(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9863,        326]
NotebookOptionsPosition[      7346,        251]
NotebookOutlinePosition[      8770,        285]
CellTagsIndexPosition[      8727,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[DownRightVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/DownRightVector"], 
          "\\[RightTeeVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightTeeVector"], 
          "\\[RightVectorBar]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightVectorBar"], 
          "\\[RightArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightArrow"], 
          "\\[LeftVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/LeftVector"], 
          "\\[RightUpVector]" :> 
          Documentation`HelpLookup["paclet:ref/character/RightUpVector"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[DownRightVector]\"\>", 
       2->"\<\"\\\\[RightTeeVector]\"\>", 3->"\<\"\\\\[RightVectorBar]\"\>", 
       4->"\<\"\\\\[RightArrow]\"\>", 5->"\<\"\\\\[LeftVector]\"\>", 
       6->"\<\"\\\\[RightUpVector]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[RightVector]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[RightVector]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->694252268],

Cell["\\[RightVector]", "CharacterName",
 CellID->9246],

Cell["Unicode: 21C0.", "Notes",
 CellID->16272],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["vec", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->7742],

Cell["\<\
Infix and overfix arrow\[Hyphen]like operator. \
\>", "Notes",
 CellID->21204],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[RightVector]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RightVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RightVector"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22562],

Cell["Used in mathematics to indicate weak convergence. ", "Notes",
 CellID->24636],

Cell[TextData[{
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "\[RightVector]"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OverVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverVector"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15441],

Cell["Used in mathematics to indicate a vector quantity. ", "Notes",
 CellID->21913],

Cell["\<\
Sometimes used in prefix form as a typographical symbol to stand for \
\[OpenCurlyDoubleQuote]see also\[CloseCurlyDoubleQuote]. \
\>", "Notes",
 CellID->8474],

Cell["Extensible character. ", "Notes",
 CellID->22713]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->743],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->29416]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->23142],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[DownRightVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DownRightVector"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightTeeVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightTeeVector"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightVectorBar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightVectorBar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[LeftVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftVector"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RightUpVector]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightUpVector"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->18466]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->389123023],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[RightVector] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 43, 39.3616682}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 21C0. Alias: Esc vec Esc. Infix and overfix arrow-like \
operator. x \\[RightVector] y is by default interpreted as RightVector[x,y]. \
Used in mathematics to indicate weak convergence. OverscriptBox[StyleBox[x, \
TI], \\[RightVector]] is by default interpreted as OverVector[x]. Used in \
mathematics to indicate a vector quantity. Sometimes used in prefix form as a \
typographical symbol to stand for 'see also'. Extensible character. ", 
    "synonyms" -> {"right vector"}, "title" -> "\\[RightVector]", "type" -> 
    "Character Name", "uri" -> "ref/character/RightVector"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2493, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3116, 86, 593, 19, 70, "CharacterImage",
 CellID->694252268],
Cell[3712, 107, 55, 1, 70, "CharacterName",
 CellID->9246],
Cell[3770, 110, 47, 1, 70, "Notes",
 CellID->16272],
Cell[3820, 113, 234, 9, 70, "Notes",
 CellID->7742],
Cell[4057, 124, 88, 3, 70, "Notes",
 CellID->21204],
Cell[4148, 129, 510, 20, 70, "Notes",
 CellID->22562],
Cell[4661, 151, 83, 1, 70, "Notes",
 CellID->24636],
Cell[4747, 154, 350, 13, 70, "Notes",
 CellID->15441],
Cell[5100, 169, 84, 1, 70, "Notes",
 CellID->21913],
Cell[5187, 172, 168, 4, 70, "Notes",
 CellID->8474],
Cell[5358, 178, 55, 1, 70, "Notes",
 CellID->22713]
}, Open  ]],
Cell[CellGroupData[{
Cell[5450, 184, 51, 1, 70, "TutorialsSection",
 CellID->743],
Cell[5504, 187, 129, 3, 70, "Tutorials",
 CellID->29416]
}, Open  ]],
Cell[CellGroupData[{
Cell[5670, 195, 50, 1, 70, "SeeAlsoSection",
 CellID->23142],
Cell[5723, 198, 1340, 38, 70, "SeeAlso",
 CellID->18466]
}, Open  ]],
Cell[CellGroupData[{
Cell[7100, 241, 58, 1, 70, "MoreAboutSection",
 CellID->389123023],
Cell[7161, 244, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7319, 249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

