(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6931,        243]
NotebookOptionsPosition[      4850,        181]
NotebookOutlinePosition[      6111,        213]
CellTagsIndexPosition[      6068,        210]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Sqrt]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Sqrt]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->530797617],

Cell["\\[Sqrt]", "CharacterName",
 CellID->20701],

Cell["Unicode: 221A.", "Notes",
 CellID->30738],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["sqrt", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->9126],

Cell["\<\
Prefix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->13382],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Sqrt]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9086],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["@", "KeyEvent"],
 ", ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["2", "KeyEvent"],
 " or \[Backslash]",
 Cell[BoxData["@"], "InlineFormula"],
 " yields a complete ",
 Cell[BoxData[
  ButtonBox["SqrtBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SqrtBox"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->8444],

Cell[TextData[{
 Cell["\\[Sqrt]", "InlineCharacterName"],
 " is equivalent when evaluated, but will not draw a line on top of the \
quantity whose square root is being taken. "
}], "Notes",
 CellID->31682]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->5025],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->11681]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->274365173],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Sqrt] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 58.1761858}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 221A. Alias: Esc sqrt Esc. Prefix operator with built-in \
evaluation rules. \\[Sqrt] x is by default interpreted as Sqrt[x]. Ctrl+@, \
Ctrl+2 or \\@ yields a complete SqrtBox object. \\[Sqrt] is equivalent when \
evaluated, but will not draw a line on top of the quantity whose square root \
is being taken. ", "synonyms" -> {"sqrt"}, "title" -> "\\[Sqrt]", "type" -> 
    "Character Name", "uri" -> "ref/character/Sqrt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1370, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1993, 61, 579, 19, 70, "CharacterImage",
 CellID->530797617],
Cell[2575, 82, 49, 1, 70, "CharacterName",
 CellID->20701],
Cell[2627, 85, 47, 1, 70, "Notes",
 CellID->30738],
Cell[2677, 88, 235, 9, 70, "Notes",
 CellID->9126],
Cell[2915, 99, 97, 3, 70, "Notes",
 CellID->13382],
Cell[3015, 104, 379, 15, 70, "Notes",
 CellID->9086],
Cell[3397, 121, 455, 17, 70, "Notes",
 CellID->8444],
Cell[3855, 140, 205, 5, 70, "Notes",
 CellID->31682]
}, Open  ]],
Cell[CellGroupData[{
Cell[4097, 150, 52, 1, 70, "TutorialsSection",
 CellID->5025],
Cell[4152, 153, 129, 3, 70, "Tutorials",
 CellID->11681]
}, Open  ]],
Cell[CellGroupData[{
Cell[4318, 161, 58, 1, 70, "MoreAboutSection",
 CellID->274365173],
Cell[4379, 164, 143, 2, 70, "MoreAbout"],
Cell[4525, 168, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[4823, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

