(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7507,        266]
NotebookOptionsPosition[      5301,        197]
NotebookOutlinePosition[      6524,        229]
CellTagsIndexPosition[      6481,        226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Del]" :> 
          Documentation`HelpLookup["paclet:ref/character/Del"], 
          "\\[EmptySquare]" :> 
          Documentation`HelpLookup["paclet:ref/character/EmptySquare"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Del]\"\>", 
       2->"\<\"\\\\[EmptySquare]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Square]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Square]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->25880676],

Cell["\\[Square]", "CharacterName",
 CellID->12387],

Cell["Unicode: F520.", "Notes",
 CellID->32315],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["sq", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32236],

Cell["Prefix operator. ", "Notes",
 CellID->3678],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Square]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Square",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Square"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3306],

Cell["\<\
Used in mathematical physics to denote the d\[CloseCurlyQuote]Alembertian \
operator. \
\>", "Notes",
 CellID->9810],

Cell["\<\
Sometimes used in number theory to indicate a quadratic residue. \
\>", "Notes",
 CellID->27879],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[EmptySquare]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySquare"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->10993]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->7399],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->24187]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17382],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Del]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Del"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[EmptySquare]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/EmptySquare"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->20643]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->3968273],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Square] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 58.4730684}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F520. Alias: Esc sq Esc. Prefix operator. [] x is by default \
interpreted as Square[x]. Used in mathematical physics to denote the \
d'Alembertian operator. Sometimes used in number theory to indicate a \
quadratic residue. Not the same as \\[EmptySquare]. ", 
    "synonyms" -> {"square"}, "title" -> "\\[Square]", "type" -> 
    "Character Name", "uri" -> "ref/character/Square"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1875, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2498, 76, 582, 19, 70, "CharacterImage",
 CellID->25880676],
Cell[3083, 97, 51, 1, 70, "CharacterName",
 CellID->12387],
Cell[3137, 100, 47, 1, 70, "Notes",
 CellID->32315],
Cell[3187, 103, 234, 9, 70, "Notes",
 CellID->32236],
Cell[3424, 114, 49, 1, 70, "Notes",
 CellID->3678],
Cell[3476, 117, 385, 15, 70, "Notes",
 CellID->3306],
Cell[3864, 134, 126, 4, 70, "Notes",
 CellID->9810],
Cell[3993, 140, 106, 3, 70, "Notes",
 CellID->27879],
Cell[4102, 145, 212, 7, 70, "Notes",
 CellID->10993]
}, Open  ]],
Cell[CellGroupData[{
Cell[4351, 157, 52, 1, 70, "TutorialsSection",
 CellID->7399],
Cell[4406, 160, 129, 3, 70, "Tutorials",
 CellID->24187]
}, Open  ]],
Cell[CellGroupData[{
Cell[4572, 168, 50, 1, 70, "SeeAlsoSection",
 CellID->17382],
Cell[4625, 171, 395, 11, 70, "SeeAlso",
 CellID->20643]
}, Open  ]],
Cell[CellGroupData[{
Cell[5057, 187, 56, 1, 70, "MoreAboutSection",
 CellID->3968273],
Cell[5116, 190, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5274, 195, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

