(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7427,        247]
NotebookOptionsPosition[      5493,        186]
NotebookOutlinePosition[      6617,        217]
CellTagsIndexPosition[      6574,        214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[SquareUnion]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareUnion"], 
          "\\[Intersection]" :> 
          Documentation`HelpLookup["paclet:ref/character/Intersection"], 
          "\\[Wedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/Wedge"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[SquareUnion]\"\>", 
       2->"\<\"\\\\[Intersection]\"\>", 
       3->"\<\"\\\\[Wedge]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[SquareIntersection]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[SquareIntersection]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->672634722],

Cell["\\[SquareIntersection]", "CharacterName",
 CellID->20622],

Cell["Unicode: 2293.", "Notes",
 CellID->1878],

Cell["Infix operator. ", "Notes",
 CellID->29639],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SquareIntersection]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SquareIntersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareIntersection"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3908]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8402],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->27853],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->16602]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->28869],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[SquareUnion]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareUnion"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Intersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Intersection"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->14474]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[SquareIntersection] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 58.3324398}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2293. Infix operator. x \\[SquareIntersection] y is by default \
interpreted as SquareIntersection[x,y]. ", 
    "synonyms" -> {"square intersection"}, "title" -> 
    "\\[SquareIntersection]", "type" -> "Character Name", "uri" -> 
    "ref/character/SquareIntersection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2197, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2820, 81, 607, 19, 70, "CharacterImage",
 CellID->672634722],
Cell[3430, 102, 63, 1, 70, "CharacterName",
 CellID->20622],
Cell[3496, 105, 46, 1, 70, "Notes",
 CellID->1878],
Cell[3545, 108, 49, 1, 70, "Notes",
 CellID->29639],
Cell[3597, 111, 530, 20, 70, "Notes",
 CellID->3908]
}, Open  ]],
Cell[CellGroupData[{
Cell[4164, 136, 52, 1, 70, "TutorialsSection",
 CellID->8402],
Cell[4219, 139, 163, 3, 70, "Tutorials",
 CellID->27853],
Cell[4385, 144, 129, 3, 70, "Tutorials",
 CellID->16602]
}, Open  ]],
Cell[CellGroupData[{
Cell[4551, 152, 38, 0, 70, "MoreAboutSection"],
Cell[4592, 154, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4772, 161, 50, 1, 70, "SeeAlsoSection",
 CellID->28869],
Cell[4825, 164, 626, 17, 70, "SeeAlso",
 CellID->14474]
}, Open  ]],
Cell[5466, 184, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

