(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7945,        263]
NotebookOptionsPosition[      5958,        202]
NotebookOutlinePosition[      7136,        233]
CellTagsIndexPosition[      7093,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[SquareIntersection]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareIntersection"],
           "\\[Union]" :> 
          Documentation`HelpLookup["paclet:ref/character/Union"], 
          "\\[UnionPlus]" :> 
          Documentation`HelpLookup["paclet:ref/character/UnionPlus"], 
          "\\[Vee]" :> Documentation`HelpLookup["paclet:ref/character/Vee"], 
          "\\[Coproduct]" :> 
          Documentation`HelpLookup["paclet:ref/character/Coproduct"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\\[SquareIntersection]\"\>", 2->"\<\"\\\\[Union]\"\>", 
       3->"\<\"\\\\[UnionPlus]\"\>", 4->"\<\"\\\\[Vee]\"\>", 
       5->"\<\"\\\\[Coproduct]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[SquareUnion]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[SquareUnion]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->193610206],

Cell["\\[SquareUnion]", "CharacterName",
 CellID->21367],

Cell["Unicode: 2294.", "Notes",
 CellID->18453],

Cell["Infix operator. ", "Notes",
 CellID->25677],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[SquareUnion]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SquareUnion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareUnion"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14301],

Cell["\<\
Used in mathematics to denote various forms of generalized union, typically \
of disjoint subspaces. \
\>", "Notes",
 CellID->16695]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->25338],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->9835]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->28911],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[SquareIntersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareIntersection"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Union]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Union"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UnionPlus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UnionPlus"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Vee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Coproduct]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Coproduct"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->31732]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[SquareUnion] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 59.2543384}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2294. Infix operator. x \\[SquareUnion] y is by default \
interpreted as SquareUnion[x,y]. Used in mathematics to denote various forms \
of generalized union, typically of disjoint subspaces. ", 
    "synonyms" -> {"square union"}, "title" -> "\\[SquareUnion]", "type" -> 
    "Character Name", "uri" -> "ref/character/SquareUnion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2282, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2905, 83, 593, 19, 70, "CharacterImage",
 CellID->193610206],
Cell[3501, 104, 56, 1, 70, "CharacterName",
 CellID->21367],
Cell[3560, 107, 47, 1, 70, "Notes",
 CellID->18453],
Cell[3610, 110, 49, 1, 70, "Notes",
 CellID->25677],
Cell[3662, 113, 510, 20, 70, "Notes",
 CellID->14301],
Cell[4175, 135, 142, 4, 70, "Notes",
 CellID->16695]
}, Open  ]],
Cell[CellGroupData[{
Cell[4354, 144, 53, 1, 70, "TutorialsSection",
 CellID->25338],
Cell[4410, 147, 128, 3, 70, "Tutorials",
 CellID->9835]
}, Open  ]],
Cell[CellGroupData[{
Cell[4575, 155, 38, 0, 70, "MoreAboutSection"],
Cell[4616, 157, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4796, 164, 50, 1, 70, "SeeAlsoSection",
 CellID->28911],
Cell[4849, 167, 1067, 30, 70, "SeeAlso",
 CellID->31732]
}, Open  ]],
Cell[5931, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

