(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9358,        316]
NotebookOptionsPosition[      6980,        243]
NotebookOutlinePosition[      8266,        275]
CellTagsIndexPosition[      8223,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Special Characters\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Times]" :> 
          Documentation`HelpLookup["paclet:ref/character/Times"], "\\[Cross]" :> 
          Documentation`HelpLookup["paclet:ref/character/Cross"], 
          "\\[FivePointedStar]" :> 
          Documentation`HelpLookup["paclet:ref/character/FivePointedStar"], 
          "\\[SixPointedStar]" :> 
          Documentation`HelpLookup["paclet:ref/character/SixPointedStar"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[Times]\"\>", 
       2->"\<\"\\\\[Cross]\"\>", 3->"\<\"\\\\[FivePointedStar]\"\>", 
       4->"\<\"\\\\[SixPointedStar]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Star]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Star]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->399869877],

Cell["\\[Star]", "CharacterName",
 CellID->15772],

Cell["Unicode: 22C6.", "Notes",
 CellID->12793],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["star", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->6058],

Cell["Infix operator. ", "Notes",
 CellID->3242],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Star]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Star",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Star"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12314],

Cell["\<\
Used to denote convolution and generalized forms of multiplication. \
\>", "Notes",
 CellID->8300],

Cell["Sometimes used in prefix form to indicate dual. ", "Notes",
 CellID->22981],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[SixPointedStar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SixPointedStar"]], 
  "InlineCharacterName"],
 ", ",
 Cell[TextData[ButtonBox["\\[RawStar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawStar"]], "InlineCharacterName"],
 " or ",
 Cell[TextData[ButtonBox["\\[Conjugate]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Conjugate"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->65],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[RawStar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawStar"]], "InlineCharacterName"],
 " is the character entered for superscripts. "
}], "Notes",
 CellID->229]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->8091],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->10953],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->14275]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->17554],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[FivePointedStar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/FivePointedStar"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SixPointedStar]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SixPointedStar"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->2671]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->13607167],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Star] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 44, 59.3793416}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22C6. Alias: Esc star Esc. Infix operator. x * y is by default \
interpreted as Star[x,y]. Used to denote convolution and generalized forms of \
multiplication. Sometimes used in prefix form to indicate dual. Not the same \
as \\[SixPointedStar], \\[RawStar] or \\[Conjugate]. \\[RawStar] is the \
character entered for superscripts. ", "synonyms" -> {"star"}, "title" -> 
    "\\[Star]", "type" -> "Character Name", "uri" -> "ref/character/Star"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2338, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2961, 83, 579, 19, 70, "CharacterImage",
 CellID->399869877],
Cell[3543, 104, 49, 1, 70, "CharacterName",
 CellID->15772],
Cell[3595, 107, 47, 1, 70, "Notes",
 CellID->12793],
Cell[3645, 110, 235, 9, 70, "Notes",
 CellID->6058],
Cell[3883, 121, 48, 1, 70, "Notes",
 CellID->3242],
Cell[3934, 124, 489, 20, 70, "Notes",
 CellID->12314],
Cell[4426, 146, 108, 3, 70, "Notes",
 CellID->8300],
Cell[4537, 151, 81, 1, 70, "Notes",
 CellID->22981],
Cell[4621, 154, 504, 16, 70, "Notes",
 CellID->65],
Cell[5128, 172, 223, 6, 70, "Notes",
 CellID->229]
}, Open  ]],
Cell[CellGroupData[{
Cell[5388, 183, 52, 1, 70, "TutorialsSection",
 CellID->8091],
Cell[5443, 186, 180, 5, 70, "Tutorials",
 CellID->10953],
Cell[5626, 193, 129, 3, 70, "Tutorials",
 CellID->14275]
}, Open  ]],
Cell[CellGroupData[{
Cell[5792, 201, 50, 1, 70, "SeeAlsoSection",
 CellID->17554],
Cell[5845, 204, 853, 24, 70, "SeeAlso",
 CellID->2671]
}, Open  ]],
Cell[CellGroupData[{
Cell[6735, 233, 57, 1, 70, "MoreAboutSection",
 CellID->13607167],
Cell[6795, 236, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6953, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

