(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8389,        277]
NotebookOptionsPosition[      6219,        210]
NotebookOutlinePosition[      7409,        241]
CellTagsIndexPosition[      7366,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[SucceedsEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/SucceedsEqual"], 
          "\\[Precedes]" :> 
          Documentation`HelpLookup["paclet:ref/character/Precedes"], 
          "\\[NotSucceeds]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotSucceeds"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[SucceedsEqual]\"\>", 
       2->"\<\"\\\\[Precedes]\"\>", 
       3->"\<\"\\\\[NotSucceeds]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Succeeds]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Succeeds]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->428881267],

Cell["\\[Succeeds]", "CharacterName",
 CellID->27348],

Cell["Unicode: 227B.", "Notes",
 CellID->31402],

Cell["Infix ordering operator. ", "Notes",
 CellID->12764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Succeeds]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Succeeds",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Succeeds"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29016],

Cell["\<\
Used in mathematics to indicate various notions of partial ordering. \
\>", "Notes",
 CellID->30748],

Cell[TextData[{
 "Often applied to functions and read \[OpenCurlyDoubleQuote]",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " dominates ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "\[CloseCurlyDoubleQuote]. "
}], "Notes",
 CellID->30421]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->22923],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->3320],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->14195]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->7876],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[SucceedsEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SucceedsEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Precedes]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Precedes"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotSucceeds]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotSucceeds"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->16016]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->32822936],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Succeeds] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 6.7857812}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 227B. Infix ordering operator. x \\[Succeeds] y is by default \
interpreted as Succeeds[x,y]. Used in mathematics to indicate various notions \
of partial ordering. Often applied to functions and read 'x dominates y'. ", 
    "synonyms" -> {"succeeds"}, "title" -> "\\[Succeeds]", "type" -> 
    "Character Name", "uri" -> "ref/character/Succeeds"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2402, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3025, 84, 587, 19, 70, "CharacterImage",
 CellID->428881267],
Cell[3615, 105, 53, 1, 70, "CharacterName",
 CellID->27348],
Cell[3671, 108, 47, 1, 70, "Notes",
 CellID->31402],
Cell[3721, 111, 58, 1, 70, "Notes",
 CellID->12764],
Cell[3782, 114, 501, 20, 70, "Notes",
 CellID->29016],
Cell[4286, 136, 110, 3, 70, "Notes",
 CellID->30748],
Cell[4399, 141, 268, 9, 70, "Notes",
 CellID->30421]
}, Open  ]],
Cell[CellGroupData[{
Cell[4704, 155, 53, 1, 70, "TutorialsSection",
 CellID->22923],
Cell[4760, 158, 162, 3, 70, "Tutorials",
 CellID->3320],
Cell[4925, 163, 129, 3, 70, "Tutorials",
 CellID->14195]
}, Open  ]],
Cell[CellGroupData[{
Cell[5091, 171, 49, 1, 70, "SeeAlsoSection",
 CellID->7876],
Cell[5143, 174, 634, 17, 70, "SeeAlso",
 CellID->16016]
}, Open  ]],
Cell[CellGroupData[{
Cell[5814, 196, 57, 1, 70, "MoreAboutSection",
 CellID->32822936],
Cell[5874, 199, 143, 2, 70, "MoreAbout"],
Cell[6020, 203, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6192, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

