(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8054,        271]
NotebookOptionsPosition[      5937,        206]
NotebookOutlinePosition[      7134,        237]
CellTagsIndexPosition[      7091,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[TildeEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/TildeEqual"], 
          "\\[Congruent]" :> 
          Documentation`HelpLookup["paclet:ref/character/Congruent"], 
          "\\[NotTildeFullEqual]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/NotTildeFullEqual"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[TildeEqual]\"\>", 
       2->"\<\"\\\\[Congruent]\"\>", 
       3->"\<\"\\\\[NotTildeFullEqual]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[TildeFullEqual]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[TildeFullEqual]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->90395328],

Cell["\\[TildeFullEqual]", "CharacterName",
 CellID->7070],

Cell["Unicode: 2245.", "Notes",
 CellID->14262],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["~==", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->16790],

Cell["Infix similarity operator. ", "Notes",
 CellID->20012],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[TildeFullEqual]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TildeFullEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TildeFullEqual"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7102],

Cell["\<\
Used in mathematics to indicate isomorphism, congruence and homotopic \
equivalence. \
\>", "Notes",
 CellID->17210]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->7584],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->22412]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20609],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[TildeEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/TildeEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Congruent]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Congruent"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotTildeFullEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotTildeFullEqual"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->2416]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->735063914],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[TildeFullEqual] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 22.3174288}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2245. Alias: Esc ~== Esc. Infix similarity operator. x ~== y is \
by default interpreted as TildeFullEqual[x,y]. Used in mathematics to \
indicate isomorphism, congruence and homotopic equivalence. ", 
    "synonyms" -> {"tilde full equal"}, "title" -> "\\[TildeFullEqual]", 
    "type" -> "Character Name", "uri" -> "ref/character/TildeFullEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2256, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2879, 83, 598, 19, 70, "CharacterImage",
 CellID->90395328],
Cell[3480, 104, 58, 1, 70, "CharacterName",
 CellID->7070],
Cell[3541, 107, 47, 1, 70, "Notes",
 CellID->14262],
Cell[3591, 110, 235, 9, 70, "Notes",
 CellID->16790],
Cell[3829, 121, 60, 1, 70, "Notes",
 CellID->20012],
Cell[3892, 124, 518, 20, 70, "Notes",
 CellID->7102],
Cell[4413, 146, 126, 4, 70, "Notes",
 CellID->17210]
}, Open  ]],
Cell[CellGroupData[{
Cell[4576, 155, 52, 1, 70, "TutorialsSection",
 CellID->7584],
Cell[4631, 158, 129, 3, 70, "Tutorials",
 CellID->22412]
}, Open  ]],
Cell[CellGroupData[{
Cell[4797, 166, 50, 1, 70, "SeeAlsoSection",
 CellID->20609],
Cell[4850, 169, 644, 18, 70, "SeeAlso",
 CellID->2416]
}, Open  ]],
Cell[CellGroupData[{
Cell[5531, 192, 58, 1, 70, "MoreAboutSection",
 CellID->735063914],
Cell[5592, 195, 143, 2, 70, "MoreAbout"],
Cell[5738, 199, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5910, 204, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

