(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8159,        273]
NotebookOptionsPosition[      5922,        204]
NotebookOutlinePosition[      7126,        235]
CellTagsIndexPosition[      7083,        232]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[TildeEqual]" :> 
          Documentation`HelpLookup["paclet:ref/character/TildeEqual"], 
          "\\[NotTildeTilde]" :> 
          Documentation`HelpLookup["paclet:ref/character/NotTildeTilde"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\\[TildeEqual]\"\>", 
       2->"\<\"\\\\[NotTildeTilde]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Relational Operators & Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/RelationalOperatorsAndCharacters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Relational Operators & Characters\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[TildeTilde]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[TildeTilde]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->383222829],

Cell["\\[TildeTilde]", "CharacterName",
 CellID->6549],

Cell["Unicode: 2248.", "Notes",
 CellID->10695],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["~~", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->32656],

Cell["Infix similarity operator. ", "Notes",
 CellID->3979],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[TildeTilde]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TildeTilde",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TildeTilde"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32331],

Cell["\<\
Used for various notions of approximate or asymptotic equality. \
\>", "Notes",
 CellID->7655],

Cell["Used in pure mathematics to indicate homeomorphism. ", "Notes",
 CellID->25516]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->11261],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->12254],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->20654]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21601],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[TildeEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/TildeEqual"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[NotTildeTilde]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotTildeTilde"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->17463]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->276451920],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[ButtonBox["Relational Operators & Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RelationalOperatorsAndCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[TildeTilde] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 22.6455622}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 2248. Alias: Esc ~~ Esc. Infix similarity operator. x ~~ y is \
by default interpreted as TildeTilde[x,y]. Used for various notions of \
approximate or asymptotic equality. Used in pure mathematics to indicate \
homeomorphism. ", "synonyms" -> {"tilde tilde"}, "title" -> "\\[TildeTilde]", 
    "type" -> "Character Name", "uri" -> "ref/character/TildeTilde"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2263, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2886, 81, 591, 19, 70, "CharacterImage",
 CellID->383222829],
Cell[3480, 102, 54, 1, 70, "CharacterName",
 CellID->6549],
Cell[3537, 105, 47, 1, 70, "Notes",
 CellID->10695],
Cell[3587, 108, 234, 9, 70, "Notes",
 CellID->32656],
Cell[3824, 119, 59, 1, 70, "Notes",
 CellID->3979],
Cell[3886, 122, 507, 20, 70, "Notes",
 CellID->32331],
Cell[4396, 144, 104, 3, 70, "Notes",
 CellID->7655],
Cell[4503, 149, 85, 1, 70, "Notes",
 CellID->25516]
}, Open  ]],
Cell[CellGroupData[{
Cell[4625, 155, 53, 1, 70, "TutorialsSection",
 CellID->11261],
Cell[4681, 158, 163, 3, 70, "Tutorials",
 CellID->12254],
Cell[4847, 163, 129, 3, 70, "Tutorials",
 CellID->20654]
}, Open  ]],
Cell[CellGroupData[{
Cell[5013, 171, 50, 1, 70, "SeeAlsoSection",
 CellID->21601],
Cell[5066, 174, 413, 11, 70, "SeeAlso",
 CellID->17463]
}, Open  ]],
Cell[CellGroupData[{
Cell[5516, 190, 58, 1, 70, "MoreAboutSection",
 CellID->276451920],
Cell[5577, 193, 143, 2, 70, "MoreAbout"],
Cell[5723, 197, 157, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5895, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

