(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10583,        354]
NotebookOptionsPosition[      8148,        279]
NotebookOutlinePosition[      9434,        312]
CellTagsIndexPosition[      9391,        309]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Star]" :> 
          Documentation`HelpLookup["paclet:ref/character/Star"], 
          "\\[CircleTimes]" :> 
          Documentation`HelpLookup["paclet:ref/character/CircleTimes"], 
          "\\[Divide]" :> 
          Documentation`HelpLookup["paclet:ref/character/Divide"], 
          "\\[Wedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/Wedge"], "\\[Cross]" :> 
          Documentation`HelpLookup["paclet:ref/character/Cross"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Star]\"\>", 
       2->"\<\"\\\\[CircleTimes]\"\>", 3->"\<\"\\\\[Divide]\"\>", 
       4->"\<\"\\\\[Wedge]\"\>", 
       5->"\<\"\\\\[Cross]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfNamedCharacters"], 
          "Mathematica Syntax Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSyntaxCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of Named Characters\"\>", 
       2->"\<\"Mathematica Syntax Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Times]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Times]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->779983029],

Cell["\\[Times]", "CharacterName",
 CellID->29126],

Cell["Unicode: 00D7.", "Notes",
 CellID->237122633],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["*", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->20180],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->9382],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Times]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", which is equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "*", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4046],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->10798],

Cell[TextData[{
 Cell["\\[Times]", "InlineCharacterName"],
 " represents ordinary multiplication, while ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 " represents vector cross product. "
}], "Notes",
 CellID->8818],

Cell[TextData[{
 Cell["\\[Times]", "InlineCharacterName"],
 " is drawn larger than ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->4785]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26950],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->6206],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->14619],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->15203]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25666],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Star]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Star"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CircleTimes]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleTimes"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Divide]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Divide"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Wedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Wedge"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->27258]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->408041547],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"],
  FontSlant->"Italic"],
 ButtonBox[" Syntax Characters",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSyntaxCharacters"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Times] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 22.8174416}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00D7. Alias: Esc * Esc. Infix operator with built-in evaluation \
rules. x x y is by default interpreted as Times[x,y], which is equivalent to \
x y or x*y. Not the same as \\[Cross]. \\[Times] represents ordinary \
multiplication, while \\[Cross] represents vector cross product. \\[Times] is \
drawn larger than \\[Cross]. ", "synonyms" -> {"times"}, "title" -> 
    "\\[Times]", "type" -> "Character Name", "uri" -> 
    "ref/character/Times"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2743, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3366, 91, 581, 19, 70, "CharacterImage",
 CellID->779983029],
Cell[3950, 112, 50, 1, 70, "CharacterName",
 CellID->29126],
Cell[4003, 115, 51, 1, 70, "Notes",
 CellID->237122633],
Cell[4057, 118, 233, 9, 70, "Notes",
 CellID->20180],
Cell[4293, 129, 95, 3, 70, "Notes",
 CellID->9382],
Cell[4391, 134, 751, 31, 70, "Notes",
 CellID->4046],
Cell[5145, 167, 200, 7, 70, "Notes",
 CellID->10798],
Cell[5348, 176, 301, 8, 70, "Notes",
 CellID->8818],
Cell[5652, 186, 248, 8, 70, "Notes",
 CellID->4785]
}, Open  ]],
Cell[CellGroupData[{
Cell[5937, 199, 53, 1, 70, "TutorialsSection",
 CellID->26950],
Cell[5993, 202, 143, 3, 70, "Tutorials",
 CellID->6206],
Cell[6139, 207, 180, 5, 70, "Tutorials",
 CellID->14619],
Cell[6322, 214, 129, 3, 70, "Tutorials",
 CellID->15203]
}, Open  ]],
Cell[CellGroupData[{
Cell[6488, 222, 50, 1, 70, "SeeAlsoSection",
 CellID->25666],
Cell[6541, 225, 1038, 29, 70, "SeeAlso",
 CellID->27258]
}, Open  ]],
Cell[CellGroupData[{
Cell[7616, 259, 58, 1, 70, "MoreAboutSection",
 CellID->408041547],
Cell[7677, 262, 143, 2, 70, "MoreAbout"],
Cell[7823, 266, 283, 8, 70, "MoreAbout"]
}, Open  ]],
Cell[8121, 277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

