(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7961,        273]
NotebookOptionsPosition[      5755,        203]
NotebookOutlinePosition[      6909,        234]
CellTagsIndexPosition[      6866,        231]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>", 
       4->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[ConjugateTranspose]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/ConjugateTranspose"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"\\\\[ConjugateTranspose]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Transpose]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Transpose]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->838833761],

Cell["\\[Transpose]", "CharacterName",
 CellID->6732],

Cell["Unicode: F3C7.", "Notes",
 CellID->27073],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["tr", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->17639],

Cell["\<\
Superscript postfix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->19670],

Cell[TextData[{
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["m", "TI"], "\[Transpose]"]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18197],

Cell[TextData[{
 "Not the same as keyboard ",
 Cell[BoxData["T"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18343]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->18352],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->4934],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->6816],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->31448]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19052],

Cell[TextData[Cell[TextData[ButtonBox["\\[ConjugateTranspose]",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ref/character/ConjugateTranspose"]], "InlineCharacterName"]], \
"SeeAlso",
 CellID->2360]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->48561714],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Transpose] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 23.1455750}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: F3C7. Alias: Esc tr Esc. Superscript postfix operator with \
built-in evaluation rules. m^\\[Transpose] is by default interpreted as \
Transpose[m]. Not the same as keyboard T. ", "synonyms" -> {"transpose"}, 
    "title" -> "\\[Transpose]", "type" -> "Character Name", "uri" -> 
    "ref/character/Transpose"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2321, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2944, 84, 589, 19, 70, "CharacterImage",
 CellID->838833761],
Cell[3536, 105, 53, 1, 70, "CharacterName",
 CellID->6732],
Cell[3592, 108, 47, 1, 70, "Notes",
 CellID->27073],
Cell[3642, 111, 234, 9, 70, "Notes",
 CellID->17639],
Cell[3879, 122, 110, 3, 70, "Notes",
 CellID->19670],
Cell[3992, 127, 347, 13, 70, "Notes",
 CellID->18197],
Cell[4342, 142, 118, 5, 70, "Notes",
 CellID->18343]
}, Open  ]],
Cell[CellGroupData[{
Cell[4497, 152, 53, 1, 70, "TutorialsSection",
 CellID->18352],
Cell[4553, 155, 143, 3, 70, "Tutorials",
 CellID->4934],
Cell[4699, 160, 179, 5, 70, "Tutorials",
 CellID->6816],
Cell[4881, 167, 173, 3, 70, "Tutorials",
 CellID->20037],
Cell[5057, 172, 129, 3, 70, "Tutorials",
 CellID->31448]
}, Open  ]],
Cell[CellGroupData[{
Cell[5223, 180, 50, 1, 70, "SeeAlsoSection",
 CellID->19052],
Cell[5276, 183, 197, 5, 70, "SeeAlso",
 CellID->2360]
}, Open  ]],
Cell[CellGroupData[{
Cell[5510, 193, 57, 1, 70, "MoreAboutSection",
 CellID->48561714],
Cell[5570, 196, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5728, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

