(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7107,        239]
NotebookOptionsPosition[      5179,        177]
NotebookOutlinePosition[      6221,        206]
CellTagsIndexPosition[      6178,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Non\[Hyphen]English Characters and Keyboards" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonEnglishCharactersAndKeyboards"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Non\[Hyphen]English Characters and Keyboards\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[UDoubleAcute]" :> 
          Documentation`HelpLookup["paclet:ref/character/UDoubleAcute"], 
          "\\[CapitalUDoubleDot]" :> 
          Documentation`HelpLookup[
           "paclet:ref/character/CapitalUDoubleDot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\\[UDoubleAcute]\"\>", 
       2->"\<\"\\\\[CapitalUDoubleDot]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[UDoubleDot]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[UDoubleDot]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->39506334],

Cell["\\[UDoubleDot]", "CharacterName",
 CellID->8983],

Cell["Unicode: 00FC.", "Notes",
 CellID->546579767],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["u\"", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->29385],

Cell["Letter. ", "Notes",
 CellID->15425],

Cell["Included in ISO Latin\[Hyphen]1. ", "Notes",
 CellID->32593]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30312],

Cell[TextData[ButtonBox["Non\[Hyphen]English Characters and Keyboards",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonEnglishCharactersAndKeyboards"]], "Tutorials",\

 CellID->13372],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->9581],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[UDoubleAcute]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UDoubleAcute"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalUDoubleDot]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalUDoubleDot"]], 
  "InlineCharacterName"]
}], "SeeAlso",
 CellID->14677]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->612437944],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[UDoubleDot] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 30.1613796}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 00FC. Alias: Esc u\" Esc. Letter. Included in ISO Latin-1. ", 
    "synonyms" -> {"u double dot"}, "title" -> "\\[UDoubleDot]", "type" -> 
    "Character Name", "uri" -> "ref/character/UDoubleDot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2246, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2869, 83, 590, 19, 70, "CharacterImage",
 CellID->39506334],
Cell[3462, 104, 54, 1, 70, "CharacterName",
 CellID->8983],
Cell[3519, 107, 51, 1, 70, "Notes",
 CellID->546579767],
Cell[3573, 110, 235, 9, 70, "Notes",
 CellID->29385],
Cell[3811, 121, 41, 1, 70, "Notes",
 CellID->15425],
Cell[3855, 124, 66, 1, 70, "Notes",
 CellID->32593]
}, Open  ]],
Cell[CellGroupData[{
Cell[3958, 130, 53, 1, 70, "TutorialsSection",
 CellID->30312],
Cell[4014, 133, 189, 4, 70, "Tutorials",
 CellID->13372],
Cell[4206, 139, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4416, 147, 49, 1, 70, "SeeAlsoSection",
 CellID->9581],
Cell[4468, 150, 428, 12, 70, "SeeAlso",
 CellID->14677]
}, Open  ]],
Cell[CellGroupData[{
Cell[4933, 167, 58, 1, 70, "MoreAboutSection",
 CellID->612437944],
Cell[4994, 170, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5152, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

