(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9343,        314]
NotebookOptionsPosition[      7122,        244]
NotebookOutlinePosition[      8290,        275]
CellTagsIndexPosition[      8247,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Formulas" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringFormulas"], 
          "Special Characters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"], 
          "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Entering Formulas\"\>", 
       2->"\<\"Special Characters\"\>", 
       3->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Intersection]" :> 
          Documentation`HelpLookup["paclet:ref/character/Intersection"], 
          "\\[SquareUnion]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareUnion"], 
          "\\[UnionPlus]" :> 
          Documentation`HelpLookup["paclet:ref/character/UnionPlus"], 
          "\\[Cup]" :> Documentation`HelpLookup["paclet:ref/character/Cup"], 
          "\\[Vee]" :> 
          Documentation`HelpLookup["paclet:ref/character/Vee"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\\[Intersection]\"\>", 
       2->"\<\"\\\\[SquareUnion]\"\>", 3->"\<\"\\\\[UnionPlus]\"\>", 
       4->"\<\"\\\\[Cup]\"\>", 5->"\<\"\\\\[Vee]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Union]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Union]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->535398252],

Cell["\\[Union]", "CharacterName",
 CellID->56],

Cell["Unicode: 22C3.", "Notes",
 CellID->17415],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["un", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->25542],

Cell["\<\
Infix operator with built\[Hyphen]in evaluation rules. \
\>", "Notes",
 CellID->12726],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Union]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13392],

Cell[TextData[{
 "The character ",
 Cell[BoxData[
  FormBox["\[Union]", TraditionalForm]], "InlineMath"],
 " is sometimes called \[OpenCurlyDoubleQuote]cup\[CloseCurlyDoubleQuote]. "
}], "Notes",
 CellID->19314],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[Cup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cup"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->131484753]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->15537],

Cell[TextData[ButtonBox["Entering Formulas",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringFormulas"]], "Tutorials",
 CellID->19123],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecialCharacters-MathematicalAndOtherNotation"]], \
"Tutorials",
 CellID->10848],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->8559]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21372],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Intersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Intersection"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SquareUnion]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareUnion"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UnionPlus]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UnionPlus"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Cup]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cup"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Vee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->27094]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->40272223],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Union] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 31.2864084}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22C3. Alias: Esc un Esc. Infix operator with built-in \
evaluation rules. x \\[Union] y is by default interpreted as Union[x,y]. The \
character \\[Union] is sometimes called 'cup'. Not the same as \\[Cup]. ", 
    "synonyms" -> {"union"}, "title" -> "\\[Union]", "type" -> 
    "Character Name", "uri" -> "ref/character/Union"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2595, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3218, 89, 581, 19, 70, "CharacterImage",
 CellID->535398252],
Cell[3802, 110, 47, 1, 70, "CharacterName",
 CellID->56],
Cell[3852, 113, 47, 1, 70, "Notes",
 CellID->17415],
Cell[3902, 116, 234, 9, 70, "Notes",
 CellID->25542],
Cell[4139, 127, 96, 3, 70, "Notes",
 CellID->12726],
Cell[4238, 132, 492, 20, 70, "Notes",
 CellID->13392],
Cell[4733, 154, 211, 6, 70, "Notes",
 CellID->19314],
Cell[4947, 162, 200, 7, 70, "Notes",
 CellID->131484753]
}, Open  ]],
Cell[CellGroupData[{
Cell[5184, 174, 53, 1, 70, "TutorialsSection",
 CellID->15537],
Cell[5240, 177, 144, 3, 70, "Tutorials",
 CellID->19123],
Cell[5387, 182, 180, 5, 70, "Tutorials",
 CellID->10848],
Cell[5570, 189, 128, 3, 70, "Tutorials",
 CellID->8559]
}, Open  ]],
Cell[CellGroupData[{
Cell[5735, 197, 50, 1, 70, "SeeAlsoSection",
 CellID->21372],
Cell[5788, 200, 1052, 29, 70, "SeeAlso",
 CellID->27094]
}, Open  ]],
Cell[CellGroupData[{
Cell[6877, 234, 57, 1, 70, "MoreAboutSection",
 CellID->40272223],
Cell[6937, 237, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7095, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

