(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11505,        361]
NotebookOptionsPosition[      9205,        290]
NotebookOutlinePosition[     10460,        322]
CellTagsIndexPosition[     10417,        319]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Other Mathematical Notation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OtherMathematicalNotation"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Other Mathematical Notation\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[Vee]" :> 
          Documentation`HelpLookup["paclet:ref/character/Vee"], "\\[UpArrow]" :> 
          Documentation`HelpLookup["paclet:ref/character/UpArrow"], 
          "\\[Intersection]" :> 
          Documentation`HelpLookup["paclet:ref/character/Intersection"], 
          "\\[SquareIntersection]" :> 
          Documentation`HelpLookup["paclet:ref/character/SquareIntersection"],
           "\\[CircleTimes]" :> 
          Documentation`HelpLookup["paclet:ref/character/CircleTimes"], 
          "\\[And]" :> Documentation`HelpLookup["paclet:ref/character/And"], 
          "\\[CapitalLambda]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalLambda"], 
          "\\[RawWedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawWedge"], 
          "\\[And]" :> Documentation`HelpLookup["paclet:ref/character/And"], 
          "\\[CapitalLambda]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalLambda"], 
          "\\[RawWedge]" :> 
          Documentation`HelpLookup["paclet:ref/character/RawWedge"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\\[Vee]\"\>", 
       2->"\<\"\\\\[UpArrow]\"\>", 3->"\<\"\\\\[Intersection]\"\>", 
       4->"\<\"\\\\[SquareIntersection]\"\>", 5->"\<\"\\\\[CircleTimes]\"\>", 
       6->"\<\"\\\\[And]\"\>", 7->"\<\"\\\\[CapitalLambda]\"\>", 
       8->"\<\"\\\\[RawWedge]\"\>", 9->"\<\"\\\\[And]\"\>", 
       10->"\<\"\\\\[CapitalLambda]\"\>", 
       11->"\<\"\\\\[RawWedge]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Wedge]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Wedge]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->84875144],

Cell["\\[Wedge]", "CharacterName",
 CellID->7548],

Cell["Unicode: 22C0.", "Notes",
 CellID->19488],

Cell[TextData[{
 "Alias: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["^", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->12679],

Cell["Infix operator. ", "Notes",
 CellID->1293],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox["\[Wedge]", TraditionalForm]], "InlineMath"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Wedge",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Wedge"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14397],

Cell["\<\
Used to mean wedge or exterior product and other generalized antisymmetric \
products. \
\>", "Notes",
 CellID->10899],

Cell["Occasionally used for generalized notions of intersection. ", "Notes",
 CellID->12368],

Cell[TextData[{
 "Not the same as ",
 Cell[TextData[ButtonBox["\\[And]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 ", ",
 Cell[TextData[ButtonBox["\\[CapitalLambda]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalLambda"]], "InlineCharacterName"],
 " or ",
 Cell[TextData[ButtonBox["\\[RawWedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawWedge"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->18314]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->3194],

Cell[TextData[ButtonBox["Other Mathematical Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OtherMathematicalNotation"]], "Tutorials",
 CellID->20990],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->26603]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->21940],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[Vee]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Vee"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[UpArrow]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/UpArrow"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Intersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Intersection"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[SquareIntersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/SquareIntersection"]], 
  "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CircleTimes]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CircleTimes"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[And]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalLambda]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalLambda"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawWedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawWedge"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[And]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/And"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[CapitalLambda]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalLambda"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[RawWedge]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RawWedge"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->6188]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->589655761],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Wedge] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 54.1776194}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 22C0. Alias: Esc ^ Esc. Infix operator. x ^ y is by default \
interpreted as Wedge[x,y]. Used to mean wedge or exterior product and other \
generalized antisymmetric products. Occasionally used for generalized notions \
of intersection. Not the same as \\[And], \\[CapitalLambda] or \\[RawWedge]. \
", "synonyms" -> {"wedge"}, "title" -> "\\[Wedge]", "type" -> 
    "Character Name", "uri" -> "ref/character/Wedge"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3243, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3866, 98, 580, 19, 70, "CharacterImage",
 CellID->84875144],
Cell[4449, 119, 49, 1, 70, "CharacterName",
 CellID->7548],
Cell[4501, 122, 47, 1, 70, "Notes",
 CellID->19488],
Cell[4551, 125, 233, 9, 70, "Notes",
 CellID->12679],
Cell[4787, 136, 48, 1, 70, "Notes",
 CellID->1293],
Cell[4838, 139, 492, 20, 70, "Notes",
 CellID->14397],
Cell[5333, 161, 128, 4, 70, "Notes",
 CellID->10899],
Cell[5464, 167, 92, 1, 70, "Notes",
 CellID->12368],
Cell[5559, 170, 492, 15, 70, "Notes",
 CellID->18314]
}, Open  ]],
Cell[CellGroupData[{
Cell[6088, 190, 52, 1, 70, "TutorialsSection",
 CellID->3194],
Cell[6143, 193, 163, 3, 70, "Tutorials",
 CellID->20990],
Cell[6309, 198, 129, 3, 70, "Tutorials",
 CellID->26603]
}, Open  ]],
Cell[CellGroupData[{
Cell[6475, 206, 50, 1, 70, "SeeAlsoSection",
 CellID->21940],
Cell[6528, 209, 2394, 66, 70, "SeeAlso",
 CellID->6188]
}, Open  ]],
Cell[CellGroupData[{
Cell[8959, 280, 58, 1, 70, "MoreAboutSection",
 CellID->589655761],
Cell[9020, 283, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[9178, 288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

