(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7472,        257]
NotebookOptionsPosition[      5521,        194]
NotebookOutlinePosition[      6588,        224]
CellTagsIndexPosition[      6545,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA CHARACTER NAME", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Entering Greek Letters" :> 
          Documentation`HelpLookup["paclet:tutorial/EnteringGreekLetters"], 
          "Letters and Letter\[Hyphen]Like Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LettersAndLetterLikeForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Entering Greek Letters\"\>", 
       2->"\<\"Letters and Letter\[Hyphen]Like Forms\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\\[CapitalZeta]" :> 
          Documentation`HelpLookup["paclet:ref/character/CapitalZeta"], 
          "\\[Xi]" :> Documentation`HelpLookup["paclet:ref/character/Xi"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\\[CapitalZeta]\"\>", 
       2->"\<\"\\\\[Xi]\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of Named Characters" :> 
          Documentation`HelpLookup[
           "paclet:guide/ListingOfNamedCharacters"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Listing of Named Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {
    TooltipBox[
     StyleBox["\<\"\[Zeta]\"\>", "TradFormChar"],
     "TraditionalForm"], 
    TooltipBox[
     StyleBox["\<\"\[Zeta]\"\>", "StandFormChar"],
     "StandardForm"]}
  },
  GridBoxBackground->{"Columns" -> {{
       GrayLevel[1]}}},
  GridBoxDividers->{"Columns" -> {
      AbsoluteThickness[2], {{
        AbsoluteThickness[1], 
        GrayLevel[0.4]}}, 
      AbsoluteThickness[2]}, "Rows" -> {{
       AbsoluteThickness[2]}}},
  GridBoxSpacings->{
   "Columns" -> {{0.4}}, "Rows" -> {{0.2}}}]], "CharacterImage",
 CellID->107231189],

Cell["\\[Zeta]", "CharacterName",
 CellID->4950],

Cell["Unicode: 03B6.", "Notes",
 CellID->10990],

Cell[TextData[{
 "Aliases: ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["z", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["zeta", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->684],

Cell["Greek letter. ", "Notes",
 CellID->15634],

Cell[TextData[{
 "Used in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12658]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->28748],

Cell[TextData[ButtonBox["Entering Greek Letters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EnteringGreekLetters"]], "Tutorials",
 CellID->3006],

Cell[TextData[ButtonBox["Letters and Letter\[Hyphen]Like Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LettersAndLetterLikeForms"]], "Tutorials",
 CellID->20037]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->16807],

Cell[TextData[{
 Cell[TextData[ButtonBox["\\[CapitalZeta]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CapitalZeta"]], "InlineCharacterName"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["\\[Xi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Xi"]], "InlineCharacterName"]
}], "SeeAlso",
 CellID->11919]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->979790832],

Cell[TextData[ButtonBox["Listing of Named Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfNamedCharacters"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\\[Zeta] - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 45, 55.3964006}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Character Name", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unicode: 03B6. Aliases: Esc z Esc, Esc zeta Esc. Greek letter. Used in \
TraditionalForm for Zeta and WeierstrassZeta. ", "synonyms" -> {"zeta"}, 
    "title" -> "\\[Zeta]", "type" -> "Character Name", "uri" -> 
    "ref/character/Zeta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2100, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2723, 79, 579, 19, 70, "CharacterImage",
 CellID->107231189],
Cell[3305, 100, 48, 1, 70, "CharacterName",
 CellID->4950],
Cell[3356, 103, 47, 1, 70, "Notes",
 CellID->10990],
Cell[3406, 106, 415, 15, 70, "Notes",
 CellID->684],
Cell[3824, 123, 47, 1, 70, "Notes",
 CellID->15634],
Cell[3874, 126, 460, 18, 70, "Notes",
 CellID->12658]
}, Open  ]],
Cell[CellGroupData[{
Cell[4371, 149, 53, 1, 70, "TutorialsSection",
 CellID->28748],
Cell[4427, 152, 152, 3, 70, "Tutorials",
 CellID->3006],
Cell[4582, 157, 173, 3, 70, "Tutorials",
 CellID->20037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4792, 165, 50, 1, 70, "SeeAlsoSection",
 CellID->16807],
Cell[4845, 168, 393, 11, 70, "SeeAlso",
 CellID->11919]
}, Open  ]],
Cell[CellGroupData[{
Cell[5275, 184, 58, 1, 70, "MoreAboutSection",
 CellID->979790832],
Cell[5336, 187, 143, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5494, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

