(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    437693,       7928]
NotebookOptionsPosition[    431077,       7714]
NotebookOutlinePosition[    432662,       7756]
CellTagsIndexPosition[    432575,       7751]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"FLV\"" :> Documentation`HelpLookup["paclet:ref/format/FLV"], 
          "\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"SWF\"" :> Documentation`HelpLookup["paclet:ref/format/SWF"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"FLV\\\"\"\>", 
       2->"\<\"\\\"GIF\\\"\"\>", 3->"\<\"\\\"PNG\\\"\"\>", 
       4->"\<\"\\\"SWF\\\"\"\>", 
       5->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Multimedia Formats" :> 
          Documentation`HelpLookup["paclet:guide/MultimediaFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"Multimedia Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "AVI ",
 StyleBox["(", "FilenameExtension"],
 ".avi",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19281],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["video/avi", "InlineCode"],
 "\nMicrosoft AVI format.\nMultimedia container format.\nCommonly used for \
archiving and exchanging video content.\nStores audio and video content in a \
format suitable for synchronous playback.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "AVI is an acronym for Audio Video Interleave.\nBinary format.\nSupports a \
variety of audio and video codecs as well as uncompressed video frames.\n\
Introduced in 1992 by Microsoft."
}], "FormatUsage",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the AVI standard."
}], "FormatNotes",
 CellID->9152],

Cell["\<\
Export generates uncompressed RGB frames, using a color resolution of 8 bits \
per channel.\
\>", "FormatNotes",
 CellID->1048729514]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", "]"}]], "InlineFormula"],
 " imports an AVI file and returns a list of raster graphics "
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " exports list of graphics or a list of arbitrary expressions, taking each \
element to be an animation frame."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->450877100],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"avi\", \"MR\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports a list of arbitrary expressions to AVI."
}], "FormatNotes",
 CellID->1838044116],

Cell[TextData[{
 "When exporting a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]]],
 ", the animation is composed from frames corresponding to rasterized images \
of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->455195517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"avi\", \"MR\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Manipulate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " exports an animated demonstration of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object to an AVI file."
}], "FormatNotes",
 CellID->1447928605],

Cell[TextData[{
 "The exported AVI video will play at the same speed and will have the same \
size as the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->195249723],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"avi\", \"MR\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["ListAnimate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListAnimate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " object as an AVI video."
}], "FormatNotes",
 CellID->4084],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "AVI",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<AVI\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<AVI\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "AVI",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "AVI",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->9166],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16893],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
    Cell[BoxData["\"\<Elements\>\""], "InlineFormula"], Cell[
     "", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<Rules\>\""], "InlineFormula"], Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<Options\>\""], "InlineFormula"], Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16074],

Cell["Data representation elements:", "FormatNotes",
 CellID->30300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<Animation\>\""], "InlineFormula"], Cell[
    "animated AVI represented as an animation object", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\"Data\"", "InlineFormula"], Cell[
    "array of raw bitmap data for each frame", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<GraphicsList\>\""], "InlineFormula"], Cell[
    "frames of an animated AVI as a list of graphics", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses ",
 Cell[BoxData["\"\<GraphicsList\>\""], "InlineFormula"],
 " for the AVI format."
}], "FormatNotes",
 CellID->9573],

Cell["Accessing individual frames:", "FormatNotes",
 CellID->243792274],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Frames\>\"", Cell[
    "list of integers used to reference individual frames", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Frames\>\"", ",", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "th frame"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->17950642],

Cell[TextData[{
 "Meta-information elements available for ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->19426],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<Background\>\""], "InlineFormula"], Cell[
    "background color shown in transparent image regions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<BitDepth\>\""], "InlineFormula"], Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\"ColorSpace\"", "InlineFormula"], 
    Cell["color encoding used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\"Duration\"", "InlineFormula"], 
    Cell["animation length in seconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<FrameCount\>\""], "InlineFormula"], Cell[
    "number of frames in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\"FrameRate\"", "InlineFormula"], 
    Cell["number of frames to be displayed per second", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[BoxData[
    "\"\<ImageSize\>\""], "InlineFormula"], Cell[
    "raster dimensions", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[
    "\"VideoEncoding\"", "InlineFormula"], Cell[
    "video codec used in the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->28510],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).avi\>\"", ",", "\"\<VideoEncoding\>\""}], "]"}]],
   "InlineFormula"],
 " gives one of the following codecs: ",
 Cell[BoxData["\"\<YUV\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<H261\>\""], "InlineFormula"],
 ",",
 Cell[BoxData[
  RowBox[{" ", "\"\<H263\>\""}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Uncompressed\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Cinepak\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MotionJPEG\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1056263857]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->10422],

Cell["General options:", "FormatNotes",
 CellID->30774],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "color of area padded around the exported animation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "pixel dimensions of the animated object", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30114],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1357247666],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FrameRate\>\"", "15", Cell[
    "number of frames to be displayed per second", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->690224028]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26122],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<FLV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/FLV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SWF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SWF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2036061149]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->176385089],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Multimedia Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MultimediaFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->324030680],

Cell["\<\
Export a list of 2D graphics generated from the evolution of a cellular \
automaton:\
\>", "ExampleText",
 CellID->1955517324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<ca.avi\>\"", ",", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ArrayPlot", "[", 
      RowBox[{
       RowBox[{"First", "[", 
        RowBox[{"CellularAutomaton", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"746", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "}"}]}], "}"}], 
            ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
              "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
               "1"}], "}"}], "}"}], ",", "0"}], "}"}], ",", "x", ",", 
          RowBox[{"-", "1"}]}], "]"}], "]"}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", "128"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}], ",", 
       RowBox[{"ColorRules", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", 
           RowBox[{"Hue", "[", 
            RowBox[{"x", "/", "400"}], "]"}]}], ",", 
          RowBox[{"0", "\[Rule]", "White"}]}], "}"}]}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "10", ",", " ", "400", ",", " ", "10"}], "}"}]}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7950],

Cell[BoxData["\<\"ca.avi\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1768709751]
}, Open  ]],

Cell["Show the Import elements available in the generated file:", \
"ExampleText",
 CellID->1289930780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ca.avi\>\"", ",", "\"\<Elements\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2103267738],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Animation\"\>", ",", "\<\"BitDepth\"\>", 
   ",", "\<\"ColorSpace\"\>", ",", "\<\"Data\"\>", ",", "\<\"Duration\"\>", 
   ",", "\<\"FrameCount\"\>", ",", "\<\"FrameRate\"\>", ",", "\<\"Frames\"\>",
    ",", "\<\"GraphicsList\"\>", ",", "\<\"ImageSize\"\>", 
   ",", "\<\"VideoEncoding\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1236143283]
}, Open  ]],

Cell["Import meta-information elements:", "ExampleText",
 CellID->1019202995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ca.avi\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "\"\<BitDepth\>\"", ",", "\"\<ColorSpace\>\"", ",", "\"\<Duration\>\"", 
      ",", "\"\<FrameCount\>\"", ",", "\"\<FrameRate\>\"", ",", 
      "\"\<ImageSize\>\"", ",", "\"\<VideoEncoding\>\""}], "}"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1477755475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8", ",", "RGBColor", ",", "2.6666800605598953`", ",", "40", ",", 
   "14.999924659729004`", ",", 
   RowBox[{"{", 
    RowBox[{"128", ",", "150"}], "}"}], ",", "\<\"Uncompressed\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1103356303]
}, Open  ]],

Cell["\<\
This gives a list of integer indices which can be used to reference \
individual frames:\
\>", "ExampleText",
 CellID->1415168493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ca.avi\>\"", ",", "\"\<Frames\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1284096433],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", "14", ",", "15",
    ",", "16", ",", "17", ",", "18", ",", "19", ",", "20", ",", "21", ",", 
   "22", ",", "23", ",", "24", ",", "25", ",", "26", ",", "27", ",", "28", 
   ",", "29", ",", "30", ",", "31", ",", "32", ",", "33", ",", "34", ",", 
   "35", ",", "36", ",", "37", ",", "38", ",", "39", ",", "40"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->588092676]
}, Open  ]],

Cell["Import frames 10 and 30:", "ExampleText",
 CellID->1355471326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ca.avi\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Frames\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "30"}], "}"}]}], "}"}]}], "]"}], "//", " ", 
  "Row"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1201193829],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJztlottJDkMRA1cJJfShrAJXAh7UVy6vT4YMGYpslik1K2emSqMgZ62RFY9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     "], {{0, 0}, {128, 150}}, {0, 255},
     ColorFunction->Automatic],
    ImageSize->{128, 150},
    PlotRange->{{0, 128}, {0, 150}}], "\[InvisibleSpace]", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztnXmTXdV19l2VT5JPke/x/ptKvamExLEZNHSr53mUujUy4+D5dcqVeAAh
RKun26NGzGQG4QRjAoQADgbMjNT7/T3rWedcmQCWieIL+Oxq3To6dw9rr7P3
Ws8a9rl//je7/s/f/NlXvvKV2/k3xj9dl6Y0pSlNaUpTmtKUpjSlKU1pSlOa
0pSmNKUpTWlKR8rOR6/ffKGcPVae/HH7Ntfc4f7H1m/K/6S8+WJ5tlV+uVre
eKG8/0Z59aly8d6ysKc8dHf58D1V4JNr7nCfb6lDTerTirZN+czlg7fKy4+V
X9xfHv9h2dpfHv5O+dV6eWa5XLynPLC7LO4rL5wv7/5Gn1xzh/t8Sx1qUp9W
tKUH+mnKH1o+eFucvO9rZWWoPPHjsj5VTt5Yzt1aXnumvPJE2T6o/545ojXP
J9fc4T7fUof/Up9WtKUH+qG3pvxB5cUL5YE95Rt/UX70l2XrQNmY0gpnVbPC
H/luOX1IAn9zpqyN65Nr7nCfb6lDTerTirb0QD/01pSrLG+9rBW7PVfuva4c
v67cH+v8/G1lY7acni/bwfkzR8uFu/TZGmtfc59vqUNN6tOKtvRAP/RGn/Tc
lE8v774muY0AWRkoW3Nlfbos92uFbx4oK4NlbaJszpbN/VrbsHRjWuufT665
w32+pQ41qU8r2tID/dAbfdIz/Tflo2WnvP9meemR8vS95fRhLVqEtti+v6wO
l+WB0hqVJH/gJgkWhAnaFvHOyuc+3OaTa+5IC++JOjepPvdpSw/0Q2/0Sc/0
zyiMxYh/4uh053L58J3yzq/Lv2+XB79RTnVJVpy8qZzaJ77xuTpSNma0pOEt
/FzqKatDYjWrnTtLfVr88J9PrrnDfb5djZrU5w5t6YF+6j7pn1EYixEZl9Gh
AUr+dMrlD8vlD8pvXxJ0QW4/ty5W/OSvxJaFrnLmsJarRc36RIoaOLwyIpZy
sT1ftubLauwIKqxN6pNr7nCfb1V5SPW5sFBSNQul/ep/IR40IzIuo0MDlEAP
VEHbl7KwwHZ2ys6l8t7r5cUHy8Wflke+J1HAQn3o2+XC7eX+62Mxj6U8Mau5
RnqwjLkAz4BwqMAyZknDTJb61qxkDp9cc4f7fEsdam5EK9rSg/eIJZKux/Rf
RmRcRocGKIEeqII2KIROUftl2RTYpE/9tDx/Vgjk6RPl5z8MVoyVx75fzt0S
K3yuLPeJUfDHgr3mP9dwtZbkp7pLa1jAZqlX354+KHnCJ9fc4X4r6tRaQ23H
ruB/qAnuq0KfxmV0aIASDwptUAidUAvNUP4lKEwHbgirTwiNXLgj8QzCQWwM
KbE+njJkfTJYMRz8nwweTusrhMZybyzmcd2ULhiReJdUmdU1d7S8x4O3vapP
K9rq5mTwfzj4P1nJrvGUbNAgMRV4CdqgUCgrthKUf6ELEvXlx8uj3xcgB4Es
9VcsGolnMRnQcT7kyYiYAyexnmAU94Hx3FnsCww5KRbZ5qItMqc1Uq3nyVy6
rbjPt7bF9Ewn1ZYeqCCjYFo9bwVGVZNQ7ttxn5qSdSPVw+1XQ2iGcuhnFl/Q
8vpz5cG7JIov3KmdvrC3LPZqsiy5+/5BaIRZM1Ot/BHxAaPp7M1iI3xAJvOJ
MOG/MOr0kdgvfWWxS2t+9QodsVbtHe7zLXX0sI6oFW3poe6N/9K/TLlpjUgr
RqcHKIGepaANCqETaqEZyqGfWXwRy9uvSq6e+HpZHtIstg9qstKP8KGnLHaL
Y+DAk7uEGNGJrMzzt8p7g7iw/NmICyuF9RAsKE06hD96XlNt/M81d7jPt9SR
1h5PUa/dVMkfeqZ/RmGstUCqjA4NUAI9UEU1KIROqIVmKKdDZsFcvljl0gfl
4vFy/O+0Js8cbXOp1oOCkQdDq7LrQ+eiDVGFLE4W3vZ8mld8yyfsohOawytW
qb8S88cSz/i/3Odb6lCT+rSqe/CI9Ez/jLIVlsJaPDVogBKP6D1VP1k6gX5m
wVwufYGk0E554ZykKJy5eE959AdSaq2Qt2AVi99WSNrlwYD64/l0tufzzw43
AxWWMcDm3DEJZNi1OpZuh5WhNv+Tb9P6VltjVvVpZfzpzuWyqPpPDo9rdGjQ
AxpPBQSFQk0johnKoZ/+mQsz+vzbyyDnt39dnl2VRL33OqnCs7doal6iCFU2
9dmjldwYCzU3HX6GQTHKfwiK9clEMrSVmp4Vh6VeR1OkeKlLeoeS9aawsJIw
2RfgZza083iipvWQZvUoq2GObYR/qVXZHdAGhZv7c3PRFvqZBXNhRsyL2THH
z2fBeAQt/OzucuJr5b6vao2xuiQx+kPIBJJn42vt2bYala5kdlig69OJi6wW
+S/CeWUgFnDIK66XKhuhNZ7AUm6HSX0apnpPUYc71LcvQr6LgbiYTkVvnCMk
fJdGV7deDyF5ROFMaIcRUX4q1D33mRHzYnZCRJ8nM1kg8+dysP/Xv5aHvyWF
dfyrMvmx9CUWJhO3YO9sxr5e6dd84ZK2eSxO+21WBlNQUwc0LliyVzoRhkhj
zpWzR9LCXYqu6Fb9h/NhK9C7RgnrmJp1K3qgH0H6A+rZusPmM+N6i8lHNBwI
qj9GnxG1xlECA0OaCzNiXsyOOTJT5susPw/Q9LV/E6hgHT74j2kKPfSt8rNv
5EwF6Q8IBC7s1lzAFbDl/B2aEZKWxfnAnvBt7tLU5GcIobE5J08+X937t+pB
oGgiUOVBLcWFPQlRpFbCpjO44r7cFAeDbxNqRVt6oB96o0+LMr5iLEbUuHtE
A02gB6qgja6gE2qhWY91NlcFM2JeNvqY6XpAKebe2cJOfOJH5VRPIg375x//
l/LIdyrX5bSI90pmaW3NB8i5NZRjLC2pv/H0GKRJNZGGFStQmHwqjdbV0Ikw
B84gjaVcblZNPrk+Zag/GbJrJE1puUl7U0zVPWvQgVz5AgBD+lYhnlsDGs2H
KRe7Rk2m04nKjJiX4wvGVMyauXdQFl16XypJkPsG6SxDEdmqc8J+S2G6boUz
kzmKcvM5IMdyJYphFMtPvrWK7eL2SOpKzx3ZLmxTOR9k1fbKwoJd/JdPrhdD
HdcuCDfxGrBO1+ObzAch39EhjevHKhQ6lIR5lM3Q+FC+FbEDyaLwUwkYRHPm
y6yZOxyADx0przyp5cEGt+9F0nVEHjDLUkAIkzp7NPWgEEtf+h5/5y9YYU8m
y3J9OuGlBPtw5akIXYDEyOUXkNU2FDLHtpvYXgXIqEl9u539KG0my9UwrVHs
NfVD/yg9QWdNM/QvV9BLW2a4mmb4oJg7HcKHP3bZKW/+R/nVRvjwb8/9uBqP
IFd1QETme+aQ1BkL6YHdEgWOmBtspPdgIuTJ3oiw9KZnzHBRNmlXLmmDHzTm
QpfqG9ifvEkc4NNmgrRMV2pVR2doSw/0Y0BrL59HYUTJq4l8BK3KlSE93itq
5dmbEf0bIUJXh3NqrZGEwVwzdzgAH+DG/7Z1wC57/7f6/PBdZXoAA5B+z21I
DWH433+j+GB3Sm1y+tPryk4bg7rlwZQMLEVr4ZO7MrZiKeRWBkWGi46FbQRz
8s6ogCXrX/CycuvxravVrQx13Jslj2M0jGjNK99sSDmoMlS2K8lk17OoFRxz
ZKbMl1kzdzgAH+AGPIEzNZeubbl8qbx4vjz0zfLzfypP/kgqD2oTOYQ9BWBg
1xsVKOQ0VenNUKwW+GLLUMWNEFNwD1iIAE8TeCY1sv9YfvSGBeTnIs6gRyKe
nnJj7IrPifDnh+FgRtGKtqJnpt3nylAGFGii6MMB0WDBYm6vRoVUB6GmrccV
zdyfSI+ZMl86Ye5eP1SGJ3AG/sAleHX5mppp7/yX4IHymqZTPZkScIIsxKOi
GTLAIU+fKI98KzBkOPxriSQUfTRZx7fAFblDu6tFG2LfkmG1bjLYNouAhV69
62HWGdWshn2hgG8gpZXBDJYJ2x9sG3reRDUZVw4nb3a3KIEee6GhUG6foba0
cTiAb5kXs2OOjCIr46jmDgdy1c2mWQeX4BUcu4blvTeEflFk526LDJADetwO
fyBU5UCICAgXD383KAy+2aMrfRq2PNibv9p1Lys1sB/Tt4vYes3r0DCGnQ5E
r+0mBwvQszKHLevioXAtKTSYLv3ajqOttUPdp3GC3dGMawxshesgQhIZ28qh
ATk3xjUj5sXsmGNGf/aHQokAkLgRxgL8gUvwCo5dw/L2K+XR74rOjZAqkplh
9div6zUJArQ3RtbKP2pjwha4sRmGKhuc/7K6xOcx1cw1HAvMYZH1SnfoEU+n
GrX/WQtyODJ54oL5ykcX2nwjbGHuCGcOqY4v7H+24t6cTktKKHQiAz2Wad47
a4FLoY3mihNFD5vhsuO/zIUZ2WG1FjEC7zX7yeHDZsAqLbZIzIBXcOwalpcf
17jsLIsFw4ON2VRSEAkCN96Tk/NQWLhHUgVIz4YsdfoBNdciae1sgPZTkfMA
kNB1dzgHBqLDw5X0GEohlm63Po3uZ7Qx1f7kjiBWXzriLDrsoGjF5qLPlQgK
K6bTqxEZl9G5hhI5ycdEmxMwrLM2Z1P4yzq7I8L6M4mHqWk9vhb7uuYJ48Il
eAXHrmH57Uvl0e+lr1JpTrtyXVlInr9NyyPtr+nYnsPpY1/uC9UQbGQKchqE
Uob4c7eH+zc8NtuH0sNppLQWys5zl04cTQ+qPdgW+PJFTEt6K1h5MNVBeo+j
/mqVl6U1sF99GtXYO7p9KL1J3IQS6LGqlYfkjkxu2QhHkGMT2ow9of5C4jFf
Zl2Dba2KXerZPlV4BceuZdlRthKLBHS9Fma79Roi1DtRPrTxZBSGIfSzWpYD
GRo8WMIjJcyflfA2oPVaE+FGGInQ5HQozfB2MimrNllJkxkx5FsFUG7P8C6S
ARy4VAWIua/Y4lRGM9eirUGCJFJ4RCU/pzUWI2rcCD6uDOXWkFa9ObWDyV6N
1IvTsTyYVz7W8cwBqzkgXBoPdzvUN7y6lubATnnnNeXSaz0PinL73oVD+jIU
K9/vSFpGznri08rOm9T2o7NNWmHv2OEjx91d5eFvptc3H2tXWRqIhX047dyN
6TT/7cRuhRhkOJm63QHyR9J1bAeIlT5t6UFQZyAyIgZzk1KNERk3fVADSZIz
Umy/J/53AK6aka083ayCzkIRg1UMYiT4MyZewbFr8gh2Litn9Zer5dH/p/QM
AwMl8rHwBttJUzbtHViBTuvT87drm+sRhMxZ2Fvxqop3eLXDhJ/dHQp0ROtQ
7p19iWat4xwltPpw5MuAxyZVRgf6MwpWC3CrjLof+TcMk2LlM6J9Qe048lg+
U8WXI1gM5dDPLKyv7VYVHrCTpErlgg9wQ+kEAfPgEryCY/Dtf5jEdek9xd2Q
dRduK48F/w2M/clqsTgSqJhKk1YO88CBsgtuDq0X4hGDBVlhR0GrsptaV9iY
SNc6F2I1nPAWR1vzCdfpx+pyvco5TGN2IsW1sxcUMan8b1vzKXA2Z9r4X2u1
p22btyoLzspCUf4bRa0Wdugp+VdvyaS7tck0lten0sRW6vVcmyd8wiXxKnQi
3Lv03mfnPzY1RiKUQAZayapTa2ZWegpUAAywb6SNrsOEZOKIweVIpGlV7iB5
RAczM7B2/tRuT0MOpUb0pKNeYfcj6ZBxfPz4V+PbifSzCa8OJZ40LOFb6jja
bncTPdCPwwru3GCsdoTWLiBnOS4PVv63cLV5CrIc59N4ry0UT0qQ6UiYe7N5
k56FNObVD9yDh5+tfPieniMEK/ozmSoJCq3abNSImaNtO3FtPFemJGpsCtvL
K1Vlltb91+dSX+pPEKWVM5SPVQ1DTWDIABHlnYs1b1+lB10dyqw2Y4/VkcyU
Wx1Kq80+Ve8FrulHZuN+9Sy4NZuLxKaE8H9/bgpog8LM0xhOe1YbdqTSVtWT
MiReq5I6LK82YsMabCimcFjcg4cffqYtwIMDfd3zt8lPb8btA4mBDSrSqT6d
q1o1+zRrZvFAOLjOhI223F9Bpki5ue9riSftf5OXsif9Elo8t4d5FZbaasgl
lveFuwLMTP8O/3Nn/S7/qUNN6tNKSHg0rSplXt2eQ5j+1mj634xXoerkrhRr
y6FSpU0cpNulGTGv5b6sYLG2Xq0B0y8gfSBFrp8X3KPJZ9sCz5+VTXHiawGe
Q0gaV0gUD6S6z3BqROW2D6TBYhNJgmKqyoAdazuCzCjh5Bl5D2Qgz+ZDFILq
ylht7TRwGue5WyNxNKI5jsJ/DP+HM8mcmtR34mjtysiYclfmltgwFOwPOCTY
M5QGcm7nscz+le7uSeMuW8VMV2o3bwDClYFK6cylQqFPuEdDOPkZyi9X1Fbp
TNOZldoaz/RLx6btp3WapdNCZHbNJ9pUvo0Bw0RbKC31Z5qNH5yFLfsUEeqJ
07lTZ9eq/Ofl/txlzolVuton819LdCDdZasj7dwSoyZ6do4of2fC1LVKMhtN
1VJ/W9S0QjVsH8jJKugzn9E0h+HWJ9OvnrmR0bnNdmMk6IGHcPIPKjof8bKO
J5z4evQ/lAI/Zc6wlA7gWcKzN91ojowgP3MdDueqXhlI89NI20e06jxnx/sE
Vmdy7ou9aXytjadPZrEnl/Gpnoybtz6B/9x3HF/x6Ng4iz3pa/IWoGf6zzUw
o3EdD63zon24zFZJ0jyQa96ri1GYo6M8K5XflftwA56YOeaSHbNwD3rgJPy8
+mSJ50+nQ3U9AJ71FKuFmwqbHpaZefpwohSf7mmNZ7KNNuCBNL7Sugk9K99F
ZcVYHBlCazeFKWeZ6UirzOSpXHKaYKT30P+JyP+0uWfjKPk/ngYR31JnNUSW
dEdvbkZ6k07ZnzkqKyGplsLQsPFigZOH+A6EydaXeHh9Mk2wrbifKUnj1Qmp
WGY1T+APXIJXxhVwz/CMm3D1aspbLytP8uQNcZBhJBxT4SJGlykzcP8VwmE0
xbjg/Z5I2JhNI/f8rWnUbFbAz8F0H0IxryzQLPBtyFt+2rlti0mburcKJoZ0
WuzOrDlm2nJW/3h4xiKTbbE7s9MdsnTbtOZuTsbyVzsNpA5qL994Hr1xyN4w
2MiW++dvTdOYOcpG2xOLaqZKlqtEHPwR8uwJp/qkuLcabgH4CVev5gDsqxfL
L06Wh7+dC0+uyEOawk/+r0QZvfF5/O/Sw8ZAimXPBdjYF1GVPZlAaKgphDOf
zLTxa3/mUuA9B9mNRpSlE6BdDyIUd6ZJh1JeGUjPKnUkeC09hjKNmev1OG1q
amUrWVOMZGKzgpJTsYrClNAhyitGh5Kl/vSX2gT2I4Ny6Dcodfqiltk+zVQW
8VyskJ70zsGTmj/wiq9Mrbch/ISr8Pb3FsDSM4vlsX/KUN32fBKm/OSb5arl
QTME8vPBOyvIMZcweHMu1zx/0Iw0SKdKRDSYsiNcafWHva91OJYYfstnBHoS
+fjk44btzek8rKHJjibGtrvMUQD7ymSSzydgEM9n8xSkUdBiLEs5lCYzJdIE
tOmJ6Ji0xnhymAsl2NyYk9Ls5tKW4cJgDD7ADXjCffhz7uaMU8h9MZ9BVfgJ
V38vEN3ZKa8+qScFVHZSqx2P9rgqMDecKn4zNtpqeJxWw3spD2e4l31K3R4Y
+RIn0iMhMbU3DqEcSGeaE5wMUzMgMpyJmgt7UzJvRKDHrgzBm/7IV3EI2GC+
ihvK4xoZm3YabB/M5ny7sLdKKx3OcI+BpdPDMmfpQKzwvSlYLKBkg4Tx5ZP1
ml1YNIu97bkLQu9PcEgPcMneeLthnSoMP7X+nxSHP6W893r5tyXleumc5u4Q
EZPa2u4KgtmMervCbG6uxd50eKaIdir4lJSOlOkVOMS8FV4KsSYNOFK5Hfpi
U0eoi2mCFhTOuCntYpCGH70stdAC5yJL0Oabki7CgOIO9+2ZdFYArZSLEnau
ehtUz/IHhtNSJ4L70hGx4nSv0Yq8SiRmnLQnqk1EBKEyKIzAJVd7K6E3K87A
H4MQYeaZCPP1iJPwE67CWzj8KeX5M+lHok9n2si7bvfmRIZW2xHPmfTPSxqE
uDhzOIGKXcEKSvYl3vPxCusmHznRsozzL6rWrTpgckwn9JQjLAoN79HcH/pW
ihfH1Jz8bFPUf8tVCrRjVRZQtFqOBBWbhPRJzxciMCdYG8qI0Re6MhlbqdqB
MeoDGktxfMybd2suYZX8q7MRaZrK+MLmTDsa7iB1zTFlUDsraT69c3D4k6VP
eewH5Z6/DiR8IAlQsC8SkpmjAyt2hS0GG51sIwXnAw6HUuCsVTkbsuD2yoRR
guutSYatAEnafbnYvK7OHsv4vr3KqzGKNbjTJDIcFkHbEzdE0sK0Prl2KNk+
TCc2WHsKelVuasfHGSX3aWxJ6dDeRP5eeOcDQEKzku52V/GjyRRH24fyeEiq
9ZnwUPWk089hGiV7R7q1rGabG2HBwVs4/ElxAUTTE/8SBs5YhjV9rsehE4g8
6RDbTKY080cdm6U15HOM0iZkmorjaZhgPDpTRX6kuRSeG1XCoSX/+TtUZ6VC
9Qq83i479GT4hP28aMugiVImE1lxx5lvsqB3qz6taHvmSGJX+qTn83dUWmC8
SisNMb49l7ry7NE0cp2ga7PLxrtjizUYtqG9MZuscA48o8MlCzGnyWljzqZw
hrdw+JNUwCuPR/ZvmIHQI1FwR+D/QMgW1A7xrFenNTecB7gr0siH2/5MRx7Z
sMpSPpby1nFwe5OcJyBUWR1vd/KA1Mqh9pGus3EijH2t85JdKZMR9YvhYpJA
CGtI7qY+3beuoSb1aaUDlbe0D4tpex5qj+VxfbIj8dv+jPtbH5n41aGMQtb+
UmaqzJZdkeg7VUVAJjI4aLVii0Dvxgk2bs9lkgAcfuXjQvPPrurRo6cc49bf
kTyhvBYGTu0cM2DzeQefrvWUDZPkxb2pfZ7daHwh8LY00Z6I3YcKdvTQHhg/
NUXGw6l+Kk44+gCdYepyX6qYzf0ZEdCWHw4Pz3Ai282Z6hU0Efc3nT6+JyNi
b6ZGOP5uz4Pj5qe6U/kqsW1PGDVBqi2OVnVennnZZrFJYpmz2JfnQUxn7eKT
wzxY58OwZikdwmH4DLc/UnhSOg0aqGMttsDSgNYVG9lG+uZ0ugcXutNshEIn
ELYilymxxHAm4tpf7XyJha702EDz/V+vbJ+hcvzvY5rTGVL0Flup3iGg1wuE
47d2OFvHUdNJ6fRzX0RknGpuP4ZjcPayKit1V6RMRJ8rw7k4HayUIbxHNFgX
tGmL5nbWGWZbHhq2GbMxX4HwA8kEG/IL3VX+UuVagXtSAZFiuhbGtV7w0iVu
f6T85yM6X8DDko+xOw0fxym8Ty2QfYBLcxnIcK3tbi+GM4fT/HFscftgO0nJ
fvtTXRWEG0vXkJeTgrPhcl/YnSlGFmV+z4O9Sc7SlIG8J9e2xFp3lfMzGEu3
NzNL7bFZm0hR7Ci5Fs/uDEbYV7lWHQC3t3klKHQcoU4t2z7YTodjdmcOt72C
qlPxQdowjo9ZO1i+1XElB+511vWA+Ay3/3t5/7cykB//54AQ/ZlKoSTYWzJt
3vFWIZyxyodZH9Gd07ZSJthMFeDojiyUg8lMLZvBPMBbO4cFOUa1RFkVMnz2
5Ukxg9L1SOBk8xqZrI5mvsH9PoIdXtkzN6enUTnYX898DCdaS5gfidTBqYSa
PtW1FKmnjCgBPppvZ7KL28eHlwcTstLqtHVKd4aHpOUPho6ea8/dvtO1sczy
sq6EY8rvncmkHcH4KfEWDsPnTylvvqjXmTL6yRsyZ8B+s+X+nNraaEYbheS7
080FDT71th4W+vpUOuqB3E4XyajcVCbO+YE6cKD3n/SnxtyYSX+pJaemPJ0n
dh1ht6vT/L94jwLcfJr/rergwPpEnibenM7UIGOz5f60ShhruT956FP58lfM
Vhm84xlzpMKFOzOssB4Oh/WJPAnoWH9uwJ6MSK6NJou8pzZnM5fjZMBjuHo1
7yPduazzfZiKNJSzdzhdfBdui/dqzoU3b1est+slfu/7e0Xu7P2wre0kZOfj
nb8lo/aOQlp61/lpmVVyLHBjd76dwHFt561ZQPlYn2WCMaqdus+fLb95Tp92
lRtbpqwbSXeNoyRpOJiMgXDrDWvczFSp8uusQRx5zEj6LZlb6NRr+2TsAWPW
mvtXIyKwN15l0C3+wCV4Zecw3IOHcBJ+wtWrSUehzhv/rjfhrI1WqQjVuzd/
cSIcqmHOs38Na6GE0Re6q+DUSDhSBtPlYpNkcy5VP/2cuF4Wir3Ezi7wuUiA
OmBPts+xsNzDzlroypxk+5blfuxKfcTnGb8L8VD7jpTgnspHHbnWC13paqPP
M9H/2WOZseBsYWdoQI/Oc10fGjNA4OZcm377qxUFG8kQ20KkCXnVMZDytG8S
Z+APXPI7SA10pdBHxU+4epXpQG//WpIqDwmO5U588G4lEtjgckQJMXgmkgPr
ExCOR/g4bSsyOZ2qbb/EqZ48pShNVLllZC0ORHAnzkr4FSgOFjz0TQGMxcAt
xrEwsD6sYVNLJyv3VRHJOFJBHePGldhT9KB+ZjNrWumLcc6REeVbviEdTdBj
wkRhT/oZnFS/Up3QtEN1tcr0WIvImtbA0YzW2RyDS/DKUtebjoHgJ1y9yvLB
2+WZpTxA4b+njuvO1oEqdWoiz3JemcbTTqQZzzQDhB47VK9A6W97JOo/mHPv
dTrABUr0HG0oQTbLiQ377LoslxP/oJ3OhV+v+vTxKmvI6biHq4TbuMm3fkEr
9WlFWy6ejVfM0aeTCTMANKhxGR0aFrs/Spu3BpRDv8GDVc/Hzrc1lilJvoZL
8Oqp4+06cJI7V/8O3mb9d3D9N/K/s/K/wT+dxT8N/u8U/m/s3w7av43/p7P+
n8b/2Vn/Z+P/76z/vzTxr47Gv0oT/+10/LfJf+hs/kNp8n86m//T5L91Ov+t
yf/sbP5nafKfO5r/XJr8/07n/zfnXzp7/qU05786ev6rNOcfO33+0aU5/9up
878uzfn3VkfPvzfvf1jr6PsfmvefrHX0/Selef9PR9//U5r3X3X6/Velef9b
R9//Vj2D5v2HHXv/Yf0Imvd/duz9n837bzv9/tvm/c+dff9z8/7zzr7/vHn/
f2ff/9/8/sV6R3//ovn9l/WO/v5LaX7/qKO/f/TR0vz+1x/997/+e2l+/65j
v38Xpfn9x87+/mNpfv+0o79/6tL8/m9ny+Xm968/H+Vy8/vvnS47l3TKG5WE
NL73uhDRt6Qt72S5B+8KRFTFO5zJJvfFYCbPWFeuVxk7rfEUGisVCHGii5Na
7Y1J3/tYpoUYesnOClHmLWZAuzLcHmV1MH2VdY6KjtscFYWZ0hY+E1n3xzQX
ZsS8mN3OtTasrn3ZUdxN/pkxHc599AeZW2LvcSb/jGf+jy0dx8KUXxF/PuDg
xWz347ljmWu3OpYAdWUooYiPUhpero5lTtq5Y+mA9ZbJ4yFV/xnzCqsw83+q
jN/0YIeuh3LoX4ukIGb0x0f4n7lc+qBcPK6UVCYo124VbTTfHB/fOphRwrWp
9LGfi9NeF+7MaHurPly8X51sTOXx4VZ1Oqzmv//rTaGEsanwNe1v9+AR6Vnh
m+p4xdpURjahxCPmc6wiknIEDWoWzOXS50nUX015+9Xy2Pfj5SdD2tSGKH7D
QCY2x5ETnWIbShtKCPDWUHnOV5lMkSIIGmLk/sj/XNibsbCUY6MZ8+K+jJHr
Y9eMp/9ZsfjJKp8kQIv08v5MnNZLA+IwjtOk18bzVD7UQvNyJJQyC+byRSyv
P6dZwBwW3qZz+3vTo6vzjPvSnWK1iPTwy08cBbOL2KngElxHqhy/rnQl1TmK
a1UoVjGIrsQtpwMsOem97o3/+hUojmauVAfAoQR67C1fjAR4JdHdKcqhn1l8
QYug6ePl0e/nC0yWavt0JL3QPlIht+dIit+t/Zk9ctqn/PoyzVIsjbedOEe0
DiLYsLLr3umX1Dl9KAPEy/15Qvn0fGawONCjJiMZLLCTf606UdsazXQsaIZy
oZ0vmuT5SPnVeubEOitVaZwzQuNaz5EfLl5Vazj5Wec/j2Ya50JXWe5tuyAy
AjKb4Q9Hf2rnAzWdxGuYulbJnzrP2V6+fC9Hb5gPYUFcuCMzjZ3rC+VfgvLq
U+WpnyoHlek8fUJvwvHSRa7KAx9+lfq8/PpUWw8ao9pdb4+BAsTDAjZ+L4Re
UHBTHMiK9zzoYGP17oLlKp/hyvxnh+Nb1Xl2Z5tAA5R4UGiDQuiEWmiG8i9H
2bmsc2cg5/deLy8+WC7+tDzyPclkFu1D35YXF6VZp3K1rpDtxp/ODDwd5+Jt
4dqAtdd0azbNZ1vHCqMfyixH4882/0fbSVOMyLiMDg1QAj1QBW1QCJ2i9pqk
Tn3+Csajzne8FLGDu8pz8XK2n/xVOX6dhIbTDxx5XJ+ozsuMxxHRoYzRbM1X
MsRHICdSdm3NZ2xFrsuRlGwKxk1kFNIJGIzCWIzIuIwODVACPVD1uTVs/zcK
C+zDd8o7v1a2Eqw4FWzR60EiEJCne2byFKTiJj3pi3DukyMsXttyREylH2k1
ajr/wa5Ln5Byn/TPKIzFiIzL6NDwZV3qV1t2yvtvlpceKU/fK1Fw/41Kxc+3
M1WSfCXOUD+wO44u7ks1UeN/C3Ylhu2JOjeltLHW8BuW6JOe6Z9RGIsRv0D2
7B+tvPtaefyHSiFYGYh4R/hnjJdWqvCWhdL2XDoiBGLnqqNzs5WoCTwj7Brx
enqjT3qm/6Z8ennrZSEQWHrvdZIVLFoFR26Llx7EyXq9wPCo5PaZCG7W19z3
KXVqUp9WtKUH+qE3+rzK459Nobx4QcLkG39RfvSX6Y5DsGA9+fWqtsUczdfr
L8Lm8gtaqaM3VITDjbb0QD/01pQ/qHzwtlYsQhtJ/sSPI0cl3kH62jPK9Ng+
qP+ywoEufHLNHe7zrd+9SX1a0ZYe6Ofq3z3blLp88FZ5+THl0iO3WdUPf0ec
ZIVfvCfOV+4rL5wv7/5Gn9K8u3Wfb6mj95TuVyva0gP9NOUzlzdfLM+2dJzk
jRfK+2/IJmXNL+wpD92d59r45Jo73Odb6lCT+rS6mvftN+X3lJ2PXr/5ggT+
kz9u3+aaO9z/2PpNaUpTmtKUpjSlKU1pSlOa0pSmNKUpTWlKU/5ky/8HFCZI
6g==
     "], {{0, 0}, {128, 150}}, {0, 255},
     ColorFunction->Automatic],
    ImageSize->{128, 150},
    PlotRange->{{0, 128}, {0, 150}}]}],
  Row[{
    Graphics[
     Raster[CompressedData["
1:eJztlottJDkMRA1cJJfShrAJXAh7UVy6vT4YMGYpslik1K2emSqMgZ62RFY9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      "], {{0, 0}, {128, 150}}, {0, 255}, ColorFunction -> Automatic], 
     ImageSize -> {128, 150}, PlotRange -> {{0, 128}, {0, 150}}], 
    Graphics[
     Raster[CompressedData["
1:eJztnXmTXdV19l2VT5JPke/x/ptKvamExLEZNHSr53mUujUy4+D5dcqVeAAh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      "], {{0, 0}, {128, 150}}, {0, 255}, ColorFunction -> Automatic], 
     ImageSize -> {128, 150}, PlotRange -> {{0, 128}, {0, 150}}]}]]], "Output",\

 CellLabel->"Out[5]=",
 CellID->1353862038]
}, Open  ]],

Cell["Import the entire AVI file as an animation object:", "ExampleText",
 CellID->900048706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ca.avi\>\"", ",", "\"\<Animation\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->893057308],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 8, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 40, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$2642$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 40, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->20.97974729537964]}
                },
                ColumnsEqual->False,
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                
                GridBoxItemSize->{
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                RowsEqual->False],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[RasterBox[CompressedData["
1:eJztkc1NQ2EQxCJRCRcKogQaoAWqoF1+znt4kLzFM8HWFymnrMd5fHl9fnm4
XC7vX5+3r8/39w8RETnk6XL8ZA/7s9ifxf4s9mexP4v9WezPYn8W+7PYf5VT
2voHXY39WezPYn8W+7PYn8X+LPZnsT+L/Vnsfwt3M7x0SKn2pHRIqfakdEip
9qR0SKn2pHRIqfakdEip9qR0SKn2pHRIqfakdEip9qR0SKn2JHPIoVWm9hVk
Ls202iBzaabVBplLM602yFyaabVB5tJMqw0yl2ZabZC5NNNqg8ylmVYbZC7N
tNogc2mm1QaZS//g6CknWjwDj9qfPWp/9qj92aP2Z4/anz1qf/ao/dmj9meP
2p89+p/7H/5mwrubIXML7mP//Gf/KGf729/+jUPsj79GbftHOdvf/vZvHHJF
f/k59mexP4v9WezPYn8W+7PYn8X+LPZnsT+L/Vk2+ie8s7YnvEZt+0c529/+
9m8cYn/8NWrbP8rZ/va3f+MQ++Pvt5z+g0snWjwDj9qfPWp/9qj92aP2Z4/a
nz1qf/ao/dmj9meP2p89av9bjiJWG2QuzbTaIHNpptUGmUszrTbIXJpptUHm
0kyrDTKXZlptkLk002qDzKWZVhtkLs202iBzaabVBqVLM62uoHRIqfakdEip
9qR0SKn2pHRIqfakdEip9qR0SKn2pHRIqfakdEip9qR0SKn2pHRIqfbkbob8
llOG/9t6t2N/Fvuz2J/F/iz2Z7E/i/1Z7M9ifxb7h3PY1ryr2J/F/iz2Z7E/
i/1Z7M9ifxb7s9ifxf4s9he5Lz4BxK2x7g==
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 2->
                GraphicsBox[RasterBox[CompressedData["
1:eJzt1sFtmzEMQGEDnST79NQRvEBWyBRdN3HPrQWBP0nRzfcgAz4Q0uNzDnm7
v/+6/7jdbr8fn4/H58/3TwAAAAAAAAAAAAAA8EL8vG2db6LRz5DFh2j0M2Tx
IRr9DFl8iEY/QxYfotHPkMWHaFSzuWY4RXgsV2Ms+p9F/7Pofxb9z6L/WfQv
olossVhDxv6fSf+1bTX6r22r0X9tW43+a9tq9F/bVrP5Yu5YIvwDY4nwD4wl
wj8wlgj/wFgi/ANjifAPjCXyQv5/X/7PUy22+ei+W+zRfbcsDf31f6YRHgs/
uu+mv/766/9a/cNXXRkLnyH3V2fUX//J9+uv/+Q++uuv///dv5rcPtXoP9BW
/zb0H2irfxv6D7SN+TdohM+EF6/UiM1ceVF//fXXX3/99Y/NIIb+Z9H/LPqf
Rf+z6H8W/c/S37//v/H+F6/UiM1ceVF//fXXX3/99Q/793Olfz/Vfz/96D9w
o/BYNfoPtNW/Df0H2urfRn//3Pur/Yesqb/++uuvv/76T+ife1XsxX2N8Fj4
0X23LA399X+mER4LP7rvpr/++uv/6v1zxa6MJcI/MJYI/8BYIvwDY4nwD4wl
wj8wlgj/wFgi38Q/8f7cU21bjf5r22r0X9tWo//athr917bV6L+2HUJ1sfDY
kB+uGv3Pov9Z9D+L/mfR/yz6T2PImkM0+hmy+BCNfoYsPkSjnyGLD9HoZ8ji
QzT6GbL4EI1+hiw+RAMAAAAAAAAAAAAAsvkCKVPRdA==
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 3->
                GraphicsBox[RasterBox[CompressedData["
1:eJzt1dFtFDEQgOGTqISWKCEN8EADVEG7SXhDCt712GPP3t736SKh1WY8/oN0
399+/nj79ng8/nz+/P78+fvvdwAAAAAAAAAAdvr1OP+wjv619K+lf66ehjvf
eTX619K/lv57tO4ebdLTNmWHm9G/lv619K/Vc82ZtjNz9P/6Ts/znrOiz/XX
fwX9S6R3y3pneJnnon8t/WvpX6uVJdQwmiI6J+XQa9K/lv619L+I6N17fnfp
WTejfy39a+m/TeuaKW1XLNl6frr8NelfS/89QhsO33fyytH5p4de5++iv/7D
S+p/PET/Uz2nL+0ZXSY6P3S7/fTXP7RMdL7+/Ye+SP+Ub5/WkOhn9cw9Nfaf
qP8w/dNr7D9R/+FThrdavUz6WTNtc5fRX//TZfT/7/v67z+9Z07Kp+SgPfX0
119//Xf2nzmRHseF9V9N/1r61xr7LvD9m3XrnROO5+i/esLxHP1XTzieo//Y
tOHTs/T0Tz9opkDuJtH39c/dJPq+/rmbRN/XP9fMVqdDop/VM/fU2H+i/sP0
T6+x/0T9U/ScmL5eT/+s+aHb7ae//qFlovP17z/0xfufbtLTLTRwcsnTfVJu
vZT++g8vqf/xEP2Hjd138xWG/z9cn/619K+l/wVF79vzu0vPuhn9a+lfS/8S
rSuH+sz0Tzn3eelfS/9a+tca7tZ6nvXO8DLPRf9a+l/ETJ9oipn5d2r+L/1r
6V9L/1qt/j1/l9acnufDO9yM/rX0r6X/NfVcf+c7r0b/WvrX0v+5tBrquYf+
tfSvpX8t/QEAAAAAAACALz4AO8ATJg==
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 4->
                GraphicsBox[RasterBox[CompressedData["
1:eJzt1d1tGzEQRWEBrsQtuQQ3kBZcRYBUK9vvK84PybnDzTlQgDysdi8/Ad73
zz8fn2+Px+Pvz7+vn3+//38SEREREREREREREdG/h/2hfeGvDX9t+O/Iozp2
nr/D/xz+2vDf2kIQj3/lniPCXxv+2vDXtkNm4L/wV75H+GvDXxv+DbsEMZU8
/gsfd+Pw14b/8tJ/by/vYN45fUHliSrDXxv+2vDXZq4NXXB559CMV9sWDm4V
/trw14Z/n8y1Of8lF0yOPCL8teGvDf+thVZd4uT809vMx5m/oHm0yvAfD94d
/uPBq0ovTJ+iwH8hr+kz+bvgj/8Tf/xF/mtbwrtwhmfbncJfG/7a8Hfmea1M
fkKP23QK4ZHxxx9/c0C3PHrdcsLivyn8teGvbeZdYN5H+DluW+InO+6MTT74
N9yGf2d/8z7mtwry+FfOCF08Hol/YkboYvyXzwhd7B9pntG8z44/qoNHFz/O
fK6JiT/++OPfxz/ES/6csPhvCn9t+GtLwPrfcaGH7nshFj/OfK6JiT/++OPf
xz/Ee/mtgjz+lTNCF49H4p+YEboY/+UzQhf7R5pn7PA5bpu/c8/Y5IN/w234
d/Y379Mhj3+3nLD4bwp/bfhrS8Cq3lCeiycPnt6w9sj4449/cebZi2d4tt0p
/LXhrw3/aOl3Sug4/pdjaHPoEblT7H7t4o//E3/8Rf7msNDF5sIa/8Qwz9Eq
w388eHf4jwfLM4fl/JdcMDnyiPDXhr82/Ou7RHh13px/aMarbQsHtwp/bfhr
w1/b/FrTf8kFlSeqDH9t+B+U+ffW/630F29GGgp/bfhrw78s/xlfve9Cr9fQ
FycHHxH+2vDXhr+2HTID/8o9R4S/Nvy14d88P4jHH95o+GvD/5RQ1Ya/Nvy1
4U9ERERERERERETuvgGousCG
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 5->
                GraphicsBox[RasterBox[CompressedData["
1:eJztlY1pHEEMRg9SSVpKCW4gLaSKtJPSHIeAMexY/iSNRnOz7zEHx65OP29A
9/3l54+Xb4/H4/fb59fb59/3VwAAAAAAAACAW/HnseLAZ+C/F/y3kNfIRWTA
fy/4b0ERcn1l+7fD9Lp3AP+94H8TuvzDf/DfC/57wf8yhv96xh/iRP9KleMv
Bf+94L8Xr+S8f2+5s8F/L/hfiSHh9ROTes7qVAfcCP57wX8L4aV9fWWcTLyr
q6e7CPz3gv8WjJFFaXa8kkqJF69SjN8H/PeC/5Vcu/IeJblRzm7GSLV4liLw
j3/l7WH+SysmNQ7D1rhadhH4F+sWgX+xbj6VnbN0T3o15i+uYq7Y+PjHP/7x
v9h/2FUeRZrY1cRUE1Hc4r8O/D+1/9hK1Pekqwcxg2t2u4f8sPjHP/7FHsQ+
84QlP0U5u/Ss4Az4zwdnwP8wRllfc49SKDzynnPhH//4tzsf/rydYScbtjcU
6Mpg5+wC/72c6l/cUdU7M7Bdt+3K5Rb/+L+zfzHYlaGCcFdzK7q6crWHf6Wi
qyv8T6/o6qrUv1IlsEi/PCvzfzkp/vGPf/wf4F/MCR+pcIV/Hfz3MtEV+793
/+Mf//jX/RsZKgh3Nbeiqyv8T6/o6gr/0yu6unJlsIMDi7To7N+Vyy3+8X9n
/9fg4c/bsf23M3Tlag//GfDfS9i/saOW7UzvXnWNs9Vc+Mc//u3OqzH6PKCc
XXpWcAb854Mz4H8YU7onxT7DrpK7t2hYpQf81w2Lf/zjP+y/GsV23r831UTw
j3+lPdeT6lQTcbkVg5MrUWxY7Mp4Gy6dnys2Pv7xf2f/YnsV5DV6L25659Xg
X6xbBP7FutXE9qTowasxeXGlsxSBf/wrb0/1f8UrISbNTqXEi1cpxu8D/nvB
/yZ4/RsZjJOJd3X1LNrfwX8v+N8EUVosZ3Wq59X+Dv57wf9uDOcynoT/SlwZ
TrV9Bf+94L8X/PdiC3G5GqZVnuAf/13gf0OM2Sf6V17dE/z3gv8WjIV8jTGe
6GF63TuA/17wvwlXIcqZm+HO4L8X/G9CTCPaZ4H/XvDfC/4BAAAAAAAATuQv
qoQ8qw==
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 6->
                GraphicsBox[RasterBox[CompressedData["
1:eJztlIltHDEMAA9IJWkpJbiBtJAqUmLacGwEMILd5SNKFFerGciAT5b4jHz8
/vbzx9u31+v1++Pn18fP5+/vAAAAALAQf16fC6rAfy34n8A/yf+vw5+kkzAE
/CdhitK1f+0oB5zx9wT/teB/MudJ7llKnMuPneke/Bz4rwX/tUhttnbt9G9G
MAt7GPivBf8l6NoDY9n03x/5SQ+B/5sQayrsf1qFq4D/WvBfS+tYnjb/nz32
v8B/LfivJdZd2P+0ClcB/7U4NfrHi37gfD7v4ZYA/7Xgv4TL3t8d/lsvShkD
L/ukh8B/LfgvQepC6jocOaBLf1BzfwnwXwv+h6DM4dhF0785vaWAzvNKxqSW
e8D/ZP+tvYTjH3akk2YEqSSlVN1/gIHS8B8A/6v7N0+2HgivQ0AlvnM/r8I8
e/jH/1b+zZPSXU9MD37/zgj+FvpLNTP68+I/UKqZsTVv3pdX+jr7/UsXW/1n
d6S8FP7xj3/dfOzhwon8/s2A0nkz43ACifA/EPwv5/9wUQrVv1prDvtvzTiw
tfAT4/9u/vMYVbMe/5xiAvi/DIj/c6681Cv6P0cwp+vwmemc3p6anSk6i++p
2d9Lagsee4Ga8Y//TqRc89mzkj27vk8le3ZdXok504bP0v6pO7kAvyv8r+v/
sKMcMCOMLSk7vudAq5OeYvCP/338n2PquQJDMrySAiqlSnr1OEPAP/539n/I
dU69D5L/mdmVYh5PiX/mT+38wT/+N/Qv5VIOmBHGlpQd33Og1UlPMfjH/4b+
/UNy2rpJAX5X+Mc//jsf4vLjTPasZM+uyyuZ9q1XMrY2FU7RWXzG/ME//jf0
P/AFnbnyUkv+JxDuBf9JqbMvBsC/52LewJdSt75LeBrntYb/5fw7a+7HWfz5
vBlQOt/6n9BPIBH+B4L/5fwfLkqhBi49o1KAc19qKrujyxrwj3/8e8w7Q4Wf
2IzT2kur/4Glmhn9efEfKNXMiP/UUs2MZl7zZOuB8DoEVOI79/MqzLOH/8n+
W4sMY3p27iue9f1z5IFN9UvDfwD8P8a/Gbnzounf2cs5oL993f/wlnvAP/53
9h9GqsG00Ro50Kzu39xfAvzfBH0I+MeIeVHKaA4us9SlwX8t+L8Jrf4vjykX
zUStFx8G/mvBfy2x7vr9Z1e4CvivBf+1nOdw0zrHufw4MNHDwH8tzJ9a8F8L
/kswx3j5/DdLXRr814L/m6B3HYhz+dEfwSzsYeC/ltaxINlw+o+lwz/+k8D/
rTD7lbSY/p0+dxN+AP+14H8JlPkc0w5N4P+24LkW/NeC/1rwDwAAAO38BVfg
K7Q=
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 7->
                GraphicsBox[RasterBox[CompressedData["
1:eJztle1tGzEQBQWkkrSUEtxAWkgVbjQFKM4/4bR8fCSXH5Jn4ADWidy3OxfS
Pz9+//r4cbvdPr/+/fn69//3OwAAAAAAAAAAwDH8vd+qP7t7fGfwvwvHPG9h
HvjfC/4BYBzzrvAvme7r6HveWvhfTDhaKFCsr25vXa+3v9PrwP9e8H8UI/f5
pcjz71n13xj8LyPxaLf639jqOeB/C/o4i+Nf/bkUef49q74/zoHgfy/OUH01
w48p948Ixf8d/y3g/xDS/wqElVPu/9b+XwL8z0P07xzY1tHm3T9mq6UZd70j
/K/3P3KWw1KXsmHK8/pwu65cjVs8fh/4x39pu6780v79yqGKaqvafzha1X9K
nAhN0WWC/zBoXJfY2yqkqcPSen+78D8jTqz3X7cTh39/++PDcf9ib7Ul/yzr
+q2l+lZ2x4Xrq3LMt4B//OM/XOB31YoQ4j/s21Va09S57wT/ZlxT52v8hw2H
syT+iNDLGvFwS3vO+8L/af6F6rBItUI3jv/SLu1/ds9CWl9BPyUR/N8LB/a5
4IxD7fg3HzpF0nsWy/CPf/wn+k9BNxyOJoqETaY4qY6QmIX/jhEOyeo7wmFK
aNX33xQx0ny6ZAH+z/E/r7JW11RwgSX8i4L476iMfydR37rjN6pzjevG1rSX
bbd5zNkD4l8P+/hxWe720I3mwzbwvwxxAFOO+eBNNS+uOv4a8I//LXHV8ddw
yQ2FOBvH09MLhl+V4vD/Pf0/ppcuBLEm/GrL/ZM4znrwP89tE6LhVyf0v7el
Z/C/Be6feW4d8D/PrQP+57nVXNJFw3rjeHp6wfCrUtyut4D/xPQO5t0qi++f
1rjq+GvA/17/lzYePy7L3R660XzYBv4Xg/8FuaKZGVexKNXR2Jr2su02jzl7
QPxfBpxdOWW0UNpol+WgGZVXZuG/NSvxRIcppVMv1ovtOmL8Ohqx6oN//Iv1
YruOOMr/IVl3+4+CbtJ/7yMjJGbhv2OExCzTf8oRdtSFcdWHvp/EnvH/Nv7F
S2kt2B0djlba5fif17OQ1lfQT0nke/p3zkt1wPRzHYaGqh3/a9rr04t//OM/
XNDUTxNiFv9h367SmqbOfSf4N+OaOp/tv9phuN7vTQhpLbIgLlxflYP/l/Bf
fQuimTDRQQjxN/btGu/28aH/38OJwL+z/fEh/qfGifW5/kWuszcc0O/QnOgu
/SfG9b2vEdWDBfHfpKuVaqt+ri/keX24XVeuxi0evw/87/Uvmgm/qm5vjQs/
iq86KpcWlGZc6dxsAP8LwP9e/w6iN/MuLY1Z9d9d2ez/JcD/FmaczXn3TzX0
8EvmGfzvxTnUp90/TsN5huaC/0MI2+6bZfb9k9jqOeB/L/g/kOr1O+/+9+u/
MfhfTPVoh378mn3r9fZ3eh34Pwrz1Itbwr9PWiNmzXwS+N8L/gHgtXAuGW6S
eeD/BDC/F/zvBf8AAAAAAAAAAK38Ayr7ZeM=
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 8->
                GraphicsBox[RasterBox[CompressedData["
1:eJztltFtHDEMRA9IJWkpJbiBtJAqXFV6ci64nwUEEkOOKHLP82ADiw2XGj1Z
RH5+/P718ePxeHw+f/88f/8/fwkhhBBCCCGEEEIIm79fj+dPd4rvi/x3cTWv
UziP/Hdh2dYpnEH+T/Kyak0b/1knwiP/vVxNImdhVYoc8l+H7xPvkKvXGcn/
HKzpwc8fzSUE+a9mrw1malXkmY/8d+HvyJ8t+BTKVeYy3wv576LujvPz50zO
XuS/C/yOR3+u31rPuZ65XcxE/ruwXPF7wf3zya38uc4nkf8u6uZD9fyJ9q/1
mGWOn+/g37qV/hsmf7Ufv4/1putE5P+kf+SO+5V4n/PzZ1fytVL+7+4/2hnP
HE2L+891w085mpBB/vHOvP81A1LJmGEmwK4OeB5/74irikr5x11FK3fdwTUz
slbulJn+1XtHOsh/3d7xDkh/PH8ueVe99RWzX/nnU1X7X+uttfjMyE3Hv63o
nzvlqLG93eQ/5z9aiWTG8Xfqv+Hr8YT8rq1K+UcS1vn30yKrRO81viOrs/+m
OollIPqV/M/xj3zrJ9yF75Ov57P5Bvy/EKSzlV/+q/37a/lfVdx0fy+5b3dl
w13J/138Ix2QPFGiZ4Fn8/9+cjmRbNHV5R/PiWRjVo+uYq0Yvd1Wfmt1P4Pf
M5fwzF+m/M/0X43y7+3Tte7d8689rXvt31P+pvvzZEKSaM4o8t/r39/FWrM+
VyTpXQWxUZFH/q9vTvr3we/mrp8z/f3dzUH+e1mdrM9W/a61mD5If/nH+0f7
IP0n+39hzQfrX9f3Z+YPn3km8j+Be93ZFeXv5b75NX96kf8u/Px+/a61mD5I
/8mnIP+97J0t1fOHn1HTkP9q8Jzrc0WS3lUQGxV55P/65ox//G7umgzIunjO
6iTVpyD/5/2vq/M9T66r/L3rvmt+6/Zdn5mbvnZGdmRl8HsysyjnCkf+z/v3
nVScMrJ6zj+yIyYnki26uvzjOZFsOf/RDv5++Ttu9fffnMmGu5L/u/j31/Kz
7QLxydTz2XDbuCX5x7NV+Pe/9Tvsvem+T+RNdRLkXJCv5H+Cf/yM8LQ4flr/
DV+PJ+R3bVXKP5Kwzj++It4/d6/xDtGaXQn3GtvbTf4Z/349s2t83dwp7623
vmL2G81Zncfv3FtvfXXGP3Jz8cy5/NHK3Fe5VZi9Ix3kv27vSIdoJW6GyZx7
3pvH3zviqqJS/nFXfiWeJ1qPnBfTme+WOy8kIYP8450r/CNpmQkQ/fF3urdn
dJUK8/I/wf/Kuq61+q5suP+9/f03Z2yvyH+v/5W6+VA9f6L9az1mmePne/p/
Ye1lfZ/rjD8zya38uc4nkf8JIJnnzB9mFzOR/wnkdo13Xp+n5exF/icQnULW
+4rKXOZ7If8T2HvH+fnz3jNnRf4ng8wQa54wHcQL+T+P7xPvkKvXWcj/fPj5
05f9HZD/XhDn1rP888j/NCyrsn0G+Z8A879WwSP/E5D5XuRfCCGEEEIIIQTI
P0j1fJw=
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 9->
                GraphicsBox[RasterBox[CompressedData["
1:eJztl4FtWzEMRAN0kq7UEbpAV+gUHSFruikKBB8SeTxS+pLs3MEFfr4p8vhE
CfX3n79+/Pz29vb25+Pf749//54fkiRJkiRJkiRJkiRJkq/3x9vHZ7eLryvx
36L/2PvPbl9fReK/Xh5z7cUamVT5l9KgxH+X+lvl+uC91C7MkvifoCz/9Q5f
W+K/Xt7/Kvn7RxvRKAXEA4j5l8sV4p9O4r9LhWsh/HnbP5d/CL/8rSX+62XS
SFFl8mcjsYHyDh4o8d8r0AV4yXz6JNm1vJM5LPapoXR9WZ602nkJS5dznizx
XybmlmAWelcxyJ+N8WyYnp/lOhL/XQJn2Qsb6Wjk/smaMTeiUO5Wif8uhS2E
hsN7xruamvyFPNgS9pkFdZPEf6OADfN+GGyB4V/L2VhqnrGZZQqHnO8lO6t3
zL9p1fQcnp0150L81/A3ATI2zDzNG+8r3tgD8i/nvNrjTTJ7mjUm/rzJW/kz
qEF1YIPcXz5zLQ9pMjt7hVkV/3P4z0pL9tJEMglB5mwSZmd5GoOcCztem1Kv
rucBJAEvwZDjxss0QDCzO+K/l/9nhlRm7ITpJRVZoGRuDZ+ZpwHQAVBksPiH
NMr8m7VmCyAtT5X0UNjZwUgvntmpJkO/3Mzv1TXXiv+t/JslvJnxXrxyDIQU
pRE/gBXZDr/7GAhvg6nYpzLLgSnCA5adf741sMorLf5Pwd8zb7oibZQ/YS9M
5GBpwArE48EQ/wP5gww4rWdmRIBq1vMUJ6DBEFTKifibThbwZ9CFnD/fD559
wD/800QxxYnHgeTGUOWBAz7YTOiToUo6GT+SphPvFDAYvRLiDyw1z3P594UK
NkaOOW+b4c8M0oi9wuAxMyD+J/Dva3moybQFkU2B5evtMTPJ2BZ/Jn9TyCua
4t9XuS4EtZgDWz7pZAtmZKEu6TnkP7714r+Xv9lgLX6umTMzTwcO8mdnKbtq
1pTWctZ6FP+vwL+pGxZtHJoBNSf9cyoDeMk0dY30dnCuxN+LXMM/FHNC+0hm
+cT7xywH7J2DN5T4HyizwTP1PnanbZfmf6/E/1aZZkJXZoNNQM1J/5zKAF4y
TV0j12yQ+HuRK/l7dZkDm70r7rh/7nDb8xH/1+afjZ/r7czM0/k3W2x6u29K
vYWMW95e2XPP3Cwq/k/EH5cIX06U2WBq+Xp7ABS5HeLP528KeUUL/JlvmVoj
Z78p2lQJgYSpBu1h/gW22QziD5iU2TK2QddMoVBevyn+ofOCpebZpJEaJPJb
8V/Avy+EY8Kt7COzxxzwD//8fDY9jzjxOJDccIxpG7wErTGFeMPl+R+38XB6
BFYHnYi/6WQBf5OtmTbkPOXse72Ef84tDViBeABT/E/m7/VC2iA3yEtllsOD
AdoEkaSfbF/MzIQVzQwFk+LfpCIrggw8XmZ5uN3kKi8g2w6/X9l2mGxm8gZI
s6pghvGQ3dnxSC+e2dkmQ7/czO/VNdeK/638zQymNxMv2UvYFBOZyjxCldlZ
EkjInAkW/5DGIH+mF94GoOTV9TyAJOAl4I8bL9MAweG41iqKPwPEq5tSygbf
C++tsLNhEmZmeBqDhEHmgo3UQPIfj1IhD2myNnjlfRH/Q/iHfJg8zRvvK97Y
A/Iv57za402S+yv+jMlD+DO1GBugQWA7/PQ5ry/LOXt7YWsMmYkS/738e4Fy
TC+FciH/Wk5mZjwze0XORirDmvkPLWGfWVA3SfxPkHmEcdhII95dUfYMzLxb
l2eh3K0S/xNk9hJuSr+QvE+8tUyMZ8P0fD75/xL/A2XyH7yIRu4fvE21nCdL
/HcJsAUvmU+fJLuWdzKHxQ6ZvaeoMvmzkdjAyKk8TeJ/jgpNTbl/7rP3XBL/
E5RqzUPh8R8sV4h/Oon/EwlcO9cA8+XL3ySLleW/3uFrS/x3aeT+We/29ST+
J8jkyb+UBiX+ewV+C4/87JUKEvO9Ev9DJOx7Jf6SJEmSJEmSJEmS9BT6C+Yv
qfA=
                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 10->
                GraphicsBox[RasterBox[CompressedData["
1:eJztlottJDkMRA1cJJfShrAJXAh7UVy6vT4YMGYpslik1K2emSqMgZ62RFY9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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 11->
                GraphicsBox[RasterBox[CompressedData["
1:eJztltGNJDcMRBdwJE7Jf/69BJzCReF02+efQZ9IFouU1N2zU4VZQLcjksUn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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 12->
                GraphicsBox[RasterBox[CompressedData["
1:eJztl41tJTcMhA2kktRwnaSEayAtpIq0q1wQwBBEcjiktD92ZuAD/PYocviR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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 13->
                GraphicsBox[RasterBox[CompressedData["
1:eJztmdHN3EYMhA3kNU2kpZTgBtJCqki7GwcGDjKHMxyupNPZ4eB3cCftksNv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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 14->
                GraphicsBox[RasterBox[CompressedData["
1:eJztl1GS3EYMQ7cqp8hnruQj+AK5Qk6R67adH5eWIEBQUmtmY6I2VWNNNwm+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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 15->
                GraphicsBox[RasterBox[CompressedData["
1:eJztl41t5UYMhA2kklSSHlLCNZAWroq0u7ngAGNNDj9ypZX0bHPwzpAl/gyH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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 16->
                GraphicsBox[RasterBox[CompressedData["
1:eJztVtuN7FYMWyCVpKWUkI/8poVUkXadGwRYnCuJFKXjx2RGxK4xa+tBUTye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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 17->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfmXVdW17zPu/RfeGPeHO8Yd7za/ZLznTbw3w5vEkdY+phPpDAQ0IYhg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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 18->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfmTVVW25yui/4WO6B8q3g/1S/9UHe91V7yOjuioilfvhdX4fKXlxCwI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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 19->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnelznNd15l01f8l8mE9x+dOkplKV2NklxZtW7hD3XSRIYt9B7AABUlwl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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 20->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnXtQ1de1xztz/+z03snMvf2jTXqn7UxrkybVxLfxiaggoIb45CnIQ0AQ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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 21->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnYdzXcd1/z2TfyHOTJLxb8aeJONMZhTbiSNFlqNIVqNIUayS2AvYGwiQ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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 22->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfdzXceV5121f8n+CVO1U+Mfdmqrxi6vLY1lruUZW5LFgEAwZxJEzo8g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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 23->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfmXlkWW5+uc+bH7p/kLpuacnjlnfpjp03Wqerp62unq6u5yqsouLS0t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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 24->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnemTncWR7h0xH+evuJ/m051Pd8IOO8bhG949Cx4wYAaxCYH27tYuJLRv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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 25->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfl3nsWV53PO/CXz3/QPc6bn5CTnZDKdHiCJF/Aq27Ita99lSa/21dKr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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 26->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnduT5MV15xWx/4Ff92nf/OaIfdnn3XCsw44NPyzWhhcssAZmBmaGmb53
V3dXV1dXV1V3V3V39XWm587McBlzkWAlgVZYYAnBYi3riCUca4UBoZB1AQS6
IGDBMLmf7/lmVY/GsgADKmb2l1Hzi1/nL/PkOeeXv5Pnljn/Zs+R/7znX33m
M5/Z5t8s/3SfilKUohSlKEUpSlGKUpSiFKUoRSlKUYpSlKIUpSi/3fLepTSz
lH7nd1NjPf345fTSK+m5F9M//DA9+Eha3Ex/+x21uXRJV+6poZ6ntKEl7elF
XyC8d6m/dFx9Ba7+/QvpCw+nPQPp934/jc+nh76aHn4snb83nb8v7ZxLh8vp
rgfSL15XS67cU0M9T2lDS9rTi75AAA7QLhVv4QOXF76n2fsH16c/uiHdPJQG
K2loVjWVVto/mgYq6bN7U3kpff8H4ipX7qmhnqe0oSXt6UVfIACHGmAW5YOU
d99NFx9MtwynoWq6bSJ9fjDdeDgNzKRj59Lqcd1MNdNt46nWSd98Oj31P3Xl
nhrqeUobWnJDL/oCAThAAyaQi/K+BenNdD0wmS7cnzrH05Fy2j+WTt+dHn8y
bd+RRmtpbjVV2qm+lrbOpNqqrtxTQz1PaUNL2tOLvkAADtCACeSi/HOFyfnG
W1pA7/liumUo7RtNzY0030mNjbR5Jt37UPrLJ9K5e9OhyXT7tCp5CsPH6rpy
Tw31PKUNLWlPr0ZA4CnQgAlk4DNK8SFcUX70crrvy+nEnWllJ43OpclmOjQV
U3pFYvzoOU1yJvDCRppopOpKWtjUn9yUmrrq0aZueEob/qQ9vegLBOAADZhA
Bj6jMBYjFqVXHv2GZPV1t6TPD4iTqDEHJ9PUQjp6hyQ5E3hxK2b+VJpF8nQk
8NvH0uyy+M+Ve2qo5yltaEl7etEXCMABGjCBDHyNMqgRi+LynefT8Fz63O1p
eiENz0piIDqGKqm6nNZPSaSX6mm8LmG+d1RXZjVif+P0Lv+5p4b6Xhva04u+
QAAO0IAJZOAzCmMxIuP+/1leeVVy+P++rfs33kw7F9If35RuOiK5wW+sJo7B
wNZRiQt0y7UTmsxwVeJlU0/n19Lyzi7/uaeGep7Shpa0pxd9gQAcoPEUyB6C
sRiRcRmdAibgA1bXfPn56+nJb4sVI7V075fSI4+lO+/XLEV7HK+lqcW0tJ2m
F9NETF2mdDtewdm/kIQZrop1zGcaINJ51JP/3FNDPU9pQ0va04u+PKqFXgTM
6YDPKOMxIpWMDg5gMhIvHdzA8Norb76VXvtpeu1n6dFvimPX3Zw+u09cQjnf
M5gOlrQyzixJMqBJaravp9qKrrOhZ670RH1bwpzG5ZaESW/+c08N9TyljSvp
RV/+7EEDMjWMwlg0Ztw9YSCACfiAFR3BEDzBFpyvmfKtb0tEXLgvrZ3UPIR8
rCRkBQvl4Izm4di8RATXanAY7tGANZRZzexFh5kIec5U159RA5Ae/7mnhnqe
6qOoq/1cNAYCcIBGMyADvzcW4zI6OIAJDQBCLzAET7AF52ugPPfd9NQzMkhv
OCh6LdLr66lzQoYS8xaZMD4vjolp8+LY0GwaKItd/Frb4gyq40BFV1gKBH4s
pjCqx3/uqfEj2vTa0xcIBgVMIAN/ojsc4zI6OIAJ+ICVFwvwBFtwBnPwv6rL
A1/RpGqsab5VWmIOArm8KPG7uKmZyVRklWTuzbQkmREaCHDUxQPj4u3Zi+nk
XWn5WNo+K05WltV4pKpZrT9D1PTuqedpJd4a7elFXyDQBmgHwwQGPqMwFiPS
mNHBAUzAB6za8frAE2zBGczB/yot772XXn413fcl8WEnDCj0DWYXWjoSeP+o
pMHInFQRJiEcQzLzW1jXFXXRPp/N02n9tBw7ZinTmL4HSlLyt4LDMIor99RQ
Px2yyy+LXvQFgn1BwOzB59eKhZ7RR2LVAB+tPh1hCJ7C9pwggz9UQMtVV555
VnKVVY+vW2w8JS2dmQaZrJWzLU0zVA4EBayDFdMxIZmE9Zh4tmSZ1VxR7JHS
qC50sasH7f2OeyUiEClcuafGTiHa0FIrS2UXAtCAyVPgMwpjMSLjDoSVUQl8
wArcwHAjsAVnMG+GZQ0tV1f55RuSvX94g2iciMXO6914MJYfwpmZdvyCeML8
ZOlEOCCQeeTFET7ABJ5unJJuPxGCYrKR5RXr5rHzmqjMXq7cU2N5Qhta0n4+
+gIBOEDzsiv48xqLERmXp8fjqwQfIzZez/oAP4CAP1RACxRdReWln0jxu/6A
ZpfoClou/5VCpKyf1PzcP5ZKjdRck33kp+OxOKLJwEnWRGbywQkxAfmA3ugX
VA+D69CUrvW1zF6e0oaWtKcXfYEAnHEzP36MwliMyLiMDg5gAj5XYDgRkwHg
UAEtUPTpL++8kx5/SoYPAoHV8M8HZO/PxMd+xa8cyh7Sg4l3ZEbRq/JlT2XD
TkuAS59clmOTlmjvk+HhLwdAGC7zYUjXsfkMk6e0oSXt6UVfIAAHaMDcHX1R
Ix6JxrScqGeYV/zAHPyhAlqgCLqgDho/nQUr/tFvyNN702HJVaYZakZzUypH
M3ySS1ta0az2ZGaGf5IaHtkz0Ij1EZ2Q2QsDaxhWbfFKTqFT6cCEJnxrKzdD
+Owd1ZV7aqjnKW1oSXu907YgAAdo1LiZf0uh9jC6NVXwsSIEhkYGnIX5pqiA
FppBF9RBoz0nn5Ly9jvpu99Lf/ecEPvTWxXvm+zaRJDD4sXkGZ3PVhVM4MYK
D6qIhcbSplZM2ldiUWZyos9TA9Os2AOBp+1jUtprIV5sqSFYmMNcbVVRz1Pa
0HIm1FSbCcABGjdA9hA8pYZxLcrAxOoQuNmslpU9LwjgDxW29aAL6qARSqEX
qt/+FHwLP3wpnb5HkwQ+3Dyc9o1IluoXiyzEcsM0gy40QEQuxj6aBgLZthJ6
izUQ5EMpfgheqEalZD7DNCwj1Tc1JwHoz2ekJnMJmNRrYq+rxhN4MloaAfoC
AThAk2tuvjtEI2tfjG6bDnzACtzAcCg+FupL0WyymRHgB3XQCKXQC9XQ3sdy
6ZIU4//1v6WwQZqZg14B8v7xvaOZoGCwDponA+E65htH6iJaJYhOabJZOex1
ZL0bj7V4JnRCPn/aIBakKK5k7XT5Mv8/99YwZ8N6ouVU9JKrpxULek0wL0eM
StowOjiACfgABNzA0O8anI+HZnU5YlDnVwy9UA3tcOC3nFnBAvSzX6Sn/0bh
vC98JSb2rLQIOIDWjdhcPpo/W/iA/oxR2QhRA6NQxRUu2RYhVnu2z6jZbDvP
3sWN3BdQzDTqtUCXxavVUGYYDmnDOsuN9MxGrqSm2s6VtKQ9vSbDZQccRWRC
GALfXxD1jMvoVoTAp729i+FY6Khg3uyuFPSFLqgDFINC71CEKuAAfIAb8OS3
szS/9rP04vdlGIL2nsF03d5067imCiSgZjBtsFxQ8BYiRAt11DBVxmIGUjNW
y1a/jVnkMFJCa+KaaIRkaswEe+GQzOOhvspF1tIPg4vlEibPhs+BK/fUUO8G
tJwIDdbuI4MCJpDbMTcasRAzrtzdsTDZEyLVdEMAuQFnMJdivBG0rIkuaqAR
SqEXqqEdDsAHuAFP4MwnXX7xulI+nvjrdPEhyUl5YBqaHqcvigS5X5iEq6Kd
CckjRU9Opp3z2Q+JRSn3TkmrJPITKlj1lNKwEqteM5vMdOTPynJO5imHKsiU
g0U21uAq05JKjCwtpuHhtElFG1rOhCntlKFK8F+cDGN2KkQWIzIuo4MDmIAP
WDXCWrffFZy1ZC+po8DOiy7qqaGB6N2MBaItPsANeAJnfvFJhg/+8d30xNNa
7LArZ8IIRSVmCmH1aNJuihwUEjuNoU7WK3PmuJ4Ox6J29xe0FEqkh/w8d5/o
YlGjphS2J3NSrptw0Y/M5bXPpiiGFSsmUuVwhBcZjjmvFfaE7qmRSl8Oc6yT
jW7rACMRXABmK741hSYbGpFxGR0c9HnOqwbcwFBhylCZwJxHUOFgEHRBHTQu
bO5SDQfgA/Bla6+LP//4CSRXvPuu0swe/ro+zH//J7J6SmE9Mf3kRZnRF8qM
kllUyxETljPwZxbZpakwbjM7zaSFhirIPHRYyksbHVEdtV6s5QyH7NUPfvLt
d05m1V1D7Ih7GEdc5dNey3o7bfhzIjRVRwqcHQFMILcjKGMlwYG22fjKpgIH
u/LAc7SWnaXC/3jQEh3H4pMB5kIE96EdDsAHuAFP4AwN4BK8+nhTXF7/ZTp+
Jh0YlnXz7/4o3Xi7vsGhquJKfH3S4bezBeq5yo0iTREoXD0R8fEVVTIbmWZc
kdKn7hKLhkPHXohll46HSuql4PuKUheakXPClz4fcTFGQT6cvag2zGFm4+cO
61oK25Z6nkrVP6H2iwEWCMCpBp60Af5EfXdERgcHMJlp7eIGnmALzmDusKYc
d0v5m7KlzChQDUxxoCpuwBM4A3/gEryCYx9jefOt1N5MN+zXV4wNiEXDzaHI
BuGjhkaI5etzCMlqs2N/2J5Mua0zmiQLwUYI70Q8/e4vpi8+ovlGS0HYyOLL
Lgs+57WY7c0wjtbCSzMTnLG7zC9l70hmtR16tYiL9do3w9Tl3gITyBYgi/Fe
lEF3VjiASTOwArf5+PTAFpzBHPxnu27VUiMH7+pBrxGbjeQiuAFP9oVTHS7B
q483fImK+8BX9IotYB28sHLOxz4XCy4r4Mk7FblzqAXC0dNuGRFK0FVe2lVH
10/ltDRm7M65kBLhpbFMoCVssYoo+bOSJgPCdthQctpEmNihXto7KEwN9Tyl
jVpu6E93t3ILTE9dSb9mHpTRwcGJdmDVUzhpCQTAgj9UeB1XrGFHNEIp9NId
2m1iOITk5QkuwauP0Sj46c+VGODwRy2kNPoes0UOyYhlGH+M/U4oHmNzmid8
8mhoe4alttkhLOkUymfPC60IbEW/8Ya+XPk8Ywi/CAhkyili2F1Mae9QL8Ic
SmcWxQ2u3FPjoLAWmu6SXQsIwDHb7c1jFI3VyEMrNaLrebYKalEDzmAO/lBR
DaNvLNbxzsmcSgTVJh8+dEIf5p4hHACCY/Dto5eXX01fejQi1ytKrQSlmQgj
5pfekoS0oo6pmFnUyhk4M23JBwtwFjg5apZ/5Ucbf031cAjLQXdUZKKxIH5P
XMixxUaEYP78iFhBm3ln27pjJ97Icui9sQTThpa0p5fjksABGjCBDHzaMFZ9
Lc9Y4/ArvxVh6+UD/GfaOfsIuvxyodRmBcB7fDBP4A9cEoQF8e3lj5xTpMzA
gXTrmIB7zSp1gyBToUY6M1DB7h1NQoc8aMMMgVIWOH7zoREtbGbb1roNRDnm
JdViXboElWgawFF2RJhvVPLho4Sge0vMLqqy0sqRAhjYWMuLDjXU85Q2tKS9
jI6WINiAAiaQl0MZo7Ie6o1jYXbP9nBbCJ8tOBv5pbCv/cqgrhGfvzJUI8tx
LFyLDv2UGnllh1dwDL599CzHrz+hyDXv3QFux4/GItgnW2YhywraHJ7WHOPV
gzA3WIW0RDdAPeYR+IyHQBgLUHLzbgtthDOTE6nraAhL3uqJ7KucChphLzOK
Gi0r7WyOOb2wx38nKGaDK3yhtKcXj4AAHPtUgQx8R3wYURmMYU+ByXLUj4We
DyiwBWcwB3+ooD0ULUUohxseQW9eShbEB/Wdy/E7pwfAMdrAvY9YXv2pNIS5
1e7nFllStrBqgcx4TWjfdCQnx1ZjySuHL7ccE5U2yNs/OyiEmYRa2iLG6sWR
VQ/aq6vqiym6eSo8b6FPNjeyyxoBsnlWk4o/35f/cn231J5ediY3N3JMB8jA
ZxThGW5ARjca4ANW5UhMojHYgrNEVk1UiJZQ+6srOcUXerWWBXW1bqKRM7ss
kOEYfIN7H7187RuhE0aEuhxefflbTsYr6IgDzAdsT/5sdV1tTs7nI+WGynVr
kpsxCUMIQEs9Esg1VeYiwlXJ3jMvndK613MKOlw6czG7iwH4G/jPUzu0aW/e
Kii/nk0tS0t7whlxNL7iamBCS4s+MGyGeFRcMhxuk828xcBOuVYkNEIvVDN6
LZZ107UYb7AcPig49rWPLHzefkf5kN/4H/qalP5az6bTbOTH8l0fPy98rO00
N/KKwJ/NIHlwJq9ETt337OXGUujoOWkvU/E18ZnfOpb9RQ6/ev7ba8dA/Im9
ydoqL9M/z//FWH8HQsmfamZPWp7/9ayDMQpjDYWUYHRwABNLHu8dsLOOG2sd
gwENivwGqdSSHRqRUgjOa6Dxev7uJiOODK/gGHyDe//iGA0a7HMvagV5+hl5
RWRuxzyfiQXrxsPaVKVs5HZ8gzEHULm1RsxrMjj93o4aVBHw8UYJudNDLUQ5
ke2woitf9MFwEU82sudfbpZuzrN9ZftHcxbKb+C/M09oaZ+ec6EXuvwH8mR4
Cw/GVoLe6Iq/N4SVA5TVGK6xkd1K3oAARRMREYNGf/ta7GIRhA9wQ/rekvgD
l+gCx+Ab3IOH/wJb4CevpUceFxoDFVkuxy7kJJAj4X5EtbBrfTk+OmnCETCq
xhzgu56LuVSLSAfacju8VTSAP8fOqXIwfKf6RUAQpsEoJMb2HWpmMx+w+rJW
c3oz6sSf3hYu1tav538lxCNtaJkTpMN2aG5kxwiQgc8ojMWIHtpoDEZ2FriB
oV73nHDejJ1lULEQ4lRJwhE1k/AM/V/x4p0cpIAn8sDP5NQXOAbfBsK+gJPw
84OX9y5pL/P1B9N//K9ycFnprcbiyxLvNONK6C32jZy+W4RAAujVYsmjC1cQ
aIe+Bz7j3Slajtxj9Dq/qcFZTSoIUfbmtmBCy8FSxAg29e2PhJeJP2+flIE/
HY5lpCuY9PjPPTXlSOKiDS2la62oLxAWYxoDE8jAZxTGWozANKObq+CjtOql
/HGNBw8VggmPXI8iqJsJSqEXqu3jAmalm5htrKrtbArBPXgIJ+HnB9wGTrO/
/htNj//wJ+k/3RgGSCsH7A6X88p+eCq0nVbeE6T5EyE85hWEMLq8yqMhfDay
Vg+jnPxwW8hn7W0JlfLGsJUsUYciOskMdEZKM8yu/RN5TZlb3U2f2Ay3MIK3
Edf6WrayncAw1zWZ909k4M42AbLyeyt5teIRo9MMTJSJN5OzUnvYerWCCtES
EX+oOxJ5vNBb6e51mg0rA55YSzxczuFU+Ab34CGcpBlc/SCv4O230/1fFvwb
Dmmfznh8v6gTfHQHSmlhS1q0LUHwH4nZi0YBeojB20oSsN4fOhVxw7H5bJJz
7RzP+R7N8KppJY3g7EKsDqybyi05Kp9MLVa36bAO7B/mJ+/98UjK2pSgAKDV
RbkrV1WzGFvwOhEycxdFvtqCMxGfA5CBzyi3xuaLhZBv4LC4lVFyPgwQejiD
v6Kfzby/FeqgEUoVjumI9pHZ7MRQ3O2E+AOXAHIm3EpwDx7CSfgJV9/+AIkr
r/8y/bf/HptqO9nmZRpgcdfWlMLNoCxY9n4gSB3aO3OPJoxTDfkYaczkYUIy
MUDGdtl4WE9MoZ5+MhKmDUZN50QOSDkji0fbZ+PrqEm6bkbWKD9EgVMQe8mB
/Cm2b+2mODr5sH0sd6Gv/IE1QQOmPNuzeWsAIyr+uCUcwKSnX1VjOVBl2Fng
PxteBSiCLmUaRFIi9EK1yYcP9oCZM3CpFokH/nwkPTriJ1x9X6f08y9KGUM9
q4atMdDdv+nkHL5caHRGgY1xJ611Tmb3IHMMMr2AiqXLlyVZbaW1bja+wyL2
QBq44wVOAYU6/myEOgFFSxHHXzmuwCtTceWYmGlPmoOMduNQQz1PaaMwdAQo
6QuEmYAGTCA7+dP+fNtKc6u7+HjHwVps/eilZs0t54j8XFBXW8kOXqh2Kp1d
Ls7W4NFQJacY2XgZqGRmwlV4C4d/Q8Fkw7L7/KBMOVYTFpGjd2hl3zqbfVlM
p5mY1SOxhrLq2dWslWgppwRYDSvVc0ir3sk+Cl2XpFfIxlySmVMJOaYPISKP
UMc9CyWQIRwGnrxLDKyGQm73+6m70vn7Y73eVpv9Y+H531YN9Tx1AGIhvGr0
BQJwaDMckIHPKI5CKjHMXqNN4QNW4MZND9t6JwfLSvWseDvZY7o7WyphZwFZ
Nn5JnIE/9hnCMfgG97QQz4mfcBXewuFfW9BRf/jjENGr+rK0ba2TSZNWdjT7
WkHe5gwfnfdETy/lnG3m2OFQfW3RT4UCD5zFrazSKGiyJQms1WpaN0zCudhJ
yhQ6caee7h/XFEKATEea3IkLImEykn+8nw4uKbzekn4ibsTqMx+LHfU89X49
8Ty2D5+IED/Q2rFZYH9YcIy1Efnwc7GIgAn43B6rzxXYKl8ifHomaiB8WVCa
c+mX8l5v7wpsRpDCjIJj8M2TRLuVj4qrc7EIwud/ahG8+P10z4N6y7yskXih
5dDrHN3YO6x37Qwlvd+jivGxnPENjkdUwkKY7/S2iWywoGxAPuZhO6ybqUit
B8nJiPGVFrJjn6VNUeyL2bPtz7YW+Z8DleyZRIfU5sfwrs+FEsgQw5Xd/Y/c
U6OAbwiiRrgu6WUv60D4+XlqWWcvMSMuxR6NHCYIrCbjpS+GXxGcwfx4zGFa
2pyEOsesoXc5AtBwYCfyYVpHs1tMrryWOOYI0XjYMiPBVXgLh+Ez3L6ieMMC
rwnjDhF6SzCcGQUEex6cLm5vg11P445xh+dkspH3WznGxIvWh3M+nbpblYiC
pRA79qVzUwlLwZE+EMO65IN1GN2ZlvbDM1tA4IaDWhmZ6jS2MbJ3NKKf3fw3
7qmxyk0beTPG1Yu+Vpmqyzkr1YF7xmLEkWqOiurVRNaQYxarkbBRjaAG+ENF
azsHcaxx6U01sheLvuP17IS0R8IJ7fZCzEZ+O8DhJ3/CWzjs7SRXlH/9b7Ul
mZYbZzREKVxn7WPZCFWGcDCf5Ybu9nENVHKcRfxs55ivBM5GNhacE+uw73JE
B6RQbWpxpAFd+EKnIxHCaQ+aQkt58WLW2Sdp/nvJm2joY/fGaod+vP/LQRDq
eercTtqb//a1Ai3n94a0cSIEfzI6OABB+RWBKqAaa3lDt/dFAsoq/WKIU8eC
K+38vuCAN9HAEzgDf1oxh+0I6vGwFJMT3tIXPsPtKwqvD2Phzw5p5uwbC3Ov
LTFob6q/XzlhxmRdTndTm6T6xkLsnBwz3PqkvZqV1q7fmBsA7hvNb6ocesu0
l4BTYex3cnYulMIxMIcKSB4Ip4oXZeTGbEQ27VDVPAl3JTXU89RLrZwwZfUV
hGOCBkxn2NYjVMqImtKBg7UvsAK3g7GM9vzYiuCEp9T6ql+Hc41sMtsWboS/
Ec7sD9ZZftpjD8DZCAfAVZCEw/AZbl9RfvDjdMdfpP+yT76piTA6uGIPTscL
lVetLphoAvX1cBVGcnItnM8DcSbDcEgS+zaxuydDMvOB3zyszHlr3axxPB2u
5gMBkIqecj5SgMYg6WM3vFN4KAAqiFMR9xzjQ84oByMC8TCHK/f7Qv44DliO
idHr6129PogD+E5bsqtK6fFz+bgDsAI3MLQlAs5gTuNqbGiFIvtIR0Lr0/IU
Lmg4AHC4ocj4uvjDo4lQruDbdOz07PET3sJh+Ay3/2l59u/09HMHNYu8i9az
rhZK1/BcTtdkFJmEITfqMavbEUBkKsrPvyHE9gxlB9p0yCsImYiUwiOxe4VJ
ArtYwrLjpZbdAtClzLdFiejKspyKR8Lis8cJiU0zVDgEhZSo2FUBl7xTQzuL
j+spbZx/Sy/6KiHhsKDJEIiokLKdKzlDz24oMAEfsAI3MJyNPVPgPFjJWg31
UARdUAeNUFoP19BMcMDpWwzEvRNK4ZX2Gnfyl+idy3AV3sJh+Pxry9vvpGNn
FfdhqjBKO7Qd+RBq2RJnqkyH78tKJkt/L5HYwuT4BX3y852cGlEOAQsfamEb
WhY1N7IjlEUKq1yHD9RkdUo1ClXN/jQv+p3IMGyu5ZQbSLs1PhBuhiIkNBXp
H0NxqslUPPUeRtrTy929FNozZqWasaoOEZaEA5jY7dncyDIHbGvx3rXmtnKS
w3yokdBokdVL24YPVk2Hw3hX1Gw+y4EjEZZqh80IV+EtHP4NEYHnv6dsaufs
nbwzDm9ZyfJwejFvYSvH/GT157tDhM7EijazlN/yQsSJvJliciEnJlkyeHMW
SyR9QVKOyun8QitL2b+EgkevTiSeoaXIxm/v/uzPt0NDB8EtCBpX7u0ucLzg
8i5AAA7QgAlk4Ns/U1nK7AKHfbGJaTnyxLzFzFLOaWaTC3nLhnbKbGTJ0KN6
LgIfSlDcEWe8edDro/ekwEM46VxKePv8+x0D+IMfKXI9Gx9sYyOvlfYoOizC
20d/ZvRSPa+Jdhbx/TKKcsnWcsCIvouRUu4sKefeLEUAy9aNEgInNQlpMxun
9HhyKqgUoRwf6ZZ30zTyiQF2XMM9ZtTX/krX4a4b2acZTDbyjhUfFgccoAHT
n9hQrIyMyLiHQpewzaXwzVbOQXJmVzvc1DKQY/pBF9Q1IlXALh2v9aVQO+GJ
1IluoM22v5bmDXGSEeEqvP0g5ZVXdVqUY9ZeRgcj1/RAnEbofRPMhHok4Cl+
GsuZVy7nCB09lx28zovmW27Gft7Wdo5lOKQrO2VUNqkT16vL+fyfckT5lUl+
KpsPPljDITP5hOcF+dn/o225XJdij8DCRg5m+ZgOK/BA0IRcyNlfCm8t5zRy
xt0bylgOFkfMSGbOKWFr88Tb0KAFipzbYy3Cm16NUn09u0fgDPyBSzRw7NXb
iuEk/PxQ5wt99THNGb5WlCXWHasN+0e1lklmVrIMbEa0biJ24+pbaOh102Ai
lDS5ecPuAwJ97Vjz67BtWI9UQGapznzrprJUYzeE9hA1taQejfDHUtTIgR/5
nwBh2j/2LcVYuXK/sJnzP7WxLhrTi75AmApXkjYCL2fHzmSszoyr2EEn2/hm
uN10OmW0nC1WqBiP7cDaILAhGqXErqmmGsfaeO3TJuWS+ENfK3JAgHvwEODw
80OVrz+RXYgToSgi4k7fnU8A4OrT1Zz64k2ayoRczLmIdp0p5bWVtRpwk5pa
yUuYM5xpfPLuOGzhrNwmJ+5MJ+7KSexOglIoZzkHFyrtrKu0w7PdOdHdblDO
7amh3jrJcDX7kOdjy0BOsd7MqeOMwliMKBfZBeHgEycscORADmytUQ9FUA9a
7MRzzuF0rIDeWuskKJ9Q1+MPvFqLmA7cs/P2wyYCPf5kziJWTsim0ml2zucj
7+xNra7kNcLJtNIENvNOc2WMnJSt5wOU7CR3R+fNHprSkueFA/MTVtjLCplj
4XFCQ16L3S40BmC9m7V78i4Zp15Kygs55UxhzYUstHlKG2fS1sObPRXNgAbM
2UjNYhR7Jhn32LksxveN5jRmS5Uezj6+CVrWQ8nJu/I3824+BrJsv5wn7dg1
AMeUod3Jmdjw88POf/tSHNoeiUy88Vp3b2n8QNtKqbeZlCLgdfOgTBWnzPmc
gcvbD8UGz5uH8sFTiqAFZF/5kw8WPfmZZ8UcgNDsUBx1goh+8tvpr56KbMNG
HhrRIX9jJyIvIWl5Shta0p5e9NX5WpNqBkwgA18Tu7o7Ln/6GC6w2h95KZPN
X0Hbh6EBBLqgDhpNC1Rb1byi/XgtQ3aSgH1Wxfy/6uZ/If/7KP8L/aeP+k+h
//dR/y/s3z7av4X/p4/+n8L/2V//Z+H/76P/v4h/9Tf+VcR/+xv/LfIf+pv/
UOT/9Df/p8h/62/+W5H/2d/8T5ci/7lf+c8uRf5/f/P/U7H/pa/7X1Kx/6vf
+7+K/Y/93f+Yiv2/fd3/61Lsf+/j/neX4vyHPp7/4FKcf9LH8096pTj/p1/n
/6Ti/Kt+n39VnP/W3/PfivMP+3v+YXH+Z3/P/0zF+bd9Pf/WpTj/uY/nP6fi
/PN+n39enP/f3/P/i///or///4VL8f+/9Ov/f+mV4v8/Kvfv/z9yKf7/rz7+
/1+p+P/v+v3/3/VK8f8/9uX/f7yiFP//aX9L8f//fkpK8f9f970U///7p6S8
9BOtd9cfiD3IIdIdfu39Ss2c0O5oiNS8tezV9xa2vNN8S+ugttZOhLs19iJZ
aHjT66HuVlCLMp7WQ0AdjMyflVCZvCt/vDu0lMy1rPZU2jld3OcM/MovgikA
hwpogaKrqPzyDTHhD2/ISYlODhyt7Xqe7S5DwYB1Nqmc/Gk/sMI6sV/YIQ+n
vjj50KEfTE40k50LEj47oaUMzuQgiFMQnQTiYBBwgOYX5PidPBthrPEUHOzQ
63mhwbOX4gj+UAEtUHR1lWeezcYsFiWWy/qpbs52xIVnW1kDQa5C4/RijoWV
F7NyOBE5zIpybuQNC97dX4/gC3oLAgGDC+nBlfvhCInaUeksFHr1IFg7lRtt
Mce8tF1oKm9dqQQ+5VbeO7kR2ILz9h3ZZIaWq66gGL/8qgxDVrSdOOZiJ2Ya
8gEy94erltl705GsDjmWsbCeT2O48bDmp17caQlwGjgARN8DJbHOrjz55MNp
pu35pWzMbke2PL3oCwTgAM0nThg+Pys8jD4S6XzgQ19wUwLqhcD2nCCDP1RA
y1VaHviKJl5jLQdl0DfasYnMmZa2+h28mAknpJ2lByfTgXHJ5LMXlcAPH8zS
SuyVc4DbsUXv//I99XJALeeXRS/6AoE2QAOmXZpTi3mjjeWV1R7wKceG97mV
HGppxGcI/ld1ee676alnJCJuOCi5ql26OzKXtNvijuwERiCXIp9hIpKlESkD
5ey0sQPHmqp30bZim54V+579azPBj7xz2e1XuzsO+A1E3qyimd3hfJoBOIAJ
+NTD5gUCeIItOIM5+F8D5VvfVuTuwn15V+/MUt4XKSk9k9c7L7vVdrbUVo9n
P2RtNW8NKNXzwRr26tsmKnVtvRwpiGM6SvWc5G+n8eJW9sIpi6C9O5aizzPC
wfscHbwDQ/AEW3C+Zsqbb6XXfir34KPfFMeuuzl9dp+MfR88pSMI5nJmVz3i
XKx6tZV8fJOjOZnV3TRj1kobquY/9+VWTsyebedKR0x8gJKhAVlRuQgu0Jhx
fQwXmIAPWNERDMETbD/eAOKnpPz8dSUGaOd7Ld37pfTIY+nO+zUPEb/jNUlm
xzF95FctMp+9n659LLZAruedbjm9ubv/0QnS3hVIG1rS3vv12kdzMMiBNu15
XNRYt8UWDEYHBzABH7ACt59/8g78vpdXXk3/8MNsxb/xpvSNP75Jqog9A2O1
fCCAFwtvrG52c6GVcb2cN3Tv+j938pECcrI1cvaRt2lbpPu4A5//w4+xGJFx
GT2F5wR8PtT5nNdS+c7z0t4/d3ucXDGbU4mGQjNnPitwHBYxXN07qutgOLGV
Pdjlv+L7q6rvtXGCIn11hE6cLOSkneE4KYWxGJFxi+KiLMfBdN0tytljDp+/
T+qiD+Jw+r2zHJ3ii5auHbWX+f91VE4nnyTmPUE+oY6+PnYDaMAEMvA1yuDH
kBl4LZUfvZzu+7K2RSMuRiPsfmgqJ58zq4+ey3u9bcki8J0d0ZP/znCormSr
2Xui6TXY3T8LNGACGfiMwliMWJTLy7vvpjfekhy+54vpliF5ep2W1tiQ6Lj3
ofSXTyi1Ul9B7ED3FoOxek7Op4Z6ntKGlrSnV2MjJ9oBDZhABj6jfBLJIddM
eekVTeADk+nC/doKijDfP6bNbo8/KUPJR7rZ1cMkR+xvnclOIR8WRxta0p5e
9AUCcA6E8QvkorxvYXJefFCbqobCQEBW2xeEQYqVpGPfmtIeEfjffFopH1y5
p2YqogPKxD6XfT6fD/UeOEADZjHtP2B54Xuarn9wveJ9Nw/FYVazOZlHJ3NW
0mf3Srf8/g8U++bKPTXU7x/NKUNDsS2avkAADjUvvN9/fFCUXoGrf/9C+sLD
ac9A+r3fl6Pmoa+mhx9L5++VGrNzTtGrux5QshMtuXJPDfU8pQ0taU8v+gIB
OEDrb5bC1VjeuyRHwe/8rmbvj1+W9H7uRS2gDz4ij+XffkdtzFXuqaGep7Sh
Je3pRV8gfKiNz0UpSlGKUpSiFKUoRSlKUYpSlKIUpShFKUpRrqXy/wC/U1rv

                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 27->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfmTXUeV54mYv2T+i/l5eiaiIZjuDv84vUy3MdauUu2vlrdv9WpXValK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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 28->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnfmznUWZx62av2Rqfres+cEfdKyyprQcdRxRxwVEEQhJSEhu1pvk7vt+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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 29->
                GraphicsBox[RasterBox[CompressedData["
1:eJztneuXncVx7r1W/pLzKf9Jvp+z8sHLK+vkHDB2AAvdpdHM7LmPNBrdLJAE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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 30->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnXmTXdV19l2VT5JPke/x/ptKvamExLEZNHSr53mUujUy4+D5dcqVeAAh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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 31->
                GraphicsBox[RasterBox[CompressedData["
1:eJztXWeTXMd1VZV/if+Kf4I/uPzFLjmIMkkBIMLm2cmzu9gFsYiiZUWrTNEu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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 32->
                GraphicsBox[RasterBox[CompressedData["
1:eJztffmPXMd1tYH8Jd+/lJ+DAJ9gwLZWkrPP9HRPL7NzuEmmpHgRvMOOjcCx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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 33->
                GraphicsBox[RasterBox[CompressedData["
1:eJztXemPZFd1t5S/JH8DEt/yiXziS6KIGOKxjJcZ94x7Znqv7tr3rau36W7P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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 34->
                GraphicsBox[RasterBox[CompressedData["
1:eJztfWuTJVd1JRHzS+avzE+YGPsH2GGMrFa/6nXfeR95H1V1q6qrn0gCgw1I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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 35->
                GraphicsBox[RasterBox[CompressedData["
1:eJztXVmTXddVThW/hAde4IFXXvIPeKIKKKqgktgEx7Kkllo93enceehJUktq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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 36->
                GraphicsBox[RasterBox[CompressedData["
1:eJztXWmTHMdxVYR/ib/rm/+JPyjCH+RwKGyFTFEkzj1mpmd6zj2xWBIiKFGi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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 37->
                GraphicsBox[RasterBox[CompressedData["
1:eJztXVeXXNWV9lrzND9j/oXf5nHeZ63hweMJtnEAYYVudajqqq7U3eooCREE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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 38->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnVuXXMV1x71WPkk+Th7ykqc85MlrJfaKLyABc+2e7p6ZnhnNSNwECEti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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 39->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnflzZEeRx4nYv2T/gP1PiCCCHwhiAxbWgM+xZzyXzj4ltbrVLbW6W2pJ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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}], 40->
                GraphicsBox[RasterBox[CompressedData["
1:eJztnX2vXUX1x0l+r8R3A3/iGyAxISEGpfgMt/ecs8+9BfGhVrC0thSjQNAU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                  "], {{0, 0}, {128, 150}}, {0, 255},
                  ColorFunction->Automatic],
                 ImageSize->{128, 150},
                 PlotRange->{{0, 128}, {0, 150}}]}, Dynamic[$CellContext`i$$],
                
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0,
               Background->GrayLevel[1]],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         ColumnsEqual->False,
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}},
         RowsEqual->False],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$2642$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 40, 1}, 40, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {101.5, 106.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[6]=",
 CellID->1770032701]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AVI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 49.9321186}", "context" -> "", 
    "keywords" -> {
     "multimedia", "video", "animation", "codec", "H.263", "Cinepak"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Registered MIME type: video/avi Microsoft AVI format. Multimedia \
container format. Commonly used for archiving and exchanging video content. \
Stores audio and video content in a format suitable for synchronous playback. \
AVI is an acronym for Audio Video Interleave. Binary format. Supports a \
variety of audio and video codecs as well as uncompressed video frames. \
Introduced in 1992 by Microsoft.", "synonyms" -> {}, "title" -> "AVI", "type" -> 
    "Format", "uri" -> "ref/format/AVI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24065, 826, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 432441, 7744}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3035, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3658, 96, 143, 6, 70, "ObjectNameAlt",
 CellID->19281],
Cell[3804, 104, 541, 12, 70, "FormatUsage",
 CellID->7085],
Cell[4348, 118, 319, 12, 70, "FormatNotes",
 CellID->9152],
Cell[4670, 132, 143, 4, 70, "FormatNotes",
 CellID->1048729514]
}, Open  ]],
Cell[CellGroupData[{
Cell[4850, 141, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4917, 144, 305, 9, 70, "FormatNotes",
 CellID->28652],
Cell[5225, 155, 402, 12, 70, "FormatNotes",
 CellID->8194],
Cell[5630, 169, 43, 1, 70, "WeakDivider",
 CellID->450877100],
Cell[5676, 172, 633, 21, 70, "FormatNotes",
 CellID->1838044116],
Cell[6312, 195, 529, 20, 70, "FormatNotes",
 CellID->455195517],
Cell[6844, 217, 684, 22, 70, "FormatNotes",
 CellID->1447928605],
Cell[7531, 241, 282, 9, 70, "FormatNotes",
 CellID->195249723],
Cell[7816, 252, 654, 22, 70, "FormatNotes",
 CellID->4084],
Cell[8473, 276, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[8515, 279, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[8870, 294, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[9447, 316, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[10030, 339, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[10736, 366, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[10777, 369, 530, 20, 70, "FormatNotes",
 CellID->20289],
Cell[11310, 391, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[12388, 433, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[13052, 457, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[13870, 487, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[13911, 490, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[14275, 506, 352, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[14664, 525, 50, 1, 70, "ElementsSection",
 CellID->9166],
Cell[14717, 528, 192, 8, 70, "FormatNotes",
 CellID->16893],
Cell[14912, 538, 824, 18, 70, "2ColumnTableMod",
 CellID->16074],
Cell[15739, 558, 68, 1, 70, "FormatNotes",
 CellID->30300],
Cell[15810, 561, 752, 15, 70, "2ColumnTableMod",
 CellID->19695],
Cell[16565, 578, 267, 9, 70, "FormatNotes",
 CellID->9573],
Cell[16835, 589, 71, 1, 70, "FormatNotes",
 CellID->243792274],
Cell[16909, 592, 630, 17, 70, "2ColumnTableMod",
 CellID->17950642],
Cell[17542, 611, 215, 8, 70, "FormatNotes",
 CellID->19426],
Cell[17760, 621, 1538, 30, 70, "2ColumnTableMod",
 CellID->28510],
Cell[19301, 653, 835, 29, 70, "FormatNotes",
 CellID->1056263857]
}, Open  ]],
Cell[CellGroupData[{
Cell[20173, 687, 49, 1, 70, "OptionsSection",
 CellID->10422],
Cell[20225, 690, 55, 1, 70, "FormatNotes",
 CellID->30774],
Cell[20283, 693, 847, 23, 70, "3ColumnTableMod",
 CellID->30114],
Cell[21133, 718, 197, 8, 70, "FormatNotes",
 CellID->1357247666],
Cell[21333, 728, 385, 9, 70, "3ColumnTableMod",
 CellID->690224028]
}, Closed]],
Cell[CellGroupData[{
Cell[21755, 742, 53, 1, 70, "TutorialsSection",
 CellID->26122],
Cell[21811, 745, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[21979, 750, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[22186, 758, 50, 1, 70, "SeeAlsoSection",
 CellID->25605],
Cell[22239, 761, 1008, 34, 70, "SeeAlso",
 CellID->2036061149]
}, Open  ]],
Cell[CellGroupData[{
Cell[23284, 800, 58, 1, 70, "MoreAboutSection",
 CellID->176385089],
Cell[23345, 803, 126, 2, 70, "MoreAbout"],
Cell[23474, 807, 151, 2, 70, "MoreAbout"],
Cell[23628, 811, 134, 2, 70, "MoreAbout"],
Cell[23765, 815, 133, 2, 70, "MoreAbout"],
Cell[23901, 819, 127, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24065, 826, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24181, 832, 60, 1, 70, "ExampleSection",
 CellID->324030680],
Cell[24244, 835, 136, 4, 70, "ExampleText",
 CellID->1955517324],
Cell[CellGroupData[{
Cell[24405, 843, 1691, 46, 70, "Input",
 CellID->7950],
Cell[26099, 891, 85, 2, 70, "Output",
 CellID->1768709751]
}, Open  ]],
Cell[26199, 896, 103, 2, 70, "ExampleText",
 CellID->1289930780],
Cell[CellGroupData[{
Cell[26327, 902, 154, 4, 70, "Input",
 CellID->2103267738],
Cell[26484, 908, 398, 8, 70, "Output",
 CellID->1236143283]
}, Open  ]],
Cell[26897, 919, 77, 1, 70, "ExampleText",
 CellID->1019202995],
Cell[CellGroupData[{
Cell[26999, 924, 403, 11, 70, "Input",
 CellID->1477755475],
Cell[27405, 937, 293, 9, 70, "Output",
 CellID->1103356303]
}, Open  ]],
Cell[27713, 949, 140, 4, 70, "ExampleText",
 CellID->1415168493],
Cell[CellGroupData[{
Cell[27878, 957, 152, 4, 70, "Input",
 CellID->1284096433],
Cell[28033, 963, 553, 11, 70, "Output",
 CellID->588092676]
}, Open  ]],
Cell[28601, 977, 68, 1, 70, "ExampleText",
 CellID->1355471326],
Cell[CellGroupData[{
Cell[28694, 982, 295, 10, 70, "Input",
 CellID->1201193829],
Cell[28992, 994, 31817, 534, 70, "Output",
 CellID->1353862038]
}, Open  ]],
Cell[60824, 1531, 93, 1, 70, "ExampleText",
 CellID->900048706],
Cell[CellGroupData[{
Cell[60942, 1536, 154, 4, 70, "Input",
 CellID->893057308],
Cell[61099, 1542, 369912, 6165, 70, "Output",
 CellID->1770032701]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[431050, 7712, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

