(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23453,        766]
NotebookOptionsPosition[     18307,        602]
NotebookOutlinePosition[     19832,        642]
CellTagsIndexPosition[     19747,        637]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"CSV\"" :> Documentation`HelpLookup["paclet:ref/format/CSV"], 
          "\"DBF\"" :> Documentation`HelpLookup["paclet:ref/format/DBF"], 
          "\"MBOX\"" :> Documentation`HelpLookup["paclet:ref/format/MBOX"], 
          "\"MDB\"" :> Documentation`HelpLookup["paclet:ref/format/MDB"], 
          "\"Table\"" :> Documentation`HelpLookup["paclet:ref/format/Table"], 
          "\"TSV\"" :> Documentation`HelpLookup["paclet:ref/format/TSV"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"CSV\\\"\"\>", 
       2->"\<\"\\\"DBF\\\"\"\>", 3->"\<\"\\\"MBOX\\\"\"\>", 
       4->"\<\"\\\"MDB\\\"\"\>", 5->"\<\"\\\"Table\\\"\"\>", 
       6->"\<\"\\\"TSV\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup["paclet:guide/SystemsAndUtilityFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       5->"\<\"New in 6.0: Import & Export Formats\"\>", 
       6->"\<\"Systems & Utility Formats\"\>", 
       7->"\<\"Web Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ApacheLog", "ObjectNameAlt",
 CellID->29426],

Cell[TextData[{
 "Apache log files.\nNative log file format of the Apache web server.\nCommon \
variants are Apache Common Log and Apache Access Log.\nIs used by ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 ", the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " license manager.\nPlain text format.\nStores information about web server \
transactions.\nRepresents each record as a line of text.\nAllows \
user-customized record formats."
}], "FormatUsage",
 CellID->15871],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read all common variants of the Apache log format, as well as Wolfram \
",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " log files and user-customized log formats."
}], "FormatNotes",
 CellID->10697]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->17612],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<ApacheLog\>\""}], "]"}]], 
  "InlineFormula"],
 " imports an Apache log file."
}], "FormatNotes",
 CellID->18703],

Cell["", "WeakDivider",
 CellID->710136041],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<ApacheLog\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "reads an Apache log file and returns the contents as a table."
}], "FormatNotes",
 CellID->9508],

Cell["", "WeakDivider",
 CellID->24237],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ApacheLog\>\"", ",", " ", 
      StyleBox["elem", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports the specified element from an Apache log file."
}], "FormatNotes",
 CellID->26443],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ApacheLog\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->22501],

Cell[TextData[{
 "The format ",
 Cell[BoxData["\"\<ApacheLog\>\""], "InlineFormula"],
 " must always be specified when importing Apache log files."
}], "FormatNotes",
 CellID->104074156],

Cell["", "WeakDivider",
 CellID->1454],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports Apache log formats."
}], "FormatNotes",
 CellID->681]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->27465],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->20267],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->17713],

Cell["", "WeakDivider",
 CellID->19793],

Cell["Data representation element:", "FormatNotes",
 CellID->1978842132],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "content of the file represented as a list of lists", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1506091460],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element for Apache log files."
}], "FormatNotes",
 CellID->489421031],

Cell["Selecting individual data fields:", "FormatNotes",
 CellID->1194257646],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ByteCount\>\"", Cell[
    "byte size of the object returned to the client", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Date\>\"", Cell[TextData[{
     "date and time of the transaction, given as a string",
     Cell[BoxData[""], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Referrer\>\"", Cell[
    "site the client reports having been referred from", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RemoteHost\>\"", Cell[
    "IP address or hostname of the client", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RemoteUser\>\"", Cell[
    "user ID of the client as determined by HTTP authentication", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RequestLine\>\"", Cell["\<\
the client request as a string, normally containing the path of the requested \
object and information about the protocol\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SessionID\>\"", Cell[
    "a string that identifies the user session", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StatusCode\>\"", Cell["\<\
the status code that the server returns to the client, as defined in the HTTP \
specification (RFC2616)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UserAgent\>\"", Cell[
    "browser identification as reported by the client", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Attachments\>\"", Cell[
    "files attached to the message", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->629581695]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->8823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->242171646],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DataFormat\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
format specification, given as a list of data representation elements and \
separators representing one record\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->320471435],

Cell[TextData[{
 "To import a custom log format, ",
 Cell[BoxData["\"\<DataFormat\>\""], "InlineFormula"],
 " can be used to specify the format of each record as a combination of data \
elements and record separators."
}], "FormatNotes",
 CellID->1611439378],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " of Common Log files uses the setting ",
 Cell[BoxData["\"\<DataFormat\>\""], "InlineFormula"],
 " -> ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<RemoteHost\>\"", ",", "\"\< \>\"", ",", "\"\<ClientID\>\"", ",", 
     "\"\< \>\"", ",", "\"\<RemoteUser\>\"", ",", "\"\< \>\"", " ", ",", 
     "\"\<Date\>\"", ",", "\"\< \\\"\>\"", ",", "\"\<RequestLine\>\"", ",", 
     "\"\<\\\" \>\"", ",", "\"\<StatusCode\>\"", ",", "\"\< \>\"", " ", ",", 
     "\"\<ByteCount\>\""}], "}"}], "."}]], "InlineFormula"]
}], "FormatNotes",
 CellID->14137115],

Cell[TextData[{
 "The default format of",
 " ",
 "Access Log files is given by ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<RemoteHost\>\"", ",", "\"\< \>\"", ",", "\"\<ClientID\>\"", ",", 
     "\"\< \>\"", ",", "\"\<RemoteUser\>\"", ",", "\"\< \>\"", " ", ",", 
     "\"\<Date\>\"", ",", "\"\< \\\"\>\"", ",", "\"\<RequestLine\>\"", ",", 
     "\"\<\\\" \>\"", ",", "\"\<StatusCode\>\"", ",", "\"\< \>\"", " ", ",", 
     "\"\<ByteCount\>\"", ",", "\n", "\"\< \\\"\>\"", ",", "\"\<Referrer\>\"",
      ",", "\"\<\\\" \\\"\>\"", ",", "\"\<UserAgent\>\"", ",", 
     "\"\<\\\"\>\""}], "}"}], "."}]], "InlineFormula"]
}], "FormatNotes",
 CellID->1545353729]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->2742],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<CSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/CSV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<DBF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/DBF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MBOX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MBOX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MDB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MDB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Table\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Table"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TSV"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8610]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->694108950],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->390586997],

Cell["Import an entire log file as a list of records:", "ExampleText",
 CellID->587829149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/common.log\>\"", ",", " ", "\"\<ApacheLog\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"127.0.0.1\"\>", ",", "\<\"michael\"\>", 
     ",", "\<\"19/Jan/2000:07:25:34 -0700\"\>", 
     ",", "\<\"GET /index.html HTTP/1.0\"\>", ",", "200", ",", "46732"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"127.0.0.1\"\>", ",", "\<\"michael\"\>", 
     ",", "\<\"19/Jan/2000:07:25:36 -0700\"\>", 
     ",", "\<\"GET /picture.gif HTTP/1.0\"\>", ",", "200", ",", "674334"}], 
    "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2145714953]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->1019048987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/common.log\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<ApacheLog\>\"", ",", "\"\<Elements\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->974239684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ByteCount\"\>", ",", "\<\"Data\"\>", ",", "\<\"Date\"\>", 
   ",", "\<\"RemoteHost\"\>", ",", "\<\"RemoteUser\"\>", 
   ",", "\<\"RequestLine\"\>", ",", "\<\"StatusCode\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->338331000]
}, Open  ]],

Cell["Read only the date fields:", "ExampleText",
 CellID->566007512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/common.log\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<ApacheLog\>\"", ",", "\"\<Date\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1939903391],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"19/Jan/2000:07:25:34 -0700\"\>", 
   ",", "\<\"19/Jan/2000:07:25:36 -0700\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->859563783]
}, Open  ]],

Cell["Read all server requests:", "ExampleText",
 CellID->1683181621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/common.log\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<ApacheLog\>\"", ",", "\"\<RequestLine\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->431422216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"GET /index.html HTTP/1.0\"\>", 
   ",", "\<\"GET /picture.gif HTTP/1.0\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1008392040]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ApacheLog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 48.7289628}", "context" -> "", 
    "keywords" -> {
     "access log", "logging", "syslog", "system logs", "web logs"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Apache log files. Native log file format of the Apache web server. \
Common variants are Apache Common Log and Apache Access Log. Is used by \
MathLM, the Mathematica license manager. Plain text format. Stores \
information about web server transactions. Represents each record as a line \
of text. Allows user-customized record formats.", "synonyms" -> {}, "title" -> 
    "ApacheLog", "type" -> "Format", "uri" -> "ref/format/ApacheLog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15390, 486, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19613, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2700, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3323, 84, 50, 1, 70, "ObjectNameAlt",
 CellID->29426],
Cell[3376, 87, 482, 12, 70, "FormatUsage",
 CellID->15871],
Cell[3861, 101, 338, 11, 70, "FormatNotes",
 CellID->10697]
}, Open  ]],
Cell[CellGroupData[{
Cell[4236, 117, 53, 1, 70, "ImportExportSection",
 CellID->17612],
Cell[4292, 120, 318, 11, 70, "FormatNotes",
 CellID->18703],
Cell[4613, 133, 43, 1, 70, "WeakDivider",
 CellID->710136041],
Cell[4659, 136, 374, 12, 70, "FormatNotes",
 CellID->9508],
Cell[5036, 150, 39, 1, 70, "WeakDivider",
 CellID->24237],
Cell[5078, 153, 419, 13, 70, "FormatNotes",
 CellID->26443],
Cell[5500, 168, 629, 22, 70, "FormatNotes",
 CellID->22501],
Cell[6132, 192, 186, 5, 70, "FormatNotes",
 CellID->104074156],
Cell[6321, 199, 38, 1, 70, "WeakDivider",
 CellID->1454],
Cell[6362, 202, 236, 9, 70, "FormatNotes",
 CellID->15869],
Cell[6601, 213, 208, 7, 70, "FormatNotes",
 CellID->681]
}, Closed]],
Cell[CellGroupData[{
Cell[6846, 225, 51, 1, 70, "ElementsSection",
 CellID->27465],
Cell[6900, 228, 192, 8, 70, "FormatNotes",
 CellID->20267],
Cell[7095, 238, 669, 13, 70, "2ColumnTableMod",
 CellID->17713],
Cell[7767, 253, 39, 1, 70, "WeakDivider",
 CellID->19793],
Cell[7809, 256, 72, 1, 70, "FormatNotes",
 CellID->1978842132],
Cell[7884, 259, 382, 9, 70, "2ColumnTableMod",
 CellID->1506091460],
Cell[8269, 270, 278, 9, 70, "FormatNotes",
 CellID->489421031],
Cell[8550, 281, 77, 1, 70, "FormatNotes",
 CellID->1194257646],
Cell[8630, 284, 1885, 37, 70, "2ColumnTableMod",
 CellID->629581695]
}, Open  ]],
Cell[CellGroupData[{
Cell[10552, 326, 48, 1, 70, "OptionsSection",
 CellID->8823],
Cell[10603, 329, 181, 7, 70, "FormatNotes",
 CellID->242171646],
Cell[10787, 338, 544, 14, 70, "3ColumnTableMod",
 CellID->320471435],
Cell[11334, 354, 258, 6, 70, "FormatNotes",
 CellID->1611439378],
Cell[11595, 362, 695, 18, 70, "FormatNotes",
 CellID->14137115],
Cell[12293, 382, 679, 16, 70, "FormatNotes",
 CellID->1545353729]
}, Closed]],
Cell[CellGroupData[{
Cell[13009, 403, 49, 1, 70, "SeeAlsoSection",
 CellID->2742],
Cell[13061, 406, 1214, 41, 70, "SeeAlso",
 CellID->8610]
}, Open  ]],
Cell[CellGroupData[{
Cell[14312, 452, 58, 1, 70, "MoreAboutSection",
 CellID->694108950],
Cell[14373, 455, 114, 2, 70, "MoreAbout"],
Cell[14490, 459, 134, 2, 70, "MoreAbout"],
Cell[14627, 463, 133, 2, 70, "MoreAbout"],
Cell[14763, 467, 165, 2, 70, "MoreAbout"],
Cell[14931, 471, 156, 2, 70, "MoreAbout"],
Cell[15090, 475, 141, 2, 70, "MoreAbout"],
Cell[15234, 479, 119, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15390, 486, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[15506, 492, 60, 1, 70, "ExampleSection",
 CellID->390586997],
Cell[15569, 495, 90, 1, 70, "ExampleText",
 CellID->587829149],
Cell[CellGroupData[{
Cell[15684, 500, 173, 5, 70, "Input",
 CellID->7128],
Cell[15860, 507, 531, 14, 70, "Output",
 CellID->2145714953]
}, Open  ]],
Cell[16406, 524, 221, 8, 70, "ExampleText",
 CellID->1019048987],
Cell[CellGroupData[{
Cell[16652, 536, 237, 7, 70, "Input",
 CellID->974239684],
Cell[16892, 545, 281, 6, 70, "Output",
 CellID->338331000]
}, Open  ]],
Cell[17188, 554, 69, 1, 70, "ExampleText",
 CellID->566007512],
Cell[CellGroupData[{
Cell[17282, 559, 234, 7, 70, "Input",
 CellID->1939903391],
Cell[17519, 568, 186, 5, 70, "Output",
 CellID->859563783]
}, Open  ]],
Cell[17720, 576, 69, 1, 70, "ExampleText",
 CellID->1683181621],
Cell[CellGroupData[{
Cell[17814, 581, 240, 7, 70, "Input",
 CellID->431422216],
Cell[18057, 590, 184, 5, 70, "Output",
 CellID->1008392040]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[18280, 600, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

