(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    138177,       2745]
NotebookOptionsPosition[    132825,       2577]
NotebookOutlinePosition[    134456,       2618]
CellTagsIndexPosition[    134369,       2613]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Directory\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Directory"], "\"GZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/GZIP"], "\"TAR\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TAR"], "\"ZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ZIP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"Directory\\\"\"\>", 
       2->"\<\"\\\"GZIP\\\"\"\>", 3->"\<\"\\\"TAR\\\"\"\>", 
       4->"\<\"\\\"ZIP\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "BZIP2 ",
 StyleBox["(.bz2)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "Mime type: ",
 StyleBox["application/x-bzip2",
  FontFamily->"Courier",
  FontSize->12],
 ".\nBZIP2 compression method and file format.\nGeneral-purpose lossless \
compression method.\nOccasionally used for archiving data on Unix systems and \
for exchanging files on the internet.\nBinary format.\nCompresses data using \
a combination of the Burrows\[Dash]Wheeler transform and Huffman entropy \
coding.\nStores a single file.\nTypically used in combination with TAR.\n\
Developed and maintained by Julian Seward.\nIntroduced in 1996, released as \
version 1.0 in 2000."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the BZIP2 format version 1.0."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", "]"}]], "InlineFormula"],
 " uncompresses and imports a ",
 "BZIP2",
 " compressed archive."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports any expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to a BZIP2 compressed file whose format is implied by the file name \
extension ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).bz2\>\"", "]"}]], "InlineFormula"],
 " uncompresses ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", "bz2"}]], "InlineFormula"],
 " and imports ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 ", automatically inferring the format from the file contents."
}], "FormatNotes",
 CellID->450071431],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).bz2\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " uncompresses a BZIP2 file and imports it as ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->427066366],

Cell[TextData[{
 "Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can automatically recognize all common file compression and archive \
formats, it is never necessary to specify ",
 Cell[BoxData["\"\<BZIP2\>\""], "InlineFormula"],
 " as a format in the second argument of ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->814065088],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be explicitly specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).bz2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
      SubscriptBox[
       StyleBox["elems", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elems", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->790737906],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "BZIP2",
 " compressed ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"], " "}]], "InlineFormula"],
 "file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 "The export format and BZIP2 compression method can be explicitly specified \
with ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "[ ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["exprs", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<BZIP2\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
     StyleBox["elems", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1935856016],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " can handle ",
 "BZIP2",
 " compressed data."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "The ",
 "BZIP2",
 " format itself does not support ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " elements."
}], "FormatNotes",
 CellID->412760358],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements of the ",
 "BZIP2",
 "-compressed file:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).bz2\>\"", ",", "\"\<Elements\>\""}], "]"}]], 
  "InlineFormula"],
 " returns the names of elements available in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 ", effectively unpacking the compressed archive before importing the \
enclosed file."
}], "FormatNotes",
 CellID->1920211061]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<Directory\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Directory"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GZIP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TAR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TAR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZIP"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->293633216],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->2004615],

Cell["Export a string to a BZIP2-compressed text file:", "ExampleText",
 CellID->752585896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{"\"\<felix qui potuit rerum conoscere causas\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<BZIP2\>\"", ",", " ", "\"\<Text\>\""}], "}"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData["\<\"BZh91AY&SY6\.95o6\.00\.00\.07\.11\.80@\.00+'\[Thorn]@ \
\.001CM0\.00D\[CapitalEGrave]\[CapitalUAcute]@m%\[AGrave]Q9\.86S\.bc6);\
\[CapitalAE]\.91'h\.15@2\[CapitalOTilde]>w\[OSlash]\[RightGuillemet]\.92)\
\[CapitalAHat]\.84\.81\.b4\[LeftGuillemet]y\[Degree]\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->316931956]
}, Open  ]],

Cell[TextData[{
 "Convert the previous output back to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string:"
}], "ExampleText",
 CellID->1399678473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32473242],

Cell[BoxData["\<\"felix qui potuit rerum conoscere causas\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->915939932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1610270696],

Cell["Export graphics to a BZIP2-compressed PNG file:", "ExampleText",
 CellID->679151227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<moon.png.bz2\>\"", ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzsvIdzY+l57umq+4+sr2SlGWtGmtTTPdM5RzbZiR3JZg7NnAkGgMg553Bw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     "], {{0, 0}, {200, 200}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->Tiny,
    PlotRange->{{0, 200}, {0, 200}}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->923754747],

Cell[BoxData["\<\"moon.png.bz2\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1880050454]
}, Open  ]],

Cell[TextData[{
 "This gives the available ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements of the PNG file:"
}], "ExampleText",
 CellID->80720679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<moon.png.bz2\>\"", ",", "\"\<Elements\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2081082067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BitDepth\"\>", ",", "\<\"ColorSpace\"\>", ",", "\<\"Data\"\>", 
   ",", "\<\"DataType\"\>", ",", "\<\"Graphics\"\>", ",", "\<\"ImageSize\"\>",
    ",", "\<\"RGBColorArray\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->82379352]
}, Open  ]],

Cell[TextData[{
 "When importing any element from a BZIP2 file, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically uncompresses it:"
}], "ExampleText",
 CellID->1295241513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<moon.png.bz2\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<ColorSpace\>\"", ",", "\"\<BitDepth\>\""}], "}"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1570300396],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"RGBColor", ",", "8"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1563670023]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BZIP2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 56.8854216}", "context" -> "", 
    "keywords" -> {"compression", "archive"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mime type: application/x-bzip2. BZIP2 compression method and file \
format. General-purpose lossless compression method. Occasionally used for \
archiving data on Unix systems and for exchanging files on the internet. \
Binary format. Compresses data using a combination of the Burrows-Wheeler \
transform and Huffman entropy coding. Stores a single file. Typically used in \
combination with TAR. Developed and maintained by Julian Seward. Introduced \
in 1996, released as version 1.0 in 2000.", "synonyms" -> {}, "title" -> 
    "BZIP2", "type" -> "Format", "uri" -> "ref/format/BZIP2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16152, 584, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 134235, 2606}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2061, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2684, 74, 109, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2796, 80, 628, 13, 70, "FormatUsage",
 CellID->37585799],
Cell[3427, 95, 336, 12, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3800, 112, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3867, 115, 344, 12, 70, "FormatNotes",
 CellID->28652],
Cell[4214, 129, 582, 20, 70, "FormatNotes",
 CellID->8194],
Cell[4799, 151, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4841, 154, 493, 16, 70, "FormatNotes",
 CellID->450071431],
Cell[5337, 172, 451, 14, 70, "FormatNotes",
 CellID->427066366],
Cell[5791, 188, 446, 14, 70, "FormatNotes",
 CellID->814065088],
Cell[6240, 204, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6282, 207, 519, 18, 70, "FormatNotes",
 CellID->29174],
Cell[6804, 227, 609, 21, 70, "FormatNotes",
 CellID->18819],
Cell[7416, 250, 615, 22, 70, "FormatNotes",
 CellID->943],
Cell[8034, 274, 635, 21, 70, "FormatNotes",
 CellID->790737906],
Cell[8672, 297, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[8713, 300, 660, 25, 70, "FormatNotes",
 CellID->20289],
Cell[9376, 327, 1110, 41, 70, "FormatNotes",
 CellID->8419],
Cell[10489, 370, 696, 23, 70, "FormatNotes",
 CellID->5565],
Cell[11188, 395, 621, 22, 70, "FormatNotes",
 CellID->1935856016],
Cell[11812, 419, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11853, 422, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[12217, 438, 362, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[12616, 457, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12675, 460, 363, 15, 70, "FormatNotes",
 CellID->412760358],
Cell[13041, 477, 222, 9, 70, "FormatNotes",
 CellID->367643471],
Cell[13266, 488, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13961, 504, 567, 18, 70, "FormatNotes",
 CellID->1920211061]
}, Open  ]],
Cell[CellGroupData[{
Cell[14565, 527, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[14623, 530, 811, 27, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[15471, 562, 58, 1, 70, "MoreAboutSection",
 CellID->293633216],
Cell[15532, 565, 151, 2, 70, "MoreAbout"],
Cell[15686, 569, 134, 2, 70, "MoreAbout"],
Cell[15823, 573, 133, 2, 70, "MoreAbout"],
Cell[15959, 577, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16152, 584, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16268, 590, 58, 1, 70, "ExampleSection",
 CellID->2004615],
Cell[16329, 593, 91, 1, 70, "ExampleText",
 CellID->752585896],
Cell[CellGroupData[{
Cell[16445, 598, 272, 7, 70, "Input",
 CellID->976592890],
Cell[16720, 607, 334, 5, 70, "Output",
 CellID->316931956]
}, Open  ]],
Cell[17069, 615, 159, 6, 70, "ExampleText",
 CellID->1399678473],
Cell[CellGroupData[{
Cell[17253, 625, 107, 3, 70, "Input",
 CellID->32473242],
Cell[17363, 630, 117, 2, 70, "Output",
 CellID->915939932]
}, Open  ]],
Cell[17495, 635, 126, 3, 70, "ExampleDelimiter",
 CellID->1610270696],
Cell[17624, 640, 90, 1, 70, "ExampleText",
 CellID->679151227],
Cell[CellGroupData[{
Cell[17739, 645, 113601, 1867, 70, "Input",
 CellID->923754747],
Cell[131343, 2514, 91, 2, 70, "Output",
 CellID->1880050454]
}, Open  ]],
Cell[131449, 2519, 228, 8, 70, "ExampleText",
 CellID->80720679],
Cell[CellGroupData[{
Cell[131702, 2531, 160, 4, 70, "Input",
 CellID->2081082067],
Cell[131865, 2537, 282, 6, 70, "Output",
 CellID->82379352]
}, Open  ]],
Cell[132162, 2546, 190, 6, 70, "ExampleText",
 CellID->1295241513],
Cell[CellGroupData[{
Cell[132377, 2556, 255, 8, 70, "Input",
 CellID->1570300396],
Cell[132635, 2566, 124, 4, 70, "Output",
 CellID->1563670023]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[132798, 2575, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

