(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21807,        769]
NotebookOptionsPosition[     17086,        621]
NotebookOutlinePosition[     18714,        663]
CellTagsIndexPosition[     18629,        658]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/GZIP"], "\"MBOX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MBOX"], "\"TAR\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TAR"], "\"UUE\"" :> 
          Documentation`HelpLookup["paclet:ref/format/UUE"], "\"ZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ZIP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GZIP\\\"\"\>", 
       2->"\<\"\\\"MBOX\\\"\"\>", 3->"\<\"\\\"TAR\\\"\"\>", 
       4->"\<\"\\\"UUE\\\"\"\>", 
       5->"\<\"\\\"ZIP\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       5->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Base64 ",
 StyleBox["(.b64)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "Base64 binary to text encoding.\nEncodes binary data as a sequence of \
printable ASCII characters.\nCommonly used for the transfer of binary content \
by email.\nThe Base64 encoding is described in internet standard \
recommendations RFC 1421 and 2045.\nASCII format.\nUses the 52 uppercase and \
lowercase letters of the Roman alphabet, the numerals 0 to 9, and the \
characters ",
 Cell[BoxData["\"\<+\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\</\>\""], "InlineFormula"],
 " to form a positional numeral system using a base of 64.\nThe ",
 Cell[BoxData["\"\<=\>\""], "InlineFormula"],
 " character is used for padding Base64-encoded data."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support Base64 encoding."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", "]"}]], "InlineFormula"],
 " imports a Base64-encoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->162514879],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an expression to a Base64-encoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).b64\>\"", "]"}]], "InlineFormula"],
 "decodes a Base64-encoded file and imports its contents as an expression, \
automatically inferring the format from the file contents."
}], "FormatNotes",
 CellID->450071431],

Cell[TextData[{
 "The import format can be given explicitly with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Base64\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->913136083],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a Base64-encoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format and file encoding can be explicitly specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\<\"\\\"\\!\\(\\*\\nStyleBox[\\\"file\\\", \
\\\"TI\\\"]\\)\\\"\"\>", ","}]}]], "InlineFormula",
  ShowStringCharacters->False],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Base64\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
     SubscriptBox[
      StyleBox["elems", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["elems", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->790737906],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a Base64-encoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"], " "}]], "InlineFormula"],
 "file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).b64\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell[TextData[{
 "The export format and file encoding can be explicitly specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["exprs", "TI"], ","}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<Base64\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
     StyleBox["elems", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1935856016],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support Base64 encoding."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GZIP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MBOX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MBOX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TAR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TAR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<UUE\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UUE"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZIP"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->385418637],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->209858584],

Cell["Convert a string to Base64 encoding:", "ExampleText",
 CellID->1387316077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"\"\<some pig\>\"", ",", " ", "\"\<Base64\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1155774215],

Cell[BoxData["\<\"c29tZSBwaWc=\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1107644390]
}, Open  ]],

Cell[TextData[{
 "The format ",
 Cell[BoxData["\"\<Base64\>\""], "InlineFormula"],
 " must be specified when reading Base64-encoded data:"
}], "ExampleText",
 CellID->593140592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<Base64\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1791010534],

Cell[BoxData["\<\"some pig\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->235764939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1283698105],

Cell["Arbitrary expressions can be encoded as Base64:", "ExampleText",
 CellID->1493332973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "/", "2"}], ",", " ", "\"\<Base64\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->805894722],

Cell[BoxData["\<\"KGEgKyBiKS8y\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->493231025]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<Base64\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->446959755],

Cell[BoxData["\<\"(a + b)/2\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->154805079]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Base64 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 54.1353512}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Base64 binary to text encoding. Encodes binary data as a sequence of \
printable ASCII characters. Commonly used for the transfer of binary content \
by email. The Base64 encoding is described in internet standard \
recommendations RFC 1421 and 2045. ASCII format. Uses the 52 uppercase and \
lowercase letters of the Roman alphabet, the numerals 0 to 9, and the \
characters \"+\" and \"/\" to form a positional numeral system using a base \
of 64. The \"=\" character is used for padding Base64-encoded data.", 
    "synonyms" -> {}, "title" -> "Base64", "type" -> "Format", "uri" -> 
    "ref/format/Base64"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15169, 534, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18495, 651}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2374, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2997, 80, 110, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3110, 86, 709, 14, 70, "FormatUsage",
 CellID->37585799],
Cell[3822, 102, 323, 12, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[4182, 119, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4249, 122, 400, 14, 70, "FormatNotes",
 CellID->162514879],
Cell[4652, 138, 460, 16, 70, "FormatNotes",
 CellID->8194],
Cell[5115, 156, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[5157, 159, 383, 10, 70, "FormatNotes",
 CellID->450071431],
Cell[5543, 171, 431, 14, 70, "FormatNotes",
 CellID->913136083],
Cell[5977, 187, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6019, 190, 471, 16, 70, "FormatNotes",
 CellID->29174],
Cell[6493, 208, 609, 21, 70, "FormatNotes",
 CellID->18819],
Cell[7105, 231, 615, 22, 70, "FormatNotes",
 CellID->943],
Cell[7723, 255, 770, 25, 70, "FormatNotes",
 CellID->790737906],
Cell[8496, 282, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[8537, 285, 648, 23, 70, "FormatNotes",
 CellID->20289],
Cell[9188, 310, 1110, 41, 70, "FormatNotes",
 CellID->8419],
Cell[10301, 353, 696, 23, 70, "FormatNotes",
 CellID->5565],
Cell[11000, 378, 850, 29, 70, "FormatNotes",
 CellID->3805],
Cell[11853, 409, 575, 19, 70, "FormatNotes",
 CellID->1935856016],
Cell[12431, 430, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[12472, 433, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[12836, 449, 343, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[13216, 466, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[13274, 469, 1009, 34, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[14320, 508, 58, 1, 70, "MoreAboutSection",
 CellID->385418637],
Cell[14381, 511, 151, 2, 70, "MoreAbout"],
Cell[14535, 515, 134, 2, 70, "MoreAbout"],
Cell[14672, 519, 133, 2, 70, "MoreAbout"],
Cell[14808, 523, 165, 2, 70, "MoreAbout"],
Cell[14976, 527, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15169, 534, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[15285, 540, 60, 1, 70, "ExampleSection",
 CellID->209858584],
Cell[15348, 543, 80, 1, 70, "ExampleText",
 CellID->1387316077],
Cell[CellGroupData[{
Cell[15453, 548, 165, 4, 70, "Input",
 CellID->1155774215],
Cell[15621, 554, 94, 2, 70, "Output",
 CellID->1107644390]
}, Open  ]],
Cell[15730, 559, 177, 5, 70, "ExampleText",
 CellID->593140592],
Cell[CellGroupData[{
Cell[15932, 568, 145, 4, 70, "Input",
 CellID->1791010534],
Cell[16080, 574, 86, 2, 70, "Output",
 CellID->235764939]
}, Open  ]],
Cell[16181, 579, 126, 3, 70, "ExampleDelimiter",
 CellID->1283698105],
Cell[16310, 584, 91, 1, 70, "ExampleText",
 CellID->1493332973],
Cell[CellGroupData[{
Cell[16426, 589, 227, 8, 70, "Input",
 CellID->805894722],
Cell[16656, 599, 93, 2, 70, "Output",
 CellID->493231025]
}, Open  ]],
Cell[CellGroupData[{
Cell[16786, 606, 144, 4, 70, "Input",
 CellID->446959755],
Cell[16933, 612, 87, 2, 70, "Output",
 CellID->154805079]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[17059, 619, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

