(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27503,        947]
NotebookOptionsPosition[     22045,        768]
NotebookOutlinePosition[     23308,        804]
CellTagsIndexPosition[     23223,        799]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinaryRead" :> 
          Documentation`HelpLookup["paclet:ref/BinaryRead"], "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], 
          "BinaryWrite" :> Documentation`HelpLookup["paclet:ref/BinaryWrite"],
           "\"Bit\"" :> Documentation`HelpLookup["paclet:ref/format/Bit"], 
          "\"Byte\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Byte"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BinaryRead\"\>", 
       2->"\<\"BinaryReadList\"\>", 3->"\<\"BinaryWrite\"\>", 
       4->"\<\"\\\"Bit\\\"\"\>", 
       5->"\<\"\\\"Byte\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Formats" :> 
          Documentation`HelpLookup["paclet:guide/BasicFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Basic Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Binary", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Sequence of binary data objects.
Binary format.
Stores a uniform sequence of simple or compound data types.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " reads raw binary data as a sequence of elementary or compound data types."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " generates binary files from uniform lists of elementary or compound data \
types."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Binary\>\""}], "]"}]], 
  "InlineFormula"],
 " imports any binary file as a list of bytes."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<Binary\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of byte-size integers to a binary file."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 "The format ",
 Cell[BoxData["\"\<Binary\>\""], "InlineFormula"],
 " must be specified when importing or exporting raw binary files."
}], "FormatNotes",
 CellID->236987809],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Binary\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element from a binary file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Binary\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"TI\"]\)\>", ",", 
     StyleBox["expr", "TI"], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Binary\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " creates a binary file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support raw binary files."
}], "FormatNotes",
 CellID->31450],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 " can be used for reading from or writing to streams of raw binary data."
}], "FormatNotes",
 CellID->1665888954]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Bit\>\"", Cell[
    "zeros and ones", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Byte\>\"", Cell[
    "integers in the range (0, 255)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Character8\>\"", Cell[
    "8\[Hyphen]bit characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Character16\>\"", Cell[
    "16\[Hyphen]bit characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer8\>\"", Cell[
    "8-bit signed integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer16\>\"", Cell[
    "16-bit signed integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer24\>\"", Cell[
    "24-bit signed integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer32\>\"", Cell[
    "32-bit signed integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer64\>\"", Cell[
    "64-bit signed integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Integer128\>\"", Cell[
    "128-bit signed integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger8\>\"", Cell[
    "8-bit unsigned integers ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger16\>\"", Cell[
    "16-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger24\>\"", Cell[
    "24-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger32\>\"", Cell[
    "32-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger64\>\"", Cell[
    "64-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UnsignedInteger128\>\"", Cell[
    "128-bit unsigned integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real32\>\"", Cell[
    "IEEE single\[Hyphen]precision numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real64\>\"", Cell[
    "IEEE double\[Hyphen]precision numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Real128\>\"", Cell[
    "IEEE quad\[Hyphen]precision numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complex64\>\"", Cell["\<\
IEEE single\[Hyphen]precision complex numbers\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complex128\>\"", Cell["\<\
IEEE double\[Hyphen]precision complex numbers\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Complex256\>\"", Cell["\<\
IEEE quad\[Hyphen]precision complex numbers\
\>", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, {Left}}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->19976],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Byte\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 "For any data representation element ",
 Cell[BoxData[
  StyleBox["type", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
 " can be used as a shorthand for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Binary\>\"", ",", 
       StyleBox["type", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->1374100664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " of real numbers returns ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " for IEEE \"infinity\", and ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " for IEEE \"not\[Hyphen]a\[Hyphen]number\". "
}], "FormatNotes",
 CellID->1851343939],

Cell["\<\
Trailing bytes are ignored if the size of the imported file is not a multiple \
of the data size.\
\>", "FormatNotes",
 CellID->647021390]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell["General option:", "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["what byte ordering to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2140947909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902],

Cell["Data representation option:", "FormatNotes",
 CellID->402223427],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DataFormat\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "specifies a compound object as a list of basic data types ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["type", "TI"], 
         StyleBox["1", "TR"]], ",", " ", 
        SubscriptBox[
         StyleBox["type", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2038100480],

Cell[TextData[{
 "With a setting ",
 Cell[BoxData[
  RowBox[{"\"\<DataFormat\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["type", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["type", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " interpret a raw binary file as a sequence of objects of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["type", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["type", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1842601635],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Binary\>\"", ",", 
    RowBox[{"\"\<DataFormat\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<Character8\>\"", ",", "\"\<Integer32\>\""}], "}"}]}]}], 
   "]"}]], "InlineFormula"],
 " reads ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 " as an alternating sequence of 8-bit characters and 32-bit integers."
}], "FormatNotes",
 CellID->1990597710]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BinaryRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryRead"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["BinaryReadList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryReadList"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["BinaryWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinaryWrite"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Bit\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Bit"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Byte\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Byte"]], "InlineFormula"]
}], "SeeAlso",
 CellID->607967296]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28203978],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->307329942],

Cell["\<\
Convert a string of characters to a list of byte-valued integers:\
\>", "ExampleText",
 CellID->1560934048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<ABCDE\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Binary\>\"", ",", "\"\<Byte\>\""}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->379151446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"65", ",", "66", ",", "67", ",", "68", ",", "69"}], "}"}]], "Output",\

 CellLabel->"Out[1]=",
 CellID->814372273]
}, Open  ]],

Cell[TextData[{
 "The format specification ",
 Cell[BoxData[
  RowBox[{"\"\<Binary\>\"", " "}]], "InlineFormula"],
 "can be omitted when importing elementary data types:"
}], "ExampleText",
 CellID->958312984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<ABCDE\>\"", ",", "\"\<Byte\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1241509980],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"65", ",", "66", ",", "67", ",", "68", ",", "69"}], "}"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->1107119608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->238969588],

Cell["\<\
Export pairs of integers and reals to a binary sequence of 8-bit integers and \
double-precision reals:\
\>", "ExampleText",
 CellID->333225552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", " ", "=", " ", 
  RowBox[{"ExportString", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "343.13"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"2", ",", "232.33"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"3", ",", "210.01"}], "}"}]}], "}"}], ",", " ", 
    "\"\<Binary\>\"", ",", " ", 
    RowBox[{"\"\<DataFormat\>\"", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Integer8\>\"", ",", " ", "\"\<Real64\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->702091319],

Cell[BoxData["\<\"\.01\[RegisteredTrademark]G\[AAcute]z\.14ru@\.02\
\[CapitalATilde]\[OTilde](\\\\\.8f\\nm@\.03\.b8\.1e\.85\[EDoubleDot]Q@j@\"\>"]\
, "Output",
 CellLabel->"Out[1]=",
 CellID->585136460]
}, Open  ]],

Cell["Convert the previous output back to an array of numbers:", "ExampleText",
 CellID->933502626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"ImportString", "[", " ", 
   RowBox[{"b", ",", "  ", "\"\<Binary\>\"", ",", " ", 
    RowBox[{"\"\<DataFormat\>\"", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Integer8\>\"", ",", " ", "\"\<Real64\>\""}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->651398048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "343.13`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "232.33`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "210.01`"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1060863607]
}, Open  ]],

Cell["Verify that each number pair was converted to 1+8 bytes:", "ExampleText",
 CellID->367274275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "b", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1049345554],

Cell[BoxData["27"], "Output",
 CellLabel->"Out[3]=",
 CellID->1525405455]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Binary - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 54.3697322}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran", "IEEE 754"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Sequence of binary data objects. Binary format. Stores a uniform \
sequence of simple or compound data types.", "synonyms" -> {}, "title" -> 
    "Binary", "type" -> "Format", "uri" -> "ref/format/Binary"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18504, 623, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23089, 792}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1757, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2380, 68, 52, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2435, 71, 157, 5, 70, "FormatUsage",
 CellID->37585799],
Cell[2595, 78, 247, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[2845, 87, 256, 8, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[3138, 100, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3205, 103, 326, 11, 70, "FormatNotes",
 CellID->28652],
Cell[3534, 116, 370, 12, 70, "FormatNotes",
 CellID->8194],
Cell[3907, 130, 189, 5, 70, "FormatNotes",
 CellID->236987809],
Cell[4099, 137, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4141, 140, 692, 24, 70, "FormatNotes",
 CellID->29174],
Cell[4836, 166, 624, 22, 70, "FormatNotes",
 CellID->943],
Cell[5463, 190, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[5504, 193, 638, 22, 70, "FormatNotes",
 CellID->20289],
Cell[6145, 217, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[6186, 220, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[6550, 236, 344, 12, 70, "FormatNotes",
 CellID->31450],
Cell[6897, 250, 388, 12, 70, "FormatNotes",
 CellID->1665888954]
}, Closed]],
Cell[CellGroupData[{
Cell[7322, 267, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[7381, 270, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[7580, 280, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[8275, 296, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[8319, 299, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[8394, 302, 3127, 61, 70, "2ColumnTableMod",
 CellID->19976],
Cell[11524, 365, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[11914, 382, 760, 27, 70, "FormatNotes",
 CellID->1374100664],
Cell[12677, 411, 529, 17, 70, "FormatNotes",
 CellID->1851343939],
Cell[13209, 430, 148, 4, 70, "FormatNotes",
 CellID->647021390]
}, Open  ]],
Cell[CellGroupData[{
Cell[13394, 439, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[13450, 442, 58, 1, 70, "FormatNotes",
 CellID->577662107],
Cell[13511, 445, 461, 12, 70, "3ColumnTableMod",
 CellID->2140947909],
Cell[13975, 459, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[14160, 468, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902],
Cell[14556, 479, 70, 1, 70, "FormatNotes",
 CellID->402223427],
Cell[14629, 482, 821, 23, 70, "3ColumnTableMod",
 CellID->2038100480],
Cell[15453, 507, 984, 36, 70, "FormatNotes",
 CellID->1842601635],
Cell[16440, 545, 567, 17, 70, "FormatNotes",
 CellID->1990597710]
}, Closed]],
Cell[CellGroupData[{
Cell[17044, 567, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[17102, 570, 1014, 34, 70, "SeeAlso",
 CellID->607967296]
}, Open  ]],
Cell[CellGroupData[{
Cell[18153, 609, 57, 1, 70, "MoreAboutSection",
 CellID->28203978],
Cell[18213, 612, 117, 2, 70, "MoreAbout"],
Cell[18333, 616, 134, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18504, 623, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18620, 629, 60, 1, 70, "ExampleSection",
 CellID->307329942],
Cell[18683, 632, 117, 3, 70, "ExampleText",
 CellID->1560934048],
Cell[CellGroupData[{
Cell[18825, 639, 218, 7, 70, "Input",
 CellID->379151446],
Cell[19046, 648, 153, 5, 70, "Output",
 CellID->814372273]
}, Open  ]],
Cell[19214, 656, 209, 6, 70, "ExampleText",
 CellID->958312984],
Cell[CellGroupData[{
Cell[19448, 666, 155, 4, 70, "Input",
 CellID->1241509980],
Cell[19606, 672, 154, 5, 70, "Output",
 CellID->1107119608]
}, Open  ]],
Cell[19775, 680, 125, 3, 70, "ExampleDelimiter",
 CellID->238969588],
Cell[19903, 685, 154, 4, 70, "ExampleText",
 CellID->333225552],
Cell[CellGroupData[{
Cell[20082, 693, 602, 18, 70, "Input",
 CellID->702091319],
Cell[20687, 713, 202, 4, 70, "Output",
 CellID->585136460]
}, Open  ]],
Cell[20904, 720, 99, 1, 70, "ExampleText",
 CellID->933502626],
Cell[CellGroupData[{
Cell[21028, 725, 332, 9, 70, "Input",
 CellID->651398048],
Cell[21363, 736, 292, 10, 70, "Output",
 CellID->1060863607]
}, Open  ]],
Cell[21670, 749, 99, 1, 70, "ExampleText",
 CellID->367274275],
Cell[CellGroupData[{
Cell[21794, 754, 109, 3, 70, "Input",
 CellID->1049345554],
Cell[21906, 759, 73, 2, 70, "Output",
 CellID->1525405455]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[22018, 766, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

