(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17099,        592]
NotebookOptionsPosition[     13278,        469]
NotebookOutlinePosition[     14655,        507]
CellTagsIndexPosition[     14570,        502]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"ICO\"" :> Documentation`HelpLookup["paclet:ref/format/ICO"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"ICO\\\"\"\>", 3->"\<\"\\\"PNG\\\"\"\>", 
       4->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemsAndUtilityFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"New in 6.0: Import & Export Formats\"\>", 
       3->"\<\"Raster Image Formats\"\>", 
       4->"\<\"Systems & Utility Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "CUR ",
 StyleBox["(.cur)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell["\<\
Microsoft Windows cursor.
Raster image file format.
Native cursor format on Windows.
CUR is an acronym derived from Cursor.
Binary format.
Can store multiple cursors at different color resolutions.
Supports alpha channels.
Similar to ICO format.\
\>", "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the CUR format."
}], "FormatNotes",
 CellID->5055]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cur\>\"", "]"}]], "InlineFormula"],
 " imports a CUR file, returning a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->8922],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cur\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of RGB color values."
}], "FormatNotes",
 CellID->10986],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cur\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "CUR",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cur\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).cur\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<CUR\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<CUR\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the CUR format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values for each cursor", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<GraphicsList\>\"", Cell["", "TableText"]}], Cell[
    "cursors given as a list of graphics objects", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->16955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects for each cursor"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<GraphicsList\>\""], "InlineFormula"],
 " element for CUR files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->450361849],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "number of bits used to represent each color channel", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", Cell[
    "color encoding used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1499224115]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ICO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ICO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->35129653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "@", 
  RowBox[{"Import", "[", "\"\<ExampleData/arrow.cur\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJmYGBQgGIWIP7///8oHsWjmATMZ8r1H4bpbXeGn/j/+niZ/0k+
ogNi/85ujf/X1+gOiP318bL/n+zS/7+pV31A/H54su7/Fwf0/7ekyNLcfndT
fhQ7qpOk/j/Yqvd/9yQNuvi9JVnmf5ynCNyuTX0q/58d0vvfny1PF/uPTtP5
P79e8X9tkjTYviA74f97p9DH7yB8ernGfxDeN0cd7AY/JwGwG0AYOf/Tyj0g
ux8e0IVjmDvqgHkARMPcQUv/f7w/A4xB9j89ogsOj/Z8mf8+FgI0jwe4/Xe6
/r895wB2w67Z6mD/0yMNwO2/1/7/3Tn9/2dWav3PD5Gga/oD2f/4sM7/G9t0
/0/KV6JrmQez/852vf/NifQJc3T7H+7X+V8QLDkgZT3I/soY6QGxG4RXNqgN
mN0gPJB2j+JRPIrpgwHTSJ0A
   "], {{0, 0}, {32, 32}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{32, 32},
  PlotRange->{{0, 32}, {0, 32}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1832689852]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CUR - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 48, 59.9480000}", "context" -> "", 
    "keywords" -> {"Microsoft", "Windows"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Microsoft Windows cursor. Raster image file format. Native cursor format \
on Windows. CUR is an acronym derived from Cursor. Binary format. Can store \
multiple cursors at different color resolutions. Supports alpha channels. \
Similar to ICO format.", "synonyms" -> {}, "title" -> "CUR", "type" -> 
    "Format", "uri" -> "ref/format/CUR"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12171, 430, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14436, 495}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2020, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2643, 73, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[2747, 79, 292, 10, 70, "FormatUsage",
 CellID->10168],
Cell[3042, 91, 199, 7, 70, "FormatNotes",
 CellID->5055]
}, Open  ]],
Cell[CellGroupData[{
Cell[3278, 103, 52, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[3333, 106, 410, 14, 70, "FormatNotes",
 CellID->8922],
Cell[3746, 122, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[3787, 125, 752, 26, 70, "FormatNotes",
 CellID->10986],
Cell[4542, 153, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[4584, 156, 351, 13, 70, "FormatNotes",
 CellID->26517],
Cell[4938, 171, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[5515, 193, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[6100, 216, 697, 25, 70, "FormatNotes",
 CellID->5874],
Cell[6800, 243, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[6841, 246, 230, 8, 70, "FormatNotes",
 CellID->9815],
Cell[7074, 256, 206, 7, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[7317, 268, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[7369, 271, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[7563, 281, 711, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[8277, 297, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[8319, 300, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[8390, 303, 546, 12, 70, "2ColumnTableMod",
 CellID->16955],
Cell[8939, 317, 531, 15, 70, "2ColumnTableMod",
 CellID->23183],
Cell[9473, 334, 274, 9, 70, "FormatNotes",
 CellID->8394],
Cell[9750, 345, 197, 8, 70, "FormatNotes",
 CellID->450361849],
Cell[9950, 355, 632, 13, 70, "2ColumnTableMod",
 CellID->1499224115]
}, Open  ]],
Cell[CellGroupData[{
Cell[10619, 373, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[10672, 376, 795, 27, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[11504, 408, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[11565, 411, 133, 2, 70, "MoreAbout"],
Cell[11701, 415, 156, 2, 70, "MoreAbout"],
Cell[11860, 419, 130, 2, 70, "MoreAbout"],
Cell[11993, 423, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12171, 430, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[12287, 436, 59, 1, 70, "ExampleSection",
 CellID->35129653],
Cell[CellGroupData[{
Cell[12371, 441, 153, 4, 70, "Input",
 CellID->27432],
Cell[12527, 447, 685, 15, 70, "Output",
 CellID->1832689852]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[13251, 467, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

