(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20028,        717]
NotebookOptionsPosition[     15215,        561]
NotebookOutlinePosition[     16615,        600]
CellTagsIndexPosition[     16530,        595]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Importing & Exporting Database Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/ImportingAndExportingDatabaseFormats"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "New in 6.0: Import & Export Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Importing & Exporting\"\>", 
      2->"\<\"Importing & Exporting Database Formats\"\>", 
      3->"\<\"Listing of All Formats\"\>", 
      4->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more about\"\>",
       
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "DBF ",
 StyleBox["(.dbf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME types: ",
 StyleBox["application/dbf, application/dbase", "InlineCode"],
 "\ndBASE DBF data files.\nLegacy file format for storing and exchanging \
structured data.\nASCII format.\nNative format of the dBASE database \
management application.\nStores numerical datasets in a portable format.\n\
dBASE IV was introduced in 1988."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the DBF format Version 4 and later."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", "]"}]], "InlineFormula"],
 " imports a DBF file, returning all datasets arranged as a table."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a table, with each column representing a datasets."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 "DBF data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ",",
 " ",
 "and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a DBF file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<DBF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<DBF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "DBF",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "datasets arranged as a table", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LabeledData\>\"", Cell[
    "datasets given as a list of rules", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", "]"}]], "InlineFormula"],
 "reads all datasets and returns them as a table."
}], "FormatNotes",
 CellID->676807488],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dbf\>\"", ",", " ", "\"\<LabeledData\>\""}], 
   "]"}]], "InlineFormula"],
 "imports the entire file and returns an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], " ", "->", " ", 
     SubscriptBox[
      StyleBox["col", "TI"], 
      StyleBox["1", "TR"]]}], ",", " ", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], " ", "->", " ", 
     SubscriptBox[
      StyleBox["col", "TI"], 
      StyleBox["2", "TR"]]}], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are the table headings."
}], "FormatNotes",
 CellID->729329788],

Cell["Meta-information elements:", "FormatNotes",
 CellID->301601943],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Labels\>\"", Cell[
    "dataset names given as a list of strings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->962449081],

Cell["The DBF format can store labels of length 10 or shorter.", "FormatNotes",
 CellID->1719857474]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica", "TI"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting Database Formats",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExportingDatabaseFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->145848295],

Cell[TextData[{
 "Get the list of available ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " formats:"
}], "ExampleText",
 CellID->749608832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/planets.dbf\>\"", " ", ",", " ", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1536566122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"LabeledData\"\>", ",", "\<\"Labels\"\>"}],
   "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1311640188]
}, Open  ]],

Cell["Import data from a DBF file:", "ExampleText",
 CellID->1526565046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", "\"\<ExampleData/planets.dbf\>\"", " ", "]"}], 
  " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->976592890],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Mercury\"\>", "4880"},
    {"\<\"Venus\"\>", "12103"},
    {"\<\"Earth\"\>", "12756"},
    {"\<\"Mars\"\>", "6794"},
    {"\<\"Jupiter\"\>", "142984"},
    {"\<\"Saturn\"\>", "120536"},
    {"\<\"Uranus\"\>", "51118"},
    {"\<\"Neptune\"\>", "49528"},
    {"\<\"Pluto\"\>", "2340"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$180]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->613590770]
}, Open  ]],

Cell["Import the column labels as a list of strings:", "ExampleText",
 CellID->617189006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/planets.dbf\>\"", " ", ",", " ", "\"\<Labels\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1304619571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PLANET\"\>", ",", "\<\"DIAM/KM\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->817003261]
}, Open  ]],

Cell["\<\
Read this file as a list of labeled datasets, giving a rule for each column:\
\>", "ExampleText",
 CellID->991597413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/planets.dbf\>\"", " ", ",", " ", "\"\<LabeledData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->374393204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"PLANET\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Mercury\"\>", ",", "\<\"Venus\"\>", ",", "\<\"Earth\"\>", 
      ",", "\<\"Mars\"\>", ",", "\<\"Jupiter\"\>", ",", "\<\"Saturn\"\>", 
      ",", "\<\"Uranus\"\>", ",", "\<\"Neptune\"\>", ",", "\<\"Pluto\"\>"}], 
     "}"}]}], ",", 
   RowBox[{"\<\"DIAM/KM\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "4880", ",", "12103", ",", "12756", ",", "6794", ",", "142984", ",", 
      "120536", ",", "51118", ",", "49528", ",", "2340"}], "}"}]}]}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->363368709]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DBF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 0.2448826}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME types: application/dbf, application/dbase dBASE DBF data files. \
Legacy file format for storing and exchanging structured data. ASCII format. \
Native format of the dBASE database management application. Stores numerical \
datasets in a portable format. dBASE IV was introduced in 1988.", 
    "synonyms" -> {}, "title" -> "DBF", "type" -> "Format", "uri" -> 
    "ref/format/DBF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11750, 426, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16396, 588}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1184, 26, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1807, 53, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[1917, 59, 389, 8, 70, "FormatUsage",
 CellID->37585799],
Cell[2309, 69, 224, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[2570, 81, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[2626, 84, 310, 9, 70, "FormatNotes",
 CellID->28652],
Cell[2939, 95, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[2981, 98, 326, 10, 70, "FormatNotes",
 CellID->28396],
Cell[3310, 110, 587, 23, 70, "FormatNotes",
 CellID->373727629],
Cell[3900, 135, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[3942, 138, 341, 11, 70, "FormatNotes",
 CellID->29174],
Cell[4286, 151, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[4863, 173, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[5446, 196, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[6152, 223, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[6193, 226, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[6432, 237, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[6685, 251, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[6744, 254, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[6943, 264, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[7618, 279, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[7693, 282, 493, 11, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[8189, 295, 258, 9, 70, "FormatNotes",
 CellID->1999285391],
Cell[8450, 306, 297, 9, 70, "FormatNotes",
 CellID->676807488],
Cell[8750, 317, 1005, 35, 70, "FormatNotes",
 CellID->729329788],
Cell[9758, 354, 69, 1, 70, "FormatNotes",
 CellID->301601943],
Cell[9830, 357, 373, 9, 70, "2ColumnTableMod",
 CellID->962449081],
Cell[10206, 368, 100, 1, 70, "FormatNotes",
 CellID->1719857474]
}, Open  ]],
Cell[CellGroupData[{
Cell[10343, 374, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[10395, 377, 177, 7, 70, "FormatNotes",
 CellID->31322],
Cell[10575, 386, 439, 12, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[11051, 403, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[11112, 406, 134, 2, 70, "MoreAbout"],
Cell[11249, 410, 169, 3, 70, "MoreAbout"],
Cell[11421, 415, 133, 2, 70, "MoreAbout"],
Cell[11557, 419, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11750, 426, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[11866, 432, 60, 1, 70, "ExampleSection",
 CellID->145848295],
Cell[11929, 435, 213, 8, 70, "ExampleText",
 CellID->749608832],
Cell[CellGroupData[{
Cell[12167, 447, 192, 6, 70, "Input",
 CellID->1536566122],
Cell[12362, 455, 172, 5, 70, "Output",
 CellID->1311640188]
}, Open  ]],
Cell[12549, 463, 72, 1, 70, "ExampleText",
 CellID->1526565046],
Cell[CellGroupData[{
Cell[12646, 468, 187, 5, 70, "Input",
 CellID->976592890],
Cell[12836, 475, 853, 25, 70, "Output",
 CellID->613590770]
}, Open  ]],
Cell[13704, 503, 89, 1, 70, "ExampleText",
 CellID->617189006],
Cell[CellGroupData[{
Cell[13818, 508, 190, 6, 70, "Input",
 CellID->1304619571],
Cell[14011, 516, 143, 4, 70, "Output",
 CellID->817003261]
}, Open  ]],
Cell[14169, 523, 127, 3, 70, "ExampleText",
 CellID->991597413],
Cell[CellGroupData[{
Cell[14321, 530, 194, 6, 70, "Input",
 CellID->374393204],
Cell[14518, 538, 631, 16, 70, "Output",
 CellID->363368709]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[15188, 559, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

