(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    443821,       8916]
NotebookOptionsPosition[    438040,       8730]
NotebookOutlinePosition[    439474,       8769]
CellTagsIndexPosition[    439387,       8764]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"OBJ\\\"\"\>", 7->"\<\"\\\"OFF\\\"\"\>", 
       8->"\<\"\\\"POV\\\"\"\>", 9->"\<\"\\\"RIB\\\"\"\>", 
       10->"\<\"\\\"STL\\\"\"\>", 
       11->"\<\"\\\"X3D\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Vector Graphics Formats" :> 
          Documentation`HelpLookup["paclet:guide/VectorGraphicsFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Computational Geometry\"\>", 
       3->"\<\"Graphics Importing & Exporting\"\>", 
       4->"\<\"Importing & Exporting\"\>", 
       5->"\<\"Listing of All Formats\"\>", 
       6->"\<\"Vector Graphics Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "DXF ",
 StyleBox["(.dxf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "MIME types: ",
 StyleBox["image/vnd.dxf", "InlineCode"],
 ", ",
 StyleBox["image/x-dxf", "InlineCode"],
 "\nAutoCAD DXF format.\n3D geometry format.\nCommonly used for the exchange \
of CAD data.\nPlain text ASCII or binary format.\nDXF is an acronym derived \
from Drawing Exchange Format.\nStores a 3D object as a collection of line and \
polygon primitives and their properties.\nIntroduced in 1982."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ASCII DXF format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", "]"}]], "InlineFormula"],
 " imports a DXF file as a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to DXF."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "DXF",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ",\"",
 Cell[BoxData["DXF"], "InlineFormula"],
 "\"] or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<DXF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a DXF file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dxf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "DXF",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "DXF",
     " file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->230773093],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "3D geometry represented as ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineData\>\"", Cell[TextData[{
     "lines represented as lists of indices, referencing the vertices as \
given by the ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
     " element"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointData\>\"", Cell[
    "point data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexColors\>\"", Cell[TextData[{
     "colors associated with each vertex, given as a list of color primitives \
(",
     Cell[BoxData[
      ButtonBox["Import",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Import"]], "InlineFormula"],
     " only)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->9135],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData[
  RowBox[{"\"\<Graphics3D\>\"", " "}]], "InlineFormula"],
 "element by default for ",
 "DXF",
 " files."
}], "FormatNotes",
 CellID->13037],

Cell["Meta-information elements:", "FormatNotes",
 CellID->249669238],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<PlotRange\>\"", Cell["\<\
specifies what range of coordinates to include in the graphics\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ViewPoint\>\"", Cell[
    "coordinates of the view point", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->7836828],

Cell[TextData[{
 "When rendering a ",
 "DXF",
 " color model, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically uses the setting",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1495251562]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30231],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->745425722],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Vector Graphics Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VectorGraphicsFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->531171571],

Cell[TextData[{
 "This imports a DXF example file, rendering it as a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->1964482740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/helicopter.dxf.gz\>\"", ",", " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102859358],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], {}, {
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 3.67}, {-0.01, 13.15, 0.}, {-0.62, 3.69, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 3.67}, {-0.62, 3.69, 0.}, {-0.62, 3.69, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.62, 3.69, 3.67}, {-0.62, 3.69, 0.}, {-0.62, -3.74, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.62, 3.69, 3.67}, {-0.62, -3.74, 0.}, {-0.62, -3.74, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.62, -3.74, 3.67}, {-0.62, -3.74, 0.}, {0.58, -3.74, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.62, -3.74, 3.67}, {0.58, -3.74, 0.}, {0.58, -3.74, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0.58, -3.74, 3.67}, {0.58, -3.74, 0.}, {0.58, 3.69, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0.58, -3.74, 3.67}, {0.58, 3.69, 0.}, {0.58, 3.69, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0.58, 3.69, 3.67}, {0.58, 3.69, 0.}, {-0.01, 13.15, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0.58, 3.69, 3.67}, {-0.01, 13.15, 0.}, {-0.01, 13.15, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 3.67}, {-0.62, 3.69, 3.67}, {-0.62, -3.74, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 0.}, {-0.62, -3.74, 0.}, {-0.62, 3.69, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 3.67}, {-0.62, -3.74, 3.67}, {0.58, -3.74, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 0.}, {0.58, -3.74, 0.}, {-0.62, -3.74, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 3.67}, {0.58, -3.74, 3.67}, {0.58, 3.69, 
      3.67}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.01, 13.15, 0.}, {0.58, 3.69, 0.}, {0.58, -3.74, 
      0.}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {0., -3.32, 3.82}, {1.22, -2.89, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {1.22, -2.89, 3.82}, {1.22, -2.89, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{1.22, -2.89, 6.13}, {1.22, -2.89, 3.82}, {1.84, -2.02, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{1.22, -2.89, 6.13}, {1.84, -2.02, 3.82}, {1.84, -2.02, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{1.84, -2.02, 6.13}, {1.84, -2.02, 3.82}, {2.45, -0.72, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{1.84, -2.02, 6.13}, {2.45, -0.72, 3.82}, {2.45, -0.72, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{2.45, -0.72, 6.13}, {2.45, -0.72, 3.82}, {0.61, 10.06, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{2.45, -0.72, 6.13}, {0.61, 10.06, 3.82}, {0.61, 10.06, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0.61, 10.06, 6.13}, {0.61, 10.06, 3.82}, {-0.59, 10.06, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0.61, 10.06, 6.13}, {-0.59, 10.06, 3.82}, {-0.59, 10.06, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.59, 10.06, 6.13}, {-0.59, 10.06, 3.82}, {-2.43, -0.72, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-0.59, 10.06, 6.13}, {-2.43, -0.72, 3.82}, {-2.43, -0.72, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-2.43, -0.72, 6.13}, {-2.43, -0.72, 3.82}, {-1.82, -2.02, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-2.43, -0.72, 6.13}, {-1.82, -2.02, 3.82}, {-1.82, -2.02, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-1.82, -2.02, 6.13}, {-1.82, -2.02, 3.82}, {-1.2, -2.89, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-1.82, -2.02, 6.13}, {-1.2, -2.89, 3.82}, {-1.2, -2.89, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-1.2, -2.89, 6.13}, {-1.2, -2.89, 3.82}, {0., -3.32, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{-1.2, -2.89, 6.13}, {0., -3.32, 3.82}, {0., -3.32, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {1.22, -2.89, 6.13}, {1.84, -2.02, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {1.84, -2.02, 3.82}, {1.22, -2.89, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {1.84, -2.02, 6.13}, {2.45, -0.72, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {2.45, -0.72, 3.82}, {1.84, -2.02, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {2.45, -0.72, 6.13}, {0.61, 10.06, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {0.61, 10.06, 3.82}, {2.45, -0.72, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {0.61, 10.06, 6.13}, {-0.59, 10.06, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {-0.59, 10.06, 3.82}, {0.61, 10.06, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {-0.59, 10.06, 6.13}, {-2.43, -0.72, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {-2.43, -0.72, 3.82}, {-0.59, 10.06, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {-2.43, -0.72, 6.13}, {-1.82, -2.02, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {-1.82, -2.02, 3.82}, {-2.43, -0.72, 
      3.82}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 6.13}, {-1.82, -2.02, 6.13}, {-1.2, -2.89, 
      6.13}}]}, 
    {RGBColor[1., 0., 0.], 
     Polygon3DBox[{{0., -3.32, 3.82}, {-1.2, -2.89, 3.82}, {-1.82, -2.02, 
      3.82}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {1.11, 0., 8.1}, {1.04, 0.35, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.11, 0., 8.1}, {1.89, 0.01, 7.73}, {1.79, 0.6, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.11, 0., 8.1}, {1.79, 0.6, 7.73}, {1.04, 0.35, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.89, 0.01, 7.73}, {2.66, 0.02, 7.16}, {2.53, 0.84, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.89, 0.01, 7.73}, {2.53, 0.84, 7.16}, {1.79, 0.6, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.66, 0.02, 7.16}, {0., 0., 7.16}, {2.53, 0.84, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {1.04, 0.35, 8.1}, {0.89, 0.66, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.04, 0.35, 8.1}, {1.79, 0.6, 7.73}, {1.52, 1.13, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.04, 0.35, 8.1}, {1.52, 1.13, 7.73}, {0.89, 0.66, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.79, 0.6, 7.73}, {2.53, 0.84, 7.16}, {2.15, 1.58, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.79, 0.6, 7.73}, {2.15, 1.58, 7.16}, {1.52, 1.13, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.53, 0.84, 7.16}, {0., 0., 7.16}, {2.15, 1.58, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0.89, 0.66, 8.1}, {0.64, 0.9, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.89, 0.66, 8.1}, {1.52, 1.13, 7.73}, {1.09, 1.54, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.89, 0.66, 8.1}, {1.09, 1.54, 7.73}, {0.64, 0.9, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.52, 1.13, 7.73}, {2.15, 1.58, 7.16}, {1.54, 2.17, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.52, 1.13, 7.73}, {1.54, 2.17, 7.16}, {1.09, 1.54, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.15, 1.58, 7.16}, {0., 0., 7.16}, {1.54, 2.17, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0.64, 0.9, 8.1}, {0.33, 1.07, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.64, 0.9, 8.1}, {1.09, 1.54, 7.73}, {0.57, 1.8, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.64, 0.9, 8.1}, {0.57, 1.8, 7.73}, {0.33, 1.07, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.09, 1.54, 7.73}, {1.54, 2.17, 7.16}, {0.8, 2.54, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.09, 1.54, 7.73}, {0.8, 2.54, 7.16}, {0.57, 1.8, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.54, 2.17, 7.16}, {0., 0., 7.16}, {0.8, 2.54, 7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0.33, 1.07, 8.1}, {0., 1.11, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.33, 1.07, 8.1}, {0.57, 1.8, 7.73}, {-0.01, 1.89, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.33, 1.07, 8.1}, {-0.01, 1.89, 7.73}, {0., 1.11, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.57, 1.8, 7.73}, {0.8, 2.54, 7.16}, {-0.01, 2.66, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.57, 1.8, 7.73}, {-0.01, 2.66, 7.16}, {-0.01, 1.89, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.8, 2.54, 7.16}, {0., 0., 7.16}, {-0.01, 2.66, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0., 1.11, 8.1}, {-0.35, 1.04, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 1.11, 8.1}, {-0.01, 1.89, 7.73}, {-0.58, 1.79, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 1.11, 8.1}, {-0.58, 1.79, 7.73}, {-0.35, 1.04, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.01, 1.89, 7.73}, {-0.01, 2.66, 7.16}, {-0.84, 2.53, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.01, 1.89, 7.73}, {-0.84, 2.53, 7.16}, {-0.58, 1.79, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.01, 2.66, 7.16}, {0., 0., 7.16}, {-0.84, 2.53, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-0.35, 1.04, 8.1}, {-0.66, 0.89, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.35, 1.04, 8.1}, {-0.58, 1.79, 7.73}, {-1.12, 1.52, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.35, 1.04, 8.1}, {-1.12, 1.52, 7.73}, {-0.66, 0.89, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.58, 1.79, 7.73}, {-0.84, 2.53, 7.16}, {-1.58, 2.15, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.58, 1.79, 7.73}, {-1.58, 2.15, 7.16}, {-1.12, 1.52, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.84, 2.53, 7.16}, {0., 0., 7.16}, {-1.58, 2.15, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-0.66, 0.89, 8.1}, {-0.9, 0.64, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.66, 0.89, 8.1}, {-1.12, 1.52, 7.73}, {-1.54, 1.09, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.66, 0.89, 8.1}, {-1.54, 1.09, 7.73}, {-0.9, 0.64, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.12, 1.52, 7.73}, {-1.58, 2.15, 7.16}, {-2.17, 1.55, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.12, 1.52, 7.73}, {-2.17, 1.55, 7.16}, {-1.54, 1.09, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.58, 2.15, 7.16}, {0., 0., 7.16}, {-2.17, 1.55, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-0.9, 0.64, 8.1}, {-1.04, 0.33, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.9, 0.64, 8.1}, {-1.54, 1.09, 7.73}, {-1.8, 0.57, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.9, 0.64, 8.1}, {-1.8, 0.57, 7.73}, {-1.04, 0.33, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.09, 7.73}, {-2.17, 1.55, 7.16}, {-2.54, 0.8, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.09, 7.73}, {-2.54, 0.8, 7.16}, {-1.8, 0.57, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.17, 1.55, 7.16}, {0., 0., 7.16}, {-2.54, 0.8, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-1.04, 0.33, 8.1}, {-1.11, 0., 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.04, 0.33, 8.1}, {-1.8, 0.57, 7.73}, {-1.89, 0., 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.04, 0.33, 8.1}, {-1.89, 0., 7.73}, {-1.11, 0., 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.8, 0.57, 7.73}, {-2.54, 0.8, 7.16}, {-2.66, -0.01, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.8, 0.57, 7.73}, {-2.66, -0.01, 7.16}, {-1.89, 0., 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.54, 0.8, 7.16}, {0., 0., 7.16}, {-2.66, -0.01, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-1.11, 0., 8.1}, {-1.04, -0.35, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.11, 0., 8.1}, {-1.89, 0., 7.73}, {-1.79, -0.58, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.11, 0., 8.1}, {-1.79, -0.58, 7.73}, {-1.04, -0.35, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.89, 0., 7.73}, {-2.66, -0.01, 7.16}, {-2.54, -0.84, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.89, 0., 7.73}, {-2.54, -0.84, 7.16}, {-1.79, -0.58, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.66, -0.01, 7.16}, {0., 0., 7.16}, {-2.54, -0.84, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-1.04, -0.35, 8.1}, {-0.89, -0.66, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.04, -0.35, 8.1}, {-1.79, -0.58, 7.73}, {-1.52, -1.12, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.04, -0.35, 8.1}, {-1.52, -1.12, 7.73}, {-0.89, -0.66, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.79, -0.58, 7.73}, {-2.54, -0.84, 7.16}, {-2.15, -1.58, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.79, -0.58, 7.73}, {-2.15, -1.58, 7.16}, {-1.52, -1.12, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.54, -0.84, 7.16}, {0., 0., 7.16}, {-2.15, -1.58, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-0.89, -0.66, 8.1}, {-0.64, -0.9, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.89, -0.66, 8.1}, {-1.52, -1.12, 7.73}, {-1.09, -1.53, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.89, -0.66, 8.1}, {-1.09, -1.53, 7.73}, {-0.64, -0.9, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.52, -1.12, 7.73}, {-2.15, -1.58, 7.16}, {-1.55, -2.17, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.52, -1.12, 7.73}, {-1.55, -2.17, 7.16}, {-1.09, -1.53, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.15, -1.58, 7.16}, {0., 0., 7.16}, {-1.55, -2.17, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-0.64, -0.9, 8.1}, {-0.33, -1.04, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.64, -0.9, 8.1}, {-1.09, -1.53, 7.73}, {-0.57, -1.8, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.64, -0.9, 8.1}, {-0.57, -1.8, 7.73}, {-0.33, -1.04, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.09, -1.53, 7.73}, {-1.55, -2.17, 7.16}, {-0.8, -2.54, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.09, -1.53, 7.73}, {-0.8, -2.54, 7.16}, {-0.57, -1.8, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.55, -2.17, 7.16}, {0., 0., 7.16}, {-0.8, -2.54, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {-0.33, -1.04, 8.1}, {0., -1.11, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.33, -1.04, 8.1}, {-0.57, -1.8, 7.73}, {0., -1.89, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.33, -1.04, 8.1}, {0., -1.89, 7.73}, {0., -1.11, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.57, -1.8, 7.73}, {-0.8, -2.54, 7.16}, {0.01, -2.66, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.57, -1.8, 7.73}, {0.01, -2.66, 7.16}, {0., -1.89, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.8, -2.54, 7.16}, {0., 0., 7.16}, {0.01, -2.66, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0., -1.11, 8.1}, {0.35, -1.04, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., -1.11, 8.1}, {0., -1.89, 7.73}, {0.58, -1.79, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., -1.11, 8.1}, {0.58, -1.79, 7.73}, {0.35, -1.04, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., -1.89, 7.73}, {0.01, -2.66, 7.16}, {0.83, -2.54, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., -1.89, 7.73}, {0.83, -2.54, 7.16}, {0.58, -1.79, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.01, -2.66, 7.16}, {0., 0., 7.16}, {0.83, -2.54, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0.35, -1.04, 8.1}, {0.66, -0.89, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.35, -1.04, 8.1}, {0.58, -1.79, 7.73}, {1.12, -1.52, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.35, -1.04, 8.1}, {1.12, -1.52, 7.73}, {0.66, -0.89, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.58, -1.79, 7.73}, {0.83, -2.54, 7.16}, {1.58, -2.15, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.58, -1.79, 7.73}, {1.58, -2.15, 7.16}, {1.12, -1.52, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.83, -2.54, 7.16}, {0., 0., 7.16}, {1.58, -2.15, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0.66, -0.89, 8.1}, {0.9, -0.64, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.66, -0.89, 8.1}, {1.12, -1.52, 7.73}, {1.53, -1.1, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.66, -0.89, 8.1}, {1.53, -1.1, 7.73}, {0.9, -0.64, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.12, -1.52, 7.73}, {1.58, -2.15, 7.16}, {2.17, -1.55, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.12, -1.52, 7.73}, {2.17, -1.55, 7.16}, {1.53, -1.1, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.58, -2.15, 7.16}, {0., 0., 7.16}, {2.17, -1.55, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {0.9, -0.64, 8.1}, {1.04, -0.33, 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.9, -0.64, 8.1}, {1.53, -1.1, 7.73}, {1.8, -0.57, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.9, -0.64, 8.1}, {1.8, -0.57, 7.73}, {1.04, -0.33, 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.53, -1.1, 7.73}, {2.17, -1.55, 7.16}, {2.54, -0.8, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.53, -1.1, 7.73}, {2.54, -0.8, 7.16}, {1.8, -0.57, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.17, -1.55, 7.16}, {0., 0., 7.16}, {2.54, -0.8, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0., 0., 8.3}, {1.04, -0.33, 8.1}, {1.11, 0., 8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.04, -0.33, 8.1}, {1.8, -0.57, 7.73}, {1.89, 0.01, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.04, -0.33, 8.1}, {1.89, 0.01, 7.73}, {1.11, 0., 
      8.1}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.8, -0.57, 7.73}, {2.54, -0.8, 7.16}, {2.66, 0.02, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.8, -0.57, 7.73}, {2.66, 0.02, 7.16}, {1.89, 0.01, 
      7.73}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.54, -0.8, 7.16}, {0., 0., 7.16}, {2.66, 0.02, 
      7.16}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -0.84, 6.86}, {-0.15, -0.84, 6.89}, {0.16, -1.37, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -0.84, 6.86}, {0.16, -1.37, 6.89}, {0.16, -1.37, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -1.37, 6.86}, {0.16, -1.37, 6.89}, {0.16, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -1.37, 6.86}, {0.16, -2.42, 6.89}, {0.16, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {0.16, -2.42, 6.89}, {0.52, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {0.52, -2.42, 6.89}, {0.52, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.52, -2.42, 6.86}, {0.52, -2.42, 6.89}, {0.52, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.52, -2.42, 6.86}, {0.52, -2.96, 6.89}, {0.52, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.52, -2.96, 6.86}, {0.52, -2.96, 6.89}, {0.16, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.52, -2.96, 6.86}, {0.16, -2.96, 6.89}, {0.16, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.86}, {0.16, -2.96, 6.89}, {0.88, -5.09, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.86}, {0.88, -5.09, 6.89}, {0.88, -5.09, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.88, -5.09, 6.86}, {0.88, -5.09, 6.89}, {
      0.88, -30.559999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.88, -5.09, 6.86}, {0.88, -30.559999, 6.89}, {
      0.88, -30.559999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.88, -30.559999, 6.86}, {0.88, -30.559999, 6.89}, {
      0.52, -31.09, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.88, -30.559999, 6.86}, {0.52, -31.09, 6.89}, {
      0.52, -31.09, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.52, -31.09, 6.86}, {0.52, -31.09, 6.89}, {-0.51, -31.09,
       6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.52, -31.09, 6.86}, {-0.51, -31.09, 
      6.89}, {-0.51, -31.09, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.51, -31.09, 6.86}, {-0.51, -31.09, 
      6.89}, {-0.87, -30.559999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.51, -31.09, 6.86}, {-0.87, -30.559999, 
      6.89}, {-0.87, -30.559999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.87, -30.559999, 6.86}, {-0.87, -30.559999, 
      6.89}, {-0.87, -5.09, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.87, -30.559999, 6.86}, {-0.87, -5.09, 
      6.89}, {-0.87, -5.09, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.87, -5.09, 6.86}, {-0.87, -5.09, 6.89}, {-0.15, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.87, -5.09, 6.86}, {-0.15, -2.96, 6.89}, {-0.15, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.86}, {-0.15, -2.96, 6.89}, {-0.51, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.86}, {-0.51, -2.96, 6.89}, {-0.51, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.51, -2.96, 6.86}, {-0.51, -2.96, 6.89}, {-0.51, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.51, -2.96, 6.86}, {-0.51, -2.42, 6.89}, {-0.51, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.51, -2.42, 6.86}, {-0.51, -2.42, 6.89}, {-0.15, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.51, -2.42, 6.86}, {-0.15, -2.42, 6.89}, {-0.15, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.42, 6.86}, {-0.15, -2.42, 6.89}, {-0.15, -0.84, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.42, 6.86}, {-0.15, -0.84, 6.89}, {-0.15, -0.84, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {0.52, -2.42, 6.86}, {0.52, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.89}, {0.52, -2.96, 6.89}, {0.52, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {0.52, -2.96, 6.86}, {0.16, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.89}, {0.16, -2.96, 6.89}, {0.52, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.86}, {0.88, -5.09, 6.86}, {
      0.88, -30.559999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.89}, {0.88, -30.559999, 6.89}, {
      0.88, -5.09, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.86}, {0.88, -30.559999, 6.86}, {
      0.52, -31.09, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.89}, {0.52, -31.09, 6.89}, {
      0.88, -30.559999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.86}, {0.52, -31.09, 6.86}, {-0.51, -31.09, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.96, 6.89}, {-0.51, -31.09, 6.89}, {0.52, -31.09, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {0.16, -2.96, 6.86}, {-0.51, -31.09, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.89}, {-0.51, -31.09, 6.89}, {0.16, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.86}, {-0.51, -2.96, 6.86}, {-0.51, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.89}, {-0.51, -2.42, 6.89}, {-0.51, -2.96, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.86}, {-0.51, -2.42, 6.86}, {-0.15, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.89}, {-0.15, -2.42, 6.89}, {-0.51, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.42, 6.86}, {-0.15, -0.84, 6.86}, {0.16, -1.37, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.42, 6.89}, {0.16, -1.37, 6.89}, {-0.15, -0.84, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.86}, {-0.15, -2.42, 6.86}, {0.16, -1.37, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.89}, {0.16, -1.37, 6.89}, {-0.15, -2.42, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.86}, {0.16, -1.37, 6.86}, {0.16, -2.42, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.15, -2.96, 6.89}, {0.16, -2.42, 6.89}, {0.16, -1.37, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {-0.51, -31.09, 
      6.86}, {-0.87, -30.559999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.89}, {-0.87, -30.559999, 
      6.89}, {-0.51, -31.09, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {-0.87, -30.559999, 
      6.86}, {-0.87, -5.09, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.89}, {-0.87, -5.09, 
      6.89}, {-0.87, -30.559999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.86}, {-0.87, -5.09, 6.86}, {-0.15, -2.96, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.16, -2.42, 6.89}, {-0.15, -2.96, 6.89}, {-0.87, -5.09, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.75, -0.41, 6.86}, {0.75, -0.41, 6.9}, {1.36, -0.23, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.75, -0.41, 6.86}, {1.36, -0.23, 6.9}, {1.36, -0.23, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.36, -0.23, 6.86}, {1.36, -0.23, 6.9}, {2.36, -0.55, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.36, -0.23, 6.86}, {2.36, -0.55, 6.9}, {2.36, -0.55, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {2.36, -0.55, 6.9}, {2.48, -0.21, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {2.48, -0.21, 6.9}, {2.48, -0.21, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.48, -0.21, 6.86}, {2.48, -0.21, 6.9}, {2.98, -0.38, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.48, -0.21, 6.86}, {2.98, -0.38, 6.9}, {2.98, -0.38, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.98, -0.38, 6.86}, {2.98, -0.38, 6.9}, {2.88, -0.72, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.98, -0.38, 6.86}, {2.88, -0.72, 6.9}, {2.88, -0.72, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.86}, {2.88, -0.72, 6.9}, {5.12, -0.69, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.86}, {5.12, -0.69, 6.9}, {5.12, -0.69, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{5.12, -0.69, 6.86}, {5.12, -0.69, 6.9}, {29.35, -8.57, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{5.12, -0.69, 6.86}, {29.35, -8.57, 6.9}, {29.35, -8.57, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{29.35, -8.57, 6.86}, {29.35, -8.57, 6.9}, {29.74, -9.07, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{29.35, -8.57, 6.86}, {29.74, -9.07, 6.9}, {29.74, -9.07, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{29.74, -9.07, 6.86}, {29.74, -9.07, 6.9}, {29.41, -10.09, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{29.74, -9.07, 6.86}, {29.41, -10.09, 6.9}, {29.41, -10.09,
       6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{29.41, -10.09, 6.86}, {29.41, -10.09, 6.9}, {
      28.799999, -10.27, 6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{29.41, -10.09, 6.86}, {28.799999, -10.27, 6.9}, {
      28.799999, -10.27, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{28.799999, -10.27, 6.86}, {28.799999, -10.27, 6.9}, {
      4.57, -2.4, 6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{28.799999, -10.27, 6.86}, {4.57, -2.4, 6.9}, {4.57, -2.4, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{4.57, -2.4, 6.86}, {4.57, -2.4, 6.9}, {2.77, -1.04, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{4.57, -2.4, 6.86}, {2.77, -1.04, 6.9}, {2.77, -1.04, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.86}, {2.77, -1.04, 6.9}, {2.66, -1.4, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.86}, {2.66, -1.4, 6.9}, {2.66, -1.4, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.66, -1.4, 6.86}, {2.66, -1.4, 6.9}, {2.16, -1.22, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.66, -1.4, 6.86}, {2.16, -1.22, 6.9}, {2.16, -1.22, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.16, -1.22, 6.86}, {2.16, -1.22, 6.9}, {2.26, -0.9, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.16, -1.22, 6.86}, {2.26, -0.9, 6.9}, {2.26, -0.9, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.26, -0.9, 6.86}, {2.26, -0.9, 6.9}, {0.75, -0.41, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.26, -0.9, 6.86}, {0.75, -0.41, 6.9}, {0.75, -0.41, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {2.48, -0.21, 6.86}, {2.98, -0.38, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.9}, {2.98, -0.38, 6.9}, {2.48, -0.21, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {2.98, -0.38, 6.86}, {2.88, -0.72, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.9}, {2.88, -0.72, 6.9}, {2.98, -0.38, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.86}, {5.12, -0.69, 6.86}, {29.35, -8.57, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.9}, {29.35, -8.57, 6.9}, {5.12, -0.69, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.86}, {29.35, -8.57, 6.86}, {29.74, -9.07, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.9}, {29.74, -9.07, 6.9}, {29.35, -8.57, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.86}, {29.74, -9.07, 6.86}, {29.41, -10.09, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.88, -0.72, 6.9}, {29.41, -10.09, 6.9}, {29.74, -9.07, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {2.88, -0.72, 6.86}, {29.41, -10.09, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.9}, {29.41, -10.09, 6.9}, {2.88, -0.72, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.86}, {2.66, -1.4, 6.86}, {2.16, -1.22, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.9}, {2.16, -1.22, 6.9}, {2.66, -1.4, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.86}, {2.16, -1.22, 6.86}, {2.26, -0.9, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.9}, {2.26, -0.9, 6.9}, {2.16, -1.22, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.26, -0.9, 6.86}, {0.75, -0.41, 6.86}, {1.36, -0.23, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.26, -0.9, 6.9}, {1.36, -0.23, 6.9}, {0.75, -0.41, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.86}, {2.26, -0.9, 6.86}, {1.36, -0.23, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.9}, {1.36, -0.23, 6.9}, {2.26, -0.9, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.86}, {1.36, -0.23, 6.86}, {2.36, -0.55, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.77, -1.04, 6.9}, {2.36, -0.55, 6.9}, {1.36, -0.23, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {29.41, -10.09, 6.86}, {
      28.799999, -10.27, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.9}, {28.799999, -10.27, 6.9}, {
      29.41, -10.09, 6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {28.799999, -10.27, 6.86}, {
      4.57, -2.4, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.9}, {4.57, -2.4, 6.9}, {28.799999, -10.27, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.86}, {4.57, -2.4, 6.86}, {2.77, -1.04, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.36, -0.55, 6.9}, {2.77, -1.04, 6.9}, {4.57, -2.4, 
      6.9}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.63, 0.58, 6.86}, {0.63, 0.58, 6.89}, {0.67, 1.21, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.63, 0.58, 6.86}, {0.67, 1.21, 6.89}, {0.67, 1.21, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.67, 1.21, 6.86}, {0.67, 1.21, 6.89}, {1.28, 2.06, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.67, 1.21, 6.86}, {1.28, 2.06, 6.89}, {1.28, 2.06, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {1.28, 2.06, 6.89}, {0.99, 2.28, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {0.99, 2.28, 6.89}, {0.99, 2.28, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.99, 2.28, 6.86}, {0.99, 2.28, 6.89}, {1.32, 2.71, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{0.99, 2.28, 6.86}, {1.32, 2.71, 6.89}, {1.32, 2.71, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.32, 2.71, 6.86}, {1.32, 2.71, 6.89}, {1.6, 2.49, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.32, 2.71, 6.86}, {1.6, 2.49, 6.89}, {1.6, 2.49, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.86}, {1.6, 2.49, 6.89}, {2.26, 4.64, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.86}, {2.26, 4.64, 6.89}, {2.26, 4.64, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.26, 4.64, 6.86}, {2.26, 4.64, 6.89}, {17.24, 25.24, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.26, 4.64, 6.86}, {17.24, 25.24, 6.89}, {17.24, 25.24, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{17.24, 25.24, 6.86}, {17.24, 25.24, 6.89}, {17.84, 
      25.459999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{17.24, 25.24, 6.86}, {17.84, 25.459999, 6.89}, {17.84, 
      25.459999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{17.84, 25.459999, 6.86}, {17.84, 25.459999, 6.89}, {
      18.700001, 24.85, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{17.84, 25.459999, 6.86}, {18.700001, 24.85, 6.89}, {
      18.700001, 24.85, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{18.700001, 24.85, 6.86}, {18.700001, 24.85, 6.89}, {18.68,
       24.200001, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{18.700001, 24.85, 6.86}, {18.68, 24.200001, 6.89}, {18.68,
       24.200001, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{18.68, 24.200001, 6.86}, {18.68, 24.200001, 6.89}, {3.7, 
      3.6, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{18.68, 24.200001, 6.86}, {3.7, 3.6, 6.89}, {3.7, 3.6, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{3.7, 3.6, 6.86}, {3.7, 3.6, 6.89}, {1.88, 2.3, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{3.7, 3.6, 6.86}, {1.88, 2.3, 6.89}, {1.88, 2.3, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.86}, {1.88, 2.3, 6.89}, {2.17, 2.08, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.86}, {2.17, 2.08, 6.89}, {2.17, 2.08, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.17, 2.08, 6.86}, {2.17, 2.08, 6.89}, {1.84, 1.65, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{2.17, 2.08, 6.86}, {1.84, 1.65, 6.89}, {1.84, 1.65, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.84, 1.65, 6.86}, {1.84, 1.65, 6.89}, {1.56, 1.87, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.84, 1.65, 6.86}, {1.56, 1.87, 6.89}, {1.56, 1.87, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.56, 1.87, 6.86}, {1.56, 1.87, 6.89}, {0.63, 0.58, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.56, 1.87, 6.86}, {0.63, 0.58, 6.89}, {0.63, 0.58, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {0.99, 2.28, 6.86}, {1.32, 2.71, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.89}, {1.32, 2.71, 6.89}, {0.99, 2.28, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {1.32, 2.71, 6.86}, {1.6, 2.49, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.89}, {1.6, 2.49, 6.89}, {1.32, 2.71, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.86}, {2.26, 4.64, 6.86}, {17.24, 25.24, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.89}, {17.24, 25.24, 6.89}, {2.26, 4.64, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.86}, {17.24, 25.24, 6.86}, {17.84, 25.459999,
       6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.89}, {17.84, 25.459999, 6.89}, {17.24, 25.24,
       6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.86}, {17.84, 25.459999, 6.86}, {18.700001, 
      24.85, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.6, 2.49, 6.89}, {18.700001, 24.85, 6.89}, {17.84, 
      25.459999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {1.6, 2.49, 6.86}, {18.700001, 24.85, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.89}, {18.700001, 24.85, 6.89}, {1.6, 2.49, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.86}, {2.17, 2.08, 6.86}, {1.84, 1.65, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.89}, {1.84, 1.65, 6.89}, {2.17, 2.08, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.86}, {1.84, 1.65, 6.86}, {1.56, 1.87, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.89}, {1.56, 1.87, 6.89}, {1.84, 1.65, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.56, 1.87, 6.86}, {0.63, 0.58, 6.86}, {0.67, 1.21, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.56, 1.87, 6.89}, {0.67, 1.21, 6.89}, {0.63, 0.58, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.86}, {1.56, 1.87, 6.86}, {0.67, 1.21, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.89}, {0.67, 1.21, 6.89}, {1.56, 1.87, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.86}, {0.67, 1.21, 6.86}, {1.28, 2.06, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.88, 2.3, 6.89}, {1.28, 2.06, 6.89}, {0.67, 1.21, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {18.700001, 24.85, 6.86}, {18.68, 
      24.200001, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.89}, {18.68, 24.200001, 6.89}, {18.700001, 
      24.85, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {18.68, 24.200001, 6.86}, {3.7, 3.6, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.89}, {3.7, 3.6, 6.89}, {18.68, 24.200001, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.86}, {3.7, 3.6, 6.86}, {1.88, 2.3, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{1.28, 2.06, 6.89}, {1.88, 2.3, 6.89}, {3.7, 3.6, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.34, 0.78, 6.86}, {-0.34, 0.78, 6.89}, {-0.92, 1.01, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.34, 0.78, 6.86}, {-0.92, 1.01, 6.89}, {-0.92, 1.01, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.92, 1.01, 6.86}, {-0.92, 1.01, 6.89}, {-1.54, 1.87, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.92, 1.01, 6.86}, {-1.54, 1.87, 6.89}, {-1.54, 1.87, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-1.54, 1.87, 6.89}, {-1.83, 1.66, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-1.83, 1.66, 6.89}, {-1.83, 1.66, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.83, 1.66, 6.86}, {-1.83, 1.66, 6.89}, {-2.15, 2.08, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.83, 1.66, 6.86}, {-2.15, 2.08, 6.89}, {-2.15, 2.08, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.15, 2.08, 6.86}, {-2.15, 2.08, 6.89}, {-1.86, 2.31, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.15, 2.08, 6.86}, {-1.86, 2.31, 6.89}, {-1.86, 2.31, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.86}, {-1.86, 2.31, 6.89}, {-3.69, 3.6, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.86}, {-3.69, 3.6, 6.89}, {-3.69, 3.6, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-3.69, 3.6, 6.86}, {-3.69, 3.6, 6.89}, {-18.66, 24.209999,
       6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-3.69, 3.6, 6.86}, {-18.66, 24.209999, 6.89}, {-18.66, 
      24.209999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-18.66, 24.209999, 6.86}, {-18.66, 24.209999, 
      6.89}, {-18.690001, 24.85, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-18.66, 24.209999, 6.86}, {-18.690001, 24.85, 
      6.89}, {-18.690001, 24.85, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-18.690001, 24.85, 6.86}, {-18.690001, 24.85, 
      6.89}, {-17.82, 25.469999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-18.690001, 24.85, 6.86}, {-17.82, 25.469999, 
      6.89}, {-17.82, 25.469999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-17.82, 25.469999, 6.86}, {-17.82, 25.469999, 
      6.89}, {-17.219999, 25.25, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-17.82, 25.469999, 6.86}, {-17.219999, 25.25, 
      6.89}, {-17.219999, 25.25, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-17.219999, 25.25, 6.86}, {-17.219999, 25.25, 
      6.89}, {-2.25, 4.65, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-17.219999, 25.25, 6.86}, {-2.25, 4.65, 6.89}, {-2.25, 
      4.65, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.25, 4.65, 6.86}, {-2.25, 4.65, 6.89}, {-1.59, 2.5, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.25, 4.65, 6.86}, {-1.59, 2.5, 6.89}, {-1.59, 2.5, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.86}, {-1.59, 2.5, 6.89}, {-1.3, 2.71, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.86}, {-1.3, 2.71, 6.89}, {-1.3, 2.71, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.3, 2.71, 6.86}, {-1.3, 2.71, 6.89}, {-0.98, 2.28, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.3, 2.71, 6.86}, {-0.98, 2.28, 6.89}, {-0.98, 2.28, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.98, 2.28, 6.86}, {-0.98, 2.28, 6.89}, {-1.26, 2.07, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.98, 2.28, 6.86}, {-1.26, 2.07, 6.89}, {-1.26, 2.07, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.26, 2.07, 6.86}, {-1.26, 2.07, 6.89}, {-0.34, 0.78, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.26, 2.07, 6.86}, {-0.34, 0.78, 6.89}, {-0.34, 0.78, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-1.83, 1.66, 6.86}, {-2.15, 2.08, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.89}, {-2.15, 2.08, 6.89}, {-1.83, 1.66, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-2.15, 2.08, 6.86}, {-1.86, 2.31, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.89}, {-1.86, 2.31, 6.89}, {-2.15, 2.08, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.86}, {-3.69, 3.6, 6.86}, {-18.66, 
      24.209999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.89}, {-18.66, 24.209999, 6.89}, {-3.69, 
      3.6, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.86}, {-18.66, 24.209999, 
      6.86}, {-18.690001, 24.85, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.89}, {-18.690001, 24.85, 6.89}, {-18.66, 
      24.209999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.86}, {-18.690001, 24.85, 6.86}, {-17.82, 
      25.469999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.86, 2.31, 6.89}, {-17.82, 25.469999, 
      6.89}, {-18.690001, 24.85, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-1.86, 2.31, 6.86}, {-17.82, 
      25.469999, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.89}, {-17.82, 25.469999, 6.89}, {-1.86, 
      2.31, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.86}, {-1.3, 2.71, 6.86}, {-0.98, 2.28, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.89}, {-0.98, 2.28, 6.89}, {-1.3, 2.71, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.86}, {-0.98, 2.28, 6.86}, {-1.26, 2.07, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.89}, {-1.26, 2.07, 6.89}, {-0.98, 2.28, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.26, 2.07, 6.86}, {-0.34, 0.78, 6.86}, {-0.92, 1.01, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.26, 2.07, 6.89}, {-0.92, 1.01, 6.89}, {-0.34, 0.78, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.86}, {-1.26, 2.07, 6.86}, {-0.92, 1.01, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.89}, {-0.92, 1.01, 6.89}, {-1.26, 2.07, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.86}, {-0.92, 1.01, 6.86}, {-1.54, 1.87, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.59, 2.5, 6.89}, {-1.54, 1.87, 6.89}, {-0.92, 1.01, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-17.82, 25.469999, 
      6.86}, {-17.219999, 25.25, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.89}, {-17.219999, 25.25, 6.89}, {-17.82, 
      25.469999, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-17.219999, 25.25, 6.86}, {-2.25, 
      4.65, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.89}, {-2.25, 4.65, 6.89}, {-17.219999, 
      25.25, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.86}, {-2.25, 4.65, 6.86}, {-1.59, 2.5, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.54, 1.87, 6.89}, {-1.59, 2.5, 6.89}, {-2.25, 4.65, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.82, -0.06, 6.86}, {-0.82, -0.06, 6.89}, {-1.23, -0.54, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-0.82, -0.06, 6.86}, {-1.23, -0.54, 6.89}, {-1.23, -0.54, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.23, -0.54, 6.86}, {-1.23, -0.54, 6.89}, {-2.22, -0.88, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-1.23, -0.54, 6.86}, {-2.22, -0.88, 6.89}, {-2.22, -0.88, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-2.22, -0.88, 6.89}, {-2.12, -1.22, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-2.12, -1.22, 6.89}, {-2.12, -1.22, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.12, -1.22, 6.86}, {-2.12, -1.22, 6.89}, {-2.63, -1.38, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.12, -1.22, 6.86}, {-2.63, -1.38, 6.89}, {-2.63, -1.38, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.63, -1.38, 6.86}, {-2.63, -1.38, 6.89}, {-2.74, -1.03, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.63, -1.38, 6.86}, {-2.74, -1.03, 6.89}, {-2.74, -1.03, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.86}, {-2.74, -1.03, 6.89}, {-4.54, -2.38, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.86}, {-4.54, -2.38, 6.89}, {-4.54, -2.38, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-4.54, -2.38, 6.86}, {-4.54, -2.38, 
      6.89}, {-28.77, -10.25, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-4.54, -2.38, 6.86}, {-28.77, -10.25, 
      6.89}, {-28.77, -10.25, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-28.77, -10.25, 6.86}, {-28.77, -10.25, 
      6.89}, {-29.379999, -10.07, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-28.77, -10.25, 6.86}, {-29.379999, -10.07, 
      6.89}, {-29.379999, -10.07, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-29.379999, -10.07, 6.86}, {-29.379999, -10.07, 
      6.89}, {-29.700001, -9.08, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-29.379999, -10.07, 6.86}, {-29.700001, -9.08, 
      6.89}, {-29.700001, -9.08, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-29.700001, -9.08, 6.86}, {-29.700001, -9.08, 
      6.89}, {-29.32, -8.56, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-29.700001, -9.08, 6.86}, {-29.32, -8.56, 
      6.89}, {-29.32, -8.56, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-29.32, -8.56, 6.86}, {-29.32, -8.56, 
      6.89}, {-5.09, -0.69, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-29.32, -8.56, 6.86}, {-5.09, -0.69, 6.89}, {-5.09, -0.69,
       6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-5.09, -0.69, 6.86}, {-5.09, -0.69, 6.89}, {-2.85, -0.72, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-5.09, -0.69, 6.86}, {-2.85, -0.72, 6.89}, {-2.85, -0.72, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.86}, {-2.85, -0.72, 6.89}, {-2.96, -0.38, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.86}, {-2.96, -0.38, 6.89}, {-2.96, -0.38, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.96, -0.38, 6.86}, {-2.96, -0.38, 6.89}, {-2.44, -0.21, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.96, -0.38, 6.86}, {-2.44, -0.21, 6.89}, {-2.44, -0.21, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.44, -0.21, 6.86}, {-2.44, -0.21, 6.89}, {-2.32, -0.56, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.44, -0.21, 6.86}, {-2.32, -0.56, 6.89}, {-2.32, -0.56, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.32, -0.56, 6.86}, {-2.32, -0.56, 6.89}, {-0.82, -0.06, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.32, -0.56, 6.86}, {-0.82, -0.06, 6.89}, {-0.82, -0.06, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-2.12, -1.22, 6.86}, {-2.63, -1.38, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.89}, {-2.63, -1.38, 6.89}, {-2.12, -1.22, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-2.63, -1.38, 6.86}, {-2.74, -1.03, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.89}, {-2.74, -1.03, 6.89}, {-2.63, -1.38, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.86}, {-4.54, -2.38, 
      6.86}, {-28.77, -10.25, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.89}, {-28.77, -10.25, 
      6.89}, {-4.54, -2.38, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.86}, {-28.77, -10.25, 
      6.86}, {-29.379999, -10.07, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.89}, {-29.379999, -10.07, 
      6.89}, {-28.77, -10.25, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.86}, {-29.379999, -10.07, 
      6.86}, {-29.700001, -9.08, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.74, -1.03, 6.89}, {-29.700001, -9.08, 
      6.89}, {-29.379999, -10.07, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-2.74, -1.03, 
      6.86}, {-29.700001, -9.08, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.89}, {-29.700001, -9.08, 
      6.89}, {-2.74, -1.03, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.86}, {-2.96, -0.38, 6.86}, {-2.44, -0.21, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.89}, {-2.44, -0.21, 6.89}, {-2.96, -0.38, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.86}, {-2.44, -0.21, 6.86}, {-2.32, -0.56, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.89}, {-2.32, -0.56, 6.89}, {-2.44, -0.21, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.32, -0.56, 6.86}, {-0.82, -0.06, 6.86}, {-1.23, -0.54, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.32, -0.56, 6.89}, {-1.23, -0.54, 6.89}, {-0.82, -0.06, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.86}, {-2.32, -0.56, 6.86}, {-1.23, -0.54, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.89}, {-1.23, -0.54, 6.89}, {-2.32, -0.56, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.86}, {-1.23, -0.54, 6.86}, {-2.22, -0.88, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.85, -0.72, 6.89}, {-2.22, -0.88, 6.89}, {-1.23, -0.54, 
      6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-29.700001, -9.08, 
      6.86}, {-29.32, -8.56, 6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.89}, {-29.32, -8.56, 
      6.89}, {-29.700001, -9.08, 6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-29.32, -8.56, 6.86}, {-5.09, -0.69,
       6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.89}, {-5.09, -0.69, 6.89}, {-29.32, -8.56,
       6.89}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.86}, {-5.09, -0.69, 6.86}, {-2.85, -0.72, 
      6.86}}]}, 
    {RGBColor[1., 1., 0.], 
     Polygon3DBox[{{-2.22, -0.88, 6.89}, {-2.85, -0.72, 6.89}, {-5.09, -0.69, 
      6.89}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -9.09, -7.21}, {6.04, -9.09, -7.21}, {
      6.04, -7.99, -8.53}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -9.09, -7.21}, {6.04, -7.99, -8.53}, {
      5.67, -7.99, -8.53}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -7.99, -8.53}, {6.04, -7.99, -8.53}, {6.04, 
      6.2, -8.53}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -7.99, -8.53}, {6.04, 6.2, -8.53}, {5.67, 
      6.2, -8.53}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, 6.2, -8.53}, {6.04, 6.2, -8.53}, {6.04, 
      6.2, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, 6.2, -8.53}, {6.04, 6.2, -8.75}, {5.67, 
      6.2, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, 6.2, -8.75}, {6.04, 6.2, -8.75}, {
      6.04, -7.99, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, 6.2, -8.75}, {6.04, -7.99, -8.75}, {
      5.67, -7.99, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -7.99, -8.75}, {6.04, -7.99, -8.75}, {
      6.04, -9.18, -7.21}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -7.99, -8.75}, {6.04, -9.18, -7.21}, {
      5.67, -9.18, -7.21}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -9.18, -7.21}, {6.04, -9.18, -7.21}, {
      6.04, -9.09, -7.21}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -9.18, -7.21}, {6.04, -9.09, -7.21}, {
      5.67, -9.09, -7.21}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -7.99, -8.53}, {5.67, 6.2, -8.53}, {5.67, 
      6.2, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{6.04, -7.99, -8.53}, {6.04, 6.2, -8.75}, {6.04, 
      6.2, -8.53}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -7.99, -8.53}, {5.67, 6.2, -8.75}, {
      5.67, -7.99, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{6.04, -7.99, -8.53}, {6.04, -7.99, -8.75}, {6.04, 
      6.2, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -9.09, -7.21}, {5.67, -7.99, -8.53}, {
      5.67, -7.99, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{6.04, -9.09, -7.21}, {6.04, -7.99, -8.75}, {
      6.04, -7.99, -8.53}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{5.67, -9.09, -7.21}, {5.67, -7.99, -8.75}, {
      5.67, -9.18, -7.21}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{6.04, -9.09, -7.21}, {6.04, -9.18, -7.21}, {
      6.04, -7.99, -8.75}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -9.08, -7.2}, {-5.66, -9.08, -7.2}, {-5.66, -7.98, \
-8.52}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -9.08, -7.2}, {-5.66, -7.98, -8.52}, {-6.03, \
-7.98, -8.52}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -7.98, -8.52}, {-5.66, -7.98, -8.52}, {-5.66, 
      6.2, -8.52}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -7.98, -8.52}, {-5.66, 6.2, -8.52}, {-6.03, 
      6.2, -8.52}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, 6.2, -8.52}, {-5.66, 6.2, -8.52}, {-5.66, 
      6.2, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, 6.2, -8.52}, {-5.66, 6.2, -8.74}, {-6.03, 
      6.2, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, 6.2, -8.74}, {-5.66, 
      6.2, -8.74}, {-5.66, -7.98, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, 
      6.2, -8.74}, {-5.66, -7.98, -8.74}, {-6.03, -7.98, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -7.98, -8.74}, {-5.66, -7.98, -8.74}, {-5.66, \
-9.17, -7.2}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -7.98, -8.74}, {-5.66, -9.17, -7.2}, {-6.03, \
-9.17, -7.2}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -9.17, -7.2}, {-5.66, -9.17, -7.2}, {-5.66, -9.08, \
-7.2}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -9.17, -7.2}, {-5.66, -9.08, -7.2}, {-6.03, -9.08, \
-7.2}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -7.98, -8.52}, {-6.03, 6.2, -8.52}, {-6.03, 
      6.2, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-5.66, -7.98, -8.52}, {-5.66, 6.2, -8.74}, {-5.66, 
      6.2, -8.52}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -7.98, -8.52}, {-6.03, 
      6.2, -8.74}, {-6.03, -7.98, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-5.66, -7.98, -8.52}, {-5.66, -7.98, -8.74}, {-5.66, 
      6.2, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -9.08, -7.2}, {-6.03, -7.98, -8.52}, {-6.03, \
-7.98, -8.74}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-5.66, -9.08, -7.2}, {-5.66, -7.98, -8.74}, {-5.66, \
-7.98, -8.52}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-6.03, -9.08, -7.2}, {-6.03, -7.98, -8.74}, {-6.03, \
-9.17, -7.2}}]}, 
    {RGBColor[0., 1., 0.], 
     Polygon3DBox[{{-5.66, -9.08, -7.2}, {-5.66, -9.17, -7.2}, {-5.66, -7.98, \
-8.74}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, -4.14, -3.42}, {2.96, -4.33, -3.42}, {
      3.13, -4.33, -3.32}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, -4.14, -3.42}, {3.13, -4.33, -3.32}, {
      3.13, -4.14, -3.32}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{3.13, -4.14, -3.32}, {3.13, -4.33, -3.32}, {
      6.16, -4.33, -8.56}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{3.13, -4.14, -3.32}, {6.16, -4.33, -8.56}, {
      6.16, -4.14, -8.56}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{6.16, -4.14, -8.56}, {6.16, -4.33, -8.56}, {
      5.98, -4.33, -8.66}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{6.16, -4.14, -8.56}, {5.98, -4.33, -8.66}, {
      5.98, -4.14, -8.66}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{5.98, -4.14, -8.66}, {5.98, -4.33, -8.66}, {
      2.96, -4.33, -3.42}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{5.98, -4.14, -8.66}, {2.96, -4.33, -3.42}, {
      2.96, -4.14, -3.42}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, -4.14, -3.42}, {3.13, -4.14, -3.32}, {
      6.16, -4.14, -8.56}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, -4.33, -3.42}, {6.16, -4.33, -8.56}, {
      3.13, -4.33, -3.32}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, -4.14, -3.42}, {6.16, -4.14, -8.56}, {
      5.98, -4.14, -8.66}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, -4.33, -3.42}, {5.98, -4.33, -8.66}, {
      6.16, -4.33, -8.56}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, 2.33, -3.4}, {2.96, 2.15, -3.4}, {3.13, 
      2.15, -3.3}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, 2.33, -3.4}, {3.13, 2.15, -3.3}, {3.13, 
      2.33, -3.3}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{3.13, 2.33, -3.3}, {3.13, 2.15, -3.3}, {6.15, 
      2.15, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{3.13, 2.33, -3.3}, {6.15, 2.15, -8.54}, {6.15, 
      2.33, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{6.15, 2.33, -8.54}, {6.15, 2.15, -8.54}, {5.99, 
      2.15, -8.64}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{6.15, 2.33, -8.54}, {5.99, 2.15, -8.64}, {5.99, 
      2.33, -8.64}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{5.99, 2.33, -8.64}, {5.99, 2.15, -8.64}, {2.96, 
      2.15, -3.4}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{5.99, 2.33, -8.64}, {2.96, 2.15, -3.4}, {2.96, 
      2.33, -3.4}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, 2.33, -3.4}, {3.13, 2.33, -3.3}, {6.15, 
      2.33, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, 2.15, -3.4}, {6.15, 2.15, -8.54}, {3.13, 
      2.15, -3.3}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, 2.33, -3.4}, {6.15, 2.33, -8.54}, {5.99, 
      2.33, -8.64}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{2.96, 2.15, -3.4}, {5.99, 2.15, -8.64}, {6.15, 
      2.15, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.12, -4.13, -3.31}, {-3.12, -4.32, -3.31}, {-2.95, \
-4.32, -3.41}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.12, -4.13, -3.31}, {-2.95, -4.32, -3.41}, {-2.95, \
-4.13, -3.41}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-2.95, -4.13, -3.41}, {-2.95, -4.32, -3.41}, {-5.97, \
-4.32, -8.65}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-2.95, -4.13, -3.41}, {-5.97, -4.32, -8.65}, {-5.97, \
-4.13, -8.65}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-5.97, -4.13, -8.65}, {-5.97, -4.32, -8.65}, {-6.15, \
-4.32, -8.55}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-5.97, -4.13, -8.65}, {-6.15, -4.32, -8.55}, {-6.15, \
-4.13, -8.55}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-6.15, -4.13, -8.55}, {-6.15, -4.32, -8.55}, {-3.12, \
-4.32, -3.31}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-6.15, -4.13, -8.55}, {-3.12, -4.32, -3.31}, {-3.12, \
-4.13, -3.31}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.12, -4.13, -3.31}, {-2.95, -4.13, -3.41}, {-5.97, \
-4.13, -8.65}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.12, -4.32, -3.31}, {-5.97, -4.32, -8.65}, {-2.95, \
-4.32, -3.41}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.12, -4.13, -3.31}, {-5.97, -4.13, -8.65}, {-6.15, \
-4.13, -8.55}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.12, -4.32, -3.31}, {-6.15, -4.32, -8.55}, {-5.97, \
-4.32, -8.65}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.1, 2.33, -3.3}, {-3.1, 2.15, -3.3}, {-2.93, 
      2.15, -3.4}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.1, 2.33, -3.3}, {-2.93, 2.15, -3.4}, {-2.93, 
      2.33, -3.4}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-2.93, 2.33, -3.4}, {-2.93, 2.15, -3.4}, {-5.96, 
      2.15, -8.63}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-2.93, 2.33, -3.4}, {-5.96, 2.15, -8.63}, {-5.96, 
      2.33, -8.63}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-5.96, 2.33, -8.63}, {-5.96, 2.15, -8.63}, {-6.12, 
      2.15, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-5.96, 2.33, -8.63}, {-6.12, 2.15, -8.54}, {-6.12, 
      2.33, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-6.12, 2.33, -8.54}, {-6.12, 2.15, -8.54}, {-3.1, 
      2.15, -3.3}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-6.12, 2.33, -8.54}, {-3.1, 2.15, -3.3}, {-3.1, 
      2.33, -3.3}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.1, 2.33, -3.3}, {-2.93, 2.33, -3.4}, {-5.96, 
      2.33, -8.63}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.1, 2.15, -3.3}, {-5.96, 2.15, -8.63}, {-2.93, 
      2.15, -3.4}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.1, 2.33, -3.3}, {-5.96, 2.33, -8.63}, {-6.12, 
      2.33, -8.54}}]}, 
    {RGBColor[0., 1., 1.], 
     Polygon3DBox[{{-3.1, 2.15, -3.3}, {-6.12, 2.15, -8.54}, {-5.96, 
      2.15, -8.63}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 33.450001, 7.67}, {-4.91, 33.450001, 7.67}, {-4.91,
       35.240002, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 33.450001, 7.67}, {-4.91, 35.240002, 
      10.18}, {-5.09, 35.240002, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 35.240002, 10.18}, {-4.91, 35.240002, 
      10.18}, {-4.91, 36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 35.240002, 10.18}, {-4.91, 36.66, 10.18}, {-5.09, 
      36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 36.66, 10.18}, {-4.91, 36.66, 10.18}, {-4.91, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 36.66, 10.18}, {-4.91, 35.959999, 6.09}, {-5.09, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 35.959999, 6.09}, {-4.91, 35.959999, 6.09}, {-4.91,
       34.52, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 35.959999, 6.09}, {-4.91, 34.52, 6.09}, {-5.09, 
      34.52, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 34.52, 6.09}, {-4.91, 34.52, 6.09}, {-4.91, 
      33.450001, 7.67}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 34.52, 6.09}, {-4.91, 33.450001, 7.67}, {-5.09, 
      33.450001, 7.67}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 33.450001, 7.67}, {-5.09, 35.240002, 
      10.18}, {-5.09, 36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.91, 33.450001, 7.67}, {-4.91, 36.66, 10.18}, {-4.91, 
      35.240002, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 33.450001, 7.67}, {-5.09, 36.66, 10.18}, {-5.09, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.91, 33.450001, 7.67}, {-4.91, 35.959999, 6.09}, {-4.91,
       36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-5.09, 33.450001, 7.67}, {-5.09, 35.959999, 6.09}, {-5.09,
       34.52, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.91, 33.450001, 7.67}, {-4.91, 34.52, 6.09}, {-4.91, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 33.450001, 7.67}, {4.84, 33.450001, 7.67}, {4.84, 
      35.240002, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 33.450001, 7.67}, {4.84, 35.240002, 10.18}, {4.66, 
      35.240002, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 35.240002, 10.18}, {4.84, 35.240002, 10.18}, {4.84, 
      36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 35.240002, 10.18}, {4.84, 36.66, 10.18}, {4.66, 
      36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 36.66, 10.18}, {4.84, 36.66, 10.18}, {4.84, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 36.66, 10.18}, {4.84, 35.959999, 6.09}, {4.66, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 35.959999, 6.09}, {4.84, 35.959999, 6.09}, {4.84, 
      34.52, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 35.959999, 6.09}, {4.84, 34.52, 6.09}, {4.66, 34.52,
       6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 34.52, 6.09}, {4.84, 34.52, 6.09}, {4.84, 33.450001,
       7.67}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 34.52, 6.09}, {4.84, 33.450001, 7.67}, {4.66, 
      33.450001, 7.67}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 33.450001, 7.67}, {4.66, 35.240002, 10.18}, {4.66, 
      36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.84, 33.450001, 7.67}, {4.84, 36.66, 10.18}, {4.84, 
      35.240002, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 33.450001, 7.67}, {4.66, 36.66, 10.18}, {4.66, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.84, 33.450001, 7.67}, {4.84, 35.959999, 6.09}, {4.84, 
      36.66, 10.18}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.66, 33.450001, 7.67}, {4.66, 35.959999, 6.09}, {4.66, 
      34.52, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.84, 33.450001, 7.67}, {4.84, 34.52, 6.09}, {4.84, 
      35.959999, 6.09}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 36.48, 8.27}, {-4.88, 34.18, 8.27}, {4.58, 34.18, 
      8.27}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 36.48, 8.27}, {4.58, 34.18, 8.27}, {4.58, 36.48, 
      8.27}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.58, 36.48, 8.27}, {4.58, 34.18, 8.27}, {4.58, 34.18, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.58, 36.48, 8.27}, {4.58, 34.18, 7.93}, {4.58, 36.48, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.58, 36.48, 7.93}, {4.58, 34.18, 7.93}, {-4.88, 34.18, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{4.58, 36.48, 7.93}, {-4.88, 34.18, 7.93}, {-4.88, 36.48, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 36.48, 7.93}, {-4.88, 34.18, 7.93}, {-4.88, 34.18, 
      8.27}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 36.48, 7.93}, {-4.88, 34.18, 8.27}, {-4.88, 36.48, 
      8.27}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 36.48, 8.27}, {4.58, 36.48, 8.27}, {4.58, 36.48, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 34.18, 8.27}, {4.58, 34.18, 7.93}, {4.58, 34.18, 
      8.27}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 36.48, 8.27}, {4.58, 36.48, 7.93}, {-4.88, 36.48, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-4.88, 34.18, 8.27}, {-4.88, 34.18, 7.93}, {4.58, 34.18, 
      7.93}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 36.18, 7.75}, {-0.13, 36.18, 7.75}, {-0.13, 
      34.950001, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 36.18, 7.75}, {-0.13, 34.950001, 7.75}, {0.14, 
      34.950001, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.950001, 7.75}, {-0.13, 34.950001, 7.75}, {-0.13, 
      31.26, 2.33}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.950001, 7.75}, {-0.13, 31.26, 2.33}, {0.14, 
      31.26, 2.33}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 31.26, 2.33}, {-0.13, 31.26, 2.33}, {-0.13, 
      34.029999, -1.7}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 31.26, 2.33}, {-0.13, 34.029999, -1.7}, {0.14, 
      34.029999, -1.7}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.029999, -1.7}, {-0.13, 34.029999, -1.7}, {-0.13, 
      35.25, -1.7}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.029999, -1.7}, {-0.13, 35.25, -1.7}, {0.14, 
      35.25, -1.7}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 35.25, -1.7}, {-0.13, 35.25, -1.7}, {-0.13, 
      34.029999, 2.33}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 35.25, -1.7}, {-0.13, 34.029999, 2.33}, {0.14, 
      34.029999, 2.33}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.029999, 2.33}, {-0.13, 34.029999, 2.33}, {-0.13, 
      36.18, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.029999, 2.33}, {-0.13, 36.18, 7.75}, {0.14, 
      36.18, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.029999, 2.33}, {0.14, 36.18, 7.75}, {0.14, 
      34.950001, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-0.13, 34.029999, 2.33}, {-0.13, 34.950001, 7.75}, {-0.13,
       36.18, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 34.029999, 2.33}, {0.14, 34.950001, 7.75}, {0.14, 
      31.26, 2.33}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-0.13, 34.029999, 2.33}, {-0.13, 31.26, 2.33}, {-0.13, 
      34.950001, 7.75}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 31.26, 2.33}, {0.14, 34.029999, -1.7}, {0.14, 
      35.25, -1.7}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-0.13, 31.26, 2.33}, {-0.13, 35.25, -1.7}, {-0.13, 
      34.029999, -1.7}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{0.14, 31.26, 2.33}, {0.14, 35.25, -1.7}, {0.14, 34.029999,
       2.33}}]}, 
    {RGBColor[0., 0., 1.], 
     Polygon3DBox[{{-0.13, 31.26, 2.33}, {-0.13, 34.029999, 2.33}, {-0.13, 
      35.25, -1.7}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.43, -10.69, 0.}, {1.39, -10.69, 
      0.37}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.43, -10.69, 0.}, {2.74, -9.84, 0.01}, {2.64, -9.84, 
      0.7}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.43, -10.69, 0.}, {2.64, -9.84, 0.7}, {1.39, -10.69, 
      0.37}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.74, -9.84, 0.01}, {3.81, -8.83, 0.02}, {3.69, -8.83, 
      0.98}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.74, -9.84, 0.01}, {3.69, -8.83, 0.98}, {2.64, -9.84, 
      0.7}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.81, -8.83, 0.02}, {4.73, -6.96, 0.04}, {4.57, -6.96, 
      1.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.81, -8.83, 0.02}, {4.57, -6.96, 1.22}, {3.69, -8.83, 
      0.98}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.73, -6.96, 0.04}, {5.27, -4.1, 0.04}, {5.09, -4.1, 
      1.36}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.73, -6.96, 0.04}, {5.09, -4.1, 1.36}, {4.57, -6.96, 
      1.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.27, -4.1, 0.04}, {5.19, -0.72, 0.04}, {5.02, -0.72, 
      1.34}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.27, -4.1, 0.04}, {5.02, -0.72, 1.34}, {5.09, -4.1, 
      1.36}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.19, -0.72, 0.04}, {4.35, 2.82, 0.03}, {4.19, 2.82, 
      1.12}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.19, -0.72, 0.04}, {4.19, 2.82, 1.12}, {5.02, -0.72, 
      1.34}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.35, 2.82, 0.03}, {1.82, 8.39, 0.01}, {1.75, 8.39, 
      0.46}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.35, 2.82, 0.03}, {1.75, 8.39, 0.46}, {4.19, 2.82, 
      1.12}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.82, 8.39, 0.01}, {0.82, 11.77, 0.}, {0.79, 11.77, 
      0.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.82, 8.39, 0.01}, {0.79, 11.77, 0.21}, {1.75, 8.39, 
      0.46}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.82, 11.77, 0.}, {0.66, 13.13, 0.}, {0.64, 13.13, 
      0.17}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.82, 11.77, 0.}, {0.64, 13.13, 0.17}, {0.79, 11.77, 
      0.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.66, 13.13, 0.}, {0.66, 10.25, 0.}, {0.64, 10.25, 
      0.17}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.66, 13.13, 0.}, {0.64, 10.25, 0.17}, {0.64, 13.13, 
      0.17}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.66, 10.25, 0.}, {-0.01, 10.25, 0.}, {0.64, 10.25, 
      0.17}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.39, -10.69, 0.37}, {1.25, -10.69, 
      0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.39, -10.69, 0.37}, {2.64, -9.84, 0.7}, {2.38, -9.84, 
      1.34}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.39, -10.69, 0.37}, {2.38, -9.84, 1.34}, {1.25, -10.69, 
      0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.64, -9.84, 0.7}, {3.69, -8.83, 0.98}, {3.32, -8.83, 
      1.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.64, -9.84, 0.7}, {3.32, -8.83, 1.87}, {2.38, -9.84, 
      1.34}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.69, -8.83, 0.98}, {4.57, -6.96, 1.22}, {4.13, -6.96, 
      2.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.69, -8.83, 0.98}, {4.13, -6.96, 2.32}, {3.32, -8.83, 
      1.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.57, -6.96, 1.22}, {5.09, -4.1, 1.36}, {4.6, -4.1, 
      2.59}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.57, -6.96, 1.22}, {4.6, -4.1, 2.59}, {4.13, -6.96, 
      2.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.09, -4.1, 1.36}, {5.02, -0.72, 1.34}, {4.53, -0.72, 
      2.55}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.09, -4.1, 1.36}, {4.53, -0.72, 2.55}, {4.6, -4.1, 
      2.59}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.02, -0.72, 1.34}, {4.19, 2.82, 1.12}, {3.79, 2.82, 
      2.13}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.02, -0.72, 1.34}, {3.79, 2.82, 2.13}, {4.53, -0.72, 
      2.55}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.19, 2.82, 1.12}, {1.75, 8.39, 0.46}, {1.58, 8.39, 
      0.89}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.19, 2.82, 1.12}, {1.58, 8.39, 0.89}, {3.79, 2.82, 
      2.13}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.75, 8.39, 0.46}, {0.79, 11.77, 0.21}, {0.71, 11.77, 
      0.4}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.75, 8.39, 0.46}, {0.71, 11.77, 0.4}, {1.58, 8.39, 
      0.89}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.79, 11.77, 0.21}, {0.64, 13.13, 0.17}, {0.58, 13.13, 
      0.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.79, 11.77, 0.21}, {0.58, 13.13, 0.33}, {0.71, 11.77, 
      0.4}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.64, 13.13, 0.17}, {0.64, 10.25, 0.17}, {0.58, 10.25, 
      0.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.64, 13.13, 0.17}, {0.58, 10.25, 0.33}, {0.58, 13.13, 
      0.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.64, 10.25, 0.17}, {-0.01, 10.25, 0.}, {0.58, 10.25, 
      0.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.25, -10.69, 0.71}, {1.03, -10.69, 
      1.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.25, -10.69, 0.71}, {2.38, -9.84, 1.34}, {1.98, -9.84, 
      1.9}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.25, -10.69, 0.71}, {1.98, -9.84, 1.9}, {1.03, -10.69, 
      1.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.38, -9.84, 1.34}, {3.32, -8.83, 1.87}, {2.75, -8.83, 
      2.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.38, -9.84, 1.34}, {2.75, -8.83, 2.64}, {1.98, -9.84, 
      1.9}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.32, -8.83, 1.87}, {4.13, -6.96, 2.32}, {3.41, -6.96, 
      3.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.32, -8.83, 1.87}, {3.41, -6.96, 3.28}, {2.75, -8.83, 
      2.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.13, -6.96, 2.32}, {4.6, -4.1, 2.59}, {3.8, -4.1, 
      3.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.13, -6.96, 2.32}, {3.8, -4.1, 3.65}, {3.41, -6.96, 
      3.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.6, -4.1, 2.59}, {4.53, -0.72, 2.55}, {3.75, -0.72, 
      3.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.6, -4.1, 2.59}, {3.75, -0.72, 3.6}, {3.8, -4.1, 
      3.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.53, -0.72, 2.55}, {3.79, 2.82, 2.13}, {3.14, 2.82, 
      3.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.53, -0.72, 2.55}, {3.14, 2.82, 3.02}, {3.75, -0.72, 
      3.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.79, 2.82, 2.13}, {1.58, 8.39, 0.89}, {1.31, 8.39, 
      1.26}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.79, 2.82, 2.13}, {1.31, 8.39, 1.26}, {3.14, 2.82, 
      3.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.58, 8.39, 0.89}, {0.71, 11.77, 0.4}, {0.58, 11.77, 
      0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.58, 8.39, 0.89}, {0.58, 11.77, 0.57}, {1.31, 8.39, 
      1.26}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.71, 11.77, 0.4}, {0.58, 13.13, 0.33}, {0.48, 13.13, 
      0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.71, 11.77, 0.4}, {0.48, 13.13, 0.47}, {0.58, 11.77, 
      0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 13.13, 0.33}, {0.58, 10.25, 0.33}, {0.48, 10.25, 
      0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 13.13, 0.33}, {0.48, 10.25, 0.47}, {0.48, 13.13, 
      0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 10.25, 0.33}, {-0.01, 10.25, 0.}, {0.48, 10.25, 
      0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.03, -10.69, 1.}, {0.75, -10.69, 
      1.23}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.03, -10.69, 1.}, {1.98, -9.84, 1.9}, {1.44, -9.84, 
      2.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.03, -10.69, 1.}, {1.44, -9.84, 2.33}, {0.75, -10.69, 
      1.23}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.98, -9.84, 1.9}, {2.75, -8.83, 2.64}, {2., -8.83, 
      3.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.98, -9.84, 1.9}, {2., -8.83, 3.25}, {1.44, -9.84, 
      2.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.75, -8.83, 2.64}, {3.41, -6.96, 3.28}, {2.49, -6.96, 
      4.03}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.75, -8.83, 2.64}, {2.49, -6.96, 4.03}, {2., -8.83, 
      3.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.41, -6.96, 3.28}, {3.8, -4.1, 3.65}, {2.78, -4.1, 
      4.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.41, -6.96, 3.28}, {2.78, -4.1, 4.48}, {2.49, -6.96, 
      4.03}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.8, -4.1, 3.65}, {3.75, -0.72, 3.6}, {2.73, -0.72, 
      4.42}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.8, -4.1, 3.65}, {2.73, -0.72, 4.42}, {2.78, -4.1, 
      4.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.75, -0.72, 3.6}, {3.14, 2.82, 3.02}, {2.28, 2.82, 
      3.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.75, -0.72, 3.6}, {2.28, 2.82, 3.71}, {2.73, -0.72, 
      4.42}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.14, 2.82, 3.02}, {1.31, 8.39, 1.26}, {0.95, 8.39, 
      1.55}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.14, 2.82, 3.02}, {0.95, 8.39, 1.55}, {2.28, 2.82, 
      3.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.31, 8.39, 1.26}, {0.58, 11.77, 0.57}, {0.43, 11.77, 
      0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.31, 8.39, 1.26}, {0.43, 11.77, 0.71}, {0.95, 8.39, 
      1.55}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 11.77, 0.57}, {0.48, 13.13, 0.47}, {0.34, 13.13, 
      0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 11.77, 0.57}, {0.34, 13.13, 0.57}, {0.43, 11.77, 
      0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.48, 13.13, 0.47}, {0.48, 10.25, 0.47}, {0.34, 10.25, 
      0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.48, 13.13, 0.47}, {0.34, 10.25, 0.57}, {0.34, 13.13, 
      0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.48, 10.25, 0.47}, {-0.01, 10.25, 0.}, {0.34, 10.25, 
      0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {0.75, -10.69, 1.23}, {0.42, -10.69, 
      1.38}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.75, -10.69, 1.23}, {1.44, -9.84, 2.33}, {0.81, -9.84, 
      2.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.75, -10.69, 1.23}, {0.81, -9.84, 2.63}, {0.42, -10.69, 
      1.38}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.44, -9.84, 2.33}, {2., -8.83, 3.25}, {1.13, -8.83, 
      3.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.44, -9.84, 2.33}, {1.13, -8.83, 3.65}, {0.81, -9.84, 
      2.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2., -8.83, 3.25}, {2.49, -6.96, 4.03}, {1.41, -6.96, 
      4.53}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2., -8.83, 3.25}, {1.41, -6.96, 4.53}, {1.13, -8.83, 
      3.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.49, -6.96, 4.03}, {2.78, -4.1, 4.48}, {1.57, -4.1, 
      5.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.49, -6.96, 4.03}, {1.57, -4.1, 5.04}, {1.41, -6.96, 
      4.53}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.78, -4.1, 4.48}, {2.73, -0.72, 4.42}, {1.55, -0.72, 
      4.96}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.78, -4.1, 4.48}, {1.55, -0.72, 4.96}, {1.57, -4.1, 
      5.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.73, -0.72, 4.42}, {2.28, 2.82, 3.71}, {1.29, 2.82, 
      4.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.73, -0.72, 4.42}, {1.29, 2.82, 4.16}, {1.55, -0.72, 
      4.96}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.28, 2.82, 3.71}, {0.95, 8.39, 1.55}, {0.52, 8.39, 
      1.74}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.28, 2.82, 3.71}, {0.52, 8.39, 1.74}, {1.29, 2.82, 
      4.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.95, 8.39, 1.55}, {0.43, 11.77, 0.71}, {0.23, 11.77, 
      0.79}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.95, 8.39, 1.55}, {0.23, 11.77, 0.79}, {0.52, 8.39, 
      1.74}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.43, 11.77, 0.71}, {0.34, 13.13, 0.57}, {0.19, 13.13, 
      0.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.43, 11.77, 0.71}, {0.19, 13.13, 0.64}, {0.23, 11.77, 
      0.79}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.34, 13.13, 0.57}, {0.34, 10.25, 0.57}, {0.19, 10.25, 
      0.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.34, 13.13, 0.57}, {0.19, 10.25, 0.64}, {0.19, 13.13, 
      0.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.34, 10.25, 0.57}, {-0.01, 10.25, 0.}, {0.19, 10.25, 
      0.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {0.42, -10.69, 1.38}, {0.06, -10.69, 
      1.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.42, -10.69, 1.38}, {0.81, -9.84, 2.63}, {0.13, -9.84, 
      2.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.42, -10.69, 1.38}, {0.13, -9.84, 2.75}, {0.06, -10.69, 
      1.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.81, -9.84, 2.63}, {1.13, -8.83, 3.65}, {0.18, -8.83, 
      3.82}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.81, -9.84, 2.63}, {0.18, -8.83, 3.82}, {0.13, -9.84, 
      2.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.13, -8.83, 3.65}, {1.41, -6.96, 4.53}, {0.23, -6.96, 
      4.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.13, -8.83, 3.65}, {0.23, -6.96, 4.75}, {0.18, -8.83, 
      3.82}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.41, -6.96, 4.53}, {1.57, -4.1, 5.04}, {0.26, -4.1, 
      5.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.41, -6.96, 4.53}, {0.26, -4.1, 5.28}, {0.23, -6.96, 
      4.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.57, -4.1, 5.04}, {1.55, -0.72, 4.96}, {0.26, -0.72, 
      5.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.57, -4.1, 5.04}, {0.26, -0.72, 5.21}, {0.26, -4.1, 
      5.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.55, -0.72, 4.96}, {1.29, 2.82, 4.16}, {0.21, 2.82, 
      4.36}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.55, -0.72, 4.96}, {0.21, 2.82, 4.36}, {0.26, -0.72, 
      5.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.29, 2.82, 4.16}, {0.52, 8.39, 1.74}, {0.07, 8.39, 
      1.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.29, 2.82, 4.16}, {0.07, 8.39, 1.83}, {0.21, 2.82, 
      4.36}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.52, 8.39, 1.74}, {0.23, 11.77, 0.79}, {0.02, 11.77, 
      0.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.52, 8.39, 1.74}, {0.02, 11.77, 0.83}, {0.07, 8.39, 
      1.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.23, 11.77, 0.79}, {0.19, 13.13, 0.64}, {0.01, 13.13, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.23, 11.77, 0.79}, {0.01, 13.13, 0.67}, {0.02, 11.77, 
      0.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.19, 13.13, 0.64}, {0.19, 10.25, 0.64}, {0.01, 10.25, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.19, 13.13, 0.64}, {0.01, 10.25, 0.67}, {0.01, 13.13, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.19, 10.25, 0.64}, {-0.01, 10.25, 0.}, {0.01, 10.25, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {0.06, -10.69, 1.44}, {-0.29, -10.69, 
      1.42}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.06, -10.69, 1.44}, {0.13, -9.84, 2.75}, {-0.55, -9.84, 
      2.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.06, -10.69, 1.44}, {-0.55, -9.84, 2.69}, {-0.29, -10.69,
       1.42}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.13, -9.84, 2.75}, {0.18, -8.83, 3.82}, {-0.76, -8.83, 
      3.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.13, -9.84, 2.75}, {-0.76, -8.83, 3.75}, {-0.55, -9.84, 
      2.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.18, -8.83, 3.82}, {0.23, -6.96, 4.75}, {-0.94, -6.96, 
      4.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.18, -8.83, 3.82}, {-0.94, -6.96, 4.65}, {-0.76, -8.83, 
      3.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.23, -6.96, 4.75}, {0.26, -4.1, 5.28}, {-1.04, -4.1, 
      5.18}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.23, -6.96, 4.75}, {-1.04, -4.1, 5.18}, {-0.94, -6.96, 
      4.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.26, -4.1, 5.28}, {0.26, -0.72, 5.21}, {-1.03, -0.72, 
      5.11}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.26, -4.1, 5.28}, {-1.03, -0.72, 5.11}, {-1.04, -4.1, 
      5.18}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.26, -0.72, 5.21}, {0.21, 2.82, 4.36}, {-0.86, 2.82, 
      4.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.26, -0.72, 5.21}, {-0.86, 2.82, 4.28}, {-1.03, -0.72, 
      5.11}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.21, 2.82, 4.36}, {0.07, 8.39, 1.83}, {-0.37, 8.39, 
      1.8}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.21, 2.82, 4.36}, {-0.37, 8.39, 1.8}, {-0.86, 2.82, 
      4.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.07, 8.39, 1.83}, {0.02, 11.77, 0.83}, {-0.17, 11.77, 
      0.81}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.07, 8.39, 1.83}, {-0.17, 11.77, 0.81}, {-0.37, 8.39, 
      1.8}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.02, 11.77, 0.83}, {0.01, 13.13, 0.67}, {-0.14, 13.13, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.02, 11.77, 0.83}, {-0.14, 13.13, 0.67}, {-0.17, 11.77, 
      0.81}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.01, 13.13, 0.67}, {0.01, 10.25, 0.67}, {-0.14, 10.25, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.01, 13.13, 0.67}, {-0.14, 10.25, 0.67}, {-0.14, 13.13, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.01, 10.25, 0.67}, {-0.01, 10.25, 0.}, {-0.14, 10.25, 
      0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-0.29, -10.69, 1.42}, {-0.64, -10.69, 
      1.3}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.29, -10.69, 1.42}, {-0.55, -9.84, 2.69}, {-1.21, -9.84,
       2.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.29, -10.69, 1.42}, {-1.21, -9.84, 
      2.48}, {-0.64, -10.69, 1.3}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.55, -9.84, 2.69}, {-0.76, -8.83, 3.75}, {-1.67, -8.83, 
      3.45}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.55, -9.84, 2.69}, {-1.67, -8.83, 3.45}, {-1.21, -9.84, 
      2.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.76, -8.83, 3.75}, {-0.94, -6.96, 4.65}, {-2.07, -6.96, 
      4.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.76, -8.83, 3.75}, {-2.07, -6.96, 4.28}, {-1.67, -8.83, 
      3.45}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.94, -6.96, 4.65}, {-1.04, -4.1, 5.18}, {-2.31, -4.1, 
      4.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.94, -6.96, 4.65}, {-2.31, -4.1, 4.76}, {-2.07, -6.96, 
      4.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.04, -4.1, 5.18}, {-1.03, -0.72, 5.11}, {-2.27, -0.72, 
      4.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.04, -4.1, 5.18}, {-2.27, -0.72, 4.69}, {-2.31, -4.1, 
      4.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.03, -0.72, 5.11}, {-0.86, 2.82, 4.28}, {-1.91, 2.82, 
      3.93}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.03, -0.72, 5.11}, {-1.91, 2.82, 3.93}, {-2.27, -0.72, 
      4.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.86, 2.82, 4.28}, {-0.37, 8.39, 1.8}, {-0.81, 8.39, 
      1.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.86, 2.82, 4.28}, {-0.81, 8.39, 1.65}, {-1.91, 2.82, 
      3.93}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.37, 8.39, 1.8}, {-0.17, 11.77, 0.81}, {-0.37, 11.77, 
      0.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.37, 8.39, 1.8}, {-0.37, 11.77, 0.75}, {-0.81, 8.39, 
      1.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.17, 11.77, 0.81}, {-0.14, 13.13, 0.67}, {-0.31, 13.13, 
      0.61}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.17, 11.77, 0.81}, {-0.31, 13.13, 0.61}, {-0.37, 11.77, 
      0.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.14, 13.13, 0.67}, {-0.14, 10.25, 0.67}, {-0.31, 10.25, 
      0.61}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.14, 13.13, 0.67}, {-0.31, 10.25, 0.61}, {-0.31, 13.13, 
      0.61}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.14, 10.25, 0.67}, {-0.01, 10.25, 0.}, {-0.31, 10.25, 
      0.61}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-0.64, -10.69, 1.3}, {-0.95, -10.69, 
      1.1}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.64, -10.69, 1.3}, {-1.21, -9.84, 2.48}, {-1.78, -9.84, 
      2.08}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.64, -10.69, 1.3}, {-1.78, -9.84, 2.08}, {-0.95, -10.69,
       1.1}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.21, -9.84, 2.48}, {-1.67, -8.83, 3.45}, {-2.48, -8.83, 
      2.92}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.21, -9.84, 2.48}, {-2.48, -8.83, 2.92}, {-1.78, -9.84, 
      2.08}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.67, -8.83, 3.45}, {-2.07, -6.96, 4.28}, {-3.07, -6.96, 
      3.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.67, -8.83, 3.45}, {-3.07, -6.96, 3.63}, {-2.48, -8.83, 
      2.92}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.07, -6.96, 4.28}, {-2.31, -4.1, 4.76}, {-3.42, -4.1, 
      4.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.07, -6.96, 4.28}, {-3.42, -4.1, 4.04}, {-3.07, -6.96, 
      3.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.31, -4.1, 4.76}, {-2.27, -0.72, 4.69}, {-3.37, -0.72, 
      3.98}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.31, -4.1, 4.76}, {-3.37, -0.72, 3.98}, {-3.42, -4.1, 
      4.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.27, -0.72, 4.69}, {-1.91, 2.82, 3.93}, {-2.83, 2.82, 
      3.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.27, -0.72, 4.69}, {-2.83, 2.82, 3.33}, {-3.37, -0.72, 
      3.98}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.91, 2.82, 3.93}, {-0.81, 8.39, 1.65}, {-1.19, 8.39, 
      1.4}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.91, 2.82, 3.93}, {-1.19, 8.39, 1.4}, {-2.83, 2.82, 
      3.33}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.81, 8.39, 1.65}, {-0.37, 11.77, 0.75}, {-0.55, 11.77, 
      0.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.81, 8.39, 1.65}, {-0.55, 11.77, 0.64}, {-1.19, 8.39, 
      1.4}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.37, 11.77, 0.75}, {-0.31, 13.13, 0.61}, {-0.45, 13.13, 
      0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.37, 11.77, 0.75}, {-0.45, 13.13, 0.51}, {-0.55, 11.77, 
      0.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.31, 13.13, 0.61}, {-0.31, 10.25, 0.61}, {-0.45, 10.25, 
      0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.31, 13.13, 0.61}, {-0.45, 10.25, 0.51}, {-0.45, 13.13, 
      0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.31, 10.25, 0.61}, {-0.01, 10.25, 0.}, {-0.45, 10.25, 
      0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-0.95, -10.69, 1.1}, {-1.19, -10.69, 
      0.84}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.95, -10.69, 1.1}, {-1.78, -9.84, 2.08}, {-2.26, -9.84, 
      1.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.95, -10.69, 1.1}, {-2.26, -9.84, 1.6}, {-1.19, -10.69, 
      0.84}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.78, -9.84, 2.08}, {-2.48, -8.83, 2.92}, {-3.14, -8.83, 
      2.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.78, -9.84, 2.08}, {-3.14, -8.83, 2.22}, {-2.26, -9.84, 
      1.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.48, -8.83, 2.92}, {-3.07, -6.96, 3.63}, {-3.88, -6.96, 
      2.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.48, -8.83, 2.92}, {-3.88, -6.96, 2.76}, {-3.14, -8.83, 
      2.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.07, -6.96, 3.63}, {-3.42, -4.1, 4.04}, {-4.32, -4.1, 
      3.06}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.07, -6.96, 3.63}, {-4.32, -4.1, 3.06}, {-3.88, -6.96, 
      2.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.42, -4.1, 4.04}, {-3.37, -0.72, 3.98}, {-4.26, -0.72, 
      3.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.42, -4.1, 4.04}, {-4.26, -0.72, 3.02}, {-4.32, -4.1, 
      3.06}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.37, -0.72, 3.98}, {-2.83, 2.82, 3.33}, {-3.57, 2.82, 
      2.53}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.37, -0.72, 3.98}, {-3.57, 2.82, 2.53}, {-4.26, -0.72, 
      3.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.83, 2.82, 3.33}, {-1.19, 8.39, 1.4}, {-1.51, 8.39, 
      1.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.83, 2.82, 3.33}, {-1.51, 8.39, 1.04}, {-3.57, 2.82, 
      2.53}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.19, 8.39, 1.4}, {-0.55, 11.77, 0.64}, {-0.69, 11.77, 
      0.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.19, 8.39, 1.4}, {-0.69, 11.77, 0.48}, {-1.51, 8.39, 
      1.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.55, 11.77, 0.64}, {-0.45, 13.13, 0.51}, {-0.57, 13.13, 
      0.39}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.55, 11.77, 0.64}, {-0.57, 13.13, 0.39}, {-0.69, 11.77, 
      0.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.45, 13.13, 0.51}, {-0.45, 10.25, 0.51}, {-0.57, 10.25, 
      0.39}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.45, 13.13, 0.51}, {-0.57, 10.25, 0.39}, {-0.57, 13.13, 
      0.39}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.45, 10.25, 0.51}, {-0.01, 10.25, 0.}, {-0.57, 10.25, 
      0.39}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-1.19, -10.69, 0.84}, {-1.37, -10.69, 
      0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.19, -10.69, 0.84}, {-2.26, -9.84, 1.6}, {-2.58, -9.84, 
      0.98}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.19, -10.69, 0.84}, {-2.58, -9.84, 
      0.98}, {-1.37, -10.69, 0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.26, -9.84, 1.6}, {-3.14, -8.83, 2.22}, {-3.59, -8.83, 
      1.37}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.26, -9.84, 1.6}, {-3.59, -8.83, 1.37}, {-2.58, -9.84, 
      0.98}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.14, -8.83, 2.22}, {-3.88, -6.96, 2.76}, {-4.44, -6.96, 
      1.7}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.14, -8.83, 2.22}, {-4.44, -6.96, 1.7}, {-3.59, -8.83, 
      1.37}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.88, -6.96, 2.76}, {-4.32, -4.1, 3.06}, {-4.94, -4.1, 
      1.9}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.88, -6.96, 2.76}, {-4.94, -4.1, 1.9}, {-4.44, -6.96, 
      1.7}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.32, -4.1, 3.06}, {-4.26, -0.72, 3.02}, {-4.88, -0.72, 
      1.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.32, -4.1, 3.06}, {-4.88, -0.72, 1.87}, {-4.94, -4.1, 
      1.9}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.26, -0.72, 3.02}, {-3.57, 2.82, 2.53}, {-4.09, 2.82, 
      1.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.26, -0.72, 3.02}, {-4.09, 2.82, 1.57}, {-4.88, -0.72, 
      1.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.57, 2.82, 2.53}, {-1.51, 8.39, 1.04}, {-1.72, 8.39, 
      0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.57, 2.82, 2.53}, {-1.72, 8.39, 0.65}, {-4.09, 2.82, 
      1.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.51, 8.39, 1.04}, {-0.69, 11.77, 0.48}, {-0.79, 11.77, 
      0.29}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.51, 8.39, 1.04}, {-0.79, 11.77, 0.29}, {-1.72, 8.39, 
      0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 11.77, 0.48}, {-0.57, 13.13, 0.39}, {-0.65, 13.13, 
      0.24}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 11.77, 0.48}, {-0.65, 13.13, 0.24}, {-0.79, 11.77, 
      0.29}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.57, 13.13, 0.39}, {-0.57, 10.25, 0.39}, {-0.65, 10.25, 
      0.24}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.57, 13.13, 0.39}, {-0.65, 10.25, 0.24}, {-0.65, 13.13, 
      0.24}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.57, 10.25, 0.39}, {-0.01, 10.25, 0.}, {-0.65, 10.25, 
      0.24}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-1.37, -10.69, 0.51}, {-1.45, -10.69, 
      0.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.37, -10.69, 0.51}, {-2.58, -9.84, 0.98}, {-2.75, -9.84,
       0.31}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.37, -10.69, 0.51}, {-2.75, -9.84, 
      0.31}, {-1.45, -10.69, 0.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.58, -9.84, 0.98}, {-3.59, -8.83, 1.37}, {-3.82, -8.83, 
      0.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.58, -9.84, 0.98}, {-3.82, -8.83, 0.44}, {-2.75, -9.84, 
      0.31}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.59, -8.83, 1.37}, {-4.44, -6.96, 1.7}, {-4.73, -6.96, 
      0.54}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.59, -8.83, 1.37}, {-4.73, -6.96, 0.54}, {-3.82, -8.83, 
      0.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.44, -6.96, 1.7}, {-4.94, -4.1, 1.9}, {-5.27, -4.1, 
      0.61}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.44, -6.96, 1.7}, {-5.27, -4.1, 0.61}, {-4.73, -6.96, 
      0.54}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.94, -4.1, 1.9}, {-4.88, -0.72, 1.87}, {-5.19, -0.72, 
      0.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.94, -4.1, 1.9}, {-5.19, -0.72, 0.6}, {-5.27, -4.1, 
      0.61}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.88, -0.72, 1.87}, {-4.09, 2.82, 1.57}, {-4.36, 2.82, 
      0.5}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.88, -0.72, 1.87}, {-4.36, 2.82, 0.5}, {-5.19, -0.72, 
      0.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.09, 2.82, 1.57}, {-1.72, 8.39, 0.65}, {-1.84, 8.39, 
      0.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.09, 2.82, 1.57}, {-1.84, 8.39, 0.21}, {-4.36, 2.82, 
      0.5}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.72, 8.39, 0.65}, {-0.79, 11.77, 0.29}, {-0.85, 11.77, 
      0.08}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.72, 8.39, 0.65}, {-0.85, 11.77, 0.08}, {-1.84, 8.39, 
      0.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.79, 11.77, 0.29}, {-0.65, 13.13, 0.24}, {-0.69, 13.13, 
      0.07}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.79, 11.77, 0.29}, {-0.69, 13.13, 0.07}, {-0.85, 11.77, 
      0.08}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.65, 13.13, 0.24}, {-0.65, 10.25, 0.24}, {-0.69, 10.25, 
      0.07}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.65, 13.13, 0.24}, {-0.69, 10.25, 0.07}, {-0.69, 13.13, 
      0.07}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.65, 10.25, 0.24}, {-0.01, 10.25, 0.}, {-0.69, 10.25, 
      0.07}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-1.45, -10.69, 
      0.16}, {-1.45, -10.69, -0.19}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.45, -10.69, 0.16}, {-2.75, -9.84, 
      0.31}, {-2.74, -9.84, -0.37}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.45, -10.69, 
      0.16}, {-2.74, -9.84, -0.37}, {-1.45, -10.69, -0.19}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.75, -9.84, 0.31}, {-3.82, -8.83, 
      0.44}, {-3.81, -8.83, -0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.75, -9.84, 
      0.31}, {-3.81, -8.83, -0.51}, {-2.74, -9.84, -0.37}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.82, -8.83, 0.44}, {-4.73, -6.96, 
      0.54}, {-4.73, -6.96, -0.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.82, -8.83, 
      0.44}, {-4.73, -6.96, -0.63}, {-3.81, -8.83, -0.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.73, -6.96, 0.54}, {-5.27, -4.1, 
      0.61}, {-5.26, -4.1, -0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.73, -6.96, 
      0.54}, {-5.26, -4.1, -0.71}, {-4.73, -6.96, -0.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.27, -4.1, 0.61}, {-5.19, -0.72, 
      0.6}, {-5.18, -0.72, -0.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.27, -4.1, 
      0.61}, {-5.18, -0.72, -0.69}, {-5.26, -4.1, -0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.19, -0.72, 0.6}, {-4.36, 2.82, 0.5}, {-4.34, 
      2.82, -0.58}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.19, -0.72, 0.6}, {-4.34, 
      2.82, -0.58}, {-5.18, -0.72, -0.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.36, 2.82, 0.5}, {-1.84, 8.39, 0.21}, {-1.83, 
      8.39, -0.24}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.36, 2.82, 0.5}, {-1.83, 8.39, -0.24}, {-4.34, 
      2.82, -0.58}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.84, 8.39, 0.21}, {-0.85, 11.77, 0.08}, {-0.85, 
      11.77, -0.11}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.84, 8.39, 0.21}, {-0.85, 11.77, -0.11}, {-1.83, 
      8.39, -0.24}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.85, 11.77, 0.08}, {-0.69, 13.13, 0.07}, {-0.69, 
      13.13, -0.09}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.85, 11.77, 0.08}, {-0.69, 13.13, -0.09}, {-0.85, 
      11.77, -0.11}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 13.13, 0.07}, {-0.69, 10.25, 0.07}, {-0.69, 
      10.25, -0.09}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 13.13, 0.07}, {-0.69, 10.25, -0.09}, {-0.69, 
      13.13, -0.09}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 10.25, 0.07}, {-0.01, 10.25, 0.}, {-0.69, 
      10.25, -0.09}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 
      0.}, {-1.45, -10.69, -0.19}, {-1.36, -10.69, -0.54}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.45, -10.69, -0.19}, {-2.74, -9.84, -0.37}, {-2.57, \
-9.84, -1.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.45, -10.69, -0.19}, {-2.57, -9.84, -1.04}, {-1.36, \
-10.69, -0.54}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.74, -9.84, -0.37}, {-3.81, -8.83, -0.51}, {-3.57, \
-8.83, -1.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.74, -9.84, -0.37}, {-3.57, -8.83, -1.44}, {-2.57, \
-9.84, -1.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.81, -8.83, -0.51}, {-4.73, -6.96, -0.63}, {-4.42, \
-6.96, -1.78}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.81, -8.83, -0.51}, {-4.42, -6.96, -1.78}, {-3.57, \
-8.83, -1.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.73, -6.96, -0.63}, {-5.26, -4.1, -0.71}, {-4.92, -4.1, \
-1.99}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.73, -6.96, -0.63}, {-4.92, -4.1, -1.99}, {-4.42, \
-6.96, -1.78}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.26, -4.1, -0.71}, {-5.18, -0.72, -0.69}, {-4.85, \
-0.72, -1.96}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.26, -4.1, -0.71}, {-4.85, -0.72, -1.96}, {-4.92, -4.1, \
-1.99}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.18, -0.72, -0.69}, {-4.34, 2.82, -0.58}, {-4.07, 
      2.82, -1.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-5.18, -0.72, -0.69}, {-4.07, 
      2.82, -1.64}, {-4.85, -0.72, -1.96}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.34, 2.82, -0.58}, {-1.83, 8.39, -0.24}, {-1.72, 
      8.39, -0.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.34, 2.82, -0.58}, {-1.72, 8.39, -0.69}, {-4.07, 
      2.82, -1.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.83, 8.39, -0.24}, {-0.85, 11.77, -0.11}, {-0.79, 
      11.77, -0.31}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.83, 8.39, -0.24}, {-0.79, 11.77, -0.31}, {-1.72, 
      8.39, -0.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.85, 11.77, -0.11}, {-0.69, 13.13, -0.09}, {-0.65, 
      13.13, -0.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.85, 11.77, -0.11}, {-0.65, 13.13, -0.25}, {-0.79, 
      11.77, -0.31}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 13.13, -0.09}, {-0.69, 10.25, -0.09}, {-0.65, 
      10.25, -0.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 13.13, -0.09}, {-0.65, 10.25, -0.25}, {-0.65, 
      13.13, -0.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 10.25, -0.09}, {-0.01, 10.25, 0.}, {-0.65, 
      10.25, -0.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 
      0.}, {-1.36, -10.69, -0.54}, {-1.16, -10.69, -0.86}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.36, -10.69, -0.54}, {-2.57, -9.84, -1.04}, {-2.23, \
-9.84, -1.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.36, -10.69, -0.54}, {-2.23, -9.84, -1.63}, {-1.16, \
-10.69, -0.86}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.57, -9.84, -1.04}, {-3.57, -8.83, -1.44}, {-3.1, \
-8.83, -2.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.57, -9.84, -1.04}, {-3.1, -8.83, -2.28}, {-2.23, \
-9.84, -1.63}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.57, -8.83, -1.44}, {-4.42, -6.96, -1.78}, {-3.84, \
-6.96, -2.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.57, -8.83, -1.44}, {-3.84, -6.96, -2.83}, {-3.1, \
-8.83, -2.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.42, -6.96, -1.78}, {-4.92, -4.1, -1.99}, {-4.27, -4.1, \
-3.14}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.42, -6.96, -1.78}, {-4.27, -4.1, -3.14}, {-3.84, \
-6.96, -2.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.92, -4.1, -1.99}, {-4.85, -0.72, -1.96}, {-4.19, \
-0.72, -3.1}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.92, -4.1, -1.99}, {-4.19, -0.72, -3.1}, {-4.27, -4.1, \
-3.14}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.85, -0.72, -1.96}, {-4.07, 2.82, -1.64}, {-3.53, 
      2.82, -2.59}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.85, -0.72, -1.96}, {-3.53, 
      2.82, -2.59}, {-4.19, -0.72, -3.1}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.07, 2.82, -1.64}, {-1.72, 8.39, -0.69}, {-1.49, 
      8.39, -1.09}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.07, 2.82, -1.64}, {-1.49, 8.39, -1.09}, {-3.53, 
      2.82, -2.59}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.72, 8.39, -0.69}, {-0.79, 11.77, -0.31}, {-0.69, 
      11.77, -0.5}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.72, 8.39, -0.69}, {-0.69, 11.77, -0.5}, {-1.49, 
      8.39, -1.09}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.79, 11.77, -0.31}, {-0.65, 13.13, -0.25}, {-0.56, 
      13.13, -0.41}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.79, 11.77, -0.31}, {-0.56, 13.13, -0.41}, {-0.69, 
      11.77, -0.5}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.65, 13.13, -0.25}, {-0.65, 10.25, -0.25}, {-0.56, 
      10.25, -0.41}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.65, 13.13, -0.25}, {-0.56, 10.25, -0.41}, {-0.56, 
      13.13, -0.41}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.65, 10.25, -0.25}, {-0.01, 10.25, 0.}, {-0.56, 
      10.25, -0.41}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 
      0.}, {-1.16, -10.69, -0.86}, {-0.92, -10.69, -1.13}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.16, -10.69, -0.86}, {-2.23, -9.84, -1.63}, {-1.75, \
-9.84, -2.14}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.16, -10.69, -0.86}, {-1.75, -9.84, -2.14}, {-0.92, \
-10.69, -1.13}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.23, -9.84, -1.63}, {-3.1, -8.83, -2.28}, {-2.43, \
-8.83, -2.97}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.23, -9.84, -1.63}, {-2.43, -8.83, -2.97}, {-1.75, \
-9.84, -2.14}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.1, -8.83, -2.28}, {-3.84, -6.96, -2.83}, {-3.01, \
-6.96, -3.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.1, -8.83, -2.28}, {-3.01, -6.96, -3.69}, {-2.43, \
-8.83, -2.97}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.84, -6.96, -2.83}, {-4.27, -4.1, -3.14}, {-3.35, -4.1, \
-4.11}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.84, -6.96, -2.83}, {-3.35, -4.1, -4.11}, {-3.01, \
-6.96, -3.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.27, -4.1, -3.14}, {-4.19, -0.72, -3.1}, {-3.31, -0.72, \
-4.05}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.27, -4.1, -3.14}, {-3.31, -0.72, -4.05}, {-3.35, -4.1, \
-4.11}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.19, -0.72, -3.1}, {-3.53, 2.82, -2.59}, {-2.77, 
      2.82, -3.39}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-4.19, -0.72, -3.1}, {-2.77, 
      2.82, -3.39}, {-3.31, -0.72, -4.05}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.53, 2.82, -2.59}, {-1.49, 8.39, -1.09}, {-1.16, 
      8.39, -1.43}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.53, 2.82, -2.59}, {-1.16, 8.39, -1.43}, {-2.77, 
      2.82, -3.39}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.49, 8.39, -1.09}, {-0.69, 11.77, -0.5}, {-0.54, 
      11.77, -0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.49, 8.39, -1.09}, {-0.54, 11.77, -0.65}, {-1.16, 
      8.39, -1.43}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 11.77, -0.5}, {-0.56, 13.13, -0.41}, {-0.44, 
      13.13, -0.52}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, 11.77, -0.5}, {-0.44, 13.13, -0.52}, {-0.54, 
      11.77, -0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.56, 13.13, -0.41}, {-0.56, 10.25, -0.41}, {-0.44, 
      10.25, -0.52}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.56, 13.13, -0.41}, {-0.44, 10.25, -0.52}, {-0.44, 
      13.13, -0.52}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.56, 10.25, -0.41}, {-0.01, 10.25, 0.}, {-0.44, 
      10.25, -0.52}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 
      0.}, {-0.92, -10.69, -1.13}, {-0.62, -10.69, -1.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.92, -10.69, -1.13}, {-1.75, -9.84, -2.14}, {-1.16, \
-9.84, -2.5}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.92, -10.69, -1.13}, {-1.16, -9.84, -2.5}, {-0.62, \
-10.69, -1.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.75, -9.84, -2.14}, {-2.43, -8.83, -2.97}, {-1.62, \
-8.83, -3.49}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.75, -9.84, -2.14}, {-1.62, -8.83, -3.49}, {-1.16, \
-9.84, -2.5}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.43, -8.83, -2.97}, {-3.01, -6.96, -3.69}, {-2., -6.96, \
-4.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.43, -8.83, -2.97}, {-2., -6.96, -4.32}, {-1.62, -8.83, \
-3.49}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.01, -6.96, -3.69}, {-3.35, -4.1, -4.11}, {-2.22, -4.1, \
-4.81}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.01, -6.96, -3.69}, {-2.22, -4.1, -4.81}, {-2., -6.96, \
-4.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.35, -4.1, -4.11}, {-3.31, -0.72, -4.05}, {-2.19, \
-0.72, -4.73}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.35, -4.1, -4.11}, {-2.19, -0.72, -4.73}, {-2.22, -4.1, \
-4.81}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.31, -0.72, -4.05}, {-2.77, 2.82, -3.39}, {-1.84, 
      2.82, -3.97}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-3.31, -0.72, -4.05}, {-1.84, 
      2.82, -3.97}, {-2.19, -0.72, -4.73}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.77, 2.82, -3.39}, {-1.16, 8.39, -1.43}, {-0.78, 
      8.39, -1.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.77, 2.82, -3.39}, {-0.78, 8.39, -1.67}, {-1.84, 
      2.82, -3.97}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.16, 8.39, -1.43}, {-0.54, 11.77, -0.65}, {-0.36, 
      11.77, -0.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.16, 8.39, -1.43}, {-0.36, 11.77, -0.76}, {-0.78, 
      8.39, -1.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.54, 11.77, -0.65}, {-0.44, 13.13, -0.52}, {-0.29, 
      13.13, -0.62}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.54, 11.77, -0.65}, {-0.29, 13.13, -0.62}, {-0.36, 
      11.77, -0.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.44, 13.13, -0.52}, {-0.44, 10.25, -0.52}, {-0.29, 
      10.25, -0.62}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.44, 13.13, -0.52}, {-0.29, 10.25, -0.62}, {-0.29, 
      13.13, -0.62}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.44, 10.25, -0.52}, {-0.01, 10.25, 0.}, {-0.29, 
      10.25, -0.62}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 
      0.}, {-0.62, -10.69, -1.32}, {-0.27, -10.69, -1.43}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.62, -10.69, -1.32}, {-1.16, -9.84, -2.5}, {-0.5, \
-9.84, -2.72}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.62, -10.69, -1.32}, {-0.5, -9.84, -2.72}, {-0.27, \
-10.69, -1.43}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.16, -9.84, -2.5}, {-1.62, -8.83, -3.49}, {-0.69, \
-8.83, -3.77}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.16, -9.84, -2.5}, {-0.69, -8.83, -3.77}, {-0.5, -9.84, \
-2.72}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.62, -8.83, -3.49}, {-2., -6.96, -4.32}, {-0.86, -6.96, \
-4.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.62, -8.83, -3.49}, {-0.86, -6.96, -4.67}, {-0.69, \
-8.83, -3.77}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2., -6.96, -4.32}, {-2.22, -4.1, -4.81}, {-0.96, -4.1, \
-5.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2., -6.96, -4.32}, {-0.96, -4.1, -5.21}, {-0.86, -6.96, \
-4.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.22, -4.1, -4.81}, {-2.19, -0.72, -4.73}, {-0.95, \
-0.72, -5.13}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.22, -4.1, -4.81}, {-0.95, -0.72, -5.13}, {-0.96, -4.1, \
-5.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.19, -0.72, -4.73}, {-1.84, 2.82, -3.97}, {-0.79, 
      2.82, -4.3}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-2.19, -0.72, -4.73}, {-0.79, 
      2.82, -4.3}, {-0.95, -0.72, -5.13}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.84, 2.82, -3.97}, {-0.78, 8.39, -1.67}, {-0.34, 
      8.39, -1.81}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-1.84, 2.82, -3.97}, {-0.34, 8.39, -1.81}, {-0.79, 
      2.82, -4.3}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.78, 8.39, -1.67}, {-0.36, 11.77, -0.76}, {-0.16, 
      11.77, -0.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.78, 8.39, -1.67}, {-0.16, 11.77, -0.83}, {-0.34, 
      8.39, -1.81}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.36, 11.77, -0.76}, {-0.29, 13.13, -0.62}, {-0.13, 
      13.13, -0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.36, 11.77, -0.76}, {-0.13, 13.13, -0.67}, {-0.16, 
      11.77, -0.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.29, 13.13, -0.62}, {-0.29, 10.25, -0.62}, {-0.13, 
      10.25, -0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.29, 13.13, -0.62}, {-0.13, 10.25, -0.67}, {-0.13, 
      13.13, -0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.29, 10.25, -0.62}, {-0.01, 10.25, 0.}, {-0.13, 
      10.25, -0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {-0.27, -10.69, -1.43}, {0.08, -10.69, 
      -1.45}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.27, -10.69, -1.43}, {-0.5, -9.84, -2.72}, {
      0.17, -9.84, -2.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.27, -10.69, -1.43}, {0.17, -9.84, -2.76}, {
      0.08, -10.69, -1.45}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.5, -9.84, -2.72}, {-0.69, -8.83, -3.77}, {
      0.25, -8.83, -3.82}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.5, -9.84, -2.72}, {0.25, -8.83, -3.82}, {
      0.17, -9.84, -2.76}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, -8.83, -3.77}, {-0.86, -6.96, -4.67}, {
      0.31, -6.96, -4.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.69, -8.83, -3.77}, {0.31, -6.96, -4.75}, {
      0.25, -8.83, -3.82}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.86, -6.96, -4.67}, {-0.96, -4.1, -5.21}, {
      0.35, -4.1, -5.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.86, -6.96, -4.67}, {0.35, -4.1, -5.28}, {
      0.31, -6.96, -4.75}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.96, -4.1, -5.21}, {-0.95, -0.72, -5.13}, {
      0.34, -0.72, -5.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.96, -4.1, -5.21}, {0.34, -0.72, -5.21}, {
      0.35, -4.1, -5.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.95, -0.72, -5.13}, {-0.79, 2.82, -4.3}, {0.28, 
      2.82, -4.36}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.95, -0.72, -5.13}, {0.28, 2.82, -4.36}, {
      0.34, -0.72, -5.21}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.79, 2.82, -4.3}, {-0.34, 8.39, -1.81}, {0.1, 
      8.39, -1.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.79, 2.82, -4.3}, {0.1, 8.39, -1.83}, {0.28, 
      2.82, -4.36}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.34, 8.39, -1.81}, {-0.16, 11.77, -0.83}, {0.03, 
      11.77, -0.84}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.34, 8.39, -1.81}, {0.03, 11.77, -0.84}, {0.1, 
      8.39, -1.83}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.16, 11.77, -0.83}, {-0.13, 13.13, -0.67}, {0.03, 
      13.13, -0.68}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.16, 11.77, -0.83}, {0.03, 13.13, -0.68}, {0.03, 
      11.77, -0.84}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.13, 13.13, -0.67}, {-0.13, 10.25, -0.67}, {0.03, 
      10.25, -0.68}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.13, 13.13, -0.67}, {0.03, 10.25, -0.68}, {0.03, 
      13.13, -0.68}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.13, 10.25, -0.67}, {-0.01, 10.25, 0.}, {0.03, 
      10.25, -0.68}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {0.08, -10.69, -1.45}, {
      0.44, -10.69, -1.38}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.08, -10.69, -1.45}, {0.17, -9.84, -2.76}, {
      0.85, -9.84, -2.62}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.08, -10.69, -1.45}, {0.85, -9.84, -2.62}, {
      0.44, -10.69, -1.38}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.17, -9.84, -2.76}, {0.25, -8.83, -3.82}, {
      1.19, -8.83, -3.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.17, -9.84, -2.76}, {1.19, -8.83, -3.64}, {
      0.85, -9.84, -2.62}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.25, -8.83, -3.82}, {0.31, -6.96, -4.75}, {
      1.48, -6.96, -4.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.25, -8.83, -3.82}, {1.48, -6.96, -4.51}, {
      1.19, -8.83, -3.64}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.31, -6.96, -4.75}, {0.35, -4.1, -5.28}, {
      1.65, -4.1, -5.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.31, -6.96, -4.75}, {1.65, -4.1, -5.02}, {
      1.48, -6.96, -4.51}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.35, -4.1, -5.28}, {0.34, -0.72, -5.21}, {
      1.62, -0.72, -4.94}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.35, -4.1, -5.28}, {1.62, -0.72, -4.94}, {
      1.65, -4.1, -5.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.34, -0.72, -5.21}, {0.28, 2.82, -4.36}, {1.36, 
      2.82, -4.15}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.34, -0.72, -5.21}, {1.36, 2.82, -4.15}, {
      1.62, -0.72, -4.94}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.28, 2.82, -4.36}, {0.1, 8.39, -1.83}, {0.56, 
      8.39, -1.74}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.28, 2.82, -4.36}, {0.56, 8.39, -1.74}, {1.36, 
      2.82, -4.15}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.1, 8.39, -1.83}, {0.03, 11.77, -0.84}, {0.24, 
      11.77, -0.8}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.1, 8.39, -1.83}, {0.24, 11.77, -0.8}, {0.56, 
      8.39, -1.74}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.03, 11.77, -0.84}, {0.03, 13.13, -0.68}, {0.19, 
      13.13, -0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.03, 11.77, -0.84}, {0.19, 13.13, -0.65}, {0.24, 
      11.77, -0.8}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.03, 13.13, -0.68}, {0.03, 10.25, -0.68}, {0.19, 
      10.25, -0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.03, 13.13, -0.68}, {0.19, 10.25, -0.65}, {0.19, 
      13.13, -0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.03, 10.25, -0.68}, {-0.01, 10.25, 0.}, {0.19, 
      10.25, -0.65}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {0.44, -10.69, -1.38}, {
      0.76, -10.69, -1.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.44, -10.69, -1.38}, {0.85, -9.84, -2.62}, {
      1.48, -9.84, -2.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.44, -10.69, -1.38}, {1.48, -9.84, -2.32}, {
      0.76, -10.69, -1.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.85, -9.84, -2.62}, {1.19, -8.83, -3.64}, {
      2.05, -8.83, -3.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.85, -9.84, -2.62}, {2.05, -8.83, -3.22}, {
      1.48, -9.84, -2.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.19, -8.83, -3.64}, {1.48, -6.96, -4.51}, {
      2.55, -6.96, -4.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.19, -8.83, -3.64}, {2.55, -6.96, -4.}, {
      2.05, -8.83, -3.22}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.48, -6.96, -4.51}, {1.65, -4.1, -5.02}, {
      2.84, -4.1, -4.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.48, -6.96, -4.51}, {2.84, -4.1, -4.44}, {
      2.55, -6.96, -4.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.65, -4.1, -5.02}, {1.62, -0.72, -4.94}, {
      2.81, -0.72, -4.38}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.65, -4.1, -5.02}, {2.81, -0.72, -4.38}, {
      2.84, -4.1, -4.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.62, -0.72, -4.94}, {1.36, 2.82, -4.15}, {2.33, 
      2.82, -3.68}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.62, -0.72, -4.94}, {2.33, 2.82, -3.68}, {
      2.81, -0.72, -4.38}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.36, 2.82, -4.15}, {0.56, 8.39, -1.74}, {0.98, 
      8.39, -1.54}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.36, 2.82, -4.15}, {0.98, 8.39, -1.54}, {2.33, 
      2.82, -3.68}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.56, 8.39, -1.74}, {0.24, 11.77, -0.8}, {0.43, 
      11.77, -0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.56, 8.39, -1.74}, {0.43, 11.77, -0.71}, {0.98, 
      8.39, -1.54}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.24, 11.77, -0.8}, {0.19, 13.13, -0.65}, {0.35, 
      13.13, -0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.24, 11.77, -0.8}, {0.35, 13.13, -0.57}, {0.43, 
      11.77, -0.71}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.19, 13.13, -0.65}, {0.19, 10.25, -0.65}, {0.35, 
      10.25, -0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.19, 13.13, -0.65}, {0.35, 10.25, -0.57}, {0.35, 
      13.13, -0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.19, 10.25, -0.65}, {-0.01, 10.25, 0.}, {0.35, 
      10.25, -0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {0.76, -10.69, -1.22}, {
      1.04, -10.69, -0.99}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.76, -10.69, -1.22}, {1.48, -9.84, -2.32}, {
      2.01, -9.84, -1.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.76, -10.69, -1.22}, {2.01, -9.84, -1.87}, {
      1.04, -10.69, -0.99}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.48, -9.84, -2.32}, {2.05, -8.83, -3.22}, {
      2.79, -8.83, -2.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.48, -9.84, -2.32}, {2.79, -8.83, -2.6}, {
      2.01, -9.84, -1.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.05, -8.83, -3.22}, {2.55, -6.96, -4.}, {
      3.47, -6.96, -3.23}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.05, -8.83, -3.22}, {3.47, -6.96, -3.23}, {
      2.79, -8.83, -2.6}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.55, -6.96, -4.}, {2.84, -4.1, -4.44}, {
      3.87, -4.1, -3.59}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.55, -6.96, -4.}, {3.87, -4.1, -3.59}, {
      3.47, -6.96, -3.23}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.84, -4.1, -4.44}, {2.81, -0.72, -4.38}, {
      3.8, -0.72, -3.55}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.84, -4.1, -4.44}, {3.8, -0.72, -3.55}, {
      3.87, -4.1, -3.59}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.81, -0.72, -4.38}, {2.33, 2.82, -3.68}, {3.19, 
      2.82, -2.97}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.81, -0.72, -4.38}, {3.19, 2.82, -2.97}, {
      3.8, -0.72, -3.55}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.33, 2.82, -3.68}, {0.98, 8.39, -1.54}, {1.33, 
      8.39, -1.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.33, 2.82, -3.68}, {1.33, 8.39, -1.25}, {3.19, 
      2.82, -2.97}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.98, 8.39, -1.54}, {0.43, 11.77, -0.71}, {0.58, 
      11.77, -0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.98, 8.39, -1.54}, {0.58, 11.77, -0.57}, {1.33, 
      8.39, -1.25}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.43, 11.77, -0.71}, {0.35, 13.13, -0.57}, {0.49, 
      13.13, -0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.43, 11.77, -0.71}, {0.49, 13.13, -0.47}, {0.58, 
      11.77, -0.57}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.35, 13.13, -0.57}, {0.35, 10.25, -0.57}, {0.49, 
      10.25, -0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.35, 13.13, -0.57}, {0.49, 10.25, -0.47}, {0.49, 
      13.13, -0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.35, 10.25, -0.57}, {-0.01, 10.25, 0.}, {0.49, 
      10.25, -0.47}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.04, -10.69, -0.99}, {
      1.26, -10.69, -0.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.04, -10.69, -0.99}, {2.01, -9.84, -1.87}, {
      2.41, -9.84, -1.31}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.04, -10.69, -0.99}, {2.41, -9.84, -1.31}, {
      1.26, -10.69, -0.69}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.01, -9.84, -1.87}, {2.79, -8.83, -2.6}, {
      3.35, -8.83, -1.82}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.01, -9.84, -1.87}, {3.35, -8.83, -1.82}, {
      2.41, -9.84, -1.31}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.79, -8.83, -2.6}, {3.47, -6.96, -3.23}, {
      4.17, -6.96, -2.26}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.79, -8.83, -2.6}, {4.17, -6.96, -2.26}, {
      3.35, -8.83, -1.82}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.47, -6.96, -3.23}, {3.87, -4.1, -3.59}, {
      4.63, -4.1, -2.52}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.47, -6.96, -3.23}, {4.63, -4.1, -2.52}, {
      4.17, -6.96, -2.26}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.87, -4.1, -3.59}, {3.8, -0.72, -3.55}, {
      4.57, -0.72, -2.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.87, -4.1, -3.59}, {4.57, -0.72, -2.48}, {
      4.63, -4.1, -2.52}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.8, -0.72, -3.55}, {3.19, 2.82, -2.97}, {3.83, 
      2.82, -2.08}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.8, -0.72, -3.55}, {3.83, 2.82, -2.08}, {
      4.57, -0.72, -2.48}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.19, 2.82, -2.97}, {1.33, 8.39, -1.25}, {1.6, 
      8.39, -0.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.19, 2.82, -2.97}, {1.6, 8.39, -0.87}, {3.83, 
      2.82, -2.08}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.33, 8.39, -1.25}, {0.58, 11.77, -0.57}, {0.72, 
      11.77, -0.4}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.33, 8.39, -1.25}, {0.72, 11.77, -0.4}, {1.6, 
      8.39, -0.87}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 11.77, -0.57}, {0.49, 13.13, -0.47}, {0.58, 
      13.13, -0.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 11.77, -0.57}, {0.58, 13.13, -0.32}, {0.72, 
      11.77, -0.4}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.49, 13.13, -0.47}, {0.49, 10.25, -0.47}, {0.58, 
      10.25, -0.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.49, 13.13, -0.47}, {0.58, 10.25, -0.32}, {0.58, 
      13.13, -0.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.49, 10.25, -0.47}, {-0.01, 10.25, 0.}, {0.58, 
      10.25, -0.32}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.26, -10.69, -0.69}, {
      1.39, -10.69, -0.35}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.26, -10.69, -0.69}, {2.41, -9.84, -1.31}, {
      2.66, -9.84, -0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.26, -10.69, -0.69}, {2.66, -9.84, -0.67}, {
      1.39, -10.69, -0.35}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.41, -9.84, -1.31}, {3.35, -8.83, -1.82}, {
      3.7, -8.83, -0.93}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.41, -9.84, -1.31}, {3.7, -8.83, -0.93}, {
      2.66, -9.84, -0.67}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.35, -8.83, -1.82}, {4.17, -6.96, -2.26}, {
      4.6, -6.96, -1.15}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.35, -8.83, -1.82}, {4.6, -6.96, -1.15}, {
      3.7, -8.83, -0.93}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.17, -6.96, -2.26}, {4.63, -4.1, -2.52}, {
      5.12, -4.1, -1.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.17, -6.96, -2.26}, {5.12, -4.1, -1.28}, {
      4.6, -6.96, -1.15}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.63, -4.1, -2.52}, {4.57, -0.72, -2.48}, {
      5.04, -0.72, -1.26}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.63, -4.1, -2.52}, {5.04, -0.72, -1.26}, {
      5.12, -4.1, -1.28}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.57, -0.72, -2.48}, {3.83, 2.82, -2.08}, {4.23, 
      2.82, -1.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.57, -0.72, -2.48}, {4.23, 2.82, -1.04}, {
      5.04, -0.72, -1.26}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.83, 2.82, -2.08}, {1.6, 8.39, -0.87}, {1.76, 
      8.39, -0.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.83, 2.82, -2.08}, {1.76, 8.39, -0.44}, {4.23, 
      2.82, -1.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.6, 8.39, -0.87}, {0.72, 11.77, -0.4}, {0.79, 
      11.77, -0.2}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.6, 8.39, -0.87}, {0.79, 11.77, -0.2}, {1.76, 
      8.39, -0.44}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.72, 11.77, -0.4}, {0.58, 13.13, -0.32}, {0.65, 
      13.13, -0.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.72, 11.77, -0.4}, {0.65, 13.13, -0.16}, {0.79, 
      11.77, -0.2}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 13.13, -0.32}, {0.58, 10.25, -0.32}, {0.65, 
      10.25, -0.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 13.13, -0.32}, {0.65, 10.25, -0.16}, {0.65, 
      13.13, -0.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.58, 10.25, -0.32}, {-0.01, 10.25, 0.}, {0.65, 
      10.25, -0.16}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{-0.01, -11.2, 0.}, {1.39, -10.69, -0.35}, {1.43, -10.69, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.39, -10.69, -0.35}, {2.66, -9.84, -0.67}, {2.74, -9.84, 
      0.01}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.39, -10.69, -0.35}, {2.74, -9.84, 0.01}, {1.43, -10.69, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.66, -9.84, -0.67}, {3.7, -8.83, -0.93}, {3.81, -8.83, 
      0.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{2.66, -9.84, -0.67}, {3.81, -8.83, 0.02}, {2.74, -9.84, 
      0.01}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.7, -8.83, -0.93}, {4.6, -6.96, -1.15}, {4.73, -6.96, 
      0.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{3.7, -8.83, -0.93}, {4.73, -6.96, 0.04}, {3.81, -8.83, 
      0.02}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.6, -6.96, -1.15}, {5.12, -4.1, -1.28}, {5.27, -4.1, 
      0.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.6, -6.96, -1.15}, {5.27, -4.1, 0.04}, {4.73, -6.96, 
      0.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.12, -4.1, -1.28}, {5.04, -0.72, -1.26}, {5.19, -0.72, 
      0.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.12, -4.1, -1.28}, {5.19, -0.72, 0.04}, {5.27, -4.1, 
      0.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.04, -0.72, -1.26}, {4.23, 2.82, -1.04}, {4.35, 2.82, 
      0.03}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{5.04, -0.72, -1.26}, {4.35, 2.82, 0.03}, {5.19, -0.72, 
      0.04}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.23, 2.82, -1.04}, {1.76, 8.39, -0.44}, {1.82, 8.39, 
      0.01}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{4.23, 2.82, -1.04}, {1.82, 8.39, 0.01}, {4.35, 2.82, 
      0.03}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.76, 8.39, -0.44}, {0.79, 11.77, -0.2}, {0.82, 11.77, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{1.76, 8.39, -0.44}, {0.82, 11.77, 0.}, {1.82, 8.39, 
      0.01}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.79, 11.77, -0.2}, {0.65, 13.13, -0.16}, {0.66, 13.13, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.79, 11.77, -0.2}, {0.66, 13.13, 0.}, {0.82, 11.77, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.65, 13.13, -0.16}, {0.65, 10.25, -0.16}, {0.66, 10.25, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.65, 13.13, -0.16}, {0.66, 10.25, 0.}, {0.66, 13.13, 
      0.}}]}, 
    {RGBColor[1., 0., 1.], 
     Polygon3DBox[{{0.65, 10.25, -0.16}, {-0.01, 10.25, 0.}, {0.66, 10.25, 
      0.}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.45, 31.43, 3.06}, {0.43, 31.43, 
      2.94}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.45, 31.43, 3.06}, {0.99, 5.73, 3.05}, {0.96, 5.73, 
      2.81}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.45, 31.43, 3.06}, {0.96, 5.73, 2.81}, {0.43, 31.43, 
      2.94}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.99, 5.73, 3.05}, {0., 2.76, 3.06}, {0.96, 5.73, 
      2.81}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.43, 31.43, 2.94}, {0.39, 31.43, 
      2.84}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.43, 31.43, 2.94}, {0.96, 5.73, 2.81}, {0.86, 5.73, 
      2.58}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.43, 31.43, 2.94}, {0.86, 5.73, 2.58}, {0.39, 31.43, 
      2.84}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.96, 5.73, 2.81}, {0., 2.76, 3.06}, {0.86, 5.73, 
      2.58}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.39, 31.43, 2.84}, {0.33, 31.43, 
      2.74}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.39, 31.43, 2.84}, {0.86, 5.73, 2.58}, {0.71, 5.73, 
      2.38}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.39, 31.43, 2.84}, {0.71, 5.73, 2.38}, {0.33, 31.43, 
      2.74}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.86, 5.73, 2.58}, {0., 2.76, 3.06}, {0.71, 5.73, 
      2.38}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.33, 31.43, 2.74}, {0.23, 31.43, 
      2.68}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.33, 31.43, 2.74}, {0.71, 5.73, 2.38}, {0.52, 5.73, 
      2.21}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.33, 31.43, 2.74}, {0.52, 5.73, 2.21}, {0.23, 31.43, 
      2.68}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.71, 5.73, 2.38}, {0., 2.76, 3.06}, {0.52, 5.73, 
      2.21}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.23, 31.43, 2.68}, {0.13, 31.43, 
      2.62}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.23, 31.43, 2.68}, {0.52, 5.73, 2.21}, {0.29, 5.73, 
      2.1}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.23, 31.43, 2.68}, {0.29, 5.73, 2.1}, {0.13, 31.43, 
      2.62}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.52, 5.73, 2.21}, {0., 2.76, 3.06}, {0.29, 5.73, 
      2.1}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.13, 31.43, 2.62}, {0.02, 31.43, 
      2.61}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.13, 31.43, 2.62}, {0.29, 5.73, 2.1}, {0.04, 5.73, 
      2.07}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.13, 31.43, 2.62}, {0.04, 5.73, 2.07}, {0.02, 31.43, 
      2.61}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.29, 5.73, 2.1}, {0., 2.76, 3.06}, {0.04, 5.73, 
      2.07}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.02, 31.43, 2.61}, {-0.08, 31.43, 
      2.61}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.02, 31.43, 2.61}, {0.04, 5.73, 2.07}, {-0.19, 5.73, 
      2.08}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.02, 31.43, 2.61}, {-0.19, 5.73, 2.08}, {-0.08, 31.43, 
      2.61}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.04, 5.73, 2.07}, {0., 2.76, 3.06}, {-0.19, 5.73, 
      2.08}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.08, 31.43, 2.61}, {-0.19, 31.43,
       2.64}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.08, 31.43, 2.61}, {-0.19, 5.73, 2.08}, {-0.43, 5.73, 
      2.16}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.08, 31.43, 2.61}, {-0.43, 5.73, 2.16}, {-0.19, 31.43, 
      2.64}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.19, 5.73, 2.08}, {0., 2.76, 3.06}, {-0.43, 5.73, 
      2.16}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.19, 31.43, 2.64}, {-0.29, 31.43,
       2.71}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.19, 31.43, 2.64}, {-0.43, 5.73, 2.16}, {-0.63, 5.73, 
      2.3}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.19, 31.43, 2.64}, {-0.63, 5.73, 2.3}, {-0.29, 31.43, 
      2.71}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.43, 5.73, 2.16}, {0., 2.76, 3.06}, {-0.63, 5.73, 
      2.3}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.29, 31.43, 2.71}, {-0.36, 31.43,
       2.8}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.29, 31.43, 2.71}, {-0.63, 5.73, 2.3}, {-0.8, 5.73, 
      2.48}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.29, 31.43, 2.71}, {-0.8, 5.73, 2.48}, {-0.36, 31.43, 
      2.8}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.63, 5.73, 2.3}, {0., 2.76, 3.06}, {-0.8, 5.73, 
      2.48}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.36, 31.43, 2.8}, {-0.42, 31.43, 
      2.9}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.36, 31.43, 2.8}, {-0.8, 5.73, 2.48}, {-0.92, 5.73, 
      2.71}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.36, 31.43, 2.8}, {-0.92, 5.73, 2.71}, {-0.42, 31.43, 
      2.9}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.8, 5.73, 2.48}, {0., 2.76, 3.06}, {-0.92, 5.73, 
      2.71}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.42, 31.43, 2.9}, {-0.45, 31.43, 
      3.01}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.42, 31.43, 2.9}, {-0.92, 5.73, 2.71}, {-0.99, 5.73, 
      2.94}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.42, 31.43, 2.9}, {-0.99, 5.73, 2.94}, {-0.45, 31.43, 
      3.01}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.92, 5.73, 2.71}, {0., 2.76, 3.06}, {-0.99, 5.73, 
      2.94}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.45, 31.43, 3.01}, {-0.45, 31.43,
       3.12}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.45, 31.43, 3.01}, {-0.99, 5.73, 2.94}, {-0.98, 5.73, 
      3.19}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.45, 31.43, 3.01}, {-0.98, 5.73, 3.19}, {-0.45, 31.43, 
      3.12}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.99, 5.73, 2.94}, {0., 2.76, 3.06}, {-0.98, 5.73, 
      3.19}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.45, 31.43, 3.12}, {-0.42, 31.43,
       3.23}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.45, 31.43, 3.12}, {-0.98, 5.73, 3.19}, {-0.92, 5.73, 
      3.43}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.45, 31.43, 3.12}, {-0.92, 5.73, 3.43}, {-0.42, 31.43, 
      3.23}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.98, 5.73, 3.19}, {0., 2.76, 3.06}, {-0.92, 5.73, 
      3.43}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.42, 31.43, 3.23}, {-0.36, 31.43,
       3.33}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.42, 31.43, 3.23}, {-0.92, 5.73, 3.43}, {-0.79, 5.73, 
      3.65}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.42, 31.43, 3.23}, {-0.79, 5.73, 3.65}, {-0.36, 31.43, 
      3.33}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.92, 5.73, 3.43}, {0., 2.76, 3.06}, {-0.79, 5.73, 
      3.65}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.36, 31.43, 3.33}, {-0.28, 31.43,
       3.41}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.36, 31.43, 3.33}, {-0.79, 5.73, 3.65}, {-0.62, 5.73, 
      3.83}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.36, 31.43, 3.33}, {-0.62, 5.73, 3.83}, {-0.28, 31.43, 
      3.41}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.79, 5.73, 3.65}, {0., 2.76, 3.06}, {-0.62, 5.73, 
      3.83}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.28, 31.43, 3.41}, {-0.19, 31.43,
       3.47}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.28, 31.43, 3.41}, {-0.62, 5.73, 3.83}, {-0.41, 5.73, 
      3.97}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.28, 31.43, 3.41}, {-0.41, 5.73, 3.97}, {-0.19, 31.43, 
      3.47}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.62, 5.73, 3.83}, {0., 2.76, 3.06}, {-0.41, 5.73, 
      3.97}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.19, 31.43, 3.47}, {-0.07, 31.43,
       3.51}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.19, 31.43, 3.47}, {-0.41, 5.73, 3.97}, {-0.17, 5.73, 
      4.03}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.19, 31.43, 3.47}, {-0.17, 5.73, 4.03}, {-0.07, 31.43, 
      3.51}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.41, 5.73, 3.97}, {0., 2.76, 3.06}, {-0.17, 5.73, 
      4.03}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {-0.07, 31.43, 3.51}, {0.03, 31.43, 
      3.51}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.07, 31.43, 3.51}, {-0.17, 5.73, 4.03}, {0.06, 5.73, 
      4.05}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.07, 31.43, 3.51}, {0.06, 5.73, 4.05}, {0.03, 31.43, 
      3.51}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{-0.17, 5.73, 4.03}, {0., 2.76, 3.06}, {0.06, 5.73, 
      4.05}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.03, 31.43, 3.51}, {0.13, 31.43, 
      3.49}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.03, 31.43, 3.51}, {0.06, 5.73, 4.05}, {0.31, 5.73, 
      4.}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.03, 31.43, 3.51}, {0.31, 5.73, 4.}, {0.13, 31.43, 
      3.49}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.06, 5.73, 4.05}, {0., 2.76, 3.06}, {0.31, 5.73, 
      4.}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.13, 31.43, 3.49}, {0.24, 31.43, 
      3.44}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.13, 31.43, 3.49}, {0.31, 5.73, 4.}, {0.52, 5.73, 
      3.9}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.13, 31.43, 3.49}, {0.52, 5.73, 3.9}, {0.24, 31.43, 
      3.44}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.31, 5.73, 4.}, {0., 2.76, 3.06}, {0.52, 5.73, 3.9}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.24, 31.43, 3.44}, {0.33, 31.43, 
      3.37}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.24, 31.43, 3.44}, {0.52, 5.73, 3.9}, {0.72, 5.73, 
      3.74}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.24, 31.43, 3.44}, {0.72, 5.73, 3.74}, {0.33, 31.43, 
      3.37}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.52, 5.73, 3.9}, {0., 2.76, 3.06}, {0.72, 5.73, 
      3.74}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.33, 31.43, 3.37}, {0.39, 31.43, 
      3.27}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.33, 31.43, 3.37}, {0.72, 5.73, 3.74}, {0.87, 5.73, 
      3.53}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.33, 31.43, 3.37}, {0.87, 5.73, 3.53}, {0.39, 31.43, 
      3.27}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.72, 5.73, 3.74}, {0., 2.76, 3.06}, {0.87, 5.73, 
      3.53}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.39, 31.43, 3.27}, {0.44, 31.43, 
      3.17}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.39, 31.43, 3.27}, {0.87, 5.73, 3.53}, {0.96, 5.73, 
      3.3}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.39, 31.43, 3.27}, {0.96, 5.73, 3.3}, {0.44, 31.43, 
      3.17}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.87, 5.73, 3.53}, {0., 2.76, 3.06}, {0.96, 5.73, 
      3.3}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0., 31.620001, 3.06}, {0.44, 31.43, 3.17}, {0.45, 31.43, 
      3.06}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.44, 31.43, 3.17}, {0.96, 5.73, 3.3}, {0.99, 5.73, 
      3.05}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.44, 31.43, 3.17}, {0.99, 5.73, 3.05}, {0.45, 31.43, 
      3.06}}]}, 
    {RGBColor[0., 0., 0.], 
     Polygon3DBox[{{0.96, 5.73, 3.3}, {0., 2.76, 3.06}, {0.99, 5.73, 
      3.05}}]}}},
  Boxed->False,
  ImageSize->Medium,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0, 0, 1}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1884880985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647822202],

Cell["Import a 3D model that does not store color information:", "ExampleText",
 CellID->998637302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/spikey.dxf\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563049405],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[
   None], {}, {{{}, 
     Polygon3DBox[{{-0.29494374842358073`, 0.9077435189160142, 
      1.2494017678608846`}, {0., 0., 0.9510565162951536}, {0.2628655560595668,
       0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.29494374842358073`, 0.9077435189160142, 
      1.2494017678608846`}, {0.2628655560595668, 0.8090169943749475, 
      0.42532540417602}, {-0.6881909602355868, 0.5, 0.42532540417602}}]}, {{},
      Polygon3DBox[{{-0.29494374842358073`, 0.9077435189160142, 
      1.2494017678608846`}, {-0.6881909602355868, 0.5, 0.42532540417602}, {0.,
       0., 0.9510565162951536}}]}, {{}, 
     Polygon3DBox[{{-0.9544580194373125, 0., 1.2494017678608846`}, {0., 0., 
      0.9510565162951536}, {-0.6881909602355868, 0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.9544580194373125, 0., 
      1.2494017678608846`}, {-0.6881909602355868, 0.5, 
      0.42532540417602}, {-0.6881909602355868, -0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.9544580194373125, 0., 
      1.2494017678608846`}, {-0.6881909602355868, -0.5, 0.42532540417602}, {
      0., 0., 0.9510565162951536}}]}, {{}, 
     Polygon3DBox[{{-0.29494374842358073`, -0.9077435189160141, 
      1.2494017678608846`}, {0., 0., 
      0.9510565162951536}, {-0.6881909602355868, -0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.29494374842358073`, -0.9077435189160141, 
      1.2494017678608846`}, {-0.6881909602355868, -0.5, 0.42532540417602}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.29494374842358073`, -0.9077435189160141, 
      1.2494017678608846`}, {0.2628655560595668, -0.8090169943749475, 
      0.42532540417602}, {0., 0., 0.9510565162951536}}]}, {{}, 
     Polygon3DBox[{{0.7721727581422327, -0.5610163477575298, 
      1.2494017678608846`}, {0., 0., 0.9510565162951536}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{0.7721727581422327, -0.5610163477575298, 
      1.2494017678608846`}, {0.2628655560595668, -0.8090169943749475, 
      0.42532540417602}, {0.85065080835204, 0., 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{0.7721727581422327, -0.5610163477575298, 
      1.2494017678608846`}, {0.85065080835204, 0., 0.42532540417602}, {0., 0.,
       0.9510565162951536}}]}, {{}, 
     Polygon3DBox[{{0.7721727581422327, 0.5610163477575296, 
      1.2494017678608846`}, {0., 0., 0.9510565162951536}, {0.85065080835204, 
      0., 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{0.7721727581422327, 0.5610163477575296, 
      1.2494017678608846`}, {0.85065080835204, 0., 0.42532540417602}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{0.7721727581422327, 0.5610163477575296, 
      1.2494017678608846`}, {0.2628655560595668, 0.8090169943749475, 
      0.42532540417602}, {0., 0., 0.9510565162951536}}]}, {{}, 
     Polygon3DBox[{{
      0.29494374842358073`, -0.9077435189160141, -1.2494017678608846`}, {
      0.6881909602355868, -0.5, -0.4253254041760197}, {-0.2628655560595671, \
-0.8090169943749475, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{
      0.29494374842358073`, -0.9077435189160141, -1.2494017678608846`}, \
{-0.2628655560595671, -0.8090169943749475, -0.4253254041760197}, {0., 
      0., -0.9510565162951532}}]}, {{}, 
     Polygon3DBox[{{
      0.29494374842358073`, -0.9077435189160141, -1.2494017678608846`}, {0., 
      0., -0.9510565162951532}, {
      0.6881909602355868, -0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{0.954458019437308, 0., -1.2494017678608846`}, {
      0.6881909602355868, 0.5, -0.4253254041760197}, {
      0.6881909602355868, -0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{0.954458019437308, 0., -1.2494017678608846`}, {
      0.6881909602355868, -0.5, -0.4253254041760197}, {0., 
      0., -0.9510565162951532}}]}, {{}, 
     Polygon3DBox[{{0.954458019437308, 0., -1.2494017678608846`}, {0., 
      0., -0.9510565162951532}, {0.6881909602355868, 
      0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{0.29494374842358073`, 
      0.9077435189160142, -1.2494017678608846`}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}, {0.6881909602355868, 
      0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{0.29494374842358073`, 
      0.9077435189160142, -1.2494017678608846`}, {0.6881909602355868, 
      0.5, -0.4253254041760197}, {0., 0., -0.9510565162951532}}]}, {{}, 
     Polygon3DBox[{{0.29494374842358073`, 
      0.9077435189160142, -1.2494017678608846`}, {0., 
      0., -0.9510565162951532}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.7721727581422326, 
      0.5610163477575296, -1.2494017678608846`}, {-0.8506508083520394, 
      0., -0.4253254041760197}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.7721727581422326, 
      0.5610163477575296, -1.2494017678608846`}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}, {0., 
      0., -0.9510565162951532}}]}, {{}, 
     Polygon3DBox[{{-0.7721727581422326, 
      0.5610163477575296, -1.2494017678608846`}, {0., 
      0., -0.9510565162951532}, {-0.8506508083520394, 
      0., -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.7721727581422326, -0.5610163477575298, \
-1.2494017678608846`}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}, {-0.8506508083520394, 0., -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.7721727581422326, -0.5610163477575298, \
-1.2494017678608846`}, {-0.8506508083520394, 0., -0.4253254041760197}, {0., 
      0., -0.9510565162951532}}]}, {{}, 
     Polygon3DBox[{{-0.7721727581422326, -0.5610163477575298, \
-1.2494017678608846`}, {0., 
      0., -0.9510565162951532}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.4772290097186562, 1.468759866673544, 
      0.29494374842358073`}, {0.2628655560595668, 0.8090169943749475, 
      0.42532540417602}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.4772290097186562, 1.468759866673544, 
      0.29494374842358073`}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}, {-0.6881909602355868, 0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.4772290097186562, 1.468759866673544, 
      0.29494374842358073`}, {-0.6881909602355868, 0.5, 0.42532540417602}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-1.5443455162844653`, 0., 
      0.29494374842358073`}, {-0.6881909602355868, 0.5, 
      0.42532540417602}, {-0.8506508083520394, 
      0., -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-1.5443455162844653`, 0., 
      0.29494374842358073`}, {-0.8506508083520394, 
      0., -0.4253254041760197}, {-0.6881909602355868, -0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-1.5443455162844653`, 0., 
      0.29494374842358073`}, {-0.6881909602355868, -0.5, 
      0.42532540417602}, {-0.6881909602355868, 0.5, 0.42532540417602}}]}, {{},
      Polygon3DBox[{{-0.4772290097186562, -1.468759866673544, 
      0.29494374842358073`}, {-0.6881909602355868, -0.5, 
      0.42532540417602}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-0.4772290097186562, -1.468759866673544, 
      0.29494374842358073`}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}, {0.2628655560595668, -0.8090169943749475, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-0.4772290097186562, -1.468759866673544, 
      0.29494374842358073`}, {0.2628655560595668, -0.8090169943749475, 
      0.42532540417602}, {-0.6881909602355868, -0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{1.2494017678608846`, -0.9077435189160141, 
      0.29494374842358073`}, {0.2628655560595668, -0.8090169943749475, 
      0.42532540417602}, {
      0.6881909602355868, -0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{1.2494017678608846`, -0.9077435189160141, 
      0.29494374842358073`}, {
      0.6881909602355868, -0.5, -0.4253254041760197}, {0.85065080835204, 0., 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{1.2494017678608846`, -0.9077435189160141, 
      0.29494374842358073`}, {0.85065080835204, 0., 0.42532540417602}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{1.2494017678608846`, 0.9077435189160142, 
      0.29494374842358073`}, {0.85065080835204, 0., 0.42532540417602}, {
      0.6881909602355868, 0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{1.2494017678608846`, 0.9077435189160142, 
      0.29494374842358073`}, {0.6881909602355868, 0.5, -0.4253254041760197}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{1.2494017678608846`, 0.9077435189160142, 
      0.29494374842358073`}, {0.2628655560595668, 0.8090169943749475, 
      0.42532540417602}, {0.85065080835204, 0., 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{
      0.477229009718654, -1.468759866673544, -0.29494374842358073`}, {
      0.6881909602355868, -0.5, -0.4253254041760197}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{
      0.477229009718654, -1.468759866673544, -0.29494374842358073`}, {
      0.2628655560595668, -0.8090169943749475, 
      0.42532540417602}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{
      0.477229009718654, -1.468759866673544, -0.29494374842358073`}, \
{-0.2628655560595671, -0.8090169943749475, -0.4253254041760197}, {
      0.6881909602355868, -0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{1.5443455162844655`, 0., -0.29494374842358073`}, {
      0.6881909602355868, 0.5, -0.4253254041760197}, {0.85065080835204, 0., 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{1.5443455162844655`, 0., -0.29494374842358073`}, {
      0.85065080835204, 0., 0.42532540417602}, {
      0.6881909602355868, -0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{1.5443455162844655`, 0., -0.29494374842358073`}, {
      0.6881909602355868, -0.5, -0.4253254041760197}, {0.6881909602355868, 
      0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{0.477229009718654, 
      1.468759866673544, -0.29494374842358073`}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}, {0.2628655560595668, 
      0.8090169943749475, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{0.477229009718654, 
      1.468759866673544, -0.29494374842358073`}, {0.2628655560595668, 
      0.8090169943749475, 0.42532540417602}, {0.6881909602355868, 
      0.5, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{0.477229009718654, 
      1.468759866673544, -0.29494374842358073`}, {0.6881909602355868, 
      0.5, -0.4253254041760197}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-1.2494017678608846`, 
      0.9077435189160142, -0.29494374842358073`}, {-0.8506508083520394, 
      0., -0.4253254041760197}, {-0.6881909602355868, 0.5, 
      0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-1.2494017678608846`, 
      0.9077435189160142, -0.29494374842358073`}, {-0.6881909602355868, 0.5, 
      0.42532540417602}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-1.2494017678608846`, 
      0.9077435189160142, -0.29494374842358073`}, {-0.2628655560595671, 
      0.8090169943749475, -0.4253254041760197}, {-0.8506508083520394, 
      0., -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-1.2494017678608846`, -0.9077435189160141, \
-0.29494374842358073`}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}, {-0.6881909602355868, -0.5, 0.42532540417602}}]}, {{}, 
     Polygon3DBox[{{-1.2494017678608846`, -0.9077435189160141, \
-0.29494374842358073`}, {-0.6881909602355868, -0.5, 
      0.42532540417602}, {-0.8506508083520394, 
      0., -0.4253254041760197}}]}, {{}, 
     Polygon3DBox[{{-1.2494017678608846`, -0.9077435189160141, \
-0.29494374842358073`}, {-0.8506508083520394, 
      0., -0.4253254041760197}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}}]}}},
  Boxed->False,
  ImageSize->{180., 180.29084520667138`},
  ViewPoint->{1.615334330924532, -1.9528849962410688`, 2.2420827796477796`},
  ViewVertical->{0.020417098771862503`, 0.13748085841781707`, 
   1.2251965646140093`}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1251432413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1512433409],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SphericalPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFormula"],
 " to generate a 3D geometry:"
}], "ExampleText",
 CellID->1851859171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"1", "/", "5"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "v"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"Mesh", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<CandyColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1753412545],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyEfXdcj9/7f8gKlRHK9rayR/aLq+yQZAshREZSlGwliSijUklZmSUjxIur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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Xe8/UTRBvDcc5LQFAEBQaRIV5CqCNKbvPQuvRcpioB0pPcuRQVEunQF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        "]]]}, {}, {}, {}}, {}},
   VertexColors->{
     RGBColor[0.668652, 0.8448223333333333, 0.90035], 
     RGBColor[0.6698133391077379, 0.8414086850032626, 0.9026443467562413], 
     RGBColor[0.6732391220387599, 0.8313389145944741, 0.9094123388982496], 
     RGBColor[0.6822707157583063, 0.7910576705882794, 0.8900768529831532], 
     RGBColor[0.6943126005686433, 0.7372589733788628, 0.8640491753301991], 
     RGBColor[0.7348854857534413, 0.6802476781588082, 0.8148991700747503], 
     RGBColor[0.7829685130829585, 0.6129418416456649, 0.7485060597932393], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304737655368456, 0.42898823596265884`, 0.560668722076249], 
     RGBColor[0.7893355918917556, 0.336213781160218, 0.472808565446774], 
     RGBColor[0.7262796125876929, 0.2623167436703623, 0.40373126909294593`], 
     RGBColor[0.6429396358326019, 0.236848012149959, 0.37592699778355554`], 
     RGBColor[0.5801770314217432, 0.21779742678086855`, 0.3551389299505543], 
     RGBColor[0.5368971848300259, 0.21447124202947612`, 0.3522328325706689], 
     RGBColor[0.5222253333333333, 0.21334366666666668`, 0.3512476666666667], 
     RGBColor[0.6596202678215476, 0.8713702703339858, 0.8825068693512483], 
     RGBColor[0.6610080513116139, 0.8672910097960432, 0.8852485806460664], 
     RGBColor[0.6651018125227418, 0.8552577793390966, 0.8933362336778089], 
     RGBColor[0.6716962731737472, 0.8358739753846518, 0.9063642797523663], 
     RGBColor[0.6850670863084849, 0.778564518985862, 0.8840326969042158], 
     RGBColor[0.7151319810828958, 0.7052182490335465, 0.8379642427688545], 
     RGBColor[0.773547884711325, 0.6285038050886813, 0.7652455837042207], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303159764837198, 0.40868189846030495`, 0.540782673289187], 
     RGBColor[0.7635184462740451, 0.30050310399430763`, 0.43972898166924845`],
      
     RGBColor[0.6622928733299787, 0.2427623695695653, 0.3823837150403102], 
     RGBColor[0.5606853521366123, 0.21629943333766533`, 0.35383012868250807`],
      
     RGBColor[0.4773738139926933, 0.2098966941966633, 0.34823603670251013`], 
     RGBColor[0.42565502130553357`, 0.20592195137422964`, 0.344763292232391], 
     
     RGBColor[0.4081223702993385, 0.20457451507256189`, 0.34358603318080044`],
      
     RGBColor[0.664632501040815, 0.8566372768053305, 0.8924090598066705], 
     RGBColor[0.6658946173794427, 0.8529274031749631, 0.8949025025127979], 
     RGBColor[0.669617678611968, 0.8419838108387705, 0.9022577990021847], 
     RGBColor[0.6771111192206463, 0.8141088437413435, 0.9012289539720479], 
     RGBColor[0.6901979596324895, 0.7556416705509521, 0.8729426790989718], 
     RGBColor[0.7260943491370409, 0.6913606276637464, 0.8251640931100751], 
     RGBColor[0.778775939035536, 0.6198675669247329, 0.7559558487825505], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304035428019063, 0.419951065590147, 0.5518185977786533], 
     RGBColor[0.7778458811818774, 0.3203210346898764, 0.4580867656926517], 
     RGBColor[0.6978028346268014, 0.25361422849468124`, 0.3942307137619951], 
     RGBColor[0.6072308857252166, 0.2259354032817472, 0.36401367821277325`], 
     RGBColor[0.5344252955096905, 0.21428126999371566`, 0.35206685344544325`],
      
     RGBColor[0.4873897645844436, 0.21066644974693724`, 0.348908574386073], 
     RGBColor[0.47144473753031857`, 0.20944102706121726`, 0.3478379189888548],
      
     RGBColor[0.6775706568483387, 0.8120557992156776, 0.9002356960700361], 
     RGBColor[0.6791792404621059, 0.804869241285909, 0.8967588569840971], 
     RGBColor[0.6839243302041528, 0.7836699315196541, 0.8865026829560645], 
     RGBColor[0.6915679874610441, 0.7495208918292017, 0.8699814613777572], 
     RGBColor[0.7133779579855377, 0.7074355243372963, 0.8400123183343022], 
     RGBColor[0.750726566563149, 0.6602228350897662, 0.7964024179022664], 
     RGBColor[0.790523270469165, 0.6004621159174945, 0.7350820038896158], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.830600302532844, 0.44527265428178536`, 0.57661609501465], 
     RGBColor[0.8100393351933662, 0.36485152075070565`, 0.49933633196268934`],
      
     RGBColor[0.7612259989095607, 0.29733215516188577`, 0.4367916621928069], 
     RGBColor[0.7072845801495246, 0.2565118538656683, 0.3973940578768504], 
     RGBColor[0.6543840393997602, 0.24034542663472236`, 0.3797451330188283], 
     RGBColor[0.6215440251468795, 0.23030950463547917`, 0.36878889446869495`],
      
     RGBColor[0.6104112728334796, 0.22690733090334153`, 0.36507473377662225`],
      
     RGBColor[0.6775706568483387, 0.8120557992156774, 0.900235696070036], 
     RGBColor[0.6791792404621059, 0.8048692412859089, 0.896758856984097], 
     RGBColor[0.6839243302041529, 0.783669931519654, 0.8865026829560645], 
     RGBColor[0.6915679874610441, 0.7495208918292017, 0.8699814613777572], 
     RGBColor[0.7133779579855377, 0.7074355243372963, 0.8400123183343022], 
     RGBColor[0.750726566563149, 0.6602228350897662, 0.7964024179022663], 
     RGBColor[0.790523270469165, 0.6004621159174945, 0.7350820038896158], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.830600302532844, 0.44527265428178536`, 0.57661609501465], 
     RGBColor[0.8100393351933662, 0.36485152075070565`, 0.49933633196268934`],
      
     RGBColor[0.7612259989095607, 0.29733215516188577`, 0.4367916621928069], 
     RGBColor[0.7072845801495247, 0.2565118538656683, 0.39739405787685045`], 
     RGBColor[0.6543840393997602, 0.2403454266347224, 0.3797451330188283], 
     RGBColor[0.6215440251468796, 0.23030950463547917`, 0.368788894468695], 
     RGBColor[0.6104112728334796, 0.22690733090334156`, 0.36507473377662225`],
      
     RGBColor[0.664632501040815, 0.8566372768053305, 0.8924090598066705], 
     RGBColor[0.6658946173794427, 0.8529274031749631, 0.8949025025127979], 
     RGBColor[0.669617678611968, 0.8419838108387705, 0.9022577990021847], 
     RGBColor[0.6771111192206463, 0.8141088437413435, 0.9012289539720479], 
     RGBColor[0.6901979596324896, 0.755641670550952, 0.8729426790989717], 
     RGBColor[0.726094349137041, 0.6913606276637463, 0.825164093110075], 
     RGBColor[0.778775939035536, 0.6198675669247329, 0.7559558487825505], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304035428019063, 0.419951065590147, 0.5518185977786533], 
     RGBColor[0.7778458811818774, 0.3203210346898764, 0.4580867656926517], 
     RGBColor[0.6978028346268014, 0.25361422849468124`, 0.39423071376199514`],
      
     RGBColor[0.6072308857252167, 0.22593540328174722`, 0.36401367821277325`],
      
     RGBColor[0.5344252955096906, 0.21428126999371566`, 0.35206685344544325`],
      
     RGBColor[0.4873897645844438, 0.21066644974693724`, 0.348908574386073], 
     RGBColor[0.4714447375303187, 0.20944102706121728`, 0.3478379189888548], 
     RGBColor[0.6596202678215476, 0.8713702703339858, 0.8825068693512483], 
     RGBColor[0.6610080513116139, 0.8672910097960432, 0.8852485806460664], 
     RGBColor[0.6651018125227418, 0.8552577793390967, 0.8933362336778088], 
     RGBColor[0.6716962731737471, 0.8358739753846519, 0.9063642797523663], 
     RGBColor[0.6850670863084849, 0.778564518985862, 0.8840326969042158], 
     RGBColor[0.7151319810828958, 0.7052182490335465, 0.8379642427688546], 
     RGBColor[0.773547884711325, 0.6285038050886813, 0.7652455837042207], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303159764837198, 0.40868189846030495`, 0.540782673289187], 
     RGBColor[0.763518446274045, 0.3005031039943076, 0.4397289816692484], 
     RGBColor[0.6622928733299785, 0.24276236956956526`, 0.3823837150403102], 
     RGBColor[0.5606853521366122, 0.21629943333766533`, 0.35383012868250807`],
      
     RGBColor[0.4773738139926932, 0.20989669419666326`, 0.34823603670251013`],
      
     RGBColor[
     0.42565502130553345`, 0.20592195137422964`, 0.34476329223239094`], 
     RGBColor[0.4081223702993384, 0.20457451507256189`, 0.34358603318080044`],
      
     RGBColor[0.668652, 0.8448223333333333, 0.90035], 
     RGBColor[0.6698133391077379, 0.8414086850032626, 0.9026443467562413], 
     RGBColor[0.6732391220387599, 0.8313389145944741, 0.9094123388982496], 
     RGBColor[0.6822707157583063, 0.7910576705882794, 0.8900768529831532], 
     RGBColor[0.6943126005686433, 0.7372589733788628, 0.8640491753301991], 
     RGBColor[0.7348854857534413, 0.6802476781588082, 0.8148991700747503], 
     RGBColor[0.7829685130829585, 0.6129418416456649, 0.7485060597932393], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304737655368456, 0.42898823596265884`, 0.560668722076249], 
     RGBColor[0.7893355918917556, 0.336213781160218, 0.472808565446774], 
     RGBColor[0.7262796125876929, 0.2623167436703623, 0.40373126909294593`], 
     RGBColor[0.6429396358326019, 0.236848012149959, 0.37592699778355554`], 
     RGBColor[0.5801770314217432, 0.21779742678086855`, 0.3551389299505543], 
     RGBColor[0.5368971848300259, 0.21447124202947612`, 0.3522328325706689], 
     RGBColor[0.5222253333333333, 0.21334366666666668`, 0.3512476666666667], 
     RGBColor[0.6805076535442856, 0.7989343818928126, 0.8938875865777185], 
     RGBColor[0.6820426005189703, 0.7920768052904619, 0.8905699078504502], 
     RGBColor[0.6865704727923332, 0.7718479430089974, 0.8807832339334506], 
     RGBColor[0.6938642239418399, 0.7392621546715846, 0.8650183095225092], 
     RGBColor[0.7190001008728062, 0.7003285263753712, 0.8334476536555909], 
     RGBColor[0.7546389904239869, 0.6552771072840697, 0.791834097380646], 
     RGBColor[0.7923891414545919, 0.5973798782026484, 0.7317665358822577], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8306315545899713, 0.44929457346501267`, 0.580554770863311], 
     RGBColor[0.8151527375094663, 0.37192445832612836`, 0.5058881492242996], 
     RGBColor[0.7685739447057623, 0.30749594801669156`, 0.44620660651536703`],
      
     RGBColor[0.7231764689981406, 0.2613684217001772, 0.40269598387167144`], 
     RGBColor[0.6726975729755256, 0.24594205010393358`, 0.38585497940948144`],
      
     RGBColor[0.6413608864056488, 0.23636554566918205`, 0.3754002880446562], 
     RGBColor[0.6307377616037319, 0.23311911431628113`, 0.3718561516572175], 
     RGBColor[0.6726714989591851, 0.8330073898613362, 0.9082909401933296], 
     RGBColor[0.6740196439244458, 0.827920414438973, 0.9079109579729917], 
     RGBColor[0.6791561460201904, 0.8049724187292576, 0.8968087739779246], 
     RGBColor[0.6874303122959665, 0.7680064974352152, 0.8789247519942583], 
     RGBColor[0.7032472065608819, 0.720241892153177, 0.8518414353417773], 
     RGBColor[0.7436766223698418, 0.6691347286538698, 0.8046342470394255], 
     RGBColor[0.7871610871303809, 0.6060161163665967, 0.7410562708039279], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8305439882717848, 0.4380254063351706, 0.5695188463738448], 
     RGBColor[0.8008253026016339, 0.3521065276305596, 0.4875303652008963], 
     RGBColor[0.7479854580987363, 0.27901763327790763`, 0.41982651873748433`],
      
     RGBColor[0.6786483859399872, 0.24776062101817078`, 0.3878403173543378], 
     RGBColor[0.6213841921736597, 0.2302606596124597, 0.3687355702475394], 
     RGBColor[0.5858352750394943, 0.21939689576726742`, 0.3568755748979127], 
     RGBColor[0.5730059291363481, 0.21724630627211608`, 0.35465741434447856`],
      
     RGBColor[0.6614091131464161, 0.8661121258219261, 0.8860409202078702], 
     RGBColor[0.6627520465494042, 0.8621646979449505, 0.888694025469257], 
     RGBColor[0.6667135064699412, 0.8505203548307989, 0.896520303477209], 
     RGBColor[0.6730948487659952, 0.831762992465757, 0.9091273119727163], 
     RGBColor[0.6868982737965006, 0.7703834490991233, 0.8800747153746732], 
     RGBColor[0.7190444049437338, 0.70027252122785, 0.8333959222472342], 
     RGBColor[0.775413755696752, 0.625421567373835, 0.7619301156968626], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303472285408471, 0.41270381764353226`, 0.5447213491378479], 
     RGBColor[0.768631848590145, 0.30757604156973023`, 0.4462807989308587], 
     RGBColor[0.6749662317858269, 0.24663535317888835`, 0.38661185993100383`],
      
     RGBColor[0.5783543458522638, 0.2176573479814916, 0.35501654269239724`], 
     RGBColor[0.4977352520032383, 0.21146153118109146`, 0.34960323936871524`],
      
     RGBColor[0.447687896087163, 0.2076152432386703, 0.3462427263042874], 
     RGBColor[0.43072186150922837`, 0.2063113530923609, 0.3451035136564446], 
     RGBColor[0.6614091131464161, 0.8661121258219261, 0.8860409202078702], 
     RGBColor[0.6627520465494042, 0.8621646979449505, 0.888694025469257], 
     RGBColor[0.6667135064699412, 0.8505203548307989, 0.896520303477209], 
     RGBColor[0.6730948487659952, 0.8317629924657571, 0.9091273119727163], 
     RGBColor[0.6868982737965006, 0.7703834490991233, 0.8800747153746732], 
     RGBColor[0.7190444049437338, 0.70027252122785, 0.8333959222472342], 
     RGBColor[0.775413755696752, 0.625421567373835, 0.7619301156968626], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303472285408471, 0.41270381764353226`, 0.5447213491378479], 
     RGBColor[0.7686318485901449, 0.3075760415697302, 0.4462807989308586], 
     RGBColor[0.6749662317858269, 0.24663535317888835`, 0.38661185993100383`],
      
     RGBColor[0.5783543458522635, 0.2176573479814916, 0.35501654269239724`], 
     RGBColor[0.4977352520032383, 0.21146153118109146`, 0.34960323936871524`],
      
     RGBColor[0.44768789608716286`, 0.20761524323867028`, 0.3462427263042874],
      
     RGBColor[0.43072186150922825`, 0.2063113530923609, 0.3451035136564446], 
     RGBColor[0.6726714989591851, 0.8330073898613362, 0.9082909401933296], 
     RGBColor[0.6740196439244457, 0.8279204144389731, 0.9079109579729918], 
     RGBColor[0.6791561460201904, 0.8049724187292577, 0.8968087739779247], 
     RGBColor[0.6874303122959664, 0.7680064974352152, 0.8789247519942585], 
     RGBColor[0.7032472065608818, 0.7202418921531771, 0.8518414353417774], 
     RGBColor[0.7436766223698417, 0.6691347286538699, 0.8046342470394257], 
     RGBColor[0.7871610871303809, 0.6060161163665967, 0.7410562708039279], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8305439882717848, 0.4380254063351706, 0.5695188463738448], 
     RGBColor[0.8008253026016339, 0.3521065276305596, 0.4875303652008963], 
     RGBColor[0.7479854580987362, 0.2790176332779076, 0.4198265187374843], 
     RGBColor[0.6786483859399872, 0.24776062101817076`, 0.38784031735433777`],
      
     RGBColor[0.6213841921736596, 0.23026065961245964`, 0.36873557024753933`],
      
     RGBColor[0.5858352750394942, 0.21939689576726737`, 0.35687557489791266`],
      
     RGBColor[0.573005929136348, 0.21724630627211605`, 0.3546574143444785], 
     RGBColor[0.6805076535442856, 0.7989343818928126, 0.8938875865777185], 
     RGBColor[0.6820426005189703, 0.7920768052904618, 0.8905699078504502], 
     RGBColor[0.6865704727923332, 0.7718479430089974, 0.8807832339334506], 
     RGBColor[0.6938642239418399, 0.7392621546715846, 0.8650183095225092], 
     RGBColor[0.7190001008728062, 0.7003285263753712, 0.8334476536555909], 
     RGBColor[0.7546389904239869, 0.6552771072840697, 0.791834097380646], 
     RGBColor[0.7923891414545919, 0.5973798782026484, 0.7317665358822577], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8306315545899713, 0.44929457346501267`, 0.580554770863311], 
     RGBColor[0.8151527375094663, 0.37192445832612836`, 0.5058881492242996], 
     RGBColor[0.7685739447057625, 0.30749594801669167`, 0.44620660651536703`],
      
     RGBColor[0.7231764689981407, 0.2613684217001772, 0.40269598387167144`], 
     RGBColor[0.6726975729755256, 0.2459420501039336, 0.38585497940948144`], 
     RGBColor[0.6413608864056488, 0.23636554566918208`, 0.37540028804465625`],
      
     RGBColor[0.630737761603732, 0.23311911431628116`, 0.3718561516572175], 
     RGBColor[0.668652, 0.8448223333333333, 0.90035], 
     RGBColor[0.6698133391077379, 0.8414086850032626, 0.9026443467562413], 
     RGBColor[0.6732391220387599, 0.8313389145944741, 0.9094123388982496], 
     RGBColor[0.6822707157583063, 0.7910576705882794, 0.8900768529831532], 
     RGBColor[0.6943126005686433, 0.7372589733788628, 0.8640491753301991], 
     RGBColor[0.7348854857534414, 0.680247678158808, 0.8148991700747503], 
     RGBColor[0.7829685130829585, 0.6129418416456648, 0.7485060597932391], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304737655368456, 0.42898823596265884`, 0.560668722076249], 
     RGBColor[0.7893355918917556, 0.336213781160218, 0.472808565446774], 
     RGBColor[0.7262796125876929, 0.2623167436703623, 0.40373126909294593`], 
     RGBColor[0.6429396358326019, 0.236848012149959, 0.37592699778355554`], 
     RGBColor[0.5801770314217432, 0.21779742678086855`, 0.3551389299505543], 
     RGBColor[0.536897184830026, 0.21447124202947612`, 0.3522328325706689], 
     RGBColor[0.5222253333333334, 0.21334366666666668`, 0.3512476666666667], 
     RGBColor[0.6632035592488699, 0.860837518344895, 0.8895860359858395], 
     RGBColor[0.6657994450343147, 0.8532071534346851, 0.8947144796003915], 
     RGBColor[0.670861048052447, 0.838329041972492, 0.9047142052521465], 
     RGBColor[0.5501334824334618, 0.21548849081200452`, 0.35312160581766305`],
      
     RGBColor[
     0.48618739870784006`, 0.21057404435830265`, 0.34882783952680635`], 
     RGBColor[0.4533921104990357, 0.20805362905769664`, 0.34662574528106493`],
      
     RGBColor[0.6606491563609312, 0.8683459481348159, 0.8845395461698795], 
     RGBColor[0.6633731305734348, 0.860339079202467, 0.8899210418561102], 
     RGBColor[0.4555344006152796, 0.2082182704157155, 0.3467695929188004], 
     RGBColor[0.42112089911482753`, 0.20557349061756508`, 0.3444588410465355],
      
     RGBColor[0.6709917225060319, 0.8379449365658191, 0.9049723662894426], 
     RGBColor[0.6731970772652249, 0.8314625012971087, 0.9093292750548517], 
     RGBColor[0.6802013994534436, 0.8003026121459541, 0.8945495330156622], 
     RGBColor[0.6286182255664825, 0.23247138322272495`, 0.37114902216997403`],
      
     RGBColor[0.5796458561005922, 0.2177566043798514, 0.3551032632989689], 
     RGBColor[0.5517843664557376, 0.21561536615222957`, 0.35323245717480595`],
      
     RGBColor[0.6812715491500951, 0.7955215782458889, 0.8922364805505746], 
     RGBColor[0.6360245620535117, 0.23473476273016392`, 0.3736199586534237], 
     RGBColor[0.6709917225060319, 0.8379449365658191, 0.9049723662894426], 
     RGBColor[0.6731970772652249, 0.8314625012971087, 0.9093292750548517], 
     RGBColor[0.6802013994534436, 0.8003026121459541, 0.8945495330156622], 
     RGBColor[0.6286182255664825, 0.23247138322272495`, 0.37114902216997403`],
      
     RGBColor[0.5796458561005922, 0.2177566043798514, 0.3551032632989689], 
     RGBColor[0.5517843664557376, 0.21561536615222957`, 0.35323245717480595`],
      
     RGBColor[0.6606491563609312, 0.8683459481348159, 0.8845395461698795], 
     RGBColor[0.6633731305734348, 0.860339079202467, 0.8899210418561102], 
     RGBColor[0.4555344006152796, 0.2082182704157155, 0.3467695929188004], 
     RGBColor[0.42112089911482753`, 0.20557349061756508`, 0.3444588410465355],
      
     RGBColor[0.6632035592488699, 0.8608375183448951, 0.8895860359858394], 
     RGBColor[0.6657994450343147, 0.8532071534346851, 0.8947144796003915], 
     RGBColor[0.670861048052447, 0.8383290419724921, 0.9047142052521464], 
     RGBColor[0.5501334824334618, 0.21548849081200452`, 0.35312160581766305`],
      
     RGBColor[
     0.48618739870783995`, 0.21057404435830263`, 0.34882783952680635`], 
     RGBColor[
     0.45339211049903555`, 0.20805362905769662`, 0.34662574528106493`], 
     RGBColor[0.6755808374504417, 0.820945577931796, 0.9045365491916006], 
     RGBColor[0.6788977825313488, 0.8061266914469494, 0.8973672082854086], 
     RGBColor[0.6853653472164498, 0.7772319993238874, 0.8833880271626217], 
     RGBColor[0.6643570898150429, 0.24339319498499093`, 0.3830723885608309], 
     RGBColor[0.6195960994046654, 0.2297142177193822, 0.36813901840757934`], 
     RGBColor[0.5966400480643129, 0.22269883889255382`, 0.36048031361173877`],
      
     RGBColor[0.6797747566997451, 0.8022086945146474, 0.8954716909868713], 
     RGBColor[0.6828814011572105, 0.7883293536027479, 0.8887568999226159], 
     RGBColor[0.6471660927162995, 0.23813961912952153`, 0.3773370480193158], 
     RGBColor[0.6256654986689923, 0.23156902865612547`, 0.3701639196662667], 
     RGBColor[0.6668947783694581, 0.8499875229361767, 0.8968784250558963], 
     RGBColor[0.6693055710150079, 0.8429012221013952, 0.9016411978321108], 
     RGBColor[0.6744698498439343, 0.8259090605416444, 0.9069378698946335], 
     RGBColor[0.588951078873872, 0.22034908671353093`, 0.35791508388904747`], 
     
     RGBColor[0.5304822643286361, 0.21397823633667867`, 0.35180209204986423`],
      
     RGBColor[0.5000253620774752, 0.21163753294190626`, 0.3497570126237171], 
     RGBColor[0.659737500525294, 0.8710256757011975, 0.8827384748072034], 
     RGBColor[0.40960343711992764`, 0.2046883394564815, 0.34368548187911385`],
      
     RGBColor[0.6668947783694581, 0.8499875229361769, 0.8968784250558962], 
     RGBColor[0.6693055710150079, 0.8429012221013952, 0.9016411978321108], 
     RGBColor[0.6744698498439343, 0.8259090605416445, 0.9069378698946337], 
     RGBColor[0.5889510788738719, 0.2203490867135309, 0.3579150838890474], 
     RGBColor[0.530482264328636, 0.21397823633667865`, 0.35180209204986423`], 
     
     RGBColor[0.500025362077475, 0.21163753294190624`, 0.3497570126237171], 
     RGBColor[0.6797747566997451, 0.8022086945146474, 0.8954716909868713], 
     RGBColor[0.6828814011572105, 0.7883293536027479, 0.8887568999226159], 
     RGBColor[0.6471660927162995, 0.23813961912952153`, 0.3773370480193158], 
     RGBColor[0.6256654986689923, 0.23156902865612547`, 0.3701639196662667], 
     RGBColor[0.6755808374504417, 0.8209455779317959, 0.9045365491916005], 
     RGBColor[0.6788977825313488, 0.8061266914469494, 0.8973672082854086], 
     RGBColor[0.6853653472164498, 0.7772319993238873, 0.8833880271626215], 
     RGBColor[0.664357089815043, 0.24339319498499098`, 0.383072388560831], 
     RGBColor[0.6195960994046656, 0.22971421771938225`, 0.3681390184075794], 
     RGBColor[0.5966400480643131, 0.22269883889255387`, 0.3604803136117388], 
     RGBColor[0.6689432504377449, 0.843966229750998, 0.9009253956726694], 
     RGBColor[0.6641821462013535, 0.8579610529835575, 0.8915193367635117], 
     RGBColor[0.6599683078955312, 0.8703472388960228, 0.8831944588842845], 
     RGBColor[0.6628759904755807, 0.8618003762978146, 0.8889388896463815], 
     RGBColor[0.6680351172765503, 0.8466356027433813, 0.8991312837214404], 
     RGBColor[0.6627264226930655, 0.8622400168882446, 0.8886434028636102], 
     RGBColor[0.6812478377752906, 0.7956275119177034, 0.8922877310009684], 
     RGBColor[0.6686844875571013, 0.84472683917981, 0.9004141825636949], 
     RGBColor[0.696478329883228, 0.7287984859141693, 0.8597450775172496], 
     RGBColor[0.6782635242975988, 0.8089603231588886, 0.8987381123520712], 
     RGBColor[0.7494598268992746, 0.6618241313196844, 0.7978815196069544], 
     RGBColor[0.6939771332051119, 0.7387577177530636, 0.8647742641795448], 
     RGBColor[0.7451801641426995, 0.6672340888925492, 0.8028786446352965], 
     RGBColor[0.8039414798138679, 0.5782965368228168, 0.7112391743768258], 
     RGBColor[0.8025923710303942, 0.580525133551278, 0.713636407114238], 
     RGBColor[0.8308250483208764, 0.47419585100305994`, 0.6049406563005237], 
     RGBColor[0.8308024516756093, 0.4712878222385352, 0.6020928162171599], 
     RGBColor[0.8083837503790554, 0.3625614900982046, 0.49721502632430664`], 
     RGBColor[0.8027903795608663, 0.3548246526292107, 0.4900482240248253], 
     RGBColor[0.7391387710034639, 0.26678075815913493`, 0.4084912328288493], 
     RGBColor[0.7239578961189553, 0.26160722615294635`, 0.40295668722823097`],
      
     RGBColor[0.6358604593855189, 0.234684612886648, 0.37356520995680625`], 
     RGBColor[0.6152064986660779, 0.2283727539099863, 0.366674539358896], 
     RGBColor[0.5226357669526831, 0.21337520970929846`, 0.3512752259155952], 
     RGBColor[0.46575515101646603`, 0.20900376543959853`, 0.3474558822266519],
      
     RGBColor[0.4473641754680345, 0.20759036434764247`, 0.346220989544175], 
     RGBColor[0.5259048642666063, 0.21362644954706791`, 0.35149473489926153`],
      
     RGBColor[0.4492537495632588, 0.20773558372888132`, 0.3463478681437928], 
     RGBColor[0.4125193567147284, 0.2049124365376012, 0.34388127615662933`], 
     RGBColor[0.6649490252443496, 0.85570688333832, 0.8930343864445258], 
     RGBColor[0.660305424407752, 0.8693563162522281, 0.88386046777965], 
     RGBColor[0.6674573860763497, 0.8483337898910057, 0.8979899153680219], 
     RGBColor[0.672348328054231, 0.8339573206891826, 0.9076524823023031], 
     RGBColor[0.690346762883995, 0.7549768725398761, 0.8726210514530596], 
     RGBColor[0.7174973260998794, 0.7022281965656485, 0.8352023604764067], 
     RGBColor[0.7625081648851042, 0.6453296178696972, 0.7826456984602814], 
     RGBColor[0.8080548009767028, 0.571501729614609, 0.7039302099168594], 
     RGBColor[0.8308939436244467, 0.4830621903270488, 0.6136234853108783], 
     RGBColor[0.8254374756530102, 0.386150468010486, 0.5190660141241237], 
     RGBColor[0.6671469738464622, 0.24424578470406516`, 0.3840031626689072], 
     RGBColor[0.7666098701888427, 0.3047792096118312, 0.44369003212368924`], 
     RGBColor[0.5674528614609705, 0.21681953652869407`, 0.35428454436705054`],
      
     RGBColor[0.698832678352835, 0.25392894916521136`, 0.39457429502371133`], 
     
     RGBColor[0.4851725728700392, 0.21049605197864255`, 0.34875969735578405`],
      
     RGBColor[0.568923128949955, 0.2169325309519059, 0.3543832679262576], 
     RGBColor[
     0.43409396740097606`, 0.20657050944527086`, 0.34532993932262473`], 
     RGBColor[0.5071331023330214, 0.2121837838904801, 0.35023427368077226`], 
     RGBColor[0.41677833961768196`, 0.2052397520228404, 0.3441672526567775], 
     RGBColor[0.47544356619149697`, 0.20974834892031988`, 0.3481064269991648],
      
     RGBColor[0.6718230885873304, 0.835501213267264, 0.9066148168529061], 
     RGBColor[0.6779740710436737, 0.8102534934731267, 0.8993637449758194], 
     RGBColor[0.6843031381840389, 0.781977557266671, 0.8856839164466574], 
     RGBColor[0.6902142997189512, 0.7555686690750394, 0.8729073611641183], 
     RGBColor[0.7041111101286024, 0.7191498244099339, 0.8508327030219939], 
     RGBColor[0.7952281869063783, 0.3443645101893903, 0.48035876457953647`], 
     RGBColor[0.7399424174378605, 0.2678923744004975, 0.4095209473429083], 
     RGBColor[0.6612531694083673, 0.2424446356191702, 0.3820368441742087], 
     RGBColor[0.7491145501044074, 0.28057941089276034`, 0.42127322760868163`],
      
     RGBColor[0.6013382501812279, 0.2241346114113767, 0.3620477496899721], 
     RGBColor[0.6979159217761418, 0.25364878797450235`, 0.3942684424236086], 
     RGBColor[0.5622874827315333, 0.21642256183220082`, 0.35393770640957484`],
      
     RGBColor[0.6570057094070375, 0.2411466100781334, 0.3806197867804947], 
     RGBColor[0.5482685900544232, 0.21534516829395906`, 0.3529963845129847], 
     RGBColor[0.6132032385590634, 0.22776055678901733`, 0.3660062023892039], 
     RGBColor[0.6779740710436737, 0.8102534934731267, 0.8993637449758194], 
     RGBColor[0.680889, 0.7972306666666668, 0.8930633333333333], 
     RGBColor[0.6811710093989429, 0.7959707527492942, 0.8924537900727559], 
     RGBColor[0.6874045782710961, 0.7681214675610537, 0.8789803742589276], 
     RGBColor[0.690346762883995, 0.7549768725398761, 0.8726210514530596], 
     RGBColor[0.698832678352835, 0.25392894916521136`, 0.39457429502371133`], 
     
     RGBColor[0.6784702848313746, 0.24770619324538568`, 0.3877808984327449], 
     RGBColor[0.635328742366149, 0.2345221199446238, 0.3733878160476403], 
     RGBColor[0.633377, 0.23392566666666667`, 0.37273666666666666`], 
     RGBColor[0.6132032385590634, 0.22776055678901735`, 0.3660062023892039], 
     RGBColor[0.6718230885873304, 0.835501213267264, 0.9066148168529061], 
     RGBColor[0.6649490252443496, 0.85570688333832, 0.8930343864445258], 
     RGBColor[0.6707134339321713, 0.8387629399544136, 0.9044225781332684], 
     RGBColor[0.6762596858364189, 0.8179127338759437, 0.9030692666819493], 
     RGBColor[0.6674573860763497, 0.8483337898910057, 0.8979899153680219], 
     RGBColor[0.6849168583464866, 0.7792356820776226, 0.8843574039605392], 
     RGBColor[0.6686844875571013, 0.84472683917981, 0.9004141825636949], 
     RGBColor[0.7174973260998794, 0.7022281965656485, 0.8352023604764067], 
     RGBColor[0.6782635242975988, 0.8089603231588886, 0.8987381123520712], 
     RGBColor[0.7625081648851042, 0.6453296178696972, 0.7826456984602814], 
     RGBColor[0.6939771332051119, 0.7387577177530636, 0.8647742641795448], 
     RGBColor[0.7451801641426995, 0.6672340888925492, 0.8028786446352965], 
     RGBColor[0.8080548009767028, 0.571501729614609, 0.7039302099168594], 
     RGBColor[0.8025923710303942, 0.580525133551278, 0.713636407114238], 
     RGBColor[0.8308939436244467, 0.4830621903270488, 0.6136234853108783], 
     RGBColor[0.8308024516756093, 0.4712878222385352, 0.6020928162171599], 
     RGBColor[0.8254374756530102, 0.386150468010486, 0.5190660141241237], 
     RGBColor[0.8027903795608663, 0.3548246526292107, 0.4900482240248253], 
     RGBColor[0.7666098701888427, 0.3047792096118312, 0.44369003212368924`], 
     RGBColor[0.7239578961189553, 0.26160722615294635`, 0.40295668722823097`],
      
     RGBColor[0.6152064986660779, 0.2283727539099863, 0.366674539358896], 
     RGBColor[0.5226357669526831, 0.21337520970929846`, 0.3512752259155952], 
     RGBColor[0.5622874827315333, 0.21642256183220082`, 0.35393770640957484`],
      
     RGBColor[0.5071331023330216, 0.21218378389048012`, 0.3502342736807723], 
     RGBColor[0.5482685900544232, 0.21534516829395906`, 0.3529963845129847], 
     RGBColor[0.47544356619149714`, 0.2097483489203199, 0.3481064269991648], 
     RGBColor[0.6616760295917198, 0.8653275497478852, 0.8865682415358006], 
     RGBColor[0.6599683078955311, 0.870347238896023, 0.8831944588842845], 
     RGBColor[0.660305424407752, 0.8693563162522281, 0.88386046777965], 
     RGBColor[0.6657191172765503, 0.853443269410048, 0.8945557837214404], 
     RGBColor[0.6627264226930655, 0.8622400168882446, 0.8886434028636102], 
     RGBColor[0.6722319501632621, 0.8342994026792887, 0.9074225656183099], 
     RGBColor[0.6681043488953015, 0.8464321028369688, 0.8992680580183298], 
     RGBColor[0.6857684606255077, 0.7754310373834158, 0.8825167261965523], 
     RGBColor[0.6812478377752906, 0.7956275119177035, 0.8922877310009685], 
     RGBColor[0.6964783298832279, 0.7287984859141694, 0.8597450775172497], 
     RGBColor[0.7494598268992745, 0.6618241313196845, 0.7978815196069544], 
     RGBColor[0.8039414798138679, 0.5782965368228168, 0.7112391743768258], 
     RGBColor[0.8308250483208764, 0.47419585100305994`, 0.6049406563005237], 
     RGBColor[0.8083837503790553, 0.36256149009820454`, 0.4972150263243066], 
     RGBColor[0.7391387710034639, 0.26678075815913493`, 0.4084912328288493], 
     RGBColor[0.6358604593855188, 0.23468461288664794`, 0.3735652099568062], 
     RGBColor[0.515306548263064, 0.21281193748527683`, 0.3507830933202226], 
     RGBColor[0.44736417546803436`, 0.20759036434764247`, 0.346220989544175], 
     
     RGBColor[0.41677833961768196`, 0.2052397520228404, 0.3441672526567775], 
     RGBColor[0.4125193567147282, 0.2049124365376012, 0.34388127615662933`], 
     RGBColor[0.6641821462013534, 0.8579610529835576, 0.8915193367635116], 
     RGBColor[0.6689432504377449, 0.843966229750998, 0.9009253956726694], 
     RGBColor[0.6628759904755807, 0.8618003762978146, 0.8889388896463815], 
     RGBColor[0.6946592208062355, 0.7357104020793873, 0.8632999803367131], 
     RGBColor[0.7274593310256402, 0.6896351426138541, 0.8235702794040128], 
     RGBColor[0.7685139608441931, 0.63681935858521, 0.774190368023879], 
     RGBColor[0.810004319653191, 0.5682813140352896, 0.7004661082441681], 
     RGBColor[0.8309265967229321, 0.48726441364488127`, 0.617738733464459], 
     RGBColor[0.7728249075584688, 0.31337594591905993`, 0.4516533775838458], 
     RGBColor[0.8302316617173191, 0.3978311830966747, 0.5301565396956396], 
     RGBColor[0.6853585569046154, 0.24981125205273824`, 0.39007899585290745`],
      
     RGBColor[0.7796298651771859, 0.32278866908559783`, 0.4603725895751374], 
     RGBColor[0.591626255030736, 0.22116662165848505`, 0.35880758862161344`], 
     
     RGBColor[0.7286785163306501, 0.26304984965084766`, 0.4045316025356862], 
     RGBColor[0.5144319062033724, 0.2127447186453092, 0.3507243640224507], 
     RGBColor[0.6087846522201772, 0.22641023496812793`, 0.36453205302951075`],
      
     RGBColor[0.4657551510164659, 0.20900376543959853`, 0.3474558822266519], 
     RGBColor[0.5550640602146141, 0.21586742035826503`, 0.35345267767441657`],
      
     RGBColor[0.4492537495632587, 0.20773558372888132`, 0.3463478681437928], 
     RGBColor[0.5259048642666063, 0.21362644954706791`, 0.35149473489926153`],
      
     RGBColor[0.6768312465387307, 0.8153592115956045, 0.9018338788707242], 
     RGBColor[0.6808926005208521, 0.7972145808682912, 0.8930555510635643], 
     RGBColor[0.6751622798862713, 0.8228155386575609, 0.9054412316006268], 
     RGBColor[0.6839431916214178, 0.7835856656682226, 0.8864619153439851], 
     RGBColor[0.6889389099468263, 0.7612666398873524, 0.8756640254565924], 
     RGBColor[0.7008410553577142, 0.7232835280631644, 0.8546509647564142], 
     RGBColor[0.7343532523347515, 0.6809204788858162, 0.8155206295421743], 
     RGBColor[0.7724936372468233, 0.6302453195456011, 0.7671188770710684], 
     RGBColor[0.8113534284366647, 0.5660527173068285, 0.6980688755067559], 
     RGBColor[0.8309491933681994, 0.490172442409406, 0.6205865735478228], 
     RGBColor[0.8058462762250425, 0.35905161640137595`, 0.49396375330970216`],
      
     RGBColor[0.8302983185629716, 0.4064094486851249, 0.5385572573524067], 
     RGBColor[0.7552005841045272, 0.2889977077338308, 0.42907128067624156`], 
     RGBColor[0.7886399812696355, 0.33525160173389645`, 0.47191727753324214`],
      
     RGBColor[0.6942530166344678, 0.25252940264143287`, 0.39304640694549764`],
      
     RGBColor[0.7448407019136207, 0.27466775763498913`, 0.4157971334899511], 
     RGBColor[0.6393666944981505, 0.23575611979375266`, 0.37473497644993364`],
      
     RGBColor[0.6890891512467201, 0.25095132323358116`, 0.3913236141174166], 
     RGBColor[0.6052939312390551, 0.2253434691860579, 0.36336746243321477`], 
     RGBColor[0.6545145762800902, 0.2403853187595835, 0.3797886833409893], 
     RGBColor[0.5937432774824615, 0.22181358459926087`, 0.3595138795147442], 
     RGBColor[0.6334019186343209, 0.23393328181166775`, 0.37274498013753976`],
      
     RGBColor[0.6809458874748845, 0.7969765144235154, 0.8929403751019515], 
     RGBColor[0.6729374756311404, 0.832225576163676, 0.908816404900813], 
     RGBColor[0.6793827364807958, 0.8039600961757162, 0.8963190148114186], 
     RGBColor[0.6855569575391567, 0.776375955116866, 0.8829738750765533], 
     RGBColor[0.6929847283664382, 0.7431914163198478, 0.8669192766629776], 
     RGBColor[0.7168467295476039, 0.7030506211222225, 0.8359620260154108], 
     RGBColor[0.7531404690375874, 0.6571714007327759, 0.7935838377577302], 
     RGBColor[0.6007570642437339, 0.22395700074742167`, 0.36185385172987583`],
      
     RGBColor[0.6229523888486161, 0.23073990116784224`, 0.3692587593281544], 
     RGBColor[0.5763661623417157, 0.21750455017381592`, 0.35488304279935834`],
      
     RGBColor[0.6678035896281453, 0.8473161567392611, 0.8986738766595765], 
     RGBColor[0.6617459053364635, 0.8651221564930061, 0.8867062883708933], 
     RGBColor[0.671381834242636, 0.8367982393872548, 0.9057430727880745], 
     RGBColor[0.6625071889681396, 0.8628844340391023, 0.8882102837321776], 
     RGBColor[0.6855602956975311, 0.7763610414572147, 0.882966659884622], 
     RGBColor[0.6679076821100951, 0.8470101865667139, 0.8988795222343438], 
     RGBColor[0.7064403348089887, 0.716205431962375, 0.8481129964448558], 
     RGBColor[0.6771984351489156, 0.8137187483982544, 0.9010402268026089], 
     RGBColor[0.7556441187630719, 0.654006516123264, 0.7906604647218061], 
     RGBColor[0.6931757526972104, 0.742337990108527, 0.8665063911568032], 
     RGBColor[0.7436527701889056, 0.6691648803957768, 0.8046620979092525], 
     RGBColor[0.8058909984903562, 0.5750761212434973, 0.7077750727041344], 
     RGBColor[0.8021108796802353, 0.5813205105148638, 0.7144919695725962], 
     RGBColor[0.830857701419362, 0.4783980743208923, 0.6090559044541042], 
     RGBColor[0.8307943870262852, 0.4702499587887647, 0.6010764338589896], 
     RGBColor[0.8164664053940993, 0.37374154416613603`, 0.5075713557061097], 
     RGBColor[0.8007941286282657, 0.35206340730597324`, 0.48749042189814007`],
      
     RGBColor[0.7521587659918071, 0.28479021763290163`, 0.42517379028029745`],
      
     RGBColor[0.7184116686012196, 0.2599122967193158, 0.4011063289649944], 
     RGBColor[0.665706297363334, 0.2438055133722843, 0.38352251746878113`], 
     RGBColor[0.6078351854297014, 0.22612007752249735`, 0.3642152874954955], 
     RGBColor[0.5128219459211175, 0.21262098841604798`, 0.35061626055798795`],
      
     RGBColor[0.5115068869285186, 0.21251992222675142`, 0.35052795873176296`],
      
     RGBColor[0.4445944722575369, 0.20737750442991804`, 0.34603501320929986`],
      
     RGBColor[0.6617459053364635, 0.8651221564930061, 0.8867062883708933], 
     RGBColor[0.659388, 0.872053, 0.882048], 
     RGBColor[0.664414883975709, 0.857276941934959, 0.8919791345556376], 
     RGBColor[0.669619007520544, 0.8419799046355684, 0.9022604243999349], 
     RGBColor[0.6855602956975311, 0.7763610414572147, 0.882966659884622], 
     RGBColor[0.7064403348089887, 0.716205431962375, 0.8481129964448558], 
     RGBColor[0.7556441187630719, 0.654006516123264, 0.7906604647218061], 
     RGBColor[0.8058909984903561, 0.5750761212434974, 0.7077750727041345], 
     RGBColor[0.830857701419362, 0.4783980743208923, 0.6090559044541042], 
     RGBColor[0.8164664053940993, 0.3737415441661359, 0.5075713557061097], 
     RGBColor[0.7521587659918071, 0.2847902176329016, 0.4251737902802974], 
     RGBColor[0.6657062973633339, 0.24380551337228426`, 0.3835225174687811], 
     RGBColor[0.5344420843607247, 0.2142825602667804, 0.352067980760807], 
     RGBColor[
     0.46869545849449995`, 0.20922973680197654`, 0.34765331406920397`], 
     RGBColor[0.405188, 0.204349, 0.343389], 
     RGBColor[0.43497674706737083`, 0.20663835368448227`, 0.3453892150335515],
      
     RGBColor[0.6678035896281453, 0.8473161567392612, 0.8986738766595765], 
     RGBColor[0.6729374756311404, 0.832225576163676, 0.908816404900813], 
     RGBColor[0.6665905660678287, 0.850881726712253, 0.8962774218667315], 
     RGBColor[0.676175709641738, 0.8182879085219062, 0.9032507752547436], 
     RGBColor[0.7834429968771329, 0.32806305213104553`, 0.4652583663140115], 
     RGBColor[0.7116750569046155, 0.25785358538607156`, 0.3988588291862408], 
     RGBColor[0.6246261022568365, 0.23125138868074774`, 0.36981715139290233`],
      
     RGBColor[0.5567128678972506, 0.21599413612562207`, 0.3535633896122764], 
     RGBColor[0.5115068869285185, 0.21251992222675142`, 0.35052795873176296`],
      
     RGBColor[
     0.49618207661224345`, 0.21134216503937428`, 0.34949894882034865`], 
     RGBColor[0.5763661623417156, 0.21750455017381592`, 0.3548830427993583], 
     RGBColor[0.6808926005208521, 0.7972145808682912, 0.8930555510635643], 
     RGBColor[0.6793827364807958, 0.8039600961757162, 0.8963190148114186], 
     RGBColor[0.6839431916214178, 0.7835856656682226, 0.8864619153439851], 
     RGBColor[0.6889389099468263, 0.7612666398873524, 0.8756640254565924], 
     RGBColor[0.6898914044466078, 0.7570112459856109, 0.8736052763324317], 
     RGBColor[0.7008410553577142, 0.7232835280631644, 0.8546509647564142], 
     RGBColor[0.6946592208062355, 0.7357104020793872, 0.863299980336713], 
     RGBColor[0.7343532523347515, 0.6809204788858162, 0.8155206295421743], 
     RGBColor[0.7274593310256402, 0.6896351426138541, 0.8235702794040128], 
     RGBColor[0.7724936372468233, 0.6302453195456011, 0.7671188770710684], 
     RGBColor[0.7685139608441931, 0.63681935858521, 0.774190368023879], 
     RGBColor[0.8113534284366647, 0.5660527173068285, 0.6980688755067559], 
     RGBColor[0.810004319653191, 0.5682813140352896, 0.7004661082441681], 
     RGBColor[0.8309491933681994, 0.490172442409406, 0.6205865735478228], 
     RGBColor[0.8309265967229321, 0.48726441364488127`, 0.617738733464459], 
     RGBColor[0.8302983185629716, 0.4064094486851249, 0.5385572573524067], 
     RGBColor[0.7886399812696355, 0.33525160173389645`, 0.47191727753324214`],
      
     RGBColor[0.8302316617173191, 0.39783118309667476`, 0.5301565396956396], 
     RGBColor[0.7448407019136207, 0.27466775763498913`, 0.4157971334899511], 
     RGBColor[0.7796298651771859, 0.32278866908559795`, 0.4603725895751375], 
     RGBColor[0.6890891512467201, 0.25095132323358116`, 0.3913236141174166], 
     RGBColor[0.7286785163306503, 0.2630498496508477, 0.40453160253568626`], 
     RGBColor[0.6656831944981506, 0.24379845312708603`, 0.38351480978326696`],
      
     RGBColor[0.6956812147584892, 0.2529658605814865, 0.3935228890573243], 
     RGBColor[0.6337707091999466, 0.23404598436173898`, 0.3728680177641656], 
     RGBColor[0.6545145762800904, 0.24038531875958352`, 0.37978868334098936`],
      
     RGBColor[0.6229523888486161, 0.23073990116784224`, 0.3692587593281544], 
     RGBColor[0.633401918634321, 0.23393328181166775`, 0.3727449801375398], 
     RGBColor[0.6768312465387307, 0.8153592115956044, 0.9018338788707241], 
     RGBColor[0.6689432504377449, 0.843966229750998, 0.9009253956726694], 
     RGBColor[0.6751622798862713, 0.8228155386575606, 0.9054412316006268], 
     RGBColor[0.6817544575391568, 0.7933641217835325, 0.8911927084098867], 
     RGBColor[0.6896850425304492, 0.757933194868019, 0.8740513129386791], 
     RGBColor[0.7087677248770584, 0.7132633586636274, 0.8453954320428483], 
     RGBColor[0.747518326150319, 0.6642783986947008, 0.8001485024364414], 
     RGBColor[0.6052939312390553, 0.225343469186058, 0.3633674624332148], 
     RGBColor[0.5937432774824617, 0.22181358459926095`, 0.35951387951474423`],
      
     RGBColor[0.5259048642666064, 0.21362644954706791`, 0.35149473489926153`],
      
     RGBColor[0.6748563889861635, 0.8241821463085398, 0.9061023930276273], 
     RGBColor[0.6681043488953015, 0.8464321028369688, 0.8992680580183298], 
     RGBColor[0.6883998722713811, 0.7636748612864518, 0.8768291170581365], 
     RGBColor[0.6774680878137328, 0.8125140398086359, 0.9004573917440891], 
     RGBColor[0.7222526453565639, 0.6962169576229152, 0.829649837713059], 
     RGBColor[0.6933786412439159, 0.7414315589589697, 0.8660678619916183], 
     RGBColor[0.7440394663169952, 0.668676054578055, 0.8042105742706034], 
     RGBColor[0.8022327806739853, 0.5811191419082732, 0.7142753635757189], 
     RGBColor[0.8307964287841828, 0.47051271861998917`, 0.6013337552406717], 
     RGBColor[0.8012995270583266, 0.3527624822712429, 0.4881379903766926], 
     RGBColor[0.7198158280856052, 0.26034140844110976`, 0.4015747911938745], 
     RGBColor[0.6097014087968705, 0.22669039615883693`, 0.3648379056296135], 
     RGBColor[0.5153065482630641, 0.21281193748527685`, 0.3507830933202226], 
     RGBColor[0.683287068829937, 0.7865169801548699, 0.8878800780972745], 
     RGBColor[0.7011890610201933, 0.7228436111874162, 0.8542446178302909], 
     RGBColor[0.7523841916692153, 0.6581274172950446, 0.7944669009290173], 
     RGBColor[0.8048633482931415, 0.5767736995971255, 0.7096011053603206], 
     RGBColor[0.8308404889845682, 0.47618295544391465`, 0.606886632814075], 
     RGBColor[0.8122057937259983, 0.36784819987231554`, 0.5021122215823991], 
     RGBColor[0.745295533246787, 0.2752968874057294, 0.41637991020016163`], 
     RGBColor[0.6499736544018504, 0.23899761114704268`, 0.3782737198287201], 
     RGBColor[0.6811710093989429, 0.7959707527492943, 0.892453790072756], 
     RGBColor[0.6874045782710961, 0.7681214675610537, 0.8789803742589276], 
     RGBColor[0.6969070826020864, 0.7282564960074386, 0.859244446728273], 
     RGBColor[0.7396991359392753, 0.26755586364965545`, 0.40920923005110776`],
      
     RGBColor[0.6784702848313746, 0.24770619324538565`, 0.3877808984327449], 
     RGBColor[0.6353287423661489, 0.23452211994462377`, 0.3733878160476403], 
     RGBColor[0.6969070826020864, 0.7282564960074386, 0.859244446728273], 
     RGBColor[0.7396991359392753, 0.2675558636496555, 0.4092092300511078], 
     RGBColor[0.672348328054231, 0.8339573206891826, 0.9076524823023031], 
     RGBColor[0.6970932248770584, 0.7280211919969608, 0.859027098709515], 
     RGBColor[0.683287068829937, 0.7865169801548698, 0.8878800780972745], 
     RGBColor[0.7393940942908287, 0.6745483083048524, 0.8096347177459865], 
     RGBColor[0.7011890610201933, 0.7228436111874162, 0.8542446178302909], 
     RGBColor[0.7523841916692153, 0.6581274172950446, 0.7944669009290173], 
     RGBColor[0.8048633482931415, 0.5767736995971255, 0.7096011053603206], 
     RGBColor[0.8308404889845682, 0.47618295544391465`, 0.606886632814075], 
     RGBColor[0.8122057937259984, 0.36784819987231565`, 0.5021122215823992], 
     RGBColor[0.745295533246787, 0.27529688740572944`, 0.4163799102001617], 
     RGBColor[0.6499736544018506, 0.2389976111470427, 0.37827371982872016`], 
     RGBColor[0.5689231289499551, 0.21693253095190593`, 0.3543832679262576], 
     RGBColor[0.6774680878137328, 0.8125140398086359, 0.9004573917440891], 
     RGBColor[0.6933786412439159, 0.7414315589589698, 0.8660678619916184], 
     RGBColor[0.7440394663169952, 0.668676054578055, 0.8042105742706034], 
     RGBColor[0.8022327806739853, 0.5811191419082732, 0.7142753635757189], 
     RGBColor[0.8307964287841828, 0.47051271861998906`, 0.6013337552406716], 
     RGBColor[0.8012995270583266, 0.3527624822712429, 0.4881379903766926], 
     RGBColor[0.7198158280856051, 0.26034140844110976`, 0.4015747911938745], 
     RGBColor[0.6097014087968704, 0.22669039615883688`, 0.3648379056296135], 
     RGBColor[0.687953529290763, 0.7656689569985454, 0.8777938556688407], 
     RGBColor[0.711968830454434, 0.7092168142640117, 0.8416576784606312], 
     RGBColor[0.759076141824088, 0.6496680669964806, 0.7866530815910437], 
     RGBColor[0.8069728997335295, 0.5732889254290532, 0.705852641310497], 
     RGBColor[0.8308758225219043, 0.4807301323239706, 0.6113396948824913], 
     RGBColor[0.8209519405235548, 0.379946006088311, 0.5133186849151167], 
     RGBColor[0.7593843180903249, 0.2947847136223664, 0.43443191120199337`], 
     RGBColor[0.6822694878580845, 0.24886723126874782`, 0.3890484062462462], 
     RGBColor[0.6898914044466078, 0.7570112459856109, 0.8736052763324317], 
     RGBColor[0.7032832179430908, 0.720196369862994, 0.8517993868464688], 
     RGBColor[0.73619075250595, 0.6785976795131219, 0.8133750824237777], 
     RGBColor[0.773554376954061, 0.628493080533998, 0.7652340476316543], 
     RGBColor[0.8117130187930736, 0.5654587089498331, 0.697429919045275], 
     RGBColor[0.8309552162596258, 0.49094754602795204`, 0.6213456345243109], 
     RGBColor[0.8303160852243254, 0.4086958926087785, 0.5407963777949476], 
     RGBColor[0.7910415302749185, 0.33857346165194024`, 0.4749943892593965], 
     RGBColor[0.7480325237265268, 0.2790827351859391, 0.41988682406327804`], 
     RGBColor[0.6956812147584891, 0.25296586058148646`, 0.39352288905732424`],
      
     RGBColor[0.664414883975709, 0.857276941934959, 0.8919791345556376], 
     RGBColor[0.679624573170126, 0.8028796590989362, 0.8957963020057671], 
     RGBColor[0.669619007520544, 0.8419799046355684, 0.9022604243999349], 
     RGBColor[0.692202372271381, 0.7466866946197852, 0.8686102837248032], 
     RGBColor[0.6795448580937593, 0.8032357966408595, 0.8959686004743567], 
     RGBColor[0.7303768772160539, 0.6859470480127638, 0.820163622403514], 
     RGBColor[0.6949412176947792, 0.7344505440538617, 0.862690464116474], 
     RGBColor[0.747017664313898, 0.6649112895198549, 0.8007330975168998], 
     RGBColor[0.8031716193874732, 0.5795682715032606, 0.712607140133182], 
     RGBColor[0.8308121536876389, 0.47253640271241837`, 0.6033155543015306], 
     RGBColor[0.8051919285661493, 0.3581465125472546, 0.49312533575097967`], 
     RGBColor[0.7306301721143081, 0.26364627646915956`, 0.4051827230306059], 
     RGBColor[0.6240744068440282, 0.23108279033338863`, 0.36963309219904217`],
      
     RGBColor[0.5344420843607247, 0.2142825602667804, 0.352067980760807], 
     RGBColor[
     0.46869545849449995`, 0.20922973680197654`, 0.34765331406920397`], 
     RGBColor[0.6795448580937593, 0.8032357966408595, 0.8959686004743567], 
     RGBColor[0.6949412176947792, 0.7344505440538617, 0.862690464116474], 
     RGBColor[0.747017664313898, 0.6649112895198549, 0.8007330975168998], 
     RGBColor[0.8031716193874732, 0.5795682715032606, 0.712607140133182], 
     RGBColor[0.8308121536876389, 0.47253640271241837`, 0.6033155543015306], 
     RGBColor[0.8051919285661492, 0.3581465125472545, 0.4931253357509796], 
     RGBColor[0.730630172114308, 0.26364627646915956`, 0.4051827230306058], 
     RGBColor[0.624074406844028, 0.2310827903333886, 0.3696330921990421], 
     RGBColor[0.7032832179430909, 0.720196369862994, 0.8517993868464687], 
     RGBColor[0.73619075250595, 0.6785976795131219, 0.8133750824237777], 
     RGBColor[0.773554376954061, 0.628493080533998, 0.7652340476316543], 
     RGBColor[0.8117130187930736, 0.5654587089498331, 0.697429919045275], 
     RGBColor[0.8309552162596258, 0.49094754602795204`, 0.6213456345243109], 
     RGBColor[0.8131942220212441, 0.3692154092561818, 0.5033786976322623], 
     RGBColor[0.8303160852243254, 0.4086958926087785, 0.5407963777949476], 
     RGBColor[0.7657595630555711, 0.30360305156640793`, 0.4426005311204339], 
     RGBColor[0.7910415302749185, 0.33857346165194024`, 0.4749943892593965], 
     RGBColor[0.7170896194754424, 0.2595082779572258, 0.4006652607764889], 
     RGBColor[0.7480325237265268, 0.2790827351859392, 0.4198868240632781], 
     RGBColor[0.7769437951079959, 0.6228940908144317, 0.7592113871472486], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303728556498277, 0.41600184569972626`, 0.5479511165352908], 
     RGBColor[0.7728249075584689, 0.31337594591906, 0.4516533775838459], 
     RGBColor[0.6853585569046156, 0.24981125205273827`, 0.3900789958529075], 
     RGBColor[0.591626255030736, 0.22116662165848508`, 0.35880758862161344`], 
     
     RGBColor[0.5144319062033725, 0.2127447186453092, 0.3507243640224507], 
     RGBColor[0.6616760295917198, 0.8653275497478852, 0.8865682415358006], 
     RGBColor[0.6657191172765503, 0.853443269410048, 0.8945557837214404], 
     RGBColor[0.6722319501632621, 0.8342994026792887, 0.9074225656183099], 
     RGBColor[0.6857684606255077, 0.7754310373834158, 0.8825167261965523], 
     RGBColor[0.7166305024692953, 0.7033239555848403, 0.8362145023917703], 
     RGBColor[0.7742625433667718, 0.6273232583744316, 0.7639757060294932], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303279465252184, 0.4102223583196684, 0.5422912496099668], 
     RGBColor[0.7654769617622671, 0.30321215306425414`, 0.44223843326128576`],
      
     RGBColor[0.7393940942908287, 0.6745483083048524, 0.8096347177459865], 
     RGBColor[0.7851187100334385, 0.6093899250410982, 0.7446853726961598], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8305097798585517, 0.4336230249863351, 0.5652075829433001], 
     RGBColor[0.6824143858228578, 0.7904158057620829, 0.8897663203557927], 
     RGBColor[0.6869140540768168, 0.7703129486304685, 0.880040607420992], 
     RGBColor[0.694162372606645, 0.7379301364706234, 0.8643738823865225], 
     RGBColor[0.7252399086660815, 0.2619990097199672, 0.4033843982268444], 
     RGBColor[0.6750754446055358, 0.24666872866196446`, 0.38664829602071593`],
      
     RGBColor[0.6439339535850727, 0.23715187606820876`, 0.37625872670446325`],
      
     RGBColor[0.7851187100334385, 0.6093899250410982, 0.7446853726961598], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8305097798585517, 0.4336230249863351, 0.5652075829433001], 
     RGBColor[0.7952281869063783, 0.3443645101893903, 0.48035876457953647`], 
     RGBColor[0.7166305024692953, 0.7033239555848403, 0.8362145023917703], 
     RGBColor[0.7742625433667718, 0.6273232583744316, 0.7639757060294932], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303279465252184, 0.4102223583196684, 0.5422912496099668], 
     RGBColor[0.7654769617622671, 0.30321215306425414`, 0.44223843326128576`],
      
     RGBColor[0.6671469738464622, 0.24424578470406516`, 0.3840031626689072], 
     RGBColor[0.5674528614609705, 0.21681953652869407`, 0.35428454436705054`],
      
     RGBColor[0.4851725728700392, 0.21049605197864255`, 0.34875969735578405`],
      
     RGBColor[
     0.43409396740097606`, 0.20657050944527086`, 0.34532993932262473`], 
     RGBColor[0.6680351172765503, 0.8466356027433815, 0.8991312837214404], 
     RGBColor[0.6748563889861635, 0.8241821463085398, 0.9061023930276273], 
     RGBColor[0.6883998722713811, 0.7636748612864518, 0.8768291170581365], 
     RGBColor[0.7222526453565639, 0.6962169576229152, 0.829649837713059], 
     RGBColor[0.7769437951079959, 0.6228940908144317, 0.7592113871472486], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303728556498277, 0.4160018456997262, 0.5479511165352907], 
     RGBColor[0.7916744827991451, 0.598560424916898, 0.7330364135569852], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8306195845484727, 0.44775411360564926`, 0.5790461945425314], 
     RGBColor[0.8131942220212441, 0.3692154092561818, 0.5033786976322623], 
     RGBColor[0.7657595630555711, 0.30360305156640793`, 0.4426005311204339], 
     RGBColor[0.7170896194754424, 0.2595082779572258, 0.4006652607764889], 
     RGBColor[0.6656831944981506, 0.24379845312708603`, 0.38351480978326696`],
      
     RGBColor[0.6337707091999466, 0.23404598436173898`, 0.3728680177641656], 
     RGBColor[0.7808183161324784, 0.6164937582502314, 0.7523267468903185], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304377512151394, 0.4243534469389826, 0.5561298612091979], 
     RGBColor[0.783442996877133, 0.32806305213104564`, 0.46525836631401163`], 
     
     RGBColor[0.7116750569046155, 0.2578535853860716, 0.3988588291862408], 
     RGBColor[0.6246261022568366, 0.23125138868074777`, 0.3698171513929024], 
     RGBColor[0.43497674706737094`, 0.20663835368448227`, 0.3453892150335515],
      
     RGBColor[0.6607816069292854, 0.8679566220039151, 0.8848012161074896], 
     RGBColor[0.6648925464465119, 0.8558728975133688, 0.8929228066778996], 
     RGBColor[0.671514678878497, 0.8364077549315566, 0.9060055212472208], 
     RGBColor[0.684829320682372, 0.7796267680546355, 0.8845466103962389], 
     RGBColor[0.7146239829041297, 0.7058604137905697, 0.8385574040897004], 
     RGBColor[0.7733056156995501, 0.6289040099747978, 0.7656760717518871], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8303119186442147, 0.40815968315519063`, 0.5402712664914988], 
     RGBColor[0.7628545102701068, 0.29958473739226155`, 0.4388782785361288], 
     RGBColor[0.6606473351052314, 0.24225949240443473`, 0.38183472291153514`],
      
     RGBColor[0.5583911690553702, 0.21612311855416538`, 0.35367608193866745`],
      
     RGBColor[
     0.47473003770609173`, 0.20969351213704226`, 0.34805851594066517`], 
     RGBColor[
     0.42279422179603104`, 0.20570209043537135`, 0.34457119908480266`], 
     RGBColor[0.679624573170126, 0.8028796590989362, 0.8957963020057671], 
     RGBColor[0.692202372271381, 0.7466866946197852, 0.8686102837248032], 
     RGBColor[0.7303768772160539, 0.6859470480127638, 0.820163622403514], 
     RGBColor[0.7808183161324784, 0.6164937582502314, 0.7523267468903185], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8304377512151394, 0.4243534469389825, 0.5561298612091978], 
     RGBColor[0.6809458874748845, 0.7969765144235154, 0.8929403751019515], 
     RGBColor[0.6855569575391567, 0.776375955116866, 0.8829738750765533], 
     RGBColor[0.6929847283664382, 0.7431914163198478, 0.8669192766629776], 
     RGBColor[0.7168467295476039, 0.7030506211222225, 0.8359620260154108], 
     RGBColor[0.7531404690375874, 0.6571714007327759, 0.7935838377577302], 
     RGBColor[0.7916744827991451, 0.598560424916898, 0.7330364135569852], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8306195845484727, 0.44775411360564926`, 0.5790461945425314], 
     RGBColor[0.6615732299199042, 0.8656297198252441, 0.8863651500425397], 
     RGBColor[0.7606085098858136, 0.6477309876817117, 0.7848638203269134], 
     RGBColor[0.8170471592377401, 0.5566472268145474, 0.6879516795907931], 
     RGBColor[0.8305706768706367, 0.4414600406460777, 0.5728823926295148], 
     RGBColor[0.7851837965830194, 0.33047095334630533`, 0.4674888580408452], 
     RGBColor[0.6982912293975813, 0.25376348213953787`, 0.3943936543007567], 
     RGBColor[0.5955271265665492, 0.2223587296204679, 0.36010901555677516`], 
     RGBColor[0.508509732850651, 0.21228958203434223`, 0.35032670982958986`], 
     
     RGBColor[0.42420349788656564`, 0.20581039748846833`, 0.3446658272749826],
      
     RGBColor[0.6628483710333112, 0.8618815610804096, 0.8888843245522087], 
     RGBColor[0.6661259004007698, 0.8522475682376336, 0.8953594262883084], 
     RGBColor[0.671852777165683, 0.8354139464515336, 0.9066734697416161], 
     RGBColor[0.6838867225697784, 0.7838379485507364, 0.8865839691832792], 
     RGBColor[0.7072768508559603, 0.7151479850137378, 0.8471362430152756], 
     RGBColor[0.7624134370542847, 0.6454493641148695, 0.7827563068986546], 
     RGBColor[0.8173871053790583, 0.5560856687936705, 0.6873476289546191], 
     RGBColor[0.8305876868599477, 0.4436491062182305, 0.5750261502008082], 
     RGBColor[0.7884447275772667, 0.33498152379124213`, 0.47166709840925114`],
      
     RGBColor[0.4405182416300503, 0.20706423399982138`, 0.34576130791505294`],
      
     RGBColor[0.6747313822701496, 0.8247406301812805, 0.9063725861543769], 
     RGBColor[0.5848557969685144, 0.21909756686184645`, 0.3565487968606791], 
     RGBColor[0.6809071322611354, 0.7971496584157234, 0.8930241417403738], 
     RGBColor[0.6847316061446637, 0.7800633205470341, 0.8847578134204779], 
     RGBColor[0.6914141673564882, 0.7502081032882103, 0.8703139325947622], 
     RGBColor[0.7360732869767201, 0.26530969463248444`, 0.4069986803693921], 
     RGBColor[0.6807458251017838, 0.24840159929740835`, 0.38854007477904784`],
      
     RGBColor[0.6441569997114013, 0.23722003905708053`, 0.3763331403922565], 
     RGBColor[0.6281415272922756, 0.23232570403208042`, 0.3709899838708908], 
     RGBColor[0.6682838706449181, 0.8459044153452558, 0.899622721993015], 
     RGBColor[0.8306601947489344, 0.45298035978861206`, 0.5841642709339804], 
     RGBColor[0.510062531551221, 0.2124089192262815, 0.35043097508445054`], 
     RGBColor[0.7008028054930028, 0.7233318800378472, 0.8546956270036875], 
     RGBColor[0.7587082981671771, 0.6501330612473192, 0.7870825922438731], 
     RGBColor[0.8166892668791329, 0.5572384302440287, 0.6885876188782935], 
     RGBColor[0.8305527689009484, 0.43915541133707764`, 0.5706254631921135], 
     RGBColor[0.7817507166243509, 0.3257222637775924, 0.4630900427035753], 
     RGBColor[0.689337541059325, 0.2510272312635081, 0.39140648308389653`], 
     RGBColor[0.5839899247037629, 0.21883295593800703`, 0.35625992052178623`],
      
     RGBColor[0.49345319010443495`, 0.21113244200647677`, 0.3493157131909538],
      
     RGBColor[0.43333993951650734`, 0.2065125601628923, 0.34527930886452524`],
      
     RGBColor[0.4070274767210222, 0.20449036924924258`, 0.34351251472799227`],
      
     RGBColor[0.6662899797108163, 0.8517652723612549, 0.8956835821100345], 
     RGBColor[0.6877059210384371, 0.7667751792887637, 0.8783290432974601], 
     RGBColor[0.7157889008870165, 0.7043878312012983, 0.837197193919096], 
     RGBColor[0.7672051045982599, 0.6389814620296796, 0.7765160759873531], 
     RGBColor[0.8183046207642534, 0.5545700224567656, 0.6857172949553063], 
     RGBColor[0.8306335968586148, 0.4495573990256201, 0.5808121566139477], 
     RGBColor[0.48455177097711155`, 0.2104483415093941, 0.348718012578768], 
     RGBColor[0.6794502215503729, 0.8036585977905778, 0.8961731506327617], 
     RGBColor[0.6179300640329287, 0.22920507661761597`, 0.3675831879251335], 
     RGBColor[0.6773566446575707, 0.8130119267016643, 0.9006982682007983], 
     RGBColor[0.6032562179533162, 0.22472074315935703`, 0.36268763103352614`],
      
     RGBColor[0.6644473474144466, 0.8571815186751235, 0.8920432694709846], 
     RGBColor[0.7646767441359171, 0.6425882986565727, 0.7801135686485265], 
     RGBColor[0.8178133843572131, 0.5553814973081946, 0.6865901734149169], 
     RGBColor[0.8306090167118877, 0.4463941076222531, 0.5777143371687741], 
     RGBColor[0.7925338057079078, 0.3406376002294266, 0.4769064461124534], 
     RGBColor[0.7174605152225221, 0.259621623851624, 0.40078900074355905`], 
     RGBColor[0.6202275530023054, 0.2299071902011618, 0.36834968689864056`], 
     RGBColor[0.6606858649741775, 0.8682380465792132, 0.8846120678710488], 
     RGBColor[0.6640993725391758, 0.8582043584675318, 0.8913558087448183], 
     RGBColor[0.6700638460706525, 0.8406723430770098, 0.9031392494370771], 
     RGBColor[0.6814869611199975, 0.7945591970633256, 0.8917708828967592], 
     RGBColor[0.7019283753339982, 0.7219090377646503, 0.8533813614777547], 
     RGBColor[0.7593524692154509, 0.6493187592242278, 0.7863304294098002], 
     RGBColor[0.8168105922522753, 0.5570380125067962, 0.6883720357022454], 
     RGBColor[0.8305588396958463, 0.4399366797943241, 0.5713905614110707], 
     RGBColor[0.7829145294216795, 0.32733206773122714`, 0.4645812394261198], 
     RGBColor[0.6923728379929259, 0.2519548192674472, 0.3924191329877285], 
     RGBColor[0.5879010317373669, 0.22002819187236713`, 0.3575647622714061], 
     RGBColor[0.4985573523559796, 0.2115247120348315, 0.3496584406660683], 
     RGBColor[0.4389438548125937, 0.2069432376969828, 0.34565559309012994`], 
     RGBColor[0.41285014134879205`, 0.20493785831915687`, 0.3439034872417893],
      
     RGBColor[0.6703290381995525, 0.8398928354707166, 0.9036631641977775], 
     RGBColor[0.5362293488669934, 0.2144199168522493, 0.35218798961268266`], 
     RGBColor[0.6816543212032912, 0.7938114939763199, 0.8914091459786151], 
     RGBColor[0.6854318119095252, 0.7769350596043834, 0.8832443684552086], 
     RGBColor[0.6920322787032008, 0.7474466099084569, 0.8689779288761367], 
     RGBColor[0.711529132516346, 0.7097726401141393, 0.8421710893755345], 
     RGBColor[0.6333785623241757, 0.23392614411358384`, 0.3727371878965367], 
     RGBColor[0.6723229291336543, 0.8340319784547175, 0.9076023040807579], 
     RGBColor[0.561740109441103, 0.21638049456913672`, 0.35390095211836525`], 
     
     RGBColor[0.6656699781807397, 0.8535877092134071, 0.8944587043030979], 
     RGBColor[0.6662899797108163, 0.8517652723612549, 0.8956835821100345], 
     RGBColor[0.6608931570930741, 0.8676287306689907, 0.8850215951119864], 
     RGBColor[0.5493359234334426, 0.21542719603410881`, 0.3530680523903109], 
     RGBColor[0.4923845997489973, 0.21105031766395607`, 0.3492439609118525], 
     RGBColor[0.48455177097711166`, 0.2104483415093941, 0.348718012578768], 
     RGBColor[0.43279524120744856`, 0.20647069848009122`, 0.3452427341893949],
      
     RGBColor[0.6595336023634357, 0.8716250153902636, 0.8823356526830313], 
     RGBColor[0.6602307723798231, 0.8695757489474486, 0.8837129848980486], 
     RGBColor[0.6621845380715622, 0.8638328363506742, 0.887572853172035], 
     RGBColor[0.6616163450951342, 0.8655029867763491, 0.8864503285763329], 
     RGBColor[0.6636728961285461, 0.8594579462243382, 0.8905132600328856], 
     RGBColor[0.4070274767210222, 0.20449036924924258`, 0.34351251472799227`],
      
     RGBColor[0.448904817582324, 0.20770876726982113`, 0.3463244385248037], 
     RGBColor[0.6682838706449181, 0.8459044153452558, 0.899622721993015], 
     RGBColor[0.5175745477071991, 0.2129862399784999, 0.3509353819201421], 
     RGBColor[0.510062531551221, 0.2124089192262815, 0.35043097508445054`], 
     RGBColor[0.5907611033563165, 0.2209022309473505, 0.35851895268942424`], 
     RGBColor[0.6801325207960359, 0.8006103365672084, 0.8946984093353093], 
     RGBColor[0.6809071322611354, 0.7971496584157234, 0.8930241417403738], 
     RGBColor[0.6801325207960359, 0.8006103365672084, 0.8946984093353093], 
     RGBColor[0.6335024905062907, 0.23396401661752483`, 0.3727785333940107], 
     RGBColor[0.6281415272922756, 0.23232570403208042`, 0.3709899838708908], 
     RGBColor[0.6335024905062907, 0.23396401661752483`, 0.3727785333940107], 
     RGBColor[0.6738781180617778, 0.8285526997624829, 0.9082168560604668], 
     RGBColor[0.6747313822701496, 0.8247406301812805, 0.9063725861543769], 
     RGBColor[0.6676892627904245, 0.8476522098490443, 0.8984480120455904], 
     RGBColor[0.5907611033563166, 0.2209022309473505, 0.35851895268942424`], 
     RGBColor[0.5848557969685144, 0.21909756686184648`, 0.35654879686067914`],
      
     RGBColor[0.5175745477071991, 0.2129862399784999, 0.3509353819201421], 
     RGBColor[0.6621845380715622, 0.8638328363506742, 0.887572853172035], 
     RGBColor[0.6628483710333112, 0.8618815610804096, 0.8888843245522087], 
     RGBColor[0.6595336023634357, 0.8716250153902636, 0.8823356526830313], 
     RGBColor[0.4903116933475494, 0.21089100865048838`, 0.34910477215920227`],
      
     RGBColor[0.45932150782549275`, 0.20850932085250035`, 0.3470238845396734],
      
     RGBColor[0.448904817582324, 0.20770876726982113`, 0.3463244385248037], 
     RGBColor[0.4405182416300503, 0.20706423399982138`, 0.34576130791505294`],
      
     RGBColor[0.4158352184738213, 0.205167270361872, 0.3441039252168505], 
     RGBColor[0.6608931570930741, 0.8676287306689907, 0.8850215951119864], 
     RGBColor[0.6615732299199042, 0.8656297198252441, 0.8863651500425397], 
     RGBColor[0.6656699781807397, 0.8535877092134071, 0.8944587043030978], 
     RGBColor[0.6675663522049525, 0.848013494087256, 0.8982051893410019], 
     RGBColor[0.6707979178839294, 0.8385146072332339, 0.9045894850077372], 
     RGBColor[0.43279524120744856`, 0.20647069848009122`, 0.3452427341893949],
      
     RGBColor[0.42420349788656564`, 0.20581039748846833`, 0.3446658272749826],
      
     RGBColor[0.4923845997489971, 0.21105031766395607`, 0.3492439609118525], 
     RGBColor[0.6717797616760097, 0.8356285686947111, 0.9065292200123414], 
     RGBColor[0.6723229291336543, 0.8340319784547175, 0.9076023040807579], 
     RGBColor[0.6786570552499462, 0.8072021720985416, 0.8978875231847205], 
     RGBColor[0.5686022500710866, 0.216907870457057, 0.35436172197952776`], 
     RGBColor[0.561740109441103, 0.2163804945691367, 0.3539009521183652], 
     RGBColor[0.6234194423222591, 0.23088263290342745`, 0.3694145798839403], 
     RGBColor[0.6808892257419368, 0.7972296581350047, 0.8930628454081908], 
     RGBColor[0.6816543212032912, 0.7938114939763199, 0.8914091459786151], 
     RGBColor[0.6765368151071566, 0.8166746225703547, 0.902470271471435], 
     RGBColor[0.6648170814245944, 0.24353376861197587`, 0.3832258531046188], 
     RGBColor[0.6491972866929727, 0.23876035285266345`, 0.3780147044167418], 
     RGBColor[0.6369438141836729, 0.2350156865630495, 0.37392664383170066`], 
     RGBColor[0.6386736667840661, 0.23554433023640634`, 0.3745037653152827], 
     RGBColor[0.6333785623241757, 0.23392614411358384`, 0.3727371878965367], 
     RGBColor[0.6089301283710614, 0.226454692540277, 0.36458058746071315`], 
     RGBColor[0.6703290381995526, 0.8398928354707166, 0.9036631641977775], 
     RGBColor[0.5434123021128847, 0.21497194814251316`, 0.3526703009712382], 
     RGBColor[0.4691055874129662, 0.20926125642744048`, 0.34768085285848416`],
      
     RGBColor[0.6599944908985327, 0.870270276393101, 0.8832461861425892], 
     RGBColor[0.6606858649741775, 0.8682380465792132, 0.8846120678710488], 
     RGBColor[0.6599944908985327, 0.870270276393101, 0.8832461861425892], 
     RGBColor[0.42158465971550835`, 0.20560913199709288`, 0.344489981024439], 
     
     RGBColor[0.41285014134879205`, 0.20493785831915687`, 0.3439034872417893],
      
     RGBColor[0.42158465971550835`, 0.20560913199709288`, 0.344489981024439], 
     
     RGBColor[0.6638038785993984, 0.8590729354295461, 0.8907720295904782], 
     RGBColor[0.6644473474144466, 0.8571815186751235, 0.8920432694709846], 
     RGBColor[0.6697604770663249, 0.841564068059074, 0.9025399122698488], 
     RGBColor[0.4691055874129661, 0.20926125642744048`, 0.34768085285848416`],
      
     RGBColor[
     0.46097628320351086`, 0.20863649525497147`, 0.34713499718837854`], 
     RGBColor[0.5434123021128846, 0.21497194814251316`, 0.35267030097123814`],
      
     RGBColor[0.6765368151071566, 0.8166746225703547, 0.902470271471435], 
     RGBColor[0.6773566446575707, 0.8130119267016643, 0.9006982682007983], 
     RGBColor[0.6808892257419368, 0.7972296581350047, 0.8930628454081908], 
     RGBColor[0.6814043729004015, 0.7949281707488485, 0.891949391460114], 
     RGBColor[0.6831748906066547, 0.7870181510565107, 0.8881225433492893], 
     RGBColor[0.6089301283710614, 0.226454692540277, 0.36458058746071315`], 
     RGBColor[0.6032562179533161, 0.22472074315935703`, 0.3626876310335261], 
     RGBColor[0.6386736667840661, 0.23554433023640634`, 0.3745037653152827], 
     RGBColor[0.6786570552499462, 0.8072021720985416, 0.8978875231847205], 
     RGBColor[0.6794502215503729, 0.8036585977905778, 0.8961731506327617], 
     RGBColor[0.6717797616760097, 0.8356285686947111, 0.9065292200123414], 
     RGBColor[0.6234194423222592, 0.23088263290342748`, 0.36941457988394033`],
      
     RGBColor[0.6179300640329288, 0.22920507661761597`, 0.3675831879251335], 
     RGBColor[0.5686022500710868, 0.21690787045705703`, 0.35436172197952776`],
      
     RGBColor[0.663612054029425, 0.8596367859178257, 0.8903930601086504], 
     RGBColor[0.6597073463353486, 0.8711143111389142, 0.8826789020541397], 
     RGBColor[0.6655922947700473, 0.8538160523764138, 0.8943052326080966], 
     RGBColor[0.6663745631575749, 0.8515166471837718, 0.895850685547273], 
     RGBColor[0.6696873711517869, 0.8417789560977341, 0.9023954838968052], 
     RGBColor[0.673753007226875, 0.8291116487999934, 0.9084872742327903], 
     RGBColor[0.6809819388753662, 0.7968154500711285, 0.8928624525636233], 
     RGBColor[0.6770034616811859, 0.8145898178960509, 0.9014616480874722], 
     RGBColor[0.6889748000637654, 0.7611062960903113, 0.8755864515211718], 
     RGBColor[0.7008028054930028, 0.7233318800378472, 0.8546956270036875], 
     RGBColor[0.6914973836579271, 0.7498363235648103, 0.8701340664771703], 
     RGBColor[0.7290820607257962, 0.68758383639432, 0.8216755078623943], 
     RGBColor[0.7587082981671771, 0.6501330612473192, 0.7870825922438731], 
     RGBColor[0.7342038576347616, 0.6811093299786538, 0.8156950694541215], 
     RGBColor[0.788754501670633, 0.6033839502470162, 0.7382249309246296], 
     RGBColor[0.7876853252988748, 0.6051501258093107, 0.74012475148161], 
     RGBColor[0.8166892668791329, 0.5572384302440287, 0.6885876188782935], 
     RGBColor[0.7897700650746194, 0.601706338102322, 0.7364203753033359], 
     RGBColor[0.8310445594474473, 0.5024453837391294, 0.6326054967049572], 
     RGBColor[0.8310385649963176, 0.5016739401860353, 0.6318500200400237], 
     RGBColor[0.8305527689009484, 0.43915541133707764`, 0.5706254631921135], 
     RGBColor[0.8310502533117667, 0.5031781438912035, 0.6333230906153151], 
     RGBColor[0.8229546924427364, 0.38271624367725043`, 0.5158848167748187], 
     RGBColor[0.8204711816195827, 0.3792810128985678, 0.5127026871330138], 
     RGBColor[0.7817507166243509, 0.3257222637775924, 0.4630900427035753], 
     RGBColor[0.8253136696629794, 0.3859792176404155, 0.5189073811489673], 
     RGBColor[0.7491301867886058, 0.2806010397974279, 0.42129326293762936`], 
     RGBColor[0.7447907106668225, 0.27459860896526517`, 0.4157330795600127], 
     RGBColor[0.7532520634575686, 0.28630248368369754`, 0.4265746355033884], 
     RGBColor[0.6443304891693873, 0.23727305750751818`, 0.37639102075348263`],
      
     RGBColor[
     0.45855285529574974`, 0.20845024762269734`, 0.34697227208541037`], 
     RGBColor[0.5231459402091073, 0.2134144180392654, 0.3513094823485666], 
     RGBColor[0.4231269909868529, 0.205727664736008, 0.3445935434263313], 
     RGBColor[0.659446250087549, 0.8718817792835329, 0.8821630791345338], 
     RGBColor[0.7940990718252388, 0.594555239243507, 0.7287281589081969], 
     RGBColor[0.8306601947489344, 0.45298035978861206`, 0.5841642709339804], 
     RGBColor[0.6824466140027209, 0.7902718221484404, 0.8896966614369418], 
     RGBColor[0.6847316061446637, 0.7800633205470341, 0.8847578134204779], 
     RGBColor[0.6824466140027209, 0.7902718221484404, 0.8896966614369418], 
     RGBColor[0.6877333735849954, 0.7666525314422529, 0.8782697065703756], 
     RGBColor[0.6914141673564882, 0.7502081032882103, 0.8703139325947622], 
     RGBColor[0.6877333735849954, 0.7666525314422529, 0.8782697065703756], 
     RGBColor[0.695727699341819, 0.7309368343102229, 0.8609905399674285], 
     RGBColor[0.695727699341819, 0.7309368343102229, 0.8609905399674285], 
     RGBColor[0.7360732869767201, 0.26530969463248444`, 0.4069986803693921], 
     RGBColor[0.7062200155784408, 0.2561865224904659, 0.39703889288505106`], 
     RGBColor[0.6807458251017838, 0.24840159929740835`, 0.38854007477904784`],
      
     RGBColor[0.7062200155784408, 0.2561865224904659, 0.39703889288505106`], 
     RGBColor[0.6599710682724629, 0.2420528249793819, 0.3816091036201944], 
     RGBColor[0.6441569997114013, 0.23722003905708053`, 0.3763331403922565], 
     RGBColor[0.6599710682724629, 0.2420528249793819, 0.3816091036201944], 
     RGBColor[0.6800354654539903, 0.8010439440166657, 0.8949081875550023], 
     RGBColor[0.680984712574316, 0.7968030582078693, 0.8928564574105962], 
     RGBColor[0.6274698226482407, 0.2321204308138, 0.3707658866382097], 
     RGBColor[0.6340394115613381, 0.23412809991501407`, 0.37295766349780385`],
      
     RGBColor[0.7072768508559603, 0.7151479850137378, 0.8471362430152756], 
     RGBColor[0.7342038576347616, 0.6811093299786538, 0.8156950694541215], 
     RGBColor[0.7624134370542847, 0.6454493641148695, 0.7827563068986546], 
     RGBColor[0.7290820607257962, 0.68758383639432, 0.8216755078623943], 
     RGBColor[0.7940990718252388, 0.594555239243507, 0.7287281589081969], 
     RGBColor[0.7897700650746194, 0.601706338102322, 0.7364203753033359], 
     RGBColor[0.8173871053790583, 0.5560856687936705, 0.6873476289546191], 
     RGBColor[0.7876853252988748, 0.6051501258093107, 0.74012475148161], 
     RGBColor[0.8310502533117667, 0.5031781438912035, 0.6333230906153151], 
     RGBColor[0.8305876868599477, 0.4436491062182305, 0.5750261502008082], 
     RGBColor[0.8310385649963176, 0.5016739401860353, 0.6318500200400237], 
     RGBColor[0.8253136696629794, 0.3859792176404155, 0.5189073811489673], 
     RGBColor[0.7884447275772667, 0.33498152379124213`, 0.47166709840925114`],
      
     RGBColor[0.8204711816195827, 0.3792810128985678, 0.5127026871330138], 
     RGBColor[0.7532520634575686, 0.28630248368369754`, 0.4265746355033884], 
     RGBColor[0.7067959424152108, 0.2563625259710548, 0.39723103627946277`], 
     RGBColor[0.7447907106668225, 0.27459860896526517`, 0.4157330795600127], 
     RGBColor[0.6541237629211242, 0.24026588603471793`, 0.37965829836744946`],
      
     RGBColor[0.6064858049527757, 0.22570770628814138`, 0.36376510089428854`],
      
     RGBColor[0.6340202152303944, 0.23412223350830247`, 0.3729512591284425], 
     RGBColor[0.5626625552748026, 0.2164513872711137, 0.35396289128015773`], 
     RGBColor[0.535305760645013, 0.21434893635434002`, 0.35212597374332644`], 
     
     RGBColor[0.6597073463353486, 0.8711143111389142, 0.8826789020541397], 
     RGBColor[0.6754200302004181, 0.8216640053781102, 0.9048841226266396], 
     RGBColor[0.6824716816851251, 0.7901598289948228, 0.8896424794241256], 
     RGBColor[0.6902685283295387, 0.7553263956562989, 0.8727901498788281], 
     RGBColor[0.7041230742441913, 0.7191347004711065, 0.8508187331872542], 
     RGBColor[0.6948140668995807, 0.7350186068811151, 0.8629652915179039], 
     RGBColor[0.7317088174556877, 0.6842633311883624, 0.8186083895998302], 
     RGBColor[0.7606085098858136, 0.6477309876817117, 0.7848638203269134], 
     RGBColor[0.7409379765810812, 0.6725966737572631, 0.8078320119553067], 
     RGBColor[0.788754501670633, 0.6033839502470162, 0.7382249309246296], 
     RGBColor[0.8170471592377401, 0.5566472268145474, 0.6879516795907931], 
     RGBColor[0.7925110729418806, 0.5971784592236923, 0.731549875701381], 
     RGBColor[0.8310445594474473, 0.5024453837391294, 0.6326054967049572], 
     RGBColor[0.8305706768706367, 0.4414600406460777, 0.5728823926295148], 
     RGBColor[0.8310656210641233, 0.5051558651578094, 0.6352598781620786], 
     RGBColor[0.8229546924427364, 0.38271624367725043`, 0.5158848167748187], 
     RGBColor[0.8302097392744017, 0.39500991941621627`, 0.5273936688833004], 
     RGBColor[0.4059239061866546, 0.20440555657608026`, 0.34343841364651895`],
      
     RGBColor[
     0.41800262052776876`, 0.20533384164688565`, 0.34424945903746573`], 
     RGBColor[0.663612054029425, 0.8596367859178257, 0.8903930601086504], 
     RGBColor[0.6608079470183491, 0.867879197761119, 0.884853253705724], 
     RGBColor[0.45855285529574963`, 0.20845024762269734`, 0.3469722720854103],
      
     RGBColor[0.6806039660471187, 0.7985040931748079, 0.8936794139521559], 
     RGBColor[0.7588096481325247, 0.2939898212030482, 0.43369558491344967`], 
     RGBColor[0.7394207331094634, 0.26717077252747234`, 0.40885251169544473`],
      
     RGBColor[0.7104978662702918, 0.257493835439152, 0.3984660893625209], 
     RGBColor[0.685336622997365, 0.24980454904156993`, 0.39007167816058486`], 
     
     RGBColor[0.6172422695559645, 0.22899488633970774`, 0.36735372272743116`],
      
     RGBColor[0.6367242568127962, 0.23494858973929328`, 0.37385339407875473`],
      
     RGBColor[0.6802636256835158, 0.8000246083149207, 0.8944150354446103], 
     RGBColor[0.6807933627124763, 0.7976579387718612, 0.8932700465290231], 
     RGBColor[0.6620599186953211, 0.8641991434204743, 0.8873266545727297], 
     RGBColor[0.6640993725391758, 0.8582043584675318, 0.8913558087448183], 
     RGBColor[0.6620599186953211, 0.8641991434204743, 0.8873266545727297], 
     RGBColor[0.6667785791903363, 0.8503290796194243, 0.8966488614358308], 
     RGBColor[0.6700638460706525, 0.8406723430770098, 0.9031392494370771], 
     RGBColor[0.6667785791903363, 0.8503290796194243, 0.8966488614358308], 
     RGBColor[0.6743181273794516, 0.8265869005189517, 0.9072658072117951], 
     RGBColor[0.6814869611199975, 0.7945591970633256, 0.8917708828967592], 
     RGBColor[0.6743181273794516, 0.8265869005189517, 0.9072658072117951], 
     RGBColor[0.6894133734527046, 0.7591469120464287, 0.874638506330343], 
     RGBColor[0.7019283753339982, 0.7219090377646503, 0.8533813614777547], 
     RGBColor[0.6894133734527046, 0.7591469120464287, 0.874638506330343], 
     RGBColor[0.7299725302559327, 0.6864581863952479, 0.8206357559405437], 
     RGBColor[0.7593524692154509, 0.6493187592242278, 0.7863304294098002], 
     RGBColor[0.7299725302559327, 0.6864581863952479, 0.8206357559405437], 
     RGBColor[0.7910435413036002, 0.5996026790108941, 0.7341575341271275], 
     RGBColor[0.7880477756813402, 0.6045513929669435, 0.7394807130369886], 
     RGBColor[0.8168105922522753, 0.5570380125067962, 0.6883720357022454], 
     RGBColor[0.7880477756813402, 0.6045513929669435, 0.7394807130369886], 
     RGBColor[0.8310573931917915, 0.5040969960589242, 0.6342229249174522], 
     RGBColor[0.8310405971129655, 0.5019354592564665, 0.6321061263414549], 
     RGBColor[0.8305588396958463, 0.4399366797943241, 0.5713905614110707], 
     RGBColor[0.8310405971129655, 0.5019354592564665, 0.6321061263414549], 
     RGBColor[0.8282717335346137, 0.39007085757305043`, 0.5226975569921818], 
     RGBColor[0.8213130908419392, 0.38044555482306125`, 0.5137814278685856], 
     RGBColor[0.7829145294216795, 0.32733206773122714`, 0.4645812394261198], 
     RGBColor[0.8213130908419392, 0.38044555482306125`, 0.5137814278685856], 
     RGBColor[0.7584207333171853, 0.2934518681844892, 0.43319726722927027`], 
     RGBColor[0.7462617914179367, 0.27663343072929414`, 0.41761797960553143`],
      
     RGBColor[0.6923728379929259, 0.2519548192674472, 0.3924191329877285], 
     RGBColor[0.7462617914179367, 0.27663343072929414`, 0.41761797960553143`],
      
     RGBColor[0.6375153941655265, 0.23519036164296997`, 0.374117337008124], 
     RGBColor[0.5879010317373669, 0.22002819187236713`, 0.3575647622714061], 
     RGBColor[0.6375153941655265, 0.23519036164296997`, 0.374117337008124], 
     RGBColor[0.5400619804821151, 0.21471446597475846`, 0.352445338045542], 
     RGBColor[0.4985573523559796, 0.2115247120348315, 0.3496584406660683], 
     RGBColor[0.5400619804821151, 0.21471446597475846`, 0.352445338045542], 
     RGBColor[0.4647094246896628, 0.20892339826558437`, 0.34738566519083225`],
      
     RGBColor[0.4389438548125937, 0.2069432376969828, 0.34565559309012994`], 
     RGBColor[0.4647094246896628, 0.20892339826558437`, 0.34738566519083225`],
      
     RGBColor[0.6614933774756167, 0.865864438660835, 0.8862073931950276], 
     RGBColor[0.6599078648280232, 0.8705249056731837, 0.8830750472886963], 
     RGBColor[0.6594754439140497, 0.8717959667448709, 0.8822207545892635], 
     RGBColor[0.6789890219554753, 0.8057190673723584, 0.8971700007586959], 
     RGBColor[0.6930383195004518, 0.7429519909111746, 0.8668034432379671], 
     RGBColor[0.7112315616409668, 0.7101488019526505, 0.8425185463957817], 
     RGBColor[0.7373325390601951, 0.677154337556739, 0.8120418815404891], 
     RGBColor[0.7646767441359171, 0.6425882986565727, 0.7801135686485265], 
     RGBColor[0.7910435413036002, 0.5996026790108941, 0.7341575341271275], 
     RGBColor[0.8178133843572131, 0.5553814973081946, 0.6865901734149169], 
     RGBColor[0.8310573931917915, 0.5040969960589242, 0.6342229249174522], 
     RGBColor[0.8306090167118877, 0.4463941076222531, 0.5777143371687741], 
     RGBColor[0.8282717335346137, 0.3900708575730504, 0.5226975569921818], 
     RGBColor[
     0.41175574537625603`, 0.20485375073831966`, 0.34383000220154997`], 
     RGBColor[0.4062927282509287, 0.20443390164711847`, 0.3434631788182799], 
     RGBColor[0.4402828039448567, 0.20704613991446608`, 0.3457454990595706], 
     RGBColor[0.6806039660471187, 0.7985040931748076, 0.8936794139521558], 
     RGBColor[0.6883967030170228, 0.7636890203452941, 0.8768359671760488], 
     RGBColor[0.6966940678993607, 0.7285257696791483, 0.8594931721916896], 
     RGBColor[0.6290488834451662, 0.23260299244936983`, 0.3712927002578098], 
     RGBColor[0.6327151094866221, 0.23372339265079237`, 0.3725158436699774], 
     RGBColor[0.6367242568127962, 0.23494858973929328`, 0.37385339407875473`],
      
     RGBColor[0.6687248699283748, 0.8446081389540591, 0.9004939621577196], 
     RGBColor[0.6785576750702622, 0.8076461660645734, 0.898102326375637], 
     RGBColor[0.5608803140004011, 0.21631441673593277`, 0.3538432197215517], 
     RGBColor[0.787821960437906, 0.6049244178252194, 0.7398819643673471], 
     RGBColor[0.8310393310557678, 0.5017725266306257, 0.6319465659999556], 
     RGBColor[0.8207885612919832, 0.3797200173953447, 0.5131093466304625], 
     RGBColor[0.7453452729812209, 0.2753656881796411, 0.416443641866576], 
     RGBColor[0.7917574626826184, 0.5984233502057243, 0.7328889665196184], 
     RGBColor[0.7917574626826184, 0.5984233502057243, 0.7328889665196184], 
     RGBColor[0.7294177464746305, 0.6871594932247047, 0.8212835462166825], 
     RGBColor[0.787821960437906, 0.6049244178252194, 0.7398819643673471], 
     RGBColor[0.8310393310557678, 0.5017725266306257, 0.6319465659999556], 
     RGBColor[0.8207885612919832, 0.37972001739534467`, 0.5131093466304625], 
     RGBColor[0.7892265249271243, 0.6026042136549338, 0.7373861923313136], 
     RGBColor[0.8310472058960763, 0.5027859629997166, 0.6329390268548974], 
     RGBColor[0.8240511204009684, 0.3842328398738973, 0.517289673107018], 
     RGBColor[0.7510459919864912, 0.28325101132981634`, 0.42374798971042166`],
      
     RGBColor[0.6761559926041922, 0.8183759969689806, 0.9032933922292119], 
     RGBColor[0.6908396874433721, 0.7527746675250722, 0.8715556300725396], 
     RGBColor[0.7328684860551865, 0.6827973843886448, 0.8172543088432952], 
     RGBColor[0.7892265249271243, 0.6026042136549338, 0.7373861923313136], 
     RGBColor[0.8310472058960763, 0.5027859629997166, 0.6329390268548974], 
     RGBColor[0.8240511204009684, 0.3842328398738973, 0.517289673107018], 
     RGBColor[0.6687248699283748, 0.8446081389540591, 0.9004939621577196], 
     RGBColor[0.6604023314204804, 0.8690714670983775, 0.8840519177091575], 
     RGBColor[0.6608079470183491, 0.867879197761119, 0.884853253705724], 
     RGBColor[0.6649309400523958, 0.8557600430785721, 0.8929986572580905], 
     RGBColor[0.6638336675512814, 0.8589853735751554, 0.8908308807775857], 
     RGBColor[0.6707979178839294, 0.8385146072332339, 0.9045894850077372], 
     RGBColor[0.6698292932061412, 0.841361789414361, 0.9026758657446885], 
     RGBColor[0.6824716816851251, 0.7901598289948228, 0.8896424794241256], 
     RGBColor[0.6811723202018796, 0.7959648965655322, 0.8924509568654267], 
     RGBColor[0.7041230742441913, 0.7191347004711065, 0.8508187331872542], 
     RGBColor[0.7012271184449375, 0.7227955024777096, 0.8542001802845028], 
     RGBColor[0.7589511352698505, 0.6498260888297936, 0.7867990448167507], 
     RGBColor[0.8167350036476102, 0.5571628775429809, 0.6885063491689563], 
     RGBColor[0.8305550574456569, 0.4394499308891069, 0.570913886950446], 
     RGBColor[0.7821894462575979, 0.326329121426691, 0.46365218825884225`], 
     RGBColor[0.689337541059325, 0.2510272312635081, 0.39140648308389653`], 
     RGBColor[0.5839899247037629, 0.21883295593800703`, 0.35625992052178623`],
      
     RGBColor[0.49345319010443495`, 0.21113244200647677`, 0.3493157131909538],
      
     RGBColor[
     0.44987068169190847`, 0.20778299679525183`, 0.34638929307904154`], 
     RGBColor[0.43333993951650734`, 0.2065125601628923, 0.34527930886452524`],
      
     RGBColor[0.4835703526662657, 0.2103729165974006, 0.34865211361178167`], 
     RGBColor[0.4092224822429802, 0.20465906194275496`, 0.3436599020294393], 
     RGBColor[0.7207203445745213, 0.6981539518888727, 0.831439020418432], 
     RGBColor[0.769829571166387, 0.6346460980624954, 0.7718526587355886], 
     RGBColor[0.8188361819555057, 0.5536919349768579, 0.6847727633465751], 
     RGBColor[0.8306209744045127, 0.4479329782687314, 0.5792213571692689], 
     RGBColor[0.8023449845498856, 0.35420857532601235`, 0.48947753810167965`],
      
     RGBColor[0.7067959424152108, 0.2563625259710548, 0.39723103627946277`], 
     RGBColor[0.7411973935203048, 0.26962827682730806`, 0.4111289518478496], 
     RGBColor[0.6064858049527757, 0.22570770628814138`, 0.36376510089428854`],
      
     RGBColor[0.6531989816245796, 0.23998327248628845`, 0.3793497685229243], 
     RGBColor[0.5228112776729246, 0.21338869822941453`, 0.3512870108752104], 
     RGBColor[0.5834692271106058, 0.21867383053721157`, 0.35608620296493076`],
      
     RGBColor[
     0.46557250342826684`, 0.20898972842998345`, 0.34744361805015156`], 
     RGBColor[0.5325041120574205, 0.2141336213395083, 0.35193785238290276`], 
     RGBColor[0.4059239061866546, 0.20440555657608026`, 0.34343841364651895`],
      
     RGBColor[0.7368136643635472, 0.6778102514112094, 0.812647742768505], 
     RGBColor[0.7918556544722599, 0.33969957089789304`, 0.4760375289615946], 
     RGBColor[0.6428014465615243, 0.23680578145130615`, 0.3758808944351423], 
     RGBColor[0.6658157827601078, 0.24383897215502467`, 0.38355904449692346`],
      
     RGBColor[0.6024974534777555, 0.22448886442039287`, 0.36243448849425697`],
      
     RGBColor[0.6277651437071341, 0.23221068105209056`, 0.3708644130257197], 
     RGBColor[0.6800354654539903, 0.8010439440166657, 0.8949081875550023], 
     RGBColor[0.6789441867891843, 0.8059193743486841, 0.8972669087821588], 
     RGBColor[0.7197300929312034, 0.6994057372938275, 0.8325952823840689], 
     RGBColor[0.731393303781268, 0.6846621746695799, 0.8189767974321539], 
     RGBColor[0.7695280190123596, 0.30881563842939963`, 0.44742906469964494`],
      
     RGBColor[0.7847714311515313, 0.3299005630709314, 0.4669604930139807], 
     RGBColor[0.6024974534777556, 0.2244888644203929, 0.362434488494257], 
     RGBColor[0.6274698226482407, 0.2321204308138, 0.3707658866382097], 
     RGBColor[0.6712196162579256, 0.8372750640708672, 0.9054225942090409], 
     RGBColor[0.6661259004007698, 0.8522475682376336, 0.8953594262883084], 
     RGBColor[0.6783167123267586, 0.8087226986739348, 0.8986231502095355], 
     RGBColor[0.671852777165683, 0.8354139464515336, 0.9066734697416161], 
     RGBColor[0.6899185680636399, 0.7568898889695923, 0.8735465641059709], 
     RGBColor[0.6838867225697784, 0.7838379485507364, 0.8865839691832792], 
     RGBColor[0.7207203445745213, 0.6981539518888727, 0.831439020418432], 
     RGBColor[0.7134486054404487, 0.7073462182972088, 0.8399298272163789], 
     RGBColor[0.769829571166387, 0.6346460980624954, 0.7718526587355886], 
     RGBColor[0.7659455729338867, 0.6409843615347287, 0.7786320275777323], 
     RGBColor[0.8188361819555057, 0.5536919349768579, 0.6847727633465751], 
     RGBColor[0.8180523599022643, 0.5549867329093504, 0.6861655375315431], 
     RGBColor[0.8306209744045127, 0.4479329782687314, 0.5792213571692689], 
     RGBColor[0.8023449845498856, 0.35420857532601235`, 0.48947753810167965`],
      
     RGBColor[0.7948261769603153, 0.3438084437824406, 0.47984366806626955`], 
     RGBColor[0.5228112776729246, 0.21338869822941453`, 0.3512870108752104], 
     RGBColor[0.5325041120574205, 0.2141336213395083, 0.35193785238290276`], 
     RGBColor[
     0.46557250342826684`, 0.20898972842998345`, 0.34744361805015156`], 
     RGBColor[0.6602307723798231, 0.8695757489474486, 0.8837129848980486], 
     RGBColor[0.6604023314204804, 0.8690714670983775, 0.8840519177091575], 
     RGBColor[0.659446250087549, 0.8718817792835329, 0.8821630791345338], 
     RGBColor[0.6636728961285461, 0.8594579462243382, 0.8905132600328856], 
     RGBColor[0.6649309400523958, 0.8557600430785721, 0.8929986572580905], 
     RGBColor[0.6696873711517869, 0.8417789560977341, 0.9023954838968052], 
     RGBColor[0.6698292932061412, 0.841361789414361, 0.9026758657446885], 
     RGBColor[0.6809819388753662, 0.7968154500711285, 0.8928624525636233], 
     RGBColor[0.6811723202018796, 0.7959648965655322, 0.8924509568654267], 
     RGBColor[0.7012271184449375, 0.7227955024777096, 0.8542001802845028], 
     RGBColor[0.7589511352698505, 0.6498260888297936, 0.7867990448167507], 
     RGBColor[0.8167350036476102, 0.5571628775429809, 0.6885063491689563], 
     RGBColor[0.8305550574456569, 0.43944993088910683`, 0.570913886950446], 
     RGBColor[0.7851837965830194, 0.33047095334630533`, 0.4674888580408452], 
     RGBColor[0.6982912293975813, 0.25376348213953787`, 0.3943936543007567], 
     RGBColor[0.5955271265665492, 0.2223587296204679, 0.36010901555677516`], 
     RGBColor[0.508509732850651, 0.21228958203434223`, 0.35032670982958986`], 
     
     RGBColor[
     0.44987068169190847`, 0.20778299679525183`, 0.34638929307904154`], 
     RGBColor[0.4092224822429801, 0.20465906194275496`, 0.3436599020294393], 
     RGBColor[0.7972459875229689, 0.34715556337052944`, 0.4829441783790025], 
     RGBColor[0.8126741088130871, 0.3684959805810969, 0.5027122750657325], 
     RGBColor[0.4231269909868529, 0.205727664736008, 0.3445935434263313], 
     RGBColor[0.681372648814647, 0.7950699022560529, 0.8920179608153983], 
     RGBColor[0.6785576750702622, 0.8076461660645736, 0.8981023263756371], 
     RGBColor[0.6854318119095252, 0.7769350596043834, 0.8832443684552086], 
     RGBColor[0.6920322787032008, 0.7474466099084569, 0.8689779288761367], 
     RGBColor[0.711529132516346, 0.7097726401141393, 0.8421710893755345], 
     RGBColor[0.7456961486065924, 0.6665818286055373, 0.8022761581718962], 
     RGBColor[0.7750562185854477, 0.31646233001903257`, 0.45451236289320673`],
      
     RGBColor[0.7802475194402918, 0.3236430180642391, 0.46116399177910306`], 
     RGBColor[0.7284471921475378, 0.2629791568843836, 0.40445442708402296`], 
     RGBColor[0.7385100000541986, 0.26605435516130754`, 0.4078116279384615], 
     RGBColor[0.6717944310866085, 0.24566604956746532`, 0.3855536690049427], 
     RGBColor[0.6836060018169977, 0.2492756704898537, 0.3894943002597713], 
     RGBColor[0.63432916678392, 0.2342166492314155, 0.3730543329850735], 
     RGBColor[0.647297218860792, 0.23817969133375547`, 0.3773807949345319], 
     RGBColor[0.6314043251752793, 0.2333228164206735, 0.37207853370134414`], 
     RGBColor[0.6327151094866221, 0.23372339265079237`, 0.3725158436699774], 
     RGBColor[0.6621659021828803, 0.863887614812757, 0.8875360360266704], 
     RGBColor[0.6676243332827103, 0.8478430641000584, 0.8983197370185844], 
     RGBColor[0.665486345133756, 0.8541274814814768, 0.8940959180308725], 
     RGBColor[0.6731755288668174, 0.831525840810735, 0.9092867039421949], 
     RGBColor[0.6712882054537246, 0.8370734525069922, 0.9055580993322613], 
     RGBColor[0.685661127715305, 0.7759105612144066, 0.8827487186489226], 
     RGBColor[0.6831293778996801, 0.787221485034561, 0.8882209158287564], 
     RGBColor[0.7112315616409668, 0.7101488019526505, 0.8425185463957817], 
     RGBColor[0.7055889166531338, 0.7172817167917964, 0.8491071502411265], 
     RGBColor[0.7614474211703746, 0.6466705128931552, 0.7838842701111406], 
     RGBColor[0.8172051626514382, 0.5563862205153024, 0.6876709231680496], 
     RGBColor[0.8305785829358966, 0.4424774954460287, 0.5738787887441815], 
     RGBColor[0.7866994432290644, 0.33256741934901396`, 0.4694308604971732], 
     RGBColor[0.7022441311251816, 0.2549714905497471, 0.39571243979090076`], 
     RGBColor[0.6006206057510126, 0.22391529897535362`, 0.36180832581180117`],
      
     RGBColor[0.4852619651147105, 0.21050292203813983`, 0.34876569974693095`],
      
     RGBColor[0.4571687243347893, 0.208343873047489, 0.3468793323068337], 
     RGBColor[0.6621659021828803, 0.8638876148127571, 0.8875360360266704], 
     RGBColor[0.6599078648280232, 0.8705249056731837, 0.8830750472886963], 
     RGBColor[0.6731755288668174, 0.8315258408107351, 0.9092867039421949], 
     RGBColor[0.6856611277153049, 0.7759105612144067, 0.8827487186489227], 
     RGBColor[0.7055889166531337, 0.7172817167917964, 0.8491071502411265], 
     RGBColor[0.7614474211703746, 0.6466705128931552, 0.7838842701111406], 
     RGBColor[0.8172051626514382, 0.5563862205153024, 0.6876709231680496], 
     RGBColor[0.8305785829358966, 0.4424774954460287, 0.5738787887441815], 
     RGBColor[0.7925338057079078, 0.34063760022942646`, 0.4769064461124533], 
     RGBColor[0.7174605152225219, 0.25962162385162396`, 0.40078900074355905`],
      
     RGBColor[0.6202275530023053, 0.22990719020116174`, 0.3683496868986405], 
     RGBColor[0.540744847647361, 0.21476694634451796`, 0.35249119029863457`], 
     
     RGBColor[0.4852619651147105, 0.21050292203813983`, 0.34876569974693095`],
      
     RGBColor[
     0.41175574537625603`, 0.20485375073831966`, 0.34383000220154997`], 
     RGBColor[0.4317864202726936, 0.20639316759506474`, 0.34517499522758843`],
      
     RGBColor[0.681372648814647, 0.7950699022560528, 0.8920179608153983], 
     RGBColor[0.6807933627124763, 0.7976579387718612, 0.8932700465290231], 
     RGBColor[0.6833663058557953, 0.7861629783661909, 0.887708812900862], 
     RGBColor[0.6902089393469952, 0.755592617238664, 0.8729189472268956], 
     RGBColor[0.706955298872025, 0.7155544615726412, 0.8475117014469866], 
     RGBColor[0.7456961486065924, 0.6665818286055373, 0.8022761581718962], 
     RGBColor[0.7423758798554039, 0.670779008172278, 0.8061530519883295], 
     RGBColor[0.7802475194402918, 0.3236430180642391, 0.46116399177910306`], 
     RGBColor[0.7394207331094634, 0.26717077252747234`, 0.40885251169544473`],
      
     RGBColor[0.685336622997365, 0.24980454904156993`, 0.39007167816058486`], 
     
     RGBColor[0.6491972866929727, 0.23876035285266345`, 0.3780147044167418], 
     RGBColor[0.63432916678392, 0.23421664923141552`, 0.3730543329850735], 
     RGBColor[0.6314043251752793, 0.23332281642067354`, 0.37207853370134414`],
      
     RGBColor[0.6717117052299527, 0.8358286142902528, 0.9063947673919035], 
     RGBColor[0.6172422695559646, 0.22899488633970777`, 0.3673537227274312], 
     RGBColor[0.5231459402091073, 0.2134144180392654, 0.3513094823485666], 
     RGBColor[0.6762596858364189, 0.8179127338759437, 0.9030692666819493], 
     RGBColor[0.6789441867891843, 0.8059193743486841, 0.8972669087821588], 
     RGBColor[0.6849168583464866, 0.7792356820776226, 0.8843574039605392], 
     RGBColor[0.6863052840091578, 0.7730327086228603, 0.8813564206292528], 
     RGBColor[0.6970932248770584, 0.7280211919969608, 0.859027098709515], 
     RGBColor[0.6971630075691101, 0.7279329791108543, 0.8589456173272586], 
     RGBColor[0.731393303781268, 0.6846621746695799, 0.8189767974321539], 
     RGBColor[0.7099786046544265, 0.7117326753845917, 0.8439815548319621], 
     RGBColor[0.6712513241401163, 0.837181861699252, 0.9054852364434813], 
     RGBColor[0.677335624648689, 0.8131058363437993, 0.9007437014551479], 
     RGBColor[0.5567128678972508, 0.21599413612562207`, 0.3535633896122764], 
     RGBColor[0.5407448476473611, 0.21476694634451798`, 0.35249119029863457`],
      
     RGBColor[
     0.49618207661224356`, 0.21134216503937428`, 0.34949894882034865`], 
     RGBColor[0.460976283203511, 0.20863649525497147`, 0.3471349971883786], 
     RGBColor[0.671381834242636, 0.8367982393872548, 0.9057430727880745], 
     RGBColor[0.6731361838502288, 0.8316414918288397, 0.9092089737507434], 
     RGBColor[0.6829234723430544, 0.7881413950709973, 0.8886659660463273], 
     RGBColor[0.6926199897515891, 0.7448209338422209, 0.8677076332404069], 
     RGBColor[0.7227485998886748, 0.6955900173406072, 0.8290707390909716], 
     RGBColor[0.7657680919789607, 0.6412087166979168, 0.7788392622530703], 
     RGBColor[0.8090824511739172, 0.5698041512609808, 0.7021041772606733], 
     RGBColor[0.8309111560592405, 0.4852773092040266, 0.6157927569509077], 
     RGBColor[0.5550640602146142, 0.21586742035826503`, 0.35345267767441657`],
      
     RGBColor[0.6087846522201772, 0.22641023496812793`, 0.36453205302951075`],
      
     RGBColor[0.5968321160975639, 0.22275753496331102`, 0.3605443922437987], 
     RGBColor[0.5550640602146141, 0.21586742035826503`, 0.35345267767441657`],
      
     RGBColor[0.5310574705002387, 0.21402244263932432`, 0.35184071522623445`],
      
     RGBColor[0.6707134339321713, 0.8387629399544136, 0.9044225781332684], 
     RGBColor[0.6738781180617778, 0.8285526997624829, 0.9082168560604668], 
     RGBColor[0.6612531694083673, 0.2424446356191702, 0.3820368441742087], 
     RGBColor[0.6013382501812279, 0.2241346114113767, 0.3620477496899721], 
     RGBColor[0.6734784486247615, 0.83033827530689, 0.9090807131258882], 
     RGBColor[0.6817544575391566, 0.7933641217835328, 0.8911927084098867], 
     RGBColor[0.6761091115266028, 0.8185854443219331, 0.9033947223444504], 
     RGBColor[0.676175709641738, 0.8182879085219061, 0.9032507752547435], 
     RGBColor[0.6665905660678287, 0.850881726712253, 0.8962774218667315], 
     RGBColor[0.6638038785993984, 0.8590729354295461, 0.8907720295904782], 
     RGBColor[0.6474572607274142, 0.23822860019468547`, 0.37743418884767765`],
      
     RGBColor[0.6347990910930102, 0.2343602582955061, 0.373211111322356], 
     RGBColor[0.5788765552684773, 0.21769748132608568`, 0.3550516073133633], 
     RGBColor[0.5362293488669935, 0.2144199168522493, 0.35218798961268266`], 
     RGBColor[0.6701178978953025, 0.840513462763995, 0.9032460344645754], 
     RGBColor[0.6007570642437338, 0.22395700074742164`, 0.3618538517298758], 
     RGBColor[0.6712513241401163, 0.837181861699252, 0.9054852364434813], 
     RGBColor[0.6393666944981508, 0.23575611979375274`, 0.3747349764499337], 
     RGBColor[0.6002961492412473, 0.22381614493117213`, 0.361700079119435], 
     RGBColor[0.6629248232631796, 0.8616568368589641, 0.8890353639208456], 
     RGBColor[0.6675663522049525, 0.848013494087256, 0.8982051893410019], 
     RGBColor[0.661783561750059, 0.8650114689663994, 0.8867806825506889], 
     RGBColor[0.759076141824088, 0.6496680669964806, 0.7866530815910437], 
     RGBColor[0.8069728997335295, 0.5732889254290532, 0.705852641310497], 
     RGBColor[0.7925110729418806, 0.5971784592236923, 0.731549875701381], 
     RGBColor[0.8183046207642534, 0.5545700224567656, 0.6857172949553063], 
     RGBColor[0.8308758225219043, 0.4807301323239706, 0.6113396948824913], 
     RGBColor[0.8310656210641233, 0.5051558651578094, 0.6352598781620786], 
     RGBColor[0.8306335968586148, 0.4495573990256201, 0.5808121566139477], 
     RGBColor[0.8209519405235548, 0.379946006088311, 0.5133186849151167], 
     RGBColor[0.8302097392744017, 0.39500991941621627`, 0.5273936688833004], 
     RGBColor[0.797245987522969, 0.3471555633705295, 0.48294417837900255`], 
     RGBColor[0.7593843180903249, 0.2947847136223664, 0.43443191120199337`], 
     RGBColor[0.7643770176782088, 0.3016906933077032, 0.44082907170683716`], 
     RGBColor[0.7297501816075781, 0.26337735100470605`, 0.40488913649805003`],
      
     RGBColor[0.6822694878580845, 0.24886723126874782`, 0.3890484062462462], 
     RGBColor[0.6805558303768653, 0.24834353683053886`, 0.3884766878537729], 
     RGBColor[0.6360633020873918, 0.23474660170061246`, 0.37363288328400884`],
      
     RGBColor[0.5079517549262489, 0.21224669977366167`, 0.35028924347257073`],
      
     RGBColor[
     0.47497633657425453`, 0.20971244093656635`, 0.34807505408836675`], 
     RGBColor[
     0.47521508576845206`, 0.20973078952122373`, 0.34809108530063637`], 
     RGBColor[0.45932150782549275`, 0.20850932085250035`, 0.3470238845396734],
      
     RGBColor[0.4158352184738213, 0.205167270361872, 0.3441039252168505], 
     RGBColor[0.6641676888721502, 0.8580035489585603, 0.8914907747990168], 
     RGBColor[0.6694656088151354, 0.8424308058676582, 0.9019573692286926], 
     RGBColor[0.668698379973017, 0.8446860037148928, 0.9004416284829616], 
     RGBColor[0.6736777710595283, 0.8294477762293813, 0.9086498918580529], 
     RGBColor[0.6949869472651613, 0.2527536921470883, 0.39329126430174627`], 
     RGBColor[0.6541237629211242, 0.24026588603471793`, 0.37965829836744946`],
      
     RGBColor[0.6340202152303944, 0.23412223350830247`, 0.3729512591284425], 
     RGBColor[0.5912694208554353, 0.2210575729862645, 0.3586885399416303], 
     RGBColor[0.5626625552748026, 0.2164513872711137, 0.35396289128015773`], 
     RGBColor[0.535305760645013, 0.21434893635434002`, 0.35212597374332644`], 
     
     RGBColor[0.5029532444748195, 0.21186254939993088`, 0.3499536101635329], 
     RGBColor[0.4903116933475494, 0.21089100865048838`, 0.34910477215920227`],
      
     RGBColor[0.46934969670942517`, 0.20928001695187612`, 0.3476972439837471],
      
     RGBColor[0.6155746045883349, 0.22848524723275962`, 0.36679734857161156`],
      
     RGBColor[0.4437701526202816, 0.20731415301757183`, 0.34597966289439197`],
      
     RGBColor[0.4265362898159067, 0.20598967947661267`, 0.3448224664742299], 
     RGBColor[0.5546634766678463, 0.2158366343229658, 0.3534257798250164], 
     RGBColor[0.7099786046544265, 0.7117326753845917, 0.8439815548319621], 
     RGBColor[0.756783161984212, 0.29118675405940797`, 0.4310990423169236], 
     RGBColor[0.756783161984212, 0.29118675405940797`, 0.4310990423169236], 
     RGBColor[0.6764271803943976, 0.8171644300056737, 0.9027072391063367], 
     RGBColor[0.6822507486386942, 0.7911468763097322, 0.8901200104922232], 
     RGBColor[0.7399424174378605, 0.2678923744004975, 0.4095209473429083], 
     RGBColor[0.6199172559204654, 0.2298123632840369, 0.3682461641405848], 
     RGBColor[0.6694656088151354, 0.8424308058676582, 0.9019573692286926], 
     RGBColor[0.6641676888721502, 0.8580035489585603, 0.8914907747990168], 
     RGBColor[0.7898347307121643, 0.3369041977361061, 0.4734481134692709], 
     RGBColor[0.5546634766678463, 0.2158366343229658, 0.3534257798250164], 
     RGBColor[0.5198548628570281, 0.21316148897028311`, 0.3510884974786316], 
     RGBColor[0.6610778074419663, 0.867085968136546, 0.8853863911704305], 
     RGBColor[0.6616163450951342, 0.8655029867763491, 0.8864503285763329], 
     RGBColor[0.6624419405819877, 0.8630762256036363, 0.8880813787274978], 
     RGBColor[0.664466669697841, 0.8571247226196018, 0.8920814426608253], 
     RGBColor[0.6663745631575749, 0.8515166471837718, 0.895850685547273], 
     RGBColor[0.668698379973017, 0.8446860037148928, 0.9004416284829616], 
     RGBColor[0.6629248232631796, 0.8616568368589641, 0.8890353639208456], 
     RGBColor[0.6703880801069592, 0.8397192872733987, 0.9037798076551776], 
     RGBColor[0.673753007226875, 0.8291116487999934, 0.9084872742327903], 
     RGBColor[0.6770034616811859, 0.8145898178960509, 0.9014616480874722], 
     RGBColor[0.666526867554198, 0.8510689625706123, 0.8961515787971646], 
     RGBColor[0.6819219048376158, 0.7926160290513549, 0.8908307829823648], 
     RGBColor[0.6889748000637654, 0.7611062960903113, 0.8755864515211718], 
     RGBColor[0.6914973836579271, 0.7498363235648103, 0.8701340664771703], 
     RGBColor[0.5493359234334426, 0.21542719603410881`, 0.3530680523903109], 
     RGBColor[
     0.47521508576845206`, 0.20973078952122373`, 0.34809108530063637`], 
     RGBColor[0.6675221858919954, 0.8481433168577688, 0.898117934174795], 
     RGBColor[0.6649120420437686, 0.8558155920178633, 0.8929613222673849], 
     RGBColor[0.79039770166431, 0.33768290790893285`, 0.4741694497878391], 
     RGBColor[0.7643770176782086, 0.30169069330770315`, 0.4408290717068371], 
     RGBColor[0.7491301867886058, 0.2806010397974279, 0.42129326293762936`], 
     RGBColor[0.7297501816075781, 0.263377351004706, 0.40488913649805003`], 
     RGBColor[0.6805558303768653, 0.24834353683053886`, 0.3884766878537729], 
     RGBColor[0.6443304891693873, 0.23727305750751818`, 0.37639102075348263`],
      
     RGBColor[0.6360633020873917, 0.2347466017006124, 0.3736328832840088], 
     RGBColor[0.5968321160975639, 0.22275753496331102`, 0.3605443922437987], 
     RGBColor[0.5706438853611049, 0.21706477619273637`, 0.3544988109813205], 
     RGBColor[0.561411178691375, 0.21635521526409826`, 0.3538788655153565], 
     RGBColor[0.5310574705002384, 0.2140224426393243, 0.35184071522623445`], 
     RGBColor[
     0.49935306326805706`, 0.21158586478168007`, 0.34971187000047765`], 
     RGBColor[0.5079517549262488, 0.21224669977366167`, 0.3502892434725707], 
     RGBColor[0.6810265796247926, 0.7966160116776031, 0.8927659647583871], 
     RGBColor[0.6831748906066547, 0.7870181510565107, 0.8881225433492893], 
     RGBColor[0.7145653213143186, 0.25873685139045294`, 0.3998230926637723], 
     RGBColor[0.6858925522095413, 0.2499744412397748, 0.3902571498543146], 
     RGBColor[0.6505220413028365, 0.23916519841181433`, 0.37845667522145243`],
      
     RGBColor[0.6629902501869376, 0.24297548822678094`, 0.3826163771562688], 
     RGBColor[0.6789859939261266, 0.8057325954899778, 0.8971765456287933], 
     RGBColor[0.6818193954258429, 0.7930740032714996, 0.8910523497859045], 
     RGBColor[0.6814043729004015, 0.7949281707488485, 0.891949391460114], 
     RGBColor[0.6883967030170228, 0.7636890203452941, 0.8768359671760488], 
     RGBColor[0.6966940678993607, 0.7285257696791483, 0.8594931721916896], 
     RGBColor[0.7279319175985988, 0.6890377419646363, 0.8230184662528104], 
     RGBColor[0.6614933774756167, 0.865864438660835, 0.8862073931950276], 
     RGBColor[0.7657680919789607, 0.6412087166979167, 0.7788392622530702], 
     RGBColor[0.8090824511739172, 0.5698041512609808, 0.7021041772606733], 
     RGBColor[0.7957279090587571, 0.5918645582737574, 0.7258338764100486], 
     RGBColor[0.8193814132332345, 0.5527912658412879, 0.6838039413476054], 
     RGBColor[0.8309111560592405, 0.4852773092040266, 0.6157927569509077], 
     RGBColor[0.8310836565982077, 0.5074769111042735, 0.6375328844549685], 
     RGBColor[0.8306874766535626, 0.4564913483655333, 0.5876025911196554], 
     RGBColor[0.8296980873211112, 0.3920438123043064, 0.5245251482478342], 
     RGBColor[0.8302987857605295, 0.4064695737134581, 0.5386161379480148], 
     RGBColor[0.8075751117861705, 0.36144296862561404`, 0.49617891534305525`],
      
     RGBColor[0.773473102933863, 0.3142725398390034, 0.45248391220382506`], 
     RGBColor[0.7774332204578496, 0.31975023596127106`, 0.45755802230659715`],
      
     RGBColor[0.7115764014051067, 0.2578234362244347, 0.39882591527887834`], 
     RGBColor[0.6657261930508442, 0.8534224708293909, 0.8945697626529093], 
     RGBColor[0.668092506880695, 0.8464669113378767, 0.8992446628810966], 
     RGBColor[0.7488411122490237, 0.6626062536965993, 0.7986039584158114], 
     RGBColor[0.7957279090587571, 0.5918645582737574, 0.7258338764100486], 
     RGBColor[0.8310836565982077, 0.5074769111042735, 0.6375328844549685], 
     RGBColor[0.8296980873211112, 0.3920438123043063, 0.5245251482478342], 
     RGBColor[0.5793736230385007, 0.2177356824604995, 0.3550849837566238], 
     RGBColor[0.5092422404849958, 0.21234587742158378`, 0.35037589527465385`],
      
     RGBColor[0.8075751117861705, 0.361442968625614, 0.49617891534305525`], 
     RGBColor[0.7584207333171853, 0.29345186818448915`, 0.4331972672292702], 
     RGBColor[0.6664041397816756, 0.24401877430525193`, 0.38375533490749714`],
      
     RGBColor[0.6810265796247926, 0.796616011677603, 0.892765964758387], 
     RGBColor[0.688477029839712, 0.7633301497465701, 0.8766623464612878], 
     RGBColor[0.6864399768284851, 0.7724309508152242, 0.8810652916790231], 
     RGBColor[0.7026108163452964, 0.72104635836043, 0.8525845129287222], 
     RGBColor[0.6648170814245944, 0.24353376861197587`, 0.3832258531046188], 
     RGBColor[0.6369438141836729, 0.23501568656304947`, 0.37392664383170066`],
      
     RGBColor[0.7104978662702918, 0.257493835439152, 0.3984660893625209], 
     RGBColor[0.6202065964909693, 0.229900785882591, 0.36834269528969643`], 
     RGBColor[0.6398161193226019, 0.235893464206821, 0.37488491565364784`], 
     RGBColor[0.6505220413028365, 0.23916519841181436`, 0.3784566752214525], 
     RGBColor[0.6754200302004181, 0.8216640053781102, 0.9048841226266396], 
     RGBColor[0.666526867554198, 0.8510689625706123, 0.8961515787971646], 
     RGBColor[0.6902685283295387, 0.7553263956562989, 0.8727901498788281], 
     RGBColor[0.6739660440295717, 0.8281598789879369, 0.9080268103339788], 
     RGBColor[0.7317088174556877, 0.6842633311883624, 0.8186083895998302], 
     RGBColor[0.7409379765810812, 0.6725966737572631, 0.8078320119553067], 
     RGBColor[0.6891401317584528, 0.7603676550950106, 0.8752290988207503], 
     RGBColor[0.7294177464746306, 0.6871594932247046, 0.8212835462166825], 
     RGBColor[0.635337814225579, 0.23452489230863455`, 0.37339084264364736`], 
     
     RGBColor[0.5370987419471294, 0.21448673229254864`, 0.3522463664589804], 
     RGBColor[0.6837530999041462, 0.784434925306609, 0.8868727850724014], 
     RGBColor[0.6980534462846867, 0.7268073680647258, 0.857905901385862], 
     RGBColor[0.7448393785051265, 0.6676648788742782, 0.8032765611384599], 
     RGBColor[0.8310745243488871, 0.5063016550697887, 0.6363819531835689], 
     RGBColor[0.8302536972863738, 0.4006670053125783, 0.5329336677193591], 
     RGBColor[0.7708222435714999, 0.31060582995932423`, 0.44908735839194397`],
      
     RGBColor[0.6958692098479369, 0.2530233119589253, 0.3935856088548976], 
     RGBColor[0.6764271803943976, 0.8171644300056737, 0.9027072391063367], 
     RGBColor[0.6800781367182709, 0.8008533045559222, 0.8948159566518478], 
     RGBColor[0.6822507486386942, 0.7911468763097322, 0.8901200104922232], 
     RGBColor[0.6855761153628069, 0.7762903650310957, 0.8829324668031514], 
     RGBColor[0.6199172559204654, 0.22981236328403687`, 0.36824616414058475`],
      
     RGBColor[0.6442110232442809, 0.23723654867117291`, 0.3763511639749807], 
     RGBColor[0.6736777710595283, 0.8294477762293813, 0.9086498918580529], 
     RGBColor[0.6709136914637699, 0.838174301559503, 0.9048182078119513], 
     RGBColor[0.6837530999041462, 0.784434925306609, 0.8868727850724014], 
     RGBColor[0.6801021435802729, 0.8007460507563605, 0.8947640675268903], 
     RGBColor[0.6980534462846867, 0.7268073680647258, 0.857905901385862], 
     RGBColor[0.69390218096613, 0.739092576695303, 0.8649362681138388], 
     RGBColor[0.7448393785051265, 0.6676648788742782, 0.8032765611384599], 
     RGBColor[0.7390865039218255, 0.6749371358692609, 0.8099938739736733], 
     RGBColor[0.8310745243488871, 0.5063016550697887, 0.6363819531835689], 
     RGBColor[0.8310613958679917, 0.5046121122360185, 0.6347273795207264], 
     RGBColor[0.8302536972863738, 0.4006670053125783, 0.5329336677193591], 
     RGBColor[0.8299300487747426, 0.3923646649929896, 0.5248223611331075], 
     RGBColor[0.7708222435714999, 0.31060582995932423`, 0.44908735839194397`],
      
     RGBColor[0.7613183326833077, 0.2974598726731327, 0.4369099697256918], 
     RGBColor[0.6958692098479369, 0.2530233119589253, 0.3935856088548976], 
     RGBColor[0.6732886213162572, 0.24612267472241545`, 0.38605216771049283`],
      
     RGBColor[0.6155746045883349, 0.22848524723275962`, 0.36679734857161156`],
      
     RGBColor[0.5879375685265474, 0.22003935753032014`, 0.35757695184523014`],
      
     RGBColor[0.6739660440295717, 0.8281598789879371, 0.9080268103339789], 
     RGBColor[0.6891401317584528, 0.7603676550950106, 0.8752290988207503], 
     RGBColor[0.7453452729812209, 0.275365688179641, 0.41644364186657595`], 
     RGBColor[0.635337814225579, 0.23452489230863455`, 0.37339084264364736`], 
     
     RGBColor[0.6864399768284851, 0.7724309508152243, 0.8810652916790231], 
     RGBColor[0.6881466436611683, 0.7648061932614851, 0.8773764526906338], 
     RGBColor[0.7991252772407437, 0.34975502612316733`, 0.48535211776091175`],
      
     RGBColor[0.803464753362527, 0.35575745695533, 0.49091230113852835`], 
     RGBColor[0.7528318061649324, 0.2857211772632985, 0.4260361586118788], 
     RGBColor[0.758045711246223, 0.29293313182592606`, 0.4327167503588728], 
     RGBColor[0.6978788234911771, 0.2536374507232044, 0.39425606552094516`], 
     RGBColor[0.708885218712687, 0.2570010096755647, 0.397928070371349], 
     RGBColor[0.6657261930508442, 0.8534224708293908, 0.8945697626529093], 
     RGBColor[0.6635024942090059, 0.8599588268234706, 0.8901766132354518], 
     RGBColor[0.6789890219554753, 0.8057190673723584, 0.8971700007586959], 
     RGBColor[0.6701178978953025, 0.8405134627639949, 0.9032460344645754], 
     RGBColor[0.668092506880695, 0.8464669113378767, 0.8992446628810966], 
     RGBColor[0.6930383195004518, 0.7429519909111746, 0.8668034432379671], 
     RGBColor[0.6761559926041922, 0.8183759969689803, 0.9032933922292118], 
     RGBColor[0.7373325390601951, 0.677154337556739, 0.8120418815404891], 
     RGBColor[0.7488411122490238, 0.6626062536965993, 0.7986039584158114], 
     RGBColor[0.6908396874433722, 0.7527746675250722, 0.8715556300725394], 
     RGBColor[0.7328684860551865, 0.6827973843886448, 0.8172543088432952], 
     RGBColor[0.6664041397816757, 0.24401877430525196`, 0.38375533490749714`],
      
     RGBColor[0.6488823004594164, 0.2386640929288259, 0.3779096172420446], 
     RGBColor[0.5793736230385009, 0.2177356824604995, 0.35508498375662384`], 
     RGBColor[0.5555300026363043, 0.2159032294172174, 0.3534839641543254], 
     RGBColor[0.5092422404849959, 0.2123458774215838, 0.35037589527465385`], 
     RGBColor[0.4822318311961481, 0.21027004724702333`, 0.34856223635842803`],
      
     RGBColor[0.7510459919864912, 0.2832510113298163, 0.4237479897104216], 
     RGBColor[0.6488823004594164, 0.23866409292882587`, 0.3779096172420446], 
     RGBColor[0.6946257965208524, 0.7358597294510644, 0.863372224552584], 
     RGBColor[0.7279319175985988, 0.6890377419646363, 0.8230184662528104], 
     RGBColor[0.7239598911321244, 0.694058813923848, 0.827656381433945], 
     RGBColor[0.7588096481325247, 0.2939898212030482, 0.43369558491344967`], 
     RGBColor[0.803464753362527, 0.35575745695533, 0.49091230113852835`], 
     RGBColor[0.6904817755217154, 0.2513769097905931, 0.39178822791599976`], 
     RGBColor[0.5854643186598883, 0.219283531343544, 0.3567518147023367], 
     RGBColor[0.4953773373880819, 0.211280318439928, 0.3494449132648882], 
     RGBColor[0.4354524817640601, 0.2066749153088513, 0.34542115903207377`], 
     RGBColor[0.6712196162579256, 0.8372750640708672, 0.9054225942090409], 
     RGBColor[0.6684643672347357, 0.8453738624014094, 0.8999793118663788], 
     RGBColor[0.6783167123267586, 0.8087226986739348, 0.8986231502095355], 
     RGBColor[0.6743234066202647, 0.8265633148193312, 0.9072543965082134], 
     RGBColor[0.6899185680636399, 0.7568898889695923, 0.8735465641059709], 
     RGBColor[0.6866558740164941, 0.771466401857233, 0.8805986452607769], 
     RGBColor[0.7134486054404487, 0.7073462182972088, 0.8399298272163789], 
     RGBColor[0.7659455729338867, 0.6409843615347287, 0.7786320275777323], 
     RGBColor[0.8180523599022643, 0.5549867329093504, 0.6861655375315431], 
     RGBColor[0.7948261769603153, 0.3438084437824405, 0.4798436680662695], 
     RGBColor[0.7234391635490226, 0.2614487012640646, 0.4027836252515783], 
     RGBColor[0.627931291395201, 0.23226145585459076`, 0.3709198439914616], 
     RGBColor[0.5507985563193429, 0.21553960371539893`, 0.3531662633113788], 
     RGBColor[
     0.49630004130287747`, 0.21135123097620373`, 0.34950686975596573`], 
     RGBColor[0.6824544199223445, 0.7902369481803792, 0.8896797894967972], 
     RGBColor[0.7352673924586284, 0.679764906690734, 0.814453238779802], 
     RGBColor[0.7847714311515313, 0.3299005630709314, 0.4669604930139807], 
     RGBColor[0.6824544199223445, 0.7902369481803792, 0.8896797894967972], 
     RGBColor[0.6428014465615243, 0.23680578145130615`, 0.37588089443514233`],
      
     RGBColor[0.6658157827601078, 0.24383897215502467`, 0.38355904449692346`],
      
     RGBColor[0.6277651437071341, 0.23221068105209056`, 0.3708644130257197], 
     RGBColor[0.6684643672347357, 0.8453738624014094, 0.8999793118663788], 
     RGBColor[0.6743234066202647, 0.8265633148193312, 0.9072543965082134], 
     RGBColor[0.6866558740164942, 0.7714664018572329, 0.8805986452607768], 
     RGBColor[0.7411973935203048, 0.26962827682730806`, 0.4111289518478496], 
     RGBColor[0.7234391635490227, 0.26144870126406466`, 0.4027836252515783], 
     RGBColor[0.6531989816245796, 0.23998327248628845`, 0.3793497685229243], 
     RGBColor[0.6279312913952011, 0.2322614558545908, 0.3709198439914616], 
     RGBColor[0.5834692271106058, 0.21867383053721157`, 0.35608620296493076`],
      
     RGBColor[0.550798556319343, 0.21553960371539893`, 0.3531662633113788], 
     RGBColor[
     0.49630004130287764`, 0.21135123097620376`, 0.34950686975596573`], 
     RGBColor[0.6638336675512814, 0.8589853735751554, 0.8908308807775857], 
     RGBColor[0.7821894462575979, 0.326329121426691, 0.46365218825884225`], 
     RGBColor[0.6904817755217154, 0.2513769097905931, 0.39178822791599976`], 
     RGBColor[0.5854643186598882, 0.21928353134354395`, 0.35675181470233663`],
      
     RGBColor[0.49537733738808176`, 0.211280318439928, 0.3494449132648882], 
     RGBColor[0.43545248176405993`, 0.2066749153088513, 0.34542115903207377`],
      
     RGBColor[0.788993231057921, 0.602989592476898, 0.7378007324392297], 
     RGBColor[0.7751459973505374, 0.6258638781657458, 0.7624058957682133], 
     RGBColor[0.7711755509743986, 0.6324226700977128, 0.7694609858777832], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.8199129744244869, 0.5519131783613801, 0.682859409738874], 
     RGBColor[0.8191087975943702, 0.5532416004090728, 0.6842883523470902], 
     RGBColor[0.8305746754238634, 0.4419746262255913, 0.5733863276172072], 
     RGBColor[0.8307140745438821, 0.45991430912852527`, 0.5909547054396881], 
     RGBColor[0.8306738357012484, 0.4547358540770726, 0.5858834310268178], 
     RGBColor[0.804960048168028, 0.3578257719758132, 0.4928282267223675], 
     RGBColor[0.6833663058557953, 0.786162978366191, 0.8877088129008621], 
     RGBColor[0.685167851056783, 0.7781143392782452, 0.8838149010667044], 
     RGBColor[0.6896850425304492, 0.757933194868019, 0.8740513129386791], 
     RGBColor[0.6902089393469952, 0.755592617238664, 0.8729189472268956], 
     RGBColor[0.6917992654857216, 0.7484876269693571, 0.8694815703748678], 
     RGBColor[0.7087677248770583, 0.7132633586636276, 0.8453954320428484], 
     RGBColor[0.706955298872025, 0.7155544615726412, 0.8475117014469866], 
     RGBColor[0.7109446205383366, 0.7105115266063059, 0.8428535916194762], 
     RGBColor[0.7475183261503189, 0.664278398694701, 0.8001485024364415], 
     RGBColor[0.7423758798554039, 0.670779008172278, 0.8061530519883295], 
     RGBColor[0.7452718356546577, 0.6671182061656749, 0.802771604891081], 
     RGBColor[0.7795840983876101, 0.32272536375077643`, 0.46031394845452633`],
      
     RGBColor[0.5151569414181985, 0.21280043975491772`, 0.35077304771946116`],
      
     RGBColor[0.6676243332827103, 0.8478430641000585, 0.8983197370185844], 
     RGBColor[0.665486345133756, 0.8541274814814768, 0.8940959180308725], 
     RGBColor[0.6712882054537246, 0.8370734525069922, 0.9055580993322613], 
     RGBColor[0.6831293778996801, 0.787221485034561, 0.8882209158287564], 
     RGBColor[0.7866994432290644, 0.3325674193490139, 0.46943086049717314`], 
     RGBColor[0.7022441311251816, 0.25497149054974705`, 0.39571243979090076`],
      
     RGBColor[0.6006206057510125, 0.2239152989753536, 0.3618083258118011], 
     RGBColor[0.5151569414181983, 0.2128004397549177, 0.35077304771946116`], 
     RGBColor[0.45716872433478917`, 0.20834387304748897`, 0.3468793323068337],
      
     RGBColor[0.685167851056783, 0.7781143392782452, 0.8838149010667044], 
     RGBColor[0.6917992654857216, 0.7484876269693571, 0.8694815703748678], 
     RGBColor[0.7109446205383366, 0.7105115266063059, 0.8428535916194762], 
     RGBColor[0.7452718356546577, 0.6671182061656749, 0.802771604891081], 
     RGBColor[0.7552005841045273, 0.288997707733831, 0.42907128067624173`], 
     RGBColor[0.7750562185854477, 0.31646233001903257`, 0.45451236289320673`],
      
     RGBColor[0.7795840983876101, 0.32272536375077654`, 0.46031394845452644`],
      
     RGBColor[0.694253016634468, 0.2525294026414329, 0.39304640694549764`], 
     RGBColor[0.728447192147538, 0.26297915688438367`, 0.404454427084023], 
     RGBColor[0.7385100000541986, 0.26605435516130754`, 0.4078116279384615], 
     RGBColor[0.6717944310866085, 0.24566604956746535`, 0.3855536690049427], 
     RGBColor[0.6836060018169978, 0.24927567048985372`, 0.3894943002597713], 
     RGBColor[0.6472972188607921, 0.2381796913337555, 0.37738079493453197`], 
     RGBColor[0.7739139673104701, 0.6278990721770026, 0.7645950911701732], 
     RGBColor[0.7707849381069406, 0.6330679246310574, 0.7701550662699614], 
     RGBColor[0.8118349197868235, 0.5652573403432425, 0.6972133130483975], 
     RGBColor[0.8107741800795857, 0.5670095793548457, 0.6990981424878119], 
     RGBColor[0.8309572580175234, 0.49121030585917647`, 0.621602955905993], 
     RGBColor[0.8309394913561697, 0.48892386193552284`, 0.6193638354634521], 
     RGBColor[0.6693511010166062, 0.8427673908949125, 0.901731147107721], 
     RGBColor[0.6756085895715991, 0.8208215916965366, 0.9044765649553249], 
     RGBColor[0.6810944795045379, 0.7963126600737216, 0.8926192039970512], 
     RGBColor[0.6921881174298603, 0.7467503799908732, 0.8686410945510102], 
     RGBColor[0.7257786095250738, 0.6917597567545118, 0.8255327647571518], 
     RGBColor[0.7725215307824101, 0.6301992421329302, 0.7670693130199777], 
     RGBColor[0.8193814132332345, 0.5527912658412879, 0.6838039413476054], 
     RGBColor[0.8306874766535626, 0.4564913483655333, 0.5876025911196554], 
     RGBColor[0.5820897481219028, 0.2182522611851519, 0.3556259747580018], 
     RGBColor[0.6676892627904245, 0.8476522098490443, 0.8984480120455904], 
     RGBColor[0.6708622434259042, 0.24538117263107162`, 0.3852426682147018], 
     RGBColor[0.6105089674924594, 0.22693718643171354`, 0.36510732712389105`],
      
     RGBColor[0.589816336933968, 0.22061350993617243`, 0.3582037553141217], 
     RGBColor[0.6800982268064356, 0.800763549456359, 0.8947725333549964], 
     RGBColor[0.6697604770663249, 0.8415640680590739, 0.9025399122698489], 
     RGBColor[0.6279041840240794, 0.23225317183071412`, 0.3709108003040201], 
     RGBColor[0.6734784486247615, 0.8303382753068898, 0.9090807131258881], 
     RGBColor[0.6712513241401163, 0.837181861699252, 0.9054852364434813], 
     RGBColor[0.6675221858919954, 0.8481433168577688, 0.898117934174795], 
     RGBColor[0.6649120420437686, 0.8558155920178633, 0.8929613222673849], 
     RGBColor[0.6693511010166062, 0.8427673908949125, 0.901731147107721], 
     RGBColor[0.666841563074876, 0.8501439443468348, 0.8967732926809564], 
     RGBColor[0.677335624648689, 0.8131058363437993, 0.9007437014551479], 
     RGBColor[0.6717537254157953, 0.8357050998608541, 0.9064777826597458], 
     RGBColor[0.6693763522762467, 0.8426931671649703, 0.9017810336096576], 
     RGBColor[0.7672051045982599, 0.6389814620296796, 0.776516075987353], 
     RGBColor[0.461352623822162, 0.2086654181492436, 0.3471602672059949], 
     RGBColor[0.4180026205277689, 0.20533384164688565`, 0.3442494590374658], 
     RGBColor[0.6665999034720818, 0.8508542802806095, 0.8962958688845035], 
     RGBColor[0.6709136914637699, 0.8381743015595031, 0.9048182078119513], 
     RGBColor[0.7987834395803955, 0.5868171185063702, 0.7204045011911181], 
     RGBColor[0.8311007877553034, 0.509681570115138, 0.6396919127210852], 
     RGBColor[0.8303221081157518, 0.4094709962273246, 0.5415554387714359], 
     RGBColor[0.8302696990262781, 0.40272631630205397`, 0.5349503562925545], 
     RGBColor[0.6405255707190312, 0.23611027284831526`, 0.3751216061337174], 
     RGBColor[0.5441582118060821, 0.21502927351778156`, 0.3527203863198643], 
     RGBColor[0.5879375685265473, 0.22003935753032008`, 0.3575769518452301], 
     RGBColor[0.519854862857028, 0.21316148897028311`, 0.3510884974786316], 
     RGBColor[0.680078136718271, 0.800853304555922, 0.8948159566518477], 
     RGBColor[0.685576115362807, 0.7762903650310956, 0.8829324668031514], 
     RGBColor[0.7400336209965376, 0.2680185285806894, 0.4096378067279363], 
     RGBColor[0.644211023244281, 0.23723654867117294`, 0.3763511639749807], 
     RGBColor[0.6665999034720818, 0.8508542802806094, 0.8962958688845035], 
     RGBColor[0.7707849381069406, 0.6330679246310574, 0.7701550662699614], 
     RGBColor[0.7775713691582247, 0.6218573994131603, 0.7580962501940335], 
     RGBColor[0.8107741800795857, 0.5670095793548457, 0.6990981424878119], 
     RGBColor[0.7987834395803955, 0.5868171185063702, 0.7204045011911181], 
     RGBColor[0.8204042108315271, 0.551101703509951, 0.6819865312792635], 
     RGBColor[0.8309394913561697, 0.48892386193552284`, 0.6193638354634521], 
     RGBColor[0.8311007877553034, 0.509681570115138, 0.6396919127210852], 
     RGBColor[0.8307386546906093, 0.4630776005318923, 0.5940525248848617], 
     RGBColor[0.8302696990262781, 0.402726316302054, 0.5349503562925545], 
     RGBColor[0.8303833670840172, 0.417354593092887, 0.5492758655528744], 
     RGBColor[0.6671265326461191, 0.8493063027876092, 0.8973362798455605], 
     RGBColor[0.661783561750059, 0.8650114689663994, 0.8867806825506889], 
     RGBColor[0.6748048296241063, 0.8244124945099485, 0.9062138349220447], 
     RGBColor[0.6897910889736772, 0.7574594184966933, 0.8738221010931868], 
     RGBColor[0.5370987419471291, 0.21448673229254864`, 0.3522463664589804], 
     RGBColor[0.4613526238221619, 0.2086654181492436, 0.3471602672059949], 
     RGBColor[0.7557206585730966, 0.28971708282371583`, 0.42973765360562505`],
      
     RGBColor[0.7118894215996743, 0.25791909532594054`, 0.3989303465344887], 
     RGBColor[0.6599889621228872, 0.24205829334750567`, 0.38161507344993684`],
      
     RGBColor[0.6130489658888082, 0.2277134109968939, 0.36595473322222766`], 
     RGBColor[0.5313764838952768, 0.2140469597662004, 0.3518621359119456], 
     RGBColor[0.4749763365742544, 0.20971244093656635`, 0.34807505408836675`],
      
     RGBColor[0.6829003477179018, 0.7882447073619108, 0.8887159482790756], 
     RGBColor[0.7471537181548895, 0.2778671576575382, 0.41876080792804776`], 
     RGBColor[0.6841285632060521, 0.7827574938404696, 0.88606124784659], 
     RGBColor[0.6829234723430544, 0.7881413950709973, 0.8886659660463273], 
     RGBColor[0.6845813690616177, 0.7807345243882693, 0.8850825401912971], 
     RGBColor[0.6871620898994972, 0.7692048161137037, 0.8795044956294584], 
     RGBColor[0.688477029839712, 0.7633301497465701, 0.8766623464612878], 
     RGBColor[0.6908818271479148, 0.752586402877063, 0.8714645480979565], 
     RGBColor[0.6926199897515891, 0.7448209338422209, 0.8677076332404069], 
     RGBColor[0.6930423650400847, 0.7429339169331236, 0.8667946990917513], 
     RGBColor[0.6952409970971642, 0.7331112403192261, 0.862042512257179], 
     RGBColor[0.7026108163452964, 0.7210463583604299, 0.8525845129287222], 
     RGBColor[0.7086432330748514, 0.7134207297945827, 0.8455407942211358], 
     RGBColor[0.7227485998886748, 0.6955900173406072, 0.8290707390909716], 
     RGBColor[0.7201870386584172, 0.6988281083688542, 0.8320617321816502], 
     RGBColor[0.725425733541067, 0.6922058302445379, 0.8259447984878172], 
     RGBColor[0.7725215307824101, 0.6301992421329302, 0.7670693130199777], 
     RGBColor[0.6635024942090059, 0.8599588268234706, 0.8901766132354518], 
     RGBColor[0.8302987857605295, 0.40646957371345804`, 0.5386161379480147], 
     RGBColor[0.5555300026363041, 0.2159032294172174, 0.3534839641543254], 
     RGBColor[
     0.48223183119614793`, 0.21027004724702333`, 0.34856223635842803`], 
     RGBColor[0.7997628068740366, 0.35063686702282915`, 0.4861689863345119], 
     RGBColor[0.7734731029338628, 0.3142725398390034, 0.452483912203825], 
     RGBColor[0.7774332204578495, 0.31975023596127095`, 0.4575580223065971], 
     RGBColor[0.767558323563387, 0.306091125063942, 0.44490528819137753`], 
     RGBColor[0.7491060831865951, 0.2805676993204175, 0.4212623789222599], 
     RGBColor[0.7363142046843641, 0.26538331918403096`, 0.4070790564574039], 
     RGBColor[0.7145653213143184, 0.2587368513904529, 0.39982309266377225`], 
     RGBColor[0.7115764014051066, 0.2578234362244347, 0.39882591527887834`], 
     RGBColor[0.6881143775930301, 0.2506534320000385, 0.3909984055897962], 
     RGBColor[0.6707753370895073, 0.24535461401856307`, 0.38521367411787377`],
      
     RGBColor[0.6445213203261209, 0.2373313755882978, 0.37645468673303645`], 
     RGBColor[0.647457260727414, 0.23822860019468545`, 0.3774341888476776], 
     RGBColor[0.6347990910930102, 0.23436025829550608`, 0.37321111132235596`],
      
     RGBColor[0.6060832408720487, 0.22558468253782377`, 0.36363079559021055`],
      
     RGBColor[0.6829003477179018, 0.7882447073619108, 0.8887159482790756], 
     RGBColor[0.6881466436611683, 0.7648061932614851, 0.8773764526906338], 
     RGBColor[0.6589313012255262, 0.24173507173786118`, 0.38126221169392777`],
      
     RGBColor[0.6767920612334302, 0.24719332741662672`, 0.3872210016574891], 
     RGBColor[0.655797503645515, 0.2407773818954565, 0.3802166995455455], 
     RGBColor[0.6978788234911771, 0.2536374507232045, 0.39425606552094516`], 
     RGBColor[0.7088852187126871, 0.2570010096755648, 0.39792807037134903`], 
     RGBColor[0.6629902501869376, 0.24297548822678094`, 0.3826163771562688], 
     RGBColor[0.6756085895715991, 0.8208215916965365, 0.9044765649553248], 
     RGBColor[0.6724845332029546, 0.8335569583183731, 0.907921569805751], 
     RGBColor[0.687953529290763, 0.7656689569985454, 0.8777938556688407], 
     RGBColor[0.6812771467401557, 0.7954965702793193, 0.892224381757734], 
     RGBColor[0.677951780016043, 0.8103530815579558, 0.8994119254468059], 
     RGBColor[0.6877059210384371, 0.7667751792887637, 0.87832904329746], 
     RGBColor[0.6847341916467722, 0.7800517694778069, 0.8847522250415396], 
     RGBColor[0.711968830454434, 0.7092168142640117, 0.8416576784606312], 
     RGBColor[0.6948140668995807, 0.7350186068811151, 0.8629652915179039], 
     RGBColor[0.6922333460617013, 0.7465483151556807, 0.8685433360797425], 
     RGBColor[0.7157889008870166, 0.7043878312012983, 0.8371971939190959], 
     RGBColor[0.7091656501007078, 0.7127603380520597, 0.8449307968116138], 
     RGBColor[0.7356981391219992, 0.6792203962220271, 0.8139502797723197], 
     RGBColor[0.6801021435802729, 0.8007460507563605, 0.8947640675268903], 
     RGBColor[0.69390218096613, 0.7390925766953033, 0.864936268113839], 
     RGBColor[0.7390865039218255, 0.6749371358692609, 0.8099938739736733], 
     RGBColor[0.8310613958679917, 0.5046121122360185, 0.6347273795207264], 
     RGBColor[0.8299300487747426, 0.3923646649929895, 0.5248223611331074], 
     RGBColor[0.7613183326833077, 0.2974598726731326, 0.43690996972569174`], 
     RGBColor[0.6732886213162571, 0.24612267472241542`, 0.38605216771049283`],
      
     RGBColor[0.7527425141730691, 0.6576744588136144, 0.7940485075989646], 
     RGBColor[0.7468402453770752, 0.6651355662854388, 0.8009402597771357], 
     RGBColor[0.7973159079421152, 0.5892413382935722, 0.7230121596168646], 
     RGBColor[0.7949134904419979, 0.5932098987586322, 0.7272810176591227], 
     RGBColor[0.8310925598829715, 0.5086227010162528, 0.6386549594764589], 
     RGBColor[0.8310790904735474, 0.5068892830870311, 0.6369574188192687], 
     RGBColor[0.8303427437725016, 0.4121266596098201, 0.5441561367840734], 
     RGBColor[0.8302762415234517, 0.4035682895130182, 0.5357749028336869], 
     RGBColor[0.6946257965208524, 0.7358597294510644, 0.863372224552584], 
     RGBColor[0.6960797826916988, 0.7293638558412378, 0.8602295368452447], 
     RGBColor[0.7239598911321244, 0.694058813923848, 0.827656381433945], 
     RGBColor[0.7274243134251267, 0.6896794086562639, 0.8236111675155094], 
     RGBColor[0.8029101910481286, 0.3549903777409541, 0.49020173883196505`], 
     RGBColor[0.6810944795045379, 0.7963126600737216, 0.8926192039970512], 
     RGBColor[0.6769452947548483, 0.8148496862561064, 0.9015873717621813], 
     RGBColor[0.6862927268171243, 0.7730888095225658, 0.8813835621068222], 
     RGBColor[0.6824992550886354, 0.7900366412040534, 0.8895828814733342], 
     RGBColor[0.6921881174298603, 0.7467503799908732, 0.8686410945510102], 
     RGBColor[0.6887980638305815, 0.761895888354708, 0.8759684543205144], 
     RGBColor[0.7041046318252676, 0.7191580136874959, 0.8508402673777801], 
     RGBColor[0.6957625098061024, 0.7307813140027958, 0.8609152996244431], 
     RGBColor[0.7257786095250738, 0.6917597567545118, 0.8255327647571518], 
     RGBColor[0.7182230174075585, 0.7013108440991466, 0.834355010953157], 
     RGBColor[0.7428636736950226, 0.6701623838897717, 0.805583482154612], 
     RGBColor[0.6960797826916988, 0.7293638558412376, 0.8602295368452447], 
     RGBColor[0.7274243134251267, 0.6896794086562638, 0.8236111675155093], 
     RGBColor[0.7701252312324501, 0.3096417116563548, 0.4481942744544327], 
     RGBColor[0.7769720237833333, 0.3191123015514211, 0.4569670896659991], 
     RGBColor[0.7471537181548895, 0.27786715765753817`, 0.4187608079280477], 
     RGBColor[0.7550378776360098, 0.2887726496171798, 0.4288628044048457], 
     RGBColor[0.8058462762250425, 0.35905161640137606`, 0.4939637533097022], 
     RGBColor[0.7991252772407437, 0.34975502612316733`, 0.48535211776091175`],
      
     RGBColor[0.7174885137613114, 0.2596301802167102, 0.4007983417465096], 
     RGBColor[0.7327048978586517, 0.2642803135185871, 0.40587490269916787`], 
     RGBColor[0.6858925522095412, 0.2499744412397748, 0.3902571498543146], 
     RGBColor[0.702535773343353, 0.2550606165327846, 0.3958097388264301], 
     RGBColor[0.7528318061649324, 0.2857211772632986, 0.4260361586118789], 
     RGBColor[0.758045711246223, 0.29293313182592606`, 0.4327167503588728], 
     RGBColor[0.7551469886027531, 0.6546349425270466, 0.7912409360598003], 
     RGBColor[0.7445705787655968, 0.6680046708787343, 0.8035904236978291], 
     RGBColor[0.7563479516939551, 0.6531167950141384, 0.7898386380137823], 
     RGBColor[0.7775713691582247, 0.6218573994131603, 0.7580962501940335], 
     RGBColor[0.8204042108315271, 0.551101703509951, 0.6819865312792635], 
     RGBColor[0.8307386546906093, 0.4630776005318923, 0.5940525248848617], 
     RGBColor[0.8173862906281484, 0.3750139437221999, 0.5087500073322817], 
     RGBColor[0.6864422231235695, 0.7724209151977945, 0.8810604364719445], 
     RGBColor[0.6955585292907631, 0.731692623665212, 0.861356189002174], 
     RGBColor[0.7630199542567025, 0.2998135820864755, 0.43909026239740157`], 
     RGBColor[0.6906034855335935, 0.2514141044207881, 0.3918288333771852], 
     RGBColor[0.7868785843861912, 0.3328152101824394, 0.4696603945828899], 
     RGBColor[0.745665255187682, 0.6666208812354036, 0.8023122307050907], 
     RGBColor[0.7926314104663668, 0.5969796733165319, 0.7313360478345914], 
     RGBColor[0.7825224348069236, 0.6136787196489709, 0.749298696725011], 
     RGBColor[0.831283, 0.533131, 0.662656], 
     RGBColor[0.821407002936465, 0.5494451883113495, 0.6802046689919351], 
     RGBColor[0.8306356124294765, 0.44981678877012704`, 0.5810661776609992], 
     RGBColor[0.8307888317066505, 0.4695350283598213, 0.6003763006425651], 
     RGBColor[0.8158166735134045, 0.37284282492817433`, 0.5067388523574192], 
     RGBColor[0.8270055669143767, 0.3883194762203993, 0.5210752140186152], 
     RGBColor[0.7392221032436349, 0.6747657236296467, 0.8098355421603081], 
     RGBColor[0.7295367809890215, 0.6870090206970336, 0.8211445562109431], 
     RGBColor[0.6041000855829255, 0.22497862945755506`, 0.36296916608352764`],
      
     RGBColor[0.6187641881204333, 0.22945998528529876`, 0.36786147228922483`],
      
     RGBColor[0.7593843180903249, 0.29478471362236647`, 0.4344319112019934], 
     RGBColor[0.7838784463511408, 0.3286653726128921, 0.465816308991704], 
     RGBColor[0.7925348054562529, 0.3406389830968794, 0.47690772709291607`], 
     RGBColor[0.7568164854910456, 0.29123284765209984`, 0.4311417398231617], 
     RGBColor[0.7701089206109811, 0.3096191505511776, 0.44817337560769976`]},
   VertexNormals->CompressedData["
1:eJxsu3c81937By5bJSojJESbrFApJ1FCKjRJkkqIiOytMkoREg1JhGRHRk7Z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    "]],
  Boxed->False,
  Lighting->"Neutral",
  Method->{},
  PlotRange->{{-1.1019887379579505`, 1.1019887379579505`}, {-1.2, 
   0.8643229231670809}, {-1.2, 1.2}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1211248081]
}, Open  ]],

Cell["Export it to a DXF file:", "ExampleText",
 CellID->716591026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.dxf\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172831545],

Cell[BoxData["\<\"test.dxf\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1381886071]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DXF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 7.0106808}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME types: image/vnd.dxf, image/x-dxf AutoCAD DXF format. 3D geometry \
format. Commonly used for the exchange of CAD data. Plain text ASCII or \
binary format. DXF is an acronym derived from Drawing Exchange Format. Stores \
a 3D object as a collection of line and polygon primitives and their \
properties. Introduced in 1982.", "synonyms" -> {}, "title" -> "DXF", "type" -> 
    "Format", "uri" -> "ref/format/DXF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24367, 821, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 439253, 8757}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3886, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4509, 109, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[4613, 115, 456, 10, 70, "FormatUsage",
 CellID->20778],
Cell[5072, 127, 329, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[5438, 144, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[5505, 147, 406, 14, 70, "FormatNotes",
 CellID->2520],
Cell[5914, 163, 452, 16, 70, "FormatNotes",
 CellID->12927],
Cell[6369, 181, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[6411, 184, 741, 25, 70, "FormatNotes",
 CellID->25134],
Cell[7155, 211, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[7197, 214, 351, 13, 70, "FormatNotes",
 CellID->22675],
Cell[7551, 229, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[8128, 251, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[8713, 274, 690, 25, 70, "FormatNotes",
 CellID->21001],
Cell[9406, 301, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[9447, 304, 513, 18, 70, "FormatNotes",
 CellID->9310],
Cell[9963, 324, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[11041, 366, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[11705, 390, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[12524, 420, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[12565, 423, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[12929, 439, 352, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[13318, 458, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[13372, 461, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[13567, 471, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[14237, 486, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[14279, 489, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[14350, 492, 545, 16, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[14898, 510, 2790, 71, 70, "2ColumnTableMod",
 CellID->9135],
Cell[17691, 583, 424, 17, 70, "FormatNotes",
 CellID->13037],
Cell[18118, 602, 69, 1, 70, "FormatNotes",
 CellID->249669238],
Cell[18190, 605, 526, 12, 70, "2ColumnTableMod",
 CellID->7836828],
Cell[18719, 619, 445, 18, 70, "FormatNotes",
 CellID->1495251562]
}, Open  ]],
Cell[CellGroupData[{
Cell[19201, 642, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[19253, 645, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[19452, 655, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593]
}, Closed]],
Cell[CellGroupData[{
Cell[20644, 691, 53, 1, 70, "TutorialsSection",
 CellID->30231],
Cell[20700, 694, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[20868, 699, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[21075, 707, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[21128, 710, 2250, 76, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[23415, 791, 58, 1, 70, "MoreAboutSection",
 CellID->745425722],
Cell[23476, 794, 150, 2, 70, "MoreAbout"],
Cell[23629, 798, 135, 2, 70, "MoreAbout"],
Cell[23767, 802, 151, 2, 70, "MoreAbout"],
Cell[23921, 806, 134, 2, 70, "MoreAbout"],
Cell[24058, 810, 133, 2, 70, "MoreAbout"],
Cell[24194, 814, 136, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24367, 821, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24483, 827, 60, 1, 70, "ExampleSection",
 CellID->531171571],
Cell[24546, 830, 246, 8, 70, "ExampleText",
 CellID->1964482740],
Cell[CellGroupData[{
Cell[24817, 842, 219, 5, 70, "Input",
 CellID->102859358],
Cell[25039, 849, 155091, 3798, 70, "Output",
 CellID->1884880985]
}, Open  ]],
Cell[180145, 4650, 126, 3, 70, "ExampleDelimiter",
 CellID->1647822202],
Cell[180274, 4655, 99, 1, 70, "ExampleText",
 CellID->998637302],
Cell[CellGroupData[{
Cell[180398, 4660, 131, 3, 70, "Input",
 CellID->563049405],
Cell[180532, 4665, 12635, 222, 70, "Output",
 CellID->1251432413]
}, Open  ]],
Cell[193182, 4890, 126, 3, 70, "ExampleDelimiter",
 CellID->1512433409],
Cell[193311, 4895, 228, 8, 70, "ExampleText",
 CellID->1851859171],
Cell[CellGroupData[{
Cell[193564, 4907, 676, 19, 70, "Input",
 CellID->1753412545],
Cell[194243, 4928, 243394, 3779, 70, "Output",
 CellID->1211248081]
}, Open  ]],
Cell[437652, 8710, 67, 1, 70, "ExampleText",
 CellID->716591026],
Cell[CellGroupData[{
Cell[437744, 8715, 140, 4, 70, "Input",
 CellID->172831545],
Cell[437887, 8721, 87, 2, 70, "Output",
 CellID->1381886071]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[438013, 8728, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

