(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30474,        913]
NotebookOptionsPosition[     25278,        758]
NotebookOutlinePosition[     27210,        804]
CellTagsIndexPosition[     27125,        799]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Graphics Importing & Exporting" :> 
         Documentation`HelpLookup[
          "paclet:guide/GraphicsImportingAndExporting"], 
         "Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "New in 6.0: Import & Export Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60ImportAndExportFormats"], 
         "Scientific & Medical Data Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/ScientificAndMedicalDataFormats"], 
         "Signal Processing" :> 
         Documentation`HelpLookup["paclet:guide/SignalProcessing"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Graphics Importing & Exporting\"\>", 
      2->"\<\"Importing & Exporting\"\>", 3->"\<\"Listing of All Formats\"\>",
       4->"\<\"New in 6.0: Import & Export Formats\"\>", 
      5->"\<\"Scientific & Medical Data Formats\"\>", 
      6->"\<\"Signal Processing\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "EDF ",
 StyleBox["(.edf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
EDF and EDF+ physiological signal recordings format.
Commonly used for the exchange and storage of medical time-series recordings.
Application areas include electroencephalography, polysomnography, \
electromyography, evoked potentials, electroneurography, electrocardiography.
EDF is an acronym for European Data Format.
Binary format.
Stores multiple simultaneous signal channels, time-stamped annotations, and \
meta-information.
Encodes signal samples as 16-bit integers.
EDF+ can store discontinuous time series.
First published in 1992, superseded by EDF+ in 2003.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the ",
 "EDF",
 " and EDF+ formats."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", "]"}]], "InlineFormula"],
 " imports an EDF file, returning the signals data as an array of integers."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", "]"}]], "InlineFormula"],
 "returns an array of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["ch", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["ch", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "where the signal channels ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["ch", "TI"], 
    StyleBox["i", "TI"]], " "}]], "InlineFormula"],
 "are lists of discontinuous records ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["rec", "TI"], 
     StyleBox["i1", "TI"]], ",", 
    SubscriptBox[
     StyleBox["rec", "TI"], 
     StyleBox["i2", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". Each record is given as a list of data samples."
}], "FormatNotes",
 CellID->28396],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "EDF",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<EDF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<EDF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the EDF format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell["\<\
all signal channels represented as a list of lists, with discontinuous \
records combined into a flat list\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Labels\>\"", Cell[
    "names of all signal channels", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LabeledData\>\"", Cell[
    "list of rules, each representing a labeled data channel", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RecordsData\>\"", Cell[
    "all signal channels, given as an array of lists", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", "\"\<Data\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "gives a packed array of data samples, effectively combining discontinuous \
records for each signal channel into a flat list."
}], "FormatNotes",
 CellID->791073419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", "\"\<LabeledData\>\""}], "]"}]], 
  "InlineFormula"],
 "imports the entire file and returns an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["label", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["ch", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["label", "TI"], 
      StyleBox["2", "TR"]], "->", 
     SubscriptBox[
      StyleBox["ch", "TI"], 
      StyleBox["2", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->729329788],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", " ", "\"\<RecordsData\>\""}], 
   "]"}]], "InlineFormula"],
 "returns a packed array of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["ch", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["ch", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "where the signals ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["ch", "TI"], 
    StyleBox["i", "TI"]], " "}]], "InlineFormula"],
 "are lists of discontinuous records ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["rec", "TI"], 
     StyleBox["i1", "TI"]], ",", 
    SubscriptBox[
     StyleBox["rec", "TI"], 
     StyleBox["i2", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". Each record is given as a list of data samples."
}], "FormatNotes",
 CellID->248180899],

Cell["", "WeakDivider",
 CellID->9089840],

Cell["Meta-information elements:", "FormatNotes",
 CellID->301601943],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", Cell[
    "time-stamped annotation list", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ChannelCount\>\"", Cell[
    "number of simultaneous signal channels", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FilterInformation\>\"", Cell["\<\
information about signal filters applied during the recording, given as a \
list of strings\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PatientID\>\"", Cell[
    "patient identification string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Title\>\"", Cell["\<\
title of the recording, typically used as a document identification\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RecordTimings\>\"", Cell[
    "start times and durations for each record, given in seconds", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SignalRange\>\"", Cell[
    "physical data ranges for each signal channel", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SignalUnits\>\"", Cell[
    "units in which the physical data for each channel is given", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<StartDate\>\"", Cell[
    "local date and time when the recording was started", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Device\>\"", Cell["\<\
information about the physical devices such as electrodes used for recording \
each channel\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->962449081],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).edf\>\"", ",", " ", "\"\<Annotations\>\""}], 
   "]"}]], "InlineFormula"],
 "gives the time-stamped annotation lists of an EDF+ file as a list of the \
form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["t", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["dur", "TI"], 
        StyleBox["i", "TI"]]}], "}"}], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["str", "TI"], 
        StyleBox["i1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["str", "TI"], 
        StyleBox["i2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1381737192],

Cell["\<\
In EDF and EDF+, all records have the same duration. EDF+ allows time gaps \
between records.\
\>", "FormatNotes",
 CellID->235117397]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->553458662],

Cell["\<\
Show the labels of all signal channels available in an EDF file:\
\>", "ExampleText",
 CellID->1827322205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/osas.edf.gz\>\"", ",", " ", "\"\<Labels\>\""}], 
  " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213981999],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"EEG FpzM2\"\>", ",", "\<\"EEG C3M2\"\>", 
   ",", "\<\"EEG O1M2\"\>", ",", "\<\"EEG Fp2M1\"\>", ",", "\<\"EEG C4M1\"\>",
    ",", "\<\"EEG O2M1\"\>", ",", "\<\"EEG M2M1\"\>", 
   ",", "\<\"EOG Pos8M1\"\>", ",", "\<\"EOG Pos18M1\"\>", 
   ",", "\<\"EMG Submental\"\>", ",", "\<\"EMG Linked Legs\"\>", 
   ",", "\<\"EKG\"\>", ",", "\<\"Resp Oro-Nasal\"\>", 
   ",", "\<\"Resp Chest\"\>", ",", "\<\"Resp Abdomen\"\>", 
   ",", "\<\"SaO2\"\>", ",", "\<\"Hypnogram\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1507832115]
}, Open  ]],

Cell["Import the labels and device names as a table:", "ExampleText",
 CellID->640663688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "@", 
   RowBox[{"Import", "[", " ", 
    RowBox[{"\"\<ExampleData/osas.edf.gz\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<Labels\>\"", ",", "\"\<Device\>\""}], "}"}], "}"}]}], " ",
     "]"}]}], " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86777168],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"EEG FpzM2\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EEG C3M2\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EEG O1M2\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EEG Fp2M1\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EEG C4M1\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EEG O2M1\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EEG M2M1\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EOG Pos8M1\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EOG Pos18M1\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EMG Submental\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EMG Linked Legs\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"EKG\"\>", "\<\"AgAgCl Electrodes\"\>"},
    {"\<\"Resp Oro-Nasal\"\>", "\<\"Oral/Nasal Thermistor\"\>"},
    {"\<\"Resp Chest\"\>", "\<\"Variable-Resistance Belt\"\>"},
    {"\<\"Resp Abdomen\"\>", "\<\"Variable-Resistance Belt\"\>"},
    {"\<\"SaO2\"\>", "\<\"Nellcor Pulse Oximeter\"\>"},
    {"\<\"Hypnogram\"\>", "\<\"0..6 and 9 are Wake Stages\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->151598158]
}, Open  ]],

Cell[TextData[{
 "Import the first record of the 12",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " signal channel and plot it using ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->994636164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListLinePlot", "[", " ", 
   RowBox[{
    RowBox[{"Import", "[", " ", 
     RowBox[{"\"\<ExampleData/osas.edf.gz\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<RecordsData\>\"", ",", " ", "12", ",", "1"}], "}"}]}], 
     " ", "]"}], ",", " ", 
    RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", " ", 
    RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}]}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->976592890],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd2zuQ69QZwHFN0rh0QeGCQrnD7HgYJiNCCOYREAtczFtAEpwXCMgNC+Fh
INyYPBWSECchicstVW7pcruo3NLlliq3dLllJjn/v2b8bXPmd79zJFk6+nTO
ke433vrolVtfy7Ls6utZ9r8y/e0fS+U9Hf9QHv77COeU4+A7KO+mnFDeS3kn
5bdCO32D8n7Kuyi/Q3lE+RDllPLRsN/HKe+hfILym5RPUxaU83Ccxj0u299H
WVJ+Oxyfxz0N/+55ekB3qZx5XPhB22F/5yP4YfwYfiT4u/i72PPyKH4MP9Qd
/g721wy/i/jjh250QfwY01+a4OG8HRHXOfEn8V3Eg7On8IR4cHbzcHtN8HAd
7ySubxD3urt/bftnQlxPiT8b9h+cPYePiGv3//zh72m07V8I8eDsRUx/avSI
+EuY+6DR9suKkn5Vaq5Dg73unXH71cuU9ONS048bTR7o9BHH9wqmf5Wa/tvo
B5I77f3yKqY/lprtN5q80OFuwb9/j+N+mxLbDxqcv83+cfc++/9+ck28xOXL
7B9nM9prr88PMOen1OShJrjT5qHX3D7tNXmjCe60ecLzQF4oNXmg0ce0196H
P6Tkviu1509zX3R4uA9/hOlvJTbvNJr+1Gnz9o8peY6UmudWo7nfOm1++wl+
OLnU5MtGP057XdL+p5j8XGrya6O9/tr9v37oUt9He30v7bX5941Dl5r81AR3
2vxc47uT8/qwfhnitTbfa+7HNsS74D5sL3vzMJ5r9x9ca/NxiLch3mnyaR+c
vXXoPLjU+/+k/WvzqWYc0OIhXxrnfulDPCPv+NzNsfeneclxQ62zdHyN5vy1
mv7YacYHfYhnP8P0/1zT/0tN/6v1DY4bmzdazXXurM9fj9v32P8t6i/Z/y23
w/6Nv8r+bx0ef6MZn7aa8VenyZe99vn3c7eXylz7PAyuNfmyCW6DO+y4qDfu
OOcd4jjHQz41Tj6tjZtfjdO/WuO40/SvXvv7TygZF+f6BvvX9Ld6qJ/caJ7P
LW7Ij53xJ5P74Oxd6j+RnGvipSb/1njIz5r+22ryaafpv702/713+HtyzXix
1Iyv6hBvNOOxVh+x/1C/1+7/F5h8lWvalyFeBzfa/BfcBffa58f7h8eTv39Y
v9Q8P2vteDfEW23+1Xew/6E95QeUzLNy7f2HvT9q7fjE+sepbDX3c6eZl/Xa
ee2H7j8dX67pvyVujpPr4EbTf1tt/3d7PM977bz0I46TcWmOHReW+nn2j4uP
2T+uP2X/1ie/drhcsH/jDyZnS8z1HGvGp/lg9qsZT5ea61dp8kutGX8uNfOH
RnO9NprnXat5Hm7x8HzV9I+d9cmPvWb8udfOwz6mPfXH2Hlfbvw4lUVwaX36
a6UZj9ea8f1Sc780mv6ycftPJbfD8SVvrf9ccqefTd5p6ve2J5/ujdNfs08O
42Oc0b9zzfO20I4PNOPdSpN/a834d6nvT240+WijGR+2mvy9De40+Wqnyee9
5v7bh3j2Keb+H396WD/X7K8ILjX5s9KOVzV/y6F9Kpth/6ncYNdJWuPHqdxq
+7/m/tmF7fWa9ae95vxnv8RczzE2v+XG6R+FcfOjcfpHpZm/15rx2NL2jG8a
7LxyY9x8igvGh1vc307ucEV8h8s3k3v3z/Huw/Fkn7E/8sdYkw9y7HiqwK6T
lNbHlfVZh6k16zZL65OPGk18Y33WaVrsusvW+qyDdME76+Pe4+X5stesY2S3
aY/Htw/b57cPj6fQ/L7S9sznK+P0x1rzvF1q57e2p79tjJPPWv108laT3zrN
83Hn9sx/xtn+3jj5NfvV4f7Hmv6SY/NboV0v0PyeSpNP6hBfavOfJh9ttOO5
UH8btt9pxls77Xw7eB/2l60O9zdeHcZzzXigGOqnstSsz1Sa+U+NfV4ujePG
OPlsY5zxQqtZ79lq13M053fn9rh+vXHyyT7Es8+J47E2/2nGR8Xnh8dbasZr
lfW5v2vcvZ7aL3HBeK3Be7zBOeO31u0z/926fcf3mvHGbjj+VPa2J3/ttetv
v6ZkvDPGQ/4L8cI4LoOr4Nr25j9NPmmw+XSjyT+t2yM/bY2zjtqF+A47nu6N
s+68d/+O/35DyfkYa8abueb5WWjnR5p8UGmep7Wmfy218wfN/HaDne+2xsk/
2+BOM77aacZfvfb+D85+i8kfY+34X7P+VWjWA8rBqaxC/TrUXwY3Q/20frMZ
9p/KNmx/G+KdvpHKnSZf9Nj7dW/8mPJ3xBmPjLH9IdfcD4WmfamZj1aa+Wat
+VtqxruNZj620VzfVrO+stWuJ4f4TnP+e38fx7fHwzrn7/kdrNeNccf7ixzX
HyQXuOX9Rzm0T65wczO5xq5nLDX3U6NZf9po7r/W7TEe3hrHnXHy204znuut
b/4Lzv5A6f2PzY+5Nv9Zn/d0pWY8VGnyW63Jb0u3Rz5sjLP9jeb4W+38V/s+
S3P/7LTrPZr+tHf/Pv8aTL4ZacdDIT7B5rNck++mmnxYaMYvM+37Ds14Zq6Z
X1Wa+eAiuNb83hNNPlvqo+SV9v1FqL/WjC82waea9axWM78/045XNM/n8+H3
prLTx6m80K5nDOc7lZea+6Uf9p+O5yr8vn24Ptfh+mZ/dPvJI837gnHwRDs+
0lyP6eBUFtj3PjPsOn9pfc7v3PqMfyr9YfICl7xvrW3/UvKJpr8vNc+bleY7
lUbzXclaMz/fBJ9q3ie0mnx/FrzVrGeda99nDuc3lRfD+U3lDpvPLjX5qdfk
jyvb473m+XWtff/wxeH+R5r3WWPN9Zxoxwea+3eqvf81/WX2hb8nuQyeW5/5
WaUZvy+sT3+tjdO/TzTrD0tNf1hpv3fR5Kd1iG80v+9Uk5/a4DPN/GmruT/O
tevjwRfBO32UfBnca+YnV5r+vh+2l8pr7fcDf6KkP46Cx5rn5QQP76uMs547
1cwPC02+nGnXzzT9Yx5caa73wv17/Y2Tn06Cl5rnzUo7/sC+d19j3zNurE//
P8Xtu2l7rfU/Sj6z/q3kLXY8dW7c97Ph/Fxoxrc7fSOVl+F4es3z5kqTb/aa
fHQd4tmfKRlfjDTXcxw8wY6nc+P0h6lmPF1o8tXM9uSjMtSfh+1XxslPC+34
WtPfTrTzDc39t9L0n8b9kX/Ww/EmbzTrSaf6meR2OP7kM02+2mr687n2e5Lh
/CZfBO+CL4fzkdxr8u1V8F6T/64184fsL4fxkWY+MdbcPxPNfCXX5Ntp2F6h
OZ6Z9v1BiM81v6/SnK9FcB22dxL2v9SsD62038tp5pdrzXeqG839dYrtn61x
1jvPNPfnVnN/n2vX78LvuXD7N5N3mv55GeK97elvV8H7cH6uNfPD7Eu2x3xq
pPlOavzl4fFPcM38L8e7z5KnOOf9ZKFZj5+5fY6/HLafyrlm/a/SHN9CH3Mc
w/ZSeaLJN8vgVajfaK7nWpPPNpp8dapZ32s9HuZzZ8ZZX9oaZ/53jv1OstPE
L2yPd5r55aXb4/j7cP2ujJOv95rn/XW4ntlfMf1xpH0fiJsXkiea/Jhr3kdO
Nfmx0C8mz9w+2ys16/1zzfaqsL2F9n285v45sT39f6mJr6xv/jfO83ityWeb
ED/VtG81+fJMk8+2IX6uXb8LvgjXY6ePki8190uvGa9fDe1Tude8j78eri/l
OpX2/xF2vjrWfK8w0XzPkg/1k6f6ZnKh6U+zYX/JZfDc+pzfSpO/FprxbG17
fs8J9n3i0vqMD1a4fSdtr8E17xPXOP8keWOc8dyp22M80Grmj2fhfG4160Xn
mvzQ2Z74hXHmbztsfrgM9fvgK9uz/rQP7a89P37H/bdDj7DfTY+x30lPrO/7
QeOsx09D/QL7/nFme/JfaX3y69z9k88q4/TvhWb+WWvurxNNf1u6vZvJK831
azTvD9fa8V/Y3mlwOxxv8pkmP22tTz45167fasYnF5r50U6znnOpXd8Lvgre
a+aT1/ooOfs75nkwGpzKsSafTDTzw1wz3plq5hOF5nrOtN93hfZzzfFVmvOz
wEP+N34z+cS4+T/UXwU3mvyzdnuc7034PafW5zv2VvNd95n1Gb9ujbN+dY5L
8ktnnPnkhfHXknfheC41+bm3PfnvSvu9k/UZn1wb9/+B/OPQI+x4ZRziE+OM
R/IQn2raF9jxzsz25IPS+uSLufXJJ1Xwwva8b61D/MTtkZ+WmuNd2Z7xYKPp
z2vt+F9zP51q7t9W87w6c3/e/8ad/xl3/mec/HAxHE/yTpPfLjXvj/pwfFea
9eC95v3A9RCn/IqS7zFHXx3Gx/pGKiea528ePNXkiwL7/mmm/f8e1ic+18ep
rKzP82FhnPWoOmz/xDj5ZKnJb6shntxoxmtr7fgvxE+D21D/LHiruT7nmvX7
Drs+fmGc78R34XpcatbHe9zyfu7K7b2VvPf8MP6+tr3ff/0T8zfS9Iexdvyn
/V5XM7+YasabhSZfzTT3Wxk816z3VJrx1AL7PUmtnf9Zn/HVUjM+WlkfN8Fr
69PfNprn16lmvt9q1gfOwvncDuev+39xruk/nSY/XGjGF7vgS4+X51s/nI/k
K+szXt4HX2v//+e/MPllFDwOnmi/j9Tko6n2e8kQn2nORxk8D640988ibK8O
9U+07/8075dW+ii5CfXXmvX0Tah/qpn/tJrx0pl2/UfTv88165cdtj9faPrb
zvrM5y+133dqxsNX4XztNfPXa83zJ/s39v2fJn+NQ3wSnGv681Sz/lpgv7+Z
Yf9fTGn9N8r/ApVN+Co=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageSize->Medium,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1791932383]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EDF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 7.8700778}", "context" -> "", 
    "keywords" -> {
     "medicine", "physiology", "EEG", "ECG", "EKG", "electroencephalography", 
      "polysomnography", "somnography", "electromyography", "myography", 
      "electroneurography", "neurography", "electrocardiography", "sleep", 
      "time series"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "EDF and EDF+ physiological signal recordings format. Commonly used for \
the exchange and storage of medical time-series recordings. Application areas \
include electroencephalography, polysomnography, electromyography, evoked \
potentials, electroneurography, electrocardiography. EDF is an acronym for \
European Data Format. Binary format. Stores multiple simultaneous signal \
channels, time-stamped annotations, and meta-information. Encodes signal \
samples as 16-bit integers. EDF+ can store discontinuous time series. First \
published in 1992, superseded by EDF+ in 2003.", "synonyms" -> {}, "title" -> 
    "EDF", "type" -> "Format", "uri" -> "ref/format/EDF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16029, 538, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26991, 792}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1487, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2110, 58, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2220, 64, 620, 13, 70, "FormatUsage",
 CellID->37585799],
Cell[2843, 79, 224, 9, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3104, 93, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3160, 96, 319, 9, 70, "FormatNotes",
 CellID->28652],
Cell[3482, 107, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[3524, 110, 1054, 37, 70, "FormatNotes",
 CellID->28396],
Cell[4581, 149, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4623, 152, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[4978, 167, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[5555, 189, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[6138, 212, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[6844, 239, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[6885, 242, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[7124, 253, 206, 7, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[7367, 265, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[7426, 268, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[7625, 278, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[8300, 293, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[8344, 296, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[8419, 299, 866, 17, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[9288, 318, 258, 9, 70, "FormatNotes",
 CellID->1999285391],
Cell[9549, 329, 436, 13, 70, "FormatNotes",
 CellID->791073419],
Cell[9988, 344, 835, 30, 70, "FormatNotes",
 CellID->729329788],
Cell[10826, 376, 1107, 39, 70, "FormatNotes",
 CellID->248180899],
Cell[11936, 417, 41, 1, 70, "WeakDivider",
 CellID->9089840],
Cell[11980, 420, 69, 1, 70, "FormatNotes",
 CellID->301601943],
Cell[12052, 423, 1821, 37, 70, "2ColumnTableMod",
 CellID->962449081],
Cell[13876, 462, 1001, 35, 70, "FormatNotes",
 CellID->1381737192],
Cell[14880, 499, 144, 4, 70, "FormatNotes",
 CellID->235117397]
}, Open  ]],
Cell[CellGroupData[{
Cell[15061, 508, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[15122, 511, 151, 2, 70, "MoreAbout"],
Cell[15276, 515, 134, 2, 70, "MoreAbout"],
Cell[15413, 519, 133, 2, 70, "MoreAbout"],
Cell[15549, 523, 156, 2, 70, "MoreAbout"],
Cell[15708, 527, 156, 2, 70, "MoreAbout"],
Cell[15867, 531, 125, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16029, 538, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16145, 544, 60, 1, 70, "ExampleSection",
 CellID->553458662],
Cell[16208, 547, 116, 3, 70, "ExampleText",
 CellID->1827322205],
Cell[CellGroupData[{
Cell[16349, 554, 186, 5, 70, "Input",
 CellID->213981999],
Cell[16538, 561, 573, 11, 70, "Output",
 CellID->1507832115]
}, Open  ]],
Cell[17126, 575, 89, 1, 70, "ExampleText",
 CellID->640663688],
Cell[CellGroupData[{
Cell[17240, 580, 357, 10, 70, "Input",
 CellID->86777168],
Cell[17600, 592, 1530, 33, 70, "Output",
 CellID->151598158]
}, Open  ]],
Cell[19145, 628, 345, 12, 70, "ExampleText",
 CellID->994636164],
Cell[CellGroupData[{
Cell[19515, 644, 484, 13, 70, "Input",
 CellID->976592890],
Cell[20002, 659, 5210, 92, 70, "Output",
 CellID->1791932383]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[25251, 756, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

