(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     98156,       1850]
NotebookOptionsPosition[     94468,       1736]
NotebookOutlinePosition[     96080,       1777]
CellTagsIndexPosition[     95994,       1772]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"EPS\"" :> Documentation`HelpLookup["paclet:ref/format/EPS"], 
          "\"PDF\"" :> Documentation`HelpLookup["paclet:ref/format/PDF"], 
          "\"SVG\"" :> Documentation`HelpLookup["paclet:ref/format/SVG"], 
          "\"WMF\"" :> Documentation`HelpLookup["paclet:ref/format/WMF"], 
          "\"XBM\"" :> Documentation`HelpLookup["paclet:ref/format/XBM"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"EPS\\\"\"\>", 
       2->"\<\"\\\"PDF\\\"\"\>", 3->"\<\"\\\"SVG\\\"\"\>", 
       4->"\<\"\\\"WMF\\\"\"\>", 
       5->"\<\"\\\"XBM\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Vector Graphics Formats" :> 
          Documentation`HelpLookup["paclet:guide/VectorGraphicsFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Importing & Exporting\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 4->"\<\"Raster Image Formats\"\>",
        5->"\<\"Vector Graphics Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "EMF ",
 StyleBox["(", "FilenameExtension"],
 ".emf",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Microsoft EMF format.
Image file format.
Used by the Windows operating system and by Microsoft applications as a \
graphics resource format.
EMF is an acronym derived from Enhanced Metafile.
Binary format.
Stores vector graphics, raster graphics, and text.
Stores image data as either calls to the Windows graphical device interface \
(GDI), uncompressed Device Dependent Bitmaps, or uncompressed Device \
Independent Bitmaps. 
Successor of the 16-bit WMF format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully supports the EMF format."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).emf\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports arbitrary vector or raster graphics or typeset expressions to the \
EMF format."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).emf\>\"", ",", 
     RowBox[{
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], " ", "]"}], " "}]], 
  "InlineFormula"],
 "creates an EMF file representing a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object"
}], "FormatNotes",
 CellID->6249],

Cell["\<\
Since EMF supports vector graphics, fonts are not rasterized when exporting \
to EMF.\
\>", "FormatNotes",
 CellID->280203765],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the ",
 "EMF",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell["Data representation element:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "exports arbitrary graphics to EMF", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->2136836049]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<EPS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/EPS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PDF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PDF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SVG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SVG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<WMF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/WMF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XBM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XBM"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->169276447],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout",
 CellID->1883613538],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->1836292739],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout",
 CellID->1084573336],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout",
 CellID->582862416],

Cell[TextData[ButtonBox["Vector Graphics Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VectorGraphicsFormats"]], "MoreAbout",
 CellID->1495711745]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->96241250],

Cell["Export 2D vector graphics as an EMF file:", "ExampleText",
 CellID->1902926291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<plot.emf\>\"", ",", " ", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nk0lN//AHBLZAszYynLzKCQilZFPt6XdimlSJIKSVkTRWlRIiRLZKmI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       "]]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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       "]]}, 
     {Hue[0.1421359549995791, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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       "]]}, 
     {Hue[0.37820393249936934`, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    ImageSize->Small,
    PlotRange->{{0, 10}, {-0.999999941761652, 0.9999997588489247}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1025396684],

Cell[BoxData["\<\"plot.emf\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->285800813]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EMF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 8.2919636}", "context" -> "", 
    "keywords" -> {"Microsoft", "Windows", "vector graphics"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Microsoft EMF format. Image file format. Used by the Windows operating \
system and by Microsoft applications as a graphics resource format. EMF is an \
acronym derived from Enhanced Metafile. Binary format. Stores vector \
graphics, raster graphics, and text. Stores image data as either calls to the \
Windows graphical device interface (GDI), uncompressed Device Dependent \
Bitmaps, or uncompressed Device Independent Bitmaps. Successor of the 16-bit \
WMF format.", "synonyms" -> {}, "title" -> "EMF", "type" -> "Format", "uri" -> 
    "ref/format/EMF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8408, 296, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 95861, 1765}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2245, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2868, 76, 148, 6, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3019, 84, 513, 13, 70, "FormatUsage",
 CellID->37585799],
Cell[3535, 99, 204, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3776, 111, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3832, 114, 381, 12, 70, "FormatNotes",
 CellID->8194],
Cell[4216, 128, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4258, 131, 678, 25, 70, "FormatNotes",
 CellID->6249],
Cell[4939, 158, 136, 4, 70, "FormatNotes",
 CellID->280203765],
Cell[5078, 164, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[5119, 167, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[5358, 178, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[5611, 192, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[5670, 195, 67, 1, 70, "FormatNotes",
 CellID->13573],
Cell[5740, 198, 368, 9, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[6111, 209, 262, 9, 70, "FormatNotes",
 CellID->2136836049]
}, Open  ]],
Cell[CellGroupData[{
Cell[6410, 223, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[6468, 226, 1005, 34, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[7510, 265, 58, 1, 70, "MoreAboutSection",
 CellID->169276447],
Cell[7571, 268, 172, 3, 70, "MoreAbout",
 CellID->1883613538],
Cell[7746, 273, 155, 3, 70, "MoreAbout",
 CellID->1836292739],
Cell[7904, 278, 154, 3, 70, "MoreAbout",
 CellID->1084573336],
Cell[8061, 283, 150, 3, 70, "MoreAbout",
 CellID->582862416],
Cell[8214, 288, 157, 3, 70, "MoreAbout",
 CellID->1495711745]
}, Open  ]],
Cell[CellGroupData[{
Cell[8408, 296, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[8524, 302, 59, 1, 70, "ExampleSection",
 CellID->96241250],
Cell[8586, 305, 85, 1, 70, "ExampleText",
 CellID->1902926291],
Cell[CellGroupData[{
Cell[8696, 310, 85617, 1415, 70, "Input",
 CellID->1025396684],
Cell[94316, 1727, 86, 2, 70, "Output",
 CellID->285800813]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[94441, 1734, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

