(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37537,       1250]
NotebookOptionsPosition[     29667,       1004]
NotebookOutlinePosition[     31835,       1053]
CellTagsIndexPosition[     31749,       1048]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"MOL\"" :> Documentation`HelpLookup["paclet:ref/format/MOL"], 
          "\"PDB\"" :> Documentation`HelpLookup["paclet:ref/format/PDB"], 
          "\"XYZ\"" :> Documentation`HelpLookup["paclet:ref/format/XYZ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"MOL\\\"\"\>", 
       2->"\<\"\\\"PDB\\\"\"\>", 
       3->"\<\"\\\"XYZ\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Scientific & Medical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ScientificAndMedicalDataFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"Scientific & Medical Data Formats\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "FASTA ",
 StyleBox["(.fasta, .fa, .fsa, .mpfa)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "Mime type: ",
 StyleBox[Cell[BoxData[
  RowBox[{
   RowBox[{"chemical", "/", 
    StyleBox["seq", "InlineCode"]}], 
   StyleBox["-", "InlineCode"], 
   StyleBox["aa", "InlineCode"], 
   StyleBox["-", "InlineCode"], 
   StyleBox["fasta", "InlineCode"]}]], "InlineCode"], "InlineCode"],
 StyleBox[", chemical/seq-na-fasta ", "InlineCode"],
 "\nFASTA molecular biology format.\nStandard format for storing and \
exchanging DNA and protein sequences.\nPlain text format.\nStores nucleic \
acid or protein sequences as character strings.\nVarious conventions are in \
use to represent meta-information.\nDeveloped in 1988 by William Pearson and \
David Lipman as part of the FASTA sequence-alignment software."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support all common variants of the FASTA file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", "]"}]], "InlineFormula"],
 " imports DNA or protein sequences from a FASTA file."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a sequence or a list of sequences to the FASTA format."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a list of strings representing the sequences stored in the file."
}], "FormatNotes",
 CellID->25134],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    StyleBox["str", "TI"]}], "]"}]], "InlineFormula"],
 " exports a character string representing a DNA sequence to FASTA."
}], "FormatNotes",
 CellID->446732489],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["str", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["str", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports multiple DNA sequences."
}], "FormatNotes",
 CellID->630112711],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a FASTA file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<FASTA\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<FASTA\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a FASTA file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).fasta\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "FASTA",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->525384128],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Header\>\"", Cell[
    "raw header lines", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Sequence\>\"", Cell[
    "DNA or protein sequences as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[
    "sequences as formatted text", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1118606692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Sequence\>\""], "InlineFormula"],
 " element by default for the ",
 "FASTA",
 " format."
}], "FormatNotes",
 CellID->13037],

Cell["Additional data elements:", "FormatNotes",
 CellID->908615769],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "\"Header\" and \"Sequence\" elements combined in a list", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LabeledData\>\"", Cell[
    "list of rules for each sequence stored in the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->349015766],

Cell["Header line meta-information:", "FormatNotes",
 CellID->102231501],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Accession\>\"", Cell[
    "NCBI accession number for each sequence", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Description\>\"", Cell[
    "locus description text for each sequence", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GenBankID\>\"", Cell[
    "GenBank database identifier", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Length\>\"", Cell[
    "list of integers, representing the length of each sequence", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->217919707],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the standard IUB/IUPAC abbreviations for nucleic acids:"
}], "FormatNotes",
 CellID->145650958],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "A", Cell["adenosine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "C", Cell["cytidine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "G", Cell["guanine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "T", Cell["thymidine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "U", Cell["uracil", "TableText"]},
   {Cell["      ", "TableRowIcon"], "R", Cell[
    "purine (G or A)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Y", Cell[
    "pyrimidine (T or C)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "K", Cell[
    "ketone (G or T)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "M", Cell[
    "amino group (A or C)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "S", Cell[
    "strong interaction (G or C)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "W", Cell[
    "weak interaction (A or T)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "B", Cell["C or G or T", "TableText"]},
   {Cell["      ", "TableRowIcon"], "D", Cell["A or G or T", "TableText"]},
   {Cell["      ", "TableRowIcon"], "H", Cell["A or C or T", "TableText"]},
   {Cell["      ", "TableRowIcon"], "V", Cell["A or C or G", "TableText"]},
   {Cell["      ", "TableRowIcon"], "N", Cell[
    "any nucleic acid (A or C or G or T)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "-", Cell[
    "gap of indeterminate length", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True}}}},
 CellID->1350826606],

Cell["Codes representing amino acids:", "FormatNotes",
 CellID->1971777173],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "A", Cell["alanine (Ala)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "B", Cell[
    "either aspartic acid or asparagine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "C", Cell[
    "cysteine (Cys)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "D", Cell[
    "aspartic acid (Asp)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "E", Cell[
    "glutamic acid (Glu)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "F", Cell[
    "phenylalanine (Phe)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "G", Cell["glycine (Gly)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "H", Cell[
    "histidine (His)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "I", Cell[
    "isoleucine (Ile)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "K", Cell["lysine (Lys)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "L", Cell["leucine (Leu)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "M", Cell[
    "methionine (Met)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "N", Cell[
    "asparagine (Asn)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "P", Cell["proline (Pro)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Q", Cell[
    "glutamine (Gln)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "R", Cell[
    "arginine (Arg)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "S", Cell["serine (Ser)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "T", Cell[
    "threonine (Thr)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "U", Cell[
    "selenocysteine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "V", Cell["valine (Val)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "W", Cell[
    "tryptophan (Trp)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Y", Cell[
    "tyrosine (Tyr)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Z", Cell[
    "either glutamic acid or glutamine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "X", Cell[
    "any amino acid", "TableText"]},
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "translation stop", "TableText"]},
   {Cell["      ", "TableRowIcon"], "-", Cell[
    "gap of indeterminate length", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->1838789754]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderFormat\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the format of the header", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->540278671],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses a large built-in library of header format specifications found in \
common variants of the FASTA format."
}], "FormatNotes",
 CellID->413566746],

Cell[TextData[{
 "By setting ",
 Cell[BoxData["\"\<HeaderFormat\>\""], "InlineFormula"],
 " to a list of literal strings and names of meta-information elements, any \
header line format can be specified on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2107515252],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<HeaderFormat\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"gi\", \"InlineCode\"]\)\!\(\*
StyleBox[\"|\", \"InlineCode\"]\)\>\"", ",", "\"\<DatabaseIndex\>\"", ",", 
     "\"\<|gb|\>\"", ",", "\"\<Accession\>\"", ",", "\"\<|\>\"", ",", 
     "\"\<Description\>\""}], "}"}]}]], "InlineFormula"],
 " is a setting typical for NCBI Fasta files."
}], "FormatNotes",
 CellID->39527969],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->549451608],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<LineWidth\>\"", "70", Cell[
    "maximum number of characters in a line", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->453493556]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<MOL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MOL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PDB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PDB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XYZ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XYZ"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1584468348]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->841267848],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->420119036],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout",
 CellID->355538043],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout",
 CellID->424863843]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->22717629],

Cell["This reads the raw header line from a sample FASTA file:", "ExampleText",
 CellID->241715438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/mitochondrion.fa.gz\>\"", ",", " ", "\"\<Header\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->581525318],

Cell[BoxData[
 RowBox[{"{", "\<\"gi|17981852|ref|NC_001807.4| Homo sapiens mitochondrion, \
complete genome\"\>", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1362302036]
}, Open  ]],

Cell["Extract the accession string:", "ExampleText",
 CellID->1619789989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/mitochondrion.fa.gz\>\"", ",", " ", "\"\<Accession\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160152104],

Cell[BoxData[
 RowBox[{"{", "\<\"NC_001807.4\"\>", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1887158385]
}, Open  ]],

Cell["\<\
Parse the GenBank database key and the description string from the header \
line:\
\>", "ExampleText",
 CellID->307374638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/mitochondrion.fa.gz\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", " ", 
     RowBox[{"\"\<GenBankID\>\"", ",", " ", "\"\<Description\>\""}], "}"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->169589744],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"17981852\"\>", "}"}], ",", 
   RowBox[{
   "{", "\<\"Homo sapiens mitochondrion, complete genome\"\>", "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1284994152]
}, Open  ]],

Cell["Read the first letters of the DNA sequence:", "ExampleText",
 CellID->817271510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", " ", 
  RowBox[{
   RowBox[{"First", "@", 
    RowBox[{"Import", "[", "\"\<ExampleData/mitochondrion.fa.gz\>\"", "]"}]}],
    ",", "256"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17199],

Cell[BoxData["\<\"\
GATCACAGGTCTATCACCCTATTAACCACTCACGGGAGCTCTCCATGCATTTGGTATTTTCGTCTGGGGGGTGTGCAC\
GCGATAGCATTGCGAGACGCTGGAGCCGGAGCACCCTATGTCGCAGTATCTGTCTTTGATTCCTGCCTCATTCTATTA\
TTTATCGCACCTACGTTCAATATTACAGGCGAACATACCTACTAAAGTGTGTTAATTAATTAATGCTTGTAGGACATA\
ATAATAACAATTGAATGTCTGC\"\>"], "Output",
 CellLabel->"Out[4]=",
 CellID->1801158432]
}, Open  ]],

Cell["\<\
This converts a short sequence to the FASTA format, automatically adding \
default header information:\
\>", "ExampleText",
 CellID->1904244367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"\"\<GATAGCATTGCGAGACGCTGG\>\"", ",", "\"\<FASTA\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1633656998],

Cell[BoxData["\<\">Sequence 1 | Created by Wolfram Mathematica \
6.0\\nGATAGCATTGCGAGACGCTGG\\n\"\>"], "Output",
 CellLabel->"Out[5]=",
 CellID->1130139205]
}, Open  ]],

Cell["This exports two sequences:", "ExampleText",
 CellID->1088081451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<TTTCGTCTGGGGGGT\>\"", ",", "\"\<GATAGCATTGCGAGACGCTGG\>\""}],
     "}"}], ",", "\"\<FASTA\>\""}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->361141165],

Cell[BoxData["\<\">Sequence 1 | Created by Wolfram Mathematica \
6.0\\nTTTCGTCTGGGGGGT\\n>Sequence 2 | Created by Wolfram Mathematica \
6.0\\nGATAGCATTGCGAGACGCTGG\\n\"\>"], "Output",
 CellLabel->"Out[6]=",
 CellID->1370048655]
}, Open  ]],

Cell["This exports a pair of headers and sequences:", "ExampleText",
 CellID->1641267840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", " ", "=", " ", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<AC90483\>\"", ",", "\"\<AC74958\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<TTCTATTATTTATCGCACC\>\"", ",", "\"\<ATATTACAGGCGAACATA\>\""}], 
       "}"}]}], "}"}], ",", "\"\<FASTA\>\""}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->998820625],

Cell[BoxData["\<\">AC90483\\nTTCTATTATTTATCGCACC\\n>AC74958\\\
nATATTACAGGCGAACATA\\n\"\>"], "Output",
 CellLabel->"Out[7]=",
 CellID->1320715431]
}, Open  ]],

Cell[TextData[{
 "Import the previous output using the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element gives raw headers and sequences:"
}], "ExampleText",
 CellID->364316109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<FASTA\>\"", ",", "\"\<Data\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1561692752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"AC90483\"\>", ",", "\<\"AC74958\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"TTCTATTATTTATCGCACC\"\>", 
     ",", "\<\"ATATTACAGGCGAACATA\"\>"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[8]=",
 CellID->873273425]
}, Open  ]],

Cell["Import as a list of rules:", "ExampleText",
 CellID->584966366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"f", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<FASTA\>\"", ",", "\"\<LabeledData\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->95795211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"AC90483\"\>", "\[Rule]", "\<\"TTCTATTATTTATCGCACC\"\>"}], ",",
    
   RowBox[{"\<\"AC74958\"\>", "\[Rule]", "\<\"ATATTACAGGCGAACATA\"\>"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->1203210377]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FASTA - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 10.1045100}", "context" -> "", 
    "keywords" -> {
     "protein sequences", "genomic sequences", "base pair sequences", 
      "nucleic acid sequences", "DNA sequences", "RNA sequences", 
      "bp sequences", "biotechnology sequences", "bioinformatics", "GenBank", 
      "BLAST", "NCBI", "alanine", "cysteine", "aspartic acid", 
      "glutamic acid", "phenylalanine", "glycine", "histidine", "isoleucine", 
      "lysine", "leucine", "methionine", "asparagine", "proline", "glutamine",
       "ariginine", "serine", "threonine", "selenocysteine", "valine", 
      "tryptophan", "tyrosine", "adenosine", "cytidine", "guanine", 
      "thymidine", "uracil", "purine", "pyrimidine", "ketone"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mime type: chemical/seq-aa-fasta, chemical/seq-na-fasta FASTA molecular \
biology format. Standard format for storing and exchanging DNA and protein \
sequences. Plain text format. Stores nucleic acid or protein sequences as \
character strings. Various conventions are in use to represent \
meta-information. Developed in 1988 by William Pearson and David Lipman as \
part of the FASTA sequence-alignment software.", "synonyms" -> {}, "title" -> 
    "FASTA", "type" -> "Format", "uri" -> "ref/format/FASTA"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[23948, 778, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31615, 1041}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1737, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2360, 68, 123, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2486, 74, 758, 17, 70, "FormatUsage",
 CellID->20778],
Cell[3247, 93, 347, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3631, 110, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3698, 113, 299, 9, 70, "FormatNotes",
 CellID->2520],
Cell[4000, 124, 359, 11, 70, "FormatNotes",
 CellID->12927],
Cell[4362, 137, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4404, 140, 342, 10, 70, "FormatNotes",
 CellID->25134],
Cell[4749, 152, 364, 11, 70, "FormatNotes",
 CellID->446732489],
Cell[5116, 165, 554, 19, 70, "FormatNotes",
 CellID->630112711],
Cell[5673, 186, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5715, 189, 345, 11, 70, "FormatNotes",
 CellID->22675],
Cell[6063, 202, 576, 20, 70, "FormatNotes",
 CellID->13336],
Cell[6642, 224, 584, 21, 70, "FormatNotes",
 CellID->16334],
Cell[7229, 247, 685, 25, 70, "FormatNotes",
 CellID->21001],
Cell[7917, 274, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7958, 277, 517, 18, 70, "FormatNotes",
 CellID->9310],
Cell[8478, 297, 1077, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9558, 339, 663, 22, 70, "FormatNotes",
 CellID->7590],
Cell[10224, 363, 818, 28, 70, "FormatNotes",
 CellID->20356],
Cell[11045, 393, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[11086, 396, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11450, 412, 354, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11841, 431, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11895, 434, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12090, 444, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12761, 459, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12803, 462, 72, 1, 70, "FormatNotes",
 CellID->525384128],
Cell[12878, 465, 617, 13, 70, "2ColumnTableMod",
 CellID->1118606692],
Cell[13498, 480, 288, 11, 70, "FormatNotes",
 CellID->13037],
Cell[13789, 493, 68, 1, 70, "FormatNotes",
 CellID->908615769],
Cell[13860, 496, 536, 11, 70, "2ColumnTableMod",
 CellID->349015766],
Cell[14399, 509, 72, 1, 70, "FormatNotes",
 CellID->102231501],
Cell[14474, 512, 799, 16, 70, "2ColumnTableMod",
 CellID->217919707],
Cell[15276, 530, 168, 5, 70, "FormatNotes",
 CellID->145650958],
Cell[15447, 537, 1881, 37, 70, "2ColumnTableMod",
 CellID->1350826606],
Cell[17331, 576, 75, 1, 70, "FormatNotes",
 CellID->1971777173],
Cell[17409, 579, 2810, 59, 70, "2ColumnTableMod",
 CellID->1838789754]
}, Open  ]],
Cell[CellGroupData[{
Cell[20256, 643, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[20308, 646, 182, 7, 70, "FormatNotes",
 CellID->1911960202],
Cell[20493, 655, 467, 12, 70, "3ColumnTableMod",
 CellID->540278671],
Cell[20963, 669, 283, 8, 70, "FormatNotes",
 CellID->413566746],
Cell[21249, 679, 368, 11, 70, "FormatNotes",
 CellID->2107515252],
Cell[21620, 692, 443, 11, 70, "FormatNotes",
 CellID->39527969],
Cell[22066, 705, 195, 8, 70, "FormatNotes",
 CellID->549451608],
Cell[22264, 715, 380, 9, 70, "3ColumnTableMod",
 CellID->453493556]
}, Closed]],
Cell[CellGroupData[{
Cell[22681, 729, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[22734, 732, 590, 20, 70, "SeeAlso",
 CellID->1584468348]
}, Open  ]],
Cell[CellGroupData[{
Cell[23361, 757, 58, 1, 70, "MoreAboutSection",
 CellID->841267848],
Cell[23422, 760, 154, 3, 70, "MoreAbout",
 CellID->420119036],
Cell[23579, 765, 153, 3, 70, "MoreAbout",
 CellID->355538043],
Cell[23735, 770, 176, 3, 70, "MoreAbout",
 CellID->424863843]
}, Open  ]],
Cell[CellGroupData[{
Cell[23948, 778, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24064, 784, 59, 1, 70, "ExampleSection",
 CellID->22717629],
Cell[24126, 787, 99, 1, 70, "ExampleText",
 CellID->241715438],
Cell[CellGroupData[{
Cell[24250, 792, 187, 6, 70, "Input",
 CellID->581525318],
Cell[24440, 800, 175, 4, 70, "Output",
 CellID->1362302036]
}, Open  ]],
Cell[24630, 807, 73, 1, 70, "ExampleText",
 CellID->1619789989],
Cell[CellGroupData[{
Cell[24728, 812, 190, 6, 70, "Input",
 CellID->160152104],
Cell[24921, 820, 112, 3, 70, "Output",
 CellID->1887158385]
}, Open  ]],
Cell[25048, 826, 132, 4, 70, "ExampleText",
 CellID->307374638],
Cell[CellGroupData[{
Cell[25205, 834, 292, 8, 70, "Input",
 CellID->169589744],
Cell[25500, 844, 237, 8, 70, "Output",
 CellID->1284994152]
}, Open  ]],
Cell[25752, 855, 86, 1, 70, "ExampleText",
 CellID->817271510],
Cell[CellGroupData[{
Cell[25863, 860, 237, 7, 70, "Input",
 CellID->17199],
Cell[26103, 869, 343, 6, 70, "Output",
 CellID->1801158432]
}, Open  ]],
Cell[26461, 878, 154, 4, 70, "ExampleText",
 CellID->1904244367],
Cell[CellGroupData[{
Cell[26640, 886, 175, 5, 70, "Input",
 CellID->1633656998],
Cell[26818, 893, 156, 3, 70, "Output",
 CellID->1130139205]
}, Open  ]],
Cell[26989, 899, 71, 1, 70, "ExampleText",
 CellID->1088081451],
Cell[CellGroupData[{
Cell[27085, 904, 247, 7, 70, "Input",
 CellID->361141165],
Cell[27335, 913, 227, 4, 70, "Output",
 CellID->1370048655]
}, Open  ]],
Cell[27577, 920, 89, 1, 70, "ExampleText",
 CellID->1641267840],
Cell[CellGroupData[{
Cell[27691, 925, 433, 13, 70, "Input",
 CellID->998820625],
Cell[28127, 940, 146, 3, 70, "Output",
 CellID->1320715431]
}, Open  ]],
Cell[28288, 946, 190, 5, 70, "ExampleText",
 CellID->364316109],
Cell[CellGroupData[{
Cell[28503, 955, 204, 6, 70, "Input",
 CellID->1561692752],
Cell[28710, 963, 299, 9, 70, "Output",
 CellID->873273425]
}, Open  ]],
Cell[29024, 975, 69, 1, 70, "ExampleText",
 CellID->584966366],
Cell[CellGroupData[{
Cell[29118, 980, 217, 7, 70, "Input",
 CellID->95795211],
Cell[29338, 989, 263, 8, 70, "Output",
 CellID->1203210377]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[29640, 1002, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

