(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    286909,       6008]
NotebookOptionsPosition[    278600,       5740]
NotebookOutlinePosition[    280128,       5781]
CellTagsIndexPosition[    280041,       5776]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"JPEG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/JPEG"], "\"PNG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PNG"], "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"JPEG\\\"\"\>", 
       2->"\<\"\\\"PNG\\\"\"\>", 
       3->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Multimedia Formats" :> 
          Documentation`HelpLookup["paclet:guide/MultimediaFormats"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Image Processing\"\>", 4->"\<\"Importing & Exporting\"\>", 
       5->"\<\"Listing of All Formats\"\>", 6->"\<\"Multimedia Formats\"\>", 
       7->"\<\"Numerical Data\"\>", 8->"\<\"Raster Image Formats\"\>", 
       9->"\<\"Web Formats\"\>", 
       10->"\<\"Web Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "GIF ",
 StyleBox["(.gif)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19281],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["image/gif", "InlineCode"],
 "\nGIF raster image format.\nCommonly used for static and animated graphics \
on the web.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "GIF is an acronym for Graphics Interchange Format.\nBinary format.\nUses \
LZW lossless compression after restriction to an 8\[Hyphen]bit color palette.\
\nSupports transparency.\nDeveloped in 1987 by CompuServe."
}], "FormatUsage",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the GIF89a standard for both static and animated GIF \
images."
}], "FormatNotes",
 CellID->9152]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"gif\", \"MR\"]\)\>\"", "]"}]], "InlineFormula"],
 " imports a GIF file, returning a single graphics object or a list of \
animation frames."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as an image to a GIF file."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"gif\", \"MR\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports a list of graphics as an animation."
}], "FormatNotes",
 CellID->9876],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}]}]], "InlineFormula"],
 "], where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of color indices. "
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a GIF image with the same image size as the displayed form of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->7572],

Cell["\<\
Because GIF is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->6249],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a GIF file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<GIF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<GIF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a GIF file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the GIF format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a GIF file into a cell. "
}], "FormatNotes",
 CellID->2609],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a GIF file."
}], "FormatNotes",
 CellID->11064]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->9166],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16893],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16074],

Cell["Data representation elements:", "FormatNotes",
 CellID->30300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Animation\>\"", Cell[
    "animated GIF represented as an animation object", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell["\<\
graphics representing a static GIF or the first frame of an animated GIF\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsList\>\"", Cell[
    "frames of an animated GIF as a list of graphics", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " for an ordinary static GIF, and ",
 Cell[BoxData["\"\<GraphicsList\>\""], "InlineFormula"],
 " for an animated GIF."
}], "FormatNotes",
 CellID->9573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " of an animated GIF with element ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " gives the first frame of the animation."
}], "FormatNotes",
 CellID->15589],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default generates an animated GIF if the expression supplied is a list \
of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects, and a static GIF otherwise."
}], "FormatNotes",
 CellID->13161],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " with element ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " always generates a static GIF."
}], "FormatNotes",
 CellID->31172],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->19426],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Background\>\"", Cell[
    "background color shown in transparent image regions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageCount\>\"", Cell[
    "number of frames in an animated GIF", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28510],

Cell["\<\
Data representation elements for a static GIF or the frames of animated GIF \
files:\
\>", "FormatNotes",
 CellID->980792937],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorMap\>\"", Cell[
    "color reduction palette", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of RGB color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GlobalColorMap\>\"", Cell[TextData[{
     "color reduction palette used by all frames, given as a list of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "overall image size", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RawData\>\"", Cell[
    "array of color map indices", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->102417787],

Cell["\<\
For animated GIFs, the above data representation elements are taken to be \
lists of the respective expressions.\
\>", "FormatNotes",
 CellID->1201344862],

Cell["Metadata element:", "FormatNotes",
 CellID->361846540],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "user comments", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1114238489]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->10422],

Cell["General options:", "FormatNotes",
 CellID->30774],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "background color shown in transparent image regions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->8779],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->454840903],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the image as stored in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1616757048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula",
  ShowStringCharacters->False],
 " options:"
}], "FormatNotes",
 CellID->5764],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DitheringMethod\>\"", 
    "\"\<FloydSteinberg\>\"", Cell["\<\
dithering algorithm used for generating the color-reduction table\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TransparentColor\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "color to be interpreted as transparent", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->874],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).gif\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"\"\<TransparentColor\>\"", "->", 
     ButtonBox["White",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/White"]}]}], "]"}]], "InlineFormula"],
 " creates a GIF file in which all white pixels of the original image are \
taken to be transparent."
}], "FormatNotes",
 CellID->1867802010],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<DitheringMethod\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"\"\<FloydSteinberg\>\"", " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1364466339],

Cell["Detailed properties and settings for animated GIF:", "FormatNotes",
 CellID->14902],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DisplayDurations\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "display duration for each frame in seconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Interlaced\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the graphics are stored in interlaced format, allowing progressive \
rendering\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["AnimationRepetitions",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AnimationRepetitions"], Cell["", "TableText"]}],
     "1", Cell[
    "how many times the animation plays before stopping", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28255],

Cell["\<\
GIF supports color palettes of at most 256 colors, always storing colors at a \
resolution of 8 bits per color channel.\
\>", "FormatNotes",
 CellID->4460],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<DisplayDurations\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["d", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["d", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies the display durations for each frame in an animated GIF. ",
 "If the list of display durations is shorter than the number of frames, the \
sequence is repeated as necessary."
}], "FormatNotes",
 CellID->474],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<DisplayDurations\>\"", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the display time will vary on different viewer applications."
}], "FormatNotes",
 CellID->26821],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["AnimationRepetitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AnimationRepetitions"]], "InlineFormula"],
 ": "
}], "FormatNotes",
 CellID->5556],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell["\<\
positive integer, specifying how many times the animation should be played\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Infinity", Cell[
    "animation is repeated indefinitely", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1993]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26122],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30195]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->176385089],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Multimedia Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MultimediaFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->916592079],

Cell[TextData[{
 "Import a raster image from a GIF file, rendering it as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->765611898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/rose.gif\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7950],

Cell[BoxData[
 GraphicsBox[{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJztvXt8U+eZLjq2jCWFlrAP7dj4tg/YartP6yQmO/u0TXJCwMzunn3CJKTM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     "], {{0, 0}, {223, 164}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJzFlzmOFEEQRRvEATBxOUnfgSMgYXMVZmGTQOojYDCLiYGBgdFCLcQswNDs
wyIOwAyQ3Xpdypf1p8YjnFL16x8RGRm51NXrN6/duDj6ZxdGo0ujzi4vbDIe
VfZr9X5lYbsNX+oejc/mk/HtzWJPo37tVrEnq3dz9ObEvX+v2LPGP36THv7w
QbHn0T96/m+O3tzxzck7cX7nf0O8rnPnP/G7d4q9XM2T63ewvzDVxfWdqr6T
sTnx6z7p/Kf+ePtmYZFTD+Kk+jhP6zfWi72I9YOfPX+zQX3dp62ePoLXcadN
/er6zJr+Nbe+rluqzzTWB04fDek9PuvN914tLNaX8aX41if/KT79yf+Snv+Z
k1/S13WfrepU9+9sld8Q5x3O7346Pvkl//U6bf0n/vpwYdE/nKe562//cPQe
n/0n7j5K4yMPc48z5ce7+yPx5fwcxfN1fa3Yu8iX9ZzH/ROezs+tx8U+RD28
7uuO72wX+xT57k6xz5EzPvrC+xv5133Tjo8+T/r+c7CLD/f+ab059Un5bW8V
+xg59RnS133b8nQ+4L9eV238Wj9p9OeN7/rYf6ov68oc/3CPD95/j+niJz18
SA93fu4fn0+Mr/8e1I7P9w+Pz9zjS3r2H8dHn7jj+3yj/9Gbo2cfNHf8/vP3
i/aHrj/394p9jevHfEjv+V+O+3jQf1of5vZ/eFDsW9yfTn4X+x79m6f8U3+j
r8+lzv/pSbEf5+b2/+e02M9BTn+k8af1B0dvbv/mzE9an66f1xec/jW3f38f
wNEnTv7mjm/O/KT17fqZo0/ceq9f6/u/f+aq77Th6H1/5P6U7qfwdP9j//J3
FJz9KXH2p5QfvztPc84R3h0fvetH/fvvkV3/998ju/5J/tHD0/zjP81/4vaf
9PRB0ide3w+PmvnnfKrHN4t6z5+556++v84bTv9RH39fkF/i3L8Tt3/2AXPy
G+LOv77ftry+37b+3X9eP6wv8u//PjyO81ef3/OGu38d3zzpNzeKvY/c3xGp
f62H199p7fjS/Nf3p3n4fj1e5W/O/SRx+0/zi97c/s29/h0fnvTk53uq4/ue
7PlD7/ien8R9z3f+Kb71Q9zrz+cL6wRe9/189e71T32tJy4cP3DevQ8ljh84
+wc8xfc+lPTm/O6nOf7N8Z84v7NP8269/cDR+X+pv10f1p/PudT/iZOHOfHh
rq/15u5/+6e/fQ9K3P7N3V/kn+YP7j5K3PNn7vmjPt5HnT/fAc7feucHRz/E
nT/9A3f+zs/6+vvvuOHsr0P+0SeOn7Q+8M97Gh9P6/0/6z0PiQ/peXd9kv/6
+7jNz/Wz3vVLes+z4zuP5D+Nz09z9gmeyb/1zn+I84Sf75ns//O/eAO3Yg==

        "], #]]& ),
     ColorFunctionScaling->False], {0, 0}]},
  Background->None,
  ImageMargins->0.,
  ImageSize->{223, 164},
  PlotRange->{{0, 223}, {0, 164}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->286416386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318033230],

Cell[TextData[{
 "Read an animated GIF as a list of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->782119208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/cellularautomaton.gif\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1289346575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{}, GeometricTransformationBox[RasterBox[CompressedData["

1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{{}, 
           GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

             "], {{0, 0}, {64, 35}},
             ColorFunction->(Apply[RGBColor, 
               Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
             ColorFunctionScaling->False], {0, 0}]}, 
          GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{{{}, 
            GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

              "], {{0, 0}, {64, 35}},
              ColorFunction->(Apply[RGBColor, 
                Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
              ColorFunctionScaling->False], {0, 0}]}, 
           GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
             "], {{0, 0}, {64, 35}},
             ColorFunction->(Apply[RGBColor, 
               Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
             ColorFunctionScaling->False], {0, 0}]}, 
          GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{{{{}, 
             GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

               "], {{0, 0}, {64, 35}},
               ColorFunction->(Apply[RGBColor, 
                 Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
               ColorFunctionScaling->False], {0, 0}]}, 
            GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
              "], {{0, 0}, {64, 35}},
              ColorFunction->(Apply[RGBColor, 
                Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
              ColorFunctionScaling->False], {0, 0}]}, 
           GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
             "], {{0, 0}, {64, 35}},
             ColorFunction->(Apply[RGBColor, 
               Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
             ColorFunctionScaling->False], {0, 0}]}, 
          GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{{{{{}, 
              GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                "], {{0, 0}, {64, 35}},
                ColorFunction->(Apply[RGBColor, 
                  Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                ColorFunctionScaling->False], {0, 0}]}, 
             GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
               "], {{0, 0}, {64, 35}},
               ColorFunction->(Apply[RGBColor, 
                 Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
               ColorFunctionScaling->False], {0, 0}]}, 
            GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
              "], {{0, 0}, {64, 35}},
              ColorFunction->(Apply[RGBColor, 
                Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
              ColorFunctionScaling->False], {0, 0}]}, 
           GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
             "], {{0, 0}, {64, 35}},
             ColorFunction->(Apply[RGBColor, 
               Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
             ColorFunctionScaling->False], {0, 0}]}, 
          GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaOACoARBGA0EhsmiawMzhtE+pGMwK8cl27K
9cNNgPuBESGKKjRI9TNhDXMEm6BuyvVj9QSRbqeOfqSEgORgojUPAv1MuFIC
/fRj98RQ0s8E9z2ZuinXT4HTB4l+wgAAP1ESFQ==
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{{{{{{}, 
               GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                 "], {{0, 0}, {64, 35}},
                 ColorFunction->(Apply[RGBColor, 
                   Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                 ColorFunctionScaling->False], {0, 0}]}, 
              GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                "], {{0, 0}, {64, 35}},
                ColorFunction->(Apply[RGBColor, 
                  Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                ColorFunctionScaling->False], {0, 0}]}, 
             GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
               "], {{0, 0}, {64, 35}},
               ColorFunction->(Apply[RGBColor, 
                 Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
               ColorFunctionScaling->False], {0, 0}]}, 
            GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
              "], {{0, 0}, {64, 35}},
              ColorFunction->(Apply[RGBColor, 
                Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
              ColorFunctionScaling->False], {0, 0}]}, 
           GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
             "], {{0, 0}, {64, 35}},
             ColorFunction->(Apply[RGBColor, 
               Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
             ColorFunctionScaling->False], {0, 0}]}, 
          GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaOACoARBGA0EhsmiawMzhtE+pGMwK8cl27K
9cNNgPuBESGKKjRI9TNhDXMEm6BuyvVj9QSRbqeOfqSEgORgojUPAv1MuFIC
/fRj98RQ0s8E9z2ZuinXT4HTB4l+wgAAP1ESFQ==
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBcMAMIIAlIUsCpWBSSOpYqSqfoQJBJQjJAeZ
fuRAwKscl27K9cNNQAlzZC5Opw8S/Uw4kghCjIBuyvVj9QSRbqeOfuy5iWjN
g0A/E66UQD/9uIqkoaOfCe57MnVTrp8Cpw8S/YQBAOBPEeE=
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}], ",", 
   GraphicsBox[{{{{{{{{{{{{{}, 
                GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                  "], {{0, 0}, {64, 35}},
                  ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                  ColorFunctionScaling->False], {0, 0}]}, 
               GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                 "], {{0, 0}, {64, 35}},
                 ColorFunction->(Apply[RGBColor, 
                   Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                 ColorFunctionScaling->False], {0, 0}]}, 
              GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                "], {{0, 0}, {64, 35}},
                ColorFunction->(Apply[RGBColor, 
                  Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                ColorFunctionScaling->False], {0, 0}]}, 
             GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
               "], {{0, 0}, {64, 35}},
               ColorFunction->(Apply[RGBColor, 
                 Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
               ColorFunctionScaling->False], {0, 0}]}, 
            GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
              "], {{0, 0}, {64, 35}},
              ColorFunction->(Apply[RGBColor, 
                Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
              ColorFunctionScaling->False], {0, 0}]}, 
           GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
             "], {{0, 0}, {64, 35}},
             ColorFunction->(Apply[RGBColor, 
               Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
             ColorFunctionScaling->False], {0, 0}]}, 
          GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

            "], {{0, 0}, {64, 35}},
            ColorFunction->(Apply[RGBColor, 
              Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
            ColorFunctionScaling->False], {0, 0}]}, 
         GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
           "], {{0, 0}, {64, 35}},
           ColorFunction->(Apply[RGBColor, 
             Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
           ColorFunctionScaling->False], {0, 0}]}, 
        GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
          "], {{0, 0}, {64, 35}},
          ColorFunction->(Apply[RGBColor, 
            Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
          ColorFunctionScaling->False], {0, 0}]}, 
       GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaOACoARBGA0EhsmiawMzhtE+pGMwK8cl27K
9cNNgPuBESGKKjRI9TNhDXMEm6BuyvVj9QSRbqeOfqSEgORgojUPAv1MuFIC
/fRj98RQ0s8E9z2ZuinXT4HTB4l+wgAAP1ESFQ==
         "], {{0, 0}, {64, 35}},
         ColorFunction->(Apply[RGBColor, 
           Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
         ColorFunctionScaling->False], {0, 0}]}, 
      GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBcMAMIIAlIUsCpWBSSOpYqSqfoQJBJQjJAeZ
fuRAwKscl27K9cNNQAlzZC5Opw8S/Uw4kghCjIBuyvVj9QSRbqeOfuy5iWjN
g0A/E66UQD/9uIqkoaOfCe57MnVTrp8Cpw8S/YQBAOBPEeE=
        "], {{0, 0}, {64, 35}},
        ColorFunction->(Apply[RGBColor, 
          Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
        ColorFunctionScaling->False], {0, 0}]}, 
     GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBYwgAKOhbLgojAsVQ1LFOFj0IxkBUYJTObLh
WIOAXP3YPYFFOabTB4l+5EDAqxyXbsr1I8c5RkrAFuuDTj8TjiSCECOgm3L9
WD1BpNupox97biJa8yDQz4QrJdBPP64iaejoZ4L7nkzdlOunwOmDRD9hAADv
FhF7
       "], {{0, 0}, {64, 35}},
       ColorFunction->(Apply[RGBColor, 
         Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
       ColorFunctionScaling->False], {0, 0}]},
    Background->None,
    ImageSize->{64, 35},
    PlotRange->{{0, 64}, {0, 35}}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1188793399]
}, Open  ]],

Cell["Import this file as an animation:", "ExampleText",
 CellID->330125569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/cellularautomaton.gif\>\"", ",", " ", 
   "\"\<Animation\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2033227574],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 9, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 12, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$1756$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 12, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->Automatic]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                
                GraphicsBox[{{}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 2->
                
                GraphicsBox[{{{}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 3->
                
                GraphicsBox[{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 4->
                
                GraphicsBox[{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 5->
                
                GraphicsBox[{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 6->
                
                GraphicsBox[{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 7->
                
                GraphicsBox[{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 8->
                
                GraphicsBox[{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 9->
                
                GraphicsBox[{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 10->
                
                GraphicsBox[{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaOACoARBGA0EhsmiawMzhtE+pGMwK8cl27K
9cNNgPuBESGKKjRI9TNhDXMEm6BuyvVj9QSRbqeOfqSEgORgojUPAv1MuFIC
/fRj98RQ0s8E9z2ZuinXT4HTB4l+wgAAP1ESFQ==
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 11->
                
                GraphicsBox[{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaOACoARBGA0EhsmiawMzhtE+pGMwK8cl27K
9cNNgPuBESGKKjRI9TNhDXMEm6BuyvVj9QSRbqeOfqSEgORgojUPAv1MuFIC
/fRj98RQ0s8E9z2ZuinXT4HTB4l+wgAAP1ESFQ==
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBcMAMIIAlIUsCpWBSSOpYqSqfoQJBJQjJAeZ
fuRAwKscl27K9cNNQAlzZC5Opw8S/Uw4kghCjIBuyvVj9QSRbqeOfuy5iWjN
g0A/E66UQD/9uIqkoaOfCe57MnVTrp8Cpw8S/YQBAOBPEeE=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}], 12->
                
                GraphicsBox[{{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRsEwA4yMQ1s/YQAAngIThg==

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKRgFVASMEDJh+kAkUaB4E+gkD
AIx0E3g=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKBhNgBAEoayjqhxlBtm7K9VPg
9EGinzAAAGTeE2M=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUTAKEIARBKAUlE1X/XATwCySNQ8C
/Uxw35Opm3L9FDh9kOgnDAAZyhNF
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCUUA1wAgCUBZCbOjoRxjBCAck6aZc
P3ZPDCX9THDfk6mbcv0UOH2Q6CcMAMTvEyo=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIyCYQMYQQBKobHpoh9uApiFECPZBwOm
nwlrINBVP3ZPDCX9THDfk6mbcv0UOH2Q6CcMABhNEvw=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIwCKgFGIIAxkAWhNM31Q0xghFJobKJ9
QIl+uAkoDiZa8yDQz4Q1EOiqH7snhpJ+JrjvydRNuX4KnD5I9BMGALIAEuQ=

                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFAwOwAgCUArKZkLmwoUGqX6oYhgDWRBK
E9BNuX6sniDS7dTRDzcBxcFEax4E+plwpQT66cfuiaGknwnuezJ1U66fAqcP
Ev2EAQAJgBKN
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaNgFIAAIwhAGchCcB4TqiS19cNNYIQDZEOw
mDXY9EMVY/gTIUZAN+X6sXqCSLdTRz9SQkByMNGaB4F+JlwpgX76sXtiKOln
gvueTN2U66fA6YNEP2EAAELrEmk=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBaOACoARBGA0EhsmiawMzhtE+pGMwK8cl27K
9cNNgPuBESGKKjRI9TNhDXMEm6BuyvVj9QSRbqeOfqSEgORgojUPAv1MuFIC
/fRj98RQ0s8E9z2ZuinXT4HTB4l+wgAAP1ESFQ==
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBcMAMIIAlIUsCpWBSSOpYqSqfoQJBJQjJAeZ
fuRAwKscl27K9cNNQAlzZC5Opw8S/Uw4kghCjIBuyvVj9QSRbqeOfuy5iWjN
g0A/E66UQD/9uIqkoaOfCe57MnVTrp8Cpw8S/YQBAOBPEeE=
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGBQBmIHIGYaBYwgAKOhbLgojAsVQ1LFOFj0IxkBUYJTObLh
WIOAXP3YPYFFOabTB4l+5EDAqxyXbsr1I8c5RkrAFuuDTj8TjiSCECOgm3L9
WD1BpNupox97biJa8yDQz4QrJdBPP64iaejoZ4L7nkzdlOunwOmDRD9hAADv
FhF7
                    "], {{0, 0}, {64, 35}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{0., 0., 0., 1.}, {1., 1., 1., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{64, 35},
                 PlotRange->{{0, 64}, {0, 35}}]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$1756$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 12, 1}, 12, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {43.5, 48.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{2, 2}, {5, 0}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->2010288952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1470177982],

Cell["\<\
This rasterizes an arbitrary expression and converts the result to a GIF \
file:\
\>", "ExampleText",
 CellID->334501092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<expr.gif\>\"", ",", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->754],

Cell[BoxData["\<\"expr.gif\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->914443399]
}, Open  ]],

Cell["Import the resulting file:", "ExampleText",
 CellID->232919705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<expr.gif\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1966277101],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGCQBWI9IHYgF2hzMbEIQNlqEEqdmdNWgVESu3p+PRhLEUob
8FnJi9gjq9FSAQIU1VoqwlARBx1ufjsUEy1MgQBFtYWpDFTEQZVDDJfLMV2i
wWspJw10iTKrMR7VulCKncdanE3WREiURRdNrb4oh54DVmAj4SBsiy5opGiO
w4kamsK4XI8NSAmSotpUgxTVdAGGSkQCs4F26dAByBmUGMCPI+kOJ9W4Myhp
AACYKjxU
   "], {{0, 0}, {46, 29}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJyFlMtKQlEUhiV6gC50GTTpDRpUEET2CNEgokkQNA56gXqEovISNW/QoKAL
FaQlSoMmJR61LE+iJ7WTNq00cq3DP9j9gz7YfIMPNixYew8uLE0vtvl8vsnW
aW+dDmXV/9c+5cPfr+yR0QeUfTK6d1+UjN6pXJHRu5RrMnq3EiOjb24IMTJ6
jxInowe2hDgZvVdJkNGDASFBRg+HhBsy+u6OcEs250+SzfmTZHP+FNmczyKj
zygW2ZzfIqP3KWkyeigopMnos0qGjL4dFrJk9DnlgYyee1TI6PlnhYw+r+TJ
6EOKTUafUmwy+vqaYJPRDw8Em4x+fye8kM33VyCjLysFMvqwUiSjHx8JRTL6
iFIio1spoUQ299cho48qDtncX4eMfnoiOGRzv1/J5v6WyejZjFAmo48pFTL6
+ZlQIaN/fQoVsvk+qmT0i3OhSkZvfAtvZPRxxSWje/+dS0Z/ygkuGb3ZEFwy
+k9TeCejTyg1MnrkUqiR0b3/oEZG9/6DOhl9RamT0aMRoU5G/8+/7UAiJA==

      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{46, 29},
  PlotRange->{{0, 46}, {0, 29}}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1657229061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185926637],

Cell[TextData[{
 "Create an animated GIF by exporting a list of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->280281674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<disks.gif\>\"", ",", " ", 
   RowBox[{"Table", "[", " ", 
    RowBox[{
     RowBox[{"Graphics", "[", " ", 
      RowBox[{
       RowBox[{"Disk", "[", " ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.1", ",", "0"}], "}"}], ",", " ", 
         RowBox[{"Sin", "[", "t", "]"}]}], "]"}], ",", " ", 
       RowBox[{"ImageSize", " ", "\[Rule]", " ", "Tiny"}], ",", " ", 
       RowBox[{"PlotRange", " ", "\[Rule]", " ", "1.2"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "Pi", ",", "0.2"}], "}"}]}], " ", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1012],

Cell[BoxData["\<\"disks.gif\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->331224049]
}, Open  ]],

Cell["Import the resulting file as an animation:", "ExampleText",
 CellID->1623122270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<disks.gif\>\"", ",", " ", "\"\<Animation\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->977156569],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 16, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 16, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$22178$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 16, 1},
                   AnimationRate->Automatic,
                   AnimationRepetitions->1,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->0.]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                
                GraphicsBox[{{}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 2->
                
                GraphicsBox[{{{}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 3->
                
                GraphicsBox[{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 4->
                
                GraphicsBox[{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 5->
                
                GraphicsBox[{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 6->
                
                GraphicsBox[{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 7->
                
                GraphicsBox[{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 8->
                
                GraphicsBox[{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 9->
                
                GraphicsBox[{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 10->
                
                GraphicsBox[{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 11->
                
                GraphicsBox[{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmduOgjAQhp1FlJBwEAJEQGWR8ED7CGbv9/3vdvEQjdpz/U02/RJv/VKm
7UxnPg8/X4eP2Wz2ff6NDofD8S/ZtVWexlEYRnGaV+3O9v93dRbQHUFWd9YE
Q5N494ITXtIMNgx96T8XnPDL3thQzHmGiXlhZqkWIsNxLZW+YRPJGCaijaZi
zYj0M7y1jmG/kjdMrPbKil76O12IVEO/DVUVROFWTbFUVxAtVSS9xiqOK5H/
XHvlWFyIpAOvuKNuWUkq1voKIrlzslE4eo94UideOxgnIglFZaYgEl+QPTdb
yOALN3BhqiAqRMsQpiQxc8FCSnMFUclVDMbRmPC5hURjQ0HU8ByJHUfCUXRG
R/yKxynuajsKoprtyGw5MrbjoabVJWAqdrYURMyqvrXnaFkO4yv3CvPyze05
cpYjtedIWY7YniNmOQyz7C3MjKtZuT0jfKcD8a0QMUfsXcQZRNwliDsRcbcj
chQk1yJqhs6Wg1fxAmo4SC2KqKkRbwPIGwfxVht7qe4eD/GbE/F2hvQAIL0M
RE8G0luC9MgQvT5IzxLSe4X0kCG98BHR0x8hs4k/Kqm8uDCYsYyQWdGImHlN
DA2zJLI0uzvy8hnkmVfPUh0Oh+O9/AIcZ0Y/
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztjs0qhAEYRr/kAsSCKZRbkCWZayArZaGslatwCfNXZC0LPwvRKDZm5ydh
JhZfU5KZ4QIo3qeexdfJcAHfqbezOD31Tq2uL6wNJElS/LnB5C8+5sfEJuw+
Lmqw+7DYgbP7Xdh9UuzB7gVxDGf3dTj73znsPiIuYPdyKbiEs/81YPdKOWjA
7kPiCna/uRaw+6K4hd2XxB3s/nAvYPdqJWjC7suiBbvXqkELdn9+ErD7tEhh
9w2Rwu4H+0EKu8+INux+dBi0YfdR8QK7Nx+DV9j99CR4g91nRQd2//oMOrD7
hOjC7nOiC7uviB7sflYPerD79lbwDrv/z7+R97znvV//BtA9w+c=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 12->
                
                GraphicsBox[{{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmduOgjAQhp1FlJBwEAJEQGWR8ED7CGbv9/3vdvEQjdpz/U02/RJv/VKm
7UxnPg8/X4eP2Wz2ff6NDofD8S/ZtVWexlEYRnGaV+3O9v93dRbQHUFWd9YE
Q5N494ITXtIMNgx96T8XnPDL3thQzHmGiXlhZqkWIsNxLZW+YRPJGCaijaZi
zYj0M7y1jmG/kjdMrPbKil76O12IVEO/DVUVROFWTbFUVxAtVSS9xiqOK5H/
XHvlWFyIpAOvuKNuWUkq1voKIrlzslE4eo94UideOxgnIglFZaYgEl+QPTdb
yOALN3BhqiAqRMsQpiQxc8FCSnMFUclVDMbRmPC5hURjQ0HU8ByJHUfCUXRG
R/yKxynuajsKoprtyGw5MrbjoabVJWAqdrYURMyqvrXnaFkO4yv3CvPyze05
cpYjtedIWY7YniNmOQyz7C3MjKtZuT0jfKcD8a0QMUfsXcQZRNwliDsRcbcj
chQk1yJqhs6Wg1fxAmo4SC2KqKkRbwPIGwfxVht7qe4eD/GbE/F2hvQAIL0M
RE8G0luC9MgQvT5IzxLSe4X0kCG98BHR0x8hs4k/Kqm8uDCYsYyQWdGImHlN
DA2zJLI0uzvy8hnkmVfPUh0Oh+O9/AIcZ0Y/
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztjs0qhAEYRr/kAsSCKZRbkCWZayArZaGslatwCfNXZC0LPwvRKDZm5ydh
JhZfU5KZ4QIo3qeexdfJcAHfqbezOD31Tq2uL6wNJElS/LnB5C8+5sfEJuw+
Lmqw+7DYgbP7Xdh9UuzB7gVxDGf3dTj73znsPiIuYPdyKbiEs/81YPdKOWjA
7kPiCna/uRaw+6K4hd2XxB3s/nAvYPdqJWjC7suiBbvXqkELdn9+ErD7tEhh
9w2Rwu4H+0EKu8+INux+dBi0YfdR8QK7Nx+DV9j99CR4g91nRQd2//oMOrD7
hOjC7nOiC7uviB7sflYPerD79lbwDrv/z7+R97znvV//BtA9w+c=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmctugzAQRRlIIgTh/QghgYhfyidE3ff/dxVJ0yfFYw9cdeEjseUIbI/H
18Pt9XpzHcd5eX8Gi8VisVjWp2uqPEuiKMnyqumWf39fpwF9I0jrfknDIfZo
Ai8+LCS4lP6U4IFfXhZQVLu/DSO7Smpow3nDSNiKFIWrVhC5hbnhvOcYRvZn
Q8VpZqx/4p+MFMctX0G0PZooNjoKoo2+5KT1Ffcv0f1dZ42xeOJrDjx7Rn1l
r6UoTBREOuukZS2937gaK55RQKYJ2YrKVEHELZAXRaWdY8cs9aW5gqjkOQyW
xic+S3GQKIhY228sc8QMRT/ZHvDxGN1KLVMQ1WpHKnWkakegfss8gVLRSRVE
yja1kTsalUNQq54oa1Yud+QqRyZ3ZCpHInckKkckd0T/wYH4V4gxR8xdxBpE
1BJETUTUdsgehdhrET0DoveB9HCIXhTSUyPOBogzDuSsBjlzIs7OkAwAkmUg
MhlItgTJyCBZHySzHBDZ6wDJkAdEFj5AMv2R1e8m7qx/x/Jg7bsii8VisVg+
eANXXE6S
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkDlqQgEURT/iApzAIGncgVVaXYJYWgass4O4iDgX2toK2tj4QUhai0ic
IiJiUJyWEN+FW3wuEtvAP/A4xaneTT6/5AoBx3Ey1ws6f3FJP4Ca2NvbYvYw
6IjZE6AvZg8BV8weBUMxe+nNGIrZqxXjXcweBx9i9iwYidlj4FPMXikbYzF7
rWp8idmnEyBmX8yBmP0RLMTsKbASs0fAWuz9fyNm73WNjZj9CWzF3n1+xOyN
urETs+fBXsw+nxl7sXe/g5h9+W0cxeyv4CRmbzWNk5i9CM5idndgnMXs9/kW
fve73/9z/wVyJY/K
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 13->
                
                GraphicsBox[{{{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmduOgjAQhp1FlJBwEAJEQGWR8ED7CGbv9/3vdvEQjdpz/U02/RJv/VKm
7UxnPg8/X4eP2Wz2ff6NDofD8S/ZtVWexlEYRnGaV+3O9v93dRbQHUFWd9YE
Q5N494ITXtIMNgx96T8XnPDL3thQzHmGiXlhZqkWIsNxLZW+YRPJGCaijaZi
zYj0M7y1jmG/kjdMrPbKil76O12IVEO/DVUVROFWTbFUVxAtVSS9xiqOK5H/
XHvlWFyIpAOvuKNuWUkq1voKIrlzslE4eo94UideOxgnIglFZaYgEl+QPTdb
yOALN3BhqiAqRMsQpiQxc8FCSnMFUclVDMbRmPC5hURjQ0HU8ByJHUfCUXRG
R/yKxynuajsKoprtyGw5MrbjoabVJWAqdrYURMyqvrXnaFkO4yv3CvPyze05
cpYjtedIWY7YniNmOQyz7C3MjKtZuT0jfKcD8a0QMUfsXcQZRNwliDsRcbcj
chQk1yJqhs6Wg1fxAmo4SC2KqKkRbwPIGwfxVht7qe4eD/GbE/F2hvQAIL0M
RE8G0luC9MgQvT5IzxLSe4X0kCG98BHR0x8hs4k/Kqm8uDCYsYyQWdGImHlN
DA2zJLI0uzvy8hnkmVfPUh0Oh+O9/AIcZ0Y/
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztjs0qhAEYRr/kAsSCKZRbkCWZayArZaGslatwCfNXZC0LPwvRKDZm5ydh
JhZfU5KZ4QIo3qeexdfJcAHfqbezOD31Tq2uL6wNJElS/LnB5C8+5sfEJuw+
Lmqw+7DYgbP7Xdh9UuzB7gVxDGf3dTj73znsPiIuYPdyKbiEs/81YPdKOWjA
7kPiCna/uRaw+6K4hd2XxB3s/nAvYPdqJWjC7suiBbvXqkELdn9+ErD7tEhh
9w2Rwu4H+0EKu8+INux+dBi0YfdR8QK7Nx+DV9j99CR4g91nRQd2//oMOrD7
hOjC7nOiC7uviB7sflYPerD79lbwDrv/z7+R97znvV//BtA9w+c=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmctugzAQRRlIIgTh/QghgYhfyidE3ff/dxVJ0yfFYw9cdeEjseUIbI/H
18Pt9XpzHcd5eX8Gi8VisVjWp2uqPEuiKMnyqumWf39fpwF9I0jrfknDIfZo
Ai8+LCS4lP6U4IFfXhZQVLu/DSO7Smpow3nDSNiKFIWrVhC5hbnhvOcYRvZn
Q8VpZqx/4p+MFMctX0G0PZooNjoKoo2+5KT1Ffcv0f1dZ42xeOJrDjx7Rn1l
r6UoTBREOuukZS2937gaK55RQKYJ2YrKVEHELZAXRaWdY8cs9aW5gqjkOQyW
xic+S3GQKIhY228sc8QMRT/ZHvDxGN1KLVMQ1WpHKnWkakegfss8gVLRSRVE
yja1kTsalUNQq54oa1Yud+QqRyZ3ZCpHInckKkckd0T/wYH4V4gxR8xdxBpE
1BJETUTUdsgehdhrET0DoveB9HCIXhTSUyPOBogzDuSsBjlzIs7OkAwAkmUg
MhlItgTJyCBZHySzHBDZ6wDJkAdEFj5AMv2R1e8m7qx/x/Jg7bsii8VisVg+
eANXXE6S
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkDlqQgEURT/iApzAIGncgVVaXYJYWgass4O4iDgX2toK2tj4QUhai0ic
IiJiUJyWEN+FW3wuEtvAP/A4xaneTT6/5AoBx3Ey1ws6f3FJP4Ca2NvbYvYw
6IjZE6AvZg8BV8weBUMxe+nNGIrZqxXjXcweBx9i9iwYidlj4FPMXikbYzF7
rWp8idmnEyBmX8yBmP0RLMTsKbASs0fAWuz9fyNm73WNjZj9CWzF3n1+xOyN
urETs+fBXsw+nxl7sXe/g5h9+W0cxeyv4CRmbzWNk5i9CM5idndgnMXs9/kW
fve73/9z/wVyJY/K
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqhEAMhk3RVUdRxPXACAt9pT7C0vu+/13X3Z5QqybO/BSaD/Z2P8xk
Mkmer28v16cgCF4/fhdFURRFURRPDH0/+Pt3WxcmoTuJKWrrXlClNCGtnGra
PJwaRsK8dWXosiXBg6xzoiij3xVEUXncYM2aYcQcPZYm3lIQxc0hxfm0rSA6
nY8oFtNpTiiXNLu+4v4l0nDZHWfxSSw8+M2M+okRKUqOgqgSKLrVqzcnEtz4
lQKyTMZWtFwFEbtA5nxHzlRYvoJCZv5WAgc3tWav3h5SlkISqhusYNUyR81x
FDJHwXGwStU3rKKVyBwJxyFTEDEUg9TBaFN7qaP/Ww5ErBBnDsldxB1E1BJE
TUTUdsQbBXlrRcHi9ryA3gfSwyF6UUhPjZgNIDMOZFZDzJyQ2RmyA4DsMiA7
mRvV+m5Jdi+mAHZkl3HXt2xwt+sb8b+zfGh8716/8LtDVhRFURTlv/IOxF59
Sw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJyNkr0KQXEchk9yAQzkI8VFGOUeDBabMssqyWilfF6AwRVYxGo8iuUQZziJ
jo9L4P/WO5zexFO/nuGpd/rlqvVSLWRZVvZzYesXr2IEdMTsCdAVB/tYzB4H
MzF7CszFwf2FmD0DlmL2JNiI2aPAFrMPB4admL0M9mL2NHDE7BXgiNkbwBWz
93sGV8y+tQ2umD0GPDF7Hnhi9vHIcBGzTyeGq5i9CW5i9hbwxezHg8EXB//j
LmYvgLuYvQ0eYvb1yvAUs59PhqeY/T9/43d/A/jYNPk=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 14->
                
                GraphicsBox[{{{{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmduOgjAQhp1FlJBwEAJEQGWR8ED7CGbv9/3vdvEQjdpz/U02/RJv/VKm
7UxnPg8/X4eP2Wz2ff6NDofD8S/ZtVWexlEYRnGaV+3O9v93dRbQHUFWd9YE
Q5N494ITXtIMNgx96T8XnPDL3thQzHmGiXlhZqkWIsNxLZW+YRPJGCaijaZi
zYj0M7y1jmG/kjdMrPbKil76O12IVEO/DVUVROFWTbFUVxAtVSS9xiqOK5H/
XHvlWFyIpAOvuKNuWUkq1voKIrlzslE4eo94UideOxgnIglFZaYgEl+QPTdb
yOALN3BhqiAqRMsQpiQxc8FCSnMFUclVDMbRmPC5hURjQ0HU8ByJHUfCUXRG
R/yKxynuajsKoprtyGw5MrbjoabVJWAqdrYURMyqvrXnaFkO4yv3CvPyze05
cpYjtedIWY7YniNmOQyz7C3MjKtZuT0jfKcD8a0QMUfsXcQZRNwliDsRcbcj
chQk1yJqhs6Wg1fxAmo4SC2KqKkRbwPIGwfxVht7qe4eD/GbE/F2hvQAIL0M
RE8G0luC9MgQvT5IzxLSe4X0kCG98BHR0x8hs4k/Kqm8uDCYsYyQWdGImHlN
DA2zJLI0uzvy8hnkmVfPUh0Oh+O9/AIcZ0Y/
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztjs0qhAEYRr/kAsSCKZRbkCWZayArZaGslatwCfNXZC0LPwvRKDZm5ydh
JhZfU5KZ4QIo3qeexdfJcAHfqbezOD31Tq2uL6wNJElS/LnB5C8+5sfEJuw+
Lmqw+7DYgbP7Xdh9UuzB7gVxDGf3dTj73znsPiIuYPdyKbiEs/81YPdKOWjA
7kPiCna/uRaw+6K4hd2XxB3s/nAvYPdqJWjC7suiBbvXqkELdn9+ErD7tEhh
9w2Rwu4H+0EKu8+INux+dBi0YfdR8QK7Nx+DV9j99CR4g91nRQd2//oMOrD7
hOjC7nOiC7uviB7sflYPerD79lbwDrv/z7+R97znvV//BtA9w+c=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmctugzAQRRlIIgTh/QghgYhfyidE3ff/dxVJ0yfFYw9cdeEjseUIbI/H
18Pt9XpzHcd5eX8Gi8VisVjWp2uqPEuiKMnyqumWf39fpwF9I0jrfknDIfZo
Ai8+LCS4lP6U4IFfXhZQVLu/DSO7Smpow3nDSNiKFIWrVhC5hbnhvOcYRvZn
Q8VpZqx/4p+MFMctX0G0PZooNjoKoo2+5KT1Ffcv0f1dZ42xeOJrDjx7Rn1l
r6UoTBREOuukZS2937gaK55RQKYJ2YrKVEHELZAXRaWdY8cs9aW5gqjkOQyW
xic+S3GQKIhY228sc8QMRT/ZHvDxGN1KLVMQ1WpHKnWkakegfss8gVLRSRVE
yja1kTsalUNQq54oa1Yud+QqRyZ3ZCpHInckKkckd0T/wYH4V4gxR8xdxBpE
1BJETUTUdsgehdhrET0DoveB9HCIXhTSUyPOBogzDuSsBjlzIs7OkAwAkmUg
MhlItgTJyCBZHySzHBDZ6wDJkAdEFj5AMv2R1e8m7qx/x/Jg7bsii8VisVg+
eANXXE6S
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkDlqQgEURT/iApzAIGncgVVaXYJYWgass4O4iDgX2toK2tj4QUhai0ic
IiJiUJyWEN+FW3wuEtvAP/A4xaneTT6/5AoBx3Ey1ws6f3FJP4Ca2NvbYvYw
6IjZE6AvZg8BV8weBUMxe+nNGIrZqxXjXcweBx9i9iwYidlj4FPMXikbYzF7
rWp8idmnEyBmX8yBmP0RLMTsKbASs0fAWuz9fyNm73WNjZj9CWzF3n1+xOyN
urETs+fBXsw+nxl7sXe/g5h9+W0cxeyv4CRmbzWNk5i9CM5idndgnMXs9/kW
fve73/9z/wVyJY/K
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqhEAMhk3RVUdRxPXACAt9pT7C0vu+/13X3Z5QqybO/BSaD/Z2P8xk
Mkmer28v16cgCF4/fhdFURRFURRPDH0/+Pt3WxcmoTuJKWrrXlClNCGtnGra
PJwaRsK8dWXosiXBg6xzoiij3xVEUXncYM2aYcQcPZYm3lIQxc0hxfm0rSA6
nY8oFtNpTiiXNLu+4v4l0nDZHWfxSSw8+M2M+okRKUqOgqgSKLrVqzcnEtz4
lQKyTMZWtFwFEbtA5nxHzlRYvoJCZv5WAgc3tWav3h5SlkISqhusYNUyR81x
FDJHwXGwStU3rKKVyBwJxyFTEDEUg9TBaFN7qaP/Ww5ErBBnDsldxB1E1BJE
TUTUdsQbBXlrRcHi9ryA3gfSwyF6UUhPjZgNIDMOZFZDzJyQ2RmyA4DsMiA7
mRvV+m5Jdi+mAHZkl3HXt2xwt+sb8b+zfGh8716/8LtDVhRFURTlv/IOxF59
Sw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJyNkr0KQXEchk9yAQzkI8VFGOUeDBabMssqyWilfF6AwRVYxGo8iuUQZziJ
jo9L4P/WO5zexFO/nuGpd/rlqvVSLWRZVvZzYesXr2IEdMTsCdAVB/tYzB4H
MzF7CszFwf2FmD0DlmL2JNiI2aPAFrMPB4admL0M9mL2NHDE7BXgiNkbwBWz
93sGV8y+tQ2umD0GPDF7Hnhi9vHIcBGzTyeGq5i9CW5i9hbwxezHg8EXB//j
LmYvgLuYvQ0eYvb1yvAUs59PhqeY/T9/43d/A/jYNPk=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMsOgjAQRZlCkIa3EPb+kp9g3Pv/O1ExGgGdtOUmJvckXZ90Op3O9HC6
HE8miqLztAZCCCGEEELIi74ucmvzou43ErRZYmTCJFkb3lCm8kFahjU0M8Pd
0gRUWLOkGENmQxm63bLhxq4LotjH6wqReB9A0X1VjJIAO/kSqClc3gr7SyHi
e/DNSka9YzxTePFefJJ6KSqNQqTafBt+G2l1ChGPAplpHZm7I9E6EmdFr0jc
B8b50aq1CpHa1VHoHYWrI9c7cleHolY9ca5ZCAciVogzR+Qu4g4iagmkJiJq
O+KNGkqdw+utRfQMkN4H0cNBelFIT42YDSAzzoCY1QbIzDlSzWdnv9u9yPZ/
AHc2/8sghBBCCCHkv7gCd7rl6A==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkj0OQVEYRG/EAhQ0CmEl9mAJEjXRqFiDv4S1sAOFXFri3UjkBfE8JRXf
JFNN/CzASSanOO1U6s1aI+OcK7+Wdd9Iq3kwFrMXwULMXgJLMXsOeDH7oG94
MftoaKzF7C0QxOwrbwQx+y01gpi9DfZi9gI4iNk7IBazTydGLGZ/3I2jmH0+
M05i9u3GOIvZu+AiZu+BRMwe7YxEzB4i4ypm/83v//vvn/sTNgQrqw==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 15->
                
                GraphicsBox[{{{{{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmduOgjAQhp1FlJBwEAJEQGWR8ED7CGbv9/3vdvEQjdpz/U02/RJv/VKm
7UxnPg8/X4eP2Wz2ff6NDofD8S/ZtVWexlEYRnGaV+3O9v93dRbQHUFWd9YE
Q5N494ITXtIMNgx96T8XnPDL3thQzHmGiXlhZqkWIsNxLZW+YRPJGCaijaZi
zYj0M7y1jmG/kjdMrPbKil76O12IVEO/DVUVROFWTbFUVxAtVSS9xiqOK5H/
XHvlWFyIpAOvuKNuWUkq1voKIrlzslE4eo94UideOxgnIglFZaYgEl+QPTdb
yOALN3BhqiAqRMsQpiQxc8FCSnMFUclVDMbRmPC5hURjQ0HU8ByJHUfCUXRG
R/yKxynuajsKoprtyGw5MrbjoabVJWAqdrYURMyqvrXnaFkO4yv3CvPyze05
cpYjtedIWY7YniNmOQyz7C3MjKtZuT0jfKcD8a0QMUfsXcQZRNwliDsRcbcj
chQk1yJqhs6Wg1fxAmo4SC2KqKkRbwPIGwfxVht7qe4eD/GbE/F2hvQAIL0M
RE8G0luC9MgQvT5IzxLSe4X0kCG98BHR0x8hs4k/Kqm8uDCYsYyQWdGImHlN
DA2zJLI0uzvy8hnkmVfPUh0Oh+O9/AIcZ0Y/
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztjs0qhAEYRr/kAsSCKZRbkCWZayArZaGslatwCfNXZC0LPwvRKDZm5ydh
JhZfU5KZ4QIo3qeexdfJcAHfqbezOD31Tq2uL6wNJElS/LnB5C8+5sfEJuw+
Lmqw+7DYgbP7Xdh9UuzB7gVxDGf3dTj73znsPiIuYPdyKbiEs/81YPdKOWjA
7kPiCna/uRaw+6K4hd2XxB3s/nAvYPdqJWjC7suiBbvXqkELdn9+ErD7tEhh
9w2Rwu4H+0EKu8+INux+dBi0YfdR8QK7Nx+DV9j99CR4g91nRQd2//oMOrD7
hOjC7nOiC7uviB7sflYPerD79lbwDrv/z7+R97znvV//BtA9w+c=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmctugzAQRRlIIgTh/QghgYhfyidE3ff/dxVJ0yfFYw9cdeEjseUIbI/H
18Pt9XpzHcd5eX8Gi8VisVjWp2uqPEuiKMnyqumWf39fpwF9I0jrfknDIfZo
Ai8+LCS4lP6U4IFfXhZQVLu/DSO7Smpow3nDSNiKFIWrVhC5hbnhvOcYRvZn
Q8VpZqx/4p+MFMctX0G0PZooNjoKoo2+5KT1Ffcv0f1dZ42xeOJrDjx7Rn1l
r6UoTBREOuukZS2937gaK55RQKYJ2YrKVEHELZAXRaWdY8cs9aW5gqjkOQyW
xic+S3GQKIhY228sc8QMRT/ZHvDxGN1KLVMQ1WpHKnWkakegfss8gVLRSRVE
yja1kTsalUNQq54oa1Yud+QqRyZ3ZCpHInckKkckd0T/wYH4V4gxR8xdxBpE
1BJETUTUdsgehdhrET0DoveB9HCIXhTSUyPOBogzDuSsBjlzIs7OkAwAkmUg
MhlItgTJyCBZHySzHBDZ6wDJkAdEFj5AMv2R1e8m7qx/x/Jg7bsii8VisVg+
eANXXE6S
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkDlqQgEURT/iApzAIGncgVVaXYJYWgass4O4iDgX2toK2tj4QUhai0ic
IiJiUJyWEN+FW3wuEtvAP/A4xaneTT6/5AoBx3Ey1ws6f3FJP4Ca2NvbYvYw
6IjZE6AvZg8BV8weBUMxe+nNGIrZqxXjXcweBx9i9iwYidlj4FPMXikbYzF7
rWp8idmnEyBmX8yBmP0RLMTsKbASs0fAWuz9fyNm73WNjZj9CWzF3n1+xOyN
urETs+fBXsw+nxl7sXe/g5h9+W0cxeyv4CRmbzWNk5i9CM5idndgnMXs9/kW
fve73/9z/wVyJY/K
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqhEAMhk3RVUdRxPXACAt9pT7C0vu+/13X3Z5QqybO/BSaD/Z2P8xk
Mkmer28v16cgCF4/fhdFURRFURRPDH0/+Pt3WxcmoTuJKWrrXlClNCGtnGra
PJwaRsK8dWXosiXBg6xzoiij3xVEUXncYM2aYcQcPZYm3lIQxc0hxfm0rSA6
nY8oFtNpTiiXNLu+4v4l0nDZHWfxSSw8+M2M+okRKUqOgqgSKLrVqzcnEtz4
lQKyTMZWtFwFEbtA5nxHzlRYvoJCZv5WAgc3tWav3h5SlkISqhusYNUyR81x
FDJHwXGwStU3rKKVyBwJxyFTEDEUg9TBaFN7qaP/Ww5ErBBnDsldxB1E1BJE
TUTUdsQbBXlrRcHi9ryA3gfSwyF6UUhPjZgNIDMOZFZDzJyQ2RmyA4DsMiA7
mRvV+m5Jdi+mAHZkl3HXt2xwt+sb8b+zfGh8716/8LtDVhRFURTlv/IOxF59
Sw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJyNkr0KQXEchk9yAQzkI8VFGOUeDBabMssqyWilfF6AwRVYxGo8iuUQZziJ
jo9L4P/WO5zexFO/nuGpd/rlqvVSLWRZVvZzYesXr2IEdMTsCdAVB/tYzB4H
MzF7CszFwf2FmD0DlmL2JNiI2aPAFrMPB4admL0M9mL2NHDE7BXgiNkbwBWz
93sGV8y+tQ2umD0GPDF7Hnhi9vHIcBGzTyeGq5i9CW5i9hbwxezHg8EXB//j
LmYvgLuYvQ0eYvb1yvAUs59PhqeY/T9/43d/A/jYNPk=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMsOgjAQRZlCkIa3EPb+kp9g3Pv/O1ExGgGdtOUmJvckXZ90Op3O9HC6
HE8miqLztAZCCCGEEELIi74ucmvzou43ErRZYmTCJFkb3lCm8kFahjU0M8Pd
0gRUWLOkGENmQxm63bLhxq4LotjH6wqReB9A0X1VjJIAO/kSqClc3gr7SyHi
e/DNSka9YzxTePFefJJ6KSqNQqTafBt+G2l1ChGPAplpHZm7I9E6EmdFr0jc
B8b50aq1CpHa1VHoHYWrI9c7cleHolY9ca5ZCAciVogzR+Qu4g4iagmkJiJq
O+KNGkqdw+utRfQMkN4H0cNBelFIT42YDSAzzoCY1QbIzDlSzWdnv9u9yPZ/
AHc2/8sghBBCCCHkv7gCd7rl6A==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkj0OQVEYRG/EAhQ0CmEl9mAJEjXRqFiDv4S1sAOFXFri3UjkBfE8JRXf
JFNN/CzASSanOO1U6s1aI+OcK7+Wdd9Iq3kwFrMXwULMXgJLMXsOeDH7oG94
MftoaKzF7C0QxOwrbwQx+y01gpi9DfZi9gI4iNk7IBazTydGLGZ/3I2jmH0+
M05i9u3GOIvZu+AiZu+BRMwe7YxEzB4i4ypm/83v//vvn/sTNgQrqw==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1ksKwyAUQFGfqBFDxCyhW+oSQufd/6xfCk0jdPDyoOUeyPiixs9hOR8X
75w7Pb8ZAAAAAIBv1JJjCDGXuldhTPKSxj0KbZA3Q1NPTEFWwqSd8OuEiNeN
tI9R3EeiOl3DVuK6JoqJcTshovh3pV4jqSVqLyGithlLv1G0GrnfyFqN2G9E
rcbm5ngIv9SwmCuLNbf4dy32oMVZYnImWpztJneUxV1r8mYwefvMFm+4m/3f
ogAAAACAP3EBelt02w==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJxTTMoPSmViYGBQAGIWBkLgg70YGCzDoGHyImCwBYNG1b8Ng4bJT5kMAocx
aJi8FBicwqBh8oJgcBGDhskLg8FlDBomv3EDCDzAoGHyFy+AwAMMGiZ/7SoI
PMWgYfLfvoLAUwwaJv/zBwi8wKBh8lZg8AqDhslHgcErDBomP3cOCLzBoGHy
xNG408eo/NCWBwC3aND0
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}], 16->
                
                GraphicsBox[{{{{{{{{{{{{{{{{{}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztwzENACAQBLADJ1hCwof9/W8sqCBt0lW9ayY57wAAAAAAAAAAAIAPXLF/
KYE=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[{{1., 1., 1., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1UkKwzAQBVG1Jku+Ra6UI5jsff9dYjDGFmT5GwT1QOsCDa3Xtr+3GEL4
nGsFAAAAAAD4o9XapIFesv3k0mWJJdkpLapEtEvURHqymyTZrmIPRdHIz0YW
JJoNBFe4jo06Z8NjrzzO3OXuerxBj1niMhNdZvtB/kcBAAAAAIApfQHbSYGE

                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.058823529411764705`, 
                    0.058823529411764705`, 0.058823529411764705`, 1.}, {
                    0.1450980392156863, 0.1450980392156863, 
                    0.1450980392156863, 1.}, {0.17647058823529413`, 
                    0.17647058823529413`, 0.17647058823529413`, 1.}, {
                    0.5607843137254902, 0.5607843137254902, 
                    0.5607843137254902, 1.}, {0.8, 0.8, 0.8, 1.}, {
                    0.8352941176470589, 0.8352941176470589, 
                    0.8352941176470589, 1.}, {0.9137254901960784, 
                    0.9137254901960784, 0.9137254901960784, 1.}, {
                    0.9725490196078431, 0.9725490196078431, 
                    0.9725490196078431, 1.}, {1., 1., 1., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}, {0., 0., 0., 
                    1.}, {0., 0., 0., 1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt10sKgzAUhWGvJEbNQ3AH3VKXIJ13/7OiOBC1cdCbQ0vPB45/TDReb9Pz
PtVVVT3WayQiIiIiIvpvQwohDQUD3llZWOfLFDojG6bTL8RGdpqonOjrfUKk
7lUT7bEwaxUT/XlCRO9O4slCrcultieH7d5svFKie58QUXqETa5hVBI+lxBR
eeNdvuE0GjbfsAqJIZ8QUTiF01Ujfd4IV43wGw3EWiH2HPHsQt5BxFmCOBMh
ZzviGwX51iJmBsjsA5nhILPoiJipZ+X/DRbF/3GIiIiIiIi+2QvP94pb
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkjEOAWEYRP9sHGCzWoU9hdIZ6LQStavYirDJugO1/aNxBb9OtrAU1hGY
L5lqIpQKL5m84rWTjqfDSeSc677Wcp949DtGLmaPDS9mz2bAi9kTYy9mX8zB
Qcw+MoKYfWCcxextoxKzbzegErP3jIuYPRxBLWY/BXAVs6+W4CZmL3fgLmZf
F6ARs/sSNGL27/z+P//+2/0Jt2fl9w==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMtuhDAMRTGvGSRrQEAisewv9RNG3ff/d22mVVGnvGIHb3qPxJYjJ7YT
5+X+/nrPsyx7+/4mAAAAAAAAUuDGrmVuu9GdJOibmn6omz65wHFJT5ScNBrP
xbMhULBPphiqJUOgGhIpOF9TEOWcwuCv64bAVb9e/rKtILqoHTtRPCJRKnhf
QXRTKYaN7Z7JNdnlV5P2N5Vi3w+tVECewW6xupcoxG3lcBiKQP60wXVKoaI/
riAStvomxtHIHPX+n2dqkcLFKIhEmTXGOUaJo4tzdBJHG+doJY6ICgyIqtDC
YbFWFntukbsWNWjRS0x6okVvtzijTM5aizuDxd3H5A5ncRc9uFraOcdgNpim
/RknwSB1/qz2yW1r5tTNNzMGs7PJG8Bk8Zbx4PQ3mS9Of1sCAAAAAAD/hQ/L
tjAq
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJzVkkEKQWEURv9kAaTMiGUY2YMlKGNlA7bw5CliDaIYGiljMqAMXHqFif/Z
AffqG7y+xNSp2xmc2dct15u1Rso5V3pd2n0jrmaMgIxeNMZk9IKxIKPnjCUZ
PW+syOhhV9mS0fc7g4w+GioHMnonUISMPp0oQkbfrBUhoz9iRcjoWeNERm8Z
ZzJ6L1QiMvp8pkTk5H4XMvqgr1zJ6BXjRk7+z52M/saT0duGJ6PLUfFk9N/8
if/vTwdvNr4=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqg0AQhjMVRY0sERTRRlDEF+ojhN73/e+azYEesHFm1J9A5wNv/djT
7Ozfnz7eTi+73e799o2GYRiGYfw32rrI0iSOkzQr6nb9/w+Ni+gHkWuGNQ1d
HtIEYd6tZnDBlMETuFUsffGn4WIp+sWK1/iRwRMfFyqqh4O4DaVapDjMGzwH
vWHY8xREe/U2ZivOEqWCOVFLpquSKIg0C39k7KjvBPIt3M+ei9/E4sNYSBVE
hVDRCWfKEwhrl5MriNzmw5AOJNcoiHKBYpi8kuYJBSWl0SmIGr5DteIewapH
83+bJmIrWq2CiN0S1XpHzXUo6sidkuvI9I6M60j1jpTrSPSOhOsQXx1fxM/k
QMwVYs0Re3fBGWTf6YhagqiJiNoOuaMQdy2iZ0D0PpAeDtGLQnpqxNsA8sZB
vNUgb07I2xmSAUCyDEQmM0KypfMW3j4jg2R9IyKzvFg2z14922fIV9q6vGfh
5RZZuGEYhmEYT8onYmQeRw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkr9KglEYhz+kC4iMaBDCW2horWsQaXEQAufm6CbaMhPqIhqbbGpr8E+i
oIgE8oFfQ01F2fnBbzg8RELr98DhGR7O8L7nlE9OK41CkiRHP2cj+YvXw01x
AbvviibsXhJt2H1b3MHx/XvYfUt0YPeieIDdW1eBRzie/wl2r4ou7L4j+rD7
sejD7s3LwAB2fx4IOJ5vCLu3rwMj2H08ErD77U1gArtPJwKO9zuF3ffFDHav
iBns3usG5rD7+1tgDrsfiBfY/Uws4Hj/C9i9JlLY/VykcPx+Kez++RFIYffv
r8ASdt8TGexeFxkc/48Mdl/Pv5H3vOf9P30FEevUKA==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmcFugzAMQKu5oBIVIQqCwgAVIX5on1D1vv+/rdBVRe3qOHGwdsiTuPJE
nNjB7s/fX+ePzWZz+X1Gj8fj8fx/+n69dw91niUqhCuhSrK8HhwLujwN4Ikg
zTtngqFKn99/J6mcfE1fqneGCVXy41NFmGEiqniGNtYZ5hVrGIryJdB/sy1t
DacDzTBxOFkpuj1dAbC32cctup1eUa25YmemANiZSjrDr5i/xGy5TkaxuLM3
CrzBjlpyMFAc7RQAR7Ki2do6AnLcE1sFQExUVPYKAFqC7LWZFiMipfqSowCg
pMfB4vQtUYTKyIrGBCEib2s3lVSr6LgKAG3ayvmOfPWl0i/WQKzgGIFmZ9V8
BcAn7ihcODQByVw4MtzBSLkPEtzBTCQ3FO4IXThC3OFCAYAqejcOtIZIOCTW
SiTmEntX4gxK5BIHJQqgwB1OcnuNOyRqlEStFbkzSNx9JO5wIndRiTu1xL+B
yD+OxL8aK/lqUu6DxjqhbOndMoEegEgvw7InE5s14wR6SyI9MpFen0jPUqT3
euVIbGQFJufimYaUVli98FGipz+KzCZGdMaSupmxzKw+K7ox1MVy5lU4n3kt
WHN25/F4PB42Pz5/p9o=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkLtKQ1EQRS/iBwSVKDbil+gnqJUoKAjWtpaWlsZGS4t8gCY+QBTt0iaN
hfgg0SJouLFW8DFbdnFYiILtXXBYxWLOwEyurM2tDmRZNv31BrPfeJkqiQ3Y
fUxswun8Huw+IqpwOr8Pu5fFMew+Kk5g93FxCrtPiAvYvbIVXMLp/gbsvrsT
NGD3GdGE0/1N2H1WtGD37UrQgtP7XsHuC+IaTv9vw+61g6ANuw+JDuxerwUd
2H1YPMDuR4fBI+w+L7qw+7rowu5vr8ET7L4onmH387OgB7vf3gQ92H1J5LD7
/V2Qw+4f70EOu3/Th92XRR92/5t/ouhFL/p/+ifSkbVu
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtugkAQQJ0SUcM9gQAKIuL+UD/B9L3//1aoprXKwF6G6cuexFdPlt2Z
nZ1pr5/v17fVavVx/wmLxWJh51znWRT4nucHUZbXZ+r/b8tkB0/skrIlE3RF
6DwLbjhh0VEYTqk7LrjhpidTQxMjS3hYTNyYGC7ZrGFgnel/scNWxjCwPWgu
IpE1DCQXDUXjqSgAvKOyotqoKQA2laJiv1ZV9Fuvtim51Hl6IVdQHLQMfajs
pRWVxoe6sZbdk+Nk8phmI3e6LoqH9i+eVJwohd4riYRCd79/mD/BnXSOwtjO
fq3MVAGQzSgaveD7gzNzn8TmCoB4UnEiWEa/kMnrN6VQAKQTis4gwh9xJ+7e
gkYBUOCOkMoRooqWZMcHHLSCLKkUACXmMMyGj6CZ8aVs1meHKM50CgDk6VBT
OupxR07pQEoUgrT+C5LgI0pHNO4IKB3BuMOndPjjDqOa5xnv/xwc34pjzznO
LkcMcuQSjpzIkds57iiWu5ajZmjpHHiXjqGGY6lFOWpqjrcByxuH463G8ubk
eDtT9ADmm6QMvQyWngxLb0k0BtHuynZgGXp9Quw1o0ShZ6ldoqj0XjV7yCqr
GKiUN95V7YULcVy+p88ymxAcM5aeTm5W5BjMigTHzGtg+dndQFegdRfRDPKb
xWepd5aeCVssFgvOF6ioEHI=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkT0rhmEYhp/kBwiDDORf2PgNyoJJmW0W2a0k3i8fs8E/IGWhLIR41GPg
1VuvF+Vj5jrrHO6ORFmfo+6O4ei+husamZ2fmOvKsmz8+3Vnv/E6NiCWYfd+
sQan/yuwe4/Ygd0HxS7sPiT24HT+IezeJ45g92olOIbda9XgBHbfbASnsPvq
SnAGu/eKc9h9Yz24gt1vrgWc7jeH3adEDrvXa0EOu0+LWzi9XwG7b28FBez+
/hbcw+6XF8ED7D4pmrD750fQhN0XxCPsPipacHqfFuy+KNqwe6MetGH3GfEE
uy+JDux+sB90YPe7IniG3YfFC+z+N/9E2cte9v/0L5/Bzpo=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmstugzAQRTNF5EEABVCCIM8ihw/qJ0Td9/93DWmipLUxthnuphwpW478
Gntm8n75+ri8TSaTz/uvHhkZYeUsxHmwjx/LLAxmHl3xZkGYlUfe71d5NCWJ
aZRXTAJRLOXvP1gWor+hSv12Q4Of9hzMKfH0htvyJCd3g8gMDDdL5jpj+7mZ
oWG+cxpEbG5oWNkP5bCwUxAtDpaKbcduUuHbzdfG3tCwsVCs3RRE6+EV5hLH
ifrBbLq2fRREWwPFwWFHveJ3b2FhfS7+sug8jKu+iuuJ71Ds+iuI9vqZsgiD
7cy1s5VxKIgyjeJkeF904WkurYRHQZS0KiqmYVwH0nrHp1wKorRFIXqe8Ff8
lq1V8CmICrVD81SzZ6lecU4FkXLVc15HrnJYvnW6iFUOxcu8D1OF4sirIFLk
JyW3o5QdTCH3iSL4htyOUHYE3I5Adsy4HTPZwRbXH3iS4sytIJLyeMHvkMI7
woGYK8SaQ/Yu4gwiYgkiJiJiO+KOQty1dcTriFQOxNsH8YZDvEUhb2pEboDI
cSC5GiLnhOTOiBoApJZR7zkcXfVRhmxKmUH9mi1AjQxR64PULCG1V0gNGVIL
h9T0HXsTZsv9BNBjse8VxU5tL6uel75urBnK8L27GtGDbBi+l9owfE/4RpXH
qt52zNbbvjN0j/6FQf9rMDLyz/gGA17TIw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkz1KQ1EUBh/iAoSIsdDCLWhnimQJIlZiLARrK1vXYKFJl6TIHhS1s7EU
Ep8ixMKXNDHEgEmv95OvuAz+LOANXKYYzoVTnLWDo+3DuSRJKl9vPvmLSXlB
nMLui+IMjudbcDzfht2L4gJ2XxaXsPuKuIHdC+IWjv+/g923xD0c79eF3dMH
AbsviRR2r9cCKez+mAo43u8Jdt8Vz7D7qujB7lXRg92bjcAL7L4uXmH3DZHB
7t1OIIPdpx+BDHbfEX3YfTYN9GH3YzGA3WvngQHsvimGsPv1VWAIu5fEGxzf
xwh23xMj2H1fjGH3EzGG3b95h93/55/Ie97z/lv/BEL9okU=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmt1ugkAQRp0aJCqCgQAiQUXkhfoIpvd9/7sWaWNlF/aH4bspJ/GWk2WZ
md0Zy/vn+/1tsVh8/PzqmZkZLso8TaIwCMIoSfOS/fG3IvZcesH14uLGJqgy
3yEpjp9VHIZzsJILWlbBeayh2A0JWnbFqDVs1YaGrfVarqGeoSG8Wimytb6C
aJ2ZG6q9iaFhb/qJXTamCqLNxUhxctWPFHFPBopjT8ypcI7aisPSTkG0POiu
wlrxLdFbycnyRbU4OntysdruJ67666osPtpXNso4MQ49kb1CkY1XEA2nlatR
jupjPZggDTLtEOGA4syjIBqoJ5olSc22V1FwKYh6y69G7dZlN/VuNPTsSMDp
CKSKavAcZcpKmlFYQvyJNNh9XocvUdxGlQ0RR3LgZgyOFkmIxNyOWHR43A5P
dIwssSKuoCi5FUTCdS7nd+RdR8rvSLuOhN+RdB0RvyPqOpgq+V+Eqs6a2FuE
9I5wIN4VYs8R3y4iBhG5pOR3iC0uQG6H1ChErUWcGRBnH8QZDnIWRZypEXcD
yB0HcVeD3DkRd2dIDwDRy4D0ZBC9JUiPDNLrQ/QsIb1XSA8Z0guH9PQhswnI
jAUyK6oRM68aMrurETPIhulnqY+1TD4Tbph+tv1g8hn9LxP/12Bm5v/xBW6L
rJM=
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkTtKA2EYRQfJAjTBB6KCO7C3iEtQuwQlIFjbBUuXYKGFKVOkstBC0BXY
BcXGBCZEfI2oiWBAKx//hVsMB1GwnQMfpzjFV9zZtY3l9aEoiha+Lxf9xktx
WGzB6b4Nu+dFHXYfEw3YfUrsw+n/B7D7iDiE3UfFEew+Lk5h9xnRhN0XxRns
viTOYfeCuIDdW5cCdq/tBVqw+6Row+5l0Ybdp0UMu6+KGHafE104vd8V7D54
DVzD7rs7gRs4vf8t7F4Vd7D7+1vgHnafEAnsvikS2P3kOJDA7iXxALvPi0fY
fUU8we6dOPAMu39+BHqwe0X0Yfe/+SeynvWs/6d/AY0/kpE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmdtqg0AQhjPmYE5WWBEhJiZVMfg6fYTQ+77/XdmkgZaM6+46/lDwg1zG
j9XZ2dmZ99vXxy2YzWafP792YmLiP9EUeZYmSiVplheN/PPPWRTSH8IoOwsK
TvGKWFZvJxFBla55wYN1Wg01lGpuMmjmqhxiqFXQZ9AEqvZWHJY2Bs3y4Gco
t7YGzdbnhR0XLgqixdFZkbgZNImb4bp3VxBFVwdFvfNREO3s46ve+CmINrZp
7Oq5ivtKLF+X17d4ElkpPCLqNzbRdRymIOrfJ6Xj1ntl0bvjnRIIz7ZHcRiu
IDInyNo605pYGreiklAQKYOitDqS+gkMn11oGaaFVL1nty3zzkIilVIQpV2O
sP+/tqw7FCc5BVFHcRdLOmLe0VFw+rFiFRdJBdGFc2SyjoxzRLIO9kAUjFxN
yCgaWQURU6IU0o7i1ZFLO/LRw4oNLMGE+IBJiwPLqleYQkvsfHrCnFMIB+Jd
Ib45InYRexCRSxA5EZHbIWcU4qw9yzr4Jh2g9pGt4d54B6IWlYxeNnI1iLsB
4o6DuKtB7pyIuzOkB4DoZUB6MpDeEqJHBun1DexZ7q0UkN5r2/j3kB0a1eP3
wn17+nuXnn6LmE20kBkLZFbUImZeLWR21yJmkJoqNZZE4fBZ6p3umXAsMxN+
cOFm22yrbRhjz+gnJiZG4BurZhu5
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztksEqRGEYhk9yA8hIWLgGpVjgGthbKGsXoNwEuzkzs7OmzEKZiKWNKTML
c0zqTMSMMy6B/9W7+HsSWzVPfT2LZ/P3ff/izt7m7liSJBtfM578xsf6vEhh
95I4ht2nRR12nxXnsPuCaMDuk+Iadj86DNzA7nPiFnZv3gnYfUI0Yfd2S8Dx
/tqwe+dBwPH7O3B8vwx2r6SBDHZ/zATsvi26sHutGujC7qcngSfYfUrksPuS
yGH3LZHD7vWzQA92b90HerD7sniG3WfEC+y+Il5h91XxBrvviz7snpYDfdi9
cREYwPH9B7B7tRJ4h93XRAG7H4gCjv9PAbt/M4Tdry4DQ9j9b/6JUR/1/90/
AYDm7bE=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmduOgjAQhp1FlJBwEAJEQGWR8ED7CGbv9/3vdvEQjdpz/U02/RJv/VKm
7UxnPg8/X4eP2Wz2ff6NDofD8S/ZtVWexlEYRnGaV+3O9v93dRbQHUFWd9YE
Q5N494ITXtIMNgx96T8XnPDL3thQzHmGiXlhZqkWIsNxLZW+YRPJGCaijaZi
zYj0M7y1jmG/kjdMrPbKil76O12IVEO/DVUVROFWTbFUVxAtVSS9xiqOK5H/
XHvlWFyIpAOvuKNuWUkq1voKIrlzslE4eo94UideOxgnIglFZaYgEl+QPTdb
yOALN3BhqiAqRMsQpiQxc8FCSnMFUclVDMbRmPC5hURjQ0HU8ByJHUfCUXRG
R/yKxynuajsKoprtyGw5MrbjoabVJWAqdrYURMyqvrXnaFkO4yv3CvPyze05
cpYjtedIWY7YniNmOQyz7C3MjKtZuT0jfKcD8a0QMUfsXcQZRNwliDsRcbcj
chQk1yJqhs6Wg1fxAmo4SC2KqKkRbwPIGwfxVht7qe4eD/GbE/F2hvQAIL0M
RE8G0luC9MgQvT5IzxLSe4X0kCG98BHR0x8hs4k/Kqm8uDCYsYyQWdGImHlN
DA2zJLI0uzvy8hnkmVfPUh0Oh+O9/AIcZ0Y/
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztjs0qhAEYRr/kAsSCKZRbkCWZayArZaGslatwCfNXZC0LPwvRKDZm5ydh
JhZfU5KZ4QIo3qeexdfJcAHfqbezOD31Tq2uL6wNJElS/LnB5C8+5sfEJuw+
Lmqw+7DYgbP7Xdh9UuzB7gVxDGf3dTj73znsPiIuYPdyKbiEs/81YPdKOWjA
7kPiCna/uRaw+6K4hd2XxB3s/nAvYPdqJWjC7suiBbvXqkELdn9+ErD7tEhh
9w2Rwu4H+0EKu8+INux+dBi0YfdR8QK7Nx+DV9j99CR4g91nRQd2//oMOrD7
hOjC7nOiC7uviB7sflYPerD79lbwDrv/z7+R97znvV//BtA9w+c=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmctugzAQRRlIIgTh/QghgYhfyidE3ff/dxVJ0yfFYw9cdeEjseUIbI/H
18Pt9XpzHcd5eX8Gi8VisVjWp2uqPEuiKMnyqumWf39fpwF9I0jrfknDIfZo
Ai8+LCS4lP6U4IFfXhZQVLu/DSO7Smpow3nDSNiKFIWrVhC5hbnhvOcYRvZn
Q8VpZqx/4p+MFMctX0G0PZooNjoKoo2+5KT1Ffcv0f1dZ42xeOJrDjx7Rn1l
r6UoTBREOuukZS2937gaK55RQKYJ2YrKVEHELZAXRaWdY8cs9aW5gqjkOQyW
xic+S3GQKIhY228sc8QMRT/ZHvDxGN1KLVMQ1WpHKnWkakegfss8gVLRSRVE
yja1kTsalUNQq54oa1Yud+QqRyZ3ZCpHInckKkckd0T/wYH4V4gxR8xdxBpE
1BJETUTUdsgehdhrET0DoveB9HCIXhTSUyPOBogzDuSsBjlzIs7OkAwAkmUg
MhlItgTJyCBZHySzHBDZ6wDJkAdEFj5AMv2R1e8m7qx/x/Jg7bsii8VisVg+
eANXXE6S
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkDlqQgEURT/iApzAIGncgVVaXYJYWgass4O4iDgX2toK2tj4QUhai0ic
IiJiUJyWEN+FW3wuEtvAP/A4xaneTT6/5AoBx3Ey1ws6f3FJP4Ca2NvbYvYw
6IjZE6AvZg8BV8weBUMxe+nNGIrZqxXjXcweBx9i9iwYidlj4FPMXikbYzF7
rWp8idmnEyBmX8yBmP0RLMTsKbASs0fAWuz9fyNm73WNjZj9CWzF3n1+xOyN
urETs+fBXsw+nxl7sXe/g5h9+W0cxeyv4CRmbzWNk5i9CM5idndgnMXs9/kW
fve73/9z/wVyJY/K
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmNtqhEAMhk3RVUdRxPXACAt9pT7C0vu+/13X3Z5QqybO/BSaD/Z2P8xk
Mkmer28v16cgCF4/fhdFURRFURRPDH0/+Pt3WxcmoTuJKWrrXlClNCGtnGra
PJwaRsK8dWXosiXBg6xzoiij3xVEUXncYM2aYcQcPZYm3lIQxc0hxfm0rSA6
nY8oFtNpTiiXNLu+4v4l0nDZHWfxSSw8+M2M+okRKUqOgqgSKLrVqzcnEtz4
lQKyTMZWtFwFEbtA5nxHzlRYvoJCZv5WAgc3tWav3h5SlkISqhusYNUyR81x
FDJHwXGwStU3rKKVyBwJxyFTEDEUg9TBaFN7qaP/Ww5ErBBnDsldxB1E1BJE
TUTUdsQbBXlrRcHi9ryA3gfSwyF6UUhPjZgNIDMOZFZDzJyQ2RmyA4DsMiA7
mRvV+m5Jdi+mAHZkl3HXt2xwt+sb8b+zfGh8716/8LtDVhRFURTlv/IOxF59
Sw==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJyNkr0KQXEchk9yAQzkI8VFGOUeDBabMssqyWilfF6AwRVYxGo8iuUQZziJ
jo9L4P/WO5zexFO/nuGpd/rlqvVSLWRZVvZzYesXr2IEdMTsCdAVB/tYzB4H
MzF7CszFwf2FmD0DlmL2JNiI2aPAFrMPB4admL0M9mL2NHDE7BXgiNkbwBWz
93sGV8y+tQ2umD0GPDF7Hnhi9vHIcBGzTyeGq5i9CW5i9hbwxezHg8EXB//j
LmYvgLuYvQ0eYvb1yvAUs59PhqeY/T9/43d/A/jYNPk=
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                    GeometricTransformationBox[RasterBox[CompressedData["
1:eJztmMsOgjAQRZlCkIa3EPb+kp9g3Pv/O1ExGgGdtOUmJvckXZ90Op3O9HC6
HE8miqLztAZCCCGEEELIi74ucmvzou43ErRZYmTCJFkb3lCm8kFahjU0M8Pd
0gRUWLOkGENmQxm63bLhxq4LotjH6wqReB9A0X1VjJIAO/kSqClc3gr7SyHi
e/DNSka9YzxTePFefJJ6KSqNQqTafBt+G2l1ChGPAplpHZm7I9E6EmdFr0jc
B8b50aq1CpHa1VHoHYWrI9c7cleHolY9ca5ZCAciVogzR+Qu4g4iagmkJiJq
O+KNGkqdw+utRfQMkN4H0cNBelFIT42YDSAzzoCY1QbIzDlSzWdnv9u9yPZ/
AHc2/8sghBBCCCHkv7gCd7rl6A==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJztkj0OQVEYRG/EAhQ0CmEl9mAJEjXRqFiDv4S1sAOFXFri3UjkBfE8JRXf
JFNN/CzASSanOO1U6s1aI+OcK7+Wdd9Iq3kwFrMXwULMXgJLMXsOeDH7oG94
MftoaKzF7C0QxOwrbwQx+y01gpi9DfZi9gI4iNk7IBazTydGLGZ/3I2jmH0+
M05i9u3GOIvZu+AiZu+BRMwe7YxEzB4i4ypm/83v//vvn/sTNgQrqw==
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                   GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1ksKwyAUQFGfqBFDxCyhW+oSQufd/6xfCk0jdPDyoOUeyPiixs9hOR8X
75w7Pb8ZAAAAAIBv1JJjCDGXuldhTPKSxj0KbZA3Q1NPTEFWwqSd8OuEiNeN
tI9R3EeiOl3DVuK6JoqJcTshovh3pV4jqSVqLyGithlLv1G0GrnfyFqN2G9E
rcbm5ngIv9SwmCuLNbf4dy32oMVZYnImWpztJneUxV1r8mYwefvMFm+4m/3f
ogAAAACAP3EBelt02w==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    Part[CompressedData["
1:eJxTTMoPSmViYGBQAGIWBkLgg70YGCzDoGHyImCwBYNG1b8Ng4bJT5kMAocx
aJi8FBicwqBh8oJgcBGDhskLg8FlDBomv3EDCDzAoGHyFy+AwAMMGiZ/7SoI
PMWgYfLfvoLAUwwaJv/zBwi8wKBh8lZg8AqDhslHgcErDBomP3cOCLzBoGHy
xNG408eo/NCWBwC3aND0
                    "], #]]& ),
                    ColorFunctionScaling->False], {0, 0}]}, 
                  GeometricTransformationBox[RasterBox[CompressedData["
1:eJzt1MEJwzAMQFFHsZM5ulJHCLln/1tLCM0ARYKW98DnD7Ktx3Y8t2it7ddZ
AQAAAPjW6BF9ZBaWeTrNS17jSrwjaYkxfaSNq9+NntWIuxG/3KiYVcWdV7zd
kj9YsUsAAAAA/twLucsRbA==
                    "], {{0, 0}, {100, 100}},
                    ColorFunction->(Apply[RGBColor, 
                    
                    Part[{{0., 0., 0., 1.}, {0.17254901960784313`, 
                    0.17254901960784313`, 0.17254901960784313`, 1.}, {
                    0.3176470588235294, 0.3176470588235294, 
                    0.3176470588235294, 1.}, {0.34509803921568627`, 
                    0.34509803921568627`, 0.34509803921568627`, 1.}, {
                    0.7137254901960784, 0.7137254901960784, 
                    0.7137254901960784, 1.}, {0.9568627450980393, 
                    0.9568627450980393, 0.9568627450980393, 1.}, {1., 1., 1., 
                    1.}, {0., 0., 0., 1.}}, #]]& ),
                    ColorFunctionScaling->False], {0, 0}]},
                 Background->None,
                 ImageSize->{100, 100},
                 PlotRange->{{0, 100}, {0, 100}}]}, Dynamic[$CellContext`i$$],
                
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$22178$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 16, 1}, 16, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {76.5, 81.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->604978519]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GIF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 14.5264982}", "context" -> "", 
    "keywords" -> {
     "raster image", "image processing", "color map", "image compression", 
      "web", "animation"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: image/gif GIF raster image format. Commonly used \
for static and animated graphics on the web. GIF is an acronym for Graphics \
Interchange Format. Binary format. Uses LZW lossless compression after \
restriction to an 8-bit color palette. Supports transparency. Developed in \
1987 by CompuServe.", "synonyms" -> {}, "title" -> "GIF", "type" -> "Format", 
    "uri" -> "ref/format/GIF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[29786, 1004, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 279906, 5769}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3482, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4105, 104, 102, 4, 70, "ObjectNameAlt",
 CellID->19281],
Cell[4210, 110, 463, 11, 70, "FormatUsage",
 CellID->7085],
Cell[4676, 123, 370, 13, 70, "FormatNotes",
 CellID->9152]
}, Open  ]],
Cell[CellGroupData[{
Cell[5083, 141, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[5150, 144, 396, 12, 70, "FormatNotes",
 CellID->28652],
Cell[5549, 158, 361, 11, 70, "FormatNotes",
 CellID->8194],
Cell[5913, 171, 617, 21, 70, "FormatNotes",
 CellID->9876],
Cell[6533, 194, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[6575, 197, 746, 26, 70, "FormatNotes",
 CellID->28396],
Cell[7324, 225, 453, 15, 70, "FormatNotes",
 CellID->7572],
Cell[7780, 242, 119, 3, 70, "FormatNotes",
 CellID->6249],
Cell[7902, 247, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[7944, 250, 341, 11, 70, "FormatNotes",
 CellID->29174],
Cell[8288, 263, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[8865, 285, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[9448, 308, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[10154, 335, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[10195, 338, 519, 18, 70, "FormatNotes",
 CellID->20289],
Cell[10717, 358, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[11795, 400, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[12459, 424, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[13277, 454, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[13318, 457, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[13682, 473, 342, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[14061, 490, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[14133, 493, 240, 7, 70, "FormatNotes",
 CellID->2609],
Cell[14376, 502, 153, 4, 70, "FormatNotes",
 CellID->11064]
}, Closed]],
Cell[CellGroupData[{
Cell[14566, 511, 50, 1, 70, "ElementsSection",
 CellID->9166],
Cell[14619, 514, 192, 8, 70, "FormatNotes",
 CellID->16893],
Cell[14814, 524, 707, 14, 70, "2ColumnTableMod",
 CellID->16074],
Cell[15524, 540, 68, 1, 70, "FormatNotes",
 CellID->30300],
Cell[15595, 543, 699, 14, 70, "2ColumnTableMod",
 CellID->19695],
Cell[16297, 559, 359, 11, 70, "FormatNotes",
 CellID->9573],
Cell[16659, 572, 300, 9, 70, "FormatNotes",
 CellID->15589],
Cell[16962, 583, 410, 13, 70, "FormatNotes",
 CellID->13161],
Cell[17375, 598, 272, 9, 70, "FormatNotes",
 CellID->31172],
Cell[17650, 609, 193, 8, 70, "FormatNotes",
 CellID->19426],
Cell[17846, 619, 669, 13, 70, "2ColumnTableMod",
 CellID->28510],
Cell[18518, 634, 135, 4, 70, "FormatNotes",
 CellID->980792937],
Cell[18656, 640, 1474, 35, 70, "2ColumnTableMod",
 CellID->102417787],
Cell[20133, 677, 164, 4, 70, "FormatNotes",
 CellID->1201344862],
Cell[20300, 683, 60, 1, 70, "FormatNotes",
 CellID->361846540],
Cell[20363, 686, 349, 9, 70, "2ColumnTableMod",
 CellID->1114238489]
}, Open  ]],
Cell[CellGroupData[{
Cell[20749, 700, 49, 1, 70, "OptionsSection",
 CellID->10422],
Cell[20801, 703, 55, 1, 70, "FormatNotes",
 CellID->30774],
Cell[20859, 706, 835, 23, 70, "3ColumnTableMod",
 CellID->8779],
Cell[21697, 731, 306, 12, 70, "FormatNotes",
 CellID->454840903],
Cell[22006, 745, 475, 12, 70, "3ColumnTableMod",
 CellID->1616757048],
Cell[22484, 759, 208, 8, 70, "FormatNotes",
 CellID->5764],
Cell[22695, 769, 672, 16, 70, "3ColumnTableMod",
 CellID->874],
Cell[23370, 787, 540, 16, 70, "FormatNotes",
 CellID->1867802010],
Cell[23913, 805, 353, 13, 70, "FormatNotes",
 CellID->1364466339],
Cell[24269, 820, 89, 1, 70, "FormatNotes",
 CellID->14902],
Cell[24361, 823, 1043, 26, 70, "3ColumnTableMod",
 CellID->28255],
Cell[25407, 851, 165, 4, 70, "FormatNotes",
 CellID->4460],
Cell[25575, 857, 554, 16, 70, "FormatNotes",
 CellID->474],
Cell[26132, 875, 322, 9, 70, "FormatNotes",
 CellID->26821],
Cell[26457, 886, 243, 8, 70, "FormatNotes",
 CellID->5556],
Cell[26703, 896, 536, 13, 70, "2ColumnTableMod",
 CellID->1993]
}, Closed]],
Cell[CellGroupData[{
Cell[27276, 914, 53, 1, 70, "TutorialsSection",
 CellID->26122],
Cell[27332, 917, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[27500, 922, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[27707, 930, 50, 1, 70, "SeeAlsoSection",
 CellID->25605],
Cell[27760, 933, 589, 20, 70, "SeeAlso",
 CellID->30195]
}, Open  ]],
Cell[CellGroupData[{
Cell[28386, 958, 58, 1, 70, "MoreAboutSection",
 CellID->176385089],
Cell[28447, 961, 126, 2, 70, "MoreAbout"],
Cell[28576, 965, 151, 2, 70, "MoreAbout"],
Cell[28730, 969, 123, 2, 70, "MoreAbout"],
Cell[28856, 973, 134, 2, 70, "MoreAbout"],
Cell[28993, 977, 133, 2, 70, "MoreAbout"],
Cell[29129, 981, 127, 2, 70, "MoreAbout"],
Cell[29259, 985, 119, 2, 70, "MoreAbout"],
Cell[29381, 989, 130, 2, 70, "MoreAbout"],
Cell[29514, 993, 113, 2, 70, "MoreAbout"],
Cell[29630, 997, 119, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29786, 1004, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[29902, 1010, 60, 1, 70, "ExampleSection",
 CellID->916592079],
Cell[29965, 1013, 238, 8, 70, "ExampleText",
 CellID->765611898],
Cell[CellGroupData[{
Cell[30228, 1025, 124, 3, 70, "Input",
 CellID->7950],
Cell[30355, 1030, 20555, 344, 70, "Output",
 CellID->286416386]
}, Open  ]],
Cell[50925, 1377, 125, 3, 70, "ExampleDelimiter",
 CellID->318033230],
Cell[51053, 1382, 225, 8, 70, "ExampleText",
 CellID->782119208],
Cell[CellGroupData[{
Cell[51303, 1394, 146, 4, 70, "Input",
 CellID->1289346575],
Cell[51452, 1400, 29237, 615, 70, "Output",
 CellID->1188793399]
}, Open  ]],
Cell[80704, 2018, 76, 1, 70, "ExampleText",
 CellID->330125569],
Cell[CellGroupData[{
Cell[80805, 2023, 194, 6, 70, "Input",
 CellID->2033227574],
Cell[81002, 2031, 37410, 728, 70, "Output",
 CellID->2010288952]
}, Open  ]],
Cell[118427, 2762, 126, 3, 70, "ExampleDelimiter",
 CellID->1470177982],
Cell[118556, 2767, 131, 4, 70, "ExampleText",
 CellID->334501092],
Cell[CellGroupData[{
Cell[118712, 2775, 236, 8, 70, "Input",
 CellID->754],
Cell[118951, 2785, 86, 2, 70, "Output",
 CellID->914443399]
}, Open  ]],
Cell[119052, 2790, 69, 1, 70, "ExampleText",
 CellID->232919705],
Cell[CellGroupData[{
Cell[119146, 2795, 118, 3, 70, "Input",
 CellID->1966277101],
Cell[119267, 2800, 1133, 26, 70, "Output",
 CellID->1657229061]
}, Open  ]],
Cell[120415, 2829, 125, 3, 70, "ExampleDelimiter",
 CellID->185926637],
Cell[120543, 2834, 241, 8, 70, "ExampleText",
 CellID->280281674],
Cell[CellGroupData[{
Cell[120809, 2846, 667, 18, 70, "Input",
 CellID->1012],
Cell[121479, 2866, 87, 2, 70, "Output",
 CellID->331224049]
}, Open  ]],
Cell[121581, 2871, 86, 1, 70, "ExampleText",
 CellID->1623122270],
Cell[CellGroupData[{
Cell[121692, 2876, 165, 5, 70, "Input",
 CellID->977156569],
Cell[121860, 2883, 156674, 2850, 70, "Output",
 CellID->604978519]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[278573, 5738, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

