(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33789,       1132]
NotebookOptionsPosition[     28298,        955]
NotebookOutlinePosition[     29763,        994]
CellTagsIndexPosition[     29678,        989]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Sparse6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Sparse6"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\"Sparse6\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "Mathematical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalDataFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 3->"\<\"Mathematical Data\"\>", 
       4->"\<\"Mathematical Data Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Graph6 ",
 StyleBox["(.g6)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "Graph6 graph data format.\nUsed for storing undirected graphs.\nASCII \
format.\nStores connectivity information for multiple undirected graphs.\n\
Suitable for small graphs or large dense graphs with up to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "18"], "-", "1"}], TraditionalForm]], "InlineMath"],
 " vertices.\nRelated to sparse6 which is optimized for large sparse graphs.\n\
Developed by Brendan McKay at The Australian National University."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the graph6 file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", "]"}]], "InlineFormula"],
 "gives a graphical rendering of the first graph stored in the specified \
file."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an adjacency matrix or edge information for one graph or for \
multiple graphs to the Graph6 format."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", "]"}], " "}]], "InlineFormula"],
 "imports the first graph from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 " and returns it as a ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a graph6 file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Graph6\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Graph6\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a graph6 file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the graph6 file format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdjacencyMatrix\>\"", Cell["\<\
edge information for all graphs in this file, given as a list of matrices\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeRules\>\"", Cell[
    "connectivity data for all graphs, given as an array of rules", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[TextData[{
     "first graph stored in this file, rendered as ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsList\>\"", Cell[TextData[{
     "all graphs stored in this file, given as a list of ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCount\>\"", Cell["\<\
number of vertices in each graph, given as a list of integers\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->977886736],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element by default. "
}], "FormatNotes",
 CellID->7162],

Cell["", "WeakDivider",
 CellID->700968940],

Cell["\<\
Element specifications for graph6 files containing multiple graphs:\
\>", "FormatNotes",
 CellID->650021461],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["elem", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "data representation element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " for the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " graph in this file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["elem", "TI"], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " for graphs ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["elem", "TI"], ",", " ", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " for all graphs, given as a list"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->661382738],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).g6\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Graphics\>\"", ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives a list of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects, each representing a rendering of a graph stored in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", "g6"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->484320694],

Cell[TextData[{
 "When importing a graph6 file using the ",
 Cell[BoxData["\"\<EdgeRules\>\""], "InlineFormula"],
 " element, no rules are returned for possible unconnected vertices."
}], "FormatNotes",
 CellID->1014881928],

Cell[TextData[{
 "Graphs including unconnected vertices can be fully specified using the ",
 Cell[BoxData["\"\<AdjacencyMatrix\>\""], "InlineFormula"],
 " element, or as a combination of ",
 Cell[BoxData["\"\<EdgeRules\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<VertexCount\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->76433444]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->8692],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->19539],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the overall size of the image to display for a graph\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[Cell[BoxData[
 ButtonBox["\"\<Sparse6\>\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Sparse6"]], "InlineFormula"]], "SeeAlso",
 CellID->172004913]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->225387741],

Cell["This imports a small graph6 sample file:", "ExampleText",
 CellID->1391039153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/cubical.g6\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.3655602685573496`, 0.8126428061603018}, {
    0.643410418222244, 1.6254912131806267`}, {0.6430882537191835, 
    0.00016033087525313405`}, {0., 0.8129625331346042}, {2.1869413163286877`, 
    0.8125979219108003}, {1.5444080787203665`, 1.6256130324957945`}, {
    1.5441197178287678`, 0.}, {0.8209811502510613, 0.8129372505656721}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 5}], LineBox[{2, 4}], LineBox[{2, 6}], LineBox[{3, 4}], 
      LineBox[{3, 7}], LineBox[{4, 8}], LineBox[{5, 6}], LineBox[{5, 7}], 
      LineBox[{6, 8}], LineBox[{7, 8}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.3655602685573496`, 0.8126428061603018}, {
     0.643410418222244, 1.6254912131806267`}, {0.6430882537191835, 
     0.00016033087525313405`}, {0., 0.8129625331346042}, {2.1869413163286877`,
      0.8125979219108003}, {1.5444080787203665`, 1.6256130324957945`}, {
     1.5441197178287678`, 0.}, {0.8209811502510613, 0.8129372505656721}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->113715998]
}, Open  ]],

Cell["Show the edge rules representing the graph:", "ExampleText",
 CellID->1688063229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/cubical.g6\>\"", ",", " ", "\"\<EdgeRules\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->373583929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "3"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"2", "\[Rule]", "6"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"3", "\[Rule]", "7"}], ",", 
    RowBox[{"4", "\[Rule]", "8"}], ",", 
    RowBox[{"5", "\[Rule]", "6"}], ",", 
    RowBox[{"5", "\[Rule]", "7"}], ",", 
    RowBox[{"6", "\[Rule]", "8"}], ",", 
    RowBox[{"7", "\[Rule]", "8"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1344112241]
}, Open  ]],

Cell[TextData[{
 "Import the corresponding adjacency matrix and render it as a ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1451642648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<ExampleData/cubical.g6\>\"", ",", " ", "\"\<AdjacencyMatrix\>\""}], 
    "]"}], " ", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", " ", "MatrixPlot"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->879286775],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmVmYGDggGIQGwI+2FOLnjNzNhDetmdAAaSrJ9WcgXLncLWXVHNo
HV8D5Z5R/9LHnKFuL6nmDxZ3AgBNNx1n
   "], {{0, 0}, {8, 8}}, {0, 1}],
  Frame->True,
  FrameLabel->{None, None},
  FrameTicks->{{{{7.5, 
       FormBox["1", TraditionalForm]}, {6.5, 
       FormBox["2", TraditionalForm]}, {5.5, 
       FormBox["3", TraditionalForm]}, {4.5, 
       FormBox["4", TraditionalForm]}, {3.5, 
       FormBox["5", TraditionalForm]}, {2.5, 
       FormBox["6", TraditionalForm]}, {1.5, 
       FormBox["7", TraditionalForm]}, {0.5, 
       FormBox["8", TraditionalForm]}}, {{7.5, 
       FormBox["1", TraditionalForm]}, {6.5, 
       FormBox["2", TraditionalForm]}, {5.5, 
       FormBox["3", TraditionalForm]}, {4.5, 
       FormBox["4", TraditionalForm]}, {3.5, 
       FormBox["5", TraditionalForm]}, {2.5, 
       FormBox["6", TraditionalForm]}, {1.5, 
       FormBox["7", TraditionalForm]}, {0.5, 
       FormBox["8", TraditionalForm]}}}, {{{0.5, 
       FormBox["1", TraditionalForm]}, {1.5, 
       FormBox["2", TraditionalForm]}, {2.5, 
       FormBox["3", TraditionalForm]}, {3.5, 
       FormBox["4", TraditionalForm]}, {4.5, 
       FormBox["5", TraditionalForm]}, {5.5, 
       FormBox["6", TraditionalForm]}, {6.5, 
       FormBox["7", TraditionalForm]}, {7.5, 
       FormBox["8", TraditionalForm]}}, {{0.5, 
       FormBox["1", TraditionalForm]}, {1.5, 
       FormBox["2", TraditionalForm]}, {2.5, 
       FormBox["3", TraditionalForm]}, {3.5, 
       FormBox["4", TraditionalForm]}, {4.5, 
       FormBox["5", TraditionalForm]}, {5.5, 
       FormBox["6", TraditionalForm]}, {6.5, 
       FormBox["7", TraditionalForm]}, {7.5, 
       FormBox["8", TraditionalForm]}}}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[3]=",
 CellID->73300397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1453150027],

Cell["\<\
Convert a string representing graph6 data to a visual representation of a \
graph:\
\>", "ExampleText",
 CellID->1908470105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"\"\<MAbaHfLt}dk]mf~{_\>\"", ",", " ", "\"\<Graph6\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462964006],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.0402644663022063`, 0.7452308036047446}, {
    0.801848978703103, 0.452305794102567}, {0.6573890472839201, 
    2.3128385755649825`}, {0.26171774305007434`, 0.1714848940730085}, {
    2.4880949688305947`, 1.385926408111478}, {1.3182570159316824`, 
    1.7483495880688704`}, {0.2864148240631823, 0.8626493373408108}, {0., 
    1.4100740899154853`}, {1.5422182818329464`, 1.2125673683568505`}, {
    0.8199199040931336, 0.8585249764075319}, {1.2592278423694063`, 0.}, {
    0.4584598830252311, 1.6245413593226226`}, {1.306348940306373, 
    0.859431651230232}, {1.041637246400736, 1.3230127189043053`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 5}, {1, 6}, {1, 9}, {1, 10}, {1, 11}, {1, 13}, {1, 14}, {2,
        4}, {2, 6}, {2, 7}, {2, 9}, {2, 10}, {2, 11}, {2, 12}, {2, 14}, {3, 
       6}, {3, 8}, {3, 12}, {3, 13}, {3, 14}, {4, 8}, {4, 10}, {4, 11}, {4, 
       13}, {4, 14}, {5, 9}, {5, 13}, {5, 14}, {6, 7}, {6, 9}, {6, 10}, {6, 
       14}, {7, 8}, {7, 10}, {7, 11}, {7, 12}, {7, 13}, {7, 14}, {8, 9}, {8, 
       10}, {8, 12}, {8, 14}, {9, 10}, {9, 11}, {9, 12}, {9, 14}, {10, 11}, {
       10, 12}, {10, 13}, {10, 14}, {11, 13}, {12, 13}, {13, 14}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0402644663022063`, 0.7452308036047446}, {
     0.801848978703103, 0.452305794102567}, {0.6573890472839201, 
     2.3128385755649825`}, {0.26171774305007434`, 0.1714848940730085}, {
     2.4880949688305947`, 1.385926408111478}, {1.3182570159316824`, 
     1.7483495880688704`}, {0.2864148240631823, 0.8626493373408108}, {0., 
     1.4100740899154853`}, {1.5422182818329464`, 1.2125673683568505`}, {
     0.8199199040931336, 0.8585249764075319}, {1.2592278423694063`, 0.}, {
     0.4584598830252311, 1.6245413593226226`}, {1.306348940306373, 
     0.859431651230232}, {1.041637246400736, 1.3230127189043053`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->841303143]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graph6 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 49.5742704}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Graph6 graph data format. Used for storing undirected graphs. ASCII \
format. Stores connectivity information for multiple undirected graphs. \
Suitable for small graphs or large dense graphs with up to 2^18-1 vertices. \
Related to sparse6 which is optimized for large sparse graphs. Developed by \
Brendan McKay at The Australian National University.", "synonyms" -> {}, 
    "title" -> "Graph6", "type" -> "Format", "uri" -> "ref/format/Graph6"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17891, 638, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29544, 982}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1653, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2276, 67, 103, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2382, 73, 524, 11, 70, "FormatUsage",
 CellID->20778],
Cell[2909, 86, 331, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3277, 103, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3344, 106, 322, 10, 70, "FormatNotes",
 CellID->2520],
Cell[3669, 118, 402, 12, 70, "FormatNotes",
 CellID->12927],
Cell[4074, 132, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4116, 135, 511, 18, 70, "FormatNotes",
 CellID->25134],
Cell[4630, 155, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4672, 158, 343, 11, 70, "FormatNotes",
 CellID->22675],
Cell[5018, 171, 573, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5594, 193, 581, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6178, 216, 687, 25, 70, "FormatNotes",
 CellID->21001],
Cell[6868, 243, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[6909, 246, 515, 18, 70, "FormatNotes",
 CellID->9310],
Cell[7427, 266, 1074, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8504, 308, 660, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9167, 332, 815, 28, 70, "FormatNotes",
 CellID->20356],
Cell[9985, 362, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10026, 365, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[10390, 381, 350, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[10777, 398, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[10831, 401, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[11026, 411, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[11696, 426, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[11738, 429, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[11809, 432, 1365, 31, 70, "2ColumnTableMod",
 CellID->977886736],
Cell[13177, 465, 257, 9, 70, "FormatNotes",
 CellID->7162],
Cell[13437, 476, 43, 1, 70, "WeakDivider",
 CellID->700968940],
Cell[13483, 479, 118, 3, 70, "FormatNotes",
 CellID->650021461],
Cell[13604, 484, 1838, 59, 70, "2ColumnTableMod",
 CellID->661382738],
Cell[15445, 545, 720, 24, 70, "FormatNotes",
 CellID->484320694],
Cell[16168, 571, 223, 5, 70, "FormatNotes",
 CellID->1014881928],
Cell[16394, 578, 352, 9, 70, "FormatNotes",
 CellID->76433444]
}, Open  ]],
Cell[CellGroupData[{
Cell[16783, 592, 48, 1, 70, "OptionsSection",
 CellID->8692],
Cell[16834, 595, 190, 8, 70, "FormatNotes",
 CellID->19539],
Cell[17027, 605, 564, 16, 70, "3ColumnTableMod",
 CellID->28047]
}, Closed]],
Cell[CellGroupData[{
Cell[17628, 626, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[17681, 629, 173, 4, 70, "SeeAlso",
 CellID->172004913]
}, Open  ]],
Cell[CellGroupData[{
Cell[17891, 638, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18007, 644, 60, 1, 70, "ExampleSection",
 CellID->225387741],
Cell[18070, 647, 84, 1, 70, "ExampleText",
 CellID->1391039153],
Cell[CellGroupData[{
Cell[18179, 652, 127, 3, 70, "Input",
 CellID->17199],
Cell[18309, 657, 2014, 55, 70, "Output",
 CellID->113715998]
}, Open  ]],
Cell[20338, 715, 87, 1, 70, "ExampleText",
 CellID->1688063229],
Cell[CellGroupData[{
Cell[20450, 720, 178, 5, 70, "Input",
 CellID->373583929],
Cell[20631, 727, 613, 17, 70, "Output",
 CellID->1344112241]
}, Open  ]],
Cell[21259, 747, 249, 8, 70, "ExampleText",
 CellID->1451642648],
Cell[CellGroupData[{
Cell[21533, 759, 289, 9, 70, "Input",
 CellID->879286775],
Cell[21825, 770, 1807, 42, 70, "Output",
 CellID->73300397]
}, Open  ]],
Cell[23647, 815, 126, 3, 70, "ExampleDelimiter",
 CellID->1453150027],
Cell[23776, 820, 134, 4, 70, "ExampleText",
 CellID->1908470105],
Cell[CellGroupData[{
Cell[23935, 828, 176, 5, 70, "Input",
 CellID->462964006],
Cell[24114, 835, 3499, 92, 70, "Output",
 CellID->841303143]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27674, 934, 38, 0, 70, "MoreAboutSection"],
Cell[27715, 936, 134, 2, 70, "MoreAbout"],
Cell[27852, 940, 133, 2, 70, "MoreAbout"],
Cell[27988, 944, 125, 2, 70, "MoreAbout"],
Cell[28116, 948, 140, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[28271, 953, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

