(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    119389,       2877]
NotebookOptionsPosition[    113282,       2691]
NotebookOutlinePosition[    115179,       2736]
CellTagsIndexPosition[    115092,       2731]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Graph6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Graph6"], "\"Sparse6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Sparse6"], "\"MTX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MTX"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"Graph6\\\"\"\>", 
       2->"\<\"\\\"Sparse6\\\"\"\>", 
       3->"\<\"\\\"MTX\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "Mathematical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalDataFormats"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
          "Sparse Arrays" :> 
          Documentation`HelpLookup["paclet:guide/SparseArrays"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 3->"\<\"Mathematical Data\"\>", 
       4->"\<\"Mathematical Data Formats\"\>", 
       5->"\<\"Matrices and Linear Algebra\"\>", 
       6->"\<\"Numerical Data Formats\"\>", 
       7->"\<\"Sparse Arrays\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "HarwellBoeing ",
 StyleBox["(.rsa, .rua, ...)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "Harwell\[Dash]Boeing matrix format.\nUsed for exchanging and storing sparse \
matrices.\nPlain text format.\nFile format of the Harwell\[Dash]Boeing \
collection of standard test matrices.\nThe three-letter file extension \
encodes matrix properties that are also represented in the file. \nThe first \
letter of the file extension encodes the data type: ",
 StyleBox["\"r\"", "InlineCode"],
 " (real), ",
 StyleBox["\"c\"", "InlineCode"],
 " (complex), or ",
 StyleBox["\"p\"", "InlineCode"],
 " (pattern).\nThe second letter denotes the symmetry property: ",
 StyleBox["\"s\"", "InlineCode"],
 " (symmetric), ",
 StyleBox["\"u\"", "InlineCode"],
 " (unsymmetric), ",
 StyleBox["\"h\"", "InlineCode"],
 " (hermitian), ",
 StyleBox["\"z\"", "InlineCode"],
 " (skew-symmetric), or",
 StyleBox[" \"r\"", "InlineCode"],
 " (rectangular).\nThe third letter of the file extension is either ",
 StyleBox["\"a\"", "InlineCode"],
 " (assembled) or ",
 StyleBox["\"e\"", "InlineCode"],
 " (elemental unassembled).\nStores matrices in a sparse representation.\n\
Developed in 1992 by Iain Duff, Roger Grimes and John Lewis."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the Harwell\[Dash]Boeing file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", "]"}]], "InlineFormula"],
 "imports a matrix from a Harwell\[Dash]Boeing file."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports any numerical or pattern matrix to a Harwell\[Dash]Boeing file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", "]"}], " "}]], "InlineFormula"],
 "reads a Harwell\[Dash]Boeing file, returning the matrix it represents as a \
sparse array. "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a Harwell\[Dash]Boeing file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 Cell[BoxData[
  RowBox[{
   RowBox[{",", " ", "\"\<HarwellBoeing\>\""}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<HarwellBoeing\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a Harwell-Boeing file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the Harwell\[Dash]Boeing file format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->2010768115],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "matrix data given as a sparse array", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "a visual representation of the values of the matrix elements", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->29555966],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default. "
}], "FormatNotes",
 CellID->7162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).rsa\>\"", ",", "\"\<Graphics\>\""}], "]"}]], 
  "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " to render the matrix structure as graphics."
}], "FormatNotes",
 CellID->1920226571],

Cell["Meta-information elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Key\>\"", Cell[
    "document identification string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Title\>\"", Cell[
    "document title", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MatrixStructure\>\"", Cell[
    "symmetry properties of the matrix", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->977886736],

Cell[TextData[{
 "Possible values for",
 Cell[BoxData[
  RowBox[{" ", "\"\<MatrixStructure\>\""}]], "InlineFormula"],
 " are:"
}], "FormatNotes",
 CellID->678398105],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Hermitian\>\"", Cell[
    "matrix which is equal to its own conjugate transpose", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rectangular\>\"", Cell[
    "non-square matrix", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SkewSymmetric\>\"", Cell[
    "matrix whose transpose is also its negative", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symmetric\>\"", Cell[
    "matrix which is equal to its transpose ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Unsymmetric\>\"", Cell[
    "square matrix without transposition symmetry", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->846268812]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<Graph6\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Graph6"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Sparse6\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Sparse6"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MTX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MTX"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1644269022]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->322760746],

Cell["\<\
Import a Harwell-Boeing matrix file and render it as graphics:\
\>", "ExampleText",
 CellID->1308334297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/mcca.rua.gz\>\"", ",", " ", "\"\<Graphics\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzs3Xk0Vf/fN35JlAZFGSOZo5BUIj1TKSXSpEFpFGWKBtGAkhRSaI6USqWo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   "], {{0, 0}, {90, 90}}, {0, 1}],
  Frame->True,
  FrameLabel->{None, None},
  FrameTicks->{{{{89.75, 
       FormBox["1", TraditionalForm]}, {65.25, 
       FormBox["50", TraditionalForm]}, {40.25, 
       FormBox["100", TraditionalForm]}, {15.25, 
       FormBox["150", TraditionalForm]}, {0.25, 
       FormBox["180", TraditionalForm]}}, {{89.75, 
       FormBox["1", TraditionalForm]}, {65.25, 
       FormBox["50", TraditionalForm]}, {40.25, 
       FormBox["100", TraditionalForm]}, {15.25, 
       FormBox["150", TraditionalForm]}, {0.25, 
       FormBox["180", TraditionalForm]}}}, {{{0.25, 
       FormBox["1", TraditionalForm]}, {24.75, 
       FormBox["50", TraditionalForm]}, {49.75, 
       FormBox["100", TraditionalForm]}, {74.75, 
       FormBox["150", TraditionalForm]}, {89.75, 
       FormBox["180", TraditionalForm]}}, {{0.25, 
       FormBox["1", TraditionalForm]}, {24.75, 
       FormBox["50", TraditionalForm]}, {49.75, 
       FormBox["100", TraditionalForm]}, {74.75, 
       FormBox["150", TraditionalForm]}, {89.75, 
       FormBox["180", TraditionalForm]}}}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->1925236178]
}, Open  ]],

Cell["Read the same file as a sparse array:", "ExampleText",
 CellID->679824367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", "\"\<ExampleData/mcca.rua.gz\>\"", "]"}], 
  " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1011227477],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2659", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2659, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"180", ",", "180"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->1569094961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1195134129],

Cell[TextData[{
 "Import a sparse matrix and render it as a ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1204755712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", " ", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/mcca.rua.gz\>\"", "]"}], " ", ",", 
   " ", 
   RowBox[{"ImageSize", "\[Rule]", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92760326],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw91nk4FOr3APBpzGaSrWtfx4xZ7GMrSY41S8m+RFEka1qEShItV7lJuhou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    "], {
     {RGBColor[0.5, 0., 0.], LineBox[CompressedData["
1:eJwVj/1jm2Tbhv3+/p5atc464xa72MYWG2ywYMGCBQsWLFiwYMGCBQsOHDh4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       "]]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "102"],
       Annotation[#, 102, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "104"],
       Annotation[#, 104, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "116"],
       Annotation[#, 116, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "126"],
       Annotation[#, 126, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "127"],
       Annotation[#, 127, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "128"],
       Annotation[#, 128, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "129"],
       Annotation[#, 129, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        "130"],
       Annotation[#, 130, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        "131"],
       Annotation[#, 131, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        "132"],
       Annotation[#, 132, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        "133"],
       Annotation[#, 133, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        "134"],
       Annotation[#, 134, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        "135"],
       Annotation[#, 135, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        "136"],
       Annotation[#, 136, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        "137"],
       Annotation[#, 137, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        "138"],
       Annotation[#, 138, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        "139"],
       Annotation[#, 139, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        "140"],
       Annotation[#, 140, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        "141"],
       Annotation[#, 141, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        "142"],
       Annotation[#, 142, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        "143"],
       Annotation[#, 143, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        "145"],
       Annotation[#, 145, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        "146"],
       Annotation[#, 146, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[147],
        "147"],
       Annotation[#, 147, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[148],
        "148"],
       Annotation[#, 148, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[149],
        "149"],
       Annotation[#, 149, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[150],
        "150"],
       Annotation[#, 150, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[151],
        "151"],
       Annotation[#, 151, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[152],
        "152"],
       Annotation[#, 152, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[153],
        "153"],
       Annotation[#, 153, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[154],
        "154"],
       Annotation[#, 154, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[155],
        "155"],
       Annotation[#, 155, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[156],
        "156"],
       Annotation[#, 156, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[157],
        "157"],
       Annotation[#, 157, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[158],
        "158"],
       Annotation[#, 158, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[159],
        "159"],
       Annotation[#, 159, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[160],
        "160"],
       Annotation[#, 160, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[161],
        "161"],
       Annotation[#, 161, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[162],
        "162"],
       Annotation[#, 162, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[163],
        "163"],
       Annotation[#, 163, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[164],
        "164"],
       Annotation[#, 164, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[165],
        "165"],
       Annotation[#, 165, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[166],
        "166"],
       Annotation[#, 166, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[167],
        "167"],
       Annotation[#, 167, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[168],
        "168"],
       Annotation[#, 168, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[169],
        "169"],
       Annotation[#, 169, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[170],
        "170"],
       Annotation[#, 170, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[171],
        "171"],
       Annotation[#, 171, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[172],
        "172"],
       Annotation[#, 172, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[173],
        "173"],
       Annotation[#, 173, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[174],
        "174"],
       Annotation[#, 174, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[175],
        "175"],
       Annotation[#, 175, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[176],
        "176"],
       Annotation[#, 176, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[177],
        "177"],
       Annotation[#, 177, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[178],
        "178"],
       Annotation[#, 178, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[179],
        "179"],
       Annotation[#, 179, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[180],
        "180"],
       Annotation[#, 180, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw91nk4FOr3APBpzGaSrWtfx4xZ7GMrSY41S8m+RFEka1qEShItV7lJuhou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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->Medium,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->2001597907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524692694],

Cell["This exports a 1-by-2 matrix to the Harwell-Boeing format:", \
"ExampleText",
 CellID->942253476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"11.", ",", "22."}], "}"}], "}"}], ",", " ", 
   "\"\<HarwellBoeing\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514029619],

Cell[BoxData["\<\"Created by Wolfram Mathematica 6.0                          \
            Wolfram \\n3             1             1             1            \
 0             \\nRRA           1             2             2             0   \
          \\n(40I2)          (40I2)           (3E26.16)          \\n1 2 3 \
\\n1 1 \\n1.1000000000000000E+01    2.2000000000000000E+01    \\n\"\>"], \
"Output",
 CellLabel->"Out[1]=",
 CellID->156183601]
}, Open  ]],

Cell["Import the previous output:", "ExampleText",
 CellID->1276408948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->572305902],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->2037187605]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HarwellBoeing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 51.9805820}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Harwell-Boeing matrix format. Used for exchanging and storing sparse \
matrices. Plain text format. File format of the Harwell-Boeing collection of \
standard test matrices. The three-letter file extension encodes matrix \
properties that are also represented in the file. The first letter of the \
file extension encodes the data type: \"r\" (real), \"c\" (complex), or \"p\" \
(pattern). The second letter denotes the symmetry property: \"s\" \
(symmetric), \"u\" (unsymmetric), \"h\" (hermitian), \"z\" (skew-symmetric), \
or \"r\" (rectangular). The third letter of the file extension is either \
\"a\" (assembled) or \"e\" (elemental unassembled). Stores matrices in a \
sparse representation. Developed in 1992 by Iain Duff, Roger Grimes and John \
Lewis.", "synonyms" -> {}, "title" -> "HarwellBoeing", "type" -> "Format", 
    "uri" -> "ref/format/HarwellBoeing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16816, 571, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 114958, 2724}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2322, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2945, 78, 122, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[3070, 84, 1167, 28, 70, "FormatUsage",
 CellID->20778],
Cell[4240, 114, 345, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[4622, 131, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4689, 134, 295, 9, 70, "FormatNotes",
 CellID->2520],
Cell[4987, 145, 366, 11, 70, "FormatNotes",
 CellID->12927],
Cell[5356, 158, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[5398, 161, 359, 11, 70, "FormatNotes",
 CellID->25134],
Cell[5760, 174, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5802, 177, 358, 11, 70, "FormatNotes",
 CellID->22675],
Cell[6163, 190, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[6740, 212, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[7325, 235, 749, 26, 70, "FormatNotes",
 CellID->21001],
Cell[8077, 263, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[8118, 266, 524, 18, 70, "FormatNotes",
 CellID->9310],
Cell[8645, 286, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[9723, 328, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[10387, 352, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[11206, 382, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[11247, 385, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11611, 401, 364, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[12012, 418, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[12066, 421, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12261, 431, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12931, 446, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12973, 449, 73, 1, 70, "FormatNotes",
 CellID->2010768115],
Cell[13049, 452, 528, 12, 70, "2ColumnTableMod",
 CellID->29555966],
Cell[13580, 466, 253, 9, 70, "FormatNotes",
 CellID->7162],
Cell[13836, 477, 471, 16, 70, "FormatNotes",
 CellID->1920226571],
Cell[14310, 495, 65, 1, 70, "FormatNotes",
 CellID->13573],
Cell[14378, 498, 605, 13, 70, "2ColumnTableMod",
 CellID->977886736],
Cell[14986, 513, 165, 6, 70, "FormatNotes",
 CellID->678398105],
Cell[15154, 521, 931, 17, 70, "2ColumnTableMod",
 CellID->846268812]
}, Open  ]],
Cell[CellGroupData[{
Cell[16122, 543, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[16175, 546, 604, 20, 70, "SeeAlso",
 CellID->1644269022]
}, Open  ]],
Cell[CellGroupData[{
Cell[16816, 571, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16932, 577, 60, 1, 70, "ExampleSection",
 CellID->322760746],
Cell[16995, 580, 114, 3, 70, "ExampleText",
 CellID->1308334297],
Cell[CellGroupData[{
Cell[17134, 587, 174, 5, 70, "Input",
 CellID->17199],
Cell[17311, 594, 59668, 987, 70, "Output",
 CellID->1925236178]
}, Open  ]],
Cell[76994, 1584, 80, 1, 70, "ExampleText",
 CellID->679824367],
Cell[CellGroupData[{
Cell[77099, 1589, 154, 5, 70, "Input",
 CellID->1011227477],
Cell[77256, 1596, 402, 14, 70, "Output",
 CellID->1569094961]
}, Open  ]],
Cell[77673, 1613, 126, 3, 70, "ExampleDelimiter",
 CellID->1195134129],
Cell[77802, 1618, 228, 8, 70, "ExampleText",
 CellID->1204755712],
Cell[CellGroupData[{
Cell[78055, 1630, 253, 7, 70, "Input",
 CellID->92760326],
Cell[78311, 1639, 32307, 954, 70, "Output",
 CellID->2001597907]
}, Open  ]],
Cell[110633, 2596, 125, 3, 70, "ExampleDelimiter",
 CellID->524692694],
Cell[110761, 2601, 103, 2, 70, "ExampleText",
 CellID->942253476],
Cell[CellGroupData[{
Cell[110889, 2607, 245, 8, 70, "Input",
 CellID->1514029619],
Cell[111137, 2617, 443, 7, 70, "Output",
 CellID->156183601]
}, Open  ]],
Cell[111595, 2627, 71, 1, 70, "ExampleText",
 CellID->1276408948],
Cell[CellGroupData[{
Cell[111691, 2632, 108, 3, 70, "Input",
 CellID->572305902],
Cell[111802, 2637, 392, 14, 70, "Output",
 CellID->2037187605]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112255, 2658, 38, 0, 70, "MoreAboutSection"],
Cell[112296, 2660, 134, 2, 70, "MoreAbout"],
Cell[112433, 2664, 133, 2, 70, "MoreAbout"],
Cell[112569, 2668, 125, 2, 70, "MoreAbout"],
Cell[112697, 2672, 140, 2, 70, "MoreAbout"],
Cell[112840, 2676, 143, 2, 70, "MoreAbout"],
Cell[112986, 2680, 134, 2, 70, "MoreAbout"],
Cell[113123, 2684, 117, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[113255, 2689, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

