(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25564,        881]
NotebookOptionsPosition[     20755,        721]
NotebookOutlinePosition[     21974,        757]
CellTagsIndexPosition[     21889,        752]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary" :> 
          Documentation`HelpLookup["paclet:ref/format/Binary"], "Bit" :> 
          Documentation`HelpLookup["paclet:ref/format/Bit"], "Byte" :> 
          Documentation`HelpLookup["paclet:ref/format/Byte"], "Character8" :> 
          Documentation`HelpLookup["paclet:ref/format/Character8"], 
          "Character16" :> 
          Documentation`HelpLookup["paclet:ref/format/Character16"], 
          "Integer8" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer8"], "Integer32" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer32"], 
          "Integer64" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer64"], 
          "Integer128" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer128"], 
          "UnsignedInteger8" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger8"], 
          "UnsignedInteger16" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger16"], 
          "UnsignedInteger24" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger24"], 
          "UnsignedInteger32" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger32"], 
          "UnsignedInteger64" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger64"], 
          "UnsignedInteger128" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger128"], 
          "Real32" :> Documentation`HelpLookup["paclet:ref/format/Real32"], 
          "Real64" :> Documentation`HelpLookup["paclet:ref/format/Real64"], 
          "Real128" :> Documentation`HelpLookup["paclet:ref/format/Real128"], 
          "Complex64" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex64"], 
          "Complex128" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex128"], 
          "Complex256" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex256"], "String" :> 
          Documentation`HelpLookup["paclet:ref/format/String"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary\"\>", 2->"\<\"Bit\"\>", 
       3->"\<\"Byte\"\>", 4->"\<\"Character8\"\>", 5->"\<\"Character16\"\>", 
       6->"\<\"Integer8\"\>", 7->"\<\"Integer32\"\>", 8->"\<\"Integer64\"\>", 
       9->"\<\"Integer128\"\>", 10->"\<\"UnsignedInteger8\"\>", 
       11->"\<\"UnsignedInteger16\"\>", 12->"\<\"UnsignedInteger24\"\>", 
       13->"\<\"UnsignedInteger32\"\>", 14->"\<\"UnsignedInteger64\"\>", 
       15->"\<\"UnsignedInteger128\"\>", 16->"\<\"Real32\"\>", 
       17->"\<\"Real64\"\>", 18->"\<\"Real128\"\>", 19->"\<\"Complex64\"\>", 
       20->"\<\"Complex128\"\>", 21->"\<\"Complex256\"\>", 
       22->"\<\"String\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integer16", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Uniform sequence of signed 16-bit integers.
Binary data format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read any file as a sequence of signed 16-bit integers."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " writes a list of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"-", "2"}], "15"], ",", 
     SuperscriptBox["2", "15"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " to a binary file."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Integer16\>\""}], "]"}]], 
  "InlineFormula"],
 " imports an arbitrary file as a sequence of signed 16-bit integers, \
returning a packed array of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"-", "2"}], "15"], ",", 
     SuperscriptBox["2", "15"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<Integer16\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"-", "2"}], "15"], ",", 
     SuperscriptBox["2", "15"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " to a binary sequence of 16-bit integers."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Integer16\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Integer16\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "Integer16",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[TextData[{
     "list of integers in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"-", "2"}], "15"], ",", 
         SuperscriptBox["2", "15"], "-", "1"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->611127238],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Integer16\>\"", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], " "}]], "InlineFormula"],
 "gives the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " 16-bit integer."
}], "FormatNotes",
 CellID->61452522],

Cell["\<\
Trailing bytes are ignored if the size of the imported file is not a multiple \
of the data size.\
\>", "FormatNotes",
 CellID->647021390]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell["General option:", "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["what byte ordering to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2140947909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Binary"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Bit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Bit"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Byte",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Byte"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex256",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex256"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/String"]], "InlineFormula"]
}], "SeeAlso",
 CellID->344804987]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28203978],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->159368275],

Cell["\<\
Convert a list of integers to a string representing binary 8-bit unsigned \
integers:\
\>", "ExampleText",
 CellID->1155101741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"945", ",", "946"}], "}"}], ",", "\"\<Integer16\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->841536072],

Cell[BoxData["\<\"\[PlusMinus]\.03\.b2\.03\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1746849581]
}, Open  ]],

Cell["Convert the binary data back to a list of integers:", "ExampleText",
 CellID->378706212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"s", ",", "\"\<Integer16\>\""}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1137055818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"945", ",", "946"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1051969730]
}, Open  ]],

Cell["Show the byte values of the exported data:", "ExampleText",
 CellID->1538967698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"s", ",", "\"\<Byte\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10868426],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"177", ",", "3", ",", "178", ",", "3"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->953429755]
}, Open  ]],

Cell["Import as 16-bit Unicode characters:", "ExampleText",
 CellID->1849666884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"s", ",", "\"\<Character16\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1242360482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Alpha]\"\>", ",", "\<\"\[Beta]\"\>"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1918402018]
}, Open  ]],

Cell["Interpret as raw 16-bit Unicode text:", "ExampleText",
 CellID->807004019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"s", ",", "\"\<Text\>\"", ",", " ", 
   RowBox[{"CharacterEncoding", "\[Rule]", " ", "\"\<Unicode\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->263240468],

Cell[BoxData["\<\"\[Alpha]\[Beta]\"\>"], "Output",
 CellLabel->"Out[5]=",
 CellID->1369904158]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integer16 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 55.4494208}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Uniform sequence of signed 16-bit integers. Binary data format.", 
    "synonyms" -> {}, "title" -> "Integer16", "type" -> "Format", "uri" -> 
    "ref/format/Integer16"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18320, 613, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21755, 745}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4010, 79, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4633, 106, 55, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[4691, 109, 113, 4, 70, "FormatUsage",
 CellID->37585799],
Cell[4807, 115, 232, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[5042, 124, 441, 16, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5520, 145, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[5587, 148, 615, 21, 70, "FormatNotes",
 CellID->28652],
Cell[6205, 171, 609, 21, 70, "FormatNotes",
 CellID->8194],
Cell[6817, 194, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6859, 197, 747, 27, 70, "FormatNotes",
 CellID->29174],
Cell[7609, 226, 627, 22, 70, "FormatNotes",
 CellID->943],
Cell[8239, 250, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[8280, 253, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[8644, 269, 358, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[9039, 288, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[9098, 291, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[9297, 301, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[9992, 317, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[10036, 320, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[10110, 323, 615, 18, 70, "2ColumnTableMod",
 CellID->611127238],
Cell[10728, 343, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[11118, 360, 555, 20, 70, "FormatNotes",
 CellID->61452522],
Cell[11676, 382, 148, 4, 70, "FormatNotes",
 CellID->647021390]
}, Open  ]],
Cell[CellGroupData[{
Cell[11861, 391, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[11917, 394, 58, 1, 70, "FormatNotes",
 CellID->577662107],
Cell[11978, 397, 461, 12, 70, "3ColumnTableMod",
 CellID->2140947909],
Cell[12442, 411, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[12627, 420, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902]
}, Closed]],
Cell[CellGroupData[{
Cell[13057, 434, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[13115, 437, 4685, 153, 70, "SeeAlso",
 CellID->344804987]
}, Open  ]],
Cell[CellGroupData[{
Cell[17837, 595, 57, 1, 70, "MoreAboutSection",
 CellID->28203978],
Cell[17897, 598, 113, 2, 70, "MoreAbout"],
Cell[18013, 602, 134, 2, 70, "MoreAbout"],
Cell[18150, 606, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18320, 613, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18436, 619, 60, 1, 70, "ExampleSection",
 CellID->159368275],
Cell[18499, 622, 137, 4, 70, "ExampleText",
 CellID->1155101741],
Cell[CellGroupData[{
Cell[18661, 630, 240, 8, 70, "Input",
 CellID->841536072],
Cell[18904, 640, 103, 2, 70, "Output",
 CellID->1746849581]
}, Open  ]],
Cell[19022, 645, 94, 1, 70, "ExampleText",
 CellID->378706212],
Cell[CellGroupData[{
Cell[19141, 650, 153, 4, 70, "Input",
 CellID->1137055818],
Cell[19297, 656, 121, 4, 70, "Output",
 CellID->1051969730]
}, Open  ]],
Cell[19433, 663, 86, 1, 70, "ExampleText",
 CellID->1538967698],
Cell[CellGroupData[{
Cell[19544, 668, 141, 4, 70, "Input",
 CellID->10868426],
Cell[19688, 674, 140, 4, 70, "Output",
 CellID->953429755]
}, Open  ]],
Cell[19843, 681, 80, 1, 70, "ExampleText",
 CellID->1849666884],
Cell[CellGroupData[{
Cell[19948, 686, 150, 4, 70, "Input",
 CellID->1242360482],
Cell[20101, 692, 146, 4, 70, "Output",
 CellID->1918402018]
}, Open  ]],
Cell[20262, 699, 80, 1, 70, "ExampleText",
 CellID->807004019],
Cell[CellGroupData[{
Cell[20367, 704, 225, 6, 70, "Input",
 CellID->263240468],
Cell[20595, 712, 94, 2, 70, "Output",
 CellID->1369904158]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[20728, 719, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

