(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    246281,       4726]
NotebookOptionsPosition[    239605,       4511]
NotebookOutlinePosition[    241109,       4551]
CellTagsIndexPosition[    241022,       4546]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"JPEG\"" :> Documentation`HelpLookup["paclet:ref/format/JPEG"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"JPEG\\\"\"\>", 3->"\<\"\\\"PNG\\\"\"\>", 
       4->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       3->"\<\"New in 6.0: Import & Export Formats\"\>", 
       4->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "JPEG2000 ",
 StyleBox["(.jp2, .j2k)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19790],

Cell[TextData[{
 "MIME type: ",
 Cell[BoxData[
  RowBox[{"image", "/", "jp2"}]], "InlineFormula"],
 ".\nJPEG2000 raster image and compression format.\nUsed for photographic \
images.\nJPEG is an acronym for Joint Photographic Experts Group.\nBinary \
file format.\nSupports a variety of color resolutions and opacity.",
 StyleBox["\n",
  FontSlant->"Italic"],
 "Uses lossy or lossless compression based on wavelet transforms.\nCan store \
images as an array of rectangular tiles that are encoded separately."
}], "FormatUsage",
 CellID->6582],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the JP2 file format as well as the JPEG2000 features specified in \
part 1 of the I",
 "SO 15444",
 " standard."
}], "FormatNotes",
 CellID->13578]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->11159],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"jp2\", \"MR\"]\)\>\"", "]"}]], "InlineFormula"],
 " imports a JPEG2000 file, returning a graphics object."
}], "FormatNotes",
 CellID->20418],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as an image to a JPEG2000 file."
}], "FormatNotes",
 CellID->26489],

Cell["", "WeakDivider",
 CellID->159],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of color values."
}], "FormatNotes",
 CellID->3449],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a JPEG2000 image with the same image size as the displayed form of \
",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12924],

Cell["\<\
Because JPEG2000 is a raster image format, all fonts are rasterized on \
export.\
\>", "FormatNotes",
 CellID->9072],

Cell["", "WeakDivider",
 CellID->10380],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a JPEG2000 file."
}], "FormatNotes",
 CellID->27008],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->27967],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->10208],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<JPEG2000\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<JPEG2000\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->6477],

Cell["", "WeakDivider",
 CellID->18503],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a JPEG2000 file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15370],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32607],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->14196],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->12074],

Cell["", "WeakDivider",
 CellID->13722],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12611],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the JPEG2000 format."
}], "FormatNotes",
 CellID->19019]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->28761],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a JPEG2000 file into a cell. "
}], "FormatNotes",
 CellID->11056],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a JPEG2000 file."
}], "FormatNotes",
 CellID->12890]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->31163],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16683],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->13716],

Cell["", "WeakDivider",
 CellID->19932],

Cell["Data representation elements:", "FormatNotes",
 CellID->25452],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[TextData[{
     "raster image given as a ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Tiles\>\"", Cell[TextData[{
     "all tiles, represented as an array of ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->2741],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " for JPEG2000 files."
}], "FormatNotes",
 CellID->6813],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jp2\>\"", ",", "\"\<Data\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "gives an array of color values taken to be encoded using the color model \
specified by the \"",
 Cell[BoxData["ColorSpace"], "InlineFormula"],
 "\" option."
}], "FormatNotes",
 CellID->1523155382],

Cell["\<\
The following can be used to select or specify individual tiles:\
\>", "FormatNotes",
 CellID->2862],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Tiles\>\"", ",", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " row of tiles"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Tiles\>\"", ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " tile in row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Tiles\>\"", ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["elem", "TI"]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " tile in row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->10396],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->489333463],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bit resolution used for each color channel in the file ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->4680]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->15460],

Cell["General option:", "FormatNotes",
 CellID->20615],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->10904],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1546800927],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the image as stored in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->597025414],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->27032],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", "8", Cell[
    "bit resolution used for each color channel", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CompressionLevel\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
sets the compression parameter of the image-encoding algorithm\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the exported image", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TileSize\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "pixel dimensions of tiles", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->14387],

Cell[TextData[{
 "Allowed settings for ",
 Cell[BoxData["\"\<BitDepth\>\""], "InlineFormula"],
 " are integers in the range 1 to 31."
}], "FormatNotes",
 CellID->832055160],

Cell[TextData[{
 "Possible values of ",
 Cell[BoxData["\"\<CompressionLevel\>\""], "InlineFormula"],
 " range from 0 to 1, with larger values corresponding to smaller file \
sizes."
}], "FormatNotes",
 CellID->12287],

Cell["\<\
For lossy compression methods, a higher compression level corresponds to a \
lower quality encoding.\
\>", "FormatNotes",
 CellID->10383],

Cell[TextData[{
 Cell[BoxData["\"\<TileSize\>\""], "InlineFormula"],
 " specifies the default size of the image tiles in a JPEG2000 file and is \
normally set to a value of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"2", "^", 
     StyleBox["m", "TI"]}], ",", 
    RowBox[{"2", "^", 
     StyleBox["n", "TI"]}]}], "}"}]], "InlineFormula"],
 ". The tiles in the bottom row and the rightmost column may be smaller than \
the default size."
}], "FormatNotes",
 CellID->32584],

Cell["Detailed properties and settings:", "FormatNotes",
 CellID->3517],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "color space of the image", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageEncoding\>\"", 
    "\"\<JPEG2000\>\"", Cell[
    "compression method used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TileDimensions\>\"", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], Cell[
    "dimensions of the array of tiles", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->17006],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support JPEG2000 alpha channels in gray-level and RGB images."
}], "FormatNotes",
 CellID->8670],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<ImageEncoding\>\""], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->241],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<JPEG2000\>\"", Cell[
    "standard lossy JPEG2000 encoding", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Lossless\>\"", Cell[
    "lossless variant of the JPEG2000 compression method", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->18882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->29621],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17095]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->207240113],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->134609385],

Cell[TextData[{
 "This imports a JPEG2000 sample file as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->510798135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/girl.jp2\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9916],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzkvGdwHOmZ57kR9/2+3ZeLu9gYEzGrkdSGDra8yUpvKivLe++9d1koB+9J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   "], {{0, 0}, {240, 186}}, {0, 255},
   ColorFunction->Automatic],
  ImageMargins->0.,
  ImageSize->{240, 186},
  PlotRange->{{0, 240}, {0, 186}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1798140]
}, Open  ]],

Cell["Read the tile dimensions and tile sizes:", "ExampleText",
 CellID->170204280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/girl.jp2\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<TileDimensions\>\"", ",", " ", "\"\<TileSize\>\""}], "}"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318293221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"64", ",", "80"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1944855997]
}, Open  ]],

Cell[TextData[{
 "Import all tiles and arrange them as a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1778918867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/girl.jp2\>\"", ",", "\"\<Tiles\>\""}], "]"}], " ",
   "//", " ", "Grid"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->156567922],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[RasterBox[CompressedData["
1:eJzFevdXVGm67qx1/4T766x11jlz77kzPbdn7Nw9behuM0ZQQBQEEQUFAclJ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       "], {{0, 0}, {64, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 80},
      PlotRange->{{0, 64}, {0, 80}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJzFmFdzY2mSnjdCf0AXG6GVdqa6LB289x4gAcKRBL333gEgSIKEdwQIkLD0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       "], {{0, 0}, {64, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 80},
      PlotRange->{{0, 64}, {0, 80}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJy1mvVXnNm65+9a8zec+WXm3HNv37Z0p+NICO4Ohbt7sECIAAWFh6CFu7u7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       "], {{0, 0}, {64, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 80},
      PlotRange->{{0, 64}, {0, 80}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJztlulx2zAQhT2TStJBSsmkBDeQziPxwH0wu1gABAlQh21J/oGdzxoKosmH
xXsgf77//fP+4+3t7Tf8/YI/PF569erVq1evXr169erVq1evXr169erVq1ev
B5Rv8d30vFDhjXqepu0Deh4q7DN6HqHq83q+VpX3F3m6pCt67pH3RXrquk/J
11ZLz1bVcyN/rMdnMc+sS615gZzl0DGvEEOCjsV8Gz0vlHR5x3lIvC5uY95V
3Lw/ftnTZsU7V7JkSFs9cq/mO3HW7PDWwmjEWofAuC3G3afwSGtdEGf0FgN4
UmUNfa3Gt7jruEScjj9krzCujk0crF1jBZvslgMH8b7YqFJwYZhm4qKkcMF9
GIsbfeRNBK9QdazA6IDxtBy0OhpQ8Ek/LRawe9wFsHvtdalWcIfiXAmuI0JL
YbakEWmVIpGV5WqC67YxsYE1NaUwu7JYagu2IjVEp17poleZG8RUmd1H+Nj5
mz2TvLHfLcMSBNm7W3uaywVuiF7DP1YHhwScafnhwh3xpo1/gVlcT18DyWbJ
GZjHKGG1tFqVOKOwFRY1p7vvuPnuC3EljJLPAaYEQ2NLjgZWgDQoLyk0RMMw
6adInMIBcV7HKMkRwWQADkASBkpBoFCPqcjdiyMKMxgmwsNBZJdTnGBNfXGn
I944gFYBvaSzo7wjX0V8OietY5zy0gL8WZjz8q4VWNe0fD8JsSJXLCU+/rqe
kK9w9T3ntncjJSNSuIBV5B+h6UBnto0tbYPLJ8s4BBcpb6oG5vz6Nm6a7Dia
86BPZ/XvJM8nMZz5NDA2NuEAn4SYpWRgPLCc4DNnE4yzGeEAmwSjjPDkq0xw
ppYuaUY2+y38BNYVFl0HTuZaIUoLQlfEFpmEljiuKvBkSQTbr1BSiK0YRa8O
HqFnNh1D60wA7JHJLqLeBlfTOZvTrPcARsNBTCziMnF9CzFmA87CANJYZZ2y
VrmANwk4trSHR/Cr2V9nzVpjz9wnNG34ukaMZzEOchrUPCo2aTYbDjArAL5H
JsJXs8LwM2xcNuzzNPE0kVLJ1sBx61j1mGmsmFbmzIywDZqYgUllGDGv8Fnj
IwmfSrjZxtjm/X/Dwhjg59lPE2TNjSPEzQ6jGQYEopcppOotahoBCYwDdJtD
QoczO59W4CuMTwOkTwAQwPCcwocU5U4R4j8XDKcW
       "], {{0, 0}, {48, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{48, 80},
      PlotRange->{{0, 48}, {0, 80}}]},
    {
     GraphicsBox[RasterBox[CompressedData["
1:eJztm+tTFFcWwK3av2Q/58NuVWqT2to1FfOo2mzhYiiNEMAiiBBeg+AiYowO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       "], {{0, 0}, {64, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 80},
      PlotRange->{{0, 64}, {0, 80}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJxdu2d02/eZ5zvn7Ot79uybe3b33j2byUwmbezEdmRLVmNvADtYAAIsINF7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       "], {{0, 0}, {64, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 80},
      PlotRange->{{0, 64}, {0, 80}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJy1mvdXW1m2599a8y/MD7NmZr23al73ezOvuquqX7ddVXY5GwdyjhIogFAC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       "], {{0, 0}, {64, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 80},
      PlotRange->{{0, 64}, {0, 80}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJzt0r0NgzAURlGkTJINMkqUEVggg7AKFQWioGIVTwANf7bJF1BQKpLKprhH
suXuXdm+ps9HekmS5K5103qfsyzL87yqqqZpuq6b53lZOee890twdV2XZWmM
UUDf99rj9hRF0battXYYBrtyH1F6dCd6I2Vous7jOG5JfhW+Z/8wmq6YaZr2
nvAxoul7j2KUdxwTrFOD/rmZkD0Hf8Z/OVVPmJgoE386Ww8AAAAAAAAAAAAA
AAAAALG8AJCCzvc=
       "], {{0, 0}, {48, 80}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{48, 80},
      PlotRange->{{0, 48}, {0, 80}}]},
    {
     GraphicsBox[RasterBox[CompressedData["
1:eJy1mOmPG2cZwCvxX/CNf4APqGSzh3d9e+778ngOz/hc22t77012N9lNsmm2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       "], {{0, 0}, {64, 26}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 26},
      PlotRange->{{0, 64}, {0, 26}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJx1V1dz21ianap937d5mdp9mJmumnV321YkKUZkgAABAmDOBClSEimKEWAS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       "], {{0, 0}, {64, 26}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 26},
      PlotRange->{{0, 64}, {0, 26}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJxFl2ePI1d2hhfwv/AXY7FfDNjeXWk0munIWKycyKpiFVmBxZyKOYdmsZvs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       "], {{0, 0}, {64, 26}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{64, 26},
      PlotRange->{{0, 64}, {0, 26}}], 
     GraphicsBox[RasterBox[CompressedData["
1:eJy1lvlPmnccx5vsv9hv+w/2837puiVb2k3tMV2HUi1iLWBFjoHI4cMNAgKK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       "], {{0, 0}, {48, 26}}, {0, 255},
       ColorFunction->Automatic],
      ImageSize->{48, 26},
      PlotRange->{{0, 48}, {0, 26}}]}
   }],
  "Grid"]], "Output",
 CellLabel->"Out[3]=",
 CellID->330823672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1097919902],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can export arbitrary graphics to JPEG2000:"
}], "ExampleText",
 CellID->1560297890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<saturn.jp2\>\"", ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztnAdUVOe698+6JSc5SYwak5jEaIrGxIKKYu/Yxd6woYCKAooVVEA6wzDD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     "], {{0, 0}, {150, 112}}, {0, 253}],
    Frame->False,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    ImageSize->{150, 112},
    PlotRangeClipping->True]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1003823713],

Cell[BoxData["\<\"saturn.jp2\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->633613559]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JPEG2000 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 49, 56.7307036}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: image/jp2. JPEG2000 raster image and compression format. Used \
for photographic images. JPEG is an acronym for Joint Photographic Experts \
Group. Binary file format. Supports a variety of color resolutions and \
opacity. Uses lossy or lossless compression based on wavelet transforms. Can \
store images as an array of rectangular tiles that are encoded separately.", 
    "synonyms" -> {}, "title" -> "JPEG2000", "type" -> "Format", "uri" -> 
    "ref/format/JPEG2000"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[25657, 891, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 240888, 4539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2063, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2686, 73, 113, 4, 70, "ObjectNameAlt",
 CellID->19790],
Cell[2802, 79, 542, 12, 70, "FormatUsage",
 CellID->6582],
Cell[3347, 93, 414, 15, 70, "FormatNotes",
 CellID->13578]
}, Open  ]],
Cell[CellGroupData[{
Cell[3798, 113, 64, 1, 70, "ImportExportSection",
 CellID->11159],
Cell[3865, 116, 362, 11, 70, "FormatNotes",
 CellID->20418],
Cell[4230, 129, 367, 11, 70, "FormatNotes",
 CellID->26489],
Cell[4600, 142, 37, 1, 70, "WeakDivider",
 CellID->159],
Cell[4640, 145, 747, 26, 70, "FormatNotes",
 CellID->3449],
Cell[5390, 173, 491, 17, 70, "FormatNotes",
 CellID->12924],
Cell[5884, 192, 126, 4, 70, "FormatNotes",
 CellID->9072],
Cell[6013, 198, 39, 1, 70, "WeakDivider",
 CellID->10380],
Cell[6055, 201, 346, 11, 70, "FormatNotes",
 CellID->27008],
Cell[6404, 214, 574, 20, 70, "FormatNotes",
 CellID->27967],
Cell[6981, 236, 582, 21, 70, "FormatNotes",
 CellID->10208],
Cell[7566, 259, 713, 25, 70, "FormatNotes",
 CellID->6477],
Cell[8282, 286, 39, 1, 70, "WeakDivider",
 CellID->18503],
Cell[8324, 289, 519, 18, 70, "FormatNotes",
 CellID->15370],
Cell[8846, 309, 1096, 40, 70, "FormatNotes",
 CellID->32607],
Cell[9945, 351, 662, 22, 70, "FormatNotes",
 CellID->14196],
Cell[10610, 375, 816, 28, 70, "FormatNotes",
 CellID->12074],
Cell[11429, 405, 39, 1, 70, "WeakDivider",
 CellID->13722],
Cell[11471, 408, 361, 14, 70, "FormatNotes",
 CellID->12611],
Cell[11835, 424, 347, 12, 70, "FormatNotes",
 CellID->19019]
}, Closed]],
Cell[CellGroupData[{
Cell[12219, 441, 70, 1, 70, "NotebookInterfaceSection",
 CellID->28761],
Cell[12292, 444, 246, 7, 70, "FormatNotes",
 CellID->11056],
Cell[12541, 453, 158, 4, 70, "FormatNotes",
 CellID->12890]
}, Closed]],
Cell[CellGroupData[{
Cell[12736, 462, 51, 1, 70, "ElementsSection",
 CellID->31163],
Cell[12790, 465, 192, 8, 70, "FormatNotes",
 CellID->16683],
Cell[12985, 475, 669, 13, 70, "2ColumnTableMod",
 CellID->13716],
Cell[13657, 490, 39, 1, 70, "WeakDivider",
 CellID->19932],
Cell[13699, 493, 68, 1, 70, "FormatNotes",
 CellID->25452],
Cell[13770, 496, 1356, 35, 70, "2ColumnTableMod",
 CellID->2741],
Cell[15129, 533, 387, 14, 70, "FormatNotes",
 CellID->6813],
Cell[15519, 549, 468, 15, 70, "FormatNotes",
 CellID->1523155382],
Cell[15990, 566, 110, 3, 70, "FormatNotes",
 CellID->2862],
Cell[16103, 571, 1584, 50, 70, "2ColumnTableMod",
 CellID->10396],
Cell[17690, 623, 197, 8, 70, "FormatNotes",
 CellID->489333463],
Cell[17890, 633, 500, 11, 70, "2ColumnTableMod",
 CellID->4680]
}, Open  ]],
Cell[CellGroupData[{
Cell[18427, 649, 49, 1, 70, "OptionsSection",
 CellID->15460],
Cell[18479, 652, 54, 1, 70, "FormatNotes",
 CellID->20615],
Cell[18536, 655, 517, 15, 70, "3ColumnTableMod",
 CellID->10904],
Cell[19056, 672, 307, 12, 70, "FormatNotes",
 CellID->1546800927],
Cell[19366, 686, 474, 12, 70, "3ColumnTableMod",
 CellID->597025414],
Cell[19843, 700, 178, 7, 70, "FormatNotes",
 CellID->27032],
Cell[20024, 709, 1081, 25, 70, "3ColumnTableMod",
 CellID->14387],
Cell[21108, 736, 172, 5, 70, "FormatNotes",
 CellID->832055160],
Cell[21283, 743, 216, 6, 70, "FormatNotes",
 CellID->12287],
Cell[21502, 751, 147, 4, 70, "FormatNotes",
 CellID->10383],
Cell[21652, 757, 496, 14, 70, "FormatNotes",
 CellID->32584],
Cell[22151, 773, 71, 1, 70, "FormatNotes",
 CellID->3517],
Cell[22225, 776, 804, 19, 70, "3ColumnTableMod",
 CellID->17006],
Cell[23032, 797, 355, 12, 70, "FormatNotes",
 CellID->8670],
Cell[23390, 811, 138, 5, 70, "FormatNotes",
 CellID->241],
Cell[23531, 818, 511, 11, 70, "2ColumnTableMod",
 CellID->18882]
}, Closed]],
Cell[CellGroupData[{
Cell[24079, 834, 50, 1, 70, "SeeAlsoSection",
 CellID->29621],
Cell[24132, 837, 797, 27, 70, "SeeAlso",
 CellID->17095]
}, Open  ]],
Cell[CellGroupData[{
Cell[24966, 869, 58, 1, 70, "MoreAboutSection",
 CellID->207240113],
Cell[25027, 872, 133, 2, 70, "MoreAbout"],
Cell[25163, 876, 165, 2, 70, "MoreAbout"],
Cell[25331, 880, 156, 2, 70, "MoreAbout"],
Cell[25490, 884, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25657, 891, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[25773, 897, 60, 1, 70, "ExampleSection",
 CellID->134609385],
Cell[25836, 900, 222, 8, 70, "ExampleText",
 CellID->510798135],
Cell[CellGroupData[{
Cell[26083, 912, 124, 3, 70, "Input",
 CellID->9916],
Cell[26210, 917, 97060, 1595, 70, "Output",
 CellID->1798140]
}, Open  ]],
Cell[123285, 2515, 83, 1, 70, "ExampleText",
 CellID->170204280],
Cell[CellGroupData[{
Cell[123393, 2520, 273, 8, 70, "Input",
 CellID->318293221],
Cell[123669, 2530, 217, 8, 70, "Output",
 CellID->1944855997]
}, Open  ]],
Cell[123901, 2541, 215, 8, 70, "ExampleText",
 CellID->1778918867],
Cell[CellGroupData[{
Cell[124141, 2553, 205, 6, 70, "Input",
 CellID->156567922],
Cell[124349, 2561, 98335, 1647, 70, "Output",
 CellID->330823672]
}, Open  ]],
Cell[222699, 4211, 126, 3, 70, "ExampleDelimiter",
 CellID->1097919902],
Cell[222828, 4216, 151, 5, 70, "ExampleText",
 CellID->1560297890],
Cell[CellGroupData[{
Cell[223004, 4225, 16444, 275, 70, "Input",
 CellID->1003823713],
Cell[239451, 4502, 88, 2, 70, "Output",
 CellID->633613559]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[239578, 4509, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

