(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    615629,      11137]
NotebookOptionsPosition[    609546,      10943]
NotebookOutlinePosition[    611058,      10984]
CellTagsIndexPosition[    610970,      10979]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"VRML\"" :> Documentation`HelpLookup["paclet:ref/format/VRML"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"], 
          "\"ZPR\"" :> Documentation`HelpLookup["paclet:ref/format/ZPR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"LWO\\\"\"\>", 
       4->"\<\"\\\"Maya\\\"\"\>", 5->"\<\"\\\"NOFF\\\"\"\>", 
       6->"\<\"\\\"OBJ\\\"\"\>", 7->"\<\"\\\"OFF\\\"\"\>", 
       8->"\<\"\\\"PLY\\\"\"\>", 9->"\<\"\\\"POV\\\"\"\>", 
       10->"\<\"\\\"RIB\\\"\"\>", 11->"\<\"\\\"VRML\\\"\"\>", 
       12->"\<\"\\\"X3D\\\"\"\>", 
       13->"\<\"\\\"ZPR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "JVX ",
 StyleBox["(.jvx)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->30422],

Cell["\<\
JavaView 3D geometry format.
Native format of the JavaView visualization software.
Used for the visualization of 2D or 3D geometries.
Can be embedded in web pages and viewed with the JavaView applet.
XML format.
Can store multiple geometries.
Represents 2D or 3D objects as a collection of polygons, lines and points.\
\>", "FormatUsage",
 CellID->27666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the JVX format."
}], "FormatNotes",
 CellID->8486]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->3455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"jvx\", \"MR\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"MR\"]\)\>", "]"}]], "InlineFormula"],
 "imports a JVX file as a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object. "
}], "FormatNotes",
 CellID->2028],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object to JVX."
}], "FormatNotes",
 CellID->29614],

Cell["", "WeakDivider",
 CellID->4860],

Cell[TextData[{
 "For JVX files containing 3D objects, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["polygons", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ", where vertices are given as a list of coordinates, and the polygons are \
represented as integer indices taken to be the corresponding vertices. "
}], "FormatNotes",
 CellID->29253],

Cell[TextData[{
 "2D objects are imported as an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1933090223],

Cell["", "WeakDivider",
 CellID->11777],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a JVX file."
}], "FormatNotes",
 CellID->31348],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->12503],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->10861],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ",",
 Cell[BoxData["\"\<JVX\>\""], "InlineFormula"],
 "] or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<JVX\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22431],

Cell["", "WeakDivider",
 CellID->29082],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a JVX file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->14197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->22106],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).jvx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->8752],

Cell["", "WeakDivider",
 CellID->15821],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the JVX format."
}], "FormatNotes",
 CellID->26281]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->26021],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->24455],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15947],

Cell["", "WeakDivider",
 CellID->27124],

Cell["Data representation elements:", "FormatNotes",
 CellID->18318],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[TextData[{
     "two-dimensional objects in a JVX file represented as ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "3D geometry represented as ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineData\>\"", Cell[TextData[{
     "lines represented as lists of indices, referencing the vertices as \
given by the ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
     " element"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointData\>\"", Cell[
    "point data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexColors\>\"", Cell["\<\
colors associated with each vertex, given as a list of color primitives\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexNormals\>\"", Cell[TextData[{
     "normal vectors corresponding to the vertices given by ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, {None}},
    "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->9135],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " for the JVX files containing 3D geometries, and ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " for files that represent two-dimensional content."
}], "FormatNotes",
 CellID->1774],

Cell[TextData[{
 "When rendering a JVX file representing a color model, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically uses the setting",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1495251562],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements, specifying meta-information:"
}], "FormatNotes",
 CellID->528086330],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CreationDate\>\"", Cell[
    "time and date when the file was exported", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Creator\>\"", Cell[
    "application that generated the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->2144518906]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->9253],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "All options of ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can be given when importing from JVX."
}], "FormatNotes",
 CellID->1022956994],

Cell[TextData[{
 "Meta-information elements, available for ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->6922],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Version\>\"", "\"\<\>\"", Cell["\<\
optional version information for the file content, given as a string\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Keywords\>\"", 
    RowBox[{"{", "}"}], Cell[
    "keywords associated with the stored objects", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShortSummary\>\"", "\"\<\>\"", Cell[
    "brief description of the file content", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Summary\>\"", "\"\<\>\"", Cell[
    "description of the file content", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Title\>\"", "\"\<\!\(\*
StyleBox[\"Mathematica\",
FontSlant->\"Plain\"]\) Graphics\>\"", Cell["document title", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->10635],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1711205541],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ReadDTD\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to validate the file against the DTD format specification\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1130526963],

Cell["Advanced options:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<InvertNormals\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to invert the orientation of vertex normals", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the JVX format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["z", "TI"]}], ",", 
     StyleBox["y", "TI"]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when importing from JVX, and the inverse \
transformation when exporting to JVX."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZPR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZPR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1919681360]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->202849061],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->205660043],

Cell["Import a JVX sample file and render it as 3D graphics:", "ExampleText",
 CellID->58856465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/blend.jvx\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1393707212],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyNnXucT/X2/z9uqRQKKUcRKsmllKSj1kQXUbl9oxtCSDonIZJSTrqqVBRJ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   "], 
   {EdgeForm[RGBColor[0, 0, 0]], FaceForm[RGBColor[1., 1., 1.]], 
    Polygon3DBox[CompressedData["
1:eJwt1nVc1NkXxnGHmXF27W4FXbsxEVtx1V0Tu1BBQUUFTOzu7l4LXQPF7tq1
1lZU7Nr1Zwe2rrWf+7vPH+89d76c68x5zrwWcgdHBPb0SpIkyQ/8x0l1wLw2
59RIhTRIi3RIjxzIjpzIBW/4oAgKoyiKwR/FUQt+qICKqI1KaIQA/Iw6CERd
tERDNEYrtEYbtEcQOqAjghGCSEQgCr3QG30wGIMwRJ+/v+aK1uc3c43GGIzV
LMM14wjNYmaciAmYhMmYiSmYoxkraca5mmU+pmMGZmEhZmOJZq+r2X/TjMsw
DwuwCCuwGBuwFMuxEnGIwU7EYiN2YTf24DiO4S+cwEmcQigOKMPDCFeGF3Ae
8biIS7iMvjijbM9hgLK9ggRcxTVcxw3cwW3cVZ43MQy3lNsoPFVus5XPM837
GC/xBK+V1WJl8kazv8NzvEAiPuAV/lVWMcrqszL5ird4j4/4jk9IyZf7C/Ub
HJxTwQuZkAwpkBlZkBX5kBf5UQAFUQi+KIlSKI0yKIvT/LtFHHYXJahntYvy
nMvBDxXgj4oOm7m5e0o9CdpFZc6VUAVVUQ3VHTZzc/eyem5rFzU510AA6qMx
GiDQYbN9pQybOmwmzagN0Ug9LdAELR0220/KsLXDZtXGYe82V087tEJ78z8L
ZZgcHZVhJ4e921Y9ndEBUeoJQRh6oQui0RORGICBGITRGIUxKKrnWfW8mPYy
GVMwFTMxA7MwG3MwV5lP0Y5mKluzi/mYhwXKeY72Ml95mvxXKE+Tj8ktRjmY
56uxEr8rQ5OJyWqtZl+n/lXqicUabESQMgnGJmWyVXfXq2cb4rADocoqAruU
1V7d3aKefdiJI+rZg6M4huOIxwVcxCVcRgLGq2eQeiYo8+u4hhuYpv6xej4d
k/AAD/EIT/AYT/EMiXiO13iBl/iMDZprM77q85vn5hfPF6oXdbtm2Q2Xl53F
42X7v6vn/7+zkM7L9iRFfbRAA7RBIJqiLTIgPXKhC7zRFbnho57uaIce6glD
XkQin/p7oxv66HkEhsAXJVEKw1Ea5TACZTAafiiLGATpvUKxUe8Vh3D9+6Zn
C1Zhq3o2wPzC3qH33YleiNLdPdiEverZjr44gH44iGj0190/sAt/qmc/BuAI
Bqr/GA7huJ4fxnmcwwXE4yIuYYKej0MCLuMKruIarqt/EsZjinom4iZu4BZu
4w7u6u40TMYM9UxVz1xMxyMswEIswmMsxgM8x0N8wBM8w0d8xyc4+aPgK/Ub
XJxXK/NYJHPazJNTNyvbbcjstNlmoe5WhqYnO1Igh9P2ZMI+fubttNn6OG3m
h3Q3D7LiJ6ftyeW0u8jntDnnd9r8j+puQeRGIaftyeu0eylC/Ut7KcP5DLUC
1Q/+qIhKqIzyTruvs9qR6TF7ND3XtMc6nP+n3J7iF6fNrSH1BTUR79CI1++p
bald0Q59EIYu6IZ+CMcw9EZf9McIRGMchmI4xiOlMsyI6cpwBrIpq5xYqqyW
KUOTyUyswCzE4DcsUba/K6s1yrAAlmMdViIWq8zulW0cCmOt2TvWY6v5LmCj
02a7B2VxEAdwyOzW7M/szuxbmZdDNRxBFbMv1EBVnEQAauFnnEZtxJsd4RKu
4orZDe7iAe7hsTIPV+ZPlO0z3Df7w0OzLzzCK+0iWrt4rczf4ime46XZJxLh
cPE3GPUdPsDJ64/U5NQk8EIKzFbmi5HBZTPP6LK7WKld5HbZbPO4bOYmz0yc
8yIL8sMbPi67i0Ium3Nhl81/i9kj56LIh+IogIIuuxdf6nbtwo/zXmpll93F
PpM359qoiTqohQD8gl9RDw1QHw3RFM3Q3GV30Yh6jhrosru4gJacW6AVOrns
Xh4p/84um2cwtQtCEO6yu0hU5t1dNtue1FCEoSsi0Q29XXYXH7WLPsq8H3og
AlGIRi+MRV/0x0CMwyBMwyiMwXRkVua5MFeZz9Mu8mkXS5XtMmVeTJmvQ0ns
wWGTM45gP/bhEE6Y3HESx3Acl3AZCbhqMsQ1XMcN3FTmpqexeky2TXAbt3AH
j/AMj02+ytZkZTJ8qUwS8QRP1fPa5I43yraXMnynrN7r7iv1fMRb/IsBynA0
vijD77r7QT1J3Pz9Qk3htj3fzJ44p4QT6fEjkiMDNvLzOGw1e+D1drML6h/K
7ajJ3m1z86YWhQ+KoQDywxelUBrlUQ5+qAB/VMQFl+057bI98dRzqMy5Eqqg
KqqhutvuyNw9rx6zo4uoybkGAtx2X6Y/Qc9vaY/13XYvL5R/Q7fN0zxvjAYI
dNtdvFXmTd02w2Zu299IPS3QBK3wyWWz/Yo2bpttkNveba6e9miNjnAo82QI
Ueahbnu3nXrCEIwI9XTGNEzHDMzCTMzGHCzAXCzCPMxHDFrqfdtitf5983wt
VmE9Oui9OmGD3muT+teoZzNisVc9cdiHKESiLw6hn5ktKd8R810xe0VqXp+h
pqGeo55VT3q4kCGp7UmFeH6WmXpR/dmQFtmT2ueZkBd3+Plt3DXfN17fo95H
Qc5/U4tQH1D/Md87zmVRHn6oAH+8dtvnL833jFoZVVEN1VFD/R/M9wQf3bbn
rdv2eOE95/pUt2ZJiRaapSXS6fObnjZogLbqaY6MaK+5OiArsuhuCFqhk3qC
kANhyIku8EYu3e2GjghXTyh80AO51R+BrojU8+4YgGgMxCAMxhCU1PPiGIah
GI4RGIlR6i+FEiijHl/1VERpTMJETMYUTMU0BOh5VT2vp8wXoKGyaoalymoZ
WiuTdohVJhsQrNlNzyYsx2b1rEdnbFMm25VVV93diY3YpZ6tynCP8tmr3Hrq
7n7swAH17FaehxClPE+gH87iDM7hPC4gHqeVc39le0b5X8JFXEYCruCq7o7U
Xkarx+ziJm7gFm7jDu7q7ljtaDyuYQzuYQbGYSbuay+JmK+9vMEKZbgOn5Xh
F8Qpqy1I5rFZJffYDE0mX5GS19+oqak/4gePzTadx2aV3mMz3IcUnDMiFTIj
DdJ6bLbZqAepGag5kAm5kAVZUQD5URCFUBhFPDbzfNST1KIem/kpZVvMY3dR
hloaZVEO5eGHkh6budnRdfh67C6qUauiOmqgJgJQAX9rR/+gosfuojb1tXZR
j/P3pDYTD+emyqSZx2ZlZjdZddTswcrEzNscndASoWiPDsqqq3LopnxyIgTd
0Rk9EYYuyi0KPsqtF/JgIAZgEAZjCIaiv/L8CaMwEqMxBmMxDqUwHMUxAf4o
gUqYqGwXoI6yrYuFynAxflWGS9BCMwZhpWaM0eydNXusZtmgGXtoxp2I1Cy7
0Ad/apa++vyHNeMpfX4z42Sc1lzxmK+5/gMWByK+
     "]], Polygon3DBox[CompressedData["
1:eJw1mwnYleP2xtvv3u/eFZopDTQQSXNyiCY0z8mQeZ6HSjI0KKR5njQpaRCH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     "]], Polygon3DBox[CompressedData["
1:eJw12HV81mUXx/Ft930PpWukjO5SH4GhIjVKSlAkZMFY0KMZDGlGt6R0Cmyj
W1AapUEEkSE+1ENJKiD1fM7r+u6P9+t3nSvOdp1zIbwsGhXfskeAn59fJ38/
Px9fG+dGTuSABwXxDgogG7JrvSgKIxi5UA7lUVb7C+FDVERlfISPEYpqCEE9
1EcDrddAQzRCc9TV/s/QAu3sd0UcYvEVuqIbuiACkYjCAPRHP3RUbPMx8Nfd
sqIHeiJBdxuIQYptvheGKdcA1SWX6pKgvcN13yEYg9EYhaGKhyiH1aqIamVn
RmAsKmAcxiu2+ZGYjomYjBn4RjWdqdjmK2EKZmOWalpdsc1PxRzMxTyds/Pf
Yr5qv0DxTPXI8izCQtW+vuJZyrsYS7BU5+z8MixHS6xQvEC9tDzJWIs26mWy
5i1vClKxB7vxA9qqv+HYi33Yr/7+gku4iN9wDpfxB9JwHhfwp/ZcUj+SVOc0
7b2KCarzHdzCdUzCTdzDXdVvGu5rj+19gIeq6SPFd9QjO/MEj1WruYrvKuff
+AdPdc7OP8Nz1fRfxY/UI8vzEi9UqyWKHyvvK7xGeR52OVTAduKdfm6cH/mw
y8/Nl2RcChVxiPiAn/taXAmVcYT4jdWfcRja+Lvfz/7wRCDS363Znix8o9AR
HZAJ7RCteVu33y8r31jEKEcAsiHO3/03yNZsTx7Eoyd6IEh5e2ne1jNjEAZi
MPLqniUwAiMxSvcci0Ttr6Aa2dpojNOd7e6TMBFT8B9UQVVMxTRMRwjmYRZm
oiZqow7mYC6+RShaYCmWYTGaYQlWYDla4TPVNwXJWIW2qm0q1mktTPXcgI1Y
r9quxibN23p71XcLNitHpGq7Fdu0FqN67sBOey+qreXdpfle6mlv7Mb3ytFJ
+w9gPxLUq0M4iCPqS6L6cAqncUY1P4dfcB5jkKTxYeUYq3nbfxYXMF69Gq/4
N1zEBKThV+Wdoh7a2u+4rN5ZD+fjJm7gmvp4HbdwGwvUO+vVQzzAXSzEX3iE
x+rhIvXlBV7iX/XPevEab/BKfbE++NtfrgFu/zr1IIDYE+DWNqvuPsaB8Aa4
HliODAFufpd6b314m/itAJfDemr7cyJHgOuL9TQT46ZohibIiOz4HF+gJbKh
PcIQjiDkRizi0AnBKITO6IKuKIai+lrcTXly6Ux32D8uiqOwxvHoiRKaL43e
6KPcRbTeF/1QBiXxHr7GECSiEgZjKIbhfVTGaIzAcFRFNYRgFEYiCdWxHCuw
EhG6dzJSkKq7x2Ad1mOD7pd+T4s3Kk+YzmyyHurecRpvwVbd3ea3Ybv1VXdO
v7vFO/XzuujMLnyvWsRrvBt7VJu+qsVBHMIPGGC9x2EcUY0GYQxO4hSOq04n
cBZnMFa1mY4/kYbfMQ2zcBlXcBXfYA5u4CauYzYW4g7u4jYWIBP/yMqMLB5X
r/S6WZwVXo/rQ0a+uRHkcXW0Ptg4D/J6XC1tPh/j/CjgcfVKr5vFBT3u51m/
7Mw7KORxdbQ+2DgYhT2uljb/CeMPEYJfic/jN3xEXAM1cVF3bMi4Eerhv8QN
+DbGpx5372u4h2bETTxuv9XH1luiBZ6qPm8QSRyB1nhO3IZvDKLhwWvmOvNt
j3B0QVf0QSzi0Bf90F/r3TAACRiC3to/FMNQDIuxBNNUy6WYrtjml1lPsAgL
sRwrFdv8KhRXLcvgO6xW3qJYozyLNb8WKTpn55ORqtjm16EsSmCDzljO9fZm
rPfaY3s3YQuO4CAOoBZqow4O4xB+Ql2E4mcc1ZnaWjuOY6ivfSdwDmdxBidx
HhfsXeAUTuMGrlj/rbf4n8f16JZimw/DVXsTuK0edVJs89dwF/fwl87Z+ft4
oF4+VHxLPbc8j/FIveyn+LbyPsHf+Efn7PxTPMNwPFds8wnK4+flHfId43Fv
w+JHyuvPOMDr3kYQ3zzIjBnEeflmUWzz+VAYuZELwSii2OaLet0bWqC3UYy4
uNfltbdWQnmCNF8SpXXOzpdCGcU2X9br3tBKvZdyxOW9Lq+9tQrKU0zzFVFZ
5+x8Jbyr2Obf87p3ZW/yE8bVEYIfiH/EPtQg/hi1sV9vqT7jBqjjdW+xHt+G
aOR1b+yQ3l1j4k+9br+ds/WmaOZ17/Anvato4iiE40/iSL6xiPG693Ld3pH2
2N7O6OJ1b6irYpu3N2lnuqOb170Ne2vdlcty9kA8euqcne+F3l73hvootnl7
k5anH/p63duwt9ZP+S1vfwzwul7OxhxM1duYhYVYpF7a27AeLcYS7S+p9dVY
ox5Zz1Ptjdg7RArWYTO+wyrrG7ZgL3ZgO37EPhyyHmKP9QeHUdd6YP3Rvpra
9zOOIhS10ALn8AtOoQnO4jwu4HM0RwKe4xkeq34D8S9eaM32JOEVXuMlRlkN
8UbzSarfGKuv/Y8Yn8uRiLEIIPb43JrtmYKMjDPhbUxW3sw+N2/ro3XPcsTl
EexzdSnDtxIq+9y9rS7vM34PH+A48TGcQBXiqqiGk8T1+NZGLVwkvoQ0qytx
KOrjD+K7aMq4GRrjltWQ72dojgfEd1S3NsSt0RJPVLO2jNv53Noz1ak94zB8
5XM1+4JvuM/N2/pTr6tbJCJ8LscL1bMDorRme6xO0YhBR9XM8sZq3tatV1n4
dkKccni0Px49kEs9aICpVndM8rk6TcZ0zEBD1cZqMQ9zMRONMBvfYr7P1ehT
3Xs5VmCZ6mN3XYXvsFL3tnuuwWrtb6c7rkWy1iJ0r1SsQ4ruaDnWaz5WtbV7
bsQG5YjS/l3YqXtbzQbhAA7ie/TEj/jJ3hQS0d/qFchfK/BhP/E+ZGGcFdlw
jPgosjPOgZw4ZW/N574W5wp0efb63JncCMJp4uM+N86DvDjjc/PnkJ+4QKDL
fcLn1gviHfxKfBZ/oARxSRTDJeLifEuhNK4Qp6EC47Iog2vE13ED5YnLoSJu
ElfhWxUf4C/i+3iAj4irIwQPiR/jY8bVAt2ZR8Q1+H4S6OZt/Qn+Rl3i2qiF
f4if+lyeDwPdmu15jlDGNQNdnmfEATpTB03gj6ZohuYIVF9a4Uu0DnS9yYw2
aIt2qn96Hyz+Snm8OtMeYepLVo3DEaE+2XwkOiBKPUnvjcUd9fNy6Ew0YtSr
PBrHIk69K6he9UA8OiEY3dETvQJdD4uiEhIwEP0DXR8HYDASUVm9s56NwjAM
Uf+sZ8MxEknq33hMwDj1qqZ6MxWTMUn1rofpmKgzoeqBrU/BHDTGYizBUtU1
vb4WL8Nc9WsRVmON6v2lxmuRrJrbfApSsU51Ta+vxev189rqzAZsVL3DNd6E
zap5tO56FWn4Xfe+huuan6A72t0f4SEe6I5Wk8u4ojXbsw2ZMvDG8FK/axbG
rwJdbPNZkR0Z8TayIYdim8+J7fpddyMXce4MLu9W4iDlz6T5PMinc3Y+L/Ir
tvkC2MO5Hfa+dMZyFkQhFNYe2xuMIiiKkiiF0iiGciiLCiiB4qioPbb3BPlP
4nSg22N738UZ4ltoxLg2auIm8X17S4xD0Rj3VKtW+BJN8Jq51nybKrb5NojA
F/gc4YhUbPMdVNO3MrhaRaGj8lrto5WnleZjEKdzdj4WnRTbfGfV1Hpk9euC
rsprte+mPFGa7454nbPzPdBTsc33Up2tRwnog96qcxnFNj8Qg9AXX2MwhqI/
+qkfAxTbfHmdGY4RGIlEJGE0xirHEIzXHtv7AaootvkJmIhRmIPZmKscY1BN
uUZrPgTzMAWTUEt9rouZmIH56rPVfjlWYIF6uQxrkazaR6qmKUjV/hitb8U2
1dR6tB87sF21SlSt9mEvjuq+x3BA+0fqbkla/xlndLf/A4WahHk=
     "]], Polygon3DBox[CompressedData["
1:eJwt1ElslVUUAOD/tdSqsDYYJVCVSaNCC50LBBa6kGALZVAXIokMKgUlhII4
Ac4gAYzGoEYlTsQpUQsdQYjI2Hlm0hUSbUFoMRLU789/F1/OPSd3OOe9l5f1
WEXZ8rQoih7gOo5zjGr2spBFVHCIXzhBIytpo5WjHOFpVrGOZlrooJP1fEMq
FUVpqXgRRf8Iu7jKUPkwbqRK/jWTrHMYzzgOh7eamCjPJpe8VPJWoVjA5FRy
Nu6tPfQQ78mnmBK61KaJUylKJWe71Xo5HSV7pjCdGZxV66fMejalzOS82iyx
nLnMYUCtjyvMly9gXio5ezFK9jzMIzzENbVB3rbewRY2h1mKQs/b2M47vBt6
i+/8jM/5lI9Db7v4kt18Ed6Ke1vjy25gH/upYiX1/MQBDlLJatrpoJlGXuN1
3qCFNrrp4k16OUlnOLuZLbwV9vRwhtNs5UP6uUAf53iP3xlgkMt8ws7Q86j0
KMriNoazR22keDt3MDo9maWOnxkjH8u49ORsPHu8Zzx3cheHwuz51gVMZhJN
YfZW8uS5FFOUnsx+i7iN7ezgVYaxlZ28zwfcyk3U00AN1eGtwnBnHbVx7+yn
hPIhfiuU8iAt8bt0UiafzTzm062WLq5lHZU8w9/qq8SNbGIDQ0mjlx46aA9v
zQ13dsV3corTLGAJf9LHH5xjEee5wEX6Wc5iVnCJy/wVzi4Lewa5wgCrqeAA
IzN8T2RxMzVqI8TRjGEsB9VqKbQuIIdsmtWa4s+JPHk+xZTQqjZNnEpRRnK2
LczeOSTZM4XpzMhIZo97LrOeTSkzM5LZZ4nlzGVORjJLPPtIf6JLWMoyHmU4
i3mCJ3mKUYzgOZ5nLWuYwESyWcd6XuJFcsKdP/AjVXzFQr5nD3upDm89TgU1
1FIXzi4Ne+ppYB8rQm/HOcERDlMZenuWYxylmabQWyttNIaz8SwvhJ7jPS10
0sEGuumhPZzdyCZeDnu6+I1feYVvuca//MclPuIqmZlRdD038J18d/zZWWdz
D3dnJr21hx4myO+lkILM5K0isZjJ5HBS7RRnyJXncz/3cVbtf9el/zI=
     "]]},
   VertexColors->{
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.3333333333333333, 0.3333333333333333], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6627450980392157, 0.6627450980392157], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2784313725490196, 0.2784313725490196], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7176470588235294, 0.7176470588235294], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.44313725490196076`, 0.44313725490196076`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.5529411764705883, 0.5529411764705883], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.2, 0.2], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.796078431372549, 0.796078431372549], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.1803921568627451, 0.1803921568627451], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8156862745098039, 0.8156862745098039], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.12549019607843137`, 0.12549019607843137`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8705882352941177, 0.8705882352941177], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.1843137254901961, 0.1843137254901961], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8117647058823529, 0.8117647058823529], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.3333333333333333, 0.3333333333333333], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6627450980392157, 0.6627450980392157], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.2, 0.2], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.796078431372549, 0.796078431372549], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.12549019607843137`, 0.12549019607843137`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8705882352941177, 0.8705882352941177], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.08235294117647059, 0.08235294117647059], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9137254901960784, 0.9137254901960784], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 1., 1.], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.996078431372549, 0.996078431372549], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.1411764705882353, 0.1411764705882353], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8549019607843137, 0.8549019607843137], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2392156862745098, 0.2392156862745098], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7568627450980392, 0.7568627450980392], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.996078431372549, 0.996078431372549], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.996078431372549, 0.996078431372549], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.13725490196078433`, 0.13725490196078433`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8588235294117647, 0.8588235294117647], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.396078431372549, 0.396078431372549], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6, 0.6], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2784313725490196, 0.2784313725490196], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7176470588235294, 0.7176470588235294], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.047058823529411764`, 0.047058823529411764`], 
     RGBColor[0, 0.9490196078431372, 0.9490196078431372], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.08627450980392157, 0.08627450980392157], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9098039215686274, 0.9098039215686274], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.3529411764705882, 0.3529411764705882], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6431372549019607, 0.6431372549019607], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.08235294117647059, 0.08235294117647059], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9137254901960784, 0.9137254901960784], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.047058823529411764`, 0.047058823529411764`], 
     RGBColor[0, 0.9490196078431372, 0.9490196078431372], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.07058823529411765, 0.07058823529411765], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9254901960784314, 0.9254901960784314], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10980392156862745`, 0.10980392156862745`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8862745098039215, 0.8862745098039215], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.23137254901960785`, 0.23137254901960785`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7647058823529411, 0.7647058823529411], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.3529411764705882, 0.3529411764705882], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6431372549019607, 0.6431372549019607], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.396078431372549, 0.396078431372549], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6, 0.6], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.1843137254901961, 0.1843137254901961], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8117647058823529, 0.8117647058823529], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.08627450980392157, 0.08627450980392157], 
     RGBColor[0, 0.9098039215686274, 0.9098039215686274], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10980392156862745`, 0.10980392156862745`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8862745098039215, 0.8862745098039215], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.18823529411764706`, 0.18823529411764706`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.807843137254902, 0.807843137254902], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.22352941176470587`, 0.22352941176470587`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7725490196078432, 0.7725490196078432], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.23137254901960785`, 0.23137254901960785`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7647058823529411, 0.7647058823529411], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2392156862745098, 0.2392156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7568627450980392, 0.7568627450980392], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.1411764705882353, 0.1411764705882353], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8549019607843137, 0.8549019607843137], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.13725490196078433`, 0.13725490196078433`], 
     RGBColor[0, 0.8588235294117647, 0.8588235294117647], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.18823529411764706`, 0.18823529411764706`], 
     RGBColor[0, 0.807843137254902, 0.807843137254902], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.2, 0.2], 
     RGBColor[0, 0.796078431372549, 0.796078431372549], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.18823529411764706`, 0.18823529411764706`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.807843137254902, 0.807843137254902], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.13725490196078433`, 0.13725490196078433`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8588235294117647, 0.8588235294117647], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.1411764705882353, 0.1411764705882353], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8549019607843137, 0.8549019607843137], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2392156862745098, 0.2392156862745098], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7568627450980392, 0.7568627450980392], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.23137254901960785`, 0.23137254901960785`], 
     RGBColor[0, 0.7647058823529411, 0.7647058823529411], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.22352941176470587`, 0.22352941176470587`], 
     RGBColor[0, 0.7725490196078432, 0.7725490196078432], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.18823529411764706`, 0.18823529411764706`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.807843137254902, 0.807843137254902], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.10980392156862745`, 0.10980392156862745`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8862745098039215, 0.8862745098039215], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.08627450980392157, 0.08627450980392157], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9098039215686274, 0.9098039215686274], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.1843137254901961, 0.1843137254901961], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8117647058823529, 0.8117647058823529], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.396078431372549, 0.396078431372549], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6, 0.6], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.3529411764705882, 0.3529411764705882], 
     RGBColor[0, 0.6431372549019607, 0.6431372549019607], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.23137254901960785`, 0.23137254901960785`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7647058823529411, 0.7647058823529411], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.10980392156862745`, 0.10980392156862745`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8862745098039215, 0.8862745098039215], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.07058823529411765, 0.07058823529411765], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9254901960784314, 0.9254901960784314], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.047058823529411764`, 0.047058823529411764`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9490196078431372, 0.9490196078431372], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.08235294117647059, 0.08235294117647059], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9137254901960784, 0.9137254901960784], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.3529411764705882, 0.3529411764705882], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6431372549019607, 0.6431372549019607], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.08627450980392157, 0.08627450980392157], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9098039215686274, 0.9098039215686274], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.047058823529411764`, 0.047058823529411764`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9490196078431372, 0.9490196078431372], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2784313725490196, 0.2784313725490196], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7176470588235294, 0.7176470588235294], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.396078431372549, 0.396078431372549], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6, 0.6], 
     RGBColor[0, 0.22745098039215686`, 0.22745098039215686`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7686274509803921, 0.7686274509803921], 
     RGBColor[0, 0.13725490196078433`, 0.13725490196078433`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8588235294117647, 0.8588235294117647], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.996078431372549, 0.996078431372549], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.996078431372549, 0.996078431372549], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.2392156862745098, 0.2392156862745098], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7568627450980392, 0.7568627450980392], 
     RGBColor[0, 0.1411764705882353, 0.1411764705882353], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8549019607843137, 0.8549019607843137], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.996078431372549, 0.996078431372549], 
     RGBColor[0, 0, 0], 
     RGBColor[0, 1., 1.], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.00784313725490196, 0.00784313725490196], 
     RGBColor[0, 0.011764705882352941`, 0.011764705882352941`], 
     RGBColor[0, 0.984313725490196, 0.984313725490196], 
     RGBColor[0, 0.9882352941176471, 0.9882352941176471], 
     RGBColor[0, 0.023529411764705882`, 0.023529411764705882`], 
     RGBColor[0, 0.9725490196078431, 0.9725490196078431], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.08235294117647059, 0.08235294117647059], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9137254901960784, 0.9137254901960784], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.0392156862745098, 0.0392156862745098], 
     RGBColor[0, 0.9568627450980391, 0.9568627450980391], 
     RGBColor[0, 0.03529411764705882, 0.03529411764705882], 
     RGBColor[0, 0.9607843137254902, 0.9607843137254902], 
     RGBColor[0, 0.050980392156862744`, 0.050980392156862744`], 
     RGBColor[0, 0.9450980392156862, 0.9450980392156862], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.12549019607843137`, 0.12549019607843137`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8705882352941177, 0.8705882352941177], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.2, 0.2], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.796078431372549, 0.796078431372549], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.3333333333333333, 0.3333333333333333], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6627450980392157, 0.6627450980392157], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.1843137254901961, 0.1843137254901961], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8117647058823529, 0.8117647058823529], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.12941176470588234`, 0.12941176470588234`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8666666666666667, 0.8666666666666667], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.0784313725490196, 0.0784313725490196], 
     RGBColor[0, 0.9176470588235294, 0.9176470588235294], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.054901960784313725`, 0.054901960784313725`], 
     RGBColor[0, 0.09411764705882353, 0.09411764705882353], 
     RGBColor[0, 0.9019607843137255, 0.9019607843137255], 
     RGBColor[0, 0.9411764705882353, 0.9411764705882353], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.12549019607843137`, 0.12549019607843137`], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8705882352941177, 0.8705882352941177], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.1803921568627451, 0.1803921568627451], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8156862745098039, 0.8156862745098039], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.2823529411764706, 0.2823529411764706], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7137254901960784, 0.7137254901960784], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.16470588235294117`, 0.16470588235294117`], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8313725490196078, 0.8313725490196078], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.14509803921568626`, 0.14509803921568626`], 
     RGBColor[0, 0.8509803921568627, 0.8509803921568627], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.10588235294117647`, 0.10588235294117647`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.16078431372549018`, 0.16078431372549018`], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.8352941176470589, 0.8352941176470589], 
     RGBColor[0, 0.8901960784313725, 0.8901960784313725], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.2, 0.2], 
     RGBColor[0, 0.796078431372549, 0.796078431372549], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44313725490196076`, 0.44313725490196076`], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.5529411764705883, 0.5529411764705883], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34509803921568627`, 0.34509803921568627`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6509803921568628, 0.6509803921568628], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.2784313725490196, 0.2784313725490196], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7176470588235294, 0.7176470588235294], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.15294117647058825`, 0.15294117647058825`], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.24705882352941178`, 0.24705882352941178`], 
     RGBColor[0, 0.7490196078431373, 0.7490196078431373], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.8431372549019608, 0.8431372549019608], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.27058823529411763`, 0.27058823529411763`], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.7254901960784313, 0.7254901960784313], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.20392156862745098`, 0.20392156862745098`], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.3333333333333333, 0.3333333333333333], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.6627450980392157, 0.6627450980392157], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.792156862745098, 0.792156862745098], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.25098039215686274`, 0.25098039215686274`], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.7450980392156863, 0.7450980392156863], 
     RGBColor[0, 0.30196078431372547`, 0.30196078431372547`], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118], 
     RGBColor[0, 0.6941176470588235, 0.6941176470588235], 
     RGBColor[0, 0.34901960784313724`, 0.34901960784313724`], 
     RGBColor[0, 0.4, 0.4], 
     RGBColor[0, 0.44705882352941173`, 0.44705882352941173`], 
     RGBColor[0, 0.4980392156862745, 0.4980392156862745], 
     RGBColor[0, 0.5490196078431373, 0.5490196078431373], 
     RGBColor[0, 0.596078431372549, 0.596078431372549], 
     RGBColor[0, 0.6470588235294118, 0.6470588235294118]},
   VertexNormals->CompressedData["
1:eJx1fXeclMXSNWFJG2BzgoXNsIQlSBSlC1GCIAgoUcBAFpEMkjNIFEkSREki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    "]],
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{1.85, 1.9, 2},
  ViewVertical->{0, 1, 0}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1030756294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1358129635],

Cell["This imports a JVX file representing 2D vector graphics:", "ExampleText",
 CellID->481091482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/world.jvx\>\"", ",", " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255789605],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzVnX98VdWVt2+RamQophYxpZSmTKSRUgwUMWUQrzTSDPJipIhRI14xYsSI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   "], 
   {EdgeForm[RGBColor[0, 0, 0]], 
    {FaceForm[RGBColor[
     0.9215686274509803, 0.7098039215686275, 0.5254901960784314]], 
     PolygonBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
      17}]}, 
    {FaceForm[RGBColor[
     0.6313725490196078, 0.027450980392156862`, 0.5725490196078431]], 
     PolygonBox[{18, 19, 20, 21, 22}]}, 
    {FaceForm[RGBColor[0.2588235294117647, 0.8784313725490196, 0.6]], 
     PolygonBox[{23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
      38, 39}]}, 
    {FaceForm[RGBColor[
     0.1411764705882353, 0.3333333333333333, 0.054901960784313725`]], 
     PolygonBox[{40, 41, 42, 43}]}, 
    {FaceForm[RGBColor[
     0.5058823529411764, 0.8666666666666667, 0.16470588235294117`]], 
     PolygonBox[{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 
      59}]}, 
    {FaceForm[RGBColor[
     0.2549019607843137, 0.4666666666666667, 0.12156862745098039`]], 
     PolygonBox[{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108,
       109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
      165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
      179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
      193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 
      207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
      235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245}]}, 
    {FaceForm[RGBColor[
     0.2549019607843137, 0.4666666666666667, 0.12156862745098039`]], 
     PolygonBox[{246, 247, 248, 249}]}, 
    {FaceForm[RGBColor[
     0.2549019607843137, 0.4666666666666667, 0.12156862745098039`]], 
     PolygonBox[{250, 251, 252, 253, 254, 255, 256}]}, 
    {FaceForm[RGBColor[
     0.2549019607843137, 0.4666666666666667, 0.12156862745098039`]], 
     PolygonBox[{257, 258, 259, 260}]}, 
    {FaceForm[RGBColor[
     0.2549019607843137, 0.4666666666666667, 0.12156862745098039`]], 
     PolygonBox[{261, 262, 263, 264}]}, 
    {FaceForm[RGBColor[
     0.4823529411764706, 0.3764705882352941, 0.6549019607843137]], 
     PolygonBox[{265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 
      277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 
      291, 292, 293, 294, 295, 296, 297}]}, 
    {FaceForm[RGBColor[
     0.4823529411764706, 0.3764705882352941, 0.6549019607843137]], 
     PolygonBox[{298, 299, 300, 301, 302}]}, 
    {FaceForm[RGBColor[
     0.8627450980392157, 0.9254901960784314, 0.3176470588235294]], 
     PolygonBox[{303, 304, 305, 306, 307, 308, 309, 310}]}, 
    {FaceForm[RGBColor[0.7333333333333333, 0.14901960784313725`, 0.4]], 
     PolygonBox[{311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 
      323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 
      337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 
      351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363}]}, 
    {FaceForm[RGBColor[0.7333333333333333, 0.14901960784313725`, 0.4]], 
     PolygonBox[{364, 365, 366}]}, 
    {FaceForm[RGBColor[0.7333333333333333, 0.14901960784313725`, 0.4]], 
     PolygonBox[{367, 368, 369, 370, 371}]}, 
    {FaceForm[RGBColor[0.7333333333333333, 0.14901960784313725`, 0.4]], 
     PolygonBox[{372, 373, 374, 375}]}, 
    {FaceForm[RGBColor[
     0.6862745098039216, 0.7058823529411764, 0.5725490196078431]], 
     PolygonBox[{376, 377, 378, 379, 380, 381, 382, 383, 384, 385}]}, 
    {FaceForm[RGBColor[
     0.13725490196078433`, 0.803921568627451, 0.10196078431372549`]], 
     PolygonBox[{386, 387, 388, 389, 390}]}, 
    {FaceForm[RGBColor[
     0.13725490196078433`, 0.803921568627451, 0.10196078431372549`]], 
     PolygonBox[{391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401}]}, 
    {FaceForm[RGBColor[
     0.43137254901960786`, 0.803921568627451, 0.7450980392156863]], 
     PolygonBox[{402}]}, 
    {FaceForm[RGBColor[
     0.592156862745098, 0.5607843137254902, 0.6352941176470588]], 
     PolygonBox[{403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414, 
      415, 416}]}, 
    {FaceForm[RGBColor[
     0.49019607843137253`, 0.12549019607843137`, 0.4392156862745098]], 
     PolygonBox[{417, 418, 419, 420, 421, 422, 423, 424, 425, 426}]}, 
    {FaceForm[RGBColor[
     0.14901960784313725`, 0.10980392156862745`, 0.4666666666666667]], 
     PolygonBox[{427, 428, 429, 430, 431, 432}]}, 
    {FaceForm[RGBColor[
     0.5725490196078431, 0.22352941176470587`, 0.792156862745098]], 
     PolygonBox[{433, 434, 435, 436}]}, 
    {FaceForm[RGBColor[
     0.7333333333333333, 0.4235294117647059, 0.8235294117647058]], 
     PolygonBox[{437, 438, 439, 440, 441, 442}]}, 
    {FaceForm[RGBColor[
     0.10196078431372549`, 0.027450980392156862`, 0.8470588235294118]], 
     PolygonBox[{443}]}, 
    {FaceForm[RGBColor[
     0.6823529411764706, 0.2980392156862745, 0.9254901960784314]], 
     PolygonBox[{444, 445, 446, 447}]}, 
    {FaceForm[RGBColor[
     0.4117647058823529, 0.8784313725490196, 0.5490196078431373]], 
     PolygonBox[{448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459, 
      460, 461, 462, 463, 464, 465}]}, 
    {FaceForm[RGBColor[
     0.32941176470588235`, 0.8509803921568627, 0.24313725490196078`]], 
     PolygonBox[{466, 467, 468, 469, 470, 471, 472}]}, 
    {FaceForm[RGBColor[
     0.058823529411764705`, 0.20392156862745098`, 0.40784313725490196`]], 
     PolygonBox[{473, 474, 475, 476, 477, 478, 479, 480, 481}]}, 
    {FaceForm[RGBColor[
     0.09019607843137255, 0.9450980392156862, 0.7333333333333333]], 
     PolygonBox[{482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 
      494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504, 505, 506, 507, 
      508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 
      522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 
      536, 537, 538, 539, 540, 541, 542, 543, 544}]}, 
    {FaceForm[RGBColor[
     0.09019607843137255, 0.9450980392156862, 0.7333333333333333]], 
     PolygonBox[{545, 546, 547, 548}]}, 
    {FaceForm[RGBColor[
     0.8313725490196078, 0.8627450980392157, 0.15294117647058825`]], 
     PolygonBox[{549, 550, 551, 552}]}, 
    {FaceForm[RGBColor[
     0.8313725490196078, 0.8627450980392157, 0.15294117647058825`]], 
     PolygonBox[{553, 554, 555}]}, 
    {FaceForm[RGBColor[0, 0.40784313725490196`, 0.03529411764705882]], 
     PolygonBox[{556, 557, 558, 559, 560, 561}]}, 
    {FaceForm[RGBColor[
     0.047058823529411764`, 0.9686274509803922, 0.5607843137254902]], 
     PolygonBox[{562, 563, 564, 565, 566, 567, 568, 569, 570, 571}]}, 
    {FaceForm[RGBColor[
     0.34901960784313724`, 0.7490196078431373, 0.043137254901960784`]], 
     PolygonBox[{572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 
      584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595}]}, 
    {FaceForm[RGBColor[
     0.14509803921568626`, 0.47058823529411764`, 0.19607843137254902`]], 
     PolygonBox[{596, 597, 598, 599}]}, 
    {FaceForm[RGBColor[
     0.7098039215686275, 0.29411764705882354`, 0.22745098039215686`]], 
     PolygonBox[{600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 
      612}]}, 
    {FaceForm[RGBColor[
     0.13725490196078433`, 0.5019607843137255, 0.8823529411764706]], 
     PolygonBox[{613, 614, 615, 616}]}, 
    {FaceForm[RGBColor[
     0.13333333333333333`, 0.18823529411764706`, 0.7647058823529411]], 
     PolygonBox[{617, 618, 619, 620, 621, 622, 623, 624}]}, 
    {FaceForm[RGBColor[
     0.047058823529411764`, 0.27058823529411763`, 0.03137254901960784]], 
     PolygonBox[{625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 
      637, 638, 639}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 
      652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 
      666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 
      680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 
      694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 
      708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 
      722, 723, 724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 
      736, 737, 738, 739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 
      750, 751, 752, 753, 754, 755, 756, 757, 758}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{759, 760, 761, 762}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{763, 764, 765}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{766, 767, 768, 769, 770, 771}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 
      784, 785, 786, 787}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{788, 789, 790, 791, 792, 793}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{794, 795, 796, 797}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{798, 799, 800, 801}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 
      814, 815}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{816, 817, 818, 819, 820}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831, 832, 
      833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844, 845, 846, 
      847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 
      861}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{862, 863, 864, 865}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{866, 867, 868, 869, 870}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{871, 872, 873, 874}]}, 
    {FaceForm[RGBColor[
     0.7647058823529411, 0.6352941176470588, 0.23137254901960785`]], 
     PolygonBox[{875, 876, 877, 878, 879}]}, 
    {FaceForm[RGBColor[
     0.9803921568627451, 0.792156862745098, 0.07450980392156863]], 
     PolygonBox[{880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891, 
      892, 893, 894, 895}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.23137254901960785`, 0.7490196078431373]], 
     PolygonBox[{896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 906, 907, 
      908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 
      922, 923, 924, 925}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.23137254901960785`, 0.7490196078431373]], 
     PolygonBox[{926, 927, 928}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.23137254901960785`, 0.7490196078431373]], 
     PolygonBox[{929, 930, 931, 932}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.23137254901960785`, 0.7490196078431373]], 
     PolygonBox[{933, 934, 935, 936, 937, 938}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.23137254901960785`, 0.7490196078431373]], 
     PolygonBox[{939, 940, 941}]}, 
    {FaceForm[RGBColor[
     0.9294117647058824, 0.40784313725490196`, 0.03137254901960784]], 
     PolygonBox[{942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 952, 953, 
      954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 
      968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981, 
      982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 
      996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 
      1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 
      1020, 1021, 1022}]}, 
    {FaceForm[RGBColor[
     0.9294117647058824, 0.40784313725490196`, 0.03137254901960784]], 
     PolygonBox[{1023, 1024, 1025, 1026, 1027}]}, 
    {FaceForm[RGBColor[
     0.0392156862745098, 0.6352941176470588, 0.1803921568627451]], 
     PolygonBox[{1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 
      1038, 1039, 1040, 1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048}]}, 
    {FaceForm[RGBColor[
     0.8901960784313725, 0.5372549019607843, 0.7490196078431373]], 
     PolygonBox[{1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 
      1059, 1060, 1061}]}, 
    {FaceForm[RGBColor[
     0.043137254901960784`, 0.7019607843137254, 0.7686274509803921]], 
     PolygonBox[{1062, 1063, 1064, 1065, 1066, 1067}]}, 
    {FaceForm[RGBColor[
     0.7019607843137254, 0.7725490196078432, 0.6666666666666666]], 
     PolygonBox[{1068, 1069, 1070, 1071, 1072, 1073, 1074, 1075, 1076, 1077, 
      1078, 1079}]}, 
    {FaceForm[RGBColor[
     0.00392156862745098, 0.06274509803921569, 0.5372549019607843]], 
     PolygonBox[{1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 
      1090, 1091, 1092, 1093}]}, 
    {FaceForm[RGBColor[
     0.6862745098039216, 0.20784313725490194`, 0.9882352941176471]], 
     PolygonBox[{1094, 1095, 1096, 1097, 1098, 1099, 1100}]}, 
    {FaceForm[RGBColor[
     0.6549019607843137, 0.45098039215686275`, 0.4549019607843137]], 
     PolygonBox[{1101, 1102, 1103, 1104}]}, 
    {FaceForm[RGBColor[
     0.058823529411764705`, 0.24313725490196078`, 0.4196078431372549]], 
     PolygonBox[{1105, 1106, 1107, 1108, 1109, 1110, 1111}]}, 
    {FaceForm[RGBColor[
     0.4117647058823529, 0.4235294117647059, 0.058823529411764705`]], 
     PolygonBox[{1112, 1113, 1114, 1115, 1116, 1117, 1118}]}, 
    {FaceForm[RGBColor[
     0.5254901960784314, 0.8745098039215686, 0.6705882352941176]], 
     PolygonBox[{1119, 1120, 1121, 1122, 1123, 1124}]}, 
    {FaceForm[RGBColor[
     0.011764705882352941`, 0.8235294117647058, 0.10588235294117647`]], 
     PolygonBox[{1125, 1126, 1127, 1128}]}, 
    {FaceForm[RGBColor[
     0.9647058823529412, 0.2392156862745098, 0.15294117647058825`]], 
     PolygonBox[{1129, 1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137}]}, 
    {FaceForm[RGBColor[
     0.09803921568627451, 0.9019607843137255, 0.6980392156862745]], 
     PolygonBox[{1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146, 1147, 
      1148}]}, 
    {FaceForm[RGBColor[
     0.4666666666666667, 0.8901960784313725, 0.9137254901960784]], 
     PolygonBox[{1149, 1150, 1151, 1152}]}, 
    {FaceForm[RGBColor[
     0.043137254901960784`, 0.011764705882352941`, 0.43529411764705883`]], 
     PolygonBox[{1153, 1154, 1155, 1156, 1157}]}, 
    {FaceForm[RGBColor[
     0.8509803921568627, 0.796078431372549, 0.592156862745098]], 
     PolygonBox[{1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165}]}, 
    {FaceForm[RGBColor[
     0.0196078431372549, 0.42745098039215684`, 0.7372549019607844]], 
     PolygonBox[{1166, 1167, 1168, 1169, 1170}]}, 
    {FaceForm[RGBColor[
     0.06274509803921569, 0.1411764705882353, 0.7568627450980392]], 
     PolygonBox[{1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1179, 1180, 
      1181, 1182, 1183, 1184, 1185}]}, 
    {FaceForm[RGBColor[
     0.7215686274509804, 0.2392156862745098, 0.03529411764705882]], 
     PolygonBox[{1186, 1187, 1188}]}, 
    {FaceForm[RGBColor[
     0.7215686274509804, 0.2392156862745098, 0.03529411764705882]], 
     PolygonBox[{1189, 1190, 1191}]}, 
    {FaceForm[RGBColor[
     0.788235294117647, 0.4823529411764706, 0.08235294117647059]], 
     PolygonBox[{1192, 1193, 1194}]}, 
    {FaceForm[RGBColor[
     0.9333333333333333, 0.8823529411764706, 0.7803921568627451]], 
     PolygonBox[{1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1204, 
      1205, 1206, 1207}]}, 
    {FaceForm[RGBColor[
     0.615686274509804, 0.043137254901960784`, 0.9686274509803922]], 
     PolygonBox[{1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 
      1218, 1219, 1220, 1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228}]}, 
    {FaceForm[RGBColor[0.7372549019607844, 0.6, 0.6039215686274509]], 
     PolygonBox[{1229, 1230, 1231, 1232, 1233, 1234}]}, 
    {FaceForm[RGBColor[
     0.11764705882352941`, 0.9372549019607843, 0.00784313725490196]], 
     PolygonBox[{1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 
      1245}]}, 
    {FaceForm[RGBColor[0.5843137254901961, 0.6862745098039216, 0.2]], 
     PolygonBox[{1246, 1247, 1248, 1249, 1250, 1251}]}, 
    {FaceForm[RGBColor[
     0.9411764705882353, 0.44313725490196076`, 0.9294117647058824]], 
     PolygonBox[{1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259}]}, 
    {FaceForm[RGBColor[
     0.4745098039215686, 0.7019607843137254, 0.403921568627451]], 
     PolygonBox[{1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 
      1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279}]}, 
    {FaceForm[RGBColor[
     0.1411764705882353, 0.9921568627450981, 0.6196078431372549]], 
     PolygonBox[{1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 
      1289}]}, 
    {FaceForm[RGBColor[
     0.4666666666666667, 0.2549019607843137, 0.21176470588235294`]], 
     PolygonBox[{1290, 1291, 1292}]}, 
    {FaceForm[RGBColor[
     0.00392156862745098, 0.4235294117647059, 0.2823529411764706]], 
     PolygonBox[{1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 
      1303, 1304, 1305, 1306, 1307, 1308}]}, 
    {FaceForm[RGBColor[0.4745098039215686, 0.4, 0.8156862745098039]], 
     PolygonBox[{1309, 1310, 1311, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 
      1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 1330, 
      1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341, 1342, 
      1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 
      1355, 1356, 1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 
      1367, 1368, 1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 
      1379}]}, 
    {FaceForm[RGBColor[0.4745098039215686, 0.4, 0.8156862745098039]], 
     PolygonBox[{1380, 1381, 1382, 1383}]}, 
    {FaceForm[RGBColor[
     0.16470588235294117`, 0.5333333333333333, 0.39215686274509803`]], 
     PolygonBox[{1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 1392, 
      1393}]}, 
    {FaceForm[RGBColor[
     0.23137254901960785`, 0.4745098039215686, 0.3333333333333333]], 
     PolygonBox[{1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 
      1404, 1405}]}, 
    {FaceForm[RGBColor[
     0.44705882352941173`, 0.7843137254901961, 0.5450980392156862]], 
     PolygonBox[{1406, 1407, 1408, 1409, 1410, 1411}]}, 
    {FaceForm[RGBColor[
     0.8549019607843137, 0.7411764705882353, 0.3803921568627451]], 
     PolygonBox[{1412, 1413, 1414, 1415, 1416, 1417, 1418, 1419, 1420, 1421, 
      1422}]}, 
    {FaceForm[RGBColor[
     0.403921568627451, 0.8588235294117647, 0.12156862745098039`]], 
     PolygonBox[{1423, 1424, 1425, 1426, 1427, 1428}]}, 
    {FaceForm[RGBColor[
     0.9098039215686274, 0.14901960784313725`, 0.6470588235294118]], 
     PolygonBox[{1429, 1430, 1431, 1432, 1433, 1434}]}, 
    {FaceForm[RGBColor[
     0.11764705882352941`, 0.4823529411764706, 0.8666666666666667]], 
     PolygonBox[{1435, 1436, 1437, 1438, 1439, 1440, 1441}]}, 
    {FaceForm[RGBColor[
     0.16862745098039217`, 0.7137254901960784, 0.6666666666666666]], 
     PolygonBox[{1442, 1443, 1444, 1445, 1446, 1447, 1448, 1449, 1450, 
      1451}]}, 
    {FaceForm[RGBColor[
     0.7019607843137254, 0.6352941176470588, 0.3176470588235294]], 
     PolygonBox[{1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461, 
      1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 
      1474, 1475, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 
      1486, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1496}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 1506, 
      1507, 1508}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1509, 1510, 1511}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1512, 1513, 1514, 1515}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1516, 1517, 1518, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 
      1526, 1527, 1528, 1529, 1530}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1531, 1532, 1533, 1534, 1535, 1536, 1537}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1538, 1539, 1540}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1541, 1542, 1543}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1544, 1545, 1546}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1547, 1548, 1549, 1550}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1551, 1552, 1553}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1554, 1555, 1556, 1557, 1558}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1559, 1560, 1561}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1562, 1563, 1564, 1565, 1566}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1567, 1568, 1569}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 
      1580, 1581, 1582, 1583}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1584, 1585, 1586}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1587, 1588, 1589}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1590, 1591, 1592}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1593, 1594, 1595}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1596, 1597, 1598}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1599, 1600, 1601}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1602, 1603, 1604, 1605, 1606}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1607, 1608, 1609}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1610, 1611, 1612, 1613, 1614, 1615, 1616}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1617, 1618, 1619, 1620}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.22352941176470587`, 0.2980392156862745]], 
     PolygonBox[{1621, 1622, 1623, 1624, 1625, 1626, 1627, 1628, 1629, 1630, 
      1631, 1632, 1633, 1634, 1635, 1636, 1637}]}, 
    {FaceForm[RGBColor[
     0.8705882352941177, 0.6470588235294118, 0.6745098039215687]], 
     PolygonBox[{1638, 1639, 1640, 1641, 1642, 1643, 1644, 1645, 1646, 1647, 
      1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 
      1659}]}, 
    {FaceForm[RGBColor[
     0.44313725490196076`, 0.12549019607843137`, 0.2627450980392157]], 
     PolygonBox[{1660, 1661, 1662, 1663, 1664, 1665, 1666, 1667, 1668, 1669, 
      1670, 1671}]}, 
    {FaceForm[RGBColor[0.27058823529411763`, 0.580392156862745, 0]], 
     PolygonBox[{1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680}]}, 
    {FaceForm[RGBColor[
     0.3529411764705882, 0.11764705882352941`, 0.9333333333333333]], 
     PolygonBox[{1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688, 1689, 1690, 
      1691}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.8666666666666667, 0.25098039215686274`]], 
     PolygonBox[{1692, 1693, 1694, 1695, 1696, 1697, 1698, 1699, 1700, 1701, 
      1702, 1703, 1704, 1705}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.8666666666666667, 0.25098039215686274`]], 
     PolygonBox[{1706, 1707, 1708, 1709}]}, 
    {FaceForm[RGBColor[
     0.8823529411764706, 0.8666666666666667, 0.25098039215686274`]], 
     PolygonBox[{1710, 1711, 1712, 1713}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.16862745098039217`, 0.19607843137254902`]], 
     PolygonBox[{1714}]}, 
    {FaceForm[RGBColor[
     0.5490196078431373, 0.12549019607843137`, 0.8470588235294118]], 
     PolygonBox[{1715, 1716, 1717, 1718, 1719}]}, 
    {FaceForm[RGBColor[
     0.5490196078431373, 0.12549019607843137`, 0.8470588235294118]], 
     PolygonBox[{1720, 1721, 1722, 1723}]}, 
    {FaceForm[RGBColor[
     0.5490196078431373, 0.12549019607843137`, 0.8470588235294118]], 
     PolygonBox[{1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731, 1732, 1733, 
      1734, 1735}]}, 
    {FaceForm[RGBColor[
     0.5490196078431373, 0.12549019607843137`, 0.8470588235294118]], 
     PolygonBox[{1736, 1737, 1738, 1739, 1740, 1741, 1742, 1743, 1744}]}, 
    {FaceForm[RGBColor[
     0.5490196078431373, 0.12549019607843137`, 0.8470588235294118]], 
     PolygonBox[{1745, 1746, 1747}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.3254901960784314, 0.8235294117647058]], 
     PolygonBox[{1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 1756}]}, 
    {FaceForm[RGBColor[
     0.9764705882352941, 0.11372549019607843`, 0.6470588235294118]], 
     PolygonBox[{1757, 1758, 1759, 1760, 1761, 1762, 1763, 1764, 1765, 1766, 
      1767, 1768, 1769, 1770, 1771, 1772, 1773, 1774, 1775, 1776, 1777, 1778, 
      1779, 1780, 1781, 1782, 1783, 1784, 1785, 1786, 1787, 1788, 1789, 
      1790}]}, 
    {FaceForm[RGBColor[
     0.3803921568627451, 0.8470588235294118, 0.8470588235294118]], 
     PolygonBox[{1791, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799, 
      1800}]}, 
    {FaceForm[RGBColor[
     0.3764705882352941, 0.796078431372549, 0.8431372549019608]], 
     PolygonBox[{1801, 1802, 1803, 1804}]}, 
    {FaceForm[RGBColor[
     0.49411764705882355`, 0.2549019607843137, 0.8627450980392157]], 
     PolygonBox[{1805, 1806, 1807, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 
      1815}]}, 
    {FaceForm[RGBColor[0.9568627450980391, 0.6274509803921569, 0]], 
     PolygonBox[{1816, 1817, 1818, 1819, 1820, 1821, 1822, 1823, 1824, 1825, 
      1826, 1827, 1828, 1829}]}, 
    {FaceForm[RGBColor[
     0.09803921568627451, 0.788235294117647, 0.42745098039215684`]], 
     PolygonBox[{1830, 1831, 1832, 1833, 1834, 1835, 1836, 1837, 1838}]}, 
    {FaceForm[RGBColor[
     0.45098039215686275`, 0.9725490196078431, 0.9411764705882353]], 
     PolygonBox[{1839, 1840, 1841, 1842, 1843}]}, 
    {FaceForm[RGBColor[
     0.6627450980392157, 0.12156862745098039`, 0.14901960784313725`]], 
     PolygonBox[{1844, 1845, 1846, 1847, 1848}]}, 
    {FaceForm[RGBColor[
     0.9647058823529412, 0.5490196078431373, 0.4745098039215686]], 
     PolygonBox[{1849, 1850, 1851, 1852, 1853, 1854, 1855, 1856, 1857, 1858, 
      1859, 1860, 1861, 1862, 1863}]}, 
    {FaceForm[RGBColor[
     0.7686274509803921, 0.11372549019607843`, 0.6980392156862745]], 
     PolygonBox[{1864, 1865, 1866, 1867}]}, 
    {FaceForm[RGBColor[
     0.09411764705882353, 0.9686274509803922, 0.26666666666666666`]], 
     PolygonBox[{1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876}]}, 
    {FaceForm[RGBColor[0.2, 0.8392156862745098, 0.10588235294117647`]], 
     PolygonBox[{1877, 1878, 1879, 1880}]}, 
    {FaceForm[RGBColor[
     0.30980392156862746`, 0.5725490196078431, 0.8352941176470589]], 
     PolygonBox[{1881, 1882, 1883, 1884, 1885, 1886}]}, 
    {FaceForm[RGBColor[
     0.00392156862745098, 0.5176470588235293, 0.14509803921568626`]], 
     PolygonBox[{1887, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 
      1896}]}, 
    {FaceForm[RGBColor[
     0.38431372549019605`, 0.027450980392156862`, 0.5764705882352941]], 
     PolygonBox[{1897, 1898, 1899, 1900, 1901, 1902, 1903, 1904, 1905}]}, 
    {FaceForm[RGBColor[
     0.4784313725490196, 0.2588235294117647, 0.8784313725490196]], 
     PolygonBox[{1906, 1907, 1908, 1909, 1910, 1911, 1912, 1913, 1914, 1915, 
      1916, 1917, 1918, 1919, 1920}]}, 
    {FaceForm[RGBColor[
     0.4784313725490196, 0.2588235294117647, 0.8784313725490196]], 
     PolygonBox[{1921, 1922, 1923, 1924, 1925, 1926, 1927, 1928}]}, 
    {FaceForm[RGBColor[
     0.611764705882353, 0.9294117647058824, 0.7843137254901961]], 
     PolygonBox[{1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 1937, 1938, 
      1939, 1940, 1941, 1942, 1943, 1944, 1945, 1946}]}, 
    {FaceForm[RGBColor[
     0.10588235294117647`, 0.49411764705882355`, 0.23137254901960785`]], 
     PolygonBox[{1947, 1948, 1949, 1950, 1951, 1952, 1953, 1954, 1955, 1956, 
      1957, 1958, 1959, 1960, 1961}]}, 
    {FaceForm[RGBColor[
     0.6862745098039216, 0.13725490196078433`, 0.22352941176470587`]], 
     PolygonBox[{1962, 1963, 1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971, 
      1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 
      1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 
      1996, 1997, 1998}]}, 
    {FaceForm[RGBColor[
     0.027450980392156862`, 0.8470588235294118, 0.027450980392156862`]], 
     PolygonBox[{1999, 2000, 2001, 2002, 2003}]}, 
    {FaceForm[RGBColor[
     0.9137254901960784, 0.45098039215686275`, 0.00784313725490196]], 
     PolygonBox[{2004, 2005, 2006, 2007}]}, 
    {FaceForm[RGBColor[
     0.0196078431372549, 0.396078431372549, 0.3058823529411765]], 
     PolygonBox[{2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 
      2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026}]}, 
    {FaceForm[RGBColor[
     0.6235294117647059, 0.9921568627450981, 0.8156862745098039]], 
     PolygonBox[{2027, 2028, 2029, 2030, 2031, 2032, 2033, 2034, 2035, 2036, 
      2037, 2038}]}, 
    {FaceForm[RGBColor[
     0.8235294117647058, 0.3607843137254902, 0.10980392156862745`]], 
     PolygonBox[{2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046, 2047, 2048, 
      2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057}]}, 
    {FaceForm[RGBColor[
     0.20392156862745098`, 0.8901960784313725, 0.5764705882352941]], 
     PolygonBox[{2058, 2059, 2060, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 
      2068, 2069}]}, 
    {FaceForm[RGBColor[0, 0.7058823529411764, 0.6588235294117647]], 
     PolygonBox[{2070, 2071, 2072, 2073, 2074, 2075}]}, 
    {FaceForm[RGBColor[
     0.8862745098039215, 0.8627450980392157, 0.4784313725490196]], 
     PolygonBox[{2076, 2077, 2078, 2079, 2080}]}, 
    {FaceForm[RGBColor[
     0.6313725490196078, 0.0392156862745098, 0.8352941176470589]], 
     PolygonBox[{2081, 2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 
      2090}]}, 
    {FaceForm[RGBColor[
     0.6313725490196078, 0.0392156862745098, 0.8352941176470589]], 
     PolygonBox[{2091, 2092, 2093, 2094, 2095, 2096, 2097, 2098, 2099}]}, 
    {FaceForm[RGBColor[
     0.5647058823529412, 0.1764705882352941, 0.027450980392156862`]], 
     PolygonBox[{2100, 2101, 2102, 2103, 2104}]}, 
    {FaceForm[RGBColor[
     0.8117647058823529, 0.16862745098039217`, 0.8705882352941177]], 
     PolygonBox[{2105, 2106, 2107, 2108, 2109, 2110, 2111, 2112, 2113, 2114, 
      2115, 2116, 2117, 2118}]}, 
    {FaceForm[RGBColor[0.4, 0.8196078431372549, 0.34901960784313724`]], 
     PolygonBox[{2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127, 2128, 
      2129, 2130, 2131, 2132}]}, 
    {FaceForm[RGBColor[
     0.043137254901960784`, 0.03529411764705882, 0.7058823529411764]], 
     PolygonBox[{2133, 2134, 2135, 2136, 2137, 2138, 2139, 2140, 2141}]}, 
    {FaceForm[RGBColor[
     0.14509803921568626`, 0.14901960784313725`, 0.4588235294117647]], 
     PolygonBox[{2142, 2143, 2144, 2145, 2146, 2147, 2148, 2149, 2150, 2151, 
      2152, 2153, 2154, 2155, 2156, 2157, 2158, 2159, 2160, 2161, 2162, 2163, 
      2164, 2165, 2166, 2167, 2168}]}, 
    {FaceForm[RGBColor[
     0.14509803921568626`, 0.14901960784313725`, 0.4588235294117647]], 
     PolygonBox[{2169, 2170, 2171, 2172}]}, 
    {FaceForm[RGBColor[
     0.14509803921568626`, 0.14901960784313725`, 0.4588235294117647]], 
     PolygonBox[{2173, 2174, 2175, 2176, 2177, 2178, 2179, 2180, 2181}]}, 
    {FaceForm[RGBColor[
     0.7019607843137254, 0.43529411764705883`, 0.49019607843137253`]], 
     PolygonBox[{2182, 2183, 2184, 2185, 2186, 2187, 2188, 2189}]}, 
    {FaceForm[RGBColor[
     0.5686274509803921, 0.8392156862745098, 0.9529411764705882]], 
     PolygonBox[{2190, 2191, 2192, 2193, 2194, 2195, 2196, 2197, 2198, 2199, 
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207, 2208}]}, 
    {FaceForm[RGBColor[
     0.8549019607843137, 0.5294117647058824, 0.00392156862745098]], 
     PolygonBox[{2209, 2210, 2211, 2212, 2213, 2214, 2215, 2216, 2217, 2218, 
      2219}]}, 
    {FaceForm[RGBColor[
     0.38823529411764707`, 0.6784313725490196, 0.5019607843137255]], 
     PolygonBox[{2220, 2221, 2222, 2223, 2224, 2225, 2226, 2227, 2228, 
      2229}]}, 
    {FaceForm[RGBColor[
     0.38823529411764707`, 0.6784313725490196, 0.5019607843137255]], 
     PolygonBox[{2230, 2231, 2232, 2233, 2234}]}, 
    {FaceForm[RGBColor[
     0.18823529411764706`, 0.2196078431372549, 0.803921568627451]], 
     PolygonBox[{2235, 2236, 2237, 2238, 2239, 2240, 2241, 2242, 2243, 2244, 
      2245, 2246}]}, 
    {FaceForm[RGBColor[
     0.09803921568627451, 0.3686274509803922, 0.8666666666666667]], 
     PolygonBox[{2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254, 2255, 2256, 
      2257, 2258, 2259, 2260, 2261, 2262, 2263, 2264, 2265, 2266, 2267}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2268, 2269, 2270, 2271, 2272, 2273, 2274, 2275, 2276, 2277, 
      2278}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2279, 2280, 2281}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2282, 2283, 2284, 2285}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2286, 2287, 2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295, 
      2296}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2297, 2298, 2299}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2300, 2301, 2302, 2303}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2304, 2305, 2306, 2307}]}, 
    {FaceForm[RGBColor[
     0.7607843137254902, 0.06274509803921569, 0.6588235294117647]], 
     PolygonBox[{2308, 2309, 2310, 2311}]}, 
    {FaceForm[RGBColor[0.7215686274509804, 0.6078431372549019, 0.6]], 
     PolygonBox[{2312, 2313, 2314, 2315, 2316, 2317, 2318}]}, 
    {FaceForm[RGBColor[
     0.9529411764705882, 0.28627450980392155`, 0.11764705882352941`]], 
     PolygonBox[{2319, 2320, 2321, 2322, 2323, 2324}]}, 
    {FaceForm[RGBColor[
     0.03137254901960784, 0.11372549019607843`, 0.32941176470588235`]], 
     PolygonBox[{2325}]}, 
    {FaceForm[RGBColor[
     0.2588235294117647, 0.4980392156862745, 0.10980392156862745`]], 
     PolygonBox[{2326, 2327, 2328, 2329}]}, 
    {FaceForm[RGBColor[
     0.9372549019607843, 0.5764705882352941, 0.996078431372549]], 
     PolygonBox[{2330, 2331, 2332, 2333, 2334, 2335, 2336, 2337}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2338, 2339, 2340, 2341, 2342, 2343, 2344, 2345, 2346, 2347, 
      2348, 2349, 2350, 2351, 2352, 2353, 2354, 2355, 2356, 2357, 2358, 2359, 
      2360, 2361, 2362, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 
      2372, 2373, 2374, 2375, 2376, 2377, 2378, 2379, 2380, 2381, 2382, 2383, 
      2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391, 2392, 2393, 2394, 2395, 
      2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406, 2407, 
      2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 2416, 2417, 2418, 2419, 
      2420, 2421, 2422, 2423, 2424, 2425, 2426, 2427, 2428, 2429, 2430, 2431, 
      2432, 2433, 2434, 2435, 2436, 2437, 2438, 2439, 2440, 2441, 2442, 2443, 
      2444, 2445, 2446, 2447, 2448, 2449, 2450, 2451, 2452, 2453, 2454, 2455, 
      2456, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 2466, 2467, 
      2468, 2469, 2470, 2471, 2472, 2473, 2474, 2475, 2476, 2477, 2478, 2479, 
      2480, 2481, 2482, 2483, 2484, 2485, 2486, 2487, 2488, 2489, 2490, 2491, 
      2492, 2493, 2494, 2495, 2496, 2497, 2498, 2499, 2500}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2501, 2502, 2503, 2504, 2505, 2506, 2507, 2508, 2509, 2510, 
      2511}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2512, 2513, 2514, 2515, 2516, 2517}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2518, 2519, 2520, 2521, 2522, 2523, 2524}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2525, 2526, 2527}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2528, 2529, 2530}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2531, 2532, 2533}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2534, 2535, 2536, 2537, 2538, 2539}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2540, 2541, 2542, 2543}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2544, 2545, 2546, 2547}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2548, 2549, 2550, 2551, 2552}]}, 
    {FaceForm[RGBColor[
     0.9176470588235294, 0.7176470588235294, 0.7725490196078432]], 
     PolygonBox[{2553, 2554, 2555, 2556}]}, 
    {FaceForm[RGBColor[
     0.8941176470588235, 0.5490196078431373, 0.8470588235294118]], 
     PolygonBox[{2557, 2558, 2559, 2560, 2561}]}, 
    {FaceForm[RGBColor[
     0.00784313725490196, 0.8313725490196078, 0.8862745098039215]], 
     PolygonBox[{2562, 2563}]}, 
    {FaceForm[RGBColor[0.12156862745098039`, 0.4, 0.22745098039215686`]], 
     PolygonBox[{2564, 2565, 2566, 2567, 2568, 2569, 2570, 2571, 2572, 2573, 
      2574, 2575, 2576, 2577, 2578, 2579, 2580, 2581, 2582, 2583}]}, 
    {FaceForm[RGBColor[
     0.9333333333333333, 0.8352941176470589, 0.2823529411764706]], 
     PolygonBox[{2584, 2585, 2586, 2587, 2588, 2589, 2590, 2591, 2592, 2593, 
      2594, 2595, 2596}]}, 
    {FaceForm[RGBColor[
     0.19607843137254902`, 0.8156862745098039, 0.5058823529411764]], 
     PolygonBox[{2597, 2598, 2599, 2600, 2601, 2602, 2603, 2604, 2605, 2606, 
      2607, 2608}]}, 
    {FaceForm[RGBColor[
     0.023529411764705882`, 0.6941176470588235, 0.7058823529411764]], 
     PolygonBox[{2609, 2610, 2611, 2612, 2613}]}, 
    {FaceForm[RGBColor[
     0.5647058823529412, 0.44313725490196076`, 0.6980392156862745]], 
     PolygonBox[{2614, 2615}]}, 
    {FaceForm[RGBColor[
     0.7843137254901961, 0.8470588235294118, 0.6705882352941176]], 
     PolygonBox[{2616, 2617, 2618, 2619, 2620, 2621, 2622}]}, 
    {FaceForm[RGBColor[0.8, 0.23529411764705882`, 0.996078431372549]], 
     PolygonBox[{2623, 2624, 2625, 2626, 2627, 2628, 2629}]}, 
    {FaceForm[RGBColor[
     0.6588235294117647, 0.9686274509803922, 0.34509803921568627`]], 
     PolygonBox[{2630, 2631, 2632, 2633, 2634, 2635, 2636, 2637, 2638, 2639, 
      2640, 2641, 2642, 2643}]}, 
    {FaceForm[RGBColor[
     0.8705882352941177, 0.2549019607843137, 0.7411764705882353]], 
     PolygonBox[{2644, 2645, 2646, 2647, 2648, 2649, 2650, 2651, 2652, 2653, 
      2654, 2655, 2656, 2657, 2658, 2659}]}, 
    {FaceForm[RGBColor[
     0.4117647058823529, 0.03137254901960784, 0.9725490196078431]], 
     PolygonBox[{2660, 2661, 2662, 2663, 2664}]}, 
    {FaceForm[RGBColor[
     0.5450980392156862, 0.592156862745098, 0.5254901960784314]], 
     PolygonBox[{2665, 2666, 2667, 2668, 2669}]}, 
    {FaceForm[RGBColor[
     0.9450980392156862, 0.8509803921568627, 0.8823529411764706]], 
     PolygonBox[{2670, 2671, 2672, 2673, 2674, 2675, 2676, 2677, 2678, 2679, 
      2680, 2681, 2682, 2683, 2684}]}, 
    {FaceForm[RGBColor[
     0.9568627450980391, 0.5019607843137255, 0.14901960784313725`]], 
     PolygonBox[{2685, 2686, 2687, 2688, 2689, 2690}]}, 
    {FaceForm[RGBColor[
     0.09411764705882353, 0.10980392156862745`, 0.8274509803921568]], 
     PolygonBox[{2691, 2692, 2693, 2694, 2695, 2696, 2697, 2698, 2699, 2700, 
      2701, 2702, 2703, 2704, 2705, 2706, 2707, 2708, 2709, 2710, 2711, 
      2712}]}, 
    {FaceForm[RGBColor[
     0.34901960784313724`, 0.8588235294117647, 0.10980392156862745`]], 
     PolygonBox[{2713, 2714, 2715, 2716, 2717, 2718}]}, 
    {FaceForm[RGBColor[
     0.16470588235294117`, 0.3764705882352941, 0.5098039215686274]], 
     PolygonBox[{2719, 2720, 2721, 2722}]}, 
    {FaceForm[RGBColor[
     0.23529411764705882`, 0.9058823529411765, 0.6313725490196078]], 
     PolygonBox[{2723, 2724, 2725, 2726, 2727, 2728, 2729, 2730, 2731, 2732, 
      2733, 2734}]}, 
    {FaceForm[RGBColor[
     0.09803921568627451, 0.20392156862745098`, 0.9333333333333333]], 
     PolygonBox[{2735, 2736, 2737, 2738, 2739, 2740, 2741, 2742}]}, 
    {FaceForm[RGBColor[
     0.08627450980392157, 0.5058823529411764, 0.6784313725490196]], 
     PolygonBox[{2743, 2744, 2745, 2746, 2747, 2748, 2749, 2750, 2751}]}, 
    {FaceForm[RGBColor[
     0.984313725490196, 0.23529411764705882`, 0.6196078431372549]], 
     PolygonBox[{2752, 2753, 2754, 2755, 2756}]}, 
    {FaceForm[RGBColor[
     0.7176470588235294, 0.4823529411764706, 0.08235294117647059]], 
     PolygonBox[{2757, 2758, 2759, 2760, 2761, 2762, 2763, 2764, 2765, 2766, 
      2767}]}, 
    {FaceForm[RGBColor[
     0.5215686274509804, 0.6078431372549019, 0.6549019607843137]], 
     PolygonBox[{2768, 2769, 2770, 2771, 2772, 2773, 2774, 2775, 2776, 2777, 
      2778, 2779}]}, 
    {FaceForm[RGBColor[
     0.7333333333333333, 0.6627450980392157, 0.4980392156862745]], 
     PolygonBox[{2780, 2781, 2782, 2783, 2784, 2785, 2786, 2787, 2788, 2789, 
      2790, 2791, 2792, 2793, 2794, 2795, 2796, 2797, 2798, 2799, 2800, 
      2801}]}, 
    {FaceForm[RGBColor[
     0.48627450980392156`, 0.3529411764705882, 0.15294117647058825`]], 
     PolygonBox[{2802, 2803, 2804, 2805, 2806, 2807, 2808, 2809}]}, 
    {FaceForm[RGBColor[
     0.2588235294117647, 0.5764705882352941, 0.7215686274509804]], 
     PolygonBox[{2810, 2811, 2812, 2813, 2814, 2815, 2816}]}, 
    {FaceForm[RGBColor[
     0.050980392156862744`, 0.050980392156862744`, 0.6431372549019607]], 
     PolygonBox[{2817, 2818, 2819, 2820, 2821, 2822, 2823, 2824, 2825, 2826, 
      2827, 2828, 2829, 2830, 2831, 2832, 2833}]}, 
    {FaceForm[RGBColor[
     0.050980392156862744`, 0.050980392156862744`, 0.6431372549019607]], 
     PolygonBox[{2834, 2835, 2836, 2837, 2838, 2839}]}, 
    {FaceForm[RGBColor[
     0.6313725490196078, 0.5450980392156862, 0.37254901960784315`]], 
     PolygonBox[{2840, 2841, 2842, 2843, 2844, 2845, 2846, 2847, 2848, 2849, 
      2850, 2851, 2852, 2853}]}, 
    {FaceForm[RGBColor[
     0.6549019607843137, 0.396078431372549, 0.9254901960784314]], 
     PolygonBox[{2854, 2855, 2856, 2857, 2858, 2859, 2860, 2861}]}, 
    {FaceForm[RGBColor[
     0.6549019607843137, 0.16862745098039217`, 0.3137254901960784]], 
     PolygonBox[{2862, 2863, 2864, 2865, 2866, 2867, 2868, 2869, 2870, 2871, 
      2872, 2873, 2874, 2875, 2876, 2877, 2878, 2879, 2880, 2881, 2882}]}, 
    {FaceForm[RGBColor[
     0.6549019607843137, 0.16862745098039217`, 0.3137254901960784]], 
     PolygonBox[{2883, 2884, 2885, 2886, 2887}]}, 
    {FaceForm[RGBColor[0.4, 0.043137254901960784`, 0.5137254901960784]], 
     PolygonBox[{2888, 2889, 2890, 2891, 2892, 2893, 2894, 2895, 2896, 2897, 
      2898, 2899, 2900, 2901, 2902, 2903, 2904, 2905, 2906, 2907, 2908, 2909, 
      2910, 2911, 2912, 2913, 2914, 2915, 2916, 2917, 2918, 2919, 2920, 2921, 
      2922, 2923, 2924, 2925, 2926, 2927, 2928, 2929, 2930, 2931, 2932, 2933, 
      2934, 2935, 2936, 2937, 2938, 2939, 2940, 2941, 2942, 2943, 2944, 2945, 
      2946, 2947, 2948, 2949, 2950, 2951, 2952, 2953, 2954, 2955, 2956, 2957, 
      2958, 2959, 2960, 2961, 2962, 2963, 2964, 2965, 2966, 2967, 2968, 2969, 
      2970, 2971}]}, 
    {FaceForm[RGBColor[0.4, 0.043137254901960784`, 0.5137254901960784]], 
     PolygonBox[{2972, 2973, 2974, 2975, 2976, 2977, 2978, 2979, 2980, 2981, 
      2982, 2983, 2984, 2985, 2986, 2987, 2988, 2989, 2990, 2991, 2992, 2993, 
      2994, 2995, 2996, 2997, 2998, 2999, 3000, 3001, 3002, 3003, 3004, 3005, 
      3006, 3007, 3008, 3009}]}, 
    {FaceForm[RGBColor[0.4, 0.043137254901960784`, 0.5137254901960784]], 
     PolygonBox[{3010, 3011, 3012, 3013}]}, 
    {FaceForm[RGBColor[0.4, 0.043137254901960784`, 0.5137254901960784]], 
     PolygonBox[{3014, 3015, 3016, 3017}]}, 
    {FaceForm[RGBColor[
     0.580392156862745, 0.7333333333333333, 0.5450980392156862]], 
     PolygonBox[{3018, 3019, 3020, 3021, 3022, 3023, 3024, 3025}]}, 
    {FaceForm[RGBColor[
     0.023529411764705882`, 0.22352941176470587`, 0.580392156862745]], 
     PolygonBox[{3026, 3027, 3028, 3029, 3030, 3031, 3032, 3033, 3034, 3035, 
      3036, 3037, 3038, 3039, 3040, 3041, 3042, 3043, 3044, 3045, 3046, 3047, 
      3048, 3049}]}, 
    {FaceForm[RGBColor[
     0.28627450980392155`, 0.44705882352941173`, 0.5019607843137255]], 
     PolygonBox[{3050, 3051, 3052, 3053, 3054, 3055}]}, 
    {FaceForm[RGBColor[
     0.5294117647058824, 0.23137254901960785`, 0.803921568627451]], 
     PolygonBox[{3056, 3057, 3058, 3059, 3060, 3061, 3062, 3063, 3064, 3065, 
      3066, 3067, 3068, 3069, 3070, 3071, 3072, 3073, 3074}]}, 
    {FaceForm[RGBColor[
     0.8666666666666667, 0.9803921568627451, 0.8549019607843137]], 
     PolygonBox[{3075, 3076, 3077, 3078, 3079, 3080, 3081, 3082, 3083, 3084, 
      3085, 3086, 3087, 3088, 3089, 3090, 3091, 3092, 3093, 3094, 3095, 3096, 
      3097, 3098}]}, 
    {FaceForm[RGBColor[
     0.14509803921568626`, 0.4666666666666667, 0.054901960784313725`]], 
     PolygonBox[{3099, 3100, 3101, 3102, 3103, 3104, 3105, 3106, 3107, 3108, 
      3109, 3110, 3111, 3112, 3113, 3114, 3115, 3116, 3117, 3118}]}, 
    {FaceForm[RGBColor[0.2, 0.9764705882352941, 0.15294117647058825`]], 
     PolygonBox[{3119, 3120, 3121, 3122, 3123, 3124, 3125, 3126, 3127}]}, 
    {FaceForm[RGBColor[
     0.6509803921568628, 0.15294117647058825`, 0.4627450980392157]], 
     PolygonBox[{3128, 3129, 3130, 3131, 3132, 3133, 3134, 3135}]}, 
    {FaceForm[RGBColor[
     0.5686274509803921, 0.9176470588235294, 0.6078431372549019]], 
     PolygonBox[{3136, 3137, 3138, 3139, 3140, 3141, 3142, 3143, 3144, 3145, 
      3146, 3147, 3148, 3149, 3150, 3151, 3152, 3153, 3154, 3155, 3156, 3157, 
      3158, 3159, 3160, 3161}]}, 
    {FaceForm[RGBColor[
     0.43529411764705883`, 0.34509803921568627`, 0.3333333333333333]], 
     PolygonBox[{3162, 3163, 3164, 3165, 3166, 3167, 3168, 3169, 3170, 3171, 
      3172, 3173, 3174, 3175, 3176, 3177, 3178, 3179}]}, 
    {FaceForm[RGBColor[
     0.3176470588235294, 0.9882352941176471, 0.8392156862745098]], 
     PolygonBox[{3180, 3181, 3182, 3183, 3184, 3185, 3186, 3187}]}}],
  ImageSize->Medium,
  PlotRange->All]], "Output",
 CellLabel->"Out[1]=",
 CellID->1555561380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334556127],

Cell[TextData[{
 "Create a 3D model using ",
 Cell[BoxData[
  ButtonBox["SphericalPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFormula"],
 ", and export it to JVX:"
}], "ExampleText",
 CellID->883938850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"15", "\[Phi]"}], "]"}], 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"10", "\[Theta]"}], "]"}], "/", "10"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "->", "None"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<PlumColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68382004],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyMfXVUVW3TPmIXNjaKgYmAihhHR2wwUMAWu7ARAzABRRAsxMBAVAQVUcEg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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxM3XW8dVXRB/B97z33nH1AJaRB6W6kQxokpUG6paSkQUq6QUqah5IWVLpL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        "]]]}, {}, {}, {}}, {}},
   VertexColors->{
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8266684066230551, 0.8001925771138828, 0.47136581824375506`], 
     RGBColor[0.7666581975031614, 0.7386891822315338, 0.4988875341987738], 
     RGBColor[0.6699903797457328, 0.6396160569226078, 0.5432210611324353], 
     RGBColor[0.6054648569191874, 0.5402446587021142, 0.5457167917147281], 
     RGBColor[0.5396742572139168, 0.4284208673851586, 0.537187600281467], 
     RGBColor[0.5102203348371344, 0.3338745478330556, 0.4808966382102784], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[
     0.46775521536709147`, 0.18758939734009097`, 0.30155683086197993`], 
     RGBColor[0.43087109349100067`, 0.13664140804867322`, 0.2037547652496435],
      
     RGBColor[0.3528255951290676, 0.09672358563921103, 0.12676235912405237`], 
     
     RGBColor[0.27689764724684834`, 0.06425624451715621, 0.06555733830767621],
      
     RGBColor[0.16766544464987995`, 0.03890806554559134, 0.03969589625158596],
      
     RGBColor[
     0.09985541777082654, 0.023172223398940588`, 0.023641426605624325`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8535028680136739, 0.8276947388221523, 0.4590590718579355], 
     RGBColor[0.7357346355310128, 0.7069961741411595, 0.5130696125717145], 
     RGBColor[0.681932838567443, 0.6518556703408911, 0.5377440437329631], 
     RGBColor[0.61000695089018, 0.5474890849994436, 0.545744461293215], 
     RGBColor[0.5371166501279192, 0.4202110156123413, 0.5322996209614569], 
     RGBColor[0.5112722288336009, 0.3372511000169256, 0.48290696893297635`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.469072465608675, 0.18940891337541282`, 0.305049656175485], 
     RGBColor[0.42766829115234, 0.13221738136855357`, 0.19526220344970852`], 
     RGBColor[0.3581929627060821, 0.09912571061967106, 0.13140048548416072`], 
     
     RGBColor[0.2871490725357906, 0.06733055203617055, 0.07000902402834676], 
     RGBColor[0.1327225974363661, 0.03079930710361172, 0.03142294745990626], 
     RGBColor[
     0.13017768417965242`, 0.03020874026375495, 0.030820422516148478`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8750224352228088, 0.8497497601122198, 0.44918982752616715`], 
     RGBColor[0.7109358642600475, 0.6815803549923204, 0.5244427563911173], 
     RGBColor[0.6915099469548678, 0.6616710782126757, 0.5333518168006669], 
     RGBColor[0.6136494274450905, 0.5532986638215288, 0.5457666505723374], 
     RGBColor[0.5350656084922958, 0.4136272256703547, 0.5283797658929071], 
     RGBColor[0.5121157823234339, 0.3399588846300851, 0.4845191290009557], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[
     0.47012881828489883`, 0.19086805194503945`, 0.30785068459895903`], 
     RGBColor[
     0.42440604018474376`, 0.12875887532517039`, 0.18861747605377222`], 
     RGBColor[0.36249725730802534`, 0.10105206528762137`, 0.1351199740357627],
      
     RGBColor[0.29254648724824317`, 0.06974612438605168, 0.0746731151484462], 
     
     RGBColor[
     0.10470060965938639`, 0.024296587718462218`, 0.024788557637477258`], 
     RGBColor[0.1544942538480173, 0.03585158866627673, 0.0365775302419864], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8869648940445193, 0.8619893735305035, 0.4437128101266949], 
     RGBColor[0.6971735844774506, 0.6674756394720102, 0.530754375041094], 
     RGBColor[0.6968248411363513, 0.6671182186308768, 0.5309143147466159], 
     RGBColor[0.6156708494301759, 0.5565227368328479, 0.5457789646932316], 
     RGBColor[0.5339273662573568, 0.4099734979020942, 0.5262044104460115], 
     RGBColor[0.5125839191924674, 0.34146159172109897`, 0.48541381034090725`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4707150497929215, 0.19167781276009604`, 0.30940513810077386`],
      
     RGBColor[0.4206709133124344, 0.12708724739277666`, 0.18538982485302413`],
      
     RGBColor[0.3648859606002735, 0.10212111147588486`, 0.13718413445468008`],
      
     RGBColor[0.2955418264351668, 0.07108666590526364, 0.0772614904443419], 
     RGBColor[
     0.08914957966529857, 0.020687850714991303`, 0.021106749054082587`], 
     RGBColor[0.1679889319299456, 0.03898313327539245, 0.03977248399174321], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8869648940445193, 0.8619893735305035, 0.4437128101266949], 
     RGBColor[0.6971735844774506, 0.6674756394720102, 0.530754375041094], 
     RGBColor[0.6968248411363513, 0.6671182186308768, 0.5309143147466159], 
     RGBColor[0.6156708494301759, 0.5565227368328479, 0.5457789646932316], 
     RGBColor[0.5339273662573568, 0.4099734979020942, 0.5262044104460115], 
     RGBColor[0.5125839191924674, 0.34146159172109897`, 0.48541381034090725`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4707150497929215, 0.19167781276009604`, 0.30940513810077386`],
      
     RGBColor[0.4206709133124344, 0.12708724739277666`, 0.18538982485302413`],
      
     RGBColor[0.3648859606002735, 0.10212111147588486`, 0.13718413445468008`],
      
     RGBColor[0.2955418264351668, 0.07108666590526364, 0.0772614904443419], 
     RGBColor[
     0.08914957966529836, 0.020687850714991258`, 0.021106749054082538`], 
     RGBColor[0.1679889319299456, 0.03898313327539245, 0.03977248399174321], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8750224352228088, 0.8497497601122198, 0.44918982752616715`], 
     RGBColor[0.7109358642600475, 0.6815803549923204, 0.5244427563911173], 
     RGBColor[0.6915099469548678, 0.6616710782126757, 0.5333518168006669], 
     RGBColor[0.6136494274450905, 0.5532986638215288, 0.5457666505723374], 
     RGBColor[0.5350656084922958, 0.4136272256703547, 0.5283797658929071], 
     RGBColor[0.5121157823234339, 0.3399588846300851, 0.4845191290009557], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[
     0.47012881828489883`, 0.19086805194503945`, 0.30785068459895903`], 
     RGBColor[
     0.42440604018474376`, 0.12875887532517039`, 0.18861747605377222`], 
     RGBColor[0.36249725730802534`, 0.10105206528762137`, 0.1351199740357627],
      
     RGBColor[0.29254648724824317`, 0.06974612438605168, 0.0746731151484462], 
     
     RGBColor[
     0.10470060965938639`, 0.024296587718462218`, 0.024788557637477258`], 
     RGBColor[
     0.15449425384801718`, 0.035851588666276704`, 0.03657753024198637], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8535028680136739, 0.8276947388221523, 0.4590590718579355], 
     RGBColor[0.7357346355310128, 0.7069961741411595, 0.5130696125717145], 
     RGBColor[0.681932838567443, 0.6518556703408911, 0.5377440437329631], 
     RGBColor[0.61000695089018, 0.5474890849994436, 0.545744461293215], 
     RGBColor[0.5371166501279192, 0.4202110156123413, 0.5322996209614569], 
     RGBColor[0.5112722288336009, 0.3372511000169256, 0.48290696893297635`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.469072465608675, 0.18940891337541282`, 0.305049656175485], 
     RGBColor[0.42766829115233995`, 0.13221738136855352`, 0.1952622034497084],
      
     RGBColor[0.3581929627060821, 0.09912571061967106, 0.13140048548416072`], 
     
     RGBColor[0.28714907253579064`, 0.06733055203617057, 0.07000902402834681],
      
     RGBColor[0.132722597436366, 0.030799307103611697`, 0.03142294745990623], 
     
     RGBColor[
     0.13017768417965253`, 0.030208740263754977`, 0.030820422516148503`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8266684066230554, 0.8001925771138831, 0.4713658182437549], 
     RGBColor[0.766658197503161, 0.7386891822315335, 0.49888753419877396`], 
     RGBColor[0.6699903797457328, 0.6396160569226078, 0.5432210611324353], 
     RGBColor[0.6054648569191875, 0.5402446587021144, 0.5457167917147281], 
     RGBColor[0.5396742572139168, 0.4284208673851586, 0.537187600281467], 
     RGBColor[0.5102203348371344, 0.3338745478330557, 0.48089663821027845`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4677552153670915, 0.187589397340091, 0.30155683086198004`], 
     RGBColor[0.4308710934910006, 0.13664140804867317`, 0.2037547652496434], 
     RGBColor[
     0.35282559512906764`, 0.09672358563921106, 0.12676235912405243`], 
     RGBColor[0.27689764724684857`, 0.06425624451715627, 0.06555733830767627],
      
     RGBColor[
     0.16766544464987954`, 0.038908065545591244`, 0.039695896251585865`], 
     RGBColor[
     0.09985541777082695, 0.023172223398940678`, 0.02364142660562442], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.7998339452324364, 0.7726904154056136, 0.48367256462957453`], 
     RGBColor[0.7975817594753101, 0.7703821903219081, 0.4847054558258331], 
     RGBColor[0.6610431144218367, 0.6288893659193778, 0.5460553639609118], 
     RGBColor[0.6009227629481948, 0.5330002324047848, 0.5456891221362411], 
     RGBColor[0.5422318642999144, 0.4366307191579761, 0.5420755796014771], 
     RGBColor[0.5091684408406679, 0.33049799564918586`, 0.47888630748758054`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.466437965125508, 0.1857698813047691, 0.2980640055484749], 
     RGBColor[0.4340738958296614, 0.14106543472879293`, 0.21224732704957855`],
      
     RGBColor[0.3474582275520532, 0.09432146065875106, 0.12212423276394412`], 
     
     RGBColor[0.2634029691649202, 0.061124699908040515`, 0.06236238455791943],
      
     RGBColor[0.2026082918633937, 0.04701682398757094, 0.04796884504326565], 
     RGBColor[
     0.06953315136200085, 0.016135706534126264`, 0.016462430695100214`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.7783143780233015, 0.7506353941155458, 0.493541808961343], 
     RGBColor[0.8223805307462755, 0.7957980094707474, 0.4733323120064302], 
     RGBColor[0.6564755932911126, 0.6216043844979577, 0.5460275394849708], 
     RGBColor[0.5972802863932841, 0.5271906535826993, 0.5456669328571186], 
     RGBColor[0.5448904499565105, 0.4436313280339133, 0.5453477838697876], 
     RGBColor[0.5083248873508348, 0.32779021103602624`, 0.47727414741960117`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4653816124492841, 0.18431074273514245`, 0.2952629771250008], 
     RGBColor[0.4366423438853574, 0.1446132286677884, 0.21905783283060123`], 
     RGBColor[0.3431539329501098, 0.0923951059908007, 0.11840474421234204`], 
     RGBColor[0.2525810775784834, 0.05861339611463441, 0.05980023058183828], 
     RGBColor[0.23063027964037372`, 0.05351954337272052, 0.05460323486569473],
      
     RGBColor[
     0.04521658169363569, 0.010492858131604416`, 0.010705322969262222`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.7663719192015911, 0.7383957806972623, 0.4990188263608151], 
     RGBColor[0.8361428105288723, 0.8099027249910575, 0.46702069335645346`], 
     RGBColor[0.6539408102961363, 0.617561524816035, 0.5460120980657763], 
     RGBColor[0.595258864408199, 0.5239665805713806, 0.5456546187362245], 
     RGBColor[0.5480512726510958, 0.44867269159796247`, 0.5453670390045755], 
     RGBColor[0.5078567504818013, 0.3262875039450124, 0.4763794660796496], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.46479538094126144`, 0.18350098192008585`, 0.293708523623186], 
     
     RGBColor[0.4380677250207099, 0.14658210576520417`, 0.2228373783974078], 
     RGBColor[0.34076522965786166`, 0.0913260598025372, 0.11634058379342466`],
      
     RGBColor[0.24657538083802236`, 0.05721972765234182, 0.05837834239715203],
      
     RGBColor[0.24618130963446153`, 0.05712828037619143, 0.05828504344908939],
      
     RGBColor[
     0.03172190361170727, 0.007361313522488672, 0.007510369219505383], 
     RGBColor[
     0.07686784450741728, 0.017837778909591533`, 0.018198967515466898`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.7663719192015911, 0.7383957806972623, 0.4990188263608151], 
     RGBColor[0.8361428105288723, 0.8099027249910575, 0.46702069335645346`], 
     RGBColor[0.6539408102961363, 0.617561524816035, 0.5460120980657763], 
     RGBColor[0.595258864408199, 0.5239665805713806, 0.5456546187362245], 
     RGBColor[0.5480512726510958, 0.44867269159796247`, 0.5453670390045755], 
     RGBColor[0.5078567504818013, 0.32628750394501227`, 0.47637946607964954`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.46479538094126144`, 0.18350098192008585`, 0.293708523623186], 
     
     RGBColor[0.4380677250207099, 0.14658210576520417`, 0.2228373783974078], 
     RGBColor[0.34076522965786166`, 0.0913260598025372, 0.11634058379342466`],
      
     RGBColor[0.24657538083802236`, 0.05721972765234182, 0.05837834239715203],
      
     RGBColor[0.24618130963446153`, 0.05712828037619143, 0.05828504344908939],
      
     RGBColor[
     0.03172190361170727, 0.007361313522488672, 0.007510369219505383], 
     RGBColor[
     0.07686784450741728, 0.017837778909591533`, 0.018198967515466898`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.7783143780233015, 0.7506353941155458, 0.493541808961343], 
     RGBColor[0.8223805307462755, 0.7957980094707474, 0.4733323120064302], 
     RGBColor[0.6564755932911125, 0.6216043844979575, 0.5460275394849708], 
     RGBColor[0.5972802863932841, 0.5271906535826993, 0.5456669328571186], 
     RGBColor[0.5448904499565105, 0.4436313280339133, 0.5453477838697876], 
     RGBColor[0.5083248873508348, 0.32779021103602624`, 0.47727414741960117`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4653816124492841, 0.18431074273514245`, 0.2952629771250008], 
     RGBColor[0.4366423438853574, 0.1446132286677884, 0.21905783283060123`], 
     RGBColor[0.3431539329501098, 0.0923951059908007, 0.11840474421234204`], 
     RGBColor[0.2525810775784832, 0.05861339611463436, 0.059800230581838226`],
      
     RGBColor[0.2306302796403738, 0.05351954337272054, 0.054603234865694746`],
      
     RGBColor[
     0.04521658169363548, 0.010492858131604367`, 0.010705322969262172`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.7998339452324364, 0.7726904154056136, 0.48367256462957453`], 
     RGBColor[0.7975817594753101, 0.7703821903219081, 0.4847054558258331], 
     RGBColor[0.6610431144218367, 0.6288893659193778, 0.5460553639609118], 
     RGBColor[0.6009227629481948, 0.5330002324047848, 0.5456891221362411], 
     RGBColor[0.5422318642999144, 0.4366307191579761, 0.5420755796014771], 
     RGBColor[0.5091684408406679, 0.33049799564918575`, 0.4788863074875805], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.466437965125508, 0.1857698813047691, 0.2980640055484749], 
     RGBColor[0.4340738958296614, 0.14106543472879296`, 0.2122473270495786], 
     RGBColor[0.3474582275520531, 0.09432146065875102, 0.12212423276394402`], 
     
     RGBColor[0.2634029691649202, 0.061124699908040515`, 0.06236238455791943],
      
     RGBColor[
     0.20260829186339394`, 0.04701682398757099, 0.047968845043265707`], 
     RGBColor[
     0.06953315136200065, 0.016135706534126215`, 0.016462430695100165`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8266684066230543, 0.800192577113882, 0.47136581824375545`], 
     RGBColor[0.7666581975031622, 0.7386891822315347, 0.4988875341987734], 
     RGBColor[0.6699903797457325, 0.6396160569226075, 0.5432210611324354], 
     RGBColor[0.6054648569191874, 0.5402446587021141, 0.5457167917147281], 
     RGBColor[0.5396742572139169, 0.42842086738515894`, 0.5371876002814672], 
     RGBColor[0.5102203348371344, 0.3338745478330556, 0.4808966382102784], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4677552153670914, 0.1875893973400909, 0.3015568308619798], 
     RGBColor[0.4308710934910008, 0.13664140804867336`, 0.20375476524964373`],
      
     RGBColor[0.3528255951290675, 0.09672358563921099, 0.1267623591240523], 
     RGBColor[0.276897647246848, 0.06425624451715613, 0.06555733830767614], 
     RGBColor[
     0.16766544464988076`, 0.038908065545591536`, 0.03969589625158616], 
     RGBColor[
     0.09985541777082574, 0.023172223398940397`, 0.02364142660562413], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.8257449666801182, 0.7992461599576434, 0.4717893237136369], 
     RGBColor[0.8052711232062691, 0.7782628823054063, 0.48117898112124613`], 
     RGBColor[0.7321760150346213, 0.7033490073534431, 0.5147016572509411], 
     RGBColor[0.5729296333385601, 0.4883525070200387, 0.5455185932784554], 
     RGBColor[0.5254645891246199, 0.38280820491141637`, 0.5100307456789946], 
     RGBColor[0.4492361396129307, 0.16200902222964148`, 0.25245158530203804`],
      
     RGBColor[0.3980230601561179, 0.11695137109215659`, 0.16581903838890738`],
      
     RGBColor[
     0.22817088800589477`, 0.052948822487946634`, 0.054020957728219195`], 
     RGBColor[0.1326040439502676, 0.030771795848579947`, 0.03139487914270317],
      
     RGBColor[
     0.06436684319000754, 0.014936824692943109`, 0.01523927327212961], 
     RGBColor[0.7966166817079814, 0.7693930993007854, 0.48514805711945397`], 
     RGBColor[0.8121044736588554, 0.7852662615206867, 0.47804508885632424`], 
     RGBColor[0.7493517697910659, 0.7209521325996406, 0.5068245601594192], 
     RGBColor[0.5258752441526493, 0.38412639679802035`, 0.5108155704066296], 
     RGBColor[0.2475790588618842, 0.05745263891453202, 0.05861596976746924], 
     RGBColor[0.1403255580836061, 0.03256363303148012, 0.033222998374917184`],
      
     RGBColor[
     0.031452613830214235`, 0.007298822742167371, 0.0074466130934289455`], 
     RGBColor[0.7764592830755018, 0.7487341403323633, 0.4943925874700619], 
     RGBColor[0.00867526039107937, 0.002013161391877955, 0.00205392492865122],
      
     RGBColor[0.7692651907961142, 0.7413610432415791, 0.4976919221527977], 
     RGBColor[0.776459283075502, 0.7487341403323635, 0.49439258747006176`], 
     RGBColor[
     0.008675260391079572, 0.0020131613918780017`, 0.0020539249286512682`], 
     RGBColor[0.796616681707981, 0.7693930993007849, 0.48514805711945413`], 
     RGBColor[0.8121044736588554, 0.7852662615206867, 0.47804508885632424`], 
     RGBColor[0.7493517697910661, 0.7209521325996409, 0.5068245601594191], 
     RGBColor[0.5258752441526493, 0.38412639679802035`, 0.5108155704066296], 
     RGBColor[0.2475790588618843, 0.05745263891453205, 0.058615969767469266`],
      
     RGBColor[0.1403255580836062, 0.03256363303148013, 0.033222998374917205`],
      
     RGBColor[
     0.03145261383021403, 0.007298822742167322, 0.007446613093428897], 
     RGBColor[0.8257449666801182, 0.7992461599576434, 0.4717893237136369], 
     RGBColor[0.8052711232062691, 0.7782628823054063, 0.48117898112124613`], 
     RGBColor[0.7321760150346213, 0.7033490073534431, 0.5147016572509411], 
     RGBColor[0.5729296333385601, 0.4883525070200387, 0.5455185932784554], 
     RGBColor[0.5254645891246199, 0.38280820491141637`, 0.5100307456789946], 
     RGBColor[0.4492361396129307, 0.16200902222964148`, 0.25245158530203804`],
      
     RGBColor[0.3980230601561179, 0.11695137109215659`, 0.16581903838890738`],
      
     RGBColor[
     0.22817088800589477`, 0.052948822487946634`, 0.054020957728219195`], 
     RGBColor[0.1326040439502676, 0.030771795848579947`, 0.03139487914270317],
      
     RGBColor[
     0.06436684319000754, 0.014936824692943109`, 0.01523927327212961], 
     RGBColor[0.8580749239182096, 0.8323805575160853, 0.4569622482377461], 
     RGBColor[0.797686676400138, 0.7704897178101835, 0.4846573391162542], 
     RGBColor[0.7131123654809665, 0.6838110123423831, 0.5234445754273048], 
     RGBColor[0.5672168460539239, 0.47924087993786646`, 0.5454837920574414], 
     RGBColor[0.525008796430045, 0.38134512229717143`, 0.5091596559492659], 
     RGBColor[0.44866536628495507`, 0.16122061377845975`, 0.2509381207641002],
      
     RGBColor[
     0.39127229070005665`, 0.11393011500804257`, 0.15998546703089944`], 
     RGBColor[0.20662944351494988`, 0.04794996338522215, 0.04892087913177682],
      
     RGBColor[
     0.12403380982962009`, 0.02878300661652601, 0.029365819874018196`], 
     RGBColor[
     0.10089888167921951`, 0.023414367283907413`, 0.02388847354565623], 
     RGBColor[0.8872032088903468, 0.8622336181729437, 0.4436035148319289], 
     RGBColor[0.790853325947552, 0.7634863385949033, 0.48779123138117597`], 
     RGBColor[0.6959366107245214, 0.6662078870961851, 0.5313216725188268], 
     RGBColor[0.44815111728582, 0.16051028230875383`, 0.2495745363327439], 
     RGBColor[0.18722127265896035`, 0.04344614695863674, 0.04432586709252675],
      
     RGBColor[
     0.11631229569628136`, 0.026991169433625794`, 0.02753770064180413], 
     RGBColor[0.907360607522826, 0.8828925771413654, 0.43435898448132115`], 
     RGBColor[
     0.15659046447814767`, 0.036338030584972564`, 0.03707382188913461], 
     RGBColor[0.914554699802214, 0.8902656742321502, 0.431059649798585], 
     RGBColor[0.907360607522826, 0.8828925771413654, 0.43435898448132115`], 
     RGBColor[
     0.15659046447814767`, 0.036338030584972564`, 0.03707382188913461], 
     RGBColor[0.8872032088903476, 0.8622336181729446, 0.4436035148319285], 
     RGBColor[0.790853325947552, 0.7634863385949033, 0.48779123138117597`], 
     RGBColor[0.6959366107245212, 0.6662078870961848, 0.5313216725188269], 
     RGBColor[0.44815111728582, 0.16051028230875383`, 0.2495745363327439], 
     RGBColor[0.18722127265896005`, 0.04344614695863667, 0.04432586709252668],
      
     RGBColor[
     0.11631229569628136`, 0.026991169433625794`, 0.02753770064180413], 
     RGBColor[0.13381311103901375`, 0.03105236923468337, 0.03168113372435711],
      
     RGBColor[0.8580749239182099, 0.8323805575160858, 0.4569622482377459], 
     RGBColor[0.797686676400138, 0.7704897178101835, 0.4846573391162542], 
     RGBColor[0.713112365480966, 0.6838110123423826, 0.5234445754273049], 
     RGBColor[0.5672168460539239, 0.47924087993786646`, 0.5454837920574414], 
     RGBColor[0.525008796430045, 0.38134512229717143`, 0.5091596559492659], 
     RGBColor[0.44866536628495507`, 0.16122061377845975`, 0.2509381207641002],
      
     RGBColor[
     0.39127229070005654`, 0.11393011500804252`, 0.15998546703089936`], 
     RGBColor[
     0.20662944351494958`, 0.047949963385222075`, 0.04892087913177675], 
     RGBColor[
     0.12403380982961988`, 0.028783006616525962`, 0.029365819874018147`], 
     RGBColor[0.10089888167922033`, 0.0234143672839076, 0.02388847354565642], 
     
     RGBColor[0.8129061268404583, 0.7860878615935727, 0.47767743689373177`], 
     RGBColor[0.8734293230102245, 0.848117007769919, 0.44992045623821875`], 
     RGBColor[0.7940846109134482, 0.7667980250254215, 0.4863093084166443], 
     RGBColor[0.6317334630886688, 0.5821418502934176, 0.5458768151014722], 
     RGBColor[0.6031354057288796, 0.5365292935931611, 0.5457026011381012], 
     RGBColor[0.6207617190090917, 0.5646424344193142, 0.5458099773090604], 
     RGBColor[0.578076676830966, 0.4965617993570124, 0.5455499480951541], 
     RGBColor[0.4976963995920746, 0.28907328161411344`, 0.44393185326669593`],
      
     RGBColor[0.4823509479901109, 0.21698342905754361`, 0.3499305672719703], 
     RGBColor[0.49741921434148884`, 0.2877711209241648, 0.4422339058429458], 
     RGBColor[
     0.48207376273952507`, 0.21568126836759496`, 0.34823261984822024`], 
     RGBColor[
     0.43251367767524723`, 0.13891030743335647`, 0.20811024717493237`], 
     RGBColor[0.44975038861206573`, 0.1627193536993474, 0.25381516973339435`],
      
     RGBColor[0.4041052932704158, 0.11967342876590409`, 0.1710749045711598], 
     RGBColor[0.30739378530123024`, 0.076390920933646, 0.08750317448160048], 
     RGBColor[0.2944285353940043, 0.07058842087506464, 0.07629945748304427], 
     RGBColor[0.18558617846870876`, 0.04306671068266244, 0.04393874779389406],
      
     RGBColor[
     0.11996356643179147`, 0.027838475098776926`, 0.02840216299184845], 
     RGBColor[
     0.08263286243461368, 0.019175595988425297`, 0.019563873408892953`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.1182489664466475, 0.027440588887066696`, 0.027996220173604806`], 
     RGBColor[0.7881073555694929, 0.7606720424447334, 0.4890505807131347], 
     RGBColor[0.8987059014058094, 0.8740225229337208, 0.4383281818382377], 
     RGBColor[0.811095275430982, 0.784231952225089, 0.47850792455340285`], 
     RGBColor[0.8168332988952183, 0.7901127503116285, 0.4758763681192229], 
     RGBColor[0.6585541495854952, 0.624919584045935, 0.5460402016572848], 
     RGBColor[0.5989378797253484, 0.5298344370010463, 0.5456770306025844], 
     RGBColor[0.6131690365247939, 0.5525324628934501, 0.545763724121595], 
     RGBColor[0.5433495319281164, 0.4402184029773755, 0.5442116138200268], 
     RGBColor[0.581638541443125, 0.5022428059210868, 0.5455716463015486], 
     RGBColor[0.5087087659067865, 0.3290224511484268, 0.4780077982032418], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4972273961964643, 0.28686999776720773`, 0.44105888976801183`],
      
     RGBColor[0.4658623302043665, 0.1849747575413078, 0.296537649993221], 
     RGBColor[
     0.48188194459450057`, 0.21478014521063785`, 0.34705760377328615`], 
     RGBColor[0.43547351210107726`, 0.1429987228533616, 0.2159585544137263], 
     RGBColor[0.4501062599612315, 0.16321091832835843`, 0.2547587994382734], 
     RGBColor[0.4083143291809694, 0.12155715112315282`, 0.17471207682129292`],
      
     RGBColor[0.2854563040731538, 0.06657296624539144, 0.06854624475797626], 
     RGBColor[
     0.21787822499017023`, 0.050560330284972116`, 0.05158410209539677], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.1468108642562475, 0.03406859857864625, 0.034758437245619084`],
      
     RGBColor[0.7709460733799411, 0.7430837498746694, 0.4969210404360985], 
     RGBColor[0.9127333441377837, 0.8883989992397856, 0.4318949548905798], 
     RGBColor[0.7612377608739785, 0.7331338732378034, 0.501373439837971], 
     RGBColor[0.8185209970820604, 0.7918424421349013, 0.47510236064953937`], 
     RGBColor[0.6549116730305844, 0.6191100052238494, 0.5460180123781624], 
     RGBColor[0.596033101603179, 0.5252014524898183, 0.5456593352429658], 
     RGBColor[0.6104592395199305, 0.548210464095577, 0.5457472165501118], 
     RGBColor[0.5261594262494784, 0.38503861388727884`, 0.5113586859696193], 
     RGBColor[0.5829097562051961, 0.5042703336892735, 0.5455793903017515], 
     RGBColor[0.5080360544465458, 0.3268630649766067, 0.4767221434504094], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[
     0.49715893709311826`, 0.28654839063602777`, 0.44063953138616097`], 
     RGBColor[0.46501991705580326`, 0.18381113336133864`, 0.2943039043639973],
      
     RGBColor[
     0.48181348549115455`, 0.21445853807945786`, 0.34663824539143523`], 
     RGBColor[0.4375217810762215, 0.1458279941089487, 0.22138975153892154`], 
     RGBColor[0.45023326897524996`, 0.16338635571325447`, 0.2550955769807651],
      
     RGBColor[0.2610099298192943, 0.06056937658600942, 0.06179581676102905], 
     RGBColor[0.28057794113404605`, 0.06511028522953521, 0.06642867207968044],
      
     RGBColor[0.14566901165737164`, 0.03380362283571222, 0.03448809613630922],
      
     RGBColor[0.26580335216618745`, 0.06168172738226371, 0.06293069101356003],
      
     RGBColor[
     0.03689058278033289, 0.008560745571811435, 0.008734087991515588], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.7648212826787582, 0.7368065609331343, 0.49972997498963634`], 
     RGBColor[0.9127333441377837, 0.8883989992397856, 0.4318949548905798], 
     RGBColor[0.7654798219772736, 0.7374814861352983, 0.49942795751986296`], 
     RGBColor[0.8168332988952183, 0.7901127503116285, 0.4758763681192229], 
     RGBColor[0.6536116881992426, 0.6170365905480533, 0.546010093116132], 
     RGBColor[0.5949963982942331, 0.5235479594617525, 0.545653019842237], 
     RGBColor[0.6131690365247939, 0.5525324628934503, 0.545763724121595], 
     RGBColor[0.5262608496655656, 0.38536418039705594`, 0.5115525216698382], 
     RGBColor[0.581638541443125, 0.5022428059210868, 0.5455716463015486], 
     RGBColor[0.507795966506102, 0.32609238897470066`, 0.4762632985815876], 
     RGBColor[0.5261594262494784, 0.38503861388727884`, 0.5113586859696193], 
     RGBColor[0.4972273961964643, 0.28686999776720773`, 0.44105888976801183`],
      
     RGBColor[
     0.46471926328402297`, 0.18339584069972817`, 0.29350668977900496`], 
     RGBColor[
     0.48188194459450057`, 0.21478014521063785`, 0.34705760377328615`], 
     RGBColor[0.409816516705256, 0.1222294438487111, 0.1760101685681777], 
     RGBColor[0.4501062599612315, 0.16321091832835843`, 0.2547587994382734], 
     RGBColor[0.3404550748880216, 0.09118725236858538, 0.11607256842218963`], 
     
     RGBColor[0.2457955872586726, 0.05703877051021436, 0.058193721140886855`],
      
     RGBColor[0.28545630407315387`, 0.06657296624539147, 0.0685462447579763], 
     
     RGBColor[0.14757606815812238`, 0.03424617007307112, 0.03493960429982971],
      
     RGBColor[0.2610099298192943, 0.06056937658600942, 0.06179581676102905], 
     RGBColor[
     0.0005461170671319681, 0.00012673069688216127`, 0.0001292968058108838], 
     RGBColor[0.14566901165737164`, 0.03380362283571222, 0.03448809613630922],
      
     RGBColor[
     0.07686784450741728, 0.017837778909591533`, 0.018198967515466898`], 
     RGBColor[0.16266152171353362`, 0.03774686645654225, 0.03851118460067348],
      
     RGBColor[0.7709460733799411, 0.7430837498746694, 0.4969210404360985], 
     RGBColor[0.8987059014058094, 0.8740225229337208, 0.4383281818382377], 
     RGBColor[0.7612377608739785, 0.7331338732378034, 0.501373439837971], 
     RGBColor[0.6549116730305844, 0.6191100052238494, 0.5460180123781624], 
     RGBColor[0.596033101603179, 0.5252014524898183, 0.5456593352429658], 
     RGBColor[0.6207617190090916, 0.564642434419314, 0.5458099773090604], 
     RGBColor[0.5468406266232293, 0.4467417681126616, 0.5453596639776602], 
     RGBColor[0.5780766768309661, 0.49656179935701256`, 0.5455499480951541], 
     RGBColor[0.5080360544465458, 0.3268630649766067, 0.4767221434504094], 
     RGBColor[0.5244359746791254, 0.3795063794765704, 0.5080649057478466], 
     RGBColor[0.4974192143414888, 0.28777112092416474`, 0.44223390584294575`],
      
     RGBColor[0.46501991705580326`, 0.18381113336133864`, 0.2943039043639973],
      
     RGBColor[
     0.48207376273952507`, 0.21568126836759496`, 0.34823261984822024`], 
     RGBColor[0.4083143291809694, 0.12155715112315282`, 0.17471207682129292`],
      
     RGBColor[0.44975038861206573`, 0.1627193536993474, 0.25381516973339435`],
      
     RGBColor[0.3416801415121284, 0.09173552172004491, 0.11713119049728124`], 
     
     RGBColor[0.2944285353940042, 0.07058842087506459, 0.07629945748304418], 
     RGBColor[0.2402250145458996, 0.05574607594999861, 0.05687485143025616], 
     RGBColor[0.17955703077662638`, 0.04166760024534216, 0.04251130744224518],
      
     RGBColor[
     0.03689058278033289, 0.008560745571811435, 0.008734087991515588], 
     RGBColor[
     0.11326308758414745`, 0.02628357706516372, 0.026815780575796963`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.1468108642562475, 0.03406859857864625, 0.034758437245619084`],
      
     RGBColor[0.7881073555694924, 0.7606720424447331, 0.48905058071313484`], 
     RGBColor[0.8734293230102245, 0.848117007769919, 0.44992045623821875`], 
     RGBColor[0.8110952754309824, 0.7842319522250893, 0.4785079245534027], 
     RGBColor[0.6585541495854951, 0.6249195840459348, 0.5460402016572848], 
     RGBColor[0.704058506199883, 0.6745318731635612, 0.5275968313031818], 
     RGBColor[0.5989378797253484, 0.5298344370010463, 0.5456770306025844], 
     RGBColor[0.6317334630886688, 0.5821418502934176, 0.5458768151014722], 
     RGBColor[0.5433495319281164, 0.4402184029773755, 0.5442116138200268], 
     RGBColor[0.5645036839160926, 0.4749135139111509, 0.5454672639862037], 
     RGBColor[0.5087087659067865, 0.3290224511484268, 0.4780077982032418], 
     RGBColor[0.524792327757223, 0.38065026352583864`, 0.508745951122603], 
     RGBColor[0.4976963995920746, 0.28907328161411344`, 0.44393185326669593`],
      
     RGBColor[0.4658623302043665, 0.1849747575413078, 0.296537649993221], 
     RGBColor[0.4823509479901109, 0.21698342905754361`, 0.3499305672719703], 
     RGBColor[0.4041052932704158, 0.11967342876590409`, 0.1710749045711598], 
     RGBColor[
     0.44839429009997056`, 0.16084617659879352`, 0.25021933421093623`], 
     RGBColor[0.30739378530123024`, 0.076390920933646, 0.08750317448160048], 
     RGBColor[
     0.21787822499017054`, 0.050560330284972185`, 0.051584102095396836`], 
     RGBColor[0.19639881025748457`, 0.04557586566827405, 0.04649870945200518],
      
     RGBColor[
     0.05628239999975871, 0.013060767010320095`, 0.01332522819980058], 
     RGBColor[
     0.11996356643179147`, 0.027838475098776926`, 0.02840216299184845], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.11824896644664759`, 0.027440588887066717`, 0.027996220173604827`], 
     RGBColor[0.8419099452991645, 0.815813358736865, 0.46437578597569124`], 
     RGBColor[0.8014788998032034, 0.7743763000577947, 0.4829181601187502], 
     RGBColor[0.6638655890445496, 0.6333388679810726, 0.5460299956859732], 
     RGBColor[0.7226441902577934, 0.6935800098479126, 0.5190731163391231], 
     RGBColor[0.6439111802889543, 0.6015647365856422, 0.5459509994543318], 
     RGBColor[0.5096808621318589, 0.33214285457569814`, 0.47986562314876535`],
      
     RGBColor[0.5252366927773325, 0.38207666360429393`, 0.5095952008141303], 
     RGBColor[0.4980040520098892, 0.2905185709424565, 0.44581643272802973`], 
     RGBColor[0.4826586004079254, 0.2184287183858866, 0.3518151467333041], 
     RGBColor[
     0.43251367767524723`, 0.13891030743335647`, 0.20811024717493237`], 
     RGBColor[0.4489507529489429, 0.1616148180040506, 0.2516948530330691], 
     RGBColor[0.3217841270423502, 0.08283121012154027, 0.09993836219750893], 
     RGBColor[0.18558617846870876`, 0.04306671068266244, 0.04393874779389406],
      
     RGBColor[0.21740016576042193`, 0.0504493929365843, 0.05147091842999791], 
     
     RGBColor[
     0.12831892688994356`, 0.029777401232552916`, 0.03038034950836062], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.0826328624346141, 0.019175595988425394`, 0.019563873408893054`], 
     RGBColor[0.8103905675881038, 0.78350970970381, 0.47883111571316406`], 
     RGBColor[0.7507987880095186, 0.7224351558084691, 0.5061609326704627], 
     RGBColor[0.8088731886929591, 0.7819545750901683, 0.479527011820856], 
     RGBColor[0.7412298743157043, 0.7126281465322645, 0.5105494013750642], 
     RGBColor[0.6548829243685317, 0.6190641524597458, 0.5460178372467436], 
     RGBColor[0.5383625668550502, 0.42421037568098524`, 0.534680758873536], 
     RGBColor[0.5245981414020158, 0.3800269304105675, 0.508374831221631], 
     RGBColor[
     0.49828123726047496`, 0.29182073163240513`, 0.44751438015177986`], 
     RGBColor[
     0.46843077826006246`, 0.18852255148030317`, 0.30334815577424357`], 
     RGBColor[
     0.48293578565851125`, 0.21973087907583527`, 0.35351309415705423`], 
     RGBColor[0.4495072157979152, 0.1623834594093077, 0.2531703718552021], 
     RGBColor[0.38519005758575875`, 0.11120805733429504`, 0.154729600848647], 
     
     RGBColor[0.28381850668338243`, 0.06586228357398631, 0.0671958972769269], 
     
     RGBColor[
     0.33474937694957624`, 0.08863371018012166, 0.11114207919606525`], 
     RGBColor[0.2384015212633598, 0.05532292020489467, 0.05644312740799076], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.13381311103901314`, 0.031052369234683228`, 0.03168113372435697], 
     RGBColor[0.8652294576766177, 0.8397131117830325, 0.4536810557743753], 
     RGBColor[0.7851139891925185, 0.757604194540008, 0.49042339011314523`], 
     RGBColor[0.7222211195753406, 0.6931464122379785, 0.5192671438441447], 
     RGBColor[0.786124500711189, 0.7586398498039613, 0.48995995211827736`], 
     RGBColor[0.6840506196416087, 0.6540261464580223, 0.536772792840275], 
     RGBColor[0.6624756068528294, 0.6311741239856098, 0.546064090434209], 
     RGBColor[0.5620698025615177, 0.4710315876008926, 0.5454524372407425], 
     RGBColor[0.5359989824997171, 0.41662333179294186`, 0.5301635867429072], 
     RGBColor[0.5117319037674823, 0.33872664451768464`, 0.4837854782173151], 
     RGBColor[0.5243139593051866, 0.37911471332130897`, 0.5078317156586414], 
     RGBColor[0.4984730554054995, 0.29272185478936225`, 0.44868939622671394`],
      
     RGBColor[0.4696481005298165, 0.19020403713887413`, 0.3065760117307389], 
     RGBColor[0.48312760380353575`, 0.2206320022327924, 0.3546881102319883], 
     RGBColor[0.4262686748809241, 0.13028409324398488`, 0.19155097608556076`],
      
     RGBColor[0.44779524593665426`, 0.16001871767974274`, 0.2486309066278648],
      
     RGBColor[0.3605384883430468, 0.10017543297313733`, 0.1334273346106681], 
     RGBColor[0.38098102167520514`, 0.10932433497704633`, 0.1510924285985139],
      
     RGBColor[0.2900902686555155, 0.06864686223297528, 0.07255061244341343], 
     RGBColor[0.34372160827042664`, 0.0926491648097948, 0.11889529192113317`],
      
     RGBColor[
     0.11745266430958956`, 0.027255800806210546`, 0.027807690407775143`], 
     RGBColor[0.14342843554189405`, 0.033283679787561, 0.033957625011447994`],
      
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.018454860612979754`, 0.004282593398204324, 0.004369309572166808], 
     RGBColor[0.8823907398661688, 0.857301404353096, 0.4458105960514117], 
     RGBColor[0.7710865464605444, 0.7432277182339434, 0.4968566170608031], 
     RGBColor[0.7024447594097645, 0.6728779728101316, 0.5283369233880508], 
     RGBColor[0.7844368025243469, 0.7569101579806885, 0.4907339595879609], 
     RGBColor[0.6798085585383137, 0.6496785335605275, 0.5387182751583831], 
     RGBColor[0.5585079379493588, 0.4653505810368183, 0.545430739034348], 
     RGBColor[0.6667334100030823, 0.6362780466216956, 0.5447147635781681], 
     RGBColor[0.5343633313758177, 0.41137293451621604`, 0.5270376066374629], 
     RGBColor[0.5124046152277231, 0.3408860306895046, 0.4850711329701474], 
     RGBColor[0.5242125358890993, 0.37878914681153203`, 0.5076378799584224], 
     RGBColor[0.49854151450884554`, 0.2930434619205422, 0.4491087546085648], 
     RGBColor[0.4704905136783797, 0.19136766131884328`, 0.30880975735996263`],
      
     RGBColor[0.4831960629068818, 0.2209536093639724, 0.35510746861383924`], 
     RGBColor[0.4221015270951324, 0.12772750782873524`, 0.1866260672756749], 
     RGBColor[0.4476682369226358, 0.15984328029484676`, 0.24829412908537313`],
      
     RGBColor[0.3639710487460067, 0.10171164955837712`, 0.13639352775082345`],
      
     RGBColor[0.3794788341509186, 0.10865204225148806`, 0.14979433685162913`],
      
     RGBColor[0.1737904017015502, 0.04032940928715931, 0.041146020098966916`],
      
     RGBColor[
     0.34692376055461127`, 0.09408226397483384, 0.12166238150559928`], 
     RGBColor[
     0.11096884212251602`, 0.025751179629393734`, 0.02627260288041214], 
     RGBColor[0.16282025276132, 0.037783701226069694`, 0.038548765219733015`],
      
     RGBColor[
     0.10906178562176518`, 0.02530863239203481, 0.025821094716891625`], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.8885155305673524, 0.8635785932946316, 0.44300166149787357`], 
     RGBColor[0.7710865464605444, 0.7432277182339434, 0.4968566170608031], 
     RGBColor[0.6953866581847222, 0.6656442505297094, 0.5315738902299642], 
     RGBColor[0.6975149393109266, 0.6678254879632282, 0.5305978238324817], 
     RGBColor[0.6840506196416087, 0.6540261464580223, 0.536772792840275], 
     RGBColor[0.5572367231872879, 0.46332305326863177`, 0.5454229950341452], 
     RGBColor[0.6624756068528294, 0.6311741239856098, 0.546064090434209], 
     RGBColor[0.5337795742483847, 0.40949908942336, 0.5259219572547166], 
     RGBColor[0.5126447031681667, 0.3416567066914107, 0.48552997783896923`], 
     RGBColor[0.5243139593051866, 0.37911471332130897`, 0.5078317156586414], 
     RGBColor[0.4984730554054995, 0.29272185478936225`, 0.44868939622671394`],
      
     RGBColor[0.47079116745016, 0.19178295398045375`, 0.3096069719449549], 
     RGBColor[0.48312760380353575`, 0.2206320022327924, 0.3546881102319883], 
     RGBColor[0.4201859357854372, 0.1268701993490484, 0.18497073914299028`], 
     RGBColor[0.3651961153701136, 0.1022599189098367, 0.13745214982591514`], 
     RGBColor[0.3809810216752051, 0.1093243349770463, 0.15109242859851385`], 
     RGBColor[0.168996979354657, 0.039217058490905024`, 0.04001114584643594], 
     
     RGBColor[
     0.34372160827042664`, 0.09264916480979483, 0.11889529192113321`], 
     RGBColor[
     0.08713039790076367, 0.020219283941396177`, 0.020628694497250986`], 
     RGBColor[0.1647196078020953, 0.03822446127996841, 0.038998450011975], 
     RGBColor[
     0.11096884212251602`, 0.025751179629393734`, 0.02627260288041214], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.002604203155693838, 0.0006043255203083625, 0.0006165622171124536], 
     RGBColor[0.786124500711189, 0.7586398498039613, 0.48995995211827736`], 
     RGBColor[0.7851139891925185, 0.757604194540008, 0.49042339011314523`], 
     RGBColor[0.7024447594097645, 0.6728779728101316, 0.5283369233880508], 
     RGBColor[0.694789151016698, 0.6650318760714468, 0.5318479173130326], 
     RGBColor[0.6548829243685319, 0.6190641524597461, 0.5460178372467436], 
     RGBColor[0.5585079379493588, 0.4653505810368183, 0.545430739034348], 
     RGBColor[0.5343633313758177, 0.41137293451621604`, 0.5270376066374629], 
     RGBColor[0.5620698025615176, 0.4710315876008923, 0.5454524372407425], 
     RGBColor[0.5124046152277231, 0.3408860306895046, 0.4850711329701474], 
     RGBColor[0.5245981414020158, 0.3800269304105675, 0.508374831221631], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[
     0.49828123726047496`, 0.29182073163240513`, 0.44751438015177986`], 
     RGBColor[0.44779524593665426`, 0.16001871767974274`, 0.2486309066278648],
      
     RGBColor[
     0.48293578565851125`, 0.21973087907583527`, 0.35351309415705423`], 
     RGBColor[0.4221015270951324, 0.12772750782873524`, 0.1866260672756749], 
     RGBColor[0.3639710487460067, 0.10171164955837712`, 0.13639352775082345`],
      
     RGBColor[0.38519005758575864`, 0.11120805733429501`, 0.1547296008486469],
      
     RGBColor[0.1737904017015502, 0.04032940928715931, 0.041146020098966916`],
      
     RGBColor[0.3347493769495764, 0.08863371018012174, 0.11114207919606542`], 
     
     RGBColor[
     0.09510587475386031, 0.02207005514118408, 0.022516941072915773`], 
     RGBColor[0.1628202527613201, 0.03778370122606971, 0.03854876521973303], 
     RGBColor[
     0.14337476619574022`, 0.033271225399942234`, 0.0339449184409244], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.018454860612979754`, 0.004282593398204324, 0.004369309572166808], 
     RGBColor[0.8103905675881038, 0.78350970970381, 0.47883111571316406`], 
     RGBColor[0.7222211195753403, 0.693146412237978, 0.519267143844145], 
     RGBColor[0.8088731886929591, 0.7819545750901683, 0.479527011820856], 
     RGBColor[0.6439111802889547, 0.6015647365856427, 0.5459509994543318], 
     RGBColor[0.5359989824997171, 0.41662333179294175`, 0.5301635867429071], 
     RGBColor[0.5756427954763912, 0.4926798730467541, 0.5455351213496931], 
     RGBColor[0.5117319037674823, 0.33872664451768475`, 0.48378547821731516`],
      
     RGBColor[0.5256810577974421, 0.3835030636827492, 0.5104444505056576], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4980040520098892, 0.2905185709424565, 0.44581643272802973`], 
     RGBColor[0.4696481005298165, 0.19020403713887418`, 0.30657601173073895`],
      
     RGBColor[0.4826586004079254, 0.21842871838588662`, 0.35181514673330416`],
      
     RGBColor[0.42626867488092407`, 0.1302840932439848, 0.1915509760855606], 
     RGBColor[0.3605384883430469, 0.10017543297313738`, 0.1334273346106682], 
     RGBColor[0.401229188999506, 0.1183862499363515, 0.1685895642545298], 
     RGBColor[0.2900902686555156, 0.06864686223297532, 0.07255061244341351], 
     RGBColor[0.3217841270423505, 0.08283121012154038, 0.09993836219750918], 
     RGBColor[
     0.11745266430958905`, 0.02725580080621043, 0.027807690407775025`], 
     RGBColor[
     0.14342843554189458`, 0.033283679787561124`, 0.03395762501144811], 
     RGBColor[0.1366742873480962, 0.03171632736632903, 0.03235853602487291], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.04701675842257977, 0.010910603089783874`, 0.011131526644181083`], 
     RGBColor[0.7507987880095177, 0.7224351558084683, 0.506160932670463], 
     RGBColor[0.5383625668550502, 0.42421037568098513`, 0.5346807588735359], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4684307782600625, 0.18852255148030322`, 0.3033481557742437], 
     RGBColor[0.3555782948466307, 0.09795553568928411, 0.12914106133482844`], 
     
     RGBColor[
     0.11540644776491468`, 0.02678096040241157, 0.027323235189019066`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.08263286243461286, 0.01917559598842511, 0.019563873408892762`], 
     RGBColor[0.6496947180940268, 0.6107892074209538, 0.5459862316741518], 
     RGBColor[0.5645036839160926, 0.4749135139111509, 0.5454672639862037], 
     RGBColor[0.5096808621318589, 0.33214285457569814`, 0.47986562314876535`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4981501647303595, 0.2912049791856651, 0.4467114721169418], 
     RGBColor[0.4828047131283958, 0.21911512662909527`, 0.3527101861222162], 
     RGBColor[
     0.44839429009997056`, 0.16084617659879352`, 0.25021933421093623`], 
     RGBColor[0.38806616185666853`, 0.11249523616384764`, 0.157214941165277], 
     
     RGBColor[0.3286185020010434, 0.08588988321939414, 0.10584417993701455`], 
     
     RGBColor[0.7881548516233106, 0.7607207203046534, 0.4890287982044361], 
     RGBColor[0.6592156407858025, 0.625974631404612, 0.5460442313367239], 
     RGBColor[0.560037246964321, 0.46778975700180025`, 0.5454400552959865], 
     RGBColor[0.4983906970762643, 0.2923349518838387, 0.44818489567102515`], 
     RGBColor[0.4830452454743006, 0.22024509932726885`, 0.3541836096762996], 
     RGBColor[0.4479480415428062, 0.16022977405061573`, 0.2490360599875774], 
     RGBColor[0.3827881977650362, 0.11013312304068922`, 0.1526540714223626], 
     RGBColor[0.339869324217725, 0.09092510406268839, 0.11556640118371157`], 
     RGBColor[0.8308716355965585, 0.8045003916529362, 0.46943814500949665`], 
     RGBColor[0.7848640834839283, 0.7573480706286905, 0.49053800117729957`], 
     RGBColor[0.6652949117056866, 0.6348037553282665, 0.5453744836845187], 
     RGBColor[0.5468406266232293, 0.4467417681126616, 0.5453596639776602], 
     RGBColor[0.5575585614564798, 0.46383637017394264`, 0.545424955612087], 
     RGBColor[0.49852418245765423`, 0.2929620394217268, 0.4490025840543728], 
     RGBColor[0.4831787308556905, 0.22087218686515703`, 0.35500129805964725`],
      
     RGBColor[0.4477003922770756, 0.1598876964438651, 0.24837939233483514`], 
     RGBColor[0.24887565946986848`, 0.05775352513200666, 0.05892294848524717],
      
     RGBColor[0.3461130594995416, 0.09371944081653034, 0.12096182692651869`], 
     
     RGBColor[0.2402250145458996, 0.05574607594999861, 0.05687485143025616], 
     RGBColor[
     0.17021054829490193`, 0.03949867656653023, 0.040298466271027344`], 
     RGBColor[0.8379297368216009, 0.8117341139333584, 0.4662011781675833], 
     RGBColor[0.7848640834839283, 0.7573480706286905, 0.49053800117729957`], 
     RGBColor[0.6652949117056866, 0.6348037553282665, 0.5453744836845187], 
     RGBColor[0.5484616811930547, 0.4493272739234281, 0.5453695391358885], 
     RGBColor[0.5575585614564798, 0.46383637017394264`, 0.545424955612087], 
     RGBColor[0.5242382136405407, 0.37887157172126384`, 0.507686954078805], 
     RGBColor[0.49852418245765423`, 0.2929620394217268, 0.4490025840543728], 
     RGBColor[0.4831787308556905, 0.22087218686515703`, 0.35500129805964725`],
      
     RGBColor[0.4382527998097823, 0.14683774932921392`, 0.22332812335061178`],
      
     RGBColor[0.4477003922770756, 0.1598876964438651, 0.24837939233483514`], 
     RGBColor[
     0.34611305949954163`, 0.09371944081653037, 0.12096182692651873`], 
     RGBColor[0.24820049139899625`, 0.05759684714978651, 0.05876309800592095],
      
     RGBColor[
     0.17021054829490193`, 0.03949867656653023, 0.040298466271027344`], 
     RGBColor[
     0.029969723343798722`, 0.006954706514981318, 0.0070955290222648746`], 
     RGBColor[
     0.10954460235876795`, 0.025420673756843405`, 0.025935404753408775`], 
     RGBColor[0.8308716355965585, 0.8045003916529362, 0.46943814500949665`], 
     RGBColor[0.6592156407858025, 0.625974631404612, 0.5460442313367239], 
     RGBColor[0.560037246964321, 0.46778975700180025`, 0.5454400552959865], 
     RGBColor[0.4983906970762643, 0.2923349518838387, 0.44818489567102515`], 
     RGBColor[0.4830452454743006, 0.22024509932726885`, 0.3541836096762996], 
     RGBColor[0.4375217810762215, 0.1458279941089487, 0.22138975153892154`], 
     RGBColor[0.4479480415428062, 0.16022977405061578`, 0.24903605998757747`],
      
     RGBColor[
     0.33986932421772487`, 0.09092510406268836, 0.11556640118371153`], 
     RGBColor[0.6496947180940268, 0.6107892074209538, 0.5459862316741518], 
     RGBColor[0.4981501647303595, 0.2912049791856651, 0.4467114721169418], 
     RGBColor[0.4828047131283958, 0.21911512662909527`, 0.3527101861222162], 
     RGBColor[
     0.43547351210107726`, 0.14299872285336163`, 0.21595855441372636`], 
     RGBColor[0.3286185020010435, 0.08588988321939417, 0.10584417993701459`], 
     
     RGBColor[0.6378223216888118, 0.5918532934395302, 0.545913907277902], 
     RGBColor[0.49785022580098187`, 0.289795926278285, 0.4448741429973629], 
     RGBColor[
     0.48250477419901816`, 0.21770607372171516`, 0.35087285700263726`], 
     RGBColor[0.3145889561717905, 0.07961106552759324, 0.09372076833955494], 
     RGBColor[0.6259499252835965, 0.5729173794581062, 0.5458415828816522], 
     RGBColor[0.5256810577974421, 0.3835030636827492, 0.5104444505056576], 
     RGBColor[0.4975502868716043, 0.2883868733709049, 0.443036813877784], 
     RGBColor[0.48220483526964053`, 0.216297020814335, 0.34903552788305825`], 
     
     RGBColor[
     0.40122918899950594`, 0.11838624993635147`, 0.16858956425452976`], 
     RGBColor[0.3005594103425372, 0.0733322478357922, 0.08159735674209503], 
     RGBColor[
     0.04701675842257998, 0.010910603089783923`, 0.011131526644181131`], 
     RGBColor[0.8148029479830967, 0.7880318798109364, 0.4768075220330642], 
     RGBColor[0.7561344357074892, 0.7279035661362144, 0.5037139126961411], 
     RGBColor[0.6164290025918209, 0.557731955474448, 0.5457835832190802], 
     RGBColor[0.5260374108755397, 0.3846469477320176, 0.511125495880414], 
     RGBColor[0.4973097545256995, 0.28725690067273124`, 0.4415633903237005], 
     RGBColor[0.4819643029237357, 0.21516704811616136`, 0.34756210432897483`],
      
     RGBColor[0.4499534643550796, 0.1629998619574855, 0.2543536460785608], 
     RGBColor[0.4065071530911383, 0.12074836305950991`, 0.17315043399744418`],
      
     RGBColor[0.2893085881258556, 0.06829702699249791, 0.07187513549539794], 
     RGBColor[0.8180937161224793, 0.7914045294868997, 0.47529831906020054`], 
     RGBColor[0.7644058432570559, 0.7363807844664735, 0.49992050266698146`], 
     RGBColor[0.6148966122351958, 0.55528786491441, 0.5457742481864903], 
     RGBColor[0.6111452891190446, 0.5493046809455222, 0.5457513958346775], 
     RGBColor[0.5262351719141243, 0.385281755487324, 0.5115034475494555], 
     RGBColor[0.4971762691443095, 0.28662981313484304`, 0.4407457019403528], 
     RGBColor[0.4818308175423458, 0.21453996057827318`, 0.34674441594562716`],
      
     RGBColor[0.4502011136208102, 0.1633419395642361, 0.2550103137313031], 
     RGBColor[0.4094362021846548, 0.12205923694611698`, 0.17568152575066578`],
      
     RGBColor[0.2943945632574588, 0.07057321690092559, 0.0762701009950154], 
     RGBColor[0.28220340802780397`, 0.06548748741676341, 0.06681351205257852],
      
     RGBColor[
     0.09510587475386041, 0.022070055141184104`, 0.022516941072915797`], 
     RGBColor[
     0.14709325142111962`, 0.034134128708262525`, 0.034825294263312566`], 
     RGBColor[0.7644058432570559, 0.7363807844664735, 0.49992050266698146`], 
     RGBColor[0.6159333155441415, 0.5569413579424758, 0.545780563587219], 
     RGBColor[0.6111452891190445, 0.549304680945522, 0.5457513958346775], 
     RGBColor[0.5262351719141243, 0.385281755487324, 0.5115034475494555], 
     RGBColor[0.4971762691443095, 0.28662981313484304`, 0.4407457019403528], 
     RGBColor[0.4818308175423458, 0.21453996057827318`, 0.34674441594562716`],
      
     RGBColor[0.4094362021846548, 0.12205923694611698`, 0.17568152575066578`],
      
     RGBColor[0.2959307482150831, 0.07126072492201195, 0.07759757108975456], 
     RGBColor[0.28220340802780397`, 0.06548748741676341, 0.06681351205257852],
      
     RGBColor[0.16974111219785437`, 0.03938974028289985, 0.04018732418898377],
      
     RGBColor[
     0.14709325142111962`, 0.034134128708262525`, 0.034825294263312566`], 
     RGBColor[0.8823907398661688, 0.857301404353096, 0.4458105960514117], 
     RGBColor[0.6164290025918208, 0.5577319554744479, 0.5457835832190802], 
     RGBColor[0.5801092324281628, 0.4998036299561047, 0.5455623300399102], 
     RGBColor[0.5260374108755397, 0.3846469477320176, 0.511125495880414], 
     RGBColor[0.4973097545256995, 0.28725690067273124`, 0.4415633903237005], 
     RGBColor[0.4704905136783797, 0.19136766131884328`, 0.30880975735996263`],
      
     RGBColor[0.4819643029237357, 0.21516704811616136`, 0.34756210432897483`],
      
     RGBColor[0.4065071530911383, 0.12074836305950991`, 0.17315043399744418`],
      
     RGBColor[0.2943945632574588, 0.07057321690092559, 0.0762701009950154], 
     RGBColor[0.2893085881258555, 0.06829702699249789, 0.0718751354953979], 
     RGBColor[0.6259499252835965, 0.5729173794581062, 0.5458415828816522], 
     RGBColor[0.4975502868716043, 0.2883868733709049, 0.443036813877784], 
     RGBColor[0.48220483526964053`, 0.216297020814335, 0.34903552788305825`], 
     
     RGBColor[0.3005594103425371, 0.07333224783579216, 0.08159735674209496], 
     RGBColor[0.782517606996805, 0.7549432086545992, 0.49161413572708457`], 
     RGBColor[0.704058506199883, 0.6745318731635612, 0.5275968313031818], 
     RGBColor[0.5409859475727834, 0.43263135908933215`, 0.539694441689398], 
     RGBColor[0.4670796524741205, 0.18665624319987875`, 0.2997655059497163], 
     RGBColor[0.35007289541150455`, 0.095491635589138, 0.12438365691327635`], 
     
     RGBColor[
     0.19639881025748465`, 0.045575865668274075`, 0.04649870945200521], 
     RGBColor[
     0.08430438777673882, 0.019563486395469697`, 0.01995961802222968], 
     RGBColor[0.6891539448080981, 0.6592564535596113, 0.5344323199821049], 
     RGBColor[
     0.34511270191508836`, 0.09327173830528473, 0.12009738363743663`], 
     RGBColor[
     0.25750583002742233`, 0.0597562230786475, 0.060966198099391175`], 
     RGBColor[0.17955703077662638`, 0.04166760024534216, 0.04251130744224518],
      
     RGBColor[
     0.05628239999975892, 0.013060767010320143`, 0.013325228199800629`], 
     RGBColor[
     0.11326308758414745`, 0.02628357706516372, 0.026815780575796963`], 
     RGBColor[0.6808825372585314, 0.6507792352293522, 0.5382257300112646], 
     RGBColor[0.3416801415121284, 0.09173552172004491, 0.11713119049728124`], 
     
     RGBColor[0.3798591486715197, 0.10882224915408217`, 0.15012297966914104`],
      
     RGBColor[
     0.10954460235876795`, 0.025420673756843405`, 0.025935404753408775`], 
     RGBColor[0.16266152171353354`, 0.03774686645654223, 0.03851118460067346],
      
     RGBColor[0.6808825372585314, 0.6507792352293522, 0.5382257300112646], 
     RGBColor[0.3798591486715197, 0.10882224915408217`, 0.15012297966914104`],
      
     RGBColor[0.7881548516233106, 0.7607207203046534, 0.4890287982044361], 
     RGBColor[0.6891539448080981, 0.6592564535596113, 0.5344323199821049], 
     RGBColor[
     0.38278819776503625`, 0.11013312304068923`, 0.15265407142236265`], 
     RGBColor[0.24887565946986864`, 0.0577535251320067, 0.05892294848524721], 
     
     RGBColor[0.794084610913448, 0.7667980250254213, 0.4863093084166444], 
     RGBColor[
     0.34511270191508836`, 0.09327173830528473, 0.12009738363743663`], 
     RGBColor[0.38806616185666853`, 0.11249523616384764`, 0.157214941165277], 
     
     RGBColor[0.2575058300274221, 0.05975622307864745, 0.06096619809939112], 
     RGBColor[0.8129061268404583, 0.7860878615935727, 0.47767743689373177`], 
     RGBColor[0.782517606996805, 0.7549432086545992, 0.49161413572708457`], 
     RGBColor[0.5409859475727834, 0.43263135908933215`, 0.539694441689398], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4670796524741205, 0.18665624319987875`, 0.2997655059497163], 
     RGBColor[0.35007289541150455`, 0.095491635589138, 0.12438365691327635`], 
     
     RGBColor[
     0.08430438777673882, 0.019563486395469697`, 0.01995961802222968], 
     RGBColor[0.8404306864056519, 0.8142972926341929, 0.4650541995937783], 
     RGBColor[0.6077943081094953, 0.5439600238110671, 0.5457309822913549], 
     RGBColor[0.5756427954763912, 0.4926798730467541, 0.5455351213496931], 
     RGBColor[0.5107598075424098, 0.3356062410904133, 0.48192765327179155`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4292285093067542, 0.13437250866399003`, 0.19939928332435475`],
      
     RGBColor[
     0.14974471083105148`, 0.03474942040852032, 0.035453044709277945`], 
     RGBColor[
     0.11540644776491406`, 0.026780960402411427`, 0.027323235189018916`], 
     RGBColor[
     0.13667428734809609`, 0.031716327366329004`, 0.03235853602487288], 
     RGBColor[0.6871516619352843, 0.6572043494926717, 0.5353506014094715], 
     RGBColor[0.6119918341130264, 0.5506548804031821, 0.5457565528268716], 
     RGBColor[0.5801092324281628, 0.4998036299561047, 0.5455623300399102], 
     RGBColor[0.2552433007442182, 0.059231185627826595`, 0.06043052941775081],
      
     RGBColor[
     0.14337476619574022`, 0.033271225399942234`, 0.0339449184409244], 
     RGBColor[0.694789151016698, 0.6650318760714468, 0.5318479173130326], 
     RGBColor[0.582587917936004, 0.5037570167839625, 0.5455774297238096], 
     RGBColor[0.2645897832259425, 0.06140010930663851, 0.06264337058896861], 
     RGBColor[
     0.002604203155693838, 0.0006043255203083625, 0.0006165622171124536], 
     RGBColor[0.8180937161224793, 0.7914045294868997, 0.47529831906020054`], 
     RGBColor[0.582587917936004, 0.5037570167839625, 0.5455774297238096], 
     RGBColor[0.2645897832259426, 0.06140010930663853, 0.06264337058896864], 
     RGBColor[0.8148029479830967, 0.7880318798109364, 0.4768075220330642], 
     RGBColor[0.7561344357074892, 0.7279035661362144, 0.5037139126961411], 
     RGBColor[0.6148966122351958, 0.55528786491441, 0.5457742481864903], 
     RGBColor[0.2552433007442182, 0.059231185627826595`, 0.06043052941775081],
      
     RGBColor[0.8652294576766177, 0.8397131117830325, 0.4536810557743753], 
     RGBColor[0.6871516619352843, 0.6572043494926717, 0.5353506014094715], 
     RGBColor[0.7412298743157043, 0.7126281465322645, 0.5105494013750642], 
     RGBColor[0.6119918341130266, 0.5506548804031823, 0.5457565528268716], 
     RGBColor[0.2384015212633599, 0.05532292020489468, 0.05644312740799078], 
     RGBColor[0.8404306864056524, 0.8142972926341935, 0.46505419959377803`], 
     RGBColor[0.6077943081094953, 0.5439600238110673, 0.5457309822913549], 
     RGBColor[0.5107598075424098, 0.3356062410904133, 0.48192765327179155`], 
     RGBColor[0.4292285093067541, 0.13437250866398995`, 0.19939928332435458`],
      
     RGBColor[0.14974471083105076`, 0.03474942040852015, 0.03545304470927778],
      
     RGBColor[0.7605179744613242, 0.7323961769588256, 0.5017035462896546], 
     RGBColor[0.6014410276949862, 0.5338268403051524, 0.5456922793071803], 
     RGBColor[0.5680540515412307, 0.48057618332155866`, 0.5454888921551251], 
     RGBColor[0.49382695114475567`, 0.27089538921459777`, 0.4202288603817077],
      
     RGBColor[0.47461391865698105`, 0.1970633152210754, 0.319743392315898], 
     RGBColor[
     0.44426298016900595`, 0.15513960359620416`, 0.23926473845587182`], 
     RGBColor[
     0.37611685026158304`, 0.10714741165397473`, 0.14688913129683084`], 
     RGBColor[
     0.26276251484740387`, 0.06097607752125762, 0.062210752787908045`], 
     RGBColor[
     0.08523562424857098, 0.019779587034215812`, 0.02018009437887392], 
     RGBColor[
     0.03234018149122822, 0.0075047896950060575`, 0.007656750572033719], 
     RGBColor[0.7793394324402139, 0.7516859541369799, 0.49307170134274864`], 
     RGBColor[0.8227295544553537, 0.7961557176560305, 0.4731722437193222], 
     RGBColor[0.7025974167228803, 0.673034428572375, 0.5282669121137752], 
     RGBColor[0.6066106741445105, 0.5420721832958535, 0.5457237718168242], 
     RGBColor[0.5638706451042095, 0.4739038467740717, 0.5454634076333403], 
     RGBColor[0.49387535499957586`, 0.271122780812295, 0.42052536678101216`], 
     
     RGBColor[0.4431448966813867, 0.1535951963375604, 0.23630002439859915`], 
     RGBColor[
     0.37541533662864274`, 0.10683345450502975`, 0.14628292931304093`], 
     RGBColor[0.2691464283395231, 0.062457514111292266`, 0.063722186274942], 
     RGBColor[0.2448284572470719, 0.05681434049745265, 0.05796474675273868], 
     RGBColor[
     0.09212545220591445, 0.021378424995859922`, 0.02181130644142564], 
     RGBColor[
     0.0438719354089721, 0.010180822542586197`, 0.010386969121678729`], 
     RGBColor[0.8092936112180508, 0.7823854586507719, 0.47933419880643124`], 
     RGBColor[0.802755002820401, 0.7756841553198961, 0.4823329172861767], 
     RGBColor[0.6998054301605363, 0.6701729712542214, 0.5295473652607646], 
     RGBColor[0.6148381193371705, 0.5551945714926165, 0.5457738918588046], 
     RGBColor[0.5572127918998808, 0.46328488399055695`, 0.5454228492492629], 
     RGBColor[0.4939523892932233, 0.271484672466897, 0.42099725401225113`], 
     RGBColor[
     0.44136547700442774`, 0.15113728626581732`, 0.23158170900580038`], 
     RGBColor[
     0.37429888407753037`, 0.10633379456483667`, 0.14531816438259343`], 
     RGBColor[0.28743197757325306`, 0.06745716405739616, 0.07025349197149292],
      
     RGBColor[0.2162865680812648, 0.050190973966697326`, 0.05120726685867898],
      
     RGBColor[
     0.103090550585343, 0.023922961035182495`, 0.024407365567187436`], 
     RGBColor[
     0.06222461663385679, 0.014439704422071127`, 0.014732087051987896`], 
     RGBColor[0.8444477183239901, 0.8184142771265308, 0.463211919537432], 
     RGBColor[0.7793129471133762, 0.7516588097970588, 0.4930838479700124], 
     RGBColor[0.6965287656464153, 0.6668147761326823, 0.5310501000680599], 
     RGBColor[0.6244938168495657, 0.570594954977542, 0.5458327125441255], 
     RGBColor[0.5493991614085729, 0.4508225107833212, 0.545375250088275], 
     RGBColor[0.5179318621759974, 0.3586283486575477, 0.49563454942596935`], 
     RGBColor[0.4392771570283009, 0.14825269261497231`, 0.22604431250736007`],
      
     RGBColor[
     0.37298861972838576`, 0.10574739561247777`, 0.14418592003202893`], 
     RGBColor[0.30019986845186813`, 0.07317133756745199, 0.08128666426636136],
      
     RGBColor[
     0.18278991854256954`, 0.042417816900667434`, 0.043276714873799645`], 
     RGBColor[
     0.11595914717470425`, 0.026909218582909098`, 0.027454090407726384`], 
     RGBColor[0.8778390517088699, 0.8526364602006706, 0.447898078671756], 
     RGBColor[0.7570463739650015, 0.7288381954198426, 0.5032956820973837], 
     RGBColor[0.6934164067731919, 0.663624974937139, 0.532477481477243], 
     RGBColor[0.6336653373700082, 0.5852230989281327, 0.5458885837146704], 
     RGBColor[0.5432338670389089, 0.43984712171180806`, 0.5439905604809142], 
     RGBColor[0.5184670874352385, 0.3603464077243583, 0.49665744696681546`], 
     RGBColor[0.4372935541358418, 0.1455127445347948, 0.22078458419150565`], 
     RGBColor[0.3717440575048948, 0.10519040115217895`, 0.14311045114104243`],
      
     RGBColor[0.31232752396776015`, 0.078598978557403, 0.09176658723184977], 
     RGBColor[
     0.15097293088157185`, 0.03503443838780548, 0.035743833880543294`], 
     RGBColor[
     0.12818245859649516`, 0.029745732707667102`, 0.0303480397427457], 
     RGBColor[
     0.10422184940987539`, 0.024185487693006786`, 0.02467520800104109], 
     RGBColor[0.9028540482779851, 0.8782738848078261, 0.4364257702047833], 
     RGBColor[0.7403654512689108, 0.7117422147421233, 0.510945840679438], 
     RGBColor[0.6910847943862843, 0.6612353469147129, 0.5335467990945416], 
     RGBColor[0.6405361487781063, 0.5961817200325612, 0.5459304393998984], 
     RGBColor[0.5412316469849872, 0.43342004776864695`, 0.540164010941206], 
     RGBColor[0.518868049501332, 0.3616334854569673, 0.4974237469578906], 
     RGBColor[0.4358075452071951, 0.1434601223458219, 0.21684427775752668`], 
     RGBColor[0.3214129132100727, 0.08266507616354105, 0.09961758359682274], 
     RGBColor[0.1271373497142785, 0.02950320709377881, 0.030100603344346995`],
      
     RGBColor[
     0.13733950811455345`, 0.031870696999485436`, 0.03251603141448542], 
     RGBColor[0.11954833394746, 0.02774211718346072, 0.02830385397144935], 
     RGBColor[0.9145381811720236, 0.8902487445821718, 0.4310672255270275], 
     RGBColor[0.7325740403431575, 0.7037569364055677, 0.5145191159859613], 
     RGBColor[0.6899957329142692, 0.6601191872021099, 0.5340462614515294], 
     RGBColor[0.47983209761282153`, 0.20515037539312, 0.33450090245433783`], 
     RGBColor[
     0.14161662976798492`, 0.0328632362193926, 0.033528668083684446`], 
     RGBColor[
     0.12670710695151685`, 0.029403365927049414`, 0.02999874054185214], 
     RGBColor[0.910577264574834, 0.8861892716833807, 0.4328837701301562], 
     RGBColor[0.7352153256769701, 0.7064639427177416, 0.5133077770191513], 
     RGBColor[0.6426574667840065, 0.5995651224995919, 0.5459433620684814], 
     RGBColor[0.5406134746615332, 0.43143573079775616`, 0.5389825888417019], 
     RGBColor[0.4942128642924629, 0.27270833174893805`, 0.4225928398270644], 
     RGBColor[0.3242179676127614, 0.08392045715907848, 0.10204152728615826`], 
     
     RGBColor[0.14016668715787303`, 0.03252676580219134, 0.03318538463883422],
      
     RGBColor[0.1242802856320034, 0.028840203236226377`, 0.02942417464056157],
      
     RGBColor[0.8917558065959443, 0.8668994945052264, 0.44151561507706216`], 
     RGBColor[0.7477661683167486, 0.7193270778792658, 0.507551744317482], 
     RGBColor[0.6921192457685678, 0.6622955377186485, 0.5330723818657064], 
     RGBColor[0.6374878203344821, 0.5913197795088907, 0.5459118695588375], 
     RGBColor[0.5421199590020468, 0.43627150608216175`, 0.5418617114179038], 
     RGBColor[0.5186901572556728, 0.36106245600666925`, 0.49708376759877293`],
      
     RGBColor[
     0.43646683317416424`, 0.14437079595204044`, 0.21859244801950428`], 
     RGBColor[
     0.37122535203104035`, 0.10495825841956957`, 0.14266221995566217`], 
     RGBColor[0.31738205734695063`, 0.08086109694607425, 0.09613438283512965],
      
     RGBColor[
     0.1377123277957517, 0.031957212695209375`, 0.032604298924921456`], 
     RGBColor[0.13327685920052976`, 0.03092792784054728, 0.03155417257628254],
      
     RGBColor[
     0.11274853171425953`, 0.026164170388646237`, 0.02669395609091656], 
     RGBColor[0.8618016278181071, 0.836199989991434, 0.4552531176133797], 
     RGBColor[0.7677407199517015, 0.7397986402154004, 0.49839107075062733`], 
     RGBColor[0.6949112323309115, 0.6651569950368019, 0.5317919287187172], 
     RGBColor[0.6292603751418223, 0.5781973913121278, 0.5458617495168571], 
     RGBColor[0.5455419439301713, 0.4446704302861965, 0.5453517526480104], 
     RGBColor[0.5182100256922839, 0.35952124626086646`, 0.4961661625586643], 
     RGBColor[0.43824625285112323`, 0.1468287060237836, 0.22331076341230308`],
      
     RGBColor[
     0.37234180458215266`, 0.10545791835976263`, 0.14362698488610962`], 
     RGBColor[0.3065027684820276, 0.0759921530593192, 0.08673321629685804], 
     RGBColor[
     0.16625421696155898`, 0.038580579225964744`, 0.039361778818981195`], 
     RGBColor[
     0.12231176082110098`, 0.028383391801224653`, 0.028958113450520698`], 
     RGBColor[
     0.09439585048937474, 0.021905288509161285`, 0.02234883816060737], 
     RGBColor[0.826647520712168, 0.8001711715156753, 0.47137539688237884`], 
     RGBColor[0.7911827756587264, 0.7638239857382378, 0.48764014006679157`], 
     RGBColor[0.6981878968450328, 0.6685151901583413, 0.5302891939114218], 
     RGBColor[0.6196046776294268, 0.562797007827202, 0.5458029288315362], 
     RGBColor[0.5533555744214791, 0.4571328034934321, 0.5453993518089982], 
     RGBColor[0.517646545166595, 0.357712488528648, 0.495089264871027], 
     RGBColor[0.3736520689312972, 0.10604431731212152`, 0.14475922923667411`],
      
     RGBColor[0.2937348776034124, 0.07027797954926329, 0.07570004400198949], 
     RGBColor[0.1997508665002546, 0.04635373629199472, 0.04729233080386062], 
     RGBColor[
     0.10944316423173964`, 0.02539713425349803, 0.025911388609981725`], 
     RGBColor[0.7932561873272888, 0.765948988441536, 0.4866892377480546], 
     RGBColor[0.8134493488071011, 0.7866446001154539, 0.47742830593942037`], 
     RGBColor[0.701300255718256, 0.6717049913538845, 0.5288618125022386], 
     RGBColor[0.6104331571089846, 0.5481688638766117, 0.5457470576609912], 
     RGBColor[0.5607773968530732, 0.46897026126971836`, 0.5454445641492973], 
     RGBColor[0.517111319907354, 0.3559944294618376, 0.494066367330181], 
     RGBColor[0.4939111452440871, 0.2712909161996855, 0.42074460627277727`], 
     RGBColor[0.3748966311547882, 0.10660131177242034`, 0.1458346981276606], 
     RGBColor[0.27928083808265936`, 0.06480928241617599, 0.06612157440512394],
      
     RGBColor[
     0.23156785416125145`, 0.053737114804856476`, 0.05482521179711677], 
     RGBColor[
     0.09721985280994903, 0.02256062012874009, 0.023017439274962484`], 
     RGBColor[0.05239861771335623, 0.012159505238225649`, 0.0124057172115542],
      
     RGBColor[0.768241190758173, 0.74031156383438, 0.4981615462150276], 
     RGBColor[0.8301302715031912, 0.8037405807931729, 0.4697781473573662], 
     RGBColor[0.7036318681051636, 0.6740946193763107, 0.5277924948849401], 
     RGBColor[0.6035623457008864, 0.5372102427721831, 0.5457052019757633], 
     RGBColor[0.5663374282696977, 0.4778382499255695, 0.5454784348104185], 
     RGBColor[0.5167103578412604, 0.3547073517292285, 0.4933000673391058], 
     RGBColor[0.4938468132319966, 0.2709886973151218, 0.42035052912053755`], 
     RGBColor[0.3758289904407093, 0.10701858215670816`, 0.14664038175544886`],
      
     RGBColor[0.261064506257342, 0.06058204147133055, 0.06180873809152173], 
     RGBColor[0.2554034353285449, 0.05926834609888317, 0.0604684423333131], 
     RGBColor[0.08806280329189074, 0.02043565583692176, 0.02084944760322276], 
     
     RGBColor[
     0.03707213317577161, 0.008602875747771715, 0.008777071241145943], 
     RGBColor[
     0.02991336017171457, 0.006941627004182971, 0.007082184670743099], 
     RGBColor[0.7909939228167038, 0.7636304338228568, 0.4877267512343191], 
     RGBColor[0.5904878532211946, 0.5163570420790641, 0.5456255546372992], 
     RGBColor[0.2031950989363512, 0.047152997115581456`, 0.04810777547545137],
      
     RGBColor[
     0.17907947836975927`, 0.04155678050913092, 0.042398243770495295`], 
     RGBColor[
     0.12670710695151685`, 0.029403365927049414`, 0.02999874054185214], 
     RGBColor[
     0.005040518830330079, 0.0011696914498023282`, 0.0011933759693941296`], 
     RGBColor[0.9028540482779851, 0.8782738848078261, 0.4364257702047833], 
     RGBColor[0.8371045809400697, 0.8108884263617668, 0.4665796088733444], 
     RGBColor[0.7403654512689108, 0.7117422147421233, 0.510945840679438], 
     RGBColor[0.7970912514205948, 0.7698794773498229, 0.48493041127180647`], 
     RGBColor[0.6890122296321118, 0.659111212198894, 0.5344973130037459], 
     RGBColor[0.6910847943862843, 0.6612353469147129, 0.5335467990945416], 
     RGBColor[0.7931659706001234, 0.7658565269241172, 0.48673061269368223`], 
     RGBColor[0.23888361157923851`, 0.05543479299805292, 0.0565572654595313], 
     
     RGBColor[0.1271373497142785, 0.02950320709377881, 0.030100603344346995`],
      
     RGBColor[0.25189258524459, 0.058453626133940416`, 0.05963722549564824], 
     RGBColor[
     0.09594359753196192, 0.022264455202732097`, 0.02271527744781135], 
     RGBColor[0.18901296244257884`, 0.04386192245539437, 0.04475006142734669],
      
     RGBColor[
     0.16587670208847294`, 0.038492973974583705`, 0.0392723996909996], 
     RGBColor[
     0.11954833394745991`, 0.027742117183460698`, 0.028303853971449324`], 
     RGBColor[
     0.026308292933593172`, 0.00610504321859736, 0.006228661302446822], 
     RGBColor[0.8778390517088699, 0.8526364602006706, 0.447898078671756], 
     RGBColor[0.13761038516326116`, 0.03193355611746245, 0.03258016333650961],
      
     RGBColor[
     0.10422184940987539`, 0.024185487693006786`, 0.02467520800104109], 
     RGBColor[0.8444477183239901, 0.8184142771265308, 0.463211919537432], 
     RGBColor[0.8092936112180508, 0.7823854586507719, 0.47933419880643124`], 
     RGBColor[
     0.06015576152026314, 0.013959610562945151`, 0.014242272003214602`], 
     RGBColor[
     0.13761038516326093`, 0.031933556117462396`, 0.03258016333650956], 
     RGBColor[0.7793394324402139, 0.7516859541369799, 0.49307170134274864`], 
     RGBColor[0.7970912514205948, 0.7698794773498229, 0.48493041127180647`], 
     RGBColor[0.8227295544553537, 0.7961557176560305, 0.4731722437193222], 
     RGBColor[0.8371045809400697, 0.8108884263617668, 0.4665796088733444], 
     RGBColor[0.7931659706001234, 0.7658565269241172, 0.48673061269368223`], 
     RGBColor[0.7025974167228803, 0.673034428572375, 0.5282669121137752], 
     RGBColor[0.6890122296321117, 0.6591112121988939, 0.534497313003746], 
     RGBColor[0.5352057630791704, 0.4140771182241487, 0.5286476227994658], 
     RGBColor[0.5168882500869196, 0.35527838117952654`, 0.4936400466982234], 
     RGBColor[0.529346499803281, 0.3952690365386064, 0.5174496722308111], 
     RGBColor[0.25189258524459, 0.058453626133940416`, 0.05963722549564824], 
     RGBColor[0.24482845724707178`, 0.05681434049745263, 0.05796474675273866],
      
     RGBColor[0.23888361157923843`, 0.0554347929980529, 0.05655726545953128], 
     
     RGBColor[
     0.18901296244257873`, 0.04386192245539435, 0.044750061427346666`], 
     RGBColor[
     0.09212545220591445, 0.021378424995859922`, 0.02181130644142564], 
     RGBColor[
     0.09594359753196192, 0.022264455202732097`, 0.02271527744781135], 
     RGBColor[
     0.026308292933593172`, 0.00610504321859736, 0.006228661302446822], 
     RGBColor[
     0.043871935408972294`, 0.010180822542586244`, 0.010386969121678776`], 
     RGBColor[
     0.16587670208847305`, 0.038492973974583726`, 0.03927239969099962], 
     RGBColor[0.7605179744613244, 0.7323961769588259, 0.5017035462896545], 
     RGBColor[0.7909939228167038, 0.7636304338228568, 0.4877267512343191], 
     RGBColor[0.7043517381533062, 0.6748324013718113, 0.5274623500765805], 
     RGBColor[0.6791595806753289, 0.6490134077034035, 0.5390159075890663], 
     RGBColor[0.5680540515412307, 0.48057618332155866`, 0.5454888921551251], 
     RGBColor[0.5165865634303871, 0.3543099749119929, 0.49306347723752436`], 
     RGBColor[0.5287922300894313, 0.3934898452711985, 0.5163903778169671], 
     RGBColor[
     0.44426298016900595`, 0.15513960359620416`, 0.23926473845587182`], 
     RGBColor[0.4598625139447203, 0.1766872191915043, 0.28062851637038005`], 
     RGBColor[0.4296949441699398, 0.13501679453026488`, 0.20063608362683746`],
      
     RGBColor[0.26276251484740365`, 0.06097607752125757, 0.062210752787908], 
     RGBColor[0.2031950989363511, 0.04715299711558143, 0.04810777547545134], 
     RGBColor[
     0.08523562424857098, 0.019779587034215812`, 0.02018009437887392], 
     RGBColor[
     0.005040518830330079, 0.0011696914498023282`, 0.0011933759693941296`], 
     RGBColor[
     0.03234018149122842, 0.0075047896950061034`, 0.007656750572033766], 
     RGBColor[
     0.17907947836975927`, 0.04155678050913092, 0.042398243770495295`], 
     RGBColor[0.7565570578641345, 0.7283367040600343, 0.5035200908927834], 
     RGBColor[0.78971075920139, 0.7623153422794556, 0.4883152321788518], 
     RGBColor[0.8396065649890008, 0.8134526652672389, 0.4654321558761203], 
     RGBColor[0.6824996249159345, 0.6524365595781798, 0.5374841057470915], 
     RGBColor[0.5165230744229814, 0.3541061768607368, 0.49294214000908665`], 
     RGBColor[0.5289801273111436, 0.3940929904326376, 0.5167494782194665], 
     RGBColor[0.4444982773201683, 0.15546461924326205`, 0.2398886531987436], 
     RGBColor[0.4597830088704218, 0.17657739893639338`, 0.2804177004393629], 
     RGBColor[0.3970337390155673, 0.11650860785835257`, 0.16496413206942023`],
      
     RGBColor[0.2542921013575954, 0.05901045244002556, 0.060205326709793915`],
      
     RGBColor[0.2665366808277323, 0.061851901980192504`, 0.06310431139507504],
      
     RGBColor[0.23807017653160426`, 0.05524602909254738, 0.05636467936449113],
      
     RGBColor[
     0.20617968492776562`, 0.047845593420221905`, 0.04881439582955311], 
     RGBColor[
     0.0005647827037567771, 0.0001310622024870568, 0.0001337160179894903], 
     RGBColor[
     0.02991336017171457, 0.006941627004182971, 0.007082184670743099], 
     RGBColor[
     0.17460374224318623`, 0.04051815126181572, 0.041338583819090724`], 
     RGBColor[0.7682411907581725, 0.7403115638343796, 0.4981615462150278], 
     RGBColor[0.7934959068656353, 0.7661946727283293, 0.4865792982370948], 
     RGBColor[0.8301302715031914, 0.803740580793173, 0.4697781473573661], 
     RGBColor[0.8335092363851098, 0.8072036217402729, 0.4682284958386329], 
     RGBColor[0.8025245665971344, 0.7754479853374445, 0.48243859930887756`], 
     RGBColor[0.7036318681051636, 0.6740946193763107, 0.5277924948849401], 
     RGBColor[0.6983708256291223, 0.6687026706122209, 0.5302052996189415], 
     RGBColor[0.45692598326877676`, 0.17263099321072875`, 0.2728420014356857],
      
     RGBColor[0.44380418464835586`, 0.15450586994377902`, 0.2380481946605768],
      
     RGBColor[0.4594052171703695, 0.1760555557553814, 0.279415946655975], 
     RGBColor[0.2530614892871935, 0.05872487937399293, 0.05991397121209651], 
     RGBColor[0.2554034353285454, 0.05926834609888329, 0.060468442333313215`],
      
     RGBColor[0.2400525156218418, 0.05570604623810538, 0.05683401117597951], 
     RGBColor[0.1973755865576777, 0.04580253417704552, 0.0467299676623922], 
     RGBColor[
     0.08806280329189055, 0.020435655836921716`, 0.020849447603222715`], 
     RGBColor[
     0.10430622164706048`, 0.02420506692438318, 0.024695183682856787`], 
     RGBColor[0.7932561873272881, 0.7659489884415351, 0.486689237748055], 
     RGBColor[0.04203387591025488, 0.009754286594155528, 0.00995179645197518],
      
     RGBColor[0.05239861771335582, 0.012159505238225553`, 0.0124057172115541],
      
     RGBColor[0.826647520712168, 0.8001711715156753, 0.47137539688237884`], 
     RGBColor[0.8618016278181067, 0.8361999899914336, 0.45525311761337994`], 
     RGBColor[0.119488499553253, 0.02772823214867285, 0.028289687785270207`], 
     
     RGBColor[
     0.09439585048937463, 0.02190528850916126, 0.022348838160607346`], 
     RGBColor[
     0.04203387591025548, 0.009754286594155668, 0.009951796451975322], 
     RGBColor[0.891755806595944, 0.866899494505226, 0.4415156150770624], 
     RGBColor[0.8335092363851098, 0.8072036217402729, 0.4682284958386329], 
     RGBColor[0.7477661683167486, 0.7193270778792658, 0.507551744317482], 
     RGBColor[0.6983708256291226, 0.6687026706122211, 0.5302052996189414], 
     RGBColor[0.6921192457685678, 0.6622955377186485, 0.5330723818657064], 
     RGBColor[0.8025245665971341, 0.7754479853374442, 0.4824385993088777], 
     RGBColor[0.2400525156218418, 0.05570604623810538, 0.05683401117597951], 
     RGBColor[
     0.1377123277957517, 0.031957212695209375`, 0.032604298924921456`], 
     RGBColor[0.2530614892871935, 0.05872487937399293, 0.05991397121209651], 
     RGBColor[
     0.10430622164706048`, 0.02420506692438318, 0.024695183682856787`], 
     RGBColor[
     0.13327685920052967`, 0.030927927840547254`, 0.03155417257628251], 
     RGBColor[
     0.19737558655767728`, 0.045802534177045426`, 0.046729967662392104`], 
     RGBColor[
     0.15333596813992306`, 0.035582799493020664`, 0.03630329848603801], 
     RGBColor[
     0.013767558985043294`, 0.0031948687370343194`, 0.0032595600974852403`], 
     RGBColor[0.9105772645748337, 0.8861892716833804, 0.43288377013015644`], 
     RGBColor[0.8396065649890008, 0.8134526652672389, 0.4654321558761203], 
     RGBColor[0.7352153256769705, 0.706463942717742, 0.5133077770191511], 
     RGBColor[0.6824996249159349, 0.6524365595781803, 0.5374841057470914], 
     RGBColor[0.5857548094897372, 0.5088080598929718, 0.5455967218289411], 
     RGBColor[0.5289801273111436, 0.39409299043263774`, 0.5167494782194665], 
     RGBColor[0.3970337390155674, 0.11650860785835258`, 0.1649641320694203], 
     RGBColor[
     0.37052383839809994`, 0.10464430127062456`, 0.14205601797187217`], 
     RGBColor[0.14016668715787303`, 0.03252676580219134, 0.03318538463883422],
      
     RGBColor[
     0.17460374224318592`, 0.04051815126181564, 0.041338583819090655`], 
     RGBColor[0.1242802856320032, 0.028840203236226332`, 0.02942417464056152],
      
     RGBColor[
     0.0005647827037569806, 0.00013106220248710403`, 0.00013371601798953847`],
      
     RGBColor[0.8264733594123768, 0.7999926767003536, 0.47145527025548495`], 
     RGBColor[0.6840023208337335, 0.6539766458697613, 0.5367949435058168], 
     RGBColor[0.6405361487781063, 0.596181720032561, 0.5459304393998984], 
     RGBColor[0.6354586810724325, 0.5880833978037091, 0.5458995084257497], 
     RGBColor[0.5859984086727857, 0.509196589134981, 0.5455982057891493], 
     RGBColor[0.5412316469849872, 0.43342004776864695`, 0.540164010941206], 
     RGBColor[0.5898942026472349, 0.5154101973292892, 0.5456219382301409], 
     RGBColor[0.4861421357075371, 0.23479366825106207`, 0.37315416017293573`],
      
     RGBColor[0.49419300220522205`, 0.27261502364841406`, 0.4224711710882347],
      
     RGBColor[0.4865081867680035, 0.23651330268487833`, 0.3753964708794626], 
     RGBColor[0.4861905395623573, 0.23502105984875932`, 0.3734506665722402], 
     RGBColor[
     0.45962798543823435`, 0.17636326527233231`, 0.28000663976840057`], 
     RGBColor[0.43580754520719517`, 0.14346012234582195`, 0.2168442777575268],
      
     RGBColor[0.4571487515366417, 0.17293870272767964`, 0.27343269454811125`],
      
     RGBColor[0.3990622633368203, 0.11741645865776863`, 0.16671704948964985`],
      
     RGBColor[
     0.37081169821897375`, 0.10477313076789113`, 0.14230476751325416`], 
     RGBColor[
     0.42780842626209975`, 0.13241094981232393`, 0.19563378619323588`], 
     RGBColor[0.3088752916857959, 0.07705395797070609, 0.08878339494653553], 
     RGBColor[0.3550737822192575, 0.09772974485834482, 0.1287050946747383], 
     RGBColor[0.3214129132100727, 0.08266507616354105, 0.09961758359682274], 
     RGBColor[0.3149842345907666, 0.07978796941033187, 0.09406234197473623], 
     RGBColor[
     0.12067138318961072`, 0.028002729461773474`, 0.028569743262441476`], 
     RGBColor[
     0.07831023356161576, 0.018172496465616205`, 0.01854046260629763], 
     RGBColor[
     0.06747277241333907, 0.015657579634748214`, 0.015974622434096752`], 
     RGBColor[
     0.1287944923895521, 0.029887759891539745`, 0.030492942766755127`], 
     RGBColor[0.7859861779417305, 0.7584980852602947, 0.49002338932382916`], 
     RGBColor[0.7992445060470238, 0.772086309679084, 0.48394289159679565`], 
     RGBColor[0.8170547862608337, 0.7903397487692023, 0.4757747901968411], 
     RGBColor[0.8182972593085184, 0.7916131372743107, 0.4752049706477736], 
     RGBColor[0.787561100240857, 0.7601121950841526, 0.4893011028195248], 
     RGBColor[0.8290008169129589, 0.8025830228928836, 0.4702961346943935], 
     RGBColor[0.7570463739650013, 0.7288381954198424, 0.5032956820973837], 
     RGBColor[0.8067950943042347, 0.779824773150349, 0.4804800617157484], 
     RGBColor[0.7019778829923381, 0.6723994794823569, 0.5285510409579602], 
     RGBColor[0.6375015801752829, 0.5913417258079283, 0.5459119533811885], 
     RGBColor[0.6084363204000424, 0.5449840032246485, 0.5457348933089552], 
     RGBColor[0.5896845565992844, 0.5150758217411566, 0.5456206611060181], 
     RGBColor[0.6678813143609824, 0.6374545133603808, 0.5441883148597751], 
     RGBColor[0.6336653373700083, 0.5852230989281328, 0.5458885837146704], 
     RGBColor[0.6446651964923321, 0.6027673569733417, 0.5459555927786119], 
     RGBColor[0.5623932867641981, 0.4715475296927194, 0.5454544078454003], 
     RGBColor[0.5867874106240433, 0.5104550101453869, 0.545603012239997], 
     RGBColor[0.5432338670389089, 0.43984712171180795`, 0.5439905604809141], 
     RGBColor[0.5889494131711008, 0.5139033025424229, 0.5456161827511194], 
     RGBColor[
     0.49412867019313156`, 0.27231280476385034`, 0.42207709393599485`], 
     RGBColor[0.4572821676240484, 0.17312299019466437`, 0.2737864611086418], 
     RGBColor[0.486443854755913, 0.2362110838003146, 0.37500239372722277`], 
     RGBColor[0.48626757385600483`, 0.23538295150336128`, 0.3739225538034791],
      
     RGBColor[0.43609074808573883`, 0.14385131011143593`, 0.2175952194934309],
      
     RGBColor[
     0.44275004860957484`, 0.15304979321255208`, 0.23525304388064128`], 
     RGBColor[0.42714220771348727`, 0.13149070300274882`, 0.1938672387769128],
      
     RGBColor[0.45912587459797694`, 0.17566970022560355`, 0.2786752409212627],
      
     RGBColor[0.4372935541358418, 0.1455127445347948, 0.22078458419150565`], 
     RGBColor[0.4577500035829414, 0.17376921139260673`, 0.2750269765613662], 
     RGBColor[
     0.40563252202000877`, 0.12035692850346347`, 0.17239463529944782`], 
     RGBColor[0.3717440575048947, 0.10519040115217893`, 0.1431104511410424], 
     RGBColor[0.4236361733230761, 0.1284143272029289, 0.18795220770133697`], 
     RGBColor[0.3469545819968218, 0.09409605787942586, 0.12168901537062193`], 
     
     RGBColor[0.3123275239677602, 0.07859897855740301, 0.09176658723184983], 
     RGBColor[
     0.32470656152868677`, 0.08413912369046554, 0.10246373804186405`], 
     RGBColor[0.2246123223293557, 0.052123029750032156`, 0.05317844391032828],
      
     RGBColor[
     0.2384950947194372, 0.055344634650408404`, 0.056465281538867915`], 
     RGBColor[
     0.18400458041140952`, 0.042699688598841413`, 0.04356429405642082], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.047944342209940066`, 0.011125856094796367`, 0.011351138203763905`], 
     RGBColor[0.1600479000127485, 0.03714035528986817, 0.03789239248109325], 
     RGBColor[0.7639292614061501, 0.735892344212725, 0.5001390713159215], 
     RGBColor[0.7920990304809504, 0.7647630389921852, 0.4872199298170775], 
     RGBColor[0.7101061338255831, 0.6807299790428746, 0.524823285065679], 
     RGBColor[0.6934164067731919, 0.663624974937139, 0.532477481477243], 
     RGBColor[0.7679070993631029, 0.7399691595118632, 0.4983147662856287], 
     RGBColor[0.818183486374695, 0.7914965334200919, 0.47525714887567816`], 
     RGBColor[0.7793129471133758, 0.7516588097970585, 0.4930838479700126], 
     RGBColor[0.818183486374695, 0.7914965334200919, 0.47525714887567816`], 
     RGBColor[0.7040337769305705, 0.6745065285757322, 0.5276081725722055], 
     RGBColor[0.6307223142936721, 0.5805291155134309, 0.5458706553740154], 
     RGBColor[0.6023779980116538, 0.5353212639003562, 0.5456979871533593], 
     RGBColor[0.5903802572817616, 0.5161854316152357, 0.5456248991831606], 
     RGBColor[0.6554699269956801, 0.6200003940469683, 0.5460214131558656], 
     RGBColor[0.6244938168495658, 0.5705949549775422, 0.5458327125441255], 
     RGBColor[0.6554699269956801, 0.6200003940469683, 0.5460214131558656], 
     RGBColor[0.5878406119356232, 0.5121348167118556, 0.5456094281434414], 
     RGBColor[0.5493991614085729, 0.4508225107833212, 0.545375250088275], 
     RGBColor[0.5878406119356232, 0.5121348167118556, 0.5456094281434414], 
     RGBColor[0.4568394325285401, 0.17251144078647537`, 0.2726125031924074], 
     RGBColor[0.4333091165295964, 0.14000904608218498`, 0.2102194356025439], 
     RGBColor[0.4440603336148007, 0.15485968817600584`, 0.2387274001492401], 
     RGBColor[0.42935302305429546`, 0.13454449934056564`, 0.1997294444095929],
      
     RGBColor[0.45845563063384637`, 0.1747438931148398, 0.2768980196991773], 
     RGBColor[0.4392771570283009, 0.14825269261497231`, 0.22604431250736007`],
      
     RGBColor[
     0.45845563063384637`, 0.17474389311483976`, 0.27689801969917727`], 
     RGBColor[
     0.24151827492980021`, 0.056046187042593724`, 0.057181039328023694`], 
     RGBColor[0.15097293088157177`, 0.03503443838780546, 0.03574383388054327],
      
     RGBColor[0.24873771065549755`, 0.05772151304076932, 0.05889028819657092],
      
     RGBColor[0.3361166464129862, 0.08924562134252134, 0.11232358362046327`], 
     
     RGBColor[0.3001998684518682, 0.07317133756745202, 0.08128666426636141], 
     RGBColor[0.3361166464129862, 0.08924562134252134, 0.11232358362046327`], 
     
     RGBColor[
     0.11479262060617619`, 0.026638517054137074`, 0.027177907573894964`], 
     RGBColor[
     0.12818245859649527`, 0.02974573270766713, 0.030348039742745726`], 
     RGBColor[0.16644222151152993`, 0.03862420713849267, 0.0394062901321266], 
     
     RGBColor[
     0.24503516217191743`, 0.056862307976865485`, 0.05801368550257169], 
     RGBColor[
     0.18278991854256935`, 0.04241781690066739, 0.043276714873799596`], 
     RGBColor[
     0.24503516217191743`, 0.056862307976865485`, 0.05801368550257169], 
     RGBColor[
     0.08648436811258742, 0.020069367723446467`, 0.020475742697907775`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.034430249201958564`, 0.00798980610165821, 0.008151587842630495], 
     RGBColor[0.7560572390361578, 0.7278244486422059, 0.503749316419811], 
     RGBColor[0.789548839777294, 0.7621493939445747, 0.48838949121682096`], 
     RGBColor[0.7382633868304679, 0.7095878463251193, 0.511909883652166], 
     RGBColor[0.6965287656464153, 0.6668147761326823, 0.5310501000680599], 
     RGBColor[0.7382633868304681, 0.7095878463251194, 0.511909883652166], 
     RGBColor[0.8067950943042347, 0.779824773150349, 0.4804800617157484], 
     RGBColor[0.802755002820401, 0.7756841553198961, 0.4823329172861767], 
     RGBColor[0.8290008169129589, 0.8025830228928836, 0.4702961346943935], 
     RGBColor[0.7047675169819501, 0.6752585256906037, 0.5272716667413635], 
     RGBColor[0.6283028223131825, 0.5766701395781959, 0.545855916285903], 
     RGBColor[0.6002158077848793, 0.5318726721629968, 0.5456848154989273], 
     RGBColor[0.5906285499806275, 0.5165814467942668, 0.5456264117353805], 
     RGBColor[0.6446651964923321, 0.6027673569733417, 0.5459555927786119], 
     RGBColor[0.6148381193371705, 0.5551945714926165, 0.5457738918588046], 
     RGBColor[0.6678813143609822, 0.6374545133603807, 0.5441883148597753], 
     RGBColor[0.5321171683744274, 0.40416281009954524`, 0.5227448447193885], 
     RGBColor[0.5889494131711008, 0.5139033025424229, 0.5456161827511194], 
     RGBColor[0.5572127918998807, 0.4632848839905568, 0.5454228492492629], 
     RGBColor[0.5867874106240433, 0.5104550101453869, 0.545603012239997], 
     RGBColor[0.5337848023411884, 0.4095158714643574, 0.5259319489417303], 
     RGBColor[0.5173683816503085, 0.3568195909253293, 0.49455765173833205`], 
     RGBColor[0.5305331565381927, 0.39907817358400227`, 0.5197175552109431], 
     RGBColor[0.4566814222023823, 0.17229318132968086`, 0.27219352246302403`],
      
     RGBColor[0.4144028489520586, 0.12428202234285288`, 0.17997337551923626`],
      
     RGBColor[
     0.37298861972838576`, 0.10574739561247777`, 0.14418592003202893`], 
     RGBColor[0.41440284895205864`, 0.1242820223428529, 0.1799733755192363], 
     RGBColor[0.4577500035829414, 0.17376921139260673`, 0.2750269765613662], 
     RGBColor[
     0.44136547700442774`, 0.15113728626581732`, 0.23158170900580038`], 
     RGBColor[0.45912587459797694`, 0.17566970022560355`, 0.2786752409212627],
      
     RGBColor[
     0.35421065394698165`, 0.09734345829338993, 0.12795923593964043`], 
     RGBColor[0.3762831108518734, 0.10722182033038301`, 0.14703280277365963`],
      
     RGBColor[0.3074274560262479, 0.07640599001332325, 0.08753227050959328], 
     RGBColor[0.2803799730991581, 0.06506434521313269, 0.06638180184598111], 
     RGBColor[
     0.25219195227163055`, 0.058523096572137175`, 0.059708102607335514`], 
     RGBColor[0.254344743953182, 0.059022668562219674`, 0.06021779019037086], 
     
     RGBColor[0.3247065615286868, 0.08413912369046557, 0.1024637380418641], 
     RGBColor[0.2874319775732531, 0.06745716405739617, 0.07025349197149297], 
     RGBColor[0.3469545819968217, 0.09409605787942585, 0.1216890153706219], 
     RGBColor[0.13995328819657057`, 0.03247724491975158, 0.03313486103186352],
      
     RGBColor[
     0.11595914717470425`, 0.026909218582909098`, 0.027454090407726384`], 
     RGBColor[0.13995328819657057`, 0.03247724491975158, 0.03313486103186352],
      
     RGBColor[0.24873771065549755`, 0.05772151304076932, 0.05889028819657092],
      
     RGBColor[
     0.21628656808126473`, 0.050190973966697305`, 0.05120726685867896], 
     RGBColor[
     0.24151827492980021`, 0.056046187042593724`, 0.057181039328023694`], 
     RGBColor[
     0.09987901832478904, 0.023177700090350688`, 0.023647014191924717`], 
     RGBColor[0.16644222151152993`, 0.03862420713849267, 0.0394062901321266], 
     
     RGBColor[
     0.103090550585343, 0.023922961035182495`, 0.024407365567187436`], 
     RGBColor[
     0.11479262060617619`, 0.026638517054137074`, 0.027177907573894964`], 
     RGBColor[
     0.17739223272868293`, 0.041165242084910014`, 0.041998777273036816`], 
     RGBColor[0.7639292614061501, 0.735892344212725, 0.5001390713159215], 
     RGBColor[0.7920990304809504, 0.7647630389921852, 0.4872199298170775], 
     RGBColor[0.7679070993631026, 0.7399691595118629, 0.49831476628562876`], 
     RGBColor[0.6998054301605363, 0.6701729712542214, 0.5295473652607646], 
     RGBColor[0.7101061338255833, 0.6807299790428748, 0.5248232850656789], 
     RGBColor[0.7040337769305705, 0.6745065285757322, 0.5276081725722055], 
     RGBColor[0.6307223142936721, 0.5805291155134309, 0.5458706553740154], 
     RGBColor[0.6023779980116538, 0.5353212639003562, 0.5456979871533593], 
     RGBColor[0.5903802572817616, 0.5161854316152357, 0.5456248991831606], 
     RGBColor[0.6354586810724325, 0.5880833978037091, 0.5458995084257497], 
     RGBColor[0.6066106741445106, 0.5420721832958537, 0.5457237718168242], 
     RGBColor[0.6840023208337335, 0.6539766458697613, 0.5367949435058168], 
     RGBColor[0.5365380967953652, 0.41835387456478074`, 0.5311939168286645], 
     RGBColor[0.5672958318656074, 0.47936685859329076`, 0.545484273224086], 
     RGBColor[0.5359367878943523, 0.4164236887383422, 0.5300447233152509], 
     RGBColor[0.5898942026472349, 0.5154101973292892, 0.5456219382301409], 
     RGBColor[0.5638706451042095, 0.4739038467740717, 0.5454634076333403], 
     RGBColor[0.5859984086727857, 0.509196589134981, 0.5455982057891493], 
     RGBColor[0.5166412424969086, 0.3544854932837061, 0.49316797731803214`], 
     RGBColor[0.4568394325285401, 0.1725114407864754, 0.27261250319240743`], 
     RGBColor[0.4236361733230761, 0.1284143272029289, 0.18795220770133697`], 
     RGBColor[0.3742988840775303, 0.10633379456483665`, 0.14531816438259337`],
      
     RGBColor[0.4056325220200089, 0.1203569285034635, 0.17239463529944787`], 
     RGBColor[0.4571487515366417, 0.17293870272767967`, 0.2734326945481113], 
     RGBColor[0.4431448966813867, 0.1535951963375604, 0.23630002439859915`], 
     RGBColor[
     0.45962798543823435`, 0.17636326527233231`, 0.28000663976840057`], 
     RGBColor[
     0.35940710870048626`, 0.09966909252546294, 0.13244967066867874`], 
     RGBColor[
     0.37598970472905574`, 0.10709050862740624`, 0.14677926048259587`], 
     RGBColor[0.3099825043789776, 0.07754948268199365, 0.08974017539892803], 
     RGBColor[0.31498423459076663`, 0.0797879694103319, 0.09406234197473629], 
     
     RGBColor[0.2691464283395233, 0.0624575141112923, 0.06372218627494204], 
     RGBColor[0.3550737822192575, 0.09772974485834482, 0.1287050946747383], 
     RGBColor[
     0.12481821649568808`, 0.028965034261169805`, 0.0295515333088903], 
     RGBColor[0.25951206439726393`, 0.06022178530898434, 0.06144118727541311],
      
     RGBColor[
     0.20062466379125202`, 0.046556507723774725`, 0.047499208056837716`], 
     RGBColor[0.23942690596199157`, 0.05556086866915408, 0.05668589397625918],
      
     RGBColor[0.19164811798700418`, 0.04447343071733488, 0.04537395182597198],
      
     RGBColor[0.2516263870989754, 0.05839185279167949, 0.059574201334690394`],
      
     RGBColor[0.1370368488955543, 0.031800462582635934`, 0.03244437485470911],
      
     RGBColor[
     0.08648436811258742, 0.020069367723446467`, 0.020475742697907775`], 
     RGBColor[
     0.008895187274471823, 0.002064197129218704, 0.0021059940640912145`], 
     RGBColor[0.099830457822641, 0.02316643124956809, 0.02363551717380498], 
     RGBColor[0.1180735100332855, 0.02739987286686505, 0.02795467971429289], 
     RGBColor[
     0.14193578206694027`, 0.032937297983238516`, 0.03360422948856571], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.1600479000127485, 0.03714035528986817, 0.03789239248109325], 
     RGBColor[0.7859861779417305, 0.7584980852602947, 0.49002338932382916`], 
     RGBColor[0.7992445060470238, 0.772086309679084, 0.48394289159679565`], 
     RGBColor[0.7063108604459886, 0.6768402709286216, 0.5265638628349743], 
     RGBColor[0.8182972593085188, 0.7916131372743112, 0.47520497064777345`], 
     RGBColor[0.7875611002408575, 0.7601121950841531, 0.48930110281952466`], 
     RGBColor[0.7019778829923381, 0.6723994794823569, 0.5285510409579602], 
     RGBColor[0.6375015801752828, 0.5913417258079282, 0.5459119533811885], 
     RGBColor[0.6084363204000424, 0.5449840032246485, 0.5457348933089552], 
     RGBColor[0.5896845565992845, 0.5150758217411568, 0.5456206611060181], 
     RGBColor[0.6296738440253942, 0.5788568547385573, 0.545864268291193], 
     RGBColor[0.5346830865002221, 0.41239934009247936`, 0.52764870771085], 
     RGBColor[0.5623932867641981, 0.4715475296927194, 0.5454544078454003], 
     RGBColor[0.5348904560075574, 0.4130649907808692, 0.5280450226370188], 
     RGBColor[0.5169947898900222, 0.35562037115764566`, 0.49384366059856594`],
      
     RGBColor[0.49382695114475567`, 0.27089538921459777`, 0.4202288603817077],
      
     RGBColor[0.4572821676240484, 0.17312299019466437`, 0.2737864611086418], 
     RGBColor[0.4861421357075371, 0.23479366825106207`, 0.37315416017293573`],
      
     RGBColor[0.47461391865698105`, 0.1970633152210754, 0.319743392315898], 
     RGBColor[0.4865382352941558, 0.23665446463149598`, 0.3755805384568677], 
     RGBColor[0.42780842626209975`, 0.1324109498123239, 0.19563378619323582`],
      
     RGBColor[0.3754153366286427, 0.10683345450502972`, 0.14628292931304088`],
      
     RGBColor[0.3990622633368203, 0.11741645865776863`, 0.16671704948964985`],
      
     RGBColor[0.3088752916857959, 0.07705395797070609, 0.08878339494653553], 
     RGBColor[0.3588661399007839, 0.09942698600885705, 0.1319822009800663], 
     RGBColor[
     0.09947447168142196, 0.023083821907226885`, 0.023551235114622527`], 
     RGBColor[0.2384950947194374, 0.055344634650408446`, 0.05646528153886796],
      
     RGBColor[0.1840045804114096, 0.04269968859884143, 0.043564294056420844`],
      
     RGBColor[
     0.17641601651090327`, 0.040938703547602255`, 0.04176765166584317], 
     RGBColor[0.15902932642206422`, 0.03690398739598217, 0.03765123848740755],
      
     RGBColor[
     0.09455857577333729, 0.021943050172141758`, 0.02238736444133967], 
     RGBColor[0.03381894816586528, 0.007847948959716576, 0.00800685830364935],
      
     RGBColor[
     0.12067138318961053`, 0.028002729461773433`, 0.02856974326244143], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.047944342209940066`, 0.011125856094796367`, 0.011351138203763905`], 
     RGBColor[0.1287944923895522, 0.02988775989153977, 0.030492942766755154`],
      
     RGBColor[0.6003530918694783, 0.5320916338223165, 0.5456856518076383], 
     RGBColor[0.5005229023871786, 0.30235162460688014`, 0.46124609754566237`],
      
     RGBColor[0.4938167647058443, 0.27084753536850414`, 0.4201664615431324], 
     RGBColor[0.5047432974554544, 0.3162934012589981, 0.47042917993525907`], 
     RGBColor[0.48652804885524437`, 0.23660661078540224`, 0.3755181396182923],
      
     RGBColor[
     0.06747277241333907, 0.015657579634748214`, 0.015974622434096752`], 
     RGBColor[0.804127128393328, 0.7770904223897425, 0.4817036368549543], 
     RGBColor[0.7748517509013061, 0.7470866092281455, 0.49512982942498285`], 
     RGBColor[0.7589141562239082, 0.730752452202289, 0.5024390849691724], 
     RGBColor[0.6320475999696153, 0.5826428838466252, 0.5458787287640118], 
     RGBColor[0.6035623457008862, 0.5372102427721828, 0.5457052019757633], 
     RGBColor[0.6768500181940748, 0.6466463782366967, 0.5400751127396841], 
     RGBColor[0.5357322393951389, 0.4157670934121531, 0.5296537997681713], 
     RGBColor[0.5167103578412604, 0.3547073517292285, 0.4933000673391058], 
     RGBColor[0.5298729761192494, 0.39695901172661063`, 0.5184558491995166], 
     RGBColor[
     0.42892082848419066`, 0.13394750954632628`, 0.19858343578711074`], 
     RGBColor[0.37582899044070933`, 0.10701858215670818`, 0.1466403817554489],
      
     RGBColor[0.401977247497545, 0.11872103788951502`, 0.16923598725218625`], 
     
     RGBColor[0.3113820415588984, 0.07817583501816816, 0.09094956346356159], 
     RGBColor[0.2610645062573418, 0.0605820414713305, 0.06180873809152168], 
     RGBColor[0.3514715891873894, 0.09611761046618114, 0.12559231616356376`], 
     
     RGBColor[0.24960510906227468`, 0.05792279956188583, 0.05909565047164267],
      
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.08914769470989234, 0.020687413296484176`, 0.02110630277849849], 
     RGBColor[
     0.013767558985042888`, 0.003194868737034225, 0.003259560097485144], 
     RGBColor[
     0.15333596813992326`, 0.035582799493020706`, 0.03630329848603806], 
     RGBColor[0.8851090610944272, 0.8600873633819112, 0.4445639270959818], 
     RGBColor[0.8313559817586809, 0.8049967894110117, 0.4692160155136437], 
     RGBColor[0.7162616087454894, 0.6870386156938655, 0.5220002782007064], 
     RGBColor[0.7521984634635838, 0.7238696582609854, 0.5055190173890306], 
     RGBColor[0.7039756959883887, 0.6744470024521854, 0.5276348094930989], 
     RGBColor[0.8015996708927461, 0.7745000761972125, 0.4828627724160457], 
     RGBColor[0.8134493488071012, 0.7866446001154541, 0.4774283059394203], 
     RGBColor[0.8238053935014703, 0.7972583259397471, 0.47267884539469074`], 
     RGBColor[0.7814306624036627, 0.7538292184934634, 0.49211262724694477`], 
     RGBColor[0.7013002557182563, 0.6717049913538846, 0.5288618125022385], 
     RGBColor[0.7236296968661431, 0.694590038024475, 0.5186211460269949], 
     RGBColor[0.6397360414839158, 0.5949055865223926, 0.5459255652973993], 
     RGBColor[0.6104331571089845, 0.5481688638766115, 0.5457470576609912], 
     RGBColor[0.6608037081865483, 0.6285075242318777, 0.5460539055433493], 
     RGBColor[0.5663374282696978, 0.47783824992556967`, 0.5454784348104185], 
     RGBColor[0.586348460063697, 0.5097549046427468, 0.5456003382360994], 
     RGBColor[0.5355060869160442, 0.41504114987626456`, 0.5292215877028248], 
     RGBColor[0.5426519697540644, 0.43797924666495947`, 0.5428784655425393], 
     RGBColor[0.5301882831908625, 0.39797113916989035`, 0.5190584493619637], 
     RGBColor[0.5185836174525702, 0.36072046602855007`, 0.4968801536984304], 
     RGBColor[0.5345455826602272, 0.41195795636675736`, 0.5273859167880394], 
     RGBColor[0.517111319907354, 0.3559944294618376, 0.494066367330181], 
     RGBColor[0.5312939368572315, 0.40152025848640205`, 0.521171523057252], 
     RGBColor[0.4592718010829627, 0.17587126828839666`, 0.2790621800954445], 
     RGBColor[
     0.42565143889626256`, 0.12943150598591058`, 0.18991431100585615`], 
     RGBColor[0.4368616812459762, 0.14491619907704884`, 0.21963942853746224`],
      
     RGBColor[
     0.40372303375922314`, 0.11950235139740291`, 0.17074458102058776`], 
     RGBColor[0.4574280941090342, 0.17332455825745746`, 0.27417340028282355`],
      
     RGBColor[
     0.44231817571970916`, 0.15245324775480612`, 0.23410788822659784`], 
     RGBColor[0.45880396512406973`, 0.1752250470904543, 0.27782166464272007`],
      
     RGBColor[
     0.37147308961806613`, 0.10506913151291651`, 0.14287629849906114`], 
     RGBColor[0.3493142330028589, 0.09515210193555558, 0.12372807071287684`], 
     
     RGBColor[0.4264135179960699, 0.13048416484943545`, 0.1919350425925139], 
     RGBColor[0.3748966311547882, 0.10660131177242035`, 0.14583469812766062`],
      
     RGBColor[0.4098447961765582, 0.12224210011334632`, 0.17603460582897917`],
      
     RGBColor[0.31496797466222903`, 0.0797806924016381, 0.09404829121296493], 
     
     RGBColor[0.24075257315432938`, 0.05586850001274326, 0.05699975439896621],
      
     RGBColor[0.3195012417813342, 0.08180952199708712, 0.09796564276767797], 
     RGBColor[0.2792808380826588, 0.06480928241617587, 0.0661215744051238], 
     RGBColor[0.3417492622494692, 0.09176645618604747, 0.11719092009643589`], 
     
     RGBColor[
     0.11071856697040408`, 0.025693101341150507`, 0.026213348592843636`], 
     RGBColor[0.14404569032338663`, 0.03342691854225368, 0.03410376413879227],
      
     RGBColor[
     0.10931460367822989`, 0.025367300780936165`, 0.025880951053782675`], 
     RGBColor[0.1308437356331066, 0.03036330266426537, 0.03097811457636844], 
     RGBColor[0.14582531290765066`, 0.03383989375190138, 0.03452510148483541],
      
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.01959636106076743, 0.004547487421749779, 0.004639567307391505], 
     RGBColor[0.9071659776300077, 0.8826931044294808, 0.43444824510388946`], 
     RGBColor[0.8385014573247542, 0.8123200600979106, 0.46593897729336187`], 
     RGBColor[0.7431187003529666, 0.7145639707084761, 0.5096831532074879], 
     RGBColor[0.7374900976787812, 0.7087953160414903, 0.5122645273818904], 
     RGBColor[0.6853761937690138, 0.6553847037801729, 0.5361648617041098], 
     RGBColor[0.8124170014310096, 0.785586565670004, 0.4779017582347612], 
     RGBColor[0.7911827756587269, 0.7638239857382383, 0.48764014006679135`], 
     RGBColor[0.8124170014310096, 0.785586565670004, 0.4779017582347612], 
     RGBColor[0.7532734093987785, 0.7249713512112194, 0.5050260286604573], 
     RGBColor[0.6981878968450328, 0.6685151901583413, 0.5302891939114218], 
     RGBColor[0.7532734093987783, 0.7249713512112193, 0.5050260286604574], 
     RGBColor[0.5894552520868885, 0.5147100918266491, 0.5456192642262434], 
     RGBColor[0.5607773968530733, 0.4689702612697185, 0.5454445641492973], 
     RGBColor[0.587293249539831, 0.511261799429613, 0.5456060937151208], 
     RGBColor[0.6499989776832004, 0.6112744871582512, 0.5459880851660956], 
     RGBColor[0.6196046776294268, 0.562797007827202, 0.5458029288315362], 
     RGBColor[0.6499989776832004, 0.6112744871582512, 0.5459880851660956], 
     RGBColor[0.5377273668535378, 0.4221714003094119, 0.5334667942702701], 
     RGBColor[0.5408865167589703, 0.432312188780677, 0.5395044141576667], 
     RGBColor[0.5291419513040676, 0.39461244121241723`, 0.5170587486837314], 
     RGBColor[0.518937164845684, 0.36185534390248963`, 0.4975558369789642], 
     RGBColor[0.5329615708239926, 0.40687331985121433`, 0.5243586272795939], 
     RGBColor[0.517646545166595, 0.357712488528648, 0.495089264871027], 
     RGBColor[0.5329615708239926, 0.40687331985121433`, 0.5243586272795939], 
     RGBColor[0.459714536178471, 0.1764828176965856, 0.2802361380116788], 
     RGBColor[0.428433070452405, 0.13327377001516152`, 0.19729009489674315`], 
     
     RGBColor[0.43555139624075034`, 0.1431063041135951, 0.21616507226886345`],
      
     RGBColor[0.39792972305490804`, 0.11690959877468382`, 0.1657383825994005],
      
     RGBColor[
     0.45809833807316475`, 0.17425036536822125`, 0.27595062150490896`], 
     RGBColor[0.44033457282725014`, 0.14971329967462865`, 0.2288481599107435],
      
     RGBColor[
     0.37065098393062723`, 0.10470120429719307`, 0.14216588878610714`], 
     RGBColor[0.3564733193991783, 0.09835609719451932, 0.12991448273937184`], 
     
     RGBColor[
     0.41907812054757576`, 0.12637440497342237`, 0.18401343801107992`], 
     RGBColor[0.3736520689312972, 0.10604431731212152`, 0.14475922923667411`],
      
     RGBColor[0.4190781205475757, 0.12637440497342234`, 0.1840134380110799], 
     RGBColor[0.25042682593663174`, 0.0581134853294521, 0.05929019734360409], 
     
     RGBColor[
     0.23156785416125195`, 0.053737114804856594`, 0.054825211797116885`], 
     RGBColor[0.2432073902109344, 0.05643815933127651, 0.05758094847505687], 
     RGBColor[0.3303391773651696, 0.08665995853399158, 0.10733107451783654`], 
     
     RGBColor[0.2937348776034124, 0.07027797954926329, 0.07570004400198949], 
     RGBColor[
     0.33033917736516966`, 0.08665995853399161, 0.10733107451783658`], 
     RGBColor[0.17852656348346344`, 0.04142847232564055, 0.04226733753630858],
      
     RGBColor[
     0.09721985280994883, 0.022560620128740046`, 0.023017439274962435`], 
     RGBColor[
     0.12687696257810946`, 0.02944278224128491, 0.030038954978076904`], 
     RGBColor[0.1389179432938566, 0.032236985112960685`, 0.03288973631980036],
      
     RGBColor[0.15336589589306926`, 0.03558974446002609, 0.03631038407834008],
      
     RGBColor[
     0.10944316423173964`, 0.02539713425349803, 0.025911388609981725`], 
     RGBColor[
     0.15336589589306918`, 0.03558974446002607, 0.036310384078340065`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.12219021792127296`, 0.028355186829574202`, 0.02892933736996477], 
     RGBColor[0.915038, 0.890761, 0.430838], 
     RGBColor[0.8410516480284106, 0.814933705145521, 0.4647694158936184], 
     RGBColor[0.774638078064027, 0.7468676197415307, 0.49522782347001526`], 
     RGBColor[0.7322407427067379, 0.7034153455921592, 0.5146719720251678], 
     RGBColor[0.6787381082820666, 0.6485814481516041, 0.5392092020911247], 
     RGBColor[0.6669086068540414, 0.6364576027549721, 0.5446344152834525], 
     RGBColor[0.6899491455094979, 0.6600714406004198, 0.5340676272381182], 
     RGBColor[0.6918543132987971, 0.6620240131473392, 0.5331938844614684], 
     RGBColor[0.7236296968661435, 0.6945900380244755, 0.5186211460269948], 
     RGBColor[0.6949112323309115, 0.6651569950368019, 0.5317919287187172], 
     RGBColor[0.7814306624036625, 0.7538292184934632, 0.4921126272469449], 
     RGBColor[0.5884020507753087, 0.5130302852601804, 0.545612848322799], 
     RGBColor[0.5533555744214792, 0.45713280349343227`, 0.5453993518089982], 
     RGBColor[0.5884020507753087, 0.5130302852601804, 0.545612848322799], 
     RGBColor[0.6608037081865483, 0.6285075242318777, 0.5460539055433493], 
     RGBColor[0.6292603751418223, 0.5781973913121278, 0.5458617495168571], 
     RGBColor[0.639736041483916, 0.5949055865223929, 0.5459255652973993], 
     RGBColor[0.5403342523039477, 0.4305394343415946, 0.538448952100924], 
     RGBColor[0.5402564338800632, 0.43028963923867036`, 0.5383002291603496], 
     RGBColor[0.5287685197772266, 0.39341373578989713`, 0.5163450637746492], 
     RGBColor[0.5190633444493903, 0.36226037712626086`, 0.49779698554979057`],
      
     RGBColor[0.5312939368572315, 0.40152025848640205`, 0.521171523057252], 
     RGBColor[0.5182100256922839, 0.35952124626086646`, 0.4961661625586643], 
     RGBColor[0.5345455826602272, 0.41195795636675714`, 0.5273859167880393], 
     RGBColor[0.49408742614399526`, 0.2721190484966388, 0.421824446196521], 
     RGBColor[0.4864026107067767, 0.23601732753310312`, 0.374749745987749], 
     RGBColor[
     0.48622632980686853`, 0.23518919523614973`, 0.37366990606400524`], 
     RGBColor[0.39586211440312224`, 0.1159842560771687, 0.16395169106903026`],
      
     RGBColor[0.3703575778078096, 0.10456989259421627`, 0.1419123464950434], 
     RGBColor[0.3590283677519081, 0.09949958986318976, 0.13212238762870665`], 
     
     RGBColor[0.4098447961765582, 0.12224210011334632`, 0.17603460582897917`],
      
     RGBColor[
     0.37234180458215266`, 0.10545791835976263`, 0.14362698488610962`], 
     RGBColor[0.4264135179960699, 0.1304841648494354, 0.1919350425925138], 
     RGBColor[
     0.24690993869451452`, 0.057297364395180336`, 0.0584575511690561], 
     RGBColor[
     0.19975086650025478`, 0.04635373629199476, 0.047292330803860666`], 
     RGBColor[
     0.24690993869451452`, 0.057297364395180336`, 0.0584575511690561], 
     RGBColor[0.3417492622494691, 0.09176645618604741, 0.11719092009643581`], 
     
     RGBColor[0.30650276848202757`, 0.07599215305931918, 0.086733216296858], 
     RGBColor[0.3195012417813344, 0.0818095219970872, 0.09796564276767813], 
     RGBColor[0.17668250896710044`, 0.04100054518691426, 0.04183074550676622],
      
     RGBColor[
     0.1155278510119274, 0.026809132966544167`, 0.027351978205852896`], 
     RGBColor[
     0.08676288121609764, 0.020133998847106507`, 0.020541682506105795`], 
     RGBColor[0.07976524274872678, 0.01851014262126724, 0.01888494559656002], 
     
     RGBColor[
     0.12687696257810946`, 0.02944278224128491, 0.030038954978076904`], 
     RGBColor[
     0.12231176082110098`, 0.028383391801224653`, 0.028958113450520698`], 
     RGBColor[
     0.17852656348346302`, 0.04142847232564045, 0.042267337536308486`], 
     RGBColor[
     0.0022520283448331855`, 0.0005226006267079786, 0.0005331825154479916], 
     RGBColor[0.8238053935014701, 0.7972583259397469, 0.47267884539469085`], 
     RGBColor[0.7677407199517015, 0.7397986402154004, 0.49839107075062733`], 
     RGBColor[0.8015996708927461, 0.7745000761972125, 0.4828627724160457], 
     RGBColor[0.8045769425631949, 0.7775514289237762, 0.48149734432578006`], 
     RGBColor[0.7374900976787812, 0.7087953160414903, 0.5122645273818904], 
     RGBColor[0.6853761937690138, 0.6553847037801729, 0.5361648617041098], 
     RGBColor[0.6597547180646911, 0.6268344343149908, 0.5460475152936772], 
     RGBColor[0.6906828855608775, 0.6608234377152913, 0.5337311214072762], 
     RGBColor[0.6867811595516178, 0.6568246281962176, 0.5355205201868508], 
     RGBColor[0.6768500181940748, 0.6466463782366967, 0.5400751127396841], 
     RGBColor[0.6374878203344821, 0.5913197795088907, 0.5459118695588375], 
     RGBColor[0.6320475999696156, 0.5826428838466255, 0.5458787287640118], 
     RGBColor[0.587293249539831, 0.511261799429613, 0.5456060937151208], 
     RGBColor[0.5455419439301713, 0.4446704302861965, 0.5453517526480104], 
     RGBColor[0.5894552520868885, 0.5147100918266491, 0.5456192642262434], 
     RGBColor[0.5428104176324683, 0.43848786020553643`, 0.5431812837342694], 
     RGBColor[0.5408865167589703, 0.432312188780677, 0.5395044141576667], 
     RGBColor[0.5291419513040676, 0.39461244121241723`, 0.5170587486837314], 
     RGBColor[0.586348460063697, 0.5097549046427468, 0.5456003382360994], 
     RGBColor[0.5421199590020469, 0.43627150608216186`, 0.541861711417904], 
     RGBColor[0.5902442540381462, 0.5159685128370549, 0.545624070677091], 
     RGBColor[0.518937164845684, 0.36185534390248963`, 0.4975558369789642], 
     RGBColor[0.5298729761192494, 0.39695901172661074`, 0.5184558491995166], 
     RGBColor[0.5186901572556728, 0.36106245600666925`, 0.49708376759877293`],
      
     RGBColor[0.5357322393951389, 0.415767093412153, 0.5296537997681713], 
     RGBColor[0.4941644604376427, 0.27248094015124075`, 0.42229633342775985`],
      
     RGBColor[
     0.48647964500042423`, 0.23637921918770508`, 0.37522163321898794`], 
     RGBColor[
     0.48616199779477803`, 0.23488697635158606`, 0.37327582891176553`], 
     RGBColor[0.39792972305490804`, 0.11690959877468382`, 0.1657383825994005],
      
     RGBColor[
     0.37065098393062723`, 0.10470120429719307`, 0.14216588878610714`], 
     RGBColor[0.3564733193991783, 0.09835609719451932, 0.12991448273937184`], 
     
     RGBColor[0.401977247497545, 0.11872103788951502`, 0.16923598725218625`], 
     
     RGBColor[
     0.37122535203104035`, 0.10495825841956957`, 0.14266221995566217`], 
     RGBColor[0.4289208284841906, 0.13394750954632623`, 0.19858343578711063`],
      
     RGBColor[0.2432073902109344, 0.05643815933127651, 0.05758094847505687], 
     RGBColor[
     0.16625421696155918`, 0.03858057922596479, 0.039361778818981244`], 
     RGBColor[0.25042682593663174`, 0.0581134853294521, 0.05929019734360409], 
     
     RGBColor[0.3514715891873894, 0.09611761046618114, 0.12559231616356376`], 
     
     RGBColor[0.3173820573469506, 0.08086109694607423, 0.0961343828351296], 
     RGBColor[0.3113820415588986, 0.07817583501816823, 0.09094956346356173], 
     RGBColor[0.21051267280407152`, 0.04885109683001281, 0.04984025919428156],
      
     RGBColor[
     0.12302872064555977`, 0.028549767883677715`, 0.029127858402247048`], 
     RGBColor[
     0.0926945202983874, 0.021510481656002854`, 0.021946037053365786`], 
     RGBColor[0.1389179432938566, 0.032236985112960685`, 0.03288973631980036],
      
     RGBColor[0.1707490737990442, 0.03962364558239927, 0.04042596572439357], 
     RGBColor[0.19348872626699853`, 0.04490055813020951, 0.04580972793639855],
      
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.12219021792127296`, 0.028355186829574202`, 0.02892933736996477], 
     RGBColor[
     0.01959636106076743, 0.004547487421749779, 0.004639567307391505], 
     RGBColor[0.8270055345603343, 0.800538093534446, 0.47121120556257334`], 
     RGBColor[0.7521984634635835, 0.7238696582609851, 0.5055190173890307], 
     RGBColor[0.7039756959883885, 0.6744470024521851, 0.527634809493099], 
     RGBColor[0.6426574667840064, 0.5995651224995917, 0.5459433620684814], 
     RGBColor[0.545952687990394, 0.44532554774751537`, 0.5453542548232372], 
     RGBColor[0.5426519697540643, 0.43797924666495924`, 0.5428784655425392], 
     RGBColor[0.5301882831908625, 0.39797113916989024`, 0.5190584493619635], 
     RGBColor[0.5892091727473363, 0.5143176068516426, 0.5456177651573904], 
     RGBColor[0.5809422288581667, 0.5011322200913245, 0.545567404496812], 
     RGBColor[0.5185836174525702, 0.36072046602855007`, 0.4968801536984304], 
     RGBColor[0.5341754800196229, 0.4107699365818867, 0.5266785938910004], 
     RGBColor[0.5047432974554544, 0.3162934012589981, 0.47042917993525907`], 
     RGBColor[0.4942128642924629, 0.272708331748938, 0.4225928398270643], 
     RGBColor[0.48652804885524437`, 0.23660661078540224`, 0.3755181396182923],
      
     RGBColor[0.4037230337592229, 0.11950235139740281`, 0.1707445810205876], 
     RGBColor[
     0.37147308961806613`, 0.10506913151291651`, 0.14287629849906114`], 
     RGBColor[
     0.34931423300285913`, 0.09515210193555565, 0.12372807071287698`], 
     RGBColor[0.4256315208058399, 0.12940399315366882`, 0.18986149612814435`],
      
     RGBColor[0.3149679746622292, 0.07978069240163818, 0.0940482912129651], 
     RGBColor[0.24075257315432927`, 0.05586850001274323, 0.05699975439896618],
      
     RGBColor[0.35758053209236, 0.09885162190580686, 0.13087126319176434`], 
     RGBColor[0.23585641761833773`, 0.05473230918395575, 0.05584055738854936],
      
     RGBColor[
     0.14404569032338602`, 0.033426918542253534`, 0.034103764138792125`], 
     RGBColor[0.1093146036782295, 0.02536730078093607, 0.025880951053782582`],
      
     RGBColor[
     0.1308437356331068, 0.030363302664265412`, 0.030978114576368485`], 
     RGBColor[0.14582531290765133`, 0.03383989375190154, 0.03452510148483558],
      
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.0508497686839642, 0.011800082820078299`, 0.012039017021729726`], 
     RGBColor[
     0.10980943491374388`, 0.025482130203215683`, 0.02599810560180553], 
     RGBColor[
     0.07686784450741728, 0.017837778909591533`, 0.018198967515466898`], 
     RGBColor[
     0.08914769470989285, 0.020687413296484294`, 0.02110630277849861], 
     RGBColor[0.6609913055266754, 0.6288067331678453, 0.546055048350909], 
     RGBColor[0.5870334899635955, 0.5108474951203933, 0.54560451130885], 
     RGBColor[0.48642379044679174`, 0.23611682570197262`, 0.3748794862423918],
      
     RGBColor[0.4818522783112353, 0.2146407789644062, 0.3468758776924934], 
     RGBColor[0.38180385044445564`, 0.1096925858025948, 0.15180346315125437`],
      
     RGBColor[
     0.34442231014978025`, 0.09296275866452888, 0.11950079244081536`], 
     RGBColor[0.34196761752003757`, 0.09186417944470661, 0.1173796083727203], 
     
     RGBColor[0.8354335023659707, 0.8091757676836925, 0.46734599430224677`], 
     RGBColor[0.680678005315735, 0.6505696140827448, 0.5383195318845779], 
     RGBColor[0.6184737007330311, 0.5609931528602536, 0.5457960391339206], 
     RGBColor[0.6523803591149813, 0.6150726785603977, 0.5460025920919441], 
     RGBColor[0.5861611089008844, 0.5094560883480195, 0.5455991969282055], 
     RGBColor[0.5791500275665364, 0.49827374330724405`, 0.5455564867450833], 
     RGBColor[
     0.48649492085272344`, 0.23645098207670256`, 0.37531520816210723`], 
     RGBColor[0.4595244450754882, 0.1762202451047343, 0.27973209178309544`], 
     RGBColor[
     0.44985762872812507`, 0.16286748433135634`, 0.25409952799742846`], 
     RGBColor[0.4004171175101442, 0.11802281345049032`, 0.16788782543618777`],
      
     RGBColor[0.4053736659579157, 0.12024107942024431`, 0.17217094890051185`],
      
     RGBColor[0.38657736530506365`, 0.11182893646737296`, 0.1559284210170374],
      
     RGBColor[
     0.35339952054466545`, 0.09698044164132882, 0.12725830775447974`], 
     RGBColor[0.291724796724357, 0.06937838297365301, 0.07396306419255333], 
     RGBColor[0.3317921092912997, 0.08731020728714411, 0.10858660281347367`], 
     
     RGBColor[0.7901976946533564, 0.7628143937545917, 0.48809191519005957`], 
     RGBColor[0.8330056250933213, 0.8066874794938063, 0.4684594606549136], 
     RGBColor[0.8061606024602325, 0.7791744937561658, 0.4807710506085136], 
     RGBColor[0.8404060065627332, 0.8142719987025948, 0.4650655181950061], 
     RGBColor[0.690569923697565, 0.6607076651127982, 0.5337829276642686], 
     RGBColor[0.6287848685778714, 0.5774389807027397, 0.5458588528206908], 
     RGBColor[0.6408860148484221, 0.5967397399626916, 0.5459325707179103], 
     RGBColor[0.5672958318656075, 0.4793668585932909, 0.545484273224086], 
     RGBColor[0.5856769739358536, 0.508683915844649, 0.5455962476694498], 
     RGBColor[0.5743128723275913, 0.490558708162425, 0.545527019709088], 
     RGBColor[0.5686360058503254, 0.4815043730788763, 0.5454924373108471], 
     RGBColor[0.4598325424302565, 0.17664581957778763`, 0.2805490437985798], 
     RGBColor[
     0.44937434113905406`, 0.16219991981686468`, 0.25281804094848265`], 
     RGBColor[0.4488071567139633, 0.16141646871254237`, 0.2513140927578934], 
     RGBColor[0.26662528804908037`, 0.06187246397245765, 0.06312528973723207],
      
     RGBColor[0.257924488401783, 0.05985337599828965, 0.06106531822177645], 
     RGBColor[0.25351563615075984`, 0.0588302676725291, 0.06002149346760215], 
     
     RGBColor[0.3583814964567662, 0.09921008748145291, 0.13156340396259006`], 
     
     RGBColor[0.3039094473117283, 0.07483153167907143, 0.08449223855355942], 
     RGBColor[0.31820930560441574`, 0.08123132568032544, 0.0968492364191722], 
     
     RGBColor[
     0.19426448434469365`, 0.045080578802909915`, 0.045993393761117655`], 
     RGBColor[0.25951206439726404`, 0.06022178530898436, 0.06144118727541314],
      
     RGBColor[
     0.20062466379125202`, 0.046556507723774725`, 0.047499208056837716`], 
     RGBColor[
     0.23781026528441324`, 0.055185714673778134`, 0.056303143668065075`], 
     RGBColor[0.23338672476215958`, 0.05415919782087008, 0.05525584136911642],
      
     RGBColor[
     0.21198072835276996`, 0.04919177049495674, 0.050187830996416403`], 
     RGBColor[0.7586783169422961, 0.7305107447215372, 0.5025472449275322], 
     RGBColor[0.8382549800653645, 0.8120674499431371, 0.4660520160116363], 
     RGBColor[0.8127986879471796, 0.7859777493847344, 0.47772671022149893`], 
     RGBColor[0.8404060065627332, 0.8142719987025948, 0.4650655181950061], 
     RGBColor[0.690569923697565, 0.6607076651127982, 0.5337829276642686], 
     RGBColor[0.6408860148484221, 0.5967397399626916, 0.5459325707179103], 
     RGBColor[0.6287848685778714, 0.5774389807027397, 0.5458588528206908], 
     RGBColor[0.5390142621238859, 0.42630230042872286`, 0.5359262484620101], 
     RGBColor[0.5690455299544558, 0.48215754476759504`, 0.5454949320543319], 
     RGBColor[0.5856769739358536, 0.508683915844649, 0.5455962476694498], 
     RGBColor[0.5686360058503255, 0.4815043730788764, 0.5454924373108471], 
     RGBColor[0.5743128723275912, 0.49055870816242486`, 0.545527019709088], 
     RGBColor[
     0.43004460461026983`, 0.13549978003902696`, 0.20156324446428617`], 
     RGBColor[0.4445279689189269, 0.1555056322097814, 0.23996738354508837`], 
     RGBColor[0.4301420539141026, 0.13563438663491684`, 0.2018216413766309], 
     RGBColor[0.4598325424302565, 0.17664581957778763`, 0.2805490437985798], 
     RGBColor[0.4488071567139633, 0.16141646871254237`, 0.2513140927578934], 
     RGBColor[
     0.44937434113905406`, 0.16219991981686468`, 0.25281804094848265`], 
     RGBColor[0.3583814964567662, 0.09921008748145291, 0.13156340396259006`], 
     
     RGBColor[0.3182093056044157, 0.08123132568032543, 0.09684923641917215], 
     RGBColor[0.3039094473117283, 0.07483153167907143, 0.08449223855355942], 
     RGBColor[
     0.15864838033265985`, 0.03681558590426852, 0.037561046996405806`], 
     RGBColor[0.2670129340308963, 0.061962420226117886`, 0.06321706747180726],
      
     RGBColor[0.2065563028735418, 0.047932990532671076`, 0.04890356260409771],
      
     RGBColor[
     0.23781026528441324`, 0.055185714673778134`, 0.056303143668065075`], 
     RGBColor[
     0.21198072835277007`, 0.049191770494956766`, 0.05018783099641643], 
     RGBColor[0.23338672476215946`, 0.05415919782087005, 0.05525584136911639],
      
     RGBColor[0.08360271676196215, 0.01940065819976496, 0.01979349279670403], 
     
     RGBColor[0.0882646168100152, 0.0204824882275051, 0.020897228280358497`], 
     
     RGBColor[
     0.12616281115660477`, 0.029277057870497558`, 0.029869874934212337`], 
     RGBColor[0.13467915744393602`, 0.0312533420132938, 0.03188617590410168], 
     
     RGBColor[0.7287394524431278, 0.6998269355392913, 0.5162777240717675], 
     RGBColor[0.8330056250933213, 0.8066874794938063, 0.4684594606549136], 
     RGBColor[0.8061606024602325, 0.7791744937561658, 0.4807710506085136], 
     RGBColor[0.680678005315735, 0.6505696140827448, 0.5383195318845779], 
     RGBColor[0.6523803591149813, 0.6150726785603977, 0.5460025920919441], 
     RGBColor[0.6184737007330311, 0.5609931528602536, 0.5457960391339206], 
     RGBColor[0.5861611089008844, 0.5094560883480195, 0.5455991969282055], 
     RGBColor[0.5791500275665364, 0.49827374330724405`, 0.5455564867450833], 
     RGBColor[0.4269437889499929, 0.13121662742432813`, 0.1933411108948071], 
     RGBColor[0.4440603336148007, 0.15485968817600584`, 0.2387274001492401], 
     RGBColor[0.42935302305429546`, 0.13454449934056564`, 0.1997294444095929],
      
     RGBColor[0.4595244450754882, 0.1762202451047343, 0.27973209178309544`], 
     RGBColor[
     0.44985762872812507`, 0.16286748433135634`, 0.25409952799742846`], 
     RGBColor[0.3533995205446654, 0.0969804416413288, 0.12725830775447972`], 
     RGBColor[0.3317921092912997, 0.08731020728714411, 0.10858660281347367`], 
     
     RGBColor[0.2917247967243571, 0.06937838297365304, 0.07396306419255337], 
     RGBColor[0.6633349393279698, 0.632544718874402, 0.5460693253253229], 
     RGBColor[0.6609913055266754, 0.6288067331678453, 0.546055048350909], 
     RGBColor[0.4818522783112353, 0.21464077896440625`, 0.34687587769249345`],
      
     RGBColor[
     0.42315079931598376`, 0.12819710171751675`, 0.18753277937925836`], 
     RGBColor[
     0.44275004860957484`, 0.15304979321255208`, 0.23525304388064128`], 
     RGBColor[0.42714220771348727`, 0.13149070300274882`, 0.1938672387769128],
      
     RGBColor[0.3444223101497803, 0.09296275866452891, 0.1195007924408154], 
     RGBColor[0.34196761752003757`, 0.09186417944470661, 0.1173796083727203], 
     
     RGBColor[0.6146533378509479, 0.5548998537112145, 0.5457727662048951], 
     RGBColor[0.5341754800196229, 0.4107699365818867, 0.5266785938910004], 
     RGBColor[0.49850272168876475`, 0.2928612210355938, 0.4488711223075066], 
     RGBColor[0.4256315208058398, 0.1294039931536688, 0.1898614961281443], 
     RGBColor[0.28721029482354293`, 0.06735795161047967, 0.07006192830638917],
      
     RGBColor[
     0.0508497686839642, 0.011800082820078299`, 0.012039017021729726`], 
     RGBColor[0.7951669854397339, 0.7679073314064032, 0.4858129128081926], 
     RGBColor[0.7894283172516832, 0.7620258725539053, 0.48844476492382327`], 
     RGBColor[0.8105458422066504, 0.78366884789579, 0.47875990409751834`], 
     RGBColor[0.7981747889846725, 0.7709899757075305, 0.4844334822741827], 
     RGBColor[0.6923548245925397, 0.6625369782610021, 0.5329643413577085], 
     RGBColor[0.7454341203503547, 0.7169370034391793, 0.5086212616990385], 
     RGBColor[0.6336330348169007, 0.5851715778749141, 0.5458883869336187], 
     RGBColor[0.6571709426445923, 0.6227134340188065, 0.5460317754218834], 
     RGBColor[0.623264284262642, 0.5686339083186622, 0.5458252224638599], 
     RGBColor[0.5354875387056955, 0.41498161060674665`, 0.5291861392287006], 
     RGBColor[0.5245125044966639, 0.37975203818686726`, 0.5082111659641013], 
     RGBColor[
     0.42840379555710956`, 0.13323333264059078`, 0.19721246948274818`], 
     RGBColor[
     0.38392168489825884`, 0.11064040667995483`, 0.15363355651929494`], 
     RGBColor[0.3130563032334906, 0.0789251382351842, 0.09239635038382023], 
     RGBColor[
     0.33745311561922353`, 0.08984374808153331, 0.11347847248655621`], 
     RGBColor[0.29738580305228074`, 0.07191192376804215, 0.07885493386563575],
      
     RGBColor[0.7901944812429714, 0.7628111003875009, 0.4880933889154333], 
     RGBColor[0.795850251900194, 0.7686075990365924, 0.48549955503587083`], 
     RGBColor[0.8033870092967322, 0.7763318875050038, 0.4820430682258515], 
     RGBColor[0.8111180986340201, 0.7842553433195297, 0.4784974574392166], 
     RGBColor[0.7084964779952269, 0.6790802714412683, 0.5255615009659085], 
     RGBColor[0.7274402593218195, 0.6984954156405919, 0.5168735564239583], 
     RGBColor[0.6089223696139539, 0.5457592288649685, 0.5457378542289535], 
     RGBColor[0.6417204964673388, 0.598070698904388, 0.5459376542223023], 
     RGBColor[0.5858624054291702, 0.5089796703568003, 0.5455973772830798], 
     RGBColor[0.628915374286742, 0.5776471311715173, 0.5458596478368173], 
     RGBColor[0.6468597747997519, 0.6062676061763201, 0.5459689617351132], 
     RGBColor[0.634758628529201, 0.5869668469163679, 0.5458952438378937], 
     RGBColor[0.5362156763433074, 0.4173189133565438, 0.5305777219054352], 
     RGBColor[0.5248984352009919, 0.3809908656418186, 0.5089487387179618], 
     RGBColor[0.5253513619667711, 0.3824447486996764, 0.5098143512183058], 
     RGBColor[0.4299422919747072, 0.13535845572938138`, 0.2012919519246431], 
     RGBColor[
     0.38963772476011715`, 0.11319857731843987`, 0.15857298255604532`], 
     RGBColor[0.3963460467947798, 0.11620083637843825`, 0.1643698736417814], 
     RGBColor[
     0.32297899603723745`, 0.08336596475121896, 0.10097088946577278`], 
     RGBColor[0.23842946471567208`, 0.05532940469951672, 0.05644974320402563],
      
     RGBColor[0.30807432732138973`, 0.07669549239506007, 0.08809125417570984],
      
     RGBColor[0.3252684650318522, 0.08439059937611487, 0.10294929812555009`], 
     
     RGBColor[0.31096860673916465`, 0.07799080537486078, 0.09059230025993717],
      
     RGBColor[
     0.14106640495506623`, 0.03273555228827276, 0.033398398742054275`], 
     RGBColor[
     0.12302872064555977`, 0.028549767883677715`, 0.029127858402247048`], 
     RGBColor[
     0.0926945202983874, 0.021510481656002854`, 0.021946037053365786`], 
     RGBColor[0.2050545672796242, 0.04758450115227247, 0.048548016829845], 
     RGBColor[0.8111180986340201, 0.7842553433195297, 0.4784974574392166], 
     RGBColor[0.7274402593218195, 0.6984954156405919, 0.5168735564239583], 
     RGBColor[0.7084964779952269, 0.6790802714412683, 0.5255615009659085], 
     RGBColor[0.6042927614336351, 0.5383752215190124, 0.5457096515304345], 
     RGBColor[0.6438826866941134, 0.6015192906417475, 0.5459508258767343], 
     RGBColor[0.5856141127303044, 0.5085836551777692, 0.5455958647308597], 
     RGBColor[0.628915374286742, 0.5776471311715173, 0.5458596478368173], 
     RGBColor[0.6347586285292011, 0.5869668469163681, 0.5458952438378937], 
     RGBColor[0.6468597747997519, 0.6062676061763201, 0.5459689617351132], 
     RGBColor[0.5362156763433074, 0.4173189133565438, 0.5305777219054352], 
     RGBColor[0.5253513619667711, 0.3824447486996764, 0.5098143512183058], 
     RGBColor[0.5248984352009919, 0.3809908656418186, 0.5089487387179618], 
     RGBColor[0.4299422919747072, 0.13535845572938138`, 0.2012919519246431], 
     RGBColor[0.3963460467947797, 0.11620083637843823`, 0.16436987364178135`],
      
     RGBColor[
     0.38963772476011715`, 0.11319857731843987`, 0.15857298255604532`], 
     RGBColor[
     0.32583809646357415`, 0.08464553363805256, 0.10344153617727775`], 
     RGBColor[
     0.23760035691324996`, 0.055137003809826154`, 0.05625344648125693], 
     RGBColor[0.30807432732138973`, 0.07669549239506007, 0.08809125417570984],
      
     RGBColor[0.31096860673916465`, 0.07799080537486078, 0.09059230025993717],
      
     RGBColor[
     0.32526846503185214`, 0.08439059937611484, 0.10294929812555004`], 
     RGBColor[0.14179959464448183`, 0.03290569463664219, 0.03357198622100411],
      
     RGBColor[0.2050545672796242, 0.04758450115227247, 0.048548016829845], 
     RGBColor[0.7937637528444696, 0.7664691833032048, 0.4864564594558726], 
     RGBColor[0.9071659776300077, 0.8826931044294808, 0.43444824510388946`], 
     RGBColor[0.8385014573247542, 0.8123200600979106, 0.46593897729336187`], 
     RGBColor[0.6336330348169007, 0.5851715778749141, 0.5458883869336187], 
     RGBColor[0.6232642842626422, 0.5686339083186625, 0.5458252224638599], 
     RGBColor[0.6571709426445923, 0.6227134340188065, 0.5460317754218834], 
     RGBColor[0.5900815538100476, 0.5157090136240164, 0.5456230795380349], 
     RGBColor[0.5769026782297242, 0.49468932679387745`, 0.5455427963174393], 
     RGBColor[0.5609964518259474, 0.4693196436506611, 0.5454458985908134], 
     RGBColor[0.5354875387056955, 0.41498161060674665`, 0.5291861392287006], 
     RGBColor[0.5245125044966639, 0.37975203818686726`, 0.5082111659641013], 
     RGBColor[0.48617526371005804`, 0.23494929695976174`, 0.3733570916291208],
      
     RGBColor[
     0.42840379555710956`, 0.13323333264059078`, 0.19721246948274818`], 
     RGBColor[0.3839216848982589, 0.11064040667995485`, 0.153633556519295], 
     RGBColor[
     0.32297899603723745`, 0.08336596475121896, 0.10097088946577278`], 
     RGBColor[0.23842946471567208`, 0.05532940469951672, 0.05644974320402563],
      
     RGBColor[0.31305630323349054`, 0.07892513823518417, 0.09239635038382017],
      
     RGBColor[0.2973858030522811, 0.07191192376804227, 0.07885493386563601], 
     RGBColor[0.33745311561922353`, 0.0898437480815333, 0.11347847248655618`],
      
     RGBColor[0.6146533378509481, 0.5548998537112149, 0.5457727662048951], 
     RGBColor[0.49850272168876475`, 0.2928612210355938, 0.4488711223075066], 
     RGBColor[0.48624639411598974`, 0.2352834533344918, 0.3737928135488363], 
     RGBColor[0.3220335136283758, 0.08294282121198414, 0.10015386569748463`], 
     
     RGBColor[0.28721029482354304`, 0.06735795161047974, 0.0700619283063893], 
     
     RGBColor[0.8700372030254522, 0.8446404843921228, 0.4514761409138], 
     RGBColor[0.8352803970951324, 0.8090188528175548, 0.4674162110176528], 
     RGBColor[0.7622489345336227, 0.7341702071182516, 0.5009096981738431], 
     RGBColor[0.6315224215878624, 0.5818052490235993, 0.5458755294765143], 
     RGBColor[0.5438583331605987, 0.44185164161022716`, 0.5451840109939262], 
     RGBColor[0.4941086058840103, 0.2722185466655083, 0.42195418645116384`], 
     RGBColor[0.47966443242066026`, 0.2043627179624175, 0.33347383957678184`],
      
     RGBColor[
     0.43775702079159273`, 0.14615293042002347`, 0.22201351398485025`], 
     RGBColor[0.37203484811313, 0.10532054230128086`, 0.14336173327627455`], 
     RGBColor[
     0.13733950811455345`, 0.031870696999485436`, 0.03251603141448542], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.09944172030289798, 0.02307622169607437, 0.023543481010449785`], 
     RGBColor[0.897695701532207, 0.8729871870692492, 0.43879147690730724`], 
     RGBColor[0.7063108604459887, 0.6768402709286218, 0.5265638628349741], 
     RGBColor[0.7438052272076449, 0.7152675798586501, 0.5093683001621969], 
     RGBColor[0.6391193175756756, 0.5939219408894356, 0.5459218083318472], 
     RGBColor[0.5416445251267428, 0.43474537579209804`, 0.54095308438006], 
     RGBColor[0.5045179307432969, 0.31556998001440195`, 0.4699984695910176], 
     RGBColor[0.494179736289942, 0.27255270304023826`, 0.42238990837087925`], 
     
     RGBColor[0.4703258294635231, 0.1911401832283206, 0.30837308012413667`], 
     RGBColor[0.4753016853559826, 0.19801332646259118`, 0.32156707688259856`],
      
     RGBColor[0.4789010217130968, 0.20298508506360952`, 0.3311110896624592], 
     RGBColor[
     0.42315079931598376`, 0.12819710171751675`, 0.18753277937925836`], 
     RGBColor[
     0.43611397536400537`, 0.14388339392051697`, 0.21765680902511758`], 
     RGBColor[
     0.37100396018771464`, 0.10485917616561699`, 0.14247090767273987`], 
     RGBColor[0.31953941353148096`, 0.08182660547669976, 0.0979986282858164], 
     
     RGBColor[
     0.09947447168142196, 0.023083821907226885`, 0.023551235114622527`], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.11638785693439183`, 0.027008704004397054`, 0.027555590261665503`], 
     RGBColor[0.9130450101998571, 0.8887184202377834, 0.4317520194641082], 
     RGBColor[0.7287394524431278, 0.6998269355392913, 0.5162777240717675], 
     RGBColor[0.7335697418412542, 0.7047774131431181, 0.5140624701217242], 
     RGBColor[0.6433352767827346, 0.6006461975743784, 0.5459474911589578], 
     RGBColor[0.5404159543554741, 0.4308016957875529, 0.5386050972494301], 
     RGBColor[0.5037879825824882, 0.3132268655325533, 0.46860342672683175`], 
     RGBColor[0.4693704392580475, 0.18982050398744788`, 0.3058397641385966], 
     RGBColor[0.4763962597870624, 0.19952526069219428`, 0.324469454243938], 
     RGBColor[
     0.47768084806007066`, 0.20129966079305525`, 0.32787567296818076`], 
     RGBColor[0.42694378894999285`, 0.1312166274243281, 0.19334111089480704`],
      
     RGBColor[0.4352021539425768, 0.1426238961840467, 0.2152390201786085], 
     RGBColor[0.2886715634569056, 0.06801193139423721, 0.07132466063659579], 
     RGBColor[0.3251142471502141, 0.08432158032336676, 0.10281603316618922`], 
     
     RGBColor[
     0.12481821649568786`, 0.028965034261169757`, 0.029551533308890248`], 
     RGBColor[
     0.11742687466422509`, 0.02724981611917898, 0.027801584539694273`], 
     RGBColor[
     0.1370368488955544, 0.031800462582635955`, 0.032444374854709135`], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[0.9130450101998571, 0.8887184202377834, 0.4317520194641082], 
     RGBColor[0.7586783169422961, 0.7305107447215372, 0.5025472449275322], 
     RGBColor[0.7335697418412542, 0.7047774131431181, 0.5140624701217242], 
     RGBColor[0.6433352767827346, 0.6006461975743784, 0.5459474911589578], 
     RGBColor[0.5404159543554741, 0.4308016957875529, 0.5386050972494301], 
     RGBColor[0.5028136093770433, 0.3100991530579113, 0.46674125012266865`], 
     RGBColor[0.468095134151547, 0.18805892671233873`, 0.30245816069089293`], 
     
     RGBColor[
     0.47768084806007066`, 0.20129966079305525`, 0.32787567296818076`], 
     RGBColor[0.4763962597870624, 0.19952526069219428`, 0.324469454243938], 
     RGBColor[
     0.43004460461026983`, 0.13549978003902696`, 0.20156324446428617`], 
     RGBColor[0.4352021539425768, 0.1426238961840467, 0.2152390201786085], 
     RGBColor[
     0.35421065394698165`, 0.09734345829338993, 0.12795923593964043`], 
     RGBColor[0.2803799730991581, 0.06506434521313269, 0.06638180184598111], 
     RGBColor[0.3251142471502142, 0.08432158032336678, 0.10281603316618926`], 
     
     RGBColor[
     0.15864838033265977`, 0.0368155859042685, 0.037561046996405785`], 
     RGBColor[
     0.11742687466422509`, 0.02724981611917898, 0.027801584539694273`], 
     RGBColor[
     0.14107003602797485`, 0.03273639490687569, 0.033399258422436025`], 
     RGBColor[
     0.08376325156842938, 0.019437911545470265`, 0.019831500467489136`], 
     RGBColor[
     0.08376325156842929, 0.019437911545470244`, 0.019831500467489115`], 
     RGBColor[
     0.06222461663385679, 0.014439704422071127`, 0.014732087051987896`], 
     RGBColor[0.897695701532207, 0.8729871870692492, 0.43879147690730724`], 
     RGBColor[0.7901976946533564, 0.7628143937545917, 0.48809191519005957`], 
     RGBColor[0.6391193175756756, 0.5939219408894356, 0.5459218083318472], 
     RGBColor[0.5416211475742958, 0.43467033446090547`, 0.5409084062926639], 
     RGBColor[0.5416445251267428, 0.43474537579209804`, 0.54095308438006], 
     RGBColor[0.5017877976902038, 0.30680632440495503`, 0.46478076669308005`],
      
     RGBColor[0.4667525039609548, 0.18620435338665609`, 0.2988980378164882], 
     RGBColor[0.4789010217130968, 0.20298508506360952`, 0.3311110896624592], 
     RGBColor[0.4753016853559826, 0.19801332646259118`, 0.32156707688259856`],
      
     RGBColor[0.4333091165295964, 0.14000904608218498`, 0.2102194356025439], 
     RGBColor[
     0.43611397536400537`, 0.14388339392051697`, 0.21765680902511758`], 
     RGBColor[0.34873987130795747`, 0.0948950506799176, 0.12323174507854406`],
      
     RGBColor[0.31953941353148096`, 0.08182660547669976, 0.0979986282858164], 
     
     RGBColor[
     0.19426448434469357`, 0.0450805788029099, 0.045993393761117635`], 
     RGBColor[
     0.13205248900715544`, 0.030643803250442535`, 0.031264294884005436`], 
     RGBColor[0.1354512313581727, 0.03143250774731783, 0.032068969478902344`],
      
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.11638785693439173`, 0.027008704004397033`, 0.02755559026166548], 
     RGBColor[0.8700372030254522, 0.8446404843921228, 0.4514761409138], 
     RGBColor[0.8170547862608335, 0.7903397487692021, 0.4757747901968412], 
     RGBColor[0.6941436060346736, 0.6643702685128988, 0.5321439753653544], 
     RGBColor[0.5438424275117894, 0.4418005848940527, 0.5451536128601091], 
     RGBColor[0.5438583331605987, 0.44185164161022716`, 0.5451840109939262], 
     RGBColor[0.5009137221073028, 0.3040005646722958, 0.4631102742250475], 
     RGBColor[0.4656084730617963, 0.18462410500240053`, 0.29586452151269993`],
      
     RGBColor[0.47966443242066026`, 0.2043627179624175, 0.33347383957678184`],
      
     RGBColor[0.4786159294677924, 0.20259128751816088`, 0.3303551380750934], 
     RGBColor[0.43609074808573883`, 0.14385131011143593`, 0.2175952194934309],
      
     RGBColor[
     0.43775702079159273`, 0.14615293042002347`, 0.22201351398485025`], 
     RGBColor[0.2246123223293556, 0.05212302975003213, 0.05317844391032825], 
     RGBColor[0.15840693540100986`, 0.03675955673710229, 0.03750388332158143],
      
     RGBColor[
     0.12532649519353986`, 0.029082984271279175`, 0.02967187163202509], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.09944172030289808, 0.02307622169607439, 0.023543481010449806`], 
     RGBColor[0.8010580360107058, 0.7739449642500833, 0.4831111755060109], 
     RGBColor[0.8082467882384796, 0.7813125884170447, 0.47981428986296104`], 
     RGBColor[0.6125760728911303, 0.551586713781145, 0.5457601118991473], 
     RGBColor[0.5189918439122053, 0.362030862274203, 0.49766033705947205`], 
     RGBColor[0.5172363747063347, 0.35639585209189345`, 0.49430536622670107`],
      
     RGBColor[0.47977525917659136`, 0.20488335982436, 0.33415272853035377`], 
     RGBColor[0.4748961375469372, 0.19745314380454076`, 0.32049172490424743`],
      
     RGBColor[0.28444083559222855`, 0.06611850096610881, 0.06766874362512881],
      
     RGBColor[
     0.11977827019541984`, 0.027795475671404436`, 0.028358292889752116`], 
     RGBColor[0.22413384964181365`, 0.05201199645555972, 0.05306516235607868],
      
     RGBColor[
     0.037072133175771405`, 0.008602875747771669, 0.008777071241145894], 
     RGBColor[0.7743009501267477, 0.7465221033209675, 0.495382436151197], 
     RGBColor[0.7733995375039509, 0.7455982615729567, 0.4957958395125037], 
     RGBColor[0.8270055345603343, 0.800538093534446, 0.47121120556257334`], 
     RGBColor[0.8266904955644578, 0.8002152156766466, 0.471355687874607], 
     RGBColor[0.7031510659137586, 0.6736018537707251, 0.5280129990547549], 
     RGBColor[0.604979176903317, 0.5394700219153086, 0.5457138330438145], 
     RGBColor[0.545952687990394, 0.44532554774751554`, 0.5453542548232372], 
     RGBColor[0.5006905675793397, 0.30313928203758256`, 0.4622731604232182], 
     RGBColor[0.516793040297886, 0.35497276024988234`, 0.4934580861920899], 
     RGBColor[
     0.46518460127065986`, 0.18403861145186132`, 0.29474058159982325`], 
     RGBColor[0.4794095625806657, 0.2036875318986512, 0.3324595383923386], 
     RGBColor[
     0.47581022622355157`, 0.19871577329763285`, 0.32291552561247805`], 
     RGBColor[0.43712136286270953`, 0.1452748969544974, 0.22032800121389445`],
      
     RGBColor[
     0.37563672847196833`, 0.10693253675898232`, 0.14647424159596317`], 
     RGBColor[0.2648208991767458, 0.06145374155376767, 0.06269808880967491], 
     RGBColor[0.23585641761833803`, 0.05473230918395582, 0.05584055738854943],
      
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.04023261018883959, 0.009336288926835334, 0.009525334950929738], 
     RGBColor[0.7937637528444693, 0.7664691833032045, 0.4864564594558728], 
     RGBColor[0.758050228836301, 0.7298670284044227, 0.5028352969557027], 
     RGBColor[0.8045769425631952, 0.7775514289237765, 0.4814973443257799], 
     RGBColor[0.8369259809308487, 0.8107053823921788, 0.4666615179150797], 
     RGBColor[0.7045817532265103, 0.6750681397250622, 0.5273568612005552], 
     RGBColor[0.5998953011390381, 0.5313614791343125, 0.5456828630329834], 
     RGBColor[0.6007632176962582, 0.5327457652303658, 0.5456881502167038], 
     RGBColor[0.5428104176324684, 0.43848786020553654`, 0.5431812837342694], 
     RGBColor[0.5013198188903336, 0.3053041247118163, 0.46388638744753763`], 
     RGBColor[0.5165470082626833, 0.35418300385945106`, 0.4929878812467272], 
     RGBColor[0.4661399914761355, 0.18535829069273407`, 0.2972738975853634], 
     RGBColor[0.4783149881495859, 0.20217559766904808`, 0.32955716103099914`],
      
     RGBColor[0.4770303998765777, 0.20040119756818708`, 0.32615094230675645`],
      
     RGBColor[0.4347983980320085, 0.14206618867301837`, 0.21416841960447996`],
      
     RGBColor[0.3762088281094482, 0.10718857564783871`, 0.14696861250891635`],
      
     RGBColor[0.25364328021499305`, 0.05885988846665315, 0.06005171403893999],
      
     RGBColor[0.21051267280407213`, 0.04885109683001295, 0.04984025919428171],
      
     RGBColor[
     0.08433227537846916, 0.019569957929531465`, 0.01996622059527211], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.758050228836301, 0.7298670284044227, 0.5028352969557027], 
     RGBColor[0.7746380780640274, 0.746867619741531, 0.4952278234700151], 
     RGBColor[0.6669086068540414, 0.6364576027549721, 0.5446344152834525], 
     RGBColor[0.7045817532265103, 0.6750681397250622, 0.5273568612005552], 
     RGBColor[0.6042927614336351, 0.5383752215190124, 0.5457096515304345], 
     RGBColor[0.6007632176962582, 0.5327457652303658, 0.5456881502167038], 
     RGBColor[0.5403342523039477, 0.4305394343415947, 0.538448952100924], 
     RGBColor[0.5022941920957785, 0.3084318371864584, 0.4657485640517008], 
     RGBColor[0.5165470082626833, 0.35418300385945106`, 0.4929878812467272], 
     RGBColor[0.467415296582636, 0.18711986796784316`, 0.30065550103306693`], 
     
     RGBColor[0.4770303998765777, 0.20040119756818708`, 0.32615094230675645`],
      
     RGBColor[0.4783149881495859, 0.20217559766904808`, 0.32955716103099914`],
      
     RGBColor[
     0.43169758237173156`, 0.13778303605831957`, 0.20594628603500095`], 
     RGBColor[0.3762088281094482, 0.10718857564783871`, 0.14696861250891635`],
      
     RGBColor[0.25364328021499305`, 0.05885988846665315, 0.06005171403893999],
      
     RGBColor[0.17668250896710055`, 0.04100054518691428, 0.04183074550676625],
      
     RGBColor[
     0.08433227537846916, 0.019569957929531465`, 0.01996622059527211], 
     RGBColor[
     0.07285721555480183, 0.016907081385762072`, 0.017249424745106053`], 
     RGBColor[
     0.07285721555480204, 0.01690708138576212, 0.017249424745106105`], 
     RGBColor[
     0.030828213857728486`, 0.007153925890541967, 0.007298782295144624], 
     RGBColor[0.7733995375039509, 0.7455982615729567, 0.4957958395125037], 
     RGBColor[0.7431187003529666, 0.7145639707084761, 0.5096831532074879], 
     RGBColor[0.6790811654596539, 0.6489330413449926, 0.5390518701581692], 
     RGBColor[0.6049791769033169, 0.5394700219153085, 0.5457138330438145], 
     RGBColor[0.5377273668535378, 0.4221714003094119, 0.5334667942702701], 
     RGBColor[0.5651908932347988, 0.47600958045931097`, 0.545471450335562], 
     RGBColor[0.5033200037826181, 0.31172466583941455`, 0.46770904748128933`],
      
     RGBColor[0.516793040297886, 0.35497276024988234`, 0.4934580861920899], 
     RGBColor[0.4938600791472766, 0.27105101792329755`, 0.42043179183789287`],
      
     RGBColor[0.47581022622355157`, 0.1987157732976329, 0.32291552561247805`],
      
     RGBColor[0.4794095625806657, 0.2036875318986512, 0.3324595383923386], 
     RGBColor[
     0.37563672847196833`, 0.10693253675898232`, 0.14647424159596317`], 
     RGBColor[0.2648208991767458, 0.06145374155376767, 0.06269808880967491], 
     RGBColor[
     0.14106640495506645`, 0.032735552288272816`, 0.03339839874205433], 
     RGBColor[
     0.0899510800482713, 0.020873845089089318`, 0.021296509538805786`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.11274853171425943`, 0.026164170388646216`, 0.026693956090916536`], 
     RGBColor[0.8010580360107058, 0.7739449642500833, 0.4831111755060109], 
     RGBColor[0.7162616087454894, 0.6870386156938655, 0.5220002782007064], 
     RGBColor[0.8082467882384796, 0.7813125884170447, 0.47981428986296104`], 
     RGBColor[0.6125760728911301, 0.5515867137811449, 0.5457601118991473], 
     RGBColor[0.5355060869160442, 0.41504114987626456`, 0.5292215877028248], 
     RGBColor[0.5406134746615332, 0.43143573079775627`, 0.5389825888417019], 
     RGBColor[0.5041940793655191, 0.3145304255720739, 0.46937953994932197`], 
     RGBColor[0.5189918439122053, 0.362030862274203, 0.49766033705947205`], 
     RGBColor[0.4939312095532083, 0.2713851742980275, 0.42086751375760834`], 
     RGBColor[0.4748961375469372, 0.19745314380454082`, 0.3204917249042475], 
     RGBColor[0.47977525917659136`, 0.20488335982436, 0.33415272853035377`], 
     RGBColor[0.374605840546553, 0.10647117062331843`, 0.1455834159924285], 
     RGBColor[
     0.11071856697040408`, 0.025693101341150507`, 0.026213348592843636`], 
     RGBColor[
     0.10007581621290422`, 0.023223368565127998`, 0.023693607385683064`], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.05717874682033355, 0.013268771235158044`, 0.013537444202145482`], 
     RGBColor[
     0.07686784450741758, 0.017837778909591602`, 0.01819896751546697], 
     RGBColor[
     0.07831023356161515, 0.018172496465616063`, 0.01854046260629749], 
     RGBColor[0.6638655890445496, 0.6333388679810726, 0.5460299956859732], 
     RGBColor[0.7043517381533062, 0.6748324013718113, 0.5274623500765805], 
     RGBColor[0.524792327757223, 0.38065026352583864`, 0.508745951122603], 
     RGBColor[0.2699767878103142, 0.06265020546032608, 0.0639187793384255], 
     RGBColor[
     0.2554403331564833, 0.059276908525750044`, 0.060477178136643404`], 
     RGBColor[0.5244359746791254, 0.3795063794765704, 0.5080649057478466], 
     RGBColor[0.5242382136405407, 0.37887157172126384`, 0.507686954078805], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.49404279643907767`, 0.2719093870978998, 0.42155105902196055`],
      
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[
     0.49412867019313156`, 0.27231280476385034`, 0.42207709393599485`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.49419300220522205`, 0.27261502364841406`, 0.4224711710882347],
      
     RGBColor[0.5700732396962418, 0.48379669347895243`, 0.5455011926679484], 
     RGBColor[0.2699767878103142, 0.06265020546032608, 0.0639187793384255], 
     RGBColor[
     0.32565656341437876`, 0.08456428988755581, 0.10328466724504554`], 
     RGBColor[0.6761151704469157, 0.6458932458641427, 0.5404121265788976], 
     RGBColor[0.6903649243381418, 0.6604975649192122, 0.5338769439029012], 
     RGBColor[0.3555782948466306, 0.09795553568928406, 0.12914106133482836`], 
     
     RGBColor[
     0.37052383839809994`, 0.10464430127062456`, 0.14205601797187217`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4941644604376428, 0.2724809401512408, 0.42229633342775996`], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.49408742614399526`, 0.2721190484966388, 0.421824446196521], 
     RGBColor[0.49017750000000004`, 0.253751, 0.3978735], 
     RGBColor[0.4939970189981409, 0.27169433386563596`, 0.4212706411868115], 
     RGBColor[0.4502011136208102, 0.1633419395642361, 0.2550103137313031], 
     RGBColor[0.4499534643550796, 0.1629998619574855, 0.2543536460785608], 
     RGBColor[0.4495072157979152, 0.1623834594093077, 0.2531703718552021], 
     RGBColor[0.8419099452991633, 0.8158133587368638, 0.4643757859756918], 
     RGBColor[0.8014788998032039, 0.7743763000577951, 0.48291816011875005`], 
     RGBColor[0.6378223216888114, 0.5918532934395295, 0.545913907277902], 
     RGBColor[0.5252366927773325, 0.38207666360429393`, 0.5095952008141303], 
     RGBColor[0.4489507529489429, 0.1616148180040506, 0.2516948530330691], 
     RGBColor[0.3946476754280874, 0.11544074305009963`, 0.1629022527099035], 
     RGBColor[
     0.21740016576042273`, 0.050449392936584486`, 0.051470918429998104`], 
     RGBColor[
     0.12831892688994398`, 0.029777401232553014`, 0.030380349508360716`], 
     RGBColor[0.8419099452991641, 0.8158133587368646, 0.4643757859756914], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8050529981718935, 0.7780393298412558, 0.48127901702058407`], 
     RGBColor[0.8014788998032039, 0.7743763000577951, 0.48291816011875005`], 
     RGBColor[0.8408897286043145, 0.8147677568106401, 0.46484367493158757`], 
     RGBColor[0.7325740403431575, 0.7037569364055677, 0.5145191159859613], 
     RGBColor[0.7226441902577937, 0.693580009847913, 0.519073116339123], 
     RGBColor[0.6791595806753289, 0.6490134077034035, 0.5390159075890663], 
     RGBColor[0.6899957329142692, 0.6601191872021099, 0.5340462614515294], 
     RGBColor[0.5700732396962419, 0.4837966934789526, 0.5455011926679484], 
     RGBColor[0.585629877594771, 0.50860879939527, 0.5455959607674362], 
     RGBColor[0.5402964397732456, 0.4304180571081958, 0.5383766865566497], 
     RGBColor[0.5252366927773325, 0.38207666360429393`, 0.5095952008141303], 
     RGBColor[0.5287922300894313, 0.3934898452711985, 0.5163903778169671], 
     RGBColor[0.5190553329196111, 0.36223466032545903`, 0.49778167428790976`],
      
     RGBColor[0.4489507529489429, 0.1616148180040506, 0.2516948530330691], 
     RGBColor[0.4598625139447203, 0.1766872191915043, 0.28062851637038005`], 
     RGBColor[0.12831892688994379`, 0.02977740123255297, 0.03038034950836067],
      
     RGBColor[
     0.08713949916187368, 0.020221395959555643`, 0.020630849280650367`], 
     RGBColor[
     0.14161662976798492`, 0.0328632362193926, 0.033528668083684446`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8152583172961174, 0.7884985797122827, 0.4765986818195173], 
     RGBColor[0.529346499803281, 0.3952690365386064, 0.5174496722308111], 
     RGBColor[0.518868049501332, 0.3616334854569673, 0.4974237469578906], 
     RGBColor[0.5352057630791704, 0.4140771182241487, 0.5286476227994658], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8314999896402453, 0.8051443805248559, 0.4691499710177183], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8505611528054825, 0.8246798272806952, 0.46040819314192655`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8686665096571289, 0.8432356851632752, 0.4521047645113125], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8822300722230859, 0.8571367389462884, 0.4458842810010384], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8885654105909873, 0.863629714442772, 0.4429787856595381], 
     RGBColor[0.6031354057288796, 0.5365292935931611, 0.5457026011381012], 
     RGBColor[0.25387492433482767`, 0.05891364327949844, 0.06010655730713665],
      
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8864177332992442, 0.8614285982245296, 0.4439637474727573], 
     RGBColor[
     0.39464767542808715`, 0.11544074305009952`, 0.16290225270990333`], 
     RGBColor[0.4300919559264381, 0.13556518635009987`, 0.20168880137862136`],
      
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8762124141750202, 0.8509693483535027, 0.44864408267382405`], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8599707418308926, 0.8343235475409296, 0.4560927934756229], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.840909578665655, 0.8147881007850899, 0.4648345713514149], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8228042218140095, 0.7962322429025107, 0.4731379999820286], 
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8092406592480523, 0.7823311891194975, 0.4793584834923027], 
     RGBColor[0.4594052171703694, 0.17605555575538137`, 0.27941594665597497`],
      
     RGBColor[
     0.43646683317416424`, 0.14437079595204047`, 0.21859244801950434`], 
     RGBColor[0.45692598326877676`, 0.17263099321072875`, 0.2728420014356857],
      
     RGBColor[0.8470118446393314, 0.8210422045344421, 0.46203596702604144`], 
     RGBColor[0.8029053208801507, 0.7758382136230135, 0.4822639788338032], 
     RGBColor[0.78971075920139, 0.7623153422794556, 0.4883152321788518], 
     RGBColor[0.4597830088704218, 0.17657739893639338`, 0.2804177004393629], 
     RGBColor[
     0.45669145476229084`, 0.17230703929155675`, 0.27222012483370617`], 
     RGBColor[0.4300919559264381, 0.13556518635009984`, 0.2016888013786213], 
     RGBColor[0.2838185066833827, 0.06586228357398637, 0.06719589727692697], 
     RGBColor[0.2542921013575954, 0.05901045244002556, 0.060205326709793915`],
      
     RGBColor[
     0.20617968492776562`, 0.047845593420221905`, 0.04881439582955311], 
     RGBColor[0.9145381811720236, 0.8902487445821718, 0.4310672255270275], 
     RGBColor[0.8178593458126991, 0.7911643275292244, 0.47540580532276583`], 
     RGBColor[0.8095700174061466, 0.7826687424317104, 0.4792074341657384], 
     RGBColor[0.8822300722230859, 0.8571367389462884, 0.4458842810010384], 
     RGBColor[0.6296738440253942, 0.5788568547385573, 0.545864268291193], 
     RGBColor[
     0.48250477419901816`, 0.21770607372171513`, 0.35087285700263726`], 
     RGBColor[0.3145889561717903, 0.07961106552759314, 0.09372076833955474], 
     RGBColor[0.358866139900784, 0.09942698600885706, 0.13198220098006633`], 
     RGBColor[0.3256565634143788, 0.08456428988755584, 0.10328466724504559`], 
     
     RGBColor[0.1599878640793382, 0.0371264234863466, 0.037878178579182825`], 
     
     RGBColor[0.8686665096571289, 0.8432356851632752, 0.4521047645113125], 
     RGBColor[0.5438424275117894, 0.4418005848940527, 0.5451536128601091], 
     RGBColor[0.5348904560075574, 0.4130649907808691, 0.5280450226370188], 
     RGBColor[0.5168882500869196, 0.35527838117952654`, 0.4936400466982234], 
     RGBColor[0.5009137221073028, 0.3040005646722957, 0.46311027422504747`], 
     RGBColor[0.5169947898900222, 0.35562037115764566`, 0.49384366059856594`],
      
     RGBColor[0.5011076769471842, 0.30462315462943357`, 0.4634809516647318], 
     RGBColor[0.4656084730617963, 0.18462410500240053`, 0.29586452151269993`],
      
     RGBColor[0.47554456825154834`, 0.19834882028846895`, 0.3222111060116649],
      
     RGBColor[0.8505611528054828, 0.8246798272806957, 0.4604081931419264], 
     RGBColor[0.5305331565381927, 0.39907817358400227`, 0.5197175552109431], 
     RGBColor[0.5184670874352385, 0.3603464077243583, 0.49665744696681546`], 
     RGBColor[0.5337848023411884, 0.4095158714643575, 0.5259319489417303], 
     RGBColor[0.5173683816503085, 0.3568195909253293, 0.49455765173833205`], 
     RGBColor[0.5017877976902038, 0.30680632440495503`, 0.46478076669308005`],
      
     RGBColor[0.5166412424969086, 0.3544854932837061, 0.49316797731803214`], 
     RGBColor[0.5006286921736123, 0.3028486037967934, 0.4618941316490447], 
     RGBColor[0.49404279643907767`, 0.2719093870978998, 0.42155105902196055`],
      
     RGBColor[0.4667525039609548, 0.18620435338665609`, 0.2988980378164882], 
     RGBColor[0.4747385726324606, 0.1972354995943187, 0.3200739252300242], 
     RGBColor[0.4863579810018592, 0.2358076661343641, 0.3744763588131885], 
     RGBColor[0.4863579810018592, 0.2358076661343641, 0.3744763588131885], 
     RGBColor[
     0.06015576152026293, 0.013959610562945103`, 0.014242272003214554`], 
     RGBColor[
     0.00889518727447162, 0.002064197129218657, 0.0021059940640911663`], 
     RGBColor[0.8314999896402453, 0.8051443805248559, 0.4691499710177183], 
     RGBColor[0.5321171683744274, 0.40416281009954513`, 0.5227448447193884], 
     RGBColor[0.5179318621759974, 0.3586283486575477, 0.49563454942596935`], 
     RGBColor[0.5028136093770433, 0.3100991530579112, 0.4667412501226686], 
     RGBColor[0.5165150628932023, 0.3540804600599349, 0.49292682874720584`], 
     RGBColor[0.500515730077466, 0.3023179305349767, 0.46120216229018596`], 
     RGBColor[0.4939523892932233, 0.271484672466897, 0.42099725401225113`], 
     RGBColor[0.468095134151547, 0.18805892671233873`, 0.30245816069089293`], 
     
     RGBColor[0.47445091612646895`, 0.19683816003893762`, 0.319311174240118], 
     
     RGBColor[0.48626757385600483`, 0.23538295150336128`, 0.3739225538034791],
      
     RGBColor[0.486443854755913, 0.2362110838003146, 0.37500239372722277`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.029607125249098958`, 0.0068705628176038095`, 0.007009681539628954], 
     RGBColor[0.8152583172961179, 0.788498579712283, 0.47659868181951714`], 
     RGBColor[0.5037879825824882, 0.3132268655325533, 0.46860342672683175`], 
     RGBColor[0.5006286921736123, 0.3028486037967935, 0.4618941316490448], 
     RGBColor[0.49387535499957586`, 0.271122780812295, 0.42052536678101216`], 
     
     RGBColor[0.4693704392580475, 0.18982050398744788`, 0.3058397641385966], 
     RGBColor[0.4747385726324606, 0.19723549959431874`, 0.3200739252300242], 
     RGBColor[0.4861905395623573, 0.23502105984875932`, 0.3734506665722402], 
     RGBColor[0.4865081867680035, 0.23651330268487833`, 0.3753964708794626], 
     RGBColor[
     0.034430249201958564`, 0.00798980610165821, 0.008151587842630495], 
     RGBColor[0.8050529981718935, 0.7780393298412558, 0.48127901702058407`], 
     RGBColor[0.8090371713133113, 0.7821226379581583, 0.4794518065655322], 
     RGBColor[0.6014410276949862, 0.5338268403051524, 0.5456922793071803], 
     RGBColor[0.5904878532211946, 0.5163570420790641, 0.5456255546372992], 
     RGBColor[0.5045179307432969, 0.31556998001440195`, 0.4699984695910176], 
     RGBColor[0.5011076769471842, 0.30462315462943357`, 0.4634809516647318], 
     RGBColor[0.4703258294635231, 0.1911401832283206, 0.30837308012413667`], 
     RGBColor[0.47554456825154834`, 0.19834882028846895`, 0.3222111060116649],
      
     RGBColor[0.45677095983658933`, 0.1724168595466677, 0.27243094076472335`],
      
     RGBColor[0.25544033315648335`, 0.05927690852575006, 0.06047717813664342],
      
     RGBColor[0.2423399918041573, 0.05623687281016, 0.05737558619998512], 
     RGBColor[0.2630871265426326, 0.061051406180309575`, 0.06228760674074704],
      
     RGBColor[0.6284564432747535, 0.5769151577880641, 0.5458568521157825], 
     RGBColor[0.6889795759601911, 0.6590777460319208, 0.5345122885403534], 
     RGBColor[0.3575805320923601, 0.0988516219058069, 0.13087126319176443`], 
     RGBColor[
     0.11600410421509155`, 0.026919651212469572`, 0.027464734282585147`], 
     RGBColor[
     0.08713949916187388, 0.02022139595955569, 0.020630849280650416`], 
     RGBColor[0.1599878640793382, 0.0371264234863466, 0.037878178579182825`], 
     
     RGBColor[0.8092406592480519, 0.7823311891194972, 0.47935848349230287`], 
     RGBColor[0.8379216824289449, 0.8117258591297288, 0.46620487205084277`], 
     RGBColor[0.7734526678311975, 0.7456527138993992, 0.4957714730289249], 
     RGBColor[0.8123772155539173, 0.7855457898329349, 0.4779200047235573], 
     RGBColor[0.6822123515345481, 0.6521421382043217, 0.537615854269883], 
     RGBColor[
     0.49384681323199653`, 0.27098869731512176`, 0.42035052912053744`], 
     RGBColor[
     0.48616199779477803`, 0.23488697635158606`, 0.37327582891176553`], 
     RGBColor[
     0.48647964500042423`, 0.23637921918770508`, 0.37522163321898794`], 
     RGBColor[0.822804221814009, 0.7962322429025103, 0.47313799998202877`], 
     RGBColor[0.5041940793655191, 0.3145304255720739, 0.46937953994932197`], 
     RGBColor[0.5040001245256377, 0.3139078356149361, 0.4690088625096377], 
     RGBColor[0.4939111452440871, 0.2712909161996855, 0.42074460627277727`], 
     RGBColor[0.4699019576723866, 0.19055468967778139`, 0.30724914021126004`],
      
     RGBColor[0.47916667968509996`, 0.2033520380727734, 0.3318155092632723], 
     RGBColor[
     0.48622632980686853`, 0.23518919523614973`, 0.37366990606400524`], 
     RGBColor[0.4864026107067767, 0.23601732753310312`, 0.374749745987749], 
     RGBColor[
     0.10867612491329134`, 0.025219136836436017`, 0.025729787008831332`], 
     RGBColor[0.840909578665655, 0.8147881007850899, 0.4648345713514149], 
     RGBColor[0.5033200037826181, 0.31172466583941455`, 0.46770904748128933`],
      
     RGBColor[0.5046437546622149, 0.3159738714993166, 0.47023893839367337`], 
     RGBColor[0.4939970189981409, 0.27169433386563596`, 0.4212706411868115], 
     RGBColor[
     0.46875792677322814`, 0.18897444129352584`, 0.30421562390747164`], 
     RGBColor[
     0.47972630782638775`, 0.20465339620320658`, 0.33385286835095523`], 
     RGBColor[0.48631220356092236`, 0.2355926129021002, 0.37419594097803943`],
      
     RGBColor[0.48631220356092236`, 0.2355926129021002, 0.37419594097803943`],
      
     RGBColor[
     0.45809833807316475`, 0.17425036536822125`, 0.27595062150490896`], 
     RGBColor[0.1194884995532531, 0.02772823214867287, 0.02828968778527023], 
     RGBColor[
     0.17074907379904408`, 0.039623645582399246`, 0.040425965724393546`], 
     RGBColor[0.8599707418308926, 0.8343235475409296, 0.4560927934756229], 
     RGBColor[0.5022941920957785, 0.3084318371864584, 0.4657485640517008], 
     RGBColor[0.5048734635984102, 0.316711231169369, 0.4706779473938796], 
     RGBColor[0.467415296582636, 0.1871198679678432, 0.30065550103306693`], 
     RGBColor[0.47983926992253406`, 0.2051840694650234, 0.3345448377098141], 
     RGBColor[0.45987254650462883`, 0.1767010771533802, 0.28065511874106225`],
      
     RGBColor[0.44033457282725014`, 0.1497132996746286, 0.22884815991074345`],
      
     RGBColor[
     0.43169758237173156`, 0.13778303605831957`, 0.20594628603500095`], 
     RGBColor[0.43508376093662404`, 0.1424603600798195, 0.21492508887301504`],
      
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.12701334187413257`, 0.029474430113628602`, 0.030071243672966312`], 
     RGBColor[0.8762124141750198, 0.8509693483535022, 0.4486440826738242], 
     RGBColor[0.5013198188903336, 0.3053041247118164, 0.4638863874475377], 
     RGBColor[0.5046437546622149, 0.3159738714993166, 0.47023893839367337`], 
     RGBColor[0.45880396512406973`, 0.17522504709045428`, 0.27782166464272], 
     RGBColor[0.43824625285112323`, 0.1468287060237836, 0.22331076341230308`],
      
     RGBColor[0.4574280941090342, 0.17332455825745752`, 0.27417340028282366`],
      
     RGBColor[0.4423181757197091, 0.15245324775480606`, 0.23410788822659773`],
      
     RGBColor[0.4347983980320084, 0.14206618867301832`, 0.21416841960447985`],
      
     RGBColor[0.43555139624075034`, 0.1431063041135951, 0.21616507226886345`],
      
     RGBColor[0.8864177332992442, 0.8614285982245296, 0.4439637474727573], 
     RGBColor[0.7934959068656353, 0.7661946727283293, 0.4865792982370948], 
     RGBColor[0.804127128393328, 0.7770904223897425, 0.4817036368549543], 
     RGBColor[0.6761151704469159, 0.6458932458641429, 0.5404121265788975], 
     RGBColor[0.6284564432747535, 0.5769151577880641, 0.5458568521157825], 
     RGBColor[0.5579570657442119, 0.46447196577369954`, 0.545427383224932], 
     RGBColor[0.5006905675793398, 0.3031392820375826, 0.46227316042321825`], 
     RGBColor[0.5040001245256377, 0.3139078356149361, 0.4690088625096377], 
     RGBColor[0.49785022580098187`, 0.28979592627828493`, 0.4448741429973628],
      
     RGBColor[
     0.46518460127065986`, 0.18403861145186132`, 0.29474058159982325`], 
     RGBColor[0.4791666796851, 0.2033520380727734, 0.33181550926327236`], 
     RGBColor[0.4592718010829627, 0.17587126828839666`, 0.2790621800954445], 
     RGBColor[0.4438041846483558, 0.15450586994377896`, 0.2380481946605767], 
     RGBColor[0.4371213628627095, 0.14527489695449736`, 0.22032800121389434`],
      
     RGBColor[0.4368616812459761, 0.14491619907704875`, 0.21963942853746207`],
      
     RGBColor[0.32421796761276134`, 0.08392045715907845, 0.1020415272861582], 
     
     RGBColor[0.0901240851532884, 0.02091399226419617, 0.02133746963475218], 
     RGBColor[
     0.10867612491329176`, 0.025219136836436114`, 0.025729787008831433`], 
     RGBColor[0.8379216824289449, 0.8117258591297288, 0.46620487205084277`], 
     RGBColor[
     0.08378568163845918, 0.019443116617014575`, 0.019836810934023716`], 
     RGBColor[0.6633349393279698, 0.632544718874402, 0.5460693253253229], 
     RGBColor[0.6119947645637466, 0.5506595543342798, 0.5457565706786238], 
     RGBColor[0.5005797408234087, 0.3026186401756401, 0.4615942714696464], 
     RGBColor[0.5035603213440933, 0.31249607891881936`, 0.46816833119111223`],
      
     RGBColor[0.497197729913199, 0.286730631520976, 0.44087716368721896`], 
     RGBColor[0.49843555667858325`, 0.29254569329444047`, 0.4484596911229005],
      
     RGBColor[0.48309010507661954`, 0.2204558407378707, 0.354458405128175], 
     RGBColor[0.45677095983658933`, 0.17241685954666766`, 0.2724309407647233],
      
     RGBColor[0.4589692728256294, 0.1754533864023442, 0.27825999511805233`], 
     RGBColor[0.4296949441699398, 0.13501679453026488`, 0.20063608362683746`],
      
     RGBColor[0.407681699357112, 0.12127402240475096`, 0.1741653996988262], 
     RGBColor[0.4089652918497002, 0.12184848456836006`, 0.17527459598361317`],
      
     RGBColor[0.28406867332606356`, 0.06595194254365833, 0.0673471454502005], 
     
     RGBColor[0.5043674080074856, 0.3150868059740204, 0.46971079756200845`], 
     RGBColor[0.4973614108678938, 0.28749957180349983`, 0.44187982041139057`],
      
     RGBColor[0.4982180135676982, 0.2915237194095926, 0.4471270922061065], 
     RGBColor[0.4820159592659301, 0.21540971924693, 0.34787853441666505`], 
     RGBColor[0.48287256196573447`, 0.2194338668530228, 0.35312580621138095`],
      
     RGBColor[0.5416211475742958, 0.4346703344609056, 0.5409084062926639], 
     RGBColor[0.5359367878943523, 0.4164236887383422, 0.5300447233152509], 
     RGBColor[0.5048153073146343, 0.3165245510213229, 0.47056680181800853`], 
     RGBColor[0.49762190761500846`, 0.2887233332526943, 0.4434755394466706], 
     RGBColor[
     0.49792762557899395`, 0.29015953490509705`, 0.44534826906791203`], 
     RGBColor[0.4865343952499339, 0.23663642487424782`, 0.37555701558478205`],
      
     RGBColor[0.48227645601304475`, 0.21663348069612443`, 0.349474253451945], 
     
     RGBColor[
     0.48258217397703024`, 0.21806968234852728`, 0.35134698307318646`], 
     RGBColor[0.5363102194211933, 0.4176223941608624, 0.5307584082243333], 
     RGBColor[0.5048153073146343, 0.3165245510213229, 0.47056680181800853`], 
     RGBColor[
     0.49792762557899395`, 0.29015953490509705`, 0.44534826906791203`], 
     RGBColor[0.49762190761500846`, 0.2887233332526943, 0.4434755394466706], 
     RGBColor[0.4865343952499339, 0.23663642487424782`, 0.37555701558478205`],
      
     RGBColor[0.48258217397703024`, 0.21806968234852725`, 0.3513469830731864],
      
     RGBColor[0.48227645601304475`, 0.21663348069612443`, 0.349474253451945], 
     
     RGBColor[
     0.09987901832478915, 0.023177700090350712`, 0.023647014191924744`], 
     RGBColor[0.5043674080074856, 0.3150868059740204, 0.46971079756200845`], 
     RGBColor[0.4982180135676982, 0.2915237194095926, 0.4471270922061065], 
     RGBColor[0.4973614108678938, 0.28749957180349983`, 0.44187982041139057`],
      
     RGBColor[
     0.48649492085272344`, 0.23645098207670256`, 0.37531520816210723`], 
     RGBColor[0.48287256196573447`, 0.2194338668530228, 0.35312580621138095`],
      
     RGBColor[0.4820159592659301, 0.21540971924693, 0.34787853441666505`], 
     RGBColor[0.6119947645637467, 0.55065955433428, 0.5457565706786238], 
     RGBColor[0.5005797408234087, 0.3026186401756401, 0.4615942714696464], 
     RGBColor[0.49843555667858325`, 0.29254569329444047`, 0.4484596911229005],
      
     RGBColor[0.497197729913199, 0.286730631520976, 0.44087716368721896`], 
     RGBColor[0.48642379044679174`, 0.23611682570197262`, 0.3748794862423918],
      
     RGBColor[
     0.48309010507661954`, 0.22045584073787072`, 0.35445840512817506`], 
     RGBColor[0.28406867332606367`, 0.06595194254365837, 0.0673471454502006], 
     
     RGBColor[0.6421339653509107, 0.5987301623308177, 0.5459401729966383], 
     RGBColor[0.6636498788138767, 0.6330470325447801, 0.5460712438771802], 
     RGBColor[0.5015474801287285, 0.3060349113255502, 0.46432148298325715`], 
     RGBColor[0.4972648949233805, 0.28704615926212934`, 0.44128859487182504`],
      
     RGBColor[0.48624639411598974`, 0.2352834533344918, 0.3737928135488363], 
     RGBColor[0.48315727008680104`, 0.22077136847902398`, 0.354869836312781], 
     
     RGBColor[0.4819194433214168, 0.2149563067055595, 0.3472873088770994], 
     RGBColor[0.3220335136283758, 0.08294282121198414, 0.10015386569748463`], 
     
     RGBColor[0.3451092390175169, 0.09327018851152795, 0.12009439122890897`], 
     
     RGBColor[0.5007645889214631, 0.30348701945047396`, 0.46272659128541366`],
      
     RGBColor[0.49833904073407, 0.2920922807530701, 0.4478684655833351], 
     RGBColor[0.4974824380342656, 0.2880681331469772, 0.4426211937886191], 
     RGBColor[0.48617526371005804`, 0.23494929695976174`, 0.3733570916291208],
      
     RGBColor[0.4829935891321062, 0.22000242819650023`, 0.35386717958860947`],
      
     RGBColor[0.48213698643230185`, 0.2159782805904074, 0.34861990779389346`],
      
     RGBColor[0.5005443291203601, 0.3024522831000864, 0.4613773508007617], 
     RGBColor[0.4980785439869553, 0.29086851930387564`, 0.44627274654805504`],
      
     RGBColor[0.4977728260229698, 0.2894323176514728, 0.44440001692681363`], 
     RGBColor[0.48613578931284757`, 0.23476385416221657`, 0.373115284206446], 
     
     RGBColor[
     0.48273309238499157`, 0.21877866674730584`, 0.35227146055332953`], 
     RGBColor[0.4824273744210061, 0.21734246509490296`, 0.350398730932088], 
     RGBColor[0.5005443291203601, 0.3024522831000864, 0.4613773508007617], 
     RGBColor[0.4977728260229698, 0.2894323176514728, 0.44440001692681363`], 
     RGBColor[0.4980785439869553, 0.29086851930387564`, 0.44627274654805504`],
      
     RGBColor[0.48613578931284757`, 0.23476385416221657`, 0.373115284206446], 
     
     RGBColor[0.4824273744210061, 0.21734246509490296`, 0.350398730932088], 
     RGBColor[
     0.48273309238499157`, 0.21877866674730584`, 0.35227146055332953`], 
     RGBColor[
     0.07976524274872657, 0.01851014262126719, 0.018884945596559972`], 
     RGBColor[0.5007645889214631, 0.30348701945047396`, 0.46272659128541366`],
      
     RGBColor[0.4974824380342656, 0.2880681331469772, 0.4426211937886191], 
     RGBColor[0.4983390407340699, 0.29209228075307003`, 0.447868465583335], 
     RGBColor[0.4661399914761355, 0.18535829069273407`, 0.2972738975853634], 
     RGBColor[
     0.47972630782638775`, 0.20465339620320658`, 0.33385286835095523`], 
     RGBColor[0.459714536178471, 0.1764828176965856, 0.2802361380116788], 
     RGBColor[0.48213698643230185`, 0.21597828059040744`, 0.3486199077938935],
      
     RGBColor[0.4829935891321062, 0.22000242819650023`, 0.35386717958860947`],
      
     RGBColor[0.6889795759601909, 0.6590777460319207, 0.5345122885403534], 
     RGBColor[0.6636498788138766, 0.6330470325447799, 0.5460712438771802], 
     RGBColor[0.5015474801287285, 0.3060349113255502, 0.46432148298325715`], 
     RGBColor[0.4972648949233805, 0.28704615926212934`, 0.44128859487182504`],
      
     RGBColor[0.4819194433214168, 0.2149563067055595, 0.3472873088770994], 
     RGBColor[0.48315727008680104`, 0.22077136847902398`, 0.354869836312781], 
     
     RGBColor[0.34510923901751683`, 0.09327018851152792, 0.1200943912289089], 
     
     RGBColor[0.4786159294677924, 0.20259128751816086`, 0.3303551380750933], 
     RGBColor[0.3094939104630522, 0.07733081615060657, 0.08931796464322221], 
     RGBColor[
     0.12532649519353978`, 0.029082984271279155`, 0.02967187163202507], 
     RGBColor[0.5346830865002221, 0.41239934009247936`, 0.52764870771085], 
     RGBColor[0.5122731061708621, 0.34046389006066363`, 0.48481979899713434`],
      
     RGBColor[0.47959041107853684`, 0.20401498054952613`, 0.3330204087145864],
      
     RGBColor[0.5365380967953652, 0.41835387456478074`, 0.5311939168286645], 
     RGBColor[0.5115101765545315, 0.3380149059702385, 0.4833617235141316], 
     RGBColor[
     0.49421921068715247`, 0.27273814583778355`, 0.42263171579355413`], 
     RGBColor[0.47981067087964, 0.2050497168999137, 0.33436964919923845`], 
     RGBColor[0.5390142621238859, 0.42630230042872275`, 0.53592624846201], 
     RGBColor[0.5104917779671998, 0.3347458731725841, 0.4814154076544135], 
     RGBColor[
     0.49421921068715247`, 0.27273814583778355`, 0.42263171579355413`], 
     RGBColor[0.47981067087964, 0.2050497168999137, 0.33436964919923845`], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[
     0.12579225326550314`, 0.029191067040690466`, 0.02978214291745066], 
     RGBColor[0.5094196167389272, 0.33130426370533217`, 0.4793663431439948], 
     RGBColor[0.494179736289942, 0.27255270304023826`, 0.42238990837087925`], 
     
     RGBColor[0.47959041107853684`, 0.20401498054952613`, 0.3330204087145864],
      
     RGBColor[0.6315224215878625, 0.5818052490235994, 0.5458755294765143], 
     RGBColor[0.5085060475501675, 0.3283717305320419, 0.4776203723392908], 
     RGBColor[0.4941086058840103, 0.2722185466655083, 0.42195418645116384`], 
     RGBColor[0.30949391046305225`, 0.0773308161506066, 0.08931796464322225], 
     
     RGBColor[0.7005730564567743, 0.6709596977781245, 0.5291953186141273], 
     RGBColor[0.4939312095532083, 0.2713851742980275, 0.42086751375760834`], 
     RGBColor[0.47609531846885594`, 0.1991095708430815, 0.32367147719984385`],
      
     RGBColor[0.374605840546553, 0.10647117062331843`, 0.1455834159924285], 
     RGBColor[
     0.05717874682033355, 0.013268771235158044`, 0.013537444202145482`], 
     RGBColor[0.5081675635034066, 0.3272852056054478, 0.47697347742342255`], 
     RGBColor[0.4938600791472766, 0.27105101792329755`, 0.42043179183789287`],
      
     RGBColor[0.47508463193019, 0.197713510849518, 0.3209915372652514], 
     RGBColor[0.5089304931197373, 0.32973418969587287`, 0.47843155290642525`],
      
     RGBColor[0.4938206047500661, 0.27086557512575227`, 0.420189984415218], 
     RGBColor[0.4745237432165661, 0.19693875600320804`, 0.3195042828050436], 
     RGBColor[0.5099488917070689, 0.33300322249352726`, 0.48037786876614336`],
      
     RGBColor[0.4938206047500661, 0.27086557512575227`, 0.420189984415218], 
     RGBColor[0.4745237432165661, 0.19693875600320804`, 0.3195042828050436], 
     RGBColor[
     0.07686784450741749, 0.01783777890959158, 0.018198967515466947`], 
     RGBColor[0.5110210529353415, 0.3364448319607792, 0.4824269332765621], 
     RGBColor[
     0.46875792677322814`, 0.18897444129352584`, 0.30421562390747164`], 
     RGBColor[0.47508463193019, 0.197713510849518, 0.3209915372652514], 
     RGBColor[0.428433070452405, 0.13327377001516152`, 0.19729009489674315`], 
     
     RGBColor[
     0.04023261018883959, 0.009336288926835334, 0.009525334950929738], 
     RGBColor[0.5590432961240287, 0.46620445215085454`, 0.545434000335221], 
     RGBColor[0.5119346221241012, 0.33937736513406946`, 0.48417290408126606`],
      
     RGBColor[0.5172363747063347, 0.35639585209189345`, 0.49430536622670107`],
      
     RGBColor[0.4699019576723866, 0.19055468967778139`, 0.30724914021126004`],
      
     RGBColor[0.47609531846885594`, 0.1991095708430815, 0.32367147719984385`],
      
     RGBColor[
     0.42565143889626256`, 0.12943150598591058`, 0.18991431100585615`], 
     RGBColor[0.2844408355922285, 0.06611850096610879, 0.06766874362512876], 
     RGBColor[0.5165865634303871, 0.3543099749119929, 0.49306347723752436`], 
     RGBColor[0.5085060475501675, 0.3283717305320419, 0.4776203723392908], 
     RGBColor[0.5187853670447065, 0.36136807693631356`, 0.49726572810490655`],
      
     RGBColor[0.5094196167389272, 0.33130426370533206`, 0.4793663431439947], 
     RGBColor[0.5190313990799091, 0.3621578333267448, 0.49773593305026925`], 
     RGBColor[0.5402964397732456, 0.4304180571081958, 0.5383766865566497], 
     RGBColor[0.4444095759129742, 0.15534209610555422`, 0.23965345223949497`],
      
     RGBColor[0.4434977544915456, 0.15408259836908397`, 0.23723566339298596`],
      
     RGBColor[0.7565570578641346, 0.7283367040600345, 0.5035200908927833], 
     RGBColor[0.7852478613860518, 0.7577413977676488, 0.49036199401840175`], 
     RGBColor[0.6003530918694783, 0.5320916338223165, 0.5456856518076383], 
     RGBColor[0.5165230744229814, 0.3541061768607368, 0.49294214000908665`], 
     RGBColor[0.4444982773201683, 0.15546461924326205`, 0.2398886531987436], 
     RGBColor[0.3762644815978475, 0.10721348294789135`, 0.14701670459649424`],
      
     RGBColor[0.2665366808277323, 0.061851901980192504`, 0.06310431139507504],
      
     RGBColor[
     0.03040914992182085, 0.007056678857200446, 0.007199566153396941], 
     RGBColor[
     0.11270115570322163`, 0.026153176418203493`, 0.02668273950885398], 
     RGBColor[0.8885654105909873, 0.863629714442772, 0.4429787856595381], 
     RGBColor[0.9034200168838944, 0.8788539359553018, 0.4361662072497505], 
     RGBColor[0.818862297341477, 0.7921922346941376, 0.47494583446953104`], 
     RGBColor[0.8805592848853684, 0.855424378751196, 0.44665053286391787`], 
     RGBColor[0.806902656786826, 0.7799350120236734, 0.480430731707793], 
     RGBColor[0.8500435771787513, 0.8241493732359723, 0.46064556224283526`], 
     RGBColor[0.8026343104913954, 0.7755604599007505, 0.48238826886794184`], 
     RGBColor[0.8179169039259333, 0.7912233178146915, 0.4753794081802367], 
     RGBColor[0.806902656786826, 0.7799350120236734, 0.480430731707793], 
     RGBColor[0.7905423467724255, 0.763167621575108, 0.48793385178945775`], 
     RGBColor[0.818862297341477, 0.7921922346941376, 0.47494583446953104`], 
     RGBColor[0.7733417724893916, 0.7455390592380053, 0.4958223315435456], 
     RGBColor[0.8361444786681327, 0.8099044346372853, 0.4670199283190445], 
     RGBColor[0.5821894136482718, 0.5031214211842054, 0.5455750021109648], 
     RGBColor[0.8029053208801507, 0.7758382136230135, 0.4822639788338032], 
     RGBColor[0.7803998737144338, 0.7527727815184273, 0.49258536470163233`], 
     RGBColor[0.8726084341296609, 0.8472756933716479, 0.45029693002381027`], 
     RGBColor[0.8032606057129595, 0.7762023387225329, 0.48210103908746504`], 
     RGBColor[0.8845680746843113, 0.8595329160421115, 0.4448120327855486], 
     RGBColor[0.8337763134195761, 0.8074773442377562, 0.4681060097085478], 
     RGBColor[0.8888364209797424, 0.8639074681650349, 0.4428544956253994], 
     RGBColor[0.8659029866723946, 0.8404033996590374, 0.4533721637711462], 
     RGBColor[0.8845680746843113, 0.8595329160421115, 0.4448120327855486], 
     RGBColor[0.8932775438259026, 0.8684590958986211, 0.44081772016192505`], 
     RGBColor[0.8726084341296613, 0.8472756933716483, 0.4502969300238101], 
     RGBColor[0.910478118108936, 0.8860876582357231, 0.4329292404078375], 
     RGBColor[0.8553262528030053, 0.8295634934285003, 0.4582228361742967], 
     RGBColor[0.23807017653160426`, 0.05524602909254738, 0.05636467936449113],
      
     RGBColor[0.8644362127448231, 0.8389001291756712, 0.45404485156872076`], 
     RGBColor[0.47983209761282153`, 0.20515037539312, 0.33450090245433783`], 
     RGBColor[
     0.21740016576042223`, 0.05044939293658437, 0.051470918429997986`], 
     RGBColor[
     0.11600410421509155`, 0.026919651212469572`, 0.027464734282585147`], 
     RGBColor[0.20812469359832728`, 0.04829694775264851, 0.04927488941877347],
      
     RGBColor[0.8794331276530577, 0.8542702002543333, 0.4471670079757847], 
     RGBColor[0.5120074511239598, 0.33961114431652306`, 0.4843120914674581], 
     RGBColor[0.5038900757768039, 0.31355458201290465`, 0.4687985424759477], 
     RGBColor[0.8877557875376043, 0.8627999461901972, 0.44335009274265996`], 
     RGBColor[0.5121576026909126, 0.3400931269145879, 0.48459905413586407`], 
     RGBColor[0.504077315272128, 0.31415561588986074`, 0.4691563858624646], 
     RGBColor[0.8877557875376043, 0.8627999461901972, 0.44335009274265996`], 
     RGBColor[0.5104917779671998, 0.3347458731725841, 0.4814154076544135], 
     RGBColor[0.8794331276530577, 0.8542702002543333, 0.4471670079757847], 
     RGBColor[0.5115101765545315, 0.3380149059702385, 0.4833617235141316], 
     RGBColor[0.8644362127448231, 0.8389001291756712, 0.45404485156872076`], 
     RGBColor[0.7166850453279396, 0.6874725883081926, 0.5218060828876409], 
     RGBColor[0.5870334899635955, 0.5108474951203933, 0.54560451130885], 
     RGBColor[0.5122731061708621, 0.34046389006066363`, 0.48481979899713434`],
      
     RGBColor[0.4589692728256294, 0.1754533864023442, 0.27825999511805233`], 
     RGBColor[0.20812469359832728`, 0.04829694775264851, 0.04927488941877347],
      
     RGBColor[0.8270345187263147, 0.8005677988901142, 0.4711979129246205], 
     RGBColor[0.7308527554177204, 0.7019928221318998, 0.515308526912707], 
     RGBColor[0.8120376038180802, 0.7851977278114523, 0.4780757565175566], 
     RGBColor[0.5119346221241012, 0.33937736513406946`, 0.48417290408126606`],
      
     RGBColor[0.8037149439335332, 0.7766679818755879, 0.4818926717506815], 
     RGBColor[0.5110210529353415, 0.3364448319607793, 0.48242693327656216`], 
     RGBColor[0.8037149439335332, 0.7766679818755879, 0.4818926717506815], 
     RGBColor[0.5099488917070689, 0.33300322249352726`, 0.48037786876614336`],
      
     RGBColor[0.8120376038180802, 0.7851977278114523, 0.4780757565175566], 
     RGBColor[0.5089304931197373, 0.32973418969587287`, 0.47843155290642525`],
      
     RGBColor[0.8270345187263147, 0.8005677988901142, 0.4711979129246205], 
     RGBColor[0.6581710014709584, 0.6243084808203194, 0.5460378675913463], 
     RGBColor[0.5081675635034066, 0.3272852056054478, 0.47697347742342255`], 
     RGBColor[0.5005229023871786, 0.30235162460688014`, 0.46124609754566237`],
      
     RGBColor[
     0.17264780090002868`, 0.040064259918004094`, 0.04087550184776202], 
     RGBColor[0.7734526678311969, 0.7456527138993987, 0.49577147302892516`], 
     RGBColor[0.7226441902577939, 0.6935800098479131, 0.5190731163391229], 
     RGBColor[0.8123772155539173, 0.7855457898329349, 0.4779200047235573], 
     RGBColor[0.7308527554177197, 0.7019928221318991, 0.5153085269127073], 
     RGBColor[
     0.11917616751310207`, 0.0276557530787276, 0.028215741121497197`], 
     RGBColor[0., 0., 0.], 
     RGBColor[0.5035603213440935, 0.3124960789188195, 0.46816833119111234`], 
     RGBColor[0.17964426107351622`, 0.04168784271161802, 0.04253195978848483],
      
     RGBColor[0.6421339653509107, 0.5987301623308177, 0.5459401729966383], 
     RGBColor[0.4353487496865451, 0.14282638869339676`, 0.21562773396223173`],
      
     RGBColor[0.8374815963417809, 0.8112748227344547, 0.4664067031136622], 
     RGBColor[0.585629877594771, 0.50860879939527, 0.5455959607674362], 
     RGBColor[0.5886792399855696, 0.5134723890160635, 0.5456145369071079], 
     RGBColor[0.44185470906395824`, 0.15181306186957744`, 0.2328789584332532],
      
     RGBColor[0.2376529995088365, 0.05514921993202026, 0.056265909961833865`],
      
     RGBColor[0.16930132843127463`, 0.03928768505230834, 0.04008320249111254],
      
     RGBColor[0.7047209295771788, 0.6752107790889136, 0.5272930325279522], 
     RGBColor[0.7652104805159311, 0.7372054428670264, 0.4995514821551324]},
   VertexNormals->CompressedData["
1:eJxUunc81/37/o80tERDJCUaSqmUUjibmqKsys6mQaGiklRmSRES2TuEZJ/2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    "]],
  Boxed->False,
  Lighting->"Neutral",
  Method->{},
  PlotRange->{{-1.0178277469192367`, 
   1.017827746919237}, {-1.0838382253663816`, 
   1.0838382253663816`}, {-1.0838382253663816`, 1.0838382253663816`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->926589344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<model.jvx\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1191761397],

Cell[BoxData["\<\"model.jvx\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->353823810]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JVX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 2.4027238}", "context" -> "", 
    "keywords" -> {
     "JavaView", "XML", "modelling", "rendering", "3D graphics", "geometry"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "JavaView 3D geometry format. Native format of the JavaView visualization \
software. Used for the visualization of 2D or 3D geometries. Can be embedded \
in web pages and viewed with the JavaView applet. XML format. Can store \
multiple geometries. Represents 2D or 3D objects as a collection of polygons, \
lines and points.", "synonyms" -> {}, "title" -> "JVX", "type" -> "Format", 
    "uri" -> "ref/format/JVX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[28297, 936, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 610836, 10972}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3052, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3675, 88, 102, 4, 70, "ObjectNameAlt",
 CellID->30422],
Cell[3780, 94, 364, 9, 70, "FormatUsage",
 CellID->27666],
Cell[4147, 105, 323, 12, 70, "FormatNotes",
 CellID->8486]
}, Open  ]],
Cell[CellGroupData[{
Cell[4507, 122, 63, 1, 70, "ImportExportSection",
 CellID->3455],
Cell[4573, 125, 633, 22, 70, "FormatNotes",
 CellID->2028],
Cell[5209, 149, 576, 21, 70, "FormatNotes",
 CellID->29614],
Cell[5788, 172, 38, 1, 70, "WeakDivider",
 CellID->4860],
Cell[5829, 175, 925, 27, 70, "FormatNotes",
 CellID->29253],
Cell[6757, 204, 434, 14, 70, "FormatNotes",
 CellID->1933090223],
Cell[7194, 220, 39, 1, 70, "WeakDivider",
 CellID->11777],
Cell[7236, 223, 341, 11, 70, "FormatNotes",
 CellID->31348],
Cell[7580, 236, 574, 20, 70, "FormatNotes",
 CellID->12503],
Cell[8157, 258, 582, 21, 70, "FormatNotes",
 CellID->10861],
Cell[8742, 281, 694, 25, 70, "FormatNotes",
 CellID->22431],
Cell[9439, 308, 39, 1, 70, "WeakDivider",
 CellID->29082],
Cell[9481, 311, 514, 18, 70, "FormatNotes",
 CellID->12455],
Cell[9998, 331, 1039, 38, 70, "FormatNotes",
 CellID->14197],
Cell[11040, 371, 662, 22, 70, "FormatNotes",
 CellID->22106],
Cell[11705, 395, 815, 28, 70, "FormatNotes",
 CellID->8752],
Cell[12523, 425, 39, 1, 70, "WeakDivider",
 CellID->15821],
Cell[12565, 428, 361, 14, 70, "FormatNotes",
 CellID->17296],
Cell[12929, 444, 342, 12, 70, "FormatNotes",
 CellID->26281]
}, Closed]],
Cell[CellGroupData[{
Cell[13308, 461, 51, 1, 70, "ElementsSection",
 CellID->26021],
Cell[13362, 464, 192, 8, 70, "FormatNotes",
 CellID->24455],
Cell[13557, 474, 668, 13, 70, "2ColumnTableMod",
 CellID->15947],
Cell[14228, 489, 39, 1, 70, "WeakDivider",
 CellID->27124],
Cell[14270, 492, 68, 1, 70, "FormatNotes",
 CellID->18318],
Cell[14341, 495, 3190, 79, 70, "2ColumnTableMod",
 CellID->9135],
Cell[17534, 576, 526, 16, 70, "FormatNotes",
 CellID->1774],
Cell[18063, 594, 455, 16, 70, "FormatNotes",
 CellID->1495251562],
Cell[18521, 612, 212, 7, 70, "FormatNotes",
 CellID->528086330],
Cell[18736, 621, 511, 11, 70, "2ColumnTableMod",
 CellID->2144518906]
}, Open  ]],
Cell[CellGroupData[{
Cell[19284, 637, 48, 1, 70, "OptionsSection",
 CellID->9253],
Cell[19335, 640, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[19534, 650, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[20692, 683, 240, 8, 70, "FormatNotes",
 CellID->1022956994],
Cell[20935, 693, 340, 13, 70, "FormatNotes",
 CellID->6922],
Cell[21278, 708, 1047, 20, 70, "3ColumnTableMod",
 CellID->10635],
Cell[22328, 730, 182, 7, 70, "FormatNotes",
 CellID->1711205541],
Cell[22513, 739, 489, 13, 70, "3ColumnTableMod",
 CellID->1130526963],
Cell[23005, 754, 61, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[23069, 757, 707, 17, 70, "3ColumnTableMod",
 CellID->28047],
Cell[23779, 776, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[24025, 785, 759, 26, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[24821, 816, 49, 1, 70, "SeeAlsoSection",
 CellID->4747],
Cell[24873, 819, 2676, 90, 70, "SeeAlso",
 CellID->1919681360]
}, Open  ]],
Cell[CellGroupData[{
Cell[27586, 914, 58, 1, 70, "MoreAboutSection",
 CellID->202849061],
Cell[27647, 917, 150, 2, 70, "MoreAbout"],
Cell[27800, 921, 133, 2, 70, "MoreAbout"],
Cell[27936, 925, 165, 2, 70, "MoreAbout"],
Cell[28104, 929, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28297, 936, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[28413, 942, 60, 1, 70, "ExampleSection",
 CellID->205660043],
Cell[28476, 945, 96, 1, 70, "ExampleText",
 CellID->58856465],
Cell[CellGroupData[{
Cell[28597, 950, 138, 4, 70, "Input",
 CellID->1393707212],
Cell[28738, 956, 168374, 2840, 70, "Output",
 CellID->1030756294]
}, Open  ]],
Cell[197127, 3799, 126, 3, 70, "ExampleDelimiter",
 CellID->1358129635],
Cell[197256, 3804, 99, 1, 70, "ExampleText",
 CellID->481091482],
Cell[CellGroupData[{
Cell[197380, 3809, 211, 5, 70, "Input",
 CellID->255789605],
Cell[197594, 3816, 66941, 1233, 70, "Output",
 CellID->1555561380]
}, Open  ]],
Cell[264550, 5052, 125, 3, 70, "ExampleDelimiter",
 CellID->334556127],
Cell[264678, 5057, 243, 8, 70, "ExampleText",
 CellID->883938850],
Cell[CellGroupData[{
Cell[264946, 5069, 701, 21, 70, "Input",
 CellID->68382004],
Cell[265650, 5092, 343561, 5831, 70, "Output",
 CellID->926589344]
}, Open  ]],
Cell[CellGroupData[{
Cell[609248, 10928, 142, 4, 70, "Input",
 CellID->1191761397],
Cell[609393, 10934, 87, 2, 70, "Output",
 CellID->353823810]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[609519, 10941, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

