(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20374,        722]
NotebookOptionsPosition[     15663,        575]
NotebookOutlinePosition[     17127,        614]
CellTagsIndexPosition[     17042,        609]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "Mathematical Data Formats" :> 
         Documentation`HelpLookup["paclet:guide/MathematicalDataFormats"], 
         "Matrices and Linear Algebra" :> 
         Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
         "Numerical Data Formats" :> 
         Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
         "Signal Processing" :> 
         Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
         "Sparse Arrays" :> 
         Documentation`HelpLookup["paclet:guide/SparseArrays"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
      2->"\<\"Listing of All Formats\"\>", 
      3->"\<\"Mathematical Data Formats\"\>", 
      4->"\<\"Matrices and Linear Algebra\"\>", 
      5->"\<\"Numerical Data Formats\"\>", 6->"\<\"Signal Processing\"\>", 
      7->"\<\"Sparse Arrays\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MAT ",
 StyleBox["(.mat)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MATLAB MAT-files.\nMatrix data format.\nStores matrices of numbers, Boolean \
values, or strings.\nBinary format.\nMAT Level 4 files are compatible with \
MATLAB Version 4 and earlier, while MAT Level 5 files are compatible with \
MATLAB 5 and later versions.\n",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is compatible with MAT levels 4 and 5.\nDeveloped by The MathWorks."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports MAT Level 4 and 5 files. "
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 "When appropriate, numerical data is imported as ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects."
}], "FormatNotes",
 CellID->2112839838],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " generates MAT 4 files."
}], "FormatNotes",
 CellID->56646289]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", "]"}]], "InlineFormula"],
 " imports a MAT-file, returning an array."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports any numeric array to a MAT-file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a multidimensional array containing numbers, strings, or Boolean \
values."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a MAT-file from an array of integers or doubles."
}], "FormatNotes",
 CellID->7572],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a MAT-file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<MAT\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MAT\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a MAT-file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "MAT",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "numerical or textual data given as a multidimensional array", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391],

Cell["Meta-information element:", "FormatNotes",
 CellID->916578390],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "user comments stored in the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1032800799]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->36816911],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout"],

Cell[TextData[ButtonBox["Sparse Arrays",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SparseArrays"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->51941011],

Cell["This imports a simple MAT-file:", "ExampleText",
 CellID->1232037135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/numbers.mat\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "10"}], "}"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1488109147]
}, Open  ]],

Cell["Import raw meta-information from this file:", "ExampleText",
 CellID->810803571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/numbers.mat\>\"", ",", " ", "\"\<Comments\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1055880667],

Cell[BoxData["\<\"MATLAB 5.0 MAT-file, Platform: GLNX86, Created on: Fri Jun  \
4 15:44:05 2004                                                 \"\>"], \
"Output",
 CellLabel->"Out[2]=",
 CellID->1528995108]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MAT - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 5.4809276}", "context" -> "", 
    "keywords" -> {"MATLAB", "The MathWorks"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MATLAB MAT-files. Matrix data format. Stores matrices of numbers, \
Boolean values, or strings. Binary format. MAT Level 4 files are compatible \
with MATLAB Version 4 and earlier, while MAT Level 5 files are compatible \
with MATLAB 5 and later versions. Mathematica is compatible with MAT levels 4 \
and 5. Developed by The MathWorks.", "synonyms" -> {}, "title" -> "MAT", 
    "type" -> "Format", "uri" -> "ref/format/MAT"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14411, 522, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16908, 602}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1513, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2136, 58, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2246, 64, 440, 9, 70, "FormatUsage",
 CellID->37585799],
Cell[2689, 75, 214, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[2906, 84, 246, 8, 70, "FormatNotes",
 CellID->2112839838],
Cell[3155, 94, 195, 7, 70, "FormatNotes",
 CellID->56646289]
}, Open  ]],
Cell[CellGroupData[{
Cell[3387, 106, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3454, 109, 286, 9, 70, "FormatNotes",
 CellID->28652],
Cell[3743, 120, 334, 11, 70, "FormatNotes",
 CellID->8194],
Cell[4080, 133, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4122, 136, 350, 11, 70, "FormatNotes",
 CellID->28396],
Cell[4475, 149, 373, 12, 70, "FormatNotes",
 CellID->7572],
Cell[4851, 163, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4893, 166, 341, 11, 70, "FormatNotes",
 CellID->29174],
Cell[5237, 179, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[5814, 201, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[6397, 224, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[7103, 251, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[7144, 254, 519, 18, 70, "FormatNotes",
 CellID->20289],
Cell[7666, 274, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[8744, 316, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[9408, 340, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[10226, 370, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[10267, 373, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[10631, 389, 352, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[11020, 408, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[11079, 411, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[11278, 421, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[11991, 437, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[12035, 440, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[12109, 443, 397, 10, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[12509, 455, 382, 14, 70, "FormatNotes",
 CellID->1999285391],
Cell[12894, 471, 68, 1, 70, "FormatNotes",
 CellID->916578390],
Cell[12965, 474, 368, 9, 70, "2ColumnTableMod",
 CellID->1032800799]
}, Open  ]],
Cell[CellGroupData[{
Cell[13370, 488, 57, 1, 70, "MoreAboutSection",
 CellID->36816911],
Cell[13430, 491, 134, 2, 70, "MoreAbout"],
Cell[13567, 495, 133, 2, 70, "MoreAbout"],
Cell[13703, 499, 140, 2, 70, "MoreAbout"],
Cell[13846, 503, 143, 2, 70, "MoreAbout"],
Cell[13992, 507, 134, 2, 70, "MoreAbout"],
Cell[14129, 511, 125, 2, 70, "MoreAbout"],
Cell[14257, 515, 117, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14411, 522, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14527, 528, 59, 1, 70, "ExampleSection",
 CellID->51941011],
Cell[14589, 531, 75, 1, 70, "ExampleText",
 CellID->1232037135],
Cell[CellGroupData[{
Cell[14689, 536, 132, 3, 70, "Input",
 CellID->976592890],
Cell[14824, 541, 258, 8, 70, "Output",
 CellID->1488109147]
}, Open  ]],
Cell[15097, 552, 86, 1, 70, "ExampleText",
 CellID->810803571],
Cell[CellGroupData[{
Cell[15208, 557, 179, 5, 70, "Input",
 CellID->1055880667],
Cell[15390, 564, 207, 4, 70, "Output",
 CellID->1528995108]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[15636, 573, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

