(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    243897,       5892]
NotebookOptionsPosition[    234832,       5656]
NotebookOutlinePosition[    239405,       5738]
CellTagsIndexPosition[    239318,       5733]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"AIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/AIFF"], "\"AU\"" :> 
          Documentation`HelpLookup["paclet:ref/format/AU"], "\"FLAC\"" :> 
          Documentation`HelpLookup["paclet:ref/format/FLAC"], "\"SND\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SND"], "\"WAV\"" :> 
          Documentation`HelpLookup["paclet:ref/format/WAV"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"AIFF\\\"\"\>", 
       2->"\<\"\\\"AU\\\"\"\>", 3->"\<\"\\\"FLAC\\\"\"\>", 
       4->"\<\"\\\"SND\\\"\"\>", 
       5->"\<\"\\\"WAV\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Audio Formats" :> 
          Documentation`HelpLookup["paclet:guide/AudioFormats"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"], 
          "Sound and Sonification" :> 
          Documentation`HelpLookup["paclet:guide/SoundAndSonification"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Audio Formats\"\>", 
       2->"\<\"Creating Web Pages\"\>", 3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: Import & Export Formats\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>", 
       8->"\<\"Sound and Sonification\"\>", 
       9->"\<\"Web Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MIDI ",
 StyleBox["(.mid)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->6504],

Cell[TextData[{
 "MIME type: ",
 StyleBox["audio/midi", "InlineCode"],
 "\nStandard MIDI file format.\nAudio format.\nUsed for controlling \
electronic musical instruments, computer sound cards and sequencers.\nStores \
a sequence of discrete sound events such as the beginning and end of a note, \
velocity and timbre information, and instrument and sound bank codes.\nMIDI \
is an acronym for Musical Instrument Digital Interface.\nBinary file format. \
\nIntroduced in 1983.\nDeveloped and published by the MIDI Manufacturers \
Association (U.S.) and the Association of Musical Electronic Industry MIDI \
committee (Japan)."
}], "FormatUsage",
 CellID->28822],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully supports the standard MIDI file format."
}], "FormatNotes",
 CellID->4055]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mid\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a sound object to MIDI."
}], "FormatNotes",
 CellID->6748],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mid\>\"", ",", 
     RowBox[{
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "creates a MIDI file from a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " expression consisting of ",
 Cell[BoxData[
  ButtonBox["SoundNote",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SoundNote"]], "InlineFormula"],
 " primitives."
}], "FormatNotes",
 CellID->2144],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mid\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "MIDI",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 "The file format can be explicitly specified using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["Sound",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sound"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", "\"\<MIDI\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1064434895],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general information on",
 " ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the ",
 "MIDI",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Sound\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " expression consisting of ",
     Cell[BoxData[
      ButtonBox["SoundNote",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SoundNote"]], "InlineFormula"],
     " primitives"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Sound\>\""], "InlineFormula"],
 " element for ",
 "MIDI",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mid\>\"", ",", " ", 
    RowBox[{
     ButtonBox["Sound",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sound"], "[", " ", 
     RowBox[{
      ButtonBox["SoundNote",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SoundNote"], "[", "0", "]"}], "]"}]}], "]"}]], 
  "InlineFormula"],
 " creates a MIDI file representing the \"middle C\" note played for 1 second \
in the default ",
 Cell[BoxData["\"\<Piano\>\""], "InlineFormula"],
 " style. "
}], "FormatNotes",
 CellID->1386544544],

Cell[TextData[{
 "The pitch specification 0 in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " corresponds to MIDI pitch level 60."
}], "FormatNotes",
 CellID->1371583565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mid\>\"", ",", 
    RowBox[{
     ButtonBox["Sound",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sound"], "[", 
     RowBox[{
      ButtonBox["SoundNote",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SoundNote"], "[", 
      RowBox[{
       StyleBox["pitch", "TI"], ",", 
       StyleBox["t", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\!\(\*
StyleBox[\"\\\"\<\>\", \"TI\"]\)\>"}], "]"}], "]"}]}], "]"}]], 
  "InlineFormula"],
 " specifies a duration",
 Cell[BoxData[
  RowBox[{" ", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " and an instrument style. The following General MIDI styles are supported:"
}], "FormatNotes",
 CellID->618201289],

Cell[BoxData[GridBox[{
   {"\"\<Accordion\>\"", "\"\<Agogo\>\"", "\"\<AltoSax\>\"", 
    "\"\<Applause\>\""},
   {"\"\<Atmosphere\>\"", "\"\<Bagpipe\>\"", "\"\<Bandoneon\>\"", 
    "\"\<Banjo\>\""},
   {"\"\<BaritoneSax\>\"", "\"\<Bass\>\"", "\"\<BassAndLead\>\"", 
    "\"\<Bassoon\>\""},
   {"\"\<Bird\>\"", "\"\<BlownBottle\>\"", "\"\<Bowed\>\"", 
    "\"\<BrassSection\>\""},
   {"\"\<Breath\>\"", "\"\<Brightness\>\"", "\"\<BrightPiano\>\"", 
    "\"\<Calliope\>\""},
   {"\"\<Celesta\>\"", "\"\<Cello\>\"", "\"\<Charang\>\"", "\"\<Chiff\>\""},
   {"\"\<Choir\>\"", "\"\<Clarinet\>\"", "\"\<Clavi\>\"", 
    "\"\<Contrabass\>\""},
   {"\"\<Crystal\>\"", "\"\<DrawbarOrgan\>\"", "\"\<Dulcimer\>\"", 
    "\"\<Echoes\>\""},
   {"\"\<ElectricBass\>\"", "\"\<ElectricGrandPiano\>\"", 
    "\"\<ElectricGuitar\>\"", "\"\<ElectricPiano\>\""},
   {"\"\<ElectricPiano2\>\"", "\"\<EnglishHorn\>\"", "\"\<Fiddle\>\"", 
    "\"\<Fifths\>\""},
   {"\"\<Flute\>\"", "\"\<FrenchHorn\>\"", "\"\<FretlessBass\>\"", 
    "\"\<FretNoise\>\""},
   {"\"\<Glockenspiel\>\"", "\"\<Goblins\>\"", "\"\<Guitar\>\"", 
    "\"\<GuitarDistorted\>\""},
   {"\"\<GuitarHarmonics\>\"", "\"\<GuitarMuted\>\"", 
    "\"\<GuitarOverdriven\>\"", "\"\<Gunshot\>\""},
   {"\"\<Halo\>\"", "\"\<Harmonica\>\"", "\"\<Harp\>\"", 
    "\"\<Harpsichord\>\""},
   {"\"\<Helicopter\>\"", "\"\<HonkyTonkPiano\>\"", "\"\<JazzGuitar\>\"", 
    "\"\<Kalimba\>\""},
   {"\"\<Koto\>\"", "\"\<Marimba\>\"", "\"\<MelodicTom\>\"", 
    "\"\<Metallic\>\""},
   {"\"\<MusicBox\>\"", "\"\<MutedTrumpet\>\"", "\"\<NewAge\>\"", 
    "\"\<Oboe\>\""},
   {"\"\<Ocarina\>\"", "\"\<OrchestraHit\>\"", "\"\<Organ\>\"", 
    "\"\<PanFlute\>\""},
   {"\"\<PercussiveOrgan\>\"", "\"\<Piano\>\"", "\"\<Piccolo\>\"", 
    "\"\<PickedBass\>\""},
   {"\"\<PizzicatoStrings\>\"", "\"\<Polysynth\>\"", "\"\<Rain\>\"", 
    "\"\<Recorder\>\""},
   {"\"\<ReedOrgan\>\"", "\"\<ReverseCymbal\>\"", "\"\<RockOrgan\>\"", 
    "\"\<Sawtooth\>\""},
   {"\"\<SciFi\>\"", "\"\<Seashore\>\"", "\"\<Shakuhachi\>\"", 
    "\"\<Shamisen\>\""},
   {"\"\<Shanai\>\"", "\"\<Sitar\>\"", "\"\<SlapBass\>\"", 
    "\"\<SlapBass2\>\""},
   {"\"\<SopranoSax\>\"", "\"\<Soundtrack\>\"", "\"\<Square\>\"", 
    "\"\<Steeldrums\>\""},
   {"\"\<SteelGuitar\>\"", "\"\<Strings\>\"", "\"\<Strings2\>\"", 
    "\"\<Sweep\>\""},
   {"\"\<SynthBass\>\"", "\"\<SynthBass2\>\"", "\"\<SynthBrass\>\"", 
    "\"\<SynthBrass2\>\""},
   {"\"\<SynthDrum\>\"", "\"\<SynthStrings\>\"", "\"\<SynthStrings2\>\"", 
    "\"\<SynthVoice\>\""},
   {"\"\<Taiko\>\"", "\"\<Telephone\>\"", "\"\<TenorSax\>\"", 
    "\"\<Timpani\>\""},
   {"\"\<Tinklebell\>\"", "\"\<TremoloStrings\>\"", "\"\<Trombone\>\"", 
    "\"\<Trumpet\>\""},
   {"\"\<Tuba\>\"", "\"\<TubularBells\>\"", "\"\<Vibraphone\>\"", 
    "\"\<Viola\>\""},
   {"\"\<Violin\>\"", "\"\<Voice\>\"", "\"\<VoiceAahs\>\"", 
    "\"\<VoiceOohs\>\""},
   {"\"\<Warm\>\"", "\"\<Whistle\>\"", "\"\<Woodblock\>\"", 
    "\"\<Xylophone\>\""}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "FormatNotes",
 CellID->747554645],

Cell[TextData[{
 "Percussion sounds are represented as an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SoundNote",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SoundNote"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"perc\", \"TI\"]\)\>\"", ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
 ". Possible percussion styles include:"
}], "FormatNotes",
 CellID->302945816],

Cell[BoxData[GridBox[{
   {"\"\<BassDrum\>\"", "\"\<BassDrum2\>\"", "\"\<BellTree\>\"", 
    "\"\<Cabasa\>\""},
   {"\"\<Castanets\>\"", "\"\<ChineseCymbal\>\"", "\"\<Clap\>\"", 
    "\"\<Claves\>\""},
   {"\"\<Cowbell\>\"", "\"\<CrashCymbal\>\"", "\"\<CrashCymbal2\>\"", 
    "\"\<ElectricSnare\>\""},
   {"\"\<GuiroLong\>\"", "\"\<GuiroShort\>\"", "\"\<HighAgogo\>\"", 
    "\"\<HighBongo\>\""},
   {"\"\<HighCongaMute\>\"", "\"\<HighCongaOpen\>\"", "\"\<HighFloorTom\>\"", 
    "\"\<HighTimbale\>\""},
   {"\"\<HighTom\>\"", "\"\<HighWoodblock\>\"", "\"\<HiHatClosed\>\"", 
    "\"\<HiHatOpen\>\""},
   {"\"\<HiHatPedal\>\"", "\"\<JingleBell\>\"", "\"\<LowAgogo\>\"", 
    "\"\<LowBongo\>\""},
   {"\"\<LowConga\>\"", "\"\<LowFloorTom\>\"", "\"\<LowTimbale\>\"", 
    "\"\<LowTom\>\""},
   {"\"\<LowWoodblock\>\"", "\"\<Maracas\>\"", "\"\<MetronomeBell\>\"", 
    "\"\<MetronomeClick\>\""},
   {"\"\<MidTom\>\"", "\"\<MidTom2\>\"", "\"\<MuteCuica\>\"", 
    "\"\<MuteSurdo\>\""},
   {"\"\<MuteTriangle\>\"", "\"\<OpenCuica\>\"", "\"\<OpenSurdo\>\"", 
    "\"\<OpenTriangle\>\""},
   {"\"\<RideBell\>\"", "\"\<RideCymbal\>\"", "\"\<RideCymbal2\>\"", 
    "\"\<ScratchPull\>\""},
   {"\"\<ScratchPush\>\"", "\"\<Shaker\>\"", "\"\<SideStick\>\"", 
    "\"\<Slap\>\""},
   {"\"\<Snare\>\"", "\"\<SplashCymbal\>\"", "\"\<SquareClick\>\"", 
    "\"\<Sticks\>\""},
   {"\"\<Tambourine\>\"", "\"\<Vibraslap\>\"", "\"\<WhistleLong\>\"", 
    "\"\<WhistleShort\>\""}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "FormatNotes",
 CellID->1210894350]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->13924],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<AIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/AIFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<AU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/AU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<FLAC\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/FLAC"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SND\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SND"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<WAV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/WAV"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1616376566]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Audio Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AudioFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout"],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->17951026],

Cell["A sequence of three notes, each played for 1.75 seconds:", "ExampleText",
 CellID->825290042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sound", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"SoundNote", "[", 
      RowBox[{"#", ",", "1.75", ",", " ", "\"\<Trumpet\>\""}], "]"}], "&"}], "/@",
     
    RowBox[{"{", 
     RowBox[{"0", ",", "7", ",", "12"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1030223162],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[0.0027707033834458716`, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, {1.7, 0.4438917279327484}],
           RectangleBox[{1.75, 0.5153202993613198}, \
{3.45, 0.5272250612660818}], 
          RectangleBox[{3.5, 0.5748441088851295}, {5.2, 0.5867488707898912}]},
         
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"5.25\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"5.25", " s"}]],
       Row[{
         Row[{"5.25", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 56], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 4] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 56], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 4]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {-164, 0}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[0, 1.75, "Trumpet"], 
    SoundNote[7, 1.75, "Trumpet"], 
    SoundNote[12, 1.75, "Trumpet"]}]]], "Output",
 CellLabel->"Out[1]=",
 CellID->758109956]
}, Open  ]],

Cell["Export to a MIDI file:", "ExampleText",
 CellID->1505946036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<sequence.mid\>\"", ",", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50119766],

Cell[BoxData["\<\"sequence.mid\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->223916584]
}, Open  ]],

Cell["This exports some chord notes to MIDI:", "ExampleText",
 CellID->604102001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "12"}], ",", "0", ",", "4", ",", "7", ",", "12", ",", 
        "16"}], "}"}], ",", "0.2", ",", "\"\<Trumpet\>\""}], "]"}], ",", 
    RowBox[{"SoundNote", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "12"}], ",", "0", ",", "3", ",", "7", ",", "12", ",", 
        "15"}], "}"}], ",", "2.2", ",", "\"\<Trumpet\>\""}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11791075],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[0.0027707033834458716`, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.2891298231708436}, {0.19, 0.3010345850756056}], 
          RectangleBox[{0.2, 0.2891298231708436}, {2.35, 0.3010345850756056}],
           RectangleBox[{0., 0.43198696602798653`}, \
{0.19, 0.4438917279327484}], 
          RectangleBox[{0.2, 0.43198696602798653`}, \
{2.35, 0.4438917279327484}], 
          RectangleBox[{0.2, 0.4677012517422721}, {2.35, 0.4796060136470343}],
           RectangleBox[{0., 0.4796060136470343}, \
{0.19, 0.49151077555179606`}], 
          RectangleBox[{0., 0.5153202993613198}, {0.19, 0.5272250612660818}], 
          RectangleBox[{0.2, 0.5153202993613198}, {2.35, 0.5272250612660818}],
           RectangleBox[{0., 0.5748441088851295}, {0.19, 0.5867488707898912}],
           RectangleBox[{0.2, 0.5748441088851295}, \
{2.35, 0.5867488707898912}], 
          RectangleBox[{0.2, 0.610558394599415}, {2.35, 0.6224631565041769}], 
          RectangleBox[{0., 0.6224631565041769}, {0.19, 0.6343679184089389}]},
         
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"2.4\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"2.4", " s"}]],
       Row[{
         Row[{"2.4", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 56], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 56], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 48, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 63, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 75, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[{-12, 0, 4, 7, 12, 16}, 0.2, "Trumpet"], 
    SoundNote[{-12, 0, 3, 7, 12, 15}, 2.2, "Trumpet"]}]]], "Output",
 CellLabel->"Out[3]=",
 CellID->418186997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<chords.mid\>\"", ",", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->403584092],

Cell[BoxData["\<\"chords.mid\"\>"], "Output",
 CellLabel->"Out[4]=",
 CellID->1284477018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2073020129],

Cell["Export a few percussion sounds to MIDI:", "ExampleText",
 CellID->474619175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<perc.mid\>\"", ",", 
   RowBox[{"Sound", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"SoundNote", "[", 
       RowBox[{"\"\<RideCymbal1\>\"", ",", " ", "#"}], "]"}], " ", "&"}], " ",
      "/@", " ", 
     RowBox[{"{", 
      RowBox[{"0.26", ",", "0.1", ",", "0.26", ",", "0.1", ",", "2"}], 
      "}"}]}], " ", "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1170209267],

Cell[BoxData["\<\"perc.mid\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1450115717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1973688171],

Cell[TextData[{
 "This creates a musical fragment in the style of Wolfram",
 StyleBox["Tones",
  FontSlant->"Italic"],
 " by taking cellular-automaton data and mapping it to musical notes:"
}], "ExampleText",
 CellID->1744678435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SoundNote", "[", 
     RowBox[{"#", ",", " ", 
      RowBox[{"1", "/", "5"}], ",", "\"\<Harpsichord\>\""}], "]"}], "&"}], 
   "  ", "/@", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Pick", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "4", ",", "7", ",", "12", ",", "16"}], "}"}], ",", 
        "#", ",", "1"}], "]"}], "&"}], " ", "/@", 
     RowBox[{"CellularAutomaton", "[", " ", 
      RowBox[{"60", ",", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         "0"}], "}"}], ",", " ", "15", ",", " ", 
       RowBox[{"{", 
        RowBox[{"15", ",", "4"}], "}"}]}], "]"}]}], ")"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1068740907],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[-0.14074811787423214`, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.43198696602798653`}, \
{0.19, 0.4438917279327484}], 
          RectangleBox[{0.2, 0.43198696602798653`}, \
{0.39, 0.4438917279327484}], 
          RectangleBox[{0.4, 0.43198696602798653`}, \
{0.59, 0.4438917279327484}], 
          RectangleBox[{0.6, 0.43198696602798653`}, \
{0.79, 0.4438917279327484}], 
          RectangleBox[{0.8, 0.43198696602798653`}, \
{0.99, 0.4438917279327484}], 
          RectangleBox[{1., 0.43198696602798653`}, \
{1.19, 0.4438917279327484}], 
          RectangleBox[{1.2, 0.43198696602798653`}, \
{1.39, 0.4438917279327484}], 
          RectangleBox[{1.4, 0.43198696602798653`}, \
{1.59, 0.4438917279327484}], 
          RectangleBox[{1.6, 0.43198696602798653`}, \
{1.79, 0.4438917279327484}], 
          RectangleBox[{1.8, 0.43198696602798653`}, \
{1.99, 0.4438917279327484}], 
          RectangleBox[{2., 0.43198696602798653`}, \
{2.1900000000000004`, 0.4438917279327484}], 
          RectangleBox[{2.2, 0.43198696602798653`}, \
{2.39, 0.4438917279327484}], 
          RectangleBox[{2.4, 0.43198696602798653`}, \
{2.59, 0.4438917279327484}], 
          RectangleBox[{2.6, 0.43198696602798653`}, \
{2.79, 0.4438917279327484}], 
          RectangleBox[{2.8, 0.43198696602798653`}, \
{2.99, 0.4438917279327484}], 
          RectangleBox[{3., 0.43198696602798653`}, \
{3.1900000000000004`, 0.4438917279327484}], 
          RectangleBox[{0.2, 0.4796060136470343}, \
{0.39, 0.49151077555179606`}], 
          RectangleBox[{0.6, 0.4796060136470343}, \
{0.79, 0.49151077555179606`}], 
          RectangleBox[{1., 0.4796060136470343}, \
{1.19, 0.49151077555179606`}], 
          RectangleBox[{1.4, 0.4796060136470343}, \
{1.59, 0.49151077555179606`}], 
          RectangleBox[{1.8, 0.4796060136470343}, \
{1.99, 0.49151077555179606`}], 
          RectangleBox[{2.2, 0.4796060136470343}, \
{2.39, 0.49151077555179606`}], 
          RectangleBox[{2.6, 0.4796060136470343}, \
{2.79, 0.49151077555179606`}], 
          
          RectangleBox[{3., 0.4796060136470343}, \
{3.1900000000000004`, 0.49151077555179606`}], 
          RectangleBox[{0.4, 0.5153202993613198}, {0.59, 0.5272250612660818}],
           RectangleBox[{0.6, 0.5153202993613198}, \
{0.79, 0.5272250612660818}], 
          RectangleBox[{1.2, 0.5153202993613198}, {1.39, 0.5272250612660818}],
           RectangleBox[{1.4, 0.5153202993613198}, \
{1.59, 0.5272250612660818}], 
          RectangleBox[{2., 0.5153202993613198}, \
{2.1900000000000004`, 0.5272250612660818}], 
          RectangleBox[{2.2, 0.5153202993613198}, {2.39, 0.5272250612660818}],
           RectangleBox[{2.8, 0.5153202993613198}, \
{2.99, 0.5272250612660818}], 
          RectangleBox[{3., 0.5153202993613198}, \
{3.1900000000000004`, 0.5272250612660818}], 
          RectangleBox[{0.6, 0.5748441088851295}, {0.79, 0.5867488707898912}],
           RectangleBox[{1.4, 0.5748441088851295}, \
{1.59, 0.5867488707898912}], 
          RectangleBox[{2.2, 0.5748441088851295}, {2.39, 0.5867488707898912}],
           RectangleBox[{3., 0.5748441088851295}, \
{3.1900000000000004`, 0.5867488707898912}], 
          RectangleBox[{0.8, 0.6224631565041769}, {0.99, 0.6343679184089389}],
           RectangleBox[{1., 0.6224631565041769}, {1.19, 0.6343679184089389}],
           RectangleBox[{1.2, 0.6224631565041769}, \
{1.39, 0.6343679184089389}], 
          RectangleBox[{1.4, 0.6224631565041769}, {1.59, 0.6343679184089389}],
           RectangleBox[{2.4, 0.6224631565041769}, \
{2.59, 0.6343679184089389}], 
          RectangleBox[{2.6, 0.6224631565041769}, {2.79, 0.6343679184089389}],
           RectangleBox[{2.8, 0.6224631565041769}, \
{2.99, 0.6343679184089389}], 
          RectangleBox[{3., 0.6224631565041769}, \
{3.1900000000000004`, 0.6343679184089389}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"\<\"3.2\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{"3.2", " s"}]],
       Row[{
         Row[{"3.2", " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 6], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5] =!= None,
             
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 6], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 60, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 76, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 5]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{
    SoundNote[{0}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 7}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4, 7, 12}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 7, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4, 7, 12, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 7}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4, 7, 12}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 7, 16}, 
     Rational[1, 5], "Harpsichord"], 
    SoundNote[{0, 4, 7, 12, 16}, 
     Rational[1, 5], "Harpsichord"]}]]], "Output",
 CellLabel->"Out[1]=",
 CellID->69115902]
}, Open  ]],

Cell["Export to MIDI:", "ExampleText",
 CellID->803710212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<rule60.mid\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->285393454],

Cell[BoxData["\<\"rule60.mid\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1276797627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337879681],

Cell["\<\
Generate a basic algorithmic composition and export it to MIDI:\
\>", "ExampleText",
 CellID->1974220371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sound", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"SoundNote", "[", " ", 
       RowBox[{"#", ",", 
        RowBox[{"1", "/", "12"}], ",", " ", "\"\<Harp\>\""}], " ", "]"}], 
      "&"}], "/@", " ", 
     RowBox[{"Pick", "[", 
      RowBox[{
       RowBox[{"Range", "[", "12", "]"}], ",", 
       RowBox[{"IntegerDigits", "[", 
        RowBox[{"scale", ",", "2", ",", "12"}], "]"}], ",", "1"}], "]"}]}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"scale", ",", "2304", ",", "2352"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->847019307],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[
       {Hue[0.26606693913191143`, 0.9, 0.7], 
        StyleBox[{
          RectangleBox[{0., 0.4438917279327484}, \
{0.07916666666666666, 0.45579648983751037`}], 
          RectangleBox[{0.16666666666666666`, 0.4438917279327484}, \
{0.24583333333333332`, 0.45579648983751037`}], 
          RectangleBox[{0.4166666666666667, 0.4438917279327484}, \
{0.49583333333333335`, 0.45579648983751037`}], 
          RectangleBox[{0.6666666666666666, 0.4438917279327484}, \
{0.7458333333333333, 0.45579648983751037`}], 
          RectangleBox[{1., 0.4438917279327484}, \
{1.0791666666666666`, 0.45579648983751037`}], 
          RectangleBox[{1.25, 0.4438917279327484}, \
{1.3291666666666666`, 0.45579648983751037`}], 
          RectangleBox[{1.5833333333333333`, 0.4438917279327484}, \
{1.6625, 0.45579648983751037`}], 
          RectangleBox[{1.9166666666666667`, 0.4438917279327484}, \
{1.9958333333333333`, 0.45579648983751037`}], 
          RectangleBox[{2.3333333333333335`, 0.4438917279327484}, \
{2.4124999999999996`, 0.45579648983751037`}], 
          RectangleBox[{2.5833333333333335`, 0.4438917279327484}, \
{2.6624999999999996`, 0.45579648983751037`}], 
          RectangleBox[{2.9166666666666665`, 0.4438917279327484}, \
{2.995833333333333, 0.45579648983751037`}], 
          RectangleBox[{3.25, 0.4438917279327484}, \
{3.3291666666666666`, 0.45579648983751037`}], 
          RectangleBox[{3.6666666666666665`, 0.4438917279327484}, \
{3.745833333333333, 0.45579648983751037`}], 
          RectangleBox[{4., 0.4438917279327484}, \
{4.079166666666667, 0.45579648983751037`}], 
          RectangleBox[{4.416666666666667, 0.4438917279327484}, \
{4.495833333333334, 0.45579648983751037`}], 
          RectangleBox[{4.833333333333333, 0.4438917279327484}, \
{4.9125000000000005`, 0.45579648983751037`}], 
          RectangleBox[{5.333333333333333, 0.4438917279327484}, \
{5.4125000000000005`, 0.45579648983751037`}], 
          RectangleBox[{5.583333333333333, 0.4438917279327484}, 
           {5.6625000000000005`, 0.45579648983751037`}], 
          RectangleBox[{5.916666666666667, 0.4438917279327484}, \
{5.995833333333334, 0.45579648983751037`}], 
          RectangleBox[{6.25, 0.4438917279327484}, \
{6.329166666666667, 0.45579648983751037`}], 
          RectangleBox[{6.666666666666667, 0.4438917279327484}, \
{6.745833333333334, 0.45579648983751037`}], 
          RectangleBox[{7., 0.4438917279327484}, \
{7.079166666666667, 0.45579648983751037`}], 
          RectangleBox[{7.416666666666667, 0.4438917279327484}, \
{7.495833333333334, 0.45579648983751037`}], 
          RectangleBox[{7.833333333333333, 0.4438917279327484}, \
{7.9125000000000005`, 0.45579648983751037`}], 
          RectangleBox[{8.333333333333334, 0.4438917279327484}, \
{8.4125, 0.45579648983751037`}], 
          RectangleBox[{8.666666666666666, 0.4438917279327484}, \
{8.745833333333334, 0.45579648983751037`}], 
          RectangleBox[{9.083333333333334, 0.4438917279327484}, \
{9.1625, 0.45579648983751037`}], 
          RectangleBox[{9.5, 0.4438917279327484}, \
{9.579166666666667, 0.45579648983751037`}], 
          RectangleBox[{10., 0.4438917279327484}, \
{10.079166666666667`, 0.45579648983751037`}], 
          RectangleBox[{10.416666666666666`, 0.4438917279327484}, \
{10.495833333333334`, 0.45579648983751037`}], 
          RectangleBox[{10.916666666666666`, 0.4438917279327484}, \
{10.995833333333334`, 0.45579648983751037`}], 
          RectangleBox[{11.416666666666666`, 0.4438917279327484}, \
{11.495833333333334`, 0.45579648983751037`}], 
          RectangleBox[{12., 0.4438917279327484}, \
{12.079166666666667`, 0.45579648983751037`}], 
          RectangleBox[{12.25, 0.4438917279327484}, \
{12.329166666666667`, 0.45579648983751037`}], 
          RectangleBox[{12.583333333333334`, 0.4438917279327484}, \
{12.6625, 0.45579648983751037`}], 
          RectangleBox[{12.916666666666666`, 0.4438917279327484}, \
{12.995833333333334`, 0.45579648983751037`}], 
          RectangleBox[{13.333333333333334`, 0.4438917279327484}, \
{13.4125, 0.45579648983751037`}], 
          RectangleBox[{13.666666666666666`, 0.4438917279327484}, \
{13.745833333333334`, 0.45579648983751037`}], 
          RectangleBox[{14.083333333333334`, 0.4438917279327484}, \
{14.1625, 0.45579648983751037`}], 
          RectangleBox[{14.5, 0.4438917279327484}, \
{14.579166666666667`, 0.45579648983751037`}], 
          RectangleBox[{15., 0.4438917279327484}, \
{15.079166666666667`, 0.45579648983751037`}], 
          RectangleBox[{15.333333333333334`, 0.4438917279327484}, \
{15.4125, 0.45579648983751037`}], 
          RectangleBox[{15.75, 0.4438917279327484}, \
{15.829166666666667`, 0.45579648983751037`}], 
          RectangleBox[{16.166666666666668`, 0.4438917279327484}, \
{16.245833333333334`, 0.45579648983751037`}], 
          RectangleBox[{16.666666666666668`, 0.4438917279327484}, \
{16.745833333333334`, 0.45579648983751037`}], 
          RectangleBox[{17.083333333333332`, 0.4438917279327484}, \
{17.1625, 0.45579648983751037`}], 
          RectangleBox[{17.583333333333332`, 0.4438917279327484}, \
{17.6625, 0.45579648983751037`}], 
          RectangleBox[{18.083333333333332`, 0.4438917279327484}, \
{18.1625, 0.45579648983751037`}], 
          RectangleBox[{18.666666666666668`, 0.4438917279327484}, \
{18.745833333333334`, 0.45579648983751037`}], 
          RectangleBox[{0.08333333333333333, 0.4796060136470343}, \
{0.16249999999999998`, 0.49151077555179606`}], 
          RectangleBox[{0.25, 0.4796060136470343}, \
{0.32916666666666666`, 0.49151077555179606`}], 
          RectangleBox[{0.5, 0.4796060136470343}, \
{0.5791666666666667, 0.49151077555179606`}], 
          RectangleBox[{0.75, 0.4796060136470343}, \
{0.8291666666666667, 0.49151077555179606`}], 
          RectangleBox[{1.0833333333333333`, 0.4796060136470343}, \
{1.1625, 0.49151077555179606`}], 
          RectangleBox[{1.3333333333333333`, 0.4796060136470343}, \
{1.4125, 0.49151077555179606`}], 
          RectangleBox[{1.6666666666666667`, 0.4796060136470343}, \
{1.7458333333333333`, 0.49151077555179606`}], 
          RectangleBox[{2., 0.4796060136470343}, \
{2.0791666666666666`, 0.49151077555179606`}], 
          RectangleBox[{2.4166666666666665`, 0.4796060136470343}, \
{2.495833333333333, 0.49151077555179606`}], 
          
          RectangleBox[{2.6666666666666665`, 0.4796060136470343}, \
{2.745833333333333, 0.49151077555179606`}], 
          RectangleBox[{3., 0.4796060136470343}, \
{3.0791666666666666`, 0.49151077555179606`}], 
          RectangleBox[{3.3333333333333335`, 0.4796060136470343}, \
{3.4124999999999996`, 0.49151077555179606`}], 
          RectangleBox[{3.75, 0.4796060136470343}, \
{3.8291666666666666`, 0.49151077555179606`}], 
          RectangleBox[{4.083333333333333, 0.4796060136470343}, \
{4.1625000000000005`, 0.49151077555179606`}], 
          RectangleBox[{4.5, 0.4796060136470343}, \
{4.579166666666667, 0.49151077555179606`}], 
          RectangleBox[{4.916666666666667, 0.4796060136470343}, \
{4.995833333333334, 0.49151077555179606`}], 
          RectangleBox[{5.416666666666667, 0.4796060136470343}, \
{5.495833333333334, 0.49151077555179606`}], 
          RectangleBox[{5.666666666666667, 0.4796060136470343}, \
{5.745833333333334, 0.49151077555179606`}], 
          RectangleBox[{6., 0.4796060136470343}, \
{6.079166666666667, 0.49151077555179606`}], 
          RectangleBox[{6.333333333333333, 0.4796060136470343}, \
{6.4125000000000005`, 0.49151077555179606`}], 
          RectangleBox[{6.75, 0.4796060136470343}, \
{6.829166666666667, 0.49151077555179606`}], 
          RectangleBox[{7.083333333333333, 0.4796060136470343}, \
{7.1625000000000005`, 0.49151077555179606`}], 
          RectangleBox[{7.5, 0.4796060136470343}, \
{7.579166666666667, 0.49151077555179606`}], 
          RectangleBox[{7.916666666666667, 0.4796060136470343}, \
{7.995833333333334, 0.49151077555179606`}], 
          RectangleBox[{8.416666666666666, 0.4796060136470343}, \
{8.495833333333334, 0.49151077555179606`}], 
          RectangleBox[{8.75, 0.4796060136470343}, \
{8.829166666666667, 0.49151077555179606`}], 
          RectangleBox[{9.166666666666666, 0.4796060136470343}, \
{9.245833333333334, 0.49151077555179606`}], 
          RectangleBox[{9.583333333333334, 0.4796060136470343}, \
{9.6625, 0.49151077555179606`}], 
          RectangleBox[{10.083333333333334`, 0.4796060136470343}, \
{10.1625, 0.49151077555179606`}], 
          
          RectangleBox[{10.5, 0.4796060136470343}, \
{10.579166666666667`, 0.49151077555179606`}], 
          RectangleBox[{11., 0.4796060136470343}, \
{11.079166666666667`, 0.49151077555179606`}], 
          RectangleBox[{11.5, 0.4796060136470343}, \
{11.579166666666667`, 0.49151077555179606`}], 
          RectangleBox[{12.083333333333334`, 0.4796060136470343}, \
{12.1625, 0.49151077555179606`}], 
          RectangleBox[{12.333333333333334`, 0.4796060136470343}, \
{12.4125, 0.49151077555179606`}], 
          RectangleBox[{12.666666666666666`, 0.4796060136470343}, \
{12.745833333333334`, 0.49151077555179606`}], 
          RectangleBox[{13., 0.4796060136470343}, \
{13.079166666666667`, 0.49151077555179606`}], 
          RectangleBox[{13.416666666666666`, 0.4796060136470343}, \
{13.495833333333334`, 0.49151077555179606`}], 
          RectangleBox[{13.75, 0.4796060136470343}, \
{13.829166666666667`, 0.49151077555179606`}], 
          RectangleBox[{14.166666666666666`, 0.4796060136470343}, \
{14.245833333333334`, 0.49151077555179606`}], 
          RectangleBox[{14.583333333333334`, 0.4796060136470343}, \
{14.6625, 0.49151077555179606`}], 
          RectangleBox[{15.083333333333334`, 0.4796060136470343}, \
{15.1625, 0.49151077555179606`}], 
          RectangleBox[{15.416666666666666`, 0.4796060136470343}, \
{15.495833333333334`, 0.49151077555179606`}], 
          RectangleBox[{15.833333333333334`, 0.4796060136470343}, \
{15.9125, 0.49151077555179606`}], 
          RectangleBox[{16.25, 0.4796060136470343}, \
{16.329166666666666`, 0.49151077555179606`}], 
          RectangleBox[{16.75, 0.4796060136470343}, \
{16.829166666666666`, 0.49151077555179606`}], 
          RectangleBox[{17.166666666666668`, 0.4796060136470343}, \
{17.245833333333334`, 0.49151077555179606`}], 
          RectangleBox[{17.666666666666668`, 0.4796060136470343}, \
{17.745833333333334`, 0.49151077555179606`}], 
          RectangleBox[{18.166666666666668`, 0.4796060136470343}, \
{18.245833333333334`, 0.49151077555179606`}], 
          RectangleBox[{18.75, 0.4796060136470343}, \
{18.829166666666666`, 0.49151077555179606`}], 
          
          RectangleBox[{12.166666666666666`, 0.5153202993613198}, \
{12.245833333333334`, 0.5272250612660818}], 
          RectangleBox[{12.416666666666666`, 0.5153202993613198}, \
{12.495833333333334`, 0.5272250612660818}], 
          RectangleBox[{12.75, 0.5153202993613198}, \
{12.829166666666667`, 0.5272250612660818}], 
          RectangleBox[{13.083333333333334`, 0.5153202993613198}, \
{13.1625, 0.5272250612660818}], 
          RectangleBox[{13.5, 0.5153202993613198}, \
{13.579166666666667`, 0.5272250612660818}], 
          RectangleBox[{13.833333333333334`, 0.5153202993613198}, \
{13.9125, 0.5272250612660818}], 
          RectangleBox[{14.25, 0.5153202993613198}, \
{14.329166666666667`, 0.5272250612660818}], 
          RectangleBox[{14.666666666666666`, 0.5153202993613198}, \
{14.745833333333334`, 0.5272250612660818}], 
          RectangleBox[{15.166666666666666`, 0.5153202993613198}, \
{15.245833333333334`, 0.5272250612660818}], 
          RectangleBox[{15.5, 0.5153202993613198}, \
{15.579166666666667`, 0.5272250612660818}], 
          RectangleBox[{15.916666666666666`, 0.5153202993613198}, \
{15.995833333333334`, 0.5272250612660818}], 
          RectangleBox[{16.333333333333332`, 0.5153202993613198}, \
{16.4125, 0.5272250612660818}], 
          RectangleBox[{16.833333333333332`, 0.5153202993613198}, \
{16.9125, 0.5272250612660818}], 
          RectangleBox[{17.25, 0.5153202993613198}, \
{17.329166666666666`, 0.5272250612660818}], 
          RectangleBox[{17.75, 0.5153202993613198}, \
{17.829166666666666`, 0.5272250612660818}], 
          RectangleBox[{18.25, 0.5153202993613198}, \
{18.329166666666666`, 0.5272250612660818}], 
          RectangleBox[{18.833333333333332`, 0.5153202993613198}, \
{18.9125, 0.5272250612660818}], 
          RectangleBox[{5.5, 0.5272250612660818}, \
{5.579166666666667, 0.5391298231708438}], 
          RectangleBox[{5.75, 0.5272250612660818}, \
{5.829166666666667, 0.5391298231708438}], 
          RectangleBox[{6.083333333333333, 0.5272250612660818}, \
{6.1625000000000005`, 0.5391298231708438}], 
          RectangleBox[{6.416666666666667, 0.5272250612660818}, \
{6.495833333333334, 0.5391298231708438}], 
          RectangleBox[{6.833333333333333, 0.5272250612660818}, \
{6.9125000000000005`, 0.5391298231708438}], 
          RectangleBox[{7.166666666666667, 0.5272250612660818}, \
{7.245833333333334, 0.5391298231708438}], 
          RectangleBox[{7.583333333333333, 0.5272250612660818}, \
{7.6625000000000005`, 0.5391298231708438}], 
          RectangleBox[{8., 0.5272250612660818}, \
{8.079166666666667, 0.5391298231708438}], 
          RectangleBox[{8.5, 0.5272250612660818}, \
{8.579166666666667, 0.5391298231708438}], 
          RectangleBox[{8.833333333333334, 0.5272250612660818}, \
{8.9125, 0.5391298231708438}], 
          RectangleBox[{9.25, 0.5272250612660818}, \
{9.329166666666667, 0.5391298231708438}], 
          RectangleBox[{9.666666666666666, 0.5272250612660818}, \
{9.745833333333334, 0.5391298231708438}], 
          RectangleBox[{10.166666666666666`, 0.5272250612660818}, \
{10.245833333333334`, 0.5391298231708438}], 
          RectangleBox[{10.583333333333334`, 0.5272250612660818}, \
{10.6625, 0.5391298231708438}], 
          RectangleBox[{11.083333333333334`, 0.5272250612660818}, \
{11.1625, 0.5391298231708438}], 
          RectangleBox[{11.583333333333334`, 0.5272250612660818}, \
{11.6625, 0.5391298231708438}], 
          RectangleBox[{18.916666666666668`, 0.5272250612660818}, \
{18.995833333333334`, 0.5391298231708438}], 
          RectangleBox[{2.5, 0.5391298231708438}, \
{2.5791666666666666`, 0.5510345850756055}], 
          RectangleBox[{2.75, 0.5391298231708438}, \
{2.8291666666666666`, 0.5510345850756055}], 
          RectangleBox[{3.0833333333333335`, 0.5391298231708438}, \
{3.1624999999999996`, 0.5510345850756055}], 
          RectangleBox[{3.4166666666666665`, 0.5391298231708438}, \
{3.495833333333333, 0.5510345850756055}], 
          RectangleBox[{3.8333333333333335`, 0.5391298231708438}, \
{3.9124999999999996`, 0.5510345850756055}], 
          RectangleBox[{4.166666666666667, 0.5391298231708438}, \
{4.245833333333334, 0.5510345850756055}], 
          RectangleBox[{4.583333333333333, 0.5391298231708438}, \
{4.6625000000000005`, 0.5510345850756055}], 
          
          RectangleBox[{5., 0.5391298231708438}, \
{5.079166666666667, 0.5510345850756055}], 
          RectangleBox[{8.583333333333334, 0.5391298231708438}, \
{8.6625, 0.5510345850756055}], 
          RectangleBox[{8.916666666666666, 0.5391298231708438}, \
{8.995833333333334, 0.5510345850756055}], 
          RectangleBox[{9.333333333333334, 0.5391298231708438}, \
{9.4125, 0.5510345850756055}], 
          RectangleBox[{9.75, 0.5391298231708438}, \
{9.829166666666667, 0.5510345850756055}], 
          RectangleBox[{10.25, 0.5391298231708438}, \
{10.329166666666667`, 0.5510345850756055}], 
          RectangleBox[{10.666666666666666`, 0.5391298231708438}, \
{10.745833333333334`, 0.5510345850756055}], 
          RectangleBox[{11.166666666666666`, 0.5391298231708438}, \
{11.245833333333334`, 0.5510345850756055}], 
          RectangleBox[{11.666666666666666`, 0.5391298231708438}, \
{11.745833333333334`, 0.5510345850756055}], 
          RectangleBox[{15.25, 0.5391298231708438}, \
{15.329166666666667`, 0.5510345850756055}], 
          RectangleBox[{15.583333333333334`, 0.5391298231708438}, \
{15.6625, 0.5510345850756055}], 
          RectangleBox[{16., 0.5391298231708438}, \
{16.079166666666666`, 0.5510345850756055}], 
          RectangleBox[{16.416666666666668`, 0.5391298231708438}, \
{16.495833333333334`, 0.5510345850756055}], 
          RectangleBox[{16.916666666666668`, 0.5391298231708438}, \
{16.995833333333334`, 0.5510345850756055}], 
          RectangleBox[{17.333333333333332`, 0.5391298231708438}, \
{17.4125, 0.5510345850756055}], 
          RectangleBox[{17.833333333333332`, 0.5391298231708438}, \
{17.9125, 0.5510345850756055}], 
          RectangleBox[{18.333333333333332`, 0.5391298231708438}, \
{18.4125, 0.5510345850756055}], 
          RectangleBox[{1.1666666666666667`, 0.5510345850756055}, \
{1.2458333333333333`, 0.5629393469803675}], 
          RectangleBox[{1.4166666666666667`, 0.5510345850756055}, \
{1.4958333333333333`, 0.5629393469803675}], 
          RectangleBox[{1.75, 0.5510345850756055}, \
{1.8291666666666666`, 0.5629393469803675}], 
          RectangleBox[{2.0833333333333335`, 0.5510345850756055}, 
           {2.1624999999999996`, 0.5629393469803675}], 
          RectangleBox[{3.9166666666666665`, 0.5510345850756055}, \
{3.995833333333333, 0.5629393469803675}], 
          RectangleBox[{4.25, 0.5510345850756055}, \
{4.329166666666667, 0.5629393469803675}], 
          RectangleBox[{4.666666666666667, 0.5510345850756055}, \
{4.745833333333334, 0.5629393469803675}], 
          RectangleBox[{5.083333333333333, 0.5510345850756055}, \
{5.1625000000000005`, 0.5629393469803675}], 
          RectangleBox[{6.916666666666667, 0.5510345850756055}, \
{6.995833333333334, 0.5629393469803675}], 
          RectangleBox[{7.25, 0.5510345850756055}, \
{7.329166666666667, 0.5629393469803675}], 
          RectangleBox[{7.666666666666667, 0.5510345850756055}, \
{7.745833333333334, 0.5629393469803675}], 
          RectangleBox[{8.083333333333334, 0.5510345850756055}, \
{8.1625, 0.5629393469803675}], 
          RectangleBox[{10.333333333333334`, 0.5510345850756055}, \
{10.4125, 0.5629393469803675}], 
          RectangleBox[{10.75, 0.5510345850756055}, \
{10.829166666666667`, 0.5629393469803675}], 
          RectangleBox[{11.25, 0.5510345850756055}, \
{11.329166666666667`, 0.5629393469803675}], 
          RectangleBox[{11.75, 0.5510345850756055}, \
{11.829166666666667`, 0.5629393469803675}], 
          RectangleBox[{13.583333333333334`, 0.5510345850756055}, \
{13.6625, 0.5629393469803675}], 
          RectangleBox[{13.916666666666666`, 0.5510345850756055}, \
{13.995833333333334`, 0.5629393469803675}], 
          RectangleBox[{14.333333333333334`, 0.5510345850756055}, \
{14.4125, 0.5629393469803675}], 
          RectangleBox[{14.75, 0.5510345850756055}, \
{14.829166666666667`, 0.5629393469803675}], 
          RectangleBox[{17., 0.5510345850756055}, \
{17.079166666666666`, 0.5629393469803675}], 
          RectangleBox[{17.416666666666668`, 0.5510345850756055}, \
{17.495833333333334`, 0.5629393469803675}], 
          RectangleBox[{17.916666666666668`, 0.5510345850756055}, \
{17.995833333333334`, 0.5629393469803675}], 
          RectangleBox[{18.416666666666668`, 0.5510345850756055}, \
{18.495833333333334`, 0.5629393469803675}], 
          
          RectangleBox[{0.5833333333333334, 0.5629393469803675}, \
{0.6625, 0.5748441088851295}], 
          RectangleBox[{0.8333333333333334, 0.5629393469803675}, \
{0.9125, 0.5748441088851295}], 
          RectangleBox[{1.8333333333333333`, 0.5629393469803675}, \
{1.9125, 0.5748441088851295}], 
          RectangleBox[{2.1666666666666665`, 0.5629393469803675}, \
{2.245833333333333, 0.5748441088851295}], 
          RectangleBox[{3.1666666666666665`, 0.5629393469803675}, \
{3.245833333333333, 0.5748441088851295}], 
          RectangleBox[{3.5, 0.5629393469803675}, \
{3.5791666666666666`, 0.5748441088851295}], 
          RectangleBox[{4.75, 0.5629393469803675}, \
{4.829166666666667, 0.5748441088851295}], 
          RectangleBox[{5.166666666666667, 0.5629393469803675}, \
{5.245833333333334, 0.5748441088851295}], 
          RectangleBox[{6.166666666666667, 0.5629393469803675}, \
{6.245833333333334, 0.5748441088851295}], 
          RectangleBox[{6.5, 0.5629393469803675}, \
{6.579166666666667, 0.5748441088851295}], 
          RectangleBox[{7.75, 0.5629393469803675}, \
{7.829166666666667, 0.5748441088851295}], 
          RectangleBox[{8.166666666666666, 0.5629393469803675}, \
{8.245833333333334, 0.5748441088851295}], 
          RectangleBox[{9.416666666666666, 0.5629393469803675}, \
{9.495833333333334, 0.5748441088851295}], 
          RectangleBox[{9.833333333333334, 0.5629393469803675}, \
{9.9125, 0.5748441088851295}], 
          RectangleBox[{11.333333333333334`, 0.5629393469803675}, \
{11.4125, 0.5748441088851295}], 
          RectangleBox[{11.833333333333334`, 0.5629393469803675}, \
{11.9125, 0.5748441088851295}], 
          RectangleBox[{12.833333333333334`, 0.5629393469803675}, \
{12.9125, 0.5748441088851295}], 
          RectangleBox[{13.166666666666666`, 0.5629393469803675}, \
{13.245833333333334`, 0.5748441088851295}], 
          RectangleBox[{14.416666666666666`, 0.5629393469803675}, \
{14.495833333333334`, 0.5748441088851295}], 
          RectangleBox[{14.833333333333334`, 0.5629393469803675}, \
{14.9125, 0.5748441088851295}], 
          RectangleBox[{16.083333333333332`, 0.5629393469803675}, \
{16.1625, 0.5748441088851295}], 
          RectangleBox[{16.5, 0.5629393469803675}, \
{16.579166666666666`, 0.5748441088851295}], 
          RectangleBox[{18., 0.5629393469803675}, \
{18.079166666666666`, 0.5748441088851295}], 
          RectangleBox[{18.5, 0.5629393469803675}, \
{18.579166666666666`, 0.5748441088851295}], 
          RectangleBox[{0.3333333333333333, 0.5748441088851295}, \
{0.41250000000000003`, 0.5867488707898912}], 
          RectangleBox[{0.9166666666666666, 0.5748441088851295}, \
{0.9958333333333333, 0.5867488707898912}], 
          RectangleBox[{1.5, 0.5748441088851295}, \
{1.5791666666666666`, 0.5867488707898912}], 
          RectangleBox[{2.25, 0.5748441088851295}, \
{2.3291666666666666`, 0.5867488707898912}], 
          RectangleBox[{2.8333333333333335`, 0.5748441088851295}, \
{2.9124999999999996`, 0.5867488707898912}], 
          RectangleBox[{3.5833333333333335`, 0.5748441088851295}, \
{3.6624999999999996`, 0.5867488707898912}], 
          RectangleBox[{4.333333333333333, 0.5748441088851295}, \
{4.4125000000000005`, 0.5867488707898912}], 
          RectangleBox[{5.25, 0.5748441088851295}, \
{5.329166666666667, 0.5867488707898912}], 
          RectangleBox[{5.833333333333333, 0.5748441088851295}, \
{5.9125000000000005`, 0.5867488707898912}], 
          RectangleBox[{6.583333333333333, 0.5748441088851295}, \
{6.6625000000000005`, 0.5867488707898912}], 
          RectangleBox[{7.333333333333333, 0.5748441088851295}, \
{7.4125000000000005`, 0.5867488707898912}], 
          RectangleBox[{8.25, 0.5748441088851295}, \
{8.329166666666667, 0.5867488707898912}], 
          RectangleBox[{9., 0.5748441088851295}, \
{9.079166666666667, 0.5867488707898912}], 
          RectangleBox[{9.916666666666666, 0.5748441088851295}, \
{9.995833333333334, 0.5867488707898912}], 
          RectangleBox[{10.833333333333334`, 0.5748441088851295}, \
{10.9125, 0.5867488707898912}], 
          RectangleBox[{11.916666666666666`, 0.5748441088851295}, \
{11.995833333333334`, 0.5867488707898912}], 
          RectangleBox[{12.5, 0.5748441088851295}, \
{12.579166666666667`, 0.5867488707898912}], 
          
          RectangleBox[{13.25, 0.5748441088851295}, \
{13.329166666666667`, 0.5867488707898912}], 
          RectangleBox[{14., 0.5748441088851295}, \
{14.079166666666667`, 0.5867488707898912}], 
          RectangleBox[{14.916666666666666`, 0.5748441088851295}, \
{14.995833333333334`, 0.5867488707898912}], 
          RectangleBox[{15.666666666666666`, 0.5748441088851295}, \
{15.745833333333334`, 0.5867488707898912}], 
          RectangleBox[{16.583333333333332`, 0.5748441088851295}, \
{16.6625, 0.5867488707898912}], 
          RectangleBox[{17.5, 0.5748441088851295}, \
{17.579166666666666`, 0.5867488707898912}], 
          RectangleBox[{18.583333333333332`, 0.5748441088851295}, \
{18.6625, 0.5867488707898912}]},
         Antialiasing->True]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->All,
       PlotRangePadding->{Automatic, 0.05}], {180, -35}, 
      ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[
       {GrayLevel[0.6], RectangleBox[{0, 0}]},
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       InterpretationBox[
        RowBox[{"19", "\[InvisibleSpace]", "\<\" s\"\>"}],
        Row[{19, " s"}]],
       Row[{
         Row[{19, " s"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 46], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 38, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 38, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 39, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 41, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 41, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 42, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 42, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 43, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 43, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 44, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 44, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 45, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 45, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 46, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 46, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 47, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 47, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 48, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 48, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 49, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 49, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 50, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 50, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 51, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 51, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 52, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 52, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 53, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 53, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 54, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 54, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 55, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 55, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 56, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 56, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 57, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 57, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 58, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 58, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 59, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 59, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 60, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 60, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 61, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 61, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 62, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 62, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 63, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 63, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 64, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 64, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 65, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 65, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 66, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 66, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 67, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 67, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 68, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 68, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 69, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 69, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 70, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 70, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 71, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 71, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 72, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 72, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 73, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 73, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 74, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 74, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 75, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 75, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 76, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 76, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 77, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 77, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 78, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 78, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 79, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 79, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 80, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 80, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 81, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 81, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 82, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 82, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 83, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 83, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 84, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 84, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 85, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 85, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 86, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 86, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 87, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 87, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 88, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 88, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 89, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 89, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 90, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 90, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 91, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 91, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 92, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 92, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 93, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 93, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 94, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 94, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 95, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 95, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 96, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 96, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 97, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 97, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 98, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 98, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 99, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 99, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 100, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 100, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 101, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 101, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 102, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 102, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 103, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 103, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 104, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 104, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 105, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 105, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 106, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 106, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 107, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 107, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 108, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 108, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 109, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 109, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 110, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 110, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 111, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 111, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 112, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 112, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 113, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 113, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 114, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 114, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 115, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 115, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 116, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 116, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 117, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 117, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 118, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 118, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 119, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 119, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 120, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 121, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 121, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 122, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 122, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 123, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 123, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 124, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 124, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 125, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 125, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 126, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 126, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 127, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 127, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 128, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 128, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 129, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 129, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 130, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 130, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 131, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 131, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 132, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 132, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 133, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 133, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 134, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 134, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 135, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 135, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 136, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 136, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 137, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 137, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 138, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 138, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 139, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 139, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 140, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 140, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 141, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 141, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 142, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 142, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 143, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 143, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 144, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 144, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 145, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 145, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 146, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 146, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 147, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 147, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 148, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 148, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 149, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 149, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 150, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 150, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 151, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 151, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 152, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 152, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 153, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 153, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 154, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 154, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 155, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 155, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 156, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 156, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 157, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 157, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 158, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 158, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 159, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 159, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 160, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 160, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 161, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 161, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 162, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 162, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 163, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 163, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 164, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 164, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 165, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 165, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 166, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 166, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 167, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 167, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 168, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 168, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 169, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 169, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 170, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 170, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 171, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 171, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 172, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 172, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 173, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 173, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 174, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 174, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 175, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 175, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 176, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 176, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 177, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 177, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 178, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 178, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 179, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 179, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 180, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 180, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 181, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 181, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 182, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 182, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 183, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 183, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 184, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 184, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 185, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 185, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 186, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 186, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 187, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 187, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 188, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 188, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 189, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 189, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 190, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 190, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 191, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 191, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 192, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 192, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 193, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 193, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 194, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 194, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 195, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 195, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 196, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 196, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 197, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 197, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 198, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 198, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 199, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 199, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 200, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 200, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 201, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 201, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 202, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 202, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 203, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 203, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 204, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 204, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 205, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 205, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 206, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 206, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 207, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 207, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 208, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 208, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 209, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 209, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 210, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 210, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 211, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 211, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 212, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 212, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 213, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 213, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 214, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 214, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 215, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 215, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 216, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 216, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 217, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 217, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 218, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 218, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 219, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 219, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 220, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 220, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 221, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 221, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 222, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 222, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 223, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 223, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 224, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 224, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 225, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 225, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 226, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 226, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 227, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 227, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 228, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 12] =!= 
            None, 
            Sound`EmitMIDI[
             Sound`MIDISequence[{
               Sound`MIDITrack[{
                 Sound`MIDIEvent[0, "SetTempo", "Tempo" -> 1000000], 
                 Sound`MIDIEvent[
                 0, "ProgramCommand", "Channel" -> 0, "Value" -> 46], 
                 Sound`MIDIEvent[
                 0, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 1, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 1, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 2, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 2, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 3, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 3, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 4, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 4, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 5, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 5, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 6, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 6, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 7, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 7, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 8, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 8, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 9, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 0],
                  
                 Sound`MIDIEvent[
                 9, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 10, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 10, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 11, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 11, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 12, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 12, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 13, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 13, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 14, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 14, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 15, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 15, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 16, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 16, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 17, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 17, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 18, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 18, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 19, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 19, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 20, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 20, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 21, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 21, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 22, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 22, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 23, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 23, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 24, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 24, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 25, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 25, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 26, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 26, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 27, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 27, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 28, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 28, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 29, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 29, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 30, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 30, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 31, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 31, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 32, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 32, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 33, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 33, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 34, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 34, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 35, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 35, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 36, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 36, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 37, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 37, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 38, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 38, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 39, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 39, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 40, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 40, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 41, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 41, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 42, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 42, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 43, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 43, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 44, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 44, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 45, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 45, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 46, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 46, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 47, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 47, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 48, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 48, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 49, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 49, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 50, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 50, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 51, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 51, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 52, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 52, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 53, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 53, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 54, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 54, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 55, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 55, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 56, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 56, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 57, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 57, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 58, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 58, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 59, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 59, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 60, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 60, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 61, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 61, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 62, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 62, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 63, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 63, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 64, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 64, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 65, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 65, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 66, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 66, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 67, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 67, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 68, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 68, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 69, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 69, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 70, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 70, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 71, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 71, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 72, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 72, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 73, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 73, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 74, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 74, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 75, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 75, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 76, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 76, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 77, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 77, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 78, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 78, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 79, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 79, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 80, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 80, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 81, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 81, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 82, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 82, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 83, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 83, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 84, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 84, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 85, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 85, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 86, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 86, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 87, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 87, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 88, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 88, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 89, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 89, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 90, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 90, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 91, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 91, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 92, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 92, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 93, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 93, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 94, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 94, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 95, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 95, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 96, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 96, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 97, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 97, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 98, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 98, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 99, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 99, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 100, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 100, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 101, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 101, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 102, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 102, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 103, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 103, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 104, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 104, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 105, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 105, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 106, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 106, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 107, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 107, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 108, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 108, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 109, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 109, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 110, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 110, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 111, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 111, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 112, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 112, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 113, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 113, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 114, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 114, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 115, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 115, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 116, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 116, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 117, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 117, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 118, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 118, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 119, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 119, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 120, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 120, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 121, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 121, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 122, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 122, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 123, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 123, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 124, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 124, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 125, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 125, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 126, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 126, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 127, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 127, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 128, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 128, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 129, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 129, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 130, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 130, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 131, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 131, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 132, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 132, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 133, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 133, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 134, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 134, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 135, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 135, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 136, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 136, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 137, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 137, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 138, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 138, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 139, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 139, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 140, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 140, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 141, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 141, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 142, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 142, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 143, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 143, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 144, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 144, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 145, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 145, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 146, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 146, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 147, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 147, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 148, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 148, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 149, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 149, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 150, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 150, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 151, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 151, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 152, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 152, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 153, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 153, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 154, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 154, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 155, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 155, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 156, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 156, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 157, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 157, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 158, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 158, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 159, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 159, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 160, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 160, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 161, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 161, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 162, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 162, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 163, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 163, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 164, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 164, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 165, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 165, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 166, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 166, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 167, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 167, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 168, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 168, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 169, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 169, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 170, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 170, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 171, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 171, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 172, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 172, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 173, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 173, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 174, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 174, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 175, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 175, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 176, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 176, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 177, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 177, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 178, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 178, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 179, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 179, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 180, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 180, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 181, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 181, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 182, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 182, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 183, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 183, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 184, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 184, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 185, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 185, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 186, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 186, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 187, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 187, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 188, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 188, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 189, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 189, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 190, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 190, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 191, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 191, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 192, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 192, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 193, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 193, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 194, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 194, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 195, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 195, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 196, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 196, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 197, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 197, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 198, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 198, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 199, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 199, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 200, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 200, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 201, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 201, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 202, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 202, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 203, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 203, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 204, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 204, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 205, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 205, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 206, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 206, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 207, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 207, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 208, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 208, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 209, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 209, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 210, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 210, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 211, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 211, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 212, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 212, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 213, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 213, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 214, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 214, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 215, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 215, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 216, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 216, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 217, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 217, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 218, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 218, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 219, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 219, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 220, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 220, "NoteOn", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 221, "NoteOff", "Note" -> 69, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 221, "NoteOn", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 222, "NoteOff", "Note" -> 70, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 222, "NoteOn", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 223, "NoteOff", "Note" -> 71, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 223, "NoteOn", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 224, "NoteOff", "Note" -> 72, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 224, "NoteOn", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 225, "NoteOff", "Note" -> 61, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 225, "NoteOn", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 226, "NoteOff", "Note" -> 64, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 226, "NoteOn", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 227, "NoteOff", "Note" -> 67, "Channel" -> 0, "Velocity" -> 
                  0], 
                 Sound`MIDIEvent[
                 227, "NoteOn", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  127], 
                 Sound`MIDIEvent[
                 228, "NoteOff", "Note" -> 68, "Channel" -> 0, "Velocity" -> 
                  0]}]}, "DivisionType" -> "PPQ", "Resolution" -> 12]]]; 
          Sound`SoundDump`emitSoundThroughFE[None, "Preemptive"]), 
         PassEventsDown -> Automatic, PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[{{
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[9, 
      Rational[1, 12], "Harp"], 
     SoundNote[10, 
      Rational[1, 12], "Harp"], 
     SoundNote[11, 
      Rational[1, 12], "Harp"], 
     SoundNote[12, 
      Rational[1, 12], "Harp"]}, {
     SoundNote[1, 
      Rational[1, 12], "Harp"], 
     SoundNote[4, 
      Rational[1, 12], "Harp"], 
     SoundNote[7, 
      Rational[1, 12], "Harp"], 
     SoundNote[8, 
      Rational[1, 12], "Harp"]}}]]], "Output",
 CellLabel->"Out[1]=",
 CellID->180742992]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<scaleprogression.mid\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->797035899],

Cell[BoxData["\<\"scaleprogression.mid\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->481197402]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MIDI - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 10.3716778}", "context" -> "", 
    "keywords" -> {
     "accordion", "agogo", "algorithmic composition", "alto sax", "applause", 
      "atmosphere", "bagpipe", "bandoneon", "banjo", "baritone sax", "bass", 
      "bass and lead", "bass drum", "bassoon", "bell tree", "bird", 
      "blown bottle", "bongo", "bowed", "brass section", "breath", 
      "brightness", "bright piano", "cabasa", "calliope", "castanets", 
      "celesta", "cello", "charang", "chiff", "chinese cymbal", "choir", 
      "clap", "clarinet", "claves", "clavi", "computer music", "conga", 
      "contrabass", "cowbell", "crash cymbal", "crystal", "cuica", "cymbal", 
      "drawbar organ", "drum", "dulcimer", "echoes", "electric bass", 
      "electric grand piano", "electric guitar", "electric piano", 
      "electric snare", "english horn", "fiddle", "fifths", "flute", 
      "french horn", "fretless bass", "fret noise", "glockenspiel", "goblins",
       "guiro", "guiro long", "guiro short", "guitar", "guitar distorted", 
      "guitar harmonics", "guitar muted", "guitar overdriven", "gunshot", 
      "halo", "harmonica", "harp", "harpsichord", "helicopter", "high agogo", 
      "high bongo", "high conga mute", "high conga open", "high floor tom", 
      "high timbale", "high tom", "high woodblock", "hi-hat", "hi hat closed",
       "hi hat open", "hi hat pedal", "honky tonk piano", "jazz guitar", 
      "jingle bell", "kalimba", "koto", "low agogo", "low bongo", "low conga",
       "low floor tom", "low timbale", "low tom", "low woodblock", "maracas", 
      "marimba", "melodic tom", "metallic", "metronome", "metronome bell", 
      "metronome click", "MIDI", "mid tom", "music", "musical instrument", 
      "music box", "mute cuica", "muted trumpet", "mute surdo", 
      "mute triangle", "new age", "oboe", "ocarina", "open cuica", 
      "open surdo", "open triangle", "orchestra hit", "organ", "pan flute", 
      "percussion", "percussive organ", "piano", "piccolo", "picked bass", 
      "pitch", "pizzicato strings", "polysynth", "rain", "recorder", 
      "reed organ", "reverse cymbal", "ride bell", "ride cymbal", 
      "rock organ", "sawtooth", "saxophone", "sci fi", "scratch pull", 
      "scratch push", "seashore", "shaker", "shakuhachi", "shamisen", 
      "shanai", "side stick", "sitar", "slap", "slap bass", "snare", 
      "soprano sax", "sound", "soundtrack", "splash cymbal", "square", 
      "square click", "steeldrums", "steel guitar", "sticks", "strings", 
      "sweep", "synth bass", "synth brass", "synth drum", "synth strings", 
      "synth voice", "taiko", "tambourine", "telephone", "tenor sax", 
      "timpani", "tinklebell", "tom", "tremolo strings", "triangle", 
      "trombone", "trumpet", "tuba", "tubular bells", "vibraphone", 
      "vibraslap", "viola", "violin", "voice", "voice aahs", "voice oohs", 
      "warm", "whistle", "whistle long", "whistle short", "WolframTones", 
      "woodblock", "xylophone"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: audio/midi Standard MIDI file format. Audio format. Used for \
controlling electronic musical instruments, computer sound cards and \
sequencers. Stores a sequence of discrete sound events such as the beginning \
and end of a note, velocity and timbre information, and instrument and sound \
bank codes. MIDI is an acronym for Musical Instrument Digital Interface. \
Binary file format. Introduced in 1983. Developed and published by the MIDI \
Manufacturers Association (U.S.) and the Association of Musical Electronic \
Industry MIDI committee (Japan).", "synonyms" -> {}, "title" -> "MIDI", 
    "type" -> "Format", "uri" -> "ref/format/MIDI"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17842, 553, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 239184, 5726}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2936, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3559, 90, 102, 4, 70, "ObjectNameAlt",
 CellID->6504],
Cell[3664, 96, 662, 12, 70, "FormatUsage",
 CellID->28822],
Cell[4329, 110, 214, 7, 70, "FormatNotes",
 CellID->4055]
}, Open  ]],
Cell[CellGroupData[{
Cell[4580, 122, 52, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[4635, 125, 325, 11, 70, "FormatNotes",
 CellID->6748],
Cell[4963, 138, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[5004, 141, 755, 27, 70, "FormatNotes",
 CellID->2144],
Cell[5762, 170, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[5804, 173, 525, 20, 70, "FormatNotes",
 CellID->15469],
Cell[6332, 195, 497, 17, 70, "FormatNotes",
 CellID->1064434895],
Cell[6832, 214, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[6873, 217, 235, 9, 70, "FormatNotes",
 CellID->9815],
Cell[7111, 228, 217, 9, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[7365, 242, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[7417, 245, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[7488, 248, 669, 20, 70, "2ColumnTableMod",
 CellID->16955],
Cell[8160, 270, 278, 11, 70, "FormatNotes",
 CellID->8394],
Cell[8441, 283, 684, 22, 70, "FormatNotes",
 CellID->1386544544],
Cell[9128, 307, 178, 6, 70, "FormatNotes",
 CellID->1371583565],
Cell[9309, 315, 862, 28, 70, "FormatNotes",
 CellID->618201289],
Cell[10174, 345, 3141, 68, 70, "FormatNotes",
 CellID->747554645],
Cell[13318, 415, 402, 12, 70, "FormatNotes",
 CellID->302945816],
Cell[13723, 429, 1625, 35, 70, "FormatNotes",
 CellID->1210894350]
}, Open  ]],
Cell[CellGroupData[{
Cell[15385, 469, 50, 1, 70, "SeeAlsoSection",
 CellID->13924],
Cell[15438, 472, 1008, 34, 70, "SeeAlso",
 CellID->1616376566]
}, Open  ]],
Cell[CellGroupData[{
Cell[16483, 511, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[16544, 514, 117, 2, 70, "MoreAbout"],
Cell[16664, 518, 126, 2, 70, "MoreAbout"],
Cell[16793, 522, 134, 2, 70, "MoreAbout"],
Cell[16930, 526, 133, 2, 70, "MoreAbout"],
Cell[17066, 530, 165, 2, 70, "MoreAbout"],
Cell[17234, 534, 156, 2, 70, "MoreAbout"],
Cell[17393, 538, 159, 2, 70, "MoreAbout"],
Cell[17555, 542, 134, 2, 70, "MoreAbout"],
Cell[17692, 546, 113, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17842, 553, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[17958, 559, 59, 1, 70, "ExampleSection",
 CellID->17951026],
Cell[18020, 562, 99, 1, 70, "ExampleText",
 CellID->825290042],
Cell[CellGroupData[{
Cell[18144, 567, 330, 11, 70, "Input",
 CellID->1030223162],
Cell[18477, 580, 5570, 136, 70, "Output",
 CellID->758109956]
}, Open  ]],
Cell[24062, 719, 66, 1, 70, "ExampleText",
 CellID->1505946036],
Cell[CellGroupData[{
Cell[24153, 724, 148, 4, 70, "Input",
 CellID->50119766],
Cell[24304, 730, 90, 2, 70, "Output",
 CellID->223916584]
}, Open  ]],
Cell[24409, 735, 81, 1, 70, "ExampleText",
 CellID->604102001],
Cell[CellGroupData[{
Cell[24515, 740, 592, 18, 70, "Input",
 CellID->11791075],
Cell[25110, 760, 11097, 255, 70, "Output",
 CellID->418186997]
}, Open  ]],
Cell[CellGroupData[{
Cell[36244, 1020, 147, 4, 70, "Input",
 CellID->403584092],
Cell[36394, 1026, 89, 2, 70, "Output",
 CellID->1284477018]
}, Open  ]],
Cell[36498, 1031, 126, 3, 70, "ExampleDelimiter",
 CellID->2073020129],
Cell[36627, 1036, 82, 1, 70, "ExampleText",
 CellID->474619175],
Cell[CellGroupData[{
Cell[36734, 1041, 448, 13, 70, "Input",
 CellID->1170209267],
Cell[37185, 1056, 87, 2, 70, "Output",
 CellID->1450115717]
}, Open  ]],
Cell[37287, 1061, 126, 3, 70, "ExampleDelimiter",
 CellID->1973688171],
Cell[37416, 1066, 229, 6, 70, "ExampleText",
 CellID->1744678435],
Cell[CellGroupData[{
Cell[37670, 1076, 873, 27, 70, "Input",
 CellID->1068740907],
Cell[38546, 1105, 31893, 732, 70, "Output",
 CellID->69115902]
}, Open  ]],
Cell[70454, 1840, 58, 1, 70, "ExampleText",
 CellID->803710212],
Cell[CellGroupData[{
Cell[70537, 1845, 142, 4, 70, "Input",
 CellID->285393454],
Cell[70682, 1851, 89, 2, 70, "Output",
 CellID->1276797627]
}, Open  ]],
Cell[70786, 1856, 125, 3, 70, "ExampleDelimiter",
 CellID->337879681],
Cell[70914, 1861, 115, 3, 70, "ExampleText",
 CellID->1974220371],
Cell[CellGroupData[{
Cell[71054, 1868, 627, 20, 70, "Input",
 CellID->847019307],
Cell[71684, 1890, 162792, 3746, 70, "Output",
 CellID->180742992]
}, Open  ]],
Cell[CellGroupData[{
Cell[234513, 5641, 152, 4, 70, "Input",
 CellID->797035899],
Cell[234668, 5647, 98, 2, 70, "Output",
 CellID->481197402]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[234805, 5654, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

