(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24369,        723]
NotebookOptionsPosition[     19904,        577]
NotebookOutlinePosition[     21312,        616]
CellTagsIndexPosition[     21227,        611]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "Numerical Data Formats" :> 
         Documentation`HelpLookup["paclet:guide/NumericalDataFormats"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
      2->"\<\"Numerical Data Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MTP ",
 StyleBox["(.mtp)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Minitab portable worksheet format.
Statistical data format.
Used for exchanging and archiving statistical data.
MTP is an acronym derived from Minitab Portable Worksheet.
Plain text ASCII format.
Stores arrays of labeled data.
Developed in the 1970s as part of the Minitab Statistical Software.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " supports the MTP format."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtp\>\"", "]"}]], "InlineFormula"],
 " imports an ",
 "MTP",
 " file, returning a list of lists."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtp\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a two-dimensional array of strings and numbers, representing the \
rows and columns stored in the file."
}], "FormatNotes",
 CellID->28396],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtp\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "MTP",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtp\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mtp\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<MTP\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MTP\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the MTP format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell["General elements:", "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "datasets arranged as a table", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LabeledData\>\"", Cell[
    "datasets given as a list of rules", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391],

Cell["Textual information:", "FormatNotes",
 CellID->1876675502],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<TextData\>\"", Cell[
    "textual data given as a list of rules", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1192838625]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->145748571],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in an MTP sample file:"
}], "ExampleText",
 CellID->1111086257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/oldfaithful.mtp\>\"", " ", ",", " ", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1656410734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"LabeledData\"\>", 
   ",", "\<\"TextData\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1464690277]
}, Open  ]],

Cell["\<\
Import this file as a list of rules, each representing a labeled dataset:\
\>", "ExampleText",
 CellID->149616692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", 
   RowBox[{
   "\"\<ExampleData/oldfaithful.mtp\>\"", " ", ",", " ", 
    "\"\<LabeledData\>\""}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->589667367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Date\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
      "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
      "1.`", ",", "2.`", ",", "2.`", ",", "2.`", ",", "2.`", ",", "2.`", ",", 
      "2.`", ",", "2.`", ",", "2.`", ",", "2.`", ",", "2.`", ",", "2.`", ",", 
      "2.`", ",", "2.`", ",", "3.`", ",", "3.`", ",", "3.`", ",", "3.`", ",", 
      "3.`", ",", "3.`", ",", "3.`", ",", "3.`", ",", "3.`", ",", "3.`", ",", 
      "3.`", ",", "3.`", ",", "3.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", 
      "4.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", 
      "4.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", "4.`", ",", "5.`", ",", 
      "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", 
      "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", "5.`", ",", 
      "5.`", ",", "6.`", ",", "6.`", ",", "6.`", ",", "6.`", ",", "6.`", ",", 
      "6.`", ",", "6.`", ",", "6.`", ",", "6.`", ",", "6.`", ",", "6.`", ",", 
      "6.`", ",", "6.`", ",", "6.`", ",", "7.`", ",", "7.`", ",", "7.`", ",", 
      "7.`", ",", "7.`", ",", "7.`", ",", "7.`", ",", "7.`", ",", "7.`", ",", 
      "7.`", ",", "7.`", ",", "7.`", ",", "7.`", ",", "8.`", ",", "8.`", ",", 
      "8.`", ",", "8.`", ",", "8.`", ",", "8.`", ",", "8.`", ",", "8.`", ",", 
      "8.`", ",", "8.`", ",", "8.`", ",", "8.`", ",", "8.`"}], "}"}]}], ",", 
   RowBox[{"\<\"WaitNext\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "78.`", ",", "74.`", ",", "68.`", ",", "76.`", ",", "80.`", ",", "84.`", 
      ",", "50.`", ",", "93.`", ",", "55.`", ",", "76.`", ",", "58.`", ",", 
      "74.`", ",", "75.`", ",", "80.`", ",", "56.`", ",", "80.`", ",", "69.`",
       ",", "57.`", ",", "90.`", ",", "42.`", ",", "91.`", ",", "51.`", ",", 
      "79.`", ",", "53.`", ",", "82.`", ",", "51.`", ",", "76.`", ",", "82.`",
       ",", "84.`", ",", "53.`", ",", "86.`", ",", "51.`", ",", "85.`", ",", 
      "45.`", ",", "88.`", ",", "51.`", ",", "80.`", ",", "49.`", ",", "82.`",
       ",", "75.`", ",", "73.`", ",", "67.`", ",", "68.`", ",", "86.`", ",", 
      "72.`", ",", "75.`", ",", "75.`", ",", "66.`", ",", "84.`", ",", "70.`",
       ",", "79.`", ",", "60.`", ",", "86.`", ",", "71.`", ",", "67.`", ",", 
      "81.`", ",", "76.`", ",", "83.`", ",", "76.`", ",", "55.`", ",", "73.`",
       ",", "56.`", ",", "83.`", ",", "57.`", ",", "71.`", ",", "72.`", ",", 
      "77.`", ",", "55.`", ",", "75.`", ",", "73.`", ",", "70.`", ",", "83.`",
       ",", "50.`", ",", "95.`", ",", "51.`", ",", "82.`", ",", "54.`", ",", 
      "83.`", ",", "51.`", ",", "80.`", ",", "78.`", ",", "81.`", ",", "53.`",
       ",", "89.`", ",", "44.`", ",", "78.`", ",", "61.`", ",", "73.`", ",", 
      "75.`", ",", "73.`", ",", "76.`", ",", "55.`", ",", "86.`", ",", "48.`",
       ",", "77.`", ",", "73.`", ",", "70.`", ",", "88.`", ",", "75.`", ",", 
      "83.`", ",", "61.`", ",", "78.`", ",", "61.`", ",", "81.`", ",", "51.`",
       ",", "80.`", ",", "79.`"}], "}"}]}], ",", 
   RowBox[{"\<\"DurLast\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "4.400000095`", ",", "3.900000095`", ",", "4.`", ",", "4.`", ",", "3.5`",
       ",", "4.099999905`", ",", "2.299999952`", ",", "4.699999809`", ",", 
      "1.700000048`", ",", "4.900000095`", ",", "1.700000048`", ",", 
      "4.599999905`", ",", "3.400000095`", ",", "4.300000191`", ",", 
      "1.700000048`", ",", "3.900000095`", ",", "3.700000048`", ",", 
      "3.099999905`", ",", "4.`", ",", "1.799999952`", ",", "4.099999905`", 
      ",", "1.799999952`", ",", "3.200000048`", ",", "1.899999976`", ",", 
      "4.599999905`", ",", "2.`", ",", "4.5`", ",", "3.900000095`", ",", 
      "4.300000191`", ",", "2.299999952`", ",", "3.799999952`", ",", 
      "1.899999976`", ",", "4.599999905`", ",", "1.799999952`", ",", 
      "4.699999809`", ",", "1.799999952`", ",", "4.599999905`", ",", 
      "1.899999976`", ",", "3.5`", ",", "4.`", ",", "3.700000048`", ",", 
      "3.700000048`", ",", "4.300000191`", ",", "3.599999905`", ",", 
      "3.799999952`", ",", "3.799999952`", ",", "3.799999952`", ",", "2.5`", 
      ",", "4.5`", ",", "4.099999905`", ",", "3.700000048`", ",", 
      "3.799999952`", ",", "3.400000095`", ",", "4.`", ",", "2.299999952`", 
      ",", "4.400000095`", ",", "4.099999905`", ",", "4.300000191`", ",", 
      "3.299999952`", ",", "2.`", ",", "4.300000191`", ",", "2.900000095`", 
      ",", "4.599999905`", ",", "1.899999976`", ",", "3.599999905`", ",", 
      "3.700000048`", ",", "3.700000048`", ",", "1.799999952`", ",", 
      "4.599999905`", ",", "3.5`", ",", "4.`", ",", "3.700000048`", ",", 
      "1.700000048`", ",", "4.599999905`", ",", "1.700000048`", ",", "4.`", 
      ",", "1.799999952`", ",", "4.400000095`", ",", "1.899999976`", ",", 
      "4.599999905`", ",", "2.900000095`", ",", "3.5`", ",", "2.`", ",", 
      "4.300000191`", ",", "1.799999952`", ",", "4.099999905`", ",", 
      "1.799999952`", ",", "4.699999809`", ",", "4.199999809`", ",", 
      "3.900000095`", ",", "4.300000191`", ",", "1.799999952`", ",", "4.5`", 
      ",", "2.`", ",", "4.199999809`", ",", "4.400000095`", ",", 
      "4.099999905`", ",", "4.099999905`", ",", "4.`", ",", "4.099999905`", 
      ",", "2.700000048`", ",", "4.599999905`", ",", "1.899999976`", ",", 
      "4.5`", ",", "2.`", ",", "4.800000191`", ",", "4.099999905`"}], "}"}]}],
    ",", 
   RowBox[{"\<\"WaitLast\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"\"\>", ",", "78.`", ",", "74.`", ",", "68.`", ",", "76.`", 
      ",", "80.`", ",", "84.`", ",", "50.`", ",", "93.`", ",", "55.`", ",", 
      "76.`", ",", "58.`", ",", "74.`", ",", "75.`", ",", "80.`", ",", "56.`",
       ",", "80.`", ",", "69.`", ",", "57.`", ",", "90.`", ",", "42.`", ",", 
      "91.`", ",", "51.`", ",", "79.`", ",", "53.`", ",", "82.`", ",", "51.`",
       ",", "76.`", ",", "82.`", ",", "84.`", ",", "53.`", ",", "86.`", ",", 
      "51.`", ",", "85.`", ",", "45.`", ",", "88.`", ",", "51.`", ",", "80.`",
       ",", "49.`", ",", "82.`", ",", "75.`", ",", "73.`", ",", "67.`", ",", 
      "68.`", ",", "86.`", ",", "72.`", ",", "75.`", ",", "75.`", ",", "66.`",
       ",", "84.`", ",", "70.`", ",", "79.`", ",", "60.`", ",", "86.`", ",", 
      "71.`", ",", "67.`", ",", "81.`", ",", "76.`", ",", "83.`", ",", "76.`",
       ",", "55.`", ",", "73.`", ",", "56.`", ",", "83.`", ",", "57.`", ",", 
      "71.`", ",", "72.`", ",", "77.`", ",", "55.`", ",", "75.`", ",", "73.`",
       ",", "70.`", ",", "83.`", ",", "50.`", ",", "95.`", ",", "51.`", ",", 
      "82.`", ",", "54.`", ",", "83.`", ",", "51.`", ",", "80.`", ",", "78.`",
       ",", "81.`", ",", "53.`", ",", "89.`", ",", "44.`", ",", "78.`", ",", 
      "61.`", ",", "73.`", ",", "75.`", ",", "73.`", ",", "76.`", ",", "55.`",
       ",", "86.`", ",", "48.`", ",", "77.`", ",", "73.`", ",", "70.`", ",", 
      "88.`", ",", "75.`", ",", "83.`", ",", "61.`", ",", "78.`", ",", "61.`",
       ",", "81.`", ",", "51.`", ",", "80.`"}], "}"}]}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1660098230]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/oldfaithful.mtp\>\"", " ", ",", " ", "\"\<TextData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->444439978],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Source\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"R. A. Hutchinson\"\>", 
      ",", "\<\"Yellowstone Nat'l Park\"\>", ",", "\<\"Geologist\"\>", 
      ",", "\<\"Eruptions of Old\"\>", ",", "\<\"Faithful Geyser\"\>", 
      ",", "\<\"Quoted in\"\>", ",", "\<\"S. Weisberg\"\>", 
      ",", "\<\"Applied Linear Regression\"\>", 
      ",", "\<\"Wiley, 1985, page 234\"\>"}], "}"}]}], ",", 
   RowBox[{"\<\"Variable\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"Date=Date between\"\>", ",", "\<\"Aug 1-9, 1978\"\>", 
      ",", "\<\"DurLast=Duration of\"\>", ",", "\<\"an eruption in\"\>", 
      ",", "\<\"minutes\"\>", ",", "\<\"WaitNext=Interval until\"\>", 
      ",", "\<\"next eruption in\"\>", ",", "\<\"minutes\"\>"}], "}"}]}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->754585980]
}, Open  ]],

Cell["\<\
Read all numerical data from this file as an array, typesetting the first 10 \
rows as a table:\
\>", "ExampleText",
 CellID->2051875454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"Import", "[", " ", 
     RowBox[{
     "\"\<ExampleData/oldfaithful.mtp\>\"", " ", ",", " ", "\"\<Data\>\""}], 
     "]"}], " ", ",", "10"}], "]"}], "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1989895258],

Cell[BoxData[
 TagBox[GridBox[{
    {"1.`", "78.`", "4.400000095`", "\<\"\"\>"},
    {"1.`", "74.`", "3.900000095`", "78.`"},
    {"1.`", "68.`", "4.`", "74.`"},
    {"1.`", "76.`", "4.`", "68.`"},
    {"1.`", "80.`", "3.5`", "76.`"},
    {"1.`", "84.`", "4.099999905`", "80.`"},
    {"1.`", "50.`", "2.299999952`", "84.`"},
    {"1.`", "93.`", "4.699999809`", "50.`"},
    {"1.`", "55.`", "1.700000048`", "93.`"},
    {"1.`", "76.`", "4.900000095`", "55.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[4]//TableForm=",
 CellID->533793018]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MTP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 12.7936148}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Minitab portable worksheet format. Statistical data format. Used for \
exchanging and archiving statistical data. MTP is an acronym derived from \
Minitab Portable Worksheet. Plain text ASCII format. Stores arrays of labeled \
data. Developed in the 1970s as part of the Minitab Statistical Software.", 
    "synonyms" -> {}, "title" -> "MTP", "type" -> "Format", "uri" -> 
    "ref/format/MTP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8894, 332, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21094, 604}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 764, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1387, 44, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[1497, 50, 344, 9, 70, "FormatUsage",
 CellID->37585799],
Cell[1844, 61, 198, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[2079, 73, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[2135, 76, 304, 11, 70, "FormatNotes",
 CellID->28652],
Cell[2442, 89, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[2484, 92, 379, 11, 70, "FormatNotes",
 CellID->28396],
Cell[2866, 105, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[2908, 108, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[3263, 123, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[3840, 145, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[4423, 168, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[5129, 195, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[5170, 198, 231, 8, 70, "FormatNotes",
 CellID->16216],
Cell[5404, 208, 206, 7, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[5647, 220, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[5706, 223, 60, 1, 70, "FormatNotes",
 CellID->367643471],
Cell[5769, 226, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[6444, 241, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[6488, 244, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[6563, 247, 493, 11, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[7059, 260, 258, 9, 70, "FormatNotes",
 CellID->1999285391],
Cell[7320, 271, 64, 1, 70, "FormatNotes",
 CellID->1876675502],
Cell[7387, 274, 373, 9, 70, "2ColumnTableMod",
 CellID->1192838625]
}, Open  ]],
Cell[CellGroupData[{
Cell[7797, 288, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[7849, 291, 177, 7, 70, "FormatNotes",
 CellID->31322],
Cell[8029, 300, 460, 13, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[8526, 318, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[8587, 321, 133, 2, 70, "MoreAbout"],
Cell[8723, 325, 134, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8894, 332, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[9010, 338, 60, 1, 70, "ExampleSection",
 CellID->145748571],
Cell[9073, 341, 230, 8, 70, "ExampleText",
 CellID->1111086257],
Cell[CellGroupData[{
Cell[9328, 353, 196, 6, 70, "Input",
 CellID->1656410734],
Cell[9527, 361, 175, 5, 70, "Output",
 CellID->1464690277]
}, Open  ]],
Cell[9717, 369, 124, 3, 70, "ExampleText",
 CellID->149616692],
Cell[CellGroupData[{
Cell[9866, 376, 220, 7, 70, "Input",
 CellID->589667367],
Cell[10089, 385, 7181, 105, 70, "Output",
 CellID->1660098230]
}, Open  ]],
Cell[CellGroupData[{
Cell[17307, 495, 195, 6, 70, "Input",
 CellID->444439978],
Cell[17505, 503, 874, 19, 70, "Output",
 CellID->754585980]
}, Open  ]],
Cell[18394, 525, 147, 4, 70, "ExampleText",
 CellID->2051875454],
Cell[CellGroupData[{
Cell[18566, 533, 301, 9, 70, "Input",
 CellID->1989895258],
Cell[18870, 544, 968, 26, 70, "Output",
 CellID->533793018]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19877, 575, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

