(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17657,        658]
NotebookOptionsPosition[     13547,        525]
NotebookOutlinePosition[     14981,        564]
CellTagsIndexPosition[     14896,        559]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DumpSave" :> Documentation`HelpLookup["paclet:ref/DumpSave"], 
          "Get" :> Documentation`HelpLookup["paclet:ref/Get"], "\"Package\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Package"], 
          "\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"NB\"" :> Documentation`HelpLookup["paclet:ref/format/NB"], 
          "\"WDX\"" :> Documentation`HelpLookup["paclet:ref/format/WDX"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DumpSave\"\>", 
       2->"\<\"Get\"\>", 3->"\<\"\\\"Package\\\"\"\>", 
       4->"\<\"\\\"ExpressionML\\\"\"\>", 5->"\<\"\\\"NB\\\"\"\>", 
       6->"\<\"\\\"WDX\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MX ",
 StyleBox["(", "FilenameExtension"],
 ".mx",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->3676],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " serialized package format.\nUsed for the distribution of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " packages.\nStores arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in a serialized format optimized for fast loading.\nBinary \
file format.\nMX files cannot be exchanged between different operating \
systems or versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ".\nDeveloped by Wolfram Research."
}], "FormatUsage",
 CellID->29643],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 "MX",
 " files."
}], "FormatNotes",
 CellID->5821],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " MX files can be created with ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " and read with ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->168992130]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", "]"}]], "InlineFormula"],
 "reads in an MX file and returns an expression."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " serializes an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression and saves it as an MX file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an MX file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<MX\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MX\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mx\>\"", "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1809274264],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "MX",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[
    "reads and evaluates all expressions, returning the last one", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeldExpression\>\"", Cell[
    "list of unevaluated expressions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Expression\>\""], "InlineFormula"],
 " element for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 "MX",
 " files."
}], "FormatNotes",
 CellID->13037]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Package\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Package"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<WDX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/WDX"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1816688968]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->738946037],

Cell[TextData[{
 "Export an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression to the MX format:"
}], "ExampleText",
 CellID->1281255602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Framed", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1277347576],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox["x",
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1657572249]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"str", " ", "=", " ", 
   RowBox[{"ExportString", "[", 
    RowBox[{"%", ",", " ", "\"\<MX\>\""}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1797604746],

Cell[TextData[{
 "Show the available ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "ExampleText",
 CellID->1244374345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"str", ",", " ", "\"\<Elements\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->525055810],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Expression\"\>", ",", "\<\"HeldExpression\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1658920059]
}, Open  ]],

Cell["Import as an expression:", "ExampleText",
 CellID->2003861929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "str", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1930842377],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   FrameBox["x",
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox["x",
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox["x",
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False], ",", 
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->689242612]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 13.3873800}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica serialized package format. Used for the distribution of \
Mathematica packages. Stores arbitrary Mathematica expressions in a \
serialized format optimized for fast loading. Binary file format. MX files \
cannot be exchanged between different operating systems or versions of \
Mathematica. Developed by Wolfram Research.", "synonyms" -> {}, "title" -> 
    "MX", "type" -> "Format", "uri" -> "ref/format/MX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10867, 398, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14762, 552}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1909, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2532, 70, 140, 6, 70, "ObjectNameAlt",
 CellID->3676],
Cell[2675, 78, 555, 16, 70, "FormatUsage",
 CellID->29643],
Cell[3233, 96, 382, 17, 70, "FormatNotes",
 CellID->5821],
Cell[3618, 115, 391, 15, 70, "FormatNotes",
 CellID->168992130]
}, Open  ]],
Cell[CellGroupData[{
Cell[4046, 135, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4113, 138, 290, 9, 70, "FormatNotes",
 CellID->2520],
Cell[4406, 149, 411, 14, 70, "FormatNotes",
 CellID->12927],
Cell[4820, 165, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4862, 168, 340, 11, 70, "FormatNotes",
 CellID->22675],
Cell[5205, 181, 674, 24, 70, "FormatNotes",
 CellID->21001],
Cell[5882, 207, 459, 16, 70, "FormatNotes",
 CellID->1809274264],
Cell[6344, 225, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[6385, 228, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[6749, 244, 351, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[7137, 263, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[7191, 266, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[7386, 276, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[8057, 291, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[8099, 294, 179, 7, 70, "FormatNotes",
 CellID->13573],
Cell[8281, 303, 536, 12, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[8820, 317, 337, 14, 70, "FormatNotes",
 CellID->13037]
}, Open  ]],
Cell[CellGroupData[{
Cell[9194, 336, 38, 0, 70, "MoreAboutSection"],
Cell[9235, 338, 151, 2, 70, "MoreAbout"],
Cell[9389, 342, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9559, 349, 50, 1, 70, "SeeAlsoSection",
 CellID->19008],
Cell[9612, 352, 1218, 41, 70, "SeeAlso",
 CellID->1816688968]
}, Open  ]],
Cell[CellGroupData[{
Cell[10867, 398, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[10983, 404, 60, 1, 70, "ExampleSection",
 CellID->738946037],
Cell[11046, 407, 162, 6, 70, "ExampleText",
 CellID->1281255602],
Cell[CellGroupData[{
Cell[11233, 417, 143, 4, 70, "Input",
 CellID->1277347576],
Cell[11379, 423, 557, 24, 70, "Output",
 CellID->1657572249]
}, Open  ]],
Cell[11951, 450, 202, 6, 70, "Input",
 CellID->1797604746],
Cell[12156, 458, 208, 8, 70, "ExampleText",
 CellID->1244374345],
Cell[CellGroupData[{
Cell[12389, 470, 153, 4, 70, "Input",
 CellID->525055810],
Cell[12545, 476, 158, 5, 70, "Output",
 CellID->1658920059]
}, Open  ]],
Cell[12718, 484, 68, 1, 70, "ExampleText",
 CellID->2003861929],
Cell[CellGroupData[{
Cell[12811, 489, 111, 3, 70, "Input",
 CellID->1930842377],
Cell[12925, 494, 556, 24, 70, "Output",
 CellID->689242612]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[13520, 523, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

