(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40690,       1365]
NotebookOptionsPosition[     33397,       1127]
NotebookOutlinePosition[     35059,       1169]
CellTagsIndexPosition[     34973,       1164]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"HTML\"" :> Documentation`HelpLookup["paclet:ref/format/HTML"], 
          "\"Package\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Package"], "\"XHTML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTML"], 
          "\"XHTMLMathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTMLMathML"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\"ExpressionML\\\"\"\>", 
       2->"\<\"\\\"HTML\\\"\"\>", 3->"\<\"\\\"Package\\\"\"\>", 
       4->"\<\"\\\"XHTML\\\"\"\>", 
       5->"\<\"\\\"XHTMLMathML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 3->"\<\"Web Formats\"\>", 
       4->"\<\"XML Formats\"\>", 
       5->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MathML ",
 StyleBox["(", "FilenameExtension"],
 ".mml",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["text/mathml, application/mathml+xml", "InlineCode"],
 "\nMathML mathematical markup language.\nUsed for integrating mathematical \
formulas in web documents.\nRendering of embedded MathML is supported by a \
number of browsers and browser additions.\nSpecifies the presentation and the \
semantic content of mathematical formulas.\nXML-based format.\nBased on a \
draft that was derived from the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " typesetting language.\nIntroduced in 1999 and updated in 2003 by the W3C \
math working group."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the MathML 2.0 specification. "
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", "]"}]], "InlineFormula"],
 " imports an MathML file and returns a box expression."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an arbitrary expression to MathML."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", "]"}], " "}]], "InlineFormula"],
 "reads the MathML presentation elements from a file and converts them to the \
corresponding ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " box expression."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", "\"\<Expression\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "converts MathML to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression using ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " interpretation rules."
}], "FormatNotes",
 CellID->1670417185],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "converts a box expression or an arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression to MathML."
}], "FormatNotes",
 CellID->7572],

Cell["\<\
When exporting an arbitrary mathematical expression, its presentation and its \
context are represented in the resulting MathML.\
\>", "FormatNotes",
 CellID->434469221],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a MathML file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<MathML\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MathML\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a MathML file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).mml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell[TextData[{
 "The export format can be explicitly specified in the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], ",", "\"\<MathML\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<MathML\>\"", ",", 
      StyleBox["elems", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->72326222],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "MathML",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Boxes\>\"", Cell[TextData[{
     "MathML",
     " typeset as a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " box expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[TextData[{
     "arbitrary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeldExpression\>\"", Cell[
    "unevaluated expression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLObject\>\"", Cell[
    "MathML as a symbolic XML expression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLElement\>\"", Cell[
    "nested XMLElement objects", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->1865694418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Boxes\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->806641260],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Annotations\>\"", 
    RowBox[{"{", "}"}], Cell["which annotations to include", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Presentation\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to export MathML presentation elements", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<Semantics\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export MathML content elements", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->21895],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData["\"\<Annotations\>\""], "InlineFormula"],
 " is a list which may include any number of the choices ",
 Cell[BoxData["\"\<DocumentHeader\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<XMLDeclaration\>\""], "InlineFormula"],
 ", and ",
 Cell[BoxData["\"\<DOCTYPEDeclaration\>\""], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->5303]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Package\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Package"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTMLMathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1748583473]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->532038560],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->187051597],

Cell["\<\
Exporting an arbitrary mathematical expression by default generates \
presentation MathML:\
\>", "ExampleText",
 CellID->744370389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], "/", "b"}], ",", " ", "\"\<MathML\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2094284799],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<mfrac>\\n  <mrow>\\n   <mi>a</mi>\\n   <mo>+</mo>\\n   <mn>1</mn>\\n  \
</mrow>\\n  <mi>b</mi>\\n </mfrac>\\n</math>\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1950186364]
}, Open  ]],

Cell["This creates combined presentation and content MathML:", "ExampleText",
 CellID->266098761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], "/", "b"}], ",", " ", "\"\<MathML\>\"", 
   ",", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1886799234],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <mfrac>\\n   <mrow>\\n    <mi>a</mi>\\n    <mo>+</mo>\\n    \
<mn>1</mn>\\n   </mrow>\\n   <mi>b</mi>\\n  </mfrac>\\n  <annotation-xml \
encoding='MathML-Content'>\\n   <apply>\\n    <times/>\\n    <apply>\\n     \
<plus/>\\n     <ci>a</ci>\\n     <cn type='integer'>1</cn>\\n    </apply>\\n  \
  <apply>\\n     <power/>\\n     <ci>b</ci>\\n     <cn type='integer'>-1</cn>\
\\n    </apply>\\n   </apply>\\n  </annotation-xml>\\n </semantics>\\n</math>\
\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1691194236]
}, Open  ]],

Cell["This generates pure content MathML:", "ExampleText",
 CellID->88270473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], "/", "b"}], ",", " ", "\"\<MathML\>\"", 
   ",", 
   RowBox[{"\"\<Presentation\>\"", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"\"\<Semantics\>\"", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1260923073],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<apply>\\n  <times/>\\n  <apply>\\n   <plus/>\\n   <ci>a</ci>\\n   <cn \
type='integer'>1</cn>\\n  </apply>\\n  <apply>\\n   <power/>\\n   \
<ci>b</ci>\\n   <cn type='integer'>-1</cn>\\n  </apply>\\n </apply>\\n</math>\
\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellID->965459315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1579017654],

Cell[TextData[{
 "Define and display a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " box expression:"
}], "ExampleText",
 CellID->751895924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", " ", "=", " ", 
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<F\>\"", ",", "\"\<=\>\"", ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<-\>\"", ",", "\"\<G\>\""}], "}"}], "]"}], ",", 
        RowBox[{"FractionBox", "[", 
         RowBox[{
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<m\>\"", ",", "\"\< \>\"", ",", "\"\<M\>\""}], "}"}], 
           "]"}], ",", 
          RowBox[{"SuperscriptBox", "[", 
           RowBox[{"\"\<r\>\"", ",", "\"\<2\>\""}], "]"}]}], "]"}], ",", 
        RowBox[{"SubscriptBox", "[", 
         RowBox[{"\"\<e\>\"", ",", "\"\<r\>\""}], "]"}]}], "}"}], "]"}]}], 
    "}"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1641568820],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"F\"\>", ",", "\<\"=\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"-\"\>", ",", "\<\"G\"\>"}], "}"}], "]"}], ",", 
       RowBox[{"FractionBox", "[", 
        RowBox[{
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"m\"\>", ",", "\<\" \"\>", ",", "\<\"M\"\>"}], "}"}], 
          "]"}], ",", 
         RowBox[{"SuperscriptBox", "[", 
          RowBox[{"\<\"r\"\>", ",", "\<\"2\"\>"}], "]"}]}], "]"}], ",", 
       RowBox[{"SubscriptBox", "[", 
        RowBox[{"\<\"e\"\>", ",", "\<\"r\"\>"}], "]"}]}], "}"}], "]"}]}], 
   "}"}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->644095856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2146343128],

Cell[BoxData[
 TagBox[
  RowBox[{"F", "=", 
   RowBox[{
    RowBox[{"-", "G"}], 
    FractionBox[
     RowBox[{"m", " ", "M"}], 
     SuperscriptBox["r", "2"]], 
    SubscriptBox["e", "r"]}]}],
  DisplayForm]], "Output",
 CellLabel->"Out[2]//DisplayForm=",
 CellID->2001470912]
}, Open  ]],

Cell["Convert it to presentation MathML:", "ExampleText",
 CellID->2113710460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mml", " ", "=", " ", 
  RowBox[{"ExportString", "[", 
   RowBox[{"f", ",", " ", "\"\<MathML\>\""}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->523877819],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n <mrow>\
\\n  <mi>F</mi>\\n  <mo>=</mo>\\n  <mrow>\\n   <mrow>\\n    <mo>-</mo>\\n    \
<mi>G</mi>\\n   </mrow>\\n   <mo>&#8290;</mo>\\n   <mfrac>\\n    <mrow>\\n    \
 <mi>m</mi>\\n     <mo>&#8290;</mo>\\n     <mi>M</mi>\\n    </mrow>\\n    \
<msup>\\n     <mi>r</mi>\\n     <mn>2</mn>\\n    </msup>\\n   </mfrac>\\n   \
<mo>&#8290;</mo>\\n   <msub>\\n    <mi>e</mi>\\n    <mi>r</mi>\\n   \
</msub>\\n  </mrow>\\n </mrow>\\n</math>\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellID->537771376]
}, Open  ]],

Cell["\<\
Convert the previous output to a box expression and display it:\
\>", "ExampleText",
 CellID->976618786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "mml", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->276517309],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"F\"\>", ",", "\<\"=\"\>", ",", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             RowBox[{"\<\"-\"\>", ",", "\<\"G\"\>"}], "}"}], "]"}], 
           ",", "\<\" \"\>", ",", 
           RowBox[{"FractionBox", "[", 
            RowBox[{
             RowBox[{"RowBox", "[", 
              RowBox[{"{", 
               RowBox[{"\<\"m\"\>", ",", "\<\" \"\>", ",", "\<\"M\"\>"}], 
               "}"}], "]"}], ",", 
             RowBox[{"SuperscriptBox", "[", 
              RowBox[{"\<\"r\"\>", ",", "\<\"2\"\>"}], "]"}]}], "]"}], 
           ",", "\<\" \"\>", ",", 
           RowBox[{"SubscriptBox", "[", 
            RowBox[{"\<\"e\"\>", ",", "\<\"r\"\>"}], "]"}]}], "}"}], "]"}]}], 
       "}"}], "]"}], ",", "\<\"MathMLPresentationTag\"\>", ",", 
     RowBox[{"AutoDelete", "\[Rule]", "True"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->699536345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->702172773],

Cell[BoxData[
 TagBox[
  FormBox[
   TagBox[
    RowBox[{"F", "=", 
     RowBox[{
      RowBox[{"-", "G"}], " ", 
      FractionBox[
       RowBox[{"m", " ", "M"}], 
       SuperscriptBox["r", "2"]], " ", 
      SubscriptBox["e", "r"]}]}],
    "MathMLPresentationTag",
    AutoDelete->True],
   TraditionalForm],
  DisplayForm]], "Output",
 CellLabel->"Out[5]//DisplayForm=",
 CellID->1781866737]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes the MathML format:"
}], "ExampleText",
 CellID->1686474025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringFormat", "[", "mml", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1076011616],

Cell[BoxData["\<\"MathML\"\>"], "Output",
 CellLabel->"Out[6]=",
 CellID->1906467848]
}, Open  ]],

Cell[TextData[{
 "Show the available ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "ExampleText",
 CellID->1321015720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"mml", ",", "\"\<Elements\>\""}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1540884148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Boxes\"\>", ",", "\<\"Expression\"\>", 
   ",", "\<\"HeldExpression\"\>", ",", "\<\"XMLElement\"\>", 
   ",", "\<\"XMLObject\"\>"}], "}"}]], "Output",
 CellLabel->"Out[7]=",
 CellID->1134576263]
}, Open  ]],

Cell["Convert MathML to an evaluated expression:", "ExampleText",
 CellID->1625263354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"mml", ",", "\"\<Expression\>\""}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1220900268],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"G", " ", "m", " ", "M", " ", 
    SubscriptBox["e", "r"]}], 
   SuperscriptBox["r", "2"]]}]], "Output",
 CellLabel->"Out[8]=",
 CellID->1915516891]
}, Open  ]],

Cell["Import MathML as a symbolic XML expression:", "ExampleText",
 CellID->1956684485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"mml", ",", " ", "\"\<XMLObject\>\""}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1632677546],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"math\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"http://www.w3.org/2000/xmlns/\"\>", 
         ",", "\<\"xmlns\"\>"}], "}"}], 
       "\[Rule]", "\<\"http://www.w3.org/1998/Math/MathML\"\>"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"XMLElement", "[", 
       RowBox[{"\<\"mrow\"\>", ",", 
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mi\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"F\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mo\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", "\<\"=\"\>", "}"}]}], "]"}], ",", 
          RowBox[{"XMLElement", "[", 
           RowBox[{"\<\"mrow\"\>", ",", 
            RowBox[{"{", "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mrow\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"mo\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"-\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"mi\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"G\"\>", "}"}]}], "]"}]}], "}"}]}], 
               "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mo\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"\[InvisibleTimes]\"\>", "}"}]}], "]"}], ",",
               
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mfrac\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"mrow\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"mi\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"m\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"mo\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"\[InvisibleTimes]\"\>", "}"}]}], "]"}], 
                    ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"mi\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"M\"\>", "}"}]}], "]"}]}], "}"}]}], 
                   "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"msup\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"mi\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"r\"\>", "}"}]}], "]"}], ",", 
                    RowBox[{"XMLElement", "[", 
                    RowBox[{"\<\"mn\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"2\"\>", "}"}]}], "]"}]}], "}"}]}], 
                   "]"}]}], "}"}]}], "]"}], ",", 
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"mo\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", "\<\"\[InvisibleTimes]\"\>", "}"}]}], "]"}], ",",
               
              RowBox[{"XMLElement", "[", 
               RowBox[{"\<\"msub\"\>", ",", 
                RowBox[{"{", "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"mi\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"e\"\>", "}"}]}], "]"}], ",", 
                  RowBox[{"XMLElement", "[", 
                   RowBox[{"\<\"mi\"\>", ",", 
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "\<\"r\"\>", "}"}]}], "]"}]}], "}"}]}], 
               "]"}]}], "}"}]}], "]"}]}], "}"}]}], "]"}], "}"}]}], "]"}], ",",
    
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellLabel->"Out[9]=",
 CellID->1275784264]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 5.1840450}", "context" -> "", 
    "keywords" -> {"XML", "MathML", "notebook", "expression", "typesetting"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MIME type: text/mathml, application/mathml+xml MathML mathematical \
markup language. Used for integrating mathematical formulas in web documents. \
Rendering of embedded MathML is supported by a number of browsers and browser \
additions. Specifies the presentation and the semantic content of \
mathematical formulas. XML-based format. Based on a draft that was derived \
from the Mathematica typesetting language. Introduced in 1999 and updated in \
2003 by the W3C math working group.", "synonyms" -> {}, "title" -> "MathML", 
    "type" -> "Format", "uri" -> "ref/format/MathML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18824, 660, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34839, 1157}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2224, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2847, 76, 151, 6, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3001, 84, 627, 13, 70, "FormatUsage",
 CellID->37585799],
Cell[3631, 99, 343, 12, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[4011, 116, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4078, 119, 299, 9, 70, "FormatNotes",
 CellID->28652],
Cell[4380, 130, 336, 11, 70, "FormatNotes",
 CellID->8194],
Cell[4719, 143, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4761, 146, 430, 14, 70, "FormatNotes",
 CellID->28396],
Cell[5194, 162, 572, 20, 70, "FormatNotes",
 CellID->1670417185],
Cell[5769, 184, 435, 15, 70, "FormatNotes",
 CellID->7572],
Cell[6207, 201, 179, 4, 70, "FormatNotes",
 CellID->434469221],
Cell[6389, 207, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6431, 210, 344, 11, 70, "FormatNotes",
 CellID->29174],
Cell[6778, 223, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[7361, 246, 710, 25, 70, "FormatNotes",
 CellID->32611],
Cell[8074, 273, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[8115, 276, 522, 18, 70, "FormatNotes",
 CellID->20289],
Cell[8640, 296, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[9718, 338, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[10382, 362, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[11200, 392, 752, 26, 70, "FormatNotes",
 CellID->72326222],
Cell[11955, 420, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11996, 423, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[12360, 439, 355, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[12752, 458, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12811, 461, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[13010, 471, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13723, 487, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[13767, 490, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[13842, 493, 1047, 26, 70, "2ColumnTableMod",
 CellID->1865694418],
Cell[14892, 521, 383, 14, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[15312, 540, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[15364, 543, 182, 7, 70, "FormatNotes",
 CellID->806641260],
Cell[15549, 552, 963, 22, 70, "3ColumnTableMod",
 CellID->21895],
Cell[16515, 576, 391, 11, 70, "FormatNotes",
 CellID->5303]
}, Closed]],
Cell[CellGroupData[{
Cell[16943, 592, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[17001, 595, 1054, 34, 70, "SeeAlso",
 CellID->1748583473]
}, Open  ]],
Cell[CellGroupData[{
Cell[18092, 634, 58, 1, 70, "MoreAboutSection",
 CellID->532038560],
Cell[18153, 637, 134, 2, 70, "MoreAbout"],
Cell[18290, 641, 133, 2, 70, "MoreAbout"],
Cell[18426, 645, 113, 2, 70, "MoreAbout"],
Cell[18542, 649, 113, 2, 70, "MoreAbout"],
Cell[18658, 653, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18824, 660, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18940, 666, 60, 1, 70, "ExampleSection",
 CellID->187051597],
Cell[19003, 669, 141, 4, 70, "ExampleText",
 CellID->744370389],
Cell[CellGroupData[{
Cell[19169, 677, 228, 8, 70, "Input",
 CellID->2094284799],
Cell[19400, 687, 251, 4, 70, "Output",
 CellID->1950186364]
}, Open  ]],
Cell[19666, 694, 97, 1, 70, "ExampleText",
 CellID->266098761],
Cell[CellGroupData[{
Cell[19788, 699, 288, 9, 70, "Input",
 CellID->1886799234],
Cell[20079, 710, 603, 9, 70, "Output",
 CellID->1691194236]
}, Open  ]],
Cell[20697, 722, 77, 1, 70, "ExampleText",
 CellID->88270473],
Cell[CellGroupData[{
Cell[20799, 727, 356, 10, 70, "Input",
 CellID->1260923073],
Cell[21158, 739, 353, 6, 70, "Output",
 CellID->965459315]
}, Open  ]],
Cell[21526, 748, 126, 3, 70, "ExampleDelimiter",
 CellID->1579017654],
Cell[21655, 753, 149, 6, 70, "ExampleText",
 CellID->751895924],
Cell[CellGroupData[{
Cell[21829, 763, 852, 23, 70, "Input",
 CellID->1641568820],
Cell[22684, 788, 795, 22, 70, "Output",
 CellID->644095856]
}, Open  ]],
Cell[CellGroupData[{
Cell[23516, 815, 108, 3, 70, "Input",
 CellID->2146343128],
Cell[23627, 820, 277, 11, 70, "Output",
 CellID->2001470912]
}, Open  ]],
Cell[23919, 834, 78, 1, 70, "ExampleText",
 CellID->2113710460],
Cell[CellGroupData[{
Cell[24022, 839, 185, 5, 70, "Input",
 CellID->523877819],
Cell[24210, 846, 562, 8, 70, "Output",
 CellID->537771376]
}, Open  ]],
Cell[24787, 857, 114, 3, 70, "ExampleText",
 CellID->976618786],
Cell[CellGroupData[{
Cell[24926, 864, 110, 3, 70, "Input",
 CellID->276517309],
Cell[25039, 869, 1151, 30, 70, "Output",
 CellID->699536345]
}, Open  ]],
Cell[CellGroupData[{
Cell[26227, 904, 107, 3, 70, "Input",
 CellID->702172773],
Cell[26337, 909, 396, 16, 70, "Output",
 CellID->1781866737]
}, Open  ]],
Cell[26748, 928, 218, 7, 70, "ExampleText",
 CellID->1686474025],
Cell[CellGroupData[{
Cell[26991, 939, 111, 3, 70, "Input",
 CellID->1076011616],
Cell[27105, 944, 85, 2, 70, "Output",
 CellID->1906467848]
}, Open  ]],
Cell[27205, 949, 208, 8, 70, "ExampleText",
 CellID->1321015720],
Cell[CellGroupData[{
Cell[27438, 961, 149, 4, 70, "Input",
 CellID->1540884148],
Cell[27590, 967, 238, 6, 70, "Output",
 CellID->1134576263]
}, Open  ]],
Cell[27843, 976, 86, 1, 70, "ExampleText",
 CellID->1625263354],
Cell[CellGroupData[{
Cell[27954, 981, 151, 4, 70, "Input",
 CellID->1220900268],
Cell[28108, 987, 203, 7, 70, "Output",
 CellID->1915516891]
}, Open  ]],
Cell[28326, 997, 87, 1, 70, "ExampleText",
 CellID->1956684485],
Cell[CellGroupData[{
Cell[28438, 1002, 155, 4, 70, "Input",
 CellID->1632677546],
Cell[28596, 1008, 4735, 112, 70, "Output",
 CellID->1275784264]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[33370, 1125, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

