(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    386370,       6498]
NotebookOptionsPosition[    381275,       6332]
NotebookOutlinePosition[    382643,       6370]
CellTagsIndexPosition[    382556,       6365]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"OBJ\\\"\"\>", 
       6->"\<\"\\\"OFF\\\"\"\>", 7->"\<\"\\\"POV\\\"\"\>", 
       8->"\<\"\\\"RIB\\\"\"\>", 9->"\<\"\\\"STL\\\"\"\>", 
       10->"\<\"\\\"X3D\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>",
        2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       6->"\<\"New in 6.0: Import & Export Formats\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Maya ",
 StyleBox["(.ma)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell["\<\
Autodesk Maya scene description format.
3D geometry format.
Native format of the Maya modeling, animation and rendering software.
Used for storage and interchange of 3D graphical objects.
ASCII format.
Can store multiple 3D objects as polygon primitives.\
\>", "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " supports Maya 4.0 ASCII files."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ma\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to a binary ",
 "Maya",
 " file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ma\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a binary ",
 "Maya",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ma\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ma\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ma\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the Maya format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell["General elements:", "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "Maya",
     " file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a 3D geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "the polygon elements in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " element corresponds to the first argument of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4998]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell["Advanced option:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by Maya the vertical axis \
corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["y", "TI"]}]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when exporting to Maya."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->167237190],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->791686789],

Cell["Get the image of a polyhedron:", "ExampleText",
 CellID->402942170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolyhedronData", "[", 
  "\"\<MetagyrateDiminishedRhombicosidodecahedron\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1823819904],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJwNk2k81AkAhgcxJsf4G8YMM8yQlKLYcoxWkiuVTWgRIaqVX4c0W670S4eU
I5vCyrGO3ViJSsfE/40lxSBrikjCRluxZJAc68Pz7Xmfby9/75Gd+2QpFIrl
InKLmCXUzbWPEajiv/pgnaSFw+afjrXmsLGPWubKbCIQk9MpUZjQRt0t/y6z
Bzqg335LVScJpBQVdFQWsiFwduVGWDLhsOaZp1cGAW/9IsQpcZFWJ4qX7GBh
R6GfpLJJDdLQjgFKrBaClctyz0dw0XLOpr3dSQ2ZDiPBA5McpHbtX+aUqAG7
MN/OV3w1TG5fv/AzTQOcRBmXhiVs1G8RXAvPpQOFZ672hWnhjL2/fv8ZBjSu
Bph0n6Qjulq6xG6MgyLh080l8bpwp/6jfqNDFfqJfHHHSh5kTQ10G2TYeKQ6
FHBkSgVrr5l//f4rA6ohtcdjuzjIjc8sLclTgeXRU7+9nmCAn/fnsIWtJqbE
NfYaUSoYTRhTF0SxkReqdC5Oj4dN0jHjL7eUUb9ZbEDUaEPSEbnynoRA0kat
Wr8EZWw05bk+4PMwQx10jX3JQfjdZyoZZsqw02nIOb+4V3RoqbGw0cSu6aD3
j1lLsSedeBgGAh4BkshPy7QRJNLrm1WlQe7oKms3gRYSVqfMl9oQIK1bi5w0
FCEq8bQw0OVjaKnVynIFFgLHMnqzsqm47NHcF/ScAd3VkZJaRz2cKHJ6d19I
Re59X7/WUgI+wtPa/nuYaBkNO8n/gQrPNnGzqZkWbDylN9LKebCWnpKuV6Mi
2sbI2aWOgeWJvX9RptRx06inOntEHrNnv5ssK+agqiJ5Xc5rNcyFy3gpNMqj
y83jjgKTj87Baa/93TpQXF7+o0G+PPpOa4dXK/CgZEr5lTKhDtluxr7hajmI
dpbmpVwhEGJ0+bXZFQ7Iz7SIYjdZCCquKH3UZyOEVkhLt1ODT+nd0RfxMvBT
u6noK8/H8ESofCSpiQKYz5hsWiArwhtbG5MZsB+ROpT46eHpiuSFA1/myXrJ
rq0WRwlEWs5ddBAycbC608SmeJ48MfJMlC5lYuu9O14KIh42NM4bhayYJ3N9
DCzKLzDguG33umEVBswX2Jpeojkydz74vwhPXQScc7TOu02g+Ync0JKMb+RH
/xfGgmkepoqF9dvHdbApc9x/yHeGXOB6Os4FEDhI1FR926KN9XqH3Q84T5MF
04fq33YxkdV7wkYUSGDvJWHcT9GT5FvjWvmKNm2ovPFVvc4kMKcj7plxnySX
jgpnP35e7D/m7a9ZxUITzdCx8rSUbEpGyssVPAi2lRewYjTQUzCX5MAbJ6c3
hB+38GfApdOIf1yTi9SkvYaiY2PkN2Y1929vBrw01NNNojRhpV/mkWw4Rt5e
szbZvJcFkYFtd9T3PNCVHhfanh0hbeXi6KG/68EkZstUhDoXtNkkqvDuB9Iq
4JFWlgsDziPtTwbd2JhtLLgRYzBEUqqoZXKlTJQWm2ZTxAwEjVvN6F98T1a1
RHGD13LwvCujulGsCz/SLdV4eoCMNmysbE5b7KdNXB/cyoZ3fuXXU5cGSMHw
7s8d+drgFBFHehZ/Pfyv45Odbf1kryndLbCIiYf2KaKQBi5GsuYDM736ybkQ
/658RV2E8+MlttmauGRb4ROb0EZy3b3H6lIXfW+Bn2SBjV+C03aEWDeT/WKf
N6lTbNAlpbWWbA56Tw5Ndj94Tk51LOvZ8AcLFw5lKERmMOEWoHXV8V09KXJf
3kijc9D9gXaou4KF/wH1qZQI
   "], Polygon3DBox[{{32, 22, 20, 30}, {30, 20, 27}, {20, 11, 17, 27}, {22, 
     13, 5, 11, 20}, {11, 7, 17}, {17, 7, 12, 21}, {5, 1, 7, 11}, {5, 2, 1}, {
     2, 4, 3, 1}, {1, 3, 8, 12, 7}, {4, 6, 3}, {3, 6, 14, 8}, {30, 27, 36, 
     41}, {41, 36, 45}, {36, 31, 42, 45}, {27, 17, 21, 31, 36}, {31, 33, 
     42}, {42, 33, 37, 46}, {21, 23, 33, 31}, {21, 12, 23}, {12, 8, 18, 23}, {
     23, 18, 28, 37, 33}, {8, 14, 18}, {18, 14, 24, 28}, {41, 45, 52, 50}, {
     50, 52, 53}, {52, 54, 55, 53}, {45, 42, 46, 54, 52}, {46, 49, 54}, {54, 
     49, 51, 55}, {37, 38, 49, 46}, {37, 28, 38}, {28, 24, 34, 38}, {38, 34, 
     40, 51, 49}, {24, 26, 34}, {34, 26, 29, 40}, {50, 53, 47, 43}, {43, 47, 
     44, 35, 25, 15, 9, 13, 22, 32}, {53, 55, 48, 44, 47}, {48, 39, 35, 44}, {
     55, 51, 48}, {51, 40, 39, 48}, {39, 29, 19, 25, 35}, {40, 29, 39}, {29, 
     26, 16, 19}, {13, 9, 2, 5}, {25, 19, 10, 15}, {15, 10, 4, 2, 9}, {19, 16,
      10}, {10, 16, 6, 4}, {32, 30, 41, 50, 43}, {16, 26, 24, 14, 
     6}}]]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1245547127]
}, Open  ]],

Cell["Export it to a Maya entity file:", "ExampleText",
 CellID->1233112199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<polyhedron.ma\>\"", ",", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17199],

Cell[BoxData["\<\"polyhedron.ma\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->861205638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1424743152],

Cell["Use SphericalPlot3D to create a solid 3D geometry:", "ExampleText",
 CellID->1215491614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", "\[Theta]"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<RedBlueTones\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1903106234],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyNfXm8jtX6vkZSYpuHhpMScUQI6dXaijRsTqpzMs9zRWaikgwZGiTzTJSo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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3XW4NlXVBvB5zxMvIKWIdEsJKFIS0iECEtKdIqEgICEqXYI0KC0pDYJI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        "]]]}, {}, {}, {}}, {}},
   VertexColors->{
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.8079907454605841, 0.8482559574234044, 0.779173674721117], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8471356723147693, 0.848322115533647, 0.743875566318748], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8419086825773979, 0.8483132814958527, 0.7485888935668759], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8581393024876561, 0.8388593101687083, 0.721820114891925], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.6375241911674806, 0.7889798099995133, 0.828845953539745], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8621097079648561, 0.8017152067180416, 0.6706987323585397], 
     RGBColor[0.8193090107918465, 0.6352501585473148, 0.5212868018406838], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.5014983053673207, 0.7110034463603374, 0.8073817987381057], 
     RGBColor[0.7447512591920866, 0.8362233180441756, 0.8151640465070086], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8563752708238457, 0.7407555408141201, 0.602911895439858], 
     RGBColor[0.7550064921679905, 0.5011951926910476, 0.4393761614385036], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.8586694674502792, 0.8338994887271276, 0.7149939189238599], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8575723454844284, 0.8441633300480139, 0.729120030733878], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.8527254012601542, 0.8483315626302061, 0.7388351466753795], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.139681, 0.311666, 0.550652], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.15309636743230903`, 0.33586181464533976`, 0.5690835044945493],
      
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8594091107916072, 0.8269799463920551, 0.7054705615722141], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.8346164086117439, 0.8483009569597325, 0.7551645471093709], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.450385, 0.157961, 0.217975], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.4884049013796483, 0.18468771742251117`, 0.23752337721676853`],
      
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.2201078346449573, 0.45672298732441174`, 0.6611512145553002], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.43186419207594223`, 0.6692282806920952, 0.79289277199246], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.8592678684312741, 0.8283013028313303, 0.7072891427659925], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8492638464794459, 0.8483257123210807, 0.7419565303567267], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.7203730802233016, 0.43258296854318035`, 0.3990778807393107], 
     RGBColor[0.633996906348939, 0.31126970533089704`, 0.3244620986306351], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.25299237263389684`, 0.5160331918262847, 0.7063316028527226], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.858657796080745, 0.8340086772117485, 0.7151441948969482], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.8420237526651569, 0.8483134759736604, 0.7484851315533021], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.5945302017469082, 0.25929024955356933`, 0.2920889423166444], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8317855011399834, 0.8482961724958529, 0.7577172579417988], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.16956813575286056`, 0.3655701215684284, 0.5917142280558171], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.3068578337744883, 0.56478229489779, 0.7348567047034666], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.8598910243490887, 0.8224715285147971, 0.6992656317579902], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8579234452862532, 0.840878706491206, 0.724599407492863], 
     RGBColor[0.8360089419173987, 0.848303310454281, 0.7539088597054829], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.5526972572455231, 0.22988309051136846`, 0.2705800443572467], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.1430548185529245, 0.3177509834166279, 0.5552873223000259], 
     RGBColor[0.8306894864744746, 0.8482943201419236, 0.7587055659444635], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[
     0.46745090256643473`, 0.16995775798468443`, 0.22674963351580033`], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.4546768883132767, 0.16097805375330945`, 0.2201817246014763], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.8598074120381629, 0.8232537419044905, 0.700342191055494], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.8298651379755376, 0.848292926925912, 0.7594489047373855], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567], 
     RGBColor[0.5170446054907382, 0.20482047029838177`, 0.2522488162374996], 
     RGBColor[0.1920815746001296, 0.4061751214781442, 0.6226456618309244], 
     RGBColor[0.36759800155861444`, 0.6155322470420304, 0.7630562340119154], 
     RGBColor[0.8596962450752704, 0.8242937357272089, 0.7017735332364716], 
     RGBColor[0.857126, 0.848339, 0.734867], 
     RGBColor[0.6759667978405994, 0.37021541067001695`, 0.3607176554375567]},
   VertexNormals->CompressedData["
1:eJxcXXk8lt3WRkUpmRqpyFRpMDSo1HObKZWIRg1Es+aiRINUSiWKJjKVBimK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    "]],
  Boxed->False,
  Lighting->"Neutral",
  Method->{},
  PlotRange->{{-1., 1.}, {-1., 1.}, {-3., 3.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->495702822]
}, Open  ]],

Cell["Export it to Maya:", "ExampleText",
 CellID->845949702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.ma\>\"", ",", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1335371818],

Cell[BoxData["\<\"test.ma\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->242550329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118231029],

Cell["Export inline 3D graphics:", "ExampleText",
 CellID->686530928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<dini.ma\>\"", ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxUmXc41+37/620S7JSSUWkJS1UTkmhbCmaKpWQUYqWiJZI00oyEw17ZJ1v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     "], {{
       {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxFnWXYlUXXhnfvbb12dyc2SIiCStmNYINYgIpgAmIQSioqYoDYYKAICooF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          "]]]}, {}, {}, {}}, {}},
     VertexNormals->CompressedData["
1:eJxM2nc01u8bB3BJUkklKkJGRhJJVJRbZEUppEhGZVMyGjQ0EJI0SJKVEZK9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      "]],
    Boxed->False,
    ImageSize->{180., 180.},
    PlotRange->{{-0.997759342072175, 
     0.9999924553399645}, {-0.9994340166304078, 
     0.9994340166304077}, {-2.6489452557652227`, 2.5401499488673784`}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ViewAngle->0.27872144458044706`,
    ViewPoint->{2.6989233864589774`, 1.451451419345165, -1.4349569092156416`},
    
    ViewVertical->{1.8107628207379283`, 1.4114261011064237`, 
     0.4673511505185708}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->682081854],

Cell[BoxData["\<\"dini.ma\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->875636560]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Maya - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 5.7778102}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Autodesk Maya scene description format. 3D geometry format. Native \
format of the Maya modeling, animation and rendering software. Used for \
storage and interchange of 3D graphical objects. ASCII format. Can store \
multiple 3D objects as polygon primitives.", "synonyms" -> {}, "title" -> 
    "Maya", "type" -> "Format", "uri" -> "ref/format/Maya"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16009, 538, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 382422, 6358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3282, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3905, 94, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[4009, 100, 301, 8, 70, "FormatUsage",
 CellID->20778],
Cell[4313, 110, 199, 7, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[4549, 122, 53, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[4605, 125, 476, 18, 70, "FormatNotes",
 CellID->12927],
Cell[5084, 145, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[5126, 148, 530, 20, 70, "FormatNotes",
 CellID->9310],
Cell[5659, 170, 1074, 40, 70, "FormatNotes",
 CellID->5974],
Cell[6736, 212, 660, 22, 70, "FormatNotes",
 CellID->7590],
Cell[7399, 236, 815, 28, 70, "FormatNotes",
 CellID->20356],
Cell[8217, 266, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[8258, 269, 231, 8, 70, "FormatNotes",
 CellID->32080],
Cell[8492, 279, 207, 7, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[8736, 291, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[8790, 294, 56, 1, 70, "FormatNotes",
 CellID->17282],
Cell[8849, 297, 373, 9, 70, "2ColumnTableMod",
 CellID->1825],
Cell[9225, 308, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[9267, 311, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[9338, 314, 1472, 37, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[10813, 353, 304, 10, 70, "FormatNotes",
 CellID->4998]
}, Open  ]],
Cell[CellGroupData[{
Cell[11154, 368, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[11206, 371, 60, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[11269, 374, 468, 12, 70, "3ColumnTableMod",
 CellID->28047],
Cell[11740, 388, 233, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[11976, 397, 702, 25, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[12715, 427, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[12768, 430, 2040, 69, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[14845, 504, 58, 1, 70, "MoreAboutSection",
 CellID->167237190],
Cell[14906, 507, 150, 2, 70, "MoreAbout"],
Cell[15059, 511, 151, 2, 70, "MoreAbout"],
Cell[15213, 515, 134, 2, 70, "MoreAbout"],
Cell[15350, 519, 133, 2, 70, "MoreAbout"],
Cell[15486, 523, 165, 2, 70, "MoreAbout"],
Cell[15654, 527, 156, 2, 70, "MoreAbout"],
Cell[15813, 531, 159, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16009, 538, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16125, 544, 60, 1, 70, "ExampleSection",
 CellID->791686789],
Cell[16188, 547, 73, 1, 70, "ExampleText",
 CellID->402942170],
Cell[CellGroupData[{
Cell[16286, 552, 163, 4, 70, "Input",
 CellID->1823819904],
Cell[16452, 558, 2929, 47, 70, "Output",
 CellID->1245547127]
}, Open  ]],
Cell[19396, 608, 76, 1, 70, "ExampleText",
 CellID->1233112199],
Cell[CellGroupData[{
Cell[19497, 613, 146, 4, 70, "Input",
 CellID->17199],
Cell[19646, 619, 91, 2, 70, "Output",
 CellID->861205638]
}, Open  ]],
Cell[19752, 624, 126, 3, 70, "ExampleDelimiter",
 CellID->1424743152],
Cell[19881, 629, 94, 1, 70, "ExampleText",
 CellID->1215491614],
Cell[CellGroupData[{
Cell[20000, 634, 665, 18, 70, "Input",
 CellID->1903106234],
Cell[20668, 654, 220576, 3343, 70, "Output",
 CellID->495702822]
}, Open  ]],
Cell[241259, 4000, 61, 1, 70, "ExampleText",
 CellID->845949702],
Cell[CellGroupData[{
Cell[241345, 4005, 145, 4, 70, "Input",
 CellID->1335371818],
Cell[241493, 4011, 85, 2, 70, "Output",
 CellID->242550329]
}, Open  ]],
Cell[241593, 4016, 125, 3, 70, "ExampleDelimiter",
 CellID->118231029],
Cell[241721, 4021, 69, 1, 70, "ExampleText",
 CellID->686530928],
Cell[CellGroupData[{
Cell[241815, 4026, 139306, 2295, 70, "Input",
 CellID->682081854],
Cell[381124, 6323, 85, 2, 70, "Output",
 CellID->875636560]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[381248, 6330, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

