(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23278,        804]
NotebookOptionsPosition[     18476,        657]
NotebookOutlinePosition[     20137,        699]
CellTagsIndexPosition[     20052,        694]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "New in 6.0: Data Handling & Data Sources" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60DataHandlingAndDataSources"], 
         "New in 6.0: Import & Export Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60ImportAndExportFormats"], 
         "Tabular & Spreadsheet Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/TabularAndSpreadsheetFormats"], "XML Formats" :> 
         Documentation`HelpLookup["paclet:guide/XMLFormats"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
      2->"\<\"Listing of All Formats\"\>", 
      3->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
      4->"\<\"New in 6.0: Import & Export Formats\"\>", 
      5->"\<\"Tabular & Spreadsheet Formats\"\>", 
      6->"\<\"XML Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ODS ",
 StyleBox["(.ods)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->16827],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/vnd.oasis.opendocument.spreadsheet", "InlineCode"],
 "\nOpenDocument spreadsheet file.\nUsed for storage and exchange of \
spreadsheet data and formulas.\nIs part of the OASIS Open Document Format \
(ODF) family of file formats.\nODS is an acronym derived from OpenDocument \
Spreadsheet.\nIs native spreadsheet format of OpenOffice.org 2.0.\nXML-based \
format, usually ZIP-compressed.\nSupports multiple sheets in one file.\n\
Developed by the OASIS industry consortium, based upon the OpenOffice.org SXC \
format.\nApproved as ISO/IEC 26300 standard in 2006."
}], "FormatUsage",
 CellID->9961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the ODS standard."
}], "FormatNotes",
 CellID->491]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->2995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", "]"}]], "InlineFormula"],
 " imports all sheets of an ",
 "ODS",
 " file, returning the result as a list of arrays."
}], "FormatNotes",
 CellID->11942],

Cell["", "WeakDivider",
 CellID->5436],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", "]"}], " "}]], "InlineFormula"],
 "returns the sheets of an ODS file as an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are full arrays containing numerical and textual data, Boolean values, and \
date specifications."
}], "FormatNotes",
 CellID->32391],

Cell["", "WeakDivider",
 CellID->3902],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "ODS",
 " file."
}], "FormatNotes",
 CellID->153],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->292],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->12382],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<ODS\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ODS\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17421],

Cell["", "WeakDivider",
 CellID->14771],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->11538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ODS format."
}], "FormatNotes",
 CellID->1869]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->19912],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->25667],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->26299],

Cell["", "WeakDivider",
 CellID->17035],

Cell["Data representation elements:", "FormatNotes",
 CellID->9894],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of full arrays, representing all sheets", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Formulas\>\"", Cell[
    "all ODS formulas as text", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->146182287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->812283704],

Cell[TextData[{
 "ODS data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ",",
 " ",
 "and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell[TextData[{
 "ODS",
 " error cells are imported as ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->819249840],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "[\"",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 ".ods\",",
 Cell[BoxData[
  RowBox[{"\"\<Formulas\>\"", "]"}]], "InlineFormula"],
 "gives spreadsheet formulas for each cell in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are arrays corresponding to the sheets of an ODS file."
}], "FormatNotes",
 CellID->498669149],

Cell["Importing parts of a data sheet:", "FormatNotes",
 CellID->1203739437],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     RowBox[{
      StyleBox["k", "TI"], Cell["", "TableText"]}]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet, given as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     StyleBox["k", "TI"], ",", " ", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     StyleBox["k", "TI"], ",", " ", 
     StyleBox["m", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "cell ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1453356619],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Data\>\"", ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 "returns the first sheet as an array."
}], "FormatNotes",
 CellID->2093805552],

Cell["\<\
The following can be used to select or specify individual sheets by name:\
\>", "FormatNotes",
 CellID->28703],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Sheets\>\"", Cell[
    "list of sheet names", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " of sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", 
     StyleBox["m", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "cell ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " in sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->487595630],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Sheets\>\"", ",", " ", 
       ButtonBox["All",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/All"]}], "}"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ods\>\"", ",", " ", "\"\<Data\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->426627287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " yields spreadsheets as full rectangular arrays. "
}], "FormatNotes",
 CellID->1651196649]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->159661309],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->305148316],

Cell["\<\
Import tabular data from an ODS file and format it as a table: \
\>", "ExampleText",
 CellID->1567771885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "@", 
   RowBox[{"Import", "[", "\"\<ExampleData/population.ods\>\"", "]"}]}], " ", 
  "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1597788241],

Cell[BoxData[
 TagBox[GridBox[{
    {"1313973713", "\<\"China\"\>"},
    {"1095351995", "\<\"India\"\>"},
    {"298444215", "\<\"United States\"\>"},
    {"245452739", "\<\"Indonesia\"\>"},
    {"188078227", "\<\"Brazil\"\>"},
    {"165803560", "\<\"Pakistan\"\>"},
    {"147365352", "\<\"Bangladesh\"\>"},
    {"142893540", "\<\"Russia\"\>"},
    {"131859731", "\<\"Nigeria\"\>"},
    {"127463611", "\<\"Japan\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[1]//TableForm=",
 CellID->1657501273]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ODS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 18.2156286}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/vnd.oasis.opendocument.spreadsheet OpenDocument \
spreadsheet file. Used for storage and exchange of spreadsheet data and \
formulas. Is part of the OASIS Open Document Format (ODF) family of file \
formats. ODS is an acronym derived from OpenDocument Spreadsheet. Is native \
spreadsheet format of OpenOffice.org 2.0. XML-based format, usually \
ZIP-compressed. Supports multiple sheets in one file. Developed by the OASIS \
industry consortium, based upon the OpenOffice.org SXC format. Approved as \
ISO/IEC 26300 standard in 2006.", "synonyms" -> {}, "title" -> "ODS", "type" -> 
    "Format", "uri" -> "ref/format/ODS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16952, 600, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19918, 687}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1479, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2102, 58, 102, 4, 70, "ObjectNameAlt",
 CellID->16827],
Cell[2207, 64, 651, 11, 70, "FormatUsage",
 CellID->9961],
Cell[2861, 77, 200, 7, 70, "FormatNotes",
 CellID->491]
}, Open  ]],
Cell[CellGroupData[{
Cell[3098, 89, 52, 1, 70, "ImportExportSection",
 CellID->2995],
Cell[3153, 92, 333, 11, 70, "FormatNotes",
 CellID->11942],
Cell[3489, 105, 38, 1, 70, "WeakDivider",
 CellID->5436],
Cell[3530, 108, 822, 27, 70, "FormatNotes",
 CellID->32391],
Cell[4355, 137, 38, 1, 70, "WeakDivider",
 CellID->3902],
Cell[4396, 140, 350, 13, 70, "FormatNotes",
 CellID->153],
Cell[4749, 155, 572, 20, 70, "FormatNotes",
 CellID->292],
Cell[5324, 177, 582, 21, 70, "FormatNotes",
 CellID->12382],
Cell[5909, 200, 703, 25, 70, "FormatNotes",
 CellID->17421],
Cell[6615, 227, 39, 1, 70, "WeakDivider",
 CellID->14771],
Cell[6657, 230, 236, 9, 70, "FormatNotes",
 CellID->11538],
Cell[6896, 241, 205, 7, 70, "FormatNotes",
 CellID->1869]
}, Closed]],
Cell[CellGroupData[{
Cell[7138, 253, 51, 1, 70, "ElementsSection",
 CellID->19912],
Cell[7192, 256, 192, 8, 70, "FormatNotes",
 CellID->25667],
Cell[7387, 266, 668, 13, 70, "2ColumnTableMod",
 CellID->26299],
Cell[8058, 281, 39, 1, 70, "WeakDivider",
 CellID->17035],
Cell[8100, 284, 67, 1, 70, "FormatNotes",
 CellID->9894],
Cell[8170, 287, 496, 11, 70, "2ColumnTableMod",
 CellID->146182287],
Cell[8669, 300, 257, 9, 70, "FormatNotes",
 CellID->812283704],
Cell[8929, 311, 587, 23, 70, "FormatNotes",
 CellID->373727629],
Cell[9519, 336, 218, 9, 70, "FormatNotes",
 CellID->819249840],
Cell[9740, 347, 824, 29, 70, "FormatNotes",
 CellID->498669149],
Cell[10567, 378, 76, 1, 70, "FormatNotes",
 CellID->1203739437],
Cell[10646, 381, 1664, 53, 70, "2ColumnTableMod",
 CellID->1453356619],
Cell[12313, 436, 378, 12, 70, "FormatNotes",
 CellID->2093805552],
Cell[12694, 450, 120, 3, 70, "FormatNotes",
 CellID->28703],
Cell[12817, 455, 1457, 43, 70, "2ColumnTableMod",
 CellID->487595630],
Cell[14277, 500, 720, 26, 70, "FormatNotes",
 CellID->426627287],
Cell[15000, 528, 223, 7, 70, "FormatNotes",
 CellID->1651196649]
}, Open  ]],
Cell[CellGroupData[{
Cell[15260, 540, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[15312, 543, 177, 7, 70, "FormatNotes",
 CellID->31322],
Cell[15492, 552, 460, 13, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[15989, 570, 58, 1, 70, "MoreAboutSection",
 CellID->159661309],
Cell[16050, 573, 134, 2, 70, "MoreAbout"],
Cell[16187, 577, 133, 2, 70, "MoreAbout"],
Cell[16323, 581, 165, 2, 70, "MoreAbout"],
Cell[16491, 585, 156, 2, 70, "MoreAbout"],
Cell[16650, 589, 149, 2, 70, "MoreAbout"],
Cell[16802, 593, 113, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16952, 600, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[17068, 606, 60, 1, 70, "ExampleSection",
 CellID->305148316],
Cell[17131, 609, 115, 3, 70, "ExampleText",
 CellID->1567771885],
Cell[CellGroupData[{
Cell[17271, 616, 209, 6, 70, "Input",
 CellID->1597788241],
Cell[17483, 624, 927, 26, 70, "Output",
 CellID->1657501273]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[18449, 655, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

