(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    263452,       5094]
NotebookOptionsPosition[    255918,       4849]
NotebookOutlinePosition[    257473,       4891]
CellTagsIndexPosition[    257386,       4886]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"VRML\"" :> Documentation`HelpLookup["paclet:ref/format/VRML"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"], 
          "\"ZPR\"" :> Documentation`HelpLookup["paclet:ref/format/ZPR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"NOFF\\\"\"\>", 7->"\<\"\\\"OBJ\\\"\"\>", 
       8->"\<\"\\\"PLY\\\"\"\>", 9->"\<\"\\\"POV\\\"\"\>", 
       10->"\<\"\\\"RIB\\\"\"\>", 11->"\<\"\\\"VRML\\\"\"\>", 
       12->"\<\"\\\"X3D\\\"\"\>", 
       13->"\<\"\\\"ZPR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>",
        2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"New in 6.0: Import & Export Formats\"\>", 
       6->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "OFF ",
 StyleBox["(.off, .coff, .noff, .cnoff)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell["\<\
OFF 3D geometry format. 
Used for storing and exchanging 3D models. 
OFF is an acronym for Object File Format.
Occasionally called COFF if color information is present.
Related to NOFF and CNOFF.
ASCII or binary format.
Represents a single 2D or 3D object.
Stores a collection of planar polygons with possibly shared vertices. 
Supports polygon and vertex colors.\
\>", "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support ASCII and binary versions of the OFF file format."
}], "FormatNotes",
 CellID->2061495838],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " reads and writes vertex or face colors."
}], "FormatNotes",
 CellID->59388568],

Cell[TextData[{
 "If both vertex and face colors are present in the file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns the vertex color information."
}], "FormatNotes",
 CellID->855453080]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", "]"}]], "InlineFormula"],
 "imports an OFF file as graphics."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics to a binary OFF file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 "For OFF files representing a 3D object, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell[TextData[{
 "Planar objects are imported as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}]}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->125287718],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "OFF",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<OFF\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<OFF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a binary ",
 "OFF",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).off\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the OFF",
 " ",
 "format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[TextData[{
     "2D OFF file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "3D geometry represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "OFF",
     " file as a ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonColors\>\"", Cell["\<\
face color information, given as a list of color primitives associated with \
each polygon\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "the polygon elements in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexColors\>\"", Cell["\<\
colors associated with each vertex, given as a list of color primitives\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element to represent 3D geometries, and the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for 2-dimensional objects."
}], "FormatNotes",
 CellID->13037],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " element corresponds to the first argument of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4998],

Cell[TextData[{
 "When rendering an OFF color model, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically uses the setting",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], "->", "\"\<Neutral\>\""}]}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1495251562]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Lighting",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Lighting"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what simulated lighting to use in coloring 3D surfaces", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "All options of ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " can be given when importing from OFF."
}], "FormatNotes",
 CellID->1022956994],

Cell["Detailed properties and settings:", "FormatNotes",
 CellID->19539],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BinaryFormat\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the file is in ASCII or binary format", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InvertNormals\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to invert the orientation of vertex normals", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28047],

Cell[TextData[{
 "Binary OFF files store information as ",
 Cell[BoxData["\"\<Integer32\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"\"\<Real32\>\"", " "}]], "InlineFormula"],
 "data types, always using the setting ",
 Cell[BoxData[
  RowBox[{"\"\<ByteOrdering\>\"", "->", "1"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1486431821],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the OFF format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["z", "TI"]}], ",", 
     StyleBox["y", "TI"]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when importing from OFF, and the inverse \
transformation when exporting to OFF."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZPR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZPR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1919681360]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->161113867],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->7321461],

Cell["This imports a 3D model of a sea shell:", "ExampleText",
 CellID->1179728456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{"\"\<ExampleData/seashell.off\>\"", ",", 
   RowBox[{"Background", " ", "\[Rule]", " ", "Gray"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], GraphicsComplex3DBox[CompressedData["
1:eJxlXAdYjf8XjygR2ZJRySzxQwnFSYhkhDIqEWVlRCWVFtp777333uN023tv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    "], 
    {RGBColor[0.729412, 0.556863, 0.898039], Polygon3DBox[CompressedData["
1:eJwt3GOQHmYfRvEmaZO6sW3btm3btm27iFXEbGMWsYpYRaymMdt373l/H+65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      "]]}]},
  Background->GrayLevel[0.5],
  Boxed->False,
  Lighting->"Neutral"]], "Output",
 CellLabel->"Out[1]=",
 CellID->454024089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596643543],

Cell["Import a simple OFF file that contains vertex color data:", \
"ExampleText",
 CellID->124805946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/vertcube.off\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1186879358],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], 
   GraphicsComplex3DBox[{{1., -1., 1.}, {1., 1., 1.}, {1., -1., -1.}, {1., 
    1., -1.}, {-1., -1., 1.}, {-1., 1., 1.}, {-1., -1., -1.}, {-1., 1., -1.}},
     Polygon3DBox[{{1, 3, 4, 2}, {5, 6, 8, 7}, {1, 5, 7, 3}, {2, 4, 8, 6}, {1,
      2, 6, 5}, {3, 7, 8, 4}}],
    VertexColors->{
      RGBColor[0.05, 0.8, 0.1, 0.75], 
      RGBColor[0.2, 0.05, 0.8, 0.75], 
      RGBColor[0.9, 0.9, 0.02, 0.75], 
      RGBColor[0., 0.7, 0.4, 0.75], 
      RGBColor[0.1, 0.4, 0.7, 0.75], 
      RGBColor[0.7, 0.7, 0, 0.75], 
      RGBColor[0., 0., 0., 0.75], 
      RGBColor[1., 1., 1., 0.75]}]},
  Boxed->False,
  Lighting->"Neutral"]], "Output",
 CellLabel->"Out[1]=",
 CellID->192871460]
}, Open  ]],

Cell["Extract the vertex colors:", "ExampleText",
 CellID->1669494950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/vertcube.off\>\"", ",", "\"\<VertexColors\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->902936223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.05`", ",", "0.8`", ",", "0.1`", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.2`", ",", "0.05`", ",", "0.8`", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.9`", ",", "0.9`", ",", "0.02`", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.`", ",", "0.7`", ",", "0.4`", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.1`", ",", "0.4`", ",", "0.7`", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.7`", ",", "0.7`", ",", "0", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "0.75`"}], "]"}], ",", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"1.`", ",", "1.`", ",", "1.`", ",", "0.75`"}], "]"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->777001581]
}, Open  ]],

Cell["Import the vertex coordinates:", "ExampleText",
 CellID->826926336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/vertcube.off\>\"", ",", "\"\<VertexData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1283617307],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`", ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "1.`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", "1.`", ",", 
     RowBox[{"-", "1.`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->135360987]
}, Open  ]],

Cell["Read the corresponding polygon data:", "ExampleText",
 CellID->418271197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/vertcube.off\>\"", ",", "\"\<PolygonData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->180292948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", "8", ",", "4"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->84151119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1084699606],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 " to create a 3D object:"
}], "ExampleText",
 CellID->557598659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", " ", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "+", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", " ", 
   RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<CandyColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->836271362],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyNXWuQVtWVbVAMOj5AM4mJqEDUMtEogzia+E0WURAfmLIYKjH4JL4QHfGB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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3QnYdlP1BvDzPs95/yJChMxzmUmGaDDPU4YMmRUyZZ7Th0imzGTmkzkk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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztnGtMVFcQx9EqqQ9E6UME68a2WG2qKFCIih2jiYgB11BRI0lNfWLVaq2v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    "],
   VertexNormals->CompressedData["
1:eJyFXHecVkWyHVDUXQMCLiJgAOWxrohvRReVCzWkNZAEE6i4iooSFETx6YIw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    "]],
  Boxed->False,
  Lighting->"Neutral",
  PlotRange->{{-1., 1.}, {-2., 2.}, {-1., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2004520260]
}, Open  ]],

Cell["Export it to the OFF format:", "ExampleText",
 CellID->593683873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<candy.off\>\"", ",", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->526032743],

Cell[BoxData["\<\"candy.off\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1850041962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->923885364],

Cell["Export a 3D model with transparent surfaces:", "ExampleText",
 CellID->1434544938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"x", " ", "y", " ", "z"}], "]"}], ">", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"Opacity", "[", "0.5", "]"}]}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<ArmyColors\>\""}], ",", 
   " ", 
   RowBox[{"Mesh", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643595914],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJztnb+KZUlyh/uuoAwh5wq9gGDZ18jjrkw9gkDmavUIegYh+hWahXbGmdkB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   "], {{
     {Opacity[0.5], EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{722, 723, 724}, {1432, 1225, 1227}, {1209, 1225, 
         1210}, {1295, 1470, 1278}, {726, 725, 727}, {1544, 1431, 1433}, {750,
          641, 640}, {638, 749, 639}, {1274, 1273, 1275}, {1276, 1277, 
         1278}, {624, 725, 615}, {863, 877, 864}, {880, 874, 873}, {1454, 
         1453, 1455}, {1469, 1470, 1471}, {830, 723, 718}, {726, 833, 719}, {
         1440, 1428, 1430}, {872, 862, 861}, {875, 763, 762}, {1432, 1441, 
         1433}, {760, 874, 761}, {747, 862, 748}, {1467, 1466, 1468}, {1429, 
         1542, 1430}, {722, 623, 614}, {1469, 1572, 1458}, {872, 1020, 873}, {
         1021, 877, 876}, {1569, 1466, 1455}, {1424, 1431, 1425}, {1226, 1238,
          1227}, {1237, 1222, 1224}, {880, 1033, 881}, {1034, 883, 882}, {
         1206, 1422, 1207}, {1223, 1428, 1224}, {1429, 1422, 1423}, {1553, 
         1542, 1543}, {1255, 1256, 1257}, {1253, 1252, 1254}, {1295, 1296, 
         1297}, {1293, 1292, 1294}, {1544, 1554, 1545}, {1424, 1208, 1210}, {
         1190, 1208, 1191}, {1206, 1188, 1189}, {863, 752, 751}, {1276, 1457, 
         1257}, {1223, 1205, 1207}, {1467, 1292, 1275}, {760, 749, 748}, {999,
          849, 840}, {850, 1000, 843}, {735, 841, 727}, {842, 841, 843}, {875,
          883, 876}, {1010, 865, 864}, {834, 976, 827}, {838, 734, 724}, {860,
          1009, 861}, {830, 831, 832}, {834, 833, 835}, {750, 763, 751}, {838,
          839, 840}, {1571, 1572, 1573}, {988, 839, 832}, {1569, 1568, 
         1570}, {1456, 1457, 1458}, {842, 989, 835}, {975, 831, 826}, {1454, 
         1273, 1254}}], Polygon3DBox[CompressedData["
1:eJxNmnn81tO2x5/fM/2e75PmOZUGTXIaKcN1ODg4xhORU46hkNlR92SIIuOt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         "]], 
        Polygon3DBox[{{749, 760, 761, 650, 639}, {863, 864, 865, 753, 752}, {
         1441, 1555, 1554, 1544, 1433}, {615, 725, 726, 719, 611}, {860, 861, 
         862, 747, 746}, {1466, 1569, 1570, 1582, 1468}, {1583, 1573, 1572, 
         1469, 1471}, {651, 762, 763, 750, 640}, {883, 1034, 1035, 1021, 
         876}, {719, 833, 834, 827, 715}, {826, 831, 830, 718, 714}, {1222, 
         1204, 1205, 1223, 1224}, {1009, 1019, 1020, 872, 861}, {839, 988, 
         987, 999, 840}, {1000, 990, 989, 842, 843}, {1020, 1032, 1033, 880, 
         873}, {1277, 1298, 1296, 1295, 1278}, {1225, 1209, 1211, 1226, 
         1227}, {1542, 1553, 1552, 1440, 1430}, {623, 722, 724, 734, 622}, {
         877, 1021, 1022, 1010, 864}, {989, 977, 976, 834, 835}, {718, 723, 
         722, 614, 610}, {1572, 1571, 1574, 1456, 1458}, {1205, 1187, 1188, 
         1206, 1207}, {1256, 1279, 1277, 1276, 1257}, {1238, 1442, 1441, 1432,
          1227}, {1252, 1452, 1453, 1454, 1254}, {625, 735, 727, 725, 624}, {
         1208, 1190, 1192, 1209, 1210}, {831, 975, 974, 988, 832}, {747, 748, 
         749, 638, 637}, {1431, 1544, 1545, 1539, 1425}, {1292, 1467, 1468, 
         1474, 1294}, {1273, 1274, 1272, 1253, 1254}, {750, 751, 752, 642, 
         641}, {1208, 1424, 1425, 1419, 1191}, {734, 838, 840, 849, 733}, {
         1418, 1423, 1422, 1206, 1189}, {767, 882, 883, 875, 762}, {736, 850, 
         843, 841, 735}, {1453, 1567, 1568, 1569, 1455}, {874, 880, 881, 766, 
         761}, {1457, 1456, 1459, 1255, 1257}, {1428, 1440, 1439, 1237, 
         1224}, {1475, 1471, 1470, 1295, 1297}, {1538, 1543, 1542, 1429, 
         1423}, {1292, 1293, 1291, 1274, 1275}}], 
        Polygon3DBox[{{763, 875, 876, 877, 863, 751}, {862, 872, 873, 874, 
         760, 748}, {841, 842, 835, 833, 726, 727}, {1225, 1432, 1433, 1431, 
         1424, 1210}, {1273, 1454, 1455, 1466, 1467, 1275}, {723, 830, 832, 
         839, 838, 724}, {1470, 1469, 1458, 1457, 1276, 1278}, {1422, 1429, 
         1430, 1428, 1223, 1207}}]}]}, 
     {Opacity[0.5], EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{1014, 870, 869}, {1264, 1266, 2627}, {2060, 2046, 
         2045}, {1245, 1247, 2588}, {2079, 2080, 2081}, {1231, 1232, 1242}, {
         1116, 1118, 1120}, {1124, 1125, 2533}, {2043, 2059, 2044}, {207, 209,
          2408}, {1373, 1372, 1371}, {1374, 1376, 1375}, {204, 202, 201}, {
         140, 142, 165}, {804, 926, 805}, {1234, 1219, 1218}, {143, 145, 
         167}, {844, 1004, 854}, {903, 904, 1089}, {928, 809, 808}, {837, 846,
          995}, {2082, 2084, 2083}, {855, 857, 1005}, {905, 906, 1090}}], 
        Polygon3DBox[CompressedData["
1:eJxNm3f813P3/9/vz3oPRWQ0tBRJhWjvPTR92tqpND/tXYRSqeiKy8zIuMyQ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         "]]}]}, {}, {}, {}}, {{
      Line3DBox[{153, 2201, 2202, 2203, 2204, 2205, 2206, 2207, 2208, 2209, 
       2210, 2211, 2212, 2213, 2214, 2215, 2216, 2217, 2218, 2219, 2220, 2221,
        2222, 2223, 2224, 2225, 2226, 2227, 2228, 2229, 2230, 2231, 2232, 
       2233, 2234, 2235, 2236, 2237, 2239, 153}], 
      Line3DBox[{30, 2255, 2256, 2257, 2258, 2259, 2260, 2261, 2262, 2263, 
       2264, 2265, 2266, 2267, 2268, 2269, 2270, 2271, 2272, 2273, 2274, 2275,
        2276, 2277, 2278, 2279, 2280, 2281, 2282, 2283, 2284, 2285, 2286, 
       2287, 2288, 2289, 2290, 2291, 2293, 30}], 
      Line3DBox[{184, 2317, 2318, 2319, 2320, 2321, 2322, 2323, 2324, 2325, 
       2326, 2327, 2328, 2329, 2330, 2331, 2332, 2333, 2334, 2335, 2336, 2337,
        2338, 2339, 2340, 2341, 2342, 2343, 2344, 2345, 2346, 2347, 2348, 
       2349, 2350, 2351, 2352, 2353, 2355, 184}], 
      Line3DBox[{208, 2371, 2372, 2373, 2374, 2375, 2376, 2377, 2378, 2379, 
       2380, 2381, 2382, 2383, 2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391,
        2392, 2393, 2394, 2395, 2396, 2397, 2398, 2399, 2400, 2401, 2402, 
       2403, 2404, 2405, 2406, 2407, 2409, 208}], 
      Line3DBox[{1100, 2441, 2442, 2443, 2444, 2445, 2446, 2447, 2448, 2449, 
       2450, 2451, 2452, 2453, 2454, 2455, 2456, 2457, 2458, 2459, 2460, 2461,
        2462, 2463, 2464, 2465, 2466, 2467, 2468, 2469, 2470, 2471, 2472, 
       2473, 2474, 2475, 2476, 2477, 2479, 1100}], 
      Line3DBox[{1121, 2496, 2497, 2498, 2499, 2500, 2501, 2502, 2503, 2504, 
       2505, 2506, 2507, 2508, 2509, 2510, 2511, 2512, 2513, 2514, 2515, 2516,
        2517, 2518, 2519, 2520, 2521, 2522, 2523, 2524, 2525, 2526, 2527, 
       2528, 2529, 2530, 2531, 2532, 2534, 1121}], 
      Line3DBox[{1246, 2551, 2552, 2553, 2554, 2555, 2556, 2557, 2558, 2559, 
       2560, 2561, 2562, 2563, 2564, 2565, 2566, 2567, 2568, 2569, 2570, 2571,
        2572, 2573, 2574, 2575, 2576, 2577, 2578, 2579, 2580, 2581, 2582, 
       2583, 2584, 2585, 2586, 2587, 2589, 1246}], 
      Line3DBox[{1265, 2590, 2591, 2592, 2593, 2594, 2595, 2596, 2597, 2598, 
       2599, 2600, 2601, 2602, 2603, 2604, 2605, 2606, 2607, 2608, 2609, 2610,
        2611, 2612, 2613, 2614, 2615, 2616, 2617, 2618, 2619, 2620, 2621, 
       2622, 2623, 2624, 2625, 2626, 2628, 1265}]}, {
      Line3DBox[{1, 2248, 2249, 2250, 2251, 2252, 2253, 26, 23, 369, 477, 585,
        693, 805, 926, 924, 922, 920, 918, 915, 2247, 797, 685, 577, 469, 361,
        5, 1}], 
      Line3DBox[{4, 2240, 2241, 2242, 2243, 2244, 2245, 2246, 916, 913, 941, 
       955, 969, 983, 995, 846, 730, 618, 510, 402, 155, 156, 134, 114, 94, 
       74, 54, 4}], 
      Line3DBox[{25, 2254, 20, 17, 14, 11, 8, 2, 2193, 2194, 2195, 2196, 2197,
        2198, 2199, 2200, 2238, 157, 159, 161, 163, 165, 142, 122, 102, 82, 
       62, 25}], 
      Line3DBox[{29, 2294, 2295, 2296, 2297, 2298, 2299, 2300, 2302, 2303, 
       2304, 2305, 2306, 2307, 2309, 940, 938, 936, 934, 932, 930, 928, 808, 
       696, 588, 480, 372, 29}], 
      Line3DBox[{2292, 27, 63, 83, 103, 123, 143, 167, 169, 171, 173, 175, 
       177, 2316, 151, 131, 111, 91, 71, 50, 49, 46, 43, 40, 37, 34, 31, 
       2292}], Line3DBox[{2301, 2310, 2311, 2312, 2313, 2314, 2315, 179, 180, 
       414, 522, 630, 740, 854, 1004, 994, 982, 968, 954, 939, 2308, 815, 703,
        595, 487, 379, 51, 2301}], 
      Line3DBox[{183, 2356, 2357, 2358, 2359, 2360, 2361, 2362, 2363, 2364, 
       2365, 2366, 2367, 2368, 2370, 344, 318, 298, 278, 258, 238, 204, 201, 
       198, 195, 192, 189, 183}], 
      Line3DBox[{2354, 181, 415, 523, 631, 741, 855, 1005, 1015, 1027, 1041, 
       1055, 1069, 2432, 898, 782, 670, 562, 454, 332, 330, 310, 290, 270, 
       250, 230, 186, 2354}], 
      Line3DBox[{207, 2408, 239, 259, 279, 299, 319, 2434, 2435, 2436, 2437, 
       2438, 2440, 357, 359, 327, 307, 287, 267, 247, 227, 226, 223, 220, 217,
        214, 211, 207}], 
      Line3DBox[{225, 2410, 2411, 2412, 2413, 2414, 2415, 2416, 2418, 2419, 
       2420, 2421, 2422, 2423, 2424, 1096, 1082, 1068, 1054, 1040, 1026, 1014,
        869, 757, 647, 539, 431, 225}], 
      Line3DBox[{329, 2426, 2427, 2428, 2429, 2430, 2431, 2433, 1083, 1084, 
       1085, 1086, 1087, 1088, 1089, 904, 788, 676, 568, 460, 343, 2369, 341, 
       339, 337, 335, 333, 329}], 
      Line3DBox[{345, 346, 461, 569, 677, 789, 905, 1090, 1091, 1092, 1093, 
       1094, 1095, 2425, 912, 796, 684, 576, 468, 360, 2417, 2439, 355, 353, 
       351, 349, 347, 345}], 
      Line3DBox[{1099, 2480, 2481, 2482, 2483, 2484, 2485, 2486, 2487, 2668, 
       2669, 2670, 2671, 2672, 2673, 2054, 1874, 1766, 1658, 1548, 1436, 1234,
        1218, 1200, 1182, 1164, 1146, 1099}], 
      Line3DBox[{2478, 1097, 1104, 1107, 1110, 1113, 1116, 1120, 1397, 1513, 
       1625, 1733, 1841, 2494, 1954, 1952, 1950, 1948, 1946, 1944, 1941, 1833,
        1725, 1617, 1505, 1389, 1101, 2478}], 
      Line3DBox[{1124, 2533, 1126, 1129, 1132, 1135, 1138, 2535, 2536, 2537, 
       2538, 2539, 2540, 2541, 2542, 2666, 1968, 1966, 1964, 1962, 1960, 1958,
        1844, 1736, 1628, 1516, 1400, 1124}], 
      Line3DBox[{1141, 1142, 1161, 1179, 1197, 1215, 1231, 1242, 1446, 1560, 
       1670, 1778, 1886, 2549, 2052, 2036, 2020, 2004, 1988, 1971, 1972, 1851,
        1743, 1635, 1523, 1407, 1143, 1141}], 
      Line3DBox[{1245, 2588, 1447, 1561, 1671, 1779, 1887, 2643, 2069, 2097, 
       2113, 2129, 2145, 2161, 2177, 1926, 1818, 1710, 1602, 1490, 1362, 1360,
        1342, 1324, 1306, 1286, 1268, 1245}], 
      Line3DBox[{1264, 2627, 1283, 1303, 1321, 1339, 1357, 2645, 2646, 2647, 
       2648, 2649, 2650, 2651, 2652, 2680, 2160, 2144, 2128, 2112, 2096, 2095,
        1903, 1795, 1687, 1579, 1463, 1264}], 
      Line3DBox[{1359, 2629, 2630, 2631, 2632, 2633, 2634, 2635, 2636, 2682, 
       2683, 2684, 2685, 2686, 2687, 2184, 1932, 1824, 1716, 1608, 1496, 1373,
        1371, 1369, 1367, 1365, 1363, 1359}], 
      Line3DBox[{1374, 1375, 1497, 1609, 1717, 1825, 1933, 2659, 2186, 2187, 
       2188, 2189, 2190, 2191, 2192, 1940, 1832, 1724, 1616, 1504, 1388, 1387,
        1385, 1383, 1381, 1379, 1377, 1374}], 
      Line3DBox[{1955, 1956, 1980, 1996, 2012, 2028, 2044, 2059, 2058, 2057, 
       2056, 2055, 2053, 2674, 2037, 2021, 2005, 1989, 1973, 1942, 2488, 2489,
        2490, 2491, 2492, 2493, 2495, 1955}], 
      Line3DBox[{1957, 2661, 2662, 2663, 2664, 2665, 2667, 1970, 2543, 2544, 
       2545, 2546, 2547, 2548, 2550, 2066, 2065, 2064, 2063, 2062, 2061, 2060,
        2045, 2029, 2013, 1997, 1981, 1957}], 
      Line3DBox[{2067, 2068, 2071, 2073, 2075, 2077, 2079, 2081, 2104, 2120, 
       2136, 2152, 2168, 2688, 2183, 2182, 2181, 2180, 2179, 2178, 2637, 2638,
        2639, 2640, 2641, 2642, 2644, 2067}], 
      Line3DBox[{2082, 2083, 2085, 2087, 2089, 2091, 2093, 2675, 2676, 2677, 
       2678, 2679, 2681, 2176, 2653, 2654, 2655, 2656, 2657, 2658, 2660, 2185,
        2169, 2153, 2137, 2121, 2105, 2082}]}}},
   VertexColors->CompressedData["
1:eJztXX1UVVUWRxm/kmm0+FBpVITkpYkQPpiEYQOJIBYqiVqAqCApoKViKmJa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    "],
   VertexNormals->CompressedData["
1:eJztnX2w3lVxxyNQBFo7lLbQih3bQU2AmZJpBKwCZ6AO1lIrCtbRSaxJSrgk
KLZ1BquxdgjJDRMhkhcyDi8JJAFspkCnvMgMulAh0YIQEEoIyjtFCfSGinCT
cJN2eM73ZM7n91t+L/cmee7Nc/+58+xznv3t2d2zZ8+e3f390bTzPnnWPuPG
jfvng8aN23cc/zYHfLbCkLeEV40j/io48bSlZ6TmtbfgKcJXDd5817U7vhb0
f8PqjW+7asdAGCk6Hfyu/mz42r7rjt22Iuj/rd94ff221wZ6erJX4fHwEd7W
XhHelM7hw8/Y51/eNXH7N8K3ttz2jvfv6A+rXjjqNydWrrsi/MxyPHtsXu3g
hXGjXr6fWHzIZ64eXBxe/65t//Jry8PX77rjHf+wtbl8Ty/H05NvBt/985o2
dP3sT72yIFw8/8/PPmPTjWHOu1cc9rGB5vJ18PTkm8F3/7weuOb7Z/362qvD
3z73/ccPnfuD8JWjXvvfYy5vLt/15Xh68s3gu39ev//ka/P+fc0N4cw/fHjJ
upVPhRf7f+8vjvjwpsbyPRx4XurgGfXyPeaO/inHbj8/vLz15tlXDA2EHfdP
X33g0LKwMvrxj8Zzgj63o8P3Z+QPya/xxmt/1P6qfdIbL3srey27643X+tX6
1zr2xksfoh4kvfDGSw9fzMe7/HkQ9Ezv0OOO53wv6czXHU9+Dnb4WVteizry
csdTf1Z0Pnt6UuH/F+AG/JbrZ5EenjP12RvvPdeDn5Hzx6r02YN/IpeLVem5
B4c+WJX+e/AHcj20qnXhwaH/VrVeqvBo/VTZc2e8OfS4+jz1nqPnTF2/Juz/
pX0mL/7ykzbrzc++/cf6tWkV69eDU45V69qDn16uV43xwA7Y4go74MG5fnP7
sKv9lr3H/5EeSv/a+rfCMz3HM+r9n4bju06+sg+yC8M9nwJPT74ZfPfPC3Eh
G258aTDH05NvBt/989J+qn10uPHhRTmennwz+O6fl+7Dro7+Tb17t9p4xoh8
6/6O34/U+L0F3pRfPfhbjxup8QkemsHd5zfEM/JwxT+8OB/jJd1Gfz14a3z2
Jz866F03Dl4e9H/TzX1XPrNlIDjwpvpiM7YPvW2/15eHvvh/6cAJ/7Tv4EBw
4I3xP3LFsmVTNq0Mk/e5cuZpz94UDv3mguWbXxgIP4nwKTm8Mf7nT7zkvTtm
rwnXX/bR62//6Lrw6Y+fcNcpswbCs4D/dQfeGP8Hb//qywtW3BIWPHxQ+OEF
T4d5v3p2/xWrXwwnRPg3I7y/A3fx815feu0915P32VEel0U5nRM/i5/ir/gq
PsT5J36I/kh3mofg83O4PQc8Kzt4knz13Chn6wOd53U+2yTM67jOZyN/Turw
p7G8mPdwZjM+m8NnE58xX5Negz92XeSz9CfqjUmPPpjrjzl6ZVEORjyOXMyR
i0V9MM5LciEfjo9yuRT8bCkXl/+iX3RLvxx4a/uj+UtPYZesrf0RP8VH6Xtf
ObwxfslF8tC60To6Loc3xi/5Sq7cfwGvib/nb+9h+JjxD3Wv5d3r8h6s2+iv
B2+NL+2zM+C/OfDG9uHCV/7+0SmvrA76P+OAX7t48+aB4MAb4x+cveGlSQ/d
GJa8/Aev9m28Jfzqzc//L99yeGP8E+Yu/eNrzrgtPPXo5CkPXfufYd3vrvvx
5UcOhPER/kQOb76//PLvvnXNL/4jfOR7T06/+4lnwhsLH540q+8X4b8A396B
u/iZFyi99p57Dvwr7UOenMRP8Vd8FR/EF/FD9Ee60zwEH8rhRjyPd/CY81xz
6LRZmNfUuH9uAX9O6fCnsbyYN3l6Mz6bw+c0n8F8viY+T8j5Y9JH6U/UGyOf
xd+hcr0S3CAXc+Rij0W5bAGdS6Nc5mBec8rlYtOjXMjPlnJx+S/6RTfX7+M5
vLX90fxfLbc/1tb+iJ/io2M/ra39nBnlMi3KQ/Zf8M/n8NbrRXLV+ttSDu/5
h6MDPmb8Q+UreXl8zIvpNvrrwVvj07m/EB9S3IJxgqb4tb95/gX3w6b4L5p4
UvizL3wv6P+5t/321w9YPBAceGP8O3625J3j7/9BWPexCy9aEx4K7zvvT5/e
/OH/CQ68Mf77rvjSocfefV84+R/f/m93T3w+XPXzGyc+9eR/h3sBv7IDd/Gz
rkB67T2X8VbJmX625DM/8nFW5K8+iw/ii/gh+iPdaR6CX5XDE5/HRzz3dPAk
+c7K5WqkM/orSZ8Pi/N6vDMvWwj+fL7Dn8byYt1FFZ8Zv/5JOZ+THww+m8Nn
E5/vy/lp5LP4e2W5Xpl+B3kJj23P5WJ3R7n0g874WX5imte2KBfom22McrkE
/GwpF5f/ol90j8f6vSeHN9YH8UHzn1VufwRvbT+3Rj7K/1yc20/BG+OXXCQP
3g9o/RzW0v5LvpKr1t/CcnjPPxwd8DHjHyoP3avbYN56t9FfD94an+k+0Lsn
1P3qp1vevyiexPiQ4h+MizTFr33S81O4rzbFv/o9R9253/mPBP2/5acHvvz0
0S8FB94Y/6Sfbjx8TVgfZt30ocUPPvN8mBn/b1007rQfvv2x8L7vnnL7vhOf
CRfeP2Pabxz1QoLrs74nnnM6/21bHD8hjrug87sEnxfxvKfzvUs/6x61brx5
XZffu6f7PMZhk/wd/7sm38PKzmdz8CQ9XJvHjwz5AVoHdhbme19nvo3lyzrP
9RV8Y76C1iXj1OPL+WYO35IeS+7SgwnQH+mN9FDw+Nn0/VCuhxb10K7FcyWX
teV0Ui6aF/XHHLnYj9vJxeW/+KP1oPWheWk+1EfAE3/EF/GpKT2S77gnOvwa
X27frK19g322tbgHALwx/uvy/cW4vwDeGL/0QXqg9Sr4fTm853+ODviY8T9V
v+jVAbO+sNvorwdvjc+Yd6Z8NOZJzavIr/Pw8z6N95m8f2uKn/EYxsMYv2mK
X/4d/T7uz/L76Cfq99rnuf8Tj/Z37XvcD9vSX+W/Ck4/WHQRz2BnvPbVMD5+
L7h+PyvH49LPvg9al968mA8qPWUegPSL8V8vLhzhSW9x71t4blw35tDfWF7s
W3F4BR+Y/3oC+LAd99OMd2vdSF59Uf8kd+/cQvhWyP2cHI+Bz4rL26k5n5XP
QT7bieV8tpZ8dvnJ89g2rBfpt9YD9V7jjszXlYlP84CHfq4+6/um9HO9SR6w
h3ZVuZ1M8WrikTyb0nNqbudtqDyfJeVRNMUv/T8p6gfypsOJObz1epSevVju
P1i5/+Dh7/m3exa+83v2zSnvn1Pt97KuIO8rUsTDPLO8f0hxPO8d8z4hxfGM
E+X9QIrjue/mfT9qj3f9Z9HDPgd155v30/D5yTpsb7zkxbpebzz1pLxPTlP/
vL5esU7Lq0NiPqLy55y8+0J8UPEC+lWev6U6CK9ugM9VHQDpVJ4+56W8e/GB
+fL1+LyTn8xflr6wnkd0efm2vL/XPSLjqoq30h91/MuUV8g8O+Xf4T4+5c2J
Tua7aV7KH1TeIPnQNp/Ty/fhPafu5Zmfont55j3ov5cP4vnx3j284na8r9Zz
ec8sOnXfrnt25u/oXhf9vFrnP/B+TPFqJ25XyBuWvnj3MFVxfMZZhWct4p1e
nFJ0Mu7IuGDLuLExfqPzkVdH5+VP18ybSX6x1in92XmIl8jf9PzEpvNlHzrt
t3iufSjOl3nhmi/zgZx4ieD2RjkeA5913rRNkc5P5XS21n/1L3oQ+q995Tno
v/KQpf/Mc6L+S7+l/7fm60LwZDdkL7ZD/x/Ln5v0f1Wkk/ovv6et/rNvIO2t
6ukeKbe3Rnur/JmLyu2tOfbWHHtrjr012tto35V/RXtrjr012tuY52JTW9pb
9lWkPyC/pK/cHzD6A8qT0/7G+07ZS8aVvHiT1h/xbIA/oPwl+gNzI51z4Q9o
XlPL/YG2dQTGvpP0V1UvOQn+quiQn8L8winwV7WutB/q3C/7q31gboRH+6i4
khEP/VXp2WT4q6KT/qrmdRz8VfHhxJb+Kvty6vzBOm2dD1ifozoB5mUqP4z3
69qfGcfUPrYJcNl74pka7RyfK7slOk+OdErvNC/xS/wTH5ZHPixv1Ke02+IP
owWevnfPrezrWtV/mH1d8/6u3vOq4N48Cud94/sZmj6XdWtVcRsPzvzmqniO
B2deS1Wcx4PzvqEq/kN/NO/vWhyvPqzsz8o+r8Lr4K8Zb6nPN/bLbIqHcqyK
U3lw6tVgRfzKg1PPF1XEtTw41/XIxLvaw9mvuap/iwdnnxHEzcyJmxn75TA/
TH4I7+Hkh+C8lPyV+eXjU38R3r/ruU6cjf1+Ut8L9sMQH9jHgnxu22+EfbGr
6qk9OPu/IC5XqI9nvQficsa6c96Pyg/n+Vl+Oet9Nc4Zb3zu47nfTjrNmVfi
g/xj+O3GetCm8mL/8aq6Gw/Ovjw4hxrr0liHg7hfoT6M99Y6hzKuofMq6280
zomDpDoV1q+ITtadcF46/x2W9/1J5xjxmfUZTeXFPu9V+cAenP2SEFcx5omz
PgpxlUK+NvIAUj6Il0/A8cp7JX7Fb5TXyXxPh86UR+nELZmPn/IWmc/YVF7s
p1+V3+LBvT5W7F/wSB73M+ZDzUH+8RuRf17+seTFvAYHv/WV47Gh8j4LhXmd
kMdRC/fwTfnP9xBU8Z99wZBfVOgHUVUHyDiZgyc9tx/xDJ2zef6uOV/3PQpV
fOB7FOS/e+MX5HxLcWn2TXP46fbRIJ+r6iqR12S0K5BLins7eAzrIuU1ib43
cvqp5+bIN8XP+8EfR+4prq7PdePt50b5SZ6dz2vc8XwfxoPD3F+cuL09Vh63
N8TbC3UOsvesc9D9FfPSJuT5iwlP3H/s1nx/Sf8vBB79zqHTOK8J2F9Wlt8L
pHhZ2/2F7x0Zrv82pfweIcWXt8B/071pf7n/lupPmBeo/YF5gY5fl+wo16Hw
cj07/p7R33PuKcy5p0h82JrfU5hzT5Hk0tbf4/tgqvomeXD2neR5SnkDc3Ce
2pbfLxTqhXCvkfI4Ty0/T6X7RdpN5zyV7Cmfi7wI0pnOU849iDn3IInPJ7c8
T/G9O1V9UD04+4EyXjEd9yas/59cHq9I/r7iDyfh3mRBvk+b7lHm5v1Q036P
e2iNNz53FeIVzj2LOfcs5tyz2DDvWQrvN2r7Hj32ab00v5dJ92qv5/cyhvuR
Qn0d7mWM9zL0A+Qn0m/QOGe88bnT8nucdM+6ML/H4bwSH5x7HGt3j+PBd3Xf
9267l+nBxzh8xO+/9hSceTzMg+H797qN/nrw1vgK5yIvz6ltfS7zotaV5y21
7v/A/ConXyq07f/DOhzVyTB/S3ldPB/q/MbzYdt+EazXEV2sC6qqk+O5VOdV
4tfv9b9uvwi+R7Dq/O71f/f6frLfk+TM+vxr83iwMc/OwWN8rs7RpFN+5VTM
t22/CL43sSHf0nplX1Txjf2wdpTzLek1+xdIr1lXprgs+JziGMSj32/L9TON
g1yMcuE5bBX4ILlAD0e8X0TdOjrBGd+RPm5DfGcu+CF+KW7u4Gmsb4wfefmm
be3nRsShaP8Bb4yfea7cv4bbX4L5slrfjJf1+kuMKviY8W8Zb/Xys/fW/rfM
R0ddUOE9OU3xM6+deeTKM2jbv5H58agXKvTpbIqfefbKv1e/IcHb2n/G2XX/
zji78iU4XnF1Z7xLD99zXLOPa6FecGne/z3VvbEfaH/ex7VQt+TVvfNeAX1Z
C/vxfDx3ft6XtZCPj/cbBfRlLeRHN5Uv3wNdsy9xIV+Mffa1nthf9aJyPrNf
biEvgPc00kPe0/CenPexxKN7IAdPwX9y5GiOHNlftxC3Xgj+t6xDceXFeymv
rqatfYB9s3PL64KsbX/vJbgnU3/dJfk94nD76xr76zrwxvhZX8T9vddfd1TC
x4z/ybo11nGdvpe/n4v1e6x/4/sYm+JnHSDq8Avv82mKX/3H1Y/8VfgXS3J4
Y/y8v/fqFdv2n/TqG5kfUNX/R/rMPh/ec/k+SMmZ7wGSfLTPs+7f68vJfkan
Ip+R9dPEo/iL89yUp8A6Ts5L9+TkT8u8BRvM8VTmmfD9mlpnfK+S1seWfL62
pJzPhveguXmjXh5l3bw8Pld1tVtBpyMXc+RijlxG/P1cE5AHw3j5RsShm+JH
PbM59qe1/8a8HK9uua39/GKUA97DFRx4Y/ysl+b+e3Lv/VyjET5m/EPW4au+
mnlp5e8X3vP014O3xmfsR6B6fubbtX2/s+yL3gco+zOtHN4YP/sjHFbev6B1
fJV9Fnjvyj7xTfGzX4PqIpmPWNW/UfrMvm7ec/k+b8l5Ovwr5VU68YVCX3Xx
w+tHyXxK5U0Sj+7VvLjGVNAp/wPvI091nYvAn7b9KICnMq+V70fXOgP9KX+V
70OaUs7npI/s7yk+s9/H3LyOh/BC3qojl3Tfz7iSIxdz5GKOXFrnr3r8Z38T
rl/e2zfFz/xdr39KW/sj+/lF+G8OvDF+5hO/5PRzeaml/WdestcXpnz/9fD3
/MM9DB8z/uHVMf96Vcx33xD77DjwrqO/Hrw1PmN/JfZdujSHN7YP7NPE/k18
v3dT/Oz35PRjcvITqvGzb5Tyc1i30Cw/Zyd+1jl4famq+m+rroN9fL3nngR7
LTk75/zC+xfFV++9OFX9xNlPkXiUF8V7Kd1XefEIbx9aDv60rMsw8LmyjgZ8
TuuM7zXfUs7npNfMA3P4XKgj9+qq69bd8rnKSyOdui9kPMiRizlyGaF6mZ38
Z782rl/mbzbFz75v0lPWEbW1P+wf59jPhvG3nfhZv+T1p2tr/7Ve9H8D+v0B
3vMPRwec8hghf6U3vh18V9Mz2sdX4an7+27z+8cq3BvXbXSOVbg3rtvoHKtw
b1y30TlW4d64bqNzrMK9cbXH28jS04M743p87sF3IXzYeHv6uUvgtX/f4/8u
gdf+fY//uwRe+/c9/u8SeO3f9/i/W+GFcV3K//S9DW98t8G7hY7mcL0nJ74/
J703Z8f901cfOLQsvLz15tlXDA2EY+7on3Ls9vPDTZ99/2eO3HFxWPXo7APf
vWMgye239r330sve+HZ478Pzlk4e2gk/+LGv/uWdv/xO+NERB5zz81cHwsPv
XPtXN7zeH2YOnfY73/7KneGC049Y+J3bB8LfzP7s0eHeZWG/Th/hEPtCB/WF
1md9L7h+L3zCo+fp+Xqu6BO9olPz0fwE1/zFD/GB/NJ/8ku/I7/0HPJLdJFf
mgf5pXl/IfJnev4enPRfcI0jv4SX/BId5JfoJr80T/JLfCG/xEfyS+PJryq9
I79EP/ml+ZJf5KM+63vyS/jILz2f/Mr56N+nevpYtZ67C95t+w/hxXk4emuO
npuzLsxZR+asO3PWqdEOqs+69O9zEc/ZHbzm2A1z7IxxPf1rZ55GO7b/A2/y
xWj3nuz8N9rJ4zu/M0+PPTss+g+J/PtZZx5pvudG/p3dmbfNxL4wM/afzz9v
SvBzsf6F5xDYCz3X29c8e0T7JT7Q3olvtI/iM/QsSC4O/8yxP/Y52CvpCfdV
6ZVjD82xn+bY20Qn+GcO/+SvFtajsy+MMjtT9f1op3N30VUF9/VHeiM90vfS
P8c+pfVPOy59px3X+qAd3x9+K95/kvD0xfU5J65X2nGtb9Gp9U/7JHsh+0E7
Tn9M9kj2iXZc4z1/z/MPacdFP+247JP4pPeIxPeLhPz/msRP2nHhpR0XHZ6/
7fnntOPiC+04/X/xWXyva8cFpx2XHtCOy77TjkvPcJ5KcNpx6R/tuJ7bzI57
f5uNdlz88dZvD14H7n1fHI99P723B36CSb8cu0f9Neqv9EH6Tjus9QG/yLSe
qCdaf56+efoJv85kD+AHmuwH/EabCTvE9xxpPcpuz4h44Mem52q9H1zOr3AD
7APtyQciH2h/6IdrnH5H+6bnFOI1kS7Hfqb5ap6at2OfzbHn5th/c/YL95zl
ncuc/cuc/c6c/THJAfsp9U58pD9suT9cXI/Ovu+t/y7zE6vP03uWnqbwbrPr
w7X33U5fsm/GuEtdv1xw+uXwlwpxF+1/jCfTLxdc+yHjLvTL4S9V+uWC0y8X
H+iXy37RL3fONZVxF/rlsr/0y2Wv6ZfTvuefNxX8cuGjX+6cayrjLvTLxQ/6
5eIf/XKNp1+Oc03BX6dfLvplx6Vnc/JzTSHuovMh4y70y2fm55pC3IV+D841
BX8d6zJ9pl9Ovapaz90N75Z9pur74nhHf8zRN3P0s+CnS28c/TdnvZizvsxZ
j5XnRfrvjn0wx56YY3/MsVfJT6f/7tjD4vqv8N8/APssPtKe6zPtv35/g7Nf
HOzsL4dgP9J8+rB/af75eWan/z4T++PM/LxT8N8lH/rv3n7t7e/0B47PzzsF
/532Cuedgv/u2Elz7Cr9l0Sn+MD7l6p1PDrg3UKH95fivYXxjGsgT8AYN2Nc
A3kClXENwRnXQJ5AwV4yroE8gYK99PZ3xjW0/hjXyP23TQV7ybiG7AHjGrIf
jGukeKXjLzGuIXvGuAb9N9pLxjWYJ1DXXjKuIfoZ10j+L+IatJd4D3YhriH+
M64heYFflfaScQ3pD+Ma0jfGNaSfdeMaiY+Ia2i9OOvUcG5K6w58THoHvie9
g5yS3h3s0HmDMy/yQfpEvukz9NKc+1mjfqc8gEifI3euK8TTCnrFdZu+d/SW
dgHxqMK6cPnnrDtz1qk567rAJ+F37IY5dsYcu1TgU65fBbtX0DPhdexqcT3k
eRQF/lHPkEdR4B/1TL+rq2eCU880D2edBuqf+MH17K3z7oZ3vT9TcT7dVXTs
tnv5LqMrfT9K9KRpHkYa14u3vOVflX6mcV1rx/4P0577Mg==
    "]],
  BoxRatios->{1, 1, 1},
  Boxed->False,
  Lighting->"Neutral",
  PlotRange->{{-5, 5}, {-5, 5}, {-5, 5}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->248555684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.off\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2116429832],

Cell[BoxData["\<\"test.off\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->558679264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->674089440],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " example using inline 3D graphics:"
}], "ExampleText",
 CellID->1444980155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<helicoid.off\>\"", ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxU3Xk0lV37B/DSoNSTSGlQ0iClRIMonV0ZQhQqmqkkikrSSKV5MkREIyKz
SlSms80yz/M8zxSZi59z9r6vd/3ef961PqvlcY773Pe1976u7xE7cV7nFM+4
ceMKeceNmzD2/9Zxrrq38qxZvHlK52Xj+Le2er1NnfNlP6tE4639T/Mo9Fy+
I+qF2m4W48t0xnskm6ejOQ/K2E5qx8A7RuZZ799fgEI2udtLfTcCT9n3dWWy
eTk6GJiLnNTOgevsFz8rklyDbjvwDAx3XATfNs5i+/79DSgvdYGW1PfL4FIB
WNiurhmtmLTR1+D2dXAR3emdSebt6DraPc5J7SY43/iDCaOjXagpan3giak2
4M8PGN4QcLFmOSvN3pG8YTerfcvxP0WfXqChmds2rN8UhTK+NGXaZT5DjIve
t9+5blM6irqyvcI28w149e1b10+tLECqTx+ubH3lDS6DNuXIbCpHXw+dM7TN
DASPvdk/65ZnDeJ39t8zd3wIeMvRvejUygaU8HdhR8urMHDBrZ/O7PrcjK4Z
Pn8SuSEcfLPINBeZTe1obfpECdvMKPATw0axwuwu1D0v6sTaDTHgXy+n8SRW
WrEe+z2e7dB3lPXyfrFK0ScvJK/nZWP4KBLZi/lbyju9QYwvWRv86uSjNFTr
3ntfzikQfN885evqH/PRzblPJc6cCwMXXrB+xclHZeipwYIZck5R4GZ2M1u3
bqxBGvkFgzzlseC77R9uU/9Yj/YOvG03OZcILu0w4qIr3IwOiRhVZY9LARd4
btlx4lEbMtgmlbvJKR2853m74vnBTrRh3Y0TWYLZ4H47BXqffb7BMs31lPeV
NGJtMrvtFMf7CcWP/3t/tXEEyvlibRe5zBsxvuDVFV9J41Q08cLiiohlYeB+
bgMPFmfmIVFenh7h7xhcxShMXtK4FC3MMr8XsSwR3HyefN98m2oU8OoEf4tZ
Kji+9XLP4sw6JG+095Xw9yzwGY29vssXNKG6uZ6CS2/ngh/R2McjadyK/G/O
PxCxrADcPyTksHRYBzKvd3yrnVIEnj3nx3qVmddZ6LHS67BxZizTVUK/Cj+F
Irfrd69Ilf1AgU8sXsX5BiDGh1XH+6wp+4lyK8xCYn0jwfedWTz1hFcuEh/O
nvacnQAuKR3DWlNWjAx5z7JifdPAJ/TpXxoQqEI5j+/8uKqWA95RMZp/3KsW
/bLPynFg54OXxGSdT8YNiN9FpM13fTF4wof3fGvKmpHUG5OJsb5l4J8fnPd2
7GtDmp7fFpYsrAJ/8y/A/MPEqyyTPrGM5Z/MWQqLjF3Sy8KRn6bcq4ymb4h/
RtM9s4rPiPEF62aVpjclIe8qs37TihjwL4vuW5SsyUGKcsarl2qkgO/zGnc9
vakQXVD98tm0Iht8YKXVbexRjmIuSaUlCxWAZxbdUCxZM/a59ghoWKJRAv7+
VXhSLl89OpYhMe7m3Qpw86P9aulNjajwr46taUU1uOLijRmJCS1oxPH5/PmD
teC3+Ne+EXCxZDX9lqyY63yJ9Z9glEIcL0ZPA/u7BF1C0c7B8/7jPb4ixv1E
dyoKuiSgY+uSJ433iAefbuI4Y0FNJhI21pW1Mc8AlyvpbBdwyUfNmRe/jvPI
A2+1fqHjElmCkkwi0rY9LgZ/s2Tzj/k1lejDRJ762+YV4D51XXZ7JtSimKxl
N6tX14CP+xYXK+BSj6Teqj4Z51EHfvCR8588iSb09oypy+LZjeBXUleLO2de
ZF0sHU5XFL/C6uJ59LtsXhx6UWEk+qzrC7rR/W9x5KxviPETG7ofPe2KRbPy
005HzEoCHxqU5tFuSkWX9J69T7PLBk+p+r71aVcOqkpYNy1iViG48w69IbOz
hUhtXcllX9cy8OPefd+0mkpRaRYyT7OrBl8zxcVi/ckqZD95ls8O7Tpw67D5
c5921SDlrY3l4bMaweuMzly2WlOPhizCBWUKm8GNevIeb7c4z/K9w/dx1oFr
rKK/XxIKPyUg1cy+9aojQSi22uTAPckfiPHB2CNyO0ei0XNFP9u7kj/BjWbo
S4bdTEIGaXZXPBfngudE2keojGSggT+qEncli8Hfbahe1s7ORQ6LJpSclK0E
3/v0anvozUIk5FWp5Lm4FnxK7cxQa1Ypqv6x5a2geAN4tJzfDZWRChSY4dp7
R7IZPDzZ3YO3qhpdre3V7JFuA++9J+CQnmzMYg0Ybb4pdoMV01f2Mkc5Ge2Z
cFml3cMHuUlM02NXhSPGM99tut3m8R0lyY5aR1elgA8tfHXuQngsem+q0Jxx
Og/c1nTuwjaPZFS+9ZpAdFUJuFikS9qpJxnoGe/hhYWS1eCl9/i2XgjPQasu
DH7JOF0HvixQ7UVQUD5KKX6pkvihEdws71Fbq0cROr1dtiyqqgX8+1DyDgmX
UjTJP/986IIO8OcjW98pfTvO8soWO77ihhXL99eks+llKeh7Sl39pnp3ZIme
KRiujESMJ3rJ6G2q/4xMJ349cHJlGniw4e9IHd1wZPfHXo1PPx9cw/HAzE31
MajJKKnxxMoy8G0Xf8QpLUxE7qYjsRWD1eAbdeZa6uimoHRvt5l8+vXgq9Zd
XWFgP3adVG7Ql01oAuef2t4uW5+Nls/NDjqxsg2cb3BBUvS4PKStffavnV0n
+ATz/3Lsvu9jfT1hsvOWvjXreetaFqdevMAn/rsy1gl1WNyUlJgwVldSb3Yy
2VUZ+wGFXLuzbcWEdPCXS7YtyvAMQt/KPTce5SkA/3Dg6UBF7FfkZDUxTXxC
Ofjw+77j+0N+ILkZ66UHbGrA9zYdT0v3jEYrKuuGjvA0gO9/aTTfUy0WzQl+
kRh7pxl8/BaRrIrYeDTpprKD+IR28KDKnLvzNiehHs2+Q0/vdoGrJO1SHwyV
ZZ0stzxYkmrNul5/UCCONwsdbTSX+OxjiRKyXyx5bBKFGJ8mknrxk899NDCJ
teGRSTq4hWeQcfxWB5SU49q2fE8BeI1sn/AnH2f03F0w+qFJOfieNFbyK4HX
KHiTSvKf2Brwqk+KW+K3uiMh0Qmfl+9pAJ8z1CQY3u2Jrk2OcdUtbwbXVHrW
Guzjjao6rGwemrSD37OTjvM64ouUCuTP/OjrAhe0fmbX3LyD/SGt0fBGpDVL
pmv7xcrMbHTpaP1enyl3cFr+g7M1h6IQ46Nz30Z9nOKIvQb9rasPpYMrTVDN
Gpz+Gl9QSlkioVQAnnh58MLHKZ6Yf3r05OpD5eBNbbuHsp58xEUmB3rTftSA
8x33ujs4PQD7aOo0rVBqAF9TODh9qf0nfFlGo+RuVjO4r/eKXR+nhGCV2Spp
VYfaweUNcvkj1ULx7EEUvaWxC3xF+OavG84fYBfN3PLNS8aaJd5eWFY2b+y+
GbVnxnnNl/ii4gpDs6JIxHjfnEL1c5o+OGbhq+umRWnguSt2PBS8/gXXaTiI
Pa/JB1+pNK/FTPM7bnySN8m0qAz8lsEv9ZTF0djScJrlB6Ma8LPsk7qC12Px
lQlrmhxq6sFfauzhjTmZgK967j5480gzeFzp5h9mmsn4+vYLaWeL2sA7jcVN
FmxKxVbVz7ce1OkCj1RQeeJz5yQ765CQkO1aK9b8lrPKJYZ5qGuOOM/O1544
CkfeV6+JQIy/KZ1ppPI6BC/QQ15qNangsX4zdrU0R2LJ09k8/RL54BYKk+eq
vI7DqUts1qvVlIJPWnb/ifCOZLyha25IRno1uOu0if+am9PwBE3z1D6JenDn
a7GbKnZm4zz/lFrR+03gxzrG/VZ+nYs9pywZVq1pBZc4vs0/uDMfmxtdn3Vx
ayc4++cKQT3rM2x9qatvDodfZ/E3jvtU+Ckfud5Y1ySj6Ie7LjoHn7MKR4zz
xu+cJaMYjqe5pBabWaWAL152w82wOw7vkV++RmdhHni0kY6ftGIKdl3RYGZm
VQJ+2G9l+F+nLFw72zv4UVkV+F/L24aG3bl4zp2Qfu2FdeC7hE1NU+cX4i3X
BF2rNBrB3X7oXZJWLMH6Fy7KmVm1gDcfVLRyOVuO753OLR4KaAcXy2EHXLp/
gc2a89lvdsFVFk+d89z8oQLkfNvo6X93P+Faocycl8HfEeMlG/nvTr+L8YvT
y6e9DE4G/+q8cbGaZzI+XPtlzu+4HPDrDnUj0+5m4Y6ZOT4uwUXgHok/zzV9
ycO30C85hVcV4BPjRStVPYvwlO+8Db/iasCNYy5r+juWYe3dL4Pif9SDp0dn
RE27W4VfNYhfdgluAnc9KujyLbwG11l9Y5l4tYKv3/l1vvQjC7a0NJr04Mll
Vl/Vqjs5ykXITXpnj617CDZuP6y14VYYYjz+0yQ9W/c4zIrifbP+ViL45uTT
oXm/0vCy2F8PjUSzwQ901U+xdc/FK70qtq+/VQAuNOy86bNqEV7zMHV4tLIU
PGvyTqO8X2V4XljZISPRanDlqVbqNzSq8Rvx3O8aWbXgS+3za5651+JFrj+F
1t9qAB8/e821d3/qscdUbD5vbTP4TY2y2Vc2X2Z3fJydJVJnwWotx22ZDsVo
R+K6zNJ1YXhfXssRpf4QxLjTdH2R0nWJuKw9O1qxPw78/jevHJX0LDz912rN
hovp4FukLeNL1hXg99eUzin254JvnDR3kcOtUrzpRvdGobAicKnSiKsq6VU4
28r9X/3F8v/9d4uCTW4+q8UbkE/tIddq8Jk7xr0sWdeAx2+7qaLYXwv+LFA7
YUNJE87Ytt9fUrcB/EdUmJLU86vsog1yb3+2XGBVluzbn15Wgvy3/ggrMPuO
M889bt4g9hkxfj9N6ne+WTKuX7nl+AaxGPD5UTF39R1zsMEbmd2ZMj/BzQVb
7fLNivB53hcLN4hlg6cYz3qlplaBg7bxC9mszAd30H+no+9Yg9uvPeHLlCkG
j+JbXzzvdj1e9XXS+AWby8Gbw5KP5ps14Q2XY4bXi1WDCx0/Umd3uBXnC45c
PrS8Fnwg6vLlr3eus91u/mty3H+WlVPYwk4RL0NidjN+7FYNx24ruo6bCPgj
xs26B+o0VVPwAYcdD40FIsAbdvdu3NyXiy8mJUnNsI0Hd1rWeU1TtQT/UGqf
ZyyQCr59qDHa4FUVvlXziKdGPRt8oKlr3Oa+WuzpvmDgP9s88Cyddk9F0Uac
qB/csTmrEPxjdLOSpmoLbl60ve60QCm4tURDo655O55WmVf8Ym8FeJDbK61J
vFbs9eXp7n+NDFmJeTclOPuJbQWHz3yIiMAz+T7tmGL5ATFuFLD0iWdEKp66
/Mp7Xsuv4G1hzz4NTsvHfIkuC5+ujQZf6sI73zOiFD9YV6bJaxkPLrVl+w7v
0Gr8gKdtuprOT3D1gJtXBqfV44e5Q2lP1mb877+7ICpQ82QTVtK+r2w0OQf8
ztPBGo+IVqwk/99yXss88HfDssJ9Ap1YWcx5om9dAXjN3cuq9cLW7HHBito/
VA+xwrNnOSZEVSC9yXKHK9mR+O/CK1ITBNwQ47Pqr16sYKfhi4dljvAI+IFb
1fqXLc/Kx91OTg6x6SHgv3TmjZSzy/Dq6zN6xguEg4fUKM5U16vBRgaP9+/Y
j8Hb593wWJ5Vj7WW8hyJTY8DF9cJWTd+ZzM2c0G2NZ2J4PpPWuLL2W34yVRr
9niBFHC3uMX7f8h2YR+riC6x9engGfI9+u2frdllcVZRp4JVWEEZvsOxvFWo
31nqXZZWFJ6fJet6xuM+Al/n8zlTKx3LesTXmng4g1+zXZDySqEAn+8IU+CX
dwe/YlMnn6lVjpX4+B6ZeHiDR0TsL7gdUoPnrjiWFz81ADw8NNz2lUID7hM7
yM8v/xn8R/BCldCkZnxcesJGhY4Q8O++NiMZWu04jRV0yMQjDPybZ8O3ptIu
vFFT77bL/h/gm6PMtvhkWbPnmv4dp64qxdZqeBeiv7IarfFcNm3RuSic4Suz
elWNKWZcx9hHZOG5dJx4oEt+ZY0VeBKqdHPWKcDPO2uDK33vg59MM/YWOVeO
Y6QzYyRqnoHfDrhWnJNQg6+GHzEJn+4Ivuc365izTgO2P6RzsdLXGXzRpon1
B6qbsc/wzhsTlN3AO6xSTETOtWP8Zus9iZo34JFxdl1Vw1247Z1b0keWO/iD
AZaKi4U1e2ntwuSgEh126kmT05WZ1ciq8mWr1pwoLGyQISE29Bwzrr56eGTP
nHRc+Xv0+eIhD3D/DfsTImcW4M/r3eyl+/3BpfNWP94zpxzHbnZTWTz0BbxM
jsfnt20NDig7pex79Rv4oinnHkfObMAvrNYpSfdHgB8vKjl736kZWy8c3fHD
EoN7fVTevWdOO15f1bB48VAseJPlF+l5bl3Yd63GYkP5BHCP30uiNryzYoet
6tPVzTRgK9WuFzl6qQbd2FvZmKMeiZP/k1w8hdcdM/4qqH18jnoa5j/8w42X
9zN45NyNj0Su5uPNaw8vfcr3A9yv1MI+W70Mfx1/S5eXNwZcY/fBXXEzanDK
Wa0FKVMSwBU/DewWuVqPqwrEqp/w/QTfPNNV53JNE+5FPV4a09PBZcw36War
t+FJ+2s38PJmg0vkFh5cFdo5dr/dJdzMmwtuEbTA/rfODfbXMqma162n2WyD
keyyebVo5hejzU0zIvDJtNURQ5kfMeMvl2XpN85IxQfbi4YGM7+B77268fnq
p3n4driGxpYFseCHjt3tbphRivOt1rwezEwCl/Fs9tujVo0lts1o/X4nHXyj
s/2h1U/rMNvmisiWBTngco9kp03NaMTGdU2K83vzwBVuVEQ2zGjFgsoHzg5m
FoJvO3fPNE6rA0d9/OlY7FsCLm/ZvUPs5TV2W/sch6Ne59hyVT/vH8K1aDDo
97qPp39g5drs5EG5IMx4zQc5I+/TP3Fib1DugFw0+Ak5q5JIzVy8PjrcIKI1
EbxgUfmo1+lifO+WyIEBuQzwnZMUxO1sKnGrO17xWjEXvKJX82OkZi2exWO+
NKK1AHxOi7X850MNeMvJJaIlz0vA95QHpXudbsaGCXnzB+QqwB9lVei7XWrD
SY47nk67UA3+4IfrQJP5FfbI8+R3PecvskOOOm0uMaxDts062ysPf8PKP6YW
aTh/wYz/9I2/X3E4Ce9e8ERRwzkW3LvzXG9DQja+fsh+Qbd+KnjjlL8rKg4X
4jyN1MFdzjng4ksfH8rvLsMm7ekN74YKwEMXPU1qSKjGo0+zcn7rl4LnB+To
H3eow86SudFKiZXgvXJzB8sPN2KXU635u5xrwGcnHXM8sKIFHw9rU+9NrgP/
L6h4gkj7JfbrF7d1k7ZbsleXH+3S46tHeRUDbX97vuLcF5U6n5RDMeOh/14q
/e2Jx4tOZPsGKyeA33y2ftZQRwbOvSbje984E9zLtunXcE8eTlBN2RusnA/O
t39j8dCvYvwu/1rePL0S8PMid/FgRwW+ZrBq733jSvBWc+O9VpY1eNVlM5OB
qBrwt/v5k4d76rBwlPLKYOV68D3y3zbfuNiIJ/IsajmZ2Qj+eerte2IzL7Il
DXy8p0ZdYXsfkvAq/FSP0o1ThNvkv+Cp0a9THTy/YcZ9j6g+bJWPxWXnI6c7
eCaBt0wMvFNVmILdbguVtg1mg7sU8qJW+RyspJYWZO9ZCP7NPzzK8FEB/iVw
x2b9rnLwoptnN1cVluDdZm/82warwQd0Fv44uLwSf8i58mJrZh24rVPT/Fb5
Gjy4ce9Ne89G8LfWMQdXHK/De15JGddcbgEvTm+XuZVnxvZ/+7PzUf41tmhJ
9wHOeXOsgpfpT/NALLtQ3Xej5w/MuIzilJvJ5lE4psC7ZIPnT/BxG6pO7N+f
iC/udjrvcy0X3EQlYnKyeTqeGLL34gbP4v95oPp+keQc7DJbyDI2tRL87Ua5
Ffv3F+AXCq1bfK7Vguewlw/a1hXjo+fUoztsG8Anqc5KSzIvx+Lu/qwNns3g
8jnj3o6OVuFfOXwx17+1gft4i4RVTTvNvjisqO555wbbTS/6v/yhBtRjWsPj
MOSNu5v+nDyhEIEZVz9/R91+KAy7F1Q9PK6QCv6fUKpa240Y/OF1badqUB64
5S+dTruhRHxZo2DecYVS8Ir0Msd119Kw98hJz6hT1eAf9oUsaLuRjfn1Kr6r
BtWBF8X1dShsycNXP+lm5P9pBJ8msyXGbuzzX8ubXWug0AqO3t9yrA4vxhoG
agPtdzvAD/57G/QhVZ8dOCAz+wy2Ys8qfBin496IlhaLTn+n/Q6Xn6s0tT4T
iRn/FpH631vtYLxuUd0DqzNp4EEJcU82Rn/DN+4ESFbY54OPSrrbvdFm4wrL
hllWZ8rA/VJYKeN74rB7KP9N2yU14DrWa3ZtjE7C2sGru8vt68GHpUUyjB+m
Yh5fNaPV/5rAver59rzRzsRfPYxKb5xpAxdPt2pu+i8HG76+uzutqBN8Q5XY
T6chLXa/5DiL5PvWbNt9OldylJtQ2qq8VjkZB/whZPpB/xVRmPEnz0ZOyMm4
Y74rlaZ+K9LBg+86aeWr+eLj6q8L2QsLwE22ConKyXzGrIPJfb4rysGHf1TO
frA1FP8Xeu1pimsNuO0Gv+n5aj/wjUj71+yFDeCiny0mLNGNwq1x3gFfx65b
xktmi/7bJBODD6RGRvquaAf33Htv4NimOJyUk5P2NrALvGO4s3GL2iK26uoD
Go9zrdm8eSKrtdqa0K5u04qZtUdwgu66tooLUZjxWbOWtvHXmuLj09/9Lb+Q
Dn67MPnrUz9L/Plyjo33vgLwK0tHzPlrrfDapr33yy+Ug2+Sm++q9t8dXCR5
NuFxUg14yLGNV5763cfChqtVvPc1gEvd19LNUH6M9d50JMfUNoP7BZzdyF/7
DL/MD1Yrv9AOLmii+EQCOeCi6RfS+ke6wCsTL/lfuKjO+iFRcMnCy5pto91U
nenQjLw8zeLT5R6jIz7X3rQqRWHGtRaWdqXJuaGwabqfWpTSwT+GjrBdWz1R
pcemKZ/WF4B7H5r5IE3OD9VsTZBrUSr/n49bojny4BPqNvUNFQioAdfJm/fE
tTUE/YnoTA9e3wCu/dGz44vAN9Q3ZWPDrqjm//k1Se00uXA0oHvjX7NS+/9+
T43Q0Hr9KDTkFTv7QUYXuMIq783PFh9h8egbxCr+tWIPZ31x1pRtQQ5WXm7D
ua/Q6UXPLt/3isSMR853/zGU64+OjPO3u+eVBu4yLJu7ZVEoihuYLHMyMh88
q2Wh6lBuBNL9/WP+Pa8y8ImmPPrl8TGo99LGO7kqNeBidb1uWxYlIGQ+o/9E
ZD0461BL/quryeixWdPZnrXN4IdyyvmHclNRnklM9V2vNvArqtnqB9dkooVG
bvuF5nWB33yfOo1H/RTrRiEaCi6/wbbcbaWeXtaCKudbGj7W9EKTdEpXKjpG
YMZv8S2PeKQZitaX/lHf4ZgKbv+QP07jEht9Ub55+0tHHrgWzz/DR5oJSG3R
nbLtjqXgxdu6jVsNUpD58I4FJq+rwQ1uNZlqXMpE0U0Jql866sD/HDsnVxSf
g6bmq1weRE3gciPGmx9p5qP9MT8/bHdsBbd+e1JBvqgQeQSq5zyu7wB/Uhnj
M321KStLwzRsv/p1dme6yqi6TSviP7bdvafCH1lNWGZqKxiOGc8eqGZ3V0Sg
nP05bs8EU8A1PLILLcUT0O99P1ktGbngMknSu7srUtHQiI/0M8ES8KeWP098
T81GE/0eLlmrVwX+7+HVd5bi+eiB33q+loxa8POvJErX3ylCT28uvbv5VwN4
TWDx7O6KUuSwd9bfp4It4PvwI+3P8pXohcQEy4oN7eC5R/Q7Jmmas6b2zd35
ZddVtvEugdAU8TZkOv64Tsmtz2i5MV+ag+R3zPj43IHk4lsxqL0icIqDZDK4
xtLYxgT8E9UqthYEGOSA74pIuFN8Kxtlzb3pYy9ZBP67VsIx830+iuwQuGbR
Vw7uMs3WIwEXo301Ot4BBjXgCht+f46oKkepaSJ2C1Xqwc2DVxkU36pG2781
XraXbAKPjys/nWdfi767f9YfL9AKnlrtlByrcIl1YcevOYPNluzalDJj1fSx
1+ujJR+n8RUFJj3burQhFDO+1u3My1iNeNT7T8luSUMCuG/lasElPenI0TXe
+qteFriA4xWVWI085DrPQ3ZJQz54Rmjx3d+ixajZyCD4zKJS8CdF8rFiPeVo
U6io+NexvzvjS601RyXqqlH87a5Ma9Va8DszRhbGatShsyuy+JY01INXvw9W
OPitAQlmBqsk2TSBv5suYShWcpmVNLkyedxqC/YR1Y8Lk83b0dnz1lclU8PG
1vEyFR9UQzDj6oahsatSE5GVYI7iB9U48PNTnOve62WjV65T3f6YpoGHV+4x
WpVagI7wi/V7quaCTwjjawlVKEOmOtEeaaWF4D6JtWHv9arRDeeDGn9My8DT
pbf118+sQ0+Ke/tExupExn+/fiu3KrUBZfyXku059j4wPod3+Nr5u81o31ph
8e/P68GFvizyOil8jRUyOzuaf/EFdmHShVxl4Q6Eiz5dz+v4jia0uL70jQ3G
jL+N+PMltyMZiXe8dPaJZYMHJajmHe3OQQ0hX85vFUgGn776pWZuRxHadP6l
kE9sJripU0OySksFSnRmH5kinwd+6t88j6PdNajTQmbtVoEi8Nky2yuFf9Uj
YR2v8RdbSsETDI0X5HY0oW3SwvkfYyvBL7naH3jW1oo28CrndWjUgK+btFto
V+d11jsXba1TH0zYWspbHiZEdaBtldOPtwaHo5NVpSkHLHwx42/vv3rcEpyC
qkPxXz2LH+D/7db7LaWYh3j/qaba6MaBaxysWdgSXILeia5z0bP4Ca4cstFb
+79qJLtjwYk1DpngDd+vR0op1qHT63he2ujmgt+LxjnTrjWikPg+q3bDAvCl
8RObm4Nb0Mi+thN6FsXg8T/VRhLrx67HxirVOJsy8Ox7w38Vda1Y+afuu/O/
PcFOjZ+koHiiE/G90dkjOzkSGW3Pr9WO8cCML7FyN904OQ2dSGjT1I75Ai5a
kFbso5SPZhqb+V9zjwCXMt05vGFyGaq6f2WCdkws+Dubmhk1Y5/H73o/ZE5J
J4Ev1xR191GqR3YrB/WvuaeCB809KnPOuwmdGpa3s52ZBb6h/lXchsljn0uj
rZVaMTngkZ+K9w4bdaInWUd7Dw3kgecl57y8q2bNylmfNUHkhS5baUf2r1je
LvT8S8Bamc5I9F3lmfuBR86Y8dwX+srSnWnI1aitTe+RN/g530uDH7rzUeu+
n/HbxT+DWzyQz17bWYYe9716rvcoDFxh3a28iks1aIWrmb5ZawQ4y6OG/aG7
HtWJuLtsF48B3z5Tyd/kQjMKMXtsrVEUB65466Pz2s42ZMO+aKj3KBFcpXOK
Te/ZLqTNf2TXCfmf4G0u7m2iCdasY1OFao8psdjsmFfe24K60P4zNy1ET0Yh
9owb980qrDDjA2eO3l90Mh0FCR9wMq14Bn4i29pXV70A/ds7KCPw0RlcrU1j
xqKT5WjZG5X5phVvwOdOmBHRHV2DxLvVbE7yeYI/deg11VUfW7+6XOid+dEb
fGRhhWhEYTPS3PzShL3dD/xiQELuwpPtyKAyuuJsRSB4g1zgfZuuLrR5e7fv
M4XP4F309XZM5L5e1pv364L0V/5CB+nrvcPHfb2I8WH6es1ncV8v+Cn6erO1
uK8XXIO+3uaX3NcLPp++3ttd3NcLbkdf73Qn7usFH7+IvF5XWe7rBbekr3dZ
Kff1grfQ11vM4r5e8Bp6PYev417PrJLKl7yiVr/Qe3o9Bypzr2fEeDW9nu1O
ca9n8Kv0el5Crmfw2/R6vtnLvZ7Blej1XOrCvZ7BVen1vIBcz+Aa9HpOMeVe
z+Ba9Hq+Es29nsH30+t5+Qzu9QzeRO9XmuR+xZqz6N/xysxfaDG9XzVs496v
EONy9H5VE8+9X4GvpferPae59ytwRXq/OkbuV+AB9H41h9yvwDfS+1WGBPd+
BY7p/ereEPd+Ba5G71eLyP0KPI/erwYzufcrcC36PFpEnkesvUdPRL0V+42O
0udRcyX3eYQYj6DPo1PkeQS+hD6PAv5yn0fgxvR5tIw8j8D16PPozXbu8wh8
iD6PppHnEfhb+jzaSZ5H4Nvo8+gueR6B19HnUUwD93kEvoXWG1dIvcGyf5M8
5+il36ie1huOzdx6AzEeT+uN0HZuvQGeQusNe1JvgK+j9UbiOW69Af6K1hvW
pN4At6H1hiupN8Blab3xVZtbb4C30nojcy233gB/R+uNP5O59QZ4Gq0n7Uk9
yUovW20ukvwbvaT15ENSTyLGL9N6UpXUk+D2tJ7cRepJ8HpaT0qQehJ8M60n
V5F6EjyZ1pOrST0J3k3rSSlST4KLvCH1pCupJ8F30npyHqknwUfpegGR9QJr
6gLHtLJ53egdXS/cJOsFxPhxul5IIusF8B66XtAk6wXwHXS9cIasF8Cnh5H1
QjBZL4AX0PVC91fuegF8D10vvCbrBfCvdL2gQNYL4HPdyXqhMoO7Xvjff/co
WQ9W9XLXgyyVQ/3LX5t2ow90PfjvNHc9iBiXo+vBBLIeBH9H14MJZD0Ifoeu
B33IehBcto6sBx+T9SB4C10PypL1IPgbuh70IetBcF+6HpxH1oPg4+PJevAJ
WQ+CT6ki6/0gst5n3XU7cvsQ7kYP6Xr/CFnvI8ZVB8l6/wtZ74N/pOv9ErLe
B/ej6/1Sst4HL6Tr/XJf7nofXO8RWe+fI+t98GK63j9P1vvgB4PIev8CWe+D
l9H1/gWy3gef6E72c46T/RxWTHFs6TzBHnR0AdnP6dDm7ucgxkfpfs4Csp8D
vvsR2c95T/ZzwLPofo4M2c8Bv7Kd7OecIPs54KK3yX5OANnPATfUJ/s5f/K4
+zngP+h+zlaynwM+/R3Zz3lA9nPAtSXJft3vY9z9OtY/4RUbSwx7kKs12a/T
I/t1iPH4BWS/ToPs14Ef+Uv2676R/TrwolayX6dC9uvA/eh+XRvZrwNvovt1
68l+Hfjyw2S/7gbZrwM/kUv26+LJfh24uxrZr5tG9uvAZ/8k+7GfyH4sa7Pe
M3vX7z0oxovsx+4j+7GIcVNRsh8bRPZjwRW+kf3YYrIfCx53hOzHlpD9WHDV
CWQ/toPsx4I35ZP92E6yHwu+ypfsx3aR/VhwsxtkP/YX2Y8F/7yb7Mf+Jvux
4KKtZL9djey3s664/G7R4/uDtGrIfnsi2W9HjM/lIfvtJ8h+O3hCyv/bbwe3
EiT77dJkvx381Rqy315M9tvB+7TJfvtcst8OrnOZ7LcfIPvt4MGvyH67K9lv
B7+vT/bbi8l+O/iCSnKeMn419zyFFVqgqyR89A/CK8l5SiA5T0GMWz8l5ylC
5DwFfMEdcp5iQs5TwI8okPMUVXKeAh74nZynzCLnKeDD68h5yl1yngKuHkzO
U7rJeQp4uhA5TzlBzlPAL+mQ85Qccp4CfvIvOS+LJudlrG6hqHeFn/4g+SJy
XtZOzssQ42nh5LxsBzkvA/8XT87LHpLzMnAhel7WQc7LwOfQ8zJ/cl4G7mlF
zsuOkvMy8DX0vGwmOS8DD68j52Xx5Lzsfz8njZyXXSbnZeCInoc+IuehrLX7
xAadeXqRPT0PndLMPQ9FjDeeI+ehYeQ8FDxuFjkP/UrOQ8EF6HnoM3IeCn6c
noeGkPNQ8AP0PFSUnIeC36bnoU/JeSi4jzQ5D+0n56HgWe/IeaghOQ8Fv0vP
u+PJeTfLzOnB3v37e9EFet69m5x3I8ard5Dz7mJy3g2esJ6cd98j593gc+l5
twg57waXpefdoeS8G9yAnnd/JOfd4E/oefdFct4NHrqTnHezyHk3eGU2Oe+e
lss97wZ3oP0MSqSfgeWf2xYk5NuLgmg/gxjpZ0CMP6b9DD2knwE8kvYzBJB+
BvDLtJ/hCOlnAHeg/QwzBLn9DOB+tJ/BgPQzgMfRfoYfpJ8B/BztZxCQ5fYz
gF+n/QxnSD8DeG8g6Vf5SvpVWM0C2lPyh3pRFO1XaSH9Kojxt7RfZQPpVwE/
TPtV/pB+FXBb2q9SSvpVwDv2kX6VCNKvAq5B+1VekX4V8ELar7KV9KuAP6D9
KmtIvwr4RtqvspD0q4Bb0n4kQUduPxJrufa3E06afcia9iMdIP1IiPEftB/p
BOlHAnej/UgvST8SeCHtR2oi/UjggrQfyYb0I4H70n4kkWfcfiTwJNqP9J30
I4E30H4kP9KPBD6B9iNdIf1I4Gtpv9l/Hdx+M9ZJhwXROu596BftNztF+s0Q
48W036yB9JuBH6H9ZrtIvxl4Ou038yL9ZuAKtN9shPSbgRfSfjNJ0m8GPoP2
m+mRfjNwFdpvdo/0m4HfpP1mxaTfDPwc7Sf8SfoJWR5Zt4UFe/rQdNpPeIX0
EyLGnWg/4TnSTwi+h/YT2pN+QnBd2k/YTPoJwaVoP+EO0k8ILkP7CTNIPyH4
RtpPeJ30E4LL0X5CcdJPCL6F9hPmkX5CcHfaLxpN+kVZlTMazXOU+9F12i+a
SfpFEeNutF90DukXBY+g/aLKpF8U3Jf2i0aQflHwXbRfNJf0i4LvoP2iLaRf
FFye9ouO38btFwWXpv2i00m/KPgK2i86l/SLgj+k/cBzSD8wS2T3rnQH135k
TfuBp5F+YMT4LtoPnEv6gcEDaD/wW9IPDC5D+4HDSD8weDntB35N+oHBRWk/
sA3pBwY/QfuBT5N+YHBv2g+8gvQDgzfTfuBXpB8YfAvt98ZnuP3erIO2n8W1
2vrHrjfS733Ph9vvjRhn+r2t9Lj93uBMv/frDm6/N7gh7fe+upbb7w1uQ/u9
/X9w+73BtWi/t9tBbr83uCjt9344xO33Bmf6vS+/5vZ7g0fRfu91pN8bPI32
85vFc/v52S/TZ9vwswZQH+3n9yb9/Bic9vPHkn5+8Ku0n7+I9PODW9J+/kzS
zw8eTvv5k0g/P/gP2s9/bAm3nx/8O+3nLyX9/ODfaD+/LuL284OH0n7+HNLP
D15O5zUMybwGO3/ajbJMhwGkTec1Di/izmtgxv+j8xo5ZF4D/Cqd19j8gjuv
Ad5G5zWeknkN8E90XqOCzGuAN9N5jZdkXgNcjM5rxJB5DfBDdF6jhcxrgDvR
eQ1Ba+68BrgnnccxJ/M4bMFd1Rvt6gZQNZ3H2UXmcTDjh+k8jjKZxwGvo/M4
J8k8DvhcOo8TS+ZxwFfQeZwcMo8DvoPO41STeRzwI3Qe5yqZxwG/QudxbpN5
HHBHOo/ziMzjgDfQeasaMm/F1nqi7KApO4j46bxVBZm3wowfpvNWb8m8FXgR
nbfyJvNW4DZ03uovmbcCl6TzVv5k3gq8lc5bFZB5K3BM563GG3DnrcBf0Hmr
NaLceStwEzpvdYDMW4G/pfN0o2Sejm2b4t86/fEgek7n6f6QeTrM+Fk6T8e3
ijtPBz6ZztO9IvN04Hp0ns6ZzNOB+9F5ugoyTwduTefpll/nztOBf6TzdGZk
ng48k87THSbzdOD9BmSebpTM04EfpPOSc3y485LstCkzldPLBpEonZe8QeYl
MeMX6LzkhA7uvCT4HjovuZPMS4LPpfOSSWReEnwKnZc0JvOS4AMlZF5ymjV3
XhL8Ep2X1CPzkuDt28m8pASZlwQ3pPOSg2ReEnwinYc9SOZh2VNULd8/lRpC
pnQe1p7Mw2LGXeg87CkyDwvel0TmYbeTeVhwSToPq0XmYcHLhsg87DEyDwv+
lM7DbiLzsOCL6Dwsm8zD/u+/a0fmYZXJPCx4phCZh80g87DgTdlk3vkUmXdm
qzwsHVS3GULL6bwz72zuvDNm3ITOO0eQeWdwfTrvfIXMO4Pz0XlnQQHuvDP4
YTrvHEzmncE/x5F552Vk3hl8Mp13vkjmncGP0HlnTOadwQ/Seef/rLnzzuDr
6Dy7DZlnZ99LQvv48ofQLDrPzm/BnWfHjNvEkXl2STLPDh61lMyznybz7OBy
dJ49nMyzg4f6knn2aXO48+zgrnSeXYrMs4MXziHz7Hpknh1ciM6z3ybz7OA6
dJ7dj8yzgy+keQWtJK+AHTvJOzhFfBjp0byCApJXgBmfRPMKNpC8AvBKX5JX
gEheAXj5FpJXUE/yCsBVl5K8AiWSVwAexkfyCoRJXgG4AM0raCF5BeDJ7SSv
IIrkFYDfNCB5BXYkrwA89TvJo2gheRTsUSW+qY+vDSPFSJJHcZfkUWDG/WaT
PIockkcBXixO8ih+kTwK8LIdJI+in+RRgFcdI3kUt0geBbh5NMmjuEvyKMAt
dpE8iockjwLcsoTkUTwleRTgV06TPAp7kkcBLnqd5I0EkLwRtsK98ydV04eR
1yGSN5JL8kYw42vnkLyRAJI3Aj59dCc3b+QyyRsB77UgeSPCJG8E/GQzyRsp
J3kj4LlHSN5IIMkbAd+eQ/JGrEneCHixJ8kb0SR5I+D8R0neyEKSNwL+OJ3k
yeiTPBn29fj8aF7Rv0i3neTJYJIngxmfuITkyfwheTLgnR9Jnkw8yZMBL1Ug
eTK2JE8GPCmX5MkEkDwZ8IOhJE9mJsmTAd8zSvJkLEmeDLiyOsmTKSV5MuAK
ziRPBpE8GXCviyQvyJ3kBbG/82yem2z+F41MI3lBZSQvCDNu6UzygtxJXhB4
2zKSF+RL8oLApQ+RvCAbkhcE3u5B8oLWkLwgcJ8Wkhc0n+QFgX9xJXlBk0le
ELidAskL6rHm5gWBm1aTvKAqkhcEbjRK8qDukTwodu/29xcfJPxFd1JJHpQu
yYPCjDt4kzwoTZIHBV55iuRBXSF5UOBznEge1E+SBwXOsiB5UM9IHhT4qb0k
DyqM5EGBP1tP8qAqSB4UeCnNg5pE8qDAO2kelBTJgwJPvU/yvmaQvC/2epuJ
GcrC/9D8iSTv6yzJ+8KMv3pP8r5cSd4XuNMikvdlRfK+wA+akbyvIJL3BS4a
RfK+zpO8L3CL+yTvawrJ+wIvpHlf7iTvC1w+n+R9yZO8L/A3wyTvK8ePm/cF
vvEPyXM7TfLc2BdiTFZMOvMP/ZdF8tzukjw3zDg7juS56ZA8N/AhmucmQ/Lc
wF2iSJ5bBMlzA5+3keS57SB5buBNNM+t4QM3zw08jOa5+ZM8N/C78iTP7RzJ
cwOX+Eny3NaRPDfwUprXJ0by+tjBo5k2CVH/UA/N65MieX2Y8Via15eUx83r
A380RPL6NpO8PnCJapLX95zk9YFPVyR5fS0y3Lw+8F80r8+d5PWB59O8Pg2S
1wdeTvP6+hW4eX3gu0+TvL4PJK8PvILmMd4neYzsNtaG8rv8I6ie5jG2DnDz
GDHjPItJHuM4kscI7kjzGJ+e5uYxgj+neYxPSR4j+MGbJI9Rm+QxgostJXmM
wiSPEbyX5jGeI3mM//s5NI8x5w03jxE8muYxbiB5jOC/aN5mfy83b5O98qab
rOKJETRE8zY9/uPmbWLGTWnephzJ2wTvoHmb7zdx8zbBvWne5gSStwl+dBXJ
29xE8jbB+YpJ3uZZd27eJngjzdt8l87N2wSPo3mbJiRvE/wdzdu8S/I2wecJ
kzxVhUfcPFX26egRB56wEVRJ81TDHnPzVDHj29RInmpZOTdPFfwRzVM1G+Lm
qYKb0zxVs8ncPFXwgzRPdRPJUwUXqyR5qptInir47FiSp7rJmZunCj7Vi+Sp
bnrNzVMFH6F5qps8uHmq4LU0L1cjh5uXy/b6e7ItlncUDdG8XPyZm5eLGdem
ebm/z3HzcsFzaV7u3UncvFxwK5qXy5fJzcsFd6J5ufvcuHm54M00L/etITcv
F3wrzcvtEebm5YI70rzcl9bcvFzwJpqXq1DHzcsFL6d5yMI+3Dxkdu2WFGWb
Q6PIgOYhy4ty85Ax42o0D9n2HTcPGdyc5iGz53DzkMFZNA9Z9hg3Dxn8Ps1D
Lsrl5iGDm9I8ZKc+bh4yuA7NQ94zn5uHDC5H85Cnsbh5yOCijiQPuV6am4cM
7kPzro8hbt41W/SGlPu2oFHEL0DyrvMDuXnXmPH1NO86/iI37xq8i+Zd2z7k
5l2DK9O864j93Lxr8Ayad93znJt3DT5A866nDnLzrsGX0rzrxQbcvGvw3TTv
WjaZm3cNfo3mXYsLc/OuwZk8872/T5nLxvFH745wGhodHUVMnvkG4V72C7Xd
bMaZPHO/k3UxTmrHwJk887KF4s+lvhuBM3nmtY9LtzupnQNn8sx7r+8cHO64
CM7kmQ989tCW+n4ZnMkz/9s47Gdw+zo4k2c+bqEuj5PaTXAmz/zOygNBJ6ba
gEvWNu8SOxmIXFXHyVhUmCJn34t7Sj7dQ+IBgSJ66omoY8r120If74OvXpUx
sK4zAD1IC+8/9Og+sl06dXs873tU/3G8kVd3Asp69Dh7h7g7+Pt52ePlJgeg
MkF8a2/Mc3T62uqO9DI/5JXfv8VXKQEtcfvbdt3dH/yCT3NvW7Afkqy7lHPI
whXdk24VKZ8XgiZmPlZbqxiPpHfX3LmjGwIetd2oLb/DB1Vl3R8fEPsO7VvG
is9R/o6kr80RPdYdi24dXbKVJfAdXPWrKF6d6o069x1geat6ouVzHU2Sx/6u
MSGJYu56MWifwcSrvaaR4FI6b7XiNT6g/gWyicsavNDQpJ6HlZkxSPznXvMl
PVHoy/iQM6F6GHzxq5KNpbfc0eRHzRcdJX1Q3ajI4RLDeDT8afmKRPwDKe+x
0A40iAU/byE38KfiFZrSZ7jGXtAPpQ2qSOUPJSJhJ5N+S/FQtOewUXRLRhz4
4a0tO59ovkCJtor/lBz9UVjPhfFZDj/RSb+3cRqXgpFy+IpxIR3x4O5TNl74
m/sEDe123ffQKwC96XiVnyKehhQERR23LPJCsiNBn05GJoA7efU/Spe7hlb4
XrFuVwpED5oSfBKiMpBetiN+2eqI9B/k3v20PhG8ccGeRrFaDbyo1jC56kIg
+n7hSrT+ymxk4Sr+6KXfKVwjdHLAe18ieB3Wbt0scxv37EiVCFwRiALNpq84
eikHGfBKbCtUc8UuW7ao4LF1BuPGvXu73bXt8PHMzxK3zgQg9zMeDodwLmoM
EgqXjf6I7w3ZOlbYJ4Drehytez7kjNd0fJ9oqOCPnE/LDunx5aMjsj8H2258
xkmZ+rvUguLBy08nh6Sav8HHZqut2OTpix4bpp3kfG4bnCokdPeH4TmKUjE+
1+LAxR+MGrfLe+CD04LEHD0/IqvjBhk67oVIV/DG4erCcGwvbbOwfTAGfNS6
8dRIzwf8W8ja6rOyF7pwrFdWq60IlcrqDg91RGPJ0juCD4zZ4N9211VUHf6I
pW+czdR09kCGh5+4a8qWIL7BXecbE2Lw6jTP0936EeDF5jZtPqd9cV/HMvVh
ubfowAFRvl02pUhiVEovSjMOq1Tvt41oDQOfIFzF2zLDH2+cXJoynOmCdu0P
tVBNL0Phsj9mrnkaj8sywg9sWfAF3O9WbmyeegCedCr3xxReB4R01CqUhStQ
peN13oVXE3BD2YXhJ3y+4N/PnEzTmROI5YLET4sN2aD1eypVFE9UoomS2tuj
ZibiXWfu4bX9r8A95k5rFT0XiNMuqN9aVnMErdCw+LwtqAp5VNoKuugk4ttf
e66X+FqC/9p9wyJHa+znF99rMPOwxLbLJv4nalWNnMNst7xWSMQJ4lvHC8g7
gDc0HBWtZgdgf7XDeJLAY8z7ITP2rVgNSpCYoiKelYCDawf849I9wd2NhOZ4
R/jj7pS+oamWTthGzO0y576sPrho5tC0sdf71PHss7VB4KkDV5S0VP3wk5G+
O2cFXuHh9yclX5vWovGJUk8398Xhg1Or22fYfgV/5mkuUmTmg+Mq+VbKirlj
y0VS1fME61CF3o50fcdY/Hu93uIsmR/gEncuTy1f541HHbf9VO73xF1vBl64
fq9DaQ21KjvTMf6s8G9t48UocEMfnhE7d09sqvepeuMtb2yyIF5N+Gg9wv/+
Tcv/FYk/LCobNRKNAVe5umkT/933eMnqoNtuwT641s12xJmnAR2YFnlAzfM7
3nVP2ul3XCy42/YbS9YruuFppwQsL1j54aNzD3wV8m1Aa3h5Qwy7Q/BWrU2B
OgvjwW8N5CXvfO2Iw67cO6JR448LXZYYO2k2oiuCJltamgPw5odn7vRLJIB7
rpnne17zIRZ55Kd4vigAa8/uEBHsaUTPP4puErzugWtKvN4/r0kATwjQf/9x
ykXsZzVNo+5QIE5x+p7j4NqEln/qft4//SmuatR6K6GUCO6oVnY4zOcUmvTE
4O8Tk0CsJHjnAT+rGQl/eOGWtPU2Esl9ZSC+JxF8VHurZE3sXXTn7e++lRMC
cbSDxhbOc9dlfOvKLM+36PCOrR+O8iSCN8b0W8jXO6BZWju6T60MwHL8wr+m
P25BRiOr+vfq+qGVO0eD+PQTwO0vim/v9HiJji0Z7MJVfviLbY3XU6lW9GWS
wTLz8C8oqb92e+bpePAXLiKO6iNvUfve4Yz7kr549fTAg3z5rchR+3hf2M1v
yFdlOMFzcRy4Ku++G7ZdHqhdWNosatZH7P3k8ozH19rQX33JKu2mCORZdKsq
zS4GvLpnuYWQixfKvdSazOPxAS/mPMZF21FmaN/gghr2WL2t4GZjHg3eU2zK
ymr6iIR6BM6fq3DHrg+nXX2Q0I62mzzsLFkTi47Jf7uwVCMcfPD08EbpMl+U
NdFjXILvayw0uXD1pDMdKEfi6sMTXnGo6IKZ9HN2KHjCtkd6Usb+SPk6vh21
zBk/u+dec5e/E/3UfztZLDMe/WL5Dwt//wS+c1vyMaNHAej5wydnNjs9w7wT
zrrwhHWiqaIrB9U/JqCQnpu/TM55gxts05i9cVMgMku/nWOXaYVv22zcZXOo
CwnMde07tTIRfVHKl2955Qx+b0eBaap5IJIb0fZJPR0cNTzK+V8Xuvb39J/9
+xNRgL7+aEFGEvgZ+vPnpXJ/PtqMTh3COr/QXPrzu3dwfz64Lv39Pz7g/v7o
ys3U0Jvev5AQ/f15yO8PXkPfn/Br3PcHhUav5WcN/EIV9P0RJe8PuLAxef9P
kfcf/f77wuSf+m/URN//h+T9B19cQv6+Rd3cvy+SUhiKj3r7G52gf98J5O8L
zveHXD8fyfWDzt7QX2T16zeaEUauHwFy/YDfoddnFLk+kW9EwtUtit1orwG5
Pm+S6xP8H73+08n1jxoGV+YNOXejGnr9O5DrH1zYgny+EPl8ITF5+zURzWM+
mXy+PpHPF/ihWPL5HUc+v0j/6p+H17b0oNmj5PO7gHx+wVfsJfcHS3J/QK+/
H6yVs+tBOhPI/UGb3B/Aj2mS+w8Puf+gkj62wkB1D+ryJvef+eT+A27mR+5v
n8j9Dc2WXfby+/o/6EMAub/VkfsbeOhqcv9cSe6faK/l49+XH/xBld7k/tlK
7p/g/9H7cwq5PyOH0M5dsiV/UJoAuT+rkfszuDK9/4uR+z/K7Nn7sVeyF3VO
Jvd/TXL/Bx+4Qp4vCuT5gqatDx8XdrMXLaLPl2Pk+QKuRp9fd8nzC6ldXHT4
Uk4vekmfX6Hk+QU+mz4fhZy4z0f08MvdsPXL+lAwfT5mk+cj+G36/M0nz1+U
8KuZv+dyHyqgz9/pG7jPX/A4+nz3Is93xCO9+0xISh/6m0Ce76bk+Q7+jtYP
41K59QNC578mmIv0I1VaPwyT+gGcqU8CSX2CrIPnisqc74f65BOpT8CZ+oeH
1D8ossP62q/Yfqh/3pD6B5ypr+5f5NZXeGB1Xd4noQGor9JDufUV+Fdavz0h
9RuWNVWVOn96AI2n9Vsyqd/APWh9qEDqQ2wREPRIKmIAFdP6cFM5tz4E751D
6k9LUn/iL62CdR3TB1EwrT+nZXLrT/BYWt9u7eTWt7hz5dWtQfqDSJjWt1ak
vgV/SetnPVI/49UmFS9NQwZRzwCpn0+T+hm8iNbnc2dz63N8xndHt+SkIfSO
1uenSH0O3nOf1P+3SP2PfZp8NNr0hhAfrf8DSf0PfpyuL2zI+gI3iP/n4+8/
hB7T9YU0WV+AJ7mT9csusn7BS4wujj/zbwj92kjWL+Vk/QIu9Yesjy6T9RE2
8C46vFJrGA0FkvXRC7I+Ar/PJuuvUbL+wm/rFb41ew6jvZPI+sudrL/AayeS
9Z0oWd/hsqWeM317h5HMQ7K+qyXrO3BfH7J+XEjWj3jeSd6zp1X/oo+5ZP2o
R9aP4NJ8ZH1aS9anWNfTNFH89V9kPIusT5eR9Sm4BIusf9+R9S9+UZMj2tjx
F730J+vfFWT9Cy57iayvc3u562ucs3jTde9t/1AgXV+Lk/U1+B26fo95yF2/
Y36DN/mGTv+Q3Weyfhcg63fwJ3R/wJPsD2DN9+PXLmv8h77Q/QEZsj8A/pbu
Pzwi+w/4SaXR4zq5ETTuK9l/iNDn7j+AT95B9jf6M7n7G/jnwvQ6z6cjyJju
b2Qf4e5vgH+i+yfLa7n7J3jSURnWicoRtI7un5zV5O6fgGfS/ZlIAe7+DFZ8
4+IqJjOKkun+zMWX3P0Z8F10/0ckhbv/g2+XDXdX3x1Fw3T/Z9xD7v4PuAzd
X/qmyN1fwt/mH9d0LxxFq+j+kuIk7v4SuCKtr+67zwx3UWPB9+59kfD4j1NH
dS7fEOIwVkcx309Xr+bWxMlnmDplT/EJJRaL2afKTCr6xamvtH0PebaO1VfM
vz9ksdR3z8pOJNx997VKQDDsawXFHrTh5CFcdZ2UYqfwGdzIx2EPpx5rXjJr
/5axeoz5njj9NTEdnHqs4MAp9zNj9Rjjs3MmbufUY6Yb5X5z6jHme9ZuZkT0
Lh6rxzpU9b3mjtVjjBdUPJzLqceO1988w6nHmO8pW3b3uDmnHnuRk3eLU4/B
953duzOfU4/VnCl5z6nHmO/5uhr4Mo9TjwUZ1YRz6jHGdycdUOPUY/MfxvZw
6jHme7K6endEcuqx8WtHSzn1GOP9a7U0OPXYrrUnnDj1GPM9U6s/eLty6jFf
o+V/OfUY4w2NqyQ59diSBW0dnHqM+Z4mO6HVfpx6bHBeVzmnHmNcK707t2Os
Hts2fenUmLF6jPmeoy1a4TkXxuqxx6fi9nHqMcZfz1Idx6nHHoWxJhqN1WPM
9wS5P/6gxqnHZjlaRXLqMcZt+t8pVI/VY4bGl8evGqvHmO/ZWez2Nz5jrB7L
L1kcwKnHGOe5Eev0ZaweO2K0Y5RTjzHfU/P2oU18/Fg9tmZTwglOPfa/7+W5
eMd3rB6b/5S1k1OPMd/zEr7T3mhorB6btO67G6ceYzyBV9H5wlg9Vmi3fROn
HmO+J+X90Egzpx6LqtJ14dRjjDvZa21WHavH/jmEqnLqMeZ7RoQalzZx6jGr
13YWnHqM8ch2XntOPfZtteQhTj3GfE+Hye0LE06N1WOxPnyunHqM8RlzZr/h
1GPW50X1OfUY8z0XgluOe3HqsQnyk69z6jHGldelStqP1WNRGhPDOfUY8z0R
M1X9tDj1mHzJ/FpOPca4u2ypDKceU3Ff8JpTj8H3O5y/epdTjz0oVG5vGKvH
GO8TS2Nx6jHPgeX9G8fqMeZ7CtZYTmrk1GO7am4VZI7VY4w/TpQ34NRj83RV
hTn1GJPzj0XGuXPqMUHBhW849RjjvavSV3HqsYX5ix5z6jHI50/zFeXUYwL+
mTFPx+oxxivVv63m1GMCH3jyJo7VY0zO/HsLPi1OPSZn+W0wdqweY7z/8NZr
nHqsdtXCCaZj9RiT0z7EqkKceuzEvfMv+cfqMcYbZos2c+qxCtVvM1eP1WNM
znlouYgApx5zmTNRomqsHmO8ekdOLKcee6xgrLtkrB5jcsITbJdu5tRjrR5G
4jJj9RjjrPexnzn12CaLmWumjtVjTM52YFvQkMhYPdZTk+H3dKweY5wn1bmr
eaweu/y4UO7vWD3G5FQ7sGxGVo/VY5NW9gdw6jHGJeJOpnPqsZ2Rc0I49RiT
83w+uhhx6rFL63eVceoxxoWNzX9w6rF13VNGOPUYk5P8yE52L6ceM++f8YlT
jzEu8C5iM6ce2zI09JFTjzE5w+9MX0Rw6rGHgUiHU48xLmSTJsepxwz1jqhw
6jEmp3eGwJpZnHpM2meiPKceY7x6bbkapx5bGuiozKnHmJzbFOk1pfvH6rE1
FxsKOfUY48rG7y049djL6aIinHqMyYmtdRz05tRjGcs6jnDqMcZHBFOncOox
6ZkFcpx6jMlZNdzbMZVTj2Wv8nvHqccY1zxtNSQ/Vo/lrTSR4dRjTE5pl5hx
cf5YPSZlHKLBqccYj/g8Lk5wrB570nboJ6ceY3I+RZLaVz/j1GOvFwxy6jHI
NQ16cSZzrB7zr4y5zKnHIFfzyk8Jt7F6LOR8yk1OPcb4lm1Bh/+N1WM3D2mp
cOoxJmfSZnX4DoWxeuwn74AXpx5j/PWW2eGcesxvu3cTpx5jcho7X+qbao7V
Y6/G/+76MlaPMf5Ugudk71g9lncsZSanHmNyDtvzbu+8PFaPJQf89uHUY4zv
MJA5zanHXKwS93DqMSYn8LvOSnNOPTY6Zd4mTj3GeGO8iDWnHhM5IPKGU48x
OXsN7YKhnHps1/Fpazj1GOPB9/kbOfWY/PLf/Jx6jMmpG2c3yOLUY6XvTNZx
6jHGxwuKTy8Yq8fY1a9e+4/VY0zOG2vvx02ceixfOuTX1rF6jPH79r/528fq
MeMNAoaceozJSdO/PvMopx5TcyyU5tRjjJeWfRPi1GPnt3hP59RjTM6YUMMy
dU49NrthP+LUY4zztylOXD9Wj/2ZnDmVU48xOV2Z316d49RjQwlzF3HqMcZn
msTs4dRj1X9jTM6P1WNMzpWAlp0opx57kMUXIDBWjzE+i/77DwPcfw85UUL0
3x9M5/57cBH6+7RO4v4+kLNUTH+fdeT3Af9FX2/nZu7rhZyiZfT17q3nvl5w
T/p+dq7nvp+Q83OJvp8dz7nvJ7g4/XtpkL8X5OQcon+vW+TvBV5Kr4dJ5HqA
nBkxej08JdcD+NwEcr116HGvN8hpke4g19skcr2BX6fX8zlyPUPOCd9ecj3X
kOsZfMJK8nn5Sj4vkBOikk8+L5/I5wV8vgL5PD4nn0fI2QhyJZ/HR+TzCK64
nXzez5HPO+RU7FxDPu9R5PMObvyJ3E88yf0Ech4ar5L7SSC5n4Dj9+R+9ZTc
ryAnwSD8/92vwLcbkfthBbkfQs7A0cXkfriR3A/BZ9H77TZyv4U5/VAdcr8t
J/db8JrT5H4eSO7nMOf+kt7PK8j9HNyePi+2kOcFzIk/o88LRJ4X4L23yfPI
ijyPYM66aiZ5Hu0gzyPwobfkeadNnncwp3yDPu/8yPMOnJc+T5XJ8xTmfK3o
89SOPE/BF9Pn9WnyvIY5WWP6vH5GntfgIymkHnhK6gGYM31G64HZpB4A30rr
DRapN2BOM4DWG/9IvQFeQ+sZa1LPwJwjU88UkXoGnKmXXuzk1kswJxhG66X3
s7n1EngvrcfMJLn1GMzZDdB6LJXUY+AltN67QOo9mFN7Teu9W6TeA2+l9eRB
Uk/CnJc4rSfPknryf/NitF49SupVmJMKofWqCqlXwctpPfyT1MMwZzSf1sP3
SD38v/kmWm+bkXob5nRGz5F6O4bU2+DCtJ6vJ/U8zLmk7yT1vC6p58HfzSbr
hQ9kvQBzIuzNZL0gStYL4LJ0PVJE1iMwZzGJrkdKyXoE/K8dWe8IP+eud2BO
QaaBrHccyHoH/Mpksp5qIusp6PP3HiTrqRSyngK3rSPrNTGyXoM+eRtFsl7j
I+s18OHbZD2oR9aD0Gcu/IysB1eR9SA4/yBZb+qQ9Sb0aV96TdabyWS9+b/+
bSGynjUh61noc85+Qtazf59z17PgIhlkvSxI1svQJ5xH18unyXoZPKCJrMfr
53PX49Bnu2Q2WY+nkvU4uK40We+PSHHX+9CnGkHX++fIeh/ch+4nRD/g7idA
n+elPrKfYCnF3U8An32f7FdcIvsV0CcZRvcrppL9CvD5lWQ/5Ewddz8E+gwP
0P2Qsmzufgj4LrrfcnADd78F+vR86H6L9k7ufgu4Ld3PcVzM3c+BPjdrup8z
W4+7nwOeSPedehdz952gT6yC7i+5eHH3l8CZ/atdN+dGuqixoM+qhe5TtfFw
96nYzH6XPt2Pamrn7kfBPphTwLqDdXKd/1fVecfl+P1/3MpIRiEzKYlEyUgp
99sIoUhEiHyMaC9JpCTSQlqaNFVGtERynyIRKTN7pGgrDS3ld537nOt8H79/
70ePq/u+rnPe4/l6nfcFfaOWjpUee5xdh//c0Ga2NPc542MZlF/dCRHxK3ad
+G6Z2Kk2UbC3zSluXrke1HiEiH26cRDGvspWfGMQBecenrpmH7sPFgZMiCoY
dA7k6efv8kWfo7onjw415f+DBHqd+02i66ATFl1TDer+wYVHlouSSo8J+kNe
h76uioC/vvTsFdNL7KPgsJ5pRsRqFfb9+c9tbLakcZ+z73/LdOQw23GNYLjO
1UY39BL7nmH0+jMWia4v5P9vNv37patFf8++T1rFZVs8l3XUxBw9+8+ujOM5
baxXjNLOggeLL1hKaR5nv9f293wFPNc0rdv57FbvEOZbK1YoVJpemgmRVV/f
PCgOhBt+qY6fxseBxEdLbTwXVFfyl5FhXizzraVrBlZ3Dc2EwYZ7B51VjQYD
x815j7h18K29/yo8V7PbS7Bwq2My861tzPi4SetPOhyV+9U44kw8HJ7t7vV+
bwZcGtK0Fc+ldH7h2YPnUvK+tdOatZ67AtOgxtJ003O1ZFgl92pWacBtCLx0
ZgOe67hvRdjQBN105ltbcBb8dYtvgHi+eECVwzUYP2b6q4Lce3BJ44UEnotY
dvqyGZ6LyPvW3IyU5d80XYXdjiMe7Je9CQdP3tPecTAfvARD5PBcwZX2s3/h
uYLMz6YBWmvikqDU2Mas+X4a7HCrGmEsztVZN5wX4Ll8L8KQN57Lx/vWQnq0
d+xrjoMLJ8b5b5TJgJWHJSsMYwphsMLqFm/9BLgVdRjwXDvet+Yz5pZMbXUk
hP3cZNkxIxNUHLRu6asXwd5Ns1K7XkZAq+Trk3guHO9bmxyaEit15DzI97w7
E1ieCWOt9vnoFj8F1zvPy59o+IC53Zx4PFeN960558zd3C5xlKv7O/2VdLKg
j9k5k+W7S8DaNKfvlO8myFxfuxbPJeN9a9+VV+Y8XmyHpGs/6U9fnwWtNz6N
lXV9DimOyR801QLQxmJrAzzXi/etjbq7dcaLuDNott0q3539sqDmmr3HpEcv
YMnVlDY8F2uSSo4JnovF+9YEwzeaG20OR2kfx/sNNc2EzykD68ZLvYK0i5cc
8FwpySdn9PBcKd635vzk9yiHO7FIT81dsnR/Bry8HLlp7I7X8Mn63Bs8l8na
u48vnsvE+9YO9w0dl+12GTl05HvGT0mHh/FzhKOT30CWRc8qPNfIzLE+Ec81
4n1rViFbVDdWcf38LFPf4rM34U7Mw+lSLWXQkKMwtqclAxmm75qB5wLxvrXh
6WkOMuWpKOXttfwT9tfhWvS28yME7+B2cYEZnquzW8cqCc/V4X1rv/Yq5H6Y
nYZMuqT2K+ilQExEY5eEz3u4uH2EIZ5LUzDxqymeS8P71hJTxfbsSUhHxVWo
6bwwAYIvnNwr/voDHPl7wxDPdTmwfs5aPNeF961FSwbVy5VkoEI1cfHx2ZfA
O3h8ySDZT/B4bmM7nosyf1DD1UGDYphvLSzv1Y+1lzPR7QVLvC1sQuDo+dSF
YhafIV1sZiueK+L4zU9zStd55lsrLZ7x00wpC42Yv9C5JuIU2J5dHtsv6wsU
JYwchudyZKwvjJAvt2K+Nfn2/hVY7zMOuTVwTra6MG2FlVifPt9gg49VGJ5r
8dLk4hGr2FPMt3bk6IFv+PoTk+99rY04hZQL1HPcEr/B4riv+nguxLis0gkD
JMOZby2yxOID/v5f4xQ1LG1CUOKyvrY9a8qhWSrBCM9VsO3wysRzFXjfmtDt
5kd8fy4uR+nc/UGy+U+nujaVw7wHelF4LkH34+hneC4B71ubPrhRD99/0FNc
EihMQOEQ+q4r5Dscz9sZhM/1p2ywmbBA7ibzrY1Nmh+Ln6+SsuAm93zRKOGu
My5aFWA3qjQRn4sf92C4Lz4Xz/vWrjf1zMPrx9POtr+n/XV0Rlt5Wce3Crid
7P4Qnyt3ax14GJ8r531rGW9eVBty67M6d0AStz7RoLttfw55VYJFjbciPpe9
qXR7Cz6XzfvWBPm7nt7i1n93cVYkt/6Rh2be1TblHxD0NvEIPtd8POVoET7X
zPvW7CTX5ttz+2tMzE4Fbn+hv9m+uw6++AHbT6ecWxkZh6Yn+oXjc8G8b00q
8OndTdz+/W/6hTBu/6KD6kZjWg79hM7f0+Rs9C+gaq1zdvhcLe9bq15mdb+U
iw+qg5UDufiAmjJln9hPqgLPZS/sEgefQOKFG+3wuVTet9bbNLfyIRd/bNcP
NODiDzowr9atKb8Kjjr5NWUkOUF0a7osPtfJ+9ZWOZbO7OLi290qUx8uvqGK
tMx5tvuruf1R8PVrfhDkpnROwecied9a12/vjaO4+FnYz+8kFz+RyRz36gaJ
GrC2DTLWqIwBlY/nZuJzhbxv7UeTXRGOz7u7Dptw8Rm9TV0dbZVeA0ZxKZn4
XN6OJeWL8bk83rfmeORyKo7/Fu/rnLn4jwxmjzas21ILC52rI/C5tviJRzTw
uTbetzbX6ocXzi9hEjr6XH5BT69+GWjRUwvP0yzW4XNh0Z+fduWMusV8a11x
ZWY4f72ftT6Ry19o+cyUu9VxdWD6tmD8qNBM+FoT5obPVfG+NY8Jbx7j/Khh
vFGPy48IJTva7detB7dL8kJ8LulguOwmfC6J961JG1+Pxvl3nbT3EC7/ooXT
BdN+NtRDab/2YHyuRzw9ZA4+18P71qZIXDfH+b1OUfkSl99ReuLgD3uDGqDT
1j0Kn4sZ0jtgMj4Xw/vWrCQmdeD6QdM8xuSMajRSVnh1Ftd5Exs/BOBzJRdC
5Pw0gqKYb03H7vE8XJ/cdYhW4OoTdDkumgtLv0BpRp0WPpdR7Dz/l3+JP/Ot
aXxerIzrn8X+RX0lNY8jWbkDHd88G2GCPjnXoPl1Xsrj/ULmW4u8YNjngmEW
pEsJl39O3gfP1oeX3RjdBPPo9Q87ia7PfGslw7co3RuZBc1bA2LU2n1hyLne
Obb7m2Am/f7XgkXfn/nW3H+I/ZQ5nAm6eSdN/cXDYFXJHj+VnCaQtiP3x61H
dH+Yby181fzvs/0y4Ljx9aXaE2PBc1jRjwaJ39BA739Mmuj+M99ad7X2uHv6
6RB40DHlbm0i5OupLLlu+huu0Oe7kDxf5ltbcfL5pKqCm3B+vHF6i+kV6PEL
irBK/w2+dP2kk/XDfGtBo7KV/jZch/VJx7xOH0gFracdrcpizdw6IOvTmqxP
5lt7rLzZuLwsBaw1ptbUd94EZ/Gd6+u2NEMMXf+eZP0z39rzHXJNm40SIVxO
JSLZJR0yVz9IuXKlGT7T/SUg+4v51rZUgnf90RjI8dOas+Z6Bvz2njHAoqcZ
yun+nUj2L/OtrZEvM114LxSkK0Ldvpzj6qvHZ3YqGbSA42YSH1JJfGC+tZat
vyPLVnvDzmGJC/JkssByUMvt6rgWWOVC4k8kiT/Mtyb9+lVxYIoRFMdtrLq8
KQuSVxqPSm5rgdlLSHwbQeIb863tnZK/Krz2BPoYam9zc14W/Dh1z3q/bisM
pfGzjcRP5lvre8zuqfbkYGQstyBw791MkH8o/1gxshVqvEh81iLxmfnWnO9N
tlp38CK68eZ3WXpDBuwa4C3/s6EVltD4H0ri///8bKFv+jgrJqD8tN6Ttc/S
IXp5g2vikjaYRPOLNckvzLd29kv7rkKUjHpvxQ+8visNPp4wfLs3qA0u0vwV
QvIX860FOrmXTW25hkx1bK5kbbkB4+5nqyn8bAMTmh9nk/zIfGs/r8yoitly
E10Z1n76j9VV2NxXxr9C4w840fx7l+Rf5lv7eGJ8687mNJSjUzcOJJMgeMmJ
n3F+f2AWze9jikT5nfnWnFzRzDnLM9DJSe2Knpvj4IV71ZLdX/5AI60fjpH6
gfnWTrrmTUvRyUQPtI+gozERMALpRcqptbP6ZAKpT5hvzXltxKbE5kyULN6s
vFwxAPR609q+ebaz+iea1D/Mt/bHVSBhvCYLpdn/GDT6shP4Lh5rEFPWzuor
mw2i+or51l7ITRmB/95/3KG5kped0GNX1yumSh2QSuu3QlK/Md/a+e3zduDv
80vg4bJMMQCJ5ZYPkHXtgDxaH1qQ+pD51vacaZiHf2/v8VdS3O9Fy7tXmn4p
6QBLWn8mk/qT+daOKa0U4Pv506T+9YnNcej4omt3ouU6wZvWt0Mniepb5lt7
sSNFwpR7Xn6jjxYLJJOQ0EVy9I6DnRBO62cfUj8z35rOaZMBsdx6aNY1Wcat
B9R9+5DNpEed8JDW5y6kPme+taYowXgFbr0NiX1kxa03pNnx8fHH8V1wgtb/
/qT+Z761pSe7r+D1bGO7uv7arjTkvHDp1EirLthN+4sA0l8w39qQj/UGeL9M
7etry+0XlHno8rFtqAvkaP+iSvoX5lvrn/FtzHpuPyrK3C3k9iNqzhr6brxU
N4hdIf2RGumPmG8t+aK462Juv6+Y6X6a2+9Itc1u7vu93bDWgfRfpqT/Yr61
0LI/NyO4eFLofsCciyfIen6Zf1h2N5jr/r/+jvnW9nmH25/m4lW8kkQ1F6/Q
FUetqi3ifyEgl/SPO0n/yHxru/epzX/DxcOhiyZpc/EQVafHLB274y+0GpH+
9BPpT5lv7Whe6k11Lt6mjUr35eItUmwWiyq78RfKaP97jvS/zLe2ZbH9fBzP
13x/vJSL52iPmuWfkH49kHOT9NcRpL9mvjWLdrtYnC+sNvy4yeULFGv33MDI
qAeqaP/el/TvzLdmNX3wSJyP/t64PKCh8yb6cmPB1dHJPVxfT/iAB+EDzLcW
srKtupvLdx+PLirk8h2a1Bgh9rqLuz7lD/90RPyB+dZOj7vbB+fTrboFnVw+
RdtU+uwK0u+FGso3zj4X8Q3mW9O4/LMPztdHnxxo5/I1umC9L8cwphcmdxB+
0nZKxE+Yby14XU8prgcSb9UGc/UAenPtyWipll7QonxmxkgRn2G+taTFmu9x
veFRXD7sjHgYkqpXtX2x4h+cofxnVaeI/zDf2kR7JXlczxy+6DBoXrsvMlAO
KQoI+we3KF9SkxbxJcbZbELKe0O5esklq6Tpe/I+xqOs6ectt0WfM65l7FLs
h9+zo+q5uge/Z4fnToPp/50WJ/q/kKuaFfHsYzgkaqberRBGQsKbi25DJF0Y
j7p9W6kGv79m50n18SOjdwt4HnWa/l6NEtHvBTf3fhNerkgCnZnh/sk5EWBk
ez9PwsmTcSoF076da34dEQR7iT3A74XhOdUBep9tskX3GQLmGWV8KeHqpKMN
Xht1w+FrwfGptpK+jF/pJDzywO9b2akJLfh9Kzy/6kefr+pT0fOFXdNTtr7u
ygLXBAuZD9YXQNNW3VRDLoBxrQCJTVr4PSbVWl4d+D0mPNdaTddVO1lXoDax
51+R4l04fSIo98vcEBh6Q327bnsg412ZE+rC8PtBNCYNWYbfD8LzrmF0Pe92
Fa1nOH56xitTpTyQ+aRgfD4mEGQT3zzUcA9hHOxdv7g7+L0bKb+aLPF7N3gO
9kGR7KP5N0X7CMw9DC9vQ/dBJm+a4ijPc6BUKH0tKvUC42MXlz5aiN9nkRVj
+Qq/z4LnY6//kP17gexf2HDU1QWfJ0m9/VVLfbkP1HXeeO/oGs64mewW2ZC+
a/YJnNpqR974dFTAczOkTeKGBYkboOl0Wc+g7hHsPV3buzryBBhJ7qxfXx7B
eJp5Re5yvykmAo2arc/x+xd4nqaHSLx6SOIVyNs+l13r8QQ+JVmAg74zPJOR
anJ4G8k4W8V3hzQbhzWCNbZfj+L3GvCcbcweEielSZyEoeZdzSvGPoMJec3i
yYN3w8vd5WJV26IYf/Odc/rR2tWThftUN6/F7wvg+duzQyQ+J5L4DK27FQqX
XC+FfhO8pXOSjNDKwjWZZ82jGJdz9Y1+ENxlIFwv9cccz+HnudzldyQvCEle
ABuVpOJouRfwyNtNszLfEd2afCl6dv8oxus66tzjEp6YCjf36gzA8+15Xhd5
ieSjhSQfwR5lbfVIq5cwd1lYpVblcXRXLOWwuVIk43jue3Vnfhu6X+j/7o4a
nhvPzp/SPChJ8iBsmfHiUlj2K/Bq0Dz/O/Y08m4MWvXgazjjewmpTZfwPHbV
/QNL8Tx2nu9Z0vw7mORf0JtmNiS03xuoy+jJWNd7BgV8EavxVg5j3C/h0NBs
POfcv0rVHc8557lfEM37G0jehyXy3Q5B+mXQEZNcf67xPBrn9lWARoUyHli6
W0YNzw+v02tWwvPDeR44N5rUG89iRPUGzJcN+BQQ9hZMCksWjQ0NRkd6Y3XE
YoMYJ7wIn2Sr7Z2FS/p/sMJzuXlOuIPWOVmkzoEZk6atPFvxDnQO/zF4WRWK
On8G+tt9DmD8UEIqaA+ed70qaNxUPO+a54eVtL7aQOormDg+54afygeY33nP
a97HMDQn47Hlo2Q/xhWdugKT8Rzpg1olVniONM8VfWhdl0bqOhghvX68j8tH
OB/58Z3agQi0bljHMKRwivHGpsGDS/B85px4qc9GJbsEPG+0pPVkPKknof+o
yhNeBZ+gRlWrn4V3JModNi5zcZAr45C9U3UN8Nzjt7MXF197byjgOWQwrWMT
SR0L7SNc6j1HfIGevxVPNRZGobwklHS+xIrxyYmJ9ovxPGHVooOSy3RVBDyf
5Ovn3LGi+hlqJYZv9tj2FVYRvQateLchJYLblzy37A6s2Yrn9BrIb7y1P3Wl
kOeWfN2u7CCq21HjyRemyPAb+FRqFODvo7jU0TuoxIrxTJlZhxfh+beX14xd
fUd3m5DnmXy/kEb6BWTeP2q0oOMbrAgZ0GLO3Z9lj2MuCoJcGeecvKB8EZ4r
e+7QrHE9ZnuFPOc8RfuU26RPQRUeZkW50eUgr2R8Hz8vr7d2btzzYvwz79H2
rXhe6/vZVcZBRpZCnn+60P7IifRHaEcfNTet5d/BzHKNOV4/bTGX33Drh3HR
rRPSpuA5qOk+Pi/wHFSei1bQviye9GXorVv33Jzq7+ArKzEbr+ed+7bd49Yz
46X9t3nUHVp0SDisw7IXzxfleWkz7QfPkH4Qbeh5WKVxtgIOB/WVxPsrS9rF
jttfjKOOOJxeq+rtKAw//lYFz+3kOWoW7UOB9KHoydGAqOx5lRD5IOEe3u+Z
EZL7uP3O+Gr0t0+H8DzM0SO/FuN5mDxfLaT9by3pf9Hyrm0b1N9XQtufofo4
/sy50jbYRzmMcdeJ64xiNh+zEGZWXruN50zy3HXWBdJ33yR9NxIenjYwy+0H
VGoMnIrjYdene7u4eMh4bFvfRVJ4fqPnxQ8z8PxGnsfKCUm/f4n0+2hhe2PO
PIWf8PlUtR2Oz0+tE325+Mw47TnklzPP1liou37xAzwXkee06ZQz6BPOgNKd
cmzTi35C+/Bvayq4fKFVNzWZyxeM307Q6hf8s3qZUNq20RzPG+T57VR5wjfe
EL6BlFtPKqjZVkF7sfW6W1z+Whw/K5vLX4zrtldaLu3JVBcUzLDbjOf48Vz3
5mPCVZ4RroIuY3lzdDWYLRr4K4XLp+V2o/ty+ZTx3v79lz89l71J0Ofpf9p4
Ph7PexcYE55jRngOmvx7/FmVnGqQjQ2e5cjl9+lTr1Rw+Z1x4FmL/MeuuPWf
IPrBinV47hzPgSPkCEeSJxwJhdtWLrtuWgPxs/fbr+HqjaUzzr7j6g3Gh529
LvV/9uiAQH/agCl4nhvPhxsrCL96TvgVkvqV2q4sVgtTHayScf2zQVgk5Oof
xo2jhA/b8Jy0F+FnTuI5aTw39qDc7AbhZuiMlcu1K1dqYYdlfz9cj20R8/Hl
6jHGk9WXu2zB88eyi38l4PljPE+2pbzuHOF1aGDd8v+UDOpggnX9KVwfuoTM
vMjVh4wz9wwZ8BjP9Wq/Pe8GnuvFc+aNlBOeI5wQeZgPl05uqwNH7fZKXK9G
3pJU4epVxp9HN2y6gOdlqTd0h+N5WTx/lqd8sobwSdRV9e6JYmQ9nJ9RALh+
LjixYTZXPzMu3fkh3BDPoXJSXzYLz6HiuXQl5aJfCRdFTmbx7olLGmC63o04
XM/HDn+ZbSPpy3j12avXJM7cPCpYcSLjQZKymZDn1Z6Ux1YTHosaKq3nK/xs
gFO/DWJxf/HDonYd118wjv1cG0nhuUlecVGy5/7sEPIc24Fy4HbCgZH5Ho2a
OL9fEBEzsAj3Ox4jVwYOlnRhfFvnqY0nnkd0zWLwmofz1wl5vl1I+XPqdhF/
RuXl/S7KqTWCTLnLLOxn+P5e5olt7D7GvfPpnB/h8LrG8nL3uzz3jqDce984
EfdGJqKyqBG+9w6Jx/4H5wlDJGeV6zEevo5+H+0Dou8j4Hn4Ysrbj/mKeDtY
ND71HCFogtVThjltlo6CIJkeTYUue8bJv9H7ExAruj8CnpOvo5x/COH8kKyi
9qUkoAlmJ4/Uf7smEtRUcyWGDjrO+Pk1+rwyPETPS8Dzc3eqL+w7INIXoNI6
lEsXTTAxYZxZ/fAI8Mi92ttb4sW4+riPZP0MJOtHwHP1BVTXCCe6Bshf7w7U
V/8NpwrKhl/dHwZp7imG/zTOMN6+jK7nP/Wi9Szgebs61VOax4j0FNhZv6tB
wuc3jNyx/8737aGwNUljvkHIecbhlcTJ/ioi+0vAc3gh1XFat4h0HIhSLlxV
/PE3OEu+bujTGgTBpa2aGSuCGZ93oPv9FNnvAp7PG8QT/SiT6EfwzkI5zk+l
GVyzawJ/aZ6H+IpTyiFxoYzbiyMSf26S+CPgub0b1a3ciW4F0lcC/q7xaIbF
d/I1Suz9Ifpvr92iuDDG88VOk3g4i8RDAc/z31K9zJDoZWBY07ZZ/HUzSHl2
+Qd3nYL4AnR8v3YE4/yXaXz2JfFZwHP+wN9Ep9tIdDoImLE9rUixBXJ8Kg4l
bHCDqjk3H5+wiGT8f9EAki+an4jyhYDn/2XNRB/MIfogFO/PG+rj0gLNUXfO
a6vZgXbCy883pkcxXaC5muSvfJK/BLwuIHuI6JK3iS4JQ5KmmekWt8BGcwOZ
yd+1wXSk2okKuyimFyRpkHw6keRTAa8XHG0geqgD0UNh5U/fvEGyreApM/rx
cw1z5J1+RaVJJ4rpCKFCkt+NSH4X8DqCx1Kiwy4kOix4Tmua8Mi+Fb5E9rPo
8+oIanz2t943IZLpC6603ggn9YaA1xf2nSf6ry3RfyF/r5GTV0Er7DmElM7o
n0SeuuI2uoERTHd4oE/qnyek/hHwuoMa1Z2nEt0Z/sXnlK4Y2wZfPk7O6Pjs
i0ZV/HcgUCqc6REHaT2mSuoxAa9H9KN697BnIr0btCtkZ4pZtMGlhYqHP7kH
oODZzyxClC8wnaLFmdSHaaQ+FPA6hRfV2buJzg5H5E+dLMhtg7FLnX491AtC
V0wfW0//Ecz0i8atpF5VIPWqgNcv/Km+f5no+5D9X+0XzxF/wK3w7nXVJyFo
2vsE/yTdQKZr6NP6uYDUzwJe15CgvgJd4iuAtpj1mst3c38flT75XcMFdGRd
cFlq/lmmd9yh9XwrqecFvN4hR/0MW4ifAeZ+ywzql/UH9rje2tWYGo46clVL
dzh6Mx1kIu0vLpL+QsDrIDnUR5FLfBRgJzvhV/6gdq6vHBqqNTASJcm/DjfK
82D6CN/vJJF+R8DrIxHUv1FL/BuQutNd12NbO9T/vZ2k/isStR9etXGHtxPT
Tfj+axzpvwS8bsL7RgYT3wjURVfGLbneDhVxxgOn7YlCB3Prxzh9NmF6Ct8P
/nsi6geFvJ7C+1Um1/7tVc1WFyh9Xt3z7187DJo5Rxxfp/L3tXX2n02YztJF
+1MVFVF/KuR1lmfUJ+NMfDLIbNKNLciwA0Yi1Qz8u6RDtu8z8XZi+ks17Zdb
SL8s5PWXIOrP6aMu8ueghO2j090SO+DqveZkfJ8HaucocveZ6TJmtH/PJv27
kNdlgqkvaPJckS8IlUe4SAg6OiBxPzqCn3vav6f/cc+d6TWtkoQnnCc8Qcjm
DFA/0j/iR0KyH76Y9azphHg7B8Dr8P6GFDtuHTId5xjlG+aEbwh5Hec99UEF
Eh8U2jFeJz83uhOKoq++xvtCI37xTm5fMH0nkfKW0foi3iLk9Z23acR/VUH8
VyjCOGWia1Mn2N9unVDI7dOloak63D5luo8t5T+ZhP8Ied1nOvV9nSe+L/Tu
wvBDWsu7YOgAtxQcN7bLXFnFxQ2mBylQHrWR8CghrwdNpX4zf+I3Q2PeOj7v
CumCaxerZTq5OFa/qnAtF8eYTlS9h/Cxa4SPCXmdaAT1ue0lPje0Ufr9zJzq
LpjrWReB4+q2TktjLq4y/Si1lvA6a8LrhLx+tHkY8dc9IP46dN5IcMpFqxsq
fx8x6svFeeO3mV+4OM90pWE+hB+aEH4o5HWlUXeIr0+D+PpQSXD8V42z3RC1
Ny3lJZd3aqtapnN5h+lNB8YRnmlGeKaQ15sCpxM/4QTiJ0QSrwcv6vjWDXFD
+nQO5/JgyvjpnlweZDqUzE/CV4HwVSGvQ4kh4mP0IT5GtHqUTXD2vL9gOK0y
VovLy11+9j+5vMz0KYkfhPfKEt4r5PUpvQvEPylF/JPotOGrX4e8/sIsn61n
4rk6wfvg63dcncB0qz+UP+sR/izkdatcaeLbPEZ8m6jgvMZq9fd/wVdLWwbX
LaU/FcO4uoXpWbbLCA93JTxcyOtZs3uJX9Se+EVRvxfR8W3KPZDpWFb6jKuj
+l3QPcfVUUzngv6Ez+8ifF7I61wBmsSnepH4VNGSkf17M916YPq1rN24rpOb
v8CAq+uY/jVmItELvk4U6QVCXv8S30z8sdOIPxYdW3/A+OCLHmhQTr6P68wh
OQ57uTqT6WI1VL84RvQLIa+LZVNfrnOeyJeL7p59lj5PoRd87NuCcN07R6Fs
D1f3Mr0skOoplRoiPUXI62X51A+8lPiBUcezucNaDvVC7sg7jVe4Oly4NTKH
q8OZjraP6jsep0T6jpDX0U5SH/LdKSIfMlIfFrY/vagXyjaW6uO+wEo/2fpf
iRfT12qo3jTHU6Q3CXl97T31P/9nIPI/I0e9nnz7Sf9g/8N/WrhPSVrbdZzr
U5ju5kz1r6TjIv1LyOtuP6nv+tUPke8apfntnqRm+w/6tx+xxH3TgScCpWld
9kyPO0Z93V2LRL5u5ldfX/bwrP2kRogOmfOfdsD/fPKT+x759bW7ESxS3auS
BTFMp5Ohn4uliT5nOh1/nfvf9XZz12E+9to/5Pt8LBZ9H6bTadPfW6wn+r1M
d4uk99N5neh+Mh3tIH1eqdtEz4vpYup0PUSQ9cB0rkC63vaQ9cZ0q8KrZD1b
kvXMdKh6B7JftMh+YbpS3iKyHzvJfmQ6Udhpst8TyH5nuk/RVBJPhviL4gnT
cWY3/+vA8eoqiVdMlzHZT+LhNxIPmc4yo4XEWx0Sb5lu8oDGcwGJ50wHUb1E
8sVjki+YrrGM5qP5JB8xneIizXfjSb5jukMtzacjST5lOkIuzdcHSb5mukAW
rQcsST3AOH8mrTeeaInqDcbtR9N6JitYVM8wDj+Y1kulTaJ6iXF1vh4bd09U
jzFOztd7A1xE9R7j3gtoPRlD6knGsQ/QerWC1KuMS2+h9bAJqYcZZz5L621J
Um8zbqxC6/kQUs8zDlxA+wUX0i8wrqv2ifQjPd9F/QjjtK9pv2NN+h3GXZ9G
kX6qnPRTjKO+kyX92nHSrzEuKruN9IO7SD/IOGdRJOk3V5F+k3HLUm/Sz7aT
fpZxyNMnSL+cR/plxhVf3yb9+F3SjzNOuIT2+y9Iv8+4nx7lCULCExjH+25C
eEUw4RWMy5lRHjL+uIiHMM7WE094i/g9EW9h3GwS5TmJhOcwDiagvOjuZBEv
YlzrG+VRI+VFPIpxKgXKu868FfEuxp2SKE8LHiHiaYwjXaK8zpjwOsaFdCgP
XEB4IOM8dylvPE14I+M2UZRnWhOeyTjMRspLdQkvZVzlPuWxCwiPZZzkCuW9
cwjvZdxjrArhybMJT2YcQyeO8OpxhFczLrFWm/DwT4SHM86g+5jw9qWEtzNu
MJjy/JWE5zMOYE71gk9EL2B9fQDVI4Z/FukRrE9PpHqHLtE7WN/tSvWUZ0RP
YX30bqrXFBO9hvXFR6ke5ED0INbn7qB605hYkd7E+tbJVM+KIHoW60N1qF5m
QPQy1lfyetxwosexPpHX+2Y2D7gUsXoy6/u6qJ64NlmkJ7I+roLqlZOGi/RK
1pedonqoD9FDWZ8lR/XWg0RvZX2TEtVzJ1eJ9FzWBy2kenEs0YtZX/OE6tGL
iR7N+hQXqndnEL2b9R3d9URPTyZ6OusjLiwlev0rotezvsDhNPEDFBI/AKvz
l40mfoM1xG/A6vapD4if4QnxM7A63CaF+CVuE78Eq6vVvIkfQ434MVid7HKH
+D1uE78Hq3srqZ+k6qHIT8Lq2CPUr/IsQeRXYXXpF+qHSUkV+WFYnVlE/TZF
NiK/DasbX/F+ngciPw+rA52pX0jLRuQXYnXdI+pH0nkl8iOxOu3/ALYLrOg=

     "], {{
       {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNnWWYHFUTRkd6ZiBYCE6QJLhDgADB3S0EDxAsBA0SPEDw4BDc3S24uzvB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          "]]]}, {}, {}, {}}, {}},
     VertexNormals->CompressedData["
1:eJxsXXc4lt8bT0vaIpWGlrRIOxV3e2lpa1lFg4ZS2lEqRUIRMspIImQrbntl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      "]],
    Boxed->False,
    ImageSize->Tiny,
    PlotRange->{{-0.9994964293346906, 
     0.9999998888888808}, {-0.9998740170853136, 0.9998740170853138}, {0., 
     1.99999997979798}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355229611],

Cell[BoxData["\<\"helicoid.off\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->174366953]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OFF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 18.5281366}", "context" -> "", 
    "keywords" -> {
     "3D", "geometry", "modeling", "rendering", "CAD", "visualization"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "OFF 3D geometry format. Used for storing and exchanging 3D models. OFF \
is an acronym for Object File Format. Occasionally called COFF if color \
information is present. Related to NOFF and CNOFF. ASCII or binary format. \
Represents a single 2D or 3D object. Stores a collection of planar polygons \
with possibly shared vertices. Supports polygon and vertex colors.", 
    "synonyms" -> {}, "title" -> "OFF", "type" -> "Format", "uri" -> 
    "ref/format/OFF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[25842, 880, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 257252, 4879}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3394, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4017, 95, 123, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[4143, 101, 410, 11, 70, "FormatUsage",
 CellID->20778],
Cell[4556, 114, 357, 12, 70, "FormatNotes",
 CellID->2061495838],
Cell[4916, 128, 146, 5, 70, "FormatNotes",
 CellID->59388568],
Cell[5065, 135, 272, 8, 70, "FormatNotes",
 CellID->855453080]
}, Open  ]],
Cell[CellGroupData[{
Cell[5374, 148, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[5441, 151, 277, 9, 70, "FormatNotes",
 CellID->2520],
Cell[5721, 162, 333, 11, 70, "FormatNotes",
 CellID->12927],
Cell[6057, 175, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[6099, 178, 786, 26, 70, "FormatNotes",
 CellID->25134],
Cell[6888, 206, 517, 18, 70, "FormatNotes",
 CellID->125287718],
Cell[7408, 226, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[7450, 229, 352, 13, 70, "FormatNotes",
 CellID->22675],
Cell[7805, 244, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[8382, 266, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[8967, 289, 681, 25, 70, "FormatNotes",
 CellID->21001],
Cell[9651, 316, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[9692, 319, 530, 20, 70, "FormatNotes",
 CellID->9310],
Cell[10225, 341, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[11303, 383, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[11967, 407, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[12786, 437, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[12827, 440, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[13191, 456, 352, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[13580, 475, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[13634, 478, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[13829, 488, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[14499, 503, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[14541, 506, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[14612, 509, 2099, 54, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[16714, 565, 512, 16, 70, "FormatNotes",
 CellID->13037],
Cell[17229, 583, 304, 10, 70, "FormatNotes",
 CellID->4998],
Cell[17536, 595, 436, 16, 70, "FormatNotes",
 CellID->1495251562]
}, Open  ]],
Cell[CellGroupData[{
Cell[18009, 616, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[18061, 619, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[18260, 629, 1155, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[19418, 662, 240, 8, 70, "FormatNotes",
 CellID->1022956994],
Cell[19661, 672, 72, 1, 70, "FormatNotes",
 CellID->19539],
Cell[19736, 675, 937, 22, 70, "3ColumnTableMod",
 CellID->28047],
Cell[20676, 699, 359, 11, 70, "FormatNotes",
 CellID->1486431821],
Cell[21038, 712, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[21284, 721, 759, 26, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[22080, 752, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[22133, 755, 2676, 90, 70, "SeeAlso",
 CellID->1919681360]
}, Open  ]],
Cell[CellGroupData[{
Cell[24846, 850, 58, 1, 70, "MoreAboutSection",
 CellID->161113867],
Cell[24907, 853, 150, 2, 70, "MoreAbout"],
Cell[25060, 857, 151, 2, 70, "MoreAbout"],
Cell[25214, 861, 134, 2, 70, "MoreAbout"],
Cell[25351, 865, 133, 2, 70, "MoreAbout"],
Cell[25487, 869, 156, 2, 70, "MoreAbout"],
Cell[25646, 873, 159, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25842, 880, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[25958, 886, 58, 1, 70, "ExampleSection",
 CellID->7321461],
Cell[26019, 889, 83, 1, 70, "ExampleText",
 CellID->1179728456],
Cell[CellGroupData[{
Cell[26127, 894, 209, 5, 70, "Input",
 CellID->17199],
Cell[26339, 901, 28365, 471, 70, "Output",
 CellID->454024089]
}, Open  ]],
Cell[54719, 1375, 125, 3, 70, "ExampleDelimiter",
 CellID->596643543],
Cell[54847, 1380, 102, 2, 70, "ExampleText",
 CellID->124805946],
Cell[CellGroupData[{
Cell[54974, 1386, 134, 3, 70, "Input",
 CellID->1186879358],
Cell[55111, 1391, 729, 19, 70, "Output",
 CellID->192871460]
}, Open  ]],
Cell[55855, 1413, 70, 1, 70, "ExampleText",
 CellID->1669494950],
Cell[CellGroupData[{
Cell[55950, 1418, 178, 5, 70, "Input",
 CellID->902936223],
Cell[56131, 1425, 924, 21, 70, "Output",
 CellID->777001581]
}, Open  ]],
Cell[57070, 1449, 73, 1, 70, "ExampleText",
 CellID->826926336],
Cell[CellGroupData[{
Cell[57168, 1454, 177, 5, 70, "Input",
 CellID->1283617307],
Cell[57348, 1461, 948, 32, 70, "Output",
 CellID->135360987]
}, Open  ]],
Cell[58311, 1496, 79, 1, 70, "ExampleText",
 CellID->418271197],
Cell[CellGroupData[{
Cell[58415, 1501, 177, 5, 70, "Input",
 CellID->180292948],
Cell[58595, 1508, 569, 16, 70, "Output",
 CellID->84151119]
}, Open  ]],
Cell[59179, 1527, 126, 3, 70, "ExampleDelimiter",
 CellID->1084699606],
Cell[59308, 1532, 225, 8, 70, "ExampleText",
 CellID->557598659],
Cell[CellGroupData[{
Cell[59558, 1544, 816, 22, 70, "Input",
 CellID->836271362],
Cell[60377, 1568, 39615, 660, 70, "Output",
 CellID->2004520260]
}, Open  ]],
Cell[100007, 2231, 71, 1, 70, "ExampleText",
 CellID->593683873],
Cell[CellGroupData[{
Cell[100103, 2236, 146, 4, 70, "Input",
 CellID->526032743],
Cell[100252, 2242, 88, 2, 70, "Output",
 CellID->1850041962]
}, Open  ]],
Cell[100355, 2247, 125, 3, 70, "ExampleDelimiter",
 CellID->923885364],
Cell[100483, 2252, 88, 1, 70, "ExampleText",
 CellID->1434544938],
Cell[CellGroupData[{
Cell[100596, 2257, 824, 23, 70, "Input",
 CellID->643595914],
Cell[101423, 2282, 53658, 872, 70, "Output",
 CellID->248555684]
}, Open  ]],
Cell[CellGroupData[{
Cell[155118, 3159, 141, 4, 70, "Input",
 CellID->2116429832],
Cell[155262, 3165, 86, 2, 70, "Output",
 CellID->558679264]
}, Open  ]],
Cell[155363, 3170, 125, 3, 70, "ExampleDelimiter",
 CellID->674089440],
Cell[155491, 3175, 216, 8, 70, "ExampleText",
 CellID->1444980155],
Cell[CellGroupData[{
Cell[155732, 3187, 100027, 1651, 70, "Input",
 CellID->355229611],
Cell[255762, 4840, 90, 2, 70, "Output",
 CellID->174366953]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[255891, 4847, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

