(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1100159,      18625]
NotebookOptionsPosition[   1090904,      18336]
NotebookOutlinePosition[   1093076,      18386]
CellTagsIndexPosition[   1092987,      18381]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"FASTA\"" :> 
          Documentation`HelpLookup["paclet:ref/format/FASTA"], "\"MOL\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MOL"], "\"XYZ\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XYZ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"FASTA\\\"\"\>", 
       2->"\<\"\\\"MOL\\\"\"\>", 
       3->"\<\"\\\"XYZ\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Scientific & Medical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ScientificAndMedicalDataFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>",
        2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"Scientific & Medical Data Formats\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PDB ",
 StyleBox["(.pdb)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "Mime type: ",
 StyleBox["chemical/x-pdb", "InlineCode"],
 "\nProtein Data Bank PDB files.\n3D molecular model file.\nUsed in \
bioinformatics applications and on the web for storing and exchanging \
molecule models.\nPDB is an acronym for Protein Data Bank.\nPlain text \
format.\nStores structure information for large biological molecules such as \
proteins and nucleic acids.\nDoes not store chemical bond information.\n\
Developed in 1971 at Brookhaven National Laboratory.\nMaintained by the \
Research Collaboratory for Structural Bioinformatics (RCSB)."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " supports version 2.3 and previous versions of the PDB format, as well \
several common variants."
}], "FormatNotes",
 CellID->2043229110]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pdb\>\"", "]"}]], "InlineFormula"],
 " reads a PDB file and returns a stylized rendering of the protein. "
}], "FormatNotes",
 CellID->12927],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a variety of 3D rendering styles for macromolecules."
}], "FormatNotes",
 CellID->1783861157],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pdb\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object.  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pdb\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a PDB file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pdb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pdb\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<PDB\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PDB\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the PDB format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Graphics element:", "FormatNotes",
 CellID->525384128],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "PDB",
     " file rendered as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->263380570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for the ",
 "PDB",
 " format."
}], "FormatNotes",
 CellID->13037],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Residues\>\"", Cell[
    "residue sequences as an array of three-letter abbreviations", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Sequence\>\"", Cell[
    "residue sequences given as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ResidueAtoms\>\"", Cell[
    "list of residue atoms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ResidueChainLabels\>\"", Cell[
    "list of chain labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ResidueRoles\>\"", Cell[
    "functional roles of residue atoms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ResidueCoordinates\>\"", Cell[
    "3D coordinates of residue atoms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AdditionalAtoms\>\"", Cell[
    "atoms that are not constituents of a chain", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AdditionalCoordinates\>\"", Cell[
    "3D coordinates of additional atoms", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SecondaryStructure\>\"", Cell[
    "rules describing the large scale structure of a chain", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinates\>\"", Cell[
    "atomic coordinates, typically given in picometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexTypes\>\"", Cell["\<\
all atoms or groups constituting the molecule, typically given as a list of \
chemical element abbreviations\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->230773093],

Cell[TextData[{
 "When reading an incomplete chain which is missing one or more residues from \
PDB, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will represent it as a sequence of individual subchains. "
}], "FormatNotes",
 CellID->140652593],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses the standard IUB/IUPAC abbreviations for amino acid residues:"
}], "FormatNotes",
 CellID->335269932],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "A", Cell["alanine (Ala)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "C", Cell[
    "cysteine (Cys)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "D", Cell[
    "aspartic acid (Asp)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "E", Cell[
    "glutamic acid (Glu)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "F", Cell[
    "phenylalanine (Phe)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "G", Cell["glycine (Gly)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "H", Cell[
    "histidine (His)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "I", Cell[
    "isoleucine (Ile)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "K", Cell["lysine (Lys)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "L", Cell["leucine (Leu)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "M", Cell[
    "methionine (Met)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "N", Cell[
    "asparagine (Asn)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "P", Cell["proline (Pro)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Q", Cell[
    "glutamine (Gln)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "R", Cell[
    "arginine (Arg)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "S", Cell["serine (Ser)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "T", Cell[
    "threonine (Thr)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "V", Cell["valine (Val)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "W", Cell[
    "tryptophan (Trp)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Y", Cell[
    "tyrosine (Tyr)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "X", Cell[
    "unspecified or unknown amino acid (Unk)", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1838789754],

Cell["\<\
The following abbreviations are used to represent nucleic acids:\
\>", "FormatNotes",
 CellID->2092232678],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "A", Cell["adenosine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "C", Cell["cytidine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "G", Cell["guanosine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "I", Cell["inosine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "T", Cell["thymidine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "U", Cell["uridine", "TableText"]},
   {Cell["      ", "TableRowIcon"], "X", Cell[
    "unspecified or unknown nucleic acid", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1257383168],

Cell[TextData[{
 "When importing a PDB file that describes multiple 3D models of the same \
molecule, the following ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements can be used to read the geometries of all models:"
}], "FormatNotes",
 CellID->62078418],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ResidueCoordinatesList\>\"", Cell[
    "residue coordinates for each model", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AdditionalCoordinatesList\>\"", Cell[
    "3D coordinates of additional atoms for each model", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinatesList\>\"", 
    Cell["\<\
atomic coordinates for each model, typically given in picometers\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1021039085],

Cell["Meta-information elements:", "FormatNotes",
 CellID->1582745968],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Author\>\"", Cell[
    "author information as referenced in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "user comments stored in the file, given as a list of strings", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DepositionDate\>\"", Cell[
    "when the file was added to the database", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Organism\>\"", Cell[
    "organism in which this protein occurs", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Reference\>\"", Cell[
    "bibliographic reference, given as a list of rules", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Title\>\"", Cell[
    "document title", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->331548787]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell["General rendering options:", "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "specifies what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
function to apply to determine the coloring of secondary structure \
visualizations\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ViewPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewPoint"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "point in space from which the 3D model is to be viewed", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<ViewPoint\>\"", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically calculates the optimal viewing angle for the imported \
molecule model."
}], "FormatNotes",
 CellID->389608530],

Cell["Selecting a rendering style:", "FormatNotes",
 CellID->2097373960],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Rendering\>\"", "\"\<Structure\>\"", 
    Cell["specifies the visualization method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<Rendering\>\""], "InlineFormula"],
 " are:"
}], "FormatNotes",
 CellID->1728212143],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BallAndStick\>\"", Cell[
    "displays atoms and bonds as a ball-and-stick model", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Structure\>\"", Cell[
    "stylized rendering of the protein backbone ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Spacefilling\>\"", Cell[
    "atoms shown as overlapping spheres", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Wireframe\>\"", Cell[
    "bonds rendered as lines", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1345161726]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<FASTA\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/FASTA"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MOL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MOL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XYZ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XYZ"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->329426040],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->147723903],

Cell["\<\
Import a large PDB file from the RCSB Protein Data Bank website:\
\>", "ExampleText",
 CellID->331931580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<http://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&\
compression=NO&structureId=1tf6\>\"", ",", "\"\<PDB\>\"", ",", " ", 
   RowBox[{"Background", " ", "\[Rule]", " ", 
    RowBox[{"GrayLevel", "[", "0.15", "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", " ", "Large"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1759033801],

Cell[BoxData[
 Graphics3DBox[{{{
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1WGk8Ve3bVQqZUirVY0hoUMhQSWJFRELIg1IpispQVB7SYMpUcRzHmJzj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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {3, 4, 8, 7}, {4, 1, 5, 
           8}, {11, 12, 16, 15}, {5, 6, 10, 9}, {7, 8, 12, 11}, {6, 7, 11, 
           10}, {9, 10, 14, 13}, {10, 11, 15, 14}, {49, 50, 54, 53}, {12, 9, 
           13, 16}, {14, 15, 19, 18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {17,
            18, 22, 21}, {18, 19, 23, 22}, {19, 20, 24, 23}, {20, 17, 21, 
           24}, {21, 22, 26, 25}, {22, 23, 27, 26}, {23, 24, 28, 27}, {8, 5, 
           9, 12}, {13, 14, 18, 17}, {24, 21, 25, 28}, {26, 27, 31, 30}, {31, 
           32, 36, 35}, {28, 25, 29, 32}, {29, 30, 34, 33}, {37, 38, 42, 
           41}, {30, 31, 35, 34}, {36, 33, 37, 40}, {32, 29, 33, 36}, {34, 35,
            39, 38}, {35, 36, 40, 39}, {38, 39, 43, 42}, {39, 40, 44, 43}, {
           46, 47, 51, 50}, {41, 42, 46, 45}, {42, 43, 47, 46}, {27, 28, 32, 
           31}, {40, 37, 41, 44}, {43, 44, 48, 47}, {44, 41, 45, 48}, {47, 48,
            52, 51}, {48, 45, 49, 52}, {45, 46, 50, 49}, {25, 26, 30, 29}, {
           205, 206, 207, 208}, {50, 51, 55, 54}, {52, 49, 53, 56}, {53, 54, 
           58, 57}, {54, 55, 59, 58}, {55, 56, 60, 59}, {62, 63, 67, 66}, {56,
            53, 57, 60}, {58, 59, 63, 62}, {57, 58, 62, 61}, {60, 57, 61, 
           64}, {61, 62, 66, 65}, {51, 52, 56, 55}, {63, 64, 68, 67}, {65, 66,
            70, 69}, {66, 67, 71, 70}, {67, 68, 72, 71}, {68, 65, 69, 72}, {
           69, 70, 74, 73}, {70, 71, 75, 74}, {71, 72, 76, 75}, {72, 69, 73, 
           76}, {73, 74, 78, 77}, {74, 75, 79, 78}, {59, 60, 64, 63}, {75, 76,
            80, 79}, {76, 73, 77, 80}, {77, 78, 82, 81}, {82, 83, 87, 86}, {
           79, 80, 84, 83}, {80, 77, 81, 84}, {81, 82, 86, 85}, {83, 84, 88, 
           87}, {87, 88, 92, 91}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87,
            91, 90}, {88, 85, 89, 92}, {33, 34, 38, 37}, {89, 90, 94, 93}, {
           97, 98, 102, 101}, {92, 89, 93, 96}, {93, 94, 98, 97}, {78, 79, 83,
            82}, {91, 92, 96, 95}, {94, 95, 99, 98}, {95, 96, 100, 99}, {98, 
           99, 103, 102}, {99, 100, 104, 103}, {96, 93, 97, 100}, {90, 91, 95,
            94}, {100, 97, 101, 104}, {101, 102, 106, 105}, {102, 103, 107, 
           106}, {107, 108, 112, 111}, {104, 101, 105, 108}, {105, 106, 110, 
           109}, {113, 114, 118, 117}, {106, 107, 111, 110}, {112, 109, 113, 
           116}, {108, 105, 109, 112}, {110, 111, 115, 114}, {111, 112, 116, 
           115}, {114, 115, 119, 118}, {115, 116, 120, 119}, {122, 123, 127, 
           126}, {117, 118, 122, 121}, {118, 119, 123, 122}, {126, 127, 131, 
           130}, {116, 113, 117, 120}, {119, 120, 124, 123}, {120, 117, 121, 
           124}, {123, 124, 128, 127}, {124, 121, 125, 128}, {121, 122, 126, 
           125}, {109, 110, 114, 113}, {125, 126, 130, 129}, {127, 128, 132, 
           131}, {150, 151, 155, 154}, {132, 129, 133, 136}, {129, 130, 134, 
           133}, {130, 131, 135, 134}, {131, 132, 136, 135}, {133, 134, 138, 
           137}, {137, 138, 142, 141}, {134, 135, 139, 138}, {135, 136, 140, 
           139}, {136, 133, 137, 140}, {138, 139, 143, 142}, {151, 152, 156, 
           155}, {139, 140, 144, 143}, {147, 148, 152, 151}, {142, 143, 147, 
           146}, {143, 144, 148, 147}, {128, 125, 129, 132}, {141, 142, 146, 
           145}, {144, 141, 145, 148}, {145, 146, 150, 149}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {146, 147, 151, 150}, {140, 137, 141, 
           144}, {64, 61, 65, 68}, {152, 149, 153, 156}, {185, 186, 190, 
           189}, {155, 156, 160, 159}, {156, 153, 157, 160}, {163, 164, 168, 
           167}, {103, 104, 108, 107}, {154, 155, 159, 158}, {158, 159, 163, 
           162}, {157, 158, 162, 161}, {162, 163, 167, 166}, {159, 160, 164, 
           163}, {164, 161, 165, 168}, {166, 167, 171, 170}, {173, 174, 178, 
           177}, {168, 165, 169, 172}, {169, 170, 174, 173}, {165, 166, 170, 
           169}, {167, 168, 172, 171}, {170, 171, 175, 174}, {171, 172, 176, 
           175}, {174, 175, 179, 178}, {175, 176, 180, 179}, {172, 169, 173, 
           176}, {161, 162, 166, 165}, {160, 157, 161, 164}, {176, 173, 177, 
           180}, {177, 178, 182, 181}, {180, 177, 181, 184}, {181, 182, 186, 
           185}, {189, 190, 194, 193}, {183, 184, 188, 187}, {182, 183, 187, 
           186}, {184, 181, 185, 188}, {186, 187, 191, 190}, {187, 188, 192, 
           191}, {188, 185, 189, 192}, {190, 191, 195, 194}, {153, 154, 158, 
           157}, {191, 192, 196, 195}, {199, 200, 204, 203}, {194, 195, 199, 
           198}, {179, 180, 184, 183}, {178, 179, 183, 182}, {193, 194, 198, 
           197}, {192, 189, 193, 196}, {195, 196, 200, 199}, {200, 197, 201, 
           204}, {197, 198, 202, 201}, {196, 193, 197, 200}, {198, 199, 203, 
           202}, {209, 210, 211, 212}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Os31Akcx/HfwQ45WZlVil1Ums4W6qgZHcpXoo49KcakFjvZilmUS6U6
0XQnyaWOsjtJJcw2Sk4dlZnfTxiUS9OYC8ZgFcZWI4aIxG5/xLcH7yevR5/H
n8V74tmRRgRBqL5m/LVMTyrR7XE3cD025Q0aJFDGbm68Y/kasPzl+E53XnQ3
0A9ZzzYakUCL8yzPXI3njSK3cMaCbmC/KZi0mU/C+uU8znoOngt2TPZEv+iC
4RoidhWDhH0qKMxMwvPsQtvqNSldUDy7ao6BRcJR46Rb7tfwHN6lEBd+7oKB
xIWe9v4kxMgjw0sq8bx+eVNBRJcWzu3o6LcOJWHbZePaJ514TovYmS+9oIWy
+KAlR/eTYDUSPpA5i+exHhsn77G0MKzLyzjLJ6FaTq8kF79B82LzBQ9t33VC
tqxi/6/ZJPxenMTK8sHz6+oVzfS8ThDrL70W3Cah1yY30SkKz3nXVvhk+3fC
pmRPWfFDEoL4u0N+S8PzkKlUmyszGuiPeqILlZJQFpX2/oMQz4mdS7c6lGpg
Xrr+SrKahHf6GC+/Zjw/JRL1rOZqQGA39ThSR8JC3rSHlx7PyclEeYu5Bh70
V8VJJklwOrllfNqyD83t3l51HH7aAV3mbLbEnIIfF43spq/B88BXRbKr+zuA
d5u8f86OAprQ73BzMJ57l49pGxZ1AD+uN7/ShQKZImSz/1E8N01z2ZLS0g6j
pVrjp14UpI9a10b/iefpu4RW5LGv7pAzuziIgiXlWdPbSDx3bTnhcYbRDnMM
VstYeykQDu8buPQPnt9lQk2Lpg34brHSHw5TYL/032MHiH407/3LW3g7tQ1O
ik6Mh6dScPgjo4nuhOf6Mef3n9e1Qc8V3s34PAoklfT6UD88txtJyuzUq4HT
YZ/k/DcFw0RYwnQkntMGZ7N8BWoI4WT3cMQUEDquJiIdz58rD35wC1BDhXf7
s83NFJg8s9T/IcJzXwnjfumUCm7t7Vhb1E3BIDOFZMrwvM/XvUkkVMGdvhJ1
6TAFFa5+G8IMeL6rzs3PNUwFJqqtH1KIKjhiJ+EtpQ+gebpXnMN6MxWMfC4V
VNKrwLpEv72cieeES50B2pVg25vTHJpbBcdl5abubDzXcmVD5WIl3LBZxTse
8QyYPX61MzF4/r04h3p0XQmLgrmnvthXg4WRl0/veTy/EXBmrJGvBI/C8xWB
qdUgynOnxgvw/Ky580zibiX05RdFcyaqIXJj7gxDjOfP/zM54OKjhD0OTrQh
bg3owkfXZSjxXHJigExepoTRiyzqWH0N+Dv+ZJagx3PaMn5vGE0Jcwu9xx6t
rYXGT6L8BFMdmpeZbI7Z/lYB096lVufya2HeRg/nIkdEt2h4rmpUwMEMiwfG
FlI4WOB8eswTz7k3A74bEingS5UR70iyFJ7eeR8tDcHz2GiTuwuzFBB6fJcp
/40U6mzvBTTE4/mr8EOObXEK8HldzGCy60Bf/Gqi/yKe51ywmi0JUgAhD3Y9
La4DbeFHAasIz402PJGYMxUgE+YGVjvWw70tOoUZhedNtvMDiAUKYKx8aSjL
rgcB4SmfaMfzkdWFvnOmWiGYFZXs9qketq28/MLGgOdxCYOWRZpWMBuaOBvJ
awCHmF9SOXMH0fz6urWSVnEryC/ZCjPUDaAIlLdbLcfzb/2Pfev9/wPCtCb1

        "],
       VertexNormals->CompressedData["
1:eJy11/lXD+geB/DGMpSdTObKkq3sBhHKG0NmcI0ZDF2EMYwtY5kuxl5CxmjQ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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eFk8V/33PYU0oZIoGSqlkqmkIhaPylMSIQ0oUykqMxUqopSkjJk/0/mM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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {4, 1, 5, 8}, {6, 7, 11, 
           10}, {2, 3, 7, 6}, {13, 14, 18, 17}, {5, 6, 10, 9}, {12, 9, 13, 
           16}, {10, 11, 15, 14}, {11, 12, 16, 15}, {8, 5, 9, 12}, {7, 8, 12, 
           11}, {9, 10, 14, 13}, {14, 15, 19, 18}, {24, 21, 25, 28}, {55, 56, 
           60, 59}, {17, 18, 22, 21}, {19, 20, 24, 23}, {16, 13, 17, 20}, {15,
            16, 20, 19}, {20, 17, 21, 24}, {22, 23, 27, 26}, {25, 26, 30, 
           29}, {26, 27, 31, 30}, {23, 24, 28, 27}, {21, 22, 26, 25}, {18, 19,
            23, 22}, {27, 28, 32, 31}, {29, 30, 34, 33}, {32, 29, 33, 36}, {
           33, 34, 38, 37}, {35, 36, 40, 39}, {31, 32, 36, 35}, {30, 31, 35, 
           34}, {34, 35, 39, 38}, {41, 42, 46, 45}, {39, 40, 44, 43}, {40, 37,
            41, 44}, {37, 38, 42, 41}, {36, 33, 37, 40}, {28, 25, 29, 32}, {
           42, 43, 47, 46}, {52, 49, 53, 56}, {46, 47, 51, 50}, {47, 48, 52, 
           51}, {49, 50, 54, 53}, {45, 46, 50, 49}, {44, 41, 45, 48}, {48, 45,
            49, 52}, {43, 44, 48, 47}, {53, 54, 58, 57}, {54, 55, 59, 58}, {
           51, 52, 56, 55}, {50, 51, 55, 54}, {229, 230, 231, 232}, {56, 53, 
           57, 60}, {58, 59, 63, 62}, {60, 57, 61, 64}, {61, 62, 66, 65}, {63,
            64, 68, 67}, {59, 60, 64, 63}, {70, 71, 75, 74}, {62, 63, 67, 
           66}, {69, 70, 74, 73}, {67, 68, 72, 71}, {68, 65, 69, 72}, {65, 66,
            70, 69}, {64, 61, 65, 68}, {66, 67, 71, 70}, {71, 72, 76, 75}, {
           81, 82, 86, 85}, {57, 58, 62, 61}, {74, 75, 79, 78}, {76, 73, 77, 
           80}, {73, 74, 78, 77}, {72, 69, 73, 76}, {77, 78, 82, 81}, {79, 80,
            84, 83}, {82, 83, 87, 86}, {83, 84, 88, 87}, {80, 77, 81, 84}, {
           78, 79, 83, 82}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87, 91, 
           90}, {88, 85, 89, 92}, {89, 90, 94, 93}, {90, 91, 95, 94}, {91, 92,
            96, 95}, {92, 89, 93, 96}, {93, 94, 98, 97}, {94, 95, 99, 98}, {
           95, 96, 100, 99}, {96, 93, 97, 100}, {97, 98, 102, 101}, {98, 99, 
           103, 102}, {87, 88, 92, 91}, {99, 100, 104, 103}, {101, 102, 106, 
           105}, {103, 104, 108, 107}, {104, 101, 105, 108}, {106, 107, 111, 
           110}, {102, 103, 107, 106}, {105, 106, 110, 109}, {107, 108, 112, 
           111}, {100, 97, 101, 104}, {109, 110, 114, 113}, {38, 39, 43, 
           42}, {110, 111, 115, 114}, {108, 105, 109, 112}, {111, 112, 116, 
           115}, {112, 109, 113, 116}, {113, 114, 118, 117}, {114, 115, 119, 
           118}, {117, 118, 122, 121}, {118, 119, 123, 122}, {120, 117, 121, 
           124}, {116, 113, 117, 120}, {141, 142, 146, 145}, {119, 120, 124, 
           123}, {126, 127, 131, 130}, {124, 121, 125, 128}, {125, 126, 130, 
           129}, {122, 123, 127, 126}, {121, 122, 126, 125}, {123, 124, 128, 
           127}, {127, 128, 132, 131}, {137, 138, 142, 141}, {131, 132, 136, 
           135}, {132, 129, 133, 136}, {134, 135, 139, 138}, {130, 131, 135, 
           134}, {129, 130, 134, 133}, {133, 134, 138, 137}, {128, 125, 129, 
           132}, {138, 139, 143, 142}, {139, 140, 144, 143}, {136, 133, 137, 
           140}, {135, 136, 140, 139}, {140, 137, 141, 144}, {142, 143, 147, 
           146}, {168, 165, 169, 172}, {144, 141, 145, 148}, {145, 146, 150, 
           149}, {146, 147, 151, 150}, {147, 148, 152, 151}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {150, 151, 155, 154}, {151, 152, 156, 
           155}, {152, 149, 153, 156}, {153, 154, 158, 157}, {154, 155, 159, 
           158}, {143, 144, 148, 147}, {155, 156, 160, 159}, {157, 158, 162, 
           161}, {159, 160, 164, 163}, {160, 157, 161, 164}, {162, 163, 167, 
           166}, {158, 159, 163, 162}, {161, 162, 166, 165}, {163, 164, 168, 
           167}, {156, 153, 157, 160}, {165, 166, 170, 169}, {169, 170, 174, 
           173}, {166, 167, 171, 170}, {164, 161, 165, 168}, {167, 168, 172, 
           171}, {75, 76, 80, 79}, {170, 171, 175, 174}, {208, 205, 209, 
           212}, {174, 175, 179, 178}, {176, 173, 177, 180}, {183, 184, 188, 
           187}, {173, 174, 178, 177}, {184, 181, 185, 188}, {172, 169, 173, 
           176}, {177, 178, 182, 181}, {181, 182, 186, 185}, {178, 179, 183, 
           182}, {182, 183, 187, 186}, {175, 176, 180, 179}, {180, 177, 181, 
           184}, {185, 186, 190, 189}, {195, 196, 200, 199}, {187, 188, 192, 
           191}, {189, 190, 194, 193}, {188, 185, 189, 192}, {115, 116, 120, 
           119}, {194, 195, 199, 198}, {186, 187, 191, 190}, {191, 192, 196, 
           195}, {196, 193, 197, 200}, {193, 194, 198, 197}, {192, 189, 193, 
           196}, {190, 191, 195, 194}, {179, 180, 184, 183}, {197, 198, 202, 
           201}, {198, 199, 203, 202}, {202, 203, 207, 206}, {203, 204, 208, 
           207}, {205, 206, 210, 209}, {201, 202, 206, 205}, {200, 197, 201, 
           204}, {204, 201, 205, 208}, {211, 212, 216, 215}, {209, 210, 214, 
           213}, {210, 211, 215, 214}, {207, 208, 212, 211}, {206, 207, 211, 
           210}, {212, 209, 213, 216}, {214, 215, 219, 218}, {222, 223, 227, 
           226}, {217, 218, 222, 221}, {219, 220, 224, 223}, {199, 200, 204, 
           203}, {216, 213, 217, 220}, {215, 216, 220, 219}, {218, 219, 223, 
           222}, {220, 217, 221, 224}, {223, 224, 228, 227}, {171, 172, 176, 
           175}, {224, 221, 225, 228}, {213, 214, 218, 217}, {221, 222, 226, 
           225}, {233, 234, 235, 236}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Os71HkYBnA5jGmwKCGRpEhIykZMnpQoGaE1aZZCYZMSbZTk0DhurYgO
ZpyWtCKyFxe1GuSQiOv3mxlmjDm5UhinSiqbQ+uP+PbifvN5cz/X8/I2Corw
DpaXk5ObXI7CcprblL7fLcYgFuzLaVZciGxgmAdFyACVe9raHyUzMHj6Zd9j
1wtcKHl/SzMvFp1fpXZyfXMwKKHubK2o54KdfMbFF6nofOJGsvX4TQx08+Va
Ts1xIStElrvuNjo/s3KriJmKQZx/dS3Hrg8ks7fqyAXoPGHHltr2BAzSO/c/
a4jvg2x/e88jj9C5KJIaGnQFg4069Q9nmvuAoOtemVOHztl+YteYKAxC1TUe
lhL6QfI48HpXCzrn3nK/9PgsBvfpbkySez88Ocs69rIHnesLJhKowRhQxYGX
O2/2w964xMlZPjpf7B2ujzmBQbM0IPQbpx92hbouar1F55sFKq/VfDGo6yQ7
0rV4MFV6qTfkPTqnWehbtHst/838P1LrLzzIJ40zE76hc1PzlGcf3TDYbFcg
i2bw4MnhoJEMwjgyd9i7flOuMwawdX1NkpAHdInThw5NdG4Yc7XQEDCokfUe
aDbig8LujsTtBuhcVVRmc8cHAyE/Y09ZIB8oqiOZz9ei843KQ15pYRjsoWRz
yAV8+DC0wipZG50TK211IQmDBuuytVIxH2ZYGzQIq9G5zpqi4It3MQguUFza
oTcA7vn29DZ1dP75q7HfuSoMLC5fyM3+dQAI9GO2Dqro/A9RqP1CGwZdcawr
zcwB0NONCmojovODaY1FygIMmETqQiF/AFKr0wzTlNB5f4VF9cB7DJIV5rdn
6ArAm1JsoCSPzl26eUY58jiUpEzIb/YRQPRUbVXTkgyZLzRHByiq4XDfmmWc
lSWAWYeOuvR5dK4XVXbRVxeHB+7ML0psAXBuCxZU59A5Rdmve3wjDiPT7SGW
aoNAnBjj9cyi81Hfvz6f3IaDo9x8+kmPQSg8PP/R5SM69zd/mVu0G4dzDqu+
BWQOQiZNJZk9hc5Hh6JiDJxx4Cz+TtTqHgRemHb5vXF0PuBdvS3+CA4eVm9f
sUlCiKdvUtMdRefSvyPNDGg4LI0Wmji5CuFagaVi3zA6b7mmdT/1NA6p3fbc
hOtC4AfbRBUPoXOShouQE4GDif6wdVerELJ3ORqZitH5bynfA/1jcViY5Vm2
LwmhlLg/SCZA55YNrqzuFBzGyHxhF4hAa9jtbTAPnRN7dPyis3AgqRqbJsWJ
QNJEmTPgonNWYOf5SQYO8kqeL5SfimDFIQ/6CIbOB2uVqAce4rDqXIZa3pwI
UoReR870oHNV2etEUQ0OVL+fvgptxBAQ4Vll2oXOywY3JFKf41D7b9Fts2gx
MFW83Ys70LkexecToxOHd/tWXXOpF4M11SvIrBWdl5ZoVhhwcKB444prZsSw
vuQwaboJnefW+f1MF+PQgzMcp3dIIPzLwU/hjeg875GVoukYDom8mjVXIiSg
6e503vQpOo81fONyZwYHFUK5A7dCAhqetgEzdei81cv4xMgiDlUPKlfbTUjg
gt/2nJh/0DmZnKHTQGRD9HzO1KSJFDyKFXPEVeicm2mTFWjABg/z3t5DNCmk
R7Rvu1GAzhkrm2mV1mxwM/c9XX9TChyOuknKn+jcl3qVds+ZDa8UKfmsRim4
apICc+LReWNM5Dv942yoYJ6qa5qWQp7PIdMT59G59tm8MudwNhAJM7ss1YdA
+5Kt9Z6T6Fxr5/wHpSQ2TOq3KcxtGYIIRtjLAQ90vt+YnBlyhw1v1rEq3fYN
weBRs4YWR3Qe9q464Ew5G/KUwx+MH1/uHbs78dwKnf/offVH3/8/gLsq/A==

        "],
       VertexNormals->CompressedData["
1:eJy11+lXFtQWBnDFEDGLUBS0JMsBLQUDTSX1UQxxyhFFwxmnIMGupmYjzplp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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eHlczN/3f1JahKJoU6K0KLS8SbYnibIUaaEiWlQkskW2QohUKBrNTDPT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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {4, 1, 5, 8}, {6, 7, 11, 
           10}, {2, 3, 7, 6}, {13, 14, 18, 17}, {5, 6, 10, 9}, {12, 9, 13, 
           16}, {10, 11, 15, 14}, {11, 12, 16, 15}, {8, 5, 9, 12}, {7, 8, 12, 
           11}, {9, 10, 14, 13}, {14, 15, 19, 18}, {24, 21, 25, 28}, {55, 56, 
           60, 59}, {17, 18, 22, 21}, {19, 20, 24, 23}, {16, 13, 17, 20}, {15,
            16, 20, 19}, {20, 17, 21, 24}, {22, 23, 27, 26}, {25, 26, 30, 
           29}, {26, 27, 31, 30}, {23, 24, 28, 27}, {21, 22, 26, 25}, {18, 19,
            23, 22}, {27, 28, 32, 31}, {29, 30, 34, 33}, {32, 29, 33, 36}, {
           33, 34, 38, 37}, {35, 36, 40, 39}, {31, 32, 36, 35}, {30, 31, 35, 
           34}, {34, 35, 39, 38}, {41, 42, 46, 45}, {39, 40, 44, 43}, {40, 37,
            41, 44}, {37, 38, 42, 41}, {36, 33, 37, 40}, {28, 25, 29, 32}, {
           42, 43, 47, 46}, {52, 49, 53, 56}, {46, 47, 51, 50}, {47, 48, 52, 
           51}, {49, 50, 54, 53}, {45, 46, 50, 49}, {44, 41, 45, 48}, {48, 45,
            49, 52}, {43, 44, 48, 47}, {53, 54, 58, 57}, {54, 55, 59, 58}, {
           51, 52, 56, 55}, {50, 51, 55, 54}, {229, 230, 231, 232}, {56, 53, 
           57, 60}, {58, 59, 63, 62}, {60, 57, 61, 64}, {61, 62, 66, 65}, {63,
            64, 68, 67}, {59, 60, 64, 63}, {70, 71, 75, 74}, {62, 63, 67, 
           66}, {69, 70, 74, 73}, {67, 68, 72, 71}, {68, 65, 69, 72}, {65, 66,
            70, 69}, {64, 61, 65, 68}, {66, 67, 71, 70}, {71, 72, 76, 75}, {
           81, 82, 86, 85}, {57, 58, 62, 61}, {74, 75, 79, 78}, {76, 73, 77, 
           80}, {73, 74, 78, 77}, {72, 69, 73, 76}, {77, 78, 82, 81}, {79, 80,
            84, 83}, {82, 83, 87, 86}, {83, 84, 88, 87}, {80, 77, 81, 84}, {
           78, 79, 83, 82}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87, 91, 
           90}, {88, 85, 89, 92}, {89, 90, 94, 93}, {90, 91, 95, 94}, {91, 92,
            96, 95}, {92, 89, 93, 96}, {93, 94, 98, 97}, {94, 95, 99, 98}, {
           95, 96, 100, 99}, {96, 93, 97, 100}, {97, 98, 102, 101}, {98, 99, 
           103, 102}, {87, 88, 92, 91}, {99, 100, 104, 103}, {101, 102, 106, 
           105}, {103, 104, 108, 107}, {104, 101, 105, 108}, {106, 107, 111, 
           110}, {102, 103, 107, 106}, {105, 106, 110, 109}, {107, 108, 112, 
           111}, {100, 97, 101, 104}, {109, 110, 114, 113}, {38, 39, 43, 
           42}, {110, 111, 115, 114}, {108, 105, 109, 112}, {111, 112, 116, 
           115}, {112, 109, 113, 116}, {113, 114, 118, 117}, {114, 115, 119, 
           118}, {117, 118, 122, 121}, {118, 119, 123, 122}, {120, 117, 121, 
           124}, {116, 113, 117, 120}, {141, 142, 146, 145}, {119, 120, 124, 
           123}, {126, 127, 131, 130}, {124, 121, 125, 128}, {125, 126, 130, 
           129}, {122, 123, 127, 126}, {121, 122, 126, 125}, {123, 124, 128, 
           127}, {127, 128, 132, 131}, {137, 138, 142, 141}, {131, 132, 136, 
           135}, {132, 129, 133, 136}, {134, 135, 139, 138}, {130, 131, 135, 
           134}, {129, 130, 134, 133}, {133, 134, 138, 137}, {128, 125, 129, 
           132}, {138, 139, 143, 142}, {139, 140, 144, 143}, {136, 133, 137, 
           140}, {135, 136, 140, 139}, {140, 137, 141, 144}, {142, 143, 147, 
           146}, {168, 165, 169, 172}, {144, 141, 145, 148}, {145, 146, 150, 
           149}, {146, 147, 151, 150}, {147, 148, 152, 151}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {150, 151, 155, 154}, {151, 152, 156, 
           155}, {152, 149, 153, 156}, {153, 154, 158, 157}, {154, 155, 159, 
           158}, {143, 144, 148, 147}, {155, 156, 160, 159}, {157, 158, 162, 
           161}, {159, 160, 164, 163}, {160, 157, 161, 164}, {162, 163, 167, 
           166}, {158, 159, 163, 162}, {161, 162, 166, 165}, {163, 164, 168, 
           167}, {156, 153, 157, 160}, {165, 166, 170, 169}, {169, 170, 174, 
           173}, {166, 167, 171, 170}, {164, 161, 165, 168}, {167, 168, 172, 
           171}, {75, 76, 80, 79}, {170, 171, 175, 174}, {208, 205, 209, 
           212}, {174, 175, 179, 178}, {176, 173, 177, 180}, {183, 184, 188, 
           187}, {173, 174, 178, 177}, {184, 181, 185, 188}, {172, 169, 173, 
           176}, {177, 178, 182, 181}, {181, 182, 186, 185}, {178, 179, 183, 
           182}, {182, 183, 187, 186}, {175, 176, 180, 179}, {180, 177, 181, 
           184}, {185, 186, 190, 189}, {195, 196, 200, 199}, {187, 188, 192, 
           191}, {189, 190, 194, 193}, {188, 185, 189, 192}, {115, 116, 120, 
           119}, {194, 195, 199, 198}, {186, 187, 191, 190}, {191, 192, 196, 
           195}, {196, 193, 197, 200}, {193, 194, 198, 197}, {192, 189, 193, 
           196}, {190, 191, 195, 194}, {179, 180, 184, 183}, {197, 198, 202, 
           201}, {198, 199, 203, 202}, {202, 203, 207, 206}, {203, 204, 208, 
           207}, {205, 206, 210, 209}, {201, 202, 206, 205}, {200, 197, 201, 
           204}, {204, 201, 205, 208}, {211, 212, 216, 215}, {209, 210, 214, 
           213}, {210, 211, 215, 214}, {207, 208, 212, 211}, {206, 207, 211, 
           210}, {212, 209, 213, 216}, {214, 215, 219, 218}, {222, 223, 227, 
           226}, {217, 218, 222, 221}, {219, 220, 224, 223}, {199, 200, 204, 
           203}, {216, 213, 217, 220}, {215, 216, 220, 219}, {218, 219, 223, 
           222}, {220, 217, 221, 224}, {223, 224, 228, 227}, {171, 172, 176, 
           175}, {224, 221, 225, 228}, {213, 214, 218, 217}, {221, 222, 226, 
           225}, {233, 234, 235, 236}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Os31HkcB3DDZGUzSMORWdTKIE430oY+LjOpaXPNbQg7NlLZ2s2lmkjb
7YyhccpGNJvcEsV2sEUpZRpCjllzd7LL/H6/tKQtd5qsP+Lbg/eT15P353we
vtdwjoYc0NXR0Rlbit5SrHezE8fjpaCz6Es89NaAyJQSqLdAACpfeDGYS+JK
AZIX6FnBGmi0zeu8jKFzO225y85CKUw/lvPuJmhAfMimeWsPOjfavxtq70uh
M1PArUrVADu0oorbhM63m78X8bul4CDzdNlzQQMLCZLmzTfReQNPJhK+kQLJ
3GgxslADbfWmDP1L6Hx03Q23PpIMJttb4jdXa0C/mNGdfgydHztdbutqLYO4
aP5waosGjj7NeakXic63OdeeMdsugyhekB2nRwPEipPvdL3ReRv5aqDZPhmk
2E1MrX6tgcHZKMpNR3ReUPjoOuOYDOaqH77xfK+BOZuAqghTdO4QKtp3LUcG
pcXRyU46GBTirh735nFkvpj06lxChQxkaydqnptg4NvfPpWKoXM7dwsXTpsM
zhXcWyFaiwHl0wF6VA8619/g439WLYM9x5mf87dgENs+H6ZuQufuQ7UDkmkZ
5HromHQwMeh7UbaQIUTnNWPmmHClHKKL64duR2AQ+N9H8aUL6Py1LWd/jrMc
GImefvsOYhDc7CZwPYrOY4zHg6p3yaHKakyUfAqDtFZ+rzYcnRfbs5sIjhzW
7DgpZ/ExoMVLDX/0Rud2s/oF4WfkQGU5GvwmxIDw2viEoKPzybWNhE+JHIrG
Xs3x6jF45OdaOGCMzs+m+9TsbZKD26dALqsNA+qIU0rKHIbMY84bj+RI5MCa
mqSl/oVBfodri9UQOp9pab02MioHbnRGQLIGg1zmJnJSFzqXso40P1umgG2R
47B8EoOiUdlxu0Z0/g/9kTvFXgFpYWSPEl0cni+KW9nF6LxEcSMvxF8BmfrT
D6qNcFhTJ5imnkXn1rVQF39YAYMGkuhySxyCzUi6DQfQuWMgKUB8WQHp37zQ
S1yHQxuJ8nUfC53Tik38u+oV0GR3yDp2Iw5lwxvojzehc6XBkGFRvwICMmfj
/DxxCDs1T80xR+dc60U6eUoBeZ3uq2L9cThNVlvQtRpkfpvsKeqgKoFsn9/j
HYLDkEWYBQND5yWU7evDvlNCv1RSaxKLg8Xwibe+L9F5xtMLo9lsJbDSRVpq
Mg7Pfr/fa/IHOqcVXElPz1KCZXJpukEaDp4rr15sK0Dn1cbv2IalShAEuHA2
ZuPgfIIXDFx0/jg68clUmxK8dvYH2/JxiEyyWr2Dg86Lu0vHajAlMAScg9pr
OIQbhTdZ+6PzuGGH1M/LVPCxq+yDcRkOnZWVCb0u6Hyc9ovYykkFcxE9t4zr
cDCcEmJxK9G5noO6MH+vCrbOUMIVzTjwX21K+HlmGJmT1ILn5T+pgMbTzZSK
cMguUk8GD6Lzl/X6D7OvqIB95O+uJ304MFc7R61qR+cZzt36nxpUAL4p/MEB
HLIuX+mrvIPO756sk/ZKVRDttCpITOAwzS9gPshH5/f+DUk5PKsCSUKFR8lH
HLy8Ia8mDZ1f1WXGVVmq4Z0Av16pxWGO+PzmSAw6Z+yYtar1UgPHyMRGuJyA
i4wkqqkPOs9kdUV89YMajIWh1TFUAoLWH/Z2s0fnN7Rvx0i/qiHBZldFsC0B
AvL5LAcjdH5R2vW9uFINJhPrOrY4E3CzgCnQfhhC5mEhc8scO5Z6mxtj9rgT
8K0FreGWEp2/nxjhhY0u/U3ibBnkR8CJoJI79FZ0bpo4k6uiDMDEfKuKFkiA
odmfQpcydG55JvTtwoYByLLQMbJhE2DaiVfo8tD5l95Xv/T9/wOm6xho
        "],
       VertexNormals->CompressedData["
1:eJy11vlbDXj7B/BIduZBVIwkSiRLZNDyNvZlMJlnpMJYhjAaRowlQ/Yx6WsL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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1WGk4lG3YVkTZkrVI0SIltNkrpzaJbL2VLYqobKWSSnuSUJKdmTHPM2YR
SmaVoqiUdkqrkFB4JYns3/P9+n69P79fcxzncc113fe13ef56Pvvdw+cKCUl
JTNBSkqa+n2jMk1x7IEAUqu6mlICOOjoY8488CcX93WaJsSUCdBeFmA/SOfg
fEtw+TNdJmKLlY3NPgpwNF8urZbGQbLThfBmMJHFtrW42SJA8qKrJmH+/2cv
F1o/1D8qQNfg+dYXIxwY3250/HKQAcPJftZevwWYWldrcmUFF6V2cVYvyxmg
r8jq7p0qxOL9y6f+Y8LF+Q/kqcnTcnEiU+VmkrYQU9K/PUzt52DAbeiq1kMG
ejjZi423CXHZzrt+xx0uKqSbbB/Z09HxeWbixU1ClCyja0f95qJ+C3O1SQod
/p7WyiE7hdhzo+5tZzMXjQzGvMsjdOydK7mhEirEmrvJybXXuXjs/GX+/Ft0
RBq/OBRYKsTH6QqNXkt4SHD31ci5Q8MBV53XDhQu/61gcHUED/4qjoInfTRE
pKTc2VMuRKZ60c3jW3ngz+hgWEfSceTABr/zFL7XQTEtXZ2Hz96j4wqr6Jjy
+mywvJ4IC+a6heEjF/unNp0MeUcD+aw/apaxCDMX2avKavKwmZ//tkeJjl/j
k9+x5orAZ5Ebnknx8PuldU9QEh0eMqlPkjRFKKcVErIPudBYHJHZ7EGHPDFj
rm62CH8818lfduLCVH7OsxFLOk79y/NezxFhaVBp0KpLXBDPZ9g0hNOhHOn4
0z5HBGnvmTdjI7loENuO7fhJR7bhHdHsJBGqnbnu9ZZchPTZJ50spUNkPzvq
mqoY7vsvX0n4lwMf2djdX5Lp4Bo67xuk8B9tMYUFplz8eVGQ0lNFR1xEopTv
NDGuhz1IuKXJxVWfZqbmRgYyru5QHlARQ63/WVjyG6q+KWURMpoMuP6cKUok
xHhbSJolbubionBBYftWOtIWEauupojhn2HzOzGOiz7TpTVGiXTwfkiumueI
MaCXe7EuguorzfENicoMBNxYMWV5vhjB5rI1teZcONH+GG58T8eyM7zqEzoS
MIPDUkz/ckEbvD+1w50OHc5EAzMZCS4MNgy9n89DgY0ymXaJDp+y7OmrpkiQ
6eC2984UHmLlq5KqpzBwKA23Y/Qk4N9uklL7zEXU4yOjOnV0/HOjecrGYAly
Zz+xXs/jIfLIzp3mcgw023w2XbpJgoB2J/6cKh4eticvO6LHQOU91wWH1kmg
Nizv2H2VB7krM9N3nGXAbPm2CfG7JXBZfrFW5QgP4pmdVbp7GWhZXtHTcESC
FUsVnXmq+VizciRqlQYTt+YvCfHeKqHyP1vG3yAfR/o2CN3kmViee/FRBhXX
3VMp3vIbD+uwsqVbk4nAIk0n7VAJ6KzBulOveFCJ+8X+qM/EOE8YnOgmge+L
ebJqc/NhYjGIs8sILD8z2NO0VAL7ZiP7AYt8ao5PsGR0CCR1NhYHLpTA/FQb
/0EfD68e/Hg+qkjAW522aJqDBJtDGg82NfLw0zAo5Pg8AtE7DVztFCTol9m7
bPdbHhayJw89NyKRkBrxPKpbDPVcacuTPTwcuG1/d0CRRLXdpH1RXWJkFpFR
nWIebBcRzmVfCYiVbneCqstxNbmDtTQe/qr7JyRPIGGz9nd9BleMsKTfX3on
89Bv99YtuYxEW+3WBS8TxFDeM+PxhIU8vPwa9LqOTiI/+5iV8TUxNh91dG+Q
5eHxaFiZ9S4SY/JaP/4UiVHInL/vRRsXP30+2/w9RWKzhfPt835iGM765TVL
jwuPH2a3pZtILLh955qUnRi/Za93zrHiwlyidDzmEQnHe23bRJvFCPVNDtei
9t7RjIz5t2NIRKw6esoqVAwi8n2Dqg4X2Y8rAq0YJKYEVKuFO4txxMiBKFvK
QWb3Lnlz6pxJv05nzTURw6btDc+UwjUNtgpDzpCYoVeT7GYtxkGWfuuHrRwU
D8nO03AgkZI8TZHmJUbR97SGwG0cLKtSO9YYSMLIuYb/M10Mb15QpVkKG6sP
WVx+NE4guaA9WPqEGNstLhb7nGHD02T3yfG3BDRKZuVdOEfNlyQopVHMRhfj
taFxIYGb/0z4N4IuxvDCDWxJDRuvW/Is+yj7p/bfpE1/itH5aqMfTYWNsdot
HVmnCaj+/OXr+l6MXK7W6qD+PHQUKOUdcyVwMm/GtYktYmhkzurfbMBGeJyz
+zR9AuajChbNg2Lsuu+iFQM2zt1MzVxK2ZsnTaUF2EjgmvqcNv1oHkzEkh3F
fgTeXi0VDM2TwCKlN2fD1jzs0d5y5rwZgS85PyvqrCUoF8YnrPfLQ5+JjX/d
GBO22eu5K6k+fycKTNQ6l4eyp0xbqYUESnVjpmpS+JKltMH2YhbOY1a4VhOB
7rcLbV9ZSJA0MIeWkMrC30KCliYmwPppSb/kSvVz35nQx1EsDBdH6E26QiDc
IiXs5T4JMkyGnsyj7GPXdf+KFRHYuUbZK8NSgmJvHcvqxySOPbshjE4mMYl2
t2VUX4KQlkraygoSn/w9S3q9Sficv1y7y0qC3slx9l2pJOgNLfZjNiTEC79s
HHah7nu26esRqm9s7K0cL0aQSO9RuhXWKcaZdbcivaaScMg72XWjgcTVSJHs
/G/UPmxcefK6Pok+Jf/uvmwSiuuSKsKpPPv+Vl3i0E3A7+Lr+KTzJFQr2vaJ
pSQ47HHRcPATAYHuv3EOVD87+X+qOnlejPyojHJ1FtUHh2vU4q6Q+LHOzPhZ
nBgmiQVxyZUE6l9LrdV1JRGjIdxrRO3nVXbdzR7xBAb6rUbHrUi0L/Me/5wm
hmTxR63PwQReZUm/CD5Kop+xbbaGohhep6P2zLcgMEsjR0Z2Lon7I/ce+CqJ
EcLpWzngRuAXfVY+u5lAzc2O99f0xDhu6Rl2QZuAa4e8afAzAuNuZ5Y7zBZj
37TPGfxxJk7uuhhfo0SiQmCotJgrwlsfzq9ILhMrfE2FNhQuE71nvS5DhKly
vrMibjJRuqs62/MJgU5H3e/aQhFyeWPZ7SeYWPaIZTaXqjvnwpebC8tFCBzb
EN51mImiSgXXScMErsVlFP/cLkIVq026oyQXcgv/dZD2pfL2o/O67SYRgnuu
2yQU5KLzVzXZOZPEbb1XjkaBIjwNfGGywzMXOgV9J7Ink5C6F+326aAI82bI
D5TtzIXF1xnzSqi5Xvth1ExLS4SD9Cfv5jymI9Tj/cgGGglPi+rYSmURaj0v
1fPb6bie8kU+0JOEkpNT9hoTERaplrwqF9NhrqrBk19HYuDfcw4Z5iLUbO19
bZxJx9965eyuWKofTtv+rOoXwqG4cEHnPzTkDx12MTcjcWeEPjX4rxB6D0qm
3y+nwVhNvCtMloSm/f2vm3VEcLR9peBVQMMWF78zflIkgp74V3JniHDYqEY7
xo6Gl+a64YamJC78SD/m9FuIfoOUqjnHcqB4dEm860wCihUTbKcOCOH1MSq6
czgHd7u+H42eSOD+snLuCm0ROA8X6D3uyoEX96V0jTQB6x1bvkZQ/GeN6tq9
4/tykL9MSyNXl0D74W/Vv34KcVX5gf73ymx4vg2vN1/MxLBppeIOKu6vlrxL
0wxzMJg0U+pKfy5yWAdff9AQwaRPObpFPgdDl18QBZ25uPg9NTFcVYTns0zU
brMpP2/suQ8NmHiRFzpTUifEIpVJbLl7WYjXfDOq9i4Xy1dOt+ypFeKm4rKa
7w+ycPCkTswjh1wwK8249F6K30pbiJ1is2DupS7/al0ubIziEwKp83Bl5a+F
nM2C8+9n53VrcxEU853bkyyElfSJ8emqmbjyXnBbYTMTCvequirjhXCN1W3W
acnACiOpmA4FJoK8jEvduUKc7BaebU3KwJKrx6ZvVWbi/iz3w2duCBEUos78
Wp6B+FUmLkdcmNiYrPpseI2Q6pMtJ2wk6Xi/vH/P1jImxFmCj/oQ4gk9+ksf
PR0tBZeLNI8wsbr09roadyGy75x78McgHdN18z9sPsXEy+Lp5nlbhWAd9fJf
aZcOJfa01MQqJjjBFRMLBwTQXNEqE+qXjqefdI8/v86EbHDS5INyQry00zXj
e6fja2Xcr4QQJpiF/Mn6kyj+vLR1S9qLNBR9cmlwoXAUtUz0/iNA49yiuc61
aUjv+xaYTPkRz5XVGckXIPXSprMHdTMw5jqs+noCE8euHjjJqBRAdGhoIEIl
A81loRvlcqk6djVvShEK0HNCcUpBcjqEGlWHXU7k4uHpqO89NAFeXPO5VsBI
x8thJ/eOplzsdp+2f/M2AXacefSn0ygT60K8ltCZDET2LZo+J1iAY6kP+q4v
zMSqOprGFSMGCsduJhrtEOC3goq65fUMOOm1bW6UZyDHJ71lm4MA7wamaRwr
zMAWCWtv92kGlJc+UmB85OPD2FibnUwWyqrISHY1HZaJ148RzXysOxRwcqpq
FlyWDYeXUnqhULE1ZP97PqYqXP+ol5AJh+BLRncN6Th3S2os5DUfeenr1205
mQnh8JJl+SV0FMf78Ld58DFJbmda8J4sVMRtvqnTRIfEdW3bTVc+zF45j70/
kQXdP4rWou10zKk2VLniwIf+mz/hi39nIixfYWX0Rjq0J6xpWOHGxy95Odny
hkxMXeV0q+kVHbEevNE3vSWYkro40K44C2Qk69GiTAYc+fev9n4swedoJaWH
NVmYNGRR6r6cgZ1LTQJVX5dgcJP95NE1WRhRv6aqaEblp169tu97CQwCgnYe
M8xC1tXR2d+yGEj9enrx6kclsHaOfXFLPxsNKQ6LOFpMOO++9u59XgnWtl9b
ytmQjQU5/77InMLE3tHK5arZJej5WaauR81dlVT+B0ttJm5EF8dFlZWgfdvN
W0a5WTg2KGO2wZAJ66bZGzs/lMBx0ff95RXZ+Oyk/6pelsCks74n2aWU/5/m
WrP6sjFJ+WDzRDUCcYU5vjHFJVggk2vYGZ2NdKsK3onlBO4q7FhY86oEprau
ZxPssxF2NDzDdQEBqeShagV1PjI2zdhnfSkHxWUX9pypIfB3IPjjr8ESCM9t
dfz3Yw7eRU67MLuFelcHjhTupfAKvZWnupNy0L/eX1tlNrVvr8pmn1Pjg/g+
nmOzOgcvE+pHDlD79n2R7R2+Jx/vC88lpRynYfqUNx1TKiheQVNPbFvLR0ie
tsuBbzTUZIxgwyuKt+SRKgvc+ehYOWOvww8a3rgQ3B4Vaj+LnqNvDx/b15/l
hZ6mYc79o24CigfS9v0Tcp/g47e262NfDh3W2uuNsITA4Ea10bYEPmZwnVb3
qTCwuPzMNSUQmLc13iAll48F+NbZaMpA+UhywJ2jBKojn6aGCfmYIGiP3PSQ
jmce20a69xJgWFzse/ybjxtOQ9biRbmoMvaVWnGVic6W1hqnD5S9gpoV83Qu
ImWUvo2xmHivWZjW+I2PE//82TY7Ohf5uxZVP2xjIiF4c4X3OB8L0z97mBvk
YiA+umWoltrPN+PZx5cKIMNo4Cu4MdEb5CC1/iETky02rZivKsDopYr6T/uZ
yNOdorXzFRPdEQ1HepQFWLPJUeuFExMHwg2tDilRdenQ/b7eRAAH3319o8ZM
lIv3zvGg3qMHgQ7x13YKYKy6ZuHCXiY2aVjZpVP3jdrkPV/GToDxEcnkNyoU
b9DsqnI/S8AyS/PtQUsBCjYnpzc2UnzD8pSN/y0CFwQy1hM8BPjgry1ecZ+J
FPOnEjaPQOqpzbOMMgVwm/OrWTOWwIovp4WujhSvC5+sZnVCANXTleIGin/f
87aZxKB4xRtGQ09ppAB2x6S8nv0vzw7YFBaXQqL2xpyRgmQBzsw0jZnkSSC2
9YquDaUX2E7HnbkdAizPt3SaPELgUKvWOa3rJNSWri1xrqf2rU15QqExid3d
I0r3q0kkqxd6q1O4X1vuSv0pJCyeunEdZFiYu6RlIJTyw9+iPXriHYENlaE6
zDYSZZyo1io/IbZFuhj0UXw0QX/jTKKe6ls/j5ICFyH2+JLjf7kkdhqndA30
k4jU2x7u7yaEYmUh3ewCidKz1lUHV7DgsecIcXyXEMPvPR8scSHxLfJnr446
C2lr9MQTPguxWvPb9jVfSETFf/h1ToUF9ppzd3sfC+G/IPrp2DQWtnhd/ypt
wsL21fkpq6qEoPlsmbj+B6WLHg1cuhHEgv1q+8tO9UIcdbxzJU5I8el+gyxj
BxYGx3Z+b6d40c7uEPYw9f9Fgn2kC6UDimapVevOFsH9rF4oz5eFzffXKtU/
pPATPfd+TxOB4dHpVmzKwkRFncMFvyk/Pqu/3l0oQuFD8wRpKRYaxzBl/hcW
Qmp2DUliKHu7mdPCLrEwRWDw1ITSH2GKcWfzgkUwMN2r4yxiYTmHVRd1LQ/n
n9Yt8NtB4fc2+Y3HsnDX3mW4riIPZy8VMQ9FUX5qx/6Z5cVCytba3vibefAl
F9+6U03xuoDefS97WVCY8/RKuxEbydMlr9WLRCjSdC7fOTsPm0xXzZhgxUab
Vm7tVI4IelNNj/8YYeH3PCcN/Ug2+IRaifieCKt86uZ7vGJBoPUxXm4vG0dF
67a1U3y7lHpeTcV5UPE40/t4PxvlPxjEuKwYoxtiVZpa8xCgEy4XHs1GITfy
+nG5/9V3N648fJuHGFp08oZ7bAQd1vHz1xfj9d0DF9S5eVj64fIJQsDG/nCH
yZ6U3sz/bmPUf5yNgITtYzvOsmFdrnkklNLLaR6J1S+K2Sjz7H0guMJG1B6/
71bhYljsF3rmkGzcKg743FxHxdW6dtwgRgzH8d13K0MpPfv1sUbCIzbybgd2
0xrF+BR0L62ii42W096bvDLZ0F09xyWtXgxu19ddI8YcCIpV7j4tZMPyQH5d
7FMxquNk9u1R5+Blun1RawcbFV1dB6+8ofTvxK+0RVS8scBr1ofr2VBYvqDB
gNKbG4+uXzK5gA3bc+5KWrM4WBNaqC2ylUB0uSnwYSull3kBMR/XclAWEzfb
y0CCxXXHrtrXUviWsA7tCA5iHKW/1uhRuvXuF6/4DMqPsc+h7Y4cGBV5m885
R/mXfxYUMp6HaK/FWRNIDgrzXfx1rkhw534hn7OIjdxdTUapbziIKPkldydC
AgP74V2fddh4m9i2X2uEgx7h6KfKQAlKkrQ1iJ483LqwrCHmCQenPOUq+Lcl
0Jfya9pE9cmOo60zuwY5cGmdGzHhmQTHRgby+UvykPbFiK9mxoWgbGOAR7EE
y9WUc87o5GF2xZrpN7y5aDFdfEs+V4JPmpGvteTz0O4xcjZWj4t3cYUOx9ol
iN7Lv+Cgx8JhyxLlDyIOWgKruv4OS/Bq3Se7eG0WRlOGfBb3cBAWXn6wrEkC
e/WIgSfjlG5VX7v4sDoXu5K5L22o8/RaONhcmkTNVelQg94nDmYquGi+kC6F
9X667CJDEt45Xv7z/TjwT7VPODS9FLdMuifPmENiv4PVe6tMKs9PlPf7jFD6
3UD5exCll1P8rC81l3OwGppDIuqcp/fcbY3SIHH6lrfa8wscpC7QZF6YVoqc
MLrZ8HoCct91YsrWcfCxWFnDyKAUqsbdFh22BHTShwZfnuRgpPXtXzX5Umyf
r6xlaUzAtnD4elQeByKfhvPhfyRoCryr7kDxCaOxmWYBIRz8f3+f/6+4/3XO
/7rXf+XhfwBF88xm
       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNl3t8jnUYxl9maDO1cqwxS81xRQ4t59im2LQspBE5NJbzISsUsZgVc5xD
izBhiNYkhzRqTGHCIjksh1k5tBzS2XV/3u/z+Tx/fD/P7fpd133fz7PnfTch
A0Z2H1HW4/H8JcqJMsL+XV74igqioqgk/IUPvoqc+eL1E/eQ9eGsPFQg60fO
F6/1rCzuFQ+I+9H90ANcO/mS9Sd3H7lKZALQAshar0DRVrQTHcXTZMxXhZmB
eKuJqtSmV0erRv2QeJC6hghCq4rHzmqSrYKnOvfiz9zK6FXxBoHVtUQd+ljf
YFHbdU+B9K2JpzaZWtQPixCyQfQKJhPIzBp4Ta9Lpg49LPsIul3ri3riUREq
GooGnIWgmydMPCaeEE3pWZdsKFjdiB71yDVGa0TdRDxOL7s2o2dj5obhqc/s
Bq6zhuTCyJqvOT2aoDdFe0q08njfCXs3WoonRWv0psw1vQV1Mzwtqa1POFpz
Mi3QgnmmzrNsQa4Vs0N4RqHcRzgeO2tDz3BqZye7tmfn1px1QGtDti3av+I/
8b+wD047fJ083s9AB7z2WYgQUaKz6Cq64OmEFoXHvJHiGeqOnEVCFNlnyZkv
mp4xopvoLp7nLBJvNLMi0DvTx3LPkeuKLxYtmmwMWnvuKYJe3fDFMTMWr81+
gavpPUUPsPol0Zu6l4hHczLme5FsHJ6e7NKFuTHo5utDj3jq/qIfM6zvy6Iv
u8YyJ45sD3x9oDfe/mTj6eX0sOsA8Qq1nQ1E60duENowMVQMF6PImO9VMZja
fAloA8kOQRtEZjCa9RkhxojR6JZLZE4CPpv7GloimeF4EzhLBKtH4hlCz6Gu
HsPY3Tz22bfvEOe7YwT6WHZKEuPFG2IS9eviTbRR7GG7j+M6Bs94aus1AW0s
viS0kfQY5zobTTaJZ9+XZzaITBK7TKTnBGpnJ7u+JSZT29nbaBPJTkGbRGYy
2mR874ip1Oab5tLs+q5IRp8uZooZnE2jNk+qeE+kiTmuGVPJTadOpkcyuVki
BayeLd6nVwp1Gmep9J5NdgbaLOqZ5FLJmW+emEtt2flo6WKx+EAsEwvwLUSf
w9wFZNLoOdfltT6LyMzDl47m3GMKO80ntxiPzV0iMsQKMunsspSei6iXkFtI
7WTt7EN6LCW7HG0ZvhVoGegrxUdiu9ghdosvxXqRJT4Rm8hYdrVYRZ1BdjVX
67VGZFKb72M067VBbKbnKnJr8WTis7nr0NaSyXLNyERfS70OzxoyWa4e69l9
I/e2U3zFPW7As5GdtorP8dmzyBafiW3om9jb9E+pN+PJprZeW9C24LO+OZxt
QnPOsum9lZ/Fcp7LSjJb2eULV88c107buKcd1Dl4d3Ldzs9yl8f7O8J+V9jv
iV4uzy6eySVRLH4Vv/CMTP9a7BW5Yo/IE99wtgvd8dh1v9jH3N3oe2AvZ3l4
c+nlZOz6nfjW4/3umeLxfk/Y90q+OCAOiYPU5juMtp9e+a4edi3AcxDf9+KI
KBQ/iFPiR3FUHBMn0A+RO0rmML2OoRXQ8wjaEXzW9zi75LFnPmdH6V3Ibvn0
KCBTyC4nXT2Pu3ay60/sfIKzk2gnyZ4Rp5m9j+dwgDPLncVzitw5tLPUF8R5
UeLxvgfXxFVRJH72eN+Ti5zZu3IdzznmFtHDzq6I3/CcYcZ5+pzHd9njfe+K
qa+QdTzFzLzM3BI8F5h10XV2ib3MY++mvYP23uWSKeFebKebolTcEne4B9vz
hvgdrP5D3CZzlcxN1zM/zb1fd/W9QV/L2f+P/yR7jb6leG4y25lh17/JlOK9
7drxFr3+Ye4ZnlMR2TucWY8y+hu+rPAR5cRdFxPv+w==
           "]]]}, {}},
       VertexColors->CompressedData["
1:eJy12Pk31HsYB/CRRA0llNsyZadkKbdQTk8Z0U3i2iKFmcuoLtMiRSLVWDKD
ykELo9XpFhMxIlpIrjAcew1p5jvf8aluWibt6H7/iE8/Pee8fnnev7zPec5j
zN7jGzmFRqNNVaPR1KnJ/VGjqraXwex9+8w+uiNQjx9EOs1DgMsFy2ilJW4y
KE0nQq95IfDsEhzm5eNza6uECuY2GeRqs1qRP4LLLmT0DzY+f7eh8tAJrgwm
M2R1BSEIMtsKJ+Y44PMCr7aD3TwZiC2MxgZDEfgf0U9w1MbnAymC4xpFMnhu
VaAdxUag6jXP1SEGsXmj2oDRhUoZtLDoheJIBA37906puovPXUWtbQbtMjD/
WU333IWAUxOoO+sUPueoxpcvJGWQQjAedkYjWByRv2o5B5+v4tUsTfsug6Lx
Y/8Z7kUwPWDmbVPA58L1DPtePTksS2R8KYlF0DRq3N5qgM/LN9NbeEvkkGxf
nfDtIILKtpg1rqNSbM5557jgEcihw3rG+jWHEVTN0n+U0ozPxfd0EpVb5ZDD
z3v5KAlB+g+/V7GF+LzsWXTMbq4cDEwWaeoeQ5CzTBLhGIfPXYzjonvS5DCd
MaxxhYdgtwaRfGsTPt9Lq7doFcphYkfwH+YZCALdfCreGuFzHxtBrKlYDpV9
Xep/8xEcaPnsNPntGTZ/nKohCZfIYbDimPBLNoKdY05hjZ34XGmtVUsj5dDc
ZFvucQZBVmSlNPA6Pi+aqKzgjcvB1EX/8nAegtTkJ2PFSfj8K0cYmW9AQNK3
208jziE4PeFkWe6HzycZeqUzrAk4P+qdJipE0N0gE51ahs+LaHY/2UwClrib
GcBFBDIbsz7zKfictO8jGdsISOz79FvuFQTmL4p9+NKn2Lzna20qZy8BrTeO
s/tLECR8PkDeqcTngW88HHIzCOCT7oLwGwiuiJVzz53E52k2YbEmxQTMCtCy
EZUhmKzNFm5i43PP84sf5t0hQGOpmsi1AoEdp6ep3BGfVwsXteR3EvDVTRzb
XIWAG79PfVgHn7e/L2F/VxIgyueU69QgIDo9CgZHBrB5PPfpdNdJAvo3e0su
1CFY0ln7JKsen3c45zLfGCigwXkla/Q+gqv6EX/q5uHztkKBk5m1Av6J7ne2
bURgez/qQzAXn2+3tlu9jqkA9am3VOLHCE7patoHueHz85ohHfeDFWDUzTNR
e4LA+PrwIwsGPvfx97pgul8Be4otX2e0U73Q9fj9iaofmzurzX9286QCDrtY
OjApX08Lapndj8+9akN/3ruoAMPbNOlkG4Kzpebxr2vx+XN+XERTrQK2zR2q
rqLcagW9KvwCPlexBtIWdynAYmNS6h7K744c9ZMl4/NUX/pL7msFnN1plGlG
ecoB7aMTYfjcbcud5RvVSShiFb2RtiIIeRDQfGM9Pk/3EjkdnE/CUivZunzK
nZxt97HM8bl71KHksw4k7Hhu1uZJuZdg0XXxNHyeyeMfm+VJwrxwO49plEfO
FLrqv+7D5j9KDWN02SRE1ekbN1K9zvGSfqV14POX7+IKNBJJCNH4bh9PuSrS
do3gFj4PXrX4qPcZEgYWlqxwoHxr2Wy5US4+9yg4fy3rJgnfTfx3v2yh9kq0
9f0O4HOWenZVQBMJ5WpDP4WUX7rZFD4nEJ+rxban7B8kYbRsSfo2yn1r6Hpy
Z3zOmBjinxgjoWtjgpsu5auFu703LcDn9zKd/F/RlbC2Ivtj678IzCqD3tdP
9mLzwRWcEKa5Eny0Sp4epXzDpVCG5AU+Nxuhe1quVcInx4IFqyhP3GzMiWnA
5x8Lx7+EBSjBZOUWnw/NCCosYvUMr+FzF+4DhYCrhM9GmnUllBtLhzaFpuFz
baZEMDNNCb7SVEMW5afr+0ZEu/C5lqnfovlFSlgXPdy1kPK52/nCHC98nsK4
+XZetRL63jg1dlN3V3dvEKFjh8+TFmw5wpUoQbU6+GoW5TlHxCfz9PD5jgaP
4i0jSmgf56uYlP+1PyZu9VgPNv/V//lfnf9/x3CEkA==
        "],
       VertexNormals->CompressedData["
1:eJy11/lbDWgbB/AsERWTJXsZs5Qt2dd8m6wzg8kgVEIGg2xjeZV9TWiUiiiU
knoZQ7aM8m1Rk8rWfuq0nTqdTucUhuz0dr1zz3/wvs8vz3Xd1+d6fniu+76f
+/ncfe2PS5sbGBi0bGZg0KJpb6gsn1FoVUzX8I2Ou2eqmOD4XBOxoZrX2n8o
t7+h5YYlMR4921XCQJZ4iId4iId4/uOVRx6YtjcsoHHfxy7uV8toe/rM/jUz
tGx57GjKmy5aWrvdWlSfW4nFo04lOHcOo3iIh3iIh3iKx1ejBlm3HJXBrPSM
VQ1GhawcGO11Vq+na0enI9s2q1m/KWxA1XgNrql2Zy4amELxEA/xEA/xFI+H
Xslh35+/TdOle4zXJxfwp+sp2/odqmPEsopDUxP/YElfz5MHourgdqmF+0bL
AoqHeIiHeIineBy0O5N+ZXUsjTtYLvC4WMgtU4c6adfWce6GywdPlClx3iV2
7FydFslXPoZYvi+geIiHeIineIrH7w3rvlqkOcEKIz+HhaOLqP3Xkk2TbOpo
eDaoe05YCZQr5qcH/aHF7areZ9wrCige4iEe4ime4mHi+v3qWb8F49XANn8m
ziliRvjV+FtWdVzSabx747FInJgx9wcLqzpYnmpmkzWhiOIpHuIhnuIpHgP3
qyOujkpEp95dfFUjCzi3w3vTd033v/3r6pXRV4vZOdFudRerWkx50SKk0bmQ
4ike4iEe4ikeFaXT5ye5FGBtxeD2OZvTaDmmvsHaoY5nzuQ7b7BQkYdmDtkb
okHG1dPbrbwLKJ7iIR7iIZ7i0XnYy6OzRtRg7JlsW13ZA9h99zTpp8OV9FEs
avW7spw9czxCjsbUIH/xjA7P6/IpnuIpHuIhnuKxc+iIwJI5emQOW7yvf1wJ
gpbFJQ938uf1QOu8qb1KOEcd+Uv1Vh3G2m9aqLd8SPEUT/EQD/EUj9Qpjhvd
Y7XIPqP7lHKuBAd6hVgPb950bxEJ9m6XSxih3f10gq0eznFOc5JHxlE8xVM8
xUM8xeOpiderldcrYb902o4wZTYu3/F16+OuQXKN0uHXLyu4tefK2mZptTht
vXJkoE3CP57iKZ7iIZ7i6fqm7WyuKMaktq8LDs8NwqlYP5M9NXr0yN40dUGx
mjZ+dWetB6lh/mNayR3mQDzFUzzFQzzFc12UY+PG+/l49aTTq3i/+yzMutZm
4oimfC55HXYkRsfXlqqtnnY5MFozJTjqvgLiKR7iKR7iKZ7LOsW36nJXgc9f
RLcP7VXANqkeeQ91tbCun6ky3qznvGY4lfq4gAdmmw878fExxFM8xFM8xEM8
s/gs3uXzIkQvMeir31xAx/fdTX5JrIWVy/P365eqee1A+r7dmRouMDD460Xh
OIineIineIiHeJqN+vRZt36P4DO8vEfwvUwm7Tx43ta+HsahmUGrtqp5ydX3
YvgtDV/+5j1Za7oc4ike4ike4iGeniffftzZ0ht7vH13bEt7hMTw5llGjfW4
OeGzE/1m6ek7pb/b5ctK/jHtk6Jvy0SIp3iKp3iIh3gG6laU/r7lAGYPXuro
M0UFoxUO7aZNqG2qO+MSz8an9F02+fzhDeuQnOzp+82F/RBP8RRP8RBP8bxz
cuahk0P8WLXU47P3J8pRbbVqjpOLDhGWwW3frqnj818Kb3u8zcWuCGXj1rOZ
/3iIp3iKh3iKx9otxQvK9E+4spnKKq1vHgw3jgsoyNfD7fezdsO/VfHOjCs5
o6dXY0entrYT7xRTPMRTPMVDPMWjnWu77ZoZpbRvf+lAevQj9Hgx2TDXRIfQ
G6U1brcfc/Dqk8puZnoUTR+FMZkKiod4iqd4iKd4JATqv/AeU0SPtpuSNDOz
sXRTi5gPN3WINzs+7lx9PidGzutpPqsWc/aYTPCzV1I8xFM8xUM8xcPiUPCX
AXlP+M3p2asWjStGqOsPpxuO6ND/tfvOnD1VPGpa9deT2yokN18eappRRvEQ
T/EUD/EUj8bGrII+z5rq7MiQSX9dUKLNSK8t8bN18Hrz/bKRH7Vc7X+kYvmz
AqhLpxQaRCspHuIpnuIhnuJxVVG1xSa6hKuPBrjUvruO0B7enSeO06N30tOJ
ddu1LES/XL9fFNjsOLzg1y9KKB7iKZ7iIZ7iYZQzbYF3U3+dGhmtPxVdzKE1
VYMCa8oRpsl9M2yymh9bxY5OblOFovXep38wK6J4iId4iod4isehUptne6tr
uNu2OrR4l4pX/aca7/3pEX59ubdzf/MqIn583pt5GrTSHly7xe0JxUM8xFM8
xFM8Tm6/5RnkUMNPHStXJBoVsFe52vyPZRU49EPMLDtVJV8YDpucWVSFq75b
ggbmF1M8xEM8w//2aNvqv54D//YwCfm0uEdaJYdM8Sn+xjMb+fYRU4yWa2C3
uPHV69QqNpq7PboRnId9sTdzvR6rKR7iKZ7iIZ7ikd7mhMdDt2IeS7JXtcmr
wgerLsFbzapQYepVG1tWTS/NvOcVNn/i6r+z4xeeVlM8xFM8xUM8xeOD2f64
rWNz6ZwUq3BumpPd4ybG+nhXYn+cZ/svDhZzkcnPBZculmDaHO16//s1FA/x
FE/xEE/xiHeLGhU++gmnnxw69MQADc60MXhmNbMKXrbXnW5YFaBZz4TSK+/V
aJ+zOPh6vyqKh3iKp3iKp3isTv42ovHiAypHDdc5L6hG9nrzS7lRanx9bP+X
A3rVIKDV+5Gjh6lg6VCRtaFzHs/+7dFs9H89z//tKZ7iKR5L7PTX0wKTGNPK
89OZxCrYB5/XrmrQIMw9cEP9hyocVqpz37WuguqDn393g2KKh3iKp3iKp3iY
t/X53XFeFCY+fBH6y+JKcL76QqGHFsVj3oY4MRddDR26DcnSYK5meV7cDRXF
UzzFUzzFUzx2zH/S0kmfja4TfHOmn1Th7PZuD8Kb8juy4dkYu8n7udNgwYGX
G7VI3WPs+tK9kuIpnuIpHuIpHsaxPiUOIWqMTr39PmBrBeaZRF7T3CrDY4ud
XX+uf8KNjgF3w15r0ftCUd9BK8opnuIpnuIhnuKRarujQ/dJesQe2zdi8PMS
vIqY7PR03inaX+6o7fxSyWXv/HfpMpvm/21JxQPO5VA8xVM8xEM8xePLphF3
+s5aLCzclorreRjz4eKnbgFK5ni18Aw8W8I1VWNKjoXq4Huyvtrs432Kp3iK
h3iIp3iMz4jxH2NSgWFDp5f27xvO14WpnhPa67iof/rxCNdydj8YcNC2gxaR
X8R3OXQqn+IpHuIhHuIpHj+vuqI4NysF8f1DW8TerKB57es+LsNrqRqRY9ii
o4ap3yV8f7hvOfKcgnJ1zqUUT/EQD/EQT/EYGOekvzg7Cl8O/uyCjUE1j40f
7/NxsIYjPLXTAgNq6Wc2KGT2iELE/rZ7TknfIoqneIiHeIineHw6kvJ2rHkO
lD6KsbV/KOjnPzr+3jUd7+1Tx253qeG/xtwPSw5V4mHfltY6s1KKp3iIh3iI
p3i8zR9s1di9Gis73SqcffM8vNtsaGjdTcPHSxTmGwxUrHw+4siDjmqUPe9+
tOZdGcVTPMVDPMRTPKJtfwqp+k2LPqmGhSt+/hN95ix/nTFAxToze2g8Srjt
3hqvGC8tOtsssy7qp6B4iqd4iId4iofpj51cP7Wtxs5l34U0dL8Ch4blRWY9
NZyXYHdswcZirnnv6n44txbN2+Xcc9ibR/EUT/EQD/EUD//qrItXm/7hPXbt
7piSksjNzdxuFir11FvcspifqKD6guKUU6AOtZ1DLV4m5VA8xUM8xEM8xeNc
ayO/yT9nI6Y0Zvet8+l8nWbxWZRhPY83BO9Zm5lP97fGd4xW6OE0e9eWlVHZ
FE/xEA/xEE/xSJk/N3jRtTKEBT7PSB8Uz7MvBzeYBejYqYvD7izzJ8xNvZTv
ebwObe0Tf1jk/oTiKR7iIR7iKR7vV/eL3BmlQdbMdTOW1Wzj1xlLYgx/bXp/
tp5N3DI0k0ex9o7dt/U4v/347lW9HlE8xUM8xEM8xaPrriEdMUiLpxHR3axK
g5F5d0L9u9uVfBXtfnzy0sd8YOJyrG5nHSLXRXQ8GdLUl//2FE/xEA/xFI/I
hJKxLr5qTJ2bd+BH5W0qr7xa579GQ8dHfsXL+ih47s/EsWu+0+KuhzL8VNdS
iqd4iId4iKd49O7p9duRSeWIbP2xyCcghzeCFnhmJWm5aVVYuFFlOc/vSN09
oGvTfPiNddua6SqKp3iIh3iIp3hYGNzyXpekQKPzIo3nQgWPDjQfGbG8ltPf
HGh3162Uq00HR61IU2Os1+fzbUorKJ7iIR7iIZ7i4TzXNL3qhgJle1Qm/Rcr
qOqTO8B4ZS1/Xfd9Ue+kSAzr2sKyrn0dTt891nlyTBHFUzzEQzzFUzxezuzw
8sNcBZzftDL90ULBTEOPS8F+tZybVKFMuF8J6zUJrheMtNiZsP7A/P7XKJ7i
IR7iKZ7ikW6SZnLpYy7SL01qyBnalB95Nnn3c/TU9vh82zfZWrQvurbL2l+F
1z4WgV85xv/jKR7iIZ7iKZ5fKNWjvfZm4Ln1qmn3l0egPu7eWsepT+kfvtCh
Ik2Pb28d/DbmRiHcJ7VeN2tGBsRTPMVDPMVTPO0OBY362iEJev/tzfZl5aLT
5cxVQ17Wcaaq+aS9vvVYbTso9YQqA/Oa94n79DQD4ime4iGe4imeBV4rX21p
l4KuSt25DrGPsOni7ayQc/VsMFmRYjD4KTrbl29d2S8RBRZDSzcH/QnxFE/x
EE/xFP9/P39raOwNy4QibDm5JmZvGxVar1wwwP5B9f8s/thknJPOMZWn3BSj
rRLqUbO3MVm3LQv/q/h/AC+nNWE=
        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eFk4le/3vlIRKjMREqmklEpmt0qKSiUqUpkiFRIyFUnmYdtmIVGZ2e9u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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {4, 1, 5, 8}, {6, 7, 11, 
           10}, {2, 3, 7, 6}, {13, 14, 18, 17}, {5, 6, 10, 9}, {12, 9, 13, 
           16}, {10, 11, 15, 14}, {11, 12, 16, 15}, {8, 5, 9, 12}, {7, 8, 12, 
           11}, {9, 10, 14, 13}, {14, 15, 19, 18}, {24, 21, 25, 28}, {55, 56, 
           60, 59}, {17, 18, 22, 21}, {19, 20, 24, 23}, {16, 13, 17, 20}, {15,
            16, 20, 19}, {20, 17, 21, 24}, {22, 23, 27, 26}, {25, 26, 30, 
           29}, {26, 27, 31, 30}, {23, 24, 28, 27}, {21, 22, 26, 25}, {18, 19,
            23, 22}, {27, 28, 32, 31}, {29, 30, 34, 33}, {32, 29, 33, 36}, {
           33, 34, 38, 37}, {35, 36, 40, 39}, {31, 32, 36, 35}, {30, 31, 35, 
           34}, {34, 35, 39, 38}, {41, 42, 46, 45}, {39, 40, 44, 43}, {40, 37,
            41, 44}, {37, 38, 42, 41}, {36, 33, 37, 40}, {28, 25, 29, 32}, {
           42, 43, 47, 46}, {52, 49, 53, 56}, {46, 47, 51, 50}, {47, 48, 52, 
           51}, {49, 50, 54, 53}, {45, 46, 50, 49}, {44, 41, 45, 48}, {48, 45,
            49, 52}, {43, 44, 48, 47}, {53, 54, 58, 57}, {54, 55, 59, 58}, {
           51, 52, 56, 55}, {50, 51, 55, 54}, {229, 230, 231, 232}, {56, 53, 
           57, 60}, {58, 59, 63, 62}, {60, 57, 61, 64}, {61, 62, 66, 65}, {63,
            64, 68, 67}, {59, 60, 64, 63}, {70, 71, 75, 74}, {62, 63, 67, 
           66}, {69, 70, 74, 73}, {67, 68, 72, 71}, {68, 65, 69, 72}, {65, 66,
            70, 69}, {64, 61, 65, 68}, {66, 67, 71, 70}, {71, 72, 76, 75}, {
           81, 82, 86, 85}, {57, 58, 62, 61}, {74, 75, 79, 78}, {76, 73, 77, 
           80}, {73, 74, 78, 77}, {72, 69, 73, 76}, {77, 78, 82, 81}, {79, 80,
            84, 83}, {82, 83, 87, 86}, {83, 84, 88, 87}, {80, 77, 81, 84}, {
           78, 79, 83, 82}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87, 91, 
           90}, {88, 85, 89, 92}, {89, 90, 94, 93}, {90, 91, 95, 94}, {91, 92,
            96, 95}, {92, 89, 93, 96}, {93, 94, 98, 97}, {94, 95, 99, 98}, {
           95, 96, 100, 99}, {96, 93, 97, 100}, {97, 98, 102, 101}, {98, 99, 
           103, 102}, {87, 88, 92, 91}, {99, 100, 104, 103}, {101, 102, 106, 
           105}, {103, 104, 108, 107}, {104, 101, 105, 108}, {106, 107, 111, 
           110}, {102, 103, 107, 106}, {105, 106, 110, 109}, {107, 108, 112, 
           111}, {100, 97, 101, 104}, {109, 110, 114, 113}, {38, 39, 43, 
           42}, {110, 111, 115, 114}, {108, 105, 109, 112}, {111, 112, 116, 
           115}, {112, 109, 113, 116}, {113, 114, 118, 117}, {114, 115, 119, 
           118}, {117, 118, 122, 121}, {118, 119, 123, 122}, {120, 117, 121, 
           124}, {116, 113, 117, 120}, {141, 142, 146, 145}, {119, 120, 124, 
           123}, {126, 127, 131, 130}, {124, 121, 125, 128}, {125, 126, 130, 
           129}, {122, 123, 127, 126}, {121, 122, 126, 125}, {123, 124, 128, 
           127}, {127, 128, 132, 131}, {137, 138, 142, 141}, {131, 132, 136, 
           135}, {132, 129, 133, 136}, {134, 135, 139, 138}, {130, 131, 135, 
           134}, {129, 130, 134, 133}, {133, 134, 138, 137}, {128, 125, 129, 
           132}, {138, 139, 143, 142}, {139, 140, 144, 143}, {136, 133, 137, 
           140}, {135, 136, 140, 139}, {140, 137, 141, 144}, {142, 143, 147, 
           146}, {168, 165, 169, 172}, {144, 141, 145, 148}, {145, 146, 150, 
           149}, {146, 147, 151, 150}, {147, 148, 152, 151}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {150, 151, 155, 154}, {151, 152, 156, 
           155}, {152, 149, 153, 156}, {153, 154, 158, 157}, {154, 155, 159, 
           158}, {143, 144, 148, 147}, {155, 156, 160, 159}, {157, 158, 162, 
           161}, {159, 160, 164, 163}, {160, 157, 161, 164}, {162, 163, 167, 
           166}, {158, 159, 163, 162}, {161, 162, 166, 165}, {163, 164, 168, 
           167}, {156, 153, 157, 160}, {165, 166, 170, 169}, {169, 170, 174, 
           173}, {166, 167, 171, 170}, {164, 161, 165, 168}, {167, 168, 172, 
           171}, {75, 76, 80, 79}, {170, 171, 175, 174}, {208, 205, 209, 
           212}, {174, 175, 179, 178}, {176, 173, 177, 180}, {183, 184, 188, 
           187}, {173, 174, 178, 177}, {184, 181, 185, 188}, {172, 169, 173, 
           176}, {177, 178, 182, 181}, {181, 182, 186, 185}, {178, 179, 183, 
           182}, {182, 183, 187, 186}, {175, 176, 180, 179}, {180, 177, 181, 
           184}, {185, 186, 190, 189}, {195, 196, 200, 199}, {187, 188, 192, 
           191}, {189, 190, 194, 193}, {188, 185, 189, 192}, {115, 116, 120, 
           119}, {194, 195, 199, 198}, {186, 187, 191, 190}, {191, 192, 196, 
           195}, {196, 193, 197, 200}, {193, 194, 198, 197}, {192, 189, 193, 
           196}, {190, 191, 195, 194}, {179, 180, 184, 183}, {197, 198, 202, 
           201}, {198, 199, 203, 202}, {202, 203, 207, 206}, {203, 204, 208, 
           207}, {205, 206, 210, 209}, {201, 202, 206, 205}, {200, 197, 201, 
           204}, {204, 201, 205, 208}, {211, 212, 216, 215}, {209, 210, 214, 
           213}, {210, 211, 215, 214}, {207, 208, 212, 211}, {206, 207, 211, 
           210}, {212, 209, 213, 216}, {214, 215, 219, 218}, {222, 223, 227, 
           226}, {217, 218, 222, 221}, {219, 220, 224, 223}, {199, 200, 204, 
           203}, {216, 213, 217, 220}, {215, 216, 220, 219}, {218, 219, 223, 
           222}, {220, 217, 221, 224}, {223, 224, 228, 227}, {171, 172, 176, 
           175}, {224, 221, 225, 228}, {213, 214, 218, 217}, {221, 222, 226, 
           225}, {233, 234, 235, 236}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Ns/lHkcB3CDBksUZqVx3rCO61Ci8DVOLalUqGy1kRF2SzYZoelVK5Qa
g3rRVmSL0EGsnBblkFNqKNp9DVk0zzPzPM9QjmVKtj/i18Xn5n31ufhcfYzD
Y3ew5eXk5KRfovAlVYd2Gy+2S2AZhxE6tVEM7J7Be5tZ/YDKqYzW4gNCCezx
L/N64SSGVUPMgAVbdM6u2dHIn5LA1SNmmLe9GPzG+8P1mOicu1Xh2HolAs6W
19UyrMXgWR8fx1dG5y32r2Lj9AiwXvkpR85cDB6twj/D5vuQuY+x4DPHkYDW
ru/NThqLobHlQUDpODqPSpbYzP1IwFJeDLlLTwy07GOT0IfOn42Zv3U/QIBl
3eXI9m/F0BZSorylEZ1nbeGVd8QTIBE6+NLUxZB01/AIcQedG8qG5NedJYCv
7TW3RBPDHBYatucGOh/lv3eg5xGgrhkQ9nEWh5ENxYWCXHRulFkQWHqbAE2P
OdcBCQ4aqaFrmBnovI0hLpuvJSA8qTKAHMaBdaLyalEKOs8/vyi83U1AemKk
7qIAh7FzOvttj6JzKrxwwUJIgMPtv4Mn2nDo4Uki+RHoPNZU4526lIC/rqhs
E9bgYFzR1fBhFzrflWhkcmORAG5+TIpiOQ6cZH/atc3ovMm2iSWvTsKLzl90
1Qpw0HFdz9P2QOdBAnOXTkMSFhrYx1Zk42C6yjEy1xGdx7zUN9hnR0LpyJLr
dCoOKZIrqWJzdP6gZUwY7EmCVUdOWx/ny24HNCZZTHT+k8eml7KdJMjqnbnS
GBzov5r7/6OOztNMnOuPRpCwbYRbiu3HQetDmZSlgM7HJucT/BJIONHRlDW0
HQc94FSzJwTIvMGAZTKTRoLFf9fw+z443Eo4qjc9iM4XRqxV/PJIMFXMinvk
goMV/V70bDM6jzqHd9LKSJiXnqjvtcYhq1dpi0IJOg/Os4rPrCdhK31ZXK0R
DmeTnZsaeej8tyz3D5ynJCS/ycAKtHDYHZbeduY4Op/Tmald8ZqEmV5DXhsd
B8tC3YrmvQhdwZGdNEHCNB5S8kSGQdaT0+bFPujcTOhB+i6R0Nmeltw+gYHA
RNkp3xqdv9IS7hVpUGD8MuTxjTEMiqIi+tcx0Dn5WlvV1oiCrgkXl4ZBDOLp
ijv8Pj9H5j/k6GcL7Snw6mXE9nVhYDLUEhWNofPpskrF3Z4U+Axla7c3YhCe
H6y29jk6x+9oBToHUaB3n86prsCAe0HJV/UhOt+zknaOiKAgqZLpd+YmBjbR
WWoXr6NzOyX+ou9xCr5r8dp2MQ8D4fXQutQ0dO4slvoppVNQdClC8/J5DNgq
3rKMw+i82XLw9/w8CkryTX2SuBic3qfQvT4Ends4uRqpl1CQxlOMsjuMgbbo
ZPWgOzrXtDAgblZQUMuhVtWEYHCwfHvKPkt0HumVO36pjoK3y0c3NbMweONd
v8FHB50nM6+/8G2lIFUaP0OzwmB5ov0bvjw6pzE3zOx8SoFhoo5+FwODqFNu
Z1zfPkPmUd0xaY4DFAy53NRdkMOgY4oe7TeMznnr7FYMvKZgwUuQwyZF0P9p
1KWhE52bdWf0CHAKdD8qnw8aFIHq8FZaZjU6565OSL7wjoI/ZOOL3GYRTO18
VvWoEJ0/XP2+gCmjwN2uxFu7VATDTip3gzPR+X5P1ZllClIQa3JUrHNF8H7i
36ubE9F5p3m1W6WaFCbdJP6nUkTQ5FZ/vPggOi9a+66uliEFGePQN8GHRFAV
ZuP7cyA637j02PKUoRQindJ8IwNFEGRQJXdyIzqvSTTV0LWQwuwFXvC4iwhk
PrPyn8zQeZGu/hp1Bymk82+Nj64RgYDV81Gohc6/9r/6tfv/D5K4Nxg=
        "],
       VertexNormals->CompressedData["
1:eJy11/lXD9j/B/CQfS/L2BJGapSQGFtPYxjZUpFhhPkUWVOy75ohy0xji4hM
2piikjXbMxSlou0dpdL73bveLe93YWSpoW9nen3+g8/3nvP65Z7Huefce1/n
vl63n4uH49Kmenp62oZo1hDh2V9/MR//AjPP7FzeylaN7GVR/vV+JRid4+lq
tLmSNb9ZBpmtLIKeDPEUT/EUD/H8rx+cGFU8eVAutnVdNmiiTg2zmp7rfKLV
0FpEd7AuqGCtxeHMmfOUiE7dnblzdQjFUzzFUzzEUzw2fO7ysHm7AljMUVr2
36PB7cLy9HnGRagyDrDX3qlgVfHwuHd7lBhZaR87a8t5iqd4iqd4iKd4+Ax1
uW+0/AVejn2f9OMBHQYpp8z51iwCDu1+n9Ftp5YHOvudW7I3B2FlJ68+35r5
X0/xFE/xEE/xtIjytv3xQiS8Y4+1cvOogsmQZXOyN2Yx2Wj2jJ5epbzln9j3
kWU6vPtMuJ3iWALxFE/xEA/xFM9rZ1eueNTvITXDbp98llCJIVab4wY5FfJg
/y7lf9wu4duits4++9Lx9fYTU9b8UwLxEE/xEA/xFE/fXLtlOzplMmOiYV+r
/5Rid2xH103NSpjiVXi3cF4lTU882XZ3Xjy0bb2iFvUqgniIp3iIh3iK57VC
r9elx7JZ17Juuk/VK2TNnuCsiC/nl+5OBw8ZVLHTtIj6bS4x9HEK3uiwQwHx
EE/xEA/xEE+fDXdHvUjO4aYpyrUn2yngW3wu5YfPlRx9N8C9p7eOLqe+XRxj
H4izvy9sUXvtBcRDPMVDPMRTPD0rU7Y+K3rJFw6rqnzaJKOm9O3TK320tDtz
6MyqRWVsSDiTTUPysdE7xaCpZyHEQzzFQzzEUzyTrH2bFm/J55VBZ0f3bZmE
Tt1fv13fXMsLNYvzFgwvotd3XX8bb1wG14nd3CLT8iAe4ike4iGe4vm7SX14
zeFM+pr8/NyrfRbefbGJetBTx9Bn71xa1RWw6Ct3WvYqR3RgStqy+lyIh3iK
h3iIp3iqU2OyTWP8UDm4de6Y80rkVH02jYyqoM3NW9fUdmqm5sVv+CZXDYsm
mdemB+RBPMVTPMRDPMWzze4cu04fMqDvMG5UTFAZ1s7tfMTwJxV/67NJE60p
Y/nLsRaxLZU4vWqyacFsBcRTPMVDPMRTPN/meCtDOxchTqWeWrunAit7lJzR
C3pG48nHrxnP07DrvZ5jl5QqsX29yYarQ3MhnuIpHuIhnuIZnnakf0FwORIu
LTevOKPCrtQdTpfbPID5rHWvXANe0e69v8+aGUWwG792/V3fUoineIrn2UaP
/Y2e/4z71/O62Zv59+brsLndq6C27ploctPKwzQoAxNXtfIID87hTe8ks+ip
GSj/6367Dhe0EE/xFE/xEE/xPPRV0+FvjXU40+epx5a/snHApOL7XSfSMXW8
U6z/4uccMm9h0xtWClzJWx1RmVMJ8RRP8RQP8RTP9F9+Nnu4rhJPTqqH/jSx
CHWplp16/XkFOzac9d7fMo/bb+zzX3VEhReXlndf6VcK8RRP8RQP8RTPimYm
TdfFa3B8m8FU5QY1AiqNNwVHJfOkstyZhQW8OemG76kLpei47cbq6ndFEE/x
FA/xEE/x3DRN+945qBDHOkzu+SZQgxa+g99O9Crky4SeW6jK5eoLdivNHUpg
2lHhPay9GuIpnuIhHuIpniZRNaoA82hYHM8sCOlaAavtP6xo4aHipxrng3M3
XKf+OI39zAMqnH625kp+VTnEUzzFQzzEUzzLPf0DXg69xZQFS5sYnK1AnXZp
wuwNSh4oLRnl+OsT5IVFT5l/RwnzTRdjB6WWQzzEUzzEUzzFM64m5MGBAQ9x
bWCq2QOUo62d3zP3zsXsuPn5qUTTdBhWx6wPi1Qi/nZ4ZDP3cqQ2eoY3eho1
eoineIqniU+PLr4aNcZ1DlrzyFKJIvduV2INlVwbldr1m9THuNHk3FOD0SrM
cqw+uPbPhvNp9BRP8RBP8RRPW2tlbd9PWlw9bbPmXmgKjplWfbtgyXM6vC76
ybx7EopCPXsPNFPhUaj+iEXh5RBP8RQP8RRP8dxzvqD42jsdZs2xcbXfS7Tt
fXK7WVcFW5ud+m21QTqsu13sP/dzHsxH9apfqKyEeIqneIineIpn3dPIxV3j
dfgnztoorGMCvIza2bV0UnBR/OXbS6Kz4Dz6Z3OtRyIc5lb5WXzSQTzFUzzE
UzzFc4bNgKdG73UwW6/xL0u+jkcWRwy97in4wyHHW2O/ykHirQduec4XOftu
ve3r2oZ9NnruW/evZ1Kjh3iKh3gOiTHQM8zUYsKhFO8g7RMuvra9p/HcF1xy
LiLRZFUOxlhHP3g6M5HzrT6ez9upg3iKh3iIp3iIp+FY3y2V+0th6z53dQ+N
igMMyi+6WOfy8nzNNk20Aq+s+w/YevoJE+wdJuY76yCe4iEe4ike4hnu98TZ
ziAXnWb80dt8SiXn/73Yu9I0h69u1Q7oX56N5FCHPJf9qeyVmNCu1lUH8RQP
8RBP8RDPbV06nNids4Npe0dXRAyq5viDA8N0I9I4yXlY7MMjCnyny3r8JS2F
G09u2BVur4N4iId4iKd4iOdHpmcFrsnliFTXkN0/6Fhb3+y+1imW2/zanAxe
p0Do6zWntmSmsEvUuuoyJx3EQzzEQzzFQzyXqFS139mo2XvwuDqfpDLWDbcy
7G8wDaOHNJkQEJaMBcGGSbMyE/gpddqaLRVVWNHo0aPRo6nVv57iKR7ieXv8
9AEHf9XQ5M28apPzJYx1O/Fsjt4F6uqjbZZeesaZ59vfvlqfjO5nTkWk2VdB
PMRDPMRDPMXTffZha/00DeOUr692nFTC6prXduausXzWbsJ5f7NijoxuvT4v
shjFAQ4bJ7oXQTzEQzzEQzzFU6FyrFl2ScNFdV6uOzeXcKqejcMoXuC4J+qU
FgVq3n/Y6c8Ax1L02RtR+ot+FsRDPMRDPMRTPJdYDraZdayEhnHaaRanNYzw
jFtxpfhcQ5uaqJtiU8juZRfqepQVoFXy37dHlGsgHuIhnuIhnuI5UZnVYsND
FQPzcyJnVJSzrr7a+w/3o8ieO6I+Ij4eh509zrkFN+RTQJ5VYEg1xEM8xFPR
6Fm14F+PHY2eJ6ckXh0/q5hzrOe2MNzdUM9yogNefAhsuLfW+iV3XyCkT5hr
9vl03jEJGdDeXgvxEA/xFE/xEM/zIQN7X79SxuWL9JvFTVHTx6j4YL81fyE9
NaZS2/IG8lwHOS81C+Lu7M/BUXnVEA/xEE/xFA/xfPnggsPVm1pqX5/7z+at
L3l1fNB+ZXQcLxdvcte5ZbHQKT/7a9VL/HrWa0eOUSXEQzzEQzzEUzyX/hLv
YbpFxy4P9Z2zEhr6XQuvT0dsk/juRKHrp6DnvHWmwrCNZzGMsjR6td6lEA/x
EA/xEE/xbBZoG1kXqaN/z29vzRmWzcLWHsGL0pO5yy250/e6LEYejVrt4J6D
u59eVQ2dpIV4iId4iId4iufq+2cm3W14506MsO3n9EDBBM/HqVOLk3mx5pNZ
rMtjVmDHBM3D63wY8Lx9L6dqiId4iId4iId4jixPyxgTouXMP44XxfTL5amO
b6d/Y5zC0xlzHC/2i2epVXOHL8/TmNN7TLu2L6sgHuIhHuIhHuLZJN7hY4cP
Ffywebg26cMrLjxkuc73TjKXNH8zfrIqlfmeWLLbcx+rh64IGWReDfEQD/EQ
D/EQzxn6rw0U2eV01DNO2GSsYm2PUXWPRifS7uOuAaMynrO3oqnlV3YZcAk3
mJKxQgvxEA/xEA/xFM+/i2ak5GZXMHRwaO7EkUUMM91YtTommSeULU18m+Wy
deA/1bcXZMHv4MdZwRmVEA/xEA/xEE/xDf/XtM0/jqyi5fZuM2+sekZvP9/W
BwemctZuy+Q261MZV5lv3erqUd5pUdQ2ZFg1xEM8xEM8xEM8x48aUjzvVTWH
7DbYVPrkIvy7uBxYGXeZgYemRW1ZcJ2D1b8bF6GAVr2W64+YrYV4iKd4iId4
iGfTlZkzbXtVsfjRtuSSx1n4Z4/70V3J9/HZc3/aQsV1BtkONv+kKmbmjrU2
tmUN9arRQzzFUzzEQzzb3NRr1SNUxW0Xu4xQvFfjO6PNHd2eFKJuafdrJ/+M
Y/6YNsMDw9QccSqz171xZRAP8RRP8RAP8fQ8FNXH7u843j9kudPNtwx1bwoi
Hn2vRvO++TVj193g1b2Grut/VdPeeG53D5cyiId4iqd4iId4vtvaYvK46Tdo
+iVX+fhgGVZH6xSK2Wrk55j83OxSAoe03HfY3VvNYW6XB9vql0E8xFM8xUM8
xP+/r396UX7e8K9zeDx0RMktHxWzFd+kLw/S4H81H7bQJqNubTXNzn7J6HP0
HIb+ZG/azvEx/1fz/wfgVALf
        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1WGk8VuvXVpmVsXlASUSROREXIoriRMOplCEkRGZRGR8e09OkUSRDkqFT
z96PvTdthyZF6kidSqiUUkqmSsN/f3q/nY/vh/1l/a7fute91rrXuq4933vv
H7smiomJtXPfJO4zLzx5xek+hfLfv/UzaAEYLyZ/xTshGg9+I7RfUTAv1xfE
uAtASRsF+z0TYpfVT/67rxTmTMkpsxMKIKoutzzSIsQzz7Opsr0UMn08V7vP
Pfx/+DvGOwJLVWjU3Os921EjwNhGnwy4Eri5W3xL10IaJ3cITMWdBdBnu7sC
rQgMnZ/ecd6ShvZInGNkhQC6DyQfXDAiMBoU9jZAlwa826pWKx7GkH9GXKw9
AduzzjYZO2kMh/ttlmrLxXPVZXajFIFPB/TnJwVx55bFfjqhkYuMAtfggvME
tOdKWinyaMzuUgno7ciFocWmq7PPENhvruE5Yz+Nao9DAZdsBEilTDPCrhG4
sb14eUMNjSFnmeR7Vtm4YDBw31WWhMnU9zI1BI3QJT+X77yZBeLzG8ue9wT8
r3vG5LfRUNommTf3UDbMTjMvy14TGJOeVVbVTONYvHJ3+tdsLHzWGDlDnETJ
WNnBZ9MZaJsMnfjty0fsOnsnI30SClvkTpZydn8Xi6pUTT6qzGu2XJ9MImNj
lN2ZZQwCR7sKd3XzUbLvr7WmUiTURpR12zi77osT/C61TITyVltcWkxiaFIb
kRrMoC1j3qLpYjwcXvA4yMmMxPtXn91OBTBYQrhnFg2nYWet2MJ1U0mYzzr9
jyWPQcCP9knj+3n4FHH6l7MCCVvz2OWLsxhMbss/F8LjQf1F6GpHQxLxMYdH
Fh3h/GeNVnv8nYzBBZUHa3VI0GteXU3OYBAz1ZNe9S0Zu074lC6QIRGgnqxX
W8Ega5VBJjucjOiLGvLmYiQWrzMI3XaNwWvmzsEHdcmYZBz89v58EjOoJ2e+
bmbQny8xtmvpIbje9HFTkyfR0Xfm3DFXBkreLmVPcw4ht+LX0YkDBDSHbxWu
DmFQ+SrPpED1EJ48uiD42E3A74b4uYooBvLW52Q94g7i1GfpdbITSGSHhWy3
kmdQZr1odqppLKqPf3mYPkrgmKT11pFJnP+wH0tuMrEICrQcaXxE4K7x0Jc3
8xn0Xl9W/KsnBrrVWws7bxNoKlgwor+Ewf6cPw/XbY1ByFOlA0XvCFSHqHZu
fUsjZU1l7fSL+6AX/T71ygiBXzt6Nq5+SqPobHWGid0+vIt7ohrJ+fe6L31x
7jgN0/FXK0d09iFJ42VoCOdf+YW9noE0g5nlPcEduftwS2348aU+AvoFn5an
zGEwKHpGzlT3R+hLxym+C0i8tAp111Zi4LVuVvBf477Y9ueDdkiQsFm3z2Js
KYPqaqPu6kA/vOlrmL9qmEBO1aDahuUMrGeP6kzPDcD3UPM//ZVIfCxYEPeF
y6dpYbWY0dgGfGj27ZVyIKFUYJ7l6c3hW3PPPt3killOrg0e2iTWH80Mb4tj
0Px4u83AJXeIu/wI5U8joXsswsuX66uG8oQShzWb8bhV8bilEYkac9cDJY0M
bgbdiBhrNmPDtA6/UrMm4XEubHtZFYOTkuEeq0uWs6SiiW8Nd6+HvSt61jYx
eHypJb80cQI77VdwuYwyiaWJsyau+ZdBqKhh2XrPkev3pzZrx+qRmDxP94jm
CIOQt9NkxcJ2sOG6ZsNNPQSeS5e47njGwG3Vaf8ZZdvY14ps/5p7BBb+Zc/v
HWTgsGbasLzEJnYsTZwaZQi437x7t0KuDj4fBXljrVvYtPP7/w59SGDPpVaB
lUwdZK3tBPX3Atnwz9+H72Zy9p1/6A4MMNCQsYxp37abLdFbMHFJNIG3VnvP
h0vWwdV/2fnIYH/WJjCObPbi7On9kk3qdTDLN6vd0RnAKizZcCkwikDRxckG
BIdPKasImxwUzp5c1mK4yodA152UBf7vGcz72vl6z5JwVknmY0jUOgLOhroe
338xsNQfeyDcHs6GrFy9oduAgILSVR+nOXW48KLJc2N+ODviqzWjyoGA+s2S
2/jAwEWtp+ZlUBzrc8R3yuFj3DxcGb7HrZXBnGek97BnHLv9uIPbzUQChvxy
occLBpk/516LjtjPln2X+xLhT+Cx8nNl+x8M6mwcJvol7WcrxxZXWccRcJjR
H2Fbz9U3hV3vcusQm9d0Ka+ihQDx5JXuQBEDq7xTb+7kHmLvpIVpbxIRCJ31
RPXnVa7fJLZI/JZNZP+8q2Qfm09AbHOXv9t9BvVDB0OSbBNZLZm1V1v+IiB5
MEG9/AADm1cZh/fHpLDlw2k/9P4hYLWo7ZbiHgaum+yUe9qTWa2QK4US9QTk
bRqtCpIYWHxUbDw+lszmxpivFS8m0HEq9IRZHjcPYzfZLjuTwir9li9bWsu9
d70XIQrWnB8f+8PhM3is9/Q8A2ECAVSvGOs05uaY59aJPNU0NvFda5RnKFeX
UXONK24Mmq6ec9CelcauGEpa17eVQGBU5+mXWxmki9IfTVXmsXPU18hY7yZw
WU3Z0uUjjcquEduTx9PZjzUto8WSBKY7LxzX6adhl9k2m0rgsbYZ62f8nsD1
odok/mJJBk4Oa1bdSuexz+RV7hj3C/H+y+fmtdx8uHp6b1BJYTqbZnr44tNP
QkQWDV5XTKQh3Rj3xGpHOpsi1yAmXSjEvUYbwRJuD75c/LTEx4nHTnSpX5hT
JIRR1r6bT0/T+BI08reEO4917yy6aZoqxPPABaP1x2jMlMwb6d6dznacKSmq
SRJiZ8HAEVaaRtvcO1KNk3jsXRXXJiZAiLMfy8WluL0/WrnlcNTXVHZcZLNa
OkSIZTFfHcvn0njh4RGp2ZvKjrXL3pjlLMTw4pWPvZVpiJqa+sM+p7G39GfZ
tjoI4TIzw1M5j8LlM4UqnfdS2X1V66NdtguhpfjjoOMZCtX9WUc66RR2RYKw
47OvEAXGkcmbj1L4rN/Ai4pKYReedp5zyk6IG5YTvRfkUPjY1S4dxUtlt919
Q49YCLFx25a93usofJ+9wOutTRprnjSvJzpDCMGlsMOnOXv6baMZ521T2QuX
L0ldOSlEm1OFRoIhBeegNkfeWAobG6futofLT974kQn2nL2+vv5Iy2gqq+B6
VMcwSohHEcNui7QpVA5WMhma6ay/YD9jztWrS8G0SkqHQr4gKEdRl8cuF53m
88e5e+00CrCXorAFm6QkpXisktS1Z29GhZh3Y1DOV4LC7vMnTQ5OSGfRdWxK
3hshrI/Fu13UoBA3qUlq+dcM9javfAo/nIB9Z95IoiYFnrHf1PTudNYkId8l
JoZAJbPvXNxECo5lD45/7khnB9Ti2+dy/VwWvvl7oRgFiyj9jMKBDDZRJ/2Y
Hocv9i6yTXCgsLL0dYtldAbbafl4y0qO55QpGG4/Bu5ctznCseh09ueBR4om
zwn0RU97MV2d44cF4p/kOXv2ww9aizh8b3Nq428unhdDLVLuURlssGAgVO8r
gQWPz5TPTKJQwVvyZY9dGtt7dHKqii0Jgz++TlYLpxBuJj2JLk5l/1AWBA9w
+2WNudquHg8uP2YNsT3Zqez8qgMbT1mSsKj/e8IzXwqHeb0BR5aksdf0x4Pr
PUjszXs5OP4XhdyWEm3VV4ms2VrFqDBfEs0u1j9l8ynMKHp81OFOIuvhYVvU
50iisd/bYhIXD8nLSbl3LpHlZd0wUt7B8RZjyWXDJyjoX902q1iUyO5OOip1
Jo6EV8qF8CvXKAxFRO/f2L6f/X2rXe/xSo6nCcQ+Hz5LYVlwWlpJdTyr3BO1
8aMWiTq1IyfnJ1O4bm8YNNcinp0/q0NpJ7fvjquYzLXh+jnJRcOrZcd+Vl7M
+L0TFz9LVnXtzqbgER8buMkzgq2YsPPu0Y8E6jbJm9+JomBjbd9aWhTJRmfZ
xCY84+rlP1Gg40lhafb7NDmXSLZFO3PdWm6/l90qMr0bweGbVTUY6Qh2wrny
Qi9JEhMEU3RjtlN4ok48VlcOYqd8yVBqFxLYVZjMfrCjYPpw1KnhZDB7qbz+
dmkhgSmZKosj9SkY35S2uPtnCDsl6VrHI24/lsflHxVzotAx9fZtnfYgNrT5
oNokbj/KLC34+WolBdHHDJ7p453si9Ym45J2Ag2T1+qMqFKQi/pxwTFyJ8v8
W5N/r5HArdQT1UkKFCKceJoyI97s5b8l1NO5vlIo7U8K06Mwv2GqDKch2FZy
FrmTywNbOnsbbUBBNsHM7vWhVays+kL5U6YkjN64Xk5SorDG7Jp/zEJrVmCV
Oe2NLgl3n1in71z/q6YXbBzWWsu+3h5X5sL1W4+G3TdD7h39HfHLcJ2cK+tp
rVIo5kLitcm879fNuHhEmRV96qvhmVLhqJ1Lwicww2HyTAoDfQcP9io5o/h5
0UyJZBJFVMLgT2kKi+YIXPjLHEA5qzxtKiShkaZUcoWbA5ffn4nNtrZBxPAc
2b7LJA7kaaXLulDwFp+8x+WaD/IKTPLenOLqbkEcKlhKwe/Yh1fv/Hxh9bZ/
dyWf4+3rOtRpNQp5OYrRi713oTl5l/yKSyQulq/WXmRN4cgv/V9Z1b5YYFm9
IryWxPgvv4SCUApjq2WMvYZCUR+3dstfwST0Xkq/LXGj0NqdvFluYxgq4rss
WrdzfO9qSsZTewoqlw0zqY37YLXJzFliPwmq7aVaO/e+LFVEforDYXDzuLD7
HRfPdateL7kL3HyQ6x7UDY/GpSVdRpNWkVC+2dtxN4PCoFXk4C9+DL57ZS07
xOmF+4sjkrfGU/gn5OPk2YiFu16uu54bpyOKwuXPHKegZrF5ymrtGIh/69l0
xZvjewH8Jq1RLv6q0wedk+LxS+HHTDnOLhEn4Zb9hkKvjruprPMBNDz/4u7u
TmLAbaSm6AGFf23F/WP3HoDn/M27rodyegRxC1f2UOi/uaaGLonHGXevxVEH
SNzmNcQSjjQsKkfF3+odQqCprPIqIYlk8QjyigWN2DurzI5qJEJzTrTM8nIS
nytHBkTqNH6qmr90VUhE8VHm30/XOT1oYHelbimN6xP7q4tnH8K7qvUvx++S
OHt8zWqrDBrCBFZlbXUSkku2TanREKHW/f3Aymgae578Lp3hm4yGquKr6xVE
cL92y89vCw265JrbSvVkVM9G7ip1EcxGtK777aEhsTayPnRPEsKUvvYVG4vA
aPL/aI2lcWOKxsm0I2lY6zfnpESwCDujm1Uq/WjkG25utnqahswPdQaXXUWo
mrym/rYTDbkZBjqi4DR8S0j42r1DBFla5ue7bTSMvoyP/dZMQ+3YU88V8SJU
kDZZ691pyMTPZ7N38fFNR7496IQIPS80pw3b0JhUfdDuag4fWaE7/EtjRVDY
kf/7HKfrSy4ed0g14kPNMmW8MUOEf81qo76b0qiINGvcIcvhRw0D+GUiXFzM
d7S1o7FgRmlCJ5GN0uHjm0auilD8xM5nqSENj+lzoveY5OBi/6HbW06JUBgi
2LB1Gg02O4ea55IDauqfBvmVHP56x/LQRTSyc2Y15LZmQzRvL7v8tgi6S16U
63H8J0B1wzcz31yscLTU39smAsbgeyWOxtLGmVo/5gpAL3L0NKFE0No834vc
TaP7WRK0vAWIe1o+PPSPCMrZ9aXGoTRa12styRnIxbfx/BtL34vw/CqVtGmQ
hm7H2Ct3RQFWmX5oH+kTYapXnMydL5yOSzx/ip8kABrOPNRuF2HmiRv1zz7Q
6Lw+tSLwkQAfDjALl30WofudxPJAju89nLpnxNhHgM9Dk7V+itdiT4nmEYd0
BisVFnaZ3sjFa4/ByL5vIvxM+37gYQ6DGw+Su165CXBIf4w3s1eEgt9zu+cc
ZTD/1+0LnhcEECdORVyeUIspqo5DuZx+Hzd6bDTdWICA50e946fX4rhabCnD
6ZdNfqZLfQ1yYM23t6Q/itC3N8Hp/lROd+SvPXl/Yi4mnD+/4doTEUrcy3ss
1eogkRDfQh3PxVudr6oKIyL8IV5ipcPhn9j7e69vyoHm1LNS02Vrsb/wlEpJ
ah0mGNfYJk/Kwhvvvf3N70RwW3RuyvO8OmR33IiazGTBYqeP0PaRCPpqJp+V
z9Vhw1mTL51/ZqOP9+7R2UERtpxaNvosqw63vqnVuxdl4Sh/RE5TshaVFafX
p3bX4R79b/m4IR9js/h943K1SDYocGIG67DZ81NnSj8fzjMO/BU+JoKXjumS
oa91UF24Y8tGfia+WYn/06JSi8xiA0PmbR2OJDpptjzgo9hGUWajdi3+v/+P
/de5/xXnf93rv/LwP4fStKY=
       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {3, 4, 8, 7}, {4, 1, 5, 
           8}, {11, 12, 16, 15}, {5, 6, 10, 9}, {7, 8, 12, 11}, {6, 7, 11, 
           10}, {9, 10, 14, 13}, {10, 11, 15, 14}, {49, 50, 54, 53}, {12, 9, 
           13, 16}, {14, 15, 19, 18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {17,
            18, 22, 21}, {18, 19, 23, 22}, {19, 20, 24, 23}, {20, 17, 21, 
           24}, {21, 22, 26, 25}, {22, 23, 27, 26}, {23, 24, 28, 27}, {8, 5, 
           9, 12}, {13, 14, 18, 17}, {24, 21, 25, 28}, {26, 27, 31, 30}, {31, 
           32, 36, 35}, {28, 25, 29, 32}, {29, 30, 34, 33}, {37, 38, 42, 
           41}, {30, 31, 35, 34}, {36, 33, 37, 40}, {32, 29, 33, 36}, {34, 35,
            39, 38}, {35, 36, 40, 39}, {38, 39, 43, 42}, {39, 40, 44, 43}, {
           46, 47, 51, 50}, {41, 42, 46, 45}, {42, 43, 47, 46}, {27, 28, 32, 
           31}, {40, 37, 41, 44}, {43, 44, 48, 47}, {44, 41, 45, 48}, {47, 48,
            52, 51}, {48, 45, 49, 52}, {45, 46, 50, 49}, {25, 26, 30, 29}, {
           205, 206, 207, 208}, {50, 51, 55, 54}, {52, 49, 53, 56}, {53, 54, 
           58, 57}, {54, 55, 59, 58}, {55, 56, 60, 59}, {62, 63, 67, 66}, {56,
            53, 57, 60}, {58, 59, 63, 62}, {57, 58, 62, 61}, {60, 57, 61, 
           64}, {61, 62, 66, 65}, {51, 52, 56, 55}, {63, 64, 68, 67}, {65, 66,
            70, 69}, {66, 67, 71, 70}, {67, 68, 72, 71}, {68, 65, 69, 72}, {
           69, 70, 74, 73}, {70, 71, 75, 74}, {71, 72, 76, 75}, {72, 69, 73, 
           76}, {73, 74, 78, 77}, {74, 75, 79, 78}, {59, 60, 64, 63}, {75, 76,
            80, 79}, {76, 73, 77, 80}, {77, 78, 82, 81}, {82, 83, 87, 86}, {
           79, 80, 84, 83}, {80, 77, 81, 84}, {81, 82, 86, 85}, {83, 84, 88, 
           87}, {87, 88, 92, 91}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87,
            91, 90}, {88, 85, 89, 92}, {33, 34, 38, 37}, {89, 90, 94, 93}, {
           97, 98, 102, 101}, {92, 89, 93, 96}, {93, 94, 98, 97}, {78, 79, 83,
            82}, {91, 92, 96, 95}, {94, 95, 99, 98}, {95, 96, 100, 99}, {98, 
           99, 103, 102}, {99, 100, 104, 103}, {96, 93, 97, 100}, {90, 91, 95,
            94}, {100, 97, 101, 104}, {101, 102, 106, 105}, {102, 103, 107, 
           106}, {107, 108, 112, 111}, {104, 101, 105, 108}, {105, 106, 110, 
           109}, {113, 114, 118, 117}, {106, 107, 111, 110}, {112, 109, 113, 
           116}, {108, 105, 109, 112}, {110, 111, 115, 114}, {111, 112, 116, 
           115}, {114, 115, 119, 118}, {115, 116, 120, 119}, {122, 123, 127, 
           126}, {117, 118, 122, 121}, {118, 119, 123, 122}, {126, 127, 131, 
           130}, {116, 113, 117, 120}, {119, 120, 124, 123}, {120, 117, 121, 
           124}, {123, 124, 128, 127}, {124, 121, 125, 128}, {121, 122, 126, 
           125}, {109, 110, 114, 113}, {125, 126, 130, 129}, {127, 128, 132, 
           131}, {150, 151, 155, 154}, {132, 129, 133, 136}, {129, 130, 134, 
           133}, {130, 131, 135, 134}, {131, 132, 136, 135}, {133, 134, 138, 
           137}, {137, 138, 142, 141}, {134, 135, 139, 138}, {135, 136, 140, 
           139}, {136, 133, 137, 140}, {138, 139, 143, 142}, {151, 152, 156, 
           155}, {139, 140, 144, 143}, {147, 148, 152, 151}, {142, 143, 147, 
           146}, {143, 144, 148, 147}, {128, 125, 129, 132}, {141, 142, 146, 
           145}, {144, 141, 145, 148}, {145, 146, 150, 149}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {146, 147, 151, 150}, {140, 137, 141, 
           144}, {64, 61, 65, 68}, {152, 149, 153, 156}, {185, 186, 190, 
           189}, {155, 156, 160, 159}, {156, 153, 157, 160}, {163, 164, 168, 
           167}, {103, 104, 108, 107}, {154, 155, 159, 158}, {158, 159, 163, 
           162}, {157, 158, 162, 161}, {162, 163, 167, 166}, {159, 160, 164, 
           163}, {164, 161, 165, 168}, {166, 167, 171, 170}, {173, 174, 178, 
           177}, {168, 165, 169, 172}, {169, 170, 174, 173}, {165, 166, 170, 
           169}, {167, 168, 172, 171}, {170, 171, 175, 174}, {171, 172, 176, 
           175}, {174, 175, 179, 178}, {175, 176, 180, 179}, {172, 169, 173, 
           176}, {161, 162, 166, 165}, {160, 157, 161, 164}, {176, 173, 177, 
           180}, {177, 178, 182, 181}, {180, 177, 181, 184}, {181, 182, 186, 
           185}, {189, 190, 194, 193}, {183, 184, 188, 187}, {182, 183, 187, 
           186}, {184, 181, 185, 188}, {186, 187, 191, 190}, {187, 188, 192, 
           191}, {188, 185, 189, 192}, {190, 191, 195, 194}, {153, 154, 158, 
           157}, {191, 192, 196, 195}, {199, 200, 204, 203}, {194, 195, 199, 
           198}, {179, 180, 184, 183}, {178, 179, 183, 182}, {193, 194, 198, 
           197}, {192, 189, 193, 196}, {195, 196, 200, 199}, {200, 197, 201, 
           204}, {197, 198, 202, 201}, {196, 193, 197, 200}, {198, 199, 203, 
           202}, {209, 210, 211, 212}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12PtbzHkUB/B2XFJ2ZWlt1mMUW8wWmxoJ1clj7T4yYibbqDZqcsulomjb
RDOjZLtQpgsbypMiKuteGIwumLSNpmamuX2ZUukzrdWK1NZ+/4jjh/cvr5/O
L+c87+c4CKJ5WxgWFhZKOmPoTDOIhERLoDt0xwvFYwquHizOfbv6KWB5184K
r1AdgZmpvMKBixSER5hXx7HxXDeVF6uiPc7pVKcojQKONJ05/A2es86XHl+l
J7Dn8MmqHyMpIL7mcewxeL4tpS+mmnaJu/v6Mj8KHgWTIFPvEzR/cuhKo5uB
gDbY5Ug0iwL1a++nBc/xXBQx26aE9nrQL422pqDoHG/tSA2ebwqf9IxpJFC6
RDt4WWGEkubqN5HFeD6/0rwmn/aJea7uN44ZgcqVjnDS8Dyg48ANS4qAdPe7
3S48IyhEqQ5UDJ4XslMLhLTfXpRQt9fGCKOdRWEJfDz3iQJBP+3Dv+5izlMY
gIo5eF0GeK4Y6O0TvCCQsVHi8rXEAIM5g3HieXh+5OSU91raQ9mJ/FauAfyd
G7h+Nnie69jTyXlJQJiiEDNsDRDUy1/x8P1jNK+XL1nXQHt3/avGkWY9FDss
4/oY8LznQVISmAjklbvK2cf0wPz7jtytDs83n92TXUV7jtXrpxquHtZ1jAar
KvCcUWC0Z3UQUG8QdK2x0YNsbd54kQTPt+czxSH0XbLev8mNLdPBu8JkwU/7
8by0hje3U0XAawzvg3eUDtJi4xj8n/F8MKvwdYaCwOb32+3+mqED5hTudxaL
8Hxcu/5CsZyA2XqjY3eTFsq6Jj1TTsNzo9+eJo86Amm2Y7cdSdQCp6z2y1kD
DWge6zbc53mfQLp3Wm7lfC28Oh2ikKjwfIa8cEFQNQHxM1dm6It2EP+itSup
xvOco8daB68SOBzwuzY7qx0WjwtgsE7i+UNpQrxlBYHeDw9T/Je3A9Vxaavm
Nzy/P/1mcm4pgS2S8s3ZZg2crxzeNRqE588dJ1xcXkRAk3frdMgfGojy9RiS
LsHzMxe4jcGnCJTfPveowl8DLCvu2PIZeO7JNQf+e4JAVrMPM3VIDaN3Iqqs
h+rRPD0mWfcxk0CLZfWWVxVqeHKe35qnw/O3vizhrDQCVqV8y6ZwNZzgs8V3
pXjOWvxtZq2QQODSMv0yGzUk9k9o4Z/B8+kl0yRtiXSv61MWLZSpYEO99DQz
Gc/bPEIYkfsIPM6/VlARpQKOeJd1yCY85/jm79weTe9dWEzSn/Yq8Igf+kfm
i+fqj939KZEExmZz73op22COe2x47Ww8d9NmmOZEEHC9ZfreX9gGzpqXe5cx
8Hyl27ymBaEE7g0HHO9ybwOnm+6jelMdmjtVfWVfE0hA4LnP0ZJqBUg6MH9A
hucz9XbZEesIvG2vsa3MbIXAzytNZefwvFE49b8EPwI9hYY3Ot9WEDx/YJty
GM9XccKaJ/9AoH/9tc9yzEpIF8m7VBF4fiiz5IytD4GNLltHm84qoTTy1qLA
lXguPzSS7uFJoHaHN/9EgBLq7TImRs3F8878ckq9kIDn2TqT3kIJFlc3iIfG
4/ltJ3/XbmcCU/qdQ69ca4EFovH7r3fXonmwdkVXvCOBj14rJlqFtUC812Vr
UwOeT16+9p7jLLq3mw9O7fmiBWTSpXMvleH5p/6Pfer5/wehZ325
        "],
       VertexNormals->CompressedData["
1:eJy11/lXDuj7B/AmS9Jkm6wz9C2NpdHQGFQ+vIdQlskWZUSmKGQKyW7SjGKE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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNmvk3ld/7/5EGlUgRGYpC0eAVTcZnMg+llChRhjIk0aBRKkWUyOyYDs4p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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267
uW9m7H5zG+a+jTGMbTbmso0Z296f0+s55/njfX4fr8/n8/p+f8/jPOdQLyO3
T84Tbm5uTznc3ErrqYeb/bmc4k5dSikPs9rmPGBWl1E8YR7UlZVK1BWUKjB3
PF5KRXbLMuOJ04Ndb3oO9iqwW56eF8wdl51RTamu+Cm1mPGGVaM2tw+sEveq
AfOhrq344/VityqphtuXXTu3JnvVcfhzhyo4qjITrjRT2iit2TFehzN9cddV
AqjNUw/mh7s+zJ+9QJg9GyiNlRB6dWCBOM0TpDSk5wtvgNM8jZRgF2cIrCbv
4uviDcBlZ4YpTZVWSkscjWBh1CF8Dk2pG/OZhOOxu4UqTaiD2Q0lYbhbsNuQ
2WY4w/lsW8FDmW3Ou9fDGcROE3r2nSQrfZQBSn/OMU97pR21uSNhrdnrAIuk
jla6UEcoHWFt8UQpndhtzkwHnJHsdoa3ZbYju+3pRcGsF6N0VWKVbkqC0pOZ
zrBYanPHwbpwr+6wOOpeSiLuKHZjSCzuHux25OzuOOPYTYDHMBvPu7bgnSKo
W/JebZnryfeQRJ3Ad5JMbe4UWCJ37QtLoR6kDKTuraTCkvDYd9uP3Xhm+uJM
YXcAPInZVN6xKzu9YNYbogxW0pShykhlBOcMgKVRm3sYbCD3Gg6L5zNI4ux+
ONI4Ywi1uTPYTeXs4TjNM4o7DGbHZtPp2VwmM8OZSYdl4B6jjFaylSxlvDKJ
nnnHMjMSzzjYKDzZsEzcWS4u8+bgHI0nFzYGzwTYWDwTYVOVyUqBMpNeNnez
mSeZsV4hTvPkKVOozZMPm+Cyl8+dcpidjHc8tfNs603jDlPwTIfl4ZkBy8dd
CJuIcyq8gL2nlFnKs8pc5TllCe9RQK8Yp3lmK0XU5p4DK2SnGDYL9zy8c+jZ
OfPpmedpZorwPAObzc582DTuUMRuMWfMxTmPvYXKAmrbWwR7Btdi2Hz2lsDm
4ljAZ/Ac9fPKUmrzLIMtxLMctgjPC7DFuF+ELcG5FLYUz0plBbV5VsGWs/eS
spra9tbAnI4VsDXULyuv8lyrbFQ24DXPOuUVZlcy8zLONeyup7eK2bXsvkRv
Hcx6mzhjs7JF2aq8xcx62GZqc78Gc95xA+w16teVbbjXsbuJbMb9JrN27hvs
bMGxjTtsZOdNZpbxma7mvV6H71C2M2fuXcpO5R1lj/K+sp+eeXczs5Wz3oZt
w7kdth33Hlw78L4L24lnL2wXnvdgu/Hsgzmd78D2sPcBd3yDd9jJWXvZ+0j5
kNr2Pobtw7Uf9i47H+Lcj/dT5ROY9T5XPqM2zxewj/B8CXufnc9wfIzzE2bs
t9l+8+13OAtucweVA+yZ97BySDmqHFNOK6fo2TlHmPkC71ewL3EegB3AfQzX
QbzHYYfwfA07jOcE7Aiek7A7yl3lgXLf5YyjzHzDPb9VLuI0z1nlDLV5zsFO
uOyd407HmXW+sz2/w3ma3nnYGTwXYGfxfA87h/si7CR3PQX/Fs8PyiXlhnJN
+VW5TX1d+Q12Ac9V5Qq1uX+EXcR5CXYJ93VcVl9WfoJdxvMz7AqeX2BX8dyA
necOV9h1nnGNme+YucxZP+G5pdykNs/vsF/Yuw27zs5Nl3e2p33nd6itdw92
E88fsFt4/oT9jvsv2G2cd2B32fvbreTvVF3949NPqacEOUoctveP8pDa9h7B
/sJ1H/aI+rHyhKPk+a9SWnUpR8k55rF/5P7H7ANmHuN8xK7DUdKznf+YeciM
9czxL70yjpIzyiruSkWlAjMOWFlqc5eDOe9YClaOe5ZXvLijG7tlSFncnsza
uR7suOPw4g6l2fFk5h7fy0Peqzy8kuLNnLmrKJWV6oqP4s/3UgFvVWYqclY1
mBf38IZ54/bBVQlvDVhlPDVhVfD4wqriqQVzOqvDfNirzR09eIfKnFWTvQCl
DrXt1YXVwuUHq8FOHZx+eOvzd7I2vQZKILV5GsIC8ATB/NkJdHHYs5ES7Cj5
7bfffPsdtt/m+syGMBOItzEsTGmqtFJa0rNzmjDTkLNDYUGcGQwLxtsUVyO8
4bAQPM1gjfE0hzXB0wLWTmmvdFaiXM4IY6Yt97S5TjjN00ZpTW2eCFhzl70I
7hTOrPOdW3FmO2rrRcJa4+kAa4OnIywCdydYC+7aEt6evS68U08lQemjJPOO
xrspsTjN01WJpjZ3DKwT94yCdcYdhyOGnrl60DNPd2ai8cTDurLTAxbJHaLZ
jcWbwN3j2OulJFLbXm9YPK4kWA8cPWHdcCTiTKBO4TNJxNMX1gtPKqw3nn6w
JNzJsGQ8A5T+1OYZCEvBMwiWyt4QZbCLoz+sP3tDlTRi9UhlBPUwZRRsEJ50
ZTi7A5kZ6uI0Twa9QcwOY3cIvXSY9TI5I0sZreQo45nJgGVRp3G30TztXmOV
McTqCUou7nR2M0kW7mx27dxx7DmdY7jDKHaymenLZzqY9xoLn8iZ2bgnK5OU
fOVJpVCZQc+8U5jJ4axcWC4e28ujnogjn9q8U2GT8BTAJuOZBnM682B5eOwu
03HY3kzuOI53mMRZBezZ/7/PcnFMh03HNVspwlXA7Ex65p3DzEx6c5ViavPM
gzmdRbBCdopx/A/n6Ilo
            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2v031GkUAPAxXko0q6izNplNCr2Z3ihLl6bykhRS6gwKkSJs2eVIRd4j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        "],
       VertexNormals->CompressedData["
1:eJzFmPc/Fu73xzOy3lbSQCkto4GMpHIQhVIhJaIyGioqiSJFITuzQkYqOyOb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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNevk31u/3tWSsDClRKEKiQdJMbEoSQkqFDKVJJUmKJBnTJIlMcQ/umdyT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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2us7lHkYB/BxuIjBYu1VjYpSit3YkBw234lNq1ibSWJtNCGFIZ2ng5DW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        "],
       VertexNormals->CompressedData["
1:eJzFl/c/Ff4XxylRURIhDbQ0zCahE1kRURo0zUiRGSEjlRUZUUpKZFRWMhqO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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNWvk31e/3pUSDSioqFaFkSBGhyZaUlDKTkDJEEykiQqRBporM7qTLvdfl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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vk3lXkYAPBrSRwRLbK0UWk5SBuX0nNrWpVKJGQpoow1Ymp0kRTpJJkk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        "],
       VertexNormals->CompressedData["
1:eJzFl/c/Fe4bxu3ISmkpFInQIiHqFkWhjFRGqWSlUFFIJSWlKCshUipJyN7c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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNevk31f/3vaGRJipJSRkSaVIpRW1SKJRSGV4ks9BIVMpYkplrvIZ7pXuf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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vk31nkUB/AnotE8tFDZjbKekaTSsV6yDCmPFMaStUjUM88komJIRUgL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        "],
       VertexNormals->CompressedData["
1:eJzFl/k3FV4Xh9GAlJIMGUooUSgVkexKhYpCKtFAqRQVFZGhpDLPkiaERMOX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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNWvk31N//l0qkRbaSlOy0kLKU7YFSCJVKJUIoSaGIkoRk38a+F8mWMjOv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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2utbjHkcBvApsXRQiWI7SazDqjXJqBl8y5a2GklnpDFiS+mwFaHddEAl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        "],
       VertexNormals->CompressedData["
1:eJzFl/c/Fu4XxhWRisoolYyGSGS1KIdU0kRGQkYqojSIUp8iEilFi1RWJCQj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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNmvc/l+/7/8mOMjJSSWiQhAgVOSgzIyObl733lmRljwhll4ZEKSlc1/O6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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vk31HsYB3CypFtUVKphpD03pZKE6RlyiBYRwi0mIltXdW+WNipRqBQz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        "],
       VertexNormals->CompressedData["
1:eJzFl/c3Fv77x6WUrKikNGWWUMlWl5Y06E02SWgoImlISCVFQoUoyp4to8wu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        "]]}, 
     {EdgeForm[None], Specularity[
       GrayLevel[1], 100]}}, {
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1mmk4lO8b9yUqUmmhUqQsFULZ2uQrWhB+iVKyRoRCJEqEUFmzlmQ3thmz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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxdmHl8z3Ucx38/zNz3XHPNOeYaw9wbNubYMAwb5thsrrkjypFCRJIrVyIh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           "]]]}, {}},
       VertexColors->CompressedData["
1:eJy12vk71HsbB3BLESnbSJ3iZJT9UFNyhG45WVIHSWOtjq1NtoQeskRS4RHq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        "],
       VertexNormals->CompressedData["
1:eJyt12lUz+vXBvAyhIrMs0zH0EmmkCJXZjKPmULHLMd05FSmzLNkOCRS4egQ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        "]]}, 
     {EdgeForm[None], Specularity[
       GrayLevel[1], 100], 
      GraphicsComplex3DBox[{{4254.5, -287.8, 7620.999999999999}, {
       4791.5, -232.29999999999998`, 7681.2}, {4796.200000000001, -347.3, 
       7606.}, {4917., -380.1, 7567.5}, {4997.099999999999, -280.4, 
       7621.299999999999}, {5135., -257.4, 7616.200000000001}, {
       5182.200000000001, -148.8, 7680.7}, {5095.5, -69.89999999999999, 
       7745.6}, {4964.5, -81., 7757.5}, {
       4920.900000000001, -189.39999999999998`, 7692.2}}, 
       {RGBColor[
        0.4300308387096774, 0.11104058064516129`, 0.5624877419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4376.400000000001, 155., 7760.200000000001}, {
       5002.6, 218.4, 7570.8}, {5142.900000000001, 221.70000000000002`, 
       7562.7}, {5206.6, 131.8, 7484.099999999999}, {5136.099999999999, 41.5, 
       7415.7}, {4993.9, 35.9, 7422.3}, {4931.900000000001, 125.1, 7500.2}}, 
       {RGBColor[
        0.34726851612903226`, 0.11558974193548388`, 0.6334312258064516], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4734.2, 688.9, 7716.500000000001}, {5116., 684.6,
        7432.4}, {4990.3, 636.2, 7404.2}, {4992., 526.3, 7334.}, {5126.9, 
       499.9, 7314.400000000001}, {5190.2, 393.29999999999995`, 7245.4}, {
       5328.6, 404.8, 7250.}, {5397.3, 505.99999999999994`, 7313.}, {5339.4, 
       606., 7377.7}, {5205., 596.6999999999999, 7374.5}}, 
       {RGBColor[
        0.2935442580645161, 0.14887851612903225`, 0.6948608387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5146.8, 1185.3999999999999`, 
       7551.900000000001}, {5368.8, 945.8000000000001, 7176.3}, {5233.1, 
       968.6, 7180.500000000001}, {5163.4, 875.2, 7121.4}, {5258.5, 784.9, 
       7075.6}, {5242.900000000001, 662.6999999999999, 7003.799999999999}, {
       5365.8, 603.1, 6977.599999999999}, {5488.1, 654.1, 7015.2}, {
       5503.799999999999, 767.3, 7081.8}, {5385.799999999999, 827., 
       7108.599999999999}}, 
       {RGBColor[
        0.2624051612903226, 0.20452032258064518`, 0.7488907741935483], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5709.7, 1392.7, 7290.3}, {5574.4, 1031., 
       6812.8}, {5473.8, 1101.9, 6874.200000000001}, {5356.3, 
       1048.6000000000001`, 6857.299999999999}, {5381., 935.9, 
       6780.599999999999}, {5292., 838.3, 6730.7}, {5359.2, 740.9, 6657.4}, {
       5495., 738.4000000000001, 6635.200000000001}, {5578.799999999999, 
       829.4000000000001, 6681.4}, {5515.3, 924.2, 6752.599999999999}}, 
       {RGBColor[
        0.24858348387096774`, 0.26921051612903224`, 0.7842913548387096], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{6031.6, 1252.2, 6649.299999999999}, {5632., 
       1028.5, 6375.8}, {5524.2, 943.2, 6347.3}, {5402.6, 970.5, 6398.5}, {
       5385.799999999999, 1077.6999999999998`, 6475.9}, {5493.5, 1166.2, 
       6506.8}, {5613.7, 1138., 6455.299999999999}}, 
       {RGBColor[
        0.24515225806451613`, 0.33932974193548393`, 0.8085143225806452], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{6097.099999999999, 1037.3, 6051.1}, {5459.2, 
       1084.9, 6003.4}, {5325.7, 1050.7, 6029.}, {5257.5, 1117.3, 6124.8}, {
       5317.4, 1214.4, 6193.8}, {5453.2, 1251.3, 6170.1}, {5519.599999999999, 
       1184.6, 6075.2}}, 
       {RGBColor[0.2519013548387097, 0.4057465806451612, 0.8112741612903226], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5680.9, 989.8999999999999, 5512.599999999999}, {
       5230.2, 1192.8000000000002`, 5683.5}, {5125.099999999999, 1213.1, 
       5769.9}, {5149.6, 1304.7, 5869.3}, {5265.400000000001, 1376.3, 
       5890.7}, {5371.4, 1350.3, 5797.}, {5349., 1261., 5699.2}}, 
       {RGBColor[
        0.26327787096774197`, 0.47048051612903224`, 0.8042780322580646], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5143.4, 960.3, 5168.3}, {4858.599999999999, 
       1250.3, 5356.2}, {4991.5, 1264.7, 5325.4}, {5055.400000000001, 1341.9, 
       5409.1}, {4959., 1380.4, 5501.2}, {4969.2, 1464.3000000000002`, 
       5615.9}, {4847., 1477., 5681.3}, {4730.1, 1417., 5641.8}, {4719.3, 
       1338.6, 5535.2}, {4836.9, 1324.8, 5470.2}}, 
       {RGBColor[0.28152729032258067`, 0.524952129032258, 0.7781949354838711],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4499.6, 1148.6000000000001`, 4993.6}, {4602.5, 
       1584.1, 5318.5}, {4712.5, 1531.6000000000001`, 5254.8}, {4825.4, 
       1578.7, 5300.6}, {4787.7, 1667.5, 5400.5}, {4866.5, 1748.9, 
       5485.900000000001}, {4787.7, 1823.5, 5572.7}, {4650.5, 
       1820.4999999999998`, 5576.9}, {4575.9, 1745.3, 5497.8}, {4650.6, 
       1671.9, 5412.8}}, 
       {RGBColor[
        0.30206767741935486`, 0.5760029677419355, 0.7457495161290323], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4092.3, 1616.4, 5114.4}, {4553.7, 
       2041.6000000000001`, 5315.2}, {4647.8, 2118.7000000000003`, 
       5380.400000000001}, {4777.5, 2091.4, 5345.3}, {4821.5, 1997.6, 
       5254.}, {4717.6, 1920.7999999999997`, 5189.4}, {4590.9, 1946.1, 
       5222.8}}, 
       {RGBColor[0.3287994193548387, 0.615007, 0.7002575483870969], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4074.7, 2276.4, 5306.4}, {4589.099999999999, 
       2470.7000000000003`, 5297.3}, {4722.3, 2501.5, 5313.}, {4806.5, 2438.4,
        5225.4}, {4772., 2349.4, 5125.8}, {4630.599999999999, 
       2321.3999999999996`, 5114.5}, {4547.2, 2382.6, 5199.8}}, 
       {RGBColor[0.356959935483871, 0.651231, 0.6517548387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4245.900000000001, 2847.6, 5507.7}, {4708.1, 
       2917.5, 5323.9}, {4600.7, 2851.5, 5269.}, {4632.5, 2771.5, 5170.1}, {
       4770., 2785.4, 5158.8}, {4863.5, 2726.5, 5072.7}, {4993.099999999999, 
       2761.1, 5087.400000000001}, {5025.3, 2849.1, 5182.7}, {4946.6, 2911.5, 
       5269.700000000001}, {4818.2, 2874.8, 5252.7}}, 
       {RGBColor[
        0.39180477419354837`, 0.6765738387096774, 0.5981050967741937], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4800.2, 3368., 5575.5}, {5014.3, 3201.4, 
       5138.4}, {4876.9, 3195.2999999999997`, 5140.9}, {4827.2, 3121.1, 
       5045.4}, {4938.3, 3075.7000000000003`, 4975.8}, {4947.7, 2991.4, 
       4862.2}, {5080.2, 2971., 4824.6}, {5189.6, 3024.7, 4888.1}, {5182., 
       3103.1, 4993.7}, {5054.4, 3124.4, 5031.8}}, 
       {RGBColor[0.4276045161290323, 0.7003622258064516, 0.5437200645161291], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5301.9, 3607.9, 5361.4}, {5176.599999999999, 
       3384.8999999999996`, 4752.8}, {5180., 3293.7, 4649.6}, {5058.5, 3239.6,
        4617.4}, {4936.7, 3266.2, 4675.9}, {4939.9, 3362.6, 4783.3}, {5058.1, 
       3416.5, 4816.}}, 
       {RGBColor[
        0.47028151612903224`, 0.7154317419354839, 0.4921085806451614], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5631.900000000001, 3737.8, 4833.5}, {
       5464.099999999999, 3594.6, 4425.3}, {5395.1, 3669.8999999999996`, 
       4517.}, {5267.900000000001, 3639.7, 4525.099999999999}, {5252., 
       3537.2999999999997`, 4432.4}, {5140.5, 3461.3999999999996`, 4392.7}, {
       5159.3, 3367.4, 4298.}, {5281.8, 3351.4, 4247.099999999999}, {5393.9, 
       3416.1000000000004`, 4275.8}, {5372.2, 3508.7000000000003`, 4370.5}}, 
       {RGBColor[0.513417, 0.72992, 0.440682], CylinderBox[{2, 3}, 20], 
        CylinderBox[{3, 4}, 20], CylinderBox[{4, 5}, 20], 
        CylinderBox[{5, 6}, 20], CylinderBox[{6, 7}, 20], 
        CylinderBox[{7, 8}, 20], CylinderBox[{8, 9}, 20], 
        CylinderBox[{9, 10}, 20], CylinderBox[{10, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], SphereBox[8, 20], 
        SphereBox[9, 20], SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5838., 3716.2, 4162.3}, {5363.5, 
       3594.2999999999997`, 3997.8}, {5230., 3561.3, 3967.9}, {
       5130.400000000001, 3618.8, 4039.}, {5159.5, 3705.6, 
       4136.099999999999}, {5293.9, 3740.8, 4168.3}, {5391.7, 
       3683.2999999999997`, 4097.5}}, 
       {RGBColor[
        0.5620539032258064, 0.7370415483870968, 0.39831090322580653`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5753.6, 3509.3, 3610.4}, {5128.7, 3675.6, 
       3603.7999999999997`}, {4992.900000000001, 3682.1, 3638.3}, {4951.9, 
       3776.2999999999997`, 3726.4}, {5040.3, 3861.5, 3779.2000000000003`}, {
       5178.6, 3857.1, 3745.7999999999997`}, {5218., 3763.7999999999997`, 
       3658.7000000000003`}}, 
       {RGBColor[
        0.6107925161290322, 0.7436816451612903, 0.35667119354838717`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5249.7, 3452.4, 3135.3}, {4853.7, 
       3758.7000000000003`, 3305.2999999999997`}, {4768.4, 
       3821.5000000000005`, 3393.1}, {4824.4, 3926.2, 3461.7}, {4953.6, 
       3973.4, 3451.6}, {5037.7, 3903.1, 3358.}, {4984.5, 3800.6, 3290.5}}, 
       {RGBColor[
        0.6610567741935485, 0.7430999677419354, 0.32600229032258066`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4715.599999999999, 3368.2000000000003`, 2874.}, {
       4558.700000000001, 3883.5, 3020.5}, {4681.900000000001, 
       3868.3999999999996`, 2961.2}, {4770., 3955.2, 3003.}, {4701.1, 4032.6, 
       3095.2999999999997`}, {4744.9, 4142.7, 3173.7}, {4642.7, 4192.1, 
       3254.0999999999995`}, {4514.6, 4141.9, 3258.6}, {4472.6, 
       4039.2000000000003`, 3186.}, {4570.4, 3989.8, 3107.2}}, 
       {RGBColor[0.7108129032258065, 0.7412082258064516, 0.2966935806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4064.6, 3719.8999999999996`, 2823.7}, {4240.1, 
       4199.2, 2948.9}, {4309.2, 4120.7, 2859.9}, {4433.9, 4156.2, 2846.}, {
       4448.1, 4265., 2930.7}, {4561.3, 4346., 2958.1}, {4531.5, 4445.8, 
       3050.3}, {4408.5, 4465., 3108.7}, {4302.6, 4390.1, 3083.8}, {4329.3, 
       4292.900000000001, 2994.7}}, 
       {RGBColor[0.757012129032258, 0.7301460322580645, 0.27690622580645163`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3724.7999999999997`, 4265.5, 2941.5}, {4145.4, 
       4575.5, 2802.6}, {4134.3, 4470.900000000001, 2714.3999999999996`}, {
       4248.599999999999, 4433.599999999999, 2661.7000000000003`}, {4341.2, 
       4519.2, 2719.7}, {4480.400000000001, 4531.6, 2705.9}, {4542.1, 4627.6, 
       2778.3}, {4468.2, 4705.299999999999, 2858.8}, {4337.400000000001, 
       4703.4, 2880.2}, {4278.900000000001, 4606.900000000001, 2806.8}}, 
       {RGBColor[
        0.8012228387096773, 0.7162818387096774, 0.25848077419354837`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3715.2999999999997`, 4889.3, 2898.}, {
       4298.400000000001, 4975.2, 2644.8}, {4433.1, 4976.5, 2613.6}, {4472.3, 
       4877., 2527.6}, {4393.2, 4779.099999999999, 2471.3}, {4253.4, 4784.2, 
       2508.}, {4213.6, 4880.5, 2591.7000000000003`}}, 
       {RGBColor[
        0.8368166451612903, 0.6902756451612903, 0.24595690322580643`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4057.8, 5447.5, 2817.6}, {4428.900000000001, 
       5386.3, 2518.2}, {4300.2, 5345.8, 2496.8}, {4291.5, 5243.099999999999, 
       2416.4}, {4422.9, 5213.8, 2383.8}, {4476.700000000001, 5111.9, 
       2300.6}, {4615., 5118.5, 2294.5}, {4692.2, 5211.3, 2360.2}, {
       4643.099999999999, 5306.5, 2438.5}, {4508.9, 5301.599999999999, 
       2445.6}}, 
       {RGBColor[
        0.8683509677419354, 0.6594232580645162, 0.23398051612903226`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4546.200000000001, 5900.4, 2664.3}, {4563.6, 
       5594., 2148.9}, {4435.5, 5587.9, 2198.6}, {4374., 5477.2, 2167.6}, {
       4466.8, 5405.8, 2093.2}, {4456.8, 5278.900000000001, 
       2032.6000000000001`}, {4573.7, 5244.1, 1966.8}, {4686.099999999999, 
       5321.8, 1960.3999999999999`}, {4697., 5440.7, 2016.7000000000003`}, {
       4584.400000000001, 5476.2, 2081.}}, 
       {RGBColor[0.8877068387096774, 0.6140322903225807, 0.2236465806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4791.599999999999, 6114.8, 2131.9}, {
       4571.099999999999, 5633., 1764.1}, {4455.8, 5680.299999999999, 
       1821.3999999999999`}, {4358.2, 5593.8, 1818.1000000000001`}, {4412.7, 
       5483., 1754.7999999999997`}, {4354.9, 5357., 1721.6000000000001`}, {
       4446., 5273.8, 1657.4}, {4575.7, 5307.3, 1628.6999999999998`}, {4630.2,
        5423.599999999999, 1659.}, {4543.7, 5505.7, 1721.3000000000002`}}, 
       {RGBColor[0.9013106129032258, 0.562041806451613, 0.21258587096774198`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4988.900000000001, 5927.6, 1531.7}, {4786.8, 
       5567.900000000001, 1314.4}, {4746.099999999999, 5684.5, 1374.9}, {
       4618.7, 5686.8, 1405.1}, {4572.2, 5563.5, 1361.8}, {4445.2, 5504.3, 
       1365.3}, {4432.099999999999, 5380.2, 1314.2}, {4540.599999999999, 
       5320.5, 1263.2}, {4665.400000000001, 5365.9, 1254.2}, {4674.6, 5489.4, 
       1305.8999999999999`}}, 
       {RGBColor[0.9022597741935484, 0.4955323870967741, 0.1999262580645161], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5216.8, 5489.9, 958.8}, {4612.1, 5450.6, 
       920.8000000000001}, {4650.8, 5560.5, 993.6}, {4550.7, 5621.8, 
       1050.9}, {4439.200000000001, 5548.2, 1013.4000000000001`}, {4301.2, 
       5566.599999999999, 1045.1000000000001`}, {4221.8, 5468.7, 985.9}, {
       4268.6, 5366.599999999999, 906.8}, {4396.3, 5348.599999999999, 
       876.6999999999999}, {4475.3, 5442.4, 933.}}, 
       {RGBColor[
        0.8980634516129032, 0.42284993548387095`, 0.18591083870967742`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4911.4, 5213.8, 507.5}, {4465., 5319., 
       485.20000000000005`}, {4572.6, 5400.6, 509.40000000000003`}, {4540.8, 
       5514.200000000001, 566.6999999999999}, {4403.099999999999, 5506.7, 
       581.}, {4308.8, 5595.3, 634.5}, {4179.3, 5557.6, 633.5}, {4148.1, 
       5438.6, 581.7}, {4227.5, 5346.7, 528.5999999999999}, {
       4355.299999999999, 5387.3, 531.3}}, 
       {RGBColor[
        0.8852913225806451, 0.33987909677419365`, 0.1696357419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4467.4, 4897.5, 98.6}, {4213.2, 5491.8, 179.8}, {
       4143.6, 5587.3, 254.1}, {4212.5, 5684.2, 318.7}, {4345.7, 5687.8, 
       310.8}, {4419.3, 5591.8, 235.8}, {4349.900000000001, 5496.4, 172.8}}, 
       {RGBColor[
        0.8734219677419355, 0.25660432258064536`, 0.1540787096774194], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3973.8, 5237.7, -234.39999999999998`}, {3995.5, 
       5755.5, -66.60000000000001}, {4013.0000000000005`, 5862.1, 22.7}, {
       4138.3, 5895.6, 61.3}, {4243.3, 5827.3, 14.6}, {4228.2, 
       5718.9, -75.9}, {4104., 5686.6, -113.5}}, 
       {RGBColor[
        0.8627133225806451, 0.17293877419354836`, 0.13944490322580644`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}]}}, {
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1enk01d8bNYmKCFFJppIiTSiJaqfMFJVKhCYShWRI5lAyj0UyXPNw5/lS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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxdmHl8z3Ucx38/zNz3XHPNOeYaw9wbNubYMAwb5thsrrkjypFCRJIrVyIh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           "]]]}, {}},
       VertexColors->CompressedData["
1:eJy12vk71HsbB3BLESnbSJ3iZJT9UFNyhG45WVIHSWOtjq1NtoQeskRS4RHq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        "],
       VertexNormals->CompressedData["
1:eJyt11VUlnnXBnDEHpOwFQuxC8TAuABfTBRl7G5QURkRAxMVW1EEjHEsxsBG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        "]]}, 
     {EdgeForm[None], Specularity[
       GrayLevel[1], 100], 
      GraphicsComplex3DBox[{{4859.2, 6569.400000000001, 366.1}, {4520.4, 
       6601.900000000001, 146.6}, {4386.7, 6585.200000000001, 119.5}, {4358.3,
        6478.5, 39.}, {4447.6, 6388.2, -15.7}, {4585.900000000001, 6411.3, 
       17.299999999999997`}, {4615., 6515.7, 95.3}}, 
       {RGBColor[
        0.4300308387096774, 0.11104058064516129`, 0.5624877419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4521.5, 6919.199999999999, 588.3}, {4225.9, 
       6427.4, 496.90000000000003`}, {4362.8, 6422.1, 508.90000000000003`}, {
       4416.299999999999, 6323.599999999999, 442.2}, {4308.400000000001, 
       6260., 382.5}, {4304.3, 6146.3, 297.90000000000003`}, {4173.8, 
       6115.599999999999, 259.90000000000003`}, {4061.5, 6185.799999999999, 
       298.5}, {4064.3999999999996`, 6291.8, 377.5}, {4190.1, 6323., 415.4}}, 
       
       {RGBColor[
        0.34726851612903226`, 0.11558974193548388`, 0.6334312258064516], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3877.0000000000005`, 6666.1, 862.8}, {
       3859.8999999999996`, 6161.099999999999, 670.0999999999999}, {
       3966.7999999999997`, 6237.400000000001, 710.2}, {4081.7, 6188.5, 
       672.9}, {4049.2, 6073., 603.9}, {4132.8, 5978.6, 540.4}, {4059.4, 
       5876.3, 481.70000000000005`}, {3922.2999999999997`, 5866.400000000001, 
       484.1}, {3842.9, 5954.5, 543.4}, {3912.6, 6054.4, 600.8}}, 
       {RGBColor[
        0.2935442580645161, 0.14887851612903225`, 0.6948608387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3340.5, 6150.099999999999, 910.3}, {3749.7, 
       5719., 822.0000000000001}, {3849.4999999999995`, 5637.400000000001, 
       772.8}, {3977.2, 5684.7, 793.}, {4014.1, 5802., 855.8}, {3904.7, 
       5882.5, 904.7}, {3780.1000000000004`, 5837.8, 885.5}}, 
       {RGBColor[
        0.2624051612903226, 0.20452032258064518`, 0.7488907741935483], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3252.0000000000005`, 5543.2, 
       971.4000000000001}, {3717.2, 5380.5, 1020.3}, {3854.7, 5383.1, 991.}, {
       3931.7999999999997`, 5481.4, 1042.2}, {3877.3, 5574.7, 1120.}, {3738.2,
        5574.900000000001, 1151.8000000000002`}, {3662.2999999999997`, 5477., 
       1100.1}}, 
       {RGBColor[
        0.24858348387096774`, 0.26921051612903224`, 0.7842913548387096], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3476.7000000000003`, 4895., 985.9}, {4059.4, 
       5084.7, 1163.5}, {4182.200000000001, 5143., 1185.1000000000001`}, {
       4178.900000000001, 5254.9, 1263.8999999999999`}, {4068.3999999999996`, 
       5313.2, 1322.2}, {3942.7999999999997`, 5247., 1295.6}, {3944.6, 5137.7,
        1218.7}}, 
       {RGBColor[
        0.24515225806451613`, 0.33932974193548393`, 0.8085143225806452], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4074.3, 4557.7, 1035.6}, {4362.5, 4847.9, 
       1371.}, {4415.9, 4957.4, 1441.1}, {4332.4, 5038.5, 1511.2}, {
       4201.400000000001, 5013.5, 1513.}, {4144.5, 4902.8, 1442.6}, {
       4227.900000000001, 4823.9, 1373.6000000000001`}}, 
       {RGBColor[0.2519013548387097, 0.4057465806451612, 0.8112741612903226], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4652.3, 4388.7, 1233.7}, {4696.5, 
       4830.599999999999, 1687.6999999999998`}, {4694.2, 4949.6, 1760.5}, {
       4578.799999999999, 4988., 1820.4}, {4469.3, 4912.3, 1809.4}, {4468.9, 
       4790.9, 1735.8}, {4583.3, 4754.099999999999, 1677.}}, 
       {RGBColor[
        0.26327787096774197`, 0.47048051612903224`, 0.8042780322580646], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5188.8, 4520.7, 1557.4}, {4957.099999999999, 
       4814.6, 2065.9}, {4892.5, 4897.8, 2156.9}, {4758.5, 4888.3, 
       2172.2000000000003`}, {4689.7, 4799.4, 2100.4}, {4753.2, 4713., 
       2006.8999999999999`}, {4885.6, 4723.8, 1993.1000000000001`}}, 
       {RGBColor[0.28152729032258067`, 0.524952129032258, 0.7781949354838711],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5501.3, 4749.3, 2140.}, {5153.2, 4839.3, 
       2471.9}, {5162.3, 4719.1, 2406.2999999999997`}, {5046.4, 4663.7, 
       2381.}, {4954.7, 4753.5, 2433.4}, {4815.1, 4752.900000000001, 
       2438.6}, {4754.2, 4857.099999999999, 2497.1}, {4829.4, 4954.7, 
       2547.}, {4961.3, 4966.9, 2548.6}, {5018.9, 4861.8, 2489.5}}, 
       {RGBColor[
        0.30206767741935486`, 0.5760029677419355, 0.7457495161290323], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5612., 5019.400000000001, 2727.7999999999997`}, {
       5003.7, 4804.2, 2845.1}, {4866.400000000001, 4789.9, 2838.9}, {4823.7, 
       4679., 2770.5}, {4901.3, 4583.3, 2709.4}, {5043.7, 4604., 2719.5}, {
       5087.1, 4711.9, 2785.8}}, 
       {RGBColor[0.3287994193548387, 0.615007, 0.7002575483870969], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5216.8, 5094.400000000001, 
       3269.8999999999996`}, {4829.2, 4789.3, 3291.4}, {4724.4, 4713.4, 
       3237.8}, {4752.6, 4612.1, 3152.2}, {4879.099999999999, 4585.4, 
       3119.8}, {4988., 4660.7, 3173.1000000000004`}, {4958.8, 
       4760.900000000001, 3257.7}}, 
       {RGBColor[0.356959935483871, 0.651231, 0.6517548387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4747.8, 5053., 3740.}, {4646.6, 4564.3, 
       3612.8}, {4615.400000000001, 4462.8, 3521.6}, {4712.8, 4411.9, 
       3443.5}, {4837.400000000001, 4458.400000000001, 3453.4}, {4872.3, 
       4561.9, 3545.2}, {4774.6, 4611.5, 3622.2999999999997`}}, 
       {RGBColor[
        0.39180477419354837`, 0.6765738387096774, 0.5981050967741937], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4325.5, 4662.8, 4050.5000000000005`}, {4379.5, 
       4266.400000000001, 3859.1}, {4468., 4353.4, 3918.6}, {4591.2, 4341.5, 
       3875.1}, {4583.599999999999, 4240.1, 3780.7000000000003`}, {
       4680.400000000001, 4180.5, 3698.4}, {4640., 4082., 
       3615.2000000000003`}, {4510.7, 4046.5000000000005`, 3615.6}, {4410.4, 
       4094.8999999999996`, 3688.1}, {4453.900000000001, 4192.799999999999, 
       3769.7000000000003`}}, 
       {RGBColor[0.4276045161290323, 0.7003622258064516, 0.5437200645161291], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3916.2, 4090.9999999999995`, 4081.2}, {4289.6, 
       3799.9, 3921.2000000000003`}, {4298.2, 3900.7, 4014.3}, {4418.7, 
       3948.8, 4026.5}, {4494.2, 3875.7, 3935.7999999999997`}, {
       4632.099999999999, 3883.2999999999997`, 3904.3999999999996`}, {4667.6, 
       3790.9, 3806.5}, {4581., 3702.2, 3746.6}, {4452.1, 3694.4, 3775.3}, {
       4416., 3783.5, 3870.0000000000005`}}, 
       {RGBColor[
        0.47028151612903224`, 0.7154317419354839, 0.4921085806451614], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3957., 3422.3999999999996`, 3937.8}, {
       4483.400000000001, 3384.8999999999996`, 3951.5}, {4420.8, 
       3457.5000000000005`, 4049.9}, {4502.3, 3536.2000000000003`, 4115.}, {
       4626., 3514.2000000000003`, 4056.}, {4753.4, 3571.3999999999996`, 
       4084.0000000000005`}, {4852.1, 3520.7999999999997`, 
       3999.7999999999997`}, {4831.4, 3427.3, 3901.1000000000004`}, {4713.4, 
       3373.4, 3874.2}, {4616., 3421.2000000000003`, 3954.9}}, 
       {RGBColor[0.513417, 0.72992, 0.440682], CylinderBox[{2, 3}, 20], 
        CylinderBox[{3, 4}, 20], CylinderBox[{4, 5}, 20], 
        CylinderBox[{5, 6}, 20], CylinderBox[{6, 7}, 20], 
        CylinderBox[{7, 8}, 20], CylinderBox[{8, 9}, 20], 
        CylinderBox[{9, 10}, 20], CylinderBox[{10, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], SphereBox[8, 20], 
        SphereBox[9, 20], SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4319.3, 2916.9, 3754.}, {4864.6, 3101.6, 
       3998.1000000000004`}, {4973.7, 3158., 4061.1}, {4944.3, 3221.7, 
       4179.099999999999}, {4820.7, 3234.5999999999995`, 4239.}, {4710.7, 
       3172.9, 4167.6}, {4737.7, 3110.4, 4052.6000000000004`}}, 
       {RGBColor[
        0.5620539032258064, 0.7370415483870968, 0.39831090322580653`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4961., 2681.2999999999997`, 
       3654.0999999999995`}, {5113.4, 2761.4, 4128.4}, {4979.9, 2731.1, 
       4114.}, {4901.3, 2797.9, 4195.1}, {4988.7, 2877.6, 4267.7}, {
       4967.799999999999, 2971.2, 4369.9}, {5076.1, 3033.2000000000003`, 
       4421.200000000001}, {5196.7, 3002.1, 4372.5}, {5229.3, 2916., 
       4276.8}, {5119.5, 2856.2999999999997`, 4227.7}}, 
       {RGBColor[
        0.6107925161290322, 0.7436816451612903, 0.35667119354838717`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5472.7, 2386.9, 3925.7}, {5284.400000000001, 
       2625.4, 4498.9}, {5259.599999999999, 2735.2, 4582.4}, {5131.6, 2770.9, 
       4608.3}, {5031.1, 2701.6, 4554.6}, {5053.4, 2589.3999999999996`, 
       4469.5}, {5180.299999999999, 2555.2, 4444.400000000001}}, 
       {RGBColor[
        0.6610567741935485, 0.7430999677419354, 0.32600229032258066`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5751.5, 2396., 4567.1}, {5432.7, 2599.7, 
       4922.2}, {5330., 2661.9, 4990.2}, {5204.6, 2618.6, 
       4955.400000000001}, {5172.6, 2522.1, 4862.3}, {5283.700000000001, 
       2461.6, 4795.5}, {5406.900000000001, 2502.7000000000003`, 4827.5}}, 
       {RGBColor[0.7108129032258065, 0.7412082258064516, 0.2966935806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5920.1, 2591.9, 5155.}, {5470.3, 
       2566.7999999999997`, 5350.2}, {5526., 2481.4, 5259.}, {5438.3, 2413.7, 
       5189.6}, {5316.5, 2457.6, 5238.1}, {5184.8, 2424.2999999999997`, 
       5204.7}, {5085.6, 2486.4, 5271.8}, {5118.5, 2575.9, 5366.}, {5238.8, 
       2615.5, 5406.2}, {5334.599999999999, 2552., 5337.3}}, 
       {RGBColor[0.757012129032258, 0.7301460322580645, 0.27690622580645163`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5697.9, 2712.1, 5783.5}, {5241.599999999999, 
       2455.3, 5699.4}, {5355.9, 2408.2000000000003`, 5640.3}, {5333.8, 
       2322.6, 5543.6}, {5195.4, 2312.7, 5538.8}, {5108.5, 2238., 5457.5}, {
       4975.4, 2251.2, 5478.7}, {4934.1, 2334.3, 5575.3}, {5005.9, 2409.5, 
       5657.9}, {5137.5, 2393.9, 5634.2}}, 
       {RGBColor[
        0.8012228387096773, 0.7162818387096774, 0.25848077419354837`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5216.299999999999, 2672.2999999999997`, 
       6206.8}, {4910.2, 2198.7, 5901.8}, {4844.8, 2119.1, 5805.7}, {4919.2, 
       2045.2000000000003`, 5719.9}, {5052.8, 2048.5, 5727.4}, {
       5121.099999999999, 2128.1, 5823.599999999999}, {5047., 
       2200.7999999999997`, 5907.7}}, 
       {RGBColor[
        0.8368166451612903, 0.6902756451612903, 0.24595690322580643`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4641.8, 2330.7, 6365.3}, {4697.3, 
       1820.4999999999998`, 6041.7}, {4704.8, 1725.5, 5937.5}, {4824.5, 
       1702.9, 5877.5}, {4933.1, 1770.1000000000001`, 5917.3}, {4928., 1866.4,
        6022.4}, {4809.7, 1888.2, 6081.}}, 
       {RGBColor[
        0.8683509677419354, 0.6594232580645162, 0.23398051612903226`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4310.5, 1801.3000000000002`, 6421.7}, {4588.8, 
       1451.3, 6238.2}, {4640.7, 1548.4, 6320.6}, {4765.8, 1578.3, 
       6294.400000000001}, {4798.299999999999, 1495.5, 6187.7}, {4916.5, 
       1478.5, 6112.9}, {4914.9, 1387.2, 6012.8}, {4802.1, 1318.6, 5990.3}, {
       4685.5, 1325.6, 6053.6}, {4690.2, 1416.9, 6152.2}}, 
       {RGBColor[0.8877068387096774, 0.6140322903225807, 0.2236465806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4162.8, 1136.3, 6373.299999999999}, {
       4585.900000000001, 977.6, 6221.5}, {4556.4, 1077.6999999999998`, 
       6311.}, {4658.1, 1156.1, 6335.6}, {4761., 1104.8999999999999`, 
       6257.5}, {4895.4, 1148.4, 6242.4}, {4965.599999999999, 1068.2, 
       6152.900000000001}, {4913.4, 959.8000000000001, 6086.6}, {4788.5, 
       918.2, 6099.900000000001}, {4718.3, 994.9, 6186.3}}, 
       {RGBColor[0.9013106129032258, 0.562041806451613, 0.21258587096774198`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4383.1, 510.1, 6192.6}, {4865., 570.6, 6215.2}, {
       4769.599999999999, 628.5, 6295.3}, {4816.400000000001, 
       725.9000000000001, 6368.4}, {4950.9, 733., 6334.400000000001}, {
       5052.900000000001, 819.6999999999999, 6381.2}, {5175.099999999999, 
       792.6999999999999, 6320.4}, {5196.200000000001, 694.9, 6226.5}, {
       5101.9, 613.6, 6182.099999999999}, {4982.4, 638., 6239.9}}, 
       {RGBColor[0.9022597741935484, 0.4955323870967741, 0.1999262580645161], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{4771.3, 53.7, 6009.}, {5175.7, 344., 6392.3}, {
       5253.6, 428.7, 6471.9}, {5192.799999999999, 514.5, 6555.9}, {5059.9, 
       518.1, 6563.}, {4977.8, 433.3, 6483.700000000001}, {5038.900000000001, 
       348.5, 6400.3}}, 
       {RGBColor[
        0.8980634516129032, 0.42284993548387095`, 0.18591083870967742`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5431.7, -98.9, 6221.7}, {5479.9, 194.9, 6680.}, {
       5480.299999999999, 305.2, 6765.4}, {5363.5, 352.5, 
       6813.200000000001}, {5249., 294.09999999999997`, 6778.700000000001}, {
       5245.1, 181.4, 6691.800000000001}, {5361.8, 135.5, 
       6645.099999999999}}, 
       {RGBColor[
        0.8852913225806451, 0.33987909677419365`, 0.1696357419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{5921.3, -94.6, 6644.400000000001}, {5694.2, 94.3,
        7062.3}, {5616.400000000001, 184.60000000000002`, 
       7136.700000000001}, {5481.8, 183.7, 7122.1}, {5424.3, 97.7, 7037.7}, {
       5500.7, 4.8, 6960.9}, {5634.1, 6.6000000000000005`, 6975.9}}, 
       {RGBColor[
        0.8734219677419355, 0.25660432258064536`, 0.1540787096774194], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{6202., -44.800000000000004`, 
       7233.499999999999}, {5898.299999999999, 104.1, 7498.}, {5916.1, -6.1, 
       7418.2}, {5804.2, -54.1, 7371.599999999999}, {5706.6, 
       29.799999999999997`, 7423.3}, {5566.599999999999, 27.3, 
       7407.200000000001}, {5505.1, 130.29999999999998`, 7476.7}, {5570.4, 
       223.70000000000002`, 7552.299999999999}, {5701.400000000001, 227.2, 
       7568.300000000001}, {5762.9, 128., 7501.3}}, 
       {RGBColor[
        0.8627133225806451, 0.17293877419354836`, 0.13944490322580644`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}]}}, {
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eGk4Ve37tqRBUkgRyVRJQjITzodmJRXKLOFBhTI1mfc2Zq40aET1hEqy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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {13, 14, 18, 17}, {3, 4, 8, 7}, {5, 6, 
           10, 9}, {2, 3, 7, 6}, {4, 1, 5, 8}, {6, 7, 11, 10}, {8, 5, 9, 
           12}, {11, 12, 16, 15}, {12, 9, 13, 16}, {9, 10, 14, 13}, {7, 8, 12,
            11}, {29, 30, 34, 33}, {14, 15, 19, 18}, {16, 13, 17, 20}, {15, 
           16, 20, 19}, {18, 19, 23, 22}, {20, 17, 21, 24}, {17, 18, 22, 
           21}, {21, 22, 26, 25}, {22, 23, 27, 26}, {23, 24, 28, 27}, {25, 26,
            30, 29}, {10, 11, 15, 14}, {26, 27, 31, 30}, {24, 21, 25, 28}, {
           27, 28, 32, 31}, {28, 25, 29, 32}, {30, 31, 35, 34}, {58, 59, 63, 
           62}, {33, 34, 38, 37}, {35, 36, 40, 39}, {34, 35, 39, 38}, {43, 44,
            48, 47}, {32, 29, 33, 36}, {36, 33, 37, 40}, {37, 38, 42, 41}, {
           41, 42, 46, 45}, {31, 32, 36, 35}, {42, 43, 47, 46}, {38, 39, 43, 
           42}, {39, 40, 44, 43}, {19, 20, 24, 23}, {44, 41, 45, 48}, {55, 56,
            60, 59}, {48, 45, 49, 52}, {50, 51, 55, 54}, {49, 50, 54, 53}, {
           45, 46, 50, 49}, {47, 48, 52, 51}, {51, 52, 56, 55}, {52, 49, 53, 
           56}, {56, 53, 57, 60}, {46, 47, 51, 50}, {57, 58, 62, 61}, {53, 54,
            58, 57}, {54, 55, 59, 58}, {241, 242, 243, 244}, {59, 60, 64, 
           63}, {61, 62, 66, 65}, {73, 74, 78, 77}, {63, 64, 68, 67}, {65, 66,
            70, 69}, {62, 63, 67, 66}, {66, 67, 71, 70}, {67, 68, 72, 71}, {
           68, 65, 69, 72}, {70, 71, 75, 74}, {64, 61, 65, 68}, {71, 72, 76, 
           75}, {69, 70, 74, 73}, {72, 69, 73, 76}, {88, 85, 89, 92}, {89, 90,
            94, 93}, {76, 73, 77, 80}, {75, 76, 80, 79}, {78, 79, 83, 82}, {
           80, 77, 81, 84}, {77, 78, 82, 81}, {81, 82, 86, 85}, {82, 83, 87, 
           86}, {83, 84, 88, 87}, {85, 86, 90, 89}, {74, 75, 79, 78}, {86, 87,
            91, 90}, {84, 81, 85, 88}, {87, 88, 92, 91}, {40, 37, 41, 44}, {
           90, 91, 95, 94}, {109, 110, 114, 113}, {103, 104, 108, 107}, {93, 
           94, 98, 97}, {95, 96, 100, 99}, {92, 89, 93, 96}, {96, 93, 97, 
           100}, {97, 98, 102, 101}, {98, 99, 103, 102}, {100, 97, 101, 
           104}, {94, 95, 99, 98}, {101, 102, 106, 105}, {99, 100, 104, 
           103}, {102, 103, 107, 106}, {60, 57, 61, 64}, {91, 92, 96, 95}, {
           106, 107, 111, 110}, {105, 106, 110, 109}, {108, 105, 109, 112}, {
           110, 111, 115, 114}, {107, 108, 112, 111}, {111, 112, 116, 115}, {
           112, 109, 113, 116}, {113, 114, 118, 117}, {115, 116, 120, 119}, {
           104, 101, 105, 108}, {116, 113, 117, 120}, {114, 115, 119, 118}, {
           117, 118, 122, 121}, {118, 119, 123, 122}, {119, 120, 124, 123}, {
           120, 117, 121, 124}, {123, 124, 128, 127}, {125, 126, 130, 129}, {
           124, 121, 125, 128}, {133, 134, 138, 137}, {122, 123, 127, 126}, {
           126, 127, 131, 130}, {127, 128, 132, 131}, {131, 132, 136, 135}, {
           177, 178, 182, 181}, {132, 129, 133, 136}, {128, 125, 129, 132}, {
           129, 130, 134, 133}, {130, 131, 135, 134}, {134, 135, 139, 138}, {
           145, 146, 150, 149}, {138, 139, 143, 142}, {140, 137, 141, 144}, {
           139, 140, 144, 143}, {135, 136, 140, 139}, {137, 138, 142, 141}, {
           141, 142, 146, 145}, {142, 143, 147, 146}, {146, 147, 151, 150}, {
           136, 133, 137, 140}, {147, 148, 152, 151}, {143, 144, 148, 147}, {
           144, 141, 145, 148}, {178, 179, 183, 182}, {148, 145, 149, 152}, {
           150, 151, 155, 154}, {153, 154, 158, 157}, {154, 155, 159, 158}, {
           156, 153, 157, 160}, {152, 149, 153, 156}, {155, 156, 160, 159}, {
           157, 158, 162, 161}, {162, 163, 167, 166}, {159, 160, 164, 163}, {
           163, 164, 168, 167}, {160, 157, 161, 164}, {158, 159, 163, 162}, {
           161, 162, 166, 165}, {149, 150, 154, 153}, {164, 161, 165, 168}, {
           174, 175, 179, 178}, {167, 168, 172, 171}, {169, 170, 174, 173}, {
           168, 165, 169, 172}, {151, 152, 156, 155}, {166, 167, 171, 170}, {
           170, 171, 175, 174}, {171, 172, 176, 175}, {175, 176, 180, 179}, {
           165, 166, 170, 169}, {176, 173, 177, 180}, {172, 169, 173, 176}, {
           173, 174, 178, 177}, {79, 80, 84, 83}, {179, 180, 184, 183}, {219, 
           220, 224, 223}, {182, 183, 187, 186}, {184, 181, 185, 188}, {183, 
           184, 188, 187}, {192, 189, 193, 196}, {181, 182, 186, 185}, {185, 
           186, 190, 189}, {186, 187, 191, 190}, {190, 191, 195, 194}, {208, 
           205, 209, 212}, {191, 192, 196, 195}, {187, 188, 192, 191}, {188, 
           185, 189, 192}, {189, 190, 194, 193}, {193, 194, 198, 197}, {204, 
           201, 205, 208}, {197, 198, 202, 201}, {199, 200, 204, 203}, {198, 
           199, 203, 202}, {194, 195, 199, 198}, {196, 193, 197, 200}, {200, 
           197, 201, 204}, {201, 202, 206, 205}, {205, 206, 210, 209}, {195, 
           196, 200, 199}, {206, 207, 211, 210}, {202, 203, 207, 206}, {203, 
           204, 208, 207}, {180, 177, 181, 184}, {207, 208, 212, 211}, {121, 
           122, 126, 125}, {212, 209, 213, 216}, {214, 215, 219, 218}, {213, 
           214, 218, 217}, {222, 223, 227, 226}, {211, 212, 216, 215}, {215, 
           216, 220, 219}, {216, 213, 217, 220}, {220, 217, 221, 224}, {210, 
           211, 215, 214}, {221, 222, 226, 225}, {217, 218, 222, 221}, {218, 
           219, 223, 222}, {209, 210, 214, 213}, {223, 224, 228, 227}, {234, 
           235, 239, 238}, {227, 228, 232, 231}, {229, 230, 234, 233}, {228, 
           225, 229, 232}, {224, 221, 225, 228}, {226, 227, 231, 230}, {230, 
           231, 235, 234}, {231, 232, 236, 235}, {235, 236, 240, 239}, {225, 
           226, 230, 229}, {236, 233, 237, 240}, {232, 229, 233, 236}, {233, 
           234, 238, 237}, {245, 246, 247, 248}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Pk/1HkcB3BJD7ctGR0KQ5mSctXSJG8eJLZYWbeoHLWmsRVdZklZNTSu
yBHJUQw1Jkqx+s4wbirmxrhtjpqtjYlIx/ZHfPrh9cvzp9dPrx9e+OBTHmHy
cnJyC9+z/Ht8t9hL8XVDcLBGm06ZeQY7GT0RPRpjgMojpJRMIXkI7gVbrlGW
xyBnOJyOM0Xn6+at6s11hqAhS0H182oMjGecJJoe6LyIGdTzsXsQau5MX2Jv
wiBFY3U0OxKd2zmXVNokDAK/ltRpsguD0VhQastA5+e3hquYWA5CtVdxzjcn
DIJfMtMTnqDzxLpbXglTA3Cy881EsQ8GTwjqV2dE6NwszVWPmjUA05zp2vJw
DKyCmZG4RXQ+66T7SGnfACR3JRwN+BODincP3bN0xpF5GsPXUrYoAdUKy6Qh
GgbSq0V5zXvQeZOftmViuQRc1XJ2tRRgEPhFMFQehM65NXvx1w5LIHyfejCF
iUFh3HyyTRw6X3h/pU9eUwKMVHzYIBsD7m/RJiaF6Lz2rIuGMacfHh9+Iy3h
YmChBK18Djp3L6NY1J/rh0y5tlnrMQxC2mWdhHF0flnPVPTBsB+stnrHWsow
aDkubbdc8Q8y74qWs2cK+kA+OGG4X4EFOF+Hp/kEdP7uyp58bmIf0E+3NvyK
Y8HPntdXPtqPzit4i1EFVn3wk8KzTcYEFlDNtELjSOjcrge/RyDtBY+IZmWh
FQvoa1IMl66jc7LWy8uPb/WCT8DlyHEXFiwMOw9uZ6LzR8SsNE2XXkjwG6i+
HcAC64XQqxgXnQs12pMlX8RA2+5yxojMAucNp/MW36NzmnGMkitDDF7XTtZo
XWJBoj67/O3qV8hc90Ne5JajYvhUU3SBn8qCXNMlg/Sd6Lzrjrg0HieGNlnU
KptCFuSk56akeqJz9RtZPtQWEXjWLu1QqWZBO+/ijMMFdG5szv744aII2O7Z
L+gcFrRtdObQc9D5yFqStjpBBK//mHhbIWDBvIv/9aZ6dF45ZvH1rlgIewv4
Ez4T33ep44XD7iF07u0bJrxLE8LJYn6gaI4Fyw/tCA/6gs6ztXW2uhGFEGBM
9atVZINBPZ9K1J9A5lXxRPKxdwIwSnIT/b6WDat2HNdstUPn4/Vvb5R1CyD8
2CyBx2OD0on4foYfOjfS9o5xqBIAUenQAfkHDfDSo4mufBad78/1p7zOFIBn
9b2/BMRGSGy+FVaSjM4vbdMM3n5OAPKO50zvlzfCocBC8kE6Os+YCAuk+Aog
tiqDTvyJAytjbEIsGtG5NDwwyMdGABWUOHJHFAcMlrmdyO9D5/7fFF34GwXg
dt8uTjLKAYeHKTU4GTove+a233uZABofuwWVOTWB33jozHPVSWSumORsenGc
DxUG5rT5miaItSVdyDRC55X6kxuMW/jg+N+4giO+GebkXqkM26Fz8xE93Qk6
HxhZY78cuNYMIc5zKaF+6LyLqaZsm8QHWnHNsFjWDMN1O/0/R6Fz+9IsxSIy
H6ypQtsN/i3gzlTV5iaj8y9hTaoZ7ny42dUsDWK3gJaKz4hRKTrvtipZxFvw
gRRFndy8rRWmUrkzqQ3oPNZMd6kexwe1+ZzKsvRWqModk1n0oXN7ouvkzDwP
jIZjmh58bQXqc32YnkXnLhr6vXV9PJg1NN/EJLVBdagwR199CpmbKacNJGI8
oDlYeJB62oAXrzd6czM6N8FVd84X8OB2h2L3fZt2+NaZe2a9HTpf4XzqecQV
HlAIxtqlJe1gmF0xO+CLzmW00afxwTzgSvUZhqs6wIs2jTGj0Dkhb45OcOSB
WH0qtTC2AyST+TcVUtG5dU8ZQ0TgQbnyp72i8Q7wbp8MyC5D50dwqvl4ZR7I
SGPENPdOGOEeIe/moPOQeNWC8/9yQa0Mp7C8thOCjpwmr5Wgc8bfD+8FcLkg
sl23/qxOF5h7zkVTZtH5j/6ff3T//wFBxcwc
        "],
       VertexNormals->CompressedData["
1:eJy11/lXDfj/B3BFI8WgsmRpMIayZIRs1XPwUYYMY5mhMLapMWgZwjAzdkNM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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1WGk4lVvYjiKacIxJKUOGZGo03xIVpYg0oKRBKJJGR4Y0kbFQxr03tlns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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {4, 1, 5, 8}, {6, 7, 11, 
           10}, {2, 3, 7, 6}, {13, 14, 18, 17}, {5, 6, 10, 9}, {12, 9, 13, 
           16}, {10, 11, 15, 14}, {11, 12, 16, 15}, {8, 5, 9, 12}, {7, 8, 12, 
           11}, {9, 10, 14, 13}, {14, 15, 19, 18}, {24, 21, 25, 28}, {55, 56, 
           60, 59}, {17, 18, 22, 21}, {19, 20, 24, 23}, {16, 13, 17, 20}, {15,
            16, 20, 19}, {20, 17, 21, 24}, {22, 23, 27, 26}, {25, 26, 30, 
           29}, {26, 27, 31, 30}, {23, 24, 28, 27}, {21, 22, 26, 25}, {18, 19,
            23, 22}, {27, 28, 32, 31}, {29, 30, 34, 33}, {32, 29, 33, 36}, {
           33, 34, 38, 37}, {35, 36, 40, 39}, {31, 32, 36, 35}, {30, 31, 35, 
           34}, {34, 35, 39, 38}, {41, 42, 46, 45}, {39, 40, 44, 43}, {40, 37,
            41, 44}, {37, 38, 42, 41}, {36, 33, 37, 40}, {28, 25, 29, 32}, {
           42, 43, 47, 46}, {52, 49, 53, 56}, {46, 47, 51, 50}, {47, 48, 52, 
           51}, {49, 50, 54, 53}, {45, 46, 50, 49}, {44, 41, 45, 48}, {48, 45,
            49, 52}, {43, 44, 48, 47}, {53, 54, 58, 57}, {54, 55, 59, 58}, {
           51, 52, 56, 55}, {50, 51, 55, 54}, {229, 230, 231, 232}, {56, 53, 
           57, 60}, {58, 59, 63, 62}, {60, 57, 61, 64}, {61, 62, 66, 65}, {63,
            64, 68, 67}, {59, 60, 64, 63}, {70, 71, 75, 74}, {62, 63, 67, 
           66}, {69, 70, 74, 73}, {67, 68, 72, 71}, {68, 65, 69, 72}, {65, 66,
            70, 69}, {64, 61, 65, 68}, {66, 67, 71, 70}, {71, 72, 76, 75}, {
           81, 82, 86, 85}, {57, 58, 62, 61}, {74, 75, 79, 78}, {76, 73, 77, 
           80}, {73, 74, 78, 77}, {72, 69, 73, 76}, {77, 78, 82, 81}, {79, 80,
            84, 83}, {82, 83, 87, 86}, {83, 84, 88, 87}, {80, 77, 81, 84}, {
           78, 79, 83, 82}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87, 91, 
           90}, {88, 85, 89, 92}, {89, 90, 94, 93}, {90, 91, 95, 94}, {91, 92,
            96, 95}, {92, 89, 93, 96}, {93, 94, 98, 97}, {94, 95, 99, 98}, {
           95, 96, 100, 99}, {96, 93, 97, 100}, {97, 98, 102, 101}, {98, 99, 
           103, 102}, {87, 88, 92, 91}, {99, 100, 104, 103}, {101, 102, 106, 
           105}, {103, 104, 108, 107}, {104, 101, 105, 108}, {106, 107, 111, 
           110}, {102, 103, 107, 106}, {105, 106, 110, 109}, {107, 108, 112, 
           111}, {100, 97, 101, 104}, {109, 110, 114, 113}, {38, 39, 43, 
           42}, {110, 111, 115, 114}, {108, 105, 109, 112}, {111, 112, 116, 
           115}, {112, 109, 113, 116}, {113, 114, 118, 117}, {114, 115, 119, 
           118}, {117, 118, 122, 121}, {118, 119, 123, 122}, {120, 117, 121, 
           124}, {116, 113, 117, 120}, {141, 142, 146, 145}, {119, 120, 124, 
           123}, {126, 127, 131, 130}, {124, 121, 125, 128}, {125, 126, 130, 
           129}, {122, 123, 127, 126}, {121, 122, 126, 125}, {123, 124, 128, 
           127}, {127, 128, 132, 131}, {137, 138, 142, 141}, {131, 132, 136, 
           135}, {132, 129, 133, 136}, {134, 135, 139, 138}, {130, 131, 135, 
           134}, {129, 130, 134, 133}, {133, 134, 138, 137}, {128, 125, 129, 
           132}, {138, 139, 143, 142}, {139, 140, 144, 143}, {136, 133, 137, 
           140}, {135, 136, 140, 139}, {140, 137, 141, 144}, {142, 143, 147, 
           146}, {168, 165, 169, 172}, {144, 141, 145, 148}, {145, 146, 150, 
           149}, {146, 147, 151, 150}, {147, 148, 152, 151}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {150, 151, 155, 154}, {151, 152, 156, 
           155}, {152, 149, 153, 156}, {153, 154, 158, 157}, {154, 155, 159, 
           158}, {143, 144, 148, 147}, {155, 156, 160, 159}, {157, 158, 162, 
           161}, {159, 160, 164, 163}, {160, 157, 161, 164}, {162, 163, 167, 
           166}, {158, 159, 163, 162}, {161, 162, 166, 165}, {163, 164, 168, 
           167}, {156, 153, 157, 160}, {165, 166, 170, 169}, {169, 170, 174, 
           173}, {166, 167, 171, 170}, {164, 161, 165, 168}, {167, 168, 172, 
           171}, {75, 76, 80, 79}, {170, 171, 175, 174}, {208, 205, 209, 
           212}, {174, 175, 179, 178}, {176, 173, 177, 180}, {183, 184, 188, 
           187}, {173, 174, 178, 177}, {184, 181, 185, 188}, {172, 169, 173, 
           176}, {177, 178, 182, 181}, {181, 182, 186, 185}, {178, 179, 183, 
           182}, {182, 183, 187, 186}, {175, 176, 180, 179}, {180, 177, 181, 
           184}, {185, 186, 190, 189}, {195, 196, 200, 199}, {187, 188, 192, 
           191}, {189, 190, 194, 193}, {188, 185, 189, 192}, {115, 116, 120, 
           119}, {194, 195, 199, 198}, {186, 187, 191, 190}, {191, 192, 196, 
           195}, {196, 193, 197, 200}, {193, 194, 198, 197}, {192, 189, 193, 
           196}, {190, 191, 195, 194}, {179, 180, 184, 183}, {197, 198, 202, 
           201}, {198, 199, 203, 202}, {202, 203, 207, 206}, {203, 204, 208, 
           207}, {205, 206, 210, 209}, {201, 202, 206, 205}, {200, 197, 201, 
           204}, {204, 201, 205, 208}, {211, 212, 216, 215}, {209, 210, 214, 
           213}, {210, 211, 215, 214}, {207, 208, 212, 211}, {206, 207, 211, 
           210}, {212, 209, 213, 216}, {214, 215, 219, 218}, {222, 223, 227, 
           226}, {217, 218, 222, 221}, {219, 220, 224, 223}, {199, 200, 204, 
           203}, {216, 213, 217, 220}, {215, 216, 220, 219}, {218, 219, 223, 
           222}, {220, 217, 221, 224}, {223, 224, 228, 227}, {171, 172, 176, 
           175}, {224, 221, 225, 228}, {213, 214, 218, 217}, {221, 222, 226, 
           225}, {233, 234, 235, 236}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Ns/1HkcBvAxsSijdW42Z0JbywoVGx9Fmdb5kNRLbMkhtckmtvBSS1P0
WhLjuLE7JiKsEI1TWwxK+f0GwxzNJG3OVs5Nsv0R3y6em/fVc/FcPQanonxC
iQQCYepzNnxOnVYVn3IBg479UbemtTkQttNftaRjHFA52VttXSESg4aQqJzu
QA7oklvuVWDoXH23VeaBEAz2Tb0oI9I50LNu2FQsQOe2+4LVZgMxiNk64Fk6
woFOA8rC83/ReUWmyfFmfwwqqFFBcoaDUNS2X6dlDp3X3ClTlvHCIC4g7GJ7
2CBEHtnXVbiGziX11nXMwxgs4Bv1JksH4brpYk6NwgQyZ/wWz5o8gIF8zUZ2
9NQg5MxXv6tVR+dNx9pNRp0wuPuVH8vTYggcN2QIYrTRued+Lfg9AIMzul2F
WpFD4OJNfeRCRucvb1hQF85jUETuFw2UD8FoF77E0UDnVR9CGoeTMch7tjZ2
5O0QzFc39BaponNdwoHs4DwMbHewKA/0uJA0o8eN24zO406PFhdVY3Awbpv6
UhAX/vIXUpSU0Ln1Ip32UzsGmtGM+7IFXLCxsPYSKKBz3ui2JgkPAx+PlvsK
fC4Efy9uC5VD58rhPmnLsxhYT15Yk2zhgXwaKZhAROf9ae50ChEHoY3z1kRf
Huj5DdE4n8aRebbKQE4MCYeZkBqGchYPeg8tWIVJ0Tm1OoIwooUDC35YDunl
wWx5ZYTlCjqfuhJ8zdwIB4X1oEfVyny4Z/NY9vECOi/8ekfAIXMc/kvU637l
zgc+2aXPYw6dx7fIMor34lBU8amk5iYfks5H79afQedYrqM81wmHxqbYyZvd
fGienJGpmkDnR1LTxN4eOGT/SvpoLCuACJ786Zh36NzIuZyUG4DDliXHkzQH
AWTpMZZdR9F5qPm3vs0hOMgfJe2SJgrALz3r/bAEnfPMmSSD8zg0ha70GDMF
QP1ZN6VShM6fBlWIQy/jwDuawHZaFYDnpY8JNnx0Pnf0gnxsyuddKd7dsWev
EGicE2W9g+jcN9yZ0ZWOg+kZocfML0JwKz0eQe9H59tLrwSs5OOgXVkvKqgV
QkFxxW1LHJ1bStuuRTJw4PzxwGbTjBCOKeZ4Sl+i86tkLuF+NQ427jDiaSYC
Wo+sI+c5OncO983tYOIg8/rsh9RwEUQ0dOZGdqJzux4h3bADhzuGjYIbdBFU
qhhT7drROSOomxWM4ZDuUmgWPyKCG7QBAesJOgeFZyeGeTh4fFPksEt3GPpS
9btvtaBzo/jbrmajODRU2pe3BgxD4eDs25NMdB6v89TLexYHqmFskkPeMEhd
Vc/OP0LnsoPrL5pXcdA59Eo3uX8YXlri1Ce16JzY9megnBwbdN1bt7eqicHK
8bWiy9/ovMQ+4V6yJhv6X9Nr9x4Wg5Q0l7VMR+cE0Kj8bjsb6pjU94VxYoil
vBm3zUbnqg2PEyPt2WDv7u86Vi4GWzdZfYcUdP6Ak0/x9GJDspJ2gYgrBnUW
ScnnEjqn7vFZGzjFBo3x7B8vbpDA08vnVB6GoXPNzRqJ07FseFKe6XdOWwKN
y6tLbH90vjNDY6kqlQ0Hr6bymFYSYE1E3SFS0Plqir6dTBEb6NbLE1I3CWwt
U1de3IPO5VqJEYsP2WAxdbOvK1QCzsXKJbvM0Hn+XcOMzA425DM1bMYSJHBd
aW46iYzO38y7XfuHywb+6S3GazQJkJyI5AxFdF73vv5c7iQbVrZppodVSaB6
Rrpa9WEMmduGmxrJEPpguiM1paNTArkhxs3pE+h8XSe6fZN6H6iEG3hXiiXg
q06nNfHRuVviSmCbSR+o6dXnjS1JwNROwWSpB51/6X/1S/f/H1ftXSw=
        "],
       VertexNormals->CompressedData["
1:eJy11/lXD1gfB/Aaa2ImxlIzCGksYzAYYynvhixDlho0dhqFIcrSaMZYahrr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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eHk0Vf/3vqGiFFHKFAmlDCkZIw/RYCoqFZKSIpUIpWSMSEQUDaY7X+41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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {4, 1, 5, 8}, {6, 7, 11, 
           10}, {2, 3, 7, 6}, {13, 14, 18, 17}, {5, 6, 10, 9}, {12, 9, 13, 
           16}, {10, 11, 15, 14}, {11, 12, 16, 15}, {8, 5, 9, 12}, {7, 8, 12, 
           11}, {9, 10, 14, 13}, {14, 15, 19, 18}, {24, 21, 25, 28}, {55, 56, 
           60, 59}, {17, 18, 22, 21}, {19, 20, 24, 23}, {16, 13, 17, 20}, {15,
            16, 20, 19}, {20, 17, 21, 24}, {22, 23, 27, 26}, {25, 26, 30, 
           29}, {26, 27, 31, 30}, {23, 24, 28, 27}, {21, 22, 26, 25}, {18, 19,
            23, 22}, {27, 28, 32, 31}, {29, 30, 34, 33}, {32, 29, 33, 36}, {
           33, 34, 38, 37}, {35, 36, 40, 39}, {31, 32, 36, 35}, {30, 31, 35, 
           34}, {34, 35, 39, 38}, {41, 42, 46, 45}, {39, 40, 44, 43}, {40, 37,
            41, 44}, {37, 38, 42, 41}, {36, 33, 37, 40}, {28, 25, 29, 32}, {
           42, 43, 47, 46}, {52, 49, 53, 56}, {46, 47, 51, 50}, {47, 48, 52, 
           51}, {49, 50, 54, 53}, {45, 46, 50, 49}, {44, 41, 45, 48}, {48, 45,
            49, 52}, {43, 44, 48, 47}, {53, 54, 58, 57}, {54, 55, 59, 58}, {
           51, 52, 56, 55}, {50, 51, 55, 54}, {229, 230, 231, 232}, {56, 53, 
           57, 60}, {58, 59, 63, 62}, {60, 57, 61, 64}, {61, 62, 66, 65}, {63,
            64, 68, 67}, {59, 60, 64, 63}, {70, 71, 75, 74}, {62, 63, 67, 
           66}, {69, 70, 74, 73}, {67, 68, 72, 71}, {68, 65, 69, 72}, {65, 66,
            70, 69}, {64, 61, 65, 68}, {66, 67, 71, 70}, {71, 72, 76, 75}, {
           81, 82, 86, 85}, {57, 58, 62, 61}, {74, 75, 79, 78}, {76, 73, 77, 
           80}, {73, 74, 78, 77}, {72, 69, 73, 76}, {77, 78, 82, 81}, {79, 80,
            84, 83}, {82, 83, 87, 86}, {83, 84, 88, 87}, {80, 77, 81, 84}, {
           78, 79, 83, 82}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87, 91, 
           90}, {88, 85, 89, 92}, {89, 90, 94, 93}, {90, 91, 95, 94}, {91, 92,
            96, 95}, {92, 89, 93, 96}, {93, 94, 98, 97}, {94, 95, 99, 98}, {
           95, 96, 100, 99}, {96, 93, 97, 100}, {97, 98, 102, 101}, {98, 99, 
           103, 102}, {87, 88, 92, 91}, {99, 100, 104, 103}, {101, 102, 106, 
           105}, {103, 104, 108, 107}, {104, 101, 105, 108}, {106, 107, 111, 
           110}, {102, 103, 107, 106}, {105, 106, 110, 109}, {107, 108, 112, 
           111}, {100, 97, 101, 104}, {109, 110, 114, 113}, {38, 39, 43, 
           42}, {110, 111, 115, 114}, {108, 105, 109, 112}, {111, 112, 116, 
           115}, {112, 109, 113, 116}, {113, 114, 118, 117}, {114, 115, 119, 
           118}, {117, 118, 122, 121}, {118, 119, 123, 122}, {120, 117, 121, 
           124}, {116, 113, 117, 120}, {141, 142, 146, 145}, {119, 120, 124, 
           123}, {126, 127, 131, 130}, {124, 121, 125, 128}, {125, 126, 130, 
           129}, {122, 123, 127, 126}, {121, 122, 126, 125}, {123, 124, 128, 
           127}, {127, 128, 132, 131}, {137, 138, 142, 141}, {131, 132, 136, 
           135}, {132, 129, 133, 136}, {134, 135, 139, 138}, {130, 131, 135, 
           134}, {129, 130, 134, 133}, {133, 134, 138, 137}, {128, 125, 129, 
           132}, {138, 139, 143, 142}, {139, 140, 144, 143}, {136, 133, 137, 
           140}, {135, 136, 140, 139}, {140, 137, 141, 144}, {142, 143, 147, 
           146}, {168, 165, 169, 172}, {144, 141, 145, 148}, {145, 146, 150, 
           149}, {146, 147, 151, 150}, {147, 148, 152, 151}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {150, 151, 155, 154}, {151, 152, 156, 
           155}, {152, 149, 153, 156}, {153, 154, 158, 157}, {154, 155, 159, 
           158}, {143, 144, 148, 147}, {155, 156, 160, 159}, {157, 158, 162, 
           161}, {159, 160, 164, 163}, {160, 157, 161, 164}, {162, 163, 167, 
           166}, {158, 159, 163, 162}, {161, 162, 166, 165}, {163, 164, 168, 
           167}, {156, 153, 157, 160}, {165, 166, 170, 169}, {169, 170, 174, 
           173}, {166, 167, 171, 170}, {164, 161, 165, 168}, {167, 168, 172, 
           171}, {75, 76, 80, 79}, {170, 171, 175, 174}, {208, 205, 209, 
           212}, {174, 175, 179, 178}, {176, 173, 177, 180}, {183, 184, 188, 
           187}, {173, 174, 178, 177}, {184, 181, 185, 188}, {172, 169, 173, 
           176}, {177, 178, 182, 181}, {181, 182, 186, 185}, {178, 179, 183, 
           182}, {182, 183, 187, 186}, {175, 176, 180, 179}, {180, 177, 181, 
           184}, {185, 186, 190, 189}, {195, 196, 200, 199}, {187, 188, 192, 
           191}, {189, 190, 194, 193}, {188, 185, 189, 192}, {115, 116, 120, 
           119}, {194, 195, 199, 198}, {186, 187, 191, 190}, {191, 192, 196, 
           195}, {196, 193, 197, 200}, {193, 194, 198, 197}, {192, 189, 193, 
           196}, {190, 191, 195, 194}, {179, 180, 184, 183}, {197, 198, 202, 
           201}, {198, 199, 203, 202}, {202, 203, 207, 206}, {203, 204, 208, 
           207}, {205, 206, 210, 209}, {201, 202, 206, 205}, {200, 197, 201, 
           204}, {204, 201, 205, 208}, {211, 212, 216, 215}, {209, 210, 214, 
           213}, {210, 211, 215, 214}, {207, 208, 212, 211}, {206, 207, 211, 
           210}, {212, 209, 213, 216}, {214, 215, 219, 218}, {222, 223, 227, 
           226}, {217, 218, 222, 221}, {219, 220, 224, 223}, {199, 200, 204, 
           203}, {216, 213, 217, 220}, {215, 216, 220, 219}, {218, 219, 223, 
           222}, {220, 217, 221, 224}, {223, 224, 228, 227}, {171, 172, 176, 
           175}, {224, 221, 225, 228}, {213, 214, 218, 217}, {221, 222, 226, 
           225}, {233, 234, 235, 236}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Ps71HkUB/DBSjGJPKFtN/dZFZ7QtK4dNtKFlFVuk6SZmmIkiqZcRo1r
1NPSJkUXl+RS2IgxbvEsaUqpuZPLfL/fFq1o0rNlZeeP+OwP55fXT+eH8z7P
eY5Z5IkAhjqJRHqvKg1VpVW+CixbfAPmOXkyQYUCWgOa0/bFEYDKOzZUx+9Y
LYQ+Zk3QrscKGJrg8YGGzl3yTz8zpAqh7uAKNdunCrgy4Xx0txc6n456co7s
LwSqncx/RKoAfpISlLboPMP+0EAqUwhOsP9P90kF8KCSttQYndPkM2FruEJI
YRoeW5xXgG+U9C9PEjpnflb3HCkWQsSxLfVXyBgErvcu1Z/EkXnDnObBZy1C
4J6vsspci8HMXtvnmoPofHQs1JQqFALlbW+X9UYMIu7ruR7noXNvcHDpnRYC
Q99P44YHBtsK7MT0MnQ+wfmam6Ytgnc0w5OxARh0vOsbv5CLznscvZ3oliLQ
5PhwDQ9j8OBF8Q/OCeic+3oso8ddBHfwdR3MeAxO4qyi8Ah0fj7ohK5fiAg4
h/dQ1qZj0EvnZVZuR+dNvqnTC3EimG9+61B2FYP8RM/SLAd0bk3haIkviaCF
Uh+Vdw8D5Ucvu7zv0Xnq+8Fu2yoRzIk2CcxbMKCUbF1Q00DnupaVkppuEbwI
Nx3MeorBy6Gkr+S/MWQugxhK4IgIJr75fxcgx4DMdTjqJkTnw4ImgcUXEdxO
eCefmlLlot1cXb0DnSs3N3m/XyWG+sQIQ1jAICEygX+jAp37x3s0vnESQ3Ny
HkWyFAfT7jNDRrnonB1Rl8MIEQNHy4pUZaCa41PJrLB4dE68Eh55lCSGCrsp
I4YJDu4Wy7qyg9G52afRyupiMeRK13wJXo9Dnfm19FRA5/eWG9kvtImhTa+0
fxUVh1a1+xuUFHQeU63eSR4Tgy8eLGv1wKF52LNgLxmda359/ahHTQI33dl/
FO3C4Zb2MCtRqUDmQ4LQOhcrCex07OuPDMKBvWlxWZYEnX/7nfxRe7sEfmlk
DSojcZhyL880bEfnH/TLrl9gSmCel1zaxsJhe6FfQnQ5OjfTn/XhXZTAynB+
Qywbh2sfkn6qzUHnFl0WtOs1EpjkMi7SuDi8uvZgR+NJdB7LTGsaFEiA7MQI
1L+MQ5kJ3c81BJ3/m19g1P9BArlZ+WEPi1R3ZNltg5ot6Dw4Nu/tMT0pCGg2
NhnlOBifHdmJWaHzuZeuNb2OUoh6oXTZVo8Dz7fcS0sHnR8aHxh5HiiF/m4r
A+Dj4BPLejg7O47MjacuhdidlsIp7wdyUi8O0fEt8yFSdL7ijIbMt1AKSXTG
eLXqXufG52rXtqNzceOBToMWKXhpZTZcHsYho+dQTm85Oh9NZNUWDkkh2kfc
SZtQ7aWV7QJBDjq3t68cTVyUwrBBSsfHTzgs8SiZ8Y9F57/e6GMvmshAl345
s2sRh5R2TnpREDp/nF2y2nurDEr2DuSxdQggnCeHBtzQ+YR1qIkjXQbTT9gH
jhsS4Lpkf7nAAp0f6fCIOseVQXbn2R8tzQiwbvD299FB55ayoba0ezI4H1a1
pteGgCVh/NaamTFkXl8enrCxTwZuZ70Ud38m4GUg9bpUjM45c1epxVMyCNy8
fOLoVgJyd1GdZ/novNDtHxe6rhyaUmxG5nYTMGrWwsu4i845mzwqXtvJQbKz
qYQfQoDpDqhVZKPz+3XuxmoBcgh9FHMzmkHAHpZv5IYT6Pz2sOmMKE4ORXeu
HN4XS0DMeFiWy350fism/3NykRxI7enrfmMT8EVs27/EDZ0Ln62KK+iRwyTT
qqSUo8q1/h69GXN0zrpkkiCZkoMdh9rumkmA+pFFUpYOOv+//6v/d///AXCU
ZVw=
        "],
       VertexNormals->CompressedData["
1:eJy11/lfD4YfB/DcIsyEZYY01jRnY5nj5RoiMdcy15xpc+VeWczE15lhkaNp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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1WGk4lV3YJVOlaEKaqBAVSlIhVpOSSFSkkkQkkgpJhjJkdkbOOTiDuSKp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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNl3t8jnUYxl9maDO1cqwxS81xRQ4t59im2LQspBE5NJbzISsUsZgVc5xD
izBhiNYkhzRqTGHCIjksh1k5tBzS2XV/3u/z+Tx/fD/P7fpd133fz7PnfTch
A0Z2H1HW4/H8JcqJMsL+XV74igqioqgk/IUPvoqc+eL1E/eQ9eGsPFQg60fO
F6/1rCzuFQ+I+9H90ANcO/mS9Sd3H7lKZALQAshar0DRVrQTHcXTZMxXhZmB
eKuJqtSmV0erRv2QeJC6hghCq4rHzmqSrYKnOvfiz9zK6FXxBoHVtUQd+ljf
YFHbdU+B9K2JpzaZWtQPixCyQfQKJhPIzBp4Ta9Lpg49LPsIul3ri3riUREq
GooGnIWgmydMPCaeEE3pWZdsKFjdiB71yDVGa0TdRDxOL7s2o2dj5obhqc/s
Bq6zhuTCyJqvOT2aoDdFe0q08njfCXs3WoonRWv0psw1vQV1Mzwtqa1POFpz
Mi3QgnmmzrNsQa4Vs0N4RqHcRzgeO2tDz3BqZye7tmfn1px1QGtDti3av+I/
8b+wD047fJ083s9AB7z2WYgQUaKz6Cq64OmEFoXHvJHiGeqOnEVCFNlnyZkv
mp4xopvoLp7nLBJvNLMi0DvTx3LPkeuKLxYtmmwMWnvuKYJe3fDFMTMWr81+
gavpPUUPsPol0Zu6l4hHczLme5FsHJ6e7NKFuTHo5utDj3jq/qIfM6zvy6Iv
u8YyJ45sD3x9oDfe/mTj6eX0sOsA8Qq1nQ1E60duENowMVQMF6PImO9VMZja
fAloA8kOQRtEZjCa9RkhxojR6JZLZE4CPpv7GloimeF4EzhLBKtH4hlCz6Gu
HsPY3Tz22bfvEOe7YwT6WHZKEuPFG2IS9eviTbRR7GG7j+M6Bs94aus1AW0s
viS0kfQY5zobTTaJZ9+XZzaITBK7TKTnBGpnJ7u+JSZT29nbaBPJTkGbRGYy
2mR874ip1Oab5tLs+q5IRp8uZooZnE2jNk+qeE+kiTmuGVPJTadOpkcyuVki
BayeLd6nVwp1Gmep9J5NdgbaLOqZ5FLJmW+emEtt2flo6WKx+EAsEwvwLUSf
w9wFZNLoOdfltT6LyMzDl47m3GMKO80ntxiPzV0iMsQKMunsspSei6iXkFtI
7WTt7EN6LCW7HG0ZvhVoGegrxUdiu9ghdosvxXqRJT4Rm8hYdrVYRZ1BdjVX
67VGZFKb72M067VBbKbnKnJr8WTis7nr0NaSyXLNyERfS70OzxoyWa4e69l9
I/e2U3zFPW7As5GdtorP8dmzyBafiW3om9jb9E+pN+PJprZeW9C24LO+OZxt
QnPOsum9lZ/Fcp7LSjJb2eULV88c107buKcd1Dl4d3Ldzs9yl8f7O8J+V9jv
iV4uzy6eySVRLH4Vv/CMTP9a7BW5Yo/IE99wtgvd8dh1v9jH3N3oe2AvZ3l4
c+nlZOz6nfjW4/3umeLxfk/Y90q+OCAOiYPU5juMtp9e+a4edi3AcxDf9+KI
KBQ/iFPiR3FUHBMn0A+RO0rmML2OoRXQ8wjaEXzW9zi75LFnPmdH6V3Ibvn0
KCBTyC4nXT2Pu3ay60/sfIKzk2gnyZ4Rp5m9j+dwgDPLncVzitw5tLPUF8R5
UeLxvgfXxFVRJH72eN+Ti5zZu3IdzznmFtHDzq6I3/CcYcZ5+pzHd9njfe+K
qa+QdTzFzLzM3BI8F5h10XV2ib3MY++mvYP23uWSKeFebKebolTcEne4B9vz
hvgdrP5D3CZzlcxN1zM/zb1fd/W9QV/L2f+P/yR7jb6leG4y25lh17/JlOK9
7drxFr3+Ye4ZnlMR2TucWY8y+hu+rPAR5cRdFxPv+w==
           "]]]}, {}},
       VertexColors->CompressedData["
1:eJy12Pk31nkUB/DHkhEdJ6WpSKUYZDlo8BS54SlSGltOluxbymPfChk7SYgM
iiyPpWTS2LNEi31fk/BsPiqVLA8lmu8f8emne87rl3t/uOd97rkSDp4mztwk
EomXi0TiIWrmfh/y+O0ZKFEKPBBshyBedoPE8+0t4PLq5pdcy7QZ+FdHarzK
EYGkm0J16CA+dwuWe/excQYU93NOkV0RbGRPLNSX4PMK83Ixw+EZMJJTO3LD
HYFhumhew9/4PG0zd/XEhxngX+zKrPJAYFaXLBFhhc8Fm2lsAW46kCOimpS9
EWQORkoLqODzfQVtatp76LCNUmbh40f0rdhaYC6Iz1tzNzJNlehwsY9TuhaI
4Gz0tkJn+gQ2J7nmZ63o0eG4SEY09TqC9chT/uRafD5i7LhJsqFDc0LRWEkY
gsP6wg19Kfhc5wLZb86fDg2d41MyEQiiuCzjZN3wuX6IrOGxRDpc0rxm7RGN
wCpctVNPG5+zPOJf7M2nwx1Xb+e8OASfZPUmZcXw+Z6gjbOjdXTQsb55WCwR
QV37iG/v1zfYnEm7pf6jjw5pESIXLW4TuSG/Gq7ehc8p88qqm4gOtj7Ptd+l
IgiLSd/pmIfPtTYo/bd/Ensl1lptdBdBpYB7gEkQPu9X9utN2MWAVo5Kflwm
AgezgfN8Jvh8Laxmyl6BAVrZr3X47hO5eqeqLEQGn9d9+d0kX5cBl7w7LPQf
IHicIR9ew4XPhYITxpqsGLCy/YtUfwGCcykH31SOjWPzH91Xv7v7MuCQu3uo
XjGCvCoD7oByfB5JuRIeHs+ApWWzs5EPEVBzf8tbj8XnOcOhe3zyGKB5xqGX
txxBUJj2K10bfG4WV7azp4YBMn1TbQYVCDiHhGyN1PF5Pp9BWU0PAx4JVZwL
r0Qgt7i946AwPo+6v24exmYAbXdRzHoNgtzq5Nr/0Bg2J13scCpfZ4CuiYC6
xjMEcScLxAVb8PkOuUdR9TuZYGGecu95E4LyZhV+qQx8/qx9Xdtcjgm8ItRb
qq0IEi+vtXJT8flmvJuDlTYTzHjql6mvEEyPGy0V6uHzUcf3aZoWTBBrkBH+
3I7A88QfpVv34/PT9jFHYj2ZEFPEV6jcjSDQNWlYZXUUm/ukHr/KH8MEcmLs
d0PCPYZV3CIm8Hm2eXl3fA4TSJ/97LcQ/rX7OSerAZ8vk21XXKoIHzGgtXQh
EKbWGlU+wOdZJ1fElXqZYGmRrB5E+BVmy2n/CHzu5dIudIHNhE8OTUVHCbfj
UuVXd8HnR7hdJrb8YMLLb1zUhU4E10fPRMcY4HOVF3O0fBEWcBSqIosJ77/h
lRMqj8/d8kuOZcuxwA4ZBTgS3jpAivTfjs/niwx7blBYIKVlXbOX8PnVfJ5d
iyPY/IJEo8aCNQsUDoUaDXQg0ByZBZ1hfP657rJPgy8LPG/GvL5FuLRVmp5X
LT4fDFwv8UtkgWDqzwQK4X9VmX48lYXPkWlncVwBC6bF7eVJhAvXhljuC8Pn
MzTHv2XqWbCmNi7VSOTqd2+96HAHfC4lzrCsHGTBlU9NHn6E7yNJnkuk4POs
p/d/ZL9nwW7ZpFQlwifV3Kf+kcHnlzy0cjy52SDO3bMFtSEY0m7dZiiAz3lz
SkX7RNng6iYxkEP4V54GTtL8MDZ/O29sm6DMhg+mNsFWhD+kHigb6Mfnm3bT
BcoGbGibFPDaQXjO47SNZ0/xufFS6ZM/7dkw9SFXt/c1AsV0X9Hiu/h88aFF
4+FrbDh/t9A5inCOkdPQsSB8HjA+VJiTygbuvqZpDcJnX3D0LC3xubzkTTP/
UjYsJLaorRF3l9f0Yux1LXyumC7NS25lA3nu6GQ54ap9JCfKQXxuI8kVYv6G
DbXtSTbuhGe4BgkK8eJzP1laL2mBDaFqP8nShIvXpFCd54aw+YipokQG/yxk
a0/bT71EMDPR4OHUic/d7i1rxB+YhaWBYtcswjWKjclO5ficqdLlQiLPAkV8
eN6Y8I9P9DXjk/H5r/7P/+r5/wcfqpsM
        "],
       VertexNormals->CompressedData["
1:eJy11vlXD/j3B/AszdiFCiMiTQvZt0HjGUKWGEaMLUxZxiBFkxjLiChGNLKE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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eGc81f/7P2lQGjaZRaVkRFbzWT4tyiqkopIVZYfscQrZOxycg0OdxTGi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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {4, 1, 5, 8}, {6, 7, 11, 
           10}, {2, 3, 7, 6}, {13, 14, 18, 17}, {5, 6, 10, 9}, {12, 9, 13, 
           16}, {10, 11, 15, 14}, {11, 12, 16, 15}, {8, 5, 9, 12}, {7, 8, 12, 
           11}, {9, 10, 14, 13}, {14, 15, 19, 18}, {24, 21, 25, 28}, {55, 56, 
           60, 59}, {17, 18, 22, 21}, {19, 20, 24, 23}, {16, 13, 17, 20}, {15,
            16, 20, 19}, {20, 17, 21, 24}, {22, 23, 27, 26}, {25, 26, 30, 
           29}, {26, 27, 31, 30}, {23, 24, 28, 27}, {21, 22, 26, 25}, {18, 19,
            23, 22}, {27, 28, 32, 31}, {29, 30, 34, 33}, {32, 29, 33, 36}, {
           33, 34, 38, 37}, {35, 36, 40, 39}, {31, 32, 36, 35}, {30, 31, 35, 
           34}, {34, 35, 39, 38}, {41, 42, 46, 45}, {39, 40, 44, 43}, {40, 37,
            41, 44}, {37, 38, 42, 41}, {36, 33, 37, 40}, {28, 25, 29, 32}, {
           42, 43, 47, 46}, {52, 49, 53, 56}, {46, 47, 51, 50}, {47, 48, 52, 
           51}, {49, 50, 54, 53}, {45, 46, 50, 49}, {44, 41, 45, 48}, {48, 45,
            49, 52}, {43, 44, 48, 47}, {53, 54, 58, 57}, {54, 55, 59, 58}, {
           51, 52, 56, 55}, {50, 51, 55, 54}, {229, 230, 231, 232}, {56, 53, 
           57, 60}, {58, 59, 63, 62}, {60, 57, 61, 64}, {61, 62, 66, 65}, {63,
            64, 68, 67}, {59, 60, 64, 63}, {70, 71, 75, 74}, {62, 63, 67, 
           66}, {69, 70, 74, 73}, {67, 68, 72, 71}, {68, 65, 69, 72}, {65, 66,
            70, 69}, {64, 61, 65, 68}, {66, 67, 71, 70}, {71, 72, 76, 75}, {
           81, 82, 86, 85}, {57, 58, 62, 61}, {74, 75, 79, 78}, {76, 73, 77, 
           80}, {73, 74, 78, 77}, {72, 69, 73, 76}, {77, 78, 82, 81}, {79, 80,
            84, 83}, {82, 83, 87, 86}, {83, 84, 88, 87}, {80, 77, 81, 84}, {
           78, 79, 83, 82}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87, 91, 
           90}, {88, 85, 89, 92}, {89, 90, 94, 93}, {90, 91, 95, 94}, {91, 92,
            96, 95}, {92, 89, 93, 96}, {93, 94, 98, 97}, {94, 95, 99, 98}, {
           95, 96, 100, 99}, {96, 93, 97, 100}, {97, 98, 102, 101}, {98, 99, 
           103, 102}, {87, 88, 92, 91}, {99, 100, 104, 103}, {101, 102, 106, 
           105}, {103, 104, 108, 107}, {104, 101, 105, 108}, {106, 107, 111, 
           110}, {102, 103, 107, 106}, {105, 106, 110, 109}, {107, 108, 112, 
           111}, {100, 97, 101, 104}, {109, 110, 114, 113}, {38, 39, 43, 
           42}, {110, 111, 115, 114}, {108, 105, 109, 112}, {111, 112, 116, 
           115}, {112, 109, 113, 116}, {113, 114, 118, 117}, {114, 115, 119, 
           118}, {117, 118, 122, 121}, {118, 119, 123, 122}, {120, 117, 121, 
           124}, {116, 113, 117, 120}, {141, 142, 146, 145}, {119, 120, 124, 
           123}, {126, 127, 131, 130}, {124, 121, 125, 128}, {125, 126, 130, 
           129}, {122, 123, 127, 126}, {121, 122, 126, 125}, {123, 124, 128, 
           127}, {127, 128, 132, 131}, {137, 138, 142, 141}, {131, 132, 136, 
           135}, {132, 129, 133, 136}, {134, 135, 139, 138}, {130, 131, 135, 
           134}, {129, 130, 134, 133}, {133, 134, 138, 137}, {128, 125, 129, 
           132}, {138, 139, 143, 142}, {139, 140, 144, 143}, {136, 133, 137, 
           140}, {135, 136, 140, 139}, {140, 137, 141, 144}, {142, 143, 147, 
           146}, {168, 165, 169, 172}, {144, 141, 145, 148}, {145, 146, 150, 
           149}, {146, 147, 151, 150}, {147, 148, 152, 151}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {150, 151, 155, 154}, {151, 152, 156, 
           155}, {152, 149, 153, 156}, {153, 154, 158, 157}, {154, 155, 159, 
           158}, {143, 144, 148, 147}, {155, 156, 160, 159}, {157, 158, 162, 
           161}, {159, 160, 164, 163}, {160, 157, 161, 164}, {162, 163, 167, 
           166}, {158, 159, 163, 162}, {161, 162, 166, 165}, {163, 164, 168, 
           167}, {156, 153, 157, 160}, {165, 166, 170, 169}, {169, 170, 174, 
           173}, {166, 167, 171, 170}, {164, 161, 165, 168}, {167, 168, 172, 
           171}, {75, 76, 80, 79}, {170, 171, 175, 174}, {208, 205, 209, 
           212}, {174, 175, 179, 178}, {176, 173, 177, 180}, {183, 184, 188, 
           187}, {173, 174, 178, 177}, {184, 181, 185, 188}, {172, 169, 173, 
           176}, {177, 178, 182, 181}, {181, 182, 186, 185}, {178, 179, 183, 
           182}, {182, 183, 187, 186}, {175, 176, 180, 179}, {180, 177, 181, 
           184}, {185, 186, 190, 189}, {195, 196, 200, 199}, {187, 188, 192, 
           191}, {189, 190, 194, 193}, {188, 185, 189, 192}, {115, 116, 120, 
           119}, {194, 195, 199, 198}, {186, 187, 191, 190}, {191, 192, 196, 
           195}, {196, 193, 197, 200}, {193, 194, 198, 197}, {192, 189, 193, 
           196}, {190, 191, 195, 194}, {179, 180, 184, 183}, {197, 198, 202, 
           201}, {198, 199, 203, 202}, {202, 203, 207, 206}, {203, 204, 208, 
           207}, {205, 206, 210, 209}, {201, 202, 206, 205}, {200, 197, 201, 
           204}, {204, 201, 205, 208}, {211, 212, 216, 215}, {209, 210, 214, 
           213}, {210, 211, 215, 214}, {207, 208, 212, 211}, {206, 207, 211, 
           210}, {212, 209, 213, 216}, {214, 215, 219, 218}, {222, 223, 227, 
           226}, {217, 218, 222, 221}, {219, 220, 224, 223}, {199, 200, 204, 
           203}, {216, 213, 217, 220}, {215, 216, 220, 219}, {218, 219, 223, 
           222}, {220, 217, 221, 224}, {223, 224, 228, 227}, {171, 172, 176, 
           175}, {224, 221, 225, 228}, {213, 214, 218, 217}, {221, 222, 226, 
           225}, {233, 234, 235, 236}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Pk71HsUB/CJ69KTouLWzViyNCVLmGaQOlOIklZbtkKILkq0hzumuj1E
K6muaIoWy8iWZCvVJZMlPBHFmO93+i6RRlmirj/i0w/vX16/nHN+OM95nrM4
MGp7sAKDwaCnozidpK4vRha/EaAe16XTbCKDlcrny1mzWgGV+9tL9tr+ScCL
ok+3n7NkEBLCzdEfb0Hmr0SxOSorCBje51yyRV8GkyL9lAwMnXvXaDPcHAlw
dueFcrRlEDg1q8/nDTq3xErC2d4E2PTNLuUslIGuQ+mro3XonBdzyHUkioCE
sCdGZ+bKoOjfXPXNheg8UY16aZdAwIXsuPhsJRmMksn33grROf9iK09ygYCo
el7PkzEc7M9wHkSko3P58naPlUICZui2hWvQOJy/9zTHLgmdr5Q77fQvJqDU
89pTxz4cvCJq9/TGo3P2LVNvaT0B1scDtY+8wYGVwE/65yA6V4gXOPE6CPhw
ImCt4CUO0eyyGKW96NwherR1AzZdt8w8vakSh6rIJs8nvuh8nWuPt+gbAbu6
p4Y0C3FQG8sRntyKztU9LFvo30m436Mwz0aIQ4++vEjdEZ1fWz9hf3ohCc8a
lLl+aTiIbiguK7BG5xmu793Ey0hIGXx3ruosDoIb3zJOmaDzUL7VdtKGhLhh
PH/0JA7tq33EZovR+efMCdc9LiTYfRhusTyAw3IzQZhEA527EJacEh8SmA+s
qpyCcZiq0fkvdCY6363VywyIIEEcEJvn54VD4drvOkPjzcicDBJmVcaRYLb1
tLjQBYcAtbhsfj86d+juVqdTSChmvi5/Bzio6knvVjSic29rQfzRLBKU2zXv
qFjh8Ox1299KD9E51Gd294jI6bt22UeNhUNs7e0PI9fQeUZIR9unWhLucST2
27VwMKpeZeElQOeFn082+LSRkD1obp42BwfJTh+3ln3o/PLd9LybEhKqBSUD
xQo4XLX2n6Tc0Dnb2SCFNzI9l5LN9bavGPiWErFMO3S+8UejaqoSBQ7VyQJT
AgPtNbYDtQbo3FwycLhYk4Lf3RdwA3sx6JoZ2aEyG50350f2s1kUXOnMptNb
MBAeNM4IHnmNzHm54dxkLgXOnKB9ufUY7NFr7A/uReeG5XzjC04U5IvlWvJH
GCzpMtPpfoHO6wtUmXIvCvq2TC9DHgYj5kyToAJ0zm5XnjAOo8Ba5LIpJAuD
yga6OjUdnQf0x3TWHKPA7/u8pnOXMEiZsd6gNQ6d+zJ33DROoiDXcK5m6hkM
fE7wVctC0bk4wlXJ/joFwlPvU5uOY8BSFBBztqHzxKGvV1/mUpAy003XKAwD
qzoxsWQVOu/0chkRiijQM+rP9XPDYGnmVKHtUnTO8fqyYM1jCsaY5/W7VmPg
uYm1vGI+Oh+/Hxz54BkFpR6B+VUsDML+SNmR/lOMzJ8XSvIONVFgesrLU2c+
BiXZO+400+j85sai4p8dFBCp++V1k1Kw+TEvL/otOk9MP3sLf0/BrtS8gn6Z
FEa1LHqinqPzRq5ZfZaMgscts46Fv5FCmntyRdNDdM6MNCxYOEyB/2Ayl1Ml
hYO7+10uZ6LzYx6GCYPjFFQwLDXi7krhtMkV5bIkdI63xy7iK9Kwc2hMonJR
Ch0N646sO4zOH+Zckn1UpUGiO1A3eVwKyommaWZB6PysceWNfE0aDByHa/4K
lcKBqUO9MVvReaQDe9EKXRrur18s0t0mhQUbHncZ2aFzf/XyePWlNHy0i63Z
bCeFL+6+P1csQ+fe0Un5BRY07FejamuNpKDKHuvK0UDnj1gmc/RW0dBrIGi7
riYFFbPWgBMMdK6X2ukxZE8Dw3StonxiAGwJlfl5n5qQ+a/+r/7q/v8HbrNT
hA==
        "],
       VertexNormals->CompressedData["
1:eJyt1/k3FmgbB3Cakva0kJQWM2nzltTbPt9pT2OG0TZKe9MeWmlBmzYtk1aa
srRJSCWpSd8QJZNdZOehB4/HU0qbqV5nnmv+g/c+5z73Odf5nO9P93b1Wuxs
/1sTHR2dmsb5TeM0q5nm19m+DHu/3/OTY0Ehf8y9cvW1TwUUFcucLYaXM3bJ
hCs/p1RSR4Z4iod4iod4/Osris+2n9ROgS/bvEvjKouo3mztN+RgOSyPt3r6
aJOCg4vnzItYVEVLqx5xGRcCKJ7iIZ7iIR7icWhs965W5yswY8LmSwNml7JH
VdVnr6/F0N2ik7HwroLpH412BQ2uYmudhxZvM05QPMVDPMVDPMRD96rm7q5X
5TCivsfUSiVPqoJDbCtjsK5HcO/VC5QMcPLcXXCrjOEvjEKb+D//11M8xFM8
xEM8F6uMurxKzcX3nx/+NamZmmWeGbG9eiawrI2Vh01pKQtqXUuGVeXw6i9b
Q1xvKCGe4iEe4iEe4ukQ6PF6jU0CBjYMMndLU/PUtRfeHUKyqH6RVRG2sYTR
2al2lT1zGJH//beXFZUQT/EQD/EQD/EMnXLraXhgON9ODvd59bqad74sqo00
L6X/uW/65Ke+pGbD0E45D7P5y3bb2F6BCoiHeIiHeIiHeDpGHNu/uDaJPpEt
kltMruDbm1k1E5so2bd1j5Y6p1WsdzE5tLb9M3Z0Sn4e2lAA8RAP8RAP8RDP
OrON3x3sm8krJdZHkrqWcodGNzBsWhU9vxmbPNWnikFRUb63P2XSUqfArNql
BOIhHuIhHuIhnpM67spyPpbL62rd0Q0Tirhl2avIdo37PePm3HM97hZxt1nn
qROHlXNq8o9LjbcrIB7iIR7iIR7iOWS1l16WQQ57pZh52j0qYk7drlTrE1Xs
pHPXapzjQ244Mq/VVodq6vqs6FgdUYqBWo9xWo80rUcrrYeb1uPDsX8851ze
Xfzg8mMqvKbg5pMSBuxL2bX3TDW728+O6OfzJ5c0d2j4/XA1U67Y3VZ7lUI8
xEM8xEM8xHPQkHeHf46Og1q/oLh+RDl3OvqPSJpTyfJpx2MyDXP4Q8jWgrPf
VLK10aA1V6NLIZ7iIR7iIR7iee9QnxGmQfkYf+h1cNvG89oipYup3qsSatal
WQx/W8b7T1f6W+2qYEyRW4aFcwHEUzzEQzzEQzybBh0Y67+4AnVcq2err+TT
KXkLTNs9oWHYwtnZgxUs7Z5t92lzBW/X/57/szof4ike4iEe4iGe99/Z2Pf7
oMLHhe1LS0tzmGoTfGFLVSY6lR/dt/FjETvcvGVs6Kfgli4bhjl/VUA8xUM8
ryv+8ci48Y9HgdZz273T9UXjVHj7/K+Trtfccbr9r/qj40vg5+65+kJUIadY
N0zc/6mAeU6jOj+ZWwnxFE/xFA/xEE/3xNaprhEqtO+Z+WD5wQuc0K3bszd/
FyM2O9Rh1uYCdtL/9PXs6RL6Jm1vlTpfCfEUD/EUD/EQT/+9od+6BasRomcc
mbUwnXWemU8zfNMwR/9Ov8K/c5h1uUOIY/xLJg2zCLyop4B4iod4iod4iKee
6eaEVxtr8OAP1yW1LwuYu3Wkr+vhm3S42DlgxM4cBnfoNGr5ySo2t6pRJq8u
gniKh3iIh3iIZ3LLhpm92yhBI2sbm2sK+iknrdt4LIubfIr7bO+SyasbOy/o
MfAl19f1nb5QtwLiKR7iIR7iIZ7GtUknv1oV4Uig3fRLje/g/fl7zP9c8YLZ
z7vfyEw4B+v4OZdtq/PpZepwKO1xDcRTPMRDPMVDPGv7e44zb5mHUcHTVGnu
1Xz/uvTDqahcVr+1S7+3OgutoxfH/mqSzsjUHNPzXdQQT/EQD/Fsq/UQz7qY
AWZl/goY5U/94VhgBde8KFt3p08eF85w0Zu/KBMjjXvout9K57qVvb0XDlLj
rdZTPJy0HuIpHuKZZXEnZMFSNZar4Oq3LYOO0X3jRlinc5NbXlrXmw9RsMPZ
cpZJPreMwkm/6zUQT/EQD/EUD/Hs/zT1RGWFBrNmHZneO+EafFz8l36tDePi
lhqnIMNIDH3rZJ/cr5TOq67WtymvhnjenPmPp3gs0HqO0Xqs1nrqWC6wDV2m
gVNUwebowCdwWebxW6aLOz6o3/Wc4XwLjzrHr8nS5NHu0R86X2tqIJ7iKZ7i
KR7iubSD98txzTXodvfK8J2jU2Hfss1pn8e/Y/rYXOd+d/xwavmnmI4xCWyY
aNWz/14NxFM8xVM8xUM8f9x2ZMq7CDW+brFtbpCfg2XRs/Kihh/AUpXO0yte
p+k9ReG28cEZrPU93mN9gwbiKZ7iKR7iKZ6Ja1/MXeFYiS6GSecusxyf+g6c
M/6BG1dFj/ncsCmAMQ51kcmGwfg7NH18RJ0G4ime4iEe4imeLYbvG1m/Jx9h
0E1OVtSgr6OzerDddhQ8vxhsUnEGr8LCrx6+cZx55/z6tf9bA/EUT/EUT/EQ
T/eY88Yzm4Ri3AaHQ7VlGjytz4v9tCACkecHNl//6SG8eycazO52kz7GvinK
IA3EUzzFUzzFQzzH9LcPSJ6TxcBOHiV7ktWN/+r9t3ILE5E/ySw8/UgmzN6X
936muMW1i9aldJ1fC/EQT/EUT/EQT/2AN9U2Lgru2Wiumj1YiS3dw7cbZmZh
/OykS93WFGJq+AjbKjtvTjMd1nTQqhqIh3iKp3iKh3j2Mjh2tKhZFVfvnPR6
9+AilEU1fI3omIfzH9oeallRAPOMNZErz5ziqoQEn5neNRAP8RRP8RQP8RzV
vevTw3a1fPP5qfeopXE4rJxpNfKXDNzeNCDrYFISBvl51jo65NO7KqdV76E1
EA/xFE/xFA/xTG1WVuXeuE93n4gbdjR0D3Z2er7kuEUATqv66U1b6gpDn8/P
6xxqOH/nxKEGYYUQD/EUT/EUD/FcX7jXccQXDe+aTv98qngl+zvuNuxmfJJN
c6xKrDcvZFVITte2TTXcoprzvsAzFeIhHuIhHuIhniv+uz9+eRMNez5L2ffC
JhGtckznjlyaCFfVFku3P/Zx8ciGjzeuKWkZ8t4odV8FxEM8xVM8xEM8lVN/
q1ClqLgjavqOdHUhWv7HQLn1xiNYrLwe892yRIzIaNW5abOjNPjvdcuLOzQQ
D/EUT/EUD/H0W9bJNmymil+nv/9OV1WMgvMeW++mxaF3Urutb2Zkwdb++8wL
d9KR65txZkhjvyUe4ime4ime4vnjPK/V+VG1tPAwGfRD2TPoNfsSaq2Oh5H9
2CM25+KxIDvQ+rHjOWbXhZ96frbxftN6iKd4iqd4iOe9bqdHn32p4fzrBbXH
boaznVfDup86h5CqWPM0b3cO3t9x/qblZVyumFf+s0U1xGOG1kM8xMNS6yGe
X1ycLmoGapg2YYqn0dxHXOnb7Fc7t0dccfTdoenue6DxS/SKuqikx9qMlNCj
FRAP8RAP8RQP8bw6t8PE1rM0nPrn414rw2LZuqp/RNuGOOo8O+ARaXede3tH
Wmhii/lq04rsoCgVxEM8xEM8xEM8i9frf9gZoOHQFi829S8OZsNf+XYvXeOY
V9k6q6VxHDe5ZHff/SGM93RvH93tr4F4iId4iId4iGeP6rt817h+CXP7Mmnd
adyzuRE5zD6eD+bfXOX4KY62Ow8ccdp/B15N64cs3qWBeIineIiHeIpni6AE
3aMHNOxlZJ31pjQa3ifGBHnHxxIfbCrDDsZz+mWTw5Nj4qk7M31C8pjG90Xr
IZ7iIR7iIZ7j1HoDLu/UUHMxI/rORMLkTcx3f+g/5JEXoz+3OpDAc/4Now3v
F3L1iUszm2eoIB7iKR7iIR7iOWWuU09rDw1dfIs8z3W+BP0N+1eMNEjkxQFI
aMMEfiww7bkssZjdDizP2DFWBfEQT/EQD/EQz9U+x741Da7lhYTdrROqknhh
k1VCeUMS2znOGt7PN5FHf9/dPLlzHBeZbBidNkAD8RAP8RAP8RBPs5pHrv36
19B4nt4Fy9RC/hR9i6ab73BaR+Oaj2fSuLbviIvbczPRsczpcfZENTpoPRy0
HtB62Gk9zLSePbSe7mcsjgx2UHKr2/hO9SEVtNhRdWXslmj0q75+7MGZbN7b
0NfczrcIa1Qe3VLrqiAe4iGe4iGe4qnua77IPjetsS/q8+dzq8a+atK2UxWW
heg1qvmQXtW57NmxHqnPS5D35ESgpWUlxEM8xPOa1qOd1jNO69lmfVWHTJNk
mHsaOSbMUvKqvfUbpJcjeOaq0tF3G/vovrfeDcgrgXPyiTydFUqIp3iIp3iI
p3jO7+720O1wMoxD93bYN1nJyJM/re2aVw7L+4lB2wxKOGLNo3qFQzH8es8y
GZTyEuIpHuIpHuIpnpMk30LyAyW/j+RvlvxDki+e4iGe4iGe4vlwiWKkzd0S
BORO3txpfD6DTLoYWAcp/2/12EBDryXPqhG0MtxlalwRWiRf+o9DQBr+X/X/
AR3s9Cg=
        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1eGk81N37v32NIltZWhG+qChCuVAULSQUoixliexFYTDGPsbMMDvz+Ywp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       "], {
        {EdgeForm[None], 
         GraphicsGroup3DBox[
          Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {3, 4, 8, 7}, {4, 1, 5, 
           8}, {11, 12, 16, 15}, {5, 6, 10, 9}, {7, 8, 12, 11}, {6, 7, 11, 
           10}, {9, 10, 14, 13}, {10, 11, 15, 14}, {49, 50, 54, 53}, {12, 9, 
           13, 16}, {14, 15, 19, 18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {17,
            18, 22, 21}, {18, 19, 23, 22}, {19, 20, 24, 23}, {20, 17, 21, 
           24}, {21, 22, 26, 25}, {22, 23, 27, 26}, {23, 24, 28, 27}, {8, 5, 
           9, 12}, {13, 14, 18, 17}, {24, 21, 25, 28}, {26, 27, 31, 30}, {31, 
           32, 36, 35}, {28, 25, 29, 32}, {29, 30, 34, 33}, {37, 38, 42, 
           41}, {30, 31, 35, 34}, {36, 33, 37, 40}, {32, 29, 33, 36}, {34, 35,
            39, 38}, {35, 36, 40, 39}, {38, 39, 43, 42}, {39, 40, 44, 43}, {
           46, 47, 51, 50}, {41, 42, 46, 45}, {42, 43, 47, 46}, {27, 28, 32, 
           31}, {40, 37, 41, 44}, {43, 44, 48, 47}, {44, 41, 45, 48}, {47, 48,
            52, 51}, {48, 45, 49, 52}, {45, 46, 50, 49}, {25, 26, 30, 29}, {
           205, 206, 207, 208}, {50, 51, 55, 54}, {52, 49, 53, 56}, {53, 54, 
           58, 57}, {54, 55, 59, 58}, {55, 56, 60, 59}, {62, 63, 67, 66}, {56,
            53, 57, 60}, {58, 59, 63, 62}, {57, 58, 62, 61}, {60, 57, 61, 
           64}, {61, 62, 66, 65}, {51, 52, 56, 55}, {63, 64, 68, 67}, {65, 66,
            70, 69}, {66, 67, 71, 70}, {67, 68, 72, 71}, {68, 65, 69, 72}, {
           69, 70, 74, 73}, {70, 71, 75, 74}, {71, 72, 76, 75}, {72, 69, 73, 
           76}, {73, 74, 78, 77}, {74, 75, 79, 78}, {59, 60, 64, 63}, {75, 76,
            80, 79}, {76, 73, 77, 80}, {77, 78, 82, 81}, {82, 83, 87, 86}, {
           79, 80, 84, 83}, {80, 77, 81, 84}, {81, 82, 86, 85}, {83, 84, 88, 
           87}, {87, 88, 92, 91}, {84, 81, 85, 88}, {85, 86, 90, 89}, {86, 87,
            91, 90}, {88, 85, 89, 92}, {33, 34, 38, 37}, {89, 90, 94, 93}, {
           97, 98, 102, 101}, {92, 89, 93, 96}, {93, 94, 98, 97}, {78, 79, 83,
            82}, {91, 92, 96, 95}, {94, 95, 99, 98}, {95, 96, 100, 99}, {98, 
           99, 103, 102}, {99, 100, 104, 103}, {96, 93, 97, 100}, {90, 91, 95,
            94}, {100, 97, 101, 104}, {101, 102, 106, 105}, {102, 103, 107, 
           106}, {107, 108, 112, 111}, {104, 101, 105, 108}, {105, 106, 110, 
           109}, {113, 114, 118, 117}, {106, 107, 111, 110}, {112, 109, 113, 
           116}, {108, 105, 109, 112}, {110, 111, 115, 114}, {111, 112, 116, 
           115}, {114, 115, 119, 118}, {115, 116, 120, 119}, {122, 123, 127, 
           126}, {117, 118, 122, 121}, {118, 119, 123, 122}, {126, 127, 131, 
           130}, {116, 113, 117, 120}, {119, 120, 124, 123}, {120, 117, 121, 
           124}, {123, 124, 128, 127}, {124, 121, 125, 128}, {121, 122, 126, 
           125}, {109, 110, 114, 113}, {125, 126, 130, 129}, {127, 128, 132, 
           131}, {150, 151, 155, 154}, {132, 129, 133, 136}, {129, 130, 134, 
           133}, {130, 131, 135, 134}, {131, 132, 136, 135}, {133, 134, 138, 
           137}, {137, 138, 142, 141}, {134, 135, 139, 138}, {135, 136, 140, 
           139}, {136, 133, 137, 140}, {138, 139, 143, 142}, {151, 152, 156, 
           155}, {139, 140, 144, 143}, {147, 148, 152, 151}, {142, 143, 147, 
           146}, {143, 144, 148, 147}, {128, 125, 129, 132}, {141, 142, 146, 
           145}, {144, 141, 145, 148}, {145, 146, 150, 149}, {148, 145, 149, 
           152}, {149, 150, 154, 153}, {146, 147, 151, 150}, {140, 137, 141, 
           144}, {64, 61, 65, 68}, {152, 149, 153, 156}, {185, 186, 190, 
           189}, {155, 156, 160, 159}, {156, 153, 157, 160}, {163, 164, 168, 
           167}, {103, 104, 108, 107}, {154, 155, 159, 158}, {158, 159, 163, 
           162}, {157, 158, 162, 161}, {162, 163, 167, 166}, {159, 160, 164, 
           163}, {164, 161, 165, 168}, {166, 167, 171, 170}, {173, 174, 178, 
           177}, {168, 165, 169, 172}, {169, 170, 174, 173}, {165, 166, 170, 
           169}, {167, 168, 172, 171}, {170, 171, 175, 174}, {171, 172, 176, 
           175}, {174, 175, 179, 178}, {175, 176, 180, 179}, {172, 169, 173, 
           176}, {161, 162, 166, 165}, {160, 157, 161, 164}, {176, 173, 177, 
           180}, {177, 178, 182, 181}, {180, 177, 181, 184}, {181, 182, 186, 
           185}, {189, 190, 194, 193}, {183, 184, 188, 187}, {182, 183, 187, 
           186}, {184, 181, 185, 188}, {186, 187, 191, 190}, {187, 188, 192, 
           191}, {188, 185, 189, 192}, {190, 191, 195, 194}, {153, 154, 158, 
           157}, {191, 192, 196, 195}, {199, 200, 204, 203}, {194, 195, 199, 
           198}, {179, 180, 184, 183}, {178, 179, 183, 182}, {193, 194, 198, 
           197}, {192, 189, 193, 196}, {195, 196, 200, 199}, {200, 197, 201, 
           204}, {197, 198, 202, 201}, {196, 193, 197, 200}, {198, 199, 203, 
           202}, {209, 210, 211, 212}}]]}, {}},
       VertexColors->CompressedData["
1:eJy12Ps71GkUAPCJDU1rpaieIUU3lUdPqWc1xbFdphvFuCTtjMuSJYtHu61l
rTE7bhVSSLFuzTJ6hHUZVM+zGeM2sikzDObm0l7y2ihqU2q/f8Tph/PL55fz
/nDOed/zWgdFsUP0aDSanAp9Kia8357PVBGobq2cTSjUwUO+LHfnVhlg+fzl
GM8Fyr9ueTCx4ScdjKaYRK1ageeamICU79QEwtoWn3Lm6MB+Jvgefb4bzbvt
t0meUm6pPPQ82VkHrNcOC+VjeM7mnpF5agiIhfsehq7TgVBVXd/cg+eV+/Q2
9VDuYNjmE/tBC062TLWyDs8NZ5IvMrUEuMN6gQkSLZSYwLvSAjx38OLtr6fc
6klRVCiPysvxyvyBj+cLW3UdW3QEft0jMkwBLay9aJ7bEYbnjwYtvfIpzxFX
TNL0tfAH2z37PhvPIx36di0bJbDaV18e0KoBcVIBrXUPnpuFBFjxKKeZeBut
EWgg3DUgJNIGz0/TfeRTlDfsNuswPqKB4Fd9ztlL8fwcV6IOHiPwkrc9bdxA
AzkG7EuSF11onpy2dLqf8lujLnnmMjXk1rn2Fo7geURgj7frOIHxs9UiuzQ1
9EpP8ZMleP7iznSqhPLJM+kHYw+r4bj4s6rxSjxfdVuSNUk51+WKTRxdDXtp
ipHSq3g+z9/UVUbN1TnHvavkzSqY5rv13ojB8zL3su3tgwSybmhLiyJUEO5T
btrghechRprV4Y+pe0Fzr4HOUEGxq3/tiV14bvSlWZldD4GTSzyqX3eNwKT9
+pM8MzyPEgb5+bUTEBRqnbwTRmAhsNNF/qoTzWcGonPov1PvihXl3l7bRkDW
1HNZNIDnn7/PW9jYQkDzIkRfqhkGf27ttuJmPOe2Nhn41xO426y53nBtGIxn
imV2BXheEpmfzbhDgBeU1cDaPwwx5c/bmPF4Xr4s+/gXFQTcvt0TevTVEBRV
rV12joPnnYVHU5+VEDAOtyibujUEKYoasYUTnndL3wX9dpNALEvcttxzCFKf
HeN8tQbPs0Y7vxnPIfDXxWPxIsMhOOHe4dP7oQPNo/9mz1/PJHCkfuU9baMS
HilLbzdp8dxsYq6xKY1AxQHVldQwJZjXcTykrXh+I/6a6RyfQN1dP7daKyWc
/37Df6FCPGcuTP/b8COBRnPTq3G9g5Dlf/zNJQGeF50/+1Z7geo75YOIxqRB
iM5nuz05i+dW8oL0jGhqLiWKHmVvHwT6bMvbfBaeB275h1UeTkCYmd6lGRuA
cyWLFpJs8VzA2CFUBRNwEawXVV0fgDFHr/eLluK5dM7x51wugWHOnIklawBW
zxr46U22o3lnu292iy+BmOIHxu/eKGA57abRxl48f5roaB3AJqDX3nYtoUJB
7YEZpl1VeD6hWO6xwZXayx4n0ng+Csg7eomhl4HnFesW13qyCEQc2q3/kq6A
LY1hF7hReJ7s3XRlsQuB/F9sMg1b5BB7QGS39ySeb05MKrFhEujgLKm5HCGH
DJvO3cwdeF55kOXO2UWg8JNK8VVrObRMTTv3rcDzw7OyJIY9gcgsHovZ1w/C
kbiyP19K0bwyP3Rsvy0BZ75HBFvQD2zGU9+1A3i+abNUOmVN1e1pP8anO/vh
fnxNmLIRzwUeFofFFlRdrbSsYY0+AaduQZxtHp5/7P+xj33+/wHzx0UN
        "],
       VertexNormals->CompressedData["
1:eJy11/lXFdQWB3ASE9QSTcvnrIizYORYDF+RRAPJgcRZBJ/lk5QUTcRZ0RBQ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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNeuk3le/7tiFDKYXQqMkYjUISHZEMiZIi0kA0mFI0iA8ppWTYMxKVVJIG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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vk71GsUAPCJyjyqSYq6qVzaC3UTuYNOtq5Mu+omkyQjKrIUlaZkuCQi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        "],
       VertexNormals->CompressedData["
1:eJzFl/c71f8bx1VoyIisRErJHqXM3DRQCZGRsqNIpVRIKKWIiswKycxoGBkZ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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNevk31f/3PSlUppIKoZQoKUQp01ZIJCWFkkJJg9JLMpXQQCkpURkKdzTV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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vs/1XccB/BDy2aNROlCLl1o1kqiI6pXLqMSRTi0YqzThUp0oYtLSa5Z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        "],
       VertexNormals->CompressedData["
1:eJzFl/c7Ft4bxxGRUH2SREaZWSEiyV0qooESlUJRsipFpWQnUSgpqyhpKTIy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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNevk71P/3vhAR0ioqSyhayJ42dxEVSlIhJEWRCkUJUUpZQ9lmH2aYYSjb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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vs31HkYB/CxQ0ix3dSYVGRdYrKdWLn1LDKxbicUmxLVJhax2WpcGsl2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        "],
       VertexNormals->CompressedData["
1:eJzFl/c71m8bx9FSoqIkKSMUFUp8hZyhiLSpVFYUySgkhFKUUpIiI9kZoWQT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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNmvk3le/79lVUosGQEhWaM4TKUOEgaUAlwzsVjSRJ5koyz+Pe5tne7K1C
xH2XpKjMIlFEShGVQqEMKZ7r+wd8fn9+sta17nVe1z7O6XWsRfrM5SNWs3l4
eKJn8fDMIX8LtDZuDjgQg39fQm+ObmJin6fgiFErjbPiJ7Ln+UXjlL9yZVcV
A0My2iMl4zQSUvXv35vFhEGf2XkjXwYYqjxbUgZoLNObd6B7LwOtt18Ntmcy
EH4z9KJoOYlj96rRcjETTgvlmgfnMvF5ttnFvFQaW/o/Pb7LiEZg3jyF6weY
0B2KV3h+k8bG1g2rE67FYGjjnvD8/xgwXKJ0+AJFQ0Oqoqj9TjR0P7c/elAW
hfPHf76Jf0HjotFLgYdKTNg5/17qfSYK917VHkx7TMNfVafZ3IcBWbuK+u9j
UfjC06PhxqRxeSBbY7khEz0Xd4jUOjPQeE/m/j43GtqlSb0qddE4uC7PupfN
gJfGAS2dIBod4oF2/nQMcuV2x8cpRyFaPMS1MoDGtTIfUbmuaKyukRq+tyoS
Usn87WJxNOpFX1rvPcWE7Pkty50WRCI71Pma3Q0a16tlhEofMPDU7lTvwgVR
YP058eCyGY1O6Q0XRKKYWH/haeXYIgaE3d+ZrtxLI/R5u9iEYAykxHcULhcn
eoY40TWWNKIYu62kJmKwP3OuJN+rCOhnuK3l7qcxdnmOw/LlMZjcf4KV+TAc
uZ5B22P0aDxxcO/6m0ryyu9hwiMWgd3DMyLNG2msiVbS6Sd57JfS838SEonr
/ue7pRbReFTkqDrczYT6tZ8zMplRkOCavVQWojFS+KdW0CIG30pe6lfpRcFP
uWv4lwKNIwKrvQJVYrF8su2ZXFc4irUFM5X5aLwTEH2iciwGWsda1udMhkG+
W3Jr4Q8KtXJJW2RHmdh8atnXhufheP4nKmfRSwqbDTdZXrZhYoj39B4n30iM
uowwBqsosAy2rSzXjUZNllX3L+so3GjtnrHvpEDLFtypz43BuzQpqZbYSHwo
tQ8WmqIw0HTca9mNWKiGTnj3Xg/Hdw9LLlVBYWjVbhuZnBjofir7u7MvDJ2N
jpV7MikcuETFaP9H6rDPs/yaaAT20L9adf0pZNrtajN9w0Rp5NW5p95Gonz/
udrCIAoZK00HD+REI397Ueh8xyg0TRy+vfo2Bd2m3qey/2Jgt3Wkpl47ElbC
LxKkaijcukvl53bHYgPPzkAnOhz8a3+l7w6m4P/41H1aNBbSh8yMzO3CweMU
WOVwigJjjdQ9g/poZGdW61/qiYBwzwn3Yj0KZR7KeZ0G0VC6KXE9mRUFWV72
/GYTCj2XAzgt4jFQPcpzl/oaha33F/VkeVBo46/m7jgXiyJexr0Mp0jI6KnJ
W8RTkDnr5ChmHYfu8qxryu8jwOK+0dhhSeFszrPRxaxYCAq3bWX1RyCXebQq
fSsFczmhY/onYrAg7tvqqxFR8Fn24JPaGgpLzi/WjCD1P3Tm80bHaAYOFsa7
22tQaFpdXhrDiUGHeqP+jnAGdlctHeW3odCe5mB69Gss6J8BuakuUbikdf/1
5asUfh9fGrrzXxwObOM9xDWKghNTnfN5F4V5M8rnD2nFwVNUSzegJQpXFk2V
7RKmELU1ZWL93xgMHksQ+/yCAaWuRTNhiyjwVfXlfXOLgU+pI0PchYlexdNr
A7ZTGJWubWrbFovz+q/jbm9l4gOVwb+F6Hxx8KTmzJU4lLifkJ57kIF1vWF1
H85SuLb8v7PPb8bD4Up82e8YBta//KSTuJbC4eOll7on4+AzMLTRU4KJs7MH
IMpD4VfvNd+yh7HIbOIM03OjoWqU094jSKFC9nV4wCaiv8bsw2dto9Fw6ZTT
dk1Sn18v+15+Ewt27e2+tz1MRO086lJyhsLek4WXosXi4d03KskZZ6B0IOnd
N1MKAfrcazyHE7CjQHD6WSQTI2d4jH5IkvfHn1TPKI7HvgtXzlCkLuw13n5L
46Wwyd6+8Z9fHLoyt96+sCEG9nfERjOlKMyaesZ+TPS3lgkI26Ibg586105P
kvqRuDu/Z5VPHI7arNigFRgNF5uMGtITsGifNHxCx+OZguXH4FwmXCbOlO8x
olDNGNf8+jMBK0c8dKqtovGo/qVNwHoKx6csdjWcT8DzLU+V12nFYOB9CfV1
BQVZh8yrCTviEbTkWcrXWbF4V7xAq1qbgo27d7FnfBxiKE9Rw+8xSPZ08oIL
hVeLVzxMXh2PPtcda4eEYmB7MWTbey8Ks1NabzQZJGBznHrp5kPRcGeq3Z45
SuGyuPzkt8hEqC6V9ledisag27otL7RIXx9+xW0WSoS10YMKr54YcPqmBKxA
obfNrarwazwWfXrWahodi3SB5YWlDhSy1ruo5e6KR4Cayq1Px2Lx6ZnFtess
Mq9+NIZVlsTD7G+6TYpzDORMglJ7MygoXNhs19uTgHzbWLOqimgoK1wcj7hM
gTtL/onkriRkfTRUDVKJAR7y1S93ozBic8ZwQ10ieC2M/G1XxoLK87k+7EPB
TjtxRDkhAaHDlwxlc2NRUiqr0EBTSChKXLCtPR4F/EF184/EwqDdfMsLMvf2
65+9sUk/AQcj/DzWXSR91vf+xu8m0ndO8u0rbySidsKaOvc+Gq/atj5fkUbh
6ZNDJzy7k2B9Si7so2IMbGZ/uDFAUVBVDH2n55KE5AtOV6P4Y3EhsUGwuJFC
c67a9AvFRJzb8kjulUMsLBT9f9nPojFanJcReSwBf76Xj56ficFh5YOGJyRo
eOxzWl1dk4DqnmtzS9bH4FDqqTIm+f5TQ8U/DYEkTEkqHnEtj8Zx3tttHSR+
SFBkzXGHZLQJa4U2DkZD40X8B9YomUtRYqsr5yRj9cPlVS1ZMUgxcotUIfET
ClS3H8hPRMagvVMfyaOPrOmVVgMazrUvR89XJaDt2vfeEaKDgK9JYRfZp2+f
7EudUUpERItQzuC9aNyZdpm9fwsNK9aGwGtBSViYUfr3rRvZJ2vjxXP+Udh9
qnimqCcZSmv5DNbZR6P6gMzMS0UamX17vU86JmMwTmrL2HA0Cn37Uo6doZEV
WWkotDgJJdpHyrrJfuY67VjeHkljd9HdZLFViai7bmP7N4vsh80N489DaPTK
Sa2wjUrEwgWGQbJS0agYmX9c5yjRxy/L4MFwErQtJSa0+KLRNJvuqpSlYa7q
7Cy+PQUfxbWUHlQw8bJwQZjLaRozjOMb1R8mI9fwY6n9smgkG1bX0wk0GlW1
8s8bJmGY317qvHg0Emt/vNlSRuO3/w4vt+OJsIs+9udWDRMNNy24tvk0Dske
qTdrSwTbsuTyiDMTswUzrTZfpeHjb6+7cXcyjmfKCvxxZIKXefVogRENmZFb
v9TOpkC5eyh/XgcDPl1zEetNQ7fBqTm1PRl7Ze8kDvEzwT7NOvL7Pg226JXN
i04l4fJGnyNGC5jYmiW1yOY14QHfwmwJp0T4dsbLNJI43NPziq+V0nh460td
8d9EXGK2q32+xUBA1yXOcsJXFqc+Oei5JmNPLK+XHzkfTR38yj1PY7LPqlvI
MQUmSxyfxztHYbnAUMWVcBoBtyI/PnyeDAX5kPh89yiYHitbHk/408l1q3j9
niR8fKkpUOhB+IG3vNH3JY1XXgVHFK0S8eC/d3TKlSjYnPwhb0T02fs40Dho
QRK6dlT2+zmQPbtkdYfydRrHfnavuMpIhlzCIlcf+yjMsV61Vs+WBkffcp/L
5RQ0rJzDo0X4KlxWuk46lMb4fMa8z7eS8ejJF85waTi2rk+pNqVpnLf21boh
ngSpUQl9ujMchVELVQ8R3fzn7n6QeTgRsb4XDSpNIxA8zZcjSupKab/QpOKy
JHA+BN4UuhuB7jnheR/P0nj6fdXTpOxk4M6RWYcYETibLL7rC6mTPT4LRwYt
UlC/LytI5Hso+kU1p8zdaTDGn2XO9UzGJ3vTvs37Q/GVN+nh43gabXfP1iv/
TsQFkff6RamhOOUscPE1eX/z6EFtPYNEtDGLTGSiw9AxLHMiiNR/4I0khrxc
Eh5f5BlfsC0cb2fVpq4hnInKCZtZ95KhWnOV4fcxDGdiTAcEj9DYUNq/XvZA
Cv4sGlBp+RWM/6jDktEnaFxI3hLueiIZqSdMVxxRDsaha43vvC/QOL604+ye
vkQ8U6+5KVwdjP3zDxrlkzj8hbva6kk969Y1GRlLhkK/2YhvkPBndfOYg/f+
JGRet7Z/1RUKY4FW3WlpGq1mhkl3nyTDI/3XR2H9UJh7mLx8qUajZrmJktn+
FGSJtaWwTwaB73LYd5etNAaa+UdtTJORLhtuoJoRCI1fQW7LyXm8m6L21GAi
Hq0+UzrhGoRWtzdntyylIXGG3ejunoj30z7X1i4MwXaXzdWZ4xTGbn0XsLFP
Qk//89rIxhD8G5LfOUPODXirHre2JqPy92/zxrFgWNl1GX4lcSizjsqrLik4
Odqa/T44EOufO2p48dBYul3TOM4nGUI1Wnfk3wRgcCglrfsXhdT7JiqKm5JQ
3vygm9EXiEvrhmfWtZA5bz43LL8iEY/n1y7mcIOxVk1y9vxSCievs/8y7ydB
cLslv8l/IbAQHWFzqwmPTYaKjy9KgcXmvtc/9wXj/ftUrdP9FDYeO3ml9EUK
WmfF+DXoBKIvvGh1bBmFP/XZfMXdZG5PdPqyigMQc1fnm/ctCjpRDvc6E5Mg
8mIbD++SIMj7jB10I5z8oGekjVcjCYfydD1jRoMhrrCi35Nw6WfH3H38m5Nx
8N6UZ7lnCC4uCF0VHU0h/U53Yq9TCoQ+Zs46sT4YzeptJalkT9U63wjL25eK
J+4Vvy46B0JMQGarHIkTeP+ORLp1CpZTRiseyQdCvdli1vnjFJIyxM81kfiu
M1mMu21B6HwkPlNNuGtoj6nk4uYkuIvYdJtUheBET5LCgA4FxTnrwldSyZDp
7CjlFQiFuqTlqULCgStXlOweGEpBVWTQniVngpGgmHnGyJuCWsuLZX0vU1HO
sS3tmx+EK8IHU/6PZ1yfGfo94EnF1YrhI6dXBWGB0NZPguIUvtzwMWhqTkaw
rMujcwtC4G5R0LBmDoVV+1VyhJ2T8cHlcuTAx1CY5urZ/1pKoftosabW7hSs
N/s65vA8FM/yTq/PJ++3T/Nz3eiUCrEhq4hLH4Jx5FTfrgTCbz93LLlVbZsG
ua0JW/79CcK7qgxtk8WEK5Qf7PxdmIp7nUErNFxJfj9cWnO7pwi/YqRPMxkp
mFkvvUiMEYqlJznhkq1F4JnuGZnekIIndXViBYrhOFgpKLrzVxGZSztPvvyY
AlXpDtnL98NgmKOp/Jnw5F9Os/q22WkYbNVSi08JwVLZ+XVOChQ+LLXfwlqb
jqfCjy79PRiCC4qzOS8+F2GTvq7gef80TI18zYuXD4WrhUrhhYdF4K4NSS64
lIrxc+JzS86ROSku83fn/SJ01I7rK42noGRMUkr7cQT6bnaoO3cVISpG+rJt
Qiq8xH5+zCZ+s8OdK9e+gILIw3cfpfPT4McpD/K/GQqJ8pJuPqJDp8vQ3Orx
dBQHed0b7Q/FRPLi+pWdRahVNiketE3HXOlEyTVS4ZAN/y01UlSEd3Ic9f3G
afBp8Vqz0CwSfQ6bRH8+KMKcC5ECN2pTcefbwYoa0yjYnbtyV/xLEcRyNx43
NU2DpZHKicTVkVB3ZprvIffOLmxvn7RLx6eMg6b5/WHwirSw3stP4WvNswTh
xgzsswzs7woNx029ecKLSF5YG6/Y6ppk4JOv5K1V4pH4cnbxm7xnRWioH52z
SzUdM6vFjudIMtB3Z3VK26siaAo+qp8VkwatgRZfrhXZp283JJ8m/B+QO2+i
SYDcSy3eK6ARBavHq1ufEb92jD/Msn1jBmrHZtRaJSNw3nmxUBLxU+Hn/tOJ
NWRh7xedmjpyb978zdYKE0UIXyEgabeChS6fTR5T/VFYZ1XwcDXJ46Ilv2Jz
hTKQd2KN5vIBBjY1yPP/mEVhjpetZpNJOlbmln0Sn2KAbls/p3ELBV6ROWGr
S9Px0kKff5YIAzvd2fmdpF8Wq61TMOjKwCb/a8KNqpFQFVlzSpD4iL1j3+6+
z2ZBtevrH6GjURh77XGDQfroWe++m1bXWLBLqYp1ZTMgyeN0LJT0i0OVor5p
XQZcBDb3X7nKRPho4FtFdQrWvSLHm/6kY/MhjeyFx5hoK82+8Z74Pod5R+3L
TTPwVmZgEfscA3cZhaxP50j8gHcPkrVY4FotdtWQiIJ2WqqUBnmn0Gh0+JEJ
FuYcz87VX8mAzk/NW1W6FMyCioyONbDwUTBqaYoQE14vgmLvG1KIbf1m6avM
QgPvTmYK4a60Z/Ghzwn/L1s97+CekAx0HpjONAhhwrv9ROwP4sfDx2oqtndn
YDpxqfq/WOKX/4jcmo6gMP9O7munUBbW6rxyn3xM9J/LV9RP3ikt9/S46x42
TknP6+I3ZiC5S8bH1ZOC8UiO90MxNgL+JjEFdjHRrnWnVJdJweiU9UMpFxaW
LftrW/qSiQWPjn/WeUhh9Xy1Jm0eFvzNnjMueDAx3ebV5viSwqD2wZy/Ciyy
N9Tenyf+94nr75TMxxR+vIp2iG9mIflp3jyHf1GInNRz5MRS6GBfVC90ZsPm
9V2nyPkMmFy/VS9fTsG2+sPJWA02ePVvcWrbGRBbXt7D844C4yP36lkGi/jY
Osc4HSYYc96vMSZ+YV3buO0hcRZ0eEcFN75jQO9Ir0ELP43YQj9du0MsZEdM
vR0UYMD/XuO2mQEyDxMey6b9ZcH5Oy2hoxuFBfUFo3k1FO6/uy6UEM/G4x3X
d3uLR6HRy+T5vSkKL0cOqSUZs9EV9VPeZCsDGWVlcoYyNEwuSS6nEll4PnfH
1lxHBlJkXcJsQONJs2hzvRQLamGH5ez5GagyLw8eUKWRXYqc2rMsXFbaCboq
EqMrTDeYCtGQ1napz1/FRvzuW9vn7o/E+J2MWnXia5Rsz5a657FxvUNUcUN9
BLJtH57Zvp1GTNaCApljbMwqG6u8mBiJuAPDr3gJX2ncjA4SjWeh856I6pHy
SJS4/8iwdSF86+hsZ7mWhS11B0V/LYvEUP39PzzHaKxRa7h6342F2712XgX7
IzDzzStESZ7GtW26rModbDQNHFpYJxOBzoc+j5+voKEZVtVYSrOxfVpRicsX
DqWN//rVCHe9T1fS5jNlo2D0gK6pVjhctrr+0YijIZ77xXwlk4W6zxvn0NLh
EP0cfoWVSONBltLMdzkWLvYO5J+pD4NjhFzvv8vke0ZVWGY4C8NDLSlFjDAo
+NKvJnYT/vdb7Bx6mI03U7/eGeeHIbIp1Sye6CxVvEGoqoSNRx27LzyZCYFB
dxyEwwgfrus4d5F8/2CR7UPdmhD8+NEh0XuX6POI6fU3koWykx37MkJCULLY
ZmdSNo3a3kS9Lyos1F6XCXT1D0GPVJGXhxsNL7cvI2CRftT7u234UQi0hO05
OYdp5H5QaC84zUb17/Ds+D8hcB354P+b6HmYj56MrmRDb4Xs8O0fQfAe/Tz8
LIr40OTKpH8mbIxu7kg3cQhC9KY+vqY7xC88EZc7RfJ1PXLjr+kdQbDNffQ5
m+hz97DlqqN7WTDrrkuZ9g+C8ngc5WRFflepoefgfZKvlxJDxrzBkHqakGG9
l0ZJ3MT3UFc2pC81JN5WD8Y+rSdlkYST9UWTe868ZWPsvxoli4EAZLyj3NiO
NAb/TQzQVmwwNzz3LlcJgDb3m3qcP43uoYvXX+ey8K8lL/i4VgB+5GkvOE3u
3T7mNcO2ZuFFfqh23L8A/Pt+epk64dsYQenfhzpZ2PohcESZCsTxNbIme6Ro
pEvkWyvGsVGzlfstPicQdyRe+13TopHxdkGW4xibzCd+479y/khOin5Ws4/G
db57ixU82ZCS2Lepx9gPx6OaVCr1aahamOqF1bHgmS7+xKPYDwvP3b1+Yg2p
k1D9JXIRLFRSed5Kv/wxrWNiMEE4WeMkO+syHxt5e+xz9BsDoGG4rH2KcK/3
vFmXhB+ycfBZqkjhhQCEXVWJObuSRoWQXn67aCYqrX5ecyrwhcTO9RVqhKvf
L054c4bFxlfuilMhnT6Ik/1ov4WP8H+FyJFlZJ6bLWotuZbnixSvvrTJNgoJ
17SytCtZyFSxkjc28se6T4rSjQ8o3Lg+dK1YjQ3PsR17d60LQO6Im2tbLYWY
GseZ2d1sLIn0HtQ38Qc33VFPkLzfpSZfZ6FGJpkPjLI54T54HLBCLb6Vwj5O
r/fMKzaWasiO/BryRmlu95FLNIUTwi1Wx8ic9I6r3SIn74tmObQaBhAezgoR
rFjMxp6eenWn+f7oD3qz678rFOqrjV+8vMpGRtuWuT5cf3w/vUTGO5HCvaPW
/a6LM7HdM7p2/3k/tH4szMgg83BKMjbH6Uom5imeYVlPeYNPfX50H9k7T+X0
JteJZ8KhxtQoIc8bnpanBf7ZEo5deUJDPZKN3jiLV6l7feEU5eH2W4PC6ely
5STSL8MNjhxHJXJvsqZN2y4KKUMLe/vK2Qje7jkKb3/it/uGymwI9/4bz2g5
kAnR826OO/t84alb71cdR/jWKVx3oDIT6mqrfmw090GGjPf6j9YU5nql/JO8
lAnD3jvxbw/5wF2zoXiBKoVdicMCMp/ZYITsyTFZ44cxC4FIjhAFQ67a6bH7
bJT7Goqt5AlAwunpFhFJ4l+SNt2qWpSJ3LbH9hf5A/BoT5F2vz6FEa9XSU/i
MmGjtP748HY/YL3zxUOOFPJuH+k7tiYL+wwEh8StfPHM5EbJM7LfmYlhr6Va
MvFBPa/p0yNf6DCXvFYVoVAu1jd1QD8TJbKLcx0q/eHxZ/TkvD9FmJ/Nt61g
aSb+bmnhbHUJhMoG3ebThK/WFDfo9ltnwkpHueKCZCDuf7t7f2A3hd9qzivL
BzMRfrjpyztREsencfNKCwo77U457w7JwqTKzbV++X54LL0pgS1L9untwYgp
rSyMCDhJd0b445Gn2+Ybf4ugyJrlmUdn4pvkmR0XnxD/qHMv0ne0CDXmwcZc
p0z0Hw0yyxIJBvNW9sk8wlGJklNqg6WZ+On3yFx/G5lj+uYNL/dRaFn3Zd+u
vVmYcGpA6awAbAxeYfPciHz/VETfejALUkrBQk7qAdhU3DiXJjp/GfILiSjI
gmAF35shdiCy3nlFlY4XoTxgOidDJgtiY/cn9jQFo6TN5KQ34cN9P+ZHhr7K
xLaEbyZSsSH4L/dKtoYihcmniYfOChH9+S5FZckSnxJQtVLFlHCO7CoFo/Qs
aLaUXjKYDkBN2E9DR5LH9nbHV3OMOVgWsLkjaToQguY/5zevJDqzlm9NleLg
navAgkVPg8GwGwsxILxtbqedOxiXhQMLS1fuoEKx7Qxf6Zq1FPQcKyqyNbIw
SoXwjPSEwkx30UUvY9IvtyXPLXLIgkLFraYbUiFoUZz/bQ6p58r3o98f/cnC
E9nJUiOFICjsnHwgR3gvo/mxa8w9Du51GH0UvxYMr+Qh92wlwidr+4frgjgo
Mr7hPGERirWPNmW7yVH4Ja//pZfEsYzc21yzOByxLzCzitx7p9fnVF1KFhYf
+pzy4F0YTpZLyo8TrutimvVG12VBpPXh/LfjIXiY1j1rgz+F/4J/DV0x48A6
+WfOAr1gHAirv+VJ6udclQ6v4gwHIprVtQp/g5Fkd7Vo+1EyN8JPB/C1cnC3
ZFFBfV8ofkCiq8GSwuGqbfm793KQPCUZqX42HEYb2LPmEf60V+k3zfuUhf6n
PYGC42GwUPefvE3m1fzL9a/bFnJgqJfMclgYinlW3Y3C+RR8VcZzE1M4OMMb
/nQWIxhcz+M57V4UWu8JbTytw8XHLwXvucS3xmlNdxowKFjeaZb1XMbFst2n
c9bfD8XxhRy9LjaFnseOqXleHJirLHlj+H++Sdjntgfh0g9tRvxlwhyce7FQ
9deeMHTuf8AOGSQc/oHJx9bgQN75hK3zZeJDPYRVJzopNL8YjnUiv/e71x0N
g13BGHbb/tr8DoV30Tk1Wf5c3LZNuHflUDCKrIfSE5qJn03c7OVhzEWsUr57
7EAITl/69MFkhEKO/vndNjkczP7os6K9MhSNw/yLx1fRUJlYc/i6Mgd+NZq/
pwm3hF7e+a9zMw2xkazEzLMcJPJsVOw5E4xOG71HqxbQsNE6//q+IBeyR0wY
6aFBuNy7OsLjPQX+fSbb/tzjosEhcFb2sSAs7OkI3CpKw6iuvrrBnQuH2ppH
XN9gLLxvWSKjQ2P3fyJ1Nys58Djyu2liLBh+XV6Lis8THjjbp3Z3Pwc9/t0b
DHYHY0pZUunESRrcHvvs9/4caMqz7AwkgjBlmTBtp0SDMlnPmb2TC+UsJ/PJ
7EAEqLjdbheg0ScXu2ayhYsvueE5BnyBiJh+sPf0IRr/HX32JDSCi8SG7a0x
5HvNH+8+UL40fi9dsGaghYM/ovL0WH0g3llcFFRIJzx8a83XUgsObu+6biN8
MBA1na0s00AaBR6/D2zO4mBCokXjeV4AxL4Xzp9jTEOo/M7XWgsu4l+9tbQJ
DsBVjzXvgglvZx0Q9xH4woWXROKg23/+WFa7Pt/mOuEumvVmPJ4Lq8Gqz4GR
/lCvsi07lk/4yk4zLeENB8XirFXb/f2RazF3xfknNL48NBHUt+FgnYuBxSsd
f/ybsLDyySB6GjXes3zAgVbmqnMVAv7onBI3jbIj70/a8rPsCheDrrpyS8X8
ceGs56Qv4cPROvOBc+Q9+jvaVxyN88Vb+7obCgE09izTSxCK5KLP8rdhTpEv
DAJ/53ykCJ/vslPZ8YIDH8HITQOlvkhOXXp/TSmNQpHszffPk/M4/pbOm764
msIfS8fQOFld4sX/lIMvDgPpIaG+mOv/3no24TcfdszHj97k3grjir0+vnhw
6fHxcgsaacWlShKdXNiMzfWefuqNr5rj0QWeNNyjuksoUj9jnavUouu98dl9
mvfCTRo68cpJaRUcrMCtXr9f3mAI3HrtlElDvsri55AdmQ9l4h3dS32w69QB
5QriOw4PqtqYNXIg0zFL+uBCH2iu3f2E34BG8OfPwXakj6Zdrrqc+OSN2Jik
nzOEqwua7m7Je0neo8Tnusz4Bnx/pAhqEH9h6TFHK/UcF1ejlnnU6t7A7cXz
Az8H03j7L87kD5mfbs5OORZrPRFkaH4y05XUbUvrMRtn0u+TD5u1hb2geVGz
nCb1P7bOT//qBw5MUm7VM6S8sEy/ZY8A4Ul3zs/tK4j+ZsWGqVPwhPpCH7tD
KjQk5XIX7m3gQtdJ6Mbef1dRsMpMu5jwtkB/9qEyIy5KBY1vCnddRUis7qU0
cxrzhrNnePM4eL/tjNqLOHeMZlvlrSJ1KLwr99Jrbw5Cn23JKLPzQMDuxPKS
2SS/XgWyFlNk3m4cchkN80Bu4+2YVz8pbLhScF2MzcXwTNcn1dfu0C4NNjki
QupntK3nVz0XB3LmsFQFXbH9lFCdNZknZx/oS3/dy8W+0dJR6R8uWOihOLeb
nOundZzgLeTgrV9l9NK4K9i03092/AeFqscj5vJpHNg/F+1addQdF//cF4l5
QsF08obEDikuHH1PhG5zdUdMV0LbcnJ+SfTnh5XFXHQNG39H0xVcEdpTOJvE
STtZ1zS3kQvNpYOOKpGO2FC1WjbkG9lrqXtbbhpy4RNxuMzYzxE8phKvnrZT
eD9bZ5pF6kFbYU374Z8u6Do86sGXRUFcrmzDZAMHZWbRXEWbq+h71OS5hMz/
ZT+01h014OJ6l4K5iPNVCMq/bntD5n9H8J5JS5KXUo0TWmJzXaGg9FcutprC
/2//j/S/3vm/ftf/0uF/6fa/dP5fefl/V4ZFDg==
       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vs3lWkUB/BDuVSYkzCjkks4buEo0hlmi6KGMEU6JYpu0p3pNi6R6Cgl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        "],
       VertexNormals->CompressedData["
1:eJzF1/c/lv8XB3AZqURJSFMliaxSaB0ZIWWEhlEKlRDKKApJWVkRpSURkhmS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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNevc7lu//P5pWyQiljEqJlCL1yniIkKxkNEQhsiqy07D3XvdyG/dy3whl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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2vtXzHkYB/AZlyUVURNqQza3aF3S1CrzKEIaIjSmlBSJqCNKabpRlGxo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        "],
       VertexNormals->CompressedData["
1:eJzFl/k3FV4XxilKCVEqypgSpZLQpJ0pSkqhFEkplUiUIUWGEEqKyJBESoNE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        "]]}, 
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNmvk3le/79oUGSoaICtGAFCIp82mWkkhKGRqUpCihQcQ2D9ue933vTZLK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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmHtUznccx3vmEkW5RooQJUruIURKoijJPRTKJeVWE2IRm811bC4zY267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            "]], 
           Polygon3DBox[{{391, 392, 393, 394, 395, 396}, {397, 398, 399, 400, 
            401, 402}}]}]}, {}},
       VertexColors->CompressedData["
1:eJzN2uk3FHoYB3BrlBZKJCWh6IquO0plug8SKlfHUhHJcqWVlKSLGEtdKstY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        "],
       VertexNormals->CompressedData["
1:eJzFl/c/Fu73xyMqFSoaxrtUpMhuSXUkIllFJYXMEplZkUKINlERSdmyV8ux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        "]]}, 
     {EdgeForm[None], Specularity[
       GrayLevel[1], 100]}}, {
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1emc81f8fthChZRSSlaShREioLookEhkRJTOroiVkZByj7D0PzrId5xzZ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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxdmHl8z3Ucx38/zNz3XHPNOeYaw9wbNubYMAwb5thsrrkjypFCRJIrVyIh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           "]]]}, {}},
       VertexColors->CompressedData["
1:eJy12vk71HsbB3BLESnbSJ3iZJT9UFNyhG45WVIHSWOtjq1NtoQeskRS4RHq
yZFEHEtISbYxZI0sYxgmZiyzmO8wE4qDpNPjj/icn+7rev10//Z+39d1q3kF
OvqKiYiIXBcVERFfn3W3fll4lsAAu/NrNE3/BihSpjvzfrAAlV8n5aiI940A
LqygjdLbAErZFttONbCReb9y8qLfZzrU1LRL/nmIDKWWjxUf3eUg80X+S5Er
B4dhg1xjblAmGW671rbaW3ORuU6jahM+lgYyjO1cjxUyHPWreHFSbAqZv/K5
zAsIHAR9LoG4n/wO/MctNW3K0HngY1HTo10D0Fh6eFVBthUGcefiQkx5yLzS
8C1HW2kAatX1DpSnt4Oa5vzgq4/ofE6/z9ndhwpf7HKy70t3QppNUhXuGobM
WRHBQwFN/UB76XF73vkDtCqEB2mL8pG5C2HfX5ky/YBv2iAqS+8BZi0T75CN
zv8q33bPcIECnS+i55w6KEAOcGpJG0PnZZkpJHUKBfY51r+tOU2FD2l9fodV
ppG5IgaiosUUuGBmqfMnZwBoKqveJ73QeTo28vJmPAU0pj3v17rQQKvzvk7T
c3QefKIiEHOngEP8VjW9T0MQweiBJ3x0nrM3bqJp3ZesbIr3hdAhJsRttGv7
DDJPZxa78gcpIEIMc5Tp+gicOz/VOkig8wddY0Uquv1gohhpQjMZBQt7twjr
L9PIfCmF0Dh3sR9c8sO0+Y8YsNCrtpIxgc51HKMU6CX9UMCyIfJlxiBH9LKb
Qzc69/Q4+WvSTD+Yp3k8wUWNA+3R/X1+Nej84NSFsgqgQni9YktyxQRILCnv
ColD50Nj/ntG3lKho45s9PTKJAhVIw1370XndaJnv+nuGYCjxrIB1QuTsNsj
D/9PLx+Zb6qaPuD0YABS9lb6qUawAEdmbE+/gc7lSNGDJRsHIUxhq8jsZjYU
/NETx9uJzj0+faNqhQyC3XPJxR8ZbIjfHvvOrx1D5ixP6o5sKRrYlXXZpG7i
wDHtyWuHrND5MvFwPbGEBlimkG8byIHQLcvqxQ08ZH4s5sNJxyNDEOTeq65C
4cBKwIF/3EzR+bsro0z2xBBU+RaISxpxoYpE/2b0egqZh9yTP18VNgx8S+No
yUwuNCfk4YkG6HxDNftWijQd7MOPC1WXuRCYfWqn+CsuMt/hFxpxnUaHMxVz
2cmmU6AYq1jIVkLnQf8j3G1M/whDYgZR7ZFT4Dlj0e6SwEHmMso4V0nPEXAt
z6LavZuC2bN7nhXz2ci8kdlKLVQbhV2KJfp2Ijww/q/UkgsRnR+1kCqMGR8F
qUtjXjLAg5aHevewDhYyJ57atfbmDQNqsy0290XxoLTnYvwPPXTuFlYlJpvF
BE7GVEZUAQ9CJB6nv8yfROZtY9WMiowxKI+yfH25jwcSJsspk1vR+coG3PfW
u+Owybz8YPoyDy68tStJ+zqOzF/otKl5+U/Ap99bJJZVMDAn+euJTY8h8z+O
B8rkEyYh2O6hf6Y1BlXVs4k3mpnIHHf53Pvk8knwxF3MGvDBoCnFzPxoOwOZ
X5COJIT+wgLzGW+1lHAMunNrjH15o8icYcDUMKllQeqY8vx4EgYb+Z/7shZH
kHl0q6xPnTEbml4tsGk5GGjYE6q+KaBzK0aijlIHG87l3VHxeoPBtRmCYYDq
R2TOJv9uP2nPAe87HYTU9xjgnPEfXPTpyLzSdNg2ZZADVo5Rpy91r/eMAObD
6chhZL6af0cl05sL1KSKTHIXBk/NyN/xPUPI3Mm3nLR5hgvAiLU26MRAz1Py
lpwWOj/94v5i3XqemYcbVcZ0YCDBMle1DaMh81nR4xnN0jw4b2K/TG/DIHYL
aajp/SAy31LhukfzAQ8SdJbL97Vi4O/4iqS+F503eeI3/qyEAUHt5pprPgZa
7RJ00zcDyHzcmGZulYbBmiT3+bMEDB4Vvxfj2KDzpYLx1u/SfDDCGzyPuISB
Q+Hr8GeTVGSuEr37omQqH+4vnV1j2mCQKm9RdDsQnVfePOFrLj0Nq/WBL911
MYj5ZIotbUTnVOWvcd2J02Ct8IW/UwQDottn3cScfmSe4O+p0SechuZwuSy7
ah5UBwl0rzmj8//8PaAncWIGXiwdeRwezAPxbZ8L9yihc5Ov1N79r2fgdd8R
W6oGD2546zpEZVHQucEoNV1OAJrv7I6rsaagszbJxhyHzp02+p9QDBCA9aSr
V3/2FNh21GcUPehD5hZKpUbsBgHc5bPTi4zW76gJloXSVnRe37zT1WNeAKlQ
Pz7XyAWyo0i0Rm4vMj81JB2krSWEe9dJv+FMueBkZEj+poXOfxU7rmDpIYRe
8vQAq5kD36Pa5KvqepD5OS8Tb/dUIYDUsf04Ww6EDwtDs06i83ztspK2DiEU
EDqL8Z1sMM/VHT823I3MKx9pps4PC+GHvFaDvAYbar6oWzPOoPPh4GvbXo0I
oVLD8EisLwt2saxum7V+QObaXpa9Xkwh5H6PLwsqngSpHf2XThxA59wS0MTG
hUDoXc1Xn5+Aq87iXWLlXcjcOSa+K48lhBBu75OXweMQ7aukdWUnOnfsrJiT
5QohbyKb5CgzBjvUib+5Z3Qic9OIUouQFiFkeF99luPMgEp5fMkm/ntk3gTy
GmtPhSBDUCV+jBoB/aqgVR19dG6W7IItRgphsmEwl9RKh1vyjwzqYjuQ+Rmh
lLGisxAOp/s1JnOHoBZv6tDQ1o7MbcRCv44RhFBaXGigupUGoUJrZ30ZdO7j
ITh0TUEIaeV5N4OI631Orojt7NOGzGdH/9YhLwhgvua859OwfphtSPopuqEV
mZPuCfYr0gWAt74aFOjfC8OJfYmUn9G5dxy9+2u9AMSuJx63/dEFzOadxkZ3
WpC53AplJTJbAF67kpmeVh1A3NxzImmiGZkHfTZedXkigLy3MMDAd0CTmXyZ
0wg6/7f/Q/7t/f8PDqq6Uw==
        "],
       VertexNormals->CompressedData["
1:eJy11/dfDur/B/Aox8o4ZCUjsnWOI1TEi5BxMjKOlZGOsmV3bDlkZ1VGB8mI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        "]]}, 
     {EdgeForm[None], Specularity[
       GrayLevel[1], 100], 
      GraphicsComplex3DBox[{{4226.599999999999, -171.9, 621.8}, {
       3715.9999999999995`, -362.5, 556.9}, {3763.5, -463.5, 637.}, {
       3670.9000000000005`, -546.1999999999999, 678.5999999999999}, {
       3554.7, -497.3, 620.9}, {3421., -539.9, 627.5}, {
       3329.2999999999997`, -469.80000000000007`, 556.9}, {3370.4, -363.6, 
       485.70000000000005`}, {3493.2000000000003`, -313.3, 472.6}, {
       3581.5, -385.5, 543.7}}, 
       {RGBColor[
        0.4300308387096774, 0.11104058064516129`, 0.5624877419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3923.5, 175.1, 484.90000000000003`}, {
       3334.5, -37.8, 688.5}, {3207.1, -96.8, 697.2}, {
       3190.4, -206.70000000000002`, 774.8000000000001}, {3294.2, -257.4, 
       841.8}, {3424.3, -199.4, 834.8000000000001}, {3439.8, -90.9, 757.9}}, 
       {RGBColor[
        0.34726851612903226`, 0.11558974193548388`, 0.6334312258064516], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3362.8, 501.6, 528.7}, {3027.1, 312.7, 812.5}, {
       3162.3, 322.5, 835.3}, {3210.3, 222.5, 903.9}, {3100.5, 141.6, 
       927.9}, {3091.3, 18.8, 997.6000000000001}, {
       2960.8, -29.599999999999998`, 998.5}, {2852.9, 32.4, 
       939.6000000000001}, {2860.6000000000004`, 147.3, 874.2}, {2986.4, 
       195.79999999999998`, 872.3000000000001}}, 
       {RGBColor[
        0.2935442580645161, 0.14887851612903225`, 0.6948608387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2770.2000000000003`, 751.5, 702.7}, {2676.2, 
       440.5, 1074.3}, {2787.1, 522., 1070.1000000000001`}, {2892., 468.9, 
       1126.9}, {2848.3, 344.9, 1171.}, {2918.2, 242., 1240.}, {2835.7, 132.5,
        1265.6000000000001`}, {2703.1, 123.30000000000001`, 1229.4}, {2637.2, 
       218.6, 1165.1999999999998`}, {2715.4, 325.59999999999997`, 1139.4}}, 
       {RGBColor[
        0.2624051612903226, 0.20452032258064518`, 0.7488907741935483], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2173.3, 698.2, 966.2}, {2455.9, 422., 1438.2}, {
       2516.1000000000004`, 528.3000000000001, 1374.4}, {2645.2999999999997`, 
       531.2, 1390.5}, {2672.2000000000003`, 420.4, 1469.5}, {2794.9, 372.1, 
       1519.6}, {2777.3, 256.70000000000005`, 1595.5}, {2656.2000000000003`, 
       195.79999999999998`, 1619.8}, {2540.9, 240.39999999999998`, 1573.3}, {
       2556.2999999999997`, 352., 1499.6000000000001`}}, 
       {RGBColor[
        0.24858348387096774`, 0.26921051612903224`, 0.7842913548387096], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1952.9, 433.6, 1601.8000000000002`}, {2407.3, 
       393.9, 1878.3999999999999`}, {2541.1000000000004`, 373.6, 1916.9}, {
       2637.5, 452.29999999999995`, 1864.2}, {2605.3999999999996`, 547.9, 
       1776.5}, {2470.9, 570.8000000000001, 1735.6999999999998`}, {
       2375.7999999999997`, 492.3, 1788.6}}, 
       {RGBColor[
        0.24515225806451613`, 0.33932974193548393`, 0.8085143225806452], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1978.3999999999999`, 189.79999999999998`, 
       2192.}, {2531.1, 517.3, 2247.2000000000003`}, {2665.7, 548.2, 
       2223.7}, {2697., 638.1, 2128.3}, {2600.7000000000003`, 696.5, 
       2057.3}, {2463.1, 667.1, 2078.6000000000004`}, {2433., 577.8, 
       2173.4}}, 
       {RGBColor[0.2519013548387097, 0.4057465806451612, 0.8112741612903226], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2375.3, 327.8, 2739.3}, {2687.6, 714.4, 
       2576.8}, {2772.5, 779.5, 2488.7}, {2708.6, 848.9000000000001, 
       2388.8}, {2572.5, 860., 2368.3}, {2489.6, 790.1, 2463.9}, {2550.4, 
       721.5, 2561.9}}, 
       {RGBColor[
        0.26327787096774197`, 0.47048051612903224`, 0.8042780322580646], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2848.1000000000004`, 550.1999999999999, 
       3096.3999999999996`}, {2989.1, 927.8000000000001, 2898.9}, {2863.4, 
       879.7, 2926.8999999999996`}, {2772.8, 920.5, 2842.1}, {2842.6, 999.8, 
       2752.1}, {2797.1, 1071., 2637.8}, {2900.7000000000003`, 1139.2, 
       2574.5}, {3031.8, 1139.1, 2615.9}, {3075.7000000000003`, 1072.8, 
       2722.5}, {2976.2, 1005.7, 2785.3}}, 
       {RGBColor[0.28152729032258067`, 0.524952129032258, 0.7781949354838711],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3369.8, 983.6, 3273.8}, {3067.6, 1346.3, 
       2940.2000000000003`}, {2994.9, 1246.1000000000001`, 3000.3}, {
       2874.2999999999997`, 1233.8, 2951.2}, {2867., 1331.7, 2852.6}, {2760.5,
        1367.1, 2764.3999999999996`}, {2796.2, 1472.5, 2680.7}, {
       2917.8999999999996`, 1535.9, 2681.1}, {3017.6, 1504.1000000000001`, 
       2762.2}, {2985.5, 1401.8000000000002`, 2844.7}}, 
       {RGBColor[
        0.30206767741935486`, 0.5760029677419355, 0.7457495161290323], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3497.8, 1600.6, 3168.7999999999997`}, {2906.9, 
       1778.3999999999999`, 2943.}, {2787.9, 1805.2, 2877.9}, {2684.5, 1721.9,
        2912.3}, {2687.1, 1617.3999999999999`, 3002.7000000000003`}, {2814.8, 
       1595., 3067.2999999999997`}, {2916.6, 1675.4, 3034.5}}, 
       {RGBColor[0.3287994193548387, 0.615007, 0.7002575483870969], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3236., 2203.1, 2968.5}, {2686.3, 2137.2, 
       2971.3}, {2554.7999999999997`, 2100.7000000000003`, 
       2950.7000000000003`}, {2509., 2002.1999999999998`, 3034.2}, {2578.9, 
       1937.6000000000001`, 3134.}, {2715.7, 1980.3000000000002`, 3150.3}, {
       2762.3, 2076.7, 3069.3}}, 
       {RGBColor[0.356959935483871, 0.651231, 0.6517548387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2819.7, 2639.8, 2777.3}, {2378.1, 2486.1, 
       2948.3}, {2503.4, 2476.5, 3003.8}, {2511.4, 2389.3, 3101.5}, {
       2382.7000000000003`, 2337.8, 3111.1}, {2325.6, 2240.9, 
       3195.7000000000003`}, {2194.5, 2212.3, 3179.4}, {2126.6, 2277.2, 
       3084.1}, {2168.9, 2370., 2998.7}, {2299.6, 2396.3, 3017.4}}, 
       {RGBColor[
        0.39180477419354837`, 0.6765738387096774, 0.5981050967741937], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2088.8, 2852.1, 2707.2}, {1972.1, 
       2598.1000000000004`, 3128.9}, {2098.2, 2653.2, 3125.5}, {2176.8, 
       2607.4, 3219.7000000000003`}, {2098., 2516.7000000000003`, 3289.8}, {
       2128.4, 2435.2, 3403.3}, {2019.2, 2358., 3441.2999999999997`}, {
       1896.6000000000001`, 2358.5, 3379.}, {1867.1, 2433.2999999999997`, 
       3274.1}, {1971.5, 2509.5, 3235.}}, 
       {RGBColor[0.4276045161290323, 0.7003622258064516, 0.5437200645161291], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1534.5, 2844.3, 2913.1}, {1745.4, 2689.1, 
       3517.4999999999995`}, {1783.7, 2601., 3615.9999999999995`}, {1916.8, 
       2606.4, 3648.8999999999996`}, {2013.2, 2688.7, 3594.8999999999996`}, {
       1966.3, 2779., 3492.}, {1836.4, 2774.8, 3458.8999999999996`}}, 
       {RGBColor[
        0.47028151612903224`, 0.7154317419354839, 0.4921085806451614], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1181.5, 2809.1, 3443.1}, {1395.7, 2742.4, 
       3842.4}, {1423.7, 2841.7999999999997`, 3751.7000000000003`}, {1550.8, 
       2872.4, 3744.4}, {1610.8, 2787.4, 3836.3999999999996`}, {
       1744.3999999999999`, 2770.1, 3876.2}, {1770., 2677., 3970.5}, {1667.5, 
       2606.7, 4020.9000000000005`}, {1538.3, 2613.6, 3991.5999999999995`}, {
       1516.3, 2706.9, 3897.3999999999996`}}, 
       {RGBColor[0.513417, 0.72992, 0.440682], CylinderBox[{2, 3}, 20], 
        CylinderBox[{3, 4}, 20], CylinderBox[{4, 5}, 20], 
        CylinderBox[{5, 6}, 20], CylinderBox[{6, 7}, 20], 
        CylinderBox[{7, 8}, 20], CylinderBox[{8, 9}, 20], 
        CylinderBox[{9, 10}, 20], CylinderBox[{10, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], SphereBox[8, 20], 
        SphereBox[9, 20], SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1006.3000000000001`, 2674.9, 
       4105.599999999999}, {1490.1, 2787.3, 4269.599999999999}, {
       1623.9999999999998`, 2816.6, 4298.}, {1686.8, 2913.9, 4228.3}, {1621., 
       2981., 4133.5}, {1484.6, 2953.3, 4102.5}, {1423.6000000000001`, 2856.6,
        4172.3}}, 
       {RGBColor[
        0.5620539032258064, 0.7370415483870968, 0.39831090322580653`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1176.5, 2525.7999999999997`, 4653.3}, {
       1659.1000000000001`, 2965.2999999999997`, 4656.7}, {1780., 3027.2, 
       4617.6}, {1775.6, 3129.7000000000003`, 4529.4}, {1658.2999999999997`, 
       3170.7999999999997`, 4480.5}, {1535., 3110.1, 4518.2}, {
       1539.8999999999999`, 3008.8999999999996`, 4605.400000000001}}, 
       {RGBColor[
        0.6107925161290322, 0.7436816451612903, 0.35667119354838717`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1650.8, 2717.6, 5124.8}, {1867.7, 
       3164.3999999999996`, 4963.8}, {1915.1, 3257.5000000000005`, 4872.7}, {
       1817.3999999999999`, 3324.1, 4803.}, {1680.6999999999998`, 
       3308.1000000000004`, 4814.099999999999}, {1637.5, 3209.2, 
       4911.099999999999}, {1731.8000000000002`, 3143.4, 4980.}}, 
       {RGBColor[
        0.6610567741935485, 0.7430999677419354, 0.32600229032258066`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2174.1, 2867.6, 5387.8}, {2077.4, 3399., 
       5241.299999999999}, {1974.5, 3328.2, 5299.2}, {1856.5000000000002`, 
       3365.7, 5257.7}, {1882.6000000000001`, 3467.7999999999997`, 5167.2}, {
       1793.3, 3547., 5089.7}, {1861.7, 3639.3, 5011.2}, {1998.4, 
       3653.6000000000004`, 5007.4}, {2082.7000000000003`, 
       3580.2999999999997`, 5078.900000000001}, {2018.4, 3490., 5156.}}, 
       {RGBColor[0.7108129032258065, 0.7412082258064516, 0.2966935806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2590., 3482.2000000000003`, 5433.700000000001}, {
       2216.7000000000003`, 3831.2, 5321.7}, {2191.4, 3732., 5413.8}, {2063.7,
        3709.3, 5431.1}, {2000.8, 3798.8999999999996`, 5345.5}, {
       1862.3000000000002`, 3821.3, 5320.4}, {1843.1000000000001`, 3921.8, 
       5225.8}, {1943.9, 3992., 5163.4}, {2072.7, 3972.0999999999995`, 
       5186.}, {2093.7999999999997`, 3875., 5277.3}}, 
       {RGBColor[0.757012129032258, 0.7301460322580645, 0.27690622580645163`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2643.3, 4118.4, 5315.}, {2130.2, 4201., 5466.}, {
       2188.5, 4108.599999999999, 5548.2}, {2103.5, 4024.4999999999995`, 
       5601.9}, {1980.8, 4064.3, 5551.2}, {1850.1999999999998`, 4015.9, 
       5569.700000000001}, {1750.3, 4078.3, 5504.2}, {1780.3000000000002`, 
       4182.5, 5425.6}, {1898.6999999999998`, 4237.400000000001, 5400.3}, {
       1995.8999999999999`, 4172.7, 5467.1}}, 
       {RGBColor[
        0.8012228387096773, 0.7162818387096774, 0.25848077419354837`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2364.5, 4679.8, 5360.}, {1809.7, 4486.6, 
       5616.5}, {1690.5, 4425.7, 5648.599999999999}, {1701.8999999999999`, 
       4320., 5735.6}, {1817.8000000000002`, 4270.1, 5792.}, {1939.9, 4339.5, 
       5753.3}, {1929.4, 4442.4, 5668.9}}, 
       {RGBColor[
        0.8368166451612903, 0.6902756451612903, 0.24595690322580643`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1804.7, 5014.5, 5460.900000000001}, {1508., 
       4797.7, 5753.900000000001}, {1643.4, 4817.4, 5767.6}, {1700., 4731., 
       5848.299999999999}, {1595.6, 4649.4, 5890.}, {1595.2, 4537.5, 
       5977.8}, {1467.3, 4483.9, 5991.9}, {1354.1000000000001`, 
       4531.900000000001, 5929.9}, {1353.3, 4635.900000000001, 5848.1}, {
       1476.3999999999999`, 4689.3, 5832.7}}, 
       {RGBColor[
        0.8683509677419354, 0.6594232580645162, 0.23398051612903226`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1145.1000000000001`, 5192.7, 5604.5}, {1300.9, 
       4929.5, 6135.900000000001}, {1417.8000000000002`, 4980.7, 6083.9}, {
       1522.8, 4909.2, 6113.8}, {1472.4, 4804.3, 6189.6}, {1538.8, 
       4694.599999999999, 6250.2}, {1449.9, 4612., 6317.799999999999}, {
       1314.2, 4632., 6325.9}, {1251.1, 4733.5, 6269.9}, {1335.8, 4815., 
       6203.900000000001}}, 
       {RGBColor[0.8877068387096774, 0.6140322903225807, 0.2236465806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{866.3000000000001, 5295.4, 6159.1}, {1277.5, 
       4956.6, 6527.9}, {1359.5, 5050.9, 6469.599999999999}, {1485.8, 5017.4, 
       6471.599999999999}, {1487.5, 4893.9, 6535.1}, {1596.2, 4808.2, 
       6566.500000000001}, {1553.3, 4692.4, 6631.}, {1422.1, 4663., 
       6661.499999999999}, {1320., 4742.4, 6633.}, {1359.8000000000002`, 
       4855.1, 6570.3}}, 
       {RGBColor[0.9013106129032258, 0.562041806451613, 0.21258587096774198`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{772.3, 5050.7, 6754.4}, {1120.6, 
       4804.099999999999, 6964.1}, {1104.8999999999999`, 4922.9, 6897.}, {
       1217.8000000000002`, 4979.3, 6862.099999999999}, {1314.6000000000001`, 
       4892., 6909.3}, {1454.3, 4895.2, 6903.900000000001}, {1521.7, 
       4792.900000000001, 6960.4}, {1451.5, 4694.400000000001, 
       7018.300000000001}, {1319.6999999999998`, 4680.299999999999, 7029.8}, {
       1256.2, 4783.599999999999, 6972.400000000001}}, 
       {RGBColor[0.9022597741935484, 0.4955323870967741, 0.1999262580645161], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{770.6999999999999, 4539.200000000001, 7319.1}, {
       1327.5, 4776.599999999999, 7355.200000000001}, {1244.4, 
       4856.900000000001, 7281.3}, {1307.7, 4953.900000000001, 7220.8}, {
       1440.6000000000001`, 4936.6, 7257.200000000001}, {1556.4, 5011.4, 
       7222.3}, {1670.7999999999997`, 4959.2, 7281.}, {1673.9, 4849.2, 
       7362.8}, {1567.1, 4778.6, 7395.999999999999}, {1454.6, 4827.7, 
       7340.000000000001}}, 
       {RGBColor[
        0.8980634516129032, 0.42284993548387095`, 0.18591083870967742`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1161.8, 4439.9, 7774.8}, {1519., 4714.5, 
       7787.5}, {1386.2, 4736.4, 7759.099999999999}, {1362.7, 4853., 
       7703.5}, {1488.2, 4911.8, 7694.700000000001}, {1531.6000000000001`, 
       5036.2, 7644.799999999999}, {1663.8999999999999`, 5064.099999999999, 
       7650.9}, {1745.8999999999999`, 4972.3, 7703.900000000001}, {
       1717.2999999999997`, 4852.3, 7754.000000000001}, {1585.2, 4827.8, 
       7746.200000000001}}, 
       {RGBColor[
        0.8852913225806451, 0.33987909677419365`, 0.1696357419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1695.8999999999999`, 4338.2, 
       8178.900000000001}, {1664.5, 4982., 8096.099999999999}, {1685.2, 
       5096.099999999999, 8017.799999999999}, {1580.6, 5152.2, 7953.5}, {
       1458.9, 5098.9, 7964.799999999999}, {1434.6, 4983., 8043.7}, {1539.1, 
       4928.2, 8106.8}}, 
       {RGBColor[
        0.8734219677419355, 0.25660432258064536`, 0.1540787096774194], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2003.9, 4843.4, 8511.8}, {1742.3999999999999`, 
       5322.7, 8343.300000000001}, {1681.2, 5405.9, 8248.9}, {
       1555.3000000000002`, 5377., 8207.1}, {1491.5, 5270.3, 8255.9}, {1551.5,
        5183.9, 8351.8}, {1675.6, 5213.4, 8392.3}}, 
       {RGBColor[
        0.8627133225806451, 0.17293877419354836`, 0.13944490322580644`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}]}}, {
     {Specularity[
       GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1enc41f8bN1oopVSIrFSSUVES8kopMjJKUykkymxI017Ze519bIdz7HHo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       "], {
        {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxdmHl8z3Ucx38/zNz3XHPNOeYaw9wbNubYMAwb5thsrrkjypFCRJIrVyIh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           "]]]}, {}},
       VertexColors->CompressedData["
1:eJy12vk71HsbB3BLESnbSJ3iZJT9UFNyhG45WVIHSWOtjq1NtoQeskRS4RHq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        "],
       VertexNormals->CompressedData["
1:eJy11/dTVNnWBmDMCXMgyBUzoA5mEZ3xVdHBgJiz4mDANF5QB7OMOuAoOipm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        "]]}, 
     {EdgeForm[None], Specularity[
       GrayLevel[1], 100], 
      GraphicsComplex3DBox[{{612.1, 5652.6, 7927.500000000001}, {904.9, 
       5838.7, 8132.099999999999}, {1034.3, 5882.099999999999, 8154.6}, {
       1110.3, 5797.2, 8231.6}, {1071.5, 5676.1, 8286.7}, {934.5000000000001, 
       5637.1, 8259.099999999999}, {859.5000000000001, 5719.2, 8184.6}}, 
       {RGBColor[
        0.4300308387096774, 0.11104058064516129`, 0.5624877419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{748.5, 6128.4, 7693.300000000001}, {1236.8, 
       5813.3, 7773.7}, {1118.5, 5744.2, 7757.599999999999}, {1116.3, 
       5630.400000000001, 7821.7}, {1240.4, 5623.7, 7883.799999999999}, {
       1295.8, 5523.8, 7967.3}, {1424.5, 5557.3, 8008.700000000001}, {
       1491.3999999999999`, 5672.6, 7973.900000000001}, {1440.7, 
       5766.400000000001, 7896.099999999999}, {1315.9, 5735.799999999999, 
       7855.}}, 
       {RGBColor[
        0.34726851612903226`, 0.11558974193548388`, 0.6334312258064516], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1441.6000000000001`, 6192.1, 7414.6}, {
       1689.3000000000002`, 5731.3, 7588.}, {1560.6999999999998`, 5750.3, 
       7543.6}, {1479.7, 5654.4, 7578.3}, {1559., 5566.2, 7649.8}, {1525.7, 
       5442.900000000001, 7712.7}, {1636.6, 5385.7, 7774.599999999999}, {
       1763.2, 5440.2, 7775.799999999999}, {1795.2000000000003`, 5555.2, 
       7717.2}, {1689., 5612.1, 7656.699999999999}}, 
       {RGBColor[
        0.2935442580645161, 0.14887851612903225`, 0.6948608387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2158.1, 5965., 7363.500000000001}, {
       1974.8000000000002`, 5393.6, 7448.}, {1922.2, 5277.2, 7501.6}, {1786.9,
        5261.6, 7482.4}, {1701.3000000000002`, 5348.1, 7416.9}, {1763.3, 
       5467.799999999999, 7363.599999999999}, {1894.6999999999998`, 5484.2, 
       7381.8}}, 
       {RGBColor[
        0.2624051612903226, 0.20452032258064518`, 0.7488907741935483], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2499.2999999999997`, 5460.4, 
       7286.700000000001}, {2165.2999999999997`, 5103.6, 7244.1}, {2040.2, 
       5046.099999999999, 7278.5}, {1926.6, 5100.7, 7229.7}, {
       1932.9999999999998`, 5207.7, 7150.2}, {2057.6, 5267.900000000001, 
       7113.7}, {2170.1, 5213.2, 7162.6}}, 
       {RGBColor[
        0.24858348387096774`, 0.26921051612903224`, 0.7842913548387096], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2604., 4784.2, 7259.5}, {1986.4999999999998`, 
       4699.4, 7109.7}, {1850.1999999999998`, 4697.5, 7091.7}, {
       1802.1999999999998`, 4798.7, 7013.}, {1874.5, 4899., 6951.7}, {2017.1, 
       4894.9, 6974.7}, {2065., 4796.7, 7051.5}}, 
       {RGBColor[
        0.24515225806451613`, 0.33932974193548393`, 0.8085143225806452], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2208.5, 4221.200000000001, 7243.2}, {
       1824.8000000000002`, 4342.1, 6902.200000000001}, {1726.8999999999999`, 
       4413.1, 6829.000000000001}, {1764., 4522.3, 6757.4}, {
       1891.7000000000003`, 4561.2, 6756.699999999999}, {1992.7, 
       4491.400000000001, 6829.6}, {1955.2, 4383.8, 6900.2}}, 
       {RGBColor[0.2519013548387097, 0.4057465806451612, 0.8112741612903226], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1783.1, 3804.2999999999997`, 
       7042.400000000001}, {1531.5, 4180.599999999999, 6588.500000000001}, {
       1476.6, 4285.6, 6513.8}, {1559.9, 4372.5, 6451.8}, {
       1692.2999999999997`, 4357.5, 6462.2}, {1750.3, 4251.700000000001, 
       6537.5}, {1667.3999999999999`, 4166.599999999999, 6598.4}}, 
       {RGBColor[
        0.26327787096774197`, 0.47048051612903224`, 0.8042780322580646], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1226.6, 3690.9, 6737.900000000001}, {1301., 
       4061.1, 6227.3}, {1318.2, 4169., 6138.2}, {1442.9, 4219.5, 6119.5}, {
       1547., 4167., 6185.2}, {1531.9, 4058., 6275.8}, {1408.8, 
       4008.7000000000003`, 6293.5}}, 
       {RGBColor[0.28152729032258067`, 0.524952129032258, 0.7781949354838711],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{836.2, 3782.3, 6149.8}, {1106.5, 3993.7, 
       5813.4}, {1152.3999999999999`, 3882.1, 5879.2}, {1280.6, 3885.9, 
       5907.}, {1322.3000000000002`, 4008.2000000000003`, 5855.8}, {
       1448.1999999999998`, 4072.2000000000003`, 5852.900000000001}, {1455.5, 
       4193.6, 5794.9}, {1343.7, 4246.5, 5743.2}, {1219.9, 4196.4, 5739.5}, {
       1216., 4075.6, 5798.1}}, 
       {RGBColor[
        0.30206767741935486`, 0.5760029677419355, 0.7457495161290323], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{617., 3954.2999999999997`, 5561.9}, {1259.2, 
       4022.9, 5433.2}, {1389.4, 4069.1000000000004`, 5433.}, {
       1477.3999999999999`, 3992., 5505.2}, {1449.7, 3876.6, 5575.5}, {1310.9,
        3833.8999999999996`, 5571.200000000001}, {1224.4, 3908.2000000000003`,
        5501.5}}, 
       {RGBColor[0.3287994193548387, 0.615007, 0.7002575483870969], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{933.4, 4186.099999999999, 5012.}, {1419.4, 
       4093.9, 4990.8}, {1547.8, 4074.4999999999995`, 5043.6}, {1568.9, 
       3973.7000000000003`, 5131.6}, {1467.9, 3894., 5167.1}, {1336.3, 
       3911.2000000000003`, 5114.8}, {1316.7, 4011.6, 5027.8}}, 
       {RGBColor[0.356959935483871, 0.651231, 0.6517548387096774], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1371.4, 4346.3, 4531.900000000001}, {1694.5, 
       3979.5, 4661.2}, {1768.1000000000001`, 3902.7999999999997`, 4753.5}, {
       1703.3000000000002`, 3812.5, 4830.7}, {1571.1000000000001`, 
       3797.2999999999997`, 4818.8}, {1494., 3874.1, 4726.2}, {1559.1, 3963.2,
        4650.3}}, 
       {RGBColor[
        0.39180477419354837`, 0.6765738387096774, 0.5981050967741937], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1931.8999999999999`, 4210.2, 4221.8}, {2062.5, 
       3836.3999999999996`, 4418.5}, {1944.6000000000001`, 3873.6, 
       4358.400000000001}, {1839.9, 3807.1, 4401.3}, {1892.0000000000002`, 
       3720.3, 4496.5}, {1832.1000000000001`, 3622.7, 4579.}, {
       1912.3000000000002`, 3553.4, 4662.8}, {2043.4, 3580.8, 4662.9}, {
       2111.4, 3669.8, 4590.5}, {2029., 3737.2, 4508.2}}, 
       {RGBColor[0.4276045161290323, 0.7003622258064516, 0.5437200645161291], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2551.6, 3876., 4191.599999999999}, {2356.9, 
       3452.7000000000003`, 4350.099999999999}, {2305., 3538.4, 4255.7}, {
       2175.7999999999997`, 3527.2, 4242.3}, {2140.2000000000003`, 
       3428.4999999999995`, 4333.400000000001}, {2012.8, 3373.2, 4364.5}, {
       2022.1, 3275.3, 4463.3}, {2138.9, 3235.6000000000004`, 4524.4}, {
       2257.7999999999997`, 3286.3999999999996`, 4496.4}, {2251., 3381.7, 
       4400.7}}, 
       {RGBColor[
        0.47028151612903224`, 0.7154317419354839, 0.4921085806451614], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2823.9, 3266.2999999999997`, 
       4343.099999999999}, {2369.7, 2999.1, 4319.400000000001}, {2392.6, 
       3092.6, 4221.099999999999}, {2284.3, 3126.5, 4156.3}, {2183.7, 3051., 
       4215.599999999999}, {2044.1, 3045., 4187.8}, {1978.8, 2955., 4272.}, {
       2039.6999999999998`, 2880.3, 4370.1}, {2169.2, 2885., 4396.7}, {2234.6,
        2971.9, 4316.299999999999}}, 
       {RGBColor[0.513417, 0.72992, 0.440682], CylinderBox[{2, 3}, 20], 
        CylinderBox[{3, 4}, 20], CylinderBox[{4, 5}, 20], 
        CylinderBox[{5, 6}, 20], CylinderBox[{6, 7}, 20], 
        CylinderBox[{7, 8}, 20], CylinderBox[{8, 9}, 20], 
        CylinderBox[{9, 10}, 20], CylinderBox[{10, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], SphereBox[8, 20], 
        SphereBox[9, 20], SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2722.2999999999997`, 2648., 4490.599999999999}, {
       2150.9, 2566.2, 4270.6}, {2029., 2568., 4206.7}, {2026.8999999999999`, 
       2641.5, 4090.9}, {2131.4, 2711.5, 4033.8}, {2256.5, 2705., 4106.}, {
       2259.7999999999997`, 2633.8999999999996`, 4219.}}, 
       {RGBColor[
        0.5620539032258064, 0.7370415483870968, 0.39831090322580653`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2264.6, 2138.4, 4610.4}, {2082.1000000000004`, 
       2147.6, 4131.5}, {2215.1, 2178.9, 4144.700000000001}, {2254.9, 2275.4, 
       4065.8}, {2140.6, 2310.2, 3995.3}, {2116.6, 2406.5, 3894.8}, {1991.5, 
       2415.1, 3845.2}, {1897.7, 2332.4, 3893.6}, {1907.9999999999998`, 
       2238.2000000000003`, 3987.4}, {2033.3999999999999`, 
       2232.1000000000004`, 4034.7000000000003`}}, 
       {RGBColor[
        0.6107925161290322, 0.7436816451612903, 0.35667119354838717`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1923.6999999999998`, 1649.7, 4330.8}, {1988.1, 
       1959.6, 3767.}, {1962.3000000000002`, 2068.9, 3683.8}, {2060.8, 2158.6,
        3659.5}, {2181.1, 2142.1, 3714.9}, {2210.3, 2032., 
       3800.5000000000005`}, {2111.7999999999997`, 1944.1, 3823.8}}, 
       {RGBColor[
        0.6610567741935485, 0.7430999677419354, 0.32600229032258066`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1690.8999999999999`, 1529.6, 
       3676.1000000000004`}, {1865.6, 1875.1999999999998`, 
       3342.4999999999995`}, {1926.3999999999999`, 1986.6, 
       3286.3999999999996`}, {2057.7000000000003`, 2004.7999999999997`, 
       3323.2999999999997`}, {2132.5, 1924.8999999999999`, 
       3408.2000000000003`}, {2062.8, 1810.5, 3462.8}, {1934.9, 
       1791.7000000000003`, 3428.3}}, 
       {RGBColor[0.7108129032258065, 0.7412082258064516, 0.2966935806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1438.8, 1650.9, 3092.1}, {1848.9999999999998`, 
       1848.6000000000001`, 2920.9}, {1834.9, 1748., 3012.4}, {
       1943.1999999999998`, 1723.5, 3081.4}, {2035.1, 1814.3999999999999`, 
       3032.}, {2169.2, 1839.5, 3064.1}, {2232.3, 1937.2, 2996.2}, {2164.2, 
       2004.3, 2902.6}, {2038.1, 1989.9, 2863.5}, {1978.3000000000002`, 
       1892.1, 2933.1}}, 
       {RGBColor[0.757012129032258, 0.7301460322580645, 0.27690622580645163`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{1579.6, 1883.5, 2476.8}, {2104.1, 1837.1, 
       2565.1}, {2024.6, 1739.6000000000001`, 2620.7000000000003`}, {2083.4, 
       1671.6999999999998`, 2716.5}, {2210., 1728.5, 2724.8}, {2321.3, 1701.5,
        2807.1000000000004`}, {2432.1000000000004`, 1776.8999999999999`, 
       2789.1}, {2430.3999999999996`, 1872.5000000000002`, 2694.7}, {
       2332.7000000000003`, 1907., 2611.7000000000003`}, {2223.9, 
       1830.3999999999999`, 2632.1000000000004`}}, 
       {RGBColor[
        0.8012228387096773, 0.7162818387096774, 0.25848077419354837`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2031.1, 2035.5, 2055.5}, {2516.3, 1761., 
       2363.}, {2611.1, 1716.6000000000001`, 2457.9}, {2577.4, 1615.7, 
       2542.2999999999997`}, {2456., 1559.9, 2534.7999999999997`}, {2358.5, 
       1602.9, 2439.7}, {2392.2999999999997`, 1702.6, 2357.}}, 
       {RGBColor[
        0.8368166451612903, 0.6902756451612903, 0.24595690322580643`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2695.9, 2003.2, 1902.4999999999998`}, {2878.5, 
       1522.8, 2226.8999999999996`}, {2914.6, 1435.6999999999998`, 2332.}, {
       2818.7000000000003`, 1360.3999999999999`, 2390.9}, {2692., 1369., 
       2349.2999999999997`}, {2652.7999999999997`, 1456.2, 2243.4}, {2748., 
       1530.5, 2185.8}}, 
       {RGBColor[
        0.8683509677419354, 0.6594232580645162, 0.23398051612903226`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3236.8, 1684.6, 1846.}, {3140.8, 1235.2, 
       2021.9}, {3050.9, 1293.7, 1935.6999999999998`}, {2925.7000000000003`, 
       1263.2, 1961.1000000000001`}, {2933.5, 1179.1000000000001`, 2071.3}, {
       2835.2, 1112.1000000000001`, 2147.5}, {2877.3, 1036.1000000000001`, 
       2251.3}, {3008.8999999999996`, 1028.5, 2276.1}, {3110.3, 1086.3, 
       2212.1}, {3065.4, 1161.1000000000001`, 2109.7000000000003`}}, 
       {RGBColor[0.8877068387096774, 0.6140322903225807, 0.2236465806451613], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3667., 1155., 1897.6}, {3362.8999999999996`, 
       811.8000000000001, 2039.1}, {3344.7000000000003`, 916.9000000000001, 
       1952.1000000000001`}, {3218.7, 942.6, 1928.3999999999999`}, {3149.4, 
       849.2, 2004.5000000000002`}, {3009., 827.6999999999999, 2019.8}, {
       2982.9, 722.4, 2106.8}, {3078.6000000000004`, 647., 
       2170.7999999999997`}, {3208.8999999999996`, 665.9, 2157.4}, {3236.9, 
       767.8, 2073.5}}, 
       {RGBColor[0.9013106129032258, 0.562041806451613, 0.21258587096774198`],
         CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3763.3, 484.6, 2062.5}, {3297.7, 328.7, 
       2040.1}, {3357.1, 425.4, 1962.5}, {3271.6, 493.40000000000003`, 
       1891.1999999999998`}, {3148.3, 438.6, 1923.5}, {3017.8, 
       471.40000000000003`, 1877.1999999999998`}, {2920.7000000000003`, 390.8,
        1935.6999999999998`}, {2945.7000000000003`, 291.2, 2027.3}, {3066.9, 
       259.6, 2071.1}, {3162.6, 336.90000000000003`, 2015.4}}, 
       {RGBColor[0.9022597741935484, 0.4955323870967741, 0.1999262580645161], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3615.2000000000003`, -99.5, 2235.2}, {
       3117.1, -12.2, 1865.3}, {3007.6, 32.2, 1791.7000000000003`}, {3022.4, 
       137.5, 1708.3999999999999`}, {3140.9, 197.5, 1697.}, {3254.6, 
       154.20000000000002`, 1770.7999999999997`}, {3238.5, 50., 1853.2}}, 
       {RGBColor[
        0.8980634516129032, 0.42284993548387095`, 0.18591083870967742`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{3085., -519.2, 2028.}, {2912.7, -272.5, 
       1581.7}, {2862.8, -173.3, 1495.}, {2946.3999999999996`, -76.8, 
       1450.}, {3074.7, -76.3, 1487.5}, {3128.2, -175.6, 1575.3}, {
       3044.4, -270.8, 1619.8}}, 
       {RGBColor[
        0.8852913225806451, 0.33987909677419365`, 0.1696357419354839], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2655.9, -737.4, 1600.3}, {2764.3, -458.6, 
       1192.1}, {2791.7000000000003`, -339.59999999999997`, 1123.5}, {
       2912.1, -280.1, 1139.7}, {3003.3, -334.90000000000003`, 1220.3}, {
       2978., -455.70000000000005`, 1291.6000000000001`}, {
       2858.2000000000003`, -513.5, 1275.}}, 
       {RGBColor[
        0.8734219677419355, 0.25660432258064536`, 0.1540787096774194], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 2}, 20], SphereBox[2, 20], 
        SphereBox[3, 20], SphereBox[4, 20], SphereBox[5, 20], 
        SphereBox[6, 20], SphereBox[7, 20], Polygon3DBox[{2, 3, 4, 5, 6, 7}], 
        CylinderBox[{1, 2}, 20]}], 
      GraphicsComplex3DBox[{{2388.1, -814., 1000.5000000000001`}, {
       2583.2000000000003`, -539.5, 753.7}, {2614.6, -645.9, 
       834.8000000000001}, {2735.6000000000004`, -639.7, 883.0999999999999}, {
       2787.2, -521.8, 830.9}, {2915.2999999999997`, -461.7, 847.8}, {
       2925.5, -342.2, 776.9}, {2825.5, -287.7, 699.6}, {2706., -342.9, 
       683.1999999999999}, {2694., -458.7, 751.1999999999999}}, 
       {RGBColor[
        0.8627133225806451, 0.17293877419354836`, 0.13944490322580644`], 
        CylinderBox[{2, 3}, 20], CylinderBox[{3, 4}, 20], 
        CylinderBox[{4, 5}, 20], CylinderBox[{5, 6}, 20], 
        CylinderBox[{6, 7}, 20], CylinderBox[{7, 8}, 20], 
        CylinderBox[{8, 9}, 20], CylinderBox[{9, 10}, 20], 
        CylinderBox[{10, 2}, 20], SphereBox[2, 20], SphereBox[3, 20], 
        SphereBox[4, 20], SphereBox[5, 20], SphereBox[6, 20], 
        SphereBox[7, 20], SphereBox[8, 20], SphereBox[9, 20], 
        SphereBox[10, 20], Polygon3DBox[{2, 3, 4, 5, 10}], 
        Polygon3DBox[{5, 6, 7, 8, 9, 10}], CylinderBox[{1, 2}, 20]}]}}}, 
   {AbsoluteThickness[3], EdgeForm[None], Specularity[
     GrayLevel[1], 100], 
    GraphicsComplex3DBox[{{4661.3, 6980.500000000001, 2478.8}, {2924.7, 
     5031.2, 2946.9}, {4690., 2897.5, 2172.4}, {5295.8, 1725.6, 2600.9}, {
     6207., 797.3, 4942.900000000001}, {7184.3, -250.4, 6232.5}, {612.2, 
     6126.2, 5760.2}, {2989., 5083.599999999999, 5234.400000000001}, {2385.8, 
     2453.6000000000004`, 6072.099999999999}, {2358.2999999999997`, 1091.8, 
     5538.1}, {1909.5, -105.60000000000001`, 3213.0000000000005`}, {
     1524.7, -1465.8, 1945.7}}, 
     {RGBColor[0.490196, 0.501961, 0.690196], SphereBox[1, 42.], 
      SphereBox[2, 42.], SphereBox[3, 42.], SphereBox[4, 42.], 
      SphereBox[5, 42.], SphereBox[6, 42.], SphereBox[7, 42.], 
      SphereBox[8, 42.], SphereBox[9, 42.], SphereBox[10, 42.], 
      SphereBox[11, 42.], SphereBox[12, 42.]}]}},
  Axes->False,
  Background->GrayLevel[0.15],
  Boxed->False,
  DisplayFunction->Identity,
  FormatType->TraditionalForm,
  ImageSize->Large,
  Lighting->"Neutral",
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{-3.0701792007296898`, -0.8366249540815662, \
-1.13949917139716}]], "Output",
 CellLabel->"Out[1]=",
 CellID->221664495]
}, Open  ]],

Cell["Get the title of this PDB file:", "ExampleText",
 CellID->33601056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<http://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&\
compression=NO&structureId=1tf6\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<PDB\>\"", ",", "\"\<Title\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1596040096],

Cell[BoxData["\<\"CO-CRYSTAL STRUCTURE OF XENOPUS TFIIIA ZINC FINGER DOMAIN \
BOUND TO THE 5S RIBOSOMAL RNA GENE INTERNAL CONTROL REGION\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->427658795]
}, Open  ]],

Cell["Import the labels for each chain in the above molecule:", "ExampleText",
 CellID->1331086953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<http://www.rcsb.org/pdb/download/downloadFile.do?fileFormat=pdb&\
compression=NO&structureId=1tf6\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<PDB\>\"", ",", "\"\<ResidueChainLabels\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1925218739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>", ",", "\<\"D\"\>", 
   ",", "\<\"E\"\>", ",", "\<\"F\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1015237024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1441962028],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in a smaller sample file:"
}], "ExampleText",
 CellID->1983095645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", " ", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->864975572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AdditionalAtomCoordinates\"\>", 
   ",", "\<\"AdditionalAtomModels\"\>", ",", "\<\"AdditionalAtoms\"\>", 
   ",", "\<\"AtomModels\"\>", ",", "\<\"Author\"\>", ",", "\<\"Comments\"\>", 
   ",", "\<\"DepositionDate\"\>", ",", "\<\"Graphics3D\"\>", 
   ",", "\<\"Organism\"\>", ",", "\<\"Reference\"\>", 
   ",", "\<\"ResidueAtoms\"\>", ",", "\<\"ResidueChainLabels\"\>", 
   ",", "\<\"ResidueCoordinates\"\>", ",", "\<\"ResidueRoles\"\>", 
   ",", "\<\"Residues\"\>", ",", "\<\"SecondaryStructure\"\>", 
   ",", "\<\"Sequence\"\>", ",", "\<\"Title\"\>", 
   ",", "\<\"VertexCoordinates\"\>", ",", "\<\"VertexModels\"\>", 
   ",", "\<\"VertexTypes\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1716118851]
}, Open  ]],

Cell["Get the name of the organism referenced in this file:", "ExampleText",
 CellID->1150286349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<Organism\>\"", ",", " ", "\"\<DepositionDate\>\""}], "}"}],
      "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1288598153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"TURKEY (MELEAGRIS $GALLOPAVO) PANCREAS\"\>", "}"}], 
   ",", "\<\"16-JAN-81\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1277821792]
}, Open  ]],

Cell["Import the residue sequence:", "ExampleText",
 CellID->169088967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", "\"\<Residues\>\"", "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->182020875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\<\"Gly\"\>", ",", "\<\"Pro\"\>", ",", "\<\"Ser\"\>", 
    ",", "\<\"Gln\"\>", ",", "\<\"Pro\"\>", ",", "\<\"Thr\"\>", 
    ",", "\<\"Tyr\"\>", ",", "\<\"Pro\"\>", ",", "\<\"Gly\"\>", 
    ",", "\<\"Asp\"\>", ",", "\<\"Asp\"\>", ",", "\<\"Ala\"\>", 
    ",", "\<\"Pro\"\>", ",", "\<\"Val\"\>", ",", "\<\"Glu\"\>", 
    ",", "\<\"Asp\"\>", ",", "\<\"Leu\"\>", ",", "\<\"Ile\"\>", 
    ",", "\<\"Arg\"\>", ",", "\<\"Phe\"\>", ",", "\<\"Tyr\"\>", 
    ",", "\<\"Asp\"\>", ",", "\<\"Asn\"\>", ",", "\<\"Leu\"\>", 
    ",", "\<\"Gln\"\>", ",", "\<\"Gln\"\>", ",", "\<\"Tyr\"\>", 
    ",", "\<\"Leu\"\>", ",", "\<\"Asn\"\>", ",", "\<\"Val\"\>", 
    ",", "\<\"Val\"\>", ",", "\<\"Thr\"\>", ",", "\<\"Arg\"\>", 
    ",", "\<\"His\"\>", ",", "\<\"Arg\"\>", ",", "\<\"Tyr\"\>"}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->683363777]
}, Open  ]],

Cell["\<\
This gives the same sequence as a string of single-character abbreviations:\
\>", "ExampleText",
 CellID->1554219600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", "\"\<Sequence\>\"", "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->719031684],

Cell[BoxData[
 RowBox[{"{", "\<\"GPSQPTYPGDDAPVEDLIRFYDNLQQYLNVVTRHRY\"\>", "}"}]], "Output",\

 CellLabel->"Out[4]=",
 CellID->552455883]
}, Open  ]],

Cell["Get structural information about this molecule:", "ExampleText",
 CellID->1829644754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/1PPT.pdb\>\"", ",", " ", "\"\<SecondaryStructure\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1514388144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"Helix\"\>", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"14", ",", "32"}], "}"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"\<\"Sheet\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"\<\"Turn\"\>", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->345351964]
}, Open  ]],

Cell["Show the protein backbone in a stylized form:", "ExampleText",
 CellID->1543166347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/1PPT.pdb\>\"", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[{{
    {Specularity[
      GrayLevel[1], 100], 
     GraphicsComplex3DBox[{{167.91618715649994`, -904.9030715202471, 
      1712.1861039995783`}, {143.21535806650903`, -926.4116956235054, 
      1725.4995607802869`}, {126.0836164833311, -898.4965510085224, 
      1738.8130175609954`}, {150.78444557332202`, -876.9879269052641, 
      1725.4995607802869`}, {28.154674639825952`, -886.648368458256, 
      1489.3258943563073`}, {15.024580145656758`, -902.1445350459713, 
      1518.2649586062093`}, {-7.1108018259844625`, -874.9489516661041, 
      1522.7843733468844`}, {6.019292668184729, -859.4527850783887, 
      1493.8453090969824`}, {-95.86719013287393, -1066.449497252755, 
      1479.0707430163743`}, {-108.99728462704313`, -1081.9456638404702`, 
      1508.0098072662763`}, {-131.13266659868435`, -1054.750080460603, 
      1512.5292220069514`}, {-118.00257210451515`, -1039.2539138728878`, 
      1483.5901577570494`}, {167.91618715649994`, -904.9030715202471, 
      1712.1861039995783`}, {143.21535806650903`, -926.4116956235054, 
      1725.4995607802869`}, {126.0836164833311, -898.4965510085224, 
      1738.8130175609954`}, {150.78444557332202`, -876.9879269052641, 
      1725.4995607802869`}, {-118.00257210451515`, -1039.2539138728878`, 
      1483.5901577570494`}, {-131.13266659868435`, -1054.750080460603, 
      1512.5292220069514`}, {-108.99728462704313`, -1081.9456638404702`, 
      1508.0098072662763`}, {-95.86719013287393, -1066.449497252755, 
      1479.0707430163743`}}, {
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {13, 14, 15, 16}, {4, 1, 5,
           8}, {5, 6, 10, 9}, {6, 7, 11, 10}, {3, 4, 8, 7}, {8, 5, 9, 12}, {7,
           8, 12, 11}, {17, 18, 19, 20}}]]}, {}},
      VertexColors->{{0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.40150549800702173`, 0.11260852088259649`, 
       0.5869395333419031}, {0.40150549800702173`, 0.11260852088259649`, 
       0.5869395333419031}, {0.40150549800702173`, 0.11260852088259649`, 
       0.5869395333419031}, {0.40150549800702173`, 0.11260852088259649`, 
       0.5869395333419031}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.4357781865884444, 0.11072466862533334`, 
       0.5575611416562223}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}, {0.36451070230044447`, 0.11464199804133333`, 
       0.6186513027882222}},
      VertexNormals->{{
       0.8366514134633786, -0.12813041023449412`, -0.5325382712283419}, \
{-0.15138175013625996`, -0.9884753743648261, 0.}, {-0.8366514134633786, 
       0.12813041023449412`, 0.5325382712283419}, {0.15138175013625996`, 
       0.9884753743648261, 0.}, {
       0.7053095293162082, -0.233988335843037, -0.6691695798115415}, {
       0.1801057495494409, -0.8538349993516537, 
       0.48839299018453947`}, {-0.7053095293162082, 0.233988335843037, 
       0.6691695798115415}, {-0.18010574954944095`, 
       0.8538349993516537, -0.48839299018453947`}, {
       0.7053095293162076, -0.23398833584304127`, -0.6691695798115407}, {
       0.1801057495494415, -0.8538349993516525, 
       0.48839299018454135`}, {-0.7053095293162076, 0.23398833584304127`, 
       0.6691695798115407}, {-0.1801057495494415, 
       0.8538349993516525, -0.48839299018454135`}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}}]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1lWs4lIkbxgfpgNTWpJIcilbq0nYgKWGcUq1WJVJZx5pitmmLGObgfcdh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      "], {
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {17, 18, 22, 21}, {4, 1, 5,
           8}, {6, 7, 11, 10}, {7, 8, 12, 11}, {2, 3, 7, 6}, {5, 6, 10, 9}, {
          8, 5, 9, 12}, {10, 11, 15, 14}, {13, 14, 18, 17}, {14, 15, 19, 
          18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {11, 12, 16, 15}, {9, 10, 
          14, 13}, {77, 78, 79, 80}, {18, 19, 23, 22}, {20, 17, 21, 24}, {22, 
          23, 27, 26}, {19, 20, 24, 23}, {23, 24, 28, 27}, {25, 26, 30, 29}, {
          26, 27, 31, 30}, {21, 22, 26, 25}, {27, 28, 32, 31}, {28, 25, 29, 
          32}, {29, 30, 34, 33}, {31, 32, 36, 35}, {32, 29, 33, 36}, {12, 9, 
          13, 16}, {33, 34, 38, 37}, {35, 36, 40, 39}, {30, 31, 35, 34}, {34, 
          35, 39, 38}, {36, 33, 37, 40}, {37, 38, 42, 41}, {38, 39, 43, 42}, {
          41, 42, 46, 45}, {42, 43, 47, 46}, {43, 44, 48, 47}, {44, 41, 45, 
          48}, {46, 47, 51, 50}, {40, 37, 41, 44}, {45, 46, 50, 49}, {47, 48, 
          52, 51}, {54, 55, 59, 58}, {49, 50, 54, 53}, {50, 51, 55, 54}, {55, 
          56, 60, 59}, {51, 52, 56, 55}, {53, 54, 58, 57}, {48, 45, 49, 52}, {
          52, 49, 53, 56}, {24, 21, 25, 28}, {56, 53, 57, 60}, {68, 65, 69, 
          72}, {39, 40, 44, 43}, {60, 57, 61, 64}, {62, 63, 67, 66}, {63, 64, 
          68, 67}, {61, 62, 66, 65}, {59, 60, 64, 63}, {58, 59, 63, 62}, {64, 
          61, 65, 68}, {65, 66, 70, 69}, {69, 70, 74, 73}, {70, 71, 75, 74}, {
          57, 58, 62, 61}, {71, 72, 76, 75}, {67, 68, 72, 71}, {66, 67, 71, 
          70}, {72, 69, 73, 76}, {81, 82, 83, 84}}]]}, {}},
      VertexColors->CompressedData["
1:eJxTTMoPSmViYGAIAWJmII6cZro+SfyC/akzpc39p2/ax9lW9EX8eGlPLfHD
N//duOd7wX5Rkk7lNMbb9pH/PA9Nf049cY1jjo4fOi7YZ363jdoYeMfe8N9f
07yr1BN3sps2XfzABfvFebcC2rrv2nsfuHi84gj1xDUXnvym+e2C/bmLH/2M
99+zvyXB1nxjM/XEV3Jxh08NvGiv+nLSL/Y79+3/XSppDyihnnjBkf7nWVsu
2u88vUDiWsYDe+XjDmWOatQT96rSOtomf8le169m1oe3D+xnC86NW3nxBdXE
X5QtmLSu45L9i8Lc9XMLHtqX+Ey2nFNHPfEl8SGKR19dsn/1cU9u06uH9ptc
VjCrGFJPvNhF7q9i6GV7q7kTJq3Pe2TvMtn3uNLd51QTnzG5oeDB0cv2/8R5
3/+788jeN6hHsLuBeuLr9aq2hXhfsWf6eSPuitFj+7lzSxLn8lJPfMnsj8qK
d67YT6oUWfO1/7H9ok+B619NeEY18UPHjsvbJl+1/3W4YMHtZ4/t2VqvSU2Q
oZ74nsPSzhu/XrV/v9amiNf1ib2CYkBLwbynVBMvbG2+VN56zd7334ygtoVP
7LmnmIbNV6KeuC+r14de7uv2zRJitw5/f2If4XLIVW39E6qJm81uWy0ldN1+
5b4Kt1+/n9gvsr7s07SSeuK0rh9p7X4Appcr4w==
       "],
      VertexNormals->CompressedData["
1:eJy11P1XDQYYB/CUvVibZTrOUBmNyZW3DbWt89VMOmUnoWzy0mrE4SxHLxt7
KVF2HI2k3FJ0JS9xelMMzZdSIpXcWzcS1b2u6N5iNUfUrOM+/oPtOef7y/d8
zvPTc57RQaELVlpaWFgs6o9Vf6yjSzxmpaZxvKn858bLBh5N0a/dGW6Ar2Gc
8mRPJ03P9uy78d4hWMiIh3iIp3iI5yuf+sjP68r5XVQXeGZGf9nGWboLRxxv
6eHU0jarZnsn7SZZ2n56+w8eqImdqVNdpHiIh3hOMHvYmz32mT02e4eUWDjm
I0phl5i3oZ1N06tPBfo044Ourjw/jZFrJqueTAusZbbTxuSZx+sonuIhnuIh
HuKhzjhuq/SrwfDWgLIQlw7qRuzpOD/iGhyzR88PHtXOXd7hllcCNTy6Ujkm
VNFI8RQP8RQP8RCP5LyrmVHntNitPvvN6iQTf5/jnh+hOsXMSAf3Vl07o9Jz
Ct2GaPhGSkP52FENrDZ7xpk9Ss0e8WaPoftfenQrX3rA7p9BdwO16KpfPTPl
pJEfjilUeN6roeW2PpP+tIkBby79rSdLy9ct3B4tHppB8RQP8RAP8RAPrd2L
p+N/rUPi8xVh64uNrOxzcNk19Qat6448GVB5j7l7ty7LGH+bIf61RdbnWl95
iod4iId4iGeWtlbvm3Mdx4ZtSq7yMNHJar5ef1bNxlLfx6nKqyzQZjyyWarl
/m9vZkW+ZYJ4iod4iId4iGep0Xb1V4V5LK/Mztfe7OAZZ/X83I3XGRMQE2A3
sAJ3JyQYt/Rc545Vj5enz+6AeIiHeIineIinsr7X73nCbXa/5r0wPMHIpiif
wIMTcjHni8nWByx1+GVZ5rz2/nuJ1a+MnRjbBvEQD/EUT/EQz90H13jUb9cx
TXX6WZnDfa4pdyvT/qlBiV9vzPvbDZh7sX5g8AU1V72taC8M1yPe7LHX7BFv
9hRP8RDP5R85G4sX3GPeZffYiFI980Iah3fFaOGl+qvEdVELrKKdW3aOLOLR
6MCqw2UPIR7iIZ7iKR7iqRgWccdqiYGbZtBwuVhHr1DV0yWuWiiCt7nObqnA
YIcxC2IuaZC1dkrS4gMmiId4iGd80EvPoWbPE2bPiu9+CvDsfsBxhUWagk+a
md3Ve9iu+AY0mzYMOOaUyEFP5jXEnWnG9JG6d1d5tEM8xEM8xUM8xbPkQeFS
mxOd1E6v7nMffIFeiZH+cZH5MPh235kyI4xNBet+SJ7aDK/UhelbUtohHuIh
no1mD43Z08fsGZG0Ypvv3yZ6P262LrtVh562dXapPkXc6jZX0R29D4NtPv7s
4U41qr+3764L74B4iKd4iKd4imfw5py9LsuN7Du758dxo5pQ5TC6pGNrEaeF
3a9w7S2gbU7zVYXHITSnuh970doJ8RBP8RAP8RRPvSt7W/xN9O+M8alWNcA5
MW3Ig7HnGBR3atrutCsMOqw23fSs5KRcjyTb1A6Ih3iKh3iIh/j/ff87VWt7
7SemMcJlXpfjegNnzM74/Otrhv+sVwbaeHSOrGeC3j5sR///VI29lF4RWvuf
9f8ChFRWZQ==
       "]]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1lFdQ0wcAxkGGUoSIFKMg8+oAHIgMUUo/ASHI0CJDKwEShqkyQ4g2siGQ
CNEk/6QgwziOCkpVClUPBf4KgkpUUEHFWhxwB6FGDF5FkF596xOPffi9fXff
ePhsmamhCfO0tLQ8v6DzBcstTgs7N5fhPS++7oN7Nknrz1YZ8MVwm7w/clNS
Cl/i5D+Kczmki8P7w4ldYmj39nUsYJfhmtXAtW9Lc0mb3HijjvkSjFI3qgws
RGDpVyZIl/6n55z2j/nUXIpvwiYGLBQHSbPMpFaqoxTWebb2E4tK8bBKr9bB
5SeyR9nauoApRcosu4/zrhTLLweE1OjyyC0vPHxM66TosD4+P4coQ0qKS97R
1EMknz/qbZcuBY9nppvqeQSdnFdJbdFssr776oXM5TKoqawKpUyIJr/xKB91
BrnkgXjXpl0yXHbcsaadfgR+4innzHQOeaulftX6Rhm8j34uZ+iVIrJN7T3x
ik3ubuorSOLJUF0c3BOnLUSGV/i+Q45JJO3ndQpNrwy+ifFOQ+YCFN0us8nK
SSYpzn3RS6hyaDU3KKoIASb/uDs0HJJE9jbXZrtL5Nj9WL7ZhifE61Bi5auZ
/aTBMp0200A5dDs9I5vCBRi67tf2KYxBTmdbG9g3EMhff5HyIaAEty3O2l4o
Y5At1Qk812cESL2i3VPZJXAbKJZKz0aRl7YXaFLdZPCpNDl5RShA3NKuHvtN
UeSEo2d+nIEM4S+CFkYqi7GZFVPrFOtHnnj5RDT4VALja5bBU/18jDarGw2Z
AaTS22mFnrkU/ICeuCszfNhXZHzOanMlvZLHG0QsKZQHpu2WaIpRMVvfJcpc
Ty4yJMziVklR94G2+IlFEZRGfaO0DmdE2GdVNQjF+M3rzw0KcSHEtTFLDz6i
wj9ixL3mkxixxyzHFt8oRMtIdsFpfW+svlHN7PxOgohtgjvbg4qgPjho+jSZ
BnfZxq5HD8SwE4RkRcXnwtzKy3dCNwAJLDczJ7YYlDuBa+VNuWCVs5+6hm6F
5jCFonknxjaVaQvM8sDmmiQUCnZCMcr7qFktQQ3h0EF7nosej4+VLxlhWNx/
atbpvBge+3r1s3Qy8cbmTTS6t8MtVP14uluCeYH2O1IMudA6w5XQKD6IThx3
uekiheG24V88qrhQxQQbuvO+h2e64rzdPim8GaXR/kQmnp/Q0ThHhONr+unA
vdMSOFAHa6KiWRhuyTCetA7B60vlqp0pBAwQ4/o88EdYXd3EN6r2B0V79i+m
moDXjDl9UnAAVn3GvomOu3A/2OzedSMZYh7Kb3Gq9iM/tGHBnuQInJq9ePec
iMDb5c/0qkxiUU8STXuTo/HWZGq+61ECdt2/upacoYMjp3312p6B9gj9zrP6
MoyHtIbdHmHCqEDDOH6Hid/Nu5yNqDL4C9rbFSvioVZmbEgYiMWb/ivcyhME
4iN7P0bZpKFOK8Ouy5YDeS9r9uJsGXR2BN3j0VMRXLX/rYjKxbNDg6Z+GSKo
1loeudGUjpXMmjY7Wy6CJVFrJkdEUNL9LRgr2Mjvrp38wZEDgzGVGT1NhAMz
5SVBOWnwTRr8PCbkgJs3zmuoKIOwJ/nvhoVpGNN/2N2Yy0XLarrE21iE933D
yxpN2Lh5T/e4n5CLdVuH6t/lifBIm3J+ZyEblhuN7ucQHKgqkok9hiL83/82
l+9cOefqNdcO/wLISqF3
      "], {
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {3, 4, 8, 7}, {4, 1, 5, 
          8}, {11, 12, 16, 15}, {5, 6, 10, 9}, {7, 8, 12, 11}, {6, 7, 11, 
          10}, {9, 10, 14, 13}, {10, 11, 15, 14}, {53, 54, 55, 56}, {12, 9, 
          13, 16}, {14, 15, 19, 18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {17, 
          18, 22, 21}, {18, 19, 23, 22}, {19, 20, 24, 23}, {20, 17, 21, 24}, {
          21, 22, 26, 25}, {22, 23, 27, 26}, {23, 24, 28, 27}, {8, 5, 9, 
          12}, {24, 21, 25, 28}, {25, 26, 30, 29}, {26, 27, 31, 30}, {31, 32, 
          36, 35}, {28, 25, 29, 32}, {29, 30, 34, 33}, {30, 31, 35, 34}, {32, 
          29, 33, 36}, {36, 33, 37, 40}, {33, 34, 38, 37}, {34, 35, 39, 38}, {
          35, 36, 40, 39}, {37, 38, 42, 41}, {13, 14, 18, 17}, {38, 39, 43, 
          42}, {46, 47, 51, 50}, {41, 42, 46, 45}, {42, 43, 47, 46}, {27, 28, 
          32, 31}, {40, 37, 41, 44}, {43, 44, 48, 47}, {44, 41, 45, 48}, {47, 
          48, 52, 51}, {48, 45, 49, 52}, {45, 46, 50, 49}, {39, 40, 44, 43}, {
          57, 58, 59, 60}}]]}, {}},
      VertexColors->CompressedData["
1:eJxTTMoPSmViYGCwAWJmIK5Pjv2u/eSNvWRy3ct9vHftZxnbKb2afMKeWuJP
t0uJrDzyxj5tRwhjWMlt+5BPnmt8Ph+nmnhf/Y2l9Yve2K9XuqZcu+Omfau9
yyIdV+qJP0wVPjyz6Y39iZldDHxSN+yvxByZNG3RMaqJ7zH8zheS/Ma+UGEW
+4Hma/ZJJm9/GDBTT/xWwe3z6Y5v7IX3hEgynb5inzqL5bRH2FGqiS86ZyOz
X/GNfWeK09O1+pftOy4snP5qyxGqiXMl3b6zmPmN/ffmfZai+Rftb05lM8oU
pp542JyKL6nPX9vPeTU3dEL2efuDJneDOCsPU038VMqBr7xnX9vPtVt12N3k
jP3S73wdnC8PUU18ElsKT+2G1/Z97u1Lu7efsI8Srfn02Id64k1mm3guTX1t
f/mgv7Bi2VF7nnCXQrndB6kmrq58J8sRKH6HhUu8MuWofdrL17fZd1BPnNbl
G63dDwCfW8hh
       "],
      VertexNormals->CompressedData["
1:eJyt0W9M1AUcBvDfyTzdTFkD10gGSRaMaY61cV2JT50pf8S53c1/TdzRYgvO
IAcojZJSZxiVoDcaSX/wH4okKOiNsnsUGi5ROU6Brjw6BU6OO45GEzINYvt9
fdmb5nd73jz77HnzXfhmnjFrhqIoy6YTMh1zgzZQ2XCJ+s+0ES2ddxGqG3tg
GR6g5WD+SuP2UQZyKgLrtlymIice4ike4iEej/xfRfW/3jrfyuwoXUH6J0PI
ttsPpUz1MywxLa4mEKTthU3Viwo7WeUy1rpNTRQP8RQP8RAP8VhTc3TFTOM5
fmNpubbr5UHUmV/JvdRxl0rl56b9749QvymlNXVHN80Z+cVxT/1M8RBP8RAP
8RCPE7q5zrryLoT0diQ6T1WieE5mx/q2IA9qlg2ejgiwxG1+N7nZxbGiJ+xT
hx0UT/EUD/EQD/FYt8H6W5zhNnY/v3N/yU99jO+YsNyI9jLK6etrs/q49PfW
2Lrq22xw2Ebbu69TPMVDPCJVjxdVj3rVo7Qsvre60YP5KeaLofluPjtzxs4/
/vHSZBkda/7eS3PlS8Wbt3q5z2C8Hx55huIZpnqIh3iIh3gsqjatPjDnGnYN
ZTcZFvaw+XitYW/MCJOe/qXsvraPmfNi92oK/Qw/Xb48w37lkad4iId4iId4
bmt+5uxkUyfzmGq4UXWTJltymzdphP0Jr/ecefsk38s0PPm3JkjHEZRsUHog
HuIhHuIhHuK5qr67d8VaD8ffydqzL3iTX31ZWBOyw8cHU/Ylufo2KO1KDPVB
utN+OJ7W6IR4PFQ9xEM8xUM8F4znaHWJHibGegtWz+rmPa3lqvcjH79+GGif
77rCo1v9hdsT/HytK3rJ8j/7IB7iIR7iIR7iOTyl2XNg4ha7ZjuUt9LvMFlz
qOK5wUGG5pSWjK/y0xv/6rdrbXXovFDVP3HMgxHV47rqkap6iId4imeLdfZi
e4yHGT/Wxm8sGGDLvA/DLljvMLq0oox6H8Pf2F0U1dg//a8vTtqufgDxEA/x
WKB6RKiekar/z33xFI/I/7lvdSVcTv/Uzu8sGY7c8gGsnByY9OuG8Lj6vCzX
4XvlPXSecs2q+NjNiIvb/Elzhx9b/y9xiwc6
       "]]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNWPc/1u/311CJMrKSSjJDpQ+KjGNFCBlllC07e2e7s7Ldr/vmvm9kRJOs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      "], {
       {EdgeForm[None], 
        GraphicsGroup3DBox[{
          Polygon3DBox[{{1, 2, 8, 7}, {5, 6, 12, 11}, {2, 3, 9, 8}, {3, 4, 10,
            9}, {7, 8, 14, 13}, {12, 7, 13, 18}, {8, 9, 15, 14}, {9, 10, 16, 
           15}, {10, 11, 17, 16}, {11, 12, 18, 17}, {4, 5, 11, 10}, {6, 1, 7, 
           12}, {53, 54, 60, 59}, {13, 14, 20, 19}, {19, 20, 26, 25}, {16, 17,
            23, 22}, {17, 18, 24, 23}, {21, 22, 28, 27}, {26, 27, 33, 32}, {
           14, 15, 21, 20}, {25, 26, 32, 31}, {15, 16, 22, 21}, {23, 24, 30, 
           29}, {24, 19, 25, 30}, {22, 23, 29, 28}, {18, 13, 19, 24}, {27, 28,
            34, 33}, {47, 48, 54, 53}, {30, 25, 31, 36}, {31, 32, 38, 37}, {
           32, 33, 39, 38}, {33, 34, 40, 39}, {34, 35, 41, 40}, {35, 36, 42, 
           41}, {36, 31, 37, 42}, {37, 38, 44, 43}, {38, 39, 45, 44}, {39, 40,
            46, 45}, {40, 41, 47, 46}, {41, 42, 48, 47}, {42, 37, 43, 48}, {
           43, 44, 50, 49}, {44, 45, 51, 50}, {45, 46, 52, 51}, {46, 47, 53, 
           52}, {28, 29, 35, 34}, {48, 43, 49, 54}, {49, 50, 56, 55}, {50, 51,
            57, 56}, {51, 52, 58, 57}, {52, 53, 59, 58}, {29, 30, 36, 35}, {
           20, 21, 27, 26}, {54, 49, 55, 60}, {56, 57, 63, 62}, {57, 58, 64, 
           63}, {58, 59, 65, 64}, {59, 60, 66, 65}, {60, 55, 61, 66}, {62, 63,
            69, 68}, {67, 68, 74, 73}, {65, 66, 72, 71}, {66, 61, 67, 72}, {
           63, 64, 70, 69}, {61, 62, 68, 67}, {55, 56, 62, 61}, {68, 69, 75, 
           74}, {70, 71, 77, 76}, {71, 72, 78, 77}, {72, 67, 73, 78}, {73, 74,
            80, 79}, {74, 75, 81, 80}, {64, 65, 71, 70}, {76, 77, 83, 82}, {
           77, 78, 84, 83}, {78, 73, 79, 84}, {79, 80, 86, 85}, {80, 81, 87, 
           86}, {69, 70, 76, 75}, {81, 82, 88, 87}, {82, 83, 89, 88}, {83, 84,
            90, 89}, {86, 87, 93, 92}, {87, 88, 94, 93}, {94, 95, 101, 100}, {
           85, 86, 92, 91}, {95, 96, 102, 101}, {88, 89, 95, 94}, {90, 85, 91,
            96}, {91, 92, 98, 97}, {92, 93, 99, 98}, {93, 94, 100, 99}, {89, 
           90, 96, 95}, {108, 103, 109, 114}, {96, 91, 97, 102}, {105, 106, 
           112, 111}, {99, 100, 106, 105}, {100, 101, 107, 106}, {102, 97, 
           103, 108}, {98, 99, 105, 104}, {97, 98, 104, 103}, {101, 102, 108, 
           107}, {84, 79, 85, 90}, {106, 107, 113, 112}, {107, 108, 114, 
           113}, {104, 105, 111, 110}, {103, 104, 110, 109}, {75, 76, 82, 81},
            {109, 110, 116, 115}, {184, 185, 191, 190}, {113, 114, 120, 
           119}, {114, 109, 115, 120}, {121, 122, 128, 127}, {112, 113, 119, 
           118}, {115, 116, 122, 121}, {116, 117, 123, 122}, {119, 120, 126, 
           125}, {120, 115, 121, 126}, {117, 118, 124, 123}, {122, 123, 129, 
           128}, {123, 124, 130, 129}, {124, 125, 131, 130}, {132, 127, 133, 
           138}, {126, 121, 127, 132}, {127, 128, 134, 133}, {129, 130, 136, 
           135}, {125, 126, 132, 131}, {118, 119, 125, 124}, {128, 129, 135, 
           134}, {136, 137, 143, 142}, {133, 134, 140, 139}, {134, 135, 141, 
           140}, {131, 132, 138, 137}, {130, 131, 137, 136}, {135, 136, 142, 
           141}, {137, 138, 144, 143}, {162, 157, 163, 168}, {140, 141, 147, 
           146}, {141, 142, 148, 147}, {148, 149, 155, 154}, {139, 140, 146, 
           145}, {149, 150, 156, 155}, {142, 143, 149, 148}, {144, 139, 145, 
           150}, {145, 146, 152, 151}, {146, 147, 153, 152}, {147, 148, 154, 
           153}, {143, 144, 150, 149}, {163, 164, 170, 169}, {150, 145, 151, 
           156}, {159, 160, 166, 165}, {153, 154, 160, 159}, {154, 155, 161, 
           160}, {156, 151, 157, 162}, {152, 153, 159, 158}, {151, 152, 158, 
           157}, {155, 156, 162, 161}, {138, 133, 139, 144}, {160, 161, 167, 
           166}, {161, 162, 168, 167}, {158, 159, 165, 164}, {157, 158, 164, 
           163}, {110, 111, 117, 116}, {164, 165, 171, 170}, {165, 166, 172, 
           171}, {166, 167, 173, 172}, {167, 168, 174, 173}, {168, 163, 169, 
           174}, {169, 170, 176, 175}, {171, 172, 178, 177}, {176, 177, 183, 
           182}, {174, 169, 175, 180}, {175, 176, 182, 181}, {172, 173, 179, 
           178}, {170, 171, 177, 176}, {111, 112, 118, 117}, {177, 178, 184, 
           183}, {179, 180, 186, 185}, {180, 175, 181, 186}, {181, 182, 188, 
           187}, {182, 183, 189, 188}, {183, 184, 190, 189}, {173, 174, 180, 
           179}, {185, 186, 192, 191}, {186, 181, 187, 192}, {187, 188, 194, 
           193}, {188, 189, 195, 194}, {189, 190, 196, 195}, {178, 179, 185, 
           184}, {190, 191, 197, 196}, {191, 192, 198, 197}, {192, 187, 193, 
           198}, {194, 195, 201, 200}, {195, 196, 202, 201}, {196, 197, 203, 
           202}, {197, 198, 204, 203}, {198, 193, 199, 204}, {199, 200, 206, 
           205}, {200, 201, 207, 206}, {201, 202, 208, 207}, {202, 203, 209, 
           208}, {203, 204, 210, 209}, {204, 199, 205, 210}, {205, 206, 212, 
           211}, {212, 213, 219, 218}, {210, 205, 211, 216}, {207, 208, 214, 
           213}, {208, 209, 215, 214}, {206, 207, 213, 212}, {193, 194, 200, 
           199}, {213, 214, 220, 219}, {214, 215, 221, 220}, {215, 216, 222, 
           221}, {216, 211, 217, 222}, {209, 210, 216, 215}, {211, 212, 218, 
           217}}], Polygon3DBox[{{223, 224, 225, 226, 227, 228}, {229, 230, 
           231, 232, 233, 234}}]}]}, {}},
      VertexColors->CompressedData["
1:eJzN2P9T03UcB/CxYeBVcjcZGKVsgDJIUrhlitlL0iElJEcwRTsuviyNmDSb
XzrnYSBfbh6xGV+dYAIqFIkKspNjjOk2GOP2/myfDRhNQL4Vm6GpbJJwxn/x
9ofnL48fnz8978nKyE3iUykUimM5tOWcXOEnDEkeAs/fW+siUpWwU/XeP0uG
ScDlWXzvwPnSQcj+KUXec04J92Zn3XPMKWyeqP1vQNtrBWL/y6ovbyqB66ug
jh/H5yWZn844nlhAONY2Lh1TgnhhgOky4fNuD8krnwAL0A/nhBlXdUP76MQn
b30wjc11ltBb8lYS+BGci7daVcBy2bfJRfj8mm7PYWYWCUGHymU10z0QdOzf
vf4d+Jwm+ziMGUBC2TqBwmdODafyycLPXfg8/VCkM5Aww+JD7oNC1z1AF+6o
zmyZweaMFC11JM8M4RMO7jcMDTSqL7xkifF5/xepAeWbzMCbKLsRy9HCj09y
P9Kp8bl03l7dPGWCuny7F3WnDsrmaDc01L+wOe/S1/6qGhPMBIWlK/f2wtVH
VSH3d+HzH44VOH+OM8HjVzFLE4I+iF4ZWhslwefSuGuqNDcBL+wHa7ylekDr
Oxj1BD4Pd9debr5OwOJWc+VkSz/cHaR39DH+xubaqxV5z/cTQKn4rLxbb4DG
4lze44P4XOhxRnfxbQKYsiP5InIAkFdB5PdyfO5utgucNALi/9BblEwj/GJ8
YGDfxefRDdU8ugvB5t3hTdbzCI5b3xSeG8bnRU9PmhKmEEgEWuWJ0wTw7Nv8
xt34fDoxsVhBIthIygqfhpggo8kzeQNjFpvvbmXvYN1HYNyalnDUaAKBCMly
ovB5cRNxevQ2Arlz+/lykRmCIzrTA/fhc8OVU53yegTf1r2j71zeR7bpxkjz
d/i8MqF2rVuK4IDnsxYKImH7yJ2ieQk+z1hQn03KQxCXPSCNLbDAJaPuzzW/
4fOY9rF19qMIjjjUSeL3rcAuEek39OLzwNylLn4aguJshe9t0gptMUEKzhQ+
L7JX5ZXGI+ivbRJ7SQbBucUV1kZzYPOsxY1eC3EIMq9Uj2h2DMGvbZvtLe/i
8xx5g3BVAYK17pSvVkwOAXeSILvp+FwUHWAPViIYil89yi0ZBgddaCBW4vMo
fj1n3zME+tWV2ZlBNrgZzDKLPfC5e09FrNKXgK6RNe6zXTY4wTENsxdmsTn/
jU1uHz8CktNC2d4aG5Q+72vveYHPSU3f9Qx/Ah49/DC1zGCDhvYe6QGM/rr9
ma9bP/8DgT+QTg==
       "],
      VertexNormals->CompressedData["
1:eJzFl/c/Ff4Xx1EpIkIqIxFSRqGSVCejnUgqCSmJZHyKaGgqCYWrjGighYiM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       "]]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNm/k71N///0XWIuElWhTKVpFSKPEghBQhhGRPtuz7MmOGWTEzKCqRFiqi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      "], {
       {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmmd0VGUXhUnohEjoVSD03kNv0kKR3kIvAamh9xp6R1BpgiCgoEgRpIiI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           "]], 
          Polygon3DBox[{{649, 650, 651, 652, 653, 654}, {655, 656, 657, 658, 
           659, 660}}]}]}, {}},
      VertexColors->CompressedData["
1:eJzN2/k/1dkfB3Ayc4Vwx5KRNBQjMaGxf+MtoTHWbKOyhrKNtbJW1uwZS0aW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       "],
      VertexNormals->CompressedData["
1:eJzFmPc31//7x5VCZiglGvbMeCshusw0NNBSqBSlUpGSlGSkIaFIyC5kRGRz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       "]]}, 
    {EdgeForm[None], Specularity[
      GrayLevel[1], 100]}}, 
   {AbsoluteThickness[3], EdgeForm[None], Specularity[
     GrayLevel[1], 100], GraphicsComplex3DBox[{{111.9, -1117.5, 1927.}}, 
     {RGBColor[0.578462, 0.85539, 0.408855], SphereBox[1, 30.]}]}},
  Axes->False,
  Boxed->False,
  DisplayFunction->Identity,
  FormatType->TraditionalForm,
  Lighting->"Neutral",
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{-2.514521871663412, 0.031796191031650864`, 
   2.2584438800116797`}]], "Output",
 CellLabel->"Out[6]=",
 CellID->301665457]
}, Open  ]],

Cell["\<\
Show the same protein, using standard colors for each residue:\
\>", "ExampleText",
 CellID->728662508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Residue\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[7]:=",
 CellID->1599818096],

Cell[BoxData[
 Graphics3DBox[{{
    {Specularity[
      GrayLevel[1], 100], 
     GraphicsComplex3DBox[{{167.91618715649994`, -904.9030715202471, 
      1712.1861039995783`}, {143.21535806650903`, -926.4116956235054, 
      1725.4995607802869`}, {126.0836164833311, -898.4965510085224, 
      1738.8130175609954`}, {150.78444557332202`, -876.9879269052641, 
      1725.4995607802869`}, {28.154674639825952`, -886.648368458256, 
      1489.3258943563073`}, {15.024580145656758`, -902.1445350459713, 
      1518.2649586062093`}, {-7.1108018259844625`, -874.9489516661041, 
      1522.7843733468844`}, {6.019292668184729, -859.4527850783887, 
      1493.8453090969824`}, {-95.86719013287393, -1066.449497252755, 
      1479.0707430163743`}, {-108.99728462704313`, -1081.9456638404702`, 
      1508.0098072662763`}, {-131.13266659868435`, -1054.750080460603, 
      1512.5292220069514`}, {-118.00257210451515`, -1039.2539138728878`, 
      1483.5901577570494`}, {167.91618715649994`, -904.9030715202471, 
      1712.1861039995783`}, {143.21535806650903`, -926.4116956235054, 
      1725.4995607802869`}, {126.0836164833311, -898.4965510085224, 
      1738.8130175609954`}, {150.78444557332202`, -876.9879269052641, 
      1725.4995607802869`}, {-118.00257210451515`, -1039.2539138728878`, 
      1483.5901577570494`}, {-131.13266659868435`, -1054.750080460603, 
      1512.5292220069514`}, {-108.99728462704313`, -1081.9456638404702`, 
      1508.0098072662763`}, {-95.86719013287393, -1066.449497252755, 
      1479.0707430163743`}}, {
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {13, 14, 15, 16}, {4, 1, 5,
           8}, {5, 6, 10, 9}, {6, 7, 11, 10}, {3, 4, 8, 7}, {8, 5, 9, 12}, {7,
           8, 12, 11}, {17, 18, 19, 20}}]]}, {}},
      VertexColors->{{0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.9215686274509803, 0.9215686274509803, 
       0.9215686274509803}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}, {0.8627450980392157, 0.5882352941176471, 
       0.5098039215686274}},
      VertexNormals->{{
       0.8366514134633786, -0.12813041023449412`, -0.5325382712283419}, \
{-0.15138175013625996`, -0.9884753743648261, 0.}, {-0.8366514134633786, 
       0.12813041023449412`, 0.5325382712283419}, {0.15138175013625996`, 
       0.9884753743648261, 0.}, {
       0.7053095293162082, -0.233988335843037, -0.6691695798115415}, {
       0.1801057495494409, -0.8538349993516537, 
       0.48839299018453947`}, {-0.7053095293162082, 0.233988335843037, 
       0.6691695798115415}, {-0.18010574954944095`, 
       0.8538349993516537, -0.48839299018453947`}, {
       0.7053095293162076, -0.23398833584304127`, -0.6691695798115407}, {
       0.1801057495494415, -0.8538349993516525, 
       0.48839299018454135`}, {-0.7053095293162076, 0.23398833584304127`, 
       0.6691695798115407}, {-0.1801057495494415, 
       0.8538349993516525, -0.48839299018454135`}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {-0.5264009670160408, 
       0.08061657551308418, -0.8464059248830436}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}, {0.6856386707552182, 
       0.4649895187760334, 0.5600753168935856}}]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1lWs4lIkbxgfpgNTWpJIcilbq0nYgKWGcUq1WJVJZx5pitmmLGObgfcdh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      "], {
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{1, 2, 6, 5}, {3, 4, 8, 7}, {17, 18, 22, 21}, {4, 1, 5,
           8}, {6, 7, 11, 10}, {7, 8, 12, 11}, {2, 3, 7, 6}, {5, 6, 10, 9}, {
          8, 5, 9, 12}, {10, 11, 15, 14}, {13, 14, 18, 17}, {14, 15, 19, 
          18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {11, 12, 16, 15}, {9, 10, 
          14, 13}, {77, 78, 79, 80}, {18, 19, 23, 22}, {20, 17, 21, 24}, {22, 
          23, 27, 26}, {19, 20, 24, 23}, {23, 24, 28, 27}, {25, 26, 30, 29}, {
          26, 27, 31, 30}, {21, 22, 26, 25}, {27, 28, 32, 31}, {28, 25, 29, 
          32}, {29, 30, 34, 33}, {31, 32, 36, 35}, {32, 29, 33, 36}, {12, 9, 
          13, 16}, {33, 34, 38, 37}, {35, 36, 40, 39}, {30, 31, 35, 34}, {34, 
          35, 39, 38}, {36, 33, 37, 40}, {37, 38, 42, 41}, {38, 39, 43, 42}, {
          41, 42, 46, 45}, {42, 43, 47, 46}, {43, 44, 48, 47}, {44, 41, 45, 
          48}, {46, 47, 51, 50}, {40, 37, 41, 44}, {45, 46, 50, 49}, {47, 48, 
          52, 51}, {54, 55, 59, 58}, {49, 50, 54, 53}, {50, 51, 55, 54}, {55, 
          56, 60, 59}, {51, 52, 56, 55}, {53, 54, 58, 57}, {48, 45, 49, 52}, {
          52, 49, 53, 56}, {24, 21, 25, 28}, {56, 53, 57, 60}, {68, 65, 69, 
          72}, {39, 40, 44, 43}, {60, 57, 61, 64}, {62, 63, 67, 66}, {63, 64, 
          68, 67}, {61, 62, 66, 65}, {59, 60, 64, 63}, {58, 59, 63, 62}, {64, 
          61, 65, 68}, {65, 66, 70, 69}, {69, 70, 74, 73}, {70, 71, 75, 74}, {
          57, 58, 62, 61}, {71, 72, 76, 75}, {67, 68, 72, 71}, {66, 67, 71, 
          70}, {72, 69, 73, 76}, {81, 82, 83, 84}}]]}, {}},
      VertexColors->CompressedData["
1:eJxTTMoPSmViYGAIAWJmIJ4zGwRe21++BAKP7APA4IH9UBGvBYO3ozQO+u4d
EHhjLwIGS+D0qPjwEJcEg5ejNA56sJVXg01cDgzWYfBHxSH8oR7+AFG8Odg=

       "],
      VertexNormals->CompressedData["
1:eJy11P1XDQYYB/CUvVibZTrOUBmNyZW3DbWt89VMOmUnoWzy0mrE4SxHLxt7
KVF2HI2k3FJ0JS9xelMMzZdSIpXcWzcS1b2u6N5iNUfUrOM+/oPtOef7y/d8
zvPTc57RQaELVlpaWFgs6o9Vf6yjSzxmpaZxvKn858bLBh5N0a/dGW6Ar2Gc
8mRPJ03P9uy78d4hWMiIh3iIp3iI5yuf+sjP68r5XVQXeGZGf9nGWboLRxxv
6eHU0jarZnsn7SZZ2n56+w8eqImdqVNdpHiIh3hOMHvYmz32mT02e4eUWDjm
I0phl5i3oZ1N06tPBfo044Ourjw/jZFrJqueTAusZbbTxuSZx+sonuIhnuIh
HuKhzjhuq/SrwfDWgLIQlw7qRuzpOD/iGhyzR88PHtXOXd7hllcCNTy6Ujkm
VNFI8RQP8RQP8RCP5LyrmVHntNitPvvN6iQTf5/jnh+hOsXMSAf3Vl07o9Jz
Ct2GaPhGSkP52FENrDZ7xpk9Ss0e8WaPoftfenQrX3rA7p9BdwO16KpfPTPl
pJEfjilUeN6roeW2PpP+tIkBby79rSdLy9ct3B4tHppB8RQP8RAP8RAPrd2L
p+N/rUPi8xVh64uNrOxzcNk19Qat6448GVB5j7l7ty7LGH+bIf61RdbnWl95
iod4iId4iGeWtlbvm3Mdx4ZtSq7yMNHJar5ef1bNxlLfx6nKqyzQZjyyWarl
/m9vZkW+ZYJ4iod4iId4iGep0Xb1V4V5LK/Mztfe7OAZZ/X83I3XGRMQE2A3
sAJ3JyQYt/Rc545Vj5enz+6AeIiHeIineIinsr7X73nCbXa/5r0wPMHIpiif
wIMTcjHni8nWByx1+GVZ5rz2/nuJ1a+MnRjbBvEQD/EUT/EQz90H13jUb9cx
TXX6WZnDfa4pdyvT/qlBiV9vzPvbDZh7sX5g8AU1V72taC8M1yPe7LHX7BFv
9hRP8RDP5R85G4sX3GPeZffYiFI980Iah3fFaOGl+qvEdVELrKKdW3aOLOLR
6MCqw2UPIR7iIZ7iKR7iqRgWccdqiYGbZtBwuVhHr1DV0yWuWiiCt7nObqnA
YIcxC2IuaZC1dkrS4gMmiId4iGd80EvPoWbPE2bPiu9+CvDsfsBxhUWagk+a
md3Ve9iu+AY0mzYMOOaUyEFP5jXEnWnG9JG6d1d5tEM8xEM8xUM8xbPkQeFS
mxOd1E6v7nMffIFeiZH+cZH5MPh235kyI4xNBet+SJ7aDK/UhelbUtohHuIh
no1mD43Z08fsGZG0Ypvv3yZ6P262LrtVh562dXapPkXc6jZX0R29D4NtPv7s
4U41qr+3764L74B4iKd4iKd4imfw5py9LsuN7Du758dxo5pQ5TC6pGNrEaeF
3a9w7S2gbU7zVYXHITSnuh970doJ8RBP8RAP8RRPvSt7W/xN9O+M8alWNcA5
MW3Ig7HnGBR3atrutCsMOqw23fSs5KRcjyTb1A6Ih3iKh3iIh/j/ff87VWt7
7SemMcJlXpfjegNnzM74/Otrhv+sVwbaeHSOrGeC3j5sR///VI29lF4RWvuf
9f8ChFRWZQ==
       "]]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJy1lFdQ0wcAxkGGUoSIFKMg8+oAHIgMUUo/ASHI0CJDKwEShqkyQ4g2siGQ
CNEk/6QgwziOCkpVClUPBf4KgkpUUEHFWhxwB6FGDF5FkF596xOPffi9fXff
ePhsmamhCfO0tLQ8v6DzBcstTgs7N5fhPS++7oN7Nknrz1YZ8MVwm7w/clNS
Cl/i5D+Kczmki8P7w4ldYmj39nUsYJfhmtXAtW9Lc0mb3HijjvkSjFI3qgws
RGDpVyZIl/6n55z2j/nUXIpvwiYGLBQHSbPMpFaqoxTWebb2E4tK8bBKr9bB
5SeyR9nauoApRcosu4/zrhTLLweE1OjyyC0vPHxM66TosD4+P4coQ0qKS97R
1EMknz/qbZcuBY9nppvqeQSdnFdJbdFssr776oXM5TKoqawKpUyIJr/xKB91
BrnkgXjXpl0yXHbcsaadfgR+4innzHQOeaulftX6Rhm8j34uZ+iVIrJN7T3x
ik3ubuorSOLJUF0c3BOnLUSGV/i+Q45JJO3ndQpNrwy+ifFOQ+YCFN0us8nK
SSYpzn3RS6hyaDU3KKoIASb/uDs0HJJE9jbXZrtL5Nj9WL7ZhifE61Bi5auZ
/aTBMp0200A5dDs9I5vCBRi67tf2KYxBTmdbG9g3EMhff5HyIaAEty3O2l4o
Y5At1Qk812cESL2i3VPZJXAbKJZKz0aRl7YXaFLdZPCpNDl5RShA3NKuHvtN
UeSEo2d+nIEM4S+CFkYqi7GZFVPrFOtHnnj5RDT4VALja5bBU/18jDarGw2Z
AaTS22mFnrkU/ICeuCszfNhXZHzOanMlvZLHG0QsKZQHpu2WaIpRMVvfJcpc
Ty4yJMziVklR94G2+IlFEZRGfaO0DmdE2GdVNQjF+M3rzw0KcSHEtTFLDz6i
wj9ixL3mkxixxyzHFt8oRMtIdsFpfW+svlHN7PxOgohtgjvbg4qgPjho+jSZ
BnfZxq5HD8SwE4RkRcXnwtzKy3dCNwAJLDczJ7YYlDuBa+VNuWCVs5+6hm6F
5jCFonknxjaVaQvM8sDmmiQUCnZCMcr7qFktQQ3h0EF7nosej4+VLxlhWNx/
atbpvBge+3r1s3Qy8cbmTTS6t8MtVP14uluCeYH2O1IMudA6w5XQKD6IThx3
uekiheG24V88qrhQxQQbuvO+h2e64rzdPim8GaXR/kQmnp/Q0ThHhONr+unA
vdMSOFAHa6KiWRhuyTCetA7B60vlqp0pBAwQ4/o88EdYXd3EN6r2B0V79i+m
moDXjDl9UnAAVn3GvomOu3A/2OzedSMZYh7Kb3Gq9iM/tGHBnuQInJq9ePec
iMDb5c/0qkxiUU8STXuTo/HWZGq+61ECdt2/upacoYMjp3312p6B9gj9zrP6
MoyHtIbdHmHCqEDDOH6Hid/Nu5yNqDL4C9rbFSvioVZmbEgYiMWb/ivcyhME
4iN7P0bZpKFOK8Ouy5YDeS9r9uJsGXR2BN3j0VMRXLX/rYjKxbNDg6Z+GSKo
1loeudGUjpXMmjY7Wy6CJVFrJkdEUNL9LRgr2Mjvrp38wZEDgzGVGT1NhAMz
5SVBOWnwTRr8PCbkgJs3zmuoKIOwJ/nvhoVpGNN/2N2Yy0XLarrE21iE933D
yxpN2Lh5T/e4n5CLdVuH6t/lifBIm3J+ZyEblhuN7ucQHKgqkok9hiL83/82
l+9cOefqNdcO/wLISqF3
      "], {
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{1, 2, 6, 5}, {2, 3, 7, 6}, {3, 4, 8, 7}, {4, 1, 5, 
          8}, {11, 12, 16, 15}, {5, 6, 10, 9}, {7, 8, 12, 11}, {6, 7, 11, 
          10}, {9, 10, 14, 13}, {10, 11, 15, 14}, {53, 54, 55, 56}, {12, 9, 
          13, 16}, {14, 15, 19, 18}, {15, 16, 20, 19}, {16, 13, 17, 20}, {17, 
          18, 22, 21}, {18, 19, 23, 22}, {19, 20, 24, 23}, {20, 17, 21, 24}, {
          21, 22, 26, 25}, {22, 23, 27, 26}, {23, 24, 28, 27}, {8, 5, 9, 
          12}, {24, 21, 25, 28}, {25, 26, 30, 29}, {26, 27, 31, 30}, {31, 32, 
          36, 35}, {28, 25, 29, 32}, {29, 30, 34, 33}, {30, 31, 35, 34}, {32, 
          29, 33, 36}, {36, 33, 37, 40}, {33, 34, 38, 37}, {34, 35, 39, 38}, {
          35, 36, 40, 39}, {37, 38, 42, 41}, {13, 14, 18, 17}, {38, 39, 43, 
          42}, {46, 47, 51, 50}, {41, 42, 46, 45}, {42, 43, 47, 46}, {27, 28, 
          32, 31}, {40, 37, 41, 44}, {43, 44, 48, 47}, {44, 41, 45, 48}, {47, 
          48, 52, 51}, {48, 45, 49, 52}, {45, 46, 50, 49}, {39, 40, 44, 43}, {
          57, 58, 59, 60}}]]}, {}},
      VertexColors->CompressedData["
1:eJxTTMoPSmViYGCwAWJmII4Hg/f2ly+BwCN7BigYKuIiYLDFfvo0ELgGFf9g
PyoOEQ8AgwdwOgoMXg0Z8cEWnoNNXBIMTsLpUDB4OioOFad1+UNr9wMAGYfQ
Wg==
       "],
      VertexNormals->CompressedData["
1:eJyt0W9M1AUcBvDfyTzdTFkD10gGSRaMaY61cV2JT50pf8S53c1/TdzRYgvO
IAcojZJSZxiVoDcaSX/wH4okKOiNsnsUGi5ROU6Brjw6BU6OO45GEzINYvt9
fdmb5nd73jz77HnzXfhmnjFrhqIoy6YTMh1zgzZQ2XCJ+s+0ES2ddxGqG3tg
GR6g5WD+SuP2UQZyKgLrtlymIice4ike4iEej/xfRfW/3jrfyuwoXUH6J0PI
ttsPpUz1MywxLa4mEKTthU3Viwo7WeUy1rpNTRQP8RQP8RAP8VhTc3TFTOM5
fmNpubbr5UHUmV/JvdRxl0rl56b9749QvymlNXVHN80Z+cVxT/1M8RBP8RAP
8RCPE7q5zrryLoT0diQ6T1WieE5mx/q2IA9qlg2ejgiwxG1+N7nZxbGiJ+xT
hx0UT/EUD/EQD/FYt8H6W5zhNnY/v3N/yU99jO+YsNyI9jLK6etrs/q49PfW
2Lrq22xw2Ebbu69TPMVDPCJVjxdVj3rVo7Qsvre60YP5KeaLofluPjtzxs4/
/vHSZBkda/7eS3PlS8Wbt3q5z2C8Hx55huIZpnqIh3iIh3gsqjatPjDnGnYN
ZTcZFvaw+XitYW/MCJOe/qXsvraPmfNi92oK/Qw/Xb48w37lkad4iId4iId4
bmt+5uxkUyfzmGq4UXWTJltymzdphP0Jr/ecefsk38s0PPm3JkjHEZRsUHog
HuIhHuIhHuK5qr67d8VaD8ffydqzL3iTX31ZWBOyw8cHU/Ylufo2KO1KDPVB
utN+OJ7W6IR4PFQ9xEM8xUM8F4znaHWJHibGegtWz+rmPa3lqvcjH79+GGif
77rCo1v9hdsT/HytK3rJ8j/7IB7iIR7iIR7iOTyl2XNg4ha7ZjuUt9LvMFlz
qOK5wUGG5pSWjK/y0xv/6rdrbXXovFDVP3HMgxHV47rqkap6iId4imeLdfZi
e4yHGT/Wxm8sGGDLvA/DLljvMLq0oox6H8Pf2F0U1dg//a8vTtqufgDxEA/x
WKB6RKiekar/z33xFI/I/7lvdSVcTv/Uzu8sGY7c8gGsnByY9OuG8Lj6vCzX
4XvlPXSecs2q+NjNiIvb/Elzhx9b/y9xiwc6
       "]]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNWPc/1u/311CJMrKSSjJDpQ+KjGNFCBlllC07e2e7s7Ldr/vmvm9kRJOs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      "], {
       {EdgeForm[None], 
        GraphicsGroup3DBox[{
          Polygon3DBox[{{1, 2, 8, 7}, {5, 6, 12, 11}, {2, 3, 9, 8}, {3, 4, 10,
            9}, {7, 8, 14, 13}, {12, 7, 13, 18}, {8, 9, 15, 14}, {9, 10, 16, 
           15}, {10, 11, 17, 16}, {11, 12, 18, 17}, {4, 5, 11, 10}, {6, 1, 7, 
           12}, {53, 54, 60, 59}, {13, 14, 20, 19}, {19, 20, 26, 25}, {16, 17,
            23, 22}, {17, 18, 24, 23}, {21, 22, 28, 27}, {26, 27, 33, 32}, {
           14, 15, 21, 20}, {25, 26, 32, 31}, {15, 16, 22, 21}, {23, 24, 30, 
           29}, {24, 19, 25, 30}, {22, 23, 29, 28}, {18, 13, 19, 24}, {27, 28,
            34, 33}, {47, 48, 54, 53}, {30, 25, 31, 36}, {31, 32, 38, 37}, {
           32, 33, 39, 38}, {33, 34, 40, 39}, {34, 35, 41, 40}, {35, 36, 42, 
           41}, {36, 31, 37, 42}, {37, 38, 44, 43}, {38, 39, 45, 44}, {39, 40,
            46, 45}, {40, 41, 47, 46}, {41, 42, 48, 47}, {42, 37, 43, 48}, {
           43, 44, 50, 49}, {44, 45, 51, 50}, {45, 46, 52, 51}, {46, 47, 53, 
           52}, {28, 29, 35, 34}, {48, 43, 49, 54}, {49, 50, 56, 55}, {50, 51,
            57, 56}, {51, 52, 58, 57}, {52, 53, 59, 58}, {29, 30, 36, 35}, {
           20, 21, 27, 26}, {54, 49, 55, 60}, {56, 57, 63, 62}, {57, 58, 64, 
           63}, {58, 59, 65, 64}, {59, 60, 66, 65}, {60, 55, 61, 66}, {62, 63,
            69, 68}, {67, 68, 74, 73}, {65, 66, 72, 71}, {66, 61, 67, 72}, {
           63, 64, 70, 69}, {61, 62, 68, 67}, {55, 56, 62, 61}, {68, 69, 75, 
           74}, {70, 71, 77, 76}, {71, 72, 78, 77}, {72, 67, 73, 78}, {73, 74,
            80, 79}, {74, 75, 81, 80}, {64, 65, 71, 70}, {76, 77, 83, 82}, {
           77, 78, 84, 83}, {78, 73, 79, 84}, {79, 80, 86, 85}, {80, 81, 87, 
           86}, {69, 70, 76, 75}, {81, 82, 88, 87}, {82, 83, 89, 88}, {83, 84,
            90, 89}, {86, 87, 93, 92}, {87, 88, 94, 93}, {94, 95, 101, 100}, {
           85, 86, 92, 91}, {95, 96, 102, 101}, {88, 89, 95, 94}, {90, 85, 91,
            96}, {91, 92, 98, 97}, {92, 93, 99, 98}, {93, 94, 100, 99}, {89, 
           90, 96, 95}, {108, 103, 109, 114}, {96, 91, 97, 102}, {105, 106, 
           112, 111}, {99, 100, 106, 105}, {100, 101, 107, 106}, {102, 97, 
           103, 108}, {98, 99, 105, 104}, {97, 98, 104, 103}, {101, 102, 108, 
           107}, {84, 79, 85, 90}, {106, 107, 113, 112}, {107, 108, 114, 
           113}, {104, 105, 111, 110}, {103, 104, 110, 109}, {75, 76, 82, 
           81}, {109, 110, 116, 115}, {184, 185, 191, 190}, {113, 114, 120, 
           119}, {114, 109, 115, 120}, {121, 122, 128, 127}, {112, 113, 119, 
           118}, {115, 116, 122, 121}, {116, 117, 123, 122}, {119, 120, 126, 
           125}, {120, 115, 121, 126}, {117, 118, 124, 123}, {122, 123, 129, 
           128}, {123, 124, 130, 129}, {124, 125, 131, 130}, {132, 127, 133, 
           138}, {126, 121, 127, 132}, {127, 128, 134, 133}, {129, 130, 136, 
           135}, {125, 126, 132, 131}, {118, 119, 125, 124}, {128, 129, 135, 
           134}, {136, 137, 143, 142}, {133, 134, 140, 139}, {134, 135, 141, 
           140}, {131, 132, 138, 137}, {130, 131, 137, 136}, {135, 136, 142, 
           141}, {137, 138, 144, 143}, {162, 157, 163, 168}, {140, 141, 147, 
           146}, {141, 142, 148, 147}, {148, 149, 155, 154}, {139, 140, 146, 
           145}, {149, 150, 156, 155}, {142, 143, 149, 148}, {144, 139, 145, 
           150}, {145, 146, 152, 151}, {146, 147, 153, 152}, {147, 148, 154, 
           153}, {143, 144, 150, 149}, {163, 164, 170, 169}, {150, 145, 151, 
           156}, {159, 160, 166, 165}, {153, 154, 160, 159}, {154, 155, 161, 
           160}, {156, 151, 157, 162}, {152, 153, 159, 158}, {151, 152, 158, 
           157}, {155, 156, 162, 161}, {138, 133, 139, 144}, {160, 161, 167, 
           166}, {161, 162, 168, 167}, {158, 159, 165, 164}, {157, 158, 164, 
           163}, {110, 111, 117, 116}, {164, 165, 171, 170}, {165, 166, 172, 
           171}, {166, 167, 173, 172}, {167, 168, 174, 173}, {168, 163, 169, 
           174}, {169, 170, 176, 175}, {171, 172, 178, 177}, {176, 177, 183, 
           182}, {174, 169, 175, 180}, {175, 176, 182, 181}, {172, 173, 179, 
           178}, {170, 171, 177, 176}, {111, 112, 118, 117}, {177, 178, 184, 
           183}, {179, 180, 186, 185}, {180, 175, 181, 186}, {181, 182, 188, 
           187}, {182, 183, 189, 188}, {183, 184, 190, 189}, {173, 174, 180, 
           179}, {185, 186, 192, 191}, {186, 181, 187, 192}, {187, 188, 194, 
           193}, {188, 189, 195, 194}, {189, 190, 196, 195}, {178, 179, 185, 
           184}, {190, 191, 197, 196}, {191, 192, 198, 197}, {192, 187, 193, 
           198}, {194, 195, 201, 200}, {195, 196, 202, 201}, {196, 197, 203, 
           202}, {197, 198, 204, 203}, {198, 193, 199, 204}, {199, 200, 206, 
           205}, {200, 201, 207, 206}, {201, 202, 208, 207}, {202, 203, 209, 
           208}, {203, 204, 210, 209}, {204, 199, 205, 210}, {205, 206, 212, 
           211}, {212, 213, 219, 218}, {210, 205, 211, 216}, {207, 208, 214, 
           213}, {208, 209, 215, 214}, {206, 207, 213, 212}, {193, 194, 200, 
           199}, {213, 214, 220, 219}, {214, 215, 221, 220}, {215, 216, 222, 
           221}, {216, 211, 217, 222}, {209, 210, 216, 215}, {211, 212, 218, 
           217}}], Polygon3DBox[{{223, 224, 225, 226, 227, 228}, {229, 230, 
           231, 232, 233, 234}}]}]}, {}},
      VertexColors->CompressedData["
1:eJzt1rEJgDAQQNGgU1g6ya0ggrUgWDuQLmSrC4hgo4UrmByeCwQhxf9wHLw+
XMpuqPvMOXf6yf1MY+iSdQntUmmb4Gl6q92fuzccx+PdsvdnG8fxeE/tnuI4
/zEcT9MLbRbbjXYIjuPxnto9xXH8P38AsabJ1A==
       "],
      VertexNormals->CompressedData["
1:eJzFl/c/Ff4Xx1EpIkIqIxFSRqGSVCejnUgqCSmJZHyKaGgqCYWrjGighYiM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       "]]}, 
    {Specularity[
      GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJzNm/k71N///0XWIuElWhTKVpFSKPEghBQhhGRPtuz7MmOGWTEzKCqRFiqi
RKj0aCGyb0XKllJKSCKVPvP9A96/f3+Zua5zPWfO49zPOffH7X5dM/IeZ2y8
eXl4eLK4L3zc9zjZzMPP1NKx7dv8jPtfDtYaEDZYuRFQYvafooRZOkZosdat
usjByvQOVwvTZKyxvN8nqs3CB0AqMrXg4Am/3cfU3ckot0tHy38fG50EB4U7
j3NQaN5cZM1ZMto2LGt6to2NFU9MhhUfcFC0+FfjuvJkVAyz4H0sy8LAShu7
rysz0aclq0s7m4CuP5+4WV1Jx/gPF2ftVDm4IN1bf3IhEcV59Kmjk+lIk3yz
xqKSjXc/y3eImRKxI5fc0ZLDQs2kNcnSMWzclCGh8mQ3CZ+ob2tyzWbjy4dr
GifLuXW9auZkOZPws2rQ7v+C2fgo/c2Vhc0c3BKdda2STcRNLKEbukdY+J9i
nu42dw4GXjt4QcA4CWPHghuHbTKw+fzd7yc82CjNjOGT48RjhmWl4pbZDIzt
be4JfMdCAU+z0MN9SViwMbT1ohYbBRstRWUaWShSYN/LqSTipNepAfJGDn5I
uud5V5uNslfk944PEHF0R32pRzsb95hcIBY+ZONl7drkdh0C0u9vD3XMYuEN
m7XmC51s3M1Z1dowGI8e545u6t/CQpcLtx8+y2PhvBIz1zM+BntU+kbFa1ko
+ejRvKs0C+PVMqLTtsXjD8mW9eaiHFSteP+AasTCuNw95wa9k7AwUDfLvIWD
VMqi8ZqfLJxbPvCKfyoJd7y927lah4Od3l+E4xPYGLysb35APwHFZ+rO9Y9x
9/1MvYnNUTaGcHb00/lj0blyheDXFyzc6xX89vFyFrLOyYoUbI7EJ9QLC+65
bMwR6rMla2WglcJ7+tRiFC6zoGmu/MhBRwW57wOrWJjLPMy4/jQW32mPR4N7
JtoU9ATMTrFQIeCbiNi9OIzycqC8zOAg8BzfGOLERs+RzfS6dzGofeX0kU0H
2Kg1quTwmlvX2qhamqB0FOqVVm+mebHR9FOmyg//DNx0a9HZ9nkotuaHeb48
xkHPqjTm0W/paL9SRvLaRBgOtP6cEqBnYiIl26J8M1eftsr7TV6R6Cj8eD9v
ayY+sBxfL7yajX4ae65drI7CF9LL/+EAB0u8J/zeWHHnb5P5ZsGJxJpPhFBy
ERvdai58tClk4aqVceZKMuH4t3kqaWUPd1/L8zsjTTJw8M7Z+kcvglC5rDtZ
po+DY3r3K+RUMrBoMdNk//Jg1KiTH/dfysTl/aH/aUay8P69u+oH94biigmG
WcWmLAw/vDS05MPGVa1Cld/bw3BEoNikaD1XN8r3bzcj2OiwFWyyNMKwf/74
iO1PNqKl8y5aJgvNQuRP038FY5NGw7vYSTZ2zOa9WJRkoXbV7s6VeAqDyhQd
k79zcC3P+U+JKiw8yLgQrH/SF8ODXiYM/s3Ep0bkoFQ57ufKb5BDNAOxt1RS
ddfyLNwUE9otzMPBqzw34nXvBuMO9arbW/9x8FVA5N2UL2xcL/2zpMAjGNXO
rKK1z7JRXY25LXGOheUCgyZis/4oN2F4weQtG/fddru+roSFYiKjPZYr3fFW
yykBAa7OfWuqbEO/sZCjvWR3f7M71oTQ331tzMSxV72Ejjk2ah6ZUo+95YN6
WhRzyepMtN1WwNNXy0FL7efULtkALDvqPmhTw8Gqpxa2xGgONgoXC/kuC8DL
JfqCAc1svMm3VUkxhI1qs1Xq12J9sCedwn/tPBu9Bni/bOeO85a1JD8TPYbZ
Ru5SK8gc7Gib7fPk6lfOl8K/J98OD431lX04kokCr023buKu+6f4b6JvnxtC
V6Se045M7PhSnHE9KxMfRbx+HJ9zCpPk8rb/MOWg18L9y8EymXjqUFzis/ZT
2BS/hSMbz9Vn2svqngAHzR8a/Zszdcfk/5jn16hyzz31itgxcw6m2vhIbZMy
wQppC11+bh36y246pyxy0NWJ0ld71hgTgltd9mdx8FPftS07hbLwys7O+vTT
x1GqiTNCieJgjfaFwtteWSi9tshVz9ML37/oMTpfwcbBuqxjiRWZKN93qTQn
2Qtlg45u9FjJPd/jOYzOa9x1q5Uv4xk/jlXVgifqOSw8HF7E4FuViToXuhw6
L27Dh1+vxu5SZ+OQMHUw7n0mlvyStf3TtgNjpCx5RGvZGLHxdo7H+ywU6vuU
3yV8DHcI2ftG32RjTP7svw6xbLQm5RcM53ugWk+1hcgqNo4LS5Y67s3C9sCa
rW1WHhhYsrp+B4mFR398/R6yNxP5kq1bqE22eGvfW9fIfK4Pn9v8o7QmE3mC
DUykOkYNku/5SacdZKHx09lfkoVZSK7KfzY4vQ6fJt/96/ychUrLZbqZadkY
ECRts03aDu1q//51bGKh/rrA6/msbMzade7oEWMPLFZctoZylIXh03kFusVZ
GPxT6+D8UXfsuBl6MvhGBnJux7zAh5k4FJOm0mFpjcPp7zQUKGnIpyLZKqac
hdjdOJ4xJoMn3ttqdHL7bHDcF79M2WxUEBZ4slC2G21nyiWV1mdgTZ7xhcH3
2RjudrWk1/U4ttw8t9B8OgOzA+q3X3uQjS83X/79u8YLrezlf61vSEcV2cmM
TU1ZaHyzzkO+2QOPmz2XauxJw6GfmSd7uf5xMnKtuf+Vo+gXZb/f2oKBK/74
G+py913nOUNScJc2HunOT+duLW6jR7h/t8nG50ne2ke/m2H1GSkBwWwmXgxf
4Jn7no2fg5uao35zz3O5wbYMozT83BFC0L+ajdHnjw4qe/mii93PN/OzTGw0
8nVLqczCVRWfQ3+IeuP3+0TPvnkGHnf8wD3DWahuPPtZ/pIdphHsNf3W0rDv
T9nLMwFZuE3p7Dp1VzP8Lim5XGU9DcXhG+GVYTZa1U+TCz8dw8iLEv9KNen4
QVRjJd7JRh/T2MB2WR/MZh9TjjRhYHKO5oiRZTYKH/38luIRgDuWcuyqDzDQ
4tis2tvILPwWZS//NOUUlkTkHt+pTscIyt387wJZ6Kpy4ysFHdE3/NayXRIU
LJIV/bBXJws/zRuwzkzY4rIpi6dJo6l4fr+Uj8RYFp5iHYiskHPDJ+YhYu/X
URHunM4rVeLuY7zA5Cfwx4+qC7m/yDSc46m2DXmUhZWfu5w61wfj4TLH/pJ7
NOR9V96VuzoLF/STBZXF/TDdbmeaeRwVXU47X1hqy8T464ny7wdOoE6QWfGu
gBS8uW+Rv7clE5UFBlXjhJxR0/HIeY1tKTgqIfdvtVUWdmgq6HRyvFDzg5fe
k4xU5KTkib8KzsLmwfC2s/QzuJca8dV+FxVF5H+pnBDPwhT1l25jNSEIl84s
OoVRscu8V2NTeiZaqbvL7fYOQMPVxx2bVlFQ4fUxOZeATLQjilHPBLqjjO3m
8/46ZGwTSHGd2cC917cLczeQ3XB8ZF6l5w8JyaF6F5PjMnH6Ttp+qfW+mPmm
3qUnIwUf1ukM83P7quSG7ceN7UIw1BiXBbhSUC8/4eM89/4yh/IMSW2heKXy
ayjfeQqm7moo9nnHwd4H1kOr+INw/qGcAZ9gKh4Zb/J638bB/F1kvwvRnjhb
ZVSsc56Ezx8VVSwT5+Dwvl+vo3098L9/53vLYkgYVH+i6oQhB3cXrPJaCPRD
zY/npK9bc3Vz76/1PshBv9lx+dpNobg1RU9tixkFS35eerh6PQczxh4eqhYM
Q+H9Y39KfSnIO/WppnKCy49enitmhINw8tj4g/vsFEy3CawsHeP2C7krWyP2
cP1TUe2qK5crDwtlcdq4HCJHdXu4UcMTXS5NVGVGkbBVTWJL9jALfwbFVIn4
++Ont6/3SVxOwaOkf5t9P3F5SbK32U89FH8VLL/tfJuCx2qCOOE/uDz1x+2x
Ey0UCUrGF5Q4FOw9O/2vdIGF+atvkF++CsC5cXvpYl/u9+jz8QxMc/3pePSV
f2OeqOTzccupJBKe8V7eqs3IQIvmmcRNnzwwbvla1a4pEu6qIke+25iB2wfe
Clm3+WHl27OBJ1xSsd1M66zxwQy8+rS4vs02BM9LD99OcKTiDbrnSoE3Gfgk
Y/LJicMhaBpdckviEwW/XwzRLFdg4eVV078Y9/xwRYHGKUpcCl7rzr38R4yF
ZO+4KP0BDzT3H65U+UtCe2PpbYM+aXjCk9jSEOSO6wjqkN9Ixqz3wdTdlUwU
vu/2PDfOFx0HRp8/5p4TpYe0cQ5fGtbZdGk6bD6Dz+TNH59WpWHs3MGJHL50
fHHeq8gQg3Bm5W+t2RNU1LOfTDOsTMd1B1PKgipO4b07puVdL7j3KKFHfcwn
HX1uSRrdEXHHq9WyimL3yOh52y+zMo2BWw3GGVcETqDQrZ9p19pTuH36dH3W
Azp+2dIR7pbphd4fFkAmkYqXXZw88nUYeDOSVvzR3A9dt8vRZsXpuD3esvUl
hYkShj7bXadP4+JeQzmXOSp23zt84ctxbv21tESrYU/M4zHw/2yaitOtLkvD
b5m41F2QzbF1wc37elyVufeF6TvScVGXjmt7dXZFBdjivigTqYtfUvHfrYXs
Mg8aGulK7SM+PIHPXPc17L9Oww/PGBnCUnT8ePScVc+8J+4Uwad+yxnolCP4
3PoiA9f0Vv31+OyJ69qOiP4souG43fTS/jAmCppyZh8kn8Csj47OdpOpuGz/
Cf6xJwxMGIjKyLKyxZjB75IjF1NR8Frp3QgWDaVO9KYbDWiiqI1clb8OFe0S
TE1FWqnIszhicNXMHOfiKWNWY3Q8L9rO7mik4VbJoV252+zRXKs++MYPBmbW
15nzUhl4gcRudqU4YCXmtskdp6Pp5JaqwENMfPrg1qXaiiPYlr2jYG8pBXlO
5PkVWTGwVy5/0tFUGzeMsoo+cf1B9ortOusTNIxuHT4a3WgGlq86B7yjaCjD
OZfj0U7Fskdd/ZEm+yDL5c9qFGRiXdfDXmFFOt5dfX0p2mMzln77IJn3gIne
my9lX1rOxE3faWKRLrqYuHh1aOMQHX12O8kwOUyULOrbPEoRQu3w2Bv1R6iI
P7QGxvQZ2O1oQh/YaQgO7Xv+vven4mdHCcvKC9z5tzlTnra6wMqWiz7jwXRU
KOtUYLrTsMzE0Ol113FY+JOTx+xk4nVmomgdHwPfLLcynwBr0NDU8Fffnoaz
kgHyssNMHLKbfNlhewBitZqWbVVhYO2jEgujtWl4V15+S5G5OWTwtb5MeUHF
PcP/TopHM7CkM/kK7rGHU3IaBgOCNKxrzXjWeIDO5VvfnJ4wH8jUU4+dlmTg
oJJenVEQHVvlk2RShX1A1eB+V7lWGhbMexabWXJ1IChvkOJzh0xFw2ln8zQ0
OjN0rudfGr5lhhwYaXWEU/xGlab7GaggvSvPqTcNu10OHEgsPA6dvDUuqdx+
7WayosKO2+f/s/61/s5rd3jdncgbfoiGKXuvlXxzYqBZwGYlb2oQxFoWSERy
+/Kmg8sfv55k4L2c6WvybUHwo23zBm2FNPSqeqLkP5+Gmv0WxBr709DcR1nz
UygNV8luiv8vKAONJ/veZuV6goqbj+APcQZGrHxyettAOvbhyhN9tp5w+93I
n507abgjj483l6u3E+EuEZp9IV2iIU6nj4oSpjPEuBdMlGkIKLH1CYVZ3m7n
nlI60vjKd4jfTUPnrNJF0ZJQ+F0os6XTnolh0P+lpDMD1edSrEdNzsAlm6Ni
O9WYODskH+/E5dANWzRWaRX7gq6HsfpZOzrqEJ9uFuf6Xja1NPTxel/QfLrk
lXuLiqn1zumkP2m44WHyml/qQdDRrkj+UE3B19M6Fc9Op6OkdvSPeHI4PFUv
Fcty4uqpYFkizeXKNCbfp9NPw6Fk29I6jR46Puzvpqly+0jhzNSDr0YhcLW5
/tK6EjqShRdAzpKNkbyFOvwr/OFugJ5UoAgNMTjoeTg3TxEcGEe3ZvhBY9AX
gS4WBX2tifKlhhl4y7S/R+JFMFhUbbKEfalY+ebhwZ38XK7f0/X7+EwE0P5S
335Np6C9SdXiRDsL+a3Y95O547/tzB/vf0fF5+36MQutbJQu2lH3930IbPO+
vHr0NRXZU63Gh5dx8E2LvERBiT9MbtAl7iZTcJrcw87aw0bfC1fOH+GOxzdE
XxrbnYrJi4ckKTosvBJx17SE+z2Prwr6bskh46ut+naTNSy8mblBVS8tEj6O
9Lr/5vrkZasa25rLbLS1C5y+JR8Jds5FQV21qSgfw5y7Q+GgVuO/fdrnQyDv
3E1iN9ffXiWOnRtM4ebIn2TCtT9+EOX0lvJ3LgVXOJ/OkbjExtSIDzP13f4g
NCISp9RMRobm2Z+y1SwcNXUrdQgJhcd6C5l/m5Jx2820feHcvD9KCcoSCI+E
3VPBqddPkXBvrb/LRyNu3vohUVpGiIAmC1tf8VgyPpT3FxISyUThylmdyfPB
8Hn2oUPnNzKqxzAz73M5x0TczZHv6GkIMzT2VjlKxk2nb4eacHlDe88a5Tva
/jD0wZ1Up0/CS8vKGhQV2fj7zU3BC8RQOOPKEo+vJeD4lpO3A6vZKNX1YJNG
aQTw24w6fV9BxLFbNyxri7m8JND9+a98OLAvvWoelk5G/c13ZX5wc+px64jG
DX2BQJmP/u7YkYy50sGmI8sz0UVNemthsg/M8CkXjyYm40XWluIsKW6dT8Zz
lueeBu/7O7V/hBHRSGbDW6cgNv5nsNImhDcUKjMviAz4JCDpZN29rntspKlR
Gyd+hIH8/VbW+8oEXOrxeHDlLAclPsqc4v8QAh6eLg9T+An4ze058fzaTFzw
VcvdvfU0JPTrBGYLEdEzimiIDzlYl75MeWuJBzS+2Ki2eoSAn5a92zv1ho0l
a4Y/zzX7wLcku4DFgCRciIgLX7Bno/+jsAzvymBI6k1pt56IwRW2be9a3dgY
jm97zk2EgIBkivHYrxiM+WcUWafCQf6/wXe/EYJgOruojnQ7HiMSfrjrUTl4
xGqZqm2bJxwbePkswzYJ+aw0K5s2cnDG4t72mSEXaMtrPvLnQBJmFz5c3+/A
RqcbCum6zz1hbO2NHpeMeMzdvELTmctpqx04a3ojgyBwiXbZ/34krvA6fH2u
n4U9+YoXDyWegQ33ryqbX4/E76/OrN4exUaNLpNqyhtf+DDn8qZoJAZtTs+J
iN9hI/nI5m7CDRf4F7cooKqegM1Ux9wHh9k4nxn9N+aDHVg/GyIcMkjAsf/2
qJPLuTy25vwoQdodKGTltq98sUgmlWtdjmQh8+lhTbOL/iCScksssTcMfQ4/
Suz/j4V0t63vcxv8IEmw6tvnV2H4L7hfyjuchYwxjX5+CU/Y8i9Hf/RmFDLW
pe+5SWPhjxVPaGoUG7APD7kdlBCH8YVKTz2BhQVpOydGr1vCyIxPG298HNb/
lXIsf5aBLfritNyHJ0BvkZQoUhyFpcW3pJRyM3A+4bXjoxJfUFm7I7XmSQgG
dYjFjR9KR9URfkeNFz5wUyvj5viKUNxl8lSWj5mOI85K/9jWJ2Cqsu+3nWck
Gsbv8rRNSUdppXmWWOFBuLf+mUpWcCzS9WdEqfrpeMg9IIUjZwI7eb2W+yjF
Yn3T/jMBS2kofe7C7H+tTjBJWFux0BaB9zktW9bzp+NPDcVj1ko+oG0SGelK
CcZXzsf6f+5n4jIen3VrAr1gJpu1P0I7BGl6MXoH5Zi44T/Dus13HKGMTJ94
t4y7v5u7yPW8TNzqvXfC9oARVCj4dWisj8U3aoJ+swJMHI0QMg+JPACLnVbC
sgExqGzxXuCKEhN7t6zaYDR2HPTeH3MpvxyO1zzodZuNmKhBlg0brPGCNQ4q
Q5SbwRhsredQokbH8bKSRpEIbxAuNGhM4uqWXKVkLoI0zJM68KU90Bms4NEf
9ZFIrK3/dJGnmIYHvs15ckwOwZVMRbOPn2NxOAiXchZpeMucs1+8+AjcMVt5
8ltXDLYJvVq5z5uOy4OHnh/ucIWAm+lqBhXhePaXZI1xAh2fNEga3DzsA6WT
xxumYkMwVyWkWEaPijtfRWjft/aFzOI7LXfEwzAuwYUtcpaC/12I3fh0uzsI
/o1y146Jxi/afA9Kr1FwmCOdL2ZkD9lnP04tHorHmLy6367OVOzwVtcgBTlC
+UD6Z52qWDxn1i0RuIyG/EGcsj1OnqBHabSrOByByunbPjfNUPHmY2LSjM9p
2OYgEHynOhSbBQTXOkSk4u7amTeD7AAgLVyO+G8yHG+I5GlSC1Kw9Rw9mxLg
A2tdhp7WsmOxSJ6jdXciBRs8r9/esscdXOSIIn+WJWK91szGW8IUVLVRFV23
xQP4Ez4sz2mNw/EdzkKxgxRkhbNsQi18IUi2+P53lUj8LOvDb51FwXPF4bo9
hECw+juAyRHhGCdqWlz7iozF7ygbVxwIgY8NeXYp9lFYlXpwIPsbCec1zlu9
ex0IMttmpvpXJaDcH8KEVAoZSevs+cViTkPFi+T5rZ+S8NBCdUM1Xyp6cSg3
oxpPw/ol9FQVTEDxpPuZ77j54OGGv7nlXJ/5khPY2HM4CouFE8mux1JRJnfT
98d+IaCknhLd6RyJ+699ZQiVkrDNK+rgle5wyPQ9vCuyPgb3bZ8f63mVjCcl
z5t+NAiDtZbpq5x8k9DAgbB/Zy0JO4mWW96eDIHzsaSclg4CHvi1pPcsLAXv
Gr5dniEZAi9q9SN/aCeiSciP9z/NuX04s4bfsigU4PXfXPHsaDQ66M/I9UnB
ss2CyvaUcJjaZVposBCFH8e1dfZIk7By7GlUECMaygSl027WxmFzyUanF6eS
saRnlf4aVhTse3JnKiGPgLv9b9/emEbCm3siBY70REBdVrBiSDwRa72OjXx0
S8GK4gyht5IR8OjYapeoPUnYmx/4+Ngqrj7VRka7VkXC/JtnwkpVMeg/Muj3
9zMZH9m/jfnzMgpCtITolstj0ICo6ajjTULq0/EIDU48HKRLLC1bise9j6O8
/KeS8ehXnpYwkXh45yf/1Ho9EXe43HmvYkNG7fvZbt2asVDirdVc/5CI2x9c
ta9QS0U7x9X534ajgRzhqvAqKQl3JrhaEApSkaG+YHbTNwbE1dQv7jGJRb3h
zc1P93Nzs6fnPQvDOHikENn4LC8Gw1yRrr6JjCL5L08LAgEEWmJUDB4kIHvj
g+nDf0hYTmc5PtQiwM5bUjOJVkRsOnDnb8zFFGx7WGGgbp8IDy9M5BXcJeKH
6yVXU924/MWsnY45Hg8a6Z0D9QeT8MWHO/qnuFx2tVJdUjw4Hjr5FBQEvWIx
48kDzX1jKbhH7CLZiZQInmfrFu88j0GO8qEgYa0UzBMS4xOUS4bCHgfHkoEE
jKbNOPHEpGCL/6aRu5AMIwKPdvxQJuL3m0ZhMocpqOifprF2BRFsyESBbHsi
pvpNXtJ9S8WzYh0Gt7yTwOfl6TKNs4lYIHTwrtE5Kuqa3SLZbkoCE/bB67Py
sag8Pper9iwV66/6hj2tJ8AFe2l9D4cYfCUkNd9fnoo351UWl8ZJoHiEZ/q4
WgI2VrTE/wmg4FvLLdu6FcmQ9uRvmjyNgJcKD/bxcnO0yMRWqwdVyWDsJnDo
fCYBkz8K3/54nut7O/dAuygReJoUxvTsEpC176jK80Eadr7VFfvdSQDhLOVq
W65v11q+ann0maubwa4vEgbJUPQi+HDblmikd0ph1AkqNvPabeq3T4FAG9lg
sfQ4XDSrLNVIouGnuM8zZukpsHKS523hXCJW6zyNc0pgIGdxlC+bW/+HPwZb
5n8kosAddZfW40yU5zloHCKcDBtDz/HeZ8bhWd30oP90GLiccid0WRcRCK/L
zipw5+0zJxZM6NLwuFC1W2U0CRLO3RF9aRKJt15Ux/+a4vaFvMcvlcxTIb8k
qdzDJIabD5dPtDkycGNQnuIV31TIm+181WUbj/+56n+ps05DYb/edl0mGWK2
2Dvd9IhHk+DtSf1DaRiWraFox0oGB3Hq/dWeMaiiPrp6eRQTZ54fffk6OBkc
m3azL9tF4kB/kbhUEh0FmmTlDA+T4ehyMc1OpTD8SprpSndhoO6Uv4BUWCqo
tlcq69yLQP0vxwlv5pn4KaX21aJ/KrzgpWtEMKJxYS17Wud5Ol5dSpjf5kyG
DP8qONQbjW7vT1YcmkvHO8PfD0YfTYbqAjGLsYORKBY/z8/jlIa8Flej2I7J
IBu416goOAztLDH7choDTTqH7U+eJoNA6/Lnwe5BOHu/t3jfLSYKFZYn8xqm
QrTZI0aGXAgaGra4D0em4+pQq9jCbylw/f3k4/c9YRiB3sNXeFloeiei2DCX
BEMXPV+65YXjAe0eH5HGDAzd9HcQzhJhora4gFYWinOl70q9ubnvtLXreMEn
IkQZTPf5fT+Dh4MGjywFMlFrtU7NMn0ymN84PeI/7I37e+9WtpSlYaKzydXw
2ymQdKyRwDb2xenQM4kjqRkoy3ch/vMcGcRz5GImMwPR0s56f48rC4WyGQYX
TifDnjUrPrMNgtGsQMShlJtDXZKU1PqyCbA7+f7OpbVB+LbQ8YOJaTo+ed1x
1PMIEa4auO8tbPbFXYHKnxNXpWGXyXD6nTckuHdc5kbMghPuON7XsvNgOkq9
KBAKayUD69yeQzW7TqDTNinbul8ZyD7w/UFoOQk0/X6ob53yxIyZvInBUyxc
dXnnxgjufS85rT/er+SLVQ3KnZqzGbhh+YFLUwJJUGehIb1X+BQyZ79YXId0
ZPF3rIsuIMCxba+YXyrcsUnveeN1vzSULM6ojjAhQYdCa4lkjwlOHq0SjbBL
x+a0hMseL0gw/E1b/N/ag2iqZZM2/yID90/p/2twSIZh6UINnYf2GDIqHx67
mYVHXXzneY4lwRbfGs6jK26oGJb77Ix9Bpqu6dC61R8PCpWDNbw2bviS9ffA
5GgaetgdjhmtToJuC+0Wy4hjqM6z8vOUexqa+GvifVoyiI//vvo6XhHOHCxu
KnuShvqnEk419STDyje+r69eVgDVmLjbXQvpeL6y21pkOxGoWSV9e3iMUZgh
rePJzd2JTUzhQYEEUD0yLsuva48a/oNvO2zSUZxRf2kLXxzQv2rhpQ32GKG7
YqF0XRo6fJNpuWKTCCvF3ofkcQ5gtnJw0IZuJgo2yu6c5PpAm0bfobDjByHz
8uamx45MDJaWJK1YJIK46C4HReWDcKnNvFnUPA2rrhkmS6sSwMajxOFbhQIa
bGl1MfJMQ+O01oUp0zh4LLrzoLeyNfYe2fpVJY2JrPLabxffxYBH/JDlfjFr
fCkvMPHmItd/OCemU5MSgGxJuhskL4+qzcmO15MZ+F+x8JK7CRFE276SsdAW
wl8p2pT50THDf9Hs5V4i5O/sDqC22sD3N4c3zX2n42GpbU2piYlQ2xQxc5Kr
5714yS6Bj3SMOsj6av4mBmjm1eXBOy1wQbasssuajiH7H/Wt3R4D5RIpBB6q
Gcb+lzLObKShAU/qZZXNCbAPKTXTp3ZAddjj3XG9NGR8FH+8c4wA/OW6ry79
cYSHqkcFLHdRcX9iQN61CgKY//thkRdlD78E/6mpcjl21aOTB8lHE+CiVuo/
rNoKZXUX3HatoyLrYk8pv3EMdCbn/XslbIEq5+ghbjMUTHzwVPCIZQy4yEt9
7v5njF+q31qSPlHw0+K+31IeCbDS+kdA1TJD2M0La2KEqViR5vmy6T4BHNxZ
e5pXO8NN0t8br5el4udt8d/exRCgW/9mYK6vPTSsVlJ9diEF98GzeyH/JUCA
c9ehlXMyoO9vUVSamILf9HYfsaqOgYbLmXuYhofx/B7T6yUvUnCv7dtVUbqx
8NTlxVWVqQOYWLxB+cn2VOwIWK3zZE0ihPdKlPo+MwEBq1/FryxScVW1VXtI
LQH0yj06ewqcYNP6SlLUGxJSQipB7goB7kxtrFxEW/ixRsCBV5mE69MCzn3t
ToDQjtlTYrkK+G1L3njJJhJ2VanX2K6NA2PFNzu9KEdRSuf91ZZWEsbumXou
0h0HYfXq26WsTBD0OJ2GRDIGMCdvO5kkgZCY2OvN/aZgqv4bzlHI6HwnuyHm
HwFOrrF2Gk90BL0Xj20KViRjzotva/6zIMItN+q29fJWkGHl6nlJhYjUgul/
JheSYMRoesguSx+TRh5GvdAlYrnM3ffz3gnwyG+H0cmvx3D9l/i479uTkZjk
Np+mmgj+guZ/Vvwxx0aPQb8f4iSUun9dUpdNgNux2gV7zxhDf0eSffO/ZOT5
XS8/fIsIvfuOl2b020KM/INdcjUETGjSEdxyNxmOzVe7FNOMgGphrHyXnIRF
mjIN+WFEOLJzr89jW0tcPl64t2sFAS+wpU34EgnQPpn7Xx+fM/6++pAobklE
T9pu/q8NBCjannd2/Rlr3HG593KvUTLqyNubhvAnw42LIVtPLO2D4KGeWJdf
RDR94vBC9HcyJLzwyJ72tYSz9hWDv48k4YrJ2gBSBhlQ/0oJkSgDgmme0hUe
CVh7JY+/oogEL1Ozg3N+HsOAJzte/+UkojEPSyG8PRleCwn6hHu54Z0hpfLG
1wTceD3/Ov9QMgyOKF2krrfD6OdHpCZbiRg89VD0VQMJnjQ0xBis3gqmap8q
Xuwm4kfOy2mpfDLc7djjYFIL8PFL66O/KxKRT6prKKQ4FW6fdZeJFNTFqxXH
Xjqfise4Ly5l1UqpoLJ76PWQ8QlcryJ3CA8m4jXzDwc/uqaA9bpfv4N7PNDf
r+yk50cCHusYFW+VSYF8X/2GEWEHZKb6H79XTcR3Cw6GqedTgEDxGuxMePDY
2lJQNrmRgBXn24sdPVKh0RDXrypTA6bvJzWD+gRcsX3NP6VKKlju2L7C9osZ
vrFrjea7HI9HdXlGJNOp4PtqufqhPe6Y+mvEJmltEv6RiamKaKRAunjR2O9D
Xvijj3pmnQsR3b8K3ZxQpcAjwka3gBZHbPM4a6b7jYjrhjc2/rWmQKGb5+E/
t5QwSpzpHHeHgME8Rd8vSFMBrh7Mwl3fH1cQim6wPRNx+e7prvcP6GB9n4+d
ybHGpZr9wpfeJWDN49GjR/rpIHrwx8/Fax64N7tQZMKPq0PPn49LgnSQ8hEd
bHrnhW07BoaXVJNR33XzX2NZGvjt8t3eHnIcVaTE7ywEJCOtWzPxzW8qJIaK
GlWM7MRvzitvvZsm4Ne6NZ9VW2kgvltKLvDNavwpqrJmuwwBo2yGizbcZ0KR
twvs8D2Kyfe7mx+rEDBWRsCNssQEyYTq6ZBAD6RJx+zI7iHi2iKlyV2iTFDZ
wy9CWeaFy1tCh1+fIWHNGfmnkT10+G2ecY1c7YDRCi+2mpwkYdWN38KiaXSY
7p1YbbxGE0Ofyb84U0FE6XUD8W6JDCi//PDiyyUFCNRVPxyaT8RNhx+N/DVM
h6vvEns6Ji2Qor/BkCqSjGJvraS3XUwHZ5cAzf/8TmIzaevuW50kHB3qvCAc
mgaBiu4b4Jkbzj6z2F29PQUb7Z58rZ5kQPeBL/F1ZUexv87ZsPApGd/Uq1fT
MxlgHejH4gxMG5yNOXw46XcyCjwt2Vn6iAnhhavrG9QApi95BuSakHCT/t/y
uKAMYPv9kxY03ofMNZtlSqXJ6DTUaS3ZkAGR5w++Y9g6YDnb6vHsRAoyGmjv
C+zSwe92akv5lCPqZNbWKn1LxeSVga/OMpiwjj/e7JyEMV5cuygmuSEVzf1z
9vzbxdV5Tqn115guRBe0nWoxI+Ma8vCVkGtpYLAz35GvzAoGnT/JLginoHKE
ib/VZhbcDDlV5DG+GWj2i/HiRql4vtfslJMhCwqOPNlGuG2GIa2tRv6iVPy+
MtqL8ywdXiues7stb4m3uftTWkDFllIHXqeXTHAbXn9ib6MI8lklGGX7UnD8
q7WIMYsJ/CeadvTus4R1fTfi9+aloArDL9zHKh0iLzQ3vjA6DoNrEqafc3PZ
u8j2x5UnWfAl4VyCp5cl/HTnvzVmQcWiXaXbj3uwoC/SPTf+tiAYEQ2NR+do
uE6slb3tSTrElbtU6PuvxUj7OQWUpaP9PvLXk9VMmFbI2v+82whcVwb6FnCo
+OxJo7hsBROqnr9cyB+0B4nJHe2F46k4t9b+zaWqdNCy/Hh17x4P+NlSWHzY
horrJLxm1vuz4Oi1oMM0sjN0v7I3yBTi5hFCgd+SJQvA8tRJH58joBlzWrYl
hYGr11a1bnJNB2Gt0vWczINwd3Wjy2NLBh5wvNtNdGXC2rR7IpV37KBXUKoh
5iwNA+N1R+rOM2FLg3ZWCtENoryXfQVZKvp4PP90/lU6fKbuYcmZngaR5MjI
TQwaug6/Uyfu5eqTc8DpzBNvSKnODBc9xsCKuzFqNlMZoFGk3/7v2klI0zIU
KMlh4ltxHeUQUhqk/hk4ltTlBOtjO3NPSDBRLEHHAfIYYPhtePjbpBsUHrh3
IdiMjmsYsfRpBSZk7kqxdX3rA7kvBES6ltPw27aHaZ3p6WCWdVLCkhkMveLi
UqHr6Hjr0Y+oRUYGiHX72FMjg8C9nv8/3kEGhvfQ1bvvpoObBEUvN8AXupMJ
R7ZzOfO7pF+EtDITdhX9m65Z7g33GfyURn4mFulV8BPD6XDvj8PjpuunYOvr
Vak6B+g4uGWDVfFhBrg/0u6vLg+EGtlsS9EjNHT7uF/Iuz8NXgWetXhnEA4q
H9PLYR8dQ5nZlSeT0sE28rWitn0Y+DrqBUb3M9C8V30UD6XB1gHe3T+VgqEx
qm9HWAwTx3P8vpTcpoPwmTf9VU/94ePmF9p74hhYLinaqG1CA1FXR2W+s4Fw
/a5s3NJbGva/DLvwKpoOGi8JyUaLIWCamXCfbz8N9wrqcCb+S4Pls7DSvTUK
qJaJn52+0/B6ac3oom0akAn3NgRqR4Er2eWa2SEGPvfv3n/yJQOutMneeNMc
BuHZaoErMrk8vEL3t8ROGhhlrFDU+xkM94LWxgwT6bj5K/mEhyIVni7LWb2D
GQKDe/QefVehIb+6P+9SCQ2uVOxMfTofDo1bguY0RqjYkM5vYmHCBAl9Yt9u
sziopvmliyjTUMDtwK6OVUxufx8aDR2NheDtheOjG+g4YXAv5hXQwYjnfpaM
WhTYrJhT7llNxyXvxMP1zykg9WSHHvF1GMSbiK+aFKOhesnrN6VrKOCDXZrG
+8Ph+eW+SikZKlq0+GQVfaTC2NJi0qW5KBh9lhKhuJmKu69fxGoPBoiVPow3
0E6El5tb64KGuHxbrs0f9ZsOLVsKpb90JoBuRtCF//d7ohtvw/nr+WigdLnd
vvJJDGiLLd7uV+X6j78knXQ7FZ5fWfO3WzoSGhTGPgRYUjC2PVzsh3UqCGzd
6akSHwkO1UbCxOpUrLmiLXbdjAq3ypYrujJj4bju/bllvBQMlsqljefR4SGN
5hUvQoAB9pdjPwVT0SZNltTkSAfWDEfdOyMJzudRd3WYpaLvVj3zFceo0HZq
qWjdljhwvdN8df3nFLxBGXEK25sKP/59fuANUeBeE6KTYZaCPSZe13MVU2FA
3s/+V30UFJb2OFUKpmBdkeGwgzIV8m4tvTXaEQ+DuezPvqdSMPHQxbYpQzrE
NAbQe+kEeHTq4z27dhKKzGYdfbCXDh8H7ikqyRHA+Lib+b5SEiZd2Zu0VpcK
PfKpK0Vt4oB3y/PQVYdIOFNsVrSXyy283hL52wyjQPtfqeBfERJ++1t++TeT
y0v6yQGMtdFQJqoVJr2dhDGHV4Rf5HLLxh7vopfLE+C7YYe5UQYJBc3+Hor3
psPABs4/68fcfFMy8nj/ZSKuCFYqVTtDh/w9Rx8sSBAgtk7U2WEtEVPmzW+n
plGhpMrO5s7jWCicdR4vaibginusU4u8FOC0Uavk70bCBenEvkE+Iq75XLFR
wokCwnkiBl0i0eC33GZ/PZ2Iee4suap9NLhg6+gpEZIAhu18d8L7uc9fM/c2
aqCDSsKxnMIbBMiLVtsbPsflQ6eOnsoZOoSa2R2+7ZUEiY+NSsUME/B01yk5
UXsanMMS89iSGJAI0Dqj+jMed5Puuc9tokLuhLPqu9EIqO8UrbtxMhEvPDjt
nEqhQtTFuyvDO6MgtD72mqAIAXcf6FqtoUgH281O4sW0BFCZIhrHahDwNCel
zdSRASvOylxzsyLA76keqUuPYvG+bJ/S+zEGEAvzf0TLJsI7b9qVmRvRuDiC
U9du0GF4R6na773RYK52byK1NxqPdIpOaTfQoMfMsqp+JBw6o9WuNErF4YmF
kC2CcnQ43fVuhdipKJjijZSKUElA2R00F+PjDBA27uhlmCQASf9Q69CfeGwA
vRN39ZigWJ+tQbmTBPcXRZu0XKIwmvXJ6LlxGnyyDLo8cDse2lhzfqK6Efhl
dU+WszsTmKHnQsfuR0LhVfHeiLEIrPgp98rzHgP8xT915jwLgxMKxlzwj0Yh
p8T6ngkGXKOucjNuiARTpsvvba9iMbuPE7a/jQnLPD+m73sUD6HRhuznarHY
Ontw5+64NOgYNO/TaUuEX/MWElX9Ech7vlXZYykdpLuFpr9FxMHX5Pbisx1h
KJP9nu3gng43Qqe3jRMiIDk6eFhnJhyVjmzorG9Pg58bZG1Ux0JB+T2TuLg2
GuVWGl7XH0iDclWnvWF6kaDlKPRFdnMsCq3mXtTodFhPD/0bqxkPlzxOVUTx
xeCiw8yfN8IZ4E3nrROYS4AJfrGIkKwIjJutdBEnsWDQfrTc5mgshPofSZjj
1pPr09Ur6cgCxvjNBjtiOLwWeHRgPDECGWbvclzFWPD4VuZnkWOhUKX3Zdmx
6WisCzpXf2goA0yHKn7WLUSA+uubvzoqYtHQuOx04VoW5Bz5MvywMQ5e7tPb
NcQfg1YeV687eHF5RkG1asI+AUqP+N6fUInE2+czRvjS2DC++/yKt/4x4LP0
LbjofTiqDm0bCqaw4ZOkqiU2hUFyVEacsmoUxlGv9PbsYsObQVPtColQ+AA3
Wia489pNxrc1f2BBc3PvyJO/EbCNrSCp/isO+4uHOly/sODlpOnld/lxIC6T
LHS7IgYp/3zfLOqzQZ4+9yN0Ph5yP48+GGNE4bTX+LZfHA4kpuv3tIxFQ6LR
TAPxXyQ+3GVYX1jGAf/quBwKIwxKZi6+fNYZg9GTIcHnLTjw+92ZhE/GoTB3
cO8z3x0J6NdnRvrUyIZL/UqX0h0iQXxqa3XzwwS8JDw1oV/Chrtln/u7y+Pg
vQHhHm0iFkes6gwOrubAN8nOPzPf48HVbNA06kMMMtvz9jWey4TVczzU5q/R
sNhl1nHdIBYXwrue8Ldmgrdf1hPbpTCuX7U5XiMmYHzGaMpW60w4uzR/hlc6
DBL//thaq0XArOV1zyQvcSBsQ+OYyvoo2FFtcKpQkIAqJ2n7X/lyQK5Y61aB
SDysPvfLxLQ1Hq8ax8SUf+BAeHxWwwQjAa41i729PBGPwZJ9mudDs2CQQSaY
1MSA2/fZH6ZrE3H2BXP/h7Is0OV1u+WtGQEKOyvJfO0E7DxJnH0hkwVqpw+t
3xofDtWvE3hXc/P4tgNP8k4aZwIed/boOBINzsYrIvXdiXgjfSVHSpC7rvdJ
2uWv4qFduuD1Q/0kbP655q3mpUxIKuIcOiubBNf9njbNyRFwYqxT9/t0Fhyj
v+G9khQHB1Y0Cb4TIGJAziTTXjkb1BXjLbr0o+C/ZVpDJS+TcdqdxlsbkgW7
+nvf/DgXCRb2OdHZ10n4PUp4S01KJrj8TFP8pBkLpZXsvbfrkjH4+WSnnVUm
kE58HagOTYS3j5U8Bxe5eXDxqMvM8iwwqn0lTysmgJlaafqJd0TUUjwVKrYz
G1iHqxa2rEiEGoXSKOE1JGT7+vcNHcuGDdOcsySJWDD8e38wuYmMT7TkRWPj
syCvxiep9WQMOA49dbE2SsGzD7oGjJIygTV84mXNtXgY//g07KoQGXUj2yJC
nDNhWT5Iq3N9+OTK6pVb7ZNR6KaM4WutLLjUeLP89tpkyLp2+hSpkoT2m3jG
Uo2zQS2oXkGsmgD3ur+90tZPQeeo80OL3PHO/2iGG58mgJzSgmrv81RMu73/
u+OBLNBabnPcsz8e/CziReuepmJtuqnwAcNMWFezPuLqpSQ4tH4+T3hvClZq
l4i2QyZ0GGQ8tL5OhOGmSYuAChKSeIR/BxtlwQ+N01MPHpLAYvUD0pYTKXj3
oc3Oqo3ZIFgf+GjsejJsMPc98k6SgpofFw+en8mCKb++1xkzBDApNvvWeozL
Rey3R5a1Z8LzOP3NEjYEuNge90xghIKFktJAfsOBOx917T+fIsLLc20LR9RS
UXEiUK1AKBOaoH2f/gYSXNb55uj6iYy39JmKuluzoLv3MBTGpMBA0Ua/F/nc
dXW6X7/ZkgU6SWv+jheT4X3OmtdPXbhcd67gWeSZLKCa7XypJUSCMBGlrXiU
hjn5ZnEZezIhzJf0Zp9OMvym60k8pVHRcfTOf2+dOCD2uGbDT+7zs7nG1xpa
UrFxfdjCqmoO1M1dsr5xgwyeKnuONr1OwRipZpifzoTW8pZ/q8wpcDXxg/VZ
Vy7XNaY/+OaYBU2z1vOat1JB40AU64oADe8PiG2b6MyEfQar/9StTIErsqyL
1XdpqFrn0GBD5+pw8LCw2koyMLeuOY1VVHRL2zT9uIkNlcubVgvdJMOyUymq
FWIUVIwtSHpuzYEDNUKicWapwGQFbLjkkYrl5xw+OOdkghz10c1oXhoUZ3y8
/FeRglVX7pB6ajMh3DlX/VU8FU45qFbycfNvfoNo5T6JTKhVF5gZu5cKk3ef
/fBboiJRQtlwdzcbitXPaZwNTYF7puvkW4YpGL1v7MILPTbYOD+4pbOQAnOJ
faINXqmYLkP1c/vAhpXUI59VkQJBivptrgKpWNoSNOizORPab+QIOuTTgVO5
m7kpKBU/v18aYa7PhOn7V0bX7qTDG+Hx1pe5FNx+pspw0JwDEzzjaqS9VPhx
RJrMKaTgrvCWv4ZSbKjftzFHuTwVGgyyFsqSuPl3Us3J7g4Lrm6XeuS5gQKJ
X0ar+O1S8I5H2CIvmQ03xjrCf0vRwOt6BY/+oRS8deKEfn4NB54dtOF5sZ0J
9w6dNFrSTcH47fKpJuEcqIko6AltZcCJjZuSZT6k4AQtyVAziQ0mJkLP3xXQ
gLTQmZOek4ItucONqdw+OPBRfuhiDwWW/j49M1FARjj8PmtanwUfqrtFZrSo
cEyNd0fHHAm7psn9y7XYcPyz/7pUdzqoH7WWdTIi4/Swok3ZEQ6wrPPdHgem
gW9f2KbpPBLeO7vnJHGcDaLvO5/tEkyDHGfC2fXPSKhBiv7FGGeB5NM9p+zu
0iF5W49D6H4Smuy90h7xPgMuip0u4nlOBb3YdVcucJJRN7szqm4+AzbG7zFm
qtFg5bzY9jOBySg/eP1yz28WyOR1FvgnMUBB6YG/7Gwybn9+uOLaDBsmLhnY
jVmnw0T7+xcTb4m4/XHGozW5bLhWID34uzcNvjAGElPziSi2+2x9xUUWKK+O
zBVwZcCdOzqfTv4jIGHH2Nm3KRnwLWnp5S83GkSuu3Q+7yIBFVZkcGSbM2BX
orLh6AANIk5ef7/sDQHLVxk+mR5hwR3RxpTXtkwo0zWPVYklYuI2731VD9jw
xSN439aJdMgsuuQZw0vAWLlHyr4MNgh6vsk2sU+H0CB7u/alRKzYQVAYP8sC
no+VlZ0PGPDSV+1nf2kCuta57sjKy4B3vspxBypp0Hfgg4iQZwKO/dyj5PIz
A574Ptqkak4H5uaWhK2nE1H3tKNM2RQLGj+M8OS9Z4KW2sLAptokfLT3hkLL
fTZQdk9ln5hNh+OGVdWld5NwPmvRzJnLP1e2+xwnn+ByHDNU72lhIqbvzCDk
57LgQtbAxjRkwKZFgUu3jyag1SuK5rFrGRDF90bhTA0N3DcMxaWKJ6DNysbv
o0sZ4LzC86SZFR0udSkshGxKRI5vu+H2WRZ4XJ3MMfjKhPNe6WdTQpLwV9l5
VYVaNvz/9v/l/1Xn/1rX/9Lhf+n2v3T+X/vyf1YWUhM=
      "], {
       {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmmd0VGUXhUnohEjoVSD03kNv0kKR3kIvAamh9xp6R1BpgiCgoEgRpIiI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           "]], 
          Polygon3DBox[{{649, 650, 651, 652, 653, 654}, {655, 656, 657, 658, 
           659, 660}}]}]}, {}},
      VertexColors->CompressedData["
1:eJzt2CEKAkEUh/FBr2CxCJ7kXUEEsyCYvYxo0Gg2eQmrgklBBJOCHsGdpztR
Jhj+Dt8X9rG/vMNbpjua9MeNEMK0ejSr2fHW1vPOVr/jmn46xu7W8lZp4jiO
47iyq+1THMdxHM/x9x7b2HwWO1jwnjiO/8Db3jbNgXfFcRzHcWlXu2/B8ZI8
fFouYjerJ47/o6vdb+B4Sa523nEcx3E8x9XuN3C8JFf7X8Xxklxtn+J4Sa52
3nEcx3E8x4few/a72CXtORzPcb7n7/4CZN6sWg==
       "],
      VertexNormals->CompressedData["
1:eJzFmPc31//7x5VCZiglGvbMeCshusw0NNBSqBSlUpGSlGSkIaFIyC5kRGRz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       "]]}, 
    {EdgeForm[None], Specularity[
      GrayLevel[1], 100]}}, 
   {AbsoluteThickness[3], EdgeForm[None], Specularity[
     GrayLevel[1], 100], GraphicsComplex3DBox[{{111.9, -1117.5, 1927.}}, 
     {RGBColor[0.578462, 0.85539, 0.408855], SphereBox[1, 30.]}]}},
  Axes->False,
  Boxed->False,
  DisplayFunction->Identity,
  FormatType->TraditionalForm,
  Lighting->"Neutral",
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic},
  ViewPoint->{-2.514521871663412, 0.031796191031650864`, 
   2.2584438800116797`}]], "Output",
 CellLabel->"Out[7]=",
 CellID->16767067]
}, Open  ]],

Cell["This imports the sample file as a ball-and-stick graphic:", \
"ExampleText",
 CellID->836789210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/1PPT.pdb\>\"", ",", " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", "Medium"}], ",", " ", 
   RowBox[{"\"\<Rendering\>\"", " ", "\[Rule]", " ", "\"\<BallAndStick\>\""}],
    ",", " ", 
   RowBox[{"Background", " ", "\[Rule]", " ", 
    RowBox[{"GrayLevel", "[", "0.15", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->1496107990],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[2], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJxVmnl41NXVxwO0FJSWVQoIlMVCVGQLry8IxQFq2MKaAAlLSCAJWck6k20S
JttkZjJJZrLvhMVSERFlKVDU0SIPUgT66MvS0iIuvKKUWpFF5YEm8/0Mz9P5
5z6/c88959xzzz3bnZEbkpdHd/Xz8zvZxc+vW8cY0Pnbn2g43fkbWuHxfpe0
GPw6fxEbDI2dv+ecHu/3nSbDppjOX6DGyZXCH9xk+NBLYIrgC9zCH9IsOn6T
PE2ddKZVaIxrgP5aj5dclUt01tdDZ7bwsqtEZ2cdfIO1zgb8Qa3gpmjPlM71
f6gQPWut9pMYIrynygR/ptbgpdv4a4MXP8Gh+UH12mfjOskxocbjpfteneQJ
WuLxjs/Uic/tWsF7LdX6cXXorVr0j6wV/sc1mjdXoYdI7ethvfDfrxO8IUXw
D+u1boqP71TNb67X/BtVBu+69HmCh9ZrXxEug3ccEyy8ng2in1AhvPYIz5lO
egcaBV9SKfrmKM2fb9C+mitFJzBB+rMCDygT3uEMQ5fOsVeTxzv/lEN0ZmRq
3cQmj1eNJVbkyZK8k5ol17Bywa+t0z4/rZN+QstEZ9xmfUfVi85LdskRlCh8
U6P2u9f66Ly8+Dd9+yphX6la/3Kt8FdbBW+JEd7X1YLPLJV8AcGi01IjeKBD
9EcapbfNTdJDAnTGmfS9vkX4h4qkn9hMyXm0Wfwj8yV/SJ7Hq7ft6G2GWXz3
58nOnK2iV1QiOoZs4WW1Sd7pdtn5A+j8fqv43iwU/QFp4pvWovFAluj4p+t7
TIv2NzFZfB/PFd25rZ6Hnb9fxWm/YWbhj9qq+R2JsudLMYI/1ir4xhjBr28S
/D3oW16QPGvjBPew36AZGp2bpJctbZI/ZpHWjYgX3dwmjZ9FyV7mx+I32jQe
iRVdc5zoPd8i/KJk6fF8nMabzcIbl6UxxSL9Tkc/9yN1jsXFwh/SKnmuhWpf
84slV3Gb8IMCxGd/qfS1dSv7na/1MaWSZ3yz+NwK1nlVFWtdHnYb8xL31iL4
rUbhB68T/LRF9C/AN3GF1n1rEb/J7dLDB+gh0SL+PbCHgRn4s0LRDWsV3uUM
rbtuFvz7rYI7c3Qes8zi2xO4rUBjbKHm30D/2UWS+2Gh+D4P/c9LBH8yU3K8
0K5xA3o8l6AxGPmHQafbRuLHNo3pxVrXPZr7v1X4B9n/vBKNXds1n1co/iF2
yfM5+EnFgrucgnuwt1MF4vNzl+BR6Hlqkc5vRJm+e24jTpXoO9QmvtuRM9Mm
+NBSwSdsE72/sn5qqeSr3i6+20vRv0Pzha26xxfzBO9bwT5adD5PZsvvuIiv
xibuSb7obisX/C38Xm/Ou75MeCbsPyNV/N9z6/uv2NvCPMEPV0nufg2aH8C5
57gF74N/DrJwj4jTZ2s1BmRLnu9r9P0X4teefOywVvvrhv3/wyS6w6uFF8G+
PEaNWe5Hftg7/1SR1vm7ROfVKvxEocbXXMKvcEuf58yeyZ3wTRXQRd6N+IFw
8Ne6RS/Sqvld4GeRn/S1iu8C9F9eJfsI5fws5B/73MTVbMHvVUm/efC5mIpd
uqUnI+cQFK35DPY7FXy/YOEn1j6i45VjfIrmp9QRX+GfEqv5pcT7uVWSP2y9
+MxA75+j7xvLhfdso/CM3IPu6/T9OuduJT4GRqM/13+fS6/l2KNTepnH+d9a
pXVv2zXfB/zT373ohR+Fzo068bm2RPhfVQkvi3wmZrzGndU6z+BG4Y+ZJXgP
4vSAOo1jAg3eczA7JMeP1eKzNF7zd/BPydUaq+Mf+RPv99PsuyOP9Orhaezr
Hezu+7Ua38efmaG/z6QxCr91nHwjJltwW5Hovl2rc0stwH/jt6/Vad9RGdJj
iE1+OLdSdEzE1/v4j5H4lxsRkm+VTeMa8tuYyYpfr+G3guz41RDFd3eZ+NTg
zyyxmm9GbztK0Y9R8j1G3t9CnLy2hnPnvhxAf3/M1vz4Msl/tlzfgcHKB+5D
f3QFeUCi4u9hq+icY78PUiR/3xLttxW/WJMp/MQK6dGO3QamGHQvuEfnfPc4
Xfvtj92fBN9qEv03akS/DHuMSBF9D/bUnXO3J4tOeoPk7lEpfJdR+DPJU9/H
T+yIUH51i/hjc2vdnnjh+xVofSz39FKy8uGVucQ5F+ebJPgZziELeeZnSP6r
W8RvDveumjx+IvF3KP45OFbyv5IiOf+PesQT9oi+9/sZ7HBPuuAxkVrfij3X
RVDXEMe/Ab/YSP5MPv974sW+ZNVXz+ZyrpyLH/qZA9/j2OO4MNFfZqTOwa7n
JIhOUZL04CjlPmAnVzO5V3atGzydMR07KFFc8CzUdzt+dyd2+1EoeWKmvl8l
/nXUn/Jzq/FPBfiZ9eSnadQRuaJnwI+Ngb4/eVb6at2HK2GCX8wgT4vQfLc8
7jF5hH+K7ouT+PwCdtQrU3pbmKN1Y63S29At1Ikm8in8U59C4a8hfn5LvjYw
S/Zwm/s83IK/SxX8C/yCn0VxbVyy7KojD9S55Ir/Z3EG3z51/4iLWRbqQfKC
22WcT7FBfjxZ326n6HUplr3didH3v7GHeaU63+w84f+Ue5pIfReCX62r1Pxr
1GURJVrfRnzfBvxL9jvTKTn3lSo/Px8r+zhQTjxEfmeg9Pki/YQFFurQSdr3
ZeLbPYu+LeHS90d26BfKbgOmUB/iN05mis6N9dp3BPd9nIl+Qozo3XBrXbhZ
8GMbNHb4OfkX9G/5LfWPlTw9X3C/kTrPdZzbpS3S5+AA0VlawDkUG1TPrNe6
QeTZA6zSz5gQ8rx86W9vLnRmeHz32CvnL8zC776KuJNM3mCkfpwjfpci8Sfp
godRJ/ZKk5zuVPzPCq2/i7+8aH0E9w4bkH8dfYPTM6X/Xdh7eLn2Py1M85ZC
wR9zCS84kXhL/dCnnD5SkuS4TZy+7pKcTydJnr/lkHe6H/UrZI/Zol9RLT12
1DvSF3XXMhf3dLbGj4nnrU7Zya0IrWt3aN3iCu13Zip9OeL4i+WSfwdx7C/c
1670f06s0fwvK7U/s1Nwa7z29wz28yP7tXIOV9zKs+aiTyf29S1568/cwovM
1vxK8sPd0P9dmsZY4EfRz/0sjYPop21wab8f5QvfXIv+od83XXzH2SS/za79
jM7V+A75erBNeFPztM7I+ebTt4kuFF9/6tcvysTvvFnjYiv9BPo2fcz0BR3U
BQUGn7178U/ZRf8M+/ErFP6scvpIPn9LnjJli/z+Lgd2my0+ocTnMZzjaDP3
GPs57ZL8cRbRf5d4cdJnb6mSayD3ZUW58EamCP67eOl5tl10XRs1Lt1AfLcJ
b7hJfTwL8TzRiv+ij2fdQj/Ere/N2cR/4kXPGuGftWi8gJ/5TY34NaBXD/e0
tVb7KkgTvCMv9o49gPc0iU9Tseisqxe/ntHCv2/hvtPvPVMg+HHi+Nkq6eeT
EsnTm/rcj35snl3jJPLivVXi25dz+Ax4OPc3ij6cjfg1Fvt8Db1ayoV/hvOa
VSi5fiBfPQz+MPDnFWq/z6PPlU6ti8SvnnAJr5fTd7+1r5eQ82oFeVYq+6oS
v6Yy/DH54yT83iwbfs6kc1yMn3m8Aj+UT7/dIbxcO/0w6vNT6OG+jXiOP19F
/3yFjf4u/fJpNfoehZ4bR0nOIbWic9lJHEuSPB7626H4uZWZ0o+jXvgP8Jc1
Ju2rd6P2lYs/dqeK73XeI35RKfgrGcpPGlsU177mfhyhr7mnRXnI2AriG3X1
4jbxu4f97A8Xfh399gnAA3qL3iq3vkvJF4Im6vsK5zg1n/eKZ6nLKyT/wVL6
1v9+xzv9D/Z/AvjTEVq32anxKHb4SaTob8Xvtdh1nv2pH2Zjx8HkO3tSyBdL
hbeDdfsyNPbALwWayVMWin8l9ygxnbi6GLtAD7kp+IdN0kM0euhPfnI5Qd9G
t/R/JRk6S4T/YQ3fqYzLdL5/x06+2Yz+6YOMb+Abuc/RjwhrlNx/hE5Iqs4x
p0n43TZq/HMa+SDwavzMIe6FjfepHkbiAnpbxjnOS5XcdqPicC/eL8YkEd82
S2+tdo0fEL8s0dgT5zoS/9+H/MlIPKrLE/xeHn62Ut/HCrT+eJbg+1z491zs
oZD1+J8PiiRfBvMWzvE49cHUYu0rGr/xKfHrlQKtX1Xtq1tFtzv+ux/+9tp6
0T8WL/hOG3rZpPv0a/Lnt5qxe4P4plK3NjapP3P6Wa0/RF49q1HfS5fqXF+n
D/B5vfid7iE7WE7e7qk3dPUumGL4rz7cMt7RLMFaH1ItP7AfePtK4T1Xq7pm
TZ3sZ+NK4VvoU3bEC+VjAcL/kH7Ak/jDQXHCu1av+TzfO91szW8EbudeBKyW
HFfoz/2d+24NFdzEu95V8qgfjOI/vEn52Ar8eDL5XhvvI9t4j3PFSL7R9bLz
xQ7qx1DB36EPcNYHjxb8zUbhP8C/7EyVXr5t5F2AfGCXUfXRJvrJfUokZ3gO
97NZci7Bft/OEN5A3mXKsPds4lPXNt7NSoXfxrtVEO9oYzIEf5O6+n/aFH+v
xlMn5mn9u+BXRGPHnEs/+N5N13wU7z6/5F0mOELnlVOo/e7m3SolXHAHcXpv
m0bDAvoXvDv0412sepbGK9RLbbwHeahvZheI/kTfuwl1wNV8wS28UyzL1Fhr
1liwVXKepX9+AHm+433wdfqMF3mvWA2dH8m/4jZ5x8GHeH85yTtLQqzwb4N/
nX7G4lLR/Q64sYi8skLnW4X8BbwvvFVGH5J3yTW8C5zk/WvIdo29yL+Oqq9h
id2mb3/y6zzu89ctHp99KG7z/4PBTYJXWiTn+9T//sAP0h/5DX20Ow2S9yh5
awr95GHgl5BfZ7vFZyV9rcP0e25Th/8LP/CFWXKcA76Dfu85zqOefuNWtyfW
e9652vcn1Plj6T805mj9MeQcSJ/5hFFy7KE/eB4+p8O1/hT081k3P1p4bzVQ
3zI/MVzzJ+hPPoHfGx0mvJ7st28N77Dh2te/HJofRz+wfS51J+9Ho3zvLxvR
WzV86uivPaf7OBe9xDRg/1M1P43+3UHWpcaTF2OP3/n66tyXM/Qv0nnvMMVI
Xn/qwMXEl0lRmu9KvyzEgb3N1/19zy46tfStP5kr//AEefz35YIP2ig/+wV5
//OVj/qr3vnzJdiHiz7BZtH5FP3udtHfSxedI7WiOx/5+9FPflgn/3iduDYw
Vn61CX/tAL6buugH6th71Olz6ANXZWF33IN28h4D/dUh8L0TI3n+N0vrI6lP
69ZST6Vp/XCb4G2b6QtwP35i430iSXI+Hil8C/yX8n+LeXmS/yR6aiLvCcqS
Xp7w1WXUsdPw/89Bvxv9tL1Fwr+LX3+SfOqfVn33xr9GkHe+mSO+A8p4F+X/
D08liO4sp+Avl/C/CP43Mgr7mU5fYDj9wK94R51QKvhq+qcHsc9dVuIX98xn
PxHsK26Zxgv0Bz4ukP73jxX+BPTsT5/QMBH/RJ370hblTwHLtb8DFu1veQl9
OYP47SwQ/EAJ8pAvVePXzRnUDRvo96WIT46vn7+CdwjoDLELbloquQYU6X4c
qaBfZxD8beLeA+rHV5O4P5xDK3mmGT0fp7/x0GXw+kXrCvF5gX6pqVzn8k26
7Osu9rCN/yn500faSV8rijznS/KIU7zbHKHfNSSTfBp/cNMm+haL5F2Cv55M
nTw/R/R6FOheVpMXRZBnB+YK/v9lOpfcfO1vBPtaQF73Y7bGIrPgYdT71+PE
N5d+9l3qrhH4if4JsusLpeLbDt+Z2Pm9KtEJID9fSFz/J3XT4gLBF5EHWOlv
XCiCv1V0voTOXOoMB36uO/iLqPeP+d4H3JLzKHXhMfKmjjrcK6eJ+vJr3lVG
Q/9PDq3rqNO99H5GnnwT+zqE3/A4hT/d7uvzCd9Fv+iYTfc+e4nwd9dIX2PR
0w38Tmw1dQh9xP70x+43il8X+gPD0skTm4XfhH3F0jdLb9V+8rD3N5BzB/97
rCmRPEcW4Z849x1bDOe8BHnP7oId7s5XfbNnlr7/QJ/HYxX/n/B/Iyv/l+vu
+z9anOje5r3jV5zL0DTBXy7DnsiX96aR71J/XcqUvH6LhO/gXN5No7+VqHV/
4xyL49hvnOBJ2O0TPrr8b+BPDcQR+gAzEskbG7XPGQni2ydN+nc2cV68T/40
Q/6pC/W1P/HhBnJdoA/ljJFcl/n/6QjsZjzvADPjqePpQ31FXRqK359SY/gP
ojReLQ==
    "], {
     {RGBColor[0.4, 0.4, 0.4], SphereBox[2, 34.], SphereBox[3, 34.], 
      SphereBox[6, 34.], SphereBox[7, 34.], SphereBox[9, 34.], 
      SphereBox[10, 34.], SphereBox[11, 34.], SphereBox[13, 34.], 
      SphereBox[14, 34.], SphereBox[16, 34.], SphereBox[19, 34.], 
      SphereBox[20, 34.], SphereBox[22, 34.], SphereBox[23, 34.], 
      SphereBox[24, 34.], SphereBox[28, 34.], SphereBox[29, 34.], 
      SphereBox[31, 34.], SphereBox[32, 34.], SphereBox[33, 34.], 
      SphereBox[35, 34.], SphereBox[36, 34.], SphereBox[38, 34.], 
      SphereBox[40, 34.], SphereBox[42, 34.], SphereBox[43, 34.], 
      SphereBox[45, 34.], SphereBox[46, 34.], SphereBox[47, 34.], 
      SphereBox[48, 34.], SphereBox[49, 34.], SphereBox[50, 34.], 
      SphereBox[51, 34.], SphereBox[54, 34.], SphereBox[55, 34.], 
      SphereBox[57, 34.], SphereBox[58, 34.], SphereBox[59, 34.], 
      SphereBox[61, 34.], SphereBox[62, 34.], SphereBox[65, 34.], 
      SphereBox[66, 34.], SphereBox[68, 34.], SphereBox[69, 34.], 
      SphereBox[73, 34.], SphereBox[74, 34.], SphereBox[76, 34.], 
      SphereBox[77, 34.], SphereBox[81, 34.], SphereBox[82, 34.], 
      SphereBox[84, 34.], SphereBox[86, 34.], SphereBox[87, 34.], 
      SphereBox[89, 34.], SphereBox[90, 34.], SphereBox[91, 34.], 
      SphereBox[93, 34.], SphereBox[94, 34.], SphereBox[96, 34.], 
      SphereBox[97, 34.], SphereBox[98, 34.], SphereBox[100, 34.], 
      SphereBox[101, 34.], SphereBox[103, 34.], SphereBox[104, 34.], 
      SphereBox[105, 34.], SphereBox[109, 34.], SphereBox[110, 34.], 
      SphereBox[112, 34.], SphereBox[113, 34.], SphereBox[117, 34.], 
      SphereBox[118, 34.], SphereBox[120, 34.], SphereBox[121, 34.], 
      SphereBox[122, 34.], SphereBox[123, 34.], SphereBox[125, 34.], 
      SphereBox[126, 34.], SphereBox[128, 34.], SphereBox[129, 34.], 
      SphereBox[130, 34.], SphereBox[131, 34.], SphereBox[133, 34.], 
      SphereBox[134, 34.], SphereBox[136, 34.], SphereBox[137, 34.], 
      SphereBox[138, 34.], SphereBox[140, 34.], SphereBox[144, 34.], 
      SphereBox[145, 34.], SphereBox[147, 34.], SphereBox[148, 34.], 
      SphereBox[149, 34.], SphereBox[150, 34.], SphereBox[151, 34.], 
      SphereBox[152, 34.], SphereBox[153, 34.], SphereBox[155, 34.], 
      SphereBox[156, 34.], SphereBox[158, 34.], SphereBox[159, 34.], 
      SphereBox[160, 34.], SphereBox[161, 34.], SphereBox[162, 34.], 
      SphereBox[163, 34.], SphereBox[164, 34.], SphereBox[167, 34.], 
      SphereBox[168, 34.], SphereBox[170, 34.], SphereBox[171, 34.], 
      SphereBox[175, 34.], SphereBox[176, 34.], SphereBox[178, 34.], 
      SphereBox[179, 34.], SphereBox[183, 34.], SphereBox[184, 34.], 
      SphereBox[186, 34.], SphereBox[187, 34.], SphereBox[188, 34.], 
      SphereBox[189, 34.], SphereBox[191, 34.], SphereBox[192, 34.], 
      SphereBox[194, 34.], SphereBox[195, 34.], SphereBox[196, 34.], 
      SphereBox[200, 34.], SphereBox[201, 34.], SphereBox[203, 34.], 
      SphereBox[204, 34.], SphereBox[205, 34.], SphereBox[209, 34.], 
      SphereBox[210, 34.], SphereBox[212, 34.], SphereBox[213, 34.], 
      SphereBox[214, 34.], SphereBox[215, 34.], SphereBox[216, 34.], 
      SphereBox[217, 34.], SphereBox[218, 34.], SphereBox[221, 34.], 
      SphereBox[222, 34.], SphereBox[224, 34.], SphereBox[225, 34.], 
      SphereBox[226, 34.], SphereBox[227, 34.], SphereBox[229, 34.], 
      SphereBox[230, 34.], SphereBox[232, 34.], SphereBox[233, 34.], 
      SphereBox[237, 34.], SphereBox[238, 34.], SphereBox[240, 34.], 
      SphereBox[241, 34.], SphereBox[242, 34.], SphereBox[244, 34.], 
      SphereBox[245, 34.], SphereBox[247, 34.], SphereBox[248, 34.], 
      SphereBox[249, 34.], SphereBox[251, 34.], SphereBox[252, 34.], 
      SphereBox[254, 34.], SphereBox[256, 34.], SphereBox[258, 34.], 
      SphereBox[259, 34.], SphereBox[261, 34.], SphereBox[262, 34.], 
      SphereBox[263, 34.], SphereBox[265, 34.], SphereBox[269, 34.], 
      SphereBox[270, 34.], SphereBox[272, 34.], SphereBox[273, 34.], 
      SphereBox[275, 34.], SphereBox[276, 34.], SphereBox[279, 34.], 
      SphereBox[280, 34.], SphereBox[282, 34.], SphereBox[283, 34.], 
      SphereBox[284, 34.], SphereBox[286, 34.], SphereBox[290, 34.], 
      SphereBox[291, 34.], SphereBox[293, 34.], SphereBox[294, 34.], 
      SphereBox[295, 34.], SphereBox[296, 34.], SphereBox[297, 34.], 
      SphereBox[298, 34.], SphereBox[299, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[1, 32.], 
      SphereBox[5, 32.], SphereBox[12, 32.], SphereBox[18, 32.], 
      SphereBox[26, 32.], SphereBox[27, 32.], SphereBox[34, 32.], 
      SphereBox[41, 32.], SphereBox[53, 32.], SphereBox[60, 32.], 
      SphereBox[64, 32.], SphereBox[72, 32.], SphereBox[80, 32.], 
      SphereBox[85, 32.], SphereBox[92, 32.], SphereBox[99, 32.], 
      SphereBox[108, 32.], SphereBox[116, 32.], SphereBox[124, 32.], 
      SphereBox[132, 32.], SphereBox[139, 32.], SphereBox[141, 32.], 
      SphereBox[142, 32.], SphereBox[143, 32.], SphereBox[154, 32.], 
      SphereBox[166, 32.], SphereBox[174, 32.], SphereBox[181, 32.], 
      SphereBox[182, 32.], SphereBox[190, 32.], SphereBox[198, 32.], 
      SphereBox[199, 32.], SphereBox[207, 32.], SphereBox[208, 32.], 
      SphereBox[220, 32.], SphereBox[228, 32.], SphereBox[235, 32.], 
      SphereBox[236, 32.], SphereBox[243, 32.], SphereBox[250, 32.], 
      SphereBox[257, 32.], SphereBox[264, 32.], SphereBox[266, 32.], 
      SphereBox[267, 32.], SphereBox[268, 32.], SphereBox[274, 32.], 
      SphereBox[277, 32.], SphereBox[278, 32.], SphereBox[285, 32.], 
      SphereBox[287, 32.], SphereBox[288, 32.], SphereBox[289, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[4, 31.], 
      SphereBox[8, 31.], SphereBox[15, 31.], SphereBox[17, 31.], 
      SphereBox[21, 31.], SphereBox[25, 31.], SphereBox[30, 31.], 
      SphereBox[37, 31.], SphereBox[39, 31.], SphereBox[44, 31.], 
      SphereBox[52, 31.], SphereBox[56, 31.], SphereBox[63, 31.], 
      SphereBox[67, 31.], SphereBox[70, 31.], SphereBox[71, 31.], 
      SphereBox[75, 31.], SphereBox[78, 31.], SphereBox[79, 31.], 
      SphereBox[83, 31.], SphereBox[88, 31.], SphereBox[95, 31.], 
      SphereBox[102, 31.], SphereBox[106, 31.], SphereBox[107, 31.], 
      SphereBox[111, 31.], SphereBox[114, 31.], SphereBox[115, 31.], 
      SphereBox[119, 31.], SphereBox[127, 31.], SphereBox[135, 31.], 
      SphereBox[146, 31.], SphereBox[157, 31.], SphereBox[165, 31.], 
      SphereBox[169, 31.], SphereBox[172, 31.], SphereBox[173, 31.], 
      SphereBox[177, 31.], SphereBox[180, 31.], SphereBox[185, 31.], 
      SphereBox[193, 31.], SphereBox[197, 31.], SphereBox[202, 31.], 
      SphereBox[206, 31.], SphereBox[211, 31.], SphereBox[219, 31.], 
      SphereBox[223, 31.], SphereBox[231, 31.], SphereBox[234, 31.], 
      SphereBox[239, 31.], SphereBox[246, 31.], SphereBox[253, 31.], 
      SphereBox[255, 31.], SphereBox[260, 31.], SphereBox[271, 31.], 
      SphereBox[281, 31.], SphereBox[292, 31.], SphereBox[300, 31.], 
      SphereBox[301, 31.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{302, 2}, 15.], 
      CylinderBox[{2, 3}, 15.], CylinderBox[{3, 303}, 15.], 
      CylinderBox[{3, 304}, 15.], CylinderBox[{305, 6}, 15.], 
      CylinderBox[{306, 11}, 15.], CylinderBox[{6, 7}, 15.], 
      CylinderBox[{6, 9}, 15.], CylinderBox[{7, 307}, 15.], 
      CylinderBox[{7, 308}, 15.], CylinderBox[{9, 10}, 15.], 
      CylinderBox[{10, 11}, 15.], CylinderBox[{309, 13}, 15.], 
      CylinderBox[{13, 16}, 15.], CylinderBox[{13, 14}, 15.], 
      CylinderBox[{14, 310}, 15.], CylinderBox[{14, 311}, 15.], 
      CylinderBox[{16, 312}, 15.], CylinderBox[{313, 19}, 15.], 
      CylinderBox[{19, 20}, 15.], CylinderBox[{19, 22}, 15.], 
      CylinderBox[{20, 314}, 15.], CylinderBox[{20, 315}, 15.], 
      CylinderBox[{22, 23}, 15.], CylinderBox[{23, 24}, 15.], 
      CylinderBox[{24, 316}, 15.], CylinderBox[{24, 317}, 15.], 
      CylinderBox[{318, 28}, 15.], CylinderBox[{319, 33}, 15.], 
      CylinderBox[{28, 31}, 15.], CylinderBox[{28, 29}, 15.], 
      CylinderBox[{29, 320}, 15.], CylinderBox[{29, 321}, 15.], 
      CylinderBox[{31, 32}, 15.], CylinderBox[{32, 33}, 15.], 
      CylinderBox[{322, 35}, 15.], CylinderBox[{35, 36}, 15.], 
      CylinderBox[{35, 38}, 15.], CylinderBox[{36, 323}, 15.], 
      CylinderBox[{36, 324}, 15.], CylinderBox[{38, 325}, 15.], 
      CylinderBox[{38, 40}, 15.], CylinderBox[{326, 42}, 15.], 
      CylinderBox[{42, 43}, 15.], CylinderBox[{42, 45}, 15.], 
      CylinderBox[{43, 327}, 15.], CylinderBox[{43, 328}, 15.], 
      CylinderBox[{45, 46}, 15.], CylinderBox[{46, 47}, 15.], 
      CylinderBox[{46, 48}, 15.], CylinderBox[{47, 49}, 15.], 
      CylinderBox[{48, 50}, 15.], CylinderBox[{49, 51}, 15.], 
      CylinderBox[{50, 51}, 15.], CylinderBox[{51, 329}, 15.], 
      CylinderBox[{330, 59}, 15.], CylinderBox[{331, 54}, 15.], 
      CylinderBox[{54, 55}, 15.], CylinderBox[{54, 57}, 15.], 
      CylinderBox[{55, 332}, 15.], CylinderBox[{55, 333}, 15.], 
      CylinderBox[{57, 58}, 15.], CylinderBox[{58, 59}, 15.], 
      CylinderBox[{334, 61}, 15.], CylinderBox[{61, 62}, 15.], 
      CylinderBox[{62, 335}, 15.], CylinderBox[{62, 336}, 15.], 
      CylinderBox[{337, 65}, 15.], CylinderBox[{65, 66}, 15.], 
      CylinderBox[{65, 68}, 15.], CylinderBox[{66, 338}, 15.], 
      CylinderBox[{66, 339}, 15.], CylinderBox[{68, 69}, 15.], 
      CylinderBox[{69, 340}, 15.], CylinderBox[{69, 341}, 15.], 
      CylinderBox[{342, 73}, 15.], CylinderBox[{73, 74}, 15.], 
      CylinderBox[{73, 76}, 15.], CylinderBox[{74, 343}, 15.], 
      CylinderBox[{74, 344}, 15.], CylinderBox[{76, 77}, 15.], 
      CylinderBox[{77, 345}, 15.], CylinderBox[{77, 346}, 15.], 
      CylinderBox[{347, 81}, 15.], CylinderBox[{81, 82}, 15.], 
      CylinderBox[{81, 84}, 15.], CylinderBox[{82, 348}, 15.], 
      CylinderBox[{82, 349}, 15.], CylinderBox[{350, 86}, 15.], 
      CylinderBox[{351, 91}, 15.], CylinderBox[{86, 87}, 15.], 
      CylinderBox[{86, 89}, 15.], CylinderBox[{87, 352}, 15.], 
      CylinderBox[{87, 353}, 15.], CylinderBox[{89, 90}, 15.], 
      CylinderBox[{90, 91}, 15.], CylinderBox[{354, 93}, 15.], 
      CylinderBox[{93, 96}, 15.], CylinderBox[{93, 94}, 15.], 
      CylinderBox[{94, 355}, 15.], CylinderBox[{94, 356}, 15.], 
      CylinderBox[{96, 97}, 15.], CylinderBox[{96, 98}, 15.], 
      CylinderBox[{357, 100}, 15.], CylinderBox[{100, 101}, 15.], 
      CylinderBox[{100, 103}, 15.], CylinderBox[{101, 358}, 15.], 
      CylinderBox[{101, 359}, 15.], CylinderBox[{103, 104}, 15.], 
      CylinderBox[{104, 105}, 15.], CylinderBox[{105, 360}, 15.], 
      CylinderBox[{105, 361}, 15.], CylinderBox[{362, 109}, 15.], 
      CylinderBox[{109, 112}, 15.], CylinderBox[{109, 110}, 15.], 
      CylinderBox[{110, 363}, 15.], CylinderBox[{110, 364}, 15.], 
      CylinderBox[{112, 113}, 15.], CylinderBox[{113, 365}, 15.], 
      CylinderBox[{113, 366}, 15.], CylinderBox[{367, 117}, 15.], 
      CylinderBox[{117, 118}, 15.], CylinderBox[{117, 120}, 15.], 
      CylinderBox[{118, 368}, 15.], CylinderBox[{118, 369}, 15.], 
      CylinderBox[{120, 121}, 15.], CylinderBox[{121, 122}, 15.], 
      CylinderBox[{121, 123}, 15.], CylinderBox[{370, 125}, 15.], 
      CylinderBox[{125, 128}, 15.], CylinderBox[{125, 126}, 15.], 
      CylinderB