(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    232546,       4229]
NotebookOptionsPosition[    228060,       4086]
NotebookOutlinePosition[    229588,       4127]
CellTagsIndexPosition[    229501,       4122]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"VRML\"" :> Documentation`HelpLookup["paclet:ref/format/VRML"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"], 
          "\"ZPR\"" :> Documentation`HelpLookup["paclet:ref/format/ZPR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"NOFF\\\"\"\>", 7->"\<\"\\\"OBJ\\\"\"\>", 
       8->"\<\"\\\"OFF\\\"\"\>", 9->"\<\"\\\"PLY\\\"\"\>", 
       10->"\<\"\\\"RIB\\\"\"\>", 11->"\<\"\\\"VRML\\\"\"\>", 
       12->"\<\"\\\"X3D\\\"\"\>", 
       13->"\<\"\\\"ZPR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 
       5->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "POV ",
 StyleBox["(", "FilenameExtension"],
 ".pov",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->30422],

Cell[TextData[{
 "MIME type: ",
 StyleBox["model/x-pov", "InlineCode"],
 "\nPOV-Ray 3D scene description language and format.\nUsed for storing 3D \
models and scene descriptions.\nNative file format of the POV-Ray raytracing \
software.\nPOV-Ray is an acronym derived from Persistence of Vision \
Raytracer.\nPlain text ASCII format.\nUses the syntax of the POV-Ray \
scripting language."
}], "FormatUsage",
 CellID->27666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " supports the POV format version 3.6."
}], "FormatNotes",
 CellID->8486]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->3455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pov\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object to a POV file."
}], "FormatNotes",
 CellID->29614],

Cell["", "WeakDivider",
 CellID->29082],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pov\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "POV",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pov\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->14197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pov\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->22106],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).pov\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->8752],

Cell["", "WeakDivider",
 CellID->15821],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the ",
 "POV",
 " format."
}], "FormatNotes",
 CellID->26281]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->26021],

Cell["Data representation elements:", "FormatNotes",
 CellID->18318],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "POV",
     " file containing 3D geometries, represented as ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a geometry stored in the file"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<LineData\>\"", Cell["\<\
lines represented as lists of indices, referencing the vertices as given by \
the \"VertexData\" element\
\>", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<LineObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<PointData\>\"", Cell[
    "point data in indexed form", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<PointObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->9135],

Cell[TextData[{
 "Export uses the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1271205744]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell["Advanced option:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the POV format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["y", "TI"]}]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when exporting to POV."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZPR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZPR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1919681360]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->248182674],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->304025282],

Cell["Use ParametricPlot3D to create a solid 3D geometry:", "ExampleText",
 CellID->1040958143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "4"}], "+", 
       RowBox[{"z", "^", "2"}]}], ")"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "3"}], "+", 
       RowBox[{"y", "^", "2"}], "+", "z"}], ")"}]}], ">", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "None"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<RustTones\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1981720939],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJztnb2PJkcRxl8bEZA6JbI5EIklItLJEGA5IXWGRAKyDf4LNkdCsEBE6pQM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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwt0ktIVFEYwPFz596RVgXpKtwIaa3U3DeigpZCSU5SOTYwKRlokq8aSTCI
IJHQ8RWC0EajVeWoSKSpYfjamFSQIuhoRkJmGPkIp//hfIsf33nc75xzz/kS
ApWXbruUUl7YWHCU+ohlS6kRJlrxBP14hZfoRR2qcV/GGxCPNXIj6KL9AU+x
SP8rlhyT24fnyKV/wKa7OEH/GI4iGSlIRSk2+O4bZmXNSZdZvwPtaJFzhjDi
mNxRx+T6cR0ZaESW7vNvxfDjCnsXoBAB+jdQggvIwTmcx0Xk4RqK4MND1KIG
Z8g/ghjbtFORhlq5q7tyV/UIYozzdZM3TuwgdqILGeR4kI579JsQRKyMxyGX
/FXGvljmreblvT5ZZk6PpyBZnwsPyBnim0E8pl2MIvzGJN7jB5KY3yRW4Q6q
cZL8RCQhG+nwYIdvffiDfdu84z8cp79GXEGYdpg44Jg185At38TCcSv1mf42
7V+wZE0XTsm7nEbENmuuI+qYcyq3eVMPzmJYn434hjjD/DSmUKiLG38ZLyB6
cRmZ+q6QJXU+infoZI82tKMcPaiQ+/mODZkPyTc/2eMFcYs4IXeq71PX9h52
8Uzus9I29fYIV1HG3jdxC81ytnyXuYco84f6Hi3z1hF9TjmzrsOoZf7Lwr7U
ra5JveaB1La+k368ltqYw6y841up7f9kq4gy
         "]], Polygon3DBox[CompressedData["
1:eJxFl3tMlmUYxr/nfV8LdIVUa821tbYOthhZc4CfJZ7NObTDaiJKjZGHJh62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         "]], Polygon3DBox[CompressedData["
1:eJwt1VlIFlEUwPFv5huj3jKjp156yHqI1AiCFk0Ny08wyxLNNDC1hUjKFoyi
hSgyEbPFdgqpiIhSW8yt1NRQi1ajMME01HaX3Mn+p3sefsxdZr45c+6595uW
lLZyq+1yuaLghWw6J5CDWKyWSYxZXLgOch2AQ3uU6wg2YhNqGWtAl+NydeIs
7bsoRBH2Y59txmW+Aym0E/GA9kG3y3UIMXhIf4yrxdXGS9ovUEDbB5PQSr9Q
53vQjSa3uXcQIxhGI+pRyvx13nUN6ShzzLeW4zEqkYvTyNM4JbZ4pPH8NmxH
GJYgGrGIwyzMxHrykIQUrMFaJCAVGzRX6xCPbvzGsN5XynsqNB5Zh+PIZLyF
OD/JN9PPoN+E52jEO7yX55nvQ6/mQnLizf2fJU84zD07sBSLEYQwLLNMrmP0
e2agmP4qns3SGLK1DvoZ/+OYd8m6/OXedrdZC4fisfGF/kf6HzReibsZEZq7
dPyg/90xsUmMEzEVbY6pD6mTAwjGIlhepjh9mf/K8x2oo51P7A1c6/HMMbVz
FEd0XeSbatCDbvShFjnIxUkkIwmdbvPb31CGEiTgGDKRhUT4yfo4pnakhvwx
THsIHsfUXT/OE9s5XEQV45X4pXFIPFV4IrXE8+Hw2GYtGywT1xnkIVVjlNq7
gqvI1zx6uDcEwQhHBMrwFDWI1PUN4beDEKg5DcVy2a+oQ7k+u0DvkXuL6Rdg
D+29um9lLeZLTTHeinatRak/ycUu7MQ8zcsFYryMS9iCzRiPAMzBXEzAI54v
QqFl3luC6ah2TO4kh7561vSiB4m6jyQXN/HTMXUleWlmvAtv6b9Bi2XOCqnV
Nqlv3EM1MdbY5tyS/X7KNjUltVULP9oBlvkuOTNu4BZ222afy74dgpt+snwD
v1nkmDOpVd9xm7k7eg5KHjMwm3F/zcM4OG6TU4/WQqTsBfqBjAcjBFMwGQsR
5DZzPvB2m70ajRisQJRtzr7/9YgBjEo8csZojcjeD7TMnhqTvSz50/r3aE1U
4D5CLfMfEKPviZM9iVdyLuO1ZXIuef4HeuHj6w==
         "]], 
        Polygon3DBox[{{406, 1215, 1214, 559, 558, 407}, {607, 613, 1254, 1253,
          538, 526}}]}]}, 
     {EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{541, 543, 617}, {550, 551, 1323}, {614, 615, 671}, {
         565, 1289, 423}, {424, 1288, 422}, {940, 939, 938}, {983, 984, 
         1033}, {587, 479, 477}, {1121, 1122, 1328}, {949, 991, 950}, {411, 
         564, 414}, {479, 587, 491}, {561, 625, 563}, {1092, 1099, 1093}, {
         896, 899, 900}, {618, 1322, 549}, {1067, 1068, 1069}, {1199, 1283, 
         1200}}], Polygon3DBox[CompressedData["
1:eJxNmnmcllUVx5933ueFZN+3YRBmQGQEUWFEAgoCYhFZBpBFSRAXEBRUVHRg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         "]], 
        Polygon3DBox[{{340, 479, 491, 490, 342}, {1198, 1040, 1044, 1283, 
         1199}, {946, 990, 992, 991, 949}, {338, 467, 477, 479, 340}, {852, 
         895, 899, 896, 853}, {386, 387, 542, 543, 541}, {306, 420, 423, 1289,
          1287}, {981, 983, 1033, 1032, 1031}, {396, 397, 551, 550, 548}, {
         378, 531, 549, 1322, 1321}, {888, 889, 938, 939, 936}, {290, 411, 
         414, 413, 291}, {557, 624, 626, 625, 561}, {612, 614, 671, 670, 
         669}, {1114, 1120, 1122, 1121, 1115}, {537, 539, 616, 615, 614}, {
         1060, 1066, 1068, 1067, 1061}, {307, 424, 422, 421, 308}, {404, 561, 
         563, 562, 408}, {1091, 1097, 1100, 1099, 1092}}]}]}, {}, {}, {}}, {
     Line3DBox[{1043, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208, 1209, 
      1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221, 
      1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 
      1234, 1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 
      1246, 1247, 1248, 1249, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 
      1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266, 1267, 1268, 1269, 
      1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281, 
      1282, 1284, 1043}], {
      Line3DBox[{1, 1178, 8, 11, 14, 17, 20, 23, 26, 29, 32, 35, 38, 41, 1285,
        1286, 1287, 1289, 565, 423, 420, 418, 417, 416, 415, 413, 414, 564, 
       562, 563, 625, 626, 681, 726, 768, 810, 853, 896, 900, 950, 991, 992, 
       1046, 1045, 1041, 1039, 1037, 1034, 985, 941, 890, 846, 802, 760, 718, 
       672, 619, 552, 398, 282, 5, 1}], 
      Line3DBox[{4, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 
       1189, 1190, 1191, 1192, 1193, 1194, 1317, 1047, 1052, 1057, 1063, 1070,
        1076, 1082, 1088, 1094, 1101, 1106, 1111, 1117, 1028, 978, 933, 885, 
       840, 796, 754, 712, 666, 609, 533, 380, 255, 253, 236, 219, 202, 185, 
       168, 151, 134, 117, 100, 83, 66, 49, 4}], 
      Line3DBox[{44, 45, 63, 80, 97, 114, 131, 148, 165, 182, 199, 216, 233, 
       250, 1319, 1320, 1321, 1322, 618, 549, 531, 524, 517, 509, 501, 490, 
       491, 587, 477, 467, 457, 447, 438, 431, 421, 422, 1288, 424, 307, 46, 
       44}], Line3DBox[{252, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 
       1298, 1299, 1300, 1301, 1302, 1303, 1304, 1324, 1325, 1326, 1327, 1123,
        1032, 1033, 984, 940, 938, 889, 845, 801, 759, 717, 670, 671, 615, 
       616, 617, 543, 542, 544, 545, 546, 547, 548, 550, 1323, 551, 397, 281, 
       280, 278, 276, 274, 272, 270, 268, 266, 264, 262, 260, 258, 256, 252}],
       Line3DBox[{1283, 1044, 1051, 1056, 1061, 1067, 1069, 1075, 1081, 1087, 
       1093, 1099, 1100, 1105, 1110, 1115, 1121, 1328, 1122, 1120, 1119, 1118,
        1305, 1306, 1307, 1308, 1309, 1310, 1311, 1312, 1313, 1314, 1315, 
       1316, 1318, 1035, 1195, 1196, 1197, 1198, 1199, 1200, 1283}], 
      Line3DBox[{2, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 
       1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144,
        1145, 1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 
       1156, 1157, 1158, 1159, 1160, 1161, 1162, 1163, 1164, 1165, 1166, 1167,
        1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1179, 
       2}]}}},
   VertexColors->CompressedData["
1:eJztXGlYU2cWjhsuVUQR14hVpO4UlaooeFwAxQXqErUuVEQZXOqQVK0OWhFw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    "],
   VertexNormals->CompressedData["
1:eJztWHlcjWvXljlO5iI6ElGGziFDJBaFkjEyJSmZIsQxS8Y0SBpIGSpKqUyV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    "]],
  BoxRatios->{1, 1, 1},
  Boxed->False,
  Lighting->"Neutral",
  PlotRange->{All, All, All},
  PlotRangePadding->{Automatic, Automatic, Automatic}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1463266936]
}, Open  ]],

Cell["Export it to POV:", "ExampleText",
 CellID->231524072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<seat.pov\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70992528],

Cell[BoxData["\<\"seat.pov\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1966399086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->783855897],

Cell["Export inline graphics to a POV file:", "ExampleText",
 CellID->1601370181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<kleinbottle.pov\>\"", ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJxM23dUj///P/D2Xq/23nsvEtX1kCJpl5RIKmW0kBAqbSmJSqFplUIqFY3X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     "], {{
       {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3WXYdWW1t/F79Y2E0kiHhIggitjS3d2SIt3djVLS3dJIN4ooSIgiKAIm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          "]]]}, {}, {}, {}}, {}},
     VertexColors->CompressedData["
1:eJx8nHk0lW3UxoXMUmSKBipFmlSoaJtSMmSKQpoMDZojjaTSRKJJlEoSJVSU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      "],
     VertexNormals->CompressedData["
1:eJwUWXc81f8XNhrKSLJKihb5GhUpFUdJlIxQKqOEtpWGkWRUMkIqGRGRvRNZ
x3bta1/bdXFxF4qU1O/+/rqv13m97/mcz3mf5zzP8/pIX3M0tuPi4OBQ4eHg
4Gb/Bud6iH8wZ4J7Ol1rk3oXEin66z6Yv9LIetYWq5vGBN0edZm8Mx2oqKP2
eu9SsMas57oqk9UsKM50KhC824ZcF3P39AYFazBfndeLsWXBnu0dCdxEAna6
5OtKH3ymMZymwfW3mAVZshklWm8q8Odlt4KqET8N2aL2ZpkFFjQlflDkvZCG
f/ZMGFzhfKax2mMpYt8vFmwvbA6+PZIIktf68p89faah9kfJaV0KC0Zc91wQ
KqiCcZPSiIW65xrBzJJvS2QmyMXcmI+uJsKb7frSobIvNfrex6Tte8UAL6V9
UUn+JGAp1sjO7wjQSLKtPCH6iQaHXo3Y3JQeBd+EgIK6kBCNVMOYz5/kpoFh
TaDUVFMgk5i6VfBegMaxgp6pRzAJna80ouQ4qOBg/2TNescQDc8e5Z9Ebgrw
q4pKjZROQyxP8WGp5GCNhrMa5fxKI6DXJU2qn6PBwQnLVy82B2uEaf9+u3sn
CaaqMlYLfGKAGqdo23ZSgMaR/a7j8X+IIJ3j8lyhnwmUp27/3bz6UkN8lk8j
xK8aVunZ71D5yIIjaq4GvvyhGhn3DT7lu38CUodN5sbfLMhT8Ryx3/xCo6mQ
6HBA+AtqGU7er55kwW7mm5B7tGCNS2LZFXKaDWiop/Vr1RUWXC027ZU8F6yR
IdHBr2vehSf9RraFXmCCU+Lz/bHHgzWGSq+Zdm4dxNzEH0JWSIff0uJnk8KD
NZ6nXNxg2EfG2r2R60+HzEBN682ePTZBGnRYNbjm9gSK4PKla/VU+Hpa5utd
UpBG+vaHa1beTeGRap4AE/dxyPX5zplvE6xRWTU/kXSUhh00O/7yllGYVEzd
L3ctSEPPVnw/4QQDg722bbGY6oOWvf/5SWkGa/RXri46n87Et6EbZBO1OuDW
/PFxqTtBGq8aafean7Gwc17gVPmaOvhz0E5nN2+gRtZDbZFeOgs97nfv/uiV
C25ciiH+V15qqAv1HIteYWEe896m1xXvMUHqyXzY+2ANOkEn5EkHC1Ul7JtF
5oux4rUx3Wl9gMbS89mOlqcs9K6q95x9VIfd/AEUF60gjW2JUsu3xFn4Mvvb
D5PDrej8NNTP7usrjZXm9O2z5Qx0XrXL2PZ9L56jnoirPRWocZjrUcS8BQNH
vxAODjv1YfNKXc7ffwEa9a9XLH/yM1Ck6rgjV0c/3iokGekOBWjMfUqF8A46
RlevHylqGcDtngdPy48EaPS8Y9TtTqOjchr98PK9QcxLF3X3Xx2oMdTmnq4U
Tkcn3ka/5tZBPBUg9rHTMFBjwwbvRtdAOk7Q1UZMGIPI/1lSel9ZoIa7LkgJ
htLxiJm9t8LAIJ53VVPj5Q7UkG1rWtz9gY7TJi4xO5MHcTrjJKxPY/fzZElS
TiYd6+7bNGbbDuLVt77RXRsDNeTktnCkFdPxe+WBkzz7BrGveP8WTo8ADcLm
Ty2Xv9HxeuyoktXBQbyruouUfTpQI65T/LVUBB0vnVxQ3oWDSDrtfPRMRIBG
npXS2SAFdv13F5LnTIeR8wsxyEgmUOMIR9ZfNwkanuyy1nbhJKPT12A3p23+
Gmq351e2KU6hyg9FIi6MY0DsxztiN55rOFAXXyQdHcabl8PtzVToOCDUuvPU
MU+NEzN2KsyxOricjgorHixUGZtNIPy2LS9NiyUp0sdB5HSH93XVKZwwTtPp
velbrvZ8eD3vmhkwH9OUVYobQ+9/yqtmXr4oP7GPwOdQQ4OwaG6tx20jWFnk
YPj+VkD5FenJR9sd6dDYUBmlYDGE618o+0VYB5Z3KS6cFciiAz+Tx+qgzSDK
DdslJ7MCy3dJ/HmbW0oHpeDuxxUyg5jqfOrNf7yB5RkSiRPyBXT48GxthuWp
QSxR+XXi78OgcqGMK/WWSXQQn7y77/DzQaSGc/1kKgSWb7LnmOx4S4c9zHg+
k5pB1Gz59a1WKLDciZuvwDmIDq/FdHk9pwdxnPVb5SEpoJyrN4T4LpgOcWWe
U4vjg+i03Grg7hFQrn3da090DB1CKro4DVIHUfpdYRH5XWB57WXRDRvZdZIG
ochQbhAPNCbOy/8MKHdRTPfoYdChzfz9XJD5AK7Pib25diKwPKAstIhLmQGs
2TfnZJX60VDN272NEVAefLNKJC2QAXWmG+pa3pDwoz3RI/NtYLmw2c+Im4sM
IK91fNHq2oOtd5f8og8FlD/daPzyQwEDLlddi/ww0IkwJvifl2wjcGSPy/fx
MMF2ddZY2ko7egiV/b78oQHc159VP3qTCb+CHp7m/9eKpM3mShvFG8DB5uNb
7SZ2PPz7iNwbAibL1/VPJhGgbZ/kpk+7WCDNedRO9lUFCqQ8S6k3JoBN8yVL
XmsWjK+e5nsjl47PpTW3r5YlgN7UkPD0dRb82OfQaMD9CTLLhNxRjgBVWbCZ
JMYC+dUnEtJ+VAKnoEWIwWUCuBPzucXPM2FuxiFM6igRdnWPlFhnE+C33+Hh
+TUMEF185na9uxeGFrget2xtgGDOf98zd9HgFe+9HfdtR+CjzxX+l68bQOV1
xKGIoik4UT97RlWTAp6Rz4MXORshPWzizu/BCaA6Ni8n356E/6gK03bWjZD0
xqleP38Mzke/w1jxaTj9VObX3sxGuLlZm7W+YBh4Bq5sOn6CBuo5O4eNJhsh
Nea3Jbb3wlaZp0JvaXQITxH87CjYBBXurwt8u4iwFOlqVi/JhHl1NdlCpSa4
JGfgb/SiGiSbeksj2HxrqSzYPqjTBNwW5XriHYkgKC1cWX2UBXciH697a94E
TGpNnGNVHsrf3qR77D8WpMg/3WN0twmQEm5RepKANirkE90pTHDQcvX67dYE
HpKrpzYUdCL3D+Je9xQG1FME7hb6NIFvbFzUkOEA8n6elT6/lQ5vDj74PMCO
r9i01Qhak9FFiLHh9O9pmNY8u+HZgyaYHZei3B8bx73+iscltKjwN0ziv+MX
msDs43yACvcUHnTUVi/nGQebjBwjz51N4H33fAFX3AyW0rz3NzmOwjqe319S
RhsBD657duEjHWV2cG5xNekDpsx4+b137H4ekeCxW81ElVacGexsh6sl3yoi
jRpBq3Lrg6YhJh67BU6zd2pBskX32vUtjTB81GTZWYuFVz5XNP+rz4Fr6WMP
cLkBKIv6c7+NWXiHcELtOzESuXzOV1N/NsCmqHKTgD0sxLbIcbemYsxiuNQT
+BvhisHi2JVOJm6U8ub7eaAOR38yNvCrNYJ4wCGWyy0mRksIOo7WtOD9P1mn
r7k0QrzkvaB1uxioF7mbGry9F7edLZg6l9IAHtXfj4jX05FxztVbbIGE041n
3j++0ABXLd48HfWgI1Vzf4zW+X6M/WaefEK4AUS25i1warH3/y1uV79zA9hJ
fHdx3xgBskrUbOck6PhtuMIkeGkAP9HXHm9CAiynbjU8s5qOFntieMCMzUdn
LOX70gnAX1p26PsfGqbWpY5/c2Pri1gLR+9EAnS0UMW2cdAxI9WzIPnuIMre
L7+ql0wACZKhyS5eOrrW/YhlagyikbEXcOQSYNfs5QjFzex6DinKK6waRN5P
VXMWZQTorxA6/WgnHfXMLU9XkQYwaXXV8O06Aqg5R6rHbWfz6dMrYWumB/Bi
Fa8jTzUBjL8VsPyXaZiTsvrxK69BpKiEOJ34RICLlXMh+WE0fNRoHMKzaxjj
nBuiNp0iwJLmbqHtvjPYmfy4UHtuFL81kb/3mNUDOVm9Jf4TFX2XlIuvMsdx
k6bKqBaxBuJlTrx99nIIVzjO/Q1VpuMfAdHwDM5icNxBqdW8XAf38lZF/GLz
UcjbiJ/Hsz6huGj74Y574xC8o4n++8AUKriu4RLjrMLMd6G3ve5NQ0b06J7b
4WOYltYc13KDff9zku8+7qVBrabvcPznEdTiVNV3nqlHz7cXLkl20kAwPGNz
zs4hPPXDuyjdi4Cvx/ZQtTbRoWv8shuX5CCajztryBQRsKll9QfFXXQ4EbNX
6Vv3ALZsEdblqyfgvKpFhcl2Omw03x6gPTOAAhZcS7VVBBRZV3prjxAdRBV4
MjKlB9FTTrn7v0IC+v90Cp9ZRQeqUPZM00X2fdlnf/dLJ+DHfFNe/RUaFB44
G6XjOohmkX/uEBMJ+LvKVdHzHw0k3ytd0nQcxJidQ9Flnwl4/esDxSwBOkRH
bdygyNYVaVkP+iS/sM+L3S8+p0CHjreLzL6sAbwMF/vF2gjoqf9rWdaSDrNK
eVenhvtxixHH7kO/CLhxyrz/QBwd1NcKSGXn9aF1ZsI+C+UGDP+TV3LvOx0c
FAxTVbeQ0CVtavmlZwNeCfd75nORAXYyHUvWXD3I2zeo9aynAWuOSO/aXkcD
i/WhrloFHfh7y1vRlbw+eO6iyq+4m/1c/ZL9fULtWJd/ZMHxUB9MX3nptCaU
DmcGz91XzGrB4NsOl8ORBIGp9T9VV9i8nMCHH7vr8djQiVV2ZiQ43bFFZcqK
AVYbggipThXIcWTHiV/rSODSXblrNp4BzskJr5Q9M7GgKzxbdbQXnMwoe7Iy
GaDwfdyjXSkamNdqnqmP9IK8qO6rDDsG7HHJ8z7vgfDjwNGunjUkkL60bLCQ
SQenOwN8bw1aANdnK8YakSDu6cBTqjMNnuw0W2tf1Q2rHQVONOeQwBNrPBXT
p6FHXnR+rH0Qxjc5qf0V74MYjycrY7ZU6JkqMuwrJkOXR/RW8cd9UKrYueZ4
0TiU3ogwfpwzDg1PuOOutfdB1sHL/g41ZEjofrBrtzIVjtZOSnuI9MPIX1fa
W70hsGnTdc44Og1Sk3Imyqf7YU/I/b9/RnvAx0s8JLNlBl7UawvHOvbDcNe/
SXUrIhQ1sS7bs/3Ui0deIreD+sH2Vv33jtBq+KdglN/A1lkiL5/cpyT0wwGl
T8ed21OA+yzdgbmOAXmqy1+8CvrBiBaV9iwjE0+ee2SUyskA+z+NUTG1/ZDM
cWow/FItOlz2OCIWQoeKUe/dmp39wJMRVr62vh2VqcXGXz/TIHe4urZnsB/O
numLOMckoUGHgMzJozNwUrFk77aRftg80nADFkdwQEz4ZPWJKdgZQbRO7O4H
0f0fJ68bUHD9YVrxzrIJUCkRLNhf2g/athgnd2YS90boFekUj4Fe86mbHGH9
kP45SGexcQqHHle0+BYOg4lnP7n6Qj/UuGRLuBbPoNznoe+Fcb3QPxtwmJ/d
zycbfE2IwnS8RcyNmn9FhGlL34C7PX3AW2IzxE+l450QnpAn2dWwUdnu0rGk
PqBqPyzv1WXgXsIF7cXgTLh/3bK+z78PDrWpXdY6z0ADsuKyycMY3HzxpdVV
vz64s6T+8PNuBto4fts9cLgYz4XsrKO864MGD46vvG10lLcUsrxnVosx5fse
uZb2gbbv4Xex1nR870IWfmzdjBof2i7eZPWBgERJhq4xDfvHC7cpfenGqafZ
bS06fbAtwrDJl5uGz85fSVry6kXdrP+0aX9JYOD99NdC1QzaG0QyggZJKO+s
MKdUTQKZULFMk7AZNJfcLbGqvw/bFQurT7wlwbtnofd0HGZQ/3Xy52PP+1El
Z01T130SrC3YeqLg4gwGqLP80hj9mK/1XnLkKgk23nnh32cwg6bm2f8ZbR3A
p09tZ5GNxyC8t+EMOy6902/zj23sfUhRVznKjlMFxFx7TGbQQ+bYiapVA8ho
r31saUGC/cKFpw6bzyDZv0q6iNyP+0IcdxywIUF1koWWjdUMvrNMz/zA9ncv
juj7SV0ngd3A7MEFdh7vhVtd+9h5aOuDyW7sPAs6Fe1G/83gsoy/kkXlADa2
XC0fViWByLRkaGblNP6WLtDjeT2EkguFsdvZ+lFycXT/lfIp9O9SRuHKUay6
3bx130QPmFxwE6DzTOJWo5YgN9I46ssfkAmw6YJ119ZF5bkPoJLN71Tt/XRs
/K1NPmDfAMV+JLkXdTUgHM6zwmTz0WRSU/ARtXw02/WDcImXAme53Wu7ZafQ
eqReXTauHadL8+oflVKB13OjgZ3TGDZpiRQGLXZjg094/V7LadD1/sTbJj+C
j4U/r9vm2ov5B6ijO7lmgKz66xjFfRBHz0YcqRUkYfTr/jNzJ2dgzY8TVm1n
BnAfdfXWtwYkPNosRUkznwERn3cX3430o+k9BfkYGxIOLB173GY5AxaNpVxX
uvsxwKatKsKOhPsxsyzObAYkp0MfEefZvmPszIXhKySsrt2l9dJoBg5Hzpy0
EB7APjv9W4aXSJglaMn9Tn8GBOs4GFo72P7apvr9mwskZC8uKRfjGRB1ellt
zDuAgtvGM4XNSaiVoRBAtZ6BFIs8i5bKflTPiQqzvsWuX/fWLZ4nMxBc9Gyv
h1o/HirZ4XvTl4SyohZuOikzkF5E36V1vQ9jXeRyvdJIeF3E7aYNeQboFIsH
4kdJGHHS9YnZCAnfdwXVHmLzeMaXJlGx1B40//zmSKt0H9YpjATYPKHBghyU
NsZ2YbuZm/IHpz7cxzgRXfx2CnZNf0sQqSVig7r/N6ucMdjTkpLjwsXWCdPE
3EG2DxodVrEusBuD19aFP1U8pqFCWjAALJswL/eKQ5bEGGyKLmA5LUzDvs+q
B3jv1+HujTIiWX1kkCJ+mcFrM3Bk385e/S0V6GC8rD70mQxPt0u76OTMAOe5
QJEsuxy0kpr7q/WSDFfF+XGubgYcYjfvGL3tB4T2xDUJfmS4cFRj9mTwDMxU
XjnOd6UIepYVtA0iyUAO0bziQZuG/7pInZ8PEKD6mF9HXDUZwgenqm+2T0GM
mSnR1LYDnIQvKbr8IYOisHXC96NU6H9yhIuYSILde7okfxwZg5m7f4NnVCeg
uU1qQPLFMPgUhtTzPRoD3v4ENZ++MeAUe9QbOk6GLCGzLv30MSAlmXtsg1Gg
HeiW59oxDrpd6wWedI/BFknPyWMcA7DwhiibvTABs9/OpM0tjIFMmuwmHvNu
EE7+3uZxjQpPpi/P2QlQYDDdvX8K2iC/bUOPhuMUfEld92KNNAXy07VlSxOr
IXSnAPH+jmlIc3EjditRYF/l+BoL22wQMfrBfdNrGpx7XipdO0YBPZ3iBI/u
j9jZEqOZ7zcNxuc130TqUEAt7OVJangF2l6JG575bxruiFq3fThHgQelspw0
9RZMnag99vj2FNyLqhJ+fYkCb4Vvn9/C040rwmtFt6hQgYP/ermPJQVWF9lq
pV8ZwGAwchfwmoBpT73y+MsUCDaovUkqGMXZLdtXCZ+hQNvdJqqYAQUcj24/
2X2PgoRX/d3D8aOQ8t9FXztVCqzdVqMkWTuB1x49RrtTA+DgwHWxQpgCNzS9
z4S8peIhi/dngNkFw78+6PsxxmBcdGOA7tAUtkiekj+0twUyL41vVKgfg/+y
n7laJk3jmrUqVmcEKoEZemqzacoYaBPCjRo5Z/BRX148/2gymGme/Nj2dgxM
t4uIcPLOYF/1YVOdtXG4acLZuiZsDILMzDkGSNO41O4w2TdYhG9knA8UR48B
/znl8C6vaWRgzPgNrEaLsMKXp3PHwGCduoqc4DRWfPmeIfa9AXsObrVjtI6B
SSNyUXSnUEZDiBV8vhPPZdVV/HgwBg4b281DBaaw/aCvzg6BbqyI39sSe3oM
3ghLn8gaoqL+MB/R61oPckTxtT7YNQaOyy13F75S8YzgjfKoq73YHbpVb81a
9nuZTkjpR1Exm7/8PUuYhOFyby6pz7FxFHPV4tdzKlY++LHuv0AS1qrckQka
I8ORxQWeXA8qBv8Xl/yvlYSxJTp+S2w8uqb+yvvwkIoOdOugYwz2Hln50rS1
hwwlhbt6NR9Qsd5CPtSE7eOuSVtEbuomg3mwV4nifSqm3HWIy1gmoaqKxzGt
LjI8Uvtm4OJAxfgipTP+kn04EG9aSG0jg4+qyoS8BRX/1W7VEffvQw3dm7rc
VWSojNx/V1CJilkZ5Z4pbD5tnRS/UBRHhuCV+vdJhEms2rZ4/Wr8IKbwuBgO
nSODQ1TQd+/+CRRZ3rnww3kUO7Uy5rpjRuH8TfE3F+5S8JHHX6fsL+M4o8lq
whdDIJdzUTN6Nwk5y6uOBCvQUfMEiXuneQd0OUw9tTtSBTvj9gwOsflIhB+e
RH8twcf95M431aPwYU+7jpH4FEan5TVXPO7Db2pZ7Utz49DN89t2zaEx9Lhk
I76DNIJ/M4Jumd2ZBN3oPyQb22F8CiVPWOvJeEk07Oe2NVQwf9+yY7vtAA6Y
/Ap6/5SMZf7T0/pnqOC4SlDRjNmH7/fK3rf/QsaRgpm6VzeoENt3dfKndh/u
VzQwT2skY7JCntrZe1Q4csQstWsNu2+O5+27OsgYvuNl1dx9KrwybPso+5PN
T2MCbr1dZBwr0L6R8oAKAimCYox5Em7v8DO+1k3GB9Fzcn6u7Dhtyy0WmYSr
OAOjX/WSEZmyOfZPqRCSGNoUl0fCF3Qti9dDZNxvackTEEKFG+VqF8XNSPha
V5FzwzQZZ5rOPL2RTIW1t6b8Nat7UfWxylnlZTKez3T8u66BCpQzPxqf03qw
+mwUsUZ4DM03JPON/qDCuc9C8szqbozJ64oWUx1D7muqyvFyU3BXJzbOCLpQ
X/t6yA+rMYzYJXF7460p4Ni4fUeLQQf2vCi6defVGI6ub1d6rDoObuvFLifx
NWOG+YFHo01UOCus++9+2jhk8Ajn7HVoRLFL3sa+z6gg5WEW/Pe/CeDv9oz3
GKvHHOWlFid1Kqj70bzFciagcMe+nbHHarCp0CIg9fckFPiE+JrLTsKXMK1a
x5RytFJrjnSumQTHGJs5og/7fun44btEHt68H/bNPH4SgnxG34emTcKMyEfz
f7eeY7113djC20mw5TcV7no5CTEXHmyaWJ0FPg8ChO99mgSfh190Mvgn4ZJe
3LE6q0pILLrNM1k3CY9MCXlZchOw3zv/kFZZExiGKl2u+DUJO033/cweZe9L
lTryJ55OyMurdQxj+5se5cdNp4+OgehtGst6uhcMbzcJ3r9LBUuzBHEbg1GQ
Lrpxp1pvEChaHNcYsVQYGa0wybo6CGeFtCuO84yCqdmGO34EKmg5ONxZx/4/
oYTRFvSODCE23TtUpqlgpmUfbmLUCdyZK8vRHWOw+uE14xtcU7CjOWfPZp0W
qA1X/HWzkgKxucunhESn4FuAglw7oRosTEt+Zd4Yh2SZEpr0nimQjv26L1jl
CzRyN8RG1Y/Du7i2ZAWVKTi++bpmNtMU+I/6r4SOjMPT47M+2senwJdDU1lA
4QtK1lX6NaWOw/nxmgvl+lPQ85GtV5JrkM9v6N3y1nHoa5URW7g4BbwRKRLH
HduQfGpxcK8iBY72pTzbYT0F/ie+t1pt6UbJfxe37Gbvo1GGG9Xdhn2e6R7y
6Ww/GgnlcOnzjYLJ/QSNUYspcFFeRbggNIKUK3VThPIByEr0OqOqNwWKTyP0
NCLIqFxRRuiv74G0iJU1Y4pTwM+lmH9ejYL0aKvy1EftkJ4QcdKPdwoa7msI
m9uN4xPKQaqfKgGW34y6HKFSwYhznY779gmMmvht/ZtcAhKMX9cz2P2PqNUc
r3o4gfqSZVveCCUA4Z1zD2cBFdbTrya2ek3gP1nZrV8zY7HyiFlxSRYVhg82
bPhnOIGyHDq6EZu/4ti63+fT2Od1+MoDfH6PY9AOF8v7/1XirfncH9H1VDBd
b7wsEDKOfxXe3dTRr8MgLi3QJFMhilfvsrbAOKLXKN2bh4jndYQ9/GOoYMEv
4358hoJ9B6i7Mz62o7+QK/cO9t5ZKyR8aLmRgtYVx9m6vwM3rz1oaKRPBU03
3uZ1uRTcuiE58By5E3UYlZa1ilTYdjk9wiOGgtGD/E1ZcV34dg3Hqdei7HpW
c7szgyi4QczzVY1cNwaemzHWWkUFk9PqZ6O8KXiDyW0fG9yNtu3cC/TFSfgQ
8/mJvhsFLXaIshq7ulE8bq+LDIONu5C0zvNs/RDmMjtSuaEHn3/fEPJ9fBJ8
9yq/OnWbgj2ludwSJj34kM/S9eHAJAxvjY18aEnBxzMS+y6W9mBZ8iVu6+ZJ
eNK6zbJbm4LDq0bnaGz/cGmKWz8kZxIKj3/eySlOwZByXr5LXSQ07k4XjHaf
hMD+d7O7S8bQ0iqycPLCAKqHD985zcaz1/OwSxlMMqoG/KAPrR7F4waOt0O2
TkD/e2s+juYRpEsExG/zG8deQVXv8MIxNq5q9alZnaiidKn1lSwdH0Z3cpyQ
7wUP64hKrpQy4Kxe/bfu/9+Pnnfv5XxQiX+51VUItgMg9absAQfXFOqJpevy
So0i42fh759yZMgrKzlMmSJjQ+SWTFnVcfRV9OCRuj0GN3d/mRg6N4QxfZ/2
TGZOYNFvmjPH/BjUzBG6zMf7MEck7sWQ/iRy6kll1BygAO0/Za2jfCS8Yzt5
VjJqEgn9+9X8TShQeN8j25mvF2ev509kV0xiP8eLrmpbCnyXu3vn09MerLTS
T/jVNYl/muNW4h3Y+tTQhLdNsQdVbHszIkYnka/9823CA7a/y94imj7fjdp6
prFc05Po7vQvSc6TAu7Nr+Mb8rvR4bbuYv7cJGb/ky9veU6BOBYt7vHVbjQX
2fKAb2US9b+f2bj9DQWONdwt+DnThTphLw4V81HR2dNtafNnCvSak5hhOl04
eFJ434Q0Fa3NxHeZllFgb1lFycc7nXg8JjFUXZ2KEUkSH3/1UaBjOvlV6tkO
LIofV/5pxdY9RrMeJcsU8KraZ9kwQsRb1MuyBf/XT233/HOkxyEv35Xhf6AV
K8f1F23zqdjKE/lk9PUQeGleyxf5UYOiP1xqxcdp8KX2DIXv9jD0PNhzjP9y
DW4IqW7en0sDSZPn1zqsR4B0R+vv643VGNZgpO3hTgPyxFWh68qjEMkIGNed
r8Bn8R2XWk/SYN29a5T67FG4K+i3VyGzBDuEIj99FaEBeg9VWIuSIfPwj/vD
p/Lx6+i+TfXzMzDXqlzncZ4Mz98cuiyuG4/W8sHBnqMzYDX/4uIdczJ4eL40
4T8UCk1zYbv/suOxzzbMlW4mwwF1hU+SFnmwbtGx8eD3GTj98IXnB/9ROHTe
UCipqQKa7FUMfgnR4K3BPsXNxiPAW1Ebte8RAUhHTihoH6HBufPVf9avGwJP
uuA8rakNOt//e7DJhgbfrxwU3GjaD2HOi2eeqncC+ZOUzog/DbIGiOklJr3g
e5nr2Wm5HnjS3hoPqTTgeZ8SX7OzCzK23nXk+kSCyYnZ3SnVNHD4feIdrYcI
l+UkO56l9MPD3iTfGhINaqg88xfpjeCumKhurjkITyt9d5GmaTBK+DnguKoG
hs2RyXIcgigrfT3DJRrojghryJO+wU2hbav2qw3DwAdo9FhNB0Jw33Exo8/w
29Z/0vf9MGzXFta6LkSH+E7PqruBofhu/PxqXr9h2D+Qdj16Ox2OSgrGwcYv
SI3hpRvRh8A7zjmaKU+H1j1e1xVOVmGqBq2ipXwQ1EvumoMaHZ68SPh18EMj
1nDm3yTM9MPLGs7yuyfoMOG/1NB8ox01rA3bH90kQa6f3JOv2nQoOxv97yJ0
47DGY5dyzW4otPlHzNFkx59XfY1MIOGm3fubOV63A6nZz+bVATqo3Fg2c7g+
gGbnmbuytjaBSJmxMJ8kHeTUZVQF7g3hrdizT6LHq6DFcuXi8VV08P5iqJ1d
PYzZ9GenKSMFoKecLnCaQYO+ji833tizeXB1muyP6hgQc7dTfjlIA9neN2st
X41g8ZmlzM9WEfjzU3z4iy4a6KtRfjbpjuCP3d4B+4Ry8QT01mZ008DjGE2r
umwY03fH6/x9WYyL4jvvFw+zcXE9WFR43TCam5D4jhysROK6YwQf9nN1jaaa
5R4ModIjNZI51uPCtoGZTQQa+Kk7rHpkMoQ6cq0Kd4Ib8fM7fx69FBro1f0y
ea4yhCE06ai15GbcXcktIhlIA26rCIVVm4fQTPL0p7VNrXh705/I/5xpcNKt
+pQY5xDO8LkF71Ukov6KgUL0ZRrYJbdoONEHEQqeqlt2ErFeZ4xbWocG2eHt
P/T6B5G8WY624Uo7Hvw7x7ValQaTajdu2DUM4lsFjtNCQ+14WM0sSngPDbzm
9sq0FA6if2tQ0BWLDnTfopf8mI3TAC6PkVcJg5hkGrnt2FwH/pm3bXPhpIHN
0g0Rmt8gRmwwP8Ao6kQDqc5Kr4kZdveyBsMvDOIu+YXygtEuTB0Kftb0bQYk
iM/sjNYOYvblCdfF/B5M1fovY73jDNw2usBBuTeAUhI+9/uL+5CykH96A2Ua
+p+lSogf6UfP8I2alf+Gse78rSTB0imovmV1cVypF1MIW7fa6Y7jfpk/1ruG
JyDs7JnIlNBmzNn4cNFrBx2PNmbA69l+yPczKjJ+VABLHl5O6Ww+qux7pZao
UYMqE+uODzI7IUV7QrR4kopkotcjn+YxzEq2TV/Z1Afus42aVv5kvOpYvS/v
MxUrvFqaKhb6wQIlHP3/DGDEaaV2XvtpPNR69oVnwwCIGAqej1jF9puU5fOl
KjOYLkP++kFlEK7ITPlZZHVj4pPcTTWRM7h1W3n/G6dBiJMa9ORV78Lsaxrl
5zpmMKCpkHv/20HISFRPsTnbiU/uGyeTfsygsV2352jmIJi1NSwEJXRgfsmr
QCk+GmZeWhLsrRgEtaAdri4SHeidZ0bh2kbDnrgltab2QUgojXZixbbj4tnN
4hyKNIx1MC3dRhmESL2TgkUS7XhooOGYmQYNO6sH79kuDgKzvXkmyo+IfRv3
7fMzouHLylizD3xDoNihYpn9oQ0tLvPdcrOjIaXom6zxniGYMre+oDTWgpZa
XTWFnjSMunrzyHutIbb/epTrWtuEYcG37E0iafg4oWLVOtsh2BD82ahatQE5
+FuzaIU0bFYs4cx6PgQPtl2J4dpdh3zn6rjek2j4VCbLI2N9Oyg/UF3RLC3C
Y5GPZV1zmNCZvvX248R20FtOmeQJ/IZkwz2qAu+ZEDdwlUPWtgNyVn25MBj3
DStZq9V8PZiw45OZ226NTjhIdb96Covw6j2lzwUWTDD2XWMtt6MLjsYJzNPT
vuLKUd2tihpMkLzwlN77uwvixqp5beXz0Xaz1c7lHUz47fOVi5rVDZneZ0tX
dDKQaMD54ZAAE24yzhjBrh7QLq+NmLgSi9PFMlOnuZgg9HRjQdzJHvgyS/6+
L8IINhuP6u7kYEIOX4nlLa4eIETI8F3blAC+G5bLptaw629RX/E17wZ09b0Y
eTwPPLKnhk4KM+H9uiOCYxe7YM6+wqjwTgncnp+OU9/NBKltqqID6zvhwYfH
xJsbqoBwpVZ/yyEmJKVUi4r7tUP21gfbK9fVQfkDjbffdZhwo8A34VBaG0zc
O2F77HUD6CzRv3deYPdTQnTL3k3NEBYquPQnoRlG0Dom2IYJVsn5vEKGBHhV
ylpcPtYGDpFNPG4OTLhg8dQt50oNEOe1/PblEqFY4JPeUVcmhC1XqTI0KkAo
tejsmpftsNugoCXamwmF46UzejWFUOG7Nerkjg7gvaMRdS2QCdz7zwoFL2XA
BFWcqfKgA1oU6bYq79j9N2YdVbjyGv4KKbgrPOyAxFfHvtkkMKHBPG/kRnAE
VqZ4VtSIdoDMCYe0omwmXI80X/WtLQfXarWER+i2g+KAdeXxMia0kAv9wkdK
8GXdv2eVnER4IZqwbNrABMvLMsPpBtXY4SMQEOjXDM8Cn6zQ2pnQwRm+8YI6
AVfca7807CNA/Syf2JVu9vvy7/UoftiMGkp5hjdPVINEh4y4cicTHj3e+8qZ
0IbuNzaFbRYsheaAk98eNTPBxprSQhVox33ykdsupeSCkL9P/K1qJozmrHA6
V7Tj1DON4NprccAjq+0UWsyES+9zbc6s68DsjJvb27c4oTx3TsZEPhNm0nXP
f/jXjnu3rHJ2ehCPsKN87R32/FfZCwYrF7ej0T+Lox4fsnBKPpmoyo53RHgT
VfXZ/Ft3IIi/+wvK8F54UpHHBOW1Yrq1q9pxe5SXxJsNpbhua3NHTxITnHfI
GtxbZvPEKftvZYYV+GXfdU2+t+w8gWFmXPNEHHEaFD5nWoVcaxa8+f2Y8Ccm
aeTTFBFbK31FNaRrkOTuekDRhQkbz+VfsGLrS4MkcYJ4dS2mOuYRPa4xIXpR
yntjDxEPyWvPCOrWY+tWX4vSc0w4KX6uzLGZiLqLTSsrFQQEw8cLNppMyM9U
2TlbScT/Kv/IME80YtWWxFWPFZhgZ7yZN6+ArV9zbu+Nm25C0kwLl5MYE7I/
+bhpfSaiY4HhpaSBFvxDsk1NWmbAbme/w7JhRAwoKz49JUtEQmLo8U/dDND+
aXytyZmIqVyKde862tGDX/Sj7AcGiCxNLk5pEPF7/6Wy7INdaLi24MDz4wxQ
P6Fxp6euDQ+/8yf86utFmQ8/Latj6GCpk/JT1bAVBY0/eFcQhrBQuDQi8Axb
V4TS34sVNWLZWu3DGdzjmFHgJ/NdYAr2+0YuiVtVoF1s0LlPEnSkn7ffmOM2
BK0Wb9o3+afA72shbkFsPmpY4U3MF63DdeefVynO1EGZtujtV/VUTOPxHlqd
MI7nLB8fMppvBg/tGPdqcTLKbZU8YSM4g21qKls+K7WBSaPKsqpjP35sTIJ4
YTqa9+T9thcnQgNzffzFzm6U4zSQOvKHjprFzTy55kRoV2co3ZvsQKUm/YHL
Dxj4yi0vRcGXCIJJv8KV6UQsukLtf1jKwN2K8rqfYoiQFxtJTOBsw9mNr9cb
zTDwo4HpkadZRLh+yytbtacZqwpeqnisZ+JBK+sUiVIiwEqBaMSGJvwFwif+
7GBiU/SP/Wb1RFi8Fp+i59WAhjmPE1UPMbGeXCpv3E6EbW0vlHpXEZCxLFKl
dJqJ3+2pT0r7iUDS0XxyyJ/t98diL+66zESm//TqfxQifL5YK1S4WIMtu5K0
228z8SisCzNkEMF++eap35rV6Jy46n6EBxO3+uTuKl4kwto2JYGSS5V4RUD/
SVAQE+31XWg7Odqh8trL3tZb5bjvaeH2px+YqLB2rcSZde2wLS3kHCv4G66s
1eX7ncnEgTQ7nk9f08HymhpRNekNrnvUVWA8z4KhData7h/LBOWZeUGiSBwq
7n69pZ/JAu9jk7dUf2Wz9biwvWNtIsaIhtA1p1mQcSjkrPvvXNh10EDNvDMV
M5eDB8+RWdAwHfjT8M0XuL2RRdt6NwspZbGuP3tYoLzc/b21qBC2Ft8++k0s
F8+1HaTYNrJg1dd7HJwnS0B4ixbHhot5aCCoH6JWyoIwzk0pX/+Ww73V0x8U
a/Kw0HrX9ItMFpzx6nhnZlwJbhLWIw1qeXgvdOJDahwLxGV9ClyWqoDc1JLj
lpuD2nmKdyfDWdCdrDTeeL4GOJyto776ZGDCQa1xkUAWZFebSkxcqoWKc81U
hvxnlKnuf+jwjAVanOdtXnLUwcqBXUVF8R/QtW+T/jsfFnRZcwr+M6gDr8vO
iZm3AtE7ONt/1JsFe67Vjn00rIPDD64b9wzaQa6j8ttQ9nmNpeYDCfx1UF9S
XfdKKRzEXnz9vM6PBQxqUtW617WgWJD2VSA1HsqrLxyfYD/3DA9zcP1YDRBk
gHXmQSosddmKLr1ggd6F6K+uf6thMnGHbcy9HKjUOHfHIIAFprlWtuvZ/uHf
+sg9ZGY+DK1XebQ7mAVHYSDGKKgSjhePj6zfWgjq8g8tx0JZUESVrRwfRtgm
tHHd8NA3OCPB1OV+xwLPzvXXi/lLIWGbUKa8QCkoGVPkVn9gQWnTwZP98YVw
oGMz19CTMhjaFx905DMLeI5GVgul5UED3tlzi6Mckh7LZb/PZcGbtCaxq9Fp
cLOR5rzevgw4C9v3h5SzACe8bhupxAFV6aHTxq8l8MHl8/N1zSyoaj7b5d7k
C8yaLhEmowi0AoVOZZFY8Ge5/dmjfh8svDlziaJbAD99yj+eprCAQ+tHVXhF
JL6VdrhnL5QLYjIuzXI0FlRs+rh2zfFPKHKodf/zQ6ngI87MPT7LYvuUS+Tz
Tcnoo7p+6suFj8AssR9aYs95yIf97jfj0tDxQWP02agQuOH+4tfsdxbw77jj
d2kxHR9ePZ4u81sR9Nee5q1jx0PapUYvbMhAp0Jb34dfA7Hh158JFjsPmRDh
+qwgHXtY0afuPonGnKTMO+vmWCAy8XbFMy8dr8vx7V1jlIg37Cu+BTJY8I7a
csUyKx1d6xK9F+rT8FtQWV7DFAuWnqzVEk5NRye9lxeXE3JwctXa4twxFvzN
O7HVNSEd/+7wHClczMfutYZKmwZYkKyp7X00Kh2J5H9zz+8X4uud22+/aWfB
7tzS34Mh6aitKNlqd6gEKcs024+1LBBrJ+0P9EnHO8NRYjw2iDrvZku1v7Lv
sUv0K8spHa+eqam9JlyFbgnltF/xbLyQl/QaL6Zj0vyS+i9qDX5sE9Db9ZwF
brY7daVU07Hkl2io3TUCzm0PaFa0YkHcsZO99zjTkffroy7z/mbM0rG1eiDN
gpykrPZr6Wl4yHFgVa9zOz60LzymWc6EBe5lQxRMw45H21cZ1HXjsnlW6Aov
E7J2xbqGdaWglkFq+v17g2h0wYPXL44OlXmBVrpdSTgi+04yo4iCT3YdjRrd
Ow2QXMU/+i4Kk/W2+pxi84TEycHg6M/DsHCTJLk45Av1HAde3mHzkcaxjyud
k3XYlP2qpjojAYT/e7hMSKKi+HXmA+4XE6hkdkp5e04yNDsfbbkcO4qBBXvV
rxvQUP/hFVO9sFSQyFe3bikiYcvZLtZGNwYqm1xg6N1OA/UsHbUWu068/Pm/
TYddmBi47zlRdDANzEMdc6bi2nBHEOGy7SITVXrKP5ZsS4eFqyavrR41Ymis
k8MhLRaq3Cc5SZ1Oh5mcd2enA+tQ+8jqBZH7LExiqsuO2qVDRlL+yAn7apQX
t4tXe8tCfqOeszbu6fB+divjVm8FNg1RD49ksNg+aYb46WU6rL6xzthBvQw3
G1kuuZSzUKbphob523R4HFtz8pLeNxQ46OOy0MRCs5dX3ryJTYefkh7Yk1WA
gVt77kf0sLCo0CToR1I6qN2Xzl57Og8JB/+rFBth4Zv0AaHR9HTQH6up3r4q
C+8aLGbOTLDPj74yDctJh8v2Pr4awclo92rLFxMaCzOfBLTt+sKu/zAvIYgv
Hq+8/y7owmLhqbGktbFs3jnyLHd2kfAGdxT7M8/Os9jzRX28K70GaZZ/C54n
ZkNC8pJkPHtPchvOnLtxphabd+/gkb+bDGuHVqkqsffk8+hdVdeSa3HPw7bX
us7R4CRxg2uOPZ8hfQ7P+xJrcVBCBPTI98ApjM97/iV7j21sjtsvVYspHsqj
S9feYrDp/Fwve09Ovr6roLxYjUly58eMjqbiseOTR3LDWDBvu2JzlLcK3yf+
MAix/IIae2avL7F5JItSJcGXXo4b2zz3GP5Xik9TxO0mXrNAdcNDCXpjIWrK
/+xILK/ECzGBOuLs/CEfrRZ2RmXjYetXm3vGaxAjPrWdYfOCEzlEqiI/BruN
jrTeNqnHRcogJdiFBQI//PcbHHcDP+rQlOosAVM6bloNXGNBqpaaQ4RoIuDU
n2MapQ3YX3ox8ZQxG9erRa3EfuTC24MXHPibG1Ai65SUoRYLvA57bbPe9w22
iF7/dEC9AXM33Z79oMrmtVg1xTBEuPbt2FZLBQJ+WVSdl5Jn8/VITfvJPrbv
+qAi9/dLHZ4eGgg02MmCvFedeyxDa0FiRmDLvokalAzJ/e+mBAu4fPgnWzcQ
wPKvpsBMfRWaempuSd/EgoCPOW9UrBph/6TbXJp1BZ79WebtzMuCYFICM82j
GfRX/8d14WYJJnqWHNfnYsFU2HyfwtVWOLpht8q4bwF6du7h3bPEBOmhGOaa
5TbQjG0NLzuThXzT42lWDLZ/eZlVLBBFhCbiJm/W8Ef8Wen29tcYE1Bnr9f6
JSJ4Xtz7cxvdDSXmjNI+9TPh6K/Sy0W87WBcuYFvsi8c3rsu/fPqYccJz1yi
2oggXt2RatKdBCEZy6diSUzo8bMfIeoQweLKg8Md37LhlJJy4lF2fnW3xge3
VrcBfbVAyIsX+fBN5mqA/He2zz0z23RYvgW6ThcY7GorgBHOsIS2dSxYrnrz
mvdgE5BUN+4fqv4KrfN6/O/Y/cyZ2GtZfLYBIhy1aLS3X9m4PyjarM6CDe+/
H9nxrh6cSg33V/gVwGq+A7qHL7DgUZWLeJFsHRQ6jkkNteVDbpQPr+UdFlg5
rOiaCNXChld9U0czc2HFfLPmrccsULDaNO+XUQPlXPbVAbcz4WGN9ZdiNi6U
qiwXP2bVQFjUiwcd8amwJXNy9/9x0cQ8QW3PqQFFB1rtqpVEKJaM/HCaPbcv
/xbUjeTVQLptfu+TjlgokRh9dIetHwbXRPV7fqmB5G+FkcofwkBv38SfMfb8
Bzv/169VUANFiyH2pf1XwVU6qknwDbvOr2t1P7LP6x6IdfTmCcWpUPXHYmwc
JS+9OFadWwPrJ0+83P8pAevbhqO+vWLP+Zjh1/vpNbDfj/nIfE82HuXK8pZg
471ha6tTXVwNVKxV2f+EpxAPHqgJ0GPj5cXmsfl7gTVwcbgrcCdfBWK4btxZ
UxacFzFtcLtZAzKisykeBbUY39UZ+XMbCzpdWQ/L5Wrg3iOTQ5uEWlBrXi6t
q4I9bzma25q/VsPyE4a0TkQnZov83bNakAnaPy4uZtZUwboXf4fCeAdQ9/nC
m9ZYOrB+hjNHHlTAtqSe3k+3KejnL1w8vHkahrpkdThZ+QCCQteRj45cv+/H
l9gNg91kAe9A3gd0U78oe4bNR3NZ23JmEuvwV85lr4vipah5f2DXlA8VUw7y
Vc/cmcBddhY/PlIqkfnmzC7bbaPY7cDxJVaHhn+LmftCz1fjrx0Z743oPTg7
1RhT7sHAY9MeCza/qzEhYfQFvZeImpu9T4k/YuIFm6BKKYMaFOhe5fNSqgEf
DgX9a2Dz0dimmr9mj2tQN7WF+35BFYbV++drqbPrUggM/f2uBg/fcGsNNS1B
7i2/U8l2LGwcHlzv8rkGrVy9DwjuyEeu/QwBN08WdsdLPtyZXYNVaaV7Lsan
oNibLtlvASxMU3O/8jK/Bn0S7+weORKFHOvPbHMIY6F/4ryTXEENnpQsttR3
dMfJyKBNM+Es3PbzSAM3Ox6z/fsvofN+8O/Re6Vsdvz56+aXVew8l+40P9jo
+R40Xw7o17LzQISsGzm3BnfSog+aGydAp39lPvUVC7lnfce/sevp/VO/zM3m
Cz2Li1GxgSw0Itc+Cs6sQY7NqdEpH9Nh6u9qIQN/Ft5L3LI6iM07HIc3ss5x
ZoNm9OON8IyFzLcp49ude1ElNrJMybEKsiJGzHtvM0AoeWH/aVUS+v5tKNEJ
QPitHHY525wBciLnFP0nSPhIS2rpTUcRlE6GjHYaMWC2SZzr/PU+nIu5v3+P
Sw40ZQYG159lwHcRlZ+N7/vQR+SkBlDeg8njh98+nmP7+rjPz3eb9aG9qfde
zk8R+Omu2yrpqwzgbbZgxLmT8KbxyTu7SvNR8b5B8JeHDLiT+Ubs6XgPTt1V
bth9uRJNvYeiF0MZ0PWjhfr2ZReuFpkOPL1IwOKQVxefpjBge6bCkU73dkz5
UWZ4fhMRd55TeiZbyIDzHXU7pwhN6BB8d+CbcieGPry08c03BrCNuZvQqhqU
Dr7A3ZjVjSUCzdOmOQwQ2XWQQ0G1CFOqjjC+3utF/t37UqixDPDPu/F1fXg8
3vhsb/D5GQlZhp/Jb18yQCBr1ayLSwTcLtw8nrlMwnvqkQeLXRigMDitFBKX
D5WXjdwK6CQ89nlISOAKAyzW+Usm6FQA7cbXMj97EtIqtaXq9Riw1quCevJ2
HeyXFNTTD+pFLp6JTWvV2O9Fbpl+a9AMRuZl/BWGPfhlvRjv6d0MUH3xu1mP
ux0yvi6cayjswu4ndYRcAQbscdYSe9TcCQsiR/xfYweutXu63ug7HdqlX1Oe
e/ZA2yG+s+NXiVimQPB3aKfDNklHYZc1ffAv/7nzsQNN+GP7nrltKXRYJVVX
pn52AKRDpt0pwzW49dDqiA2udKAaX6iylB8Cw14aL3mmBC8+V1l2P0mH0qvP
F0L8hsFt+Hjg+W3puOMv75bITXQwtZ0mgPoIZB0SeSiYbAWCa+7GNzNoUKbu
+XaV8QhIcvOHSr9LgwtZR14ZD9BgmO9oU0/nMDzWe3tj/Y4iCPz9+Yk1mQZt
a2gpMD4Ez3oEhNeeqoAXAbu9TDjosMK6op+RMQi3eE/J/T1YDf/98LreoUyH
Yc/5LMELA7DanCNy7WINOF/6J5h4nw72SgHyN7j74f15ThnT3Fr4Exd7cKKY
DmStF0VebSTYLhGqGRBdC/UVs8+y/9FBL+xSrXFLL2yuXfGOmKwBnjXazkR1
BrzP/YLvH/aC21+OtItxlfBBfehigTMDtulb5F517YVrEJMScqkSvO42+s6x
5wE5H98nPe6FP1J7Rq8mVYCfi09PkBsDtBRfO+X79oLVgUSPp5wIqXfc/5Px
YcDG7rpYl6BeqJ+I/VLbVgLEc/I2O4IZ4LWl7Oq1d70gYd714WVqIRhde6oT
GcmAvM4/sz4f2XGp7c8zH+fB55fhJQafGXDTVJnbPbUX3D9O8N22SIFj5o1d
r3IZcKHhtvWV7F7YX412Ehdew7N0wvyPIjZ+r8S62LDjVXOWi75Kr3FY873g
b3a8+zf1+KakXgg1o3/gU85Gsf0lozwZDHi2V86xwL8Xiu/nLMQfLkPlhw++
O/oz4Nsdu349vV4wyTYNnDlZjznE70NWRxnQmdmwJbWpB7h6BNf33WxH6x1K
SsrRdBBfo0Tc+6Ubdq2Xvn05qQ85YuiCD47RIMJBWib2XwfYy3ErH5ekoPrw
3MjVXipoOP8c0yHXwdNDTUE3V9MxJ9+jyfTrIHxlzL1M/puDTi/WUfey+Uhx
dPZJikktHt5p8kNegYh7HoTMh1yl4rkF08OEs+MovxRe/SWjC/eYBPyYUB9B
M8Pl2d65aTTeLnbsrkUPZo7b6p+R6sY/74yvRW+g449NvkF7xXpxHW+7qv27
ZmwNcfef/0XHuiCZ8FDHXvxac9K0NKUKT+sVG4zdZKDqqhnJ3sheLBO1yijl
+Yqc7iOhrA8MXJOec2YyvRdlbQ5HFkd+wgrGvGrkFwaOGkelmeX04nHf1vF8
H30wWJP2XL6YgS8cb8z/yOjF9gOHalq3xgOVr5VEL2CgOYZv10jqxXy9fYrh
P7OgdJ75SSODgWmyp3y9onsxQrTjn9XBAkjhUdqz6iMDL6c+lzQJ60X3Xw7R
ioPfYIU8NAjhDNQO5O0ffdGL5xriVUz/R8KZh0P1v2GYqIgW7ZRIspciKeEt
Ku1FiihElH0rKpXIUikVEkkUyr5mp5dkl31fZ5jBDINWZf3N5/v791znmnHV
OXOf81z38/gUgnBgxjZzXxYm6M8rctxvw71ewQOnNxcBv1P6bc+7LNzvnnXq
2O02PG9xXevi0mLYdX1uUM+FhVQLraItrm2YKLfhjvzjYsiPn6s1c2LhFVtv
gS8ubfhs925/gdBioEvZ7GA4svD1UPeZ9gdUHKmxU5M+UAPtiesb5FoYMPPR
0PQVfz82pnZLmqyuhOCYBfsMEhhwRyw9aNGLfmTVXCpexL6vU5N8+AZ9GZDC
GLBbxTWAQec37aZZIIQq3dW/4MCA+zE7BO6dHsABDseM7arpYNDq4ClrxYCA
cis5i0sDeKNRXE/nvgf8uVIWcPEWA8pFZ9/7LB9Ak6nm79Lpqbgvpfb17bcM
2LxKeTzkSD+qUJwjjH5/wcNXCpd9bWbAMx71noifFCxyttqWrViLTdvVjnQK
MIH1+G3ftw29qHXAzzUjphm/cOsnWh9hgofd9IjWhQ78/ag0Xya1Ay+KKWnp
2jLhWKxQLGWiCXm2FX8JoPTgz+0T0YvuMEHE+HRonnsN5sy6PH/mRcHVItO1
y1yZkPrYoLdLshjXDX+ozgik4u7ORIfRK0xYtb0tbu9QLAr0Cx7xkenHR+Ki
gsonmPA8Muh+bnAkTCYfsQ8z6Ed9j0P+53YywfuW/8fov/kwFl+zM1yxH7fq
hUhyrGVCQ294scDVchATyJMfQCrS+izKMv8x4NGz03eaD9bDo5mtEpZcVFz4
tfi2UScDHChFgQFFzVB0Kfam898+lM09f7LiEwOmDgueGpTtgLev9h79q9WD
GTlnjvN4M4Db8g2z8U4PKNvoDpbT2c8FduKfFmkxIF9BjHOiigKtovx8jRUt
uPTsjsnwyWFYOPBebE1UP0hdcgn6OVWP5gIJrgHBw5DOvUm5XYoGp68Gttsc
KcdTereXzEkNw6KcmHN7DtABlR8viFbKwRjGtZaUvCGwxn5o76HDMecNU8pP
PXF2uX3Vq4tDENMcYCyzYBBo/cJpunFpkPJA7cK4yBAUdqlFHCqmQ/QRz1ZV
nWKgnj2yymPFEITIxKjV76ZDX99II/eiCkh/u7L90M4hiK04vTnXnQbnu4e/
eQ7UgODPw7dj7gzBzVXih99mDsDVTZwGEgvrYdm0PuvY0BBstjIa4mP1wy2v
1fOmHfWwyEn5aLTZMFyiW8j6KvXDNmuFD8rLG+BPivzDeNowfPeRDbj6mgpf
yo+Db1k9vFX7mGxlzICVY6bqRc+ocHzn6etXsQqmFbyOFQwyQNxWl6L3lAoZ
t3w/qyyvhkG6oLL8AAPm07coRLHPH7EtPL2jpAosbj2yf8E+/7LDkiinYCoI
Wsgnre6uhJ3GCc1vJhiwdNdkwvl3VNC2PGI+rsd+P/Zc3JvIwYQryTqSb1Ko
wLI/8TJzZxl8Pet3IXcNE3ZLxbhqFFFhrbmB0keTEkiT3lGjtZ0JFy7vEBhu
oIL6u/6XqskIvecjv5xi3xeHRZNGY/qpMD51+GgFRzakycWx5k2YUOwlF14x
TgWzSGevvz9iwQ8XextfZ8Ll9N9Mtd9U2P7vqSX/Xx0USaaZ2rDvF5OT711P
jbL/nrhOIQ8Gm1N3R2LUibfgmD/qXkGFzqxjK1Lri3Hu6915OxUmUG8XWiy3
p4LweSGdrRm16HxvTtY7iwGy395rnXhDgY5772OzdNrxVGnG+QT3YeCdHjKX
XNID3B5BTTea2b9Dy78s1LKiwzWdJ5dWWTQA7/vw72/mRnC7yKXug3EdsPpB
6phweS6qcuod5WfzyGR0tsttQQnqGAb7zCS2o8qPsi6X/UM4JVUfYavQjxyn
8nnD3/fhu0VvpI6c7MVax6FALd0hbJ4OKdDeSMUs1rH1jrZNOCMo9/SOKgP/
uUQKKMZQ8avL7CqpinJsudLy3mgRE7mtUpzGeqm4YqE0n+TOXNz60DnYy5CJ
8u5e3VI/qdgoYX+Q3voWVc0MtxncYqKH7aUPtezj4hU/eoLDQqG7qDP91G0m
1lm48lMZVBS7+1vYZzYNOEX3boy3ZmLS2VUKjzqp6CzwelbUPx+ob4aneM4x
se9wzcoVlVR8rtS2ZcmnYuDW9gzT3MfEzSZRWVnZVBSq55jd3/cVbtIlhJI2
M/GyvduRDbFU/OOltPbhhXKwfud1JHYJE51S0sOtw6hYGym4lrKtEjIadp39
McnA4T3R3e4BVKTuO/5npVkVaJv0La5iMrDg1+9nw0+pePSj0fmgmSoQXygf
zE1joEiDhdhv9vEbMq9Nf01Vwf6tIlLr2McTTnkPf2J/Dt+g7ZXlF6tA791L
jfUjDKTkFP1zODCIQlG3pJ8bNsK+WK7fg6vp0Ft8ejiqdRC1R+cmTj6pBxOV
pQPNzTQIj7y077vtEMY1c7btMaqBVL0TXhve0OBXl8Zh6akhLO4a0ntwogxW
29v78jrR4KpZGL/1tWHksn8obXqiEKpaRH6JGtFAbcZhx7W3wziaavTgTnc0
KNirrS6yoIHV1el/UbeG8V/zhjCZS7Go5/vJ/Kc/DT4U9oRVNQzhxVeU1DMi
JRjy8GFedRMNhI0EzLvuD2Ix50XKZHI9LsC+wGAZOnTqLRR440jDgg1GHIU/
27Baz/KJqicddpnXWfAnU9GyjJVjXN6LLyjUhr8VdMh9/eo3taQbB/o6lc+e
7scAeLwh6ycdfNQldhW9akEzmv52mQAavtjwKuMV5yAsWDoXp/S6Bq3iRh06
xAbxzapz64z+0eHUsoDCn1UFqCAi/pO5fAg7H0i6Dg7QIYy/79yyhttIjbjr
Iuk4hA+OuxziYX+vwBXePzybc+Dr3ZJf2hfZ132L0qhoHB34vm/7vde5AgYc
THZd7hvExhms1/Wlw9VHBzQs9zdC9YXzLrlzdNyr4MF3zIQOF/D2y2vy7fCK
tU4oP5OGDv/qfYvl6RDyhLkrc0kvSNhXqYj/60dHyevPVkzQYNd5j1vb+qig
edZ4Cy2fgihWLjP2mgbtIoqh4340MPBbteXOWBdm3nd5d0yWBlKmI5/CaIPQ
HhugX2fVgjaJn2wjIgeg5NaM32jhMLill+p7Xa1B/cvRyRULBmCZ3t1Ftn8Z
wBzQV/87n4e5QeZtPmb9EF6a1L/Qnwk5qubOZxJvwSZzrt/0TiocLUhvdg5k
wqZ0rsv/pPLhCLfnqRfuVFgUd2uwbxv7uJykEE2jAtYUR89XGFOBX63e6gGb
q31my79UaNeDscqd3OR7VMjaPBpCKxiG5QtW4XvTJmj/KPirooUKDNr5BM6x
IZgfCiwSsGuBTLUYprN+P2zd8aVZVHYIDqbFHQ962QqvUy6on5jsB9OiLKHO
+4Ng4+nfZDXdCmq3zcwy3w+A+NNhh6V/6XDuChTyYyu86yzUOX+CBmb6Awdo
lwehNfnZ359bGyA9pGJxtCIdHi072dCgNwgBWQrLfB82wNPB0deC7Otz75qm
Nif2cWubzXLCTxrgjPy6KJSmQ2XhAdk3JoPwi8esPlKhARQzmGCrQIfHpt6v
MpwGQb/M5cqQWz0cdZY2eq5Jh0+McKnkJ4PQF1n6U7O6FsTrs0TkLtKhxS1M
eEHSIGhlFgkeba0G9RkB7+rbdOix3HfuUcMg/Jh0X9TAWwFlfUHXzcPpoGNj
4HB8chBSJve8kz1dAspytinS7OeAYHPlYUGhIRgzo5Wl8ORDSf53EbF+9t9f
sS69QnEIclMTH5c2xcH2k5vXuUzRgXuDd9ItlSFISM369S/8Ba6r2pJTwzEI
AszXLNeNQ3Btl5TrrWV5+GvH8W0mNDpUbP/4ffjTIGRxvFzCsaIaFXbxx2ix
71OXH8tyA2Pp4KjXXdYn0Yaxpjwzgl408Hx4o/A4sx8Syi6rqAT1o7ivZEAP
kwqDUuWn3r5ohbeJV3Zk/B1B7V8ngzpMWuDcU9YRqeQi9OkWz/xxexwpT8/e
rw9F3Hr51JFXfBR8vbeg+YT4EL7fM7e6xbwXBWoTLM5E0HBIf3el8c0elFty
9UvzwwHMv//lr+7JQYx9ce934WgDXpKtvywjSme/TP7NDfw9iN4nReeqnpSg
y4ylzCOk4zaZN5i6cwgzbAYO39yWhI7ZNda3/9Jx5b7U/RdUhnDeO0LEqy0A
rm/jXpDMMYj328w3v5QawppAHnees5/AuIxV0zFOx/HfLg+u8A7hsR5XfQ//
IojpazM61UhHASMD7ru0Qbyz1S1wRU0pNHzVVL6QQkeZDEN+xudBrNmtkbWT
vwq6y8wyivzoKOLYs0v2zSDOrR9veGv1Db7wP1zQbkVHndrIrsp7g3hBR854
4F8dSK+JtuU6TUce5YsCIdcG8dnUXguugXrYmnBfe3YvHcXSs/16DAZRqVHH
adKqARIbF+6ckaOj3ZvhMevzg+iHXs8WBTfAnZV5r8qk6Pjk8FOnD4aDGLVj
tuqMWQM8nmDey9tGR75K96C7VoOorPJRqbeuHsaNLFUr99Gx+0LRkdwaBvZk
zzR9TmgB1TmDFd18fTDuuiC71YCJhcxlh40Tm8BP93VukkcvPBFOsMiZYOJF
zTUBu1c1QPCHdyPvFvbCzW3DB04/GMEsl68cmp7VkBIhKoIxPaBHy03p4xzF
O+rh6iYSJdBaYsHp7tADO1gj1y+fHUXR5iVOLmFpcDd0z+Vxpx54dcBmbrHu
KH4qvyN9tjwc6S2Bh09m9oAlxbB6RcsI/rT+0lRz7Que4T/guGl3L/t3cGRN
xXsmnvXv0NW0acCuMYFsU3ovPF94//uFoGF0NNzuLMbXiQU+bnc5ovtg4SYe
7+/v6AgRcp1d26mYcs9jNbcEBazXJNhVfKcixWv3NuVmGhpWzlquMqHAfv7K
yrDQLixfvd5e6tMQPny0PzjBjQIb41Z06XM2IZ+7s4FTLgOPjVpeyrpLgWTH
9kvl60qxR1I0xuAHE/9tXGjNZ08Bw+cfb9u6R2HMjwPNdndG8JNEgZ+2HgVM
Yr8nZMlmQh5t94445xE853FZ/rMKBXL9HJKWO1SC7ct5ejyDiTLVjS0cQhSg
HNi4Zc/PJpCpPpDCN8DAQ1Yhx1rofeD07rvyLYEuaKh51bZBfxgvcTEM+D37
gDL7lusiLxU0VNdIXtwziLts5F12zfTCO53BCgUrGqR3uDNbHAeQ7ha2XOdw
L6CpM2XcawjKdB6fdZruY78frQ6NONcDwodbtPm2MKGs/aqYJqUN46IN+ipk
uiHsARef8/JRiDG/qjaxqBarnubOHujsBME/t8ozt7Ng9SHdbpd9OejMf0Rj
8kkHLBJuf+D1hAVhvi7XTt5+D9eF/uxpu94OLUvKVgrpskDJor9mZEcJrF//
YFVJfhtI34UGqYJREIQaXn+xOrBX8Ag3vdkGC6y3JHX8HoFjPwOF6LuaoeHE
v5nNSW2wRokV9mLrCHhH+F0UCW+DpVucQq6dbIdvz3SGxczYXFslNjA01gHe
rg9PtGp2wE2/Adq/AgakKbbclz/dBWrPBvqmXDrh7qv7v932MaA7fd0Xod4u
MDip7K5Q0wV/ZCJFggeGYfXyL4qvM7tA6Cjnlg3SPTAu3Ouxn48Jib2HFddy
N8N9zHkppNcHpVIJP2QnGXA1Pj72xPNm2HV0UdyEeh+k2xme0frBAMmr14+0
pTWDwg6xY0v39sHwA7su6xkGHN/ryM1v0wzid+S6DhzqY//eV3h0r2aCgcre
OzewCap/rOmJN+2Dm4rLtLXY7xl8KibYEdcIPReXR6Q96wNDi7dH0q2YsLVH
PGeNRAMU3ZdQ/V3ZB09ceaW1o5iwPNfZ5ppeLfT/Th3gW0yBO5sqslUo7Peb
s3MNwhcr4YVPvXK6LAW+He0Io20YgVVFMbyySiUgLHBGOeQ0BZJWz++SPDUC
ocWHXiScywbWj9OVLbYUSOEL37DVagScd77cXiIdCBkfu42S7lEgOkih6tCF
EfhuLdzra5yOsnsveflcpwC9/82+IBYTZj4qfqkRqcA6p3MueYoUuPp6+/j1
bAY817VVrlZsxY8yoZEHf/TCwePTHeFsLhvV5XtpmvTjrYhv3sDVBU2h8pvC
0jrh8XY1778/R/Ce9rK66OX1oPRiT+aFtBI823fdpJfNo4VtNpufpWfjt5+8
KzW4B3BigmbzdukQ9mDxoYP9rRjtGuSUc2cYHb7G7Kqs7kY/1+hxH9cevF6/
SuKXKxOFNzys1MysxycltzUYHX0oJT0vcV5xBBkXTn84IF6EBvsM92ZcoiBX
0TUbY8sRVDmQqxXlHIJjsyLWu+9RUHUTrXGhyQjK3zCjKGxIgh+LdVSDb1Kw
p6Sks3P3CB5JnlvYewBBMUpCqsGYgrszwiQ/zDFxZ/wRAx7HMgh67lsyr0ZB
+tc7+o+KmchlJmXwfKYaVr6zDVURpOBLr5+/d/owceUKjQ0We+ohocLxHv9I
H/bKRXzX1GaiwrUjWtv/NEDfxz8TBgl9SGH8+rNUgomBa+NleTSawGt00tTQ
tQ9tb0tvH2W/58kt459LFGsGyocDfTTtPvxnXd1x/zcDI6JmFErCmqG9eNun
MdU+NLFvMmn8wcDzuee5Nyc3wyFK4rtPe/twUmxMWneegVEK+5d26DUD3bnu
UfGRPoyRS7TtFGKiyL6ozi1BTdCzJyybYtmHutYGCyRER5Hj+U0uZLWByZi6
3KJfjeDOde9tUcQovm731X5f1QKe++zzIx83wnURJZq/LAvdlj6r0udpgp0r
N5jEyzbC1w2HNnjnsXAXfdmGp8vroHDbXf5JSgMc3uW4YLn6GL5++PpqklYZ
5I495Av/1ABNwxGr5t+O4eybLbueNmaB/f75P39TGsDY0VxnWd4Y5gyo3Bfj
eoqR9zY9zexogMbVKT5fLrHPz9P94+VWjJ/rpV6HKDTC06CwykWnWChz7mNS
S0wDOtTLZmemNcJzjy/rtp0dwZMHBwvj5bpwdpNDqR/733vN7+w5E91hbJne
4MZ5pB83DbJkllc2gUfwybKNdjTUiD64Wugm+zko9030I7lmKE+XyI7v7EOW
yJ3+hnoG3j5947u2aTPs47BfUWjYiq7ch2ecdoxi+I+ujL32zdC8gSuysrsS
FdeFbT8XxcKHO78m/zFuBiiX2R84kIwiNzbsO3F8DAfcuQWD9jfDL4XT57Pk
MuDhDv6f94+OoQ3lZYb4+mZo+ZC9s0a5Cjg7JU3i01l4xGPSY9dwE1x78Zkx
o9gCX0TE/ez9RlFdu67nQ1ITtLU7a3VJ9YDrobSGS5Xs5wjd8cehl5uAMzn9
vOntfqCdHLP01BvG2v3TvGpTjbAQAobnFQbh4VmV2Cvs57x6j51R720aIUf/
lWSVHwO2H9ukJilCxQuiYg8WpDUAq/lrxsgBNne263rdGGpHpYfHYwoq66E8
erZEdeMYfKA7VuYkf8OzC2Qk8gLqQHGalTHKMw5H6+SXFfpkoO9yg7W0d9/g
xb/yoEaJcbj68EARvSMV/lLLIgWW1MBhgb1cSRljkBFXuURvvByqrzSqSyyo
hrtNf7Svf2dBgLS9vYRKI/xYmu5+KqoKfsnd8t2/hgWnftVoDixtAwHqgv3n
Rqsg3Fuy6K/GKDw4+6j3W1gnhL800Bmpqob5l8Aj+nwEspZfhe8resA8KDCj
Ycs3oO6fKTTlGYELh6kBukG9YKFS3F/cVgstV/NtLNOY4KmWxfdCsw/eX34f
V21aD2Urx3VMnjLhUupF22CFPrBWt2w1MW+ACJvoVPG7o3BFsK/BYqwFOE8d
5U5TaAKf2P3Do8ajkJax7NrHoFZIXRL9lEOkCVbJ7zK7f34UdPq6/EUrW0H0
p0zdh/VNQN0ab5FlMgqn/n7dCs9bQYCnWe8h+/y4gluvstmfn1wnGLB6pAX6
Jn24Vis2wbRV3sMFiaNQYTjx066NzS9brw2HdZqAe3/LwFnGKPs977byl9NN
YPrWe3eIWxNsnznl5KDAgrJroZurjzVA7QgnrZv9vLlHVUa43JMFomonMt1u
fIO/6/jPcgw0QWzwq5S6Jha4TrhNw7pyQF6+j2GCzfCuwNKCumEM5G09XBfd
/wzTbZ0ecsea4cnxh81Vx8eguK76U6/OB7D3EGXesGqGaxrRW8WPjoHzxOq7
XQvj8Sq193nitWaobr2YO9fLYj9PpGvULi9DPs7af+Kbm0H9S+nHZ/6j4Oq+
1y7oYQvapb6pt1VvAoXam4ZZI8OQNW25/9O+fnxgr2UrUV0PjUodL8ee90Dt
tpSfCRMjyL0mRejxaAl8kntrl15Ris6HX2nUs3mkrNpBW3wxCccOqUzkraNj
a5Rac9bsIC5zWtvsbVuDn5XWJ3zayeaIZU6qgk43Bn6ILdU724hZu6MCDl5m
YXiqjaDupzq8nJthZ13ThCc6/xorS4whX2t6/pBnPg6VT77cot2M1L2rlsqd
HUNPyUWr+aeO44v1jznt7ZvR9znX/i17xjBfLT+qTT8TfAJYasqXmvHT7gib
z/9YmPpzSaCrcQnc2bHSW1axGWVeDM9nJ7DQoWhGVMOxCphlk5Kv5ppwQnFd
yjIDFo7H38lUWVMPXxt/+z4rb8LNzl7GsfwsfOD7azjpUiO8pIauuBrYhNW3
VztMVozidvfxdy/ZfGHwRnpVmjfhjukW3qaAUdRf8nT9OfsWsH3Lr3XyQBMe
fHfp2XebUXwKko81jreCw5lnl8ok2c/ffTPROy6MotKqbVa781qhklb2ykWo
Cb1ipOzy9Udx2fAS2+KCVvhGNY2RZB/v7Te3Xs3+HKvyhkbpM61wsGBOdyf7
c9ZK/r3PGTiKZdJTMgfsWsA7ICDUhv29D38fkNI4xEKOvTeWWAt0gMMpzzs+
rrmwfpG3nz6bLy+2jlpt7WoF+WVHs9w7c8BiOHqFGOFL4sI3/VzN4F6/8c33
EzlQkr0pPqtiDBteXT/eYFMPcZ/PTHV2ZwNXgKN/wYlxdGrx2MpFKYdTW/Z9
9g7JBvNy6YQdn8ax1qKhYMovF8LfDx40epoNVZHfeF26x7H0pHp3xYWbODy3
ysOxNBu0bduWHAscR7Ujm7NUKEXIn/2rbK1mDvxYf0qJGTKGX1bKlF1OaMCi
mAUhp6dzoMYtauPy5FG8vrE2uD66Cy9sVzq9pjEXLj8sMR9PYWCYj9ENh6p+
7OT/YhD9Ng/qzk7f681gv3c20a4nHhzCoeCAf3Eq+XDDMua6zmIqOmpzq9j2
MVF5Q6KnQWA++PX0WFUItaPPhnNGNAcWXh096JKUlA//nD+/7dKvwcrC9bFB
XOMYnrVcgxaWD6WsK6mNV9IxQLrD7UH+OHJ5vZRVd8gHNX9jGzW5dFDNPyVX
VzCOy6ddm6qV8iE4aqFA+ocqOP5kw4q/wuMY0PXAet94HhRxVOcxeltg7/b5
1zEDLLRfxzy2OCQP2meUGX0avWDk9SvxM/t91F8251fl1jzwhc6NWSoDEPvH
neurCQMNRjNPvnyUC57+EdGPhIdg6trRZY8ZdOzU28CaSM8B7gjbP1ueM0H5
rIOWaigV923jEm0PzgaBkuo+9aMsMIlkP0fId+BAU4dKoUoW/Lo8/fbQ8nFQ
kU9uWMf5jf3csUx4ouATDOuEtoq3j0NR3B6Vn3tS8f7adwq8ZzIg/eDB6x61
47C+IPfZOsdMuHerekuLVDrcu2Nw7OvecejZXnSVP7QKqgOFZsxs0sDDI3dL
rskYCN1svFj/sQkG5Vt7mqXT4Gr/45eut1gg4HSyeu5RO9TzubXfNEoDrYmB
3wIfR8Hg+eP9f7Z0Q+MbrfbZmTS4XiQo8Hl2BC5OfGjv/tALTiGnIyZ/pMMm
5Z5F331HwHYNb7+JMAVuj6jZVst+AvPan60ax0bATdbSY5T93puvrckKf5EJ
jgUfyysOjcCHey+2nGYfLzT+nLhsaTaEHt253jaTBTTuJ3WrBlph6DuPxKaO
XFhUP6beFMCCzqU9pTkv2yDB+oYuV34uTOe120f6sOD10cOzmk1toFG0Tdci
NRdszP2bPj5ngZhd6LOcyDZoNivZKJqbC38UHK9wpbLAV+VgtP18K7xV3el7
rTkXOnNKzYQGWGAfv8pBhdUCj7aZ07o48kBM5G6Oj+QYeAuGLdC50gxtZq4C
V1TzYPn2jqm2W2Nga6x9Zd6gEbZeWTu8wCsPKrYspUm3jEFRRN3GCO86COek
j7o05UFMLiQ5KozDNiU7h5GllRBxbr1/hHg+nPPn5FXxHQfPyvNrxVcWw4IA
NUczu3zQWevxd2nJOCx9b5SyvSURVO+ZyTq+zwc7afoz+8pxMBgDLPaKxn7h
l45zH/Ph2rqxtKjL42DCtWMkbf4r0ovFHqWczIfKA3mzedxjcPrD0RSRHS3Y
pH9/THhTHkysNn8VuZMJ5w5xajRJ9ePxFv1f6lVZECkyrqG2pA/KvUSFpsZG
sLXX6100ZwKUHloy291ZhupNTxZXsnlU1nDQwb8/EPdJ2p7nlB7EuoGB516/
B/HwjwNP6rQycGmnqKRP8CiuvHrZ/tKqbnzBF+Du3peDDS5TjIuUMTx0f4xH
qrEWD+TsM1LqycMeDue+vthxVE1/quO5LBfvnaj4FeeXj7Q4p6y7deMY0fXp
oJyFDzx/LCKvmZSP+t80bsXEjeOeIL5VvHU5wLBdMnDuST5Gb5J5UGg0jj4m
i04YHyoF9Vu9rdLH87E5ZPmjjdzjWL724tjojRqIfoEFp2fyUGxqoqH4wxjy
xvo1929uAE3mq/C1CXn4NsAmbvfpMVyrmah616EJZmsX5owY5WF5fnj6Oa4x
FF3OjZv2tECeT/S6oY15eD0qwn1POQuD68815ni1gklg9bvQ4VzkPPjpWFE4
C8O+y775d6kNQuzTfnt9zUVLK94tQw9ZqF+TLdFa3gYNT7TMLqfnYsCxGaGR
RyyUfGpXlPelDao9j3prZuTicnvVKP13LGz6eGbt/eNtYO5zoSamPBfXL9b4
+72Whfular2UDFvBMNtnRns8F4PGu7cSHn3efY2H8Oij2K8Tvq65WNdBfUR4
VJL0xpLwaCKVcfh+Zw4K7j+/jPDoULb+a8IjHvdJyx8ncrDqkEEs4RH3yfPH
CI96xp+EdHVn44HVik8Ij85qy28hPOJX3+rjE5KNcvRvsYRH1+o0cwmPVthP
rTJ+mo1HuRbxEB49zX/zk/Aol/ejoFNpNur1BvMQHjXEC//HI+OtLz3XaeZg
FEeUAuGRwFK3UsIj+ephhzPTOfjv9z8hwqMdHYyXhEfLnKKb2TzC5EebzAiP
TveIXCc8+nD6zO6Yt3l4VzriDuFR5HUVZ8KjiAd83+JV8nFX8W8nwqOPBkf2
EB6h4a2dhoH5mHVl8zXCo0VU04uER1e8+0WT2debVaFoKOGR87O9MYRHG78F
S9LD8vHb6Md4wiMLj+BbhEfZiwpa2TzC914+DoRH6m9BmvDotjN/Zo1SPlb0
7v+PR0v/Di4lPFpyI26p6ngeypap/Mcj3obdIYRHhz7cEeIJycOjr+hDhEfr
5tTjCY9me4fKqrbm4fNj9A2ERzcCN3ASHmV/+bMq+FEuftIMjiI8kq1+wU94
lGeT/OR7eg4eDO7/RXjkuejDIcKjf/R0GptHSIMjvYRH6/OkBQiPGPzrhtg8
wtj2x+GER6L0B7WER6Y7inPYPMJJbaUWwqOfV6/vJjxyf+tXweYRNtybcSI8
Esq684Lw6JWBWhqbR7jx5ZGjhEdj4+X/8cgkKsrlik0aamGcGOERv9uL/3gk
YFpg0CKdhoIvPYIIjx79/FJFeMTbqXHullEaZm8c/UV4lBLVAYRHWusPnpib
YZ/vSF1OeGQY97yN8KjArHz73x/pGOuTsZDw6NJXeyrhkdQXh+9sHqFu7s0W
wqN9ssH3CY9yb3o8ffsiExl3p0sJj4omg8UIj+oklfWXL81GDgWutYRH3FOc
//HIcAdvLZtH2O+bqUp4VOgp/R+PxtV0FnDn52L0ZJMt4RFz3GOa8Mgwq3/B
1dRc3MVKbSA82nan5gnhkcHOTXVsHuGaQkdTwiMlZ6f3hEeLeVbtsmzOxQf5
Ny4THk18VLInPGp3U3jdzZGHg8NnsgiPZj5PchIe8W3em8vmEXpNlf8lPPrz
O8SU8OhhjWIglxf7d2lunkp49PpftCDhkemZxADXpjzUP8+XQHhk2b7ZivDo
4XZvrUjxfNyy03cR4ZG2z9v/eLRxaaPEFbt8tJsV/0N45OpMiSY8qqj/1MXm
ER5ou/aU8GjcM7yC8KjBKkVi/mM+/jslmEJ4FIdnfhAe+Rm7aqaezMfXlr7T
hEf2A7X/8Shh+a1HmzblYUqu3kvCI44Ckf94pErb5w1VWfhG0Xc/4dEvXrH/
eJRWO3omhjMBH6ptnSY84qX8n0deO3Wm2TyCVJ9FuoRHQk7+LwiPkhasW1Kv
lQFBx8rFCY/euFT/x6Of7ybE7/flwFk1lyHCowZj6yWER3+VvFbs7smDWY2p
bsKjsicv/+ORbO/z+Hi/fKClFGUQHh0t5RuQZfNo8cPwP2weQc9UvgvhkcaO
KX7Co021F9+ff5IP6i3iHoRHbwLuHSM80u087CBzPB+kBaJ8CI8ig6tGCI8a
vvTfOjOTB27NX+oIj+ZvVTQSHq3ftPbMuoQ8uCB/8CPh0cNPrSqER0lTJjaj
RnmwVOZlKuHRXpE9hYRH+R1BX9k8ArPBlfcIj64WTNQTHil075B8PZwLPW69
RwiPVma2hBIeDawMfuv9NRdilSQ3Ex7VXzQXJzyKqVReYZqeC+0Gg+sJj2Y/
LPxMeGSUYaBxMCMXfvwMfUd4RF1puprwaPUCX5MP5bmgG5z3m/AoIXDYk/Do
HSOnXmc8F/qny6e3io5i/zbq7GdWG8h/PGOw6FcjLpC684rkdc3P/x4ned01
LTVW5ONG/Erb2kvyOrurSmUkrxuNCPCLl23EyS+vVpO8ruRL4UqS143wPFCd
pDRgucjemWVsfj2VErQkeV20hL9S+KcGtD4ez0/yurf2S2RIXjdwllPqX0oD
+i9wP0HyOjnLpHCS18k5pWdmdjQg7bXaPZLX1Xyf+k3yupV5oY0hCo14uU+7
mOR19dT5ZJLXJVr2MjLTGjHb6LMAyevc2y7nkbzOsvLxqJ9GE956UT1J8rpb
H8pcSV63NfTkheWVTfh8nX4Ryet4v80tJ3ndXt3KukdyzdgW1phJ8rrd/Ckd
JK879XiTqI5pMx6yW72Q5HXhZ2J+kbyua4sxcy/7fXzg27NAktcJau6QInmd
isey9j/GzcjaMi1I8rruOXNFktddNV96JGh/M1qXepqSvM57dJ5B8jpDvWsM
8fXNKH1xjRjJ66TOFZ8neV1dvhLuGm5C7cisIZLXZRrmPCB5XfnNZXwfk5qw
hrFXneR10aXC30he9+KycHro5SZ8zKWoS/K6zxl+V0he11GgJ6821YjhD7WH
SF73/nh7JMnrODeur35v04hpOTu2kLyuOfizMsnrds4bpC1Ia8DjtsHJJK+z
Xfn7LsnrrAPfNRRU1qP+jEwRyesSFvoXkLxu+Ey4TV5AHUbw/koheZ1zrfpU
gU8GTs4fvEh79w1jfvO+IHmdzrLnn0leJxX/dEBgSQ0W3L01n5gxBh/vLBMg
eV0Ph+NdiQXVqDqqfIrkdf2LdziQvK5al6P4VFQVBil7eJG8jkPOQ4PkdavX
fHE9N1qFlftTC0het9iNr5PkdQrd38NGqqqx+NopbpLXrbbzUCV5nUFk9VTD
lm8Yp5+aS/I6RbNb/iSvO1dze8eXtlqUD79+jeR1R03u8pC87u+vmOpq03pU
Ego7SfK6Em7VqySvK+EY47xs3oBX/5TGkbzuyNW7NSSve8ehpJim0ISCpgVU
ktc5Pg41JXkdr/fXPA6RJuxb+voiyeuOH1nziOR1FGeY/bC+CZfxypuQvO7A
oT8iJK8TOifh/ZB9fr7+j+ckr+sL3fSE5HWfF23cuVqxCbtowp4kr8tasWSM
5HX+C0SPHtZpwuje190krzvbpbiT5HVPumKuhrg1oYl4vxXJ66YGH20geV2R
57U1PYlNKO1auobkdQP6pXEkr4uYVXzAMdCEId9+fyR53f4r/hMkr3NCt7Yw
wWb84PPYiOR1UgvaLUled+VET5rcsWasCjhfQ/K6174rIkhep7BjywYXq2bk
0fi2keR1hdmCySSvS39x6WvitWb8+KErleR1pjM9miSvk9ozKbt1czNGZDlF
kLzOMHyHA8nrArc2zduqN+HnsPtnSV73K+iwBsnrrKrcgySq61H9dc1Tktf9
zI77L6/TGJs49ni0BK27nlwjeZ2p+sv/8jqPHcvleS4mQWfiISbJ69JSHvyX
1x23hXU+tjXAs7LjPcnryla6ZZC8rrVR74fe2Uao8zjxmOR1Hkp6m0het2r5
vrfWNU0w4FGuR/I6n6GKGpLXfZiTKN2i3QwrzFS4SV4XESZwbtXUcTTYw7fb
3r4ZNOvGlUle55a6JpDkdWIP/9gpX2oGT/+GKySvUxw96Evyukav3Vmyis3Q
vyF4kuR1J08/X0vyOr2/dRdfzTUBNTrrI8nrRp6uTiF53YX7v3OelTdB+F15
PZLXFaak9JO87ti5Ca2rgU2gU7TTkuR11kfC35C8bpXKwoxK8yaIiA/kInmd
0+fRlSSvm5h0cTp5oAnkRUIfkrzOYpvdA5LXOcr7Py2TbILMneHhJK/jpLwz
I3lda6FutYtQE7w/c+Qayesi++avkrzuztzBWkn28TS/HVdIXqd94E8Nyev4
lMN8drI/53u89G2S170vPbmV5HX3+I9V2LC/d/CsjDrxGd5zZdYSn6ElTUW5
m68PNTm2JBCfwd+kWpX4DDD9ejjJoxd1T50wJD7DprkJT+Iz1BgtE36/sBdL
292ViM9wuTSRoeFZDWFej3UwpgfDL8a/Jz5DcNbsTuIzBNdIKrk79GD+sa/X
iM/wSlvIjPgM2077PR936sG4uYM/ic/A61D/4j+foSrT4WRmD558FvSZ+Awf
15s1Ep/BwfRp5Kbdvfj0G/ISn0GUtVyb+AzM/G0DpvRerI/TpRGfIX2iw5r4
DJHf7RM5ovuwuLXhFvEZIjecryc+g/SVuW3cEhS0+Fl7lfgM5p/0xIjPsKrv
nPsqEwoG3VmYRXyGwXsVV4jP8M3aICnBjYJhBs+ric+Q9Sf3DPEZHiXwO2bd
ZX9OtuJF4jPYvaoIIT4DK8bMnc+egjOh3HQb9yh8zBAsJT6DyfxojLYeBfn1
I8OIzyDtp7+F+AxNf28f+qxCwZeSbz8Tn2HTbFQ78Rnu777O5BCi4Bm3gM3E
Zwj6tvA98Rmy6F4uLfQ+bOR6tpP4DAq8O6qJz+C9qcCH37MPhTRWzBvyUkHF
YU6I+AzXmvvf75rpRb3alSXEZzhwNohCfIaK+to9Ood78VmvVgfxGTjsDDWI
z8DdXfsl4lwPZqWwjhKfIX4J7xriM8iyFvFUynTjn04qF/EZfrq7SRKf4YVb
3GaNzk78aSmPxGeQP+5ZTHyGd4uLLCefdKD34Lwb8Rn03gm7E59hWiLMqO16
O1JzNfiIz8C8olBPfAbNkCnlkvw2zDl7p5L4DG6fchYRn0GC5/FX05ttKNXF
/YH4DN8XKgsSn4H7xlcRsaQ2XDBlF0R8BsM7yvrEZxBr3/z52sl2PG39mkJ8
htQdGr3EZ3Dnq3Rs1exAGam73cRn6J2wvkV8hm1fd/NMu3RifeDkKPEZ/hl7
5RKfYVvUtw8KNV3oGKW6lvgMsiftpInP0HW478QG6R588PiDC/EZ3AZ3yRKf
gfOadJGQXh+2/Hs3THyGrc0vIonP0Hk/q25CvQ/7z144THyG5tRrQHwGjmfm
jkv39qFFx6oG4jPMG22b4rNphjj/49wah/pQNO2SK/EZXjhIOROfoW211cIE
0z68JEg9THwG0y+HMonPUHGouyztWR9Sqi6rE5+BB3YmE5/h4jc/s9+VfXiq
R3wT8RkYNSL6xGeoMlL8y7eYgt9CdiUSn2FS/3Mx8Rkmk2NOpMtS8N6iO8+J
zzDW5fxPRqkESuyvHA85TcE1Fs+liM9g/lrfmfgMK99F9bbYUvB6Qehy4jMM
lZ6P/yIdCGUHp5yS7lFwWnSggPgMh8MbZ4nPENo6FupznYIe3gbbic9woMK1
mvgMets8/fIUKWjOOdpPfAa5lud7ic8wKt5QfvBHLx4+pVJHfAbfq0LexGfY
reIXC1xdGKctuIr4DJ+3TXsRn+HESq2B6OX1uN34dQLxGfYo3vnPZ9h54I/6
s/Rs+D65kZf4DOcPf/zPZxALNr9ysL8VTotsv0p8BvFNDcrEZ9BRd1jp60r2
HQ8KEp9h7Y2j34jPkBG81prR0Qdaux8KEZ/BjdsolfgM90acT2ZcosCpxQNG
xGdYKsD1gfgMyTddPHbfo0BY9+tS4jMElfi9Jz7DOmjWCb5JAdsXxXXEZzgZ
s3u45wCCxci5fQ3GFBDp5dlIfAZqTOER4jMofNRqn1ejwJ5+rZPEZzj7VeII
8RlqXy9IVhGkgKArjBKf4Tq3+CriM8T1Nr7nH+kDxWqNQeIzLBDboUZ8Bi+a
80bDhD7IN7IYJT7DQ9PjYsRnWHOy2s/QtQ92u67YSnwGDqHe38Rn+OxXvICu
3Qe6wuO1xGdQvVstRXyGwwMcfWOqfWB9s/Ec8RludRlOiSY3g1NId82nvX3g
c71bhPgMixf7cROfQeX499TiI30wHfXsMvEZQpufNhCfwaHah06x7IO57Gsj
xPdmLvokSnzvSU6BRUOr6XieVd5BfO9jzzVGie/du3f0ZzP7d1rlioQc8b09
KlLyiO/dtJMnZMMbGnZ+11Qivrfx0uJDxPduSHz9hteJhhkXkuatrg0j48Dv
LcT3/vHoM9dmIxo+KpcVIb73eF6TA/G9Hz+TlC6yoGHpnA+D+N5l+7v8ie/d
NX/h1k9/Gmqh1CPiey/68jWT+N7NKTF11U3s8z9t1iW+N8N8uIX43i4eEx+D
Zeh4crfZfJgjDW3x7q+Cn214+ertSFVPOqbaLjlLfO9RV/544nubR28f+ltB
x7rg+W/E93azDN9GfO9oWLoz6ycd+TZECRLfO4RDWJT43nR1i/JXnIMob2UV
QHzvz6Zul4nvXelVK2X0j44KIUxX4nu3sJ5TiO+t+0XyyeAAHSUPL+Za0nAb
H3F4WRDfO4iz8DwP+3s9NQ4s592cAwce+VCJ7/1zwotjcxwdBWPOThLf+8jB
r1uI7+0YrN6v60tHf+kqdeJ7/86/YE587+LNucLHTOgYuqDwCfG9/VfcXEx8
79rtXm+K5emYLJa0lfjeQWsmtxHfe+PA48gVEzQssOZ1Jr731Hfp1cT31jla
qDr2moYXl/r6E99716oJPuJ7a3jrfzomS8PLfo9iie99SqlNg/je0SGrPCMi
B9CsJMKd+N4DT48pE99b0auruGLBAKrtiJ22+cuAsWVHNxLfu0389pCPWT+e
LLZtJb73Wieer9qJt8CxTXHxYCcVM/eLVBDf+4lbhx3xvcMrD11+4U7F9WDe
QXzvo9PrVxDfW7FUZXWlMRUX7xkzIr53weS2POJ7+1yNrUm+R0WJO9J+xPfu
ljfNJr63SMJh3soWKn5PtnlLfG+8GJJNfO8lxsJzzvr9eGydTAXxvftiP2gQ
3/vXH6szJyb7cX5tOB/xvVd+OVBKfO9ECuVm5vsBnNF8Y0p879ji6mTiex+l
alqcP0FDiTMK24jvPZdiOEx872v6Q6LRinS89Ht1IfG9RW7Yzvg8bIBvtj8z
BNnX5/aa4i/E9/Yppq0nvrddpHYhStPxzXrptcT3vnLxWSHxvTcmcxrYKtCR
X8r8AfG9D6be0CG+t3w73eW5Jh1f+vOsIb53iKdlLfG99woXK8tdpOPj47K8
xPc+rvz4z5FW9u9Vunt49W060viNgPjelArHgXreCvicJehvHk5H+3hRQ+J7
7+e/fZ/43h3PPpRLF9NRucm9kfjeix9YPSK+976UZXvE+un4IKE0jPjeewc/
CRLfe4fRbnmXKTr67pkLJr53/r3e3KnwF6hk8LWuhmMQbZw8Wonv/cGxL5L4
3rWGQwdNaHQsGaN2Et87cX/ceuJ710ZN5Wux79N5f4No4nur3oitIr63W0rD
CiEvGhrG8scT3/vfjXv7iO8twLgb08Ok4pPUrcrE994n9eU/3zuNXy+hw6QF
f1Ra7yG+9/Dxrf/53pHTAlH1oQh1A0J7iO8d+y26hfjePyh2u1rMe+HhpX06
xPde+b2khvjef2qiWpsfDoCFSz2V+N7Uqwtnie+dFeJwU0aUDoHpX6OI752/
h768+kkJemp37n+EdPj1d2Es8b3x44Z44ns/vCLvdZt93Xg+2ClLfG8Bg3O6
D9oC4Ec7ZX0yB/vf/SDXUuJ7//XffZT43pJWKgMd43TIymm1I763873BvcT3
Pqkm4HKqkQ7yG1XH79AG8bqlsxPxvYNOvj99IYX9vTHak8OfB/HiCasA4ntT
Vp+uKfKjg/e+h6LE914txJ9MfG+ZklUb2q3oIHrtfiXxvZd4VqgT35svoP4B
12k6UO/pTr26NohJezK0ie/tU0e3nd1LB+Xady7E994kvMOY+N63Pygfn5Gj
w3ZTty7ie5vPU+8R3/udWFpKmRQdStMXXSK+dwDtQS7xvfP9VELzttFhmOf4
PeJ7r4ifFye+9+JICb3KfXT4bMq9j/Rhr8vuFCJ92Ckl7X65FgZmuBSeIn1Y
q3ctS0gftiMv8JhBAgOnr6/zJH3YtPdSyaQPO+q+RGjQl4FDwyP6pA+73nrV
ItKH3RncYnnBgYEdjyam7p4ewLrkJQ9IH1a4cCBQ1orBfm/6vJb0YdulWjlJ
H9asXTPq4i3294Ye8Cd92LjZTRwy6akosH9t/O23DDT2q2knfVjjc4L/9WF/
6Eds+trMwNC28jLSh5VeKbGZ9GE9g/P1OgWYaMr1KJ/0YZ1j9axIH/bB0UO5
1keY+OZJbhHpw/J+dvtA+rD/5orO69oy8YD0fU/Sh12fF5JA+rAK256kL7rD
xJkD5w1IH/ZOnfQ90oftPBPdu4z9nLTF/Wch6cOK/YrPJn1Ysc8n3EevMNEp
7dvfPUOxuLb1pQLpw55LipZSPsHEr/4rekkfloM/zpD0YTPuVYWd28nEJbIb
i0gfdrgyexPpw4q6ue/iWMv+++Wcv5I+rNL+UkHSh/3Xqd6S+Y+BN2Mib5I+
LEiPrSR92FuF075GnQx8cUnHl/RhXRZsOkv6sL/XextWfGJg2HvN/aQP61dW
Ik76sBJO8hd4vBkotorWQvqw0R//lZA+rCH3zJdFWgy8L2r5a7yKAvSiqZGG
ihZ80eu96O3kMO6Jf7ya9GFl3obfJn3YGb16n4DgYewP1JAifVi5id4s0ocV
ShlaPyc1jPlv+Q+SPmzW9aaSKKUcNJKUG0zJG8LI7ZbbSR+2IDX5EunDbl/X
2PmKzWHPhksnSR/2ui+jiPRhfxy6bDUuMoQbXqk+JX3YZavfdZI+rN2VleIe
K4awpr5CjvRhn76XrSJ92Ht1y4cPse9/6irXZaQPG2lqmUH6sFfPlzyJuTOE
S8M0FUgfNmrzvZOkD2twsmX+2NAQWvy+3kT6sEdUZ8dJH/b20cOG0WbD+E9c
XJD0YX//fBZM+rA7J/aExNOG8XzPI3fSh9W9KLSd9GHdu60/WxkzcN2Wpu2k
Dzu774ch6cPqNkWdLxhkoB/rQT3pw9aLCUeTPuz+d0805dnvtfjXejPpw2pP
hO8ifdglbyLuvGCff5AnKJD0YQ/xJz8jfViOnlnKmwkG3m0OCiN92B11Z7VI
H3bXShozkYOJYeJma0kf1nS7rSvpw555Fm6Ru4aJbzXtr5I+7L+pYEHSh7WL
dmnX2s7EARTlJH3YX1e6jUkf9l7gw9pT7Ptid112N+nDPvb7tpb0Ydu3yv6b
N2Fi61DME9KHrV1vJ/xfH/Zc+HPj60xMOFfQQfqwrm4yb9b/1cGDm57b2bDv
F1kJUwvShz00+8ac9GF5XTXT1O2ZmLH6cgfpw65cIbyV9GGFIvP47FWYyGvp
d470YZVij18mfdjp7167vbMYqJuQr0z6sCc71yaRPuythZdNEtyH0Wy/xhHS
hxXRs2kmfdjHmgLLtazoOGPffYz0YQWm0v/rw8Y8Shg+GNeBcnuPNZM+7CGD
//dhZZqGaG4LSuBkRpId6cN6eG3uJn3YXaauH20V+iEryWnkzfs+jPt9U4b0
YYvKn4dr6Q7Bs82qCaQPu0HyrTDpw3LZjry6o8qAkE1C8woxVAzrnREhfdjs
S5nJRouY0GrNdZn0YeFHnDTpw745MPXOy5AJHx/Rqkgfdt14wzjpwwrHbdxr
cIsJhdGvgkgfdtfBsPWkD2t6Yh2eus2EB/P3pykMKt7ddZLlPZsGghQ1qXhr
JrSsd9pM+rBZW0rLSR9W0mrFYt5zTCg+bcFJ+rAHT/suJn3YQ4PusZr7mODx
euwD6cM++BRDJX3YjhgZiaTNTCirdNhL+rDqalumfS+Uw7tv+3RjlzDB+emT
p6QPWxml/q9vG/s6vDNk/IP9np+0Q7qS9GFz0kabSB+W6XdwXRWTAfGHuO+S
Puwps6zdpA+7ceu6GG4aA244Nq4kfdiLXWePkj7shkLdXevYx5U7ElpIH7Yi
U/II6cMquUhrrx9hQKWeSQHZC6pVHQ0ne0EmwVvM26xYaLFGYSHZC8pP17tB
9oLiY6aupBiyUHBpByfZC7qrSckle0H78puYTWfYx52P1OpadCDnY6vZrc6p
0K+8L7T8BAvr87XKyF5Q0AHFRPWBEChdrfk1Upv9+RNrT5O9oCPTxRZkL4gW
cG3FZhMWnngXmEv2gp42VNiSvaAdR3lDPrmw0L53fY87rRWDTA0LyV7Qmoa3
H/88ZyFzw3Ay2Qua/zfqTPaCkqUSzO7HslDsUtCS//aC/PtVyV6QqGyBv1Q2
C219bcqHKqrx03WJIrIX5HNAYkNQLgt33endTfaCVgx/HapMbsGXuyO+66ay
UCXptp/c7hz0dU2pIHtBFfsYqUNvWbiwQHuMN/Adqs1ySJK9IDvBE8yXj1g4
IbzO8IbzK/g6i1lkLyhobkw9z5mFaUp218he0CmsOkr2gkyfGW5cZszC28e5
xMlekH5OSBDZC4rWeitVfpyFvQ5bJ8heUN7cbmGyFzR1J2/j4r0sjD9J7yZ7
QeLM6n483Ypc/utWH93K/newG/tK9oISzv8QI3tBz/TONaYtY+FrsfeLyF4Q
R+2kGdkLslypvOrMz1E8pJdbQ/aC7JYKipO9oGYHZoBdwygKSjL/OS3qAGOt
RHmyFzS6r31qU+woHrnLHUH2gq5n2ewhe0HJ3g7vlt8cxVxKeTjZC+K9T42n
MPPxqIvYIreDo9hw5vQ3shd0e2Zlv+6mBFT//WZr6KpRvOVsEEn2gg7enebf
/NEIYvo+J9awRnCN929Lshe0yJRVSfaCnEvhtU7XCL5/rRtG9oJ8XrgZkb0g
FwnuJ5epI5i9X/Um2QsKKNXiJXtBJZW+T85yjKJQaOdGshe0OWrbGrIX9H17
vnOj4ij7/+/UPbIXdP8o8x7ZC7LVowpHXx9Fo3OGHGQvaBfLmJfsBWUMcR+g
541iRU/BY7IXdHqP52ayFxShvf1Fyvwo7uFwfk32gmaYdsZkL2ifuJ9bvRoL
n5VfDCZ7QZa+wo/JXlCm8HHTTEcWdv118yV7QUKiHr5kL2jlFoOn39nXQ3p6
9AmyF3R57Tcke0G/3gf3PbnFPv/hm0NkL2h1sYs82Qvy8DmqJOnJvo+Wfb5B
9oISQ/1tyF7QiP41G7GnLNy+MkGB7AWJLEnXJntBn63eaYeGsjDfjFJG9oJ6
jj1UI3tB59USv576wL7eNGI6b8W1gQ+HsZ/lxVjYM3Kkxz+NhV6VuXvIXpCo
gOcFofMBwH9i6fSvHBYq7nA+RvaCEluUu7zkAzCmPXb9FPu4oI60ENkLaq/8
xb9UMQVLrXcO8ySyUJfHTZPsBf3jSpV5v6cQZ4P1pu0fsnCanp1C9oJKz+94
S/aC9BS86Eb7WKjHved3bHUrrPV2WEn2gh7OXlFSDBvFYhXOGLIXxFhZbkP2
ggKFh9bfUB3Bdj1TTrIXNDF9WYnsBT2zfU43aRvCSo9t+WQvyL2X+t9ekKv7
iibdrG5cnK9vTfaCgsf+vxc03zfvFXu2FPLOxbeSvSDtihf/7QUNDqmoV5yg
AV4fe032gsTUFvwle0HeUzx/274z4O8eSwGyFyQxcfMs2Qv6ZZBsGbZ8FJxm
P5qTvaALS1IOkb2gZd4nn/34Nwq/nPdeJXtBsgprrcheUJBa+Pn+ayzwv5z5
szW0DVmbMzrJXtCvVZ9DxsNZwBD6Kkz2gs6uyV2WHxqFNK8QCP3EgnYZLk+y
F1QwbnM+2PMkmE8W+8vlsWClXlgJ2Qvaa+G4jewF+fi59o9msmCMcuG3Wkwb
bpjZ/SFgMhkOmQwmqiey4NuO6xfIXtDovpYsshd0oUdXnjuSBTm1ct91XrSh
tY3RKbIXZHemeBACWbCJWy2J7AWtFW0aOOtTCD70AWVzXxbkRy/kJXtBfFxV
hWQvKGvqiZfnXRY4hc8Kk72gfSUUYbIX1HZi1w89svN2kes12QuaFAu4RPaC
NqkUt5k5seCFTvRAsUsb6pl+syZ7QT95O1QYjiyYU7y3guypnsngXkH2VLPK
V2x55zWO0p2tNItjpajpymsja/MRppNW7ZP3Hkd/p2UGZE/1USi9TMsxDI7q
8C3+7jOOk2eerCB7qv5zVY+0qE7ws32Lz49H47j0q5MM2VPNpLy8+M/0JfKf
KfvT9nQcZZOycxT+lKCwZj239r441LW9CmkvxvHihqFBFb4v+OmI2Tmypyoh
o2f9N3Ac18gnCvIlfEb8LcZH9lTdF5pb0gPGcZnLXomRqmzk9I3PJHuqR+dc
jq9nf77qHEiIvU5BRQ/JsRbaV/R4vr/pmCfZIUy/XJjxBiN6lJ+QPdVTj58M
PXUexwYe2nf9A7dAfO+ZaLKn6leYdLnLdBxLtdZEhKyNhpv8f/vVCiqxNHpX
7GGdcRQc40kme6pGvb5byJ5qcbzVltOa47j5RuYdsqca7xqpQfZUZ38J/wrf
PY7C98SdyZ6qwc6G9IvbKtDFSuWPqNw40gyoFLKnKttZXzb7qQyfyjY8O7Vl
HJc8fruN7Kl+XyWVKE//ihZmXDuubRjHveVlPf8r6b7jqX7fP4BLJWWWQmak
MoryKQ3jJiTKKEIZyahUKNGSlF0hsndW2WmY6VyyR/Y69jg4nHOck0RW9Tv3
9/fv/Xif2/E+931f9/XP64nzVAvWDBNn6irBUZAqlsPHgIHPUt44T5VVbzkA
56maEQ773+FggKNeQDvOU+07NK564foX2H1C9JQ+KwOu1G78hPNUo3xjXpJ8
CuHTVmuevUt0mL3m8x7nqYa/UNEs18uH0y9PFljP0uE5WS8c56kGtL/Uog+/
gebMO/HL43S4Yzt5Huepam348UmA9hBSr3sVpPXTod+aUxrnqUoW1/WQ+8LR
5uH3bE976OB10f8EzlNtPdqmY9KdgfzIhgZJRDqc0tLNxHmq4eeJ93GeqrOL
Uo4yc34zsuI2nKc6SdWLxXmq6W4+ofvn6WBOCjfEeaolNyX0cJ7qTi5aVutm
BthPjgvhPFWeBdHNOE91ik9vexTzfV6J3z1derYBvY5aKsJ5qmmKpSLfVRmg
w/uzSyKqDgXKwxz4FiKeHXn6x0wZQNQye1ssXYsE3nF0DrZ+QqMxBlutbjIg
zUBo8vy2GtSiY5uA81QTM35qOT5mQPjS5mCcp2oZb7sH56mWXNhZWsbcF13e
CwE4T1XsNfVTe0oWqnbdIof3hVG3SSDOUy0sc5fAeap8QZQUXea6PcffYonz
VAPnf1327EhCbzeFP74ZyoBtvn0eOE/1W1vracXEMLTebJGFxFz/pzTGruM8
1ViX0M8F/TaIn1u7jTeCuY/sC2aSmc/nx7+s9GYPBT/7H14CzH2UZafYW/mh
GrFuPLhfMS0VuNozkkpDGLC/iaGF81Rdtj8+YLn3PYjue+MnzNzvm0mu/2qS
q9FFf7mHOE+VXB4Vcoa5X/pTXj7HeaqbvC6/x3mqbwPupZ41YUCo6YwpzlNt
eRpahfNUq6QsEn+LMWDrQMVmnKe6Z1DZEOepOlNP5HVV0EFI/1VJU1EVinW4
KovzVGtL6mQ28tJB8F9yFM5Tzf5SOIrzVENSVWNakmiQKzsQjvNU2fcI9+E8
Vfur7eXDO2eA6zNxgoXxCZn9OvC/PFWVkB0ZXxyG4ZiniUP/x0RIbfj/PFUu
S49PlPRatJJHJJsJlsOAsOMenKfKFvayhnJzEhnxcEXjPNURrYm9OE9VRFKv
KEmHinKf+da9ulAFdjUHUnCealmeezLBYxaxJXC9xHmqoakaYThPlcEI0xW8
T0ee0a12OE/VyvtTDM5TFR9TZW1cpCOZUwOBOE+VR9VrD85TpXALF2uqMpCG
RpEMzlMlj3TyhZl8gaFQlDfmwEBZvJQ417fVcL/5Px+cpzqdBdseejJQ586u
LThP1ZjPvh3nqYatK9xf+oKBtnhW/Qr8VA2ps0S/0RNx4PDURtI5jIHGB8X+
yRRWg1JGb4SxyyMIEJQUpIQz0EFL4Ss4T/VG+QIv7wVfxDG38t975rh55PIu
nKdaxkhd4/GMQf5+t8/XMOfJ7UrbivNUP45Zel46n4pKM26UkEMYaLTP7RnO
UzW7yWuM81QbVieSkl4ykP65aV6cp5quKLDw7k0OElJu5TcIZCD1fdkxL5l1
5x+bsj7OUy15HcyP/BiIqzUyPL0oBym7JS8ezYiAHdsNPp//yYAPq8ec7qnk
oc0GAZLtO5LhhneHYD+dAbsaQwWOLb9H7KNrS9ib+OPjR1GfYdYjl5V/2Jto
8Ei4h72JwJi6/nNjzPU5O/vNKOIz4uXmFRS9lQ/NZo73fvcwQKj7QkdrSTHq
HbDVw95E0jPPUftGBrTkbBnG3gRd6vEKt/lHsBy3CTpezgCBGbdHxX8JaMP9
7QHYm8gS2D0VkMeA9/bGPObnv6HOeL9Y7E3cC7gal5XMAM9hXXa3pUq0o6jf
CnsTxtcrHaeY+/HtKr9i04Vq5LVj+Fuhdy6wXySN7XjJgDbe2zewN6Hlpvqd
tv8tOM6cdnNm7se3HscSsDdReYBDqSglEcJVFc5EMesae9sFLexNNL/Q25Lp
+BLeF+b6jz5j1s2LOVtSDGtR/9G722cHHdCttMvhocznd/vHnMHeRI5cxfUw
hXB0xvxExmZm3X+T3tmBvQmi/Ko2b1YKUqfVoEnm32WMaY5hb6KutOnZWfcs
lDsyt30pgAExYXy52JsgbOo8m+hagNLzehwNXjDg676Xptib0LJUHcbehPDN
afc9zPMtv/XSU+xNJAg5BXCIFCPK9ueW48zz7V+xhBP2JlTndTKxNyFQeBR7
E3Dk+yqllKscNWs5mR3gLkfpDsrYm4BT4pfb+1KKEV2IEoi9ieE367A3Ad6l
acLYm9hh+DwLexPcOTX5MR+Y9VpgJcM6Phv5xLH2Y2+Ct9wPexPgM9Z7Uv9w
MlqVRZXYm3juZYi9CRj78FXHrckH5ZUFncDexNtPo9r5RAbE1peyP+n3hox6
EXfsTWzTP4a9CTA2J1lFV8QC//7jjtibkP7wvUmWynw/1QEVmzTSwHg+nQd7
E/+0/hVo/GCAcm/NI7Omd/D5JS0BexPiJ+wGl5jrXNDAWeVGcjbwej0a0It7
hY7y7F/6Mc+A5CPXdCwWcyAkOU80eVkenRolbK5ljj/2rr1ozpMLjSwnXz8o
egknyyMmGMx5Yh0Th/0Lc0CX64Ku05N4kLVHNzbPMe8npixxXh9zgGe/dxf2
JmzCZ4tfzjIgQ+441To/B9iLvkgu1mXDXeORgoZpBpAlhpJ2ZOVAFlk/A3sT
HtzHSz6MM+Da7d6Ih6k5sJrnoViy+AlU9I8d4Btgfs8giWWVuBzYCQanA9yK
gTOm/1pEOwMu/FiwGn6VA8aFPoJXj34BuakS2zc1DOBkG0gI8s6Bu/f+c8De
xNlH3mXaRQyQDltSmbudA6/PSFOwN3GpSmxmOYUB+lkV35vMc8A++b019iaM
Jh1OSzHrbP43Wp2EUg68eLcnD3sTq3WdDfLWDMgzUd7rto45/8wFCvYmEhz/
WLhLMO8Ddaom9jnZIO2kw4W9iSI1pRPqBDrkHWCLrODNBm1BcS7sTViwzwf/
4aDD+7uxWa+7MqFE1O8j9iayfAjsvsk0uHn43lPdrgwQ/hclhr2JY5fuxYzK
zMA1YtDHsag46Ply/H/ehLrl+qD4t8MgnXD+yO8hH3TK+/+9iUPZqWudU7VI
ccCrszo3FYkszv/PmxA48NBtfcAkIm3RMNtV8A79F/WtBXsTQStqylcNqIhz
99OSs2FZSO2h0zXsTUSqGc9ufTiLzB12XdW/kY30eE+dxN7EddF7vMfu0tHL
SO8dgoPZSKizrwp7EzOmd8ztmfVIfo2w86tYDvr6OScHexNpWh03j2oykM98
0ISEbg56Lm/tiL2Jpk8Pfu5wY6BjT17cH3PIQdlm7/5ib4Ivfmvy8UgGKo/f
P2b/KAdV7lPgu9FbAcXK2kojucz6xR10OON5Djp3qSkOexP3vogs3iUw0ESJ
2GfLyBw0ax4Tgb2JEBb1OwtNDORxj/o3MikHbZxU5O3NL4SGYnCN7mGgD/Os
4wsZOWii/vkK9ib+wgUQGGGgDYlGl8ZymN9frff8rg35sBZvnEuZZKBHKY9a
XxfkIDMrHykU/A6Oc1p8NKYy0L6QPaZ7P+cgndXY68GcKXCQ/QzPXQYDzfLH
PE1m1h2/A9c4luojIJPAN3v2JwMdYRXPxx5fTbT+SY3yEriikrjrQQEdDtZc
j8Men+E1312bX5bCg1hnee4YOmjPBv+HPT6TR80h2OPbfSTsoI8HHe66O+Ri
j++g25Xn2ONb0ApPLLSkg3+KVTj2+IQ6tQVms4sgruc+n7waHcIWyRLElS60
w4PBjz0+Ce3FnauSdBCvCjuMPb5HTtJvscdHlBWMOMpNh4l27kjs8Xk/ESBO
XE6CBs6sAV1WOujckRnHHp/vl2cHNaON0IEsL/XdLHT4LX4yGHt8JXY6Bdjj
08wf/zzNxrxv/z67x9eiGwnYz1Rjj49bvKZbazsd+szCD2GPTycOurDHt7bd
MUZ1Dx3OLH9Wxh6fxN6OvY48lajPIk1L6CgdRjb1HsAeXxH/+2vY4/PenRwy
r0OHTR4KtdjjE2PoFmGP7zC/zmynKR2adoYfwh7fnXLxi39Sv6M/ewwjg+3o
sIFlVQx7fHo9B66sqTA/d3LDuofOdNC4WO6OPb7EtPIP2ONL3xqmrfyADp4/
Dx7GHl/L4Gcv7PE5R9yvjX9Gh1FT/wbs8QVeedOCPb5PTv2vbV/S4as/f0zQ
Ui7yvtokfMS9A9VxeFgfjqJDVmGDqdzl12ixriAbe3w8u5Q+2qUy76v19FDH
4GhAzk8mscd3QPJdesl7Ohhm1Adijy89KrIUe3yfXv0o0/hKB4sXnLsiRr7A
0c7WNOzxifm9WjBpoEOy0c5juQZVcO2o5lfs8XlOs/6mttMhwS3OCXt82meu
dGGPryJqhfdyNx0iKg0Z2OM7qLDbGXt8PHc0ef/rpIPcdMwm1/pWUJReysce
H0sg64f73+mQOLTMOc3dDq26Ebuxx3dTtSTGsYoOH8TM5bHHJ+M9Z4g9vs4l
mmNoGR3Wa4hEY48v+aDMsU6h2/DFRyxj8hMd7r3d6o89vo0jCq3Y4/vjfIXl
JnP9P94dX4k9vnuyTgXY45ubu1evxBw/q+618ah+O4gwKluwx3d2XuZexUc6
EJSOemKPL/iVrzP2+IhsKo09Gczn66qeYo9P3qNxHHt8Fml/j3JG0qExTSoY
e3xzmzdqYo/vm3PDAy5fOmhmV3ClT7dBxQJVDXt8LoFXZeXv0mFwYOtT7PEN
iKXSscdHjDnR4GFLh+BZ3/fY43uZ18uz9XQdWHVqmZSfo4M70XwOe3w24zwy
fyvqQamKk2anTodD7mxm2OOrro4wwh6fo47qqscBOujX/lPFHl+UB80Ae3xK
50KXXQSY62TH2Dvs8XmtM3fHHt+2M0opGauz0N3t74A9vi++pebY43NQ1T2e
1j0Ll+W4QrHH13dOuAN7fA7Bc9HSibPg8eGdzIxaG0xKn67HHt9/vLUy/hqz
MPjCohp7fD/etbVij+9jkqZpVQIN3v/IMTlq2AK/9fV8scdXdDko9KUeFTjX
SHTs8T0WtjyOPT6ZxfRd89zTEBjkIL3TugJ4g9/9z+Pb+NNuS8HDIYg0cxDa
HpiJXgz9v8dHlJlP+sRfiw7yqa9XoNSi9NyN//P40jfy921MnUB8mxJeYo9v
Pva7B/b4ZjKeKNvxUlDwE01n7PF1711hOerSD2HX3I6lbKehlR+npJ0F21D7
3Ygs7PGZ1lgLnlijoeWcxSPY42t+qqGMPb4Iv6Odl9xnESnftRd7fBwzO1Kw
x5djF9Rxr3wW/RVVvoc9vrTaQRr2+P54m7MaUWaRyNSeW9jj2ybyuR17fDnE
MDmPLXQUkH2/G3t89OuSx7HH13SBdHxNko6a/7bZYI9v6szVVuzxVQ4w4pWO
0lHsiL0V9vhYYwMvYo/PqQWVKujS0a3Sxlzs8X2qHHuLPb6Yh1ZGUpfo6NTD
9Yexx7c9XE0Ze3yXXZ6qtt+gIydb+lfs8T0aMHHCHp9ALboV7UFHguqnDLHH
d2v5jCL2+E6+Eb4fFERHk79/7JRiaUf5ETmSrY4EuFUoKPg0kY5OttnrY49v
0UwkEXt8780NNqzkMfvH9vps7JU/7yzowF65Ep92ieAEFbKmd2/iujGMVANv
mmCv3NWq5duhD1Q4Kqfmg71yC5oQd/jWKmBx11X2eEQF3eouCeyVH9od+gN7
5Q+G9xu1aFGhisD6A3vlkL3nKPbKg5Zj44t2MNeVT0sH9sqljSwDsFe+OBK/
qe4nBbQvTY5gr5x8PHQf9srZ0oU9PUcpwGE7fRd75XnlPivYKw/kaOL7yxxP
Snb+h73yDd0mw9grb9EuqDgyT4HwXp1w7JW7+N1Wwl75HSM/tLyNCsk6zobY
K0+dWe3EXvkZu8e7tE9QwU09eSfH5iG075iMNK2pFWVG3LrBZ0eF9BTKbuyV
556iX8Ve+a+OANWRQCrsr1Zpxl75XxudIuyVb1WbCEVZVLgweq4Qe+X+mp+S
sFd+6iBJILOKCh/8f77BXrncTY5l7JWHcxU/qCZS4SuP0y/slZPfcBhirzzz
2W9x4gwVNP+7R8FeeeGtd/I/XIZQcmfPccMlKqz/fOc/7JWfuhW3HXvloYO/
ajw20sBFe6849sorZbRXsVf+6MJz1avbaDDQHhbq9DIU/u4/KIe98sgpHct4
cRpYPNH4gb3yTrF43nO0IfROvzuUvp8G+TLr4rBX/snsEhl75ddEQwzRcRq4
b2CoKSU2wvWejyHYKz8nPFZw6yQNJNbdmMBe+Y1AJzL2yvVfn3cv0maeB8J3
ZC+ibhjgGg/GXjnj+0pVgToNFK/Wd2GvvEKe3o298lfFdyxCFGlQRgz1xl65
3YGYI9grf+Y4x84pSoM9rs9ssVeu/Cv5FfbKrwjHn9XYQAPRxyJO2Cu/sSSo
g73yu9/L1+vOUiH2jnoC9sqf234XxV45PylK6vkgFVweRilir7zHa/Uf9spf
+V0OCOiigitX8I7vp0fghu73N9grP92m9zW3mznex3Ide+Uzl9+5YK+8+Hy0
Y9kwFXiTuJSwVx5THSGBvXKZ678J3sy/+6pabw175e9Nlf9gr/zutXODfPVU
EIimyGOv/MmmfeexV14tIbCql0mFU233n2OvPGlcqB575XH3O9aLvqSCcWOG
FfbKMxdRM/bKTz7RfyF3hwpbjZadsVfeUfY3CXvlF2a5d8VfogLHguVt7JXn
1X88j71yeYtH87t0qFA9vEfubP8gcFi5s/BebgfDXXvmNihRIfLe/mjslRfr
l1hgr1xQLvbF9r1UkGnPvYS98i+NFsnYK+e+fTfqMXOfJt28xvsqdRAa355Q
wF65p4M33F1HhXIjpIO9cg5DTw3slSsl93zwmqRAQaHnpgjTQfjtPtGAvfIz
e7Y9aCqlAGuQeiz2yul2dT7YK1+XKpawxYUCChaSB7BXvsCZ5Ym9cqGmYGUe
0gyk+TqfxV55ZVGLFvbK7+X9i+Itn4YJqH6CvfLnHOWi2CvnkdQ3lRqehO4z
lo3YKz+eEvY/r5ySf1Tx9Y9++MpWPYy98ot//t8rvzZrpJCuVo0ul7+7/D+v
PK1NAHvlhHElZ+/v4+hz8MZe7JWfrS4+ib3yccea3R/fkpG6leYS9srl+lTc
sFe+p22tisNpBgk9+lOMvXJpI1sr7JWH5srplB+mIHuuByTslT/pkHqFvXK+
2IaN1bEUtEl+bFPk7UHE3m/6Anvllvm09+c6KKi2eOkw9srTgmqLsVferPk4
mviLgv5xP8jDXvnV83fZglM7gM2J5/EuTiriezOBsFe++dLsc+yVHxNgdLKK
UVGt4k1H7JXL+O70xV75v2JLdhZ5KlrjrqJhr9yL57UU9srH5ar2m6lR0dP1
PInYKyc0cv3BXnnFTjVJXyMqyvRODcBeue3cswDslQ/Oa1186EBFNv2rJtgr
p2e1PsZeuYLz46JiTypizei+ir1ys7dbe7FXHm+gfdk4loracxwVsVeuoCl8
D3vls6av31CLqajmyucD2Cuv23DpK/bK8yIfLUQTqehRSJzOY6UJZPNwp0cG
53e4fuGVzWgTGaRNVbjcsydQPmVPrYxzI1SyfNTy8SNDwtM3aX/lJlEhe0ax
x3gdvI9WK7mtSgYff6E4gYJJZFXfqZqkUg2Fattcs1amYOrFzUgL6SkklRTW
4ZJJgMTfkoF3qqdAb+UZR7v3FMrc+zttXvgjiN3xTrZImYL6ts35odlT6KTC
uYm/jv7QLRfWvBA5BUSNRfmu51PIXDPt9uTGfKTb/mL5TtoUCB33ccjlmkKL
YqWmtdbfEOuYIWWydgo6R8Yq8mUnkc2M9kXNr01oITdLr2J5Cja0TbEUjJJQ
VInqfBp7J1I3H7YL+48MJR6pw7rK4+i0eSWX7UwvOohOrdy9RQaZbTRJO4NR
pDqw4ld1ZhB9+Pzj/GwS8/8NnHHOtxlEfwy8ejTYR9HZN8vGvvVkuKz/1mMz
8/Piv7NJQVFjyPfeSd7DM2TINaRlGBt1ooDzPGIJHePoZ/6v/66xTkOx3Afp
nTrN6GV/Or/jNxJSicmW38Y/DTs9U/a311ehS19+cOdfm0BrF9/3SeydBoXv
lsLBhz+jM97VX+PqJtCRJ57BBw5Pw6lnkgdT6SZInbZLNGxkAp0Uq7ymrTEN
5aXjhtwHPsOnOyyxTVkT6MFtBW2C/jSUcH48JvCuGoy2rWSuikwg92cObAvm
0xB5cZ+uhksr5CdsnJeRJ6HCU2m3Ja9MQ03E2WlroW7gfGgps6drDNU83ND7
yI45ft6lKO1sP3jdK+bT5xxFc7Fk6VHLabhkJ/7DdNsItFu4bmggDKBYsdoj
SmemocnP0EotegysUHR/f10P2rE0uTAmPw1PBr5WXzhOApFN1+qz7rejNCg7
7MsxDYb3s2QsHCagzGzvb1+lenSlMtrmBJm5DuknrR6JT4Lr3naXlbEv6MHH
1fO5zPfvtU/yT+W9Sdg3HisZsS0V/Tc2AesKyVBt/LisxWsSeJ4mHi3KS4LS
XJW3X/LJENtlK/rPcBJMicWXoncWwd0cD91s5vOcnqEJ3isTsG/W6bab3Dfo
zhediGfeoy+6aPHyvJoAo1N+z3T0a+FWc42c+hgZfvHIOGlzT0CMSvzqM/Y2
cH4afD0wgQwp+81CNCgkUDjuezT3TTskFLIyJFzJYEkc1VttJMFy0qDswckO
KEt2UjbSJwOXmE7f5g8k+Ph0S8y5sU647T9oWCNPhugM7hyPBBIcd04azE/u
gvD1CYde85OZdbD8JT2IBKX7PidWy3aD4nVLdc0NZDDNjbCMe0aCS0P8j5OC
u+HjcgyJtjgFBp5hr/QfkuB7lfyfxq5uYBtzubJvdgo4ElQnL7iSQG4uh/aN
pweaDm31nJ+YAudp/8RTN0ignTnILWzcAyGiSdfvDUzB97YL2fesSHBl6PoJ
8/IeCNsQ+dPm+xT0nm9z6tYmQWHnuRXqg16QG3ir8qpgCmr4C46sEyTB2r5X
fBe7iHBA59S/uEdTYH2xgmXvl3HYYe72dcp0AF6EGFvqck0BG53hmEsfg2qf
UvrQxlEw3HfQ4pXIJHjmmsmyfB+BwzIXU8V8J8AhLvZuePE4OOl+tCLnd4Jf
SV5LiDQNGOs+zmns7wULp/WDrJlf0Zgw299aZj1Kb3wtts79G4o8G2tQbz+A
2vJE77Ew9+HUnxkVjl2jKMfw2pYl2TG03XrdCdL0GGQ5vEuSZp6Pdyg0gV03
xtFT6YGZoXNDwC8sJjiVN4lKxFyfsvwcR3/96vstJvrA4tjLh0P6zPPuqHN5
tSIJDfr81lXmJMI+NXVV0bgpNCVvqRdoTEIePOMldzh74cvFr13vK6bQ1Xmz
iSp7Elp/ytA97WkPJPo6v17umkJsesPcqc4ktH1SV6BVvge6dc/ER49OMfuQ
Fx717iTEbtQumfOzG/7rZQSxzkyhPXs4imQ9Scjs5+f8hk/dMKwRNPlpbgoF
dAa0NPuTUCapPO+xTTc0ev+z4/wzhdbSP+4SjyChQyUFlb8pXVCv77KvjJOM
3OKIm4XektDLtuU/YTpdoEBdJzYpQUYne82OmHwloVW1uMY3NzuhgUh6oqpK
RoMyfgXLfSRkXe2XkHW2Axp+quz+bU1GC9FJgV9WSUjs3M1rDcz+XnUehAv9
ySinZFNUgcQEEttKXPdcsQUstffM2H8io0t1ydllkdPILfpw3o6aNigaXEq1
LhiHtRiDwrusM2gqRLto8F8LBJ+7eanQYRyGfkn/Puwxg1RZCgOQVRNw8l1x
yRceB/O7WX9vL8wgj29pKhxutVAdG/U3r28M+jK9f4MtBWWbbx3UF6qAOzmv
ZIfejkHxo53PdAooqCxkL3++QwH8/Jkzo/l8DDQDFRrnailoTUPEcfSGL9qT
FreQ4jsGLkaa7NrBFCS69YQh5+US9HEpbZdB7BhsaKhz9qDOoIVvQ7NvFevR
luH00uSqMXD/e/779fZpxLi7aczEvgMd7LovdndtDOanLuTMK5PRqf2WfG3p
RDTfk8z568Q43I6oj6UoTTL7nctU0YBh1GCq/4nz/jgI1afoeveNo5hDtqTQ
iTEkalxdop8zDr0kfl8xNIqa8pVUWCUn0NKbrYue3ePwnevupArLAKo5M/nf
+4VJROTqSpxbGIfcE2n87BbdaLvwjR4PWzIql7477cBNgvykvR3TqBV9fk+Z
UnNh/g7FFq5sEiQYPLdNrjy9ClFaXfrdJGdQ3taPld0KJPA4Rx+1sH+Pkl5x
C1/3mkG+etJbbVVIEHSupcij+w0cHC8/9cl3BiUY8gXF6pBA6JW+BTm8Auq+
FzMocjNo9sR4ceI5Enz91bGDqtoMrIoWpx/fmEbrTx/a8PoiCf5UptoKsXdD
Q1HLLqHDZKT0YCLPm3nufHt22ibn8gDcrL//gttrEjkJ705NuUSCxLcVt4mF
o7B/TZpjux4Jxen39wkYkIDj8vrz3czzrcadfWQ4ZRQd3mDq5KBEgtWGC8qi
NZOwXpLQ7HBqAJ2VLdau2E6CW5aPLr6KJMP9ndvMEb0LsRxSOeo7Ow5hn+Zj
Tw9Nw0+3z8pHZZrRJnXL1f1143CmQ+aFVcYMlLPZXNHj/oYW3IgsJpnj4Gc8
bN24jgIUw+spXKPv0IYd2kGtkePgXvZVah0HBUKtn3vobEqGLYE3z1SHjUP/
9gbuAeIM/P2691/fYAnsuzEuWhY/DpHLKyldXjNQY0P9cQ2qwJqP4Kb7YRzW
9xRqyvLOQHP71QqB+QaQHm4zmG0ZhybSBDfp9DQk5QUtBV/ohN23zuX/ch+H
0rGum6Hc06DzMNZUkrsbtpZVfErSHYfdSscN84fI0Mp7csDLtgcyqVal7lLj
UHWy6vFCERmS13k0xtn0gojgYUW2TeOwP3vLAf04MtTNSaQzthPhkFedturc
GHSYHL2+7E+GSV9RfrmXRAgxz+ULGmfe67ef5v/gQYaKa14f/7UQ4e/9Fecl
5n40f+71LfEeGT6LJ0WrzBJh9HzeZ5GeMWY/1zqp7k4G94ayOOMFIjiYXfbm
6x6DKn+9Jnk3MmxyO5Sdu0qEgHTGbs2uMfC3VLS660wGw/AH5wJF+4CoWppC
bh2DCK6MX/stybBLadBAMLAPnnkYHlpfOQad8ZMPeBXIUEn/453p3w/8fo6a
JcljcCO35G1G/RTsEV1/yyZlEI7LsSkPnRsDr6DzrN79k0AxQIu/7oyC8hep
oe6EUeDXMX5jeosEB1c177z/PAE5+/5lQ8AQ5HPSDeP3EOHlELty8AEaSFdn
zUpadIBklUyww4lKFDK3d3CIWY8ID2es4ou+ILWZ2ZGIqlEUGil92khwGnax
FeVUPO5DRmVjw0tzE2ja6ulVtqPMfT4v+1OCOILOdcnfN7s5hYYuJg/a2Q+D
zY4DNxlbxlBSUNxGcTYyemN2UFrcfgBaaq8+iHk6hr5EFSzq65GRdlPeYTN6
H7xeptk4fR5Dwpnd3SHXyMjmoz79t3YfnJkb0spuHEPckkk6Z13JCNhDP3Sx
9cGTU5LmXR1jqCpsY9ucGxnxbxHKlv5NBPV8Xvte5n2wbtXePdOdjDQG3kjM
/iRC0HGkYtvNnN/L9ITvAzIaph9xZ4wRQerKNp+Q3jEUr9VAcHpKRkT+hN7k
j0S4kTeo9XpoDI3/1hJ48YqMVvrI9oJmRODarjXDPTOGcsLfh1x7R0YDf69F
qlf1goS01JH/VseQ+KZMji0NZOTvbtPjT+2BOxHRX6q3jyNugqzQ6C8yqlU+
f5Re1Q27DnzwF1AaR1SarUaK7DTyz9DNMUJdUDz2/OEv63H0S7jGbavjNHr5
Qky22aCD2WeXXLwZMo48C1kVxWup6GL8zDPNwg4wVqvpXPvYB3mJ9B3ye2go
/f6qUt+2dgiaJzS6HO0DTZ+U+2yhNKS6i+Isn98MRBF95XAgQr9PC+vRPzQU
YO5W+6a7DnxuUJvtmf9fbN4mlWnrWTQRv7Ep63YFnH26IrS8mQgvXEoP/khh
jh86bP6fZx44ZR51VxrtBcVtQfvz82YRvaqPrUMhHl0qXueoOtILxzcIR+Y6
zKIjz13yLngAUn6j/r6HjQgsN/5aLOTR0OPbSrsiDZrRhzl3aqIREfgmbr0k
36GiVfEwfqfKbpTj/nbj9wIiiGy+/0w+ZwZRT3qsjTP72mbOK2J/BfuAYlu5
nmRPRuMnFM37ysYQxWwjXeBxH2zycmPXKGHWGyWCyeOCCeSlM/7atr0P5I8d
e+FcPYY4DGv37fmPjCzKN2712NEPp7giViPPDCEdm8N+ucoziON12S9F3X7w
DdvI+me0B331a43Ka6YgrdLJuUSXfpg3U6GpWrehDfo3bzrNMfvYy6PfHYP6
gc/nxKbO0CrU4NRR2pBPQ34iJBNSaj8oiemp3GnPRDUiHa70zcz3kSuc7lXY
D3bU0W6/3Dz4crfCKmvdLCrguW+TUMP8PvlJw+EXa+DTStFpgVc0xDnuNI06
+6HzNaVuU107UFPl7IveUpEZX839nsF+mLjmnnqOToRrmofltZQp6L+K1fVi
I/3wz4jvAVocgW9vcvWrTk4j0boiufTufril4vHjKrP+JHVZ1+3+OolYVHfe
PlTeDwM7FTNl9abAw1aJoFM2jgLVVJVZwvpBYZPB+cXGadDe7kD0KR5G2Rt+
5laZ9oPtE549D8oo8Cs15Xdxci+Kav3EzcV8n1tL99m1badBJa9/ys+QNtSi
I3HyVk8f+HEEkbnINEj773H4k/dVaJ1yhaxKRh80rBg09p6ehbVqvdOLwXmo
0/Z3aB/zXEwu32qveWEWThZLHTK5lwD227YcsvHtA+Wve5+93TMLxpUssgPH
yuCkikwEKaoPGgvMgaOVBuGutvauZjWw91b3mQflfZBtLZKSdIUGsflr4o+v
fIeYcKG91xl9IPr8etHp81Tob9olpfC5G0QaDqc06/TBw+/Hun3WUwHue+Us
efVC8/Gw7dS/RPjZWcu6WEkBvir/haBBIjzqFf+mUEWEB7zLn4zDKCD6dlBy
Q38fvB/sTzwZSYTypE+PdJwp8NUmN0+FeZ6bDKm86XIjgtKUo16hOQUMluZe
Zs/2g/m3xblhGyIIxxaG9RlQ4MMdCUUjkQEo2h3wDZj70WLs/k495rjSpLLE
L7EBCI00ZlFmjq+oCD3rMaaAY4Pz6coNAyBl9MPAypK5v748NzpmQQFUNrGv
ZKwfXMSU5g7ZEUF/K89ZO2sK/Jv89ymxox9u8IDZrqtEoPtzqi4w57kSsNB7
kDnPJY0JwkPmPGzdhv1GcsznIfOw5bcBWDR/Ej6sRIQlL2J03rcZkO+c1Wd/
PQTOnMGPxLt7wTFt6MRlwjT8Jy1Tsf3bKKxkSs0rTPYAcf9mQRo7c12R44Me
Eidgg+Pbv8/tuiAj62v6x0cD0GfMlq19iAbuu/Z/VHRqgEDutcMBtdVo5s3y
Gp1Zj+g/dlw/cfwTcuMXbL/IQUJn+47XdEtPw4F1v4Wlk9vRWfWYtvvlZJQ9
XGfgcJvZt2krhwQtdqPbkNUqYzWDvlzO5m7dPwLrDXPGRR/0oiNWEpTdrBQU
cdVEnfRoEGjsX7hreIlIsWfx3JwWBR2VFrNt1RsAiahfSxEGRESMDKRlW1CQ
AneOVRRzX20up/6JtyMizr16vq1WFPS9VY79MnNf+Yhviot2ICITS9naZDMK
0mt+5Nn2sx9Ytm2VG75MRJ67qGeeG1GQxI3nZyy3D4DP+3UqhheJ6KthAmeU
PgWx+Jv+0pRkvn+fhOsRpkR0xmJV+u55CnooFdR4nmMApu/cfLbdgogeDJaG
k69QED2z0775Wz9k2ty8fMWRiA4HnnZlf0JBGq/sDnkc74cnw1Ym132I6Inf
Lh+dTAqqoV45oHm1D5pzlJ94ZRPRtuB9rnZjFJSXoeYpqEwEMeMfZ81GiOhy
vnXrURkqEtpcKCaQ1QMX9P+xt0j0odlpmXC7J8xz5+j9ysakLnjoFbUl8XYf
SjOEkMTCWaRzYX1i4kAnzKW5fH0i3Qiv+zgU+9jpKOZo3GT2n3YwudQfdimx
AfR5fiDl63RE6m0/w8XsmzgfoWVewQaYaP4drd1ERzpXl8ZlI+rB1HUhcyqj
HioeE3ekSTEQ/Zb0VemQCog+TnepO18PVzYZ2nNcYaDZbIm2cNkc+PN2+vUG
aebnpNJEZq4yUOqx+0SD9WnIpK+7lyBbD/uvcYsQBRho4cBUevavb+iMFI+J
waV64BTn3SR4gY4+ayyF71JuQx84JO9eeV8PN+6Wjv9km0V9GToBV7t7Ubak
16/vIg0grzG1kidFRbpmcfvc7EcQm1vrk8DXDTA9AKrRJdNI9l6mgZI6CbEW
969fXNcIu3I7nVcGJxG7Xs2/dzemkK/p+SCHK43w96l3u/6nceSjIVSbJDiD
Zi7t2yuT1wgFOz1nthQOo0xfDmGNk1T055XcY6OpRriuvc4e2nuRxWizaCSV
hjr5oludeZugS3NjiU9XG/JrNL1cJ8p8f3Ofo4oUmsAonfW5UUAV0jft/RY9
Rkds59nvDeo0wW9B0BLsSEdHjinWVikz0NZG09wIiyaQ5Fh75lL5EX5os5xV
kWMgV1OlCcNbTZCQZne9XKsetqgJnenOpKODh5THlx82Ad3yMYWnsBNu8ssf
eJQ5i37fXJIt9m6C9i1eGUOGA7B83Er2gggNuc6HzPUzx1W/OzTyXhmDIrZX
/LorM+jOo3Ouvu5NEPCUOuM2PgHj8xo6wprMvtPL2k/dtAnabj54dXj9NKyN
WqgT2CeQQeAh2uPdTeDuyP6FNZkCT9eGjzS5jCLN4UWFzNFGiButfG76hgaS
U9tFHhj3oQzDcAfXqEY4vmWC22EjHTrmeKmDne3Iev0mrVijRiBnJT9qGqKD
5tbFWz9u1iA+s8I1B6FGsH+2498dTQaIlxQ0/6srQPxj1geYTRmcHZBdXDnP
gBvsJprzbbHw9aixA/l3A9i9CrN8sZcBLXZdsw+byuBa8SmReq5GeFPqTrnc
SYeFTXbbfivWgvvgrCfn8UZYfrb5111HOvDZ8nmMVjdDfrYn6crdRhARyw/d
LDULYuVfaMHivSAtlhxwLrMBdh0NVhOso0HX4zu+Asy+g8Ijd+axaQPEFz7w
G/WgQcurE0maF5jnvPm09sntDbCWnLyyTpMGUht0HvueG4B/eUY0hfF6eOFg
fGNOmAYe6WTT4CVmn/pjtqoR6sHo3dB5vY00CBao5UBmg+Bpm9BHzKmH++Zk
lfk1KuzNZMyUPhyEzpL9y0/T66HDUkJUjIUGM2LPSt/dGgSRd7oMvXf18PFq
qrkUBw1qncJT6GqDMENt6PhXUA9b1UMT5XfSIOQem8KBDYNgFsftZvm1Hlo/
6xrc302DLdY2ZyuJA+D0xs31Rm09SJuanEwWp0GQgFok2wyzX9iYsYm9qh6u
r8ktBK5SQcVV40mI1yBonVhiPZlWD33aAZGfwqgw1/g7lF1qmNmXSh3gO1UP
20reC4j7UGC3NV+J9two1Ky3COwxq4Mb31k7UtLI8MjuVpkNfQKuvlv202yr
hnrnH/F+z4cgzdX8b+h/NChZzRLIXVcGj2dLG9Uv1aIKgQ3Ry8x6dO9Z8huN
/DS0J6JbtcN1Asn43qStKE4Do2o0n39dJbr+qN/Zy3UG7Xxbu+9G+DiIC/7U
br5WiwgDe+PfMM9VxaTekZS3I+DXn0e5TalDh0bp1qKdVFQYtShUsHsIbv77
dDbHqx6pL+bTNPloKPfZkAerKPN9mjxr2VtSj1S1LqTKS9FQb/mtQ6XdAyBm
4zjEUVePPB9q1BiLM+//7JLB2pQBeOT5IKymsh6dibF13ruNhrb/yn2fJzEI
J87tvC1XXI9a2mjRlA009MPehd5kPgh1XxZDfXPq0W2tBzz6f6jo94vXiToP
BiH7T9rWtvR6dCvET9HzHxWJXQy0VHcZhPWXO09+fVuPAr41/JfPzZxnRxKf
/MFB+CswYif6uR4dSV2Bcwdo6Nr1W/N9+QNwPprNVqC1Ht0TOL9OxoqGVO6z
OEwP94O9jcEHpeV6VBaeOqKYTENss4ek3jP7mfTmYbD4rwGteVdVuM7TkMYN
uzwlISLYP3YNfe7ZgO71v3vhbT6Lkree/HOFtQfWbbzS69vTgDZ89BBMtKCj
hhzm61PtglH7ZbGGQF/CTv/WpNPZdOTfo7rvo14HvH4i99P+tB/B8snmSuON
DCSSf7uQ91YrLO7bGuRf50tYCLlwJsGegWTFO1LXtzHXn246ydLTl0DKVmP9
W8ZABdK5XzQjKsCqbsJ1n5ov4VBJ+/d9CwxUn54oz2GaDW4/4nZkqfgSeD2W
og8uM5BS8ffgGyPpqPmDpVD3Y1+C/prC7c2ZDPTrwV7TbYWViDvYTop32ZcA
9C+lS8zz2jDh2s/4qjZU5LWO98VbX8Lm2ITsgyGzqFDhYFxGIBENRQ+7rzzw
Iwg5fDvJn0ZFr0JG7K5LjKKQMk6XXAtfQodhwts02RkkaFtPqq4ioTSHkK3h
Ln6EoMKe6ftoCqm9UouTZSGjui0zNs2ufoTMnv9+t60nIUsl/l0j5TOIK2VC
mKvZn8Cjr0bgUhhBb7skiHXMfqdsyWXtp6cfIUd7JXLPbiISqsrdyJ3GPP+L
9nD1fPUnaBx6MJGy1obUC+76H+ino5v0ts7qdn+C1A9OtVe+VcjnjJPk4TcM
JFNAvj2y5k/46GaQ9ulRGurpsMvbusJA69x5mqzPBRBMStqcFbd/hkjDKbeq
KQaaydw8p/w9gAAC7ytk1Rsg7ozm8obLDHRcmNR3xSSA8Fe4g+u0RRfE+I6I
hZrSEdeqlODPbf4E5a+2Jp0ig7CU/mubNdCQP0fL5K9tAYSCTHMew74xWJSJ
3aL7ioKST2vJKtwJIOxX3zDIdmMSDGD1om0dGRlttzFO3+NPWBC/x/Ynahpu
VbG/MH40geoXXP+V+PsT2Kp+TmYoU2Ge6sBFaB5FSwJdJQfN/Amp9oKH6k/O
Qq2XmJDldB9KfO0gaSbqT9hfubHkQg4dykJ5pNM1O1DLySMZOd1+hLZGqut3
PwbM/eQ+RWCrRS1KtI+afn6EgXvaO3ppDHjm1r3njdcH5FRv1M4e4EdI39aj
Ev+HAfcZrnyvK2IgUZIFBV/zI0g06Lx60sEAZ2Gn7zt+lsG6+OfWJTF+BO2A
Hx3NTxlQXlnn+eN+LfDdWt2oI+BPeJ2+a9VRkAFr70t/GR9rgZsmtZ5pb/wI
6s054j8Is/B2g9R5+5heyODJ/pRv6Ed4wno/+qflLAgV1h8Zvt0HO7wP3bX5
7EvgCP9j9ZtrFgwrNVxYmf3FVR83jspYX4JSehYK76BBT9WWkZLmAdC81SV3
JN6XIB49W7snmwa3s2nHVl0HofU6v8lzE1/C/rZHOQrhNPjA0ej7vWUQ5g+m
ntDe50tw4HnW+OAlDWRmj48Yzw7ClNdu7eNbfQk1p9Eu3lAa3DFzenZgYBC+
pQ8MWmv5Eh63Ni3uSWTeB0zuJux+NwgvFhLQeVNfworWl4yCPBr8crNrfG8/
CNbx5f3993wJd2SFWLLLaLCzUlGLnXmOvT+mWXj4ui9BRCit+VIpsx4ljSpY
HxmEKpNnRQwzX8JMp+DrXdE0uKu18J8UDMIv0ediT918CVyXFc4GHaCB/62F
d3Mmw3CEO8n09qwPwZ0l/+9DYSqc7rqifXfdGNy5vDNqzNmH8OTGzz9i8tNw
5Jd8GyxMwI+WCzc+Sj8jEMmLARnKw3D1UriT2WEanL20PUjEz53gR3E4TB+v
RZdy4MAfZj1iOC2s875oo7acnUSUp00gPt2OZ1eVpuGvU9VgSYOn2gP/4S0c
bBRkNa4urZA8DntUfynaRnmrRR2s53SupqK0+PWaj1tHoOjsS46oUh+1Yomp
++IuNDTV8C3ugOUQ2KXUvXU55qt2UGHhLHc+DSnS2a2P2A3CDv/4BaKNr5qr
8Frkh3IauhDc/bhi3yA8zx3cVmfuq8Yjkj65v5CGiH6bcq1OMX8vF3fDI/K+
apdzL9dZZdDQmalbB4/5D4KOKI/QFxNfNRsnlqmOSBqypqdwGlcPgkluq9w/
5vNf1nMW3gmioe8Cpzk8ZwZBbD9DSOiAr9qp3ldtUcE01P3Vc3pxgjk/edP2
AOY8EVe99sYnMO/HFV3rDLKY6ydVyaX0mq8atwU/z1bm9+QfQiWGssz7jKSt
5mdbX7Vq+RyPnllmfbSMmQuyGAATkV+pdwN91dq+hpaw/jeLZOYizkkr9IPg
Mk+1x2tftZ7rlTuyX86idRd4apsjiHDXWtyzdJufmq7Z7+jri7NoM7tLQMuD
HuhXDwj3d/dT+z8MJBEc
      "]],
    Boxed->False,
    ImageSize->{220, Automatic},
    Lighting->"Neutral",
    PlotRange->{{-13.085411328313018`, 9.74778461331707}, {-15.99585417428455,
      20.08954205975698}, {-5.989130906634184, 5.989130906634185}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    SphericalRegion->True,
    ViewPoint->{-2, -8, -15},
    ViewVertical->{-0.32878421890904874`, -0.20093690976519535`, 
     2.883811777407575}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26554851],

Cell[BoxData["\<\"kleinbottle.pov\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1778265828]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"POV - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 41.7631064}", "context" -> "", 
    "keywords" -> {
     "3D", "geometry", "modeling", "rendering", "CAD", "visualization", 
      "raytracing"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: model/x-pov POV-Ray 3D scene description language and format. \
Used for storing 3D models and scene descriptions. Native file format of the \
POV-Ray raytracing software. POV-Ray is an acronym derived from Persistence \
of Vision Raytracer. Plain text ASCII format. Uses the syntax of the POV-Ray \
scripting language.", "synonyms" -> {}, "title" -> "POV", "type" -> "Format", 
    "uri" -> "ref/format/POV"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16600, 551, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 229367, 4115}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3185, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3808, 91, 143, 6, 70, "ObjectNameAlt",
 CellID->30422],
Cell[3954, 99, 424, 9, 70, "FormatUsage",
 CellID->27666],
Cell[4381, 110, 205, 7, 70, "FormatNotes",
 CellID->8486]
}, Open  ]],
Cell[CellGroupData[{
Cell[4623, 122, 52, 1, 70, "ImportExportSection",
 CellID->3455],
Cell[4678, 125, 455, 16, 70, "FormatNotes",
 CellID->29614],
Cell[5136, 143, 39, 1, 70, "WeakDivider",
 CellID->29082],
Cell[5178, 146, 524, 20, 70, "FormatNotes",
 CellID->12455],
Cell[5705, 168, 1039, 38, 70, "FormatNotes",
 CellID->14197],
Cell[6747, 208, 621, 21, 70, "FormatNotes",
 CellID->22106],
Cell[7371, 231, 815, 28, 70, "FormatNotes",
 CellID->8752],
Cell[8189, 261, 39, 1, 70, "WeakDivider",
 CellID->15821],
Cell[8231, 264, 236, 9, 70, "FormatNotes",
 CellID->17296],
Cell[8470, 275, 216, 9, 70, "FormatNotes",
 CellID->26281]
}, Closed]],
Cell[CellGroupData[{
Cell[8723, 289, 51, 1, 70, "ElementsSection",
 CellID->26021],
Cell[8777, 292, 68, 1, 70, "FormatNotes",
 CellID->18318],
Cell[8848, 295, 2388, 61, 70, "2ColumnTableMod",
 CellID->9135],
Cell[11239, 358, 155, 5, 70, "FormatNotes",
 CellID->1271205744]
}, Open  ]],
Cell[CellGroupData[{
Cell[11431, 368, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[11483, 371, 60, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[11546, 374, 468, 12, 70, "3ColumnTableMod",
 CellID->28047],
Cell[12017, 388, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[12263, 397, 701, 25, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[13001, 427, 49, 1, 70, "SeeAlsoSection",
 CellID->4747],
Cell[13053, 430, 2676, 90, 70, "SeeAlso",
 CellID->1919681360]
}, Open  ]],
Cell[CellGroupData[{
Cell[15766, 525, 58, 1, 70, "MoreAboutSection",
 CellID->248182674],
Cell[15827, 528, 150, 2, 70, "MoreAbout"],
Cell[15980, 532, 151, 2, 70, "MoreAbout"],
Cell[16134, 536, 134, 2, 70, "MoreAbout"],
Cell[16271, 540, 133, 2, 70, "MoreAbout"],
Cell[16407, 544, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16600, 551, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16716, 557, 60, 1, 70, "ExampleSection",
 CellID->304025282],
Cell[16779, 560, 95, 1, 70, "ExampleText",
 CellID->1040958143],
Cell[CellGroupData[{
Cell[16899, 565, 1049, 31, 70, "Input",
 CellID->1981720939],
Cell[17951, 598, 34707, 572, 70, "Output",
 CellID->1463266936]
}, Open  ]],
Cell[52673, 1173, 60, 1, 70, "ExampleText",
 CellID->231524072],
Cell[CellGroupData[{
Cell[52758, 1178, 139, 4, 70, "Input",
 CellID->70992528],
Cell[52900, 1184, 87, 2, 70, "Output",
 CellID->1966399086]
}, Open  ]],
Cell[53002, 1189, 125, 3, 70, "ExampleDelimiter",
 CellID->783855897],
Cell[53130, 1194, 81, 1, 70, "ExampleText",
 CellID->1601370181],
Cell[CellGroupData[{
Cell[53236, 1199, 174661, 2876, 70, "Input",
 CellID->26554851],
Cell[227900, 4077, 94, 2, 70, "Output",
 CellID->1778265828]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[228033, 4084, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

