(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35037,       1200]
NotebookOptionsPosition[     28660,        994]
NotebookOutlinePosition[     30237,       1035]
CellTagsIndexPosition[     30151,       1030]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PBM\"" :> Documentation`HelpLookup["paclet:ref/format/PBM"], 
          "\"PGM\"" :> Documentation`HelpLookup["paclet:ref/format/PGM"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"PNM\"" :> Documentation`HelpLookup["paclet:ref/format/PNM"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"PBM\\\"\"\>", 3->"\<\"\\\"PGM\\\"\"\>", 
       4->"\<\"\\\"PNG\\\"\"\>", 5->"\<\"\\\"PNM\\\"\"\>", 
       6->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "PPM ",
 StyleBox["(.ppm)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "MIME type: ",
 StyleBox["image/x-portable-pixmap", "InlineCode"],
 "\nPPM color raster image format.\nMember of the Portable family of image \
formats.\nRelated to PBM and PGM.\nImplements a subset of the PNM format.\n\
Native format of the Netpbm graphics software package.\nPrimarily used as an \
intermediate file format on Unix systems.\nPPM is an acronym for Portable \
Pixel Map.\nASCII or Binary format.\nStores raster images as 8-bit or 16-bit \
RGB data.\nDeveloped in 1988 as part of the Pbmplus package."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the PPM format. "
}], "FormatNotes",
 CellID->5055],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates binary PPM files."
}], "FormatNotes",
 CellID->1472317897],

Cell[TextData[{
 "If multiple images are present in a PPM file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns the first of the images."
}], "FormatNotes",
 CellID->1665544589]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "PPM",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as a PPM raster image."
}], "FormatNotes",
 CellID->6748],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default generates binary PPM files."
}], "FormatNotes",
 CellID->714710085],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of RGB color values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "PPM",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because PPM is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "PPM",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<PPM\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<PPM\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "PPM",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).ppm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "PPM",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->26857],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a PPM file into a cell. "
}], "FormatNotes",
 CellID->20640],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a PPM file."
}], "FormatNotes",
 CellID->26052]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of RGB triples", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->16955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 "element for PPM files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->468620669],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1285050334]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General option:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->2513],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorMap\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
determines the color reduction palette used for representing the imported PPM\
\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DitheringMethod\>\"", 
    "\"\<FloydSteinberg\>\"", Cell[TextData[{
     "the dithering method used when color reduction is performed on ",
     Cell[BoxData[
      ButtonBox["Import",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Import"]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->9261],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData["\"\<ColorMap\>\""], "InlineFormula"],
 ": "
}], "FormatNotes",
 CellID->31101],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "chooses an adaptive set of at most 256 colors", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "adaptive set of at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " colors"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["color", "TI"], 
       StyleBox["1", "TR"]], ",", " ", 
      SubscriptBox[
       StyleBox["color", "TI"], 
       StyleBox["2", "TR"]], ",", " ", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no color reduction is performed", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->24393],

Cell[TextData[{
 "The",
 Cell[BoxData[
  RowBox[{" ", "\"\<DitheringMethod\>\"", " "}]], "InlineFormula"],
 "option specifies the dithering algorithm used for generating the color \
reduction palette on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->442094198],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FloydSteinberg\>\"", Cell["\<\
Floyd\[Dash]Steinberg error diffusion dithering\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no dithering is used", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->10285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->21078],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the exported image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16878],

Cell["Detailed properties and settings:", "FormatNotes",
 CellID->4611],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", 
    ButtonBox["RGBColor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RGBColor"], Cell[
    "color space of the image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->31947]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24750],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PBM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PBM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PGM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PGM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->137141756],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->128353783],

Cell["Import a PPM example file:", "ExampleText",
 CellID->1249150954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/wolframtones.ppm\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnE2O1EAMhRvRd2DNEbgKR5gLsGTBnlNwBU4yixyA9ZyDH7WIGjnUPD+7
XO7oRYU0Spz4lZ/r66GUnvdPnz4+vb1cLh9+//v25nL58/NPHTp06DjR8ePl
821sL9fbeHd9vo3BmX1cn7/cxn7m+/X5NmywHTa7PeO6nUuRLmM/43pOQX3m
nUF6I/2uvdkGXYd4sSe12bkY5BJyBrmE+O7qjXktgcQMaIPEiGmTZIhph70h
polpYtpU7+bJENMOe0NME9OWMA2pub3kIiEiMliiysW7RAbS5AXCuA509Ubl
ggrSwAanoyzLd1eMa8pcisHcXR80YpqYFjwjpo3vEtPEtKwOFNNqhIlp47vE
tHqmIQWxzwyamNUw3O3zGOLSfJDi6/NtuGSkl3defbJW6JLFwsUEZxEsOPJA
1/rKmuC8GDENPyOmiWlETHAWwYIjDxTTXs0iptFOiWnxlhDTvNnPxzRuIwvJ
uwRuwT7JmkWBDK7JC4Qhe2XcXUGprmpkxbhWU5YFBb5zKQYxWR8iYpqYli5M
TPPenm5Bge9cCjFNTBskbdLbYpq3qunzEtPuB7ifZoeLhPZSsIHT2TiPIb6k
Zj8NkdGkPvZNfuQbJdxdrkWHLARk0WXFHCgE9lELfEdi1v5agsSIaXgKMU1M
E9PEtP9dEtOOHyimiWmpprhqiMSchmnzlLhKxG1tBbsiq5dczOdkLBGGQAnp
DXvXyXbYLO44zU18D6bI+qCxf8RATBPTxDSwGsEYMe1+iGmRwgaboUkLte1t
Mc2rR0zbJjMNmVrQ6KALB/UE9p1cUisZUiBjibB5cOOWz2hB/e2fYPPvz7EN
yT0n6vKKdZH+ewVy1yBGTMO9a4KOtsLENDGNSCGmLfSuCTraChPTxDQixSqm
uQwa/Dll1+rjFjjy/3SXZfMYwlW+mzAOZfPgFqyPqxrBmMozBQ2ZlSIYI6aJ
aUFhYhodI6YdXhLTxLS1wsQ0OkZMO7wUZ5ptocHIMjrYb8j+Q7DUlb1UIKNA
GAc3G2MH95qHq6OyFlRWDDcd7u/vBZMWpEDu2oeYFtEjpolpk2K46Yhpm5gW
0yOmiWmTYrjpiGnba/tpWc3gUusaiDBXqdcyxDWdJsKy9tMQuKW/q5C+oApi
mvhemQJpv32IaWdqITHN2y1impjG5XWZ6Bpi2nJhYlpxTBPfH5RpLgRlNQwX
nC5jXi8VVPWBhCFIRLIv2WFL/x5B0IKs7yMU+J5lk40R02Z716SF2goT0zYx
LWCTjRHTZnvXpIXaChPTNjEtYJONAd/lQPK61A4G1xXzSr2WIQVTbiKMgxv3
llFlNQpi2vrueufKlWIQI6adqYUeWpiYRse09V1Mi0yk0sS2LfTQwsQ0Oqat
78uZ5koXLEiwwoP9h0o3K7MvkdFEGLfDluWpvdQkxo6s/bQlvmfZJKYR4gvO
NJHRRJiYBlogpm1iWnb/N/H3ZMLENNACMW379/ueXA/YMdiOC7qJ3FVQ6nm5
Bq8ErC1CsDe4FLZ/uPoUrFBXNQpimviOMJZ7Ccc2yeH3CLIqLKbRZ8S0+zNi
Gh3TxHcx7dWYJcu5MpeYdn9GTKNjmvi+immDq1yF00u0n6n0rn8vLZGxRBj3
wsY8T/dR+T0C5DmVvVGQlEshpk2S2sTfcwgT08DnVPZGQVIuhZg2SWoTf88h
TEwDn1PZGwVJuRT3TMt6OBeMWGZjkOCCUmc9ed57103Kkl4f7jUPZF+ushoF
MQ/tuyuFmDapwllrdkkLte1tMY2OeWjfXSl+6tChQ8e5jl+aw9Tz
   "], {{0, 0}, {412, 49}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{412, 49},
  PlotRange->{{0, 412}, {0, 49}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1874090238]
}, Open  ]],

Cell["Read the color palette used in this file:", "ExampleText",
 CellID->679950806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/wolframtones.ppm\>\"", ",", " ", "\"\<ColorMap\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1587528657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "203", ",", "123"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"207", ",", "229", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"219", ",", "229", ",", "119"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"23", ",", "4", ",", "203"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"173", ",", "4", ",", "203"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "134", ",", "203"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"255", ",", "255", ",", "255"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1257307871]
}, Open  ]],

Cell["Import meta-information elements:", "ExampleText",
 CellID->1172710755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/wolframtones.ppm\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "\"\<ImageSize\>\"", ",", " ", "\"\<BitDepth\>\"", ",", 
      "\"\<ColorSpace\>\""}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->334301417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"412", ",", "49"}], "}"}], ",", "8", ",", "RGBColor"}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1486714567]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PPM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 42.6068780}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: image/x-portable-pixmap PPM color raster image format. Member \
of the Portable family of image formats. Related to PBM and PGM. Implements a \
subset of the PNM format. Native format of the Netpbm graphics software \
package. Primarily used as an intermediate file format on Unix systems. PPM \
is an acronym for Portable Pixel Map. ASCII or Binary format. Stores raster \
images as 8-bit or 16-bit RGB data. Developed in 1988 as part of the Pbmplus \
package.", "synonyms" -> {}, "title" -> "PPM", "type" -> "Format", "uri" -> 
    "ref/format/PPM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24573, 870, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30017, 1023}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2643, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3266, 87, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[3370, 93, 568, 10, 70, "FormatUsage",
 CellID->10168],
Cell[3941, 105, 324, 12, 70, "FormatNotes",
 CellID->5055],
Cell[4268, 119, 200, 7, 70, "FormatNotes",
 CellID->1472317897],
Cell[4471, 128, 258, 8, 70, "FormatNotes",
 CellID->1665544589]
}, Open  ]],
Cell[CellGroupData[{
Cell[4766, 141, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[4832, 144, 304, 11, 70, "FormatNotes",
 CellID->8922],
Cell[5139, 157, 357, 11, 70, "FormatNotes",
 CellID->6748],
Cell[5499, 170, 212, 7, 70, "FormatNotes",
 CellID->714710085],
Cell[5714, 179, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[5755, 182, 752, 26, 70, "FormatNotes",
 CellID->10986],
Cell[6510, 210, 493, 18, 70, "FormatNotes",
 CellID->2144],
Cell[7006, 230, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[7129, 235, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[7171, 238, 351, 13, 70, "FormatNotes",
 CellID->26517],
Cell[7525, 253, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[8102, 275, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[8687, 298, 702, 25, 70, "FormatNotes",
 CellID->5874],
Cell[9392, 325, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[9434, 328, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[9961, 350, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[11060, 392, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[11724, 416, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[12543, 446, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[12584, 449, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[12947, 465, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[13336, 484, 70, 1, 70, "NotebookInterfaceSection",
 CellID->26857],
Cell[13409, 487, 241, 7, 70, "FormatNotes",
 CellID->20640],
Cell[13653, 496, 153, 4, 70, "FormatNotes",
 CellID->26052]
}, Closed]],
Cell[CellGroupData[{
Cell[13843, 505, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[13895, 508, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[14089, 518, 710, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[14802, 534, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[14844, 537, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[14915, 540, 1081, 27, 70, "2ColumnTableMod",
 CellID->16955],
Cell[15999, 569, 393, 14, 70, "FormatNotes",
 CellID->8394],
Cell[16395, 585, 197, 8, 70, "FormatNotes",
 CellID->468620669],
Cell[16595, 595, 504, 11, 70, "2ColumnTableMod",
 CellID->1285050334]
}, Open  ]],
Cell[CellGroupData[{
Cell[17136, 611, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[17188, 614, 54, 1, 70, "FormatNotes",
 CellID->16097],
Cell[17245, 617, 516, 15, 70, "3ColumnTableMod",
 CellID->3065],
Cell[17764, 634, 177, 7, 70, "FormatNotes",
 CellID->2513],
Cell[17944, 643, 843, 22, 70, "3ColumnTableMod",
 CellID->9261],
Cell[18790, 667, 154, 5, 70, "FormatNotes",
 CellID->31101],
Cell[18947, 674, 1388, 41, 70, "2ColumnTableMod",
 CellID->24393],
Cell[20338, 717, 364, 12, 70, "FormatNotes",
 CellID->442094198],
Cell[20705, 731, 568, 15, 70, "2ColumnTableMod",
 CellID->10285],
Cell[21276, 748, 178, 7, 70, "FormatNotes",
 CellID->21078],
Cell[21457, 757, 457, 12, 70, "3ColumnTableMod",
 CellID->16878],
Cell[21917, 771, 71, 1, 70, "FormatNotes",
 CellID->4611],
Cell[21991, 774, 449, 12, 70, "3ColumnTableMod",
 CellID->31947]
}, Closed]],
Cell[CellGroupData[{
Cell[22477, 791, 53, 1, 70, "TutorialsSection",
 CellID->24750],
Cell[22533, 794, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[22701, 799, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[22908, 807, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[22961, 810, 1211, 41, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[24209, 856, 58, 1, 70, "MoreAboutSection",
 CellID->137141756],
Cell[24270, 859, 133, 2, 70, "MoreAbout"],
Cell[24406, 863, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24573, 870, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24689, 876, 60, 1, 70, "ExampleSection",
 CellID->128353783],
Cell[24752, 879, 70, 1, 70, "ExampleText",
 CellID->1249150954],
Cell[CellGroupData[{
Cell[24847, 884, 136, 4, 70, "Input",
 CellID->27432],
Cell[24986, 890, 2058, 37, 70, "Output",
 CellID->1874090238]
}, Open  ]],
Cell[27059, 930, 84, 1, 70, "ExampleText",
 CellID->679950806],
Cell[CellGroupData[{
Cell[27168, 935, 187, 6, 70, "Input",
 CellID->1587528657],
Cell[27358, 943, 611, 18, 70, "Output",
 CellID->1257307871]
}, Open  ]],
Cell[27984, 964, 77, 1, 70, "ExampleText",
 CellID->1172710755],
Cell[CellGroupData[{
Cell[28086, 969, 316, 9, 70, "Input",
 CellID->334301417],
Cell[28405, 980, 189, 7, 70, "Output",
 CellID->1486714567]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[28633, 992, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

