(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25418,        920]
NotebookOptionsPosition[     20049,        746]
NotebookOutlinePosition[     21597,        787]
CellTagsIndexPosition[     21512,        782]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"MX\"" :> Documentation`HelpLookup["paclet:ref/format/MX"], 
          "\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"NB\"" :> Documentation`HelpLookup["paclet:ref/format/NB"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"MX\\\"\"\>", 
       2->"\<\"\\\"ExpressionML\\\"\"\>", 
       3->"\<\"\\\"NB\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Formats" :> 
          Documentation`HelpLookup["paclet:guide/BasicFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Basic Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Package ",
 StyleBox["(.m)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->3676],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " source format.\nUsed for storing and exchanging ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " programs, packages and data.\nPlain ASCII text format.\nStores ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ".\nCan represent program code, numerical and textual data, 2D raster and \
vector images, 3D geometries, sound, and other kinds of data.\nDeveloped \
since 1988 by Wolfram Research."
}], "FormatUsage",
 CellID->29643],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package files."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", "]"}]], "InlineFormula"],
 "reads in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package, evaluating each expression in it, and returning the last one."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a single expression to a package source file."
}], "FormatNotes",
 CellID->12927],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always uses",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"], "->", "\"\<ASCII\>\""}]], 
  "InlineFormula"],
 " for package source files."
}], "FormatNotes",
 CellID->721395591],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a package source file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Package\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Package\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1809274264],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " source file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).m\>\""}], "]"}]], "InlineFormula"],
 " can be used to export multiple expressions."
}], "FormatNotes",
 CellID->104113528],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the package format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Save As", "MenuName"],
 " can be used to export a notebook as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package."
}], "FormatNotes",
 CellID->2609]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ExpressionList\>\"", Cell[
    "evaluates all expressions and returns the results as a list", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Get\>\"", Cell[
    "reads and evaluates all expressions, returning the last one", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeldExpressions\>\"", Cell[
    "list of unevaluated expressions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "code comments", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Get\>\""], "InlineFormula"],
 " element for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Package files."
}], "FormatNotes",
 CellID->13037]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->25476],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1144148228],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell["\"Comments\"", "TableText"], Cell[
    TextData[Cell[BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["user comments", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->470391403]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<MX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1252504826]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->195477949],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->317196834],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in a sample file:"
}], "ExampleText",
 CellID->2065206152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/Collatz.m\>\"", ",", " ", "\"\<Elements\>\""}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->927891765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Comments\"\>", ",", "\<\"ExpressionList\"\>", 
   ",", "\<\"Get\"\>", ",", "\<\"HeldExpressions\"\>"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->50649841]
}, Open  ]],

Cell["Import unevaluated expressions from this file:", "ExampleText",
 CellID->141610203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<ExampleData/Collatz.m\>\"", ",", " ", "\"\<HeldExpressions\>\""}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1857054121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldComplete", "[", 
    RowBox[{"BeginPackage", "[", "\<\"Collatz`\"\>", "]"}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{"Collatz", "::", "\<\"usage\"\>"}], 
     "=", "\<\"Collatz[n] gives a list of the iterates in the 3n+1 \
problem,\\r\\n        starting from n. The conjecture is that this sequence \
always\\r\\n        terminates.\"\>"}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{"Begin", "[", "\<\"`Private`\"\>", "]"}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{"Collatz", "[", "1", "]"}], ":=", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{"Collatz", "[", "n_Integer", "]"}], ":=", 
     RowBox[{
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Collatz", "[", 
         RowBox[{
          RowBox[{"3", " ", "n"}], "+", "1"}], "]"}], ",", "n"}], "]"}], "/;",
       
      RowBox[{
       RowBox[{"OddQ", "[", "n", "]"}], "&&", 
       RowBox[{"n", ">", "0"}]}]}]}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{"Collatz", "[", "n_Integer", "]"}], ":=", 
     RowBox[{
      RowBox[{"Prepend", "[", 
       RowBox[{
        RowBox[{"Collatz", "[", 
         FractionBox["n", "2"], "]"}], ",", "n"}], "]"}], "/;", 
      RowBox[{
       RowBox[{"EvenQ", "[", "n", "]"}], "&&", 
       RowBox[{"n", ">", "0"}]}]}]}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{"End", "[", "]"}], "]"}], ",", 
   RowBox[{"HoldComplete", "[", 
    RowBox[{"EndPackage", "[", "]"}], "]"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1802531400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->784390244],

Cell["Export an arbitrary expression to the package format:", "ExampleText",
 CellID->1770891678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"f", "[", "\"\<\[Alpha]\>\"", "]"}], ",", " ", "\"\<Package\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137265138],

Cell[BoxData["\<\"(* Created by Wolfram Mathematica 6.0 \
*)\\nf[\\\"\\\\[Alpha]\\\"]\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1378011218]
}, Open  ]],

Cell["Import the previous output:", "ExampleText",
 CellID->1400568373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", " ", 
  RowBox[{"%", ",", " ", "\"\<Package\>\""}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1557040292],

Cell[BoxData[
 RowBox[{"f", "[", "\<\"\[Alpha]\"\>", "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1892201023]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 20.1219274}", "context" -> "", 
    "keywords" -> {
     "expression", "programming language", "code", "application", "package"}, 
    "index" -> True, "label" -> "Mathematica Import/Export Format", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica source format. Used for storing and exchanging Mathematica \
programs, packages and data. Plain ASCII text format. Stores Mathematica \
expressions in InputForm. Can represent program code, numerical and textual \
data, 2D raster and vector images, 3D geometries, sound, and other kinds of \
data. Developed since 1988 by Wolfram Research.", "synonyms" -> {}, "title" -> 
    "Package", "type" -> "Format", "uri" -> "ref/format/Package"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16117, 601, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21378, 775}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1534, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2157, 64, 103, 4, 70, "ObjectNameAlt",
 CellID->3676],
Cell[2263, 70, 647, 18, 70, "FormatUsage",
 CellID->29643],
Cell[2913, 90, 377, 15, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3327, 110, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3394, 113, 379, 12, 70, "FormatNotes",
 CellID->2520],
Cell[3776, 127, 346, 11, 70, "FormatNotes",
 CellID->12927],
Cell[4125, 140, 335, 13, 70, "FormatNotes",
 CellID->721395591],
Cell[4463, 155, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4505, 158, 350, 11, 70, "FormatNotes",
 CellID->22675],
Cell[4858, 171, 572, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5433, 193, 580, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6016, 216, 684, 24, 70, "FormatNotes",
 CellID->21001],
Cell[6703, 242, 457, 16, 70, "FormatNotes",
 CellID->1809274264],
Cell[7163, 260, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7204, 263, 569, 21, 70, "FormatNotes",
 CellID->9310],
Cell[7776, 286, 1073, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8852, 328, 659, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9514, 352, 814, 28, 70, "FormatNotes",
 CellID->20356],
Cell[10331, 382, 503, 17, 70, "FormatNotes",
 CellID->104113528],
Cell[10837, 401, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10878, 404, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11242, 420, 346, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11625, 437, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[11697, 440, 221, 8, 70, "FormatNotes",
 CellID->2609]
}, Closed]],
Cell[CellGroupData[{
Cell[11955, 453, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[12009, 456, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[12204, 466, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12875, 481, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12917, 484, 179, 7, 70, "FormatNotes",
 CellID->13573],
Cell[13099, 493, 808, 17, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[13910, 512, 325, 12, 70, "FormatNotes",
 CellID->13037]
}, Open  ]],
Cell[CellGroupData[{
Cell[14272, 529, 49, 1, 70, "OptionsSection",
 CellID->25476],
Cell[14324, 532, 182, 7, 70, "FormatNotes",
 CellID->1144148228],
Cell[14509, 541, 526, 13, 70, "3ColumnTableMod",
 CellID->470391403]
}, Closed]],
Cell[CellGroupData[{
Cell[15072, 559, 50, 1, 70, "SeeAlsoSection",
 CellID->19008],
Cell[15125, 562, 604, 20, 70, "SeeAlso",
 CellID->1252504826]
}, Open  ]],
Cell[CellGroupData[{
Cell[15766, 587, 58, 1, 70, "MoreAboutSection",
 CellID->195477949],
Cell[15827, 590, 117, 2, 70, "MoreAbout"],
Cell[15947, 594, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16117, 601, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16233, 607, 60, 1, 70, "ExampleSection",
 CellID->317196834],
Cell[16296, 610, 225, 8, 70, "ExampleText",
 CellID->2065206152],
Cell[CellGroupData[{
Cell[16546, 622, 196, 6, 70, "Input",
 CellID->927891765],
Cell[16745, 630, 207, 5, 70, "Output",
 CellID->50649841]
}, Open  ]],
Cell[16967, 638, 89, 1, 70, "ExampleText",
 CellID->141610203],
Cell[CellGroupData[{
Cell[17081, 643, 208, 7, 70, "Input",
 CellID->1857054121],
Cell[17292, 652, 1688, 46, 70, "Output",
 CellID->1802531400]
}, Open  ]],
Cell[18995, 701, 125, 3, 70, "ExampleDelimiter",
 CellID->784390244],
Cell[19123, 706, 97, 1, 70, "ExampleText",
 CellID->1770891678],
Cell[CellGroupData[{
Cell[19245, 711, 197, 6, 70, "Input",
 CellID->137265138],
Cell[19445, 719, 149, 3, 70, "Output",
 CellID->1378011218]
}, Open  ]],
Cell[19609, 725, 71, 1, 70, "ExampleText",
 CellID->1400568373],
Cell[CellGroupData[{
Cell[19705, 730, 161, 4, 70, "Input",
 CellID->1557040292],
Cell[19869, 736, 114, 3, 70, "Output",
 CellID->1892201023]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[20022, 744, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

