(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    146965,       2870]
NotebookOptionsPosition[    142352,       2721]
NotebookOutlinePosition[    143733,       2759]
CellTagsIndexPosition[    143646,       2754]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"JPEG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/JPEG2000"], "\"PNG\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PNG"], "\"PPM\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PPM"], "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"JPEG\\\"\"\>", 3->"\<\"\\\"PNG\\\"\"\>", 
       4->"\<\"\\\"PPM\\\"\"\>", 
       5->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RawBitmap", "ObjectNameAlt",
 CellID->7514],

Cell["\<\
Raw raster image data.\t
Used as an intermediate format by imaging devices.
Stores images as RGB or grayscale bitmaps at a resolution of 8 bits per \
channel.
Binary format.
Does not include meta-information.
Equivalent to the binary portion of PPM files.\
\>", "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the raw bitmap format."
}], "FormatNotes",
 CellID->5055]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<RawBitmap\>\"", ",", " ", 
    RowBox[{
     ButtonBox["ImageSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSize"], " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["w", "TI"], ",", 
       StyleBox["h", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " imports a raw bitmap file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell["\<\
The image size must be specified when importing a raw bitmap.\
\>", "FormatNotes",
 CellID->114088543],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], ",", "\"\<RawBitmap\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 " exports graphics or any other expression as an image to a raw bitmap."
}], "FormatNotes",
 CellID->6748],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<RawBitmap\>\"", ",", " ", 
    RowBox[{
     ButtonBox["ImageSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSize"], " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["w", "TI"], ",", 
       StyleBox["h", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of RGB color values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     StyleBox["expr", "TI"], ",", "\"\<RawBitmap\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "creates a raw bitmap with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["All fonts are rasterized on export.", "FormatNotes",
 CellID->2137242512],

Cell[TextData[{
 "The format name ",
 Cell[BoxData["\"\<RawBitmap\>\""], "InlineFormula"],
 " must be explicitly specified."
}], "FormatNotes",
 CellID->1823419462],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<RawBitmap\>\"", ",", 
       StyleBox["elem", "TI"]}], 
      StyleBox["}", "TI"]}], ",", 
     RowBox[{
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"], "->", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["w", "TI"], ",", 
        StyleBox["h", "TI"]}], "}"}]}]}], "]"}], " "}]], "InlineFormula"],
 " imports the specified element from a ",
 Cell[BoxData["\"\<RawBitmap\>\""], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RawBitmap\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], 
     StyleBox["}", "TI"]}], ",", 
    RowBox[{
     ButtonBox["ImageSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageSize"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["w", "TI"], ",", 
       StyleBox["h", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->1930729077],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<RawBitmap\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["elem", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["elem", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], 
      StyleBox["}", "TI"]}], ",", 
     RowBox[{
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"], "->", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["w", "TI"], ",", 
        StyleBox["h", "TI"]}], "}"}]}]}], "]"}], " "}]], "InlineFormula"],
 "imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RawBitmap\>\"", ",", 
      StyleBox["elem", "TI"]}], 
     StyleBox["}", "TI"]}]}], "]"}]], "InlineFormula"],
 " creates a raw bitmap file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RawBitmap\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], 
       StyleBox["}", "TR"]}]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"], ",", "\"\<RawBitmap\>\"", ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<RawBitmap\>\"", ",", "\"\<Rules\>\""}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support raw bitmaps."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for ",
 Cell[BoxData["\"\<RawBitmap\>\""], "InlineFormula"],
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->450361849],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", Cell[
    "color encoding used in the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1499224115]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General options:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "overall image size, always specified on ",
     Cell[BoxData[
      ButtonBox["Import",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Import"]], "InlineFormula"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG2000"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PPM\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PPM"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->181153189],

Cell["\<\
Read raw bitmap data, specifying the width and height of the image in pixels:\
\
\>", "ExampleText",
 CellID->1860829104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", 
  RowBox[{
  "\"\<ExampleData/elephant\>\"", ",", "\"\<RawBitmap\>\"", ",", " ", 
   RowBox[{"ImageSize", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"220", ",", "159"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvPV3VGfXPv6u78PIcRmfyUjcjSghIYSQBBIkARJIsLg7ENzd3SEuuBZo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   "], {{0, 0}, {220, 159}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{220, 159},
  PlotRange->{{0, 220}, {0, 159}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2068888449]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RawBitmap - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 46.2163454}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Raw raster image data. Used as an intermediate format by imaging \
devices. Stores images as RGB or grayscale bitmaps at a resolution of 8 bits \
per channel. Binary format. Does not include meta-information. Equivalent to \
the binary portion of PPM files.", "synonyms" -> {}, "title" -> "RawBitmap", 
    "type" -> "Format", "uri" -> "ref/format/RawBitmap"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18760, 669, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 143512, 2747}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1752, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2375, 67, 49, 1, 70, "ObjectNameAlt",
 CellID->7514],
Cell[2427, 70, 302, 9, 70, "FormatUsage",
 CellID->10168],
Cell[2732, 81, 330, 12, 70, "FormatNotes",
 CellID->5055]
}, Open  ]],
Cell[CellGroupData[{
Cell[3099, 98, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[3165, 101, 586, 18, 70, "FormatNotes",
 CellID->8922],
Cell[3754, 121, 112, 3, 70, "FormatNotes",
 CellID->114088543],
Cell[3869, 126, 412, 13, 70, "FormatNotes",
 CellID->6748],
Cell[4284, 141, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[4325, 144, 1015, 34, 70, "FormatNotes",
 CellID->10986],
Cell[5343, 180, 509, 17, 70, "FormatNotes",
 CellID->2144],
Cell[5855, 199, 79, 1, 70, "FormatNotes",
 CellID->2137242512],
Cell[5937, 202, 164, 5, 70, "FormatNotes",
 CellID->1823419462],
Cell[6104, 209, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[6146, 212, 748, 25, 70, "FormatNotes",
 CellID->26517],
Cell[6897, 239, 852, 29, 70, "FormatNotes",
 CellID->1930729077],
Cell[7752, 270, 956, 32, 70, "FormatNotes",
 CellID->29916],
Cell[8711, 304, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[8753, 307, 608, 21, 70, "FormatNotes",
 CellID->15469],
Cell[9364, 330, 1144, 41, 70, "FormatNotes",
 CellID->22912],
Cell[10511, 373, 683, 22, 70, "FormatNotes",
 CellID->8146],
Cell[11197, 397, 879, 30, 70, "FormatNotes",
 CellID->30693],
Cell[12079, 429, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[12120, 432, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[12483, 448, 339, 12, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[12859, 465, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[12911, 468, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[13105, 478, 711, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[13819, 494, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[13861, 497, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[13932, 500, 801, 19, 70, "2ColumnTableMod",
 CellID->16955],
Cell[14736, 521, 515, 15, 70, "2ColumnTableMod",
 CellID->23183],
Cell[15254, 538, 450, 16, 70, "FormatNotes",
 CellID->8394],
Cell[15707, 556, 197, 8, 70, "FormatNotes",
 CellID->450361849],
Cell[15907, 566, 519, 11, 70, "2ColumnTableMod",
 CellID->1499224115]
}, Open  ]],
Cell[CellGroupData[{
Cell[16463, 582, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[16515, 585, 55, 1, 70, "FormatNotes",
 CellID->16097],
Cell[16573, 588, 687, 20, 70, "3ColumnTableMod",
 CellID->3065]
}, Closed]],
Cell[CellGroupData[{
Cell[17297, 613, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[17350, 616, 1009, 34, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[18396, 655, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[18457, 658, 133, 2, 70, "MoreAbout"],
Cell[18593, 662, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18760, 669, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18876, 675, 60, 1, 70, "ExampleSection",
 CellID->181153189],
Cell[18939, 678, 131, 4, 70, "ExampleText",
 CellID->1860829104],
Cell[CellGroupData[{
Cell[19095, 686, 290, 8, 70, "Input",
 CellID->27432],
Cell[19388, 696, 122898, 2018, 70, "Output",
 CellID->2068888449]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[142325, 2719, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

