(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24029,        813]
NotebookOptionsPosition[     19799,        675]
NotebookOutlinePosition[     21028,        711]
CellTagsIndexPosition[     20943,        706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary" :> 
          Documentation`HelpLookup["paclet:ref/format/Binary"], "Bit" :> 
          Documentation`HelpLookup["paclet:ref/format/Bit"], "Byte" :> 
          Documentation`HelpLookup["paclet:ref/format/Byte"], "Character8" :> 
          Documentation`HelpLookup["paclet:ref/format/Character8"], 
          "Character16" :> 
          Documentation`HelpLookup["paclet:ref/format/Character16"], 
          "Integer8" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer8"], "Integer16" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer16"], 
          "Integer24" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer24"], 
          "Integer32" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer32"], 
          "Integer64" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer64"], 
          "Integer128" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer128"], 
          "UnsignedInteger8" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger8"], 
          "UnsignedInteger16" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger16"], 
          "UnsignedInteger24" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger24"], 
          "UnsignedInteger32" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger32"], 
          "UnsignedInteger64" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger64"], 
          "UnsignedInteger128" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger128"], 
          "Real64" :> Documentation`HelpLookup["paclet:ref/format/Real64"], 
          "Real128" :> Documentation`HelpLookup["paclet:ref/format/Real128"], 
          "Complex64" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex64"], 
          "Complex128" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex128"], 
          "Complex256" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex256"], "String" :> 
          Documentation`HelpLookup["paclet:ref/format/String"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary\"\>", 2->"\<\"Bit\"\>", 
       3->"\<\"Byte\"\>", 4->"\<\"Character8\"\>", 5->"\<\"Character16\"\>", 
       6->"\<\"Integer8\"\>", 7->"\<\"Integer16\"\>", 8->"\<\"Integer24\"\>", 
       9->"\<\"Integer32\"\>", 10->"\<\"Integer64\"\>", 
       11->"\<\"Integer128\"\>", 12->"\<\"UnsignedInteger8\"\>", 
       13->"\<\"UnsignedInteger16\"\>", 14->"\<\"UnsignedInteger24\"\>", 
       15->"\<\"UnsignedInteger32\"\>", 16->"\<\"UnsignedInteger64\"\>", 
       17->"\<\"UnsignedInteger128\"\>", 18->"\<\"Real64\"\>", 
       19->"\<\"Real128\"\>", 20->"\<\"Complex64\"\>", 
       21->"\<\"Complex128\"\>", 22->"\<\"Complex256\"\>", 
       23->"\<\"String\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Real32", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Uniform sequence of IEEE single-precision numbers.
Binary data format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read arbitrary binary data as a sequence of single-precision numbers."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can convert a list of arbitrary integers or reals to binary \
single-precision numbers."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Real32\>\""}], "]"}]], 
  "InlineFormula"],
 " imports any file as 32-bit IEEE single-precision numbers, returning a \
packed array of real numbers."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<Real32\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of real numbers to ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Real32\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Real32\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "Real32",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of real numbers", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->611127238],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Real32\>\"", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], " "}]], "InlineFormula"],
 "reads the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " single-precision number from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->61452522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " for IEEE \"infinity\", and ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " for IEEE \[OpenCurlyDoubleQuote]not\[Hyphen]a\[Hyphen]number\
\[CloseCurlyDoubleQuote]. "
}], "FormatNotes",
 CellID->1851343939],

Cell["\<\
Trailing bytes are ignored if the size of the imported file is not a multiple \
of the data size.\
\>", "FormatNotes",
 CellID->647021390]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell["General option:", "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["what byte ordering to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2140947909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Binary"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Bit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Bit"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Byte",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Byte"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex256",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex256"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/String"]], "InlineFormula"]
}], "SeeAlso",
 CellID->344804987]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28203978],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->522847512],

Cell["\<\
Convert a list of integers and reals to IEEE single-precision numbers: \
\>", "ExampleText",
 CellID->1096476082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2.5", ",", "Pi", ",", "E"}], "}"}], ",", 
   " ", "\"\<Real32\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData["\<\"\.00\.00\.00\.00\.00\.00\.80?\.00\.00 \
@\[CapitalUHat]\.0fI@T\[OSlash]-@\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->280909751]
}, Open  ]],

Cell[TextData[{
 "Convert the previous result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " numbers:"
}], "ExampleText",
 CellID->916335267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", " ", "\"\<Real32\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196716535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "1.`", ",", "2.5`", ",", "3.1415927410125732`", ",", 
   "2.7182817459106445`"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1081128951]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Real32 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 46.7944852}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran", "IEEE 754"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Uniform sequence of IEEE single-precision numbers. Binary data format.", 
    "synonyms" -> {}, "title" -> "Real32", "type" -> "Format", "uri" -> 
    "ref/format/Real32"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18466, 615, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20809, 699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4157, 83, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4780, 110, 52, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[4835, 113, 120, 4, 70, "FormatUsage",
 CellID->37585799],
Cell[4958, 119, 247, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[5208, 128, 262, 8, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5507, 141, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[5574, 144, 384, 12, 70, "FormatNotes",
 CellID->28652],
Cell[5961, 158, 416, 15, 70, "FormatNotes",
 CellID->8194],
Cell[6380, 175, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6422, 178, 744, 27, 70, "FormatNotes",
 CellID->29174],
Cell[7169, 207, 624, 22, 70, "FormatNotes",
 CellID->943],
Cell[7796, 231, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[7837, 234, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[8201, 250, 355, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[8593, 269, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[8652, 272, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[8851, 282, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[9546, 298, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[9590, 301, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[9664, 304, 351, 9, 70, "2ColumnTableMod",
 CellID->611127238],
Cell[10018, 315, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[10408, 332, 632, 23, 70, "FormatNotes",
 CellID->61452522],
Cell[11043, 357, 558, 18, 70, "FormatNotes",
 CellID->1851343939],
Cell[11604, 377, 148, 4, 70, "FormatNotes",
 CellID->647021390]
}, Open  ]],
Cell[CellGroupData[{
Cell[11789, 386, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[11845, 389, 58, 1, 70, "FormatNotes",
 CellID->577662107],
Cell[11906, 392, 461, 12, 70, "3ColumnTableMod",
 CellID->2140947909],
Cell[12370, 406, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[12555, 415, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902]
}, Closed]],
Cell[CellGroupData[{
Cell[12985, 429, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[13043, 432, 4903, 160, 70, "SeeAlso",
 CellID->344804987]
}, Open  ]],
Cell[CellGroupData[{
Cell[17983, 597, 57, 1, 70, "MoreAboutSection",
 CellID->28203978],
Cell[18043, 600, 113, 2, 70, "MoreAbout"],
Cell[18159, 604, 134, 2, 70, "MoreAbout"],
Cell[18296, 608, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18466, 615, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18582, 621, 60, 1, 70, "ExampleSection",
 CellID->522847512],
Cell[18645, 624, 123, 3, 70, "ExampleText",
 CellID->1096476082],
Cell[CellGroupData[{
Cell[18793, 631, 240, 7, 70, "Input",
 CellID->976592890],
Cell[19036, 640, 151, 3, 70, "Output",
 CellID->280909751]
}, Open  ]],
Cell[19202, 646, 157, 6, 70, "ExampleText",
 CellID->916335267],
Cell[CellGroupData[{
Cell[19384, 656, 149, 4, 70, "Input",
 CellID->196716535],
Cell[19536, 662, 197, 6, 70, "Output",
 CellID->1081128951]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19772, 673, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

