(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   5577505,      91681]
NotebookOptionsPosition[   5571963,      91513]
NotebookOutlinePosition[   5573838,      91558]
CellTagsIndexPosition[   5573749,      91553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Geospatial Formats" :> 
         Documentation`HelpLookup["paclet:guide/GeospatialFormats"], 
         "Graphics Importing & Exporting" :> 
         Documentation`HelpLookup[
          "paclet:guide/GraphicsImportingAndExporting"], 
         "Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "New in 6.0: Data Handling & Data Sources" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60DataHandlingAndDataSources"], 
         "New in 6.0: Import & Export Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Geospatial Formats\"\>", 
      2->"\<\"Graphics Importing & Exporting\"\>", 
      3->"\<\"Importing & Exporting\"\>", 4->"\<\"Listing of All Formats\"\>",
       5->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
      6->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more about\"\>",
       
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SDTS ",
 StyleBox["(.ddf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->15463],

Cell["\<\
SDTS GIS format.
Geographic information standard used by the U.S. Geological Survey.
Used for archiving and exchanging maps and map data.
SDTS is an acronym for Spatial Data Transfer Standard.
Based on ISO 8211.
U.S. Federal Information Processing Standard.
An SDTS transfer archive consists of multiple .ddf files combined in a \
.tar.gz file.
The file extension .ddf is derived from Data Descriptive File.
Binary format.
Contains digital line graphs (DLG) or digital elevation models (DEM). 
Digital line graphs are vector data commonly used for maps. 
Digital elevation models are stored as a raster of elevation values.
\
\>", "FormatUsage",
 CellID->26260],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read the DLG and DEM content of SDTS."
}], "FormatNotes",
 CellID->30947]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->13793],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", "\"\<SDTS\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}], " "}]], "InlineFormula"],
 " imports an entire SDTS directory and returns a combined rendering of all \
graphics layers."
}], "FormatNotes",
 CellID->28630],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"file\", \"TI\"]CATD\)]\).ddf\>\"", "]"}]], "InlineFormula"],
 "explicitly specifies the main .ddf file of an SDTS bundle to be imported."
}], "FormatNotes",
 CellID->18717],

Cell["", "WeakDivider",
 CellID->23043],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object.  "
}], "FormatNotes",
 CellID->31376],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"elem\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " imports the specified element from an SDTS file."
}], "FormatNotes",
 CellID->25314],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"elem\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sub\", \"TI\"], 
StyleBox[\"a\", \"TI\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sub\", \"TI\"], 
StyleBox[\"b\", \"TI\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->16626],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"elem\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"elem\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->17117],

Cell["", "WeakDivider",
 CellID->1334],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20620]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->26792],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8964],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->15947],

Cell["", "WeakDivider",
 CellID->18866],

Cell["Data representation elements:", "FormatNotes",
 CellID->14693],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[TextData[{
     "all layers combined into a single ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsList\>\"", Cell[
    "list of graphics representing the layers of an SDTS archive", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "graphics primitives for each layer", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElevationRange\>\"", Cell[
    "range of elevation coordinates, typically given in meters", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SpatialRange\>\"", Cell["\<\
range of geographic coordinates, typically given in decimal degrees\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->30664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for SDTS bundles."
}], "FormatNotes",
 CellID->23775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " with element ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " gives the combined graphics contents of an SDTS archive as a ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " object, rendering DEM data as a ",
 Cell[BoxData[
  ButtonBox["ReliefPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReliefPlot"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->13000],

Cell["Data representation elements:", "FormatNotes",
 CellID->1630063808],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<LayerNames\>\"", Cell[
    "labels for each layer, given as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LayerTypes\>\"", Cell[
    "SDTS data types for each layer", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1033536277]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->25476],

Cell["General rendering options:", "FormatNotes",
 CellID->1606778643],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["background color", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the range of latitude and longitude values to assume for the data\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the image", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->521791876],

Cell["DEM rendering options:", "FormatNotes",
 CellID->2121522295],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxRatios",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxRatios"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "effective 3D bounding box ratios", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], "\"\<Topographic\>\"", Cell[
    "how to determine the color of surfaces", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataReversed",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataReversed"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to reverse the order of rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LightingAngle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LightingAngle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
the effective angle from which simulated illumination is taken to come\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->144278413],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->6379],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<DefaultElevation\>\"", "0", Cell[
    "elevation setting for areas not covered by the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DownsamplingFactor\>\"", "1", 
    Cell["\<\
integer factor by which the amount of DEM data in each horizontal dimension \
is reduced on import\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->10943],

Cell["Rendering options:", "FormatNotes",
 CellID->1796470603],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FaceColors\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "colors used to render polygon layers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VectorColors\>\"", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], " "}], Cell[
    "colors used for points and lines", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LayerSelection\>\"", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["\<\
layers to be rendered, given as a list of layer names or indices\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1808831448]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->79811678],

Cell[TextData[ButtonBox["Geospatial Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeospatialFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->305735454],

Cell["\<\
This imports SDTS digital line graphic data, rendering it as vector graphics:\
\
\>", "ExampleText",
 CellID->567217714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/sdtsdlg.tar.gz\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1580329231],

Cell[BoxData[
 GraphicsBox[{
   {FaceForm[{RGBColor[0.225956, 0.479118, 0.892638], Opacity[0.1]}], 
    PolygonBox[{CompressedData["
1:eJxdW3dcT9//Lw2rTyUzsz4ZRbQj8X6fG7Jn3YuPPkq7ZEZGRLJXVkulyBay
hbjIaA8je38iIhmR1u/1Ou/Ovb/H1z8e5/G8932e59xzXq/na2TsOWeSTxM1
NbV5Gmpq+P/Tp32z1Ikg3hxhEfirYTDZdHWVrZdCEB8G/dejAcZWOwY75Q0S
xDqLkn1aagryyOf3+P6Ogpjc5vizljC+mnJ7dayDIL7Jmu37A573XhS+o8kA
eN6g8mE1jNv887DOy14Qn5l1ScXfu9R3e8t8W0GcUzLaRRPeD9QvDbGwEcRb
k7q7N4ex/rvk1XFWgjjX7fbYv2BcbvBgmoalIM7buPXdN3g/8afZHe9+gth5
l+W9KhgPyXp3P99cEDuZJ+zH+b4fcyCWfQRx8O6PWbUwjlvxY+xuM0F03Zr1
ph7GIz1Hptf0EsTPHpkKdfj9pouLb/j0hN871S6pCYyPj95SWNBdENfZXNut
AePp/d44WpkI4oJdEY+Rr2aTxJHxxoL4a35SZ9yPs+8qz9Z2E0S3Afo7cDz/
z9Krvl1lvEO+XW5hZ0Hs+yHDCt+/m7axv3UnQSx1/L0Bf3/26mHDEgwF8YHm
xF/Ip5vf7rS69oKoldF/rRqMny8zueTXThCDPg7qjfy3uC/ukdVGEPmqf1vh
+mzwX2tBtFmvV/4bxo+1v5DEVrC+IS/m/4TxhjKn1Ho9QdxYqm6O+8eZVrz1
1xVETmfBZ/x+zccajM7WEcSqFi2/NIXxSaO8KbYtBZGsq/6G++Gh8XdmVHN5
fu2SZ0UNTQUx/8aeEJwv9WjMywBtwPOE6fj7awemzs3RFMSi3J0zW8D75rp+
YXYa8n4++3q5LFpdEMM2LP6E/ANXHa5RUxPEVNcJE5Gvm+um9Z71vHS+mpg6
R+fW8tL78PR++xpebLbF4+0fXE/Cutax1byY8yByLM5v6l7o1OQ3L37cFv9a
G55/zPU44VXFi7fsFDvrAPe710rM+8GLi4bfDvwO47nvb4yw+M6LJ6cPc8b1
Nyw++U9cJS8uySU+yO/AmEB/ja+8GBa0o1sljKO7jv3p/YUXWxg8fY58eqQ5
NC0o58Veuskv8f70y/wYafmJF3t3iLqP5zmDL9m7u4wXPebmdcH5bwes7137
nhdDH9r9owu4a82CQb6lvGi2s+MT/N5vN88YV/iOFw1W8T9xPeXJBiVWb3kx
PGRdG5xvqXXDh/jXvBhx3W4R3rfVzmnz6l7yYkDHNnmIGzxKiPB7IeOdy8fq
ZD2T3z+6fGBXm6fy7x9ZNXFk4mNeOm85jwrz6kt48UKzzT/x/k0NzHjp/5CX
7pNX2Gz/7Pu86Dvq0xxc3+O8zWG293jRi1QtxfX/MdHRiC7iRbpvgLeaWWmm
VsiLZP/Lq7je9Zf0SGA+L243PZtag/PrR2bm5PJiz5uVy/B7GXkcf2KXw4uR
KQ6n6Xk9b+4ek8WLCftM0nH+KXWt1qrf5cUmn3XN8PnrhrV1nrd5cZ/TwmD8
Pl/3wQnO5EWjsnu98Xw0/bhreP+bsN/p47fieTYjbXJjr/Oiy7GTJ/B8rhvr
XdpEhPP25NVQ3K8jKW8Dva/K/B6Zx2zJvyK/X72qnYHlZV58O7PAHNc/ZZuv
+e50XhSnGXE4/5LS/9JqLsB6A1v3wv04PCfuns95Xrx0OX8t8r92PuxPwVle
nKt8FY73/fe43KVWZ3hx6LOEUbgevehTe+NPwfe5YrwF+Y3s12Bcd5IX/83Y
uBn3L7J6JfE7wYtdazPVke+p8Wq37qbC9526dwTO9+rRmffWx3jxZfWw5rj+
X93idBOP8KJhZtMQnN/yYunW+kO8SP+H8fCGnHP+B3nxTamrNX7/lTGG9tn7
ZX7UHqTw4sDs60G4/qKQMc+j9vLiqzBRA7+vGv5L5sUbPm3tcWyx4czfgXtk
fMJL60M5CfL7K/xLs+zi5d+/qGY7KiZOnr9guOE89ViZX/NXvpWe0TJ/o15j
OuTtktc3Pq1hYP+d8vrXjxh7OXa7vD8XitReNNnGixm3bobi/n0NGDfde6u8
v92+q4fnb5b3n4wM17LcJPOj33eD/P3WGnYcr7n+f77vWvn7ay8v+1ywWj4f
pvf851tFyOdnslvnqPhw+XwtPh1vWLdCPn8l1z7Z+IXJ5/N325kX7y6T3++V
1PWpdah8vhWlGk0Sl8jn/1CTL0vqF8n34+rIe8n+IfL9eZU0qUf2Avl+CRVz
HW2D5fu3eNjXa1HzZH5fduk+bJgj31+tZ99rA2bL97undXB4TpB8/xPDt8fY
zZTtw8EoJ6OYANl+2PWysFb3l+2LsPzEeU9f2f7wq269zvWW7dO71qe/23vJ
9utzL69lsTNk+0b3xUO2f2vy1Np7T5fx1u6fTfPd5Pe7BO85ZTFN/v1jmptu
xk2V7a9D9KIHGlNk+zzkqOl0H0G230WObecWuIK/0XP7D9f3dPzt35Yusv0P
eH26RfxE2T9MOxMVUzte9h/q6yYc8B0n+5fIDoMvFI6R/U+c+Rel9WjZP/W6
+mRiwkjZf5UkW2TUDZf92zWvxeV+zrL/m6zZMC1rqOwf60rSA2yGyP4z5diC
RYmc7F+jlsMbSl7yvyZ6Q9sFKHjJP9+vjA3PHiS/v/SWS6StIy/5d1fe3yja
gZf8/x9Tk35qA3ixb06JD+qD5NrnjoH2vKQfqD2w5SV9UXX681k7G17SH1dL
9DvHWPGSPglpl+GibslL+qVXdatrnv14Sd/k5cI/c17SP8HJ657Y9+ElfWQS
8WxYrJk8/+tYn/FNTOXztj300iWvnrykv/qPX3g3rzsv6bMPVtk2Fia8pN+2
aq3h4ox5Sd+N7qQ7WsOIl/QfeKPz3l1lfF9Rl8z8zrykHyednW9h2Unez9/r
+g7ebchL+vN84nlnzQ68uHXKpvHIx3dly9M+7XhJv/7levtaQRv5PmXYd+pj
1ZqX9K9Xi4cD4lvxkj5u/bn3/lo9XtLPFZ3cQ311eUlfR1UYbijU4SX9Pax4
9g+rlrykzz8dMGuS0JyX9HvC+rBZdU15Sd87uTmE+mnzkv433d007a6mfL7y
Z93IsNbgpfhhAbc8J0Gdl+KL7t2L7esbXKX4Q1/j35omarw4yT06JFBbQdJd
Bk5pAPz+/dPnruooyJavVUaagIdr3oq0aq0gES86DVGDsdbeK5EphgrSx6I6
qRaep/aoG+g5cG/qgFO/1BP0Y+edt+oAP8rFPs0wV5CdNV024nw0brBRqPQy
4AYRYvZeB4hHyi6c1ADc9mtKxyqlQqV/AZ/36sF8P2cFadO0sKIGxrqPyaVH
YxRkVWbIL+SjMxeUi4uCbPsR0BbnuxM+OSdxqoK0+/GiA8632iz7QKW7gvz1
RsMR56O611dBsgZ9a4rzZXRMtr0fBHwKEj1wvvwJzyp7BivIv0H/mOH6x1gm
zIxdoiAu/6wYjfOpr1n6p9lKef2Rz3YvmLa20Z8Cvum54ljuZgX5mf5kI/KB
W/Vr0E4FGWN3Jhr5VLobNdsWB/HLoQVpyIer2GKslgx8xV3hyGfx3+u/zz2o
UPkDwPed7f/7Riqcd3CzuH69f+FmnwF/3u2riHwyT/WbnZKuUPk3wAN9blj8
vAb2N+fyR+Qz+N7ozT63FcRp8HJNnG/dgfBuD3LB/l3k9XE+m3Zj/XrdA/vW
u31vnO9Pc78L0Y8VxGtI/xrER8XdL9R+pSCOHUABwRhUt86UUgWZsXF+AK6/
IAECxXLwVyk7BuJ8CWOHq/X/DvvT1tUV+SQFX/h0oBriT5ADuP4DFqsTfjUo
VP4TcF/8p60kto+V43E+Pe7Bhwc6SqJzIj0F+bSIsN7Ss7VSFU/CeMTT362j
DJUEbt9W5EPvj5FSdf8AzxmRcWh+TyUZ+M73IvLJGT6p+Ka5kmx7kpmFfEAV
aVnbKInmnBEpyKes4sDXZAcl+bFm23fk82JBjm6lUklUfo4Xk44df+TurCRX
9ee/QD7Rk09cyBujlL7H55Yf1ji6KInJlcHNcL7hQpjh5qlKovJjruJlE69z
1e5KorJ7vHhxc3xHf18l6V1zohnOVx74bdeDIOCb1tkY5/v75YH7PYKVJPIg
RCCAt8mf3XfnEuDrWN+SnseAur7qK5VkqpVbF1x/nf8An9lrldL3MAW3nbEZ
+D7rNRznC2t/3rfPTtife2umIJ+WnO6o2DglmdvD0R7Xb6R9qUorWUludYob
jnyCyOqL8w8qCXx1D+Qzrdn8CTdSge8d73nIR2v0QnWLM0qVPgNccFo0MiEd
9m+isxvy6banx91mopLUHHU7jHw0ylNcJt9WquIJwOfVTgjIzFWSE9/nxCCf
KfOOnrO8pyQtnHssRD5rdmQdSXysJIvDJq5CPhuM8m82f6Ukk0/+nYJ8rAZV
nZlSqiQqO+kq/ngSlJpZLp+PkI18hOV3JQmx9ExCPisfbDdJrJb5vBoVEqSp
RojZkoVbkU/m4rxjAzUI8RBMi5GPsbBi9QxtQrZ05y4in136EHk3J8QgyfE6
8gEV5pWnQ4hylush5DNsqNUSDX1CMt+PS0M+ERkbjB1aE/Julc1v5FNgMarQ
vR0hrSaOeYF8LFesyY0yJCQ6x/k98unbfIJLTmdCbsa55yEfmi8xImQEJnQA
H/n9zll7E0IWvpl/BfnElbRaF9STkOPXeqjhfE28lmvsNCPkxui5H5EPjVPM
CXFv5lCBeM63hYb1FjKf/6I+zbKxIaRaN+wN8qE6xF7mk6eInLjHgZBjk7cX
IZ9AVMCDCKkJMWiF658wa+7ff5SE/Ba3NiCfsb8GHrEYQlT6BnA0V97OhBxt
vu8L8tHPrhmweyQhVGYBXmLwjSsYI/Op9zIeqDmBkDe5J0uRz4dVf6IdXIgq
HsP7NeJnortAiPPiUH2cz/dHyutdUwl5azu0LfLpXHxYzHIjRBUHgX+Fa1nv
LvN5/B6EhRchoWu0fiFusH9Sub8vIdQMAU7PW4DMx0zr+fTiIEKyN77+iHzE
LPu5TecSYlVu2RP5zLc73advMJH8S+za1yaeITIfaj+XEHIKA3TAqQ5bRshy
xw3NcD4DjNNXEsm+3hlR1cwugpAOTvk1iH949nlpwFqZz4Cf4e8SNxByekTr
CuQz9um108WbCVHpRlextmZzy6bbCGk4pd8F+YxzLygx30kI/e54vjQdTGdE
E8ne0/MXR4hP9SUdnG+OualOdgIhKJPwPhedPJ5Un0RU8SbaV58N+dYpMp9B
Seo/fQ8Sslt72HfE63uLi+KPyHx6z5q3pSCVENu/QEkCPlo9oEEjjRDDbRkv
cP/QXA84Q0hB64LHyHfyhwifoPOEgHcsRr5DHA9NTU4npNPy3KbIZ++YlKxb
V2Q+V9CeXpP5aK+4Ftv3JpH0AHjVghm3ZT4Vkb+ORmURyR9uGXbvcVauzAfT
AHUFRBW/Ar5zzvl0q3uExLvaPkQ+ue7GwT4PCZn4aFgR7l/13uL1cY8JsZu2
JAv3b/vuEKu8Z4RYG4VmIJ+p7eGXXhFSOOPqFeTTpnRwvu1bQnJ7imnIZ9DM
C//6lxICUV0a8qFxRxkhvn219iMfmhctJ+Sz+dJDyOf3wbIzGl8JKasMjUc+
Jy4O6N3/OyEqXcuLprFWWjOrCInACwm44nR64J5qQmIatoUhH5dcrrCoFtbf
oLUK+aj0M0dUcb6rWPRPUekADY4k31y2BPk4FDyKCdLmyNls8DToDxfav0tq
zhGUJdR/fwtZfU+HI/aRNz2Qz5G9f4na+hzJ2DrAG/kk7/s4eWBrjhRGNXOl
evJBl02z2nFE6XJyGn7P3i9tDPYacpKeovqrs8yn3tlx9u9uHFkffmI58jk7
ZeO7PiacSg8DfjDBomp6T07yF5usO3nvMJP5PAur9r5lzpEtLRKCkI9xl643
fltwkr7d9zn2Uh8bjiw8YdoD+cSm3KmYZQ/r/3VbH/ksXhZakuzAEQwbcf+m
8BbX7g3iJP8+TfP2H23CkfEYoAMe/9/pIochHDmw8mwD4nt2jfxrljNHyloa
v0e+g8Pm3EsayRHTYX1+Id9kO2V98RiOzCyMeYF8Fd18MrUmcJK9VHs568UA
F07Sf/WFEAAKnHS+zIffJXumcmTuVIjA4fmum2ZNKnLjVPlx1Nv4Ox4c+d4F
FArgNfzKCnsvjvQ/4p+KfNbfP7spwJcj05P3i8inOQqyANifWS9TkM/PPol6
BUEceeXd6SLyobplLkccrYV45FOpN22pbTBHVmTcWCXZgxCOHDxbH418xtRO
vB+3hCNNVjksRT539KKcc5dxkr+1X9i1bcMKTpVPRX+sUx9mFcGRY4PL1yCf
FVUmw7zXckS7Za8A6v+jB+2J3sBJ+pjG3Zs5Sa/T/EkkR2JXt1yC3zOyY2vP
fjs5SY+ANzrqEc0RvxnjHZHP9opJH3fEcap4F/AvZR+33kqA/bn512/EB/R7
e1A7mZP8zQ/LswMdUmB/1q2uoP7I52nAzIOcFD/gtiYe4cigMTWlyLfIeG73
wlROsqf0HqfB/uSnvEG+QwOf3LI9w5GOL1Kv4/7l9Cl56nse9ofmRXjRWdlx
XFw6nHeaRwJ/rNbeO+cKR3a1vfkA+S6Orcqru8aRpj1yzyKf6Z7m9yxucqQ+
ZmYR8nUIO2zreZuT4qvxuUutdmVxkp41+1C143YuR6aiYQbcqHiOe9NCjjgs
K96AfKdWdU9zuMeRzLwj3sinAAOgh3Deu4Urkc+CXo9WJD7miMWESR7I53mB
2d2CZxwpfvvLHvmchnBE/RVHTrXJmox8Rk1ze2vzFvbHN9ma8lEMPu9TypHO
MfNckE/7ijufY8o4cujDiH7IZ7Qw7GJWOUdUcTEvDtkU9L6mgiPUb8J40bey
U32/w3mH44Z8Wngmz3Sv4iT98NZ6dmByNZwvDz4D8ZB9EPnWcmTM+ClvkC/V
G2pOZMeCvHfx6iwf50SCL5n3tIf4eXPS7YzqBvjeL/eaFkJ8fT11wv4aGDdo
tu8TCPH323FlHnUwHtZ7c1/NZnA+aNzAkU3j1S33QPyuOndOJHPa+5f9IL7v
8p+HvTqMW4S7vbkL8T+tm8AYrGWZpy7o/dnjemjAmPorPZbPgvdPfP4c3Qri
oQIDb+Tb4r7nV8vWvKhhPFXE8YTqkm/ZbXjxv6YnvuF4BRq+drx4PqJVDY6p
DmrPi/s7GBXhGK9TrCHoYQwEYYxy1KZTo3+GMX6OvM68qMmnTMbx8+i7Wn5d
efHp9fXLkS+1f0Zgv6ifgPeT3unGG/Oiyo7D+5lTW9mZyPvxvCy/dUF3sN/U
j3CqfFdPXpyxv/053M8A2/QOGqYsv8GRc5YtPyeY8ar7B79H7VYfvlGvOxEu
9GdloTkvhtS2b4Z8kt4M+BrYjxf/ON1d0gDvi/idLFj+Gu5H8a2DUVa8uNT2
wU78fZf89qEWNjCeeNldC96P+755eZYtnD+q45zIyw5NVnrZ86IqLudID8Wi
VXX9Id4NPtcW+U79/eefGAdexDQz8rvgrphq5Sh/z7rVZ6blDGL5L06Vz1Tw
Yt5W15c4/yLvVHvM/+2Z9mEUrgfDhDiOF1VxLkc6VXr3x/zhgFZ1T/7AeABe
2KHy944q/NcA84+DqB3myNOfxW3UR/Ci56MZY/D537PWV+4eCXz6rD2G3094
kFNhO5oX8fMgn/ljw3Pzx/AqvQh44dnMbP9xvNhy6Rwd/J79OjfLajJBnt9m
UsWRhIm8qIoDnci2dOvD9i68+GL7qSe4v8etPqwudIX4L/RRS9zPlnF9IgIF
ef303E7hxcpwUB6Ae3QBTzC1UV8C7uNy4mu/acD/5/AOuJ83L1V+uevG6hEc
ufP1UYHndNivXnvO4Ps0D+feaP8A771V42T0DF78ds4vGvcnqX/bI5ZevHh4
wnM35Ld/Vu2GbG+479QuOpGO7XVXe/vCfX612xHXR/2LH8Q/D9+44PmlcXEA
6EcPByfkE/6x21Drmbyo7r+rH843+8UAs9wgXlT5TTifWR26+c7mxV98+gT8
vjRtOVfm/+DUqLK4eeCvaNzqRDwTQfkE8+KnQw2p+Pz47UMy8xaA/x770xuf
H7TG7YhfCMRLNC/nRFr1P7RDfTEvjhd0JuP3Ou/Nr45fwuoLYG/aJc+yC+VF
VR7IiSxukT6pYBkv3rDK2YP70WWA39CAMPAHw4bPx/nQbGqshPgczDi+//J5
tkFiuLz+3CIw4BG8qPKzTmRvRL/Xhat5sUrBr8H9cD71rDhwLS8OxcIavN9z
s69PzTq4zzTPwZGawafGRW2QzyfN527iRa0Nn7/g+cp426ZL1mZeLP9toU/t
b5S7ttdWXtyx5J0e/j7VU5Fw3lY8rP0N7ztW/3gUvZ0X15wYmozz6R9T3rDc
yYs95l83RP51e6Ycyt4l2+PiCSnbvKPB/4vdwnA/aX4pBvQmzVuA/6zSdo+N
48XTnhcH4noDDk8cYR3Pq/Q6jBX/JFjlJvCiKm/iRPqMO9fOdw+rTzlJ9Tcs
O+CYft+9Mn79gFe+TYr8Ps0T7Zd/f2bz6mS/g/L8NB9yWObX96TbnPgjvOgx
KGIt8m8y49AUu2Py+ipAShakyuvPxAN8Qt4fGm+myfuHXjDhlLy/Qzp/emN/
Rt5/2i9xVv4+WjfGnQo8L3+/J8FxuzUvyt83fZxJ36h0+fu7LyvqanFZPh+2
aECuyOfH6G+7z55X5fP1V7txxbXX5PP35k7s5ejr8vlc/9P5uOVN+fwuKHPf
kZ0pn++R8UdDvW/zoiqOgv24O2VW/R1epV/QXy5NEWKz5PuTNvuKo3WOfL8S
PR8Y5ebK949+33z5ftL4u0C+v5r271/FFcn3e4fxnYc29+T7v6Ltq8t592X7
8ONq5Tm/h7L9wOOr/khef+kHCOAey/Zn2g6NELunsn3yuPtRKHgm26+HmCh7
Idu3m1j3fSXbvwF6vSwTX/8/+zhMt1X/tzL/+NSJekXvZPtK/WWpbH+/Wn6O
r3kv2+efvveXRZXJ9pv6y0+8uLZhgQbic5zzJmeVy/Y/77i+4PVF9g9U/1XI
/sNitKNdTKXsX7acDrOx+i77n6O9bfVzfsj+qdmORbo+VbL/6t6i76f6X7J/
C7SAyK1aPp93o//7ZF0j+0dQI3exf4XN7xTy4rZvPaunwPmKd8nC/hfJ/2K/
iLog+WeN0DH7bTUEaf0jk68fzNcUJP9+sKnWAX9tQfL/VBc1EyR9ANHeioTm
gqQf/HSCV9m3FCR9Qf2ljiDpj+q+A6cG6gqSPqHxsb4g6RfqL1sJkr65urqF
rkVrQVTFJU5E8+gKfexPYvpoVMEPA692gqSfaD6vvSDpK9oPZChI+uvvdlbl
lp0ESZ/5Ox78kt1ZkPTbCQ9QJF0FSd89H3LjV303QdJ/JgH9/8QaC5I+DNia
WmttIkj68eQZ44bc7oKkL3/CdfDrKUj6E9PZ6qaCpE9pPddMkPTrSW3Tv+z6
CJK+pXGpuSB9b8eJBgYB/QRJH9O6s6Ug6ec78bXtEq0ESV//dX2eYX8b+Xs6
4sS2gqTPad7IXpD0+6UHwcU1/eX9UKv5cD/KQZDssbPR9BILR0GKD2heaZAg
xQ+zMDGhEKT44kzaoS71SkHMf7naCfmGJh110iCCFJ90tZlg2AA4i1/ovgHO
4huaDwCcxT807oUxi4+on4HnWfxE892As/iK5pcBZ/HXuE/2h+sAZ/EZ1X+A
s/iN2gnAWXyXhglWwFn8R/MBgLP48E5E3xDkw+JHmg+A51l8idcV+bD4k8bf
yKcxPqV2FHAWv1Y/sRmNfFh8S+8l4Cz+9fr3mTPyYfHxlxNw4ABn8XOpsYtC
E3AWX9N6CYxZ/E3zO/A8i88zz2gaIh8Wv9N8AOAsvqf3DnAW/9N8AOAsP0Dz
AUSQ8gc0/gac5Rfi9qRlIs7yD1T3Ay7lJ0J/rEU+LH9B6xf4fGN+46NyZhjy
YfkP6l8AZ/kR1xutlyIflj+h/RqAs/xKydqN85APy7/UL7+9Bvmw/AzNBwDO
8jf0ngLO8js0HwBjlv/pFv9uOPJh+SHnHUZuyIflj/a5T1MiH5ZfyhJiXJAP
yz/ReizgLD9F6/uAs/wVrX8BPlavxSjMb9F7AzjLf9F+Nxiz/BjtQ4DnWf5s
l4W/MfJh+bVHl+43Qz4s/0bz94Cz/Bz1Q4Cz/B3VU4Cz/B61f4Cz/B/N7wDO
8oO03oLnszF/uGliyRP8niy/ODz11iHky/KPwT+9diJflp/Mmgs7DTjLX9L6
MeAsv0n7fQFn+U9aHwOc5UdpHwXuR2P+9DgmJAFn+VUaH8OY5V8tAn8dQz4s
PztkHlhM3J/G/C3jw/K7zxfpRCIflv+l9WzAWX6Y6la8v435Y8aH5ZepH1MK
Uv45QG1OOO4fy08vb6qch3xY/nqbrt4M5MPy2xi+IR+W/6b1TLw/jfnxuOI/
05APy59jNxDyYfl1Wl/G89yYf7fcww1BPiw/z84Xy99n719rT+9fY36f9pPC
8yz/730sxwz5sPoArVcBzuoH7+c4GSMfVl+g9SHAWf2B+ivAu7bZtQ/rE7Q+
BDirX9D6B+CsvkH1KeCs/kHrzzBm9ZGxWBeG51n9hNar0F401lcYH1Z/ofUh
pSDVZxgfVr+h9SHAWX2H8WH1HxoPwZjVh5g9ZfUjWh9CvLG+5Dv8aAXuH6s/
0foQ4Kw+pT6u4g3yZfUrxofVt8ZdKNen9qCx/sX4sPoYjb9hzOpniVfuauJ8
rL5G60OAs/objTcBZ/U5Wh8CnNXvaP4e729jfY/WqwDfi4FQMCHUjgLO6oOM
D6sfFoZ6NcP5WH0R20ZwPlZ/pP3YgLP6JI2LAGf1S8aH1TeLsiZ9Qj6s/knr
VeiPGuujTD+w+injw+qrFx2idHA+Vn9l9pLVZxkfVr/F64jzsfoujRMBZ/Vf
18Oz++H5YfVhms9Df9xYP9bGwAJwVl9mfFj9mdZb0D831qcHn41si3xY/dqF
PGlAnNW3N3bZMgT5sPr3BWyYApzVx2l+WSlI9XPGh9XXmT5g9XfGh9XnaX8L
jFn9XtxxbAryYfV9+ruAs/r//KdXhyMf1h+QdKSkL/Jh/QPM37L+AqqLiSD1
H9D6BeCsP4H2o6EebOxfoHEjjFl/A40L4XnW/0DrY+j/G/sjmL9g/ROTdLb5
Ix/WX0HzIYCz/gvGh/VnMD3C+jdofzWMWX8H7beB51n/B+1/Qn/Y2B9C+20A
Z/0jtN8GcNZfUo46C3DWf+Jk8ugi8mH9KUkLt0QjH9a/QuslgLP+FmbvWP8L
rX/B86w/5vb4ty+QD+ufoboEcNZfQ/ttAGf9N0mR1m+QD+vPYf6d9e/Qfhu8
X439PbRPC+15Y/8P07OsP4jGuegPG/uHarZdcMP1s/4i2m8DOOs/ov02gLP+
JPr3N3gfGvuXaF5IKUj9Tex8sP4nGqdgfNDYH0XzIvA865+i+SXAWX8V9UPo
vxv7rx58PHYM+bD+rD9us24hH9a/xb4H6++i/S2As/4vZl9ZfxhOq8bs52OF
ZO9ZfxmWC5EP6z9j/pD1p9G/DwCc9a+NeKWnxPlYfxv7Hqz/jek/1h/H9DHr
n6N9nYCz/joa5wLO+u9o/Rhw1p9H8yaotxr792heA3DW38f0FOv/o/EhnsfG
/kCm11n/IIsfWH8hrccCzvoPmb9j/YlzWkZ/RD6sf5HpAdbfSPN2gLP+R9r/
C2PWH/m13YgJOB/rn2TxFeuvDNJ8sxDnY/2XU94GDcT5WH8m/nkArn/r9vJW
2L/J1s/6O5cbv7uCfFj/Z7Be85e4ftYfyvQt6x+tqN2nifOx/tL//fu3/wOG
f6KJ
      "], {{-87.425843, 34.799956}, {-87.393954, 34.801566}, {-87.382781, 
      34.803467999999995`}, {-87.38348599999999, 
      34.816179}, {-87.38460099999999, 34.815716}, {-87.38906399999999, 
      34.814319999999995`}, {-87.410326, 34.813249}, {-87.425958, 
      34.809492999999996`}, {-87.436089, 34.813953999999995`}, {-87.451871, 
      34.822455999999995`}, {-87.46873, 34.827313}, {-87.490619, 
      34.831216999999995`}, {-87.513667, 34.837832999999996`}, {-87.52942, 
      34.843145}, {-87.54456499999999, 34.844828}, {-87.55517499999999, 
      34.842462}, {-87.56237999999999, 34.836946999999995`}, {-87.576284, 
      34.830008}, {-87.58582899999999, 34.831736}, {-87.598604, 
      34.824351}, {-87.609177, 34.81971}, {-87.617449, 
      34.811001999999995`}, {-87.626346, 34.806829}, {-87.629138, 
      34.806348}, {-87.625074, 34.796395}, {-87.62284199999999, 
      34.796870999999996`}, {-87.59889199999999, 
      34.805273}, {-87.59111999999999, 34.809886999999996`}, {-87.586782, 
      34.819919}, {-87.56894899999999, 34.825987999999995`}, {-87.555511, 
      34.826108999999995`}, {-87.546054, 34.830736}, {-87.533163, 
      34.829941999999996`}, {-87.528714, 34.832252}, {-87.52311999999999, 
      34.832755}, {-87.513571, 34.830566999999995`}, {-87.508997, 
      34.82334}, {-87.499437, 34.820243}, {-87.49100399999999, 
      34.817589999999996`}, {-87.486485, 34.814448999999996`}, {-87.451143, 
      34.808837}, {-87.434854, 34.804426}, {-87.425843, 
      34.799956}}, CompressedData["
1:eJxd1ns4VPkfB/BhN0kupVWtojZUyiKVJOocJKVZwhGR62CkFolkcytJxLon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      "], CompressedData["
1:eJxd2Xc4lm8bB3AqycymEipkJJWd8Nwl2TIeiciIQkkZ2SuUERJKMpNkVFbl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      "], CompressedData["
1:eJxd1nk0VlsfB3CKEmmikAqFJDQoXJVnn4xJxntM1UOG6KqIMjz0UCoq8yMz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      "], CompressedData["
1:eJxN2Xc8V98fB3BUVknZGnZWQtkSn49d2fWJZJQRWVkhhMhW2SUSIg2jzCT6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      "], CompressedData["
1:eJxd1ns0VdseB3CPi1RSiVNSKCWx81YSzVkJR6TDCp1oe4fosck7kkfpEnrg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      "], CompressedData["
1:eJxd1n04lFkfB/Bh5SpSXpuWWkRbk7ewxSIzswmD0OaW0lY8iKVNg1Z5jZW3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      "], CompressedData["
1:eJxd1n881HccB3DpRMn5NaumH661+TlnTBPSnTE/c/pxREnkNyVqW8RE5/dJ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      "], {{-87.52954799999999, 34.559258}, {-87.52909799999999, 
      34.567439}, {-87.60837099999999, 34.568985}, {-87.95173799999999, 
      34.575213999999995`}, {-88.140549, 34.5818}, {-88.153617, 
      34.488020999999996`}, {-88.171026, 34.338727}, {-88.173435, 
      34.321422999999996`}, {-87.939606, 34.313190999999996`}, {-87.922356, 
      34.312948}, {-87.9001, 34.312764}, {-87.856138, 
      34.311921999999996`}, {-87.786593, 34.311347999999995`}, {-87.767668, 
      34.310646999999996`}, {-87.691437, 
      34.309180999999995`}, {-87.67808199999999, 34.308862}, {-87.676468, 
      34.312514}, {-87.67271199999999, 
      34.321639999999995`}, {-87.66444299999999, 
      34.326722}, {-87.65453199999999, 34.333636999999996`}, {-87.650731, 
      34.340036999999995`}, {-87.648607, 34.346874}, {-87.642955, 
      34.341021999999995`}, {-87.644531, 34.334645}, {-87.655529, 
      34.325902}, {-87.66596899999999, 34.317164}, {-87.669231, 
      34.312132999999996`}, {-87.670289, 34.308487}, {-87.634667, 
      34.307021999999996`}, {-87.631331, 34.307054}, {-87.62576899999999, 
      34.307108}, {-87.546751, 34.304665}, {-87.54861, 
      34.442327999999996`}, {-87.530782, 34.442487}, {-87.530006, 
      34.467937}, {-87.52932, 34.5002}, {-87.52998, 34.507918}, {-87.529707, 
      34.529272999999996`}, {-87.529354, 34.544722}, {-87.52954799999999, 
      34.559258}}, {{-87.976828, 34.456770999999996`}, {-87.969295, 
      34.470952}, {-87.96426199999999, 34.470107}, {-87.95807099999999, 
      34.467003999999996`}, {-87.950261, 34.466647}, {-87.944165, 
      34.46854}, {-87.936396, 34.470453}, {-87.92806999999999, 
      34.472373}, {-87.926897, 34.469207}, {-87.928527, 
      34.466915}, {-87.930165, 34.465078}, {-87.934598, 
      34.46366}, {-87.938457, 34.461341}, {-87.943421, 
      34.458553}, {-87.945574, 34.454437}, {-87.942695, 
      34.449475}, {-87.93871899999999, 34.445434999999996`}, {-87.931975, 
      34.442337}, {-87.926378, 34.441041999999996`}, {-87.921348, 
      34.440194999999996`}, {-87.918504, 34.437049}, {-87.916176, 
      34.431625}, {-87.916151, 34.430262}, {-87.909975, 
      34.427611}, {-87.906624, 34.427197}, {-87.902709, 
      34.426335}, {-87.899326, 34.424104}, {-87.898122, 
      34.41912}, {-87.890768, 34.412847}, {-87.889597, 34.40968}, {-87.893487,
       34.409179}, {-87.896271, 34.409146}, {-87.899637, 
      34.410469}, {-87.90526299999999, 34.413582}, {-87.91258599999999, 
      34.418037}, {-87.92100599999999, 34.421569999999996`}, {-87.927191, 
      34.424675}, {-87.933984, 34.430498}, {-87.94299, 
      34.435385}, {-87.949776, 34.440754}, {-87.956015, 
      34.446583}, {-87.96336099999999, 34.451943}, {-87.971222, 
      34.455025}, {-87.97514799999999, 34.456337999999995`}, {-87.976828, 
      34.456770999999996`}}, {{-87.84848699999999, 
      34.511939999999996`}, {-87.847803, 34.504678}, {-87.857258, 
      34.503206}, {-87.864634, 34.510388999999996`}, {-87.868569, 
      34.51216}, {-87.875301, 34.514353}, {-87.886979, 
      34.512397}, {-87.89544099999999, 34.517748}, {-87.899271, 
      34.513613}, {-87.89921299999999, 34.510434}, {-87.907185, 
      34.519425}, {-87.914434, 34.519337}, {-87.922799, 
      34.519235}, {-87.923232, 34.512415}, {-87.927269, 
      34.519635}, {-87.935693, 34.522712}, {-87.93803299999999, 
      34.528589}, {-87.946382, 34.527577}, {-87.954859, 
      34.533378}, {-87.964238, 34.527809}, {-87.964838, 
      34.530073}, {-87.97004799999999, 34.540003}, {-87.964659, 
      34.550066}, {-87.956248, 34.547899}, {-87.957819, 
      34.542428}, {-87.949451, 34.542532}, {-87.94547899999999, 
      34.538947}, {-87.93717099999999, 34.542229999999996`}, {-87.938785, 
      34.53903}, {-87.930418, 34.539131999999995`}, {-87.92304999999999, 
      34.532862}, {-87.918688, 34.538367}, {-87.921568, 
      34.54333}, {-87.91444899999999, 34.550685}, {-87.910685, 
      34.558454}, {-87.89343799999999, 34.561386999999996`}, {-87.89617, 
      34.558174}, {-87.90005099999999, 34.556765}, {-87.909937, 
      34.548013999999995`}, {-87.911469, 34.540272}, {-87.914683, 
      34.532964}, {-87.90907299999999, 34.531214}, {-87.904594, 
      34.53036}, {-87.902872, 34.527654}, {-87.899033, 
      34.531335}, {-87.90006699999999, 34.526779}, {-87.897795, 
      34.524535}, {-87.88607499999999, 34.524221}, {-87.880417, 
      34.519743999999996`}, {-87.87489699999999, 34.52299}, {-87.86873, 
      34.521245}, {-87.865878, 34.517644}, {-87.85920999999999, 
      34.519085}, {-87.85525, 34.51595}, {-87.85516299999999, 
      34.510954}, {-87.85178499999999, 34.509176}, {-87.84848699999999, 
      34.511939999999996`}}, CompressedData["
1:eJxd13k4VVsfB3DTlTJGqptEpeGUhITorb0lIkOqTXGODOGWJCI3YyKk06AM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      "], CompressedData["
1:eJxd1HtUk3UYB/DNiKZBMAhKxRYKjSEooMgkL+87qJRgIvpzBHESEEsQap4W
BmdAaDJFTDoTEDGWg6NwQrscPSci+gUeYCNF3LjDjE0PF0VuUlyC+u7f/njP
ez7n+d2e5/e8r3vCx1FJyzgcjgSP9U0vPOnmNRO6djAz+4QPyyz610QkthDq
Hfx1azZs0jtdToInPrKobm5gmXVdEaIbGB/a21R+DZ6yaZD+APPM28qoH8uE
N07w/TE+1jPa7S68+UOl3urvlniNOf4sk5AT6uylI3ScrHfOgke50+dFcCGv
4KAlgGXOPCo6EPIHoRot8R2BY94hzqHwJyMl02c3scyT5Cl1xx1ClcO580Ww
a4DM1mpuz+MBAfzwF3XtIQOcF1l5GLacydceg6MX+ae4Qdi/vo6zYCR0tSjW
Y2wLyxy1MSsW4VcOCi7XillmoidY3N1JaJZpf0UDXJq5a9YEhz4Y0Dth/jFt
S0xIF6EVq+P38uHsFGGYBG6/LtHvwXq+L2RcS+0n1JiFAOw2mh6fAn8vLpvr
2MwyOwRJt59/QOiv8qiSv+GSvPA5RzjD9eTUDox/c9BTPANPFbvO7Iaf7X37
fc6fhG6o6k3LxX7jDw2JsYOEMtISv1JY/lWlQxw8fPIeW4zzFhgcySzcP/3P
ES38eOuI0gLnrVy1x0bIMsG2h26kY/3jF25GTL7BMm3lW6oNcKDyM6pAfFst
39UF+3Hr++rkXiyT76pJDYRlAgdl+nrkf8p8LggWbgzg/ob+aFqQLzzCfKnx
fv8KX5aR1YTPVsJCrd7vKeJnRdGWo/Cdof6xDMzv8Dgesgre19o5vxbOc0mb
22Ui1KF9+KUE+Hz309c0A4RKrht/eh39lZ8a1R4Nn47r6/PdyDIppellV+Ct
xebqH+GhharJ+6jvvawKlR36yVrO/bBzqUeRGn5uJMEQ1kfo4WSnOndYp7td
k9uL/H53227tv/RLQdIVPYQ2J9p6W7Beq4jrvxye+WvoirvVU4qVS92EujR/
IWtFfmsKx6NG4W8+UGus+Rs9La/q4KW2+Po61Cs2TrpcBU837Y43oZ6KNdUi
HfrjxZ3i8mDELwq7Xm6Bjxy45fA54tqCdZ1muNrOkuYIV/7s0pCM+UWKf6NV
uJ9hzbviZ4jzOOe2Z8Jynfzqp7D96UwfJXzxLa9bue2E5tirHGXW+wyLmbRv
I7QrJSMyEjZ6z4dsuov7tRPw98FjPhlXl1m/V0Wh5D1YHVD1rT385c7GS4E4
3///B/8BJ2v1eA==
      "], CompressedData["
1:eJxd13lYTtvbB3BFijRroqKRNKkUHTrWflJJGsgOmSqhiYMGFFEpnQxJEyGp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      "], CompressedData["
1:eJxd1Xk81ekeB3CdGuHaSZZTllEqQymFNHqOGiWpKX4Y5TBSriyFmy2UNqdw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      "], {{-87.273603, 34.299532}, {-87.366495, 34.300695}, {-87.374281, 
      34.300636}, {-87.38151599999999, 34.301035999999996`}, {-87.391505, 
      34.299141999999996`}, {-87.395849, 34.290020999999996`}, {-87.399154, 
      34.287269}, {-87.433666, 34.290178}, {-87.443642, 
      34.287369999999996`}, {-87.46034499999999, 
      34.289051}, {-87.46657499999999, 34.298088}, {-87.47498999999999, 
      34.303926}, {-87.49168, 34.304238999999995`}, {-87.52951, 
      34.304819}, {-87.546751, 34.304665}, {-87.546224, 
      34.265589}, {-87.477824, 34.263912}, {-87.48059099999999, 
      34.218897}, {-87.427793, 34.217513}, {-87.428439, 
      34.132064}, {-87.49838199999999, 34.133300999999996`}, {-87.497806, 
      34.045125}, {-87.429052, 34.043879}, {-87.428483, 
      33.996153}, {-87.235678, 33.99481}, {-87.23235, 33.994377}, {-87.222929,
       33.993981999999995`}, {-87.21683499999999, 33.994019}, {-87.207381, 
      33.989986}, {-87.207431, 33.995441}, {-87.207054, 
      34.01499}, {-87.207145, 34.024989999999995`}, {-87.205523, 
      34.213167999999996`}, {-87.11050499999999, 34.210525}, {-87.110619, 
      34.225066999999996`}, {-87.110264, 34.250516999999995`}, {-87.109858, 
      34.269605}, {-87.109537, 34.299599}, {-87.221879, 
      34.29941}, {-87.235226, 34.299326}, {-87.273603, 
      34.299532}}, {{-87.38151599999999, 34.301035999999996`}, {-87.408221, 
      34.301739999999995`}, {-87.433819, 34.3029}, {-87.438824, 
      34.302859999999995`}, {-87.468867, 34.303522}, {-87.47498999999999, 
      34.303926}, {-87.46657499999999, 34.298088}, {-87.46034499999999, 
      34.289051}, {-87.443642, 34.287369999999996`}, {-87.433666, 
      34.290178}, {-87.399154, 34.287269}, {-87.395849, 
      34.290020999999996`}, {-87.391505, 
      34.299141999999996`}, {-87.38151599999999, 
      34.301035999999996`}}, {{-87.52951, 34.304819}, {-87.530782, 
      34.442487}, {-87.54861, 34.442327999999996`}, {-87.546751, 
      34.304665}, {-87.52951, 34.304819}}, {{-87.546751, 
      34.304665}, {-87.62576899999999, 34.307108}, {-87.631331, 
      34.307054}, {-87.634667, 34.307021999999996`}, {-87.63486499999999, 
      34.28248}, {-87.634666, 34.268848999999996`}, {-87.63453299999999, 
      34.259761}, {-87.634208, 34.237496}, {-87.63416199999999, 
      34.234314999999995`}, {-87.63412799999999, 
      34.232043}, {-87.63405499999999, 34.227045}, {-87.634016, 
      34.224318}, {-87.633949, 34.219774}, {-87.634299, 
      34.205681999999996`}, {-87.634596, 34.187954}, {-87.635598, 
      34.142494}, {-87.636483, 34.127030999999995`}, {-87.636397, 
      34.121123}, {-87.63658, 34.095667}, {-87.636454, 
      34.087032}, {-87.63632799999999, 34.078396999999995`}, {-87.635672, 
      34.033401}, {-87.635775, 34.002488}, {-87.573697, 34.000807}, {-87.4994,
       33.996472}, {-87.428483, 33.996153}, {-87.429052, 
      34.043879}, {-87.497806, 34.045125}, {-87.49838199999999, 
      34.133300999999996`}, {-87.428439, 34.132064}, {-87.427793, 
      34.217513}, {-87.48059099999999, 34.218897}, {-87.477824, 
      34.263912}, {-87.546224, 34.265589}, {-87.546751, 
      34.304665}}, CompressedData["
1:eJxd1Xs0VVkcB3CP0lQek5RLF4lkiCZNJGFvr5hbFE6llNuVRyLl/ejlUSGp
iSYSmkrCYpTSw6VDQxSptEoyJRUlNMX1SK75mtVfc9Y666zPOnvv8/v9zu/s
oykIdPaSkpCQ8MY5cTVzeS+s3cawyQ77Fx00p8T2kytrDk/qCB2LhQc/RDQQ
OP4f3zcJZpTUnTD9PRwuiourSIQVPitsioIvr7ptIzSl5GuzXehyOMyxlJTD
Q2p3PC3hlm1HoxKMKdEpuC5TBssGKW9NggcOjdYVwatXKQtESynZEWOu4+zF
sMp97pwP8Jf3dhtc4YG8o90hv1ByZmh8dzXMffDNTx42fazCifRmWI7l0ej+
JZT4/HB3YTQclqxvmGJESY76C6N22GxZSyYHTmM7uSt8GLZyYLDr3GJKlDZI
uMjAJ099cxL/TMnmRCJSgA1VjdRz4Vq//vECuK5nYVQerFf4Ieoc7D7Wom0J
0+zNlSJYp6OoP3ARJa2uf2tl+jLsEU4YJ9WQkpujXA2D7Qz7eeBXt0Pw/OOK
5WXbv8drQAk3cu4Vez/UM0dc2gn/9f7mwWLY6IS5VeNCSsoy2zMvwrxU54e9
+pQsWRWQHwePHCA+j/VQn1S/nBRYdW3rnD0/UeLbeOz2VVhy9ojIWhfrabvX
ae1gWK3nWk9kF1CS+4edZj0csldDXlGHkja9hJhiuOO43IUj8ykRPBsM48EB
pqc6CrQpifA4Of0kXJiW/WE+HCBhPNfKn2HfbeGv04Wr1n7p5sLipq2VQtj7
WcWsxIn7p6UysrCe8r5dFqHwgavjkk/xPF3PPekVWK9JyA17hXgybumX8+GY
rpd35iP+TwVTGqzhJKm985yQX/B+0Y1AWEN/OCAB+Qcb1jBeuxl2ecMpZb4m
JT2rZevrd3+fD8/JVMuvDGbYN206bfqwgZYo+x5cu8bxaqE6JXLVbX3vYJXC
xvEJNy2cusYlhGGf8FUPHYNdrpyJfwyr+imdaICv5NQ4a4cy7OGZ6Y4f4Typ
vkgxPN0qUmOlBvotGh0Md8tME6aq4P1zu4xfw/bVlVk2PyKfIzymFXb5OGZn
Jk+J2dhZQ2e4d2/BNDl4hgQ3ehDxrNsWQhQxfpm8cGNfEPovyGl9OGzRKS2V
BY8MqSjLw4tLmzzT4Ipkwc1cBUp4c+R50hP5JlwbVsJ6vK47pZNgV7WgJW2y
lFzgzH00aRfi+03m+jVJfJ9l/HzDQIZNOR6zolxMSPyAkqkN7MaT3D4+Ssh6
i/v97VsR/+rydO+vhHyJzhT3wImpo2pJw4SsMlb3v+zBsM2z/LWyYTot26oY
Fjn0lSRifPGNZXommxh2GOHGw3czdPwtYZ1kb69ROHkwQlNtI+pn/XZABLfo
fjSZCdt69n7yx/OdMwTysW4M21Vtv8gPniMQdjK4f/uhll2TNCXPRq7f3+eO
77+0x4GPevcuQEPBKsecpzqpoj5U7lU1/GfDplA1LiV2aYMyHojPdEvMewfs
J2+HjMee8xm2M2LyuQXW6KcZrxLdkN9/fQW323rQ03CzkqTjJytK3EbNXpyH
U+btkMuFYzqD+8Lgjf1vFhnAAgOLySy80vXSTkP4fNfsW4oChnW6r+D+jlKS
VFeSZALvrqlZexMO/nzdnMKtd7bo8mFuSWG9C/y8a/G9JXDNzhzGG84/7Bsy
BbY5b5aQBTc24CDo16dVVS9h1+qZUWOWlHhMjwqU9WTYFd5njcTwrbiWDCuY
H/rW3gfjxdoW4bFwT2zV0nDYhNNdUg1fqI1P58FlN2p9rsBrW2wfSWP+xHb1
AH7dfEZYZ4H5GXQPH/tznrSbUxEsiFWtPAg/vsTWG8PYhS52w+5i66+9+F/8
/3/yL5o07PM=
      "], {{-85.53009, 33.941714999999995`}, {-85.53166499999999, 
      33.903993}, {-85.532404, 33.888996}, {-85.47653799999999, 
      33.888059999999996`}, {-85.480063, 33.787605}, {-85.512659, 
      33.787887999999995`}, {-85.516885, 33.671507999999996`}, {-85.599638, 
      33.671729}, {-85.603921, 33.586712999999996`}, {-85.63974999999999, 
      33.586076999999996`}, {-85.643489, 33.496041999999996`}, {-85.564233, 
      33.494969}, {-85.553776, 33.494884}, {-85.531759, 33.4947}, {-85.516898,
       33.494574}, {-85.4679, 33.495055}, {-85.352886, 
      33.492599999999996`}, {-85.351771, 33.493499}, {-85.35443699999999, 
      33.499438999999995`}, {-85.35000699999999, 
      33.501215}, {-85.34669799999999, 33.501636}, {-85.343469, 
      33.4966}, {-85.33362199999999, 33.492405999999995`}, {-85.322119, 
      33.48865}, {-85.314421, 33.488116}, {-85.307913, 33.48168}, {-85.305148,
       33.482561}, {-85.33635799999999, 33.642084}, {-85.37380999999999, 
      33.837545}, {-85.398563, 33.964178}, {-85.407423, 
      33.964262}, {-85.408028, 33.960631}, {-85.42574599999999, 
      33.960797}, {-85.425242, 33.957155}, {-85.49501099999999, 
      33.957327}, {-85.495204, 33.942326}, {-85.53009, 
      33.941714999999995`}}, CompressedData["
1:eJxd1Xs01VkbB3CXQRklR0WEqOgyqUZFM731kCOlGUm/Moko5C4kUk6TS26x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      "], {{-85.898656, 33.672312}, {-85.915714, 
      33.678312}, {-85.93383899999999, 33.689772}, {-86.023769, 
      33.692451999999996`}, {-86.022857, 33.751564}, {-85.899166, 
      33.749621999999995`}, {-85.89129, 33.697286}, {-85.898656, 
      33.672312}}, CompressedData["
1:eJxd1H001XccB/DroTxHil2Op+sS1UzlYViu76+sFjFdftg8ZMpdTskW7bbk
uOIuKyRPd4g01jnzlCGax5+zWwet6DTGlblluCWH5ekYs73vv/vjd37ndX7f
7+/z8P2cLyc6nh+jymKxfPEo33GuwdFlCpoR5zmnHLWjSKFwUG3qNc38YZEu
ugQfPz7D587QTL3HuUqnHRTxOtt1qQH+OD/dW2ZDkZcWvpatcJ+09jIbPmjR
nZUPO+3riUjnUsRhmh9Ow2yF7J0BuDpRWKoHa0Q6CAVYH+VRO1qOeM1lHLNG
WN11Wl4E/ykL2PvEliLSRnUTFfinOw32bxB/t/89Y8ErmpHrxQbJ4QCXiy4E
tu1NSLaEZS/u9prCBn1rbsXY/2h44PEG6oszHT1Nwaad4vMTcMLvhm+Vbkoo
3iSDVTLaLhrBn/w9sGkJHmInHlAgn451/zwT/I+k3z+3DH+uo1l7BU7bvl8c
jvVDcQFrtfB2ru9UKOKr8bwyDZBvb657oRDfT9bpVunBad0uwkXUH8KZtBuE
2+tdwr6Gh/VGjWPQD7H2FscMa4oUlcR7r8Cmfu89ZGC5oSjF5w3NnFLckkdj
/VCQsTgCLiu0vN8Ha9T33LWEf7h9iNOL/L6YOVv2Gvs/1BloVtZfkZ1dfQO2
/SouvgX5CUQ6Dcp425J5fRk434rrqyKC/U0PXHh58MS15Qucv2hm7FfF4V/g
xzm7roa8pRnBEJ/IYPcWrZW+ZZrJTYjWn4V9ezQ8S1YxL3WSO5r2FPF8ev6F
xhrN3Kph122BN3/knGq9TjMxTlcqjeFBnvl1E51ghi/JPGGzE/WlqqTr6wYz
VrMpontsijz7ntdrrhfMeHB9ktI0KFIunfavZwUzj066lfVvpshcIH3K6l+a
sZc8dGyHqyTjsfvgPalhwgVVirRFOPpt/YdmUhVHin6DJQ+kUxOIvzE40TkI
d2fuDFU6NEfwbjHcNe+TOw0f82+qzmFh/jbmF8bhE0kOio4lQlaqCrS6UO9u
Px+qBTZrCrHUX6AZdKGdho0SDBKb0B/RwktpCLymoq9rNUczKVudBYZw8v7F
sVrM02zp02BbmG9X/m09vBgw+s0xxFN03hypg2sCJ5MOqVPk+Wfbin6Go7Ia
X2lqU4Qry/6xDfaTBY1xdSgSy9du7YDd7ZYHeLoU+fJGUmsrnD0ZsSTSx/lH
7OW2K+fZ52DWAQPM/8gHFcr49vP+PE9Dimhdu+pWCqfmxcm3oN81boOffgeb
1Vf3BppShFfwrCwXPkPNZXHMKKJ6ZLglD25dkCY0w1HvnwnLh52ei/r1zSlS
EFmSVQCrWUsLGuHTElezQnjXWp3mBmzTsmNMaVvhsLfAgiKTT47uuQmHTziN
eHEoIr5gE6m8f1YPj1fGYt5Z7P7y27DRxLqfPeb5//fTfw+3OYo=
      "], CompressedData["
1:eJxd12k4VlsbB/CUQo5MEYUQDYQilXPynrUfIckQbaUyJMnUYKw0UiTJkFmR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      "], {{-87.635612, 33.915202}, {-87.73633099999999, 
      33.914623999999996`}, {-87.792264, 33.916741}, {-87.797798, 
      33.916678999999995`}, {-87.85540999999999, 33.919655}, {-87.951169, 
      33.919858}, {-87.952, 33.875288999999995`}, {-87.949877, 
      33.790738}, {-87.94985199999999, 33.789373999999995`}, {-87.946015, 
      33.641615}, {-87.946056, 33.524257999999996`}, {-87.840334, 
      33.525084}, {-87.743327, 33.519804}, {-87.68057499999999, 
      33.521375}, {-87.66626, 33.521521}, {-87.666581, 
      33.580197}, {-87.631875, 33.580998}, {-87.631192, 
      33.610115}, {-87.56003, 33.606698}, {-87.423819, 
      33.602413}, {-87.423188, 33.689285}, {-87.52808, 
      33.692491}, {-87.53149499999999, 33.867984}, {-87.610624, 
      33.870433}, {-87.63609699999999, 33.872459}, {-87.635612, 
      33.915202}}, CompressedData["
1:eJxd13k0V1sbB3DDWyLl0k2GCJeiCYWk6MmVIQ0vOV1lLE26MkWhWRKKSuYh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      "], {{-85.651268, 33.642105}, {-85.651313, 
      33.638011999999996`}, {-85.655172, 33.63804}, {-85.655256, 
      33.630309}, {-85.65529, 33.627126}, {-85.68561, 
      33.627798999999996`}, {-85.690016, 33.628285}, {-85.690129, 
      33.61737}, {-85.690175, 33.612822}, {-85.71607999999999, 
      33.613456}, {-85.72489499999999, 33.613971}, {-85.72443899999999, 
      33.604417}, {-85.724488, 33.599413999999996`}, {-85.73771099999999, 
      33.599956999999996`}, {-85.742116, 33.600441}, {-85.74229199999999, 
      33.582249}, {-85.744199, 33.555881}, {-85.795976, 
      33.556664}, {-85.796657, 33.542113}, {-85.85154299999999, 
      33.498768}, {-85.85215, 33.491948}, {-85.869216, 
      33.491588}, {-85.869333, 33.477032}, {-85.887497, 
      33.476675}, {-85.887553, 33.469397}, {-85.78245199999999, 
      33.469243999999996`}, {-85.782319, 33.483799999999995`}, {-85.765258, 
      33.483692}, {-85.765664, 33.499161}, {-85.688064, 
      33.497275}, {-85.643489, 33.496041999999996`}, {-85.63974999999999, 
      33.586076999999996`}, {-85.603921, 33.586712999999996`}, {-85.599638, 
      33.671729}, {-85.516885, 33.671507999999996`}, {-85.512659, 
      33.787887999999995`}, {-85.480063, 33.787605}, {-85.47653799999999, 
      33.888059999999996`}, {-85.532404, 33.888996}, {-85.601548, 
      33.890008}, {-85.601721, 33.875006}, {-85.637114, 
      33.87573}, {-85.636882, 33.84663}, {-85.592098, 
      33.846287}, {-85.58546899999999, 33.84578}, {-85.585979, 
      33.802133}, {-85.60310899999999, 33.802268}, {-85.60327099999999, 
      33.788173}, {-85.620955, 33.787853999999996`}, {-85.62111399999999, 
      33.773759}, {-85.63768999999999, 33.77343}, {-85.638626, 
      33.688399}, {-85.637963, 33.648373}, {-85.646782, 
      33.648894}, {-85.646861, 33.641617}, {-85.651268, 
      33.642105}}, CompressedData["
1:eJxd13k41ksbB3AqSQkpERFF0inLsZzKNkTWNvXrIEpPkSQheoWQfafHTkKW
kiLaUPLj4NhDIluSw0nhINSx5P0+Xe9f7x8u18eMmXlm7rnveSQYl02sl7Gx
sdXjh/U7ujT1+pAzRetFGxZm1hESTwxHu2Fh/m+mc/WEjOwXbH9+naK9wksu
cjUQsko9hUrzpuh+u9TizfCErOBkKszz0ny8sZGQgEfCRqY3KPpWsNelRdi1
PlPkDMxx9Bu7fhMhq2VPtFvBYgruDhlwnO4ZQV3YWWFlh1MzIdx/C9vYwtqP
7p/yek2IYNuARDicJSTeuqKFEK2OY3kF8IMa/o4aWFR4Y2Y+PPliJF60jZCl
uLjt2TDf560BRXCn3Lu1PSxv89cTeUNIlQb7hm2+FN3ynMPIFbZvrlDMgA30
sy4twCv9Lo5/gtvbi56+aickfY7zJrcfRYdeaW91ekvIHtsCDTF49cz0uu8w
L7FbLw1fKbuUo91ByMUSxfXcgRQ922ybx4SzgjLe1sE7DsQ3FsLum6qdjUIo
+qDfnWtsnYRM6r9US4WbHZdraKJ9KCnhj3FYdUBqzwzGrze+sLg7lKJ9tNWv
r0D7TKmu1QOYXbG/4jDs57/jdAuc93noP8nwAY+X0TxhFH11Tssy6x0hY6uv
PwqHh2N9Ev27CDlYUvnCIpyiLx2/u9wM9lXZ69kGG6zbdGIS/X1FZE5KRlD0
GRX2wCGs76o8I40NRjS0cMAbbTJS36B/ru9Rg1TM1+5e3hqJ8W1SJ6+z9ueT
bMjjrfD7317NNmL/dg5wlf3A+h6PGlhdgTnsObfNwtxMjYd3sN+MjrCMW7CR
2OEGXpzX12iZLb6w6ny93zTOd91cknsfPPZEeasQ4mFM94noMYyfzPpgiBct
q6GWrViP7WfXMBrueelkkgiX2ta6xcKvrA8lVMOzXOlCZvBC0HRPJ7wQcbV3
AvE3Ox717T68T7TW3Q7uskzPojF+JusPiN8XOjMdLO8xqnPmh00Sws9Kon9m
LN+D+4j/e0oMmzTsj3Ji4MA2tM/pcs2tiaToQ20LCg/RLpF3Ul0almxT+aED
W7AHuM+h/0XufRIuuF/7zN8yI+EvR4vFAnD/iniLdiXChh5+csa1hDyY/1Pb
BW4S13g0+CchLhYRo4aYX7Pa6cPbGkISHD/tFoM5Yz4OrodDl1TvaMPD6s1K
Z6oJSTrdxO4LO6TTqv9WEfI61WrJFeN1KuQX74H1Il1WHsD6rvhYRYr9QUjd
8P1rkfDTbJ4p90pCnD7miVbDetVLokcrcP788qUv4XF1C+feckKknCs2LcCK
oUPxJ+DxhqSx1dEULVpAprNe4Xz1D213gE+PeLrFw8kjp6Rn4AsfRT8YoL/+
BvOORfjXWkt/GZoQzbBs/VfwQkh9oDLmY7eNlWW1K8R5VXbBcpmmDhduUnTN
+zC5btghUGTiX7hfaJnPWVhU5IabJZOiZUbO2LpivLPajVIUXHGsNs4d86f3
SVSzxVA0b3xhRkoZIQYp9z3OwYH5OulzLwih5MrfsLzRL+hCfynu+7sUISb8
7fghD0P4s4v4l9xYxNd5y8yhYpwf+0H/tXEUHRUsc1PnOSGco3ZTsfDzpuPB
es+w3/7bQ6Tika9M3HMSnhASFtL051N4MDulShzuEDYc003Afts/lOOH5Q2s
Q/cmUvSxWKNBwSJCSv3eJWnDvW12+r2FhDTs0i4UgNdoX9uiB+/BNWNivJqs
8oTKAkK+HDlo0IH5aY6uIs+HhOwmPXYsK4YdseeA2aprmXvRv6Of38f7ASG3
Fjam7sL882xZKk7w08rpskBYYuTNzrk8Qh45Moej4IbUJKs98NUqCRF9OE09
IdfgPiG7vp6wDIIXbRilfLlYn3XmFS940lvv+L17hJQXH8/eDdtq/O3QeZeQ
DSe13vDDGd6+YQJw3JQ5Vx/WM1ISkK+Tg/PaflTuO/z0X++3N7MJEZL6JDeN
/l0cSMxZmO+Xg4ZaSRQdOVxbL5dJiGLgXq0UuPvuoMJymHf0uxxfMkVvcoxn
Dt0hpHd3HfsLmEPwFzt5tHcv7qT/k0LRCUIN00YYT1og4mk5HDf5j6IsnMx8
8EcrPFj1u2oo+g9WV/LthWOqmM7fMghJnGHskIaZBStMGPDF4lp1S9jHOttA
Jp0QM2N7jXw4N3DxtmkaIa2m86o98Omt7/ct3SbE+LK3rPAtiracX+Y+AK+K
sBqcg2U0NCRU0d/h4prXRqmI95F/sifQziFAlbfBg4pdmodTUc8EFCt7YCXZ
zavqbhGSw725hdVeGCDOKQUjqhdvwPL/OOVwpRAimUzWhcE205kDsUmoR1X5
Y2Ow6fDDUh74/HahZuXbOF+fx7G7YDGHoMBquPxWV34L3JggaLUljaIHpHnS
++HDje4KsfApb/40VXiih29QOZ2iPZ/x8MzGo55ZhfVpwI6vv96NgJexCiWs
dE7NUAreov9+L+v/RfNib4/EEUIEfnNQgB2yO23Owj//jvmLipdqXWKR77d/
z2E5626txEcm8uMM90AiLPddSVoOlh3+OzAHnydqcVf81puEPPweWHke5jnv
pcwZjfynu+OZL9w2X9N5O4qQ7Kmr/m/ghGhedxV4x3WJv15ivMZEX+XmSOQD
hkHJPKxofCnXD0aWdT6P9UUuL4hXjcD9VZrkmUA87t90n7ET9tQxDpFEfZDv
vMNhC6+rzIzYBt99ZKKli/HfmlZ2C8HxrkumwVjvfiHNCA+Yr0mtJAemG7hF
rJGfg+zFLe3hcU41eR9YnjdpSgIeFdjYy4t8XZN5vHI9bBxuPSeFfLvNZvZa
OFx3ubXOBG6YlbhcAv+cB55a5ZBlH4P+5TovXeHRoHdWA9jPYNl7l5Pgn/uE
/f6QZiJVH0XRn8346udxPk0Fw2wV8Ip9MSpUAiEpuXxRVehfM2ve4oHzPiIU
e0EJdnviVGWejPcZayKsb3xlq3krzAg4qcGEe0KY0fqIv13jmr+KwpWHN5Ny
2PXHWNFpfL7q4cHuI4hnz8Qye1VYWXK8cBqWWnkjbj8cpzOrFY/7sGP0zqcb
sL3FUv5r3K8JRQQ+xmv8ErxfBfeb4RcQowSrM6Z7tXFf+Qq+CI6iv5kiKgru
c5TweoYsvPbjctUfyCery35IauA9ERYYrpeL/MR6DrLeY1EDhWnVsO5UHDGE
V0+HqLHym8pSwT7nYOQ3WfumE/CzLtOQa3CaqKOlAvKpwbkt58yCEG9ywfoH
4Qn5sZR5f4rua341JY78/POdC7PS70H4ar+C2izei+msAgOvXCN94QfcVqVK
xyDfR+a39bnivWoxxOWfCn/Dtp+FOa+pJ254jPvB5vR7gQ/id6/lxvXwUl1/
WSZcKW9VR6HezGtsltTBe9yUVdDhbpcVjo+9cD/1IrgUUJ96O29cOQD3tS45
70b9YpUlIZjJnh4qUoJ8ssrRXRD+OS/q3ZFLjlvnPPEefnZmwwrUV5uuGHoY
bvws6hCE98FgkOE2G3d8PmWLv27DXtlfB8xg/Q+8mkt4f7xgHHDzcKNo6yW1
tUJ4n8jETfifcvvfeeM9k7+6nTGB7xs9FcHXl+G98//fR/4LnlMu1A==
      "], CompressedData["
1:eJxd1HtQ1FUUB3Ak4uUDjGcKBgFpM7GBD0pZlmOAAsrIMN0CAsFVSKaVRQhi
gQQC3OXNsPKSMVCQAWfkoYihIZcdIEEpMB2Th4Ia0/CKENcGjO2r01/98Zvf
fOae+Z17fufcayuWBkRoa2lpeeJ59a5/O8Drr1jG34s266afiBoN74rn4ZEu
xbfaN4neL5nPPJjI+A77uZZFrF8X70lMhiM0wrWWvUQnzj+bCEpi3HvcyF3T
Q/RE7msXCefuCHn6vYoo8oGST6YwfnvKOloO+x+LeXcJvtt2yFSni6hOPybJ
4gTjL4IHkw9fIwpIqiuzhItXVedsbCcavZ8etwceG9LEOv5ANPy1TsxlOGVv
voHzVaJlkZW9ZyrjgXFp4QVtRJq+Rx01aYyrnML7GGytdfzzJrhsZ6i5yWWi
13nSGdeTuZWbwgWNd8bi4ZDfDTLPXCLSXb05aiWD8TvdrlwJJzxyFqrhavMM
eVQL0SbnpOizmajPX/KmHzzvNFu5DI/9fGPBBvY58s6RIDnj6z5UePtdJGp7
EJgtUzBeZR0T6gy7aJp2xcL/CCQDn10g8looId9sxg0Xs4U+sGiVqd0+uHCi
paqnnsiwY8VelIN8J/P2NsCFG0zEgjzG1z5+w3XlPJFx07TFDBy0bevN0Foi
cUaWcns+427ixdFParC/bQIrffj2tMLD5RzRlplzf6QjXhKiafylmshBN73E
Ay7xVO8urSJKKe+QuOb91+8zRPErs5fC4J7JJ8P+8Adz7lut8T3VASvqrES+
rC9ExfBIdnGRN2yxoB9dC8/pDgUPnUa/LU9FbS9gPLH1eHcwXNlgXNgN96rR
iAqigaZJra5CxnV2KV1YGdF4VYBDPzwVZNy/XEqkENRLKxB/8e+Tqi9LiPZ3
ev4YD8/IfwufOEVUGq8JVMCv0kqURH3Sob4A+JbaVtpejPi8iCUH2C5SLcuD
Z8zMR42wv96aT1Um8Jye0CkN9TkZVSzYwvzWmo0RsFxiEyqBPSzd85NzGTce
ELbXwfcCVcOW8Ou8cIKf91dr4Ht6xd+sQz310YKVNvR/y+qwsOlyIrcrS1MX
YIPa7sZZ/L/+o0+f5cBVsfvNX6B/cYdqLa5gfh/r1P16DW7PdfJqx3x//NbR
5ga4WTvlqgxuTRjJmmzG/D2MC9+J81PhGGQ2AbfGxzR/BDvatG66gXkt2mcl
s0lmfDDV6OB1eLgoNdIYVqmVziKcrw1dvc//lDH+nfS0yBUWvBxPmYKbpZvX
T3QSDeq7NKYmMO7rIDx7H/bxrj32EveB58PY54dxvv9/X/wLtFgLMw==
      "], {{-85.305148, 33.482561}, {-85.307913, 33.48168}, {-85.314421, 
      33.488116}, {-85.322119, 33.48865}, {-85.33362199999999, 
      33.492405999999995`}, {-85.343469, 33.4966}, {-85.34669799999999, 
      33.501636}, {-85.35000699999999, 33.501215}, {-85.35443699999999, 
      33.499438999999995`}, {-85.351771, 33.493499}, {-85.352886, 
      33.492599999999996`}, {-85.4679, 33.495055}, {-85.516898, 
      33.494574}, {-85.531759, 33.4947}, {-85.553776, 33.494884}, {-85.564233,
       33.494969}, {-85.643489, 33.496041999999996`}, {-85.649754, 
      33.324118}, {-85.64096599999999, 33.324053}, {-85.641001, 
      33.320868}, {-85.64484999999999, 33.320442}, {-85.645439, 
      33.316806}, {-85.641041, 33.317228}, {-85.64170899999999, 
      33.306312999999996`}, {-85.65049499999999, 33.306379}, {-85.65245, 
      33.226760999999996`}, {-85.648061, 33.226728}, {-85.648125, 
      33.220813}, {-85.64876699999999, 33.212171}, {-85.65260599999999, 
      33.212199999999996`}, {-85.65328199999999, 
      33.200373}, {-85.65319199999999, 33.106618}, {-85.593476, 
      33.107526}, {-85.485542, 33.10935}, {-85.23302799999999, 
      33.108197}, {-85.264037, 33.26191}, {-85.299553, 
      33.452477}, {-85.305148, 33.482561}}, CompressedData["
1:eJxd13k4llkfB3BLhYRRIkplKTSYSWgoOYWMEqIbjaJC0pTHmkJZGrIvUygK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      "], CompressedData["
1:eJxd1Xk0lWkcB/CbGFlazJgo2QozGZopXEn4hZg2Sr2ZYizJkKZR4YxEB4Wy
hkiUJUt0LV2mhSwvEYVryZIlpWRQQlRGx5ivc+acOWf+eM89n3Of5/ye5/v8
nvdVPuRu5SzE4XAO45n/TcrOLP66hWENkpgUXiVRucZom20bw0rH6rINcISa
jJMD7KbZYKxfT3TgiJV4SSfDOvarNCrCTTtqHpbCOt72cRKNRCvkSroUexj2
TmdgnxzcxZc63/mKYfXMCs2z4QZ7ZQ/nIYY1H4w2khUQGYh3ph+HdwV5q9g9
JkqvO2iSM8KwDgobXpvAgdmfORlwQby+VmUV0ZG+E6GRbxi2568zbqXwR4Er
L2YM61f/e+w83D+6ZVHdB4aNftI5qfOAqNl+SCodrvCT3+hyh2iJc3ZoDmxt
xH0UlUqkHBt+NQhujBgW25GA8bY3ouPh/iKv47diiWQk84vn54drXHE6FU3U
05uQfAu+FLwySCWK6Kb44upCOM7PWngujEjJx0pNB24X3vNpQTjRj71OwyZw
/V3DXN1A1L8/Jqsw/p/rCh1eRo0y7PKKtbn74MsP3ukHw4YCbcfPAUQSCWze
fbih8JuARjhCQtS4EL78ok00Bu6e4xxth1WHEx/pwjnLoqrr4Z3TmWf6/Ilk
lVqEQ/sZVo2r2BkMf+Ey/ikMfiNrbbsqhCg1pJsb3sGwUxk73VzhzO4br9bD
HwItPd4HE6kqqfUb4/yTFKQvXQ8iOpthyRt6wrD3NneES2J/90R2eC1oRb8Y
2oiKIp9uXlRIeQPyLRJMl18kKs29IDLvGOXaDi3k+4P/eJrpY4bNjeB/ZXeV
aCjlxaGt8O7KfhGpa0RPb5c9i3nEsNNHC80Mkok6qoXsW2oZVtN2v6MWvEW9
JvIhvGLWdaMz5t8cVZvOeoj1eYzvdIUfu5UkD1Uz7EGnZrG0FKLZdPdWbXhX
QIPgOtxV9OcGHfjC27MaEjj/1KP29D08Y5qs8nM60Z7eCbUKWH32XJEN3IT2
qoNl/M2GW+GXeZPul2sYlhPu0twMuwcI10TBK9y/K+NmEsUsSA2Vw/pKhVpi
N8DZESOeSnUMu9SHyzOEuQ3N3qvhocCZeL0b+P/Xn/YewP6ZchcVY9hiVHKv
DVyigRPLQR6nJ7aermfYQRvFDjm4YUT+txDYzCbO9CMP/bRO3iMZ+Z4MjRx4
D+d3TqWmwmsXKTzvyyNaLx5Ye7eRYUUsla1H4D6O1vNKuG9fRtXTfKJtExNi
XQKG3f6tn/IALDVzxecZ7LFYSzu5EPnL3a6aakI/DpsG5sAD66qkX8Odu9YW
xP1BZONtp85tZtjP1vsTL8E5v3RYESz80ms28DZRIkmFyeL9oiPIWuMPh0/q
pi2DU3h5T+1xH7UDVi9fj/5x3SxVfQo2qjUP04LPVHXlOd9DvSBP70XoPwFb
V58ID0YdObYSnmntSQmDd/fVtqyCr5YnFxwowf4Uzvn7tjPssKOr10lY5nD9
ey+4cXNxFpUStWaNKHTBs1MpOkawp23E2+3wu4UXu6vLiBSqBdKb4MRmFX5G
ORHP8/dri+fnz/EiV1UQuW0z10tAPT9RoxMc+MuPoyqr2/59f2H8XMGmkxm4
H75LNMzr4PaFg8p7YebZmiQerC/Lt+TAx05ENB1GPYn4ESE77Ldm34yYC3xa
c6hsPo93/Kk0CYznWjd6mMI+/YKgaDisWljHF2bmA0T9Uj1bngEsmWch2M0S
RZuJWNxBvhZFdN8Elh/44GAF43YvvIXxvHwTHVU4bWk8Pw2OVvXQGMN59VRN
WvFhycGCi8Xwuv1tDisx/63ma18+PCWtZ9oL//978Q8ZOyti
      "], CompressedData["
1:eJxd1H0wlVkcB/CbpBs2l7pJtlbuem3QDiUa9hfttNhds5vnSaWkttZiab10
L0veu8IlVEvF1G6TzLY3NrPG1OZ0yVBaii630YtYkbcUW973mz/3j2fOfJ7f
Ob/nd84zv7N2f8Q3B7UEAoE3nvdji57UPnuaYz7co+eraolqt9Wd/Hwhzx7u
0SxKhWeqgxtki3hW1rnV7h68bbtbUaIhz6LLZ5uD6oi8Ws8HrzHimcReoHhQ
TWRbtqxl6zKe3Yiy9uQuEVU4pv8dupxnrv0J3aEFRHumf/A9IebZB3P9OrpJ
RAEbXV+UwvsfmjUNHSW6r/S444v12v497QaJRNnn0t2GkJ/zbh4zgm/sGm7S
1uNZvUrkkgCf9XNSz+rybOK6tK0Q+R5sahtRwYOdlSalyUQmz1LCdsJtS4LN
w1KI5t8v4ZnVFyvv3YHDjc8MOMGnjqo0v6cSNRfvm4uBN6u+v5WVRrTO12xw
Oaw3UH9dkk4U8m6FWiHk2azn5NAA4jeTGxXmsEQjadNH3LQ63Dt2Mc9aO/bq
xcE1r7zzX+ig/jH5oRLMD5RZNEbBX5fEugzCqq8qQkSw8Wth+EVYue5QWhXO
e3e8btIoHO3Rd94Hbth3u0wNP5WnplnDZ3/rdTFHfono6oAxnPRaOnIZ/uT9
RrR51n/fz7cXbpDaxDTCPzpnqDOPwWuf9/rBTsXF+jmwhcxzlRj28Tc9YAVr
tYsdVfj/LnuT+7yw3jNzgdGXsDg3K8QQLq/XRGvD62/k91SjnhUXOnTPaPHM
zqNC7IS4sqTgiTP8dKVW0gF4Pi8sjvh2zQRcnPDPljj4bU/QBTW+97LJ7eN4
eMjqQHyhnMj7WuyHOvDSZEmyDuyrtDmhWcCz5jTL4xZwja2x7RysqTDMaIcD
R2ZlV+EmYYSBRwbRkVvPzmyG5bUPWC7c51XU1iLgGTlmGAzCEi+RMgl2D4js
tDlOlCkolY7OcSzO5HakD7y7WZSzE9b3jxRnwfIay9C2WY5J7E5VSTKJEnZ9
lhgMK22nlEK4dp1XycAMxzT+x2N5+E7N6R1KeOn6N6unYbfRc3ZmsPPhxS9P
ZhE9yXJ41I1+u/SH9eAv2UTXKrdHVcMVDhpZuYJo/hxhnRSBiWsOkeXFDTrF
UxxTsaiRLrjJkpVPT3JM4TljH5ZL1DV85fER+KexY1MNsGf4MdNXExzbc3M8
6C9Yq2q4twweNzA3iTxBJMqtu9v6jmMO8sdS/Tyin6NslLawu1lLUSV8ZVZY
m/SWYwVdMveF+URCxb7uyX85JvqoYzQQnu8jeFQ9UXUXbgkozTs9zrGuazGH
y9HfawvQsfA9Rf8Sn0KipQcvZ5bBOz7d2Jh7HvMD+wx/hWsSVm/67k/UP7RF
2ADntba/2YD75f/30X+omDCD
      "], CompressedData["
1:eJxd1nk8VXkfB3CRKE+hLFEKJcyIZEuib4kSRcvBZLIlTaYsLURkKTclWUa2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      "], CompressedData["
1:eJxd1HtQVHUUB/B1fQDuTEooj+ENaqFQMoOSJutBBRVfgVx5IwvLCoEiz90F
dRcCxhcrTOEDSRQTUQMJYTGhuIWwtIouisZikjCwmIimIlQE9b392R937nzm
97vn9zjnHsfopIBYPo/H88fDvRXf/ZgzEcuw9k0Z8S0FRIXKzsGOeIa1KT5d
eQGWuqo3+qQyrHP39akIeNDZ5TfRAYbdWfsq6gi81aj2TCjc5Zu+svAI0Z+N
0q6TSoa99e28oGI4UTpHtx+WX6leuyydyNl1cX8a7H0m4vu38USqdqlLOpzf
ZuZdCh98VRLEuazIuCAK3rFvbd81uE2fNmMvrJDMte+GZe+V2T2KI1rUO+1M
HVwiT9mSDe/ZcsOtiDOZHrGEW15WhGXAQ4+DP+GcJHosk8JNx86vqJUQRSv0
XnLYmKfyyhIT3frAMjwV1skLIsqjiC7pp1exCoZtXmPQnoXLZyvyPXHeJebN
Ll/Dl0scngnhNLVSlxlN5F4rVg3uZ1g/Z8mYHH7rohEnw0lun/fJ4Co/pwkH
2FC02pLzrGj9bUf4hruX6JCI6FxOi8AJVo5E3RTCGcsHyqzgL1/tT76E9XpW
dPBH9jFsw8ky6xK4Qf17U6CcYQc2m6nLYO91n/a0yhjWP2dqzTF4GcVX+sP1
SwUjpbD6oYXJbvg4/96UEfyNWWTOdrhJtnpPcySRUUd11hLEK9fVvrCPIJo8
n3TPA5bEThQ2hBM9EfV4jmN+gCjRsT2MqFXVdu4Axvvbpxf5hBJJyjTv34V9
a9dXWsErhy5+9E4mw1o/DDTPCyFyPRUjD4KHlvdFngoi6sjIEwbDBXLb5PYd
RKXNJnnG8Nmt8jRnODvk3IZxxFsc6GmhYIh8RhOGL3LrheQcVQYSmfJsssaw
n8RQlxkp24ky2VViLTxk3ek1HEAkeGG0ainm3/rwM3enbai/XaJtH8MZlRUL
hjfjvDMvxA1ifn/Vm6QTG4n6bl818DAe0WtT/WADUe5rocqA8YgLjcOJsCRu
lelNeN5dPX/NeiI7iwdO5fDB0Uc/Z/sQ1TA5rX3ww8kYx5XriDp5vXwTxJth
NW2+iohCfRRxXLydoh8mlatRf2+Sd1dy9z/4TLMIdq1LLZmJ/+2FfKrOH37a
Y6ETwK7ZX3TXexPFRNlq5sBW2kMZ832JtH+MW1nAbWOhuizs53658Cdb2HBl
IEaK8yAbTTZwrsLUQ+JH1BUTNqt0N8Oa9trlKmGx0EF3CtY/S/Ej3Id6TMjk
JTKs49M4ZhMcwDUI+J8qscZ3K9Ffz5XDh+FrC684/QK7XQ1POg3XWKvdtMjX
f3UHT44/qd+EfB/W5i8rTmDYOK4hwCcqjPdmwl9NzqnZAY+MHB9QwlcdOoI9
UE8b3KncZBfDbk643x0J/z1xVGAEj5rd2eOGepRlzeW/Rr8K+ZUd8IWLBHee
vIQrrl9+3oj6NT9fXT/O9bMezewDO4ls++3Vo/C8dIPdu0rsfyEyzX1/9rFj
K/z//vcv6ZlfAQ==
      "], {{-85.749353, 32.959351}, {-85.74875899999999, 
      32.964355}, {-85.74866399999999, 32.97437}, {-85.74853, 
      32.988481}, {-85.714066, 32.989159}, {-85.71421099999999, 
      32.974593}, {-85.722959, 32.974652999999996`}, {-85.722995, 
      32.971011}, {-85.727369, 32.971041}, {-85.72740499999999, 
      32.967399}, {-85.731779, 32.967428999999996`}, {-85.731859, 
      32.959235}, {-85.749353, 32.959351}}, {{-85.85154299999999, 
      33.498768}, {-85.90493699999999, 33.499055999999996`}, {-85.905271, 
      33.454933}, {-85.922876, 33.455023}, {-85.923857, 
      33.396343}, {-85.940899, 33.396426999999996`}, {-85.941002, 
      33.381869}, {-85.976179, 33.382035}, {-85.980058, 
      33.294241}, {-85.99542799999999, 33.294764}, {-86.11785599999999, 
      33.296603}, {-86.119807, 33.233816}, {-86.120544, 
      33.194683}, {-86.17263299999999, 33.195754}, {-86.17339199999999, 
      33.144785999999996`}, {-86.162465, 33.137017}, {-86.138947, 
      33.127387999999996`}, {-86.104429, 
      33.127728999999995`}, {-86.10490899999999, 
      33.141383999999995`}, {-86.04627599999999, 
      33.141166999999996`}, {-86.0469, 33.127970999999995`}, {-86.017859, 
      33.128307}, {-86.015002, 33.236605}, {-85.910743, 
      33.238847}, {-85.908458, 33.323924}, {-85.80574399999999, 
      33.324258}, {-85.803343, 33.409323}, {-85.75110099999999, 
      33.409904}, {-85.74899099999999, 33.458113}, {-85.72807999999999, 
      33.458428999999995`}, {-85.727441, 33.467523}, {-85.70983299999999, 
      33.467403}, {-85.709077, 33.487868999999996`}, {-85.689264, 
      33.487731}, {-85.688064, 33.497275}, {-85.765664, 
      33.499161}, {-85.765258, 33.483692}, {-85.782319, 
      33.483799999999995`}, {-85.78245199999999, 
      33.469243999999996`}, {-85.887553, 33.469397}, {-85.887497, 
      33.476675}, {-85.869333, 33.477032}, {-85.869216, 
      33.491588}, {-85.85215, 33.491948}, {-85.85154299999999, 
      33.498768}}, {{-85.827798, 33.443134}, {-85.818997, 
      33.443082}, {-85.818902, 33.453998999999996`}, {-85.80184799999999, 
      33.453897}, {-85.79861199999999, 33.446598}, {-85.801977, 
      33.43934}, {-85.80204599999999, 33.431607}, {-85.810842, 
      33.432114999999996`}, {-85.81106899999999, 33.406185}, {-85.81987, 
      33.405783}, {-85.819952, 33.396229}, {-85.82709899999999, 
      33.396271}, {-85.827348, 33.367155}, {-85.84163199999999, 
      33.367692999999996`}, {-85.84157499999999, 
      33.374517}, {-85.84597199999999, 33.374542}, {-85.845123, 
      33.410478999999995`}, {-85.85446999999999, 
      33.410531999999996`}, {-85.853973, 33.40416}, {-85.874861, 
      33.40473}, {-85.875917, 33.410195}, {-85.873678, 
      33.415186999999996`}, {-85.86869999999999, 
      33.4188}, {-85.86372899999999, 33.421502}, {-85.85874299999999, 
      33.426023}, {-85.853774, 33.42827}, {-85.848241, 
      33.432333}, {-85.84377599999999, 33.440041}, {-85.83603, 
      33.445456}, {-85.827708, 33.453596}, {-85.827798, 
      33.443134}}, {{-85.688064, 33.497275}, {-85.689264, 
      33.487731}, {-85.709077, 33.487868999999996`}, {-85.70983299999999, 
      33.467403}, {-85.727441, 33.467523}, {-85.72807999999999, 
      33.458428999999995`}, {-85.74899099999999, 
      33.458113}, {-85.75110099999999, 33.409904}, {-85.803343, 
      33.409323}, {-85.80574399999999, 33.324258}, {-85.908458, 
      33.323924}, {-85.910743, 33.238847}, {-86.015002, 
      33.236605}, {-86.017859, 33.128307}, {-86.0469, 
      33.127970999999995`}, {-86.04627599999999, 
      33.141166999999996`}, {-86.10490899999999, 
      33.141383999999995`}, {-86.104429, 33.127728999999995`}, {-86.138947, 
      33.127387999999996`}, {-86.162465, 33.137017}, {-86.17339199999999, 
      33.144785999999996`}, {-86.17404499999999, 33.119301}, {-86.174105, 
      33.104737}, {-86.009241, 33.104604}, {-86.009328, 
      33.090495}, {-85.97428099999999, 33.090339}, {-85.97472599999999, 
      33.105816}, {-85.801104, 33.104431}, {-85.65319199999999, 
      33.106618}, {-85.65328199999999, 33.200373}, {-85.65260599999999, 
      33.212199999999996`}, {-85.64876699999999, 33.212171}, {-85.648125, 
      33.220813}, {-85.648061, 33.226728}, {-85.65245, 
      33.226760999999996`}, {-85.65049499999999, 
      33.306379}, {-85.64170899999999, 33.306312999999996`}, {-85.641041, 
      33.317228}, {-85.645439, 33.316806}, {-85.64484999999999, 
      33.320442}, {-85.641001, 33.320868}, {-85.64096599999999, 
      33.324053}, {-85.649754, 33.324118}, {-85.643489, 
      33.496041999999996`}, {-85.688064, 33.497275}}, CompressedData["
1:eJxd1HkwXXcUB3CCKG3zUDFVZEiHaTOCBtOIJYc0aEOfSK6nqnhqGwkSQWyj
NGkQkoghFYTiJbbQhtT6PD+lllQQtSXG1oYyJDWZiCV5pt/3b/+4c+cz53fP
Pfec3/0Z+Ee4B+6Qk5P7ApfsLi2LGLbo4phrSv9AaTHRg9CWokXY69shlRK4
6pnRxp1ujhWcW3UJKSSy3/f71e4ejmlLQw4GwmNdO3wfwfu9PYTmRUQTv7ZN
ZfdxbONUnaMtvFg863/0AcfcOuaU1G8RmSWvlnwG371y7z0fPC++m64k6edY
tkHPmHke0ZPqa6kyC+oHNiRZRE1Kx6Llhzmmafe1svJ1ogsifvXinxxrshnL
fCeTyFDfaM5hBPXt0cwp/YFIT6FuvBXxHLagawMnmH1sZwdbDqpvmsBRQ4a6
8cgndWkLV79E9I3ITUvyiGNZ7fcr+LA4pyVAF5YL1zLVgsfLztiqwkoiKe+X
JCLJpdmmzCHkO7w9XAr7qoi6auGJ/Brx02iiJKmajjHWe6xOqv0NRz2PabOA
j6/LO4eFE7U3nby9f5BjMdPdQU6wlWOdU8UAx6arPYzewKu/jZ2e/4NjkxIn
6Roc7BuXVQT3Li1v5kcQHXTS0xPAuQUVt5thVdOOSh58oK/3qwk43d5vfgj9
jfmynlph8aGe5BU4r6zn37AzRDpBITbqWD9dtezmepZI0d1//BXiu0KWVBtg
aXFnYhzsrYs3wMsZFxsK4fOjCgsGsIOscHjcRfJ4AflGCsW9irDZrbEwN8Qf
K9SwLMx/3crOqxDOKtqbmgYnnexM4kcSuZp+cmMJ+2k8lJdQAkd5Ndo/g53f
XLb0jiFSvvFhgH47x6Z+NJ/cDY9Zeu16KeGYRUGP0OwU0btl+rGJbeh34YVg
B1jefKaDD/c/7+uU+YXDIZuLLRwLFE2fsIK9rY9raDRxbMa1cUUNbjSM7NCG
P09RMgvEfK3yXJOF8NNWDB4+uyA4l9zMMV7jkU5/eGhkWSsFXjFxc/dLJWLe
GVo/If+dhhF7H/h1lE2QzIr47FE4QH/QZAYu/oevI3NJ21bsImzsPyF0SSPy
3CMq723lWJrxcJc1vBBjut4HD6bMv6V9mej8q1zlJTH6XRQ7oAVXbu7bnICj
s2tMyrHfp+JdearoR6hLWrMIPiDYOboTXhpaivs0h2jmtc59AfzSfK3lKPyB
5kMFT1hOR82gFkYVWwnw9qBQIoYdVbbetmUcc3wo6OuB92pHnpZZ1Hnk/cO5
RLPqu6sKOjj2Pbf2whruXTGOL4fdG5yfXMH/asHzu+4LO52wvfkdHBbuwveE
6738rqXnE6lo3ksTwtU/16qOwGFhc3GVcINGy7G/4IyIjxIbYJ/gI9s3cd78
/zz6D13LTBc=
      "], {{-87.316582, 33.044024}, {-87.31838499999999, 
      33.006685}, {-87.42175499999999, 33.004532}, {-87.42027999999999, 
      32.971767}, {-87.42078599999999, 32.874333}, {-87.319215, 
      32.875564}, {-87.319304, 32.831396}, {-87.269089, 
      32.831747}, {-87.233065, 32.831984}, {-87.22327, 
      32.835234}, {-87.211807, 32.835305999999996`}, {-87.01912399999999, 
      32.836802}, {-86.983646, 32.837413999999995`}, {-86.986352, 
      32.922542}, {-87.10823099999999, 32.924689}, {-87.108007, 
      32.895553}, {-87.148958, 32.893051}, {-87.14945999999999, 
      32.887584}, {-87.156542, 32.885267}, {-87.162523, 
      32.882045}, {-87.165815, 32.883846999999996`}, {-87.163665, 
      32.887958}, {-87.17131599999999, 32.888368}, {-87.172927, 
      32.885172}, {-87.17068499999999, 32.878355}, {-87.169, 
      32.872901999999996`}, {-87.172831, 32.87379}, {-87.17719199999999, 
      32.872853}, {-87.181553, 32.871916999999996`}, {-87.185878, 
      32.866882}, {-87.229021, 32.86707}, {-87.237161, 
      32.861554}, {-87.268844, 32.86271}, {-87.268317, 
      32.920992}, {-87.260667, 32.921043}, {-87.258589, 
      32.989343999999996`}, {-87.26625, 32.989748}, {-87.267358, 
      33.047551999999996`}, {-87.277227, 33.049306}, {-87.288703, 
      33.047407}, {-87.300674, 33.040496}, {-87.30834, 
      33.040897}, {-87.316582, 33.044024}}, {{-87.42175499999999, 
      33.004532}, {-87.489041, 33.004424}, {-87.52404899999999, 
      33.004115}, {-87.523282, 32.860254999999995`}, {-87.472487, 
      32.859333}, {-87.472135, 32.83065}, {-87.421381, 
      32.831527}, {-87.42078599999999, 32.874333}, {-87.42027999999999, 
      32.971767}, {-87.42175499999999, 33.004532}}, {{-87.316582, 
      33.044024}, {-87.346795, 33.054274}, {-87.352308, 
      33.057874}, {-87.524168, 33.055552999999996`}, {-87.52404899999999, 
      33.004115}, {-87.489041, 33.004424}, {-87.42175499999999, 
      33.004532}, {-87.31838499999999, 33.006685}, {-87.316582, 
      33.044024}}, CompressedData["
1:eJxd2Hc011/8B3CjJJRKKhRSIQ2EiOKWZI/w+RiVkYhSlKyyJSJZRRLfaMhI
tkR80DBKlJ2KjLIppRJ+z7fT7/zO+f31OY9z933f8bqf9UedDG1ZmJiYfJmZ
mKjfhsOpUbE/aIzuPFfn7BhCmhbbizj+pDEmWn4X1UUTwh5u1fMHXibUNmEJ
Z86yV/lN0Rgx3R7KrHCcy+YsiV80hrJwQ3x+FCHLIp7VvYMlgz+4c8EsRaP9
ab9pjB/cInxnIwlRPX1JYBw+UvbD+mkEId2jmR/c/tAYFyYvTVfDr0QZ2X/h
cNWZ7Y6w6F05tsRpGqOS4TLWfZWQbftyeGX/0hhsAUx8inBevpFLMZwj2e6R
HU7IxzDJjh74fq74cMoVQvZM3NomPENjyDsvGrwWRkhteaxJFrxU6vu6v6GE
VG3RTBqC200ve9Jhb3M1X/tZGiNLYjqLHQ4uFz3ZBG/Ydr1oA3zozbKrZnM0
BpfpWd6wy4SEMqW6T8Dn+Z6f1YY3aC7L8mOiM5QPn+3cDH/VjG9qgIlMCPdw
CCFuFV03lZjpjOCqt4wI2HJs1uMR/IrdiXsfXC6xWmIObs9ZHtIaTIh+1ubI
dvjNRdHLm2CtPM+1bCx0xlL/Df5s8OCrPRu94BExG68bcKJ3397z8FSvdXLL
JUK0TQVsxGBep2OCv4MIyUqK+SgPf1rD4mcDr0pu47gJz88rnP2i/dwCVjpD
qjS6t/givlco8wpdmDci7MRypLO08spUwrss/L9qwps8VPl5F9AZ8+2gver1
n/uNYdnERK6rlN03u9bAZ+RDWkJh6es+le3wQKOxfj/Kb1j2aGj1QjrD75v7
2AP4U3DgRXE4IaN/lwh8bt/X29pwtdXztBb0J2uL3cUi+JAXh98EXKmXc2IZ
G52x+hv76buwpcemGhf4YJLnrmG4fFwr+gtMmwy2S4IFik9reS6iM961WXCe
R/1l/jXhIux0xob2DU1c8Ilfq1rC4VnVPyNDyL9FX3h45WI6g3PoRckGpL9J
tJpzhZUqHSrCkH569c0hWZga1sNAQoY78/lSYTGdNa9rAwjh6wpwNOOgM+b3
FfxWoWmsEp7P509IgrFsyyz8u8S96YYfIaXmo68WcNIZLyqX7fL2JSRln6vL
BNJ1ZsV8p3wISdaYcuFAupDk3SpV+ChPfDED6dTnDfQm5E+9pFYDLKnnVXDH
i5BfO2faI2BnlS5/ZvgnB+foIthz9zYV5wuEHOuLq1gDH7/RYbgIpv34pqQL
/zqhfubqeULY2tRTs+B1zkekN8BcD/XqDdB+k6jeqDv8cWbCogCepvmN7UT5
VBHeF6u48D1t3iTVIT07Qu/Ib6TrrtCu/eBJiOTJo/6PYG2FyVXccJeWmyM1
3tVWQolPPAhhHBLeS413LH3RK1WYJiWRxoN02S3vg0vd8T0mK3bspNpTXrtx
P7yvVj/dG45WchSRgRtEg/UV0b5uKetuB/hEIE/jI7i3w0C6Hr7efG5PI1wf
xmM54kZI20herc4SOuNzNWuUGty7BAcDnH5UYuaiKyF9Qzv+piK/4KoTut/P
EdJzL+GZMPxI5fKbRPjMVUXFLLSP0+QZ81lCZo5d4c6D5/vlTMjGxjrxWHhh
qnJkqRMhV18k+6yGHxrcnd4FnzrV7ZmG8a6vC7iscpqQB6eqxNnhruazx0Xh
kjcTjZ+xnrRUw/dFn8L+Vn8+t476niP7NTUc8T3Z5VTTYVWWA3HyJwkpCBEX
dUL99G85JQQ+Ybdt4V2Yy337lckThDzr7+mgvt8UrdjgtwPOB1rHZ37Y9nTZ
8g/w+LS8pB7q61a9HLsb+bcbxXQtgf33iBreRPqNk40s+egPew2LqDOsZGwU
Te2HkZHYXj84a6xq7z54l88D2aMoHzcX6TON/fS17FZ7FnwtaWDTC/jWyv49
9bAH50ZxH3hdT2jYHbixxnBoBvvTeua/Ki/UF390acBVuHJqlm3kOCELTHtb
ueHWlIX2h2CjGiaD59jfiy+5LJGxI0RqMqSR2v+0gOfdr2wJCfnuzPIO582t
T1KNwsiveC1Z4j58vIAhyAMbhMedXgFfPl+Rugv5b5c3bDgAU9eL2zGsZ8Ve
u8ewuJXSmhwbQnYwGZ/pgdV7DMo5YYMduwpkcB69Pvco5s9RQm5+CfGKg7sP
V3GFI/3o9rSO0+hPRu5YaBdsw9GikABrFm06WwFXi2ClYjzYxX05KC+z0r20
Bumun8+WslgTImH0am8D/OKOcSWPFSHmNg2Lk2G562rWqy2xv/7+LrSCebi+
8NtZoL2fuSP5aN/iuOps/BFC+J/y35aFh6eeKdIOExJWUZXvBI+v0jD4a477
1DSd0wOm+160ZsBa1IJFfU/a8g3ZYTODNdcc0D9pMfuYKjNChA8zB52Hb68K
DHaAcTsvU4S3+hiZppni/s9Mj/uE8u2vr/jIwom3kh/3oP6kuNBwTxNCeHv+
6lLnO5uPcZUP7GM48m4C98laywt2msj/udcnOAU2uGfHnQ+/7k04dRqOdlV4
okW17x1zfy9soV29aA9sF4CZxv31WVBb6Any23XMXr8OM6/6/UMVLt/ENHcN
Hjx8UIsdDgxpyg9DeYxKtphOSORWK5YiuENu/UNpmKWpKbcADlVIPJZBI+RW
WdIjM5jFW0Q/2piQSUlN21DWf/eNIeIHtdGBQfi5nHLMzEHEF2E6jEdYH9Hr
X7bIID09Iax8BE5vNjFZCCsKyhjwYfxdy3nTE5DfqH71BUnYVxNfWp8Qnr23
gnlghznWTBocPirsRq1XYbXE4mA9Qk4Wy/BwwYOPTEyddQm5ZHywtBbtmz4X
iFfXwX32RMKAGl99yNuPXdqEBHRNjBzB+OvxOW4hXdW4+8044pEyvcG6t3Dh
4xfHc6n4hLqAYDvpnN+PEe8s7FhnyIX2fO5bFLHDLm3eL8fhxsgJ8euIr3gK
ZIv2GRBCbecd8IXOInMx+KLY5J8YxGunAzucRuB16ZtrFOGXdurpY7DhsP3a
QcR3qXs2fXkGuyz/dNkMXqDwNGwK47VnzWZeDrd2Ns6d1f8XnyFenN8faH/u
a4LsEtgxL2fFd71/6wHxZltz7+YM5P/UablnFPFq/NLEJHcYt8Lqx7Bg6leN
7bCqIeemGLg5R2sgHuX5eqqGbeHULx9MDeBk34AwXji0L5auCh8yS8l7hfhY
9FT6aBTm29ks6DUT0pu8rnsNY754rExnveBDOeXDSbBD7/fQVDjXBpEN5r8j
dMZ2Cv4qZWnhB2fSRf8aIn4+RgXMyN+ejUgVzk638ElF/ad5Rq97wgXd2bLj
cJqktpIcxrf5df+ZNejPpbMpR4JgluJnUYvgjEdZHE2welTBJUPkr1E4kKuO
+VnQ0/VWWvdffAinCqsIFKO9+bgH7qh2NapFf+KoCw7lrzT3z9Fgrpff+Qxg
HgmFUmEtQkwjpulD6M99q/C8AQ1Czt6VkfoGi97nzPmjjvNK+khIM7z+qusZ
AXg+ToHHdeyjTQ9g/RdIcY7AI8vmsu+pYf85mpVthx+xiS+R20+IYJcmZxzm
J0ZArYUfvuXI6n4brh6J06fDy0/vSOeCJ1PcyjlQn0CSxea6SRoj4YpE1WPU
pyIva5sK37mGkwd+WOKZrgonPyn+9R7lJzTFVujAbUlmK27DkrKtDnfhnSav
XfbDKmH3NMrgfa820d6ror8cS57lwnoJZ/hT9uF8HIzptIZNjgSf0IJdmhrP
yMH5/S8tzWHqemCG6/zyrm1FeY7Jy7s1v9MYy53ZaSdQfyrd8ggvzOZbfmMb
+rf0R0m2HLwx73zwe8zX+x9vVzLD5d+E96hhflWpg/4bjfF7JVMPH6z8yqIw
EQ6svK1zB/kvj5q12sPtQx+ExmBBndAIfZitxPp9CvLfen/xgi1sIG/QlYjv
t3K9q9L0BI3R1yDy/jf8hnvDRXVY+9HrF1ow6/AdIxM4bnZTmo4m1uda82NK
MF4/s0WoT1q157IwbGC8MzMNHnS3Plk4TmPY+bsFr0R+kdAaASuYChO9tP7d
X2M0hlCynQYv1tOH+rJvwrDBla3xNrDlm9atcbDZ+5URYViPhm+rGgZhpaqm
WEWs52U1kTZDsFrgyt1B8JovTvvWo/6nVSMN2XD2M9ba+/DilFHWSNjXvr9G
DuO995+z20ms9yUhy0zq4TlSfOoTfKabaKzC/F6iix0XR/5j0VF52fATjeSt
XjgPKu38OHNh/cNXTYQN/p0v+J7NSp1Ll+B8HrDBRkW6g4BvSi78peKDWQnq
7zD+sIE6vxcHsStcxPxM1Rz0E8f5btcmPiSP/uULlumsRHqZdpr2C4xn5YCP
3l6kB5bii8GazW48XkaE+JtzCd6H5+NH3C8nb+mqM6H8cECFnDv860G5hTXM
KyhbMor8CQLveGJhgRbjVUFwh+DTbmWq/Z6fdWJwa3ukrx36x/JE8nih0b94
B75LPQxQ39rFsm1NcIjNkc4DuN9SLrTImcN8M/YKtrj/ODp6xzXhfo+FKWK4
n2d0xfcz4DDdLUEE9+fwe839v+CAmdZi6v5fTvslUwrP37uIFy49qPyvG45d
8CDN9hAhChoh3xZi/tykESHBXUfVltyHV1We2GoNWz3EzUvt5242Lx+Uz/KK
/VIBvysrLj8PK90frd2O89dfOUpME/m7Re/USsE+/FP98ohn2I2uafcgf+kg
8/dIxDsjXipyFvCTkvpLf+H83dyj9WjP1KmJ4x28ReqYawa8aX1U4QScuLXg
oxMsXGSpbIZ4Kkr0I3MS/McyS40T8Vaud/WhLNSHaEuNG/GZWQhe3mi/UOLy
cCCsTh0kMFNo1CYX2OhhkJk9/OZ927AG4rcrbWJ+R3F+6b/uY1OF6QlzJutw
/q3Ms+DqQ/0/Od2qCuG36bHnriFdXJ05xQqW87C8TsWXb7Yknb+L8v8x/7Br
Qv24PVScYBEqsEV6Rs7FAml4/Gn53gs2/95jaL/kht2TVnhfVlOeMEye8slZ
Ir71Em+Mfonx/HlzU8gXDlpwZbsTrLKzJuIXLPl0ptgett1ZvXED4uMUi3EH
PbgqAT2Cd9vd3jGL+anTxkEPU88SM6TnyATVn7RHf6gAH572+FpyCPG7JLUx
YCqcbYTtfiwtos7nj/xtEhWI90Pw3LeEG3JHhTjxXkl8W/FHBf3laPcUSIDd
eA19DOGsdxrafXAjq1AgL9zXGJ79AO8fT+afjWlUewMqJ33g2j+vn52D10d0
HaiFt3k0mkT+73jwfjpq999LcZTff/f+ER3Ys645Qhfmm1PuqYQHOAqX68MW
Ejv7XfH+Ornk3k8R+K2jYHAF7Hui9FwM6lu+ZkjgBnzJyfqDB7zl+NiVQriu
5Y9IMpzSuO5ZPd5/v0s/p6nD8/8DwVri3ut7MX9Yza06sNXaw4r9sAr1x8QZ
QjQT0i8cQ/76meaeMnj818+svTAtuJNLHu9LhystB5uRf/5/GKTr+YTpxcJc
rqbdsfC0eRx/MnzsyylHN+QfZK1RCoYXhwrZjMKl1Qv+8sPyp144hMBGmfwX
i7Ffn1YGTDO7IJ464mi+GRbZkfk5HOmRkw68Mzhfzg1YRtfCgQYfXzbCG6mH
HfI/z8g8FQp79nKzJcG205FFh+HCSft0MXhklPmJJOxNbUBYg7oQcH7Nvzdh
TU1u1Qy4On9n+Aj8vfZHYTx8cGtRPj/e15rb59bPUOm5Vp8jYKmiC8X6qC+X
60xmGN7nUoXLem/DpkqhLk3w21TaZDBs3iRWXIX3/JaOtV92wosKPnVchq9d
4g/aCOfXdMfowfWdqpVTqF+Iukdh6m+KL3DUkrthuu64rwp2dMfBI9/X9MXD
nHkN9Q6wbMts/U/k//HYqUAPlnc8dK0dVnG+LrYMflzn82EADlyBkxHne591
cossygdSD2+k91nWbWmFrfWV/srBuE0y+mHnnBS2d8jvQ4/f/BCOVZKpcIbb
rLo3voY/yXq7MUZpDOqakPfE/R80dPAxHCpQdOM/mPBYV72D11EbES7jXrT4
IMoru+PEhjlvMB6WwDeeOiqdghszHYW+wWxbi0Ofw/P9hlMGTRSFzuO8Dmzd
fgouOXrA4wK8g0Vi7V64q1RhohmuiapnVMMxB23XuF9AfNn6Xa4ODgngM8r2
wvpsetvJgfEVieftFfXGedegTB9HukhwSIIRrCfWPngWzs6oMaLD7My/V0jA
4wd9n1aivHn8uPYMNT7TZ9lVcFo760Nq/F8l8dBH/oxsvq4A2NVth4KWD+4v
hG/xI2gPx7k0zGzwPPwQ7PP3npo3nFuaISgFh+f6yEj7EiJELUBYkzqY4DZ/
lwPX4AgqIIbTqD+0YZ1f93w++uG+nWM62QxvGrhZI++P9xnnon25cFxX06Jo
/3/zC7/KFfN/DcdVjSpdgpXrZa2n4fl1DK8q35xpHIB4sGRsjSDmp65IOVMe
1ui0GVD98X8WPm8oKgc3Lzg4xXzlX3wKX/c2WTAXhvix80ZSNjy/riMIWc2V
VXwHpsItzyhC/v//+/8DZ6d6og==
      "], CompressedData["
1:eJxd1ns4ldkeB3DDJJPmCckmNUXsTiSSihSLzXYn8rZdN7Mxrim3Rts9XcZl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      "], CompressedData["
1:eJxd1ns4VVkfB3AdFYOM3Low9dLFVG5pJIdqvW6pNIQdxzUctyimcn9zjeNw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      "], CompressedData["
1:eJxd1HswXFccB3Clu4PWa4Npo0iD7moJm6hMlvLLKuP97FGpesV6v1JWaIKS
eEUnHiWxWLLeExtBESE0J1UNJW3SROJNQsSgHZoyoU3a3/7X6R937nzm+7u/
c+8595x3jyd4h8nLyck54yW7HxG5ZYZcJ3TpRlmfIBegxyjx1ttopyyGeRj6
cysvFgs979azrh4D8AefZ53dR2hYw5zPEbQ46vvtUvRS1E6W9DOA8LC/insG
CIUcA8dGNGsq8cAQ+urzhPKXnwCocAOft2B9+0IGVSAAg0GlH652EToheqSR
h7m1s5F1bSuhgROVrf3oNalUvhvdn8SxI9gv2TpccvASoVbzHufL0V5q91ZU
/2MLE4eAmEpCVaekRXnomQql3CS0eGf8nX3BAHcrui73lRMa1K5zzRTtHcof
MxIRenOzO+IimhuQP65fQegUcdxxCgHgd67NFaBNOxWHfI8DXOFJGdvojqZv
OevoVjP8QuxvLkiWPhMA+IqjTcfQY/s1/Y+GAdSUOanEVREq7LT1jEeL6wsL
pehJfvFZVjjAYbdLuifEhH4g8fTQjwCwHDY0iEArKvwykIc29luM5aHdYU/I
IPp1XqklQfvJ+TBVIwE0BlVDf0WPJKXry/y1uX2vRTWhswxnZRP0Xq8pnTT0
Q+nwSmY0AM8fIj9CB8v3/L6M6yfsiGpURxcKmQ6BsQDs76a8xNjvpmyh0FxD
9p4e9FrcIa0ncQBxbzFuLaLvFW9yLsRjf807Cn74/JL6F0nvJwDILWUr1dcQ
6vDl8tN29I9NF/j7cH2YG9qOnokANx4ovnRFM+ZGmm+jv9oRDJ1Ar2tpz6gJ
AWKCwGwGPc+13u5EF/i05hyTENo4zepdQEf9MGZThG6T/UDJAMcsqqvfrCW0
4XFZ785JgNOOL+bmMQ9oLrn4UwrOT/zBFlmuXPXageFUgAzv3+5vYm73RM9F
/xTAqAm/Qwvzsj/Nu3inAZ6mMurY6GWmna5vGoCfTii7H+trxmx330sHUHVR
sG1Bu9K2EsMMgA3JZHIC1kv+nrWKzgS4KtKY00MLrlj+03YG32faNScVbZK+
cmYXXfKxWb1fHaFZnWUm7LMAdRXsR5r1hO6K1BSFmK8WVz1mNhBaYc+5dga9
dT2h2x3NGbfRLcJ6C+fyV0aNhKo9MC6Kz8b9Enly1h9dkmZUzMrB+fG0UAtu
wvH6tir1cP+O7N1SP492aGNyVPJwvrcN7AXNhA4czpVbwNz3jXVuCfqUpdTm
U8xvZ2i7yGwsa4x+lp9W7o1OYWm8ss8H0HE4uvEC+0ksW+5noR+eG91Uxny6
NoS7ir5cvxgtwP3skVKT+jM65BBlTKIVRyfu3kHX7Xdny6yfnZmmdA7APv0b
q1g8X0RaBUJb9P/Po38BpAok/A==
      "], CompressedData["
1:eJxd1GtQVGUYB/AVWNycQK4GOUAlihBXIyyIeFiIUMC4dBAiiPtNbsLCQlxL
EQRZl3FBQm6BYrIo4EIMYXgaLmLQhAEWVwERmhGLHcyJJqf+p499OHPmN895
n3nf/zznfTUy1T9GhcfjeeDh3nnu3mdNyxnW9udmfnwFUbm9UnPzIsO6GbZF
WsAnl6bT4xoZVqLaUe0ES/sFATL4wXNlWM85osvz+ZLzTQzbkaW3/lU50VP2
TvgwfO6+37QavOXkE3sLHnnpiVJYRnQ6b0IRDPeqf320s5ToXuD+ynz4rCx2
6y040Nx50utLhi28XWMVXEKUtCadEsLthoar1meIjFTeV9GA1z7q5iUXE92o
0V40hqPbHf7p+Jxos2kmMxVu+nvBKbGISNNL1aUN/b3ZjkrTAqKgvVFm3H4a
xl3+OpBP9Cib32zG9VN3MwrMIxqzFHbpw7Kntt2OuUQF/k8mlfjebcXYy+RT
Iu2UQ20vor7r0g7r0WyiXM8/Fx+gHnq1svp7MVGwfX09V7+8LOvbziJKGBp/
9798OpcK2EyisoDrxdz5r8zp9C2JiE58QjbzXJ527zxTwIXb0cNp8Ib+nvnd
cP+U4Lk3zF+8e/VOOtFIa5XwFVh9c4+nL8xbPf1CSwPDeuSsPepMJXpZ7wfV
oHqGXdU6mWEBJxvwv3tYx7D3pMqDVSlEdqZmur3w4+Q39FeSicwGZv3q4Nsa
dmFbSUSiroQrWlgvEal7hMGOIRTvDIer9P62dgL9/Wb35sH35aO/FiViXmzf
67OHF/hHd1nGI59Bzaif0O9uRr6JJqzmeMGBgYN4AeqczYMeJjnCx0g3YjCO
yGHUdF8cLFD98dsS+LBPo1Ea/HqT7wcmcF2LRCK/xLAzQukpnViiBtkRjWRY
pHDxTYnBvNQlWo3XMuz4a3ohrvB1G53ZdNg2OlO+Hk3U7ijnP/uCYbtabx7c
iCQSKh4vlsFWCsFwIGwXWjptAs8ynttHIoj8o4Tj+2uQh7InrjqcyPdYt1xa
hbwO604Ww/2Flu4l8GB0W/iHWD9gY80kyBhW7BFS5Q4v87Wvce5hjXXN0W9o
I2aOc5Ph0M4srB+zNvg4o4hhJ3IqQpvhyMIZ5xxYwJM452K/qREL2WL41vmW
t2/ivIO/t4ZkwesLQb4GyC/F5xurSriWtMs5H1jc0dDNOSfd5zO4MFbL5Bc4
26zReA4OzHNbVsAjMyK1tASiUmXt8Uy4sVJQEQ5LRsXmnM+M6LrWwfssLVZE
sGtD6MAfcJJ490Q+nCO/4fYm5ne7XzxVA4/16R2vwv+tc0gadxFWntq6FoX7
4f/3yb/gkAMr
      "], {{-87.42078599999999, 32.874333}, {-87.421381, 
      32.831527}, {-87.35642399999999, 32.831579}, {-87.355746, 
      32.819289999999995`}, {-87.337186, 32.818971999999995`}, {-87.337119, 
      32.812598}, {-87.32838799999999, 32.812661999999996`}, {-87.328312, 
      32.805375999999995`}, {-87.295028, 32.805614}, {-87.290858, 
      32.825223}, {-87.269032, 32.825827}, {-87.269089, 
      32.831747}, {-87.319304, 32.831396}, {-87.319215, 
      32.875564}, {-87.42078599999999, 32.874333}}, {{-87.017876, 
      32.729341999999995`}, {-87.01912399999999, 32.836802}, {-87.211807, 
      32.835305999999996`}, {-87.21934999999999, 32.824331}, {-87.228573, 
      32.818353}, {-87.235625, 32.813753999999996`}, {-87.23941599999999, 
      32.810542}, {-87.240562, 32.816454}, {-87.243858, 
      32.818709}, {-87.246552, 32.815049}, {-87.25251999999999, 
      32.811367}, {-87.250299, 32.807283}, {-87.244787, 
      32.8014}, {-87.24857999999999, 32.798643}, {-87.261618, 
      32.792637}, {-87.269708, 32.783018999999996`}, {-87.274524, 
      32.773424}, {-87.272848, 32.769337}, {-87.26794799999999, 
      32.770281}, {-87.26355, 32.766667}, {-87.263493, 32.760748}, {-87.26344,
       32.755283}, {-87.259, 32.747116}, {-87.260592, 
      32.742551}, {-87.26382799999999, 32.738886}, {-87.26425499999999, 
      32.726588}, {-87.260408, 32.723425}, {-87.256044, 
      32.722999}, {-87.253271, 32.718008}, {-87.243426, 
      32.714428999999996`}, {-87.238466, 32.708541}, {-87.234102, 
      32.708114}, {-87.23460899999999, 32.704012}, {-87.214524, 
      32.712793}, {-87.101683, 32.710257999999996`}, {-87.105595, 
      32.579974}, {-87.072946, 32.579688}, {-87.057225, 
      32.587965}, {-87.043674, 32.595774}, {-87.037734, 
      32.602635}, {-87.040504, 32.60991}, {-87.048222, 
      32.623993}, {-87.045631, 32.643135}, {-87.038125, 
      32.660478999999995`}, {-87.030594, 32.674633}, {-87.033958, 
      32.688736}, {-87.02915399999999, 32.703787}, {-87.021633, 
      32.720217}, {-87.017876, 32.729341999999995`}}, CompressedData["
1:eJxd1nk01esaB/AyHGUb0k1dpYFOmbekgQw9JGUrQ/p1OmIbuhs5hh3h3pyb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      "], {{-87.016357, 32.663312}, {-87.017876, 
      32.729341999999995`}, {-87.021633, 32.720217}, {-87.02915399999999, 
      32.703787}, {-87.033958, 32.688736}, {-87.030594, 
      32.674633}, {-87.038125, 32.660478999999995`}, {-87.045631, 
      32.643135}, {-87.048222, 32.623993}, {-87.040504, 
      32.60991}, {-87.037734, 32.602635}, {-87.043674, 
      32.595774}, {-87.057225, 32.587965}, {-87.072946, 
      32.579688}, {-87.01690099999999, 32.579501}, {-87.016357, 
      32.663312}}, CompressedData["
1:eJxd1Xs01GkYB3BFltqQjaJEZIpo0OSenlYsk1PCr5TRBcOU4uQyEyZ3WYWs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      "], {{-85.62743999999999, 32.512181}, {-85.559482, 
      32.512093}, {-85.559649, 32.497971}, {-85.542251, 
      32.498281}, {-85.541888, 32.483243}, {-85.55927799999999, 
      32.483388999999995`}, {-85.559078, 32.454228}, {-85.593307, 
      32.454052}, {-85.593684, 32.468634}, {-85.609989, 
      32.468308}, {-85.610147, 32.454184999999995`}, {-85.626448, 
      32.453856}, {-85.62622499999999, 32.424693999999995`}, {-85.643064, 
      32.424367}, {-85.642682, 32.409327999999995`}, {-85.65951299999999, 
      32.409454}, {-85.659354, 32.424489}, {-85.676188, 
      32.424613}, {-85.676037, 32.439192}, {-85.65974399999999, 
      32.439073}, {-85.65997999999999, 32.468233999999995`}, {-85.641502, 
      32.468551}, {-85.63327199999999, 32.475778}, {-85.629938, 
      32.482586999999995`}, {-85.62988299999999, 32.487598}, {-85.633084, 
      32.493089}, {-85.63084599999999, 32.498995}, {-85.627535, 
      32.503524999999996`}, {-85.62743999999999, 32.512181}}, CompressedData["

1:eJxd1nk0ldsbB/BExoxFhiRjOeZZFBtFEVK95JhuQooyVLh+pUSGJFGhwSFD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      "], CompressedData["
1:eJxd1nk81NsbB3AmRaHFXESNaJF0C9lHeKISogkz0SJZ2+xJSSpaRHWLJNdy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      "], CompressedData["
1:eJxd13k0lVsfB3CXTAlRpriEJKWOqTIUO8o1VYaeiqjI1IQkMlxUyOGQImMi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      "], {{-86.371386, 32.370125}, {-86.371915, 32.378783}, {-86.373527, 
      32.388809}, {-86.37677, 32.39747}, {-86.362112, 32.397909}, {-86.356681,
       32.399269}, {-86.352884, 32.397897}, {-86.346921, 
      32.393333}, {-86.334442, 32.390125999999995`}, {-86.334453, 
      32.385114}, {-86.34259399999999, 32.385124999999995`}, {-86.353996, 
      32.383317999999996`}, {-86.35780299999999, 32.379222}, {-86.359985, 
      32.372845}, {-86.362161, 32.369658}, {-86.371386, 
      32.370125}}, CompressedData["
1:eJxd13k41lkbB3CRLSVLtlS2NsuEImuc1zZIEn5ll13LkDL2PFLImjYie1TI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      "], CompressedData["
1:eJxd1nk41fkeB/CDI2syhGuPVJaKUyGyfFIqisic46Yoy9EUJVRKt5C1kqWU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      "], CompressedData["
1:eJxd1Hs0lHkYB/CJoY11a2RU2Kgt1tYqy7Alz4zdLrY1Lr2J2nHJFK3KXUSS
pejESmiSklInrZCKLenNpXY5lCLlLjFjnSIptk7st/1z/3jPez7n+f1+53ne
53l/xr57XKVKHA5nE55P7xm8inBBN8PqWK+67bqTaLwnoW0ZHNmqPGjsRWS0
ISVNDF/v4vZ8+zNRR3v1G1e4LEvp0ZQbkZpG7VVZH8OGjpnwRuGlmeULT8GF
N3J6cxyJ2r+zeZoD66b7zNkDL7kla06DnUaef6ywI1ruJTkQC1tv8j2duYKo
2D75QS48vbfYU2ZBdGldYmkiXMqTHHRbgnhkXKV7L8MaBZZ27IDzhWqnRcjn
dbmd0BdWM7O/9K6dYW+a3/IOgrMNIh1ndjCsyvmPWiVfE12b8fTAZ3Ces/iL
+KVEAS5nXmjCLaaLZK3IR9H2RDzdxrBmwwLeYzjhrlXkeBPDnklb8VxpNZHj
6gi+KczX9tTygsf1tEZs6xl231iJ8y9wm7ZBdvB9hu0PGnQP/RR/J883hvPN
Vn7Mg+/l8UQzYWe3hifvYbvomtgX9xjWe+ChSYc90cIDOXVH4MWClN+tiIjv
kxISAKtYXvA+KiSadNH4YAfv3tUXdUlE1OvTLpioY9g1qn8csXAgauTw/Rrg
hLdxmm/gdRevxGTBgVdOyg9/T5RYMu/HzXAUV+B6Aw6ZPM+bBfcnL2iq+YHI
mpn4c7AW/Vgg2mq7lgjVlRgg/o3LbasSeOqVodVi2GRXv3jjOqJg1xMTNjBn
YKTbZT3RKL/sy8vYP/+1n8AS/Wblh3SqkW+fQ3LWKviv/oB/4uGIztFbQ55E
Qo2e6puNDHtZodW4aguRbRYm7wHDDk+VahsivmPfeNIHfO/Y4Zroc7C4cUDV
AXFuUNneUpi1L3A8DluYPvYPwf7c+PRsq4cMq29ysVgOH8v0Ut0GW6usWHlk
K1GU3DmpEH6pUWUhg2PKGo8OwcJWRSsH823zujX1ORxaqdScISHy3K6TUgR7
OImG1PE/xO2sDMuA75gK487CGw1DLDvhOgOuYZE3kXR3lU4XfNm+2sLbB/0r
b+Z0w7PfvVxk4kvUIpRoLW5G/V1b0k/AHcvD3SPgJT8l5EfBA7EGjelwwiSb
Og1rdLsPiODaYyETtn7o98FAjyqcV7VB1zhcink5pVepQP3/zeF2onk9/OxC
+Gl86Jrj8NIm/UEu1o81nf2c2YH8pQXrzeAu1es97XCHhdrB+1h/sjktyc2f
6Gh5piQH3j3ZFdYAOxSaSqSw4ebU3+Jh+eGYbFfYnzu/7Q72X1nbF60L5+53
5pshPjRSMJqHfpXUJ9bfgb/Sz2yZBRuonSlKCCDS+3VsdSr6fYh3wmkY9802
daGmI+KvKHdMAcutIpL/hhuk50L3wxeLdO7aoH55XXJxBPzWb6pZABdnvL96
DecNB/fszH3EsHPDRIo8uPeZ0e0+OF2mvtUI+ckqGG3lVobtjE1N04OT5s4T
c+FnHuNOKshPcyJ9SwZcI51jrQw/KswKOw7vM5/Na4HLhrtTap8w7IbJgv3d
MG61Cw9g80RaFox8JpOVFRO4b55J1KP3wP+/T/8FfqOYug==
      "], CompressedData["
1:eJxd1nk01d0aB3CH8lYSim6GTA28Usq86GWXZJ47RGWMCFHGwlEZExclcVWi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      "], CompressedData["
1:eJxd1Xk0VmkcB3BZmiwjEYWkhBlZK1mq6f5O69G04soUTba3lD1LEQ5iZGRJ
RSSloqKVZkSZa8b2EkaNEpH0SqUI8SbLO993/pw/7nnO59zffZbf8/yeu9DV
19ZDUkJCwgOPuM0PvD3VFMpysX07SuYvIhKerN6vFclypi+/3u7UIXp+RDNL
7BCTxM+5cKuhUYk27KpsIpi1gChE5eiTz3DgqZjn0vDx3TJL/oZLWCUpZ3mi
NAtWWAt316+bZStLJOWUYlwPFxekDKVNJ9L8NOZyDP6vhZnqF/fENtZJ4GvC
vxdrKAsjWG5LqXGqPNx+OffOKOys8lgjBo6uevXoFmw1RO6psNBBV/8qrNpV
1qApQzSQLLx+OpzlMvW9GHU4qFpYdQUOi64MFiI+MG2utAOsGnDlvMw3RJ4i
qUIWliJVSx+4KyuvSRHum/Mhzhs2V6rniW04YjSjBz51ICep5ijLzW6QchTA
hXPWWjfDy+VseCPi+SVXJNghv818275JOOw8420PR6V5dynCmaEdOmZHWG6H
EVYK382pstWFtc/r1c6QIFqxUn2eHqw/Ycv4TjGkFFh8XexwLat96yYZ4osE
A52HWY5f0y+pBw+dFPFfwt7+J5rcxxkaXrmF9wAWtFhPF3vZtpsGKXCoXaqc
G1zj7i9KhTOilzfmCRkqaBAVJAWwXNHN5oAL8DJPu6BkOOYSehhlaNDVJf4c
LDlYGlHRzxDb1q2RA19KLJEwf8+QfeKw5UU46lFjbsgbhtzknlplwSlmCo4B
rxgK9Qt56uOP/Rr9cH8zHJTsdTPTj+W4egVND1g5hqu7eIDlHO1+mh0Ma51Y
O2kCN34pL7GHf+MZmo55shzvwtKp8G6GIkujJAdgWfPWf44IGHoj07oxH672
jF880cNQLuXUpsERl+MVCt4ydE01b2D5fpb79eBR/fEBjPcw0fX+PpaLU9fY
Jj3IkHnJDeNVsEtCgOfEEEM3eNmD4TyW+7p6nu66MYZa16TEKMO21CaSQP5s
FFtbBB4sty/sc9z4BEOyV0yPnYPTrZ3VVEQMZRyTPyLthnpIfpEZCM9tunAx
0pXlCnovC0/AvZOR58xg5Uu9aqXYX2fTLbO6XFjO6ZWzSTfeb1Xg8yv3slxL
7wHDUZhJelNbB4dyq9zrphHpq1vLh8HZkWUfnsH5h9YbLNzDcjN6wuc1wMZ6
9Tbfw50Ldhm2SRJ5XBuJuOSM/XLIKH8Gpxcm+KXBin9k+TxHfMSO6Kk1Tiz3
4N0ZrW74/F5RkM9uljt5yHXmR3hr2KbG47DmxsKqfPH5Lsx3+Bnevj3BoX8m
0dw9NkNOsO+nWL79LCKL1LPyYjc7jq9shxOCVW0jdrGcnnTB+x54r+aguyU8
WuSYIIBv+0+WrYZ5W9OrKpVR7+3G/Gn43sRfEFUL23cm+e2Co9LVLerguo7e
L/thqT6riKuzid7pL5lRCHcUq+cvnEd0uKFgRQG8WU2ofRaOnvASlMIGfZYq
T7SITHM/ZohdrhTQKYI3iCeA9bsZnLwlPZ8o8uGf0ePIz2vL2NNycHy2QeAe
7G+bRWJ0F+ILJ7M/NsNaP0T4ivvz3vk2xgPndcld96Qe2G3NIz32IMvN6Xea
+w4uKwpuj/VBvtTKy5/CVjbDNcXBqO9KJ9t78Lfbbp3yCGG5vx5zyQcwXtem
YC9p1OeZopANu7WJ/FOUeuRh9scVdRW4b03HciY6EN9dK5W6Hvfz0qCdwRVw
+OEzCxbpEvVq8PavQvxif63XCXpENa2yphWw9ZmQFil9IlWJ1+rmuE/khufv
y4TT7PMyYuAnB4vuKH9HtEk/PzgOppGZOuroz2jYwfkX2GUpa7YY/4v//z/+
BTcZ7zY=
      "], CompressedData["
1:eJxd12k4lVsbB/DCjpA5SmYZUghJYrM4ZayMzzGeQihChiZHJ7tCUqgoNKHM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      "], CompressedData["
1:eJxd1nk8llkbB/CHKCKMLCWyhEhZZqgI95UsjbSo3BIVgyJmEDHD9NojjKTS
NgqVESJLJonuRDyWptSk4mUooVRSCNH7e+bP9w8fn+/nnOs6y3Odcx/1HwK2
egvzeLwy/An+7wiOck+dcuJ+mH+mkltK1CdZrxIgxXLdU4vKneE3gSEn3ymx
3MWgvO54+K1VcKbtIpY7oqMdEKVOpGAY7RqmzHKZy693BUgR7f7bZcU1FZZ7
tfpP8fExhr7tW7fFZDHLjYlnLXB5xVDHncRDwvBAzGSG6UOGkrkd3Rz6m0u/
u/+8miGp9bU1mfB5F9ms3FKGsv4Qir0kynKFyR0+vDKGzin5WPbDH5WqrEcr
GDpel35gHJ6OK3NtvsVQ2md5vxuzWa5Hs1X1US1DQhdUbcXmsJzblX1rde4y
9KLHYk4GfEKmMP8ULBOa5BQLa4yHHGxA/wuCceHCSbcf62Hz8xmqN+AZjw1H
c2FhCfcmDi5PzddOhGX4aZ5v4PczPxfvvMPQwDcX+xXEWM5zKO7UPxziNz08
5gZbhirq6MJnhjdM34LTRh+/LrjN0K+aWhaS4ixXaWThcQSe4i9Q3QsXl6l/
bUH/Pq2vx2/DT0eaRiuQP9XMrMh2Lsv9tudnLT7mv7rqusNheOWq3KXL6xk6
eulSQjYcHiApxME9FRXDt+Cc6zmtQfcY8kg64PsF3heZ1VnRwFBLRmFSoATL
RRcdEqpuZMjE7eX5IrinmK80CvOFqs6aS7KcmfMJ2Rg+Q8oRY265cOBBXt0u
WOJk5Ipi2O9Go4XAFwquPt0zj+Vcl8QEBcJ9EbYaxqin593PFlfDJ3z4L3xh
/8GH2zc3MRRhqGtpCQu2owCean7Hv4v4S5dHQuOaGXJmVvKPwlmJNpJrWhhq
+rauRB9WO7V6hGAvvnJzFcbfJ/6t8DK4/quKYza8cHXWZT34ySrDSkf4Ss3H
ZFk4P9Nj/wY4rT32+w+tDGnn9bjuQD4H+RT71w8Y2uyUHS1wmt7ocjHU51MP
h8kIWIW90bcEbjnxpFsW8011GdO8Bhe/URw6DMcky5ucbmMohrfQLBRuiKnN
cniEequvlTGFaSx8vAHekF9x7h/kCzVqDSmGk45ubrwPd6WcLU6HhxXLtApg
KYef5Fxg5kVtdBrc4V9YZw4/cN/W7wi/F/TDeIdN155Thpc5jmUcgKeXZ2hM
YH3T+v6tLKxLci2n4YeF/qojcJbjzU8G8HdyYbf4yGfX/0WuAb/3aOzN9dmP
sT+Y3jnYvlTKzvlvhibbOi4kw4j63vsJxkuxuxIHD9/a7t/SzlD5q4Y9O+Gu
QNVKk2cM/RWnfUQLth59wrGwshhfWBv+ZrWszzVYO/GmNKH+lC0HrWPgGU91
MxG4Mqk+YG4HQwdZiSEj1PvQ+tHMPZ0M/fbQLP8szgtPUHi9qE/yzXOEb5+q
jd3bj/qP2Z6kAj87zr1SHsD53ziy5D84j8aPqje9RrtPv7FEOe6D+WW7JfvQ
zh1X0C/AffHV5eMLg0GGgq7Yu7rBImnP6/iwSVmGcJsIy70LrTa2GWJIsH0x
cO82Xso+eHiTpUXFLJbLls4oyX7DULd/sGc4jFMaYfcW8YMV1vroz3cW1i15
j/ss83yYJ9z6KmhBC6ysaT0Rg/H2HWoyckG+mbYcSz682VQ7eQr5CorWmWhh
vpWd7nl33zFUuvz054tw5rLu72Q/MJT9KT7tI+zgb1k0D15sol3nhvWODNju
2D6M/Vt90z4M7im5UL8VtiqNEu+E/z33Iwzt2OYiF4r43YILC/dzzX7vWgM4
9LuLqvPGGUovOvNrGeYT6rMj5Sbatyw44WsM7x8jPcNPDEm3bXspA0+91CE5
OF3NTSge67N4O9zuNcpQL7tWMgT+0pXLTMHz9S4e+wtes+rHe76fUS/BZ0Wf
w9FhI4MlEwzdWdSWx8FBQdt/yplk6LNfqa0FrJUmW1UxxZDvosicUpiMSr1S
p3F/eCd67sL4Hom/15z/ytBSaYnrufAK8S3bmnlE4Zy5VxM8O1PGbACeqN4Y
OQaPXVOc+xSOfJ63aQ7Wi9Pddwi+XfGfyb/QLh2+ssAS+RI9EowG4Q5fP2vD
GYaqKv50TUf/gMdzH43Dc1qLIvSwn7u6E2LjEF8fos5GCr4XjQNRmsJE9+QK
g1bCNUYivAYRolbzylyCM6t2GWwUJWo3XPfiCPzHLw26ZrOJ9I+aLBF8f05G
nY6TmEOUcLg+zw/jPdDZNXlKjKjaUc+hG/M5lL7GX0Oc6LjSc54//G4gslIB
duCKj2nCnTfqv3Siv4ipjkcu9quu9YoXDzZ7Ze65Bw6zu7f/I/KvmHV/aynq
VUTZ6uRZxKfoB0i1C7Pcp7rgiqi5RHo12cPPYD1Dr4MFEkRHBq0KZ2ANBaMh
Q0kiE/GuNFvE+wk+cLDw+fJAF/hy7Gik1DyinZWKp+UF+WeJqdrjPRAhtdyu
EfEpN3jG9tJEvcFLn0bCA/FrFG1lib6XKYqyguUG5v+SDqsHe2/5UYjl3nrj
F4DtBR9OeKGQfKrafLw/1nUdGOWxnKTG1kf6ctjvZyEigbDpqd78UkXkbzhd
lQE36woZiS8kcstvU2iH/60D+NnJjGPh8Our0VdllYkO3F7nmAUb7B8v4KkQ
KXUV3pmCzURSRZQWE73/kiMyDU+FmO/NgnOtZatT4ISJEeEhVaIr6+NL4uHS
Q42uRWpEW5Lv3C2H50a79TbifXRpJjxeFPPf7JbqrKZBtFkkaPEmWPXJouu1
sH+xaPUq+J8Pb3fFahJpK3q6q8DmhlHD2fBlmUatVOSb7a20UR92MJqz1g5O
iT6ozMBXR22sXOG9CZ8TVmgRlcRdNwqFaycel9jDe6MkSr3hAYNPiQ9hdcHC
4CF5hU5pbfxe5+6N7fzqxK2d1117E+0/n/G4WDjjxEX3d93Vwnvvpb2FhBV8
bVZ/ig5sL8b+3TztxDUl9bzmIR6vFDVLOKEj28MIFnesyYr/4sStN47WUEB/
gwVuwXawbn9ytSKsdVD4rBhstPtj/n30byxf+dtbvD/L3HuP5sCWqt51omhf
6OymfBLzGYq5YxIGD83HDYD1blym5BcJG36wc9wH//eXXlNXWI0Op6rA7sf2
MHXIt/PJtKc6HLBsq4c//EAiTD8Floqd0POC/617+Kc4G5vfYRsPRRvBftTI
HxHfDxu254j6YL7//z7+H8nbBW4=
      "], CompressedData["
1:eJxd1GlQU1cUB/BYBYpYFR1cwlYUUGZakQJWqHKuyFILLSI8FetCpalLImIh
LEJELbKIIAESVEqUIItIkCU1UIx5gAjS1hYEVCowohgWgQSsQEHpeV/74c2b
39w799x3//cdi4PHd3A+YLFYe/Bh3mX+yzWfXaDota+l/WcmgGSbxx7xzaDo
HzyLR2feApF1Pw8/jHadZ+Iq0iVEprJizaKPeidWX0f3RXuscsik6BhF1AvG
j+zUK6cvU7TLloM10Wgj43HnXnS1NHNxCa5n/GipOPIKRSdL9Vx0sd7VUMVQ
/s8UHf5MUzOA45ZDIWEitEvE2XePnwLR+dqr5AJ6o0J/ovkJkM+L3nV8g64s
XzJegtaz/K6H8QYzXvnfj4Fs45x3+hBdtoIvU6LTy46vMUSva6A4Pe1AIrOS
J5n5/nVLT75DB0xx1nugS+e3HdS0AVletamDqZemXStiPMsP7mRsqbDuEqNN
+WF7U9BmDjUjsiYgSt4Xxxiv/iiYa9AIJLVfwmdcENVo43wfSGLQvmfM+sy2
GBfLGxxd0Koh+0OCOiBlTnp/xqGV93YXHEBb9Y2ExqBPB6aaqRRAFK3cynK0
/fk+8c5bQMYGTeZWoO+FT7C6CoEsfhVuO3GVovVnnqtV6Mm8InvGEXceHG9J
AaL19D00gk7UXtnFjwdy+3sqLhvzmPp1wewA2nHvS0kp2vawxZy8UCCCuRnG
7uio3wlnBu2y2pBde4mifUxvZkr4QKy5bVsdGKeXXo6JAFII08JVaLPghPiG
SCAnl482DmdRdFGtwwLzKCD72wM+LUN32McFidHN9a6yI2gvqrOXHQ3E675d
+mb00y1WpUExQOasaxL3iSn6TKlgjhL9b4XcLxSdVO6tckO/rRiWO6KnnXSm
nqLHKqyXTYpwXJ4CvgIgRWwl+xpaaGN+thh9zsps+wa0z61MTmIskNhrz26P
4n29qfP20pdngOxsC2THo42Ks5NVaLG6tisA7af21cb+hPOftObdwPvOrWra
vO8cEN2Fhwfmo/kPNnpUJACxCR1P6Rdifl3pJmVon8w4t070qW7/63VhQBr8
LjpUpVE0670NJUXPrOwuqUV3Fr6wm3sC8xYK0jj4/2W9MEqUhAAx6tk+yUMf
C/b22R0OZHTHYPoJdGrIHo2UqZfB7mSdx/zN3XOq0Us1XEt99NFtnk6XkoDQ
u8KGHJMomomnEh1i+VegH7peY2hnJQEyPQDcU8kUzf5q2F2eA+Teau1YGDpi
ieF792tAuG7rF65DJ4lamtS5QLwn80914/qcOtt/xqVAXt9J+SMVPQZTNRHX
gVj0rWl3QT/ff1kxWACEF3ky/xO0l7q+ct4NIPWt9MWjWH9QqKv4BR2de3o4
EL0kh7MstwRIWIx8YxC6XSbJ6K4HkvXj3SfRaOsN5o/jm4GIsovyq/H7Xzmn
yP3RLeq8C1XoRsFNfu9DIAYGI3qb0DltWfk5rUDkJv25t3H/QjfbvN0dQIbH
ZIuG0PEXE22E2C+c5E3hd9F3F+np+3aiHx6rU6Jp0yI/sy48TyYItKMr+N3q
AfLbQu2ib9FbXnvnjvcC6X9zx9gA3cI0iJdAPBtmTX3RKywFe9zVQEq3OloF
oBN4H+/jDeJ5KSelm9HNvLRtHiNABnc5m0vQByxCOdu1mKdO1/5W5vzdNSrR
G+wH/+vH/wGYmstd
      "], CompressedData["
1:eJxd1nlcjesWB/A0adA8SO3KRrdBoV2aO/vRcdCAhvNGhUvkSKV5dKQo4qT5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      "], CompressedData["
1:eJxd1Xs41FkYB3BhI0OzIdHYNMmlQqSLy4Pj0hC2rXZ/ssvakom0CoWui2pb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      "], CompressedData["
1:eJxd1Xk4lVkYAHClKAqJxM0ooTSkpuzVebPNRE3l+oxG2lBP1oirbGMpIeIm
mQhd3EaRxC0l6csSEnUV9SSSbNnvla2Fee/8OX98z3l+z1m+857vvO+36oi3
retcMTExV3xErfj+RN36vyial5coTJIA2HF0XKYEvW2/73vtHwTM/E8KRObn
e6gJvxJwmAl2LEQfcalbUT9JoLfiNz23MIpWzxa/WIgutFMa/SWOotcOZvWF
o7Xntx1oOk/RAZajj5O/EOj/w0QtA31w1UnXPQICg4+msrain3kk7rAaJlBg
rq+5D33OY6WTRz+BX6tnVfeil2uE/GnZS6DvSxlDGs1PFKxN7iJQLyOQdURv
H9zJGesksDTlk2I0Wt+MMG9/IGDc6FnxCE2r5jJ/akPzalnl6HJZyYV73xEY
Et6SHUBHJURrs98S4K3o49xDsy30sh1aCEhLD0tuwXjSX6dw05sI8Huz4+6j
a0Ly/DsbCSSn5XIfoHtM4nl2zwik+Ja/DYqhaC0DtTdRaL9gnpEzuvlWRlJ7
JYEgTtjQIbR8uusyTj6ByiY6wQ3dz5YouXuDgMepQK5OLEXb9FYWz0Ov6l7T
vA398cCVkv7reF5l8Q0X0EIy/TAgh8DOKW5oO9q1Qm98LIuAu8UGmfW4/5hk
fm0vh0DVaoHQT3T+8ktmLK8R+PaZuIeiVayHLHnpBE5ovDzExPdXji7ZqJlB
QKCbzxgJpeiUr6eZbHTVZw1HpwCKFn/x6JwN+rR9U6w3i6L7zpoqWaHDP/O8
In3xexYy7umih1eXaLV5U/TqtLweY3SLGJdjhZYItasMzSQQ0tWS0+pF0cVO
HNnLuD9hb2sEF613VrKhIJtAz6d3ezaifx9axHTEeMNZ5xTE0Y+HFsq34nno
nbk6OetJ0a8P3i7sKCCgWNk8Rw77DbqlRnzvEFjOSwzjY798du+y0iIC0+um
3zqh+x17/PbxCOheVp+2RtuIzWhT9zCeAJd8A/TWdTMj0aUEbKh3nSrogxLO
FlllBHQyAnOeeFB0qPsaa7NyAs6HVGtk0ayoG7r+NN6Xi/bB5u4UPWfqH7uY
CgKXWie29rtRtOnuLcekqwgMfBi/Uoy2FKxzT3tK4PI2v+0h6G0m/t3FtQQ6
jUbdHqCtpXTCtOsJmOfaFkvieuHqyzYOPidQHTc6sRIdtyTGrB7vm2Fbkfl3
HH9eSdq86yUBleM3ylSx/+9MRmrRKwJn++SM5NFWxUUhtW8ITGgUGovWY23K
VlvcSsBH2VD/Jc4fMfC+qtBOoBtk73qiWcozrxZ3EFCNN/+xHt04VX7f7iMB
+Uj6GQftwNynwEL7J3gUpJ7AfKpfxHBFB54IaPHyoWijicEHO9HOUi1GaXgf
EjcscvBF28WNGXLQ4c8bswJ6CIiONxONWSS2GfNbcORw9FX0XEFp6BPM/03H
mf4J6MjsrmbjCQJ5DbN5F9DFBXzfa1hPalx8ZtmnMN4I/cbr6E27C7QT0YFM
tpTzNwJjpruOlqFxtoQLWnhxtu4D2tMn/oXIdbNdI+3ouprhuZpY3+T8eDc1
T1N0iKrRMQu0ianyCpG1vtsS7xkCRZnVthpotQzN2gViAKmBbeob0Ht1Sngq
WC+DMoinXSDGl+TZIYOOSHgSy0Tz62wHfqDzlcyN+cFYj6SwsqIvuWVeqEEr
NIg7dEkCbJarPyoTQtE/j+ss6EZ3pF1/IfKA0mCUJ/r4rHg+hRYHRUMvtF/S
8nn2aEVfbsZ8tP/TyWouOiiiijWJ648kTN5MRqdqeRDl+QCT9hpauZjPih0P
GxjoiOqPz2+jjYTgwsbxrTlZdybQTkubVCLRGJX8JHpXqS5bGk2evr97Buu9
rnpsHQPNGJ0+LPJ/Lfr//49/AUS4D5w=
      "], {{-86.447627, 31.964503999999998`}, {-86.74998099999999, 
      31.961958}, {-86.85742499999999, 31.962124}, {-86.908715, 
      31.961494}, {-86.90856099999999, 31.931397999999998`}, {-86.908012, 
      31.929575999999997`}, {-86.906971, 31.830614999999998`}, {-86.906041, 
      31.753076}, {-86.904764, 31.713393}, {-86.905746, 
      31.694685}, {-86.90679999999999, 31.69012}, {-86.909193, 
      31.631712}, {-86.904338, 31.628535999999997`}, {-86.899451, 
      31.618972}, {-86.901572, 31.613031999999997`}, {-86.899928, 
      31.60665}, {-86.895063, 31.601191999999998`}, {-86.891814, 
      31.596183999999997`}, {-86.886951, 31.590726}, {-86.884237, 
      31.585258999999997`}, {-86.87937699999999, 
      31.580257}, {-86.87450899999999, 31.573428}, {-86.87124999999999, 
      31.565682}, {-86.868507, 31.553369999999997`}, {-86.86471999999999, 
      31.547449999999998`}, {-86.8561, 31.541545}, {-86.843716, 
      31.534283}, {-86.839385, 31.526082}, {-86.701909, 
      31.525045}, {-86.498926, 31.525228}, {-86.49946299999999, 
      31.553977}, {-86.499462, 31.655272}, {-86.448365, 
      31.655715999999998`}, {-86.448346, 31.684915}, {-86.44509599999999, 
      31.71776}, {-86.445606, 31.759272}, {-86.44129699999999, 
      31.759725999999997`}, {-86.441825, 31.774323}, {-86.446134, 
      31.774324999999997`}, {-86.44613199999999, 
      31.777517999999997`}, {-86.446128, 31.783904}, {-86.446097, 
      31.830427}, {-86.446096, 31.831795999999997`}, {-86.441784, 
      31.831792999999998`}, {-86.44232, 31.835898999999998`}, {-86.438547, 
      31.83544}, {-86.438002, 31.842737999999997`}, {-86.442314, 
      31.843196}, {-86.442312, 31.846389}, {-86.446086, 
      31.846846999999997`}, {-86.44662199999999, 31.850952}, {-86.447627, 
      31.964503999999998`}}, CompressedData["
1:eJxd1nk8VVsbB3BxnUxFhVwZIpUxieKNrGUsUzLsrqMoUobjRqV5Elf1eiOZ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      "], CompressedData["
1:eJxd2Hc41t0fB3CikpFoCZFKSnZWxDkJ9WSFbtllU0rJKIWQFFpUiigzkRFl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      "], CompressedData["
1:eJxd1HkwXVccB3CpSVNJLEk8S4oSBqGhJMJrPOdYY0+CO9ZE8uyiqMdTGiMq
qL1DPNuUkNpDMdIQ0+SGTB7PNtJOG6YvMTK1hJA8k2Roh3792z/u3PnM+d1z
fuf3O+fq8RN8Ij6Sk5PzxrP7vtqntdQQxLBSu47xm3WEehvNvEoKZdgUf+Gj
OVi3R8qjcQzbXdi4zw52CbWv6Yln2NKHfa3n4DX9e4bSBIbVr+1Y4MJZy33x
2UkMG9r96S8nYLNSK/1d3xzYdEnOJPTpT6rJ38IjZVxRagahlsWG6mGJDDsh
cHrgATf2XvGKgIeVJ1tK0gj9w08t5yLmf18pLc+Duw62K3rDSrUj43uFiHfy
0DmHfOaP1o9upyCftO2+C/CC0PzD6NeECt7e49l/xbACd+o5BPcq/pX1JSwK
0Cy+Fk+o3oi9wknsz/aDjhkXtkqTxN6/yrAK0cfivoklNGUxfzEO45kWwb0m
kYQOaMiv2OD7fSH+45+EEap01n95LZphp/oTdQ1gd1H5+S342OkAG7dQQlW7
tYueRTHs9QG1ExR+qao9+jd8qC1G/bcAQufFVYOiWIble5Q2p/sQKvnHpkYf
63PEWf5jFwhtbTZYScT64gPLb1Qwfn9wMvdf+PFUpvIlX+zHhed0G/l8SE4R
8+Hpnmz3EOx/2OT5iC3idwRV5uao1/nNP2USzNdYU3ZnGFZo2Wu+hXGH8sdl
Sai3/sbIZwf9CDW+qz4thJfTG1eGggl9VODbmYN+zZa0DfbCE3ptOWWwRFWg
koz4nuetnGZ4vWAu09Se0FWVne4m+OePjRWtLNFfsawrHfm5Dh8XbFgQ+lCm
y3OGlTzjVQNPEnojfM+RfuyHd7z86OwpQos+rw5Lg7dI3qbsNKEqS56zfnCM
WnSqK5dQR1/hlj3MKdGt4J/BeQuZH5GHn1r6rLfZElpt7PBKiPoVSHKtKniE
SkN5a8Fw/oT4boMdoYOXEye0YX74qNYYIdRO8v0BCus0RLpykH+e+RFnV1hu
K2NnAc5Y+m5rtz/PXGxnJpwI9TrsIZHGMCzzTnbGy4VQ5XVutxa8vb/aNBu+
lLXkVo3+L7+ecnaEDS7VTXJgjcUEBz14eMOnxwL99xYFrVvDS/VzfOdIht3z
LvL3a86EagVPqZREMGyyw9ItD6xnzY6nvgln2Mmm/vZVR0JHE6ZHfeBxI9Pc
DljngaeqXhju78Uox23k69ciH3iOz7CF8b8274PLUpUiWq8wbF1lQXEarPCo
PX3zMsOG+2k+kVJCE/abcvzg2KiqWR/Uw6wQlcL973uZ+8ILvhlzakADHpIG
Dr5G/WSrsk5l+A6XfnEW4zHajJcKfFjZuDbJjdCxmTO3O/E/cdRs55vAOI3i
fniBe+xF03lC2+qtOW2whlCjfJtPaKpHEtu1G58vsq3D/UrnaGr/AE8vp1mr
XSc0cna7ogJudEgRvM1G/KFm40o4qPbJ+6AiQqPLh41+hEUVhk23Sgn9///s
P2CFPCw=
      "], {{-85.789272, 31.617884999999998`}, {-85.85055799999999, 
      31.618257}, {-85.865073, 31.61834}, {-85.983344, 
      31.619404999999997`}, {-86.145714, 31.617755}, {-86.14391599999999, 
      31.537895}, {-86.156808, 31.537478999999998`}, {-86.156302, 
      31.530175999999997`}, {-86.19443199999999, 
      31.529829999999997`}, {-86.19415099999999, 
      31.462284999999998`}, {-86.193699, 31.439919}, {-86.192953, 
      31.212566}, {-86.193007, 31.198411}, {-86.193033, 
      31.191561}, {-86.125109, 31.192722999999997`}, {-86.125692, 
      31.182222}, {-86.116602, 31.182191}, {-86.11654999999999, 
      31.19315}, {-86.012788, 31.195027999999997`}, {-85.948602, 
      31.196098}, {-85.92453599999999, 31.195975999999998`}, {-85.847517, 
      31.196465}, {-85.79136299999999, 31.196122}, {-85.791387, 
      31.254569999999998`}, {-85.790193, 
      31.329895999999998`}, {-85.78940899999999, 
      31.358196}, {-85.78931999999999, 31.368237999999998`}, {-85.789692, 
      31.386957}, {-85.806846, 31.387065}, {-85.806713, 
      31.402583999999997`}, {-85.82441, 31.402236}, {-85.824292, 
      31.416386}, {-85.841985, 31.416947999999998`}, {-85.842406, 
      31.431099999999997`}, {-85.859037, 31.430740999999998`}, {-85.858802, 
      31.460407}, {-85.84109199999999, 
      31.460760999999998`}, {-85.84151299999999, 31.474912}, {-85.823804, 
      31.474805999999997`}, {-85.823559, 31.504013999999998`}, {-85.806917, 
      31.503912}, {-85.806502, 31.489760999999998`}, {-85.78878499999999, 
      31.490105999999997`}, {-85.789254, 31.497867999999997`}, {-85.789272, 
      31.617884999999998`}}, CompressedData["
1:eJxd1ns0lVkfB3CXKbnlTiKh3HKneDHszXE5khQeYZBOChHVScrrkpRxy5TC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      "], CompressedData["
1:eJxd13k4ltkbB3ANkihJJDFEdo0hpQadYxeF1JtdiGyh0jLWRNkl2SsRWXqj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      "], {{-85.487926, 30.996456}, {-85.485608, 
      31.053994999999997`}, {-85.485253, 
      31.125245999999997`}, {-85.48594299999999, 
      31.198324999999997`}, {-85.553344, 31.197547999999998`}, {-85.710613, 
      31.195121}, {-85.79136299999999, 31.196122}, {-85.847517, 
      31.196465}, {-85.92453599999999, 31.195975999999998`}, {-85.948602, 
      31.196098}, {-86.012788, 31.195027999999997`}, {-86.11654999999999, 
      31.19315}, {-86.116602, 31.182191}, {-86.125692, 
      31.182222}, {-86.125109, 31.192722999999997`}, {-86.193033, 
      31.191561}, {-86.193038, 31.190191}, {-86.193285, 
      31.124886999999998`}, {-86.19095999999999, 31.03353}, {-86.190966, 
      31.032159999999998`}, {-86.19001, 31.002921999999998`}, {-86.186808, 
      31.002913}, {-86.186843, 30.993775999999997`}, {-86.11962299999999, 
      30.994023}, {-85.805925, 30.994332}, {-85.49059299999999, 
      30.99648}, {-85.487926, 30.996456}}, CompressedData["
1:eJxd1nk01ekfB/ArmrmDEkW2SFnKcrnGFtXzKCZT1rhX1iyJihgV0i8lU+RK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      "], CompressedData["
1:eJxd23k0Vt/7N3CUkiFDIomETIVClHTuk1AZk2ggFZkzVFKhiERFJZKQMiaK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      "], {{-87.64331, 30.501526}, {-87.660808, 30.501343}, {-87.660485, 
      30.515981}, {-87.642984, 30.516164}, {-87.64331, 
      30.501526}}, {{-87.804276, 30.552329}, {-87.821784, 
      30.552121}, {-87.82149, 30.566757}, {-87.803978, 
      30.566965999999997`}, {-87.804276, 30.552329}}, {{-87.626841, 
      30.383692}, {-87.644314, 30.383511}, {-87.643988, 
      30.398152999999997`}, {-87.62651199999999, 
      30.398332999999997`}, {-87.626841, 30.383692}}, CompressedData["
1:eJxd1HtMk1cUAHAQFApFEcezlEcLOFaRYlOJDHoPdASmVgzwAW4uMkAZQaHF
4WIKFYGhoNQhDe1AQIVkrCLdmK08fHwER4bIkGUTxwAfyEPCa5siopad/rs/
vtz8cs99nns+75Ts2INrzMzMPsLP1KbPGWz7myl6It+9vyKIwFjwraV76Erh
jLcb2nX73RVT/znaU2FcFcHuw6IWOzTb9Ur/KjpWzCowOTs/Kft3owj4CrdX
k5cpWiaLz7qMDjwdLelE05ZZo/0Y7//88y9y0apaxV5ncwIn0uUvStCb27v9
tlkQGAwtiFSgP703YCdZS6ArgeF0Cu3MbGlvsCLwS2vy03NorZ5vO2dNYH3R
a14amvPGq6+QQWBt0H19ILoaNp5xsSGwLDxv+eQSRTuUmO9qQf+1U9ffg25d
KHt8wpZA8YNudSnaPffL/eVMAh/G5k85ozOtlX1tdgTGRyt+HL5I0XtPF4ib
1hMIX1xeakFflaTKA+wJpB5PDEtGF9vF6FQbCaR0ygvm6yn6mCQ6k+lAwBju
I1aifZ9X9wZvInB3d8a7ALTk77YmJ0cCmXl+b6bqcHwUK6oZ3VE33bGIlvwR
1truRCBaOPvqDrqeLf0syBnXS/lXdgQ9LviTxKBDchoFfDRzUveNKT5v0COw
sZai47gvBC/R+3PZWn90SNLqFB/jR9fpHw1foOjlYcGuNS4E3o7cV9WilTsG
HqrRe2b6ftuDluwMv24y66V9+XwNReuOU+l6dP504UoVWr41rvKxK4GTveWc
TLTUakYVxSJgn5DKMNl+XKibcScw0Tq4g6BnEkM869gEIjtt/E0eZSwdmPIg
EAG3im3Qdzgl7B4vAhahGU9aqylasOTL2sDB8+Zpbh5GN/T+7JLExfd4dMjh
n28perb+O/MiHwLdadrkeDQvs+apzJfAkYT8FoMG74evuR3hR+Ba/JhSilY3
jbk9RHMlNyxC0fqu0ukhNN27XWqFBsfgrKDNBM4424qfqSna9e27FMP7BKzk
m8Q56IOvO5ir/gQqz174Ogzt51iuv80jENf3YIWDPnAsxsNpK4F9w9+3j1RR
tEGxMlAdSECrfpSxDeeXdGoOdaC5J9fVhKB11sbr54UEfm3ETOP5nxUzGvah
LSe940To9IWzhg8C8P34iL4qxHz0HIrSLmwhEFzWLFSh5yKvseNwvwqpKLcZ
81vlrcyVoRsmYIMezdvS5rmI8T9crTf+dIWiGaZCMM2nv5FzEx2hI6UDWN+8
GK/Z97B+j6ZNqLv4BMo8U+c/QQ9FOxTz0NyikUgNOrFi0Pxj9P//F/8Benb2
Yg==
      "], CompressedData["
1:eJxd2Xc4Vn/cB3A7q4zslYSIlJSEzn0SkqyKG5kNLUISklFSURHKKpHMRJJR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      "], CompressedData["
1:eJxd1Hkw3VcUB/BXS8SgqC2EyOOFRsQSYQRxr62tpSr4qSWILdbQZIg3pJUw
EunU0shIa4k1aZqI2qlafqI0jNA0hISx63tTWlEZKn2k3/dv//jNm8+cc+67
9/x+53LDk7yjJDgcjgce8a9yjfdqjIBh73/bolpgT6hw+s+0WLh7Mn3d5Qih
33Hvv4qG9z/3Vc8+TOj3E0clIuCF2pxioT6h+orO6uL8HCOR5sxBQus15zIT
4K/bTu9MKhHKXxFNRcGB32Rf9HxrTyMLRTmhvzOswLP+rQ0co5fAT4M/tx/K
keMQulolvJI/z7AvJBxX5hEfiG7MuP2EYRNk9DdlEU8u3Cfl9yPDBrz2lJ5G
3K15ab25lWFLYz7lLsOjZ8cFcTDtWZvtxP9PK3vKhTQzrGxllsk8fHVX1sQP
Vk1Od41QJVTtUZxxWBPDPtUO2I6CH05VbAbBWzp9EQTnux0kdJOCk85cqH6s
R6jo3CcFk40Mu+N66S8pxG8s8252w7nD+hlmPEK1U91kVuC0O8ZO2oaEhs3z
nuiivv2zgzy59wmdnbEUusN3ompmfNBPdc/fROawk5aa9QsjQu/1z4W9RH1d
aZfFS1ipwLQyEz7dJ59rCB864GW13MCwRQWKaVZ4P+6B6wrZsEvJ4rSBMaGR
XBupPFh45CML9aOEzj8dUI6Hdx14Tnnw+pqFiTbc1ath4ANHO8cmvapnWPcH
3PP58EZtjdos/JX8BY0wE0IV4npaVJB/84pkYAdcpNs+JHZV07CeqimhvNaf
ZITINyt7fs4Ltrt2zLcfbgpN7dgwI9TP+ePX2/DF7nItU3NC6zImokfE639g
/wP/GPq1d1DCAOvplnX8HQCTuy2xCXBir3cwa0Hou5EnW94g33FwaWzkOKHl
KblFkohPGl4Oj7QktExx9L1IOH2iwrQLThFcF4jrhcrVAnUrQrmLp4zmUb/e
8UVvojWh++VT/MX2skyzpCcIXeZLVxkiP0ay/h1lG/RPukfBHO58LCXSOklo
jPTV2kQ4ix2qdMF8jI2WfOkLR2ku+GsQQp3VduWTYIO+9Ut7KKEqz7L9d7D+
Lwo9JYkOhP6ToKO9CpP+83PjjoQGyjX9OtLGsA83km7twN1Z5daXOxl2pCd4
cwXuP/GHsP1nzM/e3DOLsHi7Rc8YNsiuU8DCNoVWzBa8W6Jh2A3zi4f5QRMM
m3nvX04NXJ6s1+s7hf2KPxxYco9rud8sw84V274JhU9lk74SGNMcrIr9iSwD
qg/MMeyjzUJze+yfaPOct+GGa5sNmTjfTP6UaTnmcU2j6dADnJ9z3O3WLtzG
HYgPQX/uto45hCzg+w+uSou3I3Rk+3Ce5CLmpdjedg79VNvX2DEOe8UXp5bC
PjdSrDuWGNbDXMbhQ1tCt/K0VMKXGbbCo3qwH/Vn3VaSZHEf6GipV9dhffF4
KYnvjwx3zi78//vqP6sPOl8=
      "], CompressedData["
1:eJxd1nk0lVsfB3CZEqrrlpSUG7dEuRwimfauSKtSyIMTKiLzUCE3KRG3FFdk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      "], {{-86.700015, 31.193631}, {-86.706436, 
      31.194989}, {-86.70803599999999, 31.19316}, {-86.706426, 
      31.19088}, {-86.719796, 31.191311}, {-86.720862, 
      31.189939}, {-86.716036, 31.184925}, {-86.71870899999999, 
      31.184919999999998`}, {-86.722455, 31.185826}, {-86.726734, 
      31.186273999999997`}, {-86.735824, 31.185798}, {-86.736896, 
      31.186708999999997`}, {-86.735834, 31.189451}, {-86.732091, 
      31.189459}, {-86.73370299999999, 31.192196}, {-86.736909, 
      31.191276}, {-86.73906099999999, 
      31.195380999999998`}, {-86.74280399999999, 31.195373}, {-86.747073, 
      31.192166999999998`}, {-86.755634, 31.193517}, {-86.75989899999999, 
      31.189397999999997`}, {-86.763616, 31.181168999999997`}, {-86.764675, 
      31.17797}, {-86.76734499999999, 31.177049999999998`}, {-86.77216, 
      31.177951999999998`}, {-86.774293, 31.176119999999997`}, {-86.773746, 
      31.172468}, {-86.77961499999999, 
      31.168799999999997`}, {-86.78922299999999, 
      31.164665999999997`}, {-86.794579, 31.167392}, {-86.799926, 
      31.167377}, {-86.801508, 31.161436}, {-86.798816, 
      31.156419999999997`}, {-86.79559499999999, 
      31.152775}, {-86.79288199999999, 31.141364999999997`}, {-86.794468, 
      31.136794}, {-86.79713699999999, 31.135873999999998`}, {-86.802488, 
      31.137686}, {-86.80280599999999, 
      31.079680999999997`}, {-86.81775999999999, 
      31.079639999999998`}, {-86.81824, 31.065935999999997`}, {-86.850275, 
      31.065382}, {-86.854794, 30.999589999999998`}, {-86.772098, 
      30.999823}, {-86.701662, 30.995406}, {-86.688324, 
      30.995428999999998`}, {-86.688335, 
      30.999996999999997`}, {-86.70007199999999, 
      30.999976999999998`}, {-86.70000999999999, 31.191805}, {-86.700015, 
      31.193631}}, {{-86.983646, 32.837413999999995`}, {-87.01912399999999, 
      32.836802}, {-87.017876, 32.729341999999995`}, {-87.016357, 
      32.663312}, {-86.97169699999999, 32.663962}, {-86.96516, 
      32.663989}, {-86.96432899999999, 32.708169}, {-86.915281, 
      32.708359}, {-86.914321, 32.837686999999995`}, {-86.957993, 
      32.837975}, {-86.96072199999999, 32.837964}, {-86.983646, 
      32.837413999999995`}}, CompressedData["
1:eJxd2Hc8lt8bB3CZCVklROIbJaNFtNwHISMNHjIzooyQoiHyVSmKiJSEJD3J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      "], {{-85.74229199999999, 33.582249}, {-85.75331299999999, 
      33.582321}, {-85.753942, 33.574138}, {-85.79525699999999, 
      33.575308}, {-85.79592199999999, 33.562576}, {-85.795976, 
      33.556664}, {-85.744199, 33.555881}, {-85.74229199999999, 
      33.582249}}, CompressedData["
1:eJxd1Xsw1WkYB3B1SpSIddhDZdxKu2hbsSW2R8guWZf6KaXYUi61RVS7tlaY
FMoll+QskpTcK0ts8XM/5FqiOlFOEl00Fbmz3zOzMzuzf5w585n3/T3v83uf
531/6rsPOe6dLSEhsR8/8X+AIXll1jOsp/E63uIZIpu+bd1MA8NO1G3wl5Iw
o5+0OcS9x7BGuYqzS+CWVKOsB3CJciI3HP7kn6ej3ciw47vMfVzgZWdK5Qh+
ZqCQJg8HTPi1RYtdYbeYEP9mcdynGjjctDCKO000XeiQLNvEsCLTeQma8JDB
cKklXFoe8LQYNvDsT30Oa9re4Zjg+aXcmWMWzQw713NHkzHs03zmfjccfFhY
ZgWXJ+o5c1sY9m2X2nsGVhobNj8gZNgxD8kPQfDDV95ff37GsEkFU+5n4YWr
U/2Kexm2xZbvq4J8HZdfCivoZ9ghe2GoA3zCZKgrF36X3OakPUy0Y+6q1r/g
AZmzd3LeE9WG5R9VfIX4esbO3rBBeRJnjohhq0pCeSrwlLfsosYehl3yIjwi
/RFRG0cthIt8GuyyThjDPNXSx2pwUWdwt2oTUYtNTe2dToY1/NU1fgHs7OU4
vxT+uUerSe0e0bllynvc2hnWW69xwzq4TPdduwusGPsd21hBxM/MKOG2Mawp
n0nNhq3d/GRT4JPuxv4BlUQxMmuLxI48/A1fooro+zlM+lbYwWNQvQfW21lh
JGpl2PLAT6JqWPHl/dFTsP61OdVaeN6OSQvaBi+McOh8gviObrM28Vr/Wz+1
V5YvwP5HTI6rG2H+rNP2GfvgfcOyxeaIF+8quccCfuisV1BXTdQ/MsVXhv32
BFQq1BDdrdV3uIt6Hrx7dd5cuGSz8bYZ1P+XxTeUUjGfu3lg+Z/w00UvDPNh
+8kv/TrRT4fDNOUsaolU93mayMNXMg1GomEZ35wIIfrVycJ2aAw+oC4wk8Z4
FC/zbGAdUT0nxjIJzpK+PMgR4P1MPBZIIf5zhZOB1vVE7fMfjKjANwNTJGUa
iNZH9gkaML8uRO/oBNx7cqdtCqy3S1cmBvVIezQ/KQEuU1y6+u9GIqGNSvoR
rG/Q9eZKGaxRHX/rGHz6+e2z/GairZSW8j3On+4i0xWxsK7lx3iC8y9clfJp
JWpMDDZsrmPY/TLG6v4wz+nDxr4aho1+muS/AzYLOvZxAFYOFH6h1U4UnG0S
VFDFsPJnOocXwC+mNR+kwc6hazpqOuHuydCwSvR3ek9cCRySUXryAnyvc++o
XRf6w3V9tST8Vc4Wewf4ckKfkxRcqrvMSO0ZUVBj8+VjFTg/ccEHV8Iu/jfb
A+CoNe6cARHR4yOHLHezDGt81D7sDayy6lbLHnhTeJSdoJfousLeQyvKcB4k
fLfmw9ecL3WpwxqqPyjz+3A/pNY4at1l2I1SUUaR8ERuso40POpt5St2ixXP
dxbs7HHc1aWf6FZrs5cSfNCmN9jgLfbPSkApsNlGOqUpduJoeiYsZ6HkJXqH
erZKunGw3u8dhttlB4la27IS/JFf9byjk8rwSMyO2INw7ZXyC5UfiM5rfJsj
wv4u5WU3zcBTZTgYcN+Ai4P1R+R7e0bgX8uwQu64G+8T6smJC1WBfRI9o4Ph
8nfSCkLML7bQXxMCn3K57mEGI9vRCfjG2G2jLXC8+5LIvCGioqB19tfgl4m6
g+s/E+kvlqqfjXji60puhKhm7ev+27Cb4LVTC2xem76lEvY0PX5RZ5SIWRX/
h9jn3kfYMHDe7g98sd3ONyj6wT+GCJ+I3bE5Oz8PLlRboVEFT+kmaIzBU6UP
kpej3wpnZnVkjRGl51prTGC8bX1FTfg40eT+314GYLzIRlXWZoKogwnaLiPA
+XypPRMLD7x194mDJzMsT5yf+DdfeGd4dkMZLDoyFdwFR8vb90hNoh46Whcf
wpH1omnNKaJnK/fZOIm/R01R5YW4////ffoHqSJmbA==
      "], CompressedData["
1:eJxd1ns8VekaB3CZakROOSWiIlHudymKtdzZYkurhCiSaxcikaGzlUvutQ3t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      "], {{-87.805996, 30.227524}, {-87.80511299999999, 
      30.238516999999998`}, {-87.78981499999999, 
      30.240527999999998`}, {-87.797286, 30.245016}, {-87.806895, 
      30.25085}, {-87.810074, 30.251269999999998`}, {-87.817482, 
      30.251638999999997`}, {-87.823833, 
      30.252019999999998`}, {-87.82699699999999, 30.251524}, {-87.829089, 
      30.250125999999998`}, {-87.830653, 30.248735}, {-87.833274, 
      30.247329999999998`}, {-87.836438, 30.246834}, {-87.840659, 
      30.246325}, {-87.845401, 30.245351999999997`}, {-87.84907899999999, 
      30.243934}, {-87.851692, 30.242071}, {-87.85325499999999, 
      30.240679}, {-87.85535399999999, 30.239738}, {-87.85957499999999, 
      30.239227999999997`}, {-87.863795, 30.238718}, {-87.86643, 
      30.238228}, {-87.866754, 30.225869}, {-87.86464, 
      30.225894999999998`}, {-87.857778, 
      30.226437999999998`}, {-87.85197199999999, 30.226967}, {-87.843502, 
      30.226156}, {-87.833439, 30.224905999999997`}, {-87.824984, 
      30.225008}, {-87.816543, 30.226025}, {-87.808103, 
      30.227041}, {-87.805996, 30.227524}}, {{-87.77683499999999, 
      30.255779999999998`}, {-87.776778, 30.252119999999998`}, {-87.763556, 
      30.251814999999997`}, {-87.76361899999999, 30.255933}, {-87.732422, 
      30.25583}, {-87.72193, 30.261438}, {-87.721097, 30.276546}, {-87.725856,
       30.276493}, {-87.72423599999999, 30.274224}, {-87.724195, 
      30.271479}, {-87.72469, 30.269185}, {-87.72729199999999, 
      30.266410999999998`}, {-87.731481, 30.263619}, {-87.73409699999999, 
      30.261758999999998`}, {-87.736205, 30.261277999999997`}, {-87.738841, 
      30.260790999999998`}, {-87.740963, 30.261224}, {-87.74256299999999, 
      30.262120999999997`}, {-87.74365499999999, 30.264397}, {-87.743168, 
      30.267148}, {-87.742159, 30.270362}, {-87.741143, 
      30.273118999999998`}, {-87.74117, 30.274949}, {-87.741191, 
      30.276321}, {-87.754988, 30.279366999999997`}, {-87.756039, 
      30.278897999999998`}, {-87.75759699999999, 30.27705}, {-87.758613, 
      30.274293}, {-87.76069299999999, 30.271981}, {-87.762772, 
      30.269669}, {-87.76588799999999, 30.265973}, {-87.767439, 
      30.263666999999998`}, {-87.76899, 30.261362}, {-87.77054799999999, 
      30.259513}, {-87.772634, 30.257659}, {-87.77683499999999, 
      30.255779999999998`}}, {{-87.96309199999999, 30.233779}, {-87.938253, 
      30.234106999999998`}, {-87.900784, 30.237795}, {-87.90822299999999, 
      30.239988}, {-87.911954, 30.24177}, {-87.91462, 
      30.243108999999997`}, {-87.91726299999999, 
      30.243074999999997`}, {-87.918864, 30.243969}, {-87.919433, 
      30.24625}, {-87.920529, 30.248524}, {-87.921618, 
      30.250339999999998`}, {-87.924301, 30.252592999999997`}, {-87.928041, 
      30.254832999999998`}, {-87.931781, 
      30.257071999999997`}, {-87.93656299999999, 
      30.258381999999997`}, {-87.940263, 30.258333999999998`}, {-87.945013, 
      30.257814}, {-87.948169, 30.256857}, {-87.951324, 
      30.255899999999997`}, {-87.953935, 30.254035}, {-87.95496, 
      30.252191}, {-87.95440699999999, 30.250826}, {-87.95332599999999, 
      30.249467}, {-87.952781, 30.248559}, {-87.95487899999999, 
      30.247615999999997`}, {-87.957002, 30.248046}, {-87.960173, 
      30.248003999999998`}, {-87.9628, 30.247054}, {-87.964361, 
      30.245659999999997`}, {-87.96486499999999, 30.24428}, {-87.963247, 
      30.242472}, {-87.96111599999999, 30.241584999999997`}, {-87.957929, 
      30.240712}, {-87.95579099999999, 30.239366999999998`}, {-87.955766, 
      30.237994999999998`}, {-87.95732799999999, 30.236601}, {-87.960995, 
      30.234721999999998`}, {-87.96309199999999, 30.233779}}, CompressedData["

1:eJxd12k4lVsbB3BEyTEkpxIZk9KAVJLIs5FZCVuZx22IikTIFCLbEDIkQ+io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      "], CompressedData["
1:eJxd1GtMU2cYB3BUiKJdQkQml3az04lAuKxsgAXacyRc5DIucloQZAgTYaNF
rkUZOhC1IC7iwAlMIGM65S5sDoXBSRngIBQmCiKoU2nIGNAMRVYB2f/dx31o
ml/O877v/3ne0/JjkkIOrdXT0/PHh3xv3vtSUFDHsIPjD2Z8/GjqqfgRlQNX
8LktM7BgrTWXrmVYpZFU/RhevtoUQmwo/z6xyJ+mpvKnEtegftLf+GYlbHtD
YK7Dc025TO4fSFOJYfvCt8BZDlYiEex+MH99cQ3D/rXi5Sr/mKYsWtel911n
2BLPg1s9A2iqmue8LIdNd2TvJ/Y4f3JzHCz3m8x1RH3PUvKS5hrDXuD3jhBz
3GNeTsAdPvH9t+DEkuhkF/jU+oGGLJwn4AndtT8w7DcpHQ+II/t0McSmQ5sU
dkE0pcfNehUJm1ncHnsXrvyqlxNK6i046WHBNGXKd3tI9nsuuzIaB3dqn7QT
b5Dc79eifkPDvL4K1pyYVxDXWH9o1A/vnumIzYSP8nnvqJC/qy3yVwUcpBud
J/12WV72cUAebRe9h8xD/Obud2Q+c6Je77PEd5qjn5H8tYpWHuaXzZ9sX4Xj
Dv/uagIbKHPN9oXQ1BOdp+FrePaT8IQQePmR62f+uI/Pc9x3Eqfu8mCIS37e
/u3b8DZ1lyGx6Hx76i70o35sJmPqGTbNYFxpCWcIXHyjYL5BIF+KvG+0yo33
US/x2l5J/FvDj4X34OFF89znmHdp7kfqq7AmhlNH7F3vkN0IF12qOp2E+7vr
nGC+BfvJVb8IiJ23nhg3hsuZytp6vC9Ct7y/h+E824ylOnglryWiH64p2zYt
wn5ZFWJZKCyetJWK4ZwIxQtij57qUBXmYZ2ibN3dgH737I8dgo1qxSoHOF4T
FS1B3g7jlihOI8MmjfyRzcDnmo87ftCE/HmzlrGwLj65xwE+5lQrkmK9feKA
JAr1qZ5W/DDY1fzM6wNkve3XTzNxfnVP3iU/WBhBxbvDY0ctynkwN/OniVL0
13bMxIz4v/tAP2GMfecw8pTsvFI1jt/PyNK5jAnYPMCuh/WlKekFt9FFmKmW
riuGu7uDb+VjvX6RZ1nmXpqyecidckK+8u6zp/g+qKc5abOwKuiMidybpkh7
Grgt+sgAD/V2KYFSxQ2GrXbx5hGnlZbpJ8FVSZsuTmP/ICfNRi2su81Z/RN+
Lzg+fBFeOelzmov6Z+G5hV82M+xhbeFNaziwsfiQEr64Y3Ah24umDgRUNJeh
vuj4kvAI3LQqdJbh/Gm18eAYfP3FtX86kf+LoZbwBeS7vGDV+ynceW+wvAD5
k514a0j/sjtiRyX2T2D8hH24T7Xjq/ctMJ8VG5sAX7hAMmcQB0veUk3M4X2y
Z0XCdPj//1f/Al7xNNM=
      "], CompressedData["
1:eJxd1Hs4lFkcB3CsrFablsqwLknjNo02pdydk5Lb8lBjx2JDuaxYuU1IRZNy
SyLasmq1qxDaYqVlmK6LrexDral0MSu3XNY9kdnvPM/+tX+8zzyf55z3zDnn
/f5+uoGRnkFyMjIyXDzS35jDU3WRezlCHda7iDQWJaPlHz+whzPkDq52N6bk
7G+sen84pe/lHaYRJYa7k74XwG0NmrxXBpSoHdpnGxfOESbXSGT/0qckuFOw
Ih1+c07ubBGTklse44Oa8EJbQGPDGkoiZDat2iId/8bfyxCO35WvlI/1rpw+
P8CEAzuneS5whMUZcTncZZyWUgWLcz79ORPrlRQ76LbAsQd1lqrg/+6u8W3W
g/We6j1egv2EPjzZVBPGEcqunJ2yN6RkPC/sQjas4fHs8yTsf4NrRBkfnk0m
Ie04X23h68JLsEue55/DOP/d/pupVbBprs2Wh2sp0UxYdd0RrrywUN3LpoSZ
o1Jf+y1HyLA7cWACvjmnqcOGxyadvY+ZUPJs5wu9wlCOMJPBY+TB9Lxf41QI
R6gvrpyIXEeJ8ZWBxIuw7wfRGrsvKLkfNiEph5uH1iZehv3SyZQybKJhql0C
L+fK7FCA88/Muy/Ap4W9mtZw4+R038X1lFzQfm76OpgjtDIXFTJMKQlR/H3t
AZiXxTLJhi3a1RkJwf/tdwMlP8xIom4HcYSaj+bDlm7E/fQ7cHfCk5dPDMbC
e1Ns9D1htRFfxoAZJZPH5por93CEX7qqBU7B+uU3FGrhJdFqARmbKJnRurPb
DhbtOZGYBr/vcIizhHlu1aTeghLlMWWfRPiaa9PWBrg516JgP1zJ5wvSrSiZ
Hoh/QOCj/4T+nQZvG90ptIHlxXEfjthQYrWjv+E+nOV0eF0qPHYk7XENvJvZ
6+0E25sxvY/DpS81RMawTAz762Q4vy476h7WS6hQV++BdSUPVtlaU1IojvJg
43yF9zJTdeHbJhna7zAePxRybTnml2aUTapivFY0XN1qSUmrUJbtB+/Sc1pW
BS+RYx1fCTc0y89r4Dx+goyspXBpOHeHtzny4mvZaw2vkHUbFW+mpEhkP8eF
F2oNHMPhP5wRNLjP/MbiGdwX45RhTQWc21JWFAB3K3oa8fC9LAwDLg1L779Y
adAHbo8yu86Cu5MGuSWw1ycpvmJ8r4Ot6727YFbIaFYt/NarzWkU/uh6Z70d
/Mbgia0W8rJtWV+3PNyrYK/lBSd2P0o9hXxE7tGe5cM2HS5ZQbBoF89dG/nt
cHR5MwyXO1xVMITfblbtSIVfvfpR8B7z2a3hOU7SvBXIl5bBTUo+1fnIY09o
dsU8/EK/izWBvLaXHHYyxvuTbou6pI74ztWdC/cU2auXw7EjPMFG2FYn6O4i
WNH8qLEZ3HfrhXc96iW7eb9RHHyV2cM/D8efDfipAlY6V8BVh5P9s7WbYIst
CuNDqDedulZVRdTjCvOnCiMw3z1mfDV8JPp543bMf9Ir4WyHn9r2sL+C24r8
JXGw26FMtwLMX7ZaPToc9f6LxHJzBCwvbTAw/fVWej/qXRqTFniriiArEHZT
1IpdjP6zXDfOag79wqUlWsUZPiltMPC+vtuO6+Bi1melC+gv/++3/wKkgnrB

      "], {{-85.827798, 33.443134}, {-85.827708, 33.453596}, {-85.83603, 
      33.445456}, {-85.84377599999999, 33.440041}, {-85.848241, 
      33.432333}, {-85.853774, 33.42827}, {-85.85874299999999, 
      33.426023}, {-85.86372899999999, 33.421502}, {-85.86869999999999, 
      33.4188}, {-85.873678, 33.415186999999996`}, {-85.875917, 
      33.410195}, {-85.874861, 33.40473}, {-85.853973, 
      33.40416}, {-85.85446999999999, 33.410531999999996`}, {-85.845123, 
      33.410478999999995`}, {-85.84597199999999, 
      33.374542}, {-85.84157499999999, 33.374517}, {-85.84163199999999, 
      33.367692999999996`}, {-85.827348, 33.367155}, {-85.82709899999999, 
      33.396271}, {-85.819952, 33.396229}, {-85.81987, 
      33.405783}, {-85.81106899999999, 33.406185}, {-85.810842, 
      33.432114999999996`}, {-85.80204599999999, 33.431607}, {-85.801977, 
      33.43934}, {-85.79861199999999, 33.446598}, {-85.80184799999999, 
      33.453897}, {-85.818902, 33.453998999999996`}, {-85.818997, 
      33.443082}, {-85.827798, 33.443134}}, {{-85.53166499999999, 
      33.903993}, {-85.583106, 33.905775999999996`}, {-85.583191, 
      33.898503}, {-85.65567399999999, 33.8986}, {-85.656335, 
      33.888602}, {-85.671824, 33.888714}, {-85.671902, 
      33.881440999999995`}, {-85.686283, 33.881543}, {-85.68664299999999, 
      33.846990999999996`}, {-85.724784, 33.848161999999995`}, {-85.723699, 
      33.790409}, {-85.70491, 33.790735999999995`}, {-85.704228, 
      33.803463}, {-85.64895899999999, 33.803979}, {-85.649631, 
      33.742142}, {-85.649765, 33.729865}, {-85.64941999999999, 
      33.710763}, {-85.65008499999999, 33.700308}, {-85.651268, 
      33.642105}, {-85.646861, 33.641617}, {-85.646782, 
      33.648894}, {-85.637963, 33.648373}, {-85.638626, 
      33.688399}, {-85.63768999999999, 33.77343}, {-85.62111399999999, 
      33.773759}, {-85.620955, 33.787853999999996`}, {-85.60327099999999, 
      33.788173}, {-85.60310899999999, 33.802268}, {-85.585979, 
      33.802133}, {-85.58546899999999, 33.84578}, {-85.592098, 
      33.846287}, {-85.636882, 33.84663}, {-85.637114, 33.87573}, {-85.601721,
       33.875006}, {-85.601548, 33.890008}, {-85.532404, 
      33.888996}, {-85.53166499999999, 33.903993}}, {{-85.78878499999999, 
      31.490105999999997`}, {-85.806502, 31.489760999999998`}, {-85.806917, 
      31.503912}, {-85.823559, 31.504013999999998`}, {-85.823804, 
      31.474805999999997`}, {-85.84151299999999, 
      31.474912}, {-85.84109199999999, 31.460760999999998`}, {-85.858802, 
      31.460407}, {-85.859037, 31.430740999999998`}, {-85.842406, 
      31.431099999999997`}, {-85.841985, 31.416947999999998`}, {-85.824292, 
      31.416386}, {-85.82441, 31.402236}, {-85.806713, 
      31.402583999999997`}, {-85.806846, 31.387065}, {-85.789692, 
      31.386957}, {-85.789608, 31.396542}, {-85.789912, 
      31.423019}, {-85.78971899999999, 31.444927}, {-85.789631, 
      31.454967999999997`}, {-85.789423, 31.4787}, {-85.789378, 
      31.483721}, {-85.78878499999999, 
      31.490105999999997`}}, {{-85.78878499999999, 
      31.490105999999997`}, {-85.789378, 31.483721}, {-85.789423, 
      31.4787}, {-85.789631, 31.454967999999997`}, {-85.78971899999999, 
      31.444927}, {-85.789912, 31.423019}, {-85.789608, 
      31.396542}, {-85.789692, 31.386957}, {-85.78931999999999, 
      31.368237999999998`}, {-85.78940899999999, 31.358196}, {-85.757252, 
      31.358442999999998`}, {-85.756993, 31.32831}, {-85.746318, 
      31.32413}, {-85.73725499999999, 31.319502999999997`}, {-85.724383, 
      31.32124}, {-85.71309, 31.325726}, {-85.702913, 31.325654}, {-85.694392,
       31.320570999999997`}, {-85.674048, 31.319509}, {-85.66544999999999, 
      31.322184}, {-85.62339999999999, 31.346971}, {-85.622592, 
      31.372073}, {-85.640278, 31.372211}, {-85.63958199999999, 
      31.387269999999997`}, {-85.706599, 31.386853}, {-85.694147, 
      31.399089}, {-85.683253, 31.415899999999997`}, {-85.690615, 
      31.43056}, {-85.706696, 31.431587999999998`}, {-85.707107, 
      31.444371}, {-85.723737, 31.444488}, {-85.723579, 
      31.460918999999997`}, {-85.739139, 31.461025999999997`}, {-85.740083, 
      31.474725}, {-85.756183, 31.474833}, {-85.75604799999999, 
      31.489437}, {-85.78878499999999, 31.490105999999997`}}, {{-85.721621, 
      31.385589999999997`}, {-85.724289, 31.386978}, {-85.726398, 
      31.390643999999998`}, {-85.72798399999999, 
      31.392937999999997`}, {-85.727954, 31.396133}, {-85.72684699999999, 
      31.399777}, {-85.725203, 31.403416999999997`}, {-85.72409999999999, 
      31.406605}, {-85.72192, 31.410242}, {-85.720294, 31.412056}, {-85.71705,
       31.414772}, {-85.71542, 31.417043}, {-85.71378899999999, 
      31.419314}, {-85.71322599999999, 31.422048999999998`}, {-85.712672, 
      31.423871}, {-85.71157699999999, 31.426144999999998`}, {-85.709414, 
      31.427956}, {-85.706182, 31.429302}, {-85.703518, 
      31.427456999999997`}, {-85.70248199999999, 
      31.423797999999998`}, {-85.70250899999999, 
      31.421059999999997`}, {-85.70254899999999, 
      31.416952}, {-85.70418099999999, 31.414680999999998`}, {-85.705276, 
      31.412406999999998`}, {-85.706379, 31.409219}, {-85.70747899999999, 
      31.406488}, {-85.708569, 31.40467}, {-85.7102, 31.402399}, {-85.711835, 
      31.399672}, {-85.71239299999999, 31.397394}, {-85.71296, 
      31.394202}, {-85.714609, 31.390106}, {-85.71570299999999, 
      31.387831}, {-85.718401, 31.386024}, {-85.721621, 
      31.385589999999997`}}, {{-84.9981, 32.354763}, {-85.001787, 
      32.360735999999996`}, {-85.006135, 32.360338}, {-85.012299, 
      32.349938}, {-85.017342, 32.341345}, {-85.011715, 
      32.323040999999996`}, {-85.00281199999999, 
      32.306059999999995`}, {-85.002932, 32.299681}, {-84.97635, 
      32.300236999999996`}, {-84.976086, 32.285649}, {-84.967405, 
      32.285987}, {-84.96608599999999, 
      32.241755999999995`}, {-84.91946999999999, 32.242481}, {-84.919443, 
      32.243848}, {-84.920508, 32.244775}, {-84.924292, 
      32.245283}, {-84.926468, 32.244858}, {-84.92809299999999, 
      32.24488}, {-84.9297, 32.245813999999996`}, {-84.929664, 
      32.247637}, {-84.92798499999999, 32.250349}, {-84.92524, 
      32.252134}, {-84.92253099999999, 32.252096}, {-84.920373, 
      32.25161}, {-84.91712199999999, 32.251565}, {-84.914414, 
      32.251526999999996`}, {-84.91114499999999, 32.252392}, {-84.908408, 
      32.253721}, {-84.90566299999999, 32.255506}, {-84.90452499999999, 
      32.258224999999996`}, {-84.903386, 32.260943}, {-84.901192, 
      32.26228}, {-84.899557, 32.262712}, {-84.89738899999999, 
      32.262682}, {-84.896315, 32.262211}, {-84.894689, 
      32.262188}, {-84.89357799999999, 32.263539}, {-84.89356, 
      32.264451}, {-84.895682, 32.26676}, {-84.89943799999999, 
      32.268636}, {-84.90427, 32.270984}, {-84.910159, 
      32.274713}, {-84.919264, 32.28031}, {-84.926193, 
      32.286332}, {-84.932563, 32.293258}, {-84.937371, 
      32.296971}, {-84.94218699999999, 32.300227}, {-84.946489, 
      32.30211}, {-84.95133299999999, 32.303999}, {-84.957803, 
      32.305911}, {-84.966408, 32.309674}, {-84.97825, 
      32.314392}, {-84.991186, 32.318667}, {-84.999802, 
      32.321971999999995`}, {-85.005156, 32.325689}, {-85.00835099999999, 
      32.328921}, {-85.009333, 32.334403}, {-85.00979099999999, 
      32.338967}, {-85.008061, 32.344412999999996`}, {-85.00417, 
      32.349375}, {-84.99976199999999, 32.352962}, {-84.9981, 
      32.354763}}, {{-86.371386, 32.370125}, {-86.362161, 
      32.369658}, {-86.359985, 32.372845}, {-86.35780299999999, 
      32.379222}, {-86.353996, 32.383317999999996`}, {-86.34259399999999, 
      32.385124999999995`}, {-86.334453, 32.385114}, {-86.334442, 
      32.390125999999995`}, {-86.346921, 32.393333}, {-86.352884, 
      32.397897}, {-86.356681, 32.399269}, {-86.362112, 
      32.397909}, {-86.37677, 32.39747}, {-86.373527, 32.388809}, {-86.371915,
       32.378783}, {-86.371386, 32.370125}}, {{-87.38151599999999, 
      34.301035999999996`}, {-87.37321999999999, 
      34.305189}, {-87.37158699999999, 34.308382}, {-87.371653, 
      34.314288999999995`}, {-87.383303, 34.311474}, {-87.38727399999999, 
      34.318259999999995`}, {-87.389302, 34.349598}, {-87.390509, 
      34.357768}, {-87.39118599999999, 34.368214}, {-87.39125399999999, 
      34.37412}, {-87.414226, 34.386665}, {-87.426442, 
      34.383842}, {-87.44263099999999, 34.387347}, {-87.450375, 
      34.383195}, {-87.46305, 34.37264}, {-87.458546, 34.368587}, {-87.462898,
       34.360372999999996`}, {-87.473204, 34.33893}, {-87.485978, 
      34.337005}, {-87.49102099999999, 34.339689}, {-87.49450499999999, 
      34.351019}, {-87.498412, 34.351894}, {-87.503391, 
      34.349579}, {-87.503261, 34.339583999999995`}, {-87.50128699999999, 
      34.315971}, {-87.497294, 34.308281}, {-87.49168, 
      34.304238999999995`}, {-87.47498999999999, 34.303926}, {-87.468867, 
      34.303522}, {-87.438824, 34.302859999999995`}, {-87.433819, 
      34.3029}, {-87.408221, 34.301739999999995`}, {-87.38151599999999, 
      34.301035999999996`}}, CompressedData["
1:eJxd1Hk0lXkYB3A0TgydHDXZ6aYxMsMRJrK+b47d2K7XnkRMws0SpnDEkC1i
ZJSEc7Ivt2a0acTNEjGJpLEkhElokDtT9vn+5s/54z33fM59zvN7fs/zvC/L
97STv5CAgAAbD/mdiJ11K6theCkH3y2UWdPUpz0vM6PhZZejKafgtsiLX2vA
Tg1pHgVWNNUwEd2vDn/ZKVIZaklTy1nsM/vh8GZTxxILmgpMy+vrrGZ4+w7S
O8bMaWrj+6eXmqsYnpds86I1rCaltuUBZ70TtTGE71qZ+b2vZHj6nXOPSmHV
O1J9UbBBhXvJKPJtnksW/ljB8AIa6/jDOM/+1pa+LuwaMygmjPq6CzUy0soZ
XqljQm4I7Ki+L/1JGcO7vhQXVgXPaB7zPg9n9ulXF8AFuVJXiU+4LIQa2NLU
G0F/Nhdu81b1IfYfP/8zsVIRbmhHUyFbXda5cMeLo0PC9jQ13BnJ7oI384P6
hBxoSqQz3+ERzDQ/X1mEL9Ry/i5EPW8EVuO24L+MOywy4Lms9kNVzjT1hZTF
tArqz9cxn6uE96pMHFGEV3+9zY5wpakHgdp2prj/QI7y9QQ4yCIsSx/W/rTW
HuxOU4emimXa4Jz4AAklD5qKOMBVW4Nj752dLIVnisd9zTCPK6O5Kcmwxvp4
7Gwdw9u5tNPznBtNSdSYtGhyGd7JaW8fF9SnFp56/zAcdMTDrxf3S/CMXnZG
vOnjG84tcEyRSQixyZS6qwn6sZFU79kNVxfsnTWG9Q2TlvrhJPWotVr0T1cq
fmQXfI0prqmDn+sGyu6GOS0PtU5/R1MWdZpxN2tR/5WSC8RXE7/tKYenfcVr
J5HvCff2xRdw/0fZROLNhdTPB2AXc+ViV9QbpaVn7Y18LGF7FnHPa5kQBj4j
PJL6lSP62dMqaot44+zGCFU4QtWUIc67p1y4x4mm1kcNThEHJRipOMFjK2ai
q+jX+2PugcSCNlzfJbh9aofmMpumHmbpndgG16UWzBAPZxr/Sfzf3Bmaqr/T
ZHkS+65YJlnUC2e0aKQrwnwdn2w+4gtE5Iq8YUk7MW/ijArFwFB4MujZN6I4
T1aHb09ssBU1dBP1Sl8O1GnA+yEz2TrvD59lKSi2wK2/ebVF477VajoS3Zj3
4fkmvx/I/nE/fNYCT8d/iF6AmxfGGvVgEZeBbmJpluEw8WRI2R8ByFec1SHu
TPZPTjzSDRaQj/nHC5aRezCkhHivrhXfBVi6VyxaA9ZS0Dcizg9vGozBPgTn
+YSRfMnbn3KJxY18+a9gdKG7AfN6vBa2Ng3/xOp4qQ2bZv8oGYD6OTZTicQ3
FHTXObD0/jgPM8xf7v62yC44z+y4FLHR8bTtl9GPuQ1zAw7ig93Y7rvR7xjN
A8bGOE/9Fy3ZFXj6WgjHFn6b9jZYEPOcst11txj7tl5+y4nG/6Kc0uAcWEtI
TZ44VcK157UNTU2YjFIJiC9iydfPw5JWfK10+NnI4LwlXGfX4/AK8b8rx2su
4nvx/+/jv+P2cy0=
      "], {{-86.687136, 34.643139999999995`}, {-86.673171, 
      34.643161}, {-86.673689, 34.624992}, {-86.664751, 
      34.624096}, {-86.66529899999999, 34.619099}, {-86.65301199999999, 
      34.618660999999996`}, {-86.652473, 34.628655}, {-86.651929, 
      34.635923}, {-86.663105, 34.638179}, {-86.663111, 
      34.640905}, {-86.662025, 34.655895}, {-86.658114, 
      34.655901}, {-86.662615, 34.670429}, {-86.672113, 
      34.669962}, {-86.672082, 34.655881}, {-86.68660799999999, 
      34.655859}, {-86.687136, 34.643139999999995`}}, {{-85.62743999999999, 
      32.512181}, {-85.627535, 32.503524999999996`}, {-85.63084599999999, 
      32.498995}, {-85.633084, 32.493089}, {-85.62988299999999, 
      32.487598}, {-85.629938, 32.482586999999995`}, {-85.63327199999999, 
      32.475778}, {-85.641502, 32.468551}, {-85.65997999999999, 
      32.468233999999995`}, {-85.65974399999999, 32.439073}, {-85.676037, 
      32.439192}, {-85.676188, 32.424613}, {-85.659354, 
      32.424489}, {-85.65951299999999, 32.409454}, {-85.642682, 
      32.409327999999995`}, {-85.643064, 32.424367}, {-85.62622499999999, 
      32.424693999999995`}, {-85.626448, 32.453856}, {-85.610147, 
      32.454184999999995`}, {-85.609989, 32.468308}, {-85.593684, 
      32.468634}, {-85.593307, 32.454052}, {-85.559078, 
      32.454228}, {-85.55927799999999, 32.483388999999995`}, {-85.541888, 
      32.483243}, {-85.542251, 32.498281}, {-85.559649, 
      32.497971}, {-85.559482, 32.512093}, {-85.62743999999999, 
      32.512181}}, {{-88.372247, 30.395947}, {-88.371895, 
      30.40373}, {-88.37983799999999, 30.403595}, {-88.380167, 
      30.441101}, {-88.388125, 30.441422}, {-88.38829299999999, 
      30.448738}, {-88.392532, 30.448665}, {-88.392287, 
      30.461019999999998`}, {-88.387507, 30.460645}, {-88.387644, 
      30.466589}, {-88.402101, 30.472744}, {-88.399547, 
      30.408289}, {-88.39905, 30.386796}, {-88.395344, 
      30.386858999999998`}, {-88.393247, 30.387811}, {-88.390621, 
      30.388771}, {-88.389033, 30.388797999999998`}, {-88.386894, 
      30.387919999999998`}, {-88.384194, 30.385678}, {-88.38204499999999, 
      30.384342999999998`}, {-88.379387, 30.383930999999997`}, {-88.37781, 
      30.384414999999997`}, {-88.376772, 
      30.385347999999997`}, {-88.37679299999999, 30.386262}, {-88.378412, 
      30.387607}, {-88.381091, 30.388934}, {-88.38166199999999, 
      30.390753999999998`}, {-88.380084, 30.391239}, {-88.377427, 
      30.390826999999998`}, {-88.37639899999999, 30.392217}, {-88.37643, 
      30.393589}, {-88.37805, 30.394932999999998`}, {-88.378622, 
      30.396753}, {-88.376514, 30.397247}, {-88.374905, 
      30.396359}, {-88.373295, 30.395471999999998`}, {-88.372247, 
      30.395947}}, CompressedData["
1:eJxd1nk8lfkeB3BLjiXLJJEwJiqKSCaM9XnmkpByw8m+5ViO5SANUpZIljC3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      "], CompressedData["
1:eJxd1ns4lOkbB3A5UyS75RChsruJtEmb0+77lhxr88M7yKEMjbIpbc5FlJqU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      "], {{-87.430025, 34.775397999999996`}, {-87.43227999999999, 
      34.776742999999996`}, {-87.429619, 34.788118}, {-87.425843, 
      34.799956}, {-87.434854, 34.804426}, {-87.451143, 
      34.808837}, {-87.486485, 34.814448999999996`}, {-87.49100399999999, 
      34.817589999999996`}, {-87.499437, 34.820243}, {-87.508997, 
      34.82334}, {-87.513571, 34.830566999999995`}, {-87.52311999999999, 
      34.832755}, {-87.528714, 34.832252}, {-87.533163, 
      34.829941999999996`}, {-87.546054, 34.830736}, {-87.555511, 
      34.826108999999995`}, {-87.56894899999999, 
      34.825987999999995`}, {-87.586782, 34.819919}, {-87.59111999999999, 
      34.809886999999996`}, {-87.59889199999999, 
      34.805273}, {-87.62284199999999, 34.796870999999996`}, {-87.625074, 
      34.796395}, {-87.623342, 34.792778}, {-87.62167, 
      34.793248999999996`}, {-87.60941, 34.796999}, {-87.59381499999999, 
      34.802596}, {-87.57596099999999, 34.806849}, {-87.562514, 
      34.806063}, {-87.559212, 34.810179999999995`}, {-87.54978799999999, 
      34.817077999999995`}, {-87.543685, 34.82122}, {-87.53081399999999, 
      34.821788}, {-87.522916, 34.817315}, {-87.507204, 
      34.814727}, {-87.492019, 34.809405999999996`}, {-87.477435, 
      34.807258}, {-87.466731, 34.801897}, {-87.461117, 
      34.80058}, {-87.453835, 34.800186}, {-87.448137, 
      34.792057}, {-87.43966499999999, 34.785767}, {-87.441255, 
      34.778487}, {-87.43893899999999, 34.772147}, {-87.430025, 
      34.775397999999996`}}, CompressedData["
1:eJxd1Xs8VHkfB/AJq3IpmbQXSjapKV1QKe2rzrGMsiTVQRjKZTybJGJbuUxi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      "], CompressedData["
1:eJxd2Hc8le0fB3BURo9RZjRkRCgd2RLnZJXQoU5G2TTsVYTHHokiq8QjRFKi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      "], CompressedData["
1:eJxd12k4lVsbB3AJRYbQgBBCZCiVqeR5DJEhleFQOaYi85SxUhokiohUyBiO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      "], CompressedData["
1:eJxd1HtYU3UYB/AjXjBIFBFBJ0kYiKBucomhpDs1Ah3BBpw0U8ZFLgKJ88KS
UmEOECWGsBmKKYECAq0Q5ibIPJOLBTxcRElQEpPsgjQTAkSEvvPP/jjPeT7P
731+5/ee3/u+b4cnBEYaEQQRjMfwjnwVFV7TRNGS0pfExWCSc33j/u4SWNb4
7uUY+HmitEsCr8pd2kvA76j4Lp6w+go3+kwQyRFHD101hbmCgoABePiUfIQF
Kzv3FaQjvpLF9RfCY00LiGUUyRGSZytj4B02hGgrvJvvNj8UnlC3HOmDtem8
rA2wroJ/8SVsPPfJH/80UnRAa9I6OTxccdHyITwrc22CGey6bufxuzBvOie4
GN+TDl+OUMDm1oOMPHh1+L0wP7g99VTIHVjs1H/+9waK1hxoPdQEN1svj2LC
bRnvVctw/ipO7Qcn6ik6zUvCWAX7VDSWEHCco8qqM5DkWJh+6a2+SdHTCoXD
Jfj8bd3EJtgof/8zP7hRtk68Bt7oxcs2h+drlHnm8OJ01xtnBSTnLVf+kmkd
RQc6mgqF8OTkWL8KPnOnY04obMLzKoiHhUOObQKYsuD2GcMf323Ru8F/2yYW
d9AUXWVfbveAT3JOH5Af64FjdSe1Eljm8quRYb3S7VnRUlgi2vtnHrygouzr
hwEkh28t3+0GZx0UMeZhfXHBZ+6DNyh6dnFXjcFKR/tZ5XBa6c0LjxBfVrU9
VAZHkGH8Yji755MRfzjryY/NTPjWh7YhP2sp+uCAb3SoP8nZ1PRAJYUj3qx4
PP4RyYmc6vTYDdcLc93/giW31OJ5cFFWVvkp+EiZybyGOoq2iy1s94GbxzK5
MXBlRuuOfj+Sw3YudJi4TtHMjCq7WFjW0NJ1DV7frIs3ggfuJaXthTN9F23v
5qGeRE2slfBXakVIPhzrH7LLCNawnTwEMLtXVK+vRT3JpdzeLSTH16VcrIEj
S5bf8YY3q+336WD9bxs9TWDdjDU7DX6qjfj86Wbkx99zfwx29lctjoJ5P+1b
uAX7P0papPSBp7w78jbDV1bnjRf5Ih+r6uxkxBc76Bi34XRtrcIeHjoXlZKI
+J7BvuX6GuT3raTeFN974Tfa3gVHaY9dYMPWSrNkDXzuvvSLSDjVUPjwZOCm
BCeYmBF3V3mNor/PnbhSjf0Y3wwHLYPrNQxuHOzxKOSMWoP7tXKOZcFDQ6cH
kuE2l5P8eDhftLTQBPtFnvCcux77FQhqRpg431hrDuGO/zV6KPN5K/IpYvvY
2OB+jE+v2GWL+7MsbewPw31/l8608IYVz6QhR+HbrnUN21Afov1OSwjU0+tz
wZbTYm4q/NiNazkFH8hjMmnY+3DOhnjU48ycHxJWor5f9w3qfcA5RX4PPiw3
t0qGX62ZMV6Cfpr5qf22ZegnImiOWQz687hZyooU2FM//VgKn1WurFmLfj3K
I6YM/buC1e3BQn8X2XhM7kG/v5E6ly3FPDg6/kKvw/x432shMwDzRvtvWJ1g
K+aF6peEavhhYe6lbrhhcGJ2LVw5Kr7qg/j/z8v/AARDfH8=
      "], {{-87.03262199999999, 34.680685}, {-87.035811, 
      34.657050999999996`}, {-87.025162, 34.652103}, {-87.011691, 
      34.642624}, {-86.98983899999999, 34.63227}, {-86.968513, 
      34.615550999999996`}, {-86.96185799999999, 
      34.623298999999996`}, {-86.96857899999999, 
      34.626452}, {-86.97251299999999, 34.630524}, {-86.985428, 
      34.641373}, {-86.98991699999999, 34.644534}, {-86.996634, 
      34.646777}, {-87.003362, 34.650382}, {-87.006717, 
      34.650821}, {-87.008957, 34.65172}, {-87.01066, 34.655801}, {-87.011793,
       34.658066999999996`}, {-87.005653, 34.659002}, {-86.99783699999999, 
      34.659943999999996`}, {-86.993341, 34.655875}, {-86.989977, 
      34.654072}, {-86.984966, 34.656819}, {-86.980491, 
      34.655929}, {-86.97771999999999, 34.659574}, {-86.983318, 
      34.661367999999996`}, {-86.987802, 34.66362}, {-86.987264, 
      34.666802}, {-86.988401, 34.669976}, {-86.993419, 
      34.668139}, {-86.996769, 34.66767}, {-86.99734199999999, 
      34.669939}, {-86.996813, 34.674482999999995`}, {-86.99571, 
      34.676759}, {-86.99516799999999, 34.679486}, {-87.000219, 
      34.682643999999996`}, {-87.00304899999999, 34.688083}, {-87.006411, 
      34.689431}, {-87.008617, 34.684878999999995`}, {-87.013632, 
      34.682586}, {-87.018671, 34.683927}, {-87.020342, 
      34.683011}, {-87.02031699999999, 
      34.679376999999995`}, {-87.02141999999999, 34.677101}, {-87.022528, 
      34.675734}, {-87.025313, 34.674358999999995`}, {-87.027558, 
      34.675711}, {-87.028703, 34.679794}, {-87.03262199999999, 
      34.680685}}, CompressedData["
1:eJxd1H9Qk3UcB3CcoMhg4GiVZ5ic3oHkcdOLUrbWnrWp/Bhb1oSVyE8Rhjmi
LLSjRYFCsHYo62LOH0CzI1ZzM8VNBrME+SXIz3IjmGm3rCDmOgjWoPdz51/9
8dxzr/t+nvf39xOZLd97kOLn57cLD/lOlTqeUFklttPiRV63iODSmJ6If+FT
FGpmbwrBbSxRXxHCHVmNRBDMWAqWj7dJbJNp4qfrhAQ3+Jk7wwzY167w/JJM
cL/Te2/xrktsrQMd6XNJBDfD5M6stkhsnT0+mgDOZ12c6TVLbEfv/1xrTCS4
ysCuG7prEtutnFUx9xMI7rfmpuVfYSp1ZjUb7SWrQnzhqF8bN+Rqgtc4RF3/
oF1b+eFbPniwovbAKKzb007fg3x9ccMjA7w065n6BJbkJf4hh79vP8svhw9t
kabwYJmoZ6cRNrW1bGDCy++uDJiEHQWFfNJjnAjVOszn02VWI1n/+Xuy2Bfh
8uiMO6StIklDGRwteG6eAt89fqKoH1bd7Bsxt0psKlH3gAP2vmRMUcP8u2/2
LsCrDen2Ivh2QKwqDuuX5TTPk45k23dkw2kPfgw1whlqqloBV4alDkzCwaya
BNLKIO3hlejPUUj8pYRNBxcswTAZ0wM723a4x1Cf1nXiyBz8gcWSQ+bVtOmr
ArB/zWsX64/Do/zzqu1wXJ29Oh+WX1NNaOCywdBN5XDOmdefHyf9/qOH5PdZ
4otDD+B4qcw6BYdFUHZTcF5eMPyufxL9H7HXjITB7NivBXxYcNXjG0X9BWb0
SD5M8GX2TrizuiKyGN59auP+Fah3aliLGbByMHeZDYdq0uf3wf61Ak0JfFo3
7lXCuUdbXF/CsS2X1jnhq0nraUnwvSjahSn48huZqirkq4e6XQycl4J7pqAz
mH9uQEfINngiL+bmJjh6OqSdCTNH5gx67Ic7IYqeDPduk04o4LlXDl8qguuz
aR9/BgemchvOwf0PTV/8BHdt99HdcJLrh8v+yOvbyjMycL4TtIxXw2FCY8yP
h9f/rWt9GZ6m/lbBwn2oqi/d0ITxhZzUlT0Lu7zN7mHh4/5Qv5eWF56JfEVh
VCIPvv1N2L4cnEe6tSbbDPd5nDN6OKV04zGX5fH+od58Q3ySgbz9lFlRM5wn
3DpLOsi6tJmD/Hdo59YIYW3yREwlXHfoAO06/GdDqd4JF/jJy/xxfzvG4t/e
ifF5+6Xni2Fi/LUWA2zSlg8/hfvvn3qMkoX1Zm7hcCJhlvgrtgWeVnx0RQZz
Alcs0MUE9///k/8A0pEZGQ==
      "], CompressedData["
1:eJxd1ns4lHkbB3CHzMQ6pd6sKPumg9YpeRep9DybWSLlKsZpjAwzGIdBdoVy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      "], CompressedData["
1:eJxd1XlUzGsYB/DURFSjJoW0T9u1RAta9bO0UNo0R5JbmIppUVquUTShSJul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      "], CompressedData["
1:eJxd1GtMU2cYB/Ail0o7gVpBZFuHlyqioiI6lGnPASR1Koh46h2hQEvmpQg0
FAuIlosCDjAw8VJgs0SBAUOEKFB9QWHeJg4YRZiiIzHFOTDOVUHA/Zvs0z6c
nPySk/M+l/d5ZksVW6OmsFisbXjMb+faIFYbV0Ictj98OusYTTn1636ohe1K
4ue0pNKUVUydyuxTXLbvFXjz8S91wfCuSJ+BoKM0JW1+wWg5EiLVBy/alExT
R4ttPjkNhwieTM1OoqnOljFRJnx3dW2mSU1TiVPCL+2At/pnMM2wfCSnwR1+
doFXpodn3Gs1GGwlxC3Mx7kWTn2TMHIZrvZbKdwJqxcnG4/DA2XdwsEjNJVg
F3U5C3505unkHjhgD8ulDM5VjLi8TaSpjujK03fgxJ18bhJck8jI6+H3XguW
esIvrxT1JsFVJO+3KhXyj04QL4elTerU4QSayjhkYt+bKiGBvkPc2bDCLanB
Dja832TqUNLUz2Ft5T1s1E/0ca0Kvpn8ubccfjE7ZJ0VXHFkVDsf7nGO9zXG
05SNXfQQB55WZprTB3dl3OokNhKSErKjvBTWZ+XYieF063eWAtjE4Q6z4bGG
sHIPWCIe3VBvjfqd+2VwGRz16TVLJaz8SlbqCQ9by9LnwIF1VJMfHOcQf7XC
Cv0LnbbFBV7iW+voBRvKAoxyePXDg616S/yv6J13F5xhsbFaCvP9n7BdEX/p
hJg3C5bXEwEfpt3bvm2fIiGlXt1u82DL+zzPPNi0lzeugDn6yXnrYA3/15oq
2D606epzCwkx8hNPx8ODjieKC1gSckNT4p2K8zZ5iVtC4P2R23cFwHnpRgdv
2GJ0urs3vEPRzen6yJDNHu1kDey07NjuBDi6wGNiI6x1H1gxHZY2OlSKYNWC
EkH/JEPyORFcGlaW88bOwj63RQeG4mhK1mjYkAyLt4w7x8EaXVClcYIhYfn7
RLdj0b/ujvNZcNw1ibr3ME1tq/B/vBueWf+BSYVzva5VLYHz1Y2NEfCuhp6Z
tvDvZ20z4mDfB0Kmf5whfS68HA1cWCQXVsFpUQeMMjglZp3yR3hCI874DM6+
GMuvh9d3Pb77LIamcgzNFXXj/+UHX3RVJanh5gc/BfcoaKpR03vWFz45197f
CdY6rDFOh3XmAA/RVODCmsJHHxgS7HFqn+ogTa3tKFlVAX9jSLvafoCmYg/x
hwvhv+wL+k37aSp8LNQvBt7rxD+fa/aJCzeKxxhSt/t+pDe+P6xIueUPa5vv
WI3Dkp5VbYOjDBF4NQ1X4bybZ1o1Mjh37E9HJ8Rr7fydaOA9Q/o9ny0Wmuul
02V+D6fvKZfTqC+tfWMMgO8kLFTehTsvMW8z3zFkvHXRhmL0I6dvwp2YGNK+
ItpYYr7vfn8INsI+K1piqnF/hHPl4UH/MOTWa95yIeb1i+srhxreMsQ11LC0
F/OsWv/6ZiFsTjMR++JYQW+9Hm6IeFn9CvvotvF6ejX8akalTXgKTf09KQos
gs+p2KpO7Dd2R9r8k6hndrCh7wOskRn0jpiniqKvRc/h/+/LfwGvT3If
      "], CompressedData["
1:eJxd13c8V20fB3C3EUqplEKUpCJyh6hbbueQlcw6tGwSshuUkYQGJaTICqFC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      "], CompressedData["
1:eJxd1Hs0lHkYB/BJF1LRHnKb2MSIWjorads91vvOIJGtoZ+WDGOQZRbtOuk4
dZRi1S6VyyIhuS82W7ketzdW2VyKahBLF61LE9K4zVS7X3v2r/1jzpzPmd/7
zPM+z+95DEVhrgFKLBZLgM/St6/cm3dUQRiBlsaVi2KaKtpky66FUyzeO7vC
soHe6HA4OrItRT2IpsLr0hQjcsKMZPbxFEdoSqJIiBhcwPkNLY+X+cPsymbZ
PGEKFhZipCKa+jNtx8AGeOjOkT0lvjRFBRXzHecI01edfG7ah6b0hrXTSmYJ
4/mw/oUmXB9uyiMywrw0Tmlc701TmUHNc8lvCbP1ne5QmYCmVusIhjbC2mYp
seXwQMG6uIJpwozekcVwcH5YrHKhfYowD678eFAH8UROxt3tk4SxCwqbjoWV
tsVp9b8mjJHzX18PIR83D80IPlx8gTjdR759W06L/KWEcf6O9B/3oyl6T6ln
zwRhHtldvWiJ93ui88UzzjhhLH55EnomgKb0Xwqtl40RBqftp+GpEuUOHjyX
7hhkHUhTyXcfzizHeVNT+23zqNelmeTgq/A1P+Wfa+CqM4Ucd8Tn2rqVH4af
0bdeDcGHU8vbl+JlqLCzvV8RZtdR5YkU2HOyY0ULXMfZLTwE+3E7OAT5GtM1
SqpwiLW7KBveERqcs4h8nzrm3C6E55VucRPhuE/HpwrgrKgD2mbwsdLR/Hm4
ef9Gqgnv6yn7auUg6rHT5HcvV/j6ene/1ahfKwkY3gCP5Rq+4MOKxM2WZaiX
1rU+1Qz43z7DbbY7zqmj/lH8Mx+4qK9Ez+m1PVy6yjd0XkhTrbotmTlwe0Be
eBSsPemlMw4LSy5Xai79/n5PIQ/93C5X7YlHv9Tpx2OP4fPd4WsEsKv3tmt1
8LpW/bAZ2KE92iAYHpCP24rxfOX+u36r4MnETvIWdt7tI21AfA+XXg0B8rHx
doyLgz9JX8grhrmpKzVOwaNhXEMl5F8VJb+fAfOeGzh/DNeUHkrshmV8By8W
fOeH0DllxN+kzOmowPOqFu6PhG8Q3yoray3+z5Bolt+E1Wp1Qxnkl5NHzMdh
aaxS1Vm4+3j1TbsZwszOnuz8Hk6g6q/7wJHH/cus4aLyUXEq7CE2rdSG4y3C
1Hrh7UHxEj5MNcaoquH+c1Xa0g7AGtKmLhe4MfqPhM3wqK4iKQEWnwo8IcM8
2Ji4ZnTCevlPzUbg/btNflLAlxqG3r+BNwm+9TTDvJGmnsVpWCBPy7eEZeJX
RX/DEqupz+xhy9aNK/QR/wEvhO0A13eytyzN0+SvjvsOwBUfUlnv4FMukuI4
mP0oSrwF9TC//uayFM6Pr2FZwQu56ADmfbio5AEl/G++4KTlETsjYS3nxJMc
7IeRXvUbt+GO3/iSMNjGXu2jXai3WBRdPgbT2YLGWbiyMPKuGfbL1hfDgV7o
zyDWlQOs7l1X8Qze12RXfwxO+nyZSwzur43QwPIlHOF2T8zB/U8wkjx3w/46
fSLbNgTuCmlusFwkzMHC9LM5mKc2Y6NAXziac+jGAlzRXv1lGSztD7+cgXml
pxIMWdiHMo2uUHPMe55Bbrc+nMy2l+h9g37em4+3g7uKF7cuwkmrqitjYa25
ihYf7NNz/m03ZuG17pnB5sE0ddJu33lj7Ntxqf/RFDhf3rXdCd4r2lurgOk1
2IDwxMSFVmvs5//v738AAJTh/A==
      "], CompressedData["
1:eJxd1GlUlFUYB3CWWE3ADjtDQUImmwZibOb7qjkD1IntErI7AoKYjCEIBcoq
YoBsOScyjIjAhQBJOSDBKybHmIMsMixOMBKQwzIMCiIykP352oc5c35n5t73
3uf5v485N84nUklBQcEbn43varO9Js1ywpTarXv6xNLUb8q/WketEeZYpYvp
g2M0xZMecOfAHur+QkEMTWkOVfL2wCyV8xlGsLOmjooDHN+q1FcSTVM++03S
NsMR/jKeKyxYNo/b2D8lbV7w3VGa6rHR8PKFrUwG/fThSxKbRnW4SGPFsTiK
pvjiGPuJVcJkVk4KnWFXX0lrJ8wTsH36I2lq7lXZ1E34dNsV4x1wk/TrgTCY
neBS+CKCpth55UGSV4SZGC1qeAzfWmNIOXy2XPXNYrid35EZBTuq/qDjAn97
1rYuGC7a9PCJ7AhN7ePzJLYb61cq+s/DvVLL/L4VwugqW5RRsOqCPscLPp48
9ZWIS1M/GswHG8K9fdcunYIfZRikqsBh3YoZznB+47T6k5eESZ+9YDR+mKZM
r7YtfgMLiwu+3An/HSg9vAN2WO3jdYVj/7KeZtEyYTYFvx17EJ6Z3rqQA3Ot
1rMaw2hK2ltvmAA/t/TjJcFR7GuytReE+dn+PusNWLss5KU/zG2uEhaG0hS9
LUurZYkwc+7h8VqwuSSaeMIy46WqphCacvpkF+fuImFm6j4P4MEN2WZqlnCg
VRzbCebkhohEzwmTP+ch4MATY2vncuF+I8PkQxvrF687U3AW5xwrCK6qOGj+
5zPUI9W5MQReW+fejoBvmMgK8uDtKqOh/QuEqbBJSa2Fy2Z39fvAQ7/r5Wrg
fB2x/N0suGY8KOBD+Ivq2i13ZYTxre8cOQXr7H29JwmOcbSYb4D9fIsTnGAW
1S4Tw/eepagOzBMm55jHTS3U49/Dnhd/gROrXT9zg6M3gg6rhSu/+wf8Xl5U
pFxKGPEHbsuNqHeuprD7PuyWHXz1KPpT29Zi5QUnUSOl1ujn7TtqkrY5wmhW
ZNqNw6+TjXdyYPdmOesd5KPb7KP6iVnkZa794adwPFdbegRuOrPaUwaLHd6q
2AK7elW7tcB5Sz8lts8Q5qRzaLoEXm4MuDA5TZhQNutmOvJp23W80B2eOaTT
JYf5nTtaiyWEWTmx2OmO/LtrDQsnnxIm7Yy4PRk2nQrfrYjfycjpjxfgx4au
45ZYb3f18YkMmGZfD+zH8wYOXLloj/2Gt6VxI3B+z5NYgef7HtJN9MZ9awqI
Rw/up2Sdoz8Cb/X8J2AM9eB6WPQJUL8DMXEL2aifOFa9QID6935/wc8QFlVt
zqlC/552LmVZoh8ahiFjLOTJYHtpdh36fTmmY7kEtlozGrsBt8a/v58gj1MW
pW06+L+x2IB/DfkNfNQ6oYv9qJgabw7yPtxUcn4BHuU7iPTwvox1Ivk4z6DJ
rY4luGplJWsO5x2U5yf+hfevVO+eUBH3i7/Dl09iPkxeHt4vxzxZEg2lx2Pe
pCc/KNXG/Pr//PsPwUCIfQ==
      "], CompressedData["
1:eJxdW3dcT9//Lw2rTyUzsz4ZRbQj8X6fG7Jn3YuPPkq7ZEZGRLJXVkulyBay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      "], {{-88.38089699999999, 30.357369}, {-88.382972, 
      30.355504}, {-88.38453899999999, 30.354561999999998`}, {-88.385587, 
      30.354086}, {-88.386656, 30.354526}, {-88.38666599999999, 
      30.354982999999997`}, {-88.386698, 30.356354999999997`}, {-88.386719, 
      30.35727}, {-88.38569199999999, 30.358659999999997`}, {-88.384136, 
      30.360059}, {-88.38257899999999, 30.361458}, {-88.381012, 
      30.362399999999997`}, {-88.379964, 30.362876}, {-88.378356, 
      30.361988}, {-88.37779499999999, 30.360625}, {-88.378293, 
      30.359244}, {-88.38089699999999, 30.357369}}, {{-88.397114, 
      30.348855}, {-88.397791, 30.355248999999997`}, {-88.396203, 
      30.355276}, {-88.394086, 30.355313}, {-88.39092099999999, 
      30.355825}, {-88.39040299999999, 30.356291}, {-88.389344, 
      30.356309999999997`}, {-88.38879399999999, 30.355404}, {-88.389291, 
      30.354022999999998`}, {-88.39082599999999, 30.351709}, {-88.392403, 
      30.351224}, {-88.39397, 30.350282}, {-88.39606599999999, 
      30.349331}, {-88.397114, 30.348855}}, {{-88.383507, 
      30.378828}, {-88.38509499999999, 30.378801}, {-88.38723399999999, 
      30.379679}, {-88.38937299999999, 30.380557}, {-88.389415, 
      30.382386}, {-88.388398, 30.384234}, {-88.38628, 
      30.384269999999997`}, {-88.384671, 30.383383}, {-88.38304099999999, 
      30.381580999999997`}, {-88.381951, 30.380226999999998`}, {-88.383507, 
      30.378828}}, {{-88.388145, 30.373258}, {-88.38972299999999, 
      30.372774}, {-88.39132099999999, 30.373203999999998`}, {-88.392941, 
      30.374547999999997`}, {-88.394021, 30.375445}, {-88.394582, 
      30.376807999999997`}, {-88.39408399999999, 30.378189}, {-88.393036, 
      30.378663999999997`}, {-88.391437, 30.378234}, {-88.389299, 
      30.377356}, {-88.38767899999999, 30.376011}, {-88.387129, 
      30.375106}, {-88.388145, 30.373258}}, {{-88.024737, 
      30.678901}, {-88.022021, 30.675738}, {-88.019305, 
      30.672575}, {-88.017112, 30.668948}, {-88.01705199999999, 
      30.665747999999997`}, {-88.020686, 30.661126}, {-88.02544999999999, 
      30.660145999999997`}, {-88.028132, 30.661481}, {-88.028774, 
      30.667415}, {-88.02935699999999, 30.67015}, {-88.02993099999999, 
      30.672428}, {-88.029468, 30.676091999999997`}, {-88.028465, 
      30.679305999999997`}, {-88.02583399999999, 30.680714}, {-88.024737, 
      30.678901}}, {{-88.37505499999999, 30.217446}, {-88.37084899999999, 
      30.218432999999997`}, {-88.367627, 30.216199999999997`}, {-88.367565, 
      30.213455}, {-88.37017499999999, 30.212038}, {-88.373842, 
      30.210601999999998`}, {-88.375458, 30.211947}, {-88.37654599999999, 
      30.213302}, {-88.377645, 30.215114}, {-88.37505499999999, 
      30.217446}}, {{-88.137142, 30.293554}, {-88.136039, 
      30.291283}, {-88.137078, 30.290352}, {-88.1413, 
      30.289831999999997`}, {-88.14130899999999, 
      30.290288999999998`}, {-88.14347, 30.292544999999997`}, {-88.142449, 
      30.29439}, {-88.139285, 30.294895}, {-88.137142, 
      30.293554}}, {{-88.216466, 30.317508999999998`}, {-88.217033, 
      30.319329999999997`}, {-88.216543, 30.321168}, {-88.214975, 
      30.322108}, {-88.213916, 30.322124}, {-88.21231, 
      30.321233999999997`}, {-88.210695, 30.319886999999998`}, {-88.211176, 
      30.317591999999998`}, {-88.21113799999999, 30.315762}, {-88.212706, 
      30.314822999999997`}, {-88.214822, 30.31479}, {-88.21588899999999, 
      30.31523}, {-88.216466, 30.317508999999998`}}, {{-88.227691, 
      30.322823999999997`}, {-88.226103, 30.322848999999998`}, {-88.223449, 
      30.322433}, {-88.22183299999999, 30.321085999999998`}, {-88.221256, 
      30.318807}, {-88.223843, 30.316021}, {-88.229143, 
      30.316395}, {-88.231297, 30.318192}, {-88.230807, 
      30.320028999999998`}, {-88.229787, 30.321876}, {-88.227691, 
      30.322823999999997`}}, {{-88.349406, 30.393131}, {-88.34782799999999, 
      30.393614999999997`}, {-88.34571, 30.393651}, {-88.343572, 
      30.392771999999997`}, {-88.341444, 30.392349999999997`}, {-88.339305, 
      30.391469999999998`}, {-88.336648, 30.391057}, {-88.335039, 
      30.390169}, {-88.33341999999999, 30.388824}, {-88.333389, 
      30.387452}, {-88.334957, 30.386511}, {-88.337064, 
      30.386018}, {-88.339192, 30.38644}, {-88.34185, 
      30.386853}, {-88.34503699999999, 
      30.387256999999998`}, {-88.34876299999999, 
      30.388109999999998`}, {-88.350912, 30.389446}, {-88.35095299999999, 
      30.391275}, {-88.349406, 30.393131}}, {{-88.297006, 
      30.370666999999997`}, {-88.298554, 30.368812}, {-88.30013199999999, 
      30.368329}, {-88.30224899999999, 30.368294}, {-88.30331799999999, 
      30.368734}, {-88.303888, 30.370555}, {-88.302859, 
      30.371944}, {-88.30183, 30.373334}, {-88.300792, 
      30.374266}, {-88.298684, 30.374758}, {-88.297626, 
      30.374775}, {-88.29707599999999, 30.373869}, {-88.295987, 
      30.372514}, {-88.297006, 30.370666999999997`}}, {{-88.268771, 
      30.338184}, {-88.267174, 30.337752}, {-88.265547, 
      30.335948}, {-88.26654599999999, 30.333187}, {-88.267056, 
      30.332264}, {-88.268104, 30.331788999999997`}, {-88.269172, 
      30.33223}, {-88.27024999999999, 30.333126999999998`}, {-88.270809, 
      30.334491}, {-88.27085799999999, 30.336778}, {-88.268771, 
      30.338184}}, {{-88.25838399999999, 30.322795}, {-88.261578, 
      30.323658}, {-88.26321399999999, 30.32592}, {-88.26379299999999, 
      30.328197999999997`}, {-88.263851, 30.330942999999998`}, {-88.263362, 
      30.332780999999997`}, {-88.262343, 30.334626999999998`}, {-88.261304, 
      30.335559}, {-88.260795, 30.336482}, {-88.261343, 
      30.337387999999997`}, {-88.26190199999999, 30.338752}, {-88.261922, 
      30.339667}, {-88.261422, 30.341047}, {-88.261451, 
      30.342419}, {-88.26254899999999, 30.344231999999998`}, {-88.264136, 
      30.344206999999997`}, {-88.265773, 30.346467999999998`}, {-88.265812, 
      30.348297}, {-88.265323, 30.350134999999998`}, {-88.26482299999999, 
      30.351516}, {-88.264333, 30.353354}, {-88.263882, 
      30.357021}, {-88.26398999999999, 30.362052}, {-88.264579, 
      30.364787999999997`}, {-88.264089, 30.366625}, {-88.263599, 
      30.368463}, {-88.26203, 30.369403}, {-88.25989299999999, 
      30.368523}, {-88.25879499999999, 30.366709999999998`}, {-88.257678, 
      30.363982999999998`}, {-88.25656099999999, 
      30.361255999999997`}, {-88.256492, 30.358054}, {-88.25694299999999, 
      30.354387}, {-88.256884, 30.351643}, {-88.25682599999999, 
      30.348899}, {-88.255709, 30.346172}, {-88.255111, 
      30.342978}, {-88.253975, 30.339336}, {-88.252848, 
      30.336152}, {-88.25277, 30.332493}, {-88.253221, 
      30.328825}, {-88.25421999999999, 30.326064}, {-88.255759, 
      30.323752}, {-88.25838399999999, 30.322795}}, {{-88.105448, 
      30.268855}, {-88.100089, 30.265272999999997`}, {-88.094732, 
      30.261689999999998`}, {-88.09311, 30.259883}, {-88.093083, 
      30.258511}, {-88.094123, 30.257579999999997`}, {-88.096238, 
      30.25755}, {-88.097832, 30.257983999999997`}, {-88.09942699999999, 
      30.258419}, {-88.10104, 30.259767999999998`}, {-88.10372799999999, 
      30.262017}, {-88.106935, 30.2638}, {-88.109077, 30.265141}, {-88.111738,
       30.266018}, {-88.112805, 30.26646}, {-88.11439999999999, 
      30.266893999999997`}, {-88.11547499999999, 
      30.267792999999998`}, {-88.11707899999999, 
      30.268684999999998`}, {-88.118665, 30.268660999999998`}, {-88.119176, 
      30.267739}, {-88.120744, 30.2668}, {-88.121783, 30.26587}, {-88.12285, 
      30.266312}, {-88.12446299999999, 30.26766}, {-88.125556, 
      30.269475}, {-88.12560099999999, 30.271762}, {-88.124061, 
      30.274072999999998`}, {-88.12250999999999, 
      30.275926}, {-88.11987599999999, 30.276422}, {-88.117223, 
      30.276004}, {-88.114015, 30.274220999999997`}, {-88.109202, 
      30.271545999999997`}, {-88.105448, 30.268855}}, {{-88.060574, 
      30.189418}, {-88.06322399999999, 30.189837999999998`}, {-88.064298, 
      30.190738}, {-88.06537999999999, 30.192096}, {-88.064887, 
      30.193932999999998`}, {-88.063311, 30.194414}, {-88.06119799999999, 
      30.194443999999997`}, {-88.060678, 30.194909}, {-88.060176, 
      30.196289}, {-88.059163, 30.198591999999998`}, {-88.057076, 
      30.199994}, {-88.05442599999999, 30.199574}, {-88.052278, 
      30.197774}, {-88.051698, 30.195035999999998`}, {-88.05217499999999, 
      30.192283}, {-88.054244, 30.189966}, {-88.056348, 
      30.189477999999998`}, {-88.060574, 30.189418}}, {{-88.102818, 
      30.215353}, {-88.101726, 30.213538}, {-88.102227, 
      30.212158}, {-88.103275, 30.211685}, {-88.10538, 
      30.211197}, {-88.106982, 30.212089}, {-88.109123, 
      30.21343}, {-88.112346, 30.216129}, {-88.115589, 30.219742}, {-88.11721,
       30.221549}, {-88.118302, 30.223363}, {-88.118867, 
      30.225185}, {-88.118365, 30.226566}, {-88.117846, 
      30.227031}, {-88.11627899999999, 30.227968999999998`}, {-88.114684, 
      30.227535}, {-88.11361, 30.226636}, {-88.113045, 30.224814}, {-88.11249,
       30.223449}, {-88.110349, 30.222106999999998`}, {-88.109275, 
      30.221207999999997`}, {-88.109248, 30.219835}, {-88.108702, 
      30.218928}, {-88.107627, 30.218028999999998`}, {-88.10602399999999, 
      30.217136999999997`}, {-88.103893, 30.216253}, {-88.102818, 
      30.215353}}, CompressedData["
1:eJxd1Hk0lXkYB/Cb5KLs2zGpuKhbcqNjCbldW/Z9vMZYx9JYOpZjKTNkbVzm
INu4o7QMY1AjlDQoLzNxb8g2J8eowx2lyJXlCo3GfO+/88d73vM57+/5Lc/z
vD+t0DivCDEKhRKIR/Te+tBkFSxBkA/NKvZRLJms4WvrR/thwtZVuHWaycoK
+Ju7m0qQ8ZI+0R/gMN05P0d4iebiycD4uKsN8sWwp3OiXi4sa+87vwTTrRdS
PsD0r+oEwZIEKdfS0+vIZLJi6G1qo/CUPm9XJ/yoR+2wtxRB7tNMo4/Ch7pS
on6HN6PtE4pgE0s63U6aIB87jt+MhEdkXCfnYVOPmeo02GlYqBi2lyDtxWRM
kmHOrRVb+X0EWeamw4mGc23iVpZhhoYkTwyu/NQxXi0Dx9bs6sL+xqad+Vay
BOkRd3bIF9YVv73wGjbI8r+whvOKpdPcS+UI8mavQq0XfDF97o67PPJV/KIq
yYLJKuj7a3oSLprjPj0BUzlbspcUkK9DvxnPmzNZr9M1hkoUCfJJ/5HwN2ZM
ln4Z/yJTiSDNfcsVs+Fqu/efk/D1yoLCVPiKMErlE2xa65lVBueHaASYKxMk
yTOJp2K+o3crRgJhrf0Oalfh7D6Xn4LgKfe+TQOsrzNm8q8tXJlPq42FBZnv
CtThFqWgbG/YrF1q4ynmT/ZN6ZlBvIS+TkgSrJShnDwHd4bEDx2Am+ta6Yuw
UKVW/Xvs32HLsc0d8RZxYfe0Yf695Phm+FXO9aFGnJcyq24khA3vm5vZwEoc
t3cmyFexO/fZFPITE7aYWwl3MLZn0mDT8/7lkzA1mOOiAjce5ZlrIP9Zu7/s
yEa+bWss2NVwc8Na/Sbq0Rr60JyC+um5tameg/cKrp3LgkMG9CamUE9hHU2l
D9akGQtC4SsbjRVSZ5gs7chBnQXUv8X12Gcx8H0ev8wNDi8tudcMG9lljnei
f3wMjjUosVAPma2vJeDA3lvtF+EQrcQID/Tbe2Px/giYxl6LF4NpU1uXouHL
ybMvS9Cvg2nUMwnw4zznIgs4btU/qRUeM6JXUeHlyFl2G7xY+/i4AP2vkHde
MxCueZtV3AP/oRPA1RbNF5SheAPuPhzzpw2M6qQmwqODZTHSsGrXWz0HWJDe
KC0DU4osv2XA3JGWHCc4wrtpWWS1VcnYWth5Vi3IEV4fz3i+DfNbbjzxgp1s
Cq1LrZisgRyhshms80N55zB838cx/BB8cybUTsYa9ZR4nrCN//k2z5sYx/dw
y7aPC7AhczDoAewqJ+00Ct9hV71dg/1O9q82wYWcyTeGiOfvUWiIglNLpDaN
4YNTJ2eOw990jxbth6Oz6/+hwDSvcUYd4gMS7XcGcP9Ms5f8JrBf8R1/XhG8
Us1ZD4WHfpUnwuA3nisZ9vD8A1vGKdhePWFXJIxR9CPwozrqnp9F9UtxP6gK
l56e2ODDCrPGdxf2ECR7+UR2nygfAitJLhy0npnKFcWz2591w94Dzz/SsJ8e
4wtCkU9NSiyx4E6BdWI1XDrrNh8C517b2EmA8yt/SbSD8zbz9C1hvRerJeWY
L6FwOHxHnCD7x/IY9ei3L2b0OtZhKQ+sgH5Vsn1J1cR46bO6yaL76VVneUc4
vHAgNu879H9XcY1ZK+zETFGjw6qM283qOM+PRyaUufh//n9//weaqn0U
      "], CompressedData["
1:eJxE3Hk4VV0bB2ClCZEmM41IMoQow9lLIVRUHEooopQpkSRDJQpJ0iBJRZQo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      "], {{-87.552323, 30.27143}, {-87.553399, 30.272792}, {-87.553416, 
      30.274165}, {-87.552382, 30.276004999999998`}, {-87.55028399999999, 
      30.277396999999997`}, {-87.548175, 30.277874999999998`}, {-87.543939, 
      30.277458}, {-87.539703, 30.27704}, {-87.536018, 
      30.278447999999997`}, {-87.534426, 30.278005}, {-87.533851, 
      30.27435}, {-87.536495, 30.274326}, {-87.545461, 
      30.272409999999997`}, {-87.552323, 30.27143}}, {{-87.49024899999999, 
      30.298544}, {-87.48549899999999, 30.299501}, {-87.482871, 
      30.300897}, {-87.47971299999999, 30.302298}, {-87.474958, 
      30.302798}, {-87.472313, 30.302820999999998`}, {-87.468087, 
      30.303316}, {-87.465447, 30.303797}, {-87.462813, 
      30.304734999999997`}, {-87.461761, 30.305201999999998`}, {-87.460168, 
      30.304758}, {-87.459623, 30.30339}, {-87.45907299999999, 
      30.301565}, {-87.46011999999999, 30.300641}, {-87.462749, 
      30.299246}, {-87.46644599999999, 
      30.298755999999997`}, {-87.46907999999999, 30.297817}, {-87.471719, 
      30.297337}, {-87.47488799999999, 30.296851}, {-87.478585, 
      30.296360999999997`}, {-87.481224, 30.29588}, {-87.483334, 
      30.295403}, {-87.485968, 30.294463999999998`}, {-87.489125, 
      30.293063999999998`}, {-87.49439199999999, 30.291186}, {-87.500198, 
      30.290218}, {-87.504429, 30.29018}, {-87.50811999999999, 
      30.289230999999997`}, {-87.51234, 30.288276999999997`}, {-87.518664, 
      30.286388}, {-87.524987, 30.284499}, {-87.528138, 
      30.282639999999997`}, {-87.531311, 30.28261}, {-87.532386, 
      30.283973}, {-87.531356, 30.28627}, {-87.529258, 
      30.287661999999997`}, {-87.526097, 30.288607}, {-87.52398699999999, 
      30.289084}, {-87.521354, 30.290024}, {-87.518192, 
      30.290968}, {-87.516082, 30.291445}, {-87.512391, 
      30.292393999999998`}, {-87.51080999999999, 
      30.292866}, {-87.50871099999999, 30.294258}, {-87.50873299999999, 
      30.296087999999997`}, {-87.50769799999999, 
      30.297926999999998`}, {-87.50612199999999, 
      30.298856999999998`}, {-87.504012, 30.299333999999998`}, {-87.502425, 
      30.299348}, {-87.499775, 30.298914999999997`}, {-87.49659, 
      30.298029}, {-87.493946, 30.298053}, {-87.49024899999999, 
      30.298544}}, {{-88.137142, 30.293554}, {-88.139285, 
      30.294895}, {-88.142449, 30.29439}, {-88.14347, 
      30.292544999999997`}, {-88.14130899999999, 
      30.290288999999998`}, {-88.1413, 30.289831999999997`}, {-88.137078, 
      30.290352}, {-88.136039, 30.291283}, {-88.137142, 
      30.293554}}, {{-88.349406, 30.393131}, {-88.35095299999999, 
      30.391275}, {-88.350912, 30.389446}, {-88.34876299999999, 
      30.388109999999998`}, {-88.34503699999999, 
      30.387256999999998`}, {-88.34185, 30.386853}, {-88.339192, 
      30.38644}, {-88.337064, 30.386018}, {-88.334957, 
      30.386511}, {-88.333389, 30.387452}, {-88.33341999999999, 
      30.388824}, {-88.335039, 30.390169}, {-88.336648, 
      30.391057}, {-88.339305, 30.391469999999998`}, {-88.341444, 
      30.392349999999997`}, {-88.343572, 30.392771999999997`}, {-88.34571, 
      30.393651}, {-88.34782799999999, 30.393614999999997`}, {-88.349406, 
      30.393131}}, {{-88.268771, 30.338184}, {-88.27085799999999, 
      30.336778}, {-88.270809, 30.334491}, {-88.27024999999999, 
      30.333126999999998`}, {-88.269172, 30.33223}, {-88.268104, 
      30.331788999999997`}, {-88.267056, 30.332264}, {-88.26654599999999, 
      30.333187}, {-88.265547, 30.335948}, {-88.267174, 
      30.337752}, {-88.268771, 30.338184}}, {{-88.105448, 
      30.268855}, {-88.109202, 30.271545999999997`}, {-88.114015, 
      30.274220999999997`}, {-88.117223, 30.276004}, {-88.11987599999999, 
      30.276422}, {-88.12250999999999, 30.275926}, {-88.124061, 
      30.274072999999998`}, {-88.12560099999999, 30.271762}, {-88.125556, 
      30.269475}, {-88.12446299999999, 30.26766}, {-88.12285, 
      30.266312}, {-88.121783, 30.26587}, {-88.120744, 30.2668}, {-88.119176, 
      30.267739}, {-88.118665, 30.268660999999998`}, {-88.11707899999999, 
      30.268684999999998`}, {-88.11547499999999, 
      30.267792999999998`}, {-88.11439999999999, 
      30.266893999999997`}, {-88.112805, 30.26646}, {-88.111738, 
      30.266018}, {-88.109077, 30.265141}, {-88.106935, 
      30.2638}, {-88.10372799999999, 30.262017}, {-88.10104, 
      30.259767999999998`}, {-88.09942699999999, 30.258419}, {-88.097832, 
      30.257983999999997`}, {-88.096238, 30.25755}, {-88.094123, 
      30.257579999999997`}, {-88.093083, 30.258511}, {-88.09311, 
      30.259883}, {-88.094732, 30.261689999999998`}, {-88.100089, 
      30.265272999999997`}, {-88.105448, 30.268855}}, {{-87.552323, 
      30.27143}, {-87.545461, 30.272409999999997`}, {-87.536495, 
      30.274326}, {-87.533851, 30.27435}, {-87.534426, 
      30.278005}, {-87.536018, 30.278447999999997`}, {-87.539703, 
      30.27704}, {-87.543939, 30.277458}, {-87.548175, 
      30.277874999999998`}, {-87.55028399999999, 
      30.277396999999997`}, {-87.552382, 30.276004999999998`}, {-87.553416, 
      30.274165}, {-87.553399, 30.272792}, {-87.552323, 
      30.27143}}, CompressedData["
1:eJxd1nk8lGsbB3BGyJZ9DzkhMlJR6pXmKUaWNsskQtnyZhmSFom8trQoWzqd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      "], {{-87.96309199999999, 30.233779}, {-87.964686, 
      30.234215}, {-87.965751, 30.234658999999997`}, {-87.965784, 
      30.236489}, {-87.966337, 30.237854}, {-87.96846699999999, 
      30.238740999999997`}, {-87.970557, 30.23734}, {-87.972134, 
      30.236862}, {-87.976337, 30.235432}, {-87.980037, 
      30.235381999999998`}, {-87.984265, 30.235325}, {-87.987436, 
      30.235281999999998`}, {-87.99324899999999, 30.235204}, {-87.999566, 
      30.233745}, {-88.005371, 30.233207}, {-88.01329, 
      30.232640999999997`}, {-88.017518, 30.232582999999998`}, {-88.021209, 
      30.232073999999997`}, {-88.024883, 30.230649999999997`}, {-88.026979, 
      30.229706}, {-88.027985, 30.226945999999998`}, {-88.030577, 
      30.224164}, {-88.032128, 30.222312}, {-88.03316799999999, 
      30.221382}, {-88.03313299999999, 30.219552}, {-88.032562, 
      30.217271999999998`}, {-88.030423, 30.215929}, {-88.027253, 
      30.215972999999998`}, {-88.023043, 30.216946999999998`}, {-88.0162, 
      30.218415}, {-88.006722, 30.220375999999998`}, {-87.995676, 
      30.223271999999998`}, {-87.986717, 30.224767}, {-87.97775, 
      30.225803}, {-87.971954, 30.226796}, {-87.964556, 
      30.226895}, {-87.951881, 30.227521}, {-87.938678, 
      30.228153}, {-87.927044, 30.227846999999997`}, {-87.91435299999999, 
      30.227553999999998`}, {-87.904304, 30.227224999999997`}, {-87.893199, 
      30.226909}, {-87.87944399999999, 30.226167999999998`}, {-87.866754, 
      30.225869}, {-87.86643, 30.238228}, {-87.870122, 
      30.237724999999998`}, {-87.886499, 30.237060999999997`}, {-87.900784, 
      30.237795}, {-87.938253, 30.234106999999998`}, {-87.96309199999999, 
      30.233779}}, {{-87.741191, 30.276321}, {-87.74121199999999, 
      30.277694}, {-87.741782, 30.280431999999998`}, {-87.742902, 
      30.284537999999998`}, {-87.745065, 30.287716}, {-87.74613699999999, 
      30.288618999999997`}, {-87.74825899999999, 
      30.289051999999998`}, {-87.750361, 30.288113}, {-87.751398, 
      30.286728999999998`}, {-87.751363, 30.284442}, {-87.75132099999999, 
      30.281696999999998`}, {-87.753416, 30.280299999999997`}, {-87.754988, 
      30.279366999999997`}, {-87.741191, 30.276321}}, {{-87.83882799999999, 
      30.361188}, {-87.836659, 30.358012}, {-87.83449, 
      30.354836}, {-87.83124699999999, 30.350758}, {-87.827469, 
      30.346228}, {-87.823698, 30.342156}, {-87.818832, 
      30.33581}, {-87.81293099999999, 30.330848}, {-87.806523, 
      30.327264}, {-87.80010899999999, 30.323223}, {-87.794753, 
      30.319169}, {-87.789949, 30.31648}, {-87.784086, 
      30.313803999999998`}, {-87.779282, 30.311114999999997`}, {-87.773928, 
      30.307059}, {-87.771777, 30.304796}, {-87.769605, 
      30.301160999999997`}, {-87.764746, 30.294812}, {-87.762574, 
      30.291176}, {-87.76043, 30.289371}, {-87.758837, 
      30.288932}, {-87.757257, 30.289406999999997`}, {-87.757814, 
      30.291231}, {-87.757842, 30.293060999999998`}, {-87.756812, 
      30.294902999999998`}, {-87.754196, 30.296763}, {-87.75440499999999, 
      30.310485999999997`}, {-87.76128899999999, 30.310865}, {-87.761352, 
      30.314981999999997`}, {-87.767172, 30.314915}, {-87.76722099999999, 
      30.318116999999997`}, {-87.772004, 30.319433999999998`}, {-87.776321, 
      30.324873999999998`}, {-87.780125, 30.331235}, {-87.788598, 
      30.331594}, {-87.797209, 30.340642}, {-87.797288, 
      30.345674}, {-87.809997, 30.345979999999997`}, {-87.810062, 
      30.350096999999998`}, {-87.817545, 30.354582999999998`}, {-87.82239, 
      30.359557}, {-87.82244899999999, 
      30.363215999999998`}, {-87.83155099999999, 
      30.36951}, {-87.83882799999999, 30.361188}}, {{-88.204943, 
      34.0587}, {-88.206317, 34.045496}, {-88.22801299999999, 
      33.898775}, {-88.247367, 33.749781999999996`}, {-88.265536, 
      33.600318}, {-88.27341299999999, 
      33.534234999999995`}, {-88.08549699999999, 33.529699}, {-88.051305, 
      33.527436}, {-87.946056, 33.524257999999996`}, {-87.946015, 33.641615},
       {-87.94985199999999, 33.789373999999995`}, {-87.949877, 
      33.790738}, {-87.952, 33.875288999999995`}, {-87.951169, 
      33.919858}, {-87.951634, 34.004415}, {-87.951376, 34.02033}, {-87.95141,
       34.022148}, {-87.95418099999999, 34.022113}, {-87.98745199999999, 
      34.023055}, {-87.986353, 34.052617999999995`}, {-88.010761, 
      34.053211}, {-88.204943, 34.0587}}, {{-88.103122, 
      34.849872999999995`}, {-88.105069, 34.835766}, {-88.10226, 
      34.835350999999996`}, {-88.10056999999999, 34.834919}, {-88.09666, 
      34.835426999999996`}, {-88.094439, 34.836366}, {-88.093338, 
      34.837289}, {-88.092806, 34.838659}, {-88.09340399999999, 
      34.840467}, {-88.09514, 34.843168999999996`}, {-88.09629799999999, 
      34.844969999999996`}, {-88.098016, 34.846762999999996`}, {-88.099724, 
      34.848103}, {-88.101992, 34.849433999999995`}, {-88.103122, 
      34.849872999999995`}}, CompressedData["
1:eJxd1nk41GsbB3B1SJZy5BUdSpE1LZZTyvA8ypqy1ZQlDBHphJZDJZIKLZMT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      "], {{-85.0598, 32.062915}, {-85.059235, 
      32.064276}, {-85.06027499999999, 32.066569}, {-85.060193, 
      32.071127}, {-85.06011099999999, 32.075685}, {-85.063396, 
      32.073448}, {-85.064542, 32.069815}, {-85.065156, 
      32.065719}, {-85.06520499999999, 32.062984}, {-85.0598, 
      32.062915}}, {{-85.206289, 32.968145}, {-85.207383, 
      32.968157999999995`}, {-85.211742, 32.969117}, {-85.216093, 
      32.970532}, {-85.220445, 32.971947}, {-85.224819, 
      32.971996}, {-85.22868299999999, 32.969763}, {-85.230389, 
      32.965683999999996`}, {-85.229354, 32.96203}, {-85.226657, 
      32.959724}, {-85.224493, 32.958334}, {-85.219602, 
      32.956458}, {-85.21471199999999, 32.954582}, {-85.211469, 
      32.952269}, {-85.208773, 32.949962}, {-85.208818, 
      32.947230999999995`}, {-85.209948, 32.944967}, {-85.21109299999999, 
      32.941793}, {-85.21056899999999, 32.940422}, {-85.208952, 
      32.939038}, {-85.20732699999999, 32.938108}, {-85.20572399999999, 
      32.935814}, {-85.20412999999999, 32.933064}, {-85.20256499999999, 
      32.928492999999996`}, {-85.20211499999999, 
      32.922568999999996`}, {-85.20275099999999, 32.917113}, {-85.203904, 
      32.913484}, {-85.195769, 32.909748}, {-85.206289, 
      32.968145}}, CompressedData["
1:eJxd1Xk0VVscB3CZhTQaI0PqJeMlVDznVJ6r3kXDSa/hmhORaVXKMyW3HhUr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      "], {{-88.16015999999999, 31.849643999999998`}, {-88.174195, 
      31.850348}, {-88.174166, 31.848979999999997`}, {-88.171981, 
      31.847644}, {-88.171944, 31.84582}, {-88.17133799999999, 
      31.842636}, {-88.171281, 31.8399}, {-88.171773, 31.837612}, {-88.171678,
       31.833052}, {-88.173228, 31.829835}, {-88.17318999999999, 
      31.828011}, {-88.168397, 31.83082}, {-88.16110599999999, 
      31.843244}, {-88.16015999999999, 31.849643999999998`}}, {{-88.192488, 
      31.797158}, {-88.197346, 31.797541}, {-88.197654, 
      31.786586999999997`}, {-88.191199, 31.787141}, {-88.18253299999999, 
      31.784989999999997`}, {-88.178744, 31.784133999999998`}, {-88.171656, 
      31.780134}, {-88.167782, 31.775174}, {-88.16610899999999, 
      31.772461}, {-88.161801, 31.772524999999998`}, {-88.164031, 
      31.776142}, {-88.164833, 31.788904}, {-88.17651599999999, 
      31.806521}, {-88.181074, 31.818313999999997`}, {-88.176329, 
      31.823403}, {-88.17318999999999, 31.828011}, {-88.173228, 
      31.829835}, {-88.171678, 31.833052}, {-88.171773, 
      31.837612}, {-88.171281, 31.8399}, {-88.17133799999999, 
      31.842636}, {-88.171944, 31.84582}, {-88.171981, 
      31.847644}, {-88.174166, 31.848979999999997`}, {-88.177391, 
      31.848475999999998`}, {-88.17997199999999, 
      31.842962999999997`}, {-88.180397, 31.837483}, {-88.181389, 
      31.833363}, {-88.184026, 31.830586}, {-88.190427, 
      31.827296999999998`}, {-88.196826, 
      31.824006999999998`}, {-88.20270599999999, 31.821637}, {-88.204871, 
      31.822060999999998`}, {-88.20807599999999, 
      31.820642999999997`}, {-88.20852699999999, 
      31.816530999999998`}, {-88.204207, 
      31.816139999999997`}, {-88.19829899999999, 
      31.817141999999997`}, {-88.192881, 31.815856}, {-88.18799299999999, 
      31.814103999999997`}, {-88.18579, 31.811857}, {-88.183568, 
      31.808697}, {-88.181866, 31.804616999999997`}, {-88.183945, 
      31.800936}, {-88.188707, 31.796758999999998`}, {-88.192488, 
      31.797158}}, {{-88.197346, 31.797541}, {-88.198962, 
      31.797515999999998`}, {-88.205975, 31.797866}, {-88.211901, 
      31.797776}, {-88.215075, 31.79499}, {-88.222549, 
      31.791681999999998`}, {-88.225213, 31.790273}, {-88.221932, 
      31.788041999999997`}, {-88.208975, 31.786872}, {-88.19819199999999, 
      31.786579}, {-88.197654, 31.786586999999997`}, {-88.197346, 
      31.797541}}, {{-88.204871, 31.822060999999998`}, {-88.208124, 
      31.822923999999997`}, {-88.211945, 31.825146}, {-88.213571, 
      31.825578}, {-88.215746, 31.826456999999998`}, {-88.21683399999999, 
      31.826895999999998`}, {-88.222233, 31.82727}, {-88.225966, 
      31.825388}, {-88.226985, 31.822635}, {-88.21990199999999, 
      31.819094}, {-88.210692, 31.816954}, {-88.20852699999999, 
      31.816530999999998`}, {-88.20807599999999, 
      31.820642999999997`}, {-88.204871, 
      31.822060999999998`}}, {{-88.20852699999999, 
      31.816530999999998`}, {-88.208518, 31.816074999999998`}, {-88.192103, 
      31.804463}, {-88.192488, 31.797158}, {-88.188707, 
      31.796758999999998`}, {-88.183945, 31.800936}, {-88.181866, 
      31.804616999999997`}, {-88.183568, 31.808697}, {-88.18579, 
      31.811857}, {-88.18799299999999, 31.814103999999997`}, {-88.192881, 
      31.815856}, {-88.19829899999999, 31.817141999999997`}, {-88.204207, 
      31.816139999999997`}, {-88.20852699999999, 
      31.816530999999998`}}, {{-88.17318999999999, 31.828011}, {-88.176329, 
      31.823403}, {-88.181074, 31.818313999999997`}, {-88.17651599999999, 
      31.806521}, {-88.164833, 31.788904}, {-88.164031, 
      31.776142}, {-88.161801, 31.772524999999998`}, {-88.15843799999999, 
      31.766188}, {-88.14036, 31.751399}, {-88.13819699999999, 
      31.750974}, {-88.129656, 31.754748}, {-88.128625, 
      31.757043999999997`}, {-88.118532, 31.764032999999998`}, {-88.119683, 
      31.767667}, {-88.122886, 31.766251999999998`}, {-88.126638, 
      31.765285}, {-88.133044, 31.762455}, {-88.140592, 
      31.762801}, {-88.149264, 31.765411}, {-88.15531899999999, 
      31.771708999999998`}, {-88.15648999999999, 
      31.776252999999997`}, {-88.159334, 31.783510999999997`}, {-88.161658, 
      31.791687999999997`}, {-88.165022, 31.798025}, {-88.168992, 
      31.807546}, {-88.173936, 31.812033999999997`}, {-88.175052, 
      31.813841999999998`}, {-88.176735, 31.81701}, {-88.17576199999999, 
      31.822042999999997`}, {-88.17318999999999, 
      31.828011}}, {{-88.16610899999999, 31.772461}, {-88.164447, 
      31.770204999999997`}, {-88.160564, 31.764788}, {-88.152318, 
      31.756698}, {-88.146858, 31.753128}, {-88.14137199999999, 
      31.748189999999997`}, {-88.136535, 31.748717}, {-88.13065, 
      31.750628}, {-88.126398, 31.753427}, {-88.123742, 
      31.75529}, {-88.12114199999999, 31.75989}, {-88.12061299999999, 
      31.760354}, {-88.119545, 31.760824999999997`}, {-88.117391, 
      31.760855999999997`}, {-88.118532, 31.764032999999998`}, {-88.128625, 
      31.757043999999997`}, {-88.129656, 31.754748}, {-88.13819699999999, 
      31.750974}, {-88.14036, 31.751399}, {-88.15843799999999, 
      31.766188}, {-88.161801, 31.772524999999998`}, {-88.16610899999999, 
      31.772461}}, {{-87.84848699999999, 
      34.511939999999996`}, {-87.85178499999999, 
      34.509176}, {-87.85516299999999, 34.510954}, {-87.85525, 
      34.51595}, {-87.85920999999999, 34.519085}, {-87.865878, 
      34.517644}, {-87.86873, 34.521245}, {-87.87489699999999, 
      34.52299}, {-87.880417, 34.519743999999996`}, {-87.88607499999999, 
      34.524221}, {-87.897795, 34.524535}, {-87.90006699999999, 
      34.526779}, {-87.899033, 34.531335}, {-87.902872, 
      34.527654}, {-87.904594, 34.53036}, {-87.90907299999999, 
      34.531214}, {-87.914683, 34.532964}, {-87.911469, 
      34.540272}, {-87.909937, 34.548013999999995`}, {-87.90005099999999, 
      34.556765}, {-87.89617, 34.558174}, {-87.89343799999999, 
      34.561386999999996`}, {-87.910685, 34.558454}, {-87.91444899999999, 
      34.550685}, {-87.921568, 34.54333}, {-87.918688, 
      34.538367}, {-87.92304999999999, 34.532862}, {-87.930418, 
      34.539131999999995`}, {-87.938785, 34.53903}, {-87.93717099999999, 
      34.542229999999996`}, {-87.94547899999999, 34.538947}, {-87.949451, 
      34.542532}, {-87.957819, 34.542428}, {-87.956248, 
      34.547899}, {-87.964659, 34.550066}, {-87.97004799999999, 
      34.540003}, {-87.964838, 34.530073}, {-87.964238, 
      34.527809}, {-87.954859, 34.533378}, {-87.946382, 
      34.527577}, {-87.93803299999999, 34.528589}, {-87.935693, 
      34.522712}, {-87.927269, 34.519635}, {-87.923232, 
      34.512415}, {-87.922799, 34.519235}, {-87.914434, 
      34.519337}, {-87.907185, 34.519425}, {-87.89921299999999, 
      34.510434}, {-87.899271, 34.513613}, {-87.89544099999999, 
      34.517748}, {-87.886979, 34.512397}, {-87.875301, 
      34.514353}, {-87.868569, 34.51216}, {-87.864634, 
      34.510388999999996`}, {-87.857258, 34.503206}, {-87.847803, 
      34.504678}, {-87.84848699999999, 34.511939999999996`}}, {{-86.784199, 
      32.324273}, {-86.772866, 32.340706}, {-86.78056, 
      32.368939}, {-86.782192, 32.370301999999995`}, {-86.78118599999999, 
      32.392632}, {-86.774681, 32.395381}, {-86.757291, 
      32.389499}, {-86.746436, 32.389979}, {-86.737222, 
      32.394555}, {-86.72748, 32.404599}, {-86.73724399999999, 
      32.401845}, {-86.742678, 32.403656}, {-86.745389, 
      32.402283}, {-86.743746, 32.397731}, {-86.74645199999999, 
      32.394991}, {-86.778491, 32.398106}, {-86.783913, 
      32.39627}, {-86.784972, 32.388977}, {-86.787083, 
      32.372112}, {-86.78325799999999, 
      32.364830999999995`}, {-86.78160299999999, 32.357089}, {-86.777209, 
      32.341606999999996`}, {-86.780988, 32.336585}, {-86.78746199999999, 
      32.326543}, {-86.784199, 32.324273}}, {{-87.670289, 
      34.308487}, {-87.669231, 34.312132999999996`}, {-87.66596899999999, 
      34.317164}, {-87.655529, 34.325902}, {-87.644531, 
      34.334645}, {-87.642955, 34.341021999999995`}, {-87.648607, 
      34.346874}, {-87.650731, 34.340036999999995`}, {-87.65453199999999, 
      34.333636999999996`}, {-87.66444299999999, 
      34.326722}, {-87.67271199999999, 34.321639999999995`}, {-87.676468, 
      34.312514}, {-87.67808199999999, 34.308862}, {-87.670289, 
      34.308487}}, {{-87.670289, 34.308487}, {-87.67808199999999, 
      34.308862}, {-87.68076599999999, 34.302473}, {-87.686195, 
      34.293783999999995`}, {-87.68943399999999, 34.287388}, {-87.693208, 
      34.279624}, {-87.692047, 34.276455}, {-87.686967, 
      34.271508}, {-87.678045, 34.269781}, {-87.66926, 
      34.277141}, {-87.657084, 34.280898}, {-87.65726, 
      34.292712}, {-87.65124399999999, 34.299588}, {-87.648906, 
      34.291886}, {-87.642186, 34.288771}, {-87.639955, 
      34.288337999999996`}, {-87.638307, 34.289718}, {-87.63888299999999, 
      34.291075}, {-87.640552, 34.291059}, {-87.64226, 
      34.293769}, {-87.644544, 34.297836}, {-87.646856, 
      34.303720999999996`}, {-87.656317, 34.304082}, {-87.66564199999999, 
      34.295355}, {-87.666068, 34.286716}, {-87.67270599999999, 
      34.284377}, {-87.67708499999999, 34.279787999999996`}, {-87.680942, 
      34.277477}, {-87.683235, 34.281998}, {-87.682769, 
      34.287911}, {-87.674031, 34.298451}, {-87.670289, 
      34.308487}}, {{-87.425843, 34.799956}, {-87.429619, 
      34.788118}, {-87.43227999999999, 34.776742999999996`}, {-87.430025, 
      34.775397999999996`}, {-87.425685, 34.786787}, {-87.423485, 
      34.789983}, {-87.411748, 34.791438}, {-87.40392299999999, 
      34.792407}, {-87.39103999999999, 34.791596999999996`}, {-87.382697, 
      34.796202}, {-87.382781, 34.803467999999995`}, {-87.393954, 
      34.801566}, {-87.425843, 34.799956}}, CompressedData["
1:eJxd1Xs4VdkbB3Amd5Lqh3IN0ZwkJDVMrCWJSZLYLqUhlzAiJ5mSW0VyO8ol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      "], {{-87.150904, 33.993044999999995`}, {-87.145365, 
      33.993075999999995`}, {-87.111567, 33.99235}, {-87.111638, 
      34.001441}, {-87.11225999999999, 34.010075}, {-87.111781, 
      34.019622999999996`}, {-87.111795, 34.021442}, {-87.111856, 
      34.029168999999996`}, {-87.11192, 34.037351}, {-87.111583, 
      34.06508}, {-87.111104, 34.074628}, {-87.111701, 
      34.080079}, {-87.11172599999999, 34.083259999999996`}, {-87.111858, 
      34.100077}, {-87.11076399999999, 34.172803}, {-87.11050499999999, 
      34.210525}, {-87.205523, 34.213167999999996`}, {-87.207145, 
      34.024989999999995`}, {-87.207054, 34.01499}, {-87.207431, 
      33.995441}, {-87.207381, 33.989986}, {-87.204017, 
      33.985461}, {-87.19958199999999, 33.985033}, {-87.196339, 
      33.994144}, {-87.19140999999999, 34.000538}, {-87.189768, 
      34.002821}, {-87.184794, 34.004214}, {-87.173172, 
      34.005646}, {-87.161491, 34.000257999999995`}, {-87.150904, 
      33.993044999999995`}}, {{-85.749353, 32.959351}, {-85.731859, 
      32.959235}, {-85.731779, 32.967428999999996`}, {-85.72740499999999, 
      32.967399}, {-85.727369, 32.971041}, {-85.722995, 
      32.971011}, {-85.722959, 32.974652999999996`}, {-85.71421099999999, 
      32.974593}, {-85.714066, 32.989159}, {-85.74853, 
      32.988481}, {-85.74866399999999, 32.97437}, {-85.74875899999999, 
      32.964355}, {-85.749353, 32.959351}}, CompressedData["
1:eJxd1Hs0lHkYB/DJMpEVIWu0kaJiGrdMuY7fy4aJprZ2mFmUMlJLF9cULbnE
uswmi7WhOrZCNpVQK5nIHlRUElayapgpZHM5sZzs17/98Z73fM7veZ/f5X1+
j+G+IzsDFWg0mh+ehbf9Lvndv0R8SQY3zjzZkSK0NwzryUC+hOOzeHEMPPhk
de8MHG20u6jNiSKdZ8VhFkF8SeyWmt0dMC+2qtgGzjyR6nqMUGTVY4F14cL4
2lnZQbjyceZblQN8iZkBl6tOUeTpkE2NykG+JM/WT0cL9pddfmwD05m8Kh3E
/xtspNKA+DepVdPacN8juVsjvHSq9job84VPZMqLkD/+jg6LwJqe7Mpc2IlW
uq2AQ5ETjSelL/bzJe2TmgH5sOeVyBXP4eV2FTc87ChSGxP//iH8hdKrliu2
FFnWJFWzQP65Bia3CLZq9ksygesLeq492UyRNYWnsvKQf9B4PrseHs+9anAO
ZpR+/I7HpkhAXskrPcTrWw267IDTvIW92vCBNV3bTDZS5CVzwssPHklWqE6E
dS4l+fPh03rJRpVWFDkuVacXwcpenQ/HYAdRa8oFuG7TCqalJUUKisXiq3Af
var/b3OKyE9fHpmE952npWXBc//EvhPg/Lo35GW2wREcB48zcJV1jbMANmvO
HRyGR8xr16nDPeTP7ls/YD/Hjx57YUaRe/VUzBRs2daf5AzHWP6iNQpP2G/b
f5dFkfxxwxK9YL7kYEiFUh0sElp8cIO9d487zcBuCmqbIuHw509D2fg+586M
awTc9EeCrhw+ey0/thK2e5T3lT/mr2gvmDIJ4Uscl3QVH4UDnkZEWcGmmb/2
yGAFkxvBMXBg+u99cpinZn0+HI4JfFU2jHwXa6Kj25EvIa1sz1t4Y6OrsB5W
aYw39sZ6nu0oPiOCjdQOB6vC6bpRutkwV2QgEm5A/cRN3T4CGzCnD6UyKXJU
1uBuDl9kLiv5BHu0hGluhX+eiSdBiOcpr4xQgbUNI+1n4ZGgG9otOJ9vNOsy
9iG/4gMj32aYqrr/kxzWWM0IC4Gvz9ttPoT1tRf6z0fi/Hk/pvNy4c6heb4b
3MORsryxv8Tt4eOr4YSw3ntusMHtVi1leLlND/094uP9xfr1+N+2zvTxETg6
f29xOaz6W66AgXhx8zGTSLjCWJpYBCvbJJmyYdn9PmHtQj28j6qzhjkGgQ+U
LChy6LDndgEsLXRhlMHPLsVxTeFJntLLCVh6QFw+h/ruW4vKhYNyFUtK4XpV
n8oc1GN//4W6/2BWa8gZLuq1zLWCvh7fD2/W6kiGu/dEbdeHO9w9BkfhIyL9
mUTEO3Z4ZATCQ3SXlV7wiYG25Cx4cF0nZyW8RUM2oGhNkWGvdu7Ywv282VXr
BJ9stRS+hJlBYxnV8ADK/RLsteSU72t48qLqOx/4WSj7JhP3b0B5p0kUbLt+
7+VRWDdr/a1y9K+zLaWFezdR5OHW7J1PYBna0Ee4sNtlVgB/ql7nHoL7/bWv
3ZADvHwRb+w17FeXlrEULgkR7BLaUORLBWaKDny3WXFOD/2iVbKI5QfvWcPV
uIb+UpJWOqkFV3ePVrbCDWZp+tPor9ELhWNPkXOvQ79lYfxcU3qyoQPufzmD
IcW44fyjVRyYFs76Ph7OuS0ObUK8C9tYmAKjy3Sboh9/SEh9fgsOMB4ScuHP
+/f/1a6aAA==
      "], {{-85.65008499999999, 33.700308}, {-85.64941999999999, 
      33.710763}, {-85.649765, 33.729865}, {-85.691165, 
      33.730616999999995`}, {-85.69102, 33.744713}, {-85.79590999999999, 
      33.748129}, {-85.798225, 33.73632}, {-85.80271499999999, 
      33.728162}, {-85.814364, 33.721865}, {-85.822155, 
      33.714636}, {-85.823949, 33.69873}, {-85.820208, 33.68461}, {-85.813155,
       33.670925}, {-85.812163, 33.658184999999996`}, {-85.74377299999999, 
      33.657302}, {-85.74306299999999, 33.67367}, {-85.727064, 
      33.673564}, {-85.72679, 33.701302999999996`}, {-85.65008499999999, 
      33.700308}}, {{-85.898656, 33.672312}, {-85.89129, 
      33.697286}, {-85.899166, 33.749621999999995`}, {-86.022857, 
      33.751564}, {-86.023769, 33.692451999999996`}, {-85.93383899999999, 
      33.689772}, {-85.915714, 33.678312}, {-85.898656, 
      33.672312}}, {{-87.64331, 30.501526}, {-87.642984, 
      30.516164}, {-87.660485, 30.515981}, {-87.660808, 
      30.501343}, {-87.64331, 30.501526}}, CompressedData["
1:eJxd1H8wlHkcB/CVkN1o2SPJCeVykuS4U8o+j2TWpYT2qZQlYU1kFbJatCWK
SBo75frByV75sbmNNc6P69GF6ioVWVHpxky3uou5MptEe++dub/uj52d1+yz
3+fz/X4/n7djjCgsbg6DwYjER/991YG7+JdPfLrMfXZTWCJJ7JkWbEiBI605
F0rgg8mccRn8dkHZsBZe31vxbS28T328qTuJJLZ83SB7BIe6F0eJ95PEJfZa
jeUMn65eqPrETyaJ1tzBcn+4YOmCAGsRSVxxEGdJ4Pb7P4cOwEXq9tpGOEFf
QApJnLpykKOCN/Y9u/sKzknxS6+HZ3N5+XYHSEJ2XuisgI/HJWniYf/7zvxh
eMjWoigXjmgeWGg6y6efl5vmp8IlXi2KlXCppLV1L7ytNuDZLlhfnhS+2d97
oRBObaEkg3BudUidBo4ujeLePkgS8a3qoOzPfJq3dcYmNZUk0msspsth39vc
pDFYvLzCfhguZe5lkWnYv+vIN5Y6Ph3Tyq7jwtYeR3dl6P7bH7xD1M/sgze7
d9Nr4TN5GrYPg6INPlq6+sDBXrzOcDgxdntEIDxqdfJyGfxrboWPFF4gaGv6
w4CiNZzMs2npJMHs+LzMbw5F53IeNyhgw98tPM/A2kiLGRFMunad7oYrvfpd
lsGVszyLRYYULVTR9hw432DT9RiYE/DCxAFe83D/rQ447PwHnz68b6W/0spr
LkWr5YEaIZzKTmuqhYsFZltt4XGj+DwnI4re0ki0bYDjFrcYpsPp6+IrPWGK
9zFIBYf98GDUA9YyWeMmxhQ93Rxd4w53FBaZ8+A8ow+G9nBf/m9PaDgnfEdN
JWxsnjDGNKFoM7nWaQiuPfzx0lfwgE2avwa+mf2ljxB+7RjuNxf190R31QzA
bK5uvRgWuWQ1m89D/VPB2l79fpO1JvfgLf5jLMcM3E9CBm+1KUXHtEmk4/Cb
G+cHs2AFfeapQkwSDZl8oQqe8lq+yjOTJHoT6s7egTN3clhZcOBuhq0cLhFN
2E7CGeZx1wrhR+deft59mCQkbtmaY/CIvN95FJa+y5i4Bl/f4O28U0ISX9y7
pVbDLtG+NkpYOFHU7Mqk6FcXLeQdcOacPVd3wGEB+fx2+EnnNPcEfHeN8oQW
PnLZeP5ZONz+xbxTWSQR0/6afwmO6QhdEZxNEpuPfVcdyqLoiFjfkZAjJDE3
pVGshItZJv43pNj/cHWV3uYVaU6dsI0yhNEFs7c/fLnoKEm4sKKi/ppP0d0/
yfwd4MFx+8pP8KqkB5QAz/NXy3JuwQxvVZIC66Nbg8zg90ueiKLw/seprMgC
rPeIcLuwBvVd9NjjtQIeehUwmYj60ZXlT1Hv7m2nTsbgfEpNp7z1+9me4dYc
hPPUHXrW4AsbTGfrXuN+PEtmOmmcV8uXttZXDqH+xJY76+H6+v2FPbjfbK63
oBX3u8nIin8T/SFXx+91huXSJp0BbGUnYJeiP4y/Z7pJMb+9768Wv0G/2Wl+
bDaDu0arIgJgmWrzPy2Yf29xlIyF/i1aNTSaB5cJBeZtmI99HSMJPXjemQpc
WoH5cnoeu20R1v+7s3pqCvNZ4Lck7jZ+P60QzuvB/E6GpCir8P/6GjdmG+bf
Xec4q0XevFO2EUHIj8QjQskk8s4jNr3uT+SZ3bkD4YbIx6RGpeV75GvVRHJc
AfJ23b7gk/q8thnb+DYHefz//P4XSTCf2A==
      "], CompressedData["
1:eJxd2Hc8lt0fB3BSSUb2ekQKhTIyS7gvlU3WTZGyhZIiycwsIzweI2RWQpSR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      "], {{-86.99516799999999, 34.679486}, {-86.99571, 
      34.676759}, {-86.996813, 34.674482999999995`}, {-86.99734199999999, 
      34.669939}, {-86.996769, 34.66767}, {-86.993419, 
      34.668139}, {-86.988401, 34.669976}, {-86.987264, 
      34.666802}, {-86.987802, 34.66362}, {-86.983318, 
      34.661367999999996`}, {-86.97771999999999, 34.659574}, {-86.980491, 
      34.655929}, {-86.984966, 34.656819}, {-86.989977, 
      34.654072}, {-86.993341, 34.655875}, {-86.99783699999999, 
      34.659943999999996`}, {-87.005653, 34.659002}, {-87.011793, 
      34.658066999999996`}, {-87.01066, 34.655801}, {-87.008957, 
      34.65172}, {-87.006717, 34.650821}, {-87.003362, 
      34.650382}, {-86.996634, 34.646777}, {-86.98991699999999, 
      34.644534}, {-86.985428, 34.641373}, {-86.97251299999999, 
      34.630524}, {-86.96857899999999, 34.626452}, {-86.96185799999999, 
      34.623298999999996`}, {-86.959638, 34.625579}, {-86.957976, 
      34.627857}, {-86.97314399999999, 34.642331999999996`}, {-86.975979, 
      34.649134}, {-86.976602, 34.659577999999996`}, {-86.982782, 
      34.665003999999996`}, {-86.988986, 34.674062}, {-86.99516799999999, 
      34.679486}}, {{-87.976828, 34.456770999999996`}, {-87.97514799999999, 
      34.456337999999995`}, {-87.971222, 34.455025}, {-87.96336099999999, 
      34.451943}, {-87.956015, 34.446583}, {-87.949776, 
      34.440754}, {-87.94299, 34.435385}, {-87.933984, 
      34.430498}, {-87.927191, 34.424675}, {-87.92100599999999, 
      34.421569999999996`}, {-87.91258599999999, 
      34.418037}, {-87.90526299999999, 34.413582}, {-87.899637, 
      34.410469}, {-87.896271, 34.409146}, {-87.893487, 
      34.409179}, {-87.889597, 34.40968}, {-87.890768, 
      34.412847}, {-87.898122, 34.41912}, {-87.899326, 
      34.424104}, {-87.902709, 34.426335}, {-87.906624, 
      34.427197}, {-87.909975, 34.427611}, {-87.916151, 
      34.430262}, {-87.916176, 34.431625}, {-87.918504, 
      34.437049}, {-87.921348, 34.440194999999996`}, {-87.926378, 
      34.441041999999996`}, {-87.931975, 34.442337}, {-87.93871899999999, 
      34.445434999999996`}, {-87.942695, 34.449475}, {-87.945574, 
      34.454437}, {-87.943421, 34.458553}, {-87.938457, 
      34.461341}, {-87.934598, 34.46366}, {-87.930165, 
      34.465078}, {-87.928527, 34.466915}, {-87.926897, 
      34.469207}, {-87.92806999999999, 34.472373}, {-87.936396, 
      34.470453}, {-87.944165, 34.46854}, {-87.950261, 
      34.466647}, {-87.95807099999999, 
      34.467003999999996`}, {-87.96426199999999, 34.470107}, {-87.969295, 
      34.470952}, {-87.976828, 34.456770999999996`}}, CompressedData["
1:eJxd1Xk0lGscB/CJSWWZ7LcQSUVIDLKWJxRCRCNR3XK0WUKDUCnaaLGMlrmS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      "], {{-87.804276, 30.552329}, {-87.803978, 
      30.566965999999997`}, {-87.82149, 30.566757}, {-87.821784, 
      30.552121}, {-87.804276, 30.552329}}, {{-87.626841, 
      30.383692}, {-87.62651199999999, 30.398332999999997`}, {-87.643988, 
      30.398152999999997`}, {-87.644314, 30.383511}, {-87.626841, 
      30.383692}}, {{-88.38089699999999, 30.357369}, {-88.378293, 
      30.359244}, {-88.37779499999999, 30.360625}, {-88.378356, 
      30.361988}, {-88.379964, 30.362876}, {-88.381012, 
      30.362399999999997`}, {-88.38257899999999, 30.361458}, {-88.384136, 
      30.360059}, {-88.38569199999999, 30.358659999999997`}, {-88.386719, 
      30.35727}, {-88.386698, 30.356354999999997`}, {-88.38666599999999, 
      30.354982999999997`}, {-88.386656, 30.354526}, {-88.385587, 
      30.354086}, {-88.38453899999999, 30.354561999999998`}, {-88.382972, 
      30.355504}, {-88.38089699999999, 30.357369}}, {{-88.397114, 
      30.348855}, {-88.39606599999999, 30.349331}, {-88.39397, 
      30.350282}, {-88.392403, 30.351224}, {-88.39082599999999, 
      30.351709}, {-88.389291, 30.354022999999998`}, {-88.38879399999999, 
      30.355404}, {-88.389344, 30.356309999999997`}, {-88.39040299999999, 
      30.356291}, {-88.39092099999999, 30.355825}, {-88.394086, 
      30.355313}, {-88.396203, 30.355276}, {-88.397791, 
      30.355248999999997`}, {-88.397114, 30.348855}}, {{-88.383507, 
      30.378828}, {-88.381951, 30.380226999999998`}, {-88.38304099999999, 
      30.381580999999997`}, {-88.384671, 30.383383}, {-88.38628, 
      30.384269999999997`}, {-88.388398, 30.384234}, {-88.389415, 
      30.382386}, {-88.38937299999999, 30.380557}, {-88.38723399999999, 
      30.379679}, {-88.38509499999999, 30.378801}, {-88.383507, 
      30.378828}}, {{-88.388145, 30.373258}, {-88.387129, 
      30.375106}, {-88.38767899999999, 30.376011}, {-88.389299, 
      30.377356}, {-88.391437, 30.378234}, {-88.393036, 
      30.378663999999997`}, {-88.39408399999999, 30.378189}, {-88.394582, 
      30.376807999999997`}, {-88.394021, 30.375445}, {-88.392941, 
      30.374547999999997`}, {-88.39132099999999, 
      30.373203999999998`}, {-88.38972299999999, 30.372774}, {-88.388145, 
      30.373258}}, {{-88.024737, 30.678901}, {-88.02583399999999, 
      30.680714}, {-88.028465, 30.679305999999997`}, {-88.029468, 
      30.676091999999997`}, {-88.02993099999999, 
      30.672428}, {-88.02935699999999, 30.67015}, {-88.028774, 
      30.667415}, {-88.028132, 30.661481}, {-88.02544999999999, 
      30.660145999999997`}, {-88.020686, 30.661126}, {-88.01705199999999, 
      30.665747999999997`}, {-88.017112, 30.668948}, {-88.019305, 
      30.672575}, {-88.022021, 30.675738}, {-88.024737, 
      30.678901}}, {{-88.37505499999999, 30.217446}, {-88.377645, 
      30.215114}, {-88.37654599999999, 30.213302}, {-88.375458, 
      30.211947}, {-88.373842, 30.210601999999998`}, {-88.37017499999999, 
      30.212038}, {-88.367565, 30.213455}, {-88.367627, 
      30.216199999999997`}, {-88.37084899999999, 
      30.218432999999997`}, {-88.37505499999999, 30.217446}}, {{-88.216466, 
      30.317508999999998`}, {-88.21588899999999, 30.31523}, {-88.214822, 
      30.31479}, {-88.212706, 30.314822999999997`}, {-88.21113799999999, 
      30.315762}, {-88.211176, 30.317591999999998`}, {-88.210695, 
      30.319886999999998`}, {-88.21231, 30.321233999999997`}, {-88.213916, 
      30.322124}, {-88.214975, 30.322108}, {-88.216543, 
      30.321168}, {-88.217033, 30.319329999999997`}, {-88.216466, 
      30.317508999999998`}}, {{-88.227691, 30.322823999999997`}, {-88.229787, 
      30.321876}, {-88.230807, 30.320028999999998`}, {-88.231297, 
      30.318192}, {-88.229143, 30.316395}, {-88.223843, 
      30.316021}, {-88.221256, 30.318807}, {-88.22183299999999, 
      30.321085999999998`}, {-88.223449, 30.322433}, {-88.226103, 
      30.322848999999998`}, {-88.227691, 30.322823999999997`}}, {{-88.297006, 
      30.370666999999997`}, {-88.295987, 30.372514}, {-88.29707599999999, 
      30.373869}, {-88.297626, 30.374775}, {-88.298684, 
      30.374758}, {-88.300792, 30.374266}, {-88.30183, 
      30.373334}, {-88.302859, 30.371944}, {-88.303888, 
      30.370555}, {-88.30331799999999, 30.368734}, {-88.30224899999999, 
      30.368294}, {-88.30013199999999, 30.368329}, {-88.298554, 
      30.368812}, {-88.297006, 30.370666999999997`}}, {{-88.25838399999999, 
      30.322795}, {-88.255759, 30.323752}, {-88.25421999999999, 
      30.326064}, {-88.253221, 30.328825}, {-88.25277, 
      30.332493}, {-88.252848, 30.336152}, {-88.253975, 
      30.339336}, {-88.255111, 30.342978}, {-88.255709, 
      30.346172}, {-88.25682599999999, 30.348899}, {-88.256884, 
      30.351643}, {-88.25694299999999, 30.354387}, {-88.256492, 
      30.358054}, {-88.25656099999999, 30.361255999999997`}, {-88.257678, 
      30.363982999999998`}, {-88.25879499999999, 
      30.366709999999998`}, {-88.25989299999999, 30.368523}, {-88.26203, 
      30.369403}, {-88.263599, 30.368463}, {-88.264089, 
      30.366625}, {-88.264579, 30.364787999999997`}, {-88.26398999999999, 
      30.362052}, {-88.263882, 30.357021}, {-88.264333, 
      30.353354}, {-88.26482299999999, 30.351516}, {-88.265323, 
      30.350134999999998`}, {-88.265812, 30.348297}, {-88.265773, 
      30.346467999999998`}, {-88.264136, 
      30.344206999999997`}, {-88.26254899999999, 
      30.344231999999998`}, {-88.261451, 30.342419}, {-88.261422, 
      30.341047}, {-88.261922, 30.339667}, {-88.26190199999999, 
      30.338752}, {-88.261343, 30.337387999999997`}, {-88.260795, 
      30.336482}, {-88.261304, 30.335559}, {-88.262343, 
      30.334626999999998`}, {-88.263362, 30.332780999999997`}, {-88.263851, 
      30.330942999999998`}, {-88.26379299999999, 
      30.328197999999997`}, {-88.26321399999999, 30.32592}, {-88.261578, 
      30.323658}, {-88.25838399999999, 30.322795}}, {{-88.060574, 
      30.189418}, {-88.056348, 30.189477999999998`}, {-88.054244, 
      30.189966}, {-88.05217499999999, 30.192283}, {-88.051698, 
      30.195035999999998`}, {-88.052278, 30.197774}, {-88.05442599999999, 
      30.199574}, {-88.057076, 30.199994}, {-88.059163, 
      30.198591999999998`}, {-88.060176, 30.196289}, {-88.060678, 
      30.194909}, {-88.06119799999999, 30.194443999999997`}, {-88.063311, 
      30.194414}, {-88.064887, 30.193932999999998`}, {-88.06537999999999, 
      30.192096}, {-88.064298, 30.190738}, {-88.06322399999999, 
      30.189837999999998`}, {-88.060574, 30.189418}}, {{-88.102818, 
      30.215353}, {-88.103893, 30.216253}, {-88.10602399999999, 
      30.217136999999997`}, {-88.107627, 30.218028999999998`}, {-88.108702, 
      30.218928}, {-88.109248, 30.219835}, {-88.109275, 
      30.221207999999997`}, {-88.110349, 30.222106999999998`}, {-88.11249, 
      30.223449}, {-88.113045, 30.224814}, {-88.11361, 
      30.226636}, {-88.114684, 30.227535}, {-88.11627899999999, 
      30.227968999999998`}, {-88.117846, 30.227031}, {-88.118365, 
      30.226566}, {-88.118867, 30.225185}, {-88.118302, 
      30.223363}, {-88.11721, 30.221549}, {-88.115589, 
      30.219742}, {-88.112346, 30.216129}, {-88.109123, 
      30.21343}, {-88.106982, 30.212089}, {-88.10538, 30.211197}, {-88.103275,
       30.211685}, {-88.102227, 30.212158}, {-88.101726, 
      30.213538}, {-88.102818, 30.215353}}, CompressedData["
1:eJxd1GlQU2cUBuCISAAF2RkqCsYo0UgER1BAYtjEgOz1UspaFsvisAyL0oKQ
iCXaIchiSdUoFkoFrQKCWoJyoRUSARHowFB0hKIIaJAlbFZL3/ztj0zmmeSc
e75zzv22Rib5x6hQKJRQfJTfK4u3ncLVCPKB3cUNFEc2x4h1s9YE/tFi0EB6
kM1pLqywq19HkB7sDGMGfn8lKW2Khqc2J+Z/B+u7vqCaw5qHt6ersNmcL0aY
TQuqBKnhG9A5AKcU9ESvwh19+awbh9ic/OV8S0f8n/l8rqiUw+bkXVlaTYHP
lf2S6ubE5kjkzqliuHjMezICbrU5qWiBDwypTXNgkeD+U6WR/QMNHpU7qUvh
sIXcTCny6Y7Z3JmCBTN7+O1wRIbPFiOcp/jg4NIoLFqIZFjAD6uo636GJ++5
sg7A7iYpa2Lh7l91iCj4jd9sjjusuhosE8KzYkTCIanuq53wS8F00CAcz7/x
D4VKkDT/flYV6tkyvHdkN/xNS69wkzPqW6dbHQdnFmks28BBezvmbsMFoqE3
1rDXRk2PXviW4NLEPOKjHRs/TMHW7K6we7C12kDKR/imLIDohxuOcaPN1Amy
fCTSTQvxnWcUBnYw/YdSSY+yH3XXHvvDHi4FzsWw55hxGBde6M8Z+Ih6YwJu
z7Bg4zn1xEqYInT8Vmnps7ozHrBR8wTzCCzPrtHUgukRaZmpcG9XSYImfDYs
R+8a3LIj4U8XuGKCV9gK/0EPkW6D31U+2i2HdfNPmIfCffsYl6gaBDkTOyZo
hB/lewod4KS54LR6Zb70sRdFcFcW9VAKTBPMJ6toop/DK6fjlfPbmhrjC7+3
Ue2IgcVaK1+rrSfI0Lbr90/B+9xy+yXwMatd1fpwg2y0xHsDQUYXF92txb5t
i+2iT8F1Xrs+S4DNaTbySC2CvLBUc1EDjuhkDg7DiiqaYTv2lendaHRcmyDX
y68c58G11fM3luH6yAf2FJi39ssm/kaCdK1wEIix/9Rw0VFDHYKs2SmzN4Wb
WB9HsuD9J4JLh/D+FPpInw7DCVHv8spg6wZ7OxddgtQXeb+1hV+dudpdA1PG
TPYpHNgch6Sou9v0CHL0bnpyLawwrDT5Hj6ywm30gSURyd2b9Qmytqqe8c6e
zVGzxIRg/RyD9HHY7r7G0hM4PTCjdQSW5749b2KA8+uH8QMQT++z/dcVLjtH
q0yE+e1HfwqDh33al63gnXcuPguFt246YnwZ8eciTEPsYVJmm0yFLyjiDD8h
//5KP16JHebh9v5zEr5adr4gE7YsGT3Fhu0DS/X48Ots0+4i1P+4wyL6DUwV
rWifxnmTzX6zmUS+8+1/vRxCf4Tj0id78PxT2eO3fOAHhc8vpcEq2TSfYvS7
vE230h/92q56c+o15mHFCz45D/e99Bx1gn2TDncHov9ln5r6xZgnK7FiTTOc
55I0O4P5s0zVZcr7SXR91lUHLvGmi+Jhjx6FXhT2x11FyzYdfqblNTSJfdvv
OyLOgm0dGQw3+BG3vzwWNmvOiPsd+7oc754ihB+2Gu8IgDeYZzF64QRGo3Ev
9n/YUrZGAjO+qpKHwxvrWtu4sLZ74OQ03meG81TGIupLulytUwj7eaYy8+Co
7eNBXHiadtSPBfNC/pauhZPVj8Uv4rw9VxZ2duD+IVy9FCvw/+/v/wAF5n0U

      "], {{-87.49024899999999, 30.298544}, {-87.493946, 
      30.298053}, {-87.49659, 30.298029}, {-87.499775, 
      30.298914999999997`}, {-87.502425, 30.299348}, {-87.504012, 
      30.299333999999998`}, {-87.50612199999999, 
      30.298856999999998`}, {-87.50769799999999, 
      30.297926999999998`}, {-87.50873299999999, 
      30.296087999999997`}, {-87.50871099999999, 
      30.294258}, {-87.51080999999999, 30.292866}, {-87.512391, 
      30.292393999999998`}, {-87.516082, 30.291445}, {-87.518192, 
      30.290968}, {-87.521354, 30.290024}, {-87.52398699999999, 
      30.289084}, {-87.526097, 30.288607}, {-87.529258, 
      30.287661999999997`}, {-87.531356, 30.28627}, {-87.532386, 
      30.283973}, {-87.531311, 30.28261}, {-87.528138, 
      30.282639999999997`}, {-87.524987, 30.284499}, {-87.518664, 
      30.286388}, {-87.51234, 30.288276999999997`}, {-87.50811999999999, 
      30.289230999999997`}, {-87.504429, 30.29018}, {-87.500198, 
      30.290218}, {-87.49439199999999, 30.291186}, {-87.489125, 
      30.293063999999998`}, {-87.485968, 30.294463999999998`}, {-87.483334, 
      30.295403}, {-87.481224, 30.29588}, {-87.478585, 
      30.296360999999997`}, {-87.47488799999999, 30.296851}, {-87.471719, 
      30.297337}, {-87.46907999999999, 30.297817}, {-87.46644599999999, 
      30.298755999999997`}, {-87.462749, 30.299246}, {-87.46011999999999, 
      30.300641}, {-87.45907299999999, 30.301565}, {-87.459623, 
      30.30339}, {-87.460168, 30.304758}, {-87.461761, 
      30.305201999999998`}, {-87.462813, 30.304734999999997`}, {-87.465447, 
      30.303797}, {-87.468087, 30.303316}, {-87.472313, 
      30.302820999999998`}, {-87.474958, 30.302798}, {-87.47971299999999, 
      30.302298}, {-87.482871, 30.300897}, {-87.48549899999999, 
      30.299501}, {-87.49024899999999, 30.298544}}, {{-85.102772, 
      31.985937999999997`}, {-85.09953999999999, 31.985442}, {-85.097976, 
      31.982231}, {-85.098579, 31.978589999999997`}, {-85.09648299999999, 
      31.974915999999997`}, {-85.0938, 31.973969999999998`}, {-85.091616, 
      31.975310999999998`}, {-85.09157599999999, 
      31.977591}, {-85.09367999999999, 31.980808999999997`}, {-85.095252, 
      31.983565}, {-85.096276, 31.98677}, {-85.094584, 
      31.990852999999998`}, {-85.09186, 
      31.992186999999998`}, {-85.09026399999999, 
      31.990799}, {-85.08923999999999, 31.987593999999998`}, {-85.088748, 
      31.984851}, {-85.08770799999999, 
      31.982557999999997`}, {-85.08668399999999, 31.979353}, {-85.085652, 
      31.976604}, {-85.083525, 31.974753}, {-85.081897, 
      31.975189}, {-85.081317, 31.977462}, {-85.08126, 
      31.980653}, {-85.080624, 31.986117}, {-85.07943, 
      31.992486999999997`}, {-85.078818, 31.996582999999998`}, {-85.078229, 
      31.999312}, {-85.076528, 32.00385}, {-85.074302, 32.00747}, {-85.071553,
       32.010171}, {-85.06934299999999, 32.012879}, {-85.067126, 
      32.016042999999996`}, {-85.06544799999999, 32.019213}, {-85.065947, 
      32.021499999999996`}, {-85.065907, 32.023779}, {-85.06639799999999, 
      32.026520999999995`}, {-85.06688899999999, 32.029263}, {-85.067897, 
      32.03338}, {-85.069851, 32.014708999999996`}, {-85.09741, 
      32.0146}, {-85.102772, 31.985937999999997`}}, {{-85.208815, 
      32.980920999999995`}, {-85.214327, 33.011939999999996`}, {-85.219731, 
      33.016098}, {-85.223501, 33.019782}, {-85.227797, 
      33.024837}, {-85.23371399999999, 33.031276}, {-85.238098, 
      33.03087}, {-85.240878, 33.028169}, {-85.24149, 33.024079}, {-85.23774, 
      33.01903}, {-85.23233499999999, 33.014873}, {-85.23129899999999, 
      33.011219}, {-85.233509, 33.009878}, {-85.23842499999999, 
      33.010388}, {-85.243895, 33.010448}, {-85.24935099999999, 
      33.011419}, {-85.255376, 33.011029}, {-85.257074, 
      33.007405999999996`}, {-85.254936, 33.004196}, {-85.247314, 
      33.001836}, {-85.24022599999999, 33.000392999999995`}, {-85.235843, 
      33.000799}, {-85.23092799999999, 33.00029}, {-85.226567, 
      32.999331}, {-85.221127, 32.997448999999996`}, {-85.21844399999999, 
      32.994232}, {-85.216382, 32.986469}, {-85.213167, 
      32.982336}, {-85.208815, 32.980920999999995`}}, {{-85.22488899999999, 
      33.069416}, {-85.229976, 33.093596999999995`}, {-85.23432, 
      33.095922}, {-85.244025, 33.105587}, {-85.247311, 
      33.105623}, {-85.247895, 33.103353999999996`}, {-85.24469599999999, 
      33.097857}, {-85.238226, 33.091412999999996`}, {-85.237189, 
      33.087759999999996`}, {-85.23889, 33.084137}, {-85.23791899999999, 
      33.076388}, {-85.23467, 33.074076999999996`}, {-85.22488899999999, 
      33.069416}}, CompressedData["
1:eJxd03lMknEYB3AyY93lkWxZmeuStCytZmLxvktFjFBbb5kdVkPUZeXAmals
Hpm5MsssS0tjXkvKWJZ5JENzTkzQsJaJdlKmZBeOxKP6svVXf7z77bPndzy/
5/m9zkdO7IywotFobHyWcbtKZBv4mFK+S7Sv4nBJ4v3etPMp8NKZQl5TAEms
3cPepIId0/nTF8MHXaUNyxsp5Ub6zfne8OH+hJMCeE9oLPsthyQuXxCtK4TZ
uxaur4YprsDJEr/T4uMaDbeaC4PPYj/tk64hvT9JpIZuEgfA+1khtraI8zxE
DqYGSklTxX0eQVxk0kTJEO80VmQP+ZLE+D6r70HYz4aR4j8IU/3LCmWwleBz
D+lHEt7xwVkGOMlum8gDLphqLR6B0xUjpgHMD2rT6Hrgizr34jtwlcsKa8t6
mnhNWArMf+gglMLSW/Z3+7aRRGRy+P5KePUbT1spPJ7Dy+TDeTz+8Gy4UuK9
xBOO9yxxmgPnZ2vMTHigXO1lsau7uXgC+Z85z7l9Gp49+H1+K2xs5R5+DXfz
1R/pcOOumA4Dztfb9AW8wv2r1dmDM5D/bklVzRE4Q01jCOBeWU6mAv6i4/qO
wiMbn0aUwKPNgspDqJdk93XmXdgtPP8dG/WskLEcdPChT6zRLNj5U27lMBzw
SzzzJ3y//oVYC6eygit80E/RUe2xLFi3dsPLaNhjUWckAdOLkublwwwXppwG
twzw5X/g37WTP1X1lLLfUKpww/th027vuAE/F7TqAmETeXWaHTwkb17jBJ/K
jVPr6ygla2Hm2AGs942Rx+bCc904bQTsZZRtJuCBc42McJg7t+eFvpZSvgnK
zj8OFyWWNh2Dc8YMCxxguSjq0vAjSnnpgaOkA/dJPjXF9AzmNWf4pMFtgwZz
AVyg4dM5MP1xhzwEZraX/ZgFW9pqAxti4658Rf185n3V9NbgffS2qCbhNLF/
ngmeKPOT5HL+nY/5JDOsjoHzu66KmVXIZyxRIayDVxlzFFzk39IepTfCCQmd
qR/hvCjVh2jcP2jrlpoI1ONHjfZoNVzgTNnfg+26M0InYTPP1NkNCxXpxV6B
JPHK0O/0DXaXpj2ZBaP5V1ag/sM3hKnxmN/OeHAxBS5f2eSotfTDr+saF+/p
vtu10RL4///7L/Mj6zM=
      "], {{-85.721621, 31.385589999999997`}, {-85.718401, 
      31.386024}, {-85.71570299999999, 31.387831}, {-85.714609, 
      31.390106}, {-85.71296, 31.394202}, {-85.71239299999999, 
      31.397394}, {-85.711835, 31.399672}, {-85.7102, 31.402399}, {-85.708569,
       31.40467}, {-85.70747899999999, 31.406488}, {-85.706379, 
      31.409219}, {-85.705276, 31.412406999999998`}, {-85.70418099999999, 
      31.414680999999998`}, {-85.70254899999999, 
      31.416952}, {-85.70250899999999, 
      31.421059999999997`}, {-85.70248199999999, 
      31.423797999999998`}, {-85.703518, 31.427456999999997`}, {-85.706182, 
      31.429302}, {-85.709414, 31.427956}, {-85.71157699999999, 
      31.426144999999998`}, {-85.712672, 31.423871}, {-85.71322599999999, 
      31.422048999999998`}, {-85.71378899999999, 31.419314}, {-85.71542, 
      31.417043}, {-85.71705, 31.414772}, {-85.720294, 31.412056}, {-85.72192,
       31.410242}, {-85.72409999999999, 31.406605}, {-85.725203, 
      31.403416999999997`}, {-85.72684699999999, 31.399777}, {-85.727954, 
      31.396133}, {-85.72798399999999, 31.392937999999997`}, {-85.726398, 
      31.390643999999998`}, {-85.724289, 31.386978}, {-85.721621, 
      31.385589999999997`}}, {{-86.784199, 32.324273}, {-86.781481, 
      32.322457}, {-86.77284399999999, 32.334326}, {-86.769594, 
      32.335701}, {-86.767416, 32.333428}, {-86.764156, 32.331613}, {-86.7658,
       32.336621}, {-86.76852699999999, 32.341172}, {-86.77400999999999, 
      32.358019}, {-86.772387, 32.35939}, {-86.77841, 
      32.374868}, {-86.77789399999999, 32.382615}, {-86.778449, 
      32.386258999999995`}, {-86.774131, 32.393105}, {-86.763803, 
      32.389027999999996`}, {-86.752397, 32.386776}, {-86.737211, 
      32.39091}, {-86.726383, 32.400956}, {-86.72748, 32.404599}, {-86.737222,
       32.394555}, {-86.746436, 32.389979}, {-86.757291, 
      32.389499}, {-86.774681, 32.395381}, {-86.78118599999999, 
      32.392632}, {-86.782192, 32.370301999999995`}, {-86.78056, 
      32.368939}, {-86.772866, 32.340706}, {-86.784199, 32.324273}}}]}, 
   {RGBColor[0.137438, 0.146578, 0.157778], 
    LineBox[{{{-87.425843, 34.799956}, {-87.393954, 34.801566}, {-87.382781, 
      34.803467999999995`}}, {{-87.260305, 34.75891}, {-87.249707, 
      34.762158}, {-87.22958799999999, 34.764556}, {-87.212761, 
      34.760118}, {-87.197566, 34.750217}, {-87.184688, 
      34.748931}, {-87.18019699999999, 34.74714}, {-87.15267, 
      34.733216999999996`}, {-87.13523599999999, 
      34.721503999999996`}, {-87.128963, 34.70655}, {-87.12500899999999, 
      34.701575}, {-87.10476299999999, 34.686237999999996`}}, {{-86.310893, 
      34.991913}, {-86.309221, 34.98737}, {-86.309799, 34.98056}, {-86.312615,
       34.976023999999995`}, {-86.30700999999999, 
      34.973743999999996`}, {-86.296922, 34.970095}, {-86.290205, 
      34.964634}, {-86.28349899999999, 34.955541}, {-86.27453, 
      34.953708}, {-86.270618, 34.949159}, {-86.262216, 
      34.94551}, {-86.258316, 34.937329}, {-86.258349, 
      34.926885}, {-86.266212, 34.92236}, {-86.27460599999999, 
      34.927825}, {-86.281864, 34.938736999999996`}, {-86.28746799999999, 
      34.94011}, {-86.294185, 34.944662}, {-86.298114, 
      34.943307}, {-86.312152, 34.936065}, {-86.323923, 
      34.937899}, {-86.327854, 34.935181}, {-86.325625, 
      34.929275}, {-86.31555499999999, 34.919723}, {-86.312771, 
      34.911999}, {-86.31671, 34.905648}, {-86.340839, 
      34.892969}, {-86.340295, 34.884794}, {-86.347594, 
      34.877538}, {-86.350404, 34.873455}, {-86.34593699999999, 
      34.865729}, {-86.346513, 34.85801}, {-86.335892, 
      34.847550999999996`}, {-86.336474, 34.837106999999996`}, {-86.332003, 
      34.833014}, {-86.329771, 34.829377}, {-86.33314, 
      34.824841}, {-86.341554, 34.817586}, {-86.346054, 
      34.807147}, {-86.343267, 34.80124}, {-86.341599, 
      34.795788}, {-86.33712799999999, 34.792603}, {-86.335454, 
      34.790329}, {-86.341627, 34.782163}, {-86.342762, 
      34.774443999999995`}, {-86.33720199999999, 34.757633}, {-86.341687, 
      34.752643}, {-86.34505999999999, 34.744472}, {-86.357942, 
      34.735405}, {-86.35800499999999, 34.701342}, {-86.359248, 
      34.632757999999995`}, {-86.32578699999999, 34.610001}, {-86.331375, 
      34.607738}, {-86.330828, 34.602741}, {-86.32804, 
      34.600919999999995`}, {-86.326368, 34.600009}}, {{-86.550212, 
      34.545615999999995`}, {-86.550207, 34.538348}, {-86.547417, 
      34.536077999999996`}, {-86.535133, 34.512913999999995`}, {-86.53513, 
      34.506099}, {-86.533456, 34.502919999999996`}, {-86.530109, 
      34.500195}, {-86.5, 34.482481}, {-86.473801, 
      34.479752999999995`}, {-86.4699, 34.476572}, {-86.467113, 
      34.476571}, {-86.450942, 34.484743}, {-86.434776, 
      34.483826}, {-86.425861, 34.479278}, {-86.411908, 
      34.49426}, {-86.405215, 34.49698}, {-86.395179, 
      34.496518}, {-86.38959299999999, 34.504235}, {-86.391258, 
      34.509234}, {-86.391252, 34.513777}, {-86.39347599999999, 
      34.518775999999995`}, {-86.391243, 34.520137}, {-86.38734199999999, 
      34.518316}, {-86.38454899999999, 34.521039}, {-86.381203, 
      34.521035999999995`}, {-86.369501, 34.514663}, {-86.363919, 
      34.517382999999995`}, {-86.35945199999999, 
      34.520557}, {-86.35554499999999, 34.521915}, {-86.35275899999999, 
      34.520548999999995`}, {-86.334378, 34.509167}, {-86.334929, 
      34.512347999999996`}, {-86.32934999999999, 34.513249}, {-86.333244, 
      34.517797}, {-86.328223, 34.518698}, {-86.323737, 
      34.529593999999996`}, {-86.311442, 
      34.539114999999995`}, {-86.31143399999999, 
      34.542294999999996`}, {-86.313093, 34.548203}, {-86.30691999999999, 
      34.562729}, {-86.30914899999999, 34.564096}, {-86.313057, 
      34.563193999999996`}, {-86.327004, 34.565031999999995`}, {-86.330349, 
      34.5664}, {-86.331462, 34.568219}, {-86.332015, 
      34.570491}, {-86.33089199999999, 
      34.573668999999995`}, {-86.32754299999999, 34.573664}, {-86.323072, 
      34.576383}, {-86.31805, 34.575921}, {-86.306322, 
      34.578628}, {-86.29961999999999, 34.580433}, {-86.30184799999999, 
      34.582254}, {-86.30686999999999, 34.582716999999995`}, {-86.306297, 
      34.588620999999996`}, {-86.302938, 34.592248999999995`}, {-86.305166, 
      34.594524}, {-86.311303, 34.595897}, {-86.316322, 
      34.598175999999995`}, {-86.32413799999999, 34.598188}, {-86.326368, 
      34.600009}}, {{-86.14352799999999, 34.538269}, {-86.143517, 
      34.54054}, {-86.149625, 34.546918}, {-86.148977, 
      34.566904}, {-86.14827199999999, 34.599154}, {-86.31576, 
      34.599992}, {-86.326368, 34.600009}}, {{-85.57463, 
      34.480627}, {-85.57682199999999, 34.483824999999996`}, {-85.570663, 
      34.486047}, {-85.568389, 34.489664}, {-85.55945899999999, 
      34.490501}, {-85.55776399999999, 34.492304}, {-85.558758, 
      34.502307}, {-85.55483799999999, 34.503637999999995`}, {-85.55094, 
      34.503152}, {-85.547634, 34.499945}, {-85.54484599999999, 
      34.499922999999995`}, {-85.540865, 34.50625}, {-85.53749599999999, 
      34.50804}, {-85.53636399999999, 34.509392999999996`}, {-85.535232, 
      34.510746999999995`}, {-85.53464, 34.513467999999996`}, {-85.532393, 
      34.514812}, {-85.527345, 34.517042}, {-85.52288399999999, 
      34.517004}, {-85.525626, 34.520662}, {-85.52503999999999, 
      34.522928}, {-85.52109, 34.52653}, {-85.513305, 
      34.524647}}, {{-86.057414, 34.476189999999995`}, {-86.035123, 
      34.475194}, {-86.027869, 34.476528}, {-86.020594, 
      34.481041999999995`}, {-86.00275599999999, 34.480967}, {-85.991569, 
      34.486824999999996`}, {-85.98543099999999, 
      34.487705999999996`}, {-85.983734, 34.491333}, {-85.977041, 
      34.491758}, {-85.97143799999999, 34.495821}, {-85.961373, 
      34.499863999999995`}, {-85.956859, 34.507566}, {-85.938328, 
      34.525196}, {-85.92319499999999, 34.535115999999995`}, {-85.919834, 
      34.536916999999995`}, {-85.910853, 34.54414}, {-85.881698, 
      34.56216}, {-85.86542999999999, 34.572521}, {-85.839052, 
      34.589636999999996`}, {-85.824451, 34.599547}, {-85.819965, 
      34.601791999999996`}, {-85.814908, 34.605396999999996`}, {-85.812662, 
      34.606746}, {-85.785699, 34.6243}, {-85.761961, 
      34.653678}, {-85.73535799999999, 34.688482}, {-85.73308999999999, 
      34.691646}, {-85.72175999999999, 34.706559999999996`}, {-85.718369, 
      34.710170999999995`}, {-85.69341399999999, 34.744067}, {-85.672704, 
      34.745284999999996`}, {-85.659156, 34.756543}, {-85.64831699999999, 
      34.77554}, {-85.636358, 34.794073}, {-85.634068, 
      34.798598}, {-85.63403199999999, 34.801777}, {-85.633895, 
      34.814038}, {-85.626992, 34.830335999999996`}, {-85.603833, 
      34.847418999999995`}, {-85.603791, 
      34.851051999999996`}, {-85.60208399999999, 
      34.853308999999996`}, {-85.597032, 
      34.854178999999995`}, {-85.58349199999999, 34.862248}}, {{-86.783383, 
      34.992632}, {-86.787621, 34.625220999999996`}, {-86.78759699999999, 
      34.618862}, {-86.788144, 34.615680999999995`}, {-86.78808599999999, 
      34.600237}, {-86.788634, 34.59751}, {-86.789163, 
      34.589786}, {-86.789096, 34.571616}}, {{-86.69593499999999, 
      34.588163}, {-86.702079, 34.589515}, {-86.70765999999999, 
      34.589051}, {-86.715468, 34.586766}, {-86.73217799999999, 
      34.574469}, {-86.740526, 34.56673}, {-86.74609199999999, 
      34.562174999999996`}, {-86.756666, 34.553522}, {-86.77506699999999, 
      34.5503}, {-86.789575, 34.550719}}, {{-86.789575, 
      34.550719}, {-86.789096, 34.571616}}, {{-87.52954799999999, 
      34.559258}, {-87.52909799999999, 34.567439}, {-87.60837099999999, 
      34.568985}, {-87.95173799999999, 34.575213999999995`}, {-88.140549, 
      34.5818}}, {{-87.52954799999999, 34.559258}, {-87.529354, 
      34.544722}, {-87.529707, 34.529272999999996`}, {-87.52998, 
      34.507918}, {-87.52932, 34.5002}, {-87.530006, 34.467937}, {-87.530782, 
      34.442487}}, {{-87.109915, 34.347763}, {-87.131061, 
      34.34765}, {-87.131202, 34.364914999999996`}, {-87.120066, 
      34.364520999999996`}, {-87.12019699999999, 
      34.380877999999996`}, {-87.127995, 34.38129}, {-87.128039, 
      34.386742}, {-87.14307099999999, 34.38666}, {-87.14316199999999, 
      34.397563999999996`}, {-87.19161, 34.397740999999996`}, {-87.191655, 
      34.402739}, {-87.216161, 34.403045}, {-87.216127, 
      34.399409999999996`}, {-87.303023, 34.40157}, {-87.303872, 
      34.429733999999996`}, {-87.32782, 34.429111999999996`}, {-87.32797, 
      34.443194999999996`}, {-87.35694699999999, 
      34.443439999999995`}, {-87.357359, 34.430261}, {-87.363486, 
      34.430216}, {-87.363421, 34.42431}, {-87.444193, 
      34.424138}, {-87.444054, 34.41278}, {-87.48472699999999, 
      34.413806}, {-87.485411, 34.423795999999996`}, {-87.499342, 
      34.424132}, {-87.500022, 34.433668}, {-87.521203, 
      34.434393}, {-87.521305, 34.442116}, {-87.530782, 
      34.442487}}, {{-86.550212, 34.545615999999995`}, {-86.553, 
      34.543797999999995`}, {-86.555217, 34.522445999999995`}, {-86.561883, 
      34.488825}, {-86.581274, 34.372959}, {-86.58175899999999, 
      34.304801999999995`}}, {{-85.843477, 34.199821}, {-85.843657, 
      34.244358}, {-85.830342, 34.241555999999996`}, {-85.825349, 
      34.240618}, {-85.817585, 34.238755}, {-85.810909, 
      34.239624}, {-85.809242, 34.239615}, {-85.808512, 
      34.259150999999996`}, {-85.777941, 34.258964999999996`}, {-85.77181, 
      34.260745}, {-85.678694, 34.340101}}, {{-86.45275199999999, 
      34.259834999999995`}, {-86.45219399999999, 34.26347}, {-86.456085, 
      34.263472}, {-86.451075, 34.274376}, {-86.45885899999999, 
      34.274833}, {-86.459413, 34.278469}, {-86.459409, 
      34.285739}, {-86.459407, 34.289373999999995`}, {-86.47664499999999, 
      34.289379}, {-86.47719699999999, 34.302557}, {-86.58175899999999, 
      34.304801999999995`}}, {{-86.58175899999999, 
      34.304801999999995`}, {-86.640715, 34.305655}, {-86.69077399999999, 
      34.306492}, {-86.69967299999999, 34.306477}, {-86.738608, 
      34.306858}, {-86.744726, 34.306846}, {-86.807581, 
      34.30806}, {-86.814256, 34.308042}, {-86.999498, 
      34.311938}, {-87.095175, 34.312396}, {-87.110207, 
      34.314136}}, {{-87.110207, 34.314136}, {-87.109537, 
      34.299599}}, {{-85.843477, 34.199821}, {-86.013442, 
      34.199749}, {-86.025106, 34.199797}, {-86.045101, 
      34.199877}, {-86.06898199999999, 
      34.200421999999996`}, {-86.09286499999999, 34.200509}, {-86.10175, 
      34.200994}, {-86.105638, 34.201007}}, {{-86.057414, 
      34.476189999999995`}, {-86.110055, 34.427765}, {-86.109766, 
      34.374606}, {-86.109816, 34.36461}, {-86.10833199999999, 
      34.327799999999996`}, {-86.10834799999999, 34.324619}, {-86.107056, 
      34.250091999999995`}, {-86.106067, 34.226003}, {-86.10609, 
      34.221458999999996`}, {-86.105638, 34.201007}}, {{-87.273603, 
      34.299532}, {-87.366495, 34.300695}, {-87.374281, 
      34.300636}, {-87.38151599999999, 
      34.301035999999996`}}, {{-87.38151599999999, 
      34.301035999999996`}, {-87.408221, 34.301739999999995`}, {-87.433819, 
      34.3029}, {-87.438824, 34.302859999999995`}, {-87.468867, 
      34.303522}, {-87.47498999999999, 34.303926}}, {{-87.52951, 
      34.304819}, {-87.530782, 34.442487}}, {{-87.546751, 
      34.304665}, {-87.52951, 34.304819}}, {{-87.546751, 
      34.304665}, {-87.62576899999999, 34.307108}, {-87.631331, 
      34.307054}, {-87.634667, 34.307021999999996`}}, {{-86.45275199999999, 
      34.259834999999995`}, {-86.44385899999999, 34.259377}, {-86.444977, 
      34.249834}, {-86.40612999999999, 34.201639}, {-86.32521899999999, 
      34.120194}, {-86.32134599999999, 34.115187999999996`}, {-86.313031, 
      34.111993999999996`}, {-86.310825, 34.106536}, {-86.30528799999999, 
      34.102436}, {-86.303077, 34.099250999999995`}}, {{-85.843477, 
      34.199821}, {-85.841871, 34.127094}, {-85.84145099999999, 
      34.111184}, {-85.833141, 34.109773}, {-85.811919, 
      34.125557}, {-85.79579799999999, 34.128642}, {-85.79083299999999, 
      34.12543}, {-85.790307, 34.122245}, {-85.79707599999999, 
      34.110015}, {-85.797162, 34.10047}, {-85.750294, 
      34.013358}, {-85.737223, 33.990089}, {-85.738539, 
      33.968731999999996`}}, {{-85.53009, 33.941714999999995`}, {-85.495204, 
      33.942326}, {-85.49501099999999, 33.957327}, {-85.425242, 
      33.957155}, {-85.42574599999999, 33.960797}, {-85.408028, 
      33.960631}, {-85.407423, 33.964262}, {-85.398563, 
      33.964178}}, {{-85.738539, 33.968731999999996`}, {-85.529355, 
      33.956255999999996`}, {-85.53009, 33.941714999999995`}}, {{-85.53009, 
      33.941714999999995`}, {-85.53166499999999, 33.903993}}, {{-87.546751, 
      34.304665}, {-87.546224, 34.265589}, {-87.477824, 
      34.263912}, {-87.48059099999999, 34.218897}, {-87.427793, 
      34.217513}, {-87.428439, 34.132064}, {-87.49838199999999, 
      34.133300999999996`}, {-87.497806, 34.045125}, {-87.429052, 
      34.043879}, {-87.428483, 33.996153}}, {{-87.634667, 
      34.307021999999996`}, {-87.63486499999999, 34.28248}, {-87.634666, 
      34.268848999999996`}, {-87.63453299999999, 34.259761}, {-87.634208, 
      34.237496}, {-87.63416199999999, 
      34.234314999999995`}, {-87.63412799999999, 
      34.232043}, {-87.63405499999999, 34.227045}, {-87.634016, 
      34.224318}, {-87.633949, 34.219774}, {-87.634299, 
      34.205681999999996`}, {-87.634596, 34.187954}, {-87.635598, 
      34.142494}, {-87.636483, 34.127030999999995`}, {-87.636397, 
      34.121123}, {-87.63658, 34.095667}, {-87.636454, 
      34.087032}, {-87.63632799999999, 34.078396999999995`}, {-87.635672, 
      34.033401}, {-87.635775, 34.002488}}, {{-87.150904, 
      33.993044999999995`}, {-87.14589199999999, 33.989891}, {-87.138037, 
      33.977661}, {-87.13852, 33.969021}, {-87.136286, 
      33.96676}, {-87.13405999999999, 33.965408}, {-87.125754, 
      33.965454}, {-87.11687599999999, 33.963228}, {-87.109078, 
      33.95736}, {-87.11179299999999, 33.950525999999996`}, {-87.10566, 
      33.945102999999996`}, {-87.105643, 33.942831}, {-87.105628, 
      33.941012}, {-87.105621, 33.940103}, {-87.105611, 
      33.938739}, {-87.105036, 33.936015}, {-87.09392, 
      33.930161999999996`}, {-87.088337, 33.923826}, {-87.083265, 
      33.911577}, {-87.082117, 33.906127}, {-87.09149599999999, 
      33.902442}, {-87.09536899999999, 33.902422}, {-87.100878, 
      33.899212}, {-87.091977, 33.892893}, {-87.09196, 
      33.890619}, {-87.006749, 33.888751}, {-87.007116, 
      33.860107}, {-86.96895599999999, 
      33.859812999999995`}, {-86.96341799999999, 33.858472}}, {{-85.738539, 
      33.968731999999996`}, {-85.74107699999999, 33.935562}, {-85.749916, 
      33.937438}, {-85.81128, 33.946912}, {-85.84607, 33.95757}, {-85.846131, 
      33.950296}, {-85.881564, 33.950491}, {-85.881621, 
      33.943218}, {-85.89989299999999, 33.942859}, {-85.89962, 
      33.906487999999996`}, {-85.933926, 33.906661}, {-85.93437399999999, 
      33.921212}, {-85.951534, 33.92084}, {-85.951585, 
      33.913565999999996`}, {-85.968734, 33.914555}, {-85.968879, 
      33.893187999999995`}, {-85.98602699999999, 33.89372}, {-85.986122, 
      33.879172}, {-85.994413, 33.880117999999996`}, {-85.995064, 
      33.865117}, {-86.021604, 33.86614}, {-86.02114, 33.851589}, {-86.048782,
       33.852609}, {-86.048845, 33.841698}, {-86.064876, 
      33.842214}}, {{-87.635612, 33.915202}, {-87.635775, 
      34.002488}}, CompressedData["
1:eJwd1nk0VWsfB3CKBq45IkMI940Qoqx4e/YxpTLEuzVLkkwNErncFEUlJZdS
SslM5nlIbSKiuuWuVBQnR3EzZI4yvN/dH2ed9Vm/7+/3nGft59nrqLgeczi0
gI+PLwUf9rt0WwRv+g7N3MidsOCoUCTAsdlb/R7N1GQX73aBvzzoOXgKrtOJ
VJpSpsjfnjIerFfU6bXchRMCFwe2wlM+igoDKykS3ie+QTKJZlrE9n5einrm
T75UI7jhcrjKCTjOW8gtAG4qcumOhjfJ8Z4MwNaWL+vYeWlJHVtX3KcZ9bhH
4mzeJvT5y2TY3K45NUKJIkIi9UW3YMWALj0TOC28RdMHbtpkcFEM/q6w8+o1
mO6wGbZRpEjj6Qf+3XA5CetuVKBIt+92bdVkmrleajNSAZ+zXaJ4Em4w/trH
OjlOPCcbzitzPfNeHvvzf/q9AY4UcHyRA5d6+uQLptDMRoV9adVw5Hr96Bl2
XluX5FlY++9z1cWw6ER1gSHczv9W2gD5dyIdModWUKS1O+qALbzr/ubvfrBa
kFzDCdjw2wYLK7hYZf65MvxpKOdjgBxFlLjWwvHwvGngYKss9j/88csVuOBy
8uL/wrkXdKUs2PkJuQ97llPES2e97Fes33LfomwMDjsuuIy1+t6mVRXwjlXV
rfrIl1vcEtGHaz8JSmTBStPnQntlKOISYKckk0oznOfqdIc0RSZCexLN4DGe
rvZXuNWxR9wX1pIKyboHt0UaNVbCg2f7I+VgzQxT9V645ITuWq1lFOnZYirM
SaMZ9pjUSVFE/dQ7c3fYtJVbViZJkWh7g9RIWN4qpyEDVmN/J6x83dWKB7st
/Nf1H7h9h1IqW6eGpybzYP7Dq3fZwgYO37LuwM4hGc+iJCgyI+v3VjKdZnZ+
5nzeD8+GfSw4Ajd7Vd3tE6eIhfXmVNbbw+Y40bD7shbtXLiWm7DxhxhFuFpV
EwnwgExo4SNY/s7FEDYvHNz+KR9mr8ke2FU07KoTvC0y2q4JRvXZClg7b+TW
ADuPX3tfrShFfKPcou0zaKbKoykwDh5VlRr2hsuFX/iz+eZkPEn48VnnCj84
WdX29/ew/xclSXb95gtJXuNwWFeELLv+hqotp95m0oxb4MDhQsyLTjEuGoWP
bfkj9zzMFfH8HxcOctAwLBGhiG7NbKVHFs3M1DJ+3+D0gfFzVfCzloSdXHju
De/RG3ihav31YtiKZ/9YOJtmjjia6GQLU8Tu6gLzWlglmmvZLESRr/3TCZ9h
7j0HddZmik4VrLPjuzz1kV/CHsgHNGOy9ZqEPSxHR/iuh8P8LOMm2XxWzcUy
+Mlqv7ErcOdl3XYevKGt4cg6eCgPNwCWO+FjagY7nlSLZ52kP3f6KeaZGV3T
McqhGd5sxewo+/ueGRdegK3vSG+Xgj+MxsSNw8Zmvo230V/n4VQmlkszdr2R
Dhz4p7Hg9HvMu24+Sd1YjOeXuu52IzwRZuc3uogiHNPTAnNwf53Yywx4gYvJ
uQjMS9i1ld8T+TUiM5msv/RYaHBhFZXm5SWwxiX1z0NwmGxf+3Ks9+u9CTuI
uku5wPyPLf9Sxjy/8akaGzg8P98/S5AiwTqOsVz0a9kpDyyDPZ8c8GQturnu
UaIARe6Sd6udkD8YrN1Xs5AiHqo+gUFw0pTelzw41vjGqTfwFqo8fh3yxQJy
/NJ5NCOzNeZPddgx4Ae1D75YHSQth7xpZTpxhyV+3Ar6uAD7c+t7R8G5KdlL
k+G0Q6mdjjCnxKnEGO48MXEwFjblvLimCTsJD+jF5NPM5uT47Wv4KXLP6fXK
BDhXJ0Ogno8i5121PHbD7tJGC/fCpd6c3QfhbYbFNxbArpNFgyWwnlBYY/k8
Ie3ZakViBTTjY/LOlXWqwdrRIviK2ayOD7xWVEfRD1bafr+qco4Q3NaIeriy
1v6CNHx4sEz4Bbzezr/pxQwhl/YXRlwuxPm52muQBLeIN1ZVwEMcv0RL+HOp
ZNVWeCZ7b+bMT0I4AZ1P3WHfHfmqKfDX2A8HpIpoZp2VU4gc8nMWr25aw9cP
fBBJRj3GUtC2DLYk4as2w9kituaP4fkF1NnfYGfxmIQA+J5Shz73ByFLchR2
u8EJr9QKU2F2TClcm/4ypXuakDPtmbaLi2kmxOevlSPwdNuFCUvYsX/WciPy
v967cIQxdVsBPsre8xK83x/Sb+/DSdKyRVWw2yJNXhf6vbze794PG7vsiM2Y
IsTwdW9KFMzrnIm4BHecDz7UCavtX5paD58/++dS6VKauTMjk7gG/fnx6UuO
wwJOotpF8K9zDb85afraHy41VJVdXE4zi13wxvhOiPeZw8HjZTTTzZMqGpvE
/mQLejRRfyyi58y6ujigIxw2dLk27ol8sJTZCf0KmkmbKBfgwqEx8YaF8MKg
Ty/D4SjJ8eVB8C3hvUre6Lc7uW+qFl59ffi88wQhQu09w9aVNCPy07TQFn4f
0L5Cogr/T1KurGobJ+T571oRD+DCNCtHU9R36cgnjsFeusmDN1EX22ffpV+N
fmnejA38637BRiq5en2jhGh2NpmMIq9xvP/oXRhPRasNjuhx63YaIaSYEzPU
C7/tzMh+NUxIolXDvCL6J5cmye6CL3/45w1r+3rVCEWYcovR6ETeR/1kfP03
QjwWjYSy9XU19TvTYQOfuInbcPZvvKPibP1foTKJhzSzfyg2hQ9uOZTiFwIb
7vnj2fwQIU+0rO/2w88HnYdiUadaM+hxWOybcYEC3GaPncLKJUqPtiG/Q00j
8xNsEia/eg9scWC5hVgNzUj9x1XiCdydO3YsHg69kecij/4Hm+rWusDro8K4
I4OErLk5lZIJi5nLeHbD/wflvOXF
      "], {{-87.635612, 33.915202}, {-87.73633099999999, 
      33.914623999999996`}, {-87.792264, 33.916741}, {-87.797798, 
      33.916678999999995`}, {-87.85540999999999, 33.919655}, {-87.951169, 
      33.919858}}, {{-88.204943, 34.0587}, {-88.010761, 
      34.053211}, {-87.986353, 34.052617999999995`}, {-87.98745199999999, 
      34.023055}, {-87.95418099999999, 34.022113}, {-87.95141, 
      34.022148}, {-87.951376, 34.02033}, {-87.951634, 
      34.004415}, {-87.951169, 33.919858}}, {{-86.96341799999999, 
      33.858472}, {-86.962784, 33.844834}, {-86.954493, 
      33.845321999999996`}, {-86.95321299999999, 
      33.815318999999995`}}, {{-86.333409, 33.922928999999996`}, {-86.3384, 
      33.917935}, {-86.348366, 33.915676}, {-86.34949, 
      33.907039}, {-86.343974, 33.897939}, {-86.346212, 
      33.885667}, {-86.356186, 33.876588}, {-86.36891899999999, 
      33.870238}, {-86.388852, 33.854801}, {-86.407674, 
      33.836631}, {-86.42814299999999, 33.822551}, {-86.440304, 
      33.822103}, {-86.457439, 33.821656}, {-86.477893, 
      33.813477}, {-86.495026, 33.814842999999996`}, {-86.511606, 
      33.811206}, {-86.521552, 33.80211}, {-86.577365, 33.802087}, {-86.57788,
       33.765256}}, {{-86.064876, 33.842214}, {-86.066555, 
      33.838583}, {-86.055526, 33.83354}, {-86.05113999999999, 
      33.827157}, {-86.051159, 33.823974}, {-86.065058, 
      33.809478}, {-86.064019, 33.797652}, {-86.044825, 
      33.77257}, {-86.043773, 33.763470999999996`}, {-86.047095, 
      33.762119999999996`}, {-86.051508, 33.763047}, {-86.05814099999999, 
      33.762163}, {-86.076432, 33.750409}, {-86.07811, 
      33.746323}, {-86.08310399999999, 33.741794}, {-86.099143, 
      33.736848}, {-86.115765, 33.725082}, {-86.117989, 
      33.721906}, {-86.119694, 33.711908}, {-86.12521799999999, 
      33.711016}, {-86.135682, 33.716052}, {-86.143439, 
      33.70971}, {-86.146231, 33.702442}, {-86.14353, 33.689701}, {-86.14523, 
      33.679702}}, {{-85.651268, 33.642105}, {-85.651313, 
      33.638011999999996`}, {-85.655172, 33.63804}, {-85.655256, 
      33.630309}, {-85.65529, 33.627126}, {-85.68561, 
      33.627798999999996`}, {-85.690016, 33.628285}, {-85.690129, 
      33.61737}, {-85.690175, 33.612822}, {-85.71607999999999, 
      33.613456}, {-85.72489499999999, 33.613971}, {-85.72443899999999, 
      33.604417}, {-85.724488, 33.599413999999996`}, {-85.73771099999999, 
      33.599956999999996`}, {-85.742116, 33.600441}, {-85.74229199999999, 
      33.582249}}, {{-85.79525699999999, 33.575308}, {-85.794612, 
      33.585764999999995`}, {-85.964345, 33.586225}, {-85.9941, 
      33.586814}, {-85.99401499999999, 33.600004}, {-86.021014, 
      33.601484}, {-86.021552, 33.60376}, {-86.021535, 
      33.606488999999996`}, {-86.019842, 33.612849}, {-86.021997, 
      33.621044}, {-86.02417799999999, 33.625147}, {-86.026347, 
      33.631068}, {-86.02628399999999, 33.641528}, {-86.025705, 
      33.646073}, {-86.028995, 33.64927}, {-86.033391, 
      33.652017}, {-86.041089, 33.656141}, {-86.045467, 
      33.66207}, {-86.047642, 33.667536}, {-86.048721, 
      33.671633}, {-86.04925999999999, 33.673909}, {-86.094487, 
      33.676351}, {-86.10606899999999, 33.677301}, {-86.14523, 
      33.679702}}, {{-85.74229199999999, 33.582249}, {-85.744199, 
      33.555881}, {-85.795976, 33.556664}}, {{-85.795976, 
      33.556664}, {-85.79592199999999, 33.562576}}, {{-85.305148, 
      33.482561}, {-85.307913, 33.48168}, {-85.314421, 
      33.488116}, {-85.322119, 33.48865}, {-85.33362199999999, 
      33.492405999999995`}, {-85.343469, 33.4966}, {-85.34669799999999, 
      33.501636}, {-85.35000699999999, 33.501215}, {-85.35443699999999, 
      33.499438999999995`}, {-85.351771, 33.493499}, {-85.352886, 
      33.492599999999996`}, {-85.4679, 33.495055}, {-85.516898, 
      33.494574}, {-85.531759, 33.4947}, {-85.553776, 33.494884}, {-85.564233,
       33.494969}, {-85.643489, 33.496041999999996`}}, {{-85.688064, 
      33.497275}, {-85.643489, 33.496041999999996`}}, {{-85.795976, 
      33.556664}, {-85.796657, 33.542113}, {-85.85154299999999, 
      33.498768}}, {{-86.57788, 33.765256}, {-86.543083, 
      33.765274}, {-86.54252199999999, 33.750268999999996`}, {-86.542514, 
      33.735718}, {-86.53367999999999, 
      33.735265999999996`}, {-86.53367399999999, 
      33.72117}, {-86.52484199999999, 33.721626}, {-86.524838, 
      33.711622}, {-86.525387, 33.700254}, {-86.524821, 
      33.656141999999996`}, {-86.53364599999999, 
      33.656594999999996`}, {-86.533637, 33.63431}, {-86.54245999999999, 
      33.634761999999995`}, {-86.542452, 33.620208999999996`}, {-86.551273, 
      33.620205999999996`}, {-86.551785, 33.561534}, {-86.542971, 
      33.561538}, {-86.54296699999999, 33.554261}, {-86.517076, 
      33.553357999999996`}, {-86.51652399999999, 
      33.546079999999996`}}, {{-87.423819, 33.602413}, {-87.423188, 
      33.689285}, {-87.52808, 33.692491}, {-87.53149499999999, 
      33.867984}, {-87.610624, 33.870433}, {-87.63609699999999, 
      33.872459}, {-87.635612, 33.915202}}, {{-85.85154299999999, 
      33.498768}, {-85.85215, 33.491948}, {-85.869216, 
      33.491588}, {-85.869333, 33.477032}, {-85.887497, 
      33.476675}, {-85.887553, 33.469397}, {-85.78245199999999, 
      33.469243999999996`}, {-85.782319, 33.483799999999995`}, {-85.765258, 
      33.483692}, {-85.765664, 33.499161}, {-85.688064, 
      33.497275}}, {{-86.95321299999999, 33.815318999999995`}, {-86.953684, 
      33.801221999999996`}, {-86.955342, 33.801215}, {-86.970817, 
      33.801608}, {-86.971279, 33.786601}, {-87.006092, 
      33.787363}, {-87.00599799999999, 33.772813}, {-87.023122, 
      33.772736}, {-87.022927, 33.743635}, {-87.031759, 
      33.74314}, {-87.031663, 33.729044}, {-87.040497, 
      33.729003}, {-87.039644, 33.685351}, {-87.056752, 
      33.685725}, {-87.057648, 33.656614999999995`}, {-87.092404, 
      33.657351}, {-87.09218, 33.627791}, {-87.121961, 
      33.628544}, {-87.144567, 33.628419}, {-87.144447, 
      33.613866}, {-87.179181, 33.614122}, {-87.17905499999999, 
      33.599568}, {-87.196692, 33.599463}, {-87.19716199999999, 
      33.590364}, {-87.199877, 33.585799}, {-87.204771, 
      33.578492}, {-87.203616, 33.572586}, {-87.196916, 
      33.562619999999995`}, {-87.188065, 33.55858}, {-87.18527499999999, 
      33.554503}, {-87.188552, 33.551299}, {-87.20065, 
      33.548952}, {-87.212656, 33.536597}, {-87.21871, 
      33.536105}, {-87.230305, 33.539215999999996`}, {-87.235816, 
      33.539635}, {-87.23854899999999, 33.537344}, {-87.24064, 
      33.525504}, {-87.246619, 33.517277}, {-87.251544, 
      33.514061}, {-87.25540199999999, 33.514491}, {-87.25817699999999, 
      33.516746999999995`}, {-87.263807, 33.529446}, {-87.270974, 
      33.530308}, {-87.275312, 33.523455999999996`}, {-87.275272, 
      33.519362}, {-87.26695099999999, 33.51305}}, {{-87.26695099999999, 
      33.51305}, {-87.31816599999999, 33.514061}, {-87.318383, 
      33.587745999999996`}, {-87.37073, 33.586908}, {-87.370897, 
      33.601915999999996`}, {-87.423819, 33.602413}}, {{-87.423819, 
      33.602413}, {-87.56003, 33.606698}, {-87.631192, 
      33.610115}, {-87.631875, 33.580998}, {-87.666581, 
      33.580197}, {-87.66626, 33.521521}, {-87.68057499999999, 
      33.521375}, {-87.743327, 33.519804}, {-87.840334, 
      33.525084}}, {{-87.946056, 33.524257999999996`}, {-87.840334, 
      33.525084}}, {{-87.951169, 33.919858}, {-87.952, 
      33.875288999999995`}, {-87.949877, 33.790738}, {-87.94985199999999, 
      33.789373999999995`}, {-87.946015, 33.641615}, {-87.946056, 
      33.524257999999996`}}, CompressedData["
1:eJwV0n001XccB/B7a83RWpZ2GnOuIWp2VlgxMXwy4hIdD79OD+48jdGaRZiu
7NglxeUmXa6HOV1PbXloTVqG+FE3j1dGyHoQznUinDQPp5uy9/3jd37n9ft8
zufz+X6+P+OQH33D1nA4nK/xaN5CfUWMZzrDeqWUnuIME827N31VDPeeWOvo
NESkKpDdnoPtx8xsFweJuvZHvtmRwbDJzg5J7yC+2OAaVA1zd422HoBTUj8N
7IOrplU/FcL7EpuyN4oZNl69V1D+gGh2fdK1THhSmpyfOkLk9XdbY0Amw/7g
/9vaw7DIZs/pfpi/Sf/gPPJFBuZHTbMYNtiGm6bCfPGWIZc48PIhdd86eEt4
SfEA8q+IfPjF6Hdf2PKPBPXDi+eTojHvs53p103gJ182L/XcJ/psTPvWW8x3
fYYfdBJed1xr6xK8IcexpnSAKGRIXPIr7Gl4oFunn+i/bPNPRLD9666UhT6i
TeoC4WN4ts7aRO8ezuNax/ND/ULNwXqJ9gap+kwwT8R0nJiFHzZF++bDDREd
CVK4OcxbpoCXtOV6h+GVswsPh+GVrPhHL5RES3PnlythO16H8Bg8IpCXs6hf
pvnQQ9Tosjiksa1nZ4wu7CvLDDVFfpn0g+rKbqLfd4eEX8J+rPPTxrYirnbV
Vr8nYVjv/hWrGsSNq446bIdN+23eusAB3DNCNfK/32BnHNtFZHdkMEcCP/ep
NzzTSVSrU/t5PuyRmGKxv4Oo+nW7cyysNHK8NtFOFBuQNeOB/k6K6KeDd4lk
J57tMIS1Lo5PbIYzVu1LneFJh97dwQqigkAlVwRHyVn7V3eI7hUHrcah3rDV
1Xpb2E0S++4+zHcyOUhieJuoc7LylAS+UbHxpbCNKHq8iqeA3RSrPJ9W3L+u
ZUMTPOcQEPOohcgsplV/Bd6Voco7CM91F8yuz2ZY3h+0UN6M+3X33hYFB06d
TsiDC6e+2b4IR47znvKR7/7hkaE38BcdglRzlshJXOHeDK+kd6VZox83QrpT
E7fK/bltBLYoOxQVeYFh7z4RW/wLR6UZvHgFj+qtSQ6FeQa/JAhyGNZ8Kjgi
DvVCnXvMGLjVryNXiP7yx8YKzkWG1cn7s6ToFhG/qDLxWzjtqotc3UjEWLQM
aLwl5WzkaAOR7YMivRx42d870QOejjV6fkWK/+s7QZmqHvfH9Up9P5dhz58z
v+Byk0hr5thLKXxT6X/O7S/sO3Vbulkew1b7Ci/L6ojE6cr2G/BERdEdI3jo
Y49ZVxn2fbzGQhe25Idl7MlnWD+p58RHtUT/A1SNF48=
      "], {{-86.51652399999999, 33.546079999999996`}, {-86.499449, 
      33.546082}, {-86.481273, 33.546535}, {-86.48183399999999, 
      33.502414}, {-86.37834, 33.502806}, {-86.378512, 
      33.391354}}, {{-87.946056, 33.524257999999996`}, {-88.051305, 
      33.527436}, {-88.08549699999999, 33.529699}, {-88.27341299999999, 
      33.534234999999995`}}, CompressedData["
1:eJwd030w1HkYAPBFhsnIGaw5lzuv4a7r7rzkvNVzScZxiH7a4eKQOk3HymiT
xamxFLKu8naFjaUi2ba166XbLzqGk1M2Blesu6XbMyJrcxl1z+/+eOaZzzzP
888zz2ObkBqRpMtgMIIx6Hx4/k7nNgFF1nK3rap+BSh8+bDFEn1Y7wrPqg/A
yaJEIr9BkYFP3vNzQfOs+xtof7Orn3j3AqyHeYbP1lNke1zWsSB0avUeH9qr
bN2x5B6A4fKWi+wGivC1e0k0Osb+XBpt5r9r/icJwAVbryoZOkPnMzfajxfq
i2l7lXOe6qEtnV3aGEKKBJbOTGvkAHFLl+tpGzk45xSjx3aOLvHRE5/qJmaj
w0PvN9P+0zXlRN0DAKOR2ZeWjRSJjFHb3EWLbd8N26AN53yvkW4A9o5GIxHa
XRPGFqEPZM6r2tCdWn1NbxeAfH93xtsmiqR/DSG0/59vpsi3UfFuBF3RlB7g
gj4wWhmk6ADY6xHbGdRCkZFDhYFz6MWp5ym0z09P9a7KAPg1dgWFaIEmn0/7
y1dwtAxtfnYziIvWvI44M4qOtwwwoV3qOqdLO7r2VAhTCtC6VZGwfIcide4K
Zwe0V9zig3W0T7+FZaAEIJj1QaJTG0U836d4aWjRwfHUHWiV09M91mKAlD8S
clLQPz2iVrejj2j/CeWg3SeSG4T3AIJ+rI5uRyu5ahbt/HvLaxJ0uZ6fol0E
kMm66fFIRJHmwcioMXQ3Y+OFAj0VJR5ZbwVQD/s5cMXYr2+Wa34XIKwlUpWF
lmZ1hF3CusuQcMXoPkV2zSbxStBxjh910e5bNv3CEf2m6uwzOwlFtgz6FLii
fSdeK23QRRulIQW3AbY0q1UcGUX0RCfn+Wjm53kxtL1/27lPdAvA5klqnEEH
RVbGZJ5ydOJ31gMm6N0Ls1WjNwHK23b3h6IF1/Fy0DGV+adpm9sHz7PQ7z7s
Pp2MdvXVimlfelGTUYLOnfTLpO1rVu1Qjj54fMlW2QTwt8xq8ir64WLSdDLa
bkaocOzEfWx+TDhoZnAZl/ZG+mP+SiPAQJd9ogRdo+b/rEQX1Z8yo23KNqRO
oPmaZItN9JFegfQMmqf6XarfRZFnkMd5JQQQrFp17UcPXVSqGVg3MMgy80dL
mMcE1+sBZBzjN0/QkzaXi6+hs/8ab5hGN7f6eziiMxfCebe78V+Ntp53RcfL
ncZvoXXoh7wB4CcdvWr4C0UOlcQah6PzK2YVBuiFQm5FhABAx22mJwz9lSKb
QVtrH3CUhfafH6qbqgNI8x6MqkAbC7V2tHN+2NTUok2k/n0JaPG+sqUFdKcp
0yINrYxheT5Hsyu/55+rBbAeCreIlFNEn0mu5KGLUp257T0UiT3u/7YK/R82
FFpE
      "], {{-87.065724, 33.247156}, {-87.026763, 
      33.246887}}, {{-87.26695099999999, 33.51305}, {-87.26083299999999, 
      33.506721999999996`}, {-87.261326, 33.500805}, {-87.26459799999999, 
      33.497599}, {-87.267896, 33.497122}, {-87.270653, 
      33.497558999999995`}, {-87.276752, 33.502067}, {-87.28501399999999, 
      33.502466}, {-87.288831, 33.498799999999996`}, {-87.285428, 
      33.488816}, {-87.284286, 33.48473}, {-87.286988, 
      33.479707}, {-87.296894, 33.479639}, {-87.301949, 
      33.489612}, {-87.306912, 33.490487}, {-87.314584, 
      33.487248}, {-87.32179099999999, 33.492201}, {-87.32895599999999, 
      33.493058999999995`}, {-87.33167, 33.489401}, {-87.332698, 
      33.482569999999996`}, {-87.341377, 33.470679}, {-87.335324, 
      33.470723}, {-87.335724, 33.456618}, {-87.31425899999999, 
      33.455861999999996`}, {-87.31411299999999, 33.441761}, {-87.313017, 
      33.442223999999996`}, {-87.284396, 33.440602999999996`}, {-87.284246, 
      33.425591}, {-87.26664, 33.4248}, {-87.267123, 
      33.417972999999996`}, {-87.25392599999999, 33.41806}, {-87.253306, 
      33.410785}, {-87.248357, 33.410818}, {-87.249314, 
      33.395798}, {-87.23226799999999, 
      33.395452999999996`}, {-87.23199699999999, 33.366337}, {-87.214958, 
      33.36599}, {-87.214342, 33.358714}, {-87.197304, 
      33.358364}, {-87.197171, 33.34335}, {-87.18014099999999, 
      33.343453}, {-87.17939899999999, 33.321162}, {-87.161824, 
      33.321265}, {-87.16170199999999, 33.306706}, {-87.127104, 
      33.306445}, {-87.126981, 33.290974999999996`}, {-87.11105599999999, 
      33.290606}, {-87.0869, 33.290732999999996`}, {-87.087368, 
      33.27981}, {-87.074742, 33.279874}, {-87.074167, 
      33.276236}, {-87.065384, 33.27628}, {-87.065747, 
      33.250341}, {-87.065724, 33.247156}}, {{-85.593476, 
      33.107526}, {-85.485542, 33.10935}, {-85.23302799999999, 
      33.108197}}, {{-85.593476, 33.107526}, {-85.65319199999999, 
      33.106618}}, {{-85.85154299999999, 33.498768}, {-85.90493699999999, 
      33.499055999999996`}, {-85.905271, 33.454933}, {-85.922876, 
      33.455023}, {-85.923857, 33.396343}, {-85.940899, 
      33.396426999999996`}, {-85.941002, 33.381869}, {-85.976179, 
      33.382035}, {-85.980058, 33.294241}, {-85.99542799999999, 
      33.294764}, {-86.11785599999999, 33.296603}, {-86.119807, 
      33.233816}, {-86.120544, 33.194683}, {-86.17263299999999, 
      33.195754}, {-86.17339199999999, 
      33.144785999999996`}}, {{-85.79592199999999, 33.562576}, {-85.880769, 
      33.562155}, {-85.882536, 33.547609}, {-85.91173599999999, 
      33.546852}, {-85.91248399999999, 33.520474}, {-85.951584, 
      33.519757999999996`}, {-85.952767, 33.507937}, {-85.97018299999999, 
      33.456161}, {-85.97025099999999, 33.446152999999995`}, {-85.97305, 
      33.438887}, {-85.979702, 33.431184}, {-85.988534, 
      33.42622}, {-86.00999399999999, 33.424493}, {-86.010702, 
      33.39902}, {-86.021697, 33.399066}, {-86.022819, 
      33.395432}, {-86.06240299999999, 33.395134}, {-86.061904, 
      33.386033}, {-86.07235299999999, 33.385163}, {-86.077857, 
      33.383818}, {-86.114831, 33.353921}, {-86.132418, 
      33.353069}, {-86.13197199999999, 33.330774}, {-86.145157, 
      33.33036}, {-86.14521099999999, 33.318531}, {-86.160043, 
      33.317665999999996`}, {-86.190331, 33.296821}, {-86.20191, 
      33.284112}, {-86.206334, 33.275478}, {-86.20362, 
      33.267281}, {-86.19542899999999, 33.256338}, {-86.191625, 
      33.246773}, {-86.191127, 33.23403}, {-86.19334099999999, 
      33.22903}, {-86.20490699999999, 33.216774}, {-86.212051, 
      33.213152}, {-86.213161, 33.209514}, {-86.221949, 
      33.205895}, {-86.230747, 33.199090999999996`}, {-86.246155, 
      33.182288}, {-86.246713, 33.179559}, {-86.228115, 
      33.167229}, {-86.22593599999999, 33.163128}, {-86.22707199999999, 
      33.151753}, {-86.22380299999999, 33.146284}, {-86.221068, 
      33.144912}, {-86.204093, 33.141228}, {-86.195324, 
      33.141661}, {-86.193671, 33.143932}, {-86.17941599999999, 
      33.145713}, {-86.17339199999999, 33.144785999999996`}}, {{-86.009328, 
      33.090495}, {-85.97428099999999, 33.090339}, {-85.97472599999999, 
      33.105816}, {-85.801104, 33.104431}, {-85.65319199999999, 
      33.106618}}, {{-86.174105, 33.104737}, {-86.009241, 
      33.104604}, {-86.009328, 33.090495}}, {{-86.17339199999999, 
      33.144785999999996`}, {-86.17404499999999, 33.119301}, {-86.174105, 
      33.104737}}, {{-86.378512, 33.391354}, {-86.379065, 
      33.389534999999995`}, {-86.376324, 33.384983}, {-86.35271, 
      33.373126}, {-86.34120399999999, 33.355368}, {-86.341212, 
      33.351728}, {-86.347264, 33.347640999999996`}, {-86.362098, 
      33.347204999999995`}, {-86.367599, 33.343572}, {-86.368158, 
      33.337658}, {-86.363776, 33.330373}, {-86.367637, 
      33.320823}, {-86.367093, 33.317637}, {-86.362161, 
      33.311262}, {-86.360524, 33.305344999999996`}, {-86.357241, 
      33.298971}, {-86.358898, 33.293513}, {-86.374279, 
      33.288526}, {-86.39461, 33.274896}, {-86.40010099999999, 
      33.273534999999995`}, {-86.40723799999999, 33.272631}, {-86.417664, 
      33.274915}, {-86.42918399999999, 33.283567999999995`}, {-86.433576, 
      33.28266}, {-86.43467799999999, 33.277656}, {-86.425358, 
      33.265364}, {-86.42426499999999, 33.260813}, {-86.427566, 
      33.25126}, {-86.43251, 33.244892}, {-86.435256, 
      33.242163999999995`}, {-86.439098, 33.241256}, {-86.45281299999999, 
      33.243992}, {-86.457752, 33.241718999999996`}, {-86.465988, 
      33.228981}, {-86.466538, 33.224885}, {-86.465992, 
      33.219879999999996`}, {-86.46105899999999, 
      33.211231999999995`}, {-86.461613, 33.199856}, {-86.467647, 
      33.195762}, {-86.472034, 33.196673}, {-86.480806, 
      33.201681}, {-86.48629, 33.202137}, {-86.49342, 
      33.197131999999996`}, {-86.503289, 33.179384}, {-86.50383699999999, 
      33.176198}, {-86.50109599999999, 33.173013}, {-86.493422, 
      33.171192}, {-86.487392, 33.167096}, {-86.483009, 
      33.159814}, {-86.48301099999999, 33.147526}, {-86.478081, 
      33.142064}, {-86.463289, 33.133868}, {-86.459458, 
      33.12522}, {-86.461103, 33.122035}, {-86.46603499999999, 
      33.11885}, {-86.480279, 33.115668}, {-86.48411399999999, 
      33.113392999999995`}, {-86.49068899999999, 
      33.103381}}, {{-87.83731499999999, 33.153822}, {-87.83628, 
      33.189789999999995`}, {-87.838473, 33.254388}, {-87.838078, 
      33.425025}, {-87.840334, 33.525084}}, {{-86.51750899999999, 
      33.020996}, {-86.516419, 33.042389}, {-86.51970399999999, 
      33.048306}, {-86.520253, 33.057409}, {-86.50766399999999, 
      33.064237999999996`}, {-86.50547499999999, 
      33.067879999999995`}, {-86.511499, 33.080168}, {-86.512047, 
      33.086085}, {-86.50876199999999, 33.091091999999996`}, {-86.493428, 
      33.099285}, {-86.49068899999999, 33.103381}}, {{-87.026763, 
      33.246887}, {-87.02596899999999, 33.210031}, {-87.02157799999999, 
      33.209596}, {-87.02101499999999, 33.207322999999995`}, {-87.021458, 
      33.191393999999995`}, {-87.025847, 33.191829}, {-87.025126, 
      33.165892}, {-87.003749, 33.165988}, {-87.003726, 
      33.162347}, {-86.976317, 33.162009999999995`}, {-86.974122, 
      33.161564}, {-86.974103, 33.158378}, {-86.969167, 
      33.157942999999996`}, {-86.969364, 33.098777}, {-86.950743, 
      33.098852}, {-86.951723, 33.078821}, {-86.934202, 
      33.078889}, {-86.934122, 33.064324}, {-86.920439, 
      33.064831}, {-86.919872, 33.061191}, {-86.91604, 
      33.061205}, {-86.916021, 33.057564}, {-86.898504, 
      33.057627}, {-86.898465, 33.049889}, {-86.880951, 
      33.049949}}, {{-86.880951, 33.049949}, {-86.88160599999999, 
      33.072249}, {-86.82575399999999, 33.070602}, {-86.825746, 
      33.068781}, {-86.818629, 33.068801}, {-86.61004299999999, 
      33.069646999999996`}, {-86.608944, 33.066462}, {-86.61441599999999, 
      33.064636}, {-86.61824299999999, 33.061446}, {-86.618237, 
      33.05735}, {-86.615495, 33.053711}, {-86.60235999999999, 
      33.055088999999995`}, {-86.59961299999999, 33.047809}, {-86.583732, 
      33.039629}, {-86.580444, 33.034624}, {-86.567304, 
      33.027805}, {-86.56291999999999, 33.019614}, {-86.548147, 
      33.019166}, {-86.53666, 33.024633}, {-86.522981, 
      33.02327}, {-86.51750899999999, 33.020996}}, {{-87.065724, 
      33.247156}, {-87.076698, 33.247102}, {-87.10394099999999, 
      33.221933}, {-87.121494, 33.221838999999996`}, {-87.122154, 
      33.235943}, {-87.14958899999999, 33.236245}, {-87.160485, 
      33.227081999999996`}, {-87.160439, 33.221621}, {-87.19909799999999, 
      33.189082}, {-87.199129, 33.130828}, {-87.281339, 
      33.133027}, {-87.311076, 33.094133}, {-87.316582, 
      33.044024}}, {{-87.316582, 33.044024}, {-87.31838499999999, 
      33.006685}, {-87.42175499999999, 33.004532}}, {{-87.42175499999999, 
      33.004532}, {-87.489041, 33.004424}, {-87.52404899999999, 
      33.004115}}, {{-87.316582, 33.044024}, {-87.346795, 
      33.054274}, {-87.352308, 33.057874}, {-87.524168, 
      33.055552999999996`}, {-87.52404899999999, 
      33.004115}}, {{-87.71556199999999, 
      33.006789999999995`}, {-87.52404899999999, 
      33.004115}}, {{-87.83731499999999, 33.153822}, {-87.838118, 
      33.136517}, {-87.838905, 33.118302}, {-87.839036, 
      33.09372}, {-87.831369, 33.09381}, {-87.83227, 
      33.017323999999995`}, {-87.751837, 33.017323999999995`}, {-87.711907, 
      33.018209}, {-87.71131799999999, 33.015484}, {-87.71458, 
      33.014084}, {-87.714005, 33.012268999999996`}, {-87.716151, 
      33.009515}, {-87.71556199999999, 33.006789999999995`}}, CompressedData["

1:eJw11Xk41PseB3BDx6kkFN1QthaOnMreky5fSYx9aYjKbiJEZSsMZU1clMR1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      "], {{-85.139566, 32.746069}, {-85.154832, 
      32.746249999999996`}, {-85.20664, 32.74594}, {-85.248097, 
      32.745036999999996`}, {-85.28517699999999, 
      32.744983999999995`}, {-85.284848, 32.730862}, {-85.288125, 
      32.730442}, {-85.372084, 32.730394}, {-85.389527, 
      32.730565999999996`}, {-85.404245, 32.730709}, {-85.40468899999999, 
      32.738}, {-85.41342399999999, 32.737173}, {-85.41331799999999, 
      32.744914}, {-85.430219, 32.745073999999995`}, {-85.430416, 
      32.730502}, {-85.482207, 32.730522}, {-85.481568, 
      32.737803}, {-85.490291, 32.737881}, {-85.49037799999999, 
      32.731049999999996`}, {-85.55690899999999, 
      32.729344}, {-85.56781099999999, 32.729434}, {-85.56827, 
      32.736723999999995`}, {-85.576998, 32.73634}, {-85.576532, 
      32.729504999999996`}, {-85.592896, 32.728726}}, {{-85.593476, 
      33.107526}, {-85.592998, 33.006015999999995`}, {-85.59306099999999, 
      33.000553}, {-85.593244, 32.746034}, {-85.592766, 
      32.74011}, {-85.592896, 32.728726}}, {{-86.880951, 
      33.049949}, {-86.876572, 33.049963}, {-86.876103, 
      32.836453999999996`}, {-86.914321, 
      32.837686999999995`}}, {{-87.42175499999999, 
      33.004532}, {-87.42027999999999, 32.971767}, {-87.42078599999999, 
      32.874333}}, {{-86.983646, 32.837413999999995`}, {-86.96072199999999, 
      32.837964}, {-86.957993, 32.837975}, {-86.914321, 
      32.837686999999995`}}, {{-86.377307, 32.75459}, {-86.33695499999999, 
      32.754084}, {-86.336381, 32.7682}, {-86.318929, 
      32.767717999999995`}, {-86.31894899999999, 32.759066}, {-86.318961, 
      32.753602}, {-86.007041, 32.754954999999995`}}, {{-86.51750899999999, 
      33.020996}, {-86.52242799999999, 33.003242}, {-86.510391, 
      32.985490999999996`}, {-86.511484, 
      32.977751999999995`}, {-86.51804399999999, 32.971378}, {-86.516949, 
      32.962728999999996`}, {-86.51476, 32.95408}, {-86.516398, 
      32.943608999999995`}, {-86.51366399999999, 32.93587}, {-86.516395, 
      32.929496}, {-86.508743, 32.919937}, {-86.50546399999999, 
      32.913108}, {-86.49781399999999, 32.911742}, {-86.491258, 
      32.906734}, {-86.489074, 32.896718}, {-86.486344, 
      32.893074999999996`}, {-86.478701, 32.872586}, {-86.458497, 
      32.868483}, {-86.45140099999999, 32.863927}, {-86.448674, 
      32.858461999999996`}, {-86.447041, 32.851177}, {-86.45414099999999, 
      32.846627}, {-86.456873, 32.842985}, {-86.4607, 
      32.832059}, {-86.45634299999999, 32.813843999999996`}, {-86.450341, 
      32.812931}, {-86.442701, 32.812928}, {-86.44106599999999, 
      32.810649999999995`}, {-86.443795, 32.80883}, {-86.44434299999999, 
      32.805642999999996`}, {-86.432346, 32.79744}, {-86.42853099999999, 
      32.792429}, {-86.418712, 32.791056999999995`}, {-86.41326, 
      32.78832}, {-86.405641, 32.772832}, {-86.399101, 
      32.768273}, {-86.392568, 32.76007}, {-86.377307, 
      32.75459}}, {{-87.42078599999999, 32.874333}, {-87.421381, 
      32.831527}}, {{-86.412803, 32.707262}, {-86.41330099999999, 
      32.75098}, {-86.370768, 32.751394999999995`}, {-86.377307, 
      32.75459}}, {{-87.017876, 32.729341999999995`}, {-87.01912399999999, 
      32.836802}}, {{-85.592896, 32.728726}, {-85.609805, 
      32.727948999999995`}, {-85.609963, 32.713832}, {-85.67974199999999, 
      32.712534999999995`}, {-85.67934799999999, 32.697958}, {-85.680982, 
      32.69797}, {-85.696244, 32.697623}, {-85.696987, 
      32.678045}, {-85.695979, 32.616093}, {-85.695481, 
      32.611534999999996`}, {-85.695638, 32.596049}}, {{-86.412803, 
      32.707262}, {-86.48528499999999, 32.70775}, {-86.487465, 
      32.70775}, {-86.714173, 32.705726999999996`}, {-86.712966, 
      32.662008}, {-86.82679499999999, 
      32.660371999999995`}, {-86.91668399999999, 
      32.664176999999995`}}, {{-87.016357, 32.663312}, {-87.017876, 
      32.729341999999995`}}, {{-85.434175, 32.409836}, {-85.436196, 
      32.461798}, {-85.43613599999999, 32.466353999999995`}, {-85.437034, 
      32.480486}, {-85.437896, 32.497352}, {-85.44496199999999, 
      32.497417999999996`}, {-85.488998, 32.496908}, {-85.493866, 
      32.498773}, {-85.609652, 32.547121}, {-85.63077299999999, 
      32.555484}, {-85.647561, 32.562445}, {-85.660558, 
      32.568008}, {-85.66102599999999, 32.5753}, {-85.660949, 
      32.582588}, {-85.67890899999999, 32.582263999999995`}, {-85.695781, 
      32.581928999999995`}, {-85.695638, 32.596049}}, {{-85.695638, 
      32.596049}, {-85.712513, 32.595712}, {-85.712648, 
      32.582046999999996`}, {-85.79862899999999, 32.581244}, {-85.798693, 
      32.573955999999995`}, {-85.79828499999999, 
      32.558465999999996`}, {-85.797838, 32.54753}, {-85.797596, 
      32.513362}, {-85.79721699999999, 32.494681}, {-85.88528, 
      32.493370999999996`}}, {{-86.007041, 32.754954999999995`}, {-85.996135, 
      32.754906999999996`}, {-85.972139, 32.755254}, {-85.97259, 
      32.769373}, {-85.967136, 32.769346999999996`}, {-85.96004599999999, 
      32.769314}, {-85.95513799999999, 32.76929}, {-85.95518799999999, 
      32.762005}, {-85.955203, 32.759727999999996`}, {-85.954689, 
      32.755171}, {-85.951966, 32.754703}, {-85.895797, 
      32.754874}, {-85.887076, 32.754372}, {-85.879984, 
      32.754788999999995`}, {-85.881655, 
      32.750243999999995`}, {-85.88009699999999, 
      32.740217}, {-85.89327899999999, 32.727537}, {-85.893849, 
      32.724351999999996`}, {-85.89008899999999, 32.717045}, {-85.898354, 
      32.705248}, {-85.903269, 32.703908}, {-85.907118, 
      32.699374}, {-85.91158899999999, 32.684368}, {-85.911636, 
      32.677991999999996`}, {-85.90677, 32.672957}, {-85.905718, 
      32.667941}, {-85.900874, 32.660173}, {-85.890044, 
      32.651917}, {-85.88735299999999, 32.647804}, {-85.893569, 
      32.618231}, {-85.894245, 32.600926}, {-85.88900199999999, 
      32.574934}, {-85.89067999999999, 32.569021}, {-85.889072, 
      32.565824}, {-85.886967, 32.556702}, {-85.884896, 
      32.543025}, {-85.88878, 32.533024}, {-85.89117499999999, 
      32.504335999999995`}, {-85.889063, 32.496124}, {-85.88528, 
      32.493370999999996`}}, {{-87.072946, 32.579688}, {-87.01690099999999, 
      32.579501}, {-87.016357, 32.663312}}, {{-85.001685, 
      32.510650999999996`}, {-85.060407, 32.5105}, {-85.058909, 
      32.47312}, {-85.12469, 32.471658999999995`}, {-85.175241, 
      32.470894}, {-85.17795699999999, 32.470926}, {-85.194807, 
      32.470666}, {-85.207854, 32.47036}, {-85.211657, 32.470403}, {-85.23883,
       32.470253}, {-85.333957, 32.468081999999995`}, {-85.332185, 
      32.440726}, {-85.329904, 32.411085}, {-85.35651299999999, 
      32.410900999999996`}, {-85.361949, 32.4105}, {-85.434175, 
      32.409836}}, CompressedData["
1:eJwt1nlYzGsbB/AMLVTHMkcRJVuSQ6VyEulmJJUypmZMKGkVbUqy1CBLKVlK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      "], {{-85.88528, 32.493370999999996`}, {-85.870155, 
      32.481442}, {-85.862566, 32.479122}, {-85.855491, 
      32.480449}, {-85.852256, 32.477241}, {-85.85444799999999, 
      32.474976}, {-85.862588, 32.476388}, {-85.874574, 
      32.472355}, {-85.87406, 32.468707}, {-85.877337, 
      32.466446999999995`}, {-85.878481, 32.459164}, {-85.882316, 
      32.455084}, {-85.878005, 32.450505}, {-85.889437, 
      32.447378}, {-85.899194, 32.450162999999996`}, {-85.917113, 
      32.451167999999996`}, {-85.93067099999999, 
      32.454426999999995`}, {-85.94377899999999, 32.444468}, {-85.95521, 
      32.440878999999995`}, {-85.961169, 32.443185}, {-85.963842, 
      32.449577}, {-85.97522, 32.454186}, {-85.97957199999999, 
      32.453295}, {-85.980676, 32.450566}, {-85.974187, 
      32.44598}, {-85.97747299999999, 
      32.441894999999995`}, {-85.98346599999999, 
      32.439189}, {-85.98939899999999, 32.445594}, {-85.989896, 
      32.452886}, {-85.992072, 32.452439999999996`}, {-85.994265, 
      32.449261}, {-85.996464, 32.44517}, {-85.99001299999999, 
      32.434661999999996`}, {-85.99330599999999, 32.429209}, {-85.999837, 
      32.42696}, {-86.008515, 32.428821}, {-86.016165, 
      32.421108}, {-86.023232, 32.419771}}, CompressedData["
1:eJwt1Xk0lGscB3CXmyVMlmRKEbpJOZmKslSeYzQnkSy9dnWztrim5GabkJBh
SCprtkJnkqGiuEVvIkuibIdCXSpdpKLFLdX9zjn3j/fM+ZzfMs9znt/zvtre
XEc/SQkJCS4e8a8WQ+Ui7wRFnwvYw7htTIhk9Oy/72CelS1/xUZCdlTvavaJ
pegTv7lcm0VcMeiQfCesmz/pz4GNefITD+DHxCDX1IiQoo/xaTOw4oiU+Y8N
hAgUhyYXxFH09dzF3/cjnv/2icYUvFV6jV01HKLtHB0XT9G7U1tHfqBfmjWn
owHObJkX8B5W48sdnIUNbcyNM2HVmwWCDwkU/cuwpFwS/OL2Iw29UxR9eyKw
xQKWImqbgmDfZs7yPfBYE7/iGCwYSKeUsZ8C5ydaOfDnyVrbnXBTikd7J2zj
lmDSh3wlszcqjESKXqDHyhN7vWn1Bls4uWR7vQryDywWftkNq3YtOWkHR5ls
T5xG/bPAq42bNxEyN1xq8Q2OX3Ej4hSc+IlTzkK+y0TjqzDYqL8nXFwvXr4W
7NlcMzICO0ctFijDKkpnD2vzKTrS3zomB/3bjHI8BXCtY2esPVxu12E/CPe1
iKoE8PCRpNSX8AU6xP0W6i8Fq1YbJVH0ngD2j2z4nUN0XQM8wRfJW5gQ0t+3
66dbMkXLrNj33A5uU5U1b4LPZBUmcJH/vsjKRlNA0euqzEzZsJz6tGwQvPQc
q/szfDgytvEYzPSQDbZHva3dWwUneJmwfiYZdm1tnpKEy8ZfhebAXqya16no
n23dI7/VlJAvP6Tf9sKJ3tPSWXBArka3KvJL3+51O2BGiNC/z5HA+u2RF8QW
1KnvrYIXj7iq30K+4aKEln8E/+8XHsrc8EwthaIP+UzGZSI/tM5oWwzsNciR
CjPH/ta5DUbD4UulZ1w2E/I0KJabAzc+7K69CB+eCMofh9V+hlrFw78K1nIZ
qRTtKuEkzYCZrs0f2LDuWomULvTz/CnqvACPNpxIM0B8n4Py5bPwyua8rnuw
2tzGxjB433qKtXoLIcqL1I6YwYz+3pf6cPO26sRVcFz2zWg/2N1fOakc9nsR
kyHaSsj3+uiZEVidbfpE7IfWq45rn8Z+N1ys2gRfKKoZ3QmferpREAvXs7JX
M+HkRYV/GFsQwvXjd6yHvdfsd/eGlYUH1LvhHZ0fVXzgcU+HHbJpmO/rBlmz
MLN9r/ZR+EFC0GcZgvmzNb6RAQep50zgepI8797l7fDyCMeVuA6kYGyXRi/s
8TjSRxaOtl7tJI4bxss8EqGf36Ki/vlncD+ihAWb4E82jR5jiJeyL48NYb33
/p6nLIQr2+Lb7sJ/xYusCuG+1JGlf8JbK0fvEtQbcLwOvdvy//nDd5wtQ60R
Z8y8mtcPJ5W11a+BfUUKVxTTKdpNpbA0A/kGtUlNXNiTmytUgpt2f5ULgOv4
2qbZOJ/VLZ0cEaw5JJucBHfMHWQonaXoawtbXSSRT76u3HkSZm659fg8+t80
LFSfgrtMet41wNO6UU1LzlH0jCiC3gzHHA8Zb0PcKa0gxRP11wwHwirhB4PV
cTz05/XsrRDbooH1eyvmR3qVovF81PP0/OuYmNdiYX67BawvJVMVgnk+qhRS
dQWelhsI14Cjvpkd7oAbM/k6xbhPY1xLbUl41P6uvAfu47EvEkOZ6O+eh8nA
Aek+TRXehtWCS/LnwfV9JZw38ID0FMnDgRYuLB+UR/2OCKa72MGBW9gmMHuJ
mskA7MjjWR6Dfdu9bFpQ3z+lWfgNFr8udPC+yfMte6ifgX7nM85E4P+vKxy5
mgx7hlzvEXvsm/BDF2x5znC/NtzXzH4+lEnRfPJpgQ58+TStFZVF0aw76S9r
0W+ZoF8vJhvzMnU+vAyu0LkklQ7XaMZPOMAlfsXDTjAvIvBhDNYjHguxDYvv
s5nwFfGHB54xUXhdgfW/yC3tZORQdK/WPmYlPHc/Q3MnfBrjFQL/Bx//J4w=

      "], {{-86.412803, 32.707262}, {-86.41193899999999, 
      32.504114}, {-86.410957, 32.409804}}, {{-87.81260499999999, 
      32.524798}, {-87.81576199999999, 32.518383}, {-87.818473, 
      32.517896}, {-87.823411, 32.520572}, {-87.824114, 
      32.530131}, {-87.822535, 32.533339}, {-87.817143, 
      32.536135}, {-87.81662999999999, 32.537963}, {-87.822717, 
      32.544271}, {-87.8249, 32.544700999999996`}, {-87.844523, 
      32.547202999999996`}, {-87.853544, 32.533884}, {-87.852969, 
      32.532069}}, {{-87.472135, 32.83065}, {-87.471609, 
      32.743221999999996`}, {-87.47360599999999, 
      32.728176}, {-87.47381299999999, 32.656214}, {-87.52500599999999, 
      32.655764}, {-87.525155, 32.582882}, {-87.525137, 
      32.581514999999996`}, {-87.52440299999999, 
      32.482208}}, {{-87.81260499999999, 32.524798}, {-87.728313, 
      32.524375}, {-87.72873299999999, 32.481089}, {-87.52440299999999, 
      32.482208}}, {{-86.410957, 32.409804}, {-86.425624, 
      32.402069}, {-86.43811199999999, 32.400254}, {-86.444626, 
      32.399802}, {-86.456023, 32.406186}, {-86.46036699999999, 
      32.404821}, {-86.460912, 32.401631}, {-86.458743, 
      32.395707}, {-86.46254599999999, 32.389329}, {-86.462009, 
      32.377938}, {-86.466895, 32.374294}, {-86.471238, 
      32.371106}, {-86.47558099999999, 32.364727}, {-86.47937999999999, 
      32.364272}, {-86.485348, 32.367463}, {-86.49131799999999, 
      32.365185}, {-86.492404, 32.358806}, {-86.489149, 
      32.350148}, {-86.49132, 32.345591}, {-86.49783, 
      32.344225}}, {{-85.434175, 32.409836}, {-85.43407599999999, 
      32.376571}, {-85.434043, 32.257168}, {-85.433264, 
      32.234370999999996`}}, {{-86.91668399999999, 
      32.664176999999995`}, {-86.920468, 32.658697}, {-86.918808, 
      32.653694}, {-86.91548499999999, 32.643229999999996`}, {-86.911605, 
      32.630036}, {-86.912083, 32.617281}, {-86.906593, 
      32.608191}, {-86.902698, 32.591350999999996`}, {-86.89988799999999, 
      32.573596}, {-86.89872199999999, 32.558113}, {-86.90357399999999, 
      32.549441}, {-86.905147, 32.538047}, {-86.901322, 
      32.534416}, {-86.902931, 32.529855}, {-86.89692699999999, 
      32.52532}, {-86.89363, 32.518499}, {-86.88978399999999, 
      32.510312}, {-86.890845, 32.504841}, {-86.883741, 
      32.497121}, {-86.880434, 32.487565}, {-86.884216, 
      32.482996}, {-86.880397, 32.47982}, {-86.873835, 
      32.471185999999996`}, {-86.870537, 32.462996}, {-86.868884, 
      32.457989999999995`}, {-86.863997, 32.458461}, {-86.86181499999999, 
      32.456646}, {-86.860163, 32.45164}, {-86.861239, 
      32.449358}, {-86.86609899999999, 32.442963999999996`}, {-86.866621, 
      32.438406}, {-86.866073, 32.437497}, {-86.864452, 
      32.439324}, {-86.85793699999999, 32.439800999999996`}, {-86.856844, 
      32.438437}, {-86.849783, 32.438459}, {-86.839976, 
      32.431199}, {-86.830736, 32.429404}, {-86.824199, 
      32.424411}, {-86.827985, 32.420755}, {-86.836128, 
      32.420276}, {-86.842635, 32.417978}, {-86.84587499999999, 
      32.413868}, {-86.845857, 32.409766999999995`}, {-86.842006, 
      32.397932}, {-86.832194, 32.388393}, {-86.829999, 
      32.382475}, {-86.82618099999999, 32.37793}, {-86.81747899999999, 
      32.373398}, {-86.807096, 32.354744}, {-86.809231, 
      32.345625}, {-86.814638, 32.341052999999995`}}, {{-85.918945, 
      32.274375}, {-85.898887, 32.274725}, {-85.898832, 
      32.282016999999996`}, {-85.898657, 32.305258}, {-85.893805, 
      32.301587}, {-85.886791, 32.296991999999996`}, {-85.878687, 
      32.293301}, {-85.871183, 32.282322}, {-85.872924, 
      32.267748}, {-85.875726, 32.255914}, {-85.87527, 
      32.244973}, {-85.86557499999999, 32.237626999999996`}, {-85.854784, 
      32.232096}, {-85.72691999999999, 32.233115999999995`}, {-85.677072, 
      32.233675999999996`}, {-85.662446, 32.233568}, {-85.590938, 
      32.233015}, {-85.58389, 32.233413999999996`}, {-85.468476, 
      32.234698}, {-85.44897399999999, 32.234518}, {-85.433264, 
      32.234370999999996`}}, {{-85.410079, 32.14663}, {-85.421984, 
      32.146744}, {-85.42739499999999, 32.146796}, {-85.428282, 
      32.161392}, {-85.432375, 32.219777}, {-85.43232599999999, 
      32.223423}, {-85.43328199999999, 32.233004}, {-85.433264, 
      32.234370999999996`}}, {{-87.072946, 32.579688}, {-87.08160199999999, 
      32.572811}, {-87.080457, 32.565073}, {-87.079876, 
      32.560065}, {-87.07658599999999, 32.556438}, {-87.078679, 
      32.545038}, {-87.083514, 32.536814}, {-87.08731, 
      32.535427999999996`}, {-87.09053899999999, 
      32.530854999999995`}, {-87.09321399999999, 32.524919}, {-87.097533, 
      32.520797}, {-87.100186, 32.512127}, {-87.10228099999999, 
      32.501638}, {-87.10769599999999, 32.498875}, {-87.10981799999999, 
      32.49203}, {-87.11142799999999, 32.489288}, {-87.11630799999999, 
      32.487895}, {-87.159786, 32.487649999999995`}, {-87.22119699999999, 
      32.487276}, {-87.233671, 32.484463}, {-87.37495799999999, 
      32.483004}, {-87.422784, 32.483081}, {-87.422394, 
      32.355503}, {-87.42232, 32.349123}, {-87.42130499999999, 
      32.308116999999996`}, {-87.472816, 32.307686}}, {{-87.472816, 
      32.307686}, {-87.505355, 32.307857}, {-87.52378499999999, 
      32.307235999999996`}, {-87.525257, 32.37968}, {-87.523285, 
      32.395191}, {-87.52440299999999, 32.482208}}, {{-87.852969, 
      32.532069}, {-87.844223, 32.529438999999996`}, {-87.841436, 
      32.525372}, {-87.842959, 32.518975}, {-87.852683, 
      32.515215}, {-87.866304, 32.516874}, {-87.878343, 
      32.521285}, {-87.891942, 32.521574}, {-87.897954, 
      32.523322}, {-87.905549, 32.522317}, {-87.91846699999999, 
      32.514866999999995`}, {-87.930708, 32.500133999999996`}, {-87.945225, 
      32.491293}, {-87.954139, 32.473409}, {-87.96269, 
      32.465553}, {-87.974499, 32.457654}, {-87.994563, 
      32.455569}, {-88.006867, 32.445381}, {-88.02196099999999, 
      32.439256}, {-88.03163099999999, 32.433657}, {-88.038533, 
      32.425360999999995`}, {-88.04204299999999, 
      32.410275999999996`}, {-88.04427199999999, 32.385182}, {-88.046345, 
      32.380141}, {-88.045715, 32.375592}, {-88.041854, 
      32.372454999999995`}, {-88.0212, 32.370911}, {-88.016825, 
      32.369147}, {-88.00684299999999, 32.357887}, {-87.99362599999999, 
      32.347581}, {-87.985404, 32.343132}, {-87.970784, 32.34469}, {-87.96692,
       32.341094}, {-87.964057, 32.332927999999995`}, {-87.952051, 
      32.328981}, {-87.947638, 32.324936}, {-87.942025, 
      32.314524999999996`}, {-87.930565, 32.310569}}, {{-87.47175299999999, 
      32.264854}, {-87.472816, 32.307686}}, {{-85.410079, 
      32.14663}, {-85.37001699999999, 32.147603}, {-85.343502, 
      32.147335}, {-85.257977, 32.148249}, {-85.259692, 
      32.142341}, {-85.254359, 32.137268}, {-85.247389, 
      32.133088}, {-85.237759, 32.126142}, {-85.233547, 
      32.1188}, {-85.22884499999999, 32.108261999999996`}, {-85.225723, 
      32.100476}, {-85.218239, 32.09492}, {-85.209616, 
      32.092998}, {-85.20376399999999, 32.087004}, {-85.195728, 
      32.082352}, {-85.193113, 32.07685}, {-85.193232, 
      32.069556999999996`}, {-85.18145899999999, 
      32.062124}, {-85.11765299999999, 32.062728}, {-85.113329, 
      32.062674}, {-85.11267, 32.069506}, {-85.104553, 
      32.069860999999996`}, {-85.10521299999999, 32.06303}, {-85.096564, 
      32.062923}, {-85.06520499999999, 32.062984}}, {{-87.930565, 
      32.310569}, {-88.225532, 32.307364}, {-88.420812, 
      32.308772999999995`}}, {{-85.918945, 32.274375}, {-85.98617, 
      32.272421}, {-85.986182, 32.270598}, {-85.986311, 
      32.250546}, {-85.999318, 32.250147999999996`}, {-85.99708199999999, 
      32.088775999999996`}, {-85.996641, 32.072817}, {-85.996776, 
      32.05139}}, {{-86.190609, 31.966825999999998`}, {-86.301844, 
      31.964796999999997`}, {-86.303251, 32.051429999999996`}, {-86.312439, 
      32.051902}, {-86.315682, 32.051907}, {-86.405951, 
      32.050651}}, {{-86.49783, 32.344225}, {-86.49674499999999, 
      32.340579}, {-86.48915099999999, 32.340123}, {-86.482098, 
      32.339666}, {-86.484269, 32.33511}, {-86.4821, 32.333287}, {-86.476134, 
      32.331463}, {-86.478848, 32.324172}, {-86.481561, 32.317793}, {-86.4859,
       32.313691999999996`}, {-86.48644399999999, 
      32.307767999999996`}, {-86.490782, 32.302755}, {-86.48752999999999, 
      32.297287}, {-86.486447, 32.290451}, {-86.48428, 
      32.283159}, {-86.480487, 32.275411}, {-86.4729, 32.271763}, {-86.465311,
       32.273128}, {-86.456638, 32.273581}, {-86.449597, 
      32.26583}, {-86.44147099999999, 32.260358}, {-86.430635, 
      32.258528}, {-86.42359499999999, 32.253054999999996`}, {-86.423058, 
      32.248041}, {-86.417643, 32.244847}, {-86.40843199999999, 
      32.244839999999996`}, {-86.40843799999999, 
      32.238915}, {-86.40898299999999, 32.236181}, {-86.407943, 
      32.198806}, {-86.407947, 32.194704}, {-86.406441, 
      32.093506}, {-86.40645099999999, 32.084844}, {-86.406469, 
      32.0698}, {-86.405951, 32.050651}}, {{-86.85742499999999, 
      31.962124}, {-86.85883299999999, 32.035529}, {-86.856731, 
      32.048758}, {-86.866457, 32.048271}, {-86.87618599999999, 
      32.048238999999995`}, {-86.906454, 32.048133}}, {{-86.814638, 
      32.341052999999995`}, {-86.85038899999999, 
      32.3291}, {-86.85030499999999, 32.30996}, {-86.83728699999999, 
      32.309089}, {-86.825887, 32.305932}, {-86.837237, 
      32.297239999999995`}, {-86.844274, 32.294484}, {-86.847501, 
      32.28855}, {-86.857238, 32.283963}, {-86.86371199999999, 
      32.277105999999996`}, {-86.864232, 32.272090999999996`}, {-86.859873, 
      32.267092}, {-86.854411, 32.257538}, {-86.842986, 
      32.247091}, {-86.833738, 32.238459}, {-86.82397, 
      32.234386}, {-86.81530699999999, 
      32.235777999999996`}, {-86.81043799999999, 32.237614}, {-86.810389, 
      32.224852999999996`}, {-86.908436, 32.224996}, {-86.908299, 
      32.198105}, {-86.906454, 32.048133}}, {{-85.996776, 
      32.05139}, {-85.995548, 31.98892}, {-85.99560199999999, 
      31.980256999999998`}, {-85.995139, 31.967942999999998`}, {-86.006481, 
      31.967537999999998`}, {-86.190609, 
      31.966825999999998`}}, {{-87.23614599999999, 32.105274}, {-87.233941, 
      32.100729}, {-87.224161, 32.095777999999996`}, {-87.213332, 
      32.094479}, {-87.204127, 32.093168999999996`}, {-87.197578, 
      32.086372}, {-87.187845, 32.086431}, {-87.191559, 
      32.078202}, {-87.190979, 32.073647}, {-87.184452, 
      32.069128}, {-87.176833, 32.063247}, {-87.176768, 
      32.055496999999995`}, {-87.17832399999999, 32.047736}, {-86.906454, 
      32.048133}}, {{-85.65911799999999, 31.880198999999998`}, {-85.666125, 
      31.880708}, {-85.759441, 31.880449}, {-85.77239, 
      31.880077}, {-85.790724, 31.880651}, {-85.79109, 
      31.900263}, {-85.790961, 31.914855999999997`}, {-85.790804, 
      31.93264}, {-85.79000599999999, 31.96182}, {-85.789958, 
      31.967291999999997`}, {-85.883911, 31.967388999999997`}, {-85.883799, 
      31.98198}, {-85.886499, 31.981994999999998`}, {-85.88865899999999, 
      31.982007}, {-85.888607, 31.988846}, {-85.892924, 
      31.989324999999997`}, {-85.89289, 31.993885}, {-85.892842, 
      32.000268}, {-85.893563, 32.047689999999996`}, {-85.91140299999999, 
      32.047329}, {-85.911349, 32.054624}, {-85.95026999999999, 
      32.054364}, {-85.94968, 32.061656}, {-85.954004, 
      32.061676999999996`}, {-85.95402899999999, 
      32.058029999999995`}, {-85.958354, 32.058051}, {-85.95837499999999, 
      32.054859}, {-85.96324299999999, 32.054427}, {-85.96226, 
      32.039833}, {-85.979013, 32.039911}, {-85.97948, 
      32.051311999999996`}, {-85.983807, 32.050875999999995`}, {-85.98383, 
      32.047228}, {-85.992475, 32.047723}, {-85.99245499999999, 
      32.050914999999996`}, {-85.996776, 32.05139}}, {{-86.447627, 
      31.964503999999998`}, {-86.74998099999999, 
      31.961958}, {-86.85742499999999, 31.962124}}, {{-87.47175299999999, 
      32.264854}, {-87.47882, 32.266616}, {-87.492922, 
      32.267405}, {-87.50432599999999, 32.269127}, {-87.507577, 
      32.269098}, {-87.514046, 32.266306}, {-87.52366099999999, 
      32.25528}, {-87.522291, 32.148175}, {-87.522093, 
      32.132677}, {-87.623819, 32.132621}, {-87.623532, 
      32.112109}, {-87.623199, 32.088405}, {-87.623567, 
      32.076091}, {-87.623542, 32.074268}, {-87.62258399999999, 
      32.005884}, {-87.667912, 32.002231}, {-87.667752, 
      31.991289}}, {{-88.073403, 31.990454}, {-87.994514, 
      31.989248999999997`}, {-87.834113, 
      31.990807999999998`}, {-87.76333699999999, 31.989801}, {-87.667752, 
      31.991289}}, CompressedData["
1:eJwd03tQVHUUB/AFdoFlFRheGwjCEgiIwO6M0IAERxBRRhRoWItHssJSAoUK
SODQLgEu5LYGhaCpA5SkvJQNSGLAC/LYkTBLE1GC2h6szlKagiEP++Ifd+58
5nd+53d+59wr2J8dJzVksVg78ay+38yRp6gW45n91qe6GQ+iPtsKbgYsHG/g
vAu/XxoRcQaOkPAjLDYQmZcseKfBSt9s83E3ouyNcZIs+CYv31cJp1TuCx2E
E+4spwrgXwq0gYlL8YwLHVM5wdEbHTJlsPBxZOw7sP6jfv98WG9NIjUc4iwd
5MD2e5Mcq92JNB0Bn8wi3zcp2hMNON89z/C0KdZFbz9pugH7vZKUEwl7zRzv
5aNebmxfXRm8Y3Oxqx0sePG9S8hyPKO4Xy8RIT7KVPzzKHz9498esuA/ol7n
ha3EM5eNZpSeiP/glOTLFrh4ZuqaO5zwxfB8wot4Zuva6YHvUI8giK1is8SM
3tZucrUf6XKeWgrr/J6W/4j19tJO0RF4YOF2exTcOhcRlginK/5T+MC7RCZb
I2FlcZ5jKO573lLjroKNpQ7RvvAGfmqKk4GYCRbKH9XDWZc4va/Bvz6eTS6B
97APrd8NO99Z1zngSvTVSmEZB96TpNrrAscc77/WgXxmxUlajYDo4o6y9jJY
XaRJbHMhatxm1auEFQv/Guqdif5ZamAvw4u5wel164kcplr6F+HVazrAh6+G
x9bBfhnPmllORBPVJysL4Yetxa1WjkRJTT/ZjcMLvdGyeXsi7Uhtz0l41MtA
xIWHJ3LZB+HAGm2Tmk80Gz51eA5e4xp3y9cG8wg5wvdE/fYGtioXa/Q3Rxrz
HjwrvX8g04pop2WbPMxQzNjorAuqYG2Ox10ZrCvbwt8OHzXfFKmBlVdYm6Ms
MK9ufq2tkZhhG5k6R5kTGZ7rOPgWfL5kTma+lsifO/XpdjgzVV9as4ao4kFY
ywr2u9qJ9ELYu6/+0QTsLUzLa+YRvfzO4aeDOV1yMyIfoxtx6tX8jmHVp7lE
QX8Fp+5ji5n8yOGMJyZE7EBPSSM8OHYxjWWKeTOXKt04YmbyytDSJPyZwz1W
Fvy3TtZth/29sd67puGiqi1ZrrDi2NCFTGMxc9Mz+XkN4n1P+L9aYiJmquW1
pTzkHxeG/14Bf10w4hVkTDQW3N1I8NmeZL9oDvpt03IoAO4TsVkjbKKhXIFY
BrdodHI3QyKTsbaj3nDytKKklEXU0/VtYhXOy75tduvZSiiVSxSiB6gH3d8m
hK92ffj8B9iiMKA55EUoye5d2G2C+LlNpn8WYf/LuWN9/jLf7C5cyASnXYeN
z1oG6WAPC15nI+zDjXljFP5cWp6aDEvKz/SdQ74D62QNavQLf3+aajmU/gcT
ruhR
      "], {{-86.85742499999999, 31.962124}, {-86.908715, 
      31.961494}, {-86.90856099999999, 31.931397999999998`}, {-86.908012, 
      31.929575999999997`}, {-86.906971, 31.830614999999998`}}, {{-86.906971, 
      31.830614999999998`}, {-87.116644, 31.828747999999997`}, {-87.119339, 
      31.828733}, {-87.214204, 31.828169}, {-87.232563, 
      31.831699999999998`}, {-87.34414, 31.830917}, {-87.351686, 
      31.830859999999998`}, {-87.396414, 31.8296}, {-87.50099, 
      31.829628}}, {{-87.667752, 31.991289}, {-87.666615, 
      31.875922}, {-87.635875, 31.876237}, {-87.621231, 
      31.870454}, {-87.620088, 31.827135}, {-87.559178, 31.82727}, {-87.50099,
       31.829628}}, {{-88.073403, 31.990454}, {-88.06624, 
      31.983257}, {-88.074259, 31.979041}, {-88.075807, 
      31.975371}, {-88.075169, 31.970364}, {-88.069583, 
      31.960865}, {-88.070618, 31.958569999999998`}, {-88.079156, 
      31.953433999999998`}, {-88.081324, 31.95386}, {-88.08908, 
      31.963783999999997`}, {-88.096665, 31.965044}, {-88.100957, 
      31.963614999999997`}, {-88.122805, 31.949164}, {-88.11665599999999, 
      31.938762999999998`}, {-88.115037, 31.938786999999998`}, {-88.108616, 
      31.941615}, {-88.103758, 31.941684}, {-88.096021, 
      31.932672999999998`}, {-88.090408, 31.921806999999998`}, {-88.086119, 
      31.923236}, {-88.06857099999999, 31.936708}, {-88.06532399999999, 
      31.936297}, {-88.054345, 31.926872}, {-88.057998, 
      31.920436}, {-88.070471, 31.923454999999997`}, {-88.075318, 
      31.922931}, {-88.083762, 31.913235}, {-88.088573, 
      31.910887}, {-88.104739, 31.909744999999997`}, {-88.117074, 
      31.905918999999997`}, {-88.126803, 31.906691}, {-88.129984, 
      31.903907999999998`}, {-88.13444, 31.884231}, {-88.143672, 
      31.860833999999997`}, {-88.156508, 31.855628}, {-88.16015999999999, 
      31.849643999999998`}}, {{-86.906971, 31.830614999999998`}, {-86.906041, 
      31.753076}}, {{-85.41613199999999, 31.619457999999998`}, {-85.491389, 
      31.620617}, {-85.69142099999999, 31.618133999999998`}, {-85.72959, 
      31.618402999999997`}, {-85.747873, 31.618070999999997`}}, {{-85.747873, 
      31.618070999999997`}, {-85.789272, 31.617884999999998`}}, {{-85.789272, 
      31.617884999999998`}, {-85.85055799999999, 31.618257}, {-85.865073, 
      31.61834}, {-85.983344, 31.619404999999997`}, {-86.145714, 
      31.617755}}, {{-86.190609, 31.966825999999998`}, {-86.184715, 
      31.955409999999997`}, {-86.18152599999999, 
      31.942632999999997`}, {-86.175637, 31.93076}, {-86.17731599999999, 
      31.915716}, {-86.17682599999999, 31.903402}, {-86.172553, 
      31.892901}, {-86.177433, 31.886529999999997`}, {-86.18018099999999, 
      31.873769}, {-86.18345699999999, 31.863743999999997`}, {-86.1835, 
      31.852798999999997`}, {-86.186222, 31.845965}, {-86.183022, 
      31.83729}, {-86.191164, 31.822718}, {-86.198764, 
      31.808142999999998`}, {-86.198831, 31.790354999999998`}, {-86.148184, 
      31.79112}, {-86.146681, 31.765114999999998`}, {-86.146541, 
      31.674332999999997`}, {-86.14712899999999, 31.662929}, {-86.158975, 
      31.660228}, {-86.160085, 31.652019}, {-86.16496599999999, 
      31.642452}, {-86.16982999999999, 31.636535}, {-86.174686, 
      31.632443}, {-86.179013, 31.626068}, {-86.179591, 
      31.616031999999997`}, {-86.145714, 31.617755}}, {{-85.789272, 
      31.617884999999998`}, {-85.789254, 
      31.497867999999997`}, {-85.78878499999999, 
      31.490105999999997`}}, {{-86.193699, 31.439919}, {-86.19415099999999, 
      31.462284999999998`}, {-86.19443199999999, 
      31.529829999999997`}, {-86.156302, 31.530175999999997`}, {-86.156808, 
      31.537478999999998`}, {-86.14391599999999, 31.537895}, {-86.145714, 
      31.617755}}, {{-86.701909, 31.525045}, {-86.498926, 
      31.525228}}, {{-85.09089499999999, 
      31.308640999999998`}, {-85.17929099999999, 
      31.307440999999997`}, {-85.24941299999999, 31.310076}, {-85.320612, 
      31.312678}, {-85.323825, 31.312711999999998`}, {-85.369328, 
      31.314552}, {-85.373077, 31.31459}, {-85.41752799999999, 
      31.315030999999998`}}, {{-85.41613199999999, 
      31.619457999999998`}, {-85.415842, 31.561045}, {-85.415476, 
      31.548263}, {-85.41538, 31.515403}, {-85.41504599999999, 
      31.500339}, {-85.416916, 31.400851999999997`}, {-85.41657, 
      31.386696999999998`}, {-85.41752799999999, 
      31.315030999999998`}}, {{-85.487926, 30.996456}, {-85.485608, 
      31.053994999999997`}, {-85.485253, 
      31.125245999999997`}, {-85.48594299999999, 
      31.198324999999997`}, {-85.553344, 31.197547999999998`}, {-85.710613, 
      31.195121}}, CompressedData["
1:eJwt1Hs0FdgeB/DjdedclEEKmaRCQw7HeLvaW3Ez5c05QuSRRw8xjRxxKZm8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      "], {{-85.710613, 31.195121}, {-85.79136299999999, 
      31.196122}}, {{-85.78940899999999, 31.358196}, {-85.790193, 
      31.329895999999998`}, {-85.791387, 
      31.254569999999998`}, {-85.79136299999999, 31.196122}}, {{-86.193699, 
      31.439919}, {-86.192953, 31.212566}, {-86.193007, 
      31.198411}, {-86.193033, 31.191561}}, {{-87.50099, 
      31.829628}, {-87.50079199999999, 31.813665999999998`}, {-87.518048, 
      31.814422999999998`}, {-87.51603399999999, 
      31.697657999999997`}, {-87.566616, 31.697188999999998`}, {-87.5662, 
      31.625103}, {-87.565254, 31.553469}, {-87.584963, 
      31.540957}, {-87.599277, 31.527126}, {-87.614786, 
      31.522409}, {-87.620111, 31.519160999999997`}, {-87.621659, 
      31.514581999999997`}, {-87.62001699999999, 31.512316}, {-87.605352, 
      31.500138999999997`}, {-87.567548, 31.483162999999998`}, {-87.562646, 
      31.477732999999997`}, {-87.563008, 31.464492999999997`}, {-87.574406, 
      31.433802}, {-87.590867, 31.421318}, {-87.594534, 
      31.414890999999997`}, {-87.59984, 31.410731}, {-87.61052, 
      31.407429999999998`}, {-87.622361, 31.410507}, {-87.63918799999999, 
      31.424944}, {-87.64403399999999, 31.426263}, {-87.654224, 
      31.426159}, {-87.665447, 31.423302999999997`}, {-87.686657, 
      31.406646}, {-87.704296, 31.402804999999997`}, {-87.713157, 
      31.385818999999998`}, {-87.72583499999999, 31.373354}, {-87.721876, 
      31.359702}, {-87.72219899999999, 31.345546}, {-87.723208, 
      31.341426}, {-87.72903199999999, 31.336796}, {-87.73861199999999, 
      31.332580999999998`}, {-87.743968, 
      31.332521999999997`}, {-87.75152399999999, 
      31.33609}, {-87.75372999999999, 31.340173999999998`}, {-87.753801, 
      31.344738}, {-87.75185599999999, 31.357543}, {-87.755156, 
      31.362985}, {-87.75947099999999, 31.364762}, {-87.764808, 
      31.363332}, {-87.766359, 31.359662}, {-87.765102, 
      31.347807}, {-87.76772299999999, 
      31.344123999999997`}, {-87.78254299999999, 31.332541}, {-87.784607, 
      31.327495}, {-87.781639, 31.309265999999997`}, {-87.777276, 
      31.304294}, {-87.768109, 31.300289}, {-87.76484599999999, 
      31.29713}}, {{-87.61577899999999, 31.244386}, {-87.61039699999999, 
      31.242157}, {-87.594326, 31.240945999999997`}, {-87.584111, 
      31.237392999999997`}, {-87.573866, 
      31.231555999999998`}, {-87.55991999999999, 
      31.228949999999998`}, {-87.54709199999999, 
      31.229983999999998`}, {-87.537003, 31.236015}, {-87.53116399999999, 
      31.239721999999997`}, {-87.525341, 31.244798999999997`}, {-87.515214, 
      31.248088}, {-87.50187, 31.250949}, {-87.493882, 
      31.254216999999997`}, {-87.489662, 31.259276999999997`}, {-87.427048, 
      31.260271999999997`}}, {{-87.946134, 31.192636}, {-87.94489399999999, 
      31.183061}, {-87.946911, 31.176184}, {-87.940285, 
      31.164395}, {-87.942374, 31.161628}, {-87.952004, 
      31.161959}, {-87.961058, 31.160014}, {-87.96859099999999, 
      31.162654999999997`}, {-87.972867, 31.162599}}, {{-86.700015, 
      31.193631}, {-86.70000999999999, 31.191805}, {-86.70007199999999, 
      30.999976999999998`}, {-86.688335, 30.999996999999997`}, {-86.688324, 
      30.995428999999998`}}, {{-87.972867, 31.162599}, {-87.973435, 
      31.164417999999998`}, {-87.989104, 31.173344}, {-88.022244, 
      31.144121}, {-88.260103, 31.143351}, {-88.329602, 31.1436}, {-88.330012,
       31.114359}, {-88.43046799999999, 31.11403}}, {{-87.61577899999999, 
      31.244386}, {-87.615813, 31.169036}, {-87.615719, 
      31.162187}, {-87.61541799999999, 31.140268}, {-87.61578899999999, 
      31.128389}, {-87.61599799999999, 31.065811}, {-87.61559199999999, 
      30.997290999999997`}, {-87.599581, 
      30.996993999999997`}}, CompressedData["
1:eJwV02lQU1cUAOCwWTYFMiaCQEghLLWsLkEcuPdUQSogsoW6BFDAbaDKJmqJ
ohRaKGobgUBVsNRY19JRkApICCCIoAkqe0Eh1qpTLWURSRHoyY83b7573z3n
vPPO+zh2f9hObQaDEYaX5v6cPZG6bk4glwvz2T99QuFspOFxIXpP+tA2sROF
luEdA57oXXVrbZwdKYS6xxn2zArkCSKHmZf2FCTCFpUnegVLJT6Edl6mSjv9
QSA343vXhzlQOJYZUOSEvsGcuC7F/RP+V7Id0V9+d8/vFo/CXOeDggT0z8Kl
Df/aUvAQWjOS0W+m3Ux1uRR2JFSPa+It3vbZE6YNBdelyzkXMd/Jh6cinllQ
8GXvVVljfW8/NXkcbo77gr35CeiMOnuv7UsoOJZV6mWjPYqONvWzKJSENI7o
ob3LJDa3mRTCeDEGUowXFRqgH2lGwYrnq87CfOFiwzgj9AzBFTT1XLnzkgmF
SbbJqJfmfQJe/xi9iELKN6pTnugGh4SudcYUmO+yNqWiDU3ORL03pPBqjyBw
DcZXBmwdW2hAQd3fdiAcXfcVy8Jan4Je4AEtN03+p1YV3QsocB2DzB/i+en8
/tMCPezPaK5hN/pgbE9+uS6FQN2rmab4vNr1oquFDoUJm8f7Y9Crti6aDEG7
cKs4MnTQqkqJtjYFJ+P2lWfQw32VL5drUYhPZ9dr8rPuQq+MQSHHnhPCR0sK
65RjswSq+zfnHUabLf9hd/EMgXaPLYOZaIvQAUuRmoBRifzXOvTlTSnfbpwm
0PvOKL0ZfYF7SJTxnoDDpi0be7FerqLZIAidet5KLxfdkyTOqJ0ioN1Nc+PR
vcGF2b7o3Q7milXolrbTXpIJAmv124pDZgTy2im9yaYxApfojNgWnSlz2Xx1
lMARnQJLP/RQenlNMHoh/wCHhec7eTekg28JmNpapCSin+7bsKgP7bP+8F8v
0ISeMOWgDVhW0Zr+ZfRgx94QsHPv8XRHe2sG/jWB6dwS5gZ0jOgRx+0VgUMG
wUe4OC/zjITuihcELnjdHO9Au200G55UEcApznWaF8ibdrL4OsME9rnOVTui
d2kG4RkBt/KsZiP06tL4ax1DBBLt04rv4vmbziXTFwYJfJ1TsFLT39Qsvpdo
gMCfAyEeCqy3tFs7I6iPACPS/1Qaemlepz6/h0Dt+6T7mv9jSviLQ+MTAn6f
Dylkmv42OVelPiYgrrI88gDj8TQf9BGBP4K32WVhvt1doiJRJ4G3/2jVumE9
L+znCxqUGD/pTX8qOk6YnByhIDBSNewXgx6RfC+VdhAovLPm3jF0/RyPHGwn
IB0prFGjlV1/s4/fJ3ClIXpHIyNS7jPamtXURsCy2qU9UStSnpJnZ+LbSsA/
TVm7Hm3xhdCqqJnA9uTVE9fQ+irvc3I5AePrz6fL0bHLZrMrGwiM8vefW4wO
Lwx8vkRGYMHvt3JeYvzbLR8GO+8QOCpwjZhDp7vHnmfUEgg19ZbVo8t4USvU
1QSYATH6XmidB6KP6C0CNUlcnhE68eZ6H99KAlHyDmNLtHPxSYX6BoHLrYGe
eWiapyzd/huB/2BcUY4+e/liDauCwP8Q1HPx
      "], {{-86.193033, 31.191561}, {-86.193038, 31.190191}, {-86.193285, 
      31.124886999999998`}, {-86.19095999999999, 31.03353}, {-86.190966, 
      31.032159999999998`}, {-86.19001, 31.002921999999998`}, {-86.186808, 
      31.002913}, {-86.186843, 30.993775999999997`}}, CompressedData["
1:eJwV0ns01nccB3CUGIrHXHJ54pk5yXkcd5bb95v79mB4zm9hbS13zSXVw8jD
RJc5imzRiE1u0UScPZTMrynz1Fkph+SSyGRxbLmWHmtvf/zO77zO9/19n8/v
9/3ywpOCoxTk5OQEeDbe4h1VLov/Mqx2vZVEw49Q1RJmSO0Vwwb0xyjtExBq
PP+SiYSfNEbZGMJyv5w1/Bueipz8bA/yGR4TraIFhj3VGcimwEFdqp+3wpzg
ttYm+AV7OFdtkWH1bXbUaAYQWhk1RnTgN0tDxfKfEjqYr3ZYF75TP/g7P5DQ
AutUCx68SXS3yiCIUMmTkO/S4MZhe14jfLBzPPYPeF3DgH8R+cJvH/71J3zi
RU14BPo73I34EXBtaahA3p/QPOP73e/BR4tDc8Mx/3CvSHgX882sFPXEfkzo
ge3NU+bwl9FDZrM+hAoKatNtYP5c3Kkub0Lb/gnK6oRXvuDIkrwInVeuU7RE
n/ltk1cLnoTqx9Xf5C4xbGj893k9yEt7cixSYO+ZmJci9J1Mdjw9CGsYliQL
4eWbBqoqy/iejrQGD+RHtNe+0oO1n8v8zdDXb5Xh6Qcf44tnjrsT2s7V16mC
56Xd7o17CK0Z0bz+DH4cHWE6DVekV99KWGFYZaewgSLkvW78JCyEI+8tiPTg
XWHXdS/AsvipG7uQFzVkPPCFQxjLrn5K6KqzluIa+mrFR7KWYUHoyY8G4UzH
sRYP2F75SEcJ7GDsvm83IbQodVvU5Y35NfnbYtwIXV9WUZ2HJeKCtVlXQi0U
q9fV0T/afkc26kIotT2tPof1B5HvXLbCvEKBYRrsw+XuNXFGH9cg+xv42m/Z
0jNOhL5+Ov5zJxw30aJStpvQaZ7QbTP6dMbS/dWxXj6gcMwPdm3rO6+MvtaS
hLpG2DQlIakNrt5u/HDzKsMqBkiyneHJe56cYJjHaDW1YH9inP2H88g76jE4
GkLzKy/G7oV35lRNDdgTqqsRpr4fdjKqMO21wzzC5zVl8LitZiUHvnAw2kIR
fcsLzv7R8KDwStNVuK6hj/LRl+6oo7XlNc67aVZ3zoFQO/NDLVthE8F0yFP0
45YMjyO/yJXdlsd+iw/ypAZYZ6e8z/1qQ+i5/seL9vC8KHh/MXwlxd/3a9jP
WmmPjy2hOiPVl67Blpyk8ixYetkmvwNenAg9no++9pCgnLg3DBtTkiQOwTpL
aj75AY43qZiLRl/pxo+ALd/38h2D36Zocv6DpUZqLqvw+fLMQN013Hc35sQW
uPmom4sArnIc9Um0JrRP2eFqFqyQfb/aH/Ym+gE/wq6PnkkkVoRmTsqtiWGz
UqXmXktChXT4ndxbhk3usdoZC+eW5Zt3w6uHpMl1yF/qX0zkyxj2ln3qUhcs
2EQaDsCls3aPgtF/dqZCdAZ2V+4tCYT/B2rZO1Q=
      "], {{-87.76484599999999, 31.29713}, {-87.759513, 
      31.298561}, {-87.752545, 31.298181999999997`}, {-87.747191, 
      31.298243}, {-87.742421, 31.301492}, {-87.73548699999999, 
      31.303395}, {-87.72742799999999, 31.301658}, {-87.719402, 
      31.302203}, {-87.713505, 31.30181}, {-87.70589299999999, 
      31.294131}, {-87.70150199999999, 31.286873}, {-87.692347, 
      31.283319}, {-87.688492, 31.276054}, {-87.68358099999999, 
      31.269713999999997`}, {-87.67544, 
      31.262037999999997`}, {-87.66789399999999, 31.258464}, {-87.660316, 
      31.252606999999998`}, {-87.650103, 31.249516999999997`}, {-87.644733, 
      31.248202}, {-87.636648, 31.244175}, {-87.62968599999999, 
      31.243789}, {-87.61577899999999, 31.244386}}, {{-86.763616, 
      31.181168999999997`}, {-86.75989899999999, 
      31.189397999999997`}, {-86.755634, 31.193517}, {-86.747073, 
      31.192166999999998`}, {-86.74280399999999, 
      31.195373}, {-86.73906099999999, 31.195380999999998`}, {-86.736909, 
      31.191276}, {-86.73370299999999, 31.192196}, {-86.732091, 
      31.189459}, {-86.735834, 31.189451}, {-86.736896, 
      31.186708999999997`}, {-86.735824, 31.185798}, {-86.726734, 
      31.186273999999997`}, {-86.722455, 31.185826}, {-86.71870899999999, 
      31.184919999999998`}, {-86.716036, 31.184925}, {-86.720862, 
      31.189939}, {-86.719796, 31.191311}, {-86.706426, 
      31.19088}, {-86.70803599999999, 31.19316}, {-86.706436, 
      31.194989}, {-86.700015, 31.193631}}, {{-87.427048, 
      31.260271999999997`}, {-87.364958, 31.260315}, {-87.311971, 
      31.260714}, {-87.306084, 31.260755999999997`}, {-87.073786, 
      31.261281999999998`}, {-86.945326, 
      31.261412999999997`}, {-86.87199799999999, 
      31.261681999999997`}, {-86.764411, 31.261076}, {-86.765463, 
      31.255594}, {-86.772403, 31.250099}, {-86.77078499999999, 
      31.24645}, {-86.77238, 31.24325}, {-86.768619, 
      31.238692999999998`}, {-86.76804399999999, 
      31.226822}, {-86.76375399999999, 31.223636}, {-86.76374299999999, 
      31.22044}, {-86.772272, 31.211287}, {-86.771733, 
      31.209918}, {-86.765844, 31.208562999999998`}, {-86.76530199999999, 
      31.206280999999997`}, {-86.77224199999999, 31.202154}, {-86.767945, 
      31.196685}, {-86.762598, 31.197153999999998`}, {-86.765256, 
      31.192124999999997`}, {-86.762044, 31.191219}, {-86.764162, 
      31.184821}, {-86.76683299999999, 31.183901}, {-86.76682799999999, 
      31.182530999999997`}, {-86.763616, 31.181168999999997`}}, {{-86.763616, 
      31.181168999999997`}, {-86.764675, 31.17797}, {-86.76734499999999, 
      31.177049999999998`}, {-86.77216, 31.177951999999998`}, {-86.774293, 
      31.176119999999997`}, {-86.773746, 31.172468}, {-86.77961499999999, 
      31.168799999999997`}, {-86.78922299999999, 
      31.164665999999997`}, {-86.794579, 31.167392}, {-86.799926, 
      31.167377}, {-86.801508, 31.161436}, {-86.798816, 
      31.156419999999997`}, {-86.79559499999999, 
      31.152775}, {-86.79288199999999, 31.141364999999997`}, {-86.794468, 
      31.136794}, {-86.79713699999999, 31.135873999999998`}, {-86.802488, 
      31.137686}, {-86.80280599999999, 
      31.079680999999997`}, {-86.81775999999999, 
      31.079639999999998`}, {-86.81824, 31.065935999999997`}, {-86.850275, 
      31.065382}, {-86.854794, 30.999589999999998`}}, CompressedData["
1:eJwV03tMk1cUAHAQFApFEQcFoTxawLGKFJuOyKDnACEwtWKED3RzkQHKSCcD
XF1MoSJ0TFBwaEMRBDYhGeuQbp2tPHR+BEfGGEOWTBwDX8hDwmubIqLCTv+4
ufkl59x7zz33+qV9su/wGisrK6BhmcXqzc8nLjNsbm5S9uUVGYacjpd3klnb
7NH+VRkGPfnwIyVZW6fey7MGPJmpelpC3tLeHbjdBnAwojBWTX7/twEn+VrA
rmSO2xdkHre1vdEO8Bdj6qNzZL1J7DhrD7i++IUogyx46dtXxAFcG3rbFEKu
wY1n3B0Al6TnbR9+zbAuJda7Wsl/7zT095CN82UPTjoCau5060rJXspPD5Zz
Ad/ZVzDJIyvsK/ranADHRit/GP6KYfeeLoxpXg8YtbC02Eq+Ik9XBTsDpp9I
iUwla5wSDNqNgGmdqsK5BoY9Lo9XcF0AV6L8YyrIAU9qesM2Af66O+t1MFn+
T1uzmyugIj/w5WQ95cd5xrWQO+qnOhbI8j8jje1ugPHSmee3yA38nA9CebRf
2n+5R8ljkr8ggRye1yQRk7kThi8t8fmD3iFNdQybKHwqeUY+qOTrg8jh+1cn
xRQ/us50f/gSwy4NS3atcQd8NXJbW0eu2DFwV0feM933xx6yfGfUNYs9nzmX
z9UyrOEEk2kiF0wVLVeRVdsSLzzwADzVWy5QkHPsprVxnoDOyekci53HpIZp
L8Bx4+AOIE+nhPvU8wFjOx2CLB7lLB6a9AaMxp80DuRbghJ+jy+gTUTWQ2MN
w0oWAzw3CKje/OobH5Mbe3923y8E9Dg25PLvRYadafjGutgfsDtDn5pEFilq
H+UGAB5NLmg1V9P9iKtvRgcCXk26V5FD1jXf23yXLJRft4kgm7pKp4bIbO/b
OXZkdA3LDt0CeIbnGPNYx7Aer16nmd8EtFNtiskjH37RwV0NArxw9tLnkeRA
13LTTRFgYt+dZQH50PEEb7dtgAeGv20fqWJYs3p5oCYEUK+7n7Wd1pd3Vh/p
IAtPrasNJxvsV66dlwL+3kSdpvofaziNB8i2E36JMnLm/FnzW8H0fvxlnxVR
P3qOxOnntwKGlbVIteTZ2Kv8RDqvOkembKH+VvlVKHPJjeO4wUQWbW3zWaD4
7680rPz4HcNyLB/Bsp7pet4NcrQBSgdCAUUJvjNvtDDssYxxXZcYsMwnfe49
8lC8i0ZEFhaPxFaTUyoHrd8lZ86aHfvJ4wVe/ZWU/z+kFM6W
      "], {{-85.79136299999999, 31.196122}, {-85.847517, 
      31.196465}, {-85.92453599999999, 31.195975999999998`}, {-85.948602, 
      31.196098}, {-86.012788, 31.195027999999997`}, {-86.11654999999999, 
      31.19315}, {-86.116602, 31.182191}, {-86.125692, 
      31.182222}, {-86.125109, 31.192722999999997`}, {-86.193033, 
      31.191561}}, {{-86.498926, 31.525228}, {-86.400117, 
      31.527008}, {-86.40128299999999, 31.451705999999998`}, {-86.394843, 
      31.45307}, {-86.386786, 31.459450999999998`}, {-86.37818999999999, 
      31.466745}, {-86.37711, 31.471764}, {-86.373888, 
      31.473129999999998`}, {-86.370128, 31.474950999999997`}, {-86.365825, 
      31.480878999999998`}, {-86.36313299999999, 
      31.485896}, {-86.35776299999999, 
      31.487258999999998`}, {-86.35078899999999, 31.485424}, {-86.347028, 
      31.487700999999998`}, {-86.343267, 31.489521}, {-86.337897, 
      31.490883}, {-86.33144, 31.498175}, {-86.327131, 
      31.505014}, {-86.320685, 31.506829}, {-86.317985, 
      31.513671}, {-86.30722899999999, 31.520954}, {-86.297541, 
      31.530064}, {-86.27981899999999, 31.530030999999997`}, {-86.278947, 
      31.456094999999998`}, {-86.261243, 31.455602}, {-86.261821, 
      31.441454999999998`}, {-86.193699, 31.439919}}, {{-86.447627, 
      31.964503999999998`}, {-86.44662199999999, 31.850952}, {-86.446086, 
      31.846846999999997`}, {-86.442312, 31.846389}, {-86.442314, 
      31.843196}, {-86.438002, 31.842737999999997`}, {-86.438547, 
      31.83544}, {-86.44232, 31.835898999999998`}, {-86.441784, 
      31.831792999999998`}, {-86.446096, 31.831795999999997`}, {-86.446097, 
      31.830427}, {-86.446128, 31.783904}, {-86.44613199999999, 
      31.777517999999997`}, {-86.446134, 31.774324999999997`}, {-86.441825, 
      31.774323}, {-86.44129699999999, 31.759725999999997`}, {-86.445606, 
      31.759272}, {-86.44509599999999, 31.71776}, {-86.448346, 
      31.684915}, {-86.448365, 31.655715999999998`}, {-86.499462, 
      31.655272}, {-86.49946299999999, 31.553977}, {-86.498926, 
      31.525228}}, {{-86.701909, 31.525045}, {-86.839385, 
      31.526082}, {-86.843716, 31.534283}, {-86.8561, 
      31.541545}, {-86.86471999999999, 31.547449999999998`}, {-86.868507, 
      31.553369999999997`}, {-86.87124999999999, 
      31.565682}, {-86.87450899999999, 31.573428}, {-86.87937699999999, 
      31.580257}, {-86.884237, 31.585258999999997`}, {-86.886951, 
      31.590726}, {-86.891814, 31.596183999999997`}, {-86.895063, 
      31.601191999999998`}, {-86.899928, 31.60665}, {-86.901572, 
      31.613031999999997`}, {-86.899451, 31.618972}, {-86.904338, 
      31.628535999999997`}, {-86.909193, 31.631712}, {-86.90679999999999, 
      31.69012}, {-86.905746, 31.694685}, {-86.904764, 
      31.713393}, {-86.906041, 31.753076}}, {{-86.700015, 
      31.193631}, {-86.700034, 31.201393999999997`}, {-86.70090599999999, 
      31.337453}, {-86.699319, 31.345672999999998`}, {-86.69075199999999, 
      31.348426999999997`}, {-86.68058599999999, 
      31.354834999999998`}, {-86.678995, 31.362140999999998`}, {-86.671497, 
      31.364435}, {-86.668301, 31.374025999999997`}, {-86.671538, 
      31.384064}, {-86.668337, 31.391372999999998`}, {-86.66460599999999, 
      31.401877}, {-86.66890699999999, 31.407348}, {-86.66785999999999, 
      31.419673999999997`}, {-86.67430999999999, 
      31.426509999999997`}, {-86.67218, 
      31.433816999999998`}, {-86.67486799999999, 
      31.436550999999998`}, {-86.701152, 31.436507}, {-86.701909, 
      31.525045}}, {{-86.906041, 31.753076}, {-86.914113, 
      31.752133999999998`}, {-86.920559, 31.748917}, {-86.936696, 
      31.745662999999997`}, {-86.951183, 31.736482}, {-86.959769, 
      31.731429}, {-86.970536, 31.731384}, {-86.986643, 
      31.724017}, {-87.002208, 31.716649}, {-87.01241499999999, 
      31.713409}, {-87.025868, 31.712891}, {-87.04850499999999, 
      31.717343999999997`}, {-87.05812399999999, 
      31.707259999999998`}, {-87.06184999999999, 
      31.701310999999997`}, {-87.061239, 31.690821}, {-87.056302, 
      31.677159}, {-87.061109, 31.672117}, {-87.06755199999999, 
      31.670258999999998`}, {-87.07292799999999, 
      31.669776}, {-87.07880899999999, 31.664727}, {-87.08467, 
      31.65694}, {-87.091094, 31.6528}, {-87.10131299999999, 
      31.652745999999997`}, {-87.11097699999999, 
      31.650412}, {-87.12331499999999, 31.646238}, {-87.131884, 
      31.641627}, {-87.13452199999999, 31.635225}, {-87.13851299999999, 
      31.595962}, {-87.141694, 31.590467999999998`}, {-87.148622, 
      31.583126999999998`}, {-87.156093, 31.576694999999997`}, {-87.162365, 
      31.55521}, {-87.169174, 31.534177999999997`}, {-87.167439, 
      31.519128}, {-87.181794, 31.502156}, {-87.193984, 
      31.483825}, {-87.199777, 31.47101}, {-87.206677, 
      31.462294}, {-87.212015, 31.459066}, {-87.22005899999999, 
      31.458558}, {-87.23074799999999, 31.453923999999997`}, {-87.275398, 
      31.410259999999997`}, {-87.283411, 31.407009}, {-87.294603, 
      31.400083}, {-87.303632, 31.391344999999998`}, {-87.308919, 
      31.384003}, {-87.316383, 31.379839999999998`}, {-87.321692, 
      31.374779999999998`}, {-87.33064399999999, 31.359192}, {-87.337023, 
      31.354122999999998`}, {-87.34449099999999, 
      31.350870999999998`}, {-87.349227, 31.342617999999998`}, {-87.356535, 
      31.324299999999997`}, {-87.36128699999999, 
      31.317871999999998`}, {-87.374087, 
      31.312749999999998`}, {-87.38739699999999, 
      31.305339999999998`}, {-87.40069299999999, 31.297015}, {-87.405436, 
      31.290128}, {-87.41445, 31.282293}, {-87.424512, 
      31.272620999999997`}, {-87.427048, 31.260271999999997`}}, {{-85.710613, 
      31.195121}, {-85.707351, 31.200578}, {-85.698735, 
      31.206453}, {-85.694909, 31.214644999999997`}, {-85.692679, 
      31.223761999999997`}, {-85.691527, 31.231973}, {-85.687731, 
      31.236967999999997`}, {-85.679133, 31.240558}, {-85.677486, 
      31.244654999999998`}, {-85.673694, 31.249192999999998`}, {-85.675784, 
      31.254230999999997`}, {-85.67628599999999, 
      31.257430999999997`}, {-85.665465, 31.268766}, {-85.654162, 
      31.274615999999998`}, {-85.642376, 31.275439}, {-85.634356, 
      31.274464}, {-85.626331, 31.273944999999998`}, {-85.612408, 
      31.274290999999998`}, {-85.597985, 
      31.271435999999998`}, {-85.58679599999999, 
      31.266779}, {-85.57717699999999, 31.26533}, {-85.56755299999999, 
      31.264336}, {-85.54889399999999, 31.257786}, {-85.536093, 
      31.254023}, {-85.525903, 31.255761}, {-85.515227, 
      31.253383999999997`}, {-85.50513199999999, 
      31.247358}, {-85.49656999999999, 31.247282}, {-85.485884, 
      31.245815}, {-85.485332, 31.24718}, {-85.48537, 
      31.286904999999997`}, {-85.416848, 
      31.285802999999998`}, {-85.41752799999999, 
      31.315030999999998`}}, {{-87.072946, 32.579688}, {-87.057225, 
      32.587965}, {-87.043674, 32.595774}, {-87.037734, 
      32.602635}, {-87.040504, 32.60991}, {-87.048222, 
      32.623993}, {-87.045631, 32.643135}, {-87.038125, 
      32.660478999999995`}, {-87.030594, 32.674633}, {-87.033958, 
      32.688736}, {-87.02915399999999, 32.703787}, {-87.021633, 
      32.720217}, {-87.017876, 32.729341999999995`}}, {{-86.96516, 
      32.663989}, {-86.96432899999999, 32.708169}, {-86.915281, 
      32.708359}, {-86.914321, 32.837686999999995`}}, {{-87.016357, 
      32.663312}, {-86.97169699999999, 32.663962}, {-86.96516, 
      32.663989}}, {{-86.96516, 32.663989}, {-86.91668399999999, 
      32.664176999999995`}}, {{-86.447627, 
      31.964503999999998`}, {-86.41360999999999, 
      31.964938999999998`}, {-86.404433, 31.963562999999997`}, {-86.405951, 
      32.050651}}, {{-86.023232, 32.419771}, {-86.02108199999999, 
      32.416117}, {-86.020032, 32.410188999999995`}, {-86.01515599999999, 
      32.408346}, {-86.011386, 32.403318}, {-86.01305699999999, 
      32.39649}, {-86.012007, 32.390561999999996`}, {-86.014757, 
      32.38465}, {-86.00937499999999, 32.377337}, {-86.002905, 
      32.370473}, {-86.001314, 32.364543}, {-85.994834, 
      32.359501}, {-85.993798, 32.351749999999996`}, {-85.992753, 
      32.345366}, {-85.99009, 32.337607}, {-85.982517, 
      32.334382999999995`}, {-85.967877, 32.333404}, {-85.964123, 
      32.327006}, {-85.959806, 32.323796}, {-85.95660099999999, 
      32.316489}, {-85.956105, 32.309650999999995`}, {-85.950216, 
      32.298685}, {-85.942679, 32.290901}, {-85.929172, 
      32.284453}, {-85.92107399999999, 32.279854}, {-85.918945, 
      32.274375}}, {{-85.747873, 31.618070999999997`}, {-85.738686, 
      31.623027999999998`}, {-85.73215599999999, 
      31.631196}, {-85.72885199999999, 31.639386}, {-85.72175999999999, 
      31.649831}, {-85.718938, 31.663498999999998`}, {-85.71874799999999, 
      31.683116}, {-85.71972699999999, 31.69316}, {-85.715912, 
      31.698152}, {-85.70885299999999, 31.70449}, {-85.707701, 
      31.712237}, {-85.706462, 31.728652}, {-85.70476599999999, 
      31.736850999999998`}, {-85.699319, 31.743198999999997`}, {-85.688463, 
      31.751787999999998`}, {-85.675994, 31.759908}, {-85.670547, 
      31.765798999999998`}, {-85.66721199999999, 31.775809}, {-85.663895, 
      31.783994999999997`}, {-85.66756699999999, 
      31.793602}, {-85.67234499999999, 31.800479}, {-85.673887, 
      31.807789}, {-85.671647, 31.815983}, {-85.67369, 
      31.826943999999997`}, {-85.67298699999999, 31.842903}, {-85.672316, 
      31.855669}, {-85.66895799999999, 
      31.867501999999998`}, {-85.66294599999999, 
      31.875211}, {-85.65911799999999, 31.880198999999998`}}, {{-85.410079, 
      32.14663}, {-85.40963099999999, 32.139787}, {-85.41396, 
      32.139829}, {-85.427493, 32.139503}, {-85.427548, 32.1354}, {-85.427694,
       32.124461}, {-85.430286, 32.051995}, {-85.428617, 
      32.015046999999996`}, {-85.441589, 32.014713}, {-85.462124, 
      32.014448}, {-85.463104, 32.022209}, {-85.471209, 
      32.022283}, {-85.47077399999999, 32.014072}, {-85.50751, 
      32.014402}, {-85.512377, 32.013988999999995`}, {-85.512011, 
      31.99985}, {-85.52930099999999, 31.999544999999998`}, {-85.534217, 
      31.995027}, {-85.53904, 31.99826}, {-85.54714799999999, 
      31.997873}, {-85.587678, 31.996385}, {-85.592092, 
      31.988213}, {-85.59487999999999, 
      31.980483999999997`}, {-85.60143699999999, 
      31.973695999999997`}, {-85.61304799999999, 31.949164}, {-85.62069, 
      31.941471999999997`}, {-85.628292, 31.937426}, {-85.64964499999999, 
      31.908859999999997`}, {-85.650835, 31.898379}, {-85.65521299999999, 
      31.892484}, {-85.655834, 31.884735}, {-85.65911799999999, 
      31.880198999999998`}}, {{-86.009328, 33.090495}, {-86.007679, 
      32.915687999999996`}, {-86.007134, 32.827812}, {-86.007151, 
      32.825081}, {-86.007162, 32.823259}, {-86.01097899999999, 
      32.823730999999995`}, {-86.01319099999999, 
      32.819187}, {-86.01102399999999, 32.816446}, {-86.008861, 
      32.813249}, {-86.007224, 32.813241999999995`}, {-86.00729199999999, 
      32.802313999999996`}, {-86.00739999999999, 32.785011}, {-86.007041, 
      32.754954999999995`}}, {{-86.49068899999999, 33.103381}, {-86.374027, 
      33.102855999999996`}, {-86.174105, 33.104737}}, {{-86.17339199999999, 
      33.144785999999996`}, {-86.162465, 33.137017}, {-86.138947, 
      33.127387999999996`}, {-86.104429, 
      33.127728999999995`}, {-86.10490899999999, 
      33.141383999999995`}, {-86.04627599999999, 
      33.141166999999996`}, {-86.0469, 33.127970999999995`}, {-86.017859, 
      33.128307}, {-86.015002, 33.236605}, {-85.910743, 
      33.238847}, {-85.908458, 33.323924}, {-85.80574399999999, 
      33.324258}, {-85.803343, 33.409323}, {-85.75110099999999, 
      33.409904}, {-85.74899099999999, 33.458113}, {-85.72807999999999, 
      33.458428999999995`}, {-85.727441, 33.467523}, {-85.70983299999999, 
      33.467403}, {-85.709077, 33.487868999999996`}, {-85.689264, 
      33.487731}, {-85.688064, 33.497275}}, {{-85.65319199999999, 
      33.106618}, {-85.65328199999999, 33.200373}, {-85.65260599999999, 
      33.212199999999996`}, {-85.64876699999999, 33.212171}, {-85.648125, 
      33.220813}, {-85.648061, 33.226728}, {-85.65245, 
      33.226760999999996`}, {-85.65049499999999, 
      33.306379}, {-85.64170899999999, 33.306312999999996`}, {-85.641041, 
      33.317228}, {-85.645439, 33.316806}, {-85.64484999999999, 
      33.320442}, {-85.641001, 33.320868}, {-85.64096599999999, 
      33.324053}, {-85.649754, 33.324118}, {-85.643489, 
      33.496041999999996`}}, {{-88.172168, 32.996009}, {-88.171804, 
      33.004664}, {-88.168148, 33.012912}, {-88.16170799999999, 
      33.018924999999996`}, {-88.150824, 33.021814}, {-88.143855, 
      33.028743}, {-88.14782699999999, 33.035515}, {-88.141902, 
      33.040153}, {-88.133657, 33.03845}, {-88.12710899999999, 
      33.039454}, {-88.116778, 33.042787}, {-88.107884, 
      33.036083999999995`}, {-88.10081699999999, 
      33.038458999999996`}, {-88.094752, 33.036268}, {-88.089326, 
      33.03862}, {-88.082741, 33.037801}, {-88.080598, 
      33.040107}, {-88.079585, 33.044218}, {-88.075791, 
      33.046091}, {-88.07479599999999, 
      33.051111999999996`}, {-88.06768199999999, 33.05121}, {-88.063788, 
      33.048077}, {-88.058728, 33.041318}, {-88.05157899999999, 
      33.039594}, {-88.047147, 33.036923}, {-88.040652, 
      33.040652}, {-88.03466, 33.042099}, {-88.033654, 
      33.046665}, {-88.03871199999999, 33.053425}, {-88.038827, 
      33.059340999999996`}, {-88.031623, 33.054885999999996`}, {-88.028904, 
      33.055833}, {-88.031199, 33.061265}, {-88.026335, 
      33.064516}, {-88.019263, 33.066887}, {-88.01274599999999, 
      33.069704}, {-88.007854, 33.07159}, {-87.999113, 
      33.072615}, {-87.989841, 33.074557}, {-87.981715, 
      33.079215}, {-87.975128, 33.07839}, {-87.967506, 
      33.080763999999995`}, {-87.96376599999999, 33.085819}, {-87.955089, 
      33.090482}, {-87.95140699999999, 33.098721999999995`}, {-87.948819, 
      33.106947999999996`}, {-87.940679, 33.111148}, {-87.93145899999999, 
      33.11627}, {-87.921673, 33.120489}, {-87.913505, 
      33.123321}, {-87.90527999999999, 33.122966999999996`}, {-87.900995, 
      33.128482}, {-87.88792699999999, 33.133193}, {-87.877605, 
      33.138324}, {-87.867234, 33.140724}, {-87.85906299999999, 
      33.143553}, {-87.85034999999999, 33.146842}, {-87.83731499999999, 
      33.153822}}, {{-87.52404899999999, 33.004115}, {-87.523282, 
      32.860254999999995`}, {-87.472487, 32.859333}, {-87.472135, 
      32.83065}}, {{-87.421381, 32.831527}, {-87.472135, 
      32.83065}}, {{-87.01912399999999, 32.836802}, {-86.983646, 
      32.837413999999995`}}, {{-86.983646, 32.837413999999995`}, {-86.986352, 
      32.922542}, {-87.10823099999999, 32.924689}, {-87.108007, 
      32.895553}, {-87.148958, 32.893051}, {-87.14945999999999, 
      32.887584}, {-87.156542, 32.885267}, {-87.162523, 
      32.882045}, {-87.165815, 32.883846999999996`}, {-87.163665, 
      32.887958}, {-87.17131599999999, 32.888368}, {-87.172927, 
      32.885172}, {-87.17068499999999, 32.878355}, {-87.169, 
      32.872901999999996`}, {-87.172831, 32.87379}, {-87.17719199999999, 
      32.872853}, {-87.181553, 32.871916999999996`}, {-87.185878, 
      32.866882}, {-87.229021, 32.86707}, {-87.237161, 
      32.861554}, {-87.268844, 32.86271}, {-87.268317, 
      32.920992}, {-87.260667, 32.921043}, {-87.258589, 
      32.989343999999996`}, {-87.26625, 32.989748}, {-87.267358, 
      33.047551999999996`}, {-87.277227, 33.049306}, {-87.288703, 
      33.047407}, {-87.300674, 33.040496}, {-87.30834, 
      33.040897}, {-87.316582, 33.044024}}, {{-87.211807, 
      32.835305999999996`}, {-87.01912399999999, 32.836802}}, {{-87.072946, 
      32.579688}, {-87.105595, 32.579974}, {-87.101683, 
      32.710257999999996`}, {-87.214524, 32.712793}, {-87.23460899999999, 
      32.704012}, {-87.234102, 32.708114}, {-87.238466, 
      32.708541}, {-87.243426, 32.714428999999996`}, {-87.253271, 
      32.718008}, {-87.256044, 32.722999}, {-87.260408, 
      32.723425}, {-87.26425499999999, 32.726588}, {-87.26382799999999, 
      32.738886}, {-87.260592, 32.742551}, {-87.259, 32.747116}, {-87.26344, 
      32.755283}, {-87.263493, 32.760748}, {-87.26355, 
      32.766667}, {-87.26794799999999, 32.770281}, {-87.272848, 
      32.769337}, {-87.274524, 32.773424}, {-87.269708, 
      32.783018999999996`}, {-87.261618, 32.792637}, {-87.24857999999999, 
      32.798643}, {-87.244787, 32.8014}, {-87.250299, 
      32.807283}, {-87.25251999999999, 32.811367}, {-87.246552, 
      32.815049}, {-87.243858, 32.818709}, {-87.240562, 
      32.816454}, {-87.23941599999999, 32.810542}, {-87.235625, 
      32.813753999999996`}, {-87.228573, 32.818353}, {-87.21934999999999, 
      32.824331}, {-87.211807, 32.835305999999996`}}, {{-87.42078599999999, 
      32.874333}, {-87.319215, 32.875564}, {-87.319304, 
      32.831396}, {-87.269089, 32.831747}}, {{-87.269089, 
      32.831747}, {-87.233065, 32.831984}, {-87.22327, 
      32.835234}, {-87.211807, 32.835305999999996`}}, {{-87.421381, 
      32.831527}, {-87.35642399999999, 32.831579}, {-87.355746, 
      32.819289999999995`}, {-87.337186, 32.818971999999995`}, {-87.337119, 
      32.812598}, {-87.32838799999999, 32.812661999999996`}, {-87.328312, 
      32.805375999999995`}, {-87.295028, 32.805614}, {-87.290858, 
      32.825223}, {-87.269032, 32.825827}, {-87.269089, 
      32.831747}}, {{-85.74229199999999, 33.582249}, {-85.75331299999999, 
      33.582321}, {-85.753942, 33.574138}, {-85.79525699999999, 
      33.575308}}, {{-85.79525699999999, 33.575308}, {-85.79592199999999, 
      33.562576}}, {{-85.643489, 33.496041999999996`}, {-85.63974999999999, 
      33.586076999999996`}, {-85.603921, 33.586712999999996`}, {-85.599638, 
      33.671729}, {-85.516885, 33.671507999999996`}, {-85.512659, 
      33.787887999999995`}, {-85.480063, 33.787605}, {-85.47653799999999, 
      33.888059999999996`}, {-85.532404, 33.888996}}, {{-85.53166499999999, 
      33.903993}, {-85.532404, 33.888996}}, {{-85.532404, 
      33.888996}, {-85.601548, 33.890008}, {-85.601721, 
      33.875006}, {-85.637114, 33.87573}, {-85.636882, 33.84663}, {-85.592098,
       33.846287}, {-85.58546899999999, 33.84578}, {-85.585979, 
      33.802133}, {-85.60310899999999, 33.802268}, {-85.60327099999999, 
      33.788173}, {-85.620955, 33.787853999999996`}, {-85.62111399999999, 
      33.773759}, {-85.63768999999999, 33.77343}, {-85.638626, 
      33.688399}, {-85.637963, 33.648373}, {-85.646782, 
      33.648894}, {-85.646861, 33.641617}, {-85.651268, 
      33.642105}}, {{-86.95321299999999, 33.815318999999995`}, {-86.936633, 
      33.815382}, {-86.88371, 33.843305}, {-86.76261699999999, 
      33.840916}, {-86.7593, 33.840923}, {-86.64804699999999, 
      33.775191}, {-86.648037, 33.769734}, {-86.647477, 
      33.766096999999995`}, {-86.57788, 33.765256}}, CompressedData["
1:eJwV0ntM01cUB3DWZQw6CAKKUBmPDnSArzKwCA5OcCGb+IiGqwyhGDdnGpHB
COMR3eYEKVOgFJ8diHRSHSVsOmn/GLjfUGhNoLKu0amNzokwKFBYeWxQ6L78
8csvn/s7957zO+eGHvx0zyGei4tLEp6ld2rvT4q95xj34M6FSuEM0Y+5HQnR
8BvnR3gSuOHhH+EtZxk35nl74yXYI0h9vADOUwzWSGeJShJfHemDHXOhm9L/
JdL9/kB2AH5b+7U6fI5o06oo0f06xsWsD3S7B9sWPB9rFIwrDpNcNi4QGT6/
3SiAU/iHnlthUWKvRFvLuAPyKekKJ1HMB2sjimD9+t2dsYtE6uQtPhvgPKPM
9NRBpDJatnbJGRebtGhSwWn6yObDcEmgq30f/FdtcUk8nNqi/fbPeaK36v06
/q5h3DH+V5Me+F6tqc2Swgm/LlotsKNi6snDasbFTZ8YaEA9uaIkcQw84VM/
R8gfWNxuuVTFuKzmn6058PholJfpDOMEjoWDWvhwct1dBfw4qPN5IpzbyD7Z
Bt/r9k/X47xzySEX4uDzr/l+uRyeFzatGzrNuJe3rg3UI/+younIaPiODpNA
vZ/tONFr/IZx6TXze63oX79WWdgDl3nu+uHsf0RH9easR3D+UNf7G9D/76rx
R/A7e2zf1y/NyznsyodXjmf6D08TpToVaepKxgVHVl18BCuF3HAWvDy4Ud4A
C2YHxdvhml0G45MpIp5dHhEMT0h3Sj6GNTfK2kUwonU37ETXhCt6/OArqpF9
8XDaGbu4Sca4+llnftc/RBunZL8VwIH0i+0Z7GJw902BM9u+yFEgvlXDa/eH
Mz7qd2+CNcOlKmsF47Z43y2Jg33NE+ta4et6rceSm2b2J+yGd1y+qWyDhUc8
m2dOMc6cUhgvh6/7eXcPwIbsDPMaeH9oa48P4r3cn82vQv7tan5KOFxrygmq
mMR9fJm4mQ+7q5UfpsIFHgaJDfsrw0oDuidwv4Uyex7cZwgp8oZXLsvwyoaT
CwsmdTYicQA7lQ/77TQ5RLBvRN/gktdcjXVtGCdanJS0R8PFpc1rt8JDVXVd
HeWYf9j96ePwC8tqSxSsez00JBsWH+2RysoY57bZ5nwBv6fqvzl+Ev021F09
Ap+UmW+dhtuUQ7JjY0Qhma+Ul8KCTsGVmFH0793Rch72Y3XODR5UtIythp++
GaDpsxL9Dw5/AUw=
      "], {{-86.333409, 33.922928999999996`}, {-86.350004, 
      33.927498}, {-86.367711, 33.930247}, {-86.371579, 
      33.934343}, {-86.368245, 33.941613}, {-86.36214, 
      33.950243}, {-86.354935, 33.954325}, {-86.35271, 
      33.960232}, {-86.346059, 33.962951}, {-86.342162, 
      33.973400999999996`}, {-86.33216499999999, 33.98657}, {-86.332054, 
      34.037935}, {-86.332588, 34.047481999999995`}, {-86.322553, 
      34.072466}, {-86.303077, 34.099250999999995`}}, {{-87.11050499999999, 
      34.210525}, {-87.110619, 34.225066999999996`}, {-87.110264, 
      34.250516999999995`}, {-87.109858, 34.269605}, {-87.109537, 
      34.299599}}, {{-87.150904, 33.993044999999995`}, {-87.161491, 
      34.000257999999995`}, {-87.173172, 34.005646}, {-87.184794, 
      34.004214}, {-87.189768, 34.002821}, {-87.19140999999999, 
      34.000538}, {-87.196339, 33.994144}, {-87.19958199999999, 
      33.985033}, {-87.204017, 33.985461}, {-87.207381, 
      33.989986}}, {{-87.635775, 34.002488}, {-87.573697, 
      34.000807}, {-87.4994, 33.996472}, {-87.428483, 
      33.996153}}, {{-87.530782, 34.442487}, {-87.54861, 
      34.442327999999996`}, {-87.546751, 34.304665}}, {{-87.105126, 
      34.661255}, {-87.10665399999999, 34.499984}, {-87.109537, 
      34.370483}, {-87.11001499999999, 34.360485}, {-87.109915, 
      34.347763}}, {{-87.110207, 34.314136}, {-87.109915, 
      34.347763}}, {{-86.303077, 34.099250999999995`}, {-86.19959999999999, 
      34.177202}, {-86.18902399999999, 34.183536}, {-86.18458, 
      34.183979}, {-86.176248, 34.18441}, {-86.16846199999999, 
      34.187115}, {-86.106269, 34.186012}, {-86.1057, 
      34.188736999999996`}, {-86.105677, 34.193281999999996`}, {-86.105638, 
      34.201007}}, {{-85.749353, 32.959351}, {-85.74875899999999, 
      32.964355}, {-85.74866399999999, 32.97437}, {-85.74853, 
      32.988481}, {-85.714066, 32.989159}, {-85.71421099999999, 
      32.974593}, {-85.722959, 32.974652999999996`}, {-85.722995, 
      32.971011}, {-85.727369, 32.971041}, {-85.72740499999999, 
      32.967399}, {-85.731779, 32.967428999999996`}, {-85.731859, 
      32.959235}, {-85.749353, 32.959351}}, {{-87.31508699999999, 
      34.383766}, {-87.316105, 34.374671}, {-87.30933499999999, 
      34.366085}, {-87.292029, 34.361205999999996`}, {-87.281436, 
      34.35946}, {-87.280245, 34.351744}, {-87.285162, 
      34.342622999999996`}, {-87.28615099999999, 
      34.330346999999996`}, {-87.28379199999999, 34.317186}, {-87.273603, 
      34.299532}}, {{-87.23286999999999, 34.344327}, {-87.247872, 
      34.34196}, {-87.26058499999999, 34.333244}, {-87.266616, 
      34.324116}, {-87.26593799999999, 34.311852}, {-87.273603, 
      34.299532}}, {{-87.273603, 34.299532}, {-87.280709, 
      34.287214999999996`}, {-87.290616, 34.277150999999996`}, {-87.283839, 
      34.266745}, {-87.27208399999999, 34.258644}, {-87.259834, 
      34.256451999999996`}, {-87.249234, 34.252431}, {-87.242499, 
      34.245658}, {-87.24628899999999, 34.235181}, {-87.250042, 
      34.221069}, {-87.25380799999999, 34.20832}, {-87.254848, 
      34.201042}, {-87.25703899999999, 34.197846}, {-87.251463, 
      34.195609999999995`}, {-87.248083, 34.190633}, {-87.249062, 
      34.176992}, {-87.245622, 34.165652}, {-87.23948899999999, 
      34.162963999999995`}, {-87.22560999999999, 34.163052}, {-87.214474, 
      34.159485}, {-87.211657, 34.154956999999996`}}, {{-87.109537, 
      34.299599}, {-87.221879, 34.29941}, {-87.235226, 
      34.299326}, {-87.273603, 34.299532}}, {{-87.805996, 
      30.227524}, {-87.80511299999999, 
      30.238516999999998`}, {-87.78981499999999, 
      30.240527999999998`}, {-87.797286, 30.245016}, {-87.806895, 
      30.25085}}, {{-87.77683499999999, 30.255779999999998`}, {-87.776778, 
      30.252119999999998`}, {-87.763556, 
      30.251814999999997`}, {-87.76361899999999, 30.255933}, {-87.732422, 
      30.25583}, {-87.72193, 30.261438}, {-87.721097, 30.276546}, {-87.725856,
       30.276493}}, {{-87.83882799999999, 30.361188}, {-87.83155099999999, 
      30.36951}, {-87.82244899999999, 30.363215999999998`}, {-87.82239, 
      30.359557}, {-87.817545, 30.354582999999998`}, {-87.810062, 
      30.350096999999998`}, {-87.809997, 30.345979999999997`}, {-87.797288, 
      30.345674}, {-87.797209, 30.340642}, {-87.788598, 
      30.331594}, {-87.780125, 30.331235}, {-87.776321, 
      30.324873999999998`}, {-87.772004, 
      30.319433999999998`}, {-87.76722099999999, 
      30.318116999999997`}, {-87.767172, 30.314915}, {-87.761352, 
      30.314981999999997`}, {-87.76128899999999, 
      30.310865}, {-87.75440499999999, 30.310485999999997`}, {-87.754196, 
      30.296763}}, {{-87.96309199999999, 30.233779}, {-87.938253, 
      30.234106999999998`}, {-87.900784, 30.237795}}, CompressedData["
1:eJwV0X1MU1cYBvDqqrBMvufEgdoynUDdroFpGPJxL84IhcmHXlQcMogFjDjC
xzbBuppSJZTiUGsZgtWSFZzgaLRrBVHvpB2KRVQWCAbpRHBMJ2zSyToh7Dl/
nNz8ct9znvc9R5iVnyKZz+PxYrDIV6M5Xpp4jeU236K16UkMfW/3oQhHB8u5
pN/UmWGV+Bn/I/j9qvvhF+Av4kflobCeUtRPJ+L/nm+TQq+y3GCEe5kT/mXa
qg+GXx8PCGkh+6mHT460s1xXziWZFq6VXu6pgrvXTiy8v4Whw4s83rS3sdzT
NCNv/6cM3Trev68UnpU/MhCL9tWNFMAO3VvPdqE+Jv37pHfg7yiKi4K1u8bF
fJi/omxxE/xwvUr+2xWWG6ut6ZxAP5nKwr0zsMKzmtIhX9RxZ5MUXuMZGXQS
fqDMDyQeGKyWZcMXyymfTXDx3cQCf7jvxspTQfCCxr52N1gm0ccR7/Q+16jB
+Svcmmw9ZpbjdWkja2CfjBeBd+FvZj391qBeE+AUC+C0qSfUByT/aPMbxK0Z
Bj8T6oeXLW3uMbHc6DlFLfFfDa0C4t3/HC65hXlM8sZVqbCjIiKuHQ5VjmmI
X5VOdx1E/fm5FuffP7HcRFTX5krYvn84LAiO+X3dVxXIm2wu1L00stzbB1af
XZ7M0LGdQUVTsG/amXpdCkNTgwcMVvhOBztAfELtWGuEae9XL1ZuY+jtNtd8
DzhcWHxvFTwiEHYvgSWdp7sbUH/76YWSY5dZztbX1qCGe6+VxxNPjVi2b4BP
6vtfV8EWdWxDDfIdenM02b/oyx2PNbC9vEwRCF91Gb9ej/5Ldpxf1wO/lC78
tQ5270ibsMFWVmJfDFf+u8VWivmGsoMt78GWr7P6K+E9gt4P7QkMXWC1JrfB
63+UDeTAt1Nrts7HfYldns/5wwf3KnlNcKavYTQYnrkpitPC/HkhxX/Cg60b
HpXgfVZzhhknPI8KzVPDPyu3XjwSz9AV6uypMDg3OuWTo/BkkdRIHBWt8lwO
x944tIw4W2F2EYoZGt3p6nG+bPrYuz6w8/qVbXp4yN2tMjmOoT82aYX+sPFE
qnQjbBqQD/vBrnMBubZYhg7x782hyfxNPN9euG7pbG4Y/HxYaeEjb1FklmMI
9ysUZMQsgB/8IDo7Bv8nVXstQV6h0+MPM9xiT0gg9tZ55X0GV3slPXaFMzv7
RBI479TnBWHIH9kpVx2+xHI5kypTMPw/ZKf6GA==
      "], {{-86.72172599999999, 34.627635999999995`}, {-86.73513, 
      34.627609}, {-86.75300299999999, 34.628026}, {-86.752977, 
      34.61985}, {-86.740133, 34.619876999999995`}, {-86.740111, 
      34.613064}, {-86.73898899999999, 34.611249}, {-86.736182, 
      34.606258}, {-86.73615099999999, 34.596264999999995`}, {-86.731674, 
      34.592639999999996`}, {-86.73220599999999, 
      34.584008}, {-86.73387699999999, 34.582642}, {-86.742781, 
      34.573993}, {-86.753351, 34.563522999999996`}, {-86.764493, 
      34.558047}, {-86.76397999999999, 34.571222}, {-86.772909, 
      34.571200999999995`}, {-86.772401, 34.585284}, {-86.780215, 
      34.585266}, {-86.780722, 34.571183}, {-86.789096, 
      34.571616}}, {{-86.681967, 34.583189}, {-86.685322, 
      34.585454999999996`}, {-86.69593499999999, 34.588163}}, {{-85.678694, 
      34.340101}, {-85.676013, 34.33054}, {-85.677779, 
      34.321464999999996`}, {-85.683447, 34.311507}, {-85.694656, 
      34.303405999999995`}, {-85.69586699999999, 
      34.293872}, {-85.68926499999999, 34.287009999999995`}, {-85.691536, 
      34.282481}, {-85.680972, 34.282407}, {-85.676481, 
      34.286465}, {-85.682526, 34.293324}, {-85.684151, 
      34.297426}, {-85.674059, 34.305079}, {-85.667282, 
      34.314574}, {-85.66495499999999, 34.3241}, {-85.66428599999999, 
      34.334545999999996`}, {-85.66641899999999, 34.343195}, {-85.666902, 
      34.350014}, {-85.660687, 34.358602999999995`}, {-85.651778, 
      34.358993}, {-85.643379, 34.363475}, {-85.634469, 
      34.363864}, {-85.624374, 34.370604}, {-85.619292, 
      34.376926999999995`}, {-85.619812, 34.380111}, {-85.610349, 
      34.380039}, {-85.60976099999999, 34.382760999999995`}, {-85.613044, 
      34.387783999999996`}, {-85.607434, 34.391376}, {-85.60126799999999, 
      34.394964}, {-85.601141, 34.405868}, {-85.58999299999999, 
      34.40669}, {-85.58327299999999, 34.409818}, {-85.583139, 
      34.421175999999996`}, {-85.573107, 34.421551}, {-85.57361, 
      34.426097999999996`}, {-85.566369, 34.42604}, {-85.566068, 
      34.451026999999996`}, {-85.569968, 
      34.451057999999996`}, {-85.56979899999999, 
      34.465140999999996`}, {-85.56645499999999, 
      34.465115}, {-85.56626899999999, 34.48056}, {-85.57463, 
      34.480627}}, {{-85.57463, 34.480627}, {-85.573537, 
      34.478801}, {-85.57076099999999, 34.477869999999996`}, {-85.570334, 
      34.466963}, {-85.576422, 34.470645999999995`}, {-85.580891, 
      34.469772999999996`}, {-85.57764399999999, 34.461569}, {-85.579343, 
      34.459311}, {-85.583812, 34.458436999999996`}, {-85.5795, 
      34.446135999999996`}, {-85.57901299999999, 
      34.440225999999996`}, {-85.581842, 34.436613}, {-85.583556, 
      34.432992}, {-85.59084, 34.429414}, {-85.58866599999999, 
      34.424853999999996`}, {-85.600962, 34.421315}, {-85.59935999999999, 
      34.415396}, {-85.603842, 34.413157999999996`}, {-85.607199, 
      34.411820999999996`}, {-85.608355, 34.408195}, {-85.61116, 
      34.406399}, {-85.614631, 34.395066}, {-85.61743, 
      34.393724}, {-85.62684999999999, 34.397884999999995`}, {-85.627443, 
      34.394709}, {-85.624679, 34.392869999999995`}, {-85.61972999999999, 
      34.387381}, {-85.624797, 34.382421}, {-85.62758099999999, 
      34.382442}, {-85.63038999999999, 34.380190999999996`}, {-85.628219, 
      34.375175999999996`}, {-85.62824499999999, 
      34.372904999999996`}, {-85.632151, 34.372025}, {-85.635537, 
      34.367961}, {-85.636665, 34.366606}, {-85.64111799999999, 
      34.366639}, {-85.642758, 34.369377}, {-85.64497899999999, 
      34.369848}, {-85.64782699999999, 34.363962}, {-85.662869, 
      34.362708}, {-85.66847899999999, 34.358658999999996`}, {-85.668523, 
      34.354569999999995`}, {-85.67245199999999, 34.351417}, {-85.676396, 
      34.346900999999995`}, {-85.67476099999999, 34.343709}, {-85.678694, 
      34.340101}}, {{-85.827798, 33.443134}, {-85.827708, 
      33.453596}, {-85.83603, 33.445456}, {-85.84377599999999, 
      33.440041}, {-85.848241, 33.432333}, {-85.853774, 
      33.42827}, {-85.85874299999999, 33.426023}, {-85.86372899999999, 
      33.421502}, {-85.86869999999999, 33.4188}, {-85.873678, 
      33.415186999999996`}, {-85.875917, 33.410195}, {-85.874861, 
      33.40473}, {-85.853973, 33.40416}, {-85.85446999999999, 
      33.410531999999996`}, {-85.845123, 
      33.410478999999995`}, {-85.84597199999999, 
      33.374542}, {-85.84157499999999, 33.374517}, {-85.84163199999999, 
      33.367692999999996`}, {-85.827348, 33.367155}, {-85.82709899999999, 
      33.396271}, {-85.819952, 33.396229}, {-85.81987, 
      33.405783}, {-85.81106899999999, 33.406185}, {-85.810842, 
      33.432114999999996`}, {-85.80204599999999, 33.431607}, {-85.801977, 
      33.43934}, {-85.79861199999999, 33.446598}, {-85.80184799999999, 
      33.453897}, {-85.818902, 33.453998999999996`}, {-85.818997, 
      33.443082}, {-85.827798, 33.443134}}, {{-85.65008499999999, 
      33.700308}, {-85.72679, 33.701302999999996`}, {-85.727064, 
      33.673564}, {-85.74306299999999, 33.67367}, {-85.74377299999999, 
      33.657302}, {-85.812163, 33.658184999999996`}, {-85.813155, 
      33.670925}, {-85.820208, 33.68461}, {-85.823949, 33.69873}, {-85.822155,
       33.714636}, {-85.814364, 33.721865}, {-85.80271499999999, 
      33.728162}, {-85.798225, 33.73632}, {-85.79590999999999, 
      33.748129}, {-85.69102, 33.744713}, {-85.691165, 
      33.730616999999995`}, {-85.649765, 33.729865}}, {{-85.898656, 
      33.672312}, {-85.915714, 33.678312}, {-85.93383899999999, 
      33.689772}, {-86.023769, 33.692451999999996`}, {-86.022857, 
      33.751564}, {-85.899166, 33.749621999999995`}, {-85.89129, 
      33.697286}, {-85.898656, 33.672312}}, {{-85.53166499999999, 
      33.903993}, {-85.583106, 33.905775999999996`}, {-85.583191, 
      33.898503}, {-85.65567399999999, 33.8986}, {-85.656335, 
      33.888602}, {-85.671824, 33.888714}, {-85.671902, 
      33.881440999999995`}, {-85.686283, 33.881543}, {-85.68664299999999, 
      33.846990999999996`}, {-85.724784, 33.848161999999995`}, {-85.723699, 
      33.790409}, {-85.70491, 33.790735999999995`}, {-85.704228, 
      33.803463}, {-85.64895899999999, 33.803979}, {-85.649631, 
      33.742142}, {-85.649765, 33.729865}}, {{-85.649765, 
      33.729865}, {-85.64941999999999, 33.710763}, {-85.65008499999999, 
      33.700308}}, {{-85.65008499999999, 33.700308}, {-85.651268, 
      33.642105}}, {{-85.78878499999999, 
      31.490105999999997`}, {-85.75604799999999, 31.489437}, {-85.756183, 
      31.474833}, {-85.740083, 31.474725}, {-85.739139, 
      31.461025999999997`}, {-85.723579, 31.460918999999997`}, {-85.723737, 
      31.444488}, {-85.707107, 31.444371}, {-85.706696, 
      31.431587999999998`}, {-85.690615, 31.43056}, {-85.683253, 
      31.415899999999997`}, {-85.694147, 31.399089}, {-85.706599, 
      31.386853}, {-85.63958199999999, 31.387269999999997`}, {-85.640278, 
      31.372211}, {-85.622592, 31.372073}, {-85.62339999999999, 
      31.346971}, {-85.66544999999999, 31.322184}, {-85.674048, 
      31.319509}, {-85.694392, 31.320570999999997`}, {-85.702913, 
      31.325654}, {-85.71309, 31.325726}, {-85.724383, 
      31.32124}, {-85.73725499999999, 31.319502999999997`}, {-85.746318, 
      31.32413}, {-85.756993, 31.32831}, {-85.757252, 
      31.358442999999998`}, {-85.78940899999999, 
      31.358196}}, {{-85.78878499999999, 31.490105999999997`}, {-85.806502, 
      31.489760999999998`}, {-85.806917, 31.503912}, {-85.823559, 
      31.504013999999998`}, {-85.823804, 
      31.474805999999997`}, {-85.84151299999999, 
      31.474912}, {-85.84109199999999, 31.460760999999998`}, {-85.858802, 
      31.460407}, {-85.859037, 31.430740999999998`}, {-85.842406, 
      31.431099999999997`}, {-85.841985, 31.416947999999998`}, {-85.824292, 
      31.416386}, {-85.82441, 31.402236}, {-85.806713, 
      31.402583999999997`}, {-85.806846, 31.387065}, {-85.789692, 
      31.386957}}, {{-85.78878499999999, 31.490105999999997`}, {-85.789378, 
      31.483721}, {-85.789423, 31.4787}, {-85.789631, 
      31.454967999999997`}, {-85.78971899999999, 31.444927}, {-85.789912, 
      31.423019}, {-85.789608, 31.396542}, {-85.789692, 
      31.386957}}, {{-85.789692, 31.386957}, {-85.78931999999999, 
      31.368237999999998`}, {-85.78940899999999, 31.358196}}, {{-87.64331, 
      30.501526}, {-87.660808, 30.501343}, {-87.660485, 
      30.515981}, {-87.642984, 30.516164}, {-87.64331, 
      30.501526}}, {{-84.9981, 32.354763}, {-85.001787, 
      32.360735999999996`}, {-85.006135, 32.360338}, {-85.012299, 
      32.349938}, {-85.017342, 32.341345}, {-85.011715, 
      32.323040999999996`}, {-85.00281199999999, 
      32.306059999999995`}, {-85.002932, 32.299681}, {-84.97635, 
      32.300236999999996`}, {-84.976086, 32.285649}, {-84.967405, 
      32.285987}, {-84.96608599999999, 
      32.241755999999995`}, {-84.91946999999999, 32.242481}}, {{-86.371386, 
      32.370125}, {-86.362161, 32.369658}, {-86.359985, 
      32.372845}, {-86.35780299999999, 32.379222}, {-86.353996, 
      32.383317999999996`}, {-86.34259399999999, 
      32.385124999999995`}, {-86.334453, 32.385114}, {-86.334442, 
      32.390125999999995`}, {-86.346921, 32.393333}, {-86.352884, 
      32.397897}, {-86.356681, 32.399269}, {-86.362112, 
      32.397909}, {-86.37677, 32.39747}, {-86.373527, 32.388809}, {-86.371915,
       32.378783}, {-86.371386, 32.370125}}, {{-87.49168, 
      34.304238999999995`}, {-87.52951, 34.304819}}, {{-87.47498999999999, 
      34.303926}, {-87.49168, 34.304238999999995`}}, {{-87.47498999999999, 
      34.303926}, {-87.46657499999999, 34.298088}, {-87.46034499999999, 
      34.289051}, {-87.443642, 34.287369999999996`}, {-87.433666, 
      34.290178}, {-87.399154, 34.287269}, {-87.395849, 
      34.290020999999996`}, {-87.391505, 
      34.299141999999996`}, {-87.38151599999999, 
      34.301035999999996`}}, {{-87.38151599999999, 
      34.301035999999996`}, {-87.37321999999999, 
      34.305189}, {-87.37158699999999, 34.308382}, {-87.371653, 
      34.314288999999995`}, {-87.383303, 34.311474}, {-87.38727399999999, 
      34.318259999999995`}, {-87.389302, 34.349598}, {-87.390509, 
      34.357768}, {-87.39118599999999, 34.368214}, {-87.39125399999999, 
      34.37412}, {-87.414226, 34.386665}, {-87.426442, 
      34.383842}, {-87.44263099999999, 34.387347}, {-87.450375, 
      34.383195}, {-87.46305, 34.37264}, {-87.458546, 34.368587}, {-87.462898,
       34.360372999999996`}, {-87.473204, 34.33893}, {-87.485978, 
      34.337005}, {-87.49102099999999, 34.339689}, {-87.49450499999999, 
      34.351019}, {-87.498412, 34.351894}, {-87.503391, 
      34.349579}, {-87.503261, 34.339583999999995`}, {-87.50128699999999, 
      34.315971}, {-87.497294, 34.308281}, {-87.49168, 
      34.304238999999995`}}, {{-86.687136, 
      34.643139999999995`}, {-86.68660799999999, 34.655859}, {-86.672082, 
      34.655881}, {-86.672113, 34.669962}, {-86.662615, 
      34.670429}, {-86.658114, 34.655901}, {-86.662025, 
      34.655895}, {-86.663111, 34.640905}, {-86.663105, 
      34.638179}, {-86.651929, 34.635923}, {-86.652473, 
      34.628655}}, {{-86.69593499999999, 34.588163}, {-86.69538899999999, 
      34.593160999999995`}, {-86.675849, 34.592737}, {-86.675862, 
      34.598188}, {-86.687587, 34.598624}, {-86.687079, 
      34.61952}, {-86.67311699999999, 34.619087}, {-86.665285, 
      34.612739}, {-86.652982, 34.603671}, {-86.647399, 
      34.603679}, {-86.646855, 34.610946999999996`}, {-86.639037, 
      34.610957}, {-86.638486, 34.615044999999995`}, {-86.628445, 
      34.620962}, {-86.623977, 34.620967}, {-86.623986, 
      34.626418}, {-86.615049, 34.625972}, {-86.614505, 
      34.635512}, {-86.62847, 34.635951}, {-86.628463, 
      34.632318}, {-86.636842, 34.632308}, {-86.637394, 
      34.628674}, {-86.652473, 34.628655}}, {{-86.687136, 
      34.643139999999995`}, {-86.673171, 34.643161}, {-86.673689, 
      34.624992}, {-86.664751, 34.624096}, {-86.66529899999999, 
      34.619099}, {-86.65301199999999, 34.618660999999996`}, {-86.652473, 
      34.628655}}, {{-85.62743999999999, 32.512181}, {-85.627535, 
      32.503524999999996`}, {-85.63084599999999, 32.498995}, {-85.633084, 
      32.493089}, {-85.62988299999999, 32.487598}, {-85.629938, 
      32.482586999999995`}, {-85.63327199999999, 32.475778}, {-85.641502, 
      32.468551}, {-85.65997999999999, 
      32.468233999999995`}, {-85.65974399999999, 32.439073}, {-85.676037, 
      32.439192}, {-85.676188, 32.424613}, {-85.659354, 
      32.424489}, {-85.65951299999999, 32.409454}, {-85.642682, 
      32.409327999999995`}, {-85.643064, 32.424367}, {-85.62622499999999, 
      32.424693999999995`}, {-85.626448, 32.453856}, {-85.610147, 
      32.454184999999995`}, {-85.609989, 32.468308}, {-85.593684, 
      32.468634}, {-85.593307, 32.454052}, {-85.559078, 
      32.454228}, {-85.55927799999999, 32.483388999999995`}, {-85.541888, 
      32.483243}, {-85.542251, 32.498281}, {-85.559649, 
      32.497971}, {-85.559482, 32.512093}, {-85.62743999999999, 
      32.512181}}, {{-88.372247, 30.395947}, {-88.371895, 
      30.40373}, {-88.37983799999999, 30.403595}, {-88.380167, 
      30.441101}, {-88.388125, 30.441422}, {-88.38829299999999, 
      30.448738}, {-88.392532, 30.448665}, {-88.392287, 
      30.461019999999998`}, {-88.387507, 30.460645}, {-88.387644, 
      30.466589}, {-88.402101, 30.472744}}, {{-87.933173, 
      34.838449}, {-87.933199, 34.839811}, {-87.936711, 
      34.847943}, {-87.95164, 34.867289}, {-87.973221, 
      34.882461}, {-87.995791, 34.89035}, {-88.012148, 34.89559}, {-88.030821,
       34.904430999999995`}, {-88.04096299999999, 
      34.907022999999995`}, {-88.058292, 34.904523}, {-88.07883199999999, 
      34.894711}, {-88.097922, 34.896269}}, {{-87.52954799999999, 
      34.559258}, {-87.524598, 34.564752999999996`}, {-87.52353, 
      34.568396}, {-87.517404, 34.569359}, {-87.519708, 
      34.57479}, {-87.514738, 34.578922}, {-87.50976899999999, 
      34.583053}, {-87.50927, 34.5876}, {-87.513813, 34.593466}, {-87.514448, 
      34.599365999999996`}, {-87.50892499999999, 34.603957}, {-87.505088, 
      34.609441}, {-87.50463599999999, 34.617622}, {-87.49524199999999, 
      34.625425}, {-87.485271, 34.631868}, {-87.484212, 
      34.63642}, {-87.479778, 34.639182999999996`}, {-87.482635, 
      34.644155}, {-87.482128, 34.648247999999995`}, {-87.476012, 
      34.65057}, {-87.460319, 34.646612}, {-87.450856, 
      34.649415}, {-87.447018, 34.655350999999996`}, {-87.447671, 
      34.663067999999996`}, {-87.448347, 34.672601}, {-87.448967, 
      34.677593}, {-87.45123099999999, 34.679845}, {-87.45246, 
      34.688919999999996`}, {-87.44863699999999, 34.696218}, {-87.438637, 
      34.701295}, {-87.434767, 34.70496}, {-87.42756, 34.710014}, {-87.428733,
       34.714546999999996`}, {-87.432718, 34.720419}, {-87.434483, 
      34.727672999999996`}, {-87.43288799999999, 
      34.734497999999995`}, {-87.422355, 34.742303}, {-87.426357, 
      34.749539}, {-87.424196, 34.755914}, {-87.417575, 
      34.763687}, {-87.418199, 34.769133}, {-87.426086, 
      34.773612}, {-87.430025, 34.775397999999996`}}, {{-87.430025, 
      34.775397999999996`}, {-87.43227999999999, 
      34.776742999999996`}, {-87.429619, 34.788118}, {-87.425843, 
      34.799956}}, {{-87.21452, 34.829139}, {-87.214398, 
      34.81597}, {-87.220505, 34.810482}, {-87.256119, 
      34.788458}, {-87.27619299999999, 34.78106}, {-87.276684, 
      34.774245}, {-87.26596699999999, 34.765685999999995`}, {-87.264803, 
      34.761151999999996`}, {-87.260305, 34.75891}}, {{-87.105126, 
      34.661255}, {-87.105165, 34.666250999999995`}, {-87.10476299999999, 
      34.686237999999996`}}, {{-86.089719, 34.480851}, {-86.09082, 
      34.483581}, {-86.098041, 34.488603}, {-86.098027, 
      34.491329}, {-86.099114, 34.496784}, {-86.10130199999999, 
      34.504968999999996`}, {-86.10126699999999, 34.511783}, {-86.096775, 
      34.517674}, {-86.097871, 34.521312}, {-86.102893, 
      34.520875}, {-86.109026, 34.52135}, {-86.110676, 
      34.525898}, {-86.113449, 34.529087}, {-86.11960499999999, 
      34.525019}, {-86.124603, 34.529578}, {-86.127932, 
      34.533223}, {-86.140802, 34.524632}, {-86.145264, 
      34.524645}, {-86.143534, 34.536906}, {-86.14352799999999, 
      34.538269}}, {{-86.58596, 34.582845}, {-86.590426, 
      34.583296}, {-86.602145, 34.581469}, {-86.612746, 
      34.578279}, {-86.62445199999999, 34.569182}, {-86.632252, 
      34.561451}, {-86.639489, 34.551902999999996`}, {-86.64617899999999, 
      34.548715}, {-86.652317, 34.549161999999995`}, {-86.66850699999999, 
      34.553681999999995`}, {-86.6741, 34.55958}, {-86.674672, 
      34.565937999999996`}, {-86.67469299999999, 34.575023}, {-86.679172, 
      34.581376}, {-86.681967, 34.583189}}, {{-85.086142, 
      31.948791999999997`}, {-85.109353, 31.949081}}, {{-85.41613199999999, 
      31.619457999999998`}, {-85.414947, 
      31.707504999999998`}, {-85.32830899999999, 31.706177}, {-85.217478, 
      31.703139}, {-85.21251099999999, 31.710838}, {-85.2088, 
      31.740906}, {-85.203881, 31.745410999999997`}, {-85.18763899999999, 
      31.750697}, {-85.175658, 31.758768}, {-85.164729, 
      31.768217999999997`}, {-85.15762199999999, 31.77452}, {-85.149019, 
      31.773504}}, {{-87.210494, 34.999905999999996`}, {-87.210343, 
      34.98356}, {-87.21131799999999, 34.967662}, {-87.211214, 
      34.956309999999995`}, {-87.211193, 34.95404}, {-87.211359, 
      34.911353999999996`}, {-87.21275899999999, 
      34.880921}, {-87.21274199999999, 34.879104}, {-87.213656, 
      34.856847}, {-87.214591, 34.836859}, {-87.21457, 34.834588}, {-87.21452,
       34.829139}}, {{-86.99516799999999, 34.679486}, {-86.988986, 
      34.674062}, {-86.982782, 34.665003999999996`}, {-86.976602, 
      34.659577999999996`}, {-86.975979, 34.649134}, {-86.97314399999999, 
      34.642331999999996`}, {-86.957976, 34.627857}}, {{-86.789575, 
      34.550719}, {-86.81023599999999, 34.554753999999996`}, {-86.836466, 
      34.556045}, {-86.85883799999999, 34.567335}, {-86.874484, 
      34.571374}, {-86.88286699999999, 
      34.573617999999996`}}, {{-87.10476299999999, 
      34.686237999999996`}, {-87.09858299999999, 
      34.682182}, {-87.08619499999999, 34.669981}, {-87.065443, 
      34.659637}, {-87.04972699999999, 34.649719}, {-87.039132, 
      34.652493}, {-87.03298, 34.651613}, {-87.023443, 
      34.645751}, {-87.016697, 34.639421999999996`}, {-87.00660599999999, 
      34.634015999999995`}, {-86.999883, 34.630865}, {-86.995404, 
      34.629067}, {-86.98979299999999, 34.625003}, {-86.972966, 
      34.613262}, {-86.970727, 34.612362}, {-86.950009, 
      34.602450999999995`}, {-86.924802, 34.587555}, {-86.906899, 
      34.579896}, {-86.88286699999999, 34.573617999999996`}}, {{-87.105126, 
      34.661255}, {-87.103994, 34.659444}, {-87.10173499999999, 
      34.656276}, {-87.097241, 34.653119}, {-87.094465, 
      34.655405}, {-87.096738, 34.660388999999995`}, {-87.099567, 
      34.664916999999996`}, {-87.10014, 34.666731}, {-87.09961299999999, 
      34.670822}, {-87.097385, 34.671742}, {-87.09289, 
      34.668585}, {-87.091741, 34.664502999999996`}, {-87.091158, 
      34.661325999999995`}, {-87.087243, 34.660892}, {-87.082787, 
      34.662731}, {-87.07663699999999, 34.662307}, {-87.065393, 
      34.652823}, {-87.055314, 34.649692}, {-87.046915, 
      34.647006}, {-87.042436, 34.645665}, {-87.035155, 
      34.642973}, {-87.034025, 34.641161}, {-87.032324, 
      34.637535}, {-87.031195, 34.635723}, {-87.026726, 
      34.635743}, {-87.022255, 34.635309}, {-87.016105, 
      34.634428}, {-87.01273499999999, 34.631718}, {-87.01327599999999, 
      34.62899}, {-87.01269599999999, 34.625813}, {-87.009333, 
      34.624010999999996`}, {-87.003199, 34.6254}, {-86.99873099999999, 
      34.625419}, {-86.994813, 34.624072999999996`}, {-86.99312599999999, 
      34.622263}, {-86.989194, 34.618646}, {-86.981895, 
      34.612317}, {-86.97685, 34.609158}, {-86.975172, 
      34.608709999999995`}, {-86.969572, 34.606007999999996`}, {-86.965091, 
      34.603753999999995`}, {-86.95948899999999, 
      34.600597}, {-86.95276799999999, 34.596989}, {-86.948842, 
      34.593824}, {-86.944368, 34.592479}, {-86.939892, 
      34.590679}, {-86.937646, 34.588415999999995`}, {-86.936509, 
      34.584786}, {-86.933134, 34.580256}, {-86.93368199999999, 
      34.578437}, {-86.933677, 34.577529}, {-86.93700299999999, 
      34.573428}, {-86.942021, 34.5725}}, {{-87.03262199999999, 
      34.680685}, {-87.035811, 34.657050999999996`}, {-87.025162, 
      34.652103}, {-87.011691, 34.642624}, {-86.98983899999999, 
      34.63227}, {-86.968513, 34.615550999999996`}}, {{-86.96185799999999, 
      34.623298999999996`}, {-86.968513, 
      34.615550999999996`}}, {{-86.96185799999999, 
      34.623298999999996`}, {-86.96857899999999, 
      34.626452}, {-86.97251299999999, 34.630524}, {-86.985428, 
      34.641373}, {-86.98991699999999, 34.644534}, {-86.996634, 
      34.646777}, {-87.003362, 34.650382}, {-87.006717, 
      34.650821}, {-87.008957, 34.65172}, {-87.01066, 34.655801}, {-87.011793,
       34.658066999999996`}, {-87.005653, 34.659002}, {-86.99783699999999, 
      34.659943999999996`}, {-86.993341, 34.655875}, {-86.989977, 
      34.654072}, {-86.984966, 34.656819}, {-86.980491, 
      34.655929}, {-86.97771999999999, 34.659574}, {-86.983318, 
      34.661367999999996`}, {-86.987802, 34.66362}, {-86.987264, 
      34.666802}, {-86.988401, 34.669976}, {-86.993419, 
      34.668139}, {-86.996769, 34.66767}, {-86.99734199999999, 
      34.669939}, {-86.996813, 34.674482999999995`}, {-86.99571, 
      34.676759}, {-86.99516799999999, 34.679486}}, {{-86.99516799999999, 
      34.679486}, {-87.000219, 34.682643999999996`}, {-87.00304899999999, 
      34.688083}, {-87.006411, 34.689431}, {-87.008617, 
      34.684878999999995`}, {-87.013632, 34.682586}, {-87.018671, 
      34.683927}, {-87.020342, 34.683011}, {-87.02031699999999, 
      34.679376999999995`}, {-87.02141999999999, 34.677101}, {-87.022528, 
      34.675734}, {-87.025313, 34.674358999999995`}, {-87.027558, 
      34.675711}, {-87.028703, 34.679794}, {-87.03262199999999, 
      34.680685}}, CompressedData["
1:eJwt1Xs81OkeB3Cc6kgu0aaWJTHZnCxWJQn9fliX5FQYud9njNRGImsRsa6x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      "], CompressedData["
1:eJwd03s0lGkcB3CXZqR1KWxWlN10IaVkQ0Tv2xKRcmImYchkBuMySEmUa5NL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      "], {{-88.103122, 34.849872999999995`}, {-88.101992, 
      34.849433999999995`}, {-88.099724, 34.848103}, {-88.098016, 
      34.846762999999996`}, {-88.09629799999999, 
      34.844969999999996`}, {-88.09514, 
      34.843168999999996`}, {-88.09340399999999, 34.840467}, {-88.092806, 
      34.838659}, {-88.093338, 34.837289}, {-88.094439, 
      34.836366}, {-88.09666, 34.835426999999996`}, {-88.10056999999999, 
      34.834919}, {-88.10226, 34.835350999999996`}, {-88.105069, 
      34.835766}}, CompressedData["
1:eJwt2Hdczd8fB/AKrV9LU0jadaOhndS9WkabS9HSQnsqlaZKCqlE45umlBRp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      "], CompressedData["
1:eJwt2Hc41t0fB3BSqYzslVkoFAkR4b5V9si4ESkjhJIiW7YywuMxskeSijJS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      "], {{-86.057414, 34.476189999999995`}, {-86.066913, 
      34.472137}, {-86.077528, 34.467632}, {-86.086455, 
      34.465847}, {-86.089777, 34.469947999999995`}, {-86.088619, 
      34.478121}, {-86.089719, 34.480851}}, {{-87.976828, 
      34.456770999999996`}, {-87.969295, 34.470952}, {-87.96426199999999, 
      34.470107}, {-87.95807099999999, 34.467003999999996`}, {-87.950261, 
      34.466647}, {-87.944165, 34.46854}, {-87.936396, 
      34.470453}, {-87.92806999999999, 34.472373}, {-87.926897, 
      34.469207}, {-87.928527, 34.466915}, {-87.930165, 
      34.465078}, {-87.934598, 34.46366}, {-87.938457, 
      34.461341}, {-87.943421, 34.458553}, {-87.945574, 
      34.454437}, {-87.942695, 34.449475}, {-87.93871899999999, 
      34.445434999999996`}, {-87.931975, 34.442337}, {-87.926378, 
      34.441041999999996`}, {-87.921348, 34.440194999999996`}, {-87.918504, 
      34.437049}, {-87.916176, 34.431625}, {-87.916151, 
      34.430262}, {-87.909975, 34.427611}, {-87.906624, 
      34.427197}, {-87.902709, 34.426335}, {-87.899326, 
      34.424104}, {-87.898122, 34.41912}, {-87.890768, 
      34.412847}, {-87.889597, 34.40968}, {-87.893487, 
      34.409179}, {-87.896271, 34.409146}, {-87.899637, 
      34.410469}, {-87.90526299999999, 34.413582}, {-87.91258599999999, 
      34.418037}, {-87.92100599999999, 34.421569999999996`}, {-87.927191, 
      34.424675}, {-87.933984, 34.430498}, {-87.94299, 
      34.435385}, {-87.949776, 34.440754}, {-87.956015, 
      34.446583}, {-87.96336099999999, 34.451943}, {-87.971222, 
      34.455025}, {-87.97514799999999, 34.456337999999995`}, {-87.976828, 
      34.456770999999996`}}, {{-87.207381, 33.989986}, {-87.21683499999999, 
      33.994019}, {-87.222929, 33.993981999999995`}, {-87.23235, 
      33.994377}, {-87.235678, 33.99481}, {-87.428483, 
      33.996153}}, {{-87.207381, 33.989986}, {-87.207431, 
      33.995441}, {-87.207054, 34.01499}, {-87.207145, 
      34.024989999999995`}, {-87.205523, 
      34.213167999999996`}, {-87.11050499999999, 
      34.210525}}, {{-87.11050499999999, 34.210525}, {-87.11076399999999, 
      34.172803}, {-87.111858, 34.100077}, {-87.11172599999999, 
      34.083259999999996`}, {-87.111701, 34.080079}, {-87.111104, 
      34.074628}, {-87.111583, 34.06508}, {-87.11192, 34.037351}, {-87.111856,
       34.029168999999996`}, {-87.111795, 34.021442}, {-87.111781, 
      34.019622999999996`}, {-87.11225999999999, 34.010075}, {-87.111638, 
      34.001441}, {-87.111567, 33.99235}, {-87.145365, 
      33.993075999999995`}, {-87.150904, 
      33.993044999999995`}}, CompressedData["
1:eJw103s4VHkYB3AxSothRqlmXapx267rkraQU0+YbAzWeVzSUg1KrinbLGUk
00VIUVibSxKGIqmnSTqlkTFGKFKtDIt6jNpS2pJqv/PH/nGe83ye8zvnvO/7
+/4WbY/xCVVXU1PbgUt1X1Rj/fLwQ5IaEhlL1hgSBHPyEDceriwuHfODk584
8f3hWfJLiUvh8TBXZxZ8S9KcSIf7Cmoah7thOxfBw7kEESkT1OfAGprPpRfh
3guuL8Nh7pis2xNWbNI+S8LZyvKcx3MIwnXcgLCGH5yTPTKDc7taX8yF9fmy
niwDgii16rSc6CKpjNnWZ33hBZI9P4tg1jz6YR68ZWbhBR4c2XHHtgQWFARe
6+0kKVPO8zU5cPY4I0II9yvLmpbB70Y0+9zg+XVcNQmTIM6/MBQz4cUK/apH
8PI6G9anBySVEqhjUo71g5b04gHYTBm7Nxf1/V7Zl/cYzhh3l3HQj5jek8OD
hf5fGEJYvvfy6akOkqqNsWQMwkWxCbvz4QgDy38dMC/ei6jIBNj4MvG+DNYc
sDugsvPafSP18KTYJaQafnbs1EnOPIK4f5O9owHur43yDoNdExtP0vG/S/lJ
9XLYa1DL5wf429aiNUo4V3f3knRYWrPpuvl8gtAaciykYDdRYLc3XNMXnMBF
v0EO3kzmAuyHnvM3J/hM2zOGJ1w9lNHOhq+Fn6FVwC2f4z6P4P2WlY2nhuFV
Y4tY/bCWqftVlfltEeJzcGXaKWklPODTMS8RLqj9wjsBB7V46NrBG2qrfj0I
T6zLHG1FP5k0VuQY6gluP1N9HO4+RvtFDouXWdibwnstoqpeox/Np8Y+OrC5
g736W8yHFsM5rw4XLazrd4IVocKMK3LsX7SnuYZqfv9MtQfASZ31AZOYf6Z/
OncG3BRutoGN5zPdpKL4dpLaZZ/VHAI7Rmw+ekNGUr2i1pcCOO/51yA7OJ4T
UcKDZzftmhpvI6mDx/Yrp/E9WlWyvhSeFPBbc+Dczq3McNgsLyJsObx4Or3Y
GjYonCImkBevOKP9DVKSqg/+Tfzu/3zDeYe1+TSsHyH0GqJaSeqi/Cddb7i8
a3i7Dqz9pn80Az4RFvr55H2SSlUFAPX08H2nB1pIqsfRbfimKj+fnrTug2c/
47Z8hKvvhgm0YaPX7OsWmJ9B58a+NxKS8rgVzZgP53dPbVHH83pz0eK/sP6+
1YNGI7iCdYtVDH/VahaYw806GZaHYJHmhzwOXLdzrcMC+JJgg9MB2M9xkpOK
+mZ1BXaNwp5/xLFK0V/B1UqxG+qNMjlyZxrnpyzdY2kaLHg3dM8P7tFsbK+F
2cV3GWU4b+VbN9v2w87Rt5OuwB2xGuuc0b9Ese3paqxfMmDLLIHvWdjEp8B8
U7d4HubnkrxzVArbS7M+zsW8QyuOV76Hxw1T6ppgN9+K6BWoRx5QtGcz9jPl
dJSCDn9/I9qdDytXGzxMgz/Iv/T8DZdMvglV1c+lxZl4Ih9F6iGOqTB1OdtM
C/khhJnGvrD/16QttXBJaL+zIdzQHHx6FfLYoHAJXg8vXP92R7sqz0MntnnC
r0LurZuB/CsOUhoasKO1UuIFG/sOrW1Bve1Bigl/2OqVbtOPcLJqTrAf+2a3
jWoewmnbVPgs2acTy0AeCtOcXsFNHskf2PCq7zaFTarO+2gVP1OfIJ5kjznc
hveNmjCb9Agiek7Abiu41ytiZSlMOfLajqC+P+k8pwY6QXwccE+IhJWDso0M
WNW2ED66oiImX5cgbCRGNGO875zlfY4P/wfee+iD
      "], {{-87.47175299999999, 32.264854}, {-87.45769, 
      32.267253}, {-87.447972, 32.270525}, {-87.438727, 
      32.267868}, {-87.43542699999999, 32.263793}, {-87.43428999999999, 
      32.259245}, {-87.42444599999999, 32.251578}, {-87.41787599999999, 
      32.245706}, {-87.405322, 32.237603}, {-87.396142, 
      32.240411}, {-87.388517, 32.236824999999996`}, {-87.387894, 
      32.229537}, {-87.38242199999999, 32.224567}, {-87.37536, 
      32.222798}, {-87.373651, 32.215063}, {-87.370317, 
      32.20734}, {-87.36487199999999, 32.204647}, {-87.355105, 
      32.202898}, {-87.346436, 32.202508}, {-87.337206, 
      32.200297}, {-87.327972, 32.197631}, {-87.32310299999999, 
      32.198122}, {-87.32144199999999, 32.194488}, {-87.322463, 
      32.188555}, {-87.31755799999999, 32.185399}, {-87.3099, 
      32.177706}, {-87.304987, 32.173638}}, {{-87.304987, 
      32.173638}, {-87.303895, 32.172734}, {-87.300046, 
      32.166835999999996`}, {-87.294101, 32.16779}, {-87.289198, 
      32.164633}, {-87.28532, 32.155543}, {-87.28472099999999, 
      32.149620999999996`}, {-87.279274, 32.146012}, {-87.27117, 
      32.147436}, {-87.26194799999999, 32.145219}, {-87.252719, 
      32.142089999999996`}, {-87.253737, 32.135245}, {-87.263359, 
      32.122872}, {-87.25794499999999, 32.122453}, {-87.252011, 
      32.124316}, {-87.244399, 32.120264}, {-87.238956, 
      32.116652}, {-87.237794, 32.107998}, {-87.23614599999999, 
      32.105274}}, {{-87.804276, 30.552329}, {-87.821784, 
      30.552121}, {-87.82149, 30.566757}, {-87.803978, 
      30.566965999999997`}, {-87.804276, 30.552329}}, {{-87.626841, 
      30.383692}, {-87.644314, 30.383511}, {-87.643988, 
      30.398152999999997`}, {-87.62651199999999, 
      30.398332999999997`}, {-87.626841, 30.383692}}, CompressedData["
1:eJwt0X9Q03UYB/Dxc7Ll2FgiUnFCkkRJRqumJPt+BnHzRBDpOxEVcQrjEhkx
dtvc0OlkFmL8OLggQ7hkl4wmTRjHDVZfTCjNxIQYSoodd97oLrjruikI2Ju7
/njuudc/z89ohWp3gT+LxSKIlRzhyGQNceUMf8/th+tOESp8sv1rB8xrLY8Z
NBEqsLRbt+LzXLb0Krzz9PvtWXDukaSpzJOEUgw8pls4ckbhznojvYJQJy8G
v1APZ0c9WHXOSKi7gwuSs/CNLY6zPgOh9P6HvsmBd6da6AFYOVfdGw8/+kpg
dcMv3rzm8YTImbj8pAgHbPpHO3cZvpLybuxe2PBmhfc0PGUdi50+Tigtr+By
FXzni4fL++G0/axIK1yjmov8V0+okaLO+p9h/V4h1wh36WmlE34q2vhWIvzX
1aYJI2xnan+367B/kVb2NqzoN5hmtYSylPjYN1fJmQzpDDcaVsUZe3mw52m6
b0RDqJ/yhzrG2bif5Pk2HfxDxStiJfw4Ojs5ELYdn295DR6PKJd6ywkVzCua
4cCrrb6Y+/Co5ce7TLCcOZGd09EGu6uqeTK4MuhJQBTs43Bn2fBCb35HAiyX
zW93BuF+X/46vRkueKkvQANrPihsS4RngworY+CMbqo/BVbzy3tsgfhf3upd
kfAmqWONCPZY07xKeMvtY9fcAajX9EQ8Clv8dlxRwMLUB+z1mL9tSSZYByud
TJQQJvFDnw/7y5k20VjcBjjgF0FiLew7IFhUwRz38oZk2Cz8rcsOh+b19/zp
J2e8Qn19OTy95tOLDSw58725VWxCv3SRbDAbPnpkT24aXFvp5Ythv/mweDGc
oxrjjD6nmZ0Jw8xWOHzzqX1auKghYWkH3BI/9U4YrHDxOyWwbmNr1OQyzdRx
DnMJrOkQLDTDSdclxTNqQhW6PNsrYNmuxQg1bG7P7PQu0Ux+3UHJ9TL8b2zk
QhWs7pMbJj4h1Ee21Hv74LXOZ7QJrhH12TfBdQaX6zCc2zu+NgT+oznEooal
t2LpyUWauR8pqDbDjU3KWDt8pqDYWwifKE3WfAsvmWWWl+Fzl8qETvjD0Xs3
HpUSqtozYOte/H8/+NJ6ndEAD9z6LmtcRSiXeaJZCn/2amhqONzC3+oNg9tX
BiwhVMbrXY13ntFMVsL5g7pjhNo20vqeDf7Yc6ZnuJhQZSXC2Ub479CGSd9R
Qh1ayEsphQ+ECy/UwP8BjCXWDg==
      "], {{-87.943736, 34.834232}, {-87.97149, 34.821169}, {-87.979101, 
      34.809264999999996`}, {-87.983842, 34.793762}, {-87.98594899999999, 
      34.786922}, {-87.997061, 34.782693}, {-88.00866099999999, 
      34.774822}, {-88.02018699999999, 34.763318}, {-88.030581, 
      34.751371999999996`}, {-88.036625, 34.745843}, {-88.042, 
      34.73487}, {-88.04356899999999, 34.729399}, {-88.035983, 
      34.7136}, {-88.037516, 34.706312}, {-88.03852499999999, 
      34.700848}, {-88.04744099999999, 34.699368}, {-88.051281, 
      34.695682999999995`}, {-88.060159, 34.692385}, {-88.066728, 
      34.685483}, {-88.07000699999999, 34.681805}, {-88.081696, 
      34.679376}, {-88.0872, 34.675213}, {-88.093558, 34.658319}, {-88.131277,
       34.645078}}, {{-87.82179599999999, 35.006423}, {-87.823152, 
      34.987336}, {-87.824079, 34.975972999999996`}, {-87.82164, 
      34.964648}, {-87.823664, 34.95191}, {-87.83297, 
      34.938635}, {-87.84833499999999, 34.919385999999996`}, {-87.855479, 
      34.91113}, {-87.867673, 34.903268}, {-87.879328, 
      34.896772999999996`}, {-87.88485899999999, 34.892621}, {-87.888626, 
      34.883947}, {-87.89688199999999, 34.875674}, {-87.904527, 
      34.864683}, {-87.91044699999999, 34.851441}, {-87.915939, 
      34.845470999999996`}, {-87.928727, 34.84032}}, {{-87.928727, 
      34.84032}, {-87.933173, 34.838449}}, {{-87.933173, 
      34.838449}, {-87.943736, 34.834232}}, {{-86.72172599999999, 
      34.627635999999995`}, {-86.71743699999999, 34.691234}, {-86.67611, 
      34.7072}, {-86.64032999999999, 34.708157}, {-86.636969, 
      34.704073}, {-86.628574, 34.698631999999996`}, {-86.629108, 
      34.683643}, {-86.611222, 34.683206999999996`}, {-86.61174899999999, 
      34.661404999999995`}, {-86.602251, 34.661414}, {-86.60333, 
      34.632797}, {-86.589924, 34.632354}, {-86.590474, 
      34.625085999999996`}, {-86.587115, 34.617366}, {-86.588781, 
      34.609643}, {-86.588765, 34.595562}, {-86.585974, 
      34.595563999999996`}, {-86.58596, 34.582845}}, {{-86.687136, 
      34.643139999999995`}, {-86.69216399999999, 
      34.643132}, {-86.69215899999999, 34.641315}, {-86.69214099999999, 
      34.634046999999995`}, {-86.708339, 34.634018999999995`}, {-86.70888, 
      34.627659}, {-86.700503, 34.627674}, {-86.700473, 
      34.616318}, {-86.697681, 34.616323}, {-86.698211, 
      34.604966}, {-86.704352, 34.604956}, {-86.704337, 
      34.59905}, {-86.716061, 34.599029}, {-86.715537, 
      34.611295}, {-86.70827799999999, 34.611308}, {-86.70831, 
      34.623118}, {-86.722273, 34.623546999999995`}, {-86.72172599999999, 
      34.627635999999995`}}, {{-86.58596, 34.582845}, {-86.57870199999999, 
      34.581486999999996`}, {-86.55803999999999, 34.56878}, {-86.551895, 
      34.559698}, {-86.549099, 34.549704999999996`}, {-86.550212, 
      34.545615999999995`}}, {{-88.38089699999999, 30.357369}, {-88.382972, 
      30.355504}, {-88.38453899999999, 30.354561999999998`}, {-88.385587, 
      30.354086}, {-88.386656, 30.354526}, {-88.38666599999999, 
      30.354982999999997`}, {-88.386698, 30.356354999999997`}, {-88.386719, 
      30.35727}, {-88.38569199999999, 30.358659999999997`}, {-88.384136, 
      30.360059}, {-88.38257899999999, 30.361458}, {-88.381012, 
      30.362399999999997`}, {-88.379964, 30.362876}, {-88.378356, 
      30.361988}, {-88.37779499999999, 30.360625}, {-88.378293, 
      30.359244}, {-88.38089699999999, 30.357369}}, {{-88.397114, 
      30.348855}, {-88.397791, 30.355248999999997`}, {-88.396203, 
      30.355276}, {-88.394086, 30.355313}, {-88.39092099999999, 
      30.355825}, {-88.39040299999999, 30.356291}, {-88.389344, 
      30.356309999999997`}, {-88.38879399999999, 30.355404}, {-88.389291, 
      30.354022999999998`}, {-88.39082599999999, 30.351709}, {-88.392403, 
      30.351224}, {-88.39397, 30.350282}, {-88.39606599999999, 
      30.349331}, {-88.397114, 30.348855}}, {{-88.383507, 
      30.378828}, {-88.38509499999999, 30.378801}, {-88.38723399999999, 
      30.379679}, {-88.38937299999999, 30.380557}, {-88.389415, 
      30.382386}, {-88.388398, 30.384234}, {-88.38628, 
      30.384269999999997`}, {-88.384671, 30.383383}, {-88.38304099999999, 
      30.381580999999997`}, {-88.381951, 30.380226999999998`}, {-88.383507, 
      30.378828}}, {{-88.388145, 30.373258}, {-88.38972299999999, 
      30.372774}, {-88.39132099999999, 30.373203999999998`}, {-88.392941, 
      30.374547999999997`}, {-88.394021, 30.375445}, {-88.394582, 
      30.376807999999997`}, {-88.39408399999999, 30.378189}, {-88.393036, 
      30.378663999999997`}, {-88.391437, 30.378234}, {-88.389299, 
      30.377356}, {-88.38767899999999, 30.376011}, {-88.387129, 
      30.375106}, {-88.388145, 30.373258}}, {{-88.024737, 
      30.678901}, {-88.022021, 30.675738}, {-88.019305, 
      30.672575}, {-88.017112, 30.668948}, {-88.01705199999999, 
      30.665747999999997`}, {-88.020686, 30.661126}, {-88.02544999999999, 
      30.660145999999997`}, {-88.028132, 30.661481}, {-88.028774, 
      30.667415}, {-88.02935699999999, 30.67015}, {-88.02993099999999, 
      30.672428}, {-88.029468, 30.676091999999997`}, {-88.028465, 
      30.679305999999997`}, {-88.02583399999999, 30.680714}, {-88.024737, 
      30.678901}}, {{-88.37505499999999, 30.217446}, {-88.37084899999999, 
      30.218432999999997`}, {-88.367627, 30.216199999999997`}, {-88.367565, 
      30.213455}, {-88.37017499999999, 30.212038}, {-88.373842, 
      30.210601999999998`}, {-88.375458, 30.211947}, {-88.37654599999999, 
      30.213302}, {-88.377645, 30.215114}, {-88.37505499999999, 
      30.217446}}, {{-88.137142, 30.293554}, {-88.139285, 
      30.294895}, {-88.142449, 30.29439}, {-88.14347, 
      30.292544999999997`}, {-88.14130899999999, 
      30.290288999999998`}, {-88.1413, 30.289831999999997`}, {-88.137078, 
      30.290352}, {-88.136039, 30.291283}, {-88.137142, 
      30.293554}}, {{-88.216466, 30.317508999999998`}, {-88.217033, 
      30.319329999999997`}, {-88.216543, 30.321168}, {-88.214975, 
      30.322108}, {-88.213916, 30.322124}, {-88.21231, 
      30.321233999999997`}, {-88.210695, 30.319886999999998`}, {-88.211176, 
      30.317591999999998`}, {-88.21113799999999, 30.315762}, {-88.212706, 
      30.314822999999997`}, {-88.214822, 30.31479}, {-88.21588899999999, 
      30.31523}, {-88.216466, 30.317508999999998`}}, {{-88.227691, 
      30.322823999999997`}, {-88.226103, 30.322848999999998`}, {-88.223449, 
      30.322433}, {-88.22183299999999, 30.321085999999998`}, {-88.221256, 
      30.318807}, {-88.223843, 30.316021}, {-88.229143, 
      30.316395}, {-88.231297, 30.318192}, {-88.230807, 
      30.320028999999998`}, {-88.229787, 30.321876}, {-88.227691, 
      30.322823999999997`}}, {{-88.349406, 30.393131}, {-88.35095299999999, 
      30.391275}, {-88.350912, 30.389446}, {-88.34876299999999, 
      30.388109999999998`}, {-88.34503699999999, 
      30.387256999999998`}, {-88.34185, 30.386853}, {-88.339192, 
      30.38644}, {-88.337064, 30.386018}, {-88.334957, 
      30.386511}, {-88.333389, 30.387452}, {-88.33341999999999, 
      30.388824}, {-88.335039, 30.390169}, {-88.336648, 
      30.391057}, {-88.339305, 30.391469999999998`}, {-88.341444, 
      30.392349999999997`}, {-88.343572, 30.392771999999997`}, {-88.34571, 
      30.393651}, {-88.34782799999999, 30.393614999999997`}, {-88.349406, 
      30.393131}}, {{-88.297006, 30.370666999999997`}, {-88.298554, 
      30.368812}, {-88.30013199999999, 30.368329}, {-88.30224899999999, 
      30.368294}, {-88.30331799999999, 30.368734}, {-88.303888, 
      30.370555}, {-88.302859, 30.371944}, {-88.30183, 
      30.373334}, {-88.300792, 30.374266}, {-88.298684, 
      30.374758}, {-88.297626, 30.374775}, {-88.29707599999999, 
      30.373869}, {-88.295987, 30.372514}, {-88.297006, 
      30.370666999999997`}}, {{-88.268771, 30.338184}, {-88.27085799999999, 
      30.336778}, {-88.270809, 30.334491}, {-88.27024999999999, 
      30.333126999999998`}, {-88.269172, 30.33223}, {-88.268104, 
      30.331788999999997`}, {-88.267056, 30.332264}, {-88.26654599999999, 
      30.333187}, {-88.265547, 30.335948}, {-88.267174, 
      30.337752}, {-88.268771, 30.338184}}, {{-88.25838399999999, 
      30.322795}, {-88.261578, 30.323658}, {-88.26321399999999, 
      30.32592}, {-88.26379299999999, 30.328197999999997`}, {-88.263851, 
      30.330942999999998`}, {-88.263362, 30.332780999999997`}, {-88.262343, 
      30.334626999999998`}, {-88.261304, 30.335559}, {-88.260795, 
      30.336482}, {-88.261343, 30.337387999999997`}, {-88.26190199999999, 
      30.338752}, {-88.261922, 30.339667}, {-88.261422, 
      30.341047}, {-88.261451, 30.342419}, {-88.26254899999999, 
      30.344231999999998`}, {-88.264136, 30.344206999999997`}, {-88.265773, 
      30.346467999999998`}, {-88.265812, 30.348297}, {-88.265323, 
      30.350134999999998`}, {-88.26482299999999, 30.351516}, {-88.264333, 
      30.353354}, {-88.263882, 30.357021}, {-88.26398999999999, 
      30.362052}, {-88.264579, 30.364787999999997`}, {-88.264089, 
      30.366625}, {-88.263599, 30.368463}, {-88.26203, 
      30.369403}, {-88.25989299999999, 30.368523}, {-88.25879499999999, 
      30.366709999999998`}, {-88.257678, 
      30.363982999999998`}, {-88.25656099999999, 
      30.361255999999997`}, {-88.256492, 30.358054}, {-88.25694299999999, 
      30.354387}, {-88.256884, 30.351643}, {-88.25682599999999, 
      30.348899}, {-88.255709, 30.346172}, {-88.255111, 
      30.342978}, {-88.253975, 30.339336}, {-88.252848, 
      30.336152}, {-88.25277, 30.332493}, {-88.253221, 
      30.328825}, {-88.25421999999999, 30.326064}, {-88.255759, 
      30.323752}, {-88.25838399999999, 30.322795}}, {{-88.105448, 
      30.268855}, {-88.109202, 30.271545999999997`}, {-88.114015, 
      30.274220999999997`}, {-88.117223, 30.276004}, {-88.11987599999999, 
      30.276422}, {-88.12250999999999, 30.275926}, {-88.124061, 
      30.274072999999998`}, {-88.12560099999999, 30.271762}, {-88.125556, 
      30.269475}, {-88.12446299999999, 30.26766}, {-88.12285, 
      30.266312}, {-88.121783, 30.26587}, {-88.120744, 30.2668}, {-88.119176, 
      30.267739}, {-88.118665, 30.268660999999998`}, {-88.11707899999999, 
      30.268684999999998`}, {-88.11547499999999, 
      30.267792999999998`}, {-88.11439999999999, 
      30.266893999999997`}, {-88.112805, 30.26646}, {-88.111738, 
      30.266018}, {-88.109077, 30.265141}, {-88.106935, 
      30.2638}, {-88.10372799999999, 30.262017}, {-88.10104, 
      30.259767999999998`}, {-88.09942699999999, 30.258419}, {-88.097832, 
      30.257983999999997`}, {-88.096238, 30.25755}, {-88.094123, 
      30.257579999999997`}, {-88.093083, 30.258511}, {-88.09311, 
      30.259883}, {-88.094732, 30.261689999999998`}, {-88.100089, 
      30.265272999999997`}, {-88.105448, 30.268855}}, {{-88.060574, 
      30.189418}, {-88.06322399999999, 30.189837999999998`}, {-88.064298, 
      30.190738}, {-88.06537999999999, 30.192096}, {-88.064887, 
      30.193932999999998`}, {-88.063311, 30.194414}, {-88.06119799999999, 
      30.194443999999997`}, {-88.060678, 30.194909}, {-88.060176, 
      30.196289}, {-88.059163, 30.198591999999998`}, {-88.057076, 
      30.199994}, {-88.05442599999999, 30.199574}, {-88.052278, 
      30.197774}, {-88.051698, 30.195035999999998`}, {-88.05217499999999, 
      30.192283}, {-88.054244, 30.189966}, {-88.056348, 
      30.189477999999998`}, {-88.060574, 30.189418}}, {{-88.102818, 
      30.215353}, {-88.101726, 30.213538}, {-88.102227, 
      30.212158}, {-88.103275, 30.211685}, {-88.10538, 
      30.211197}, {-88.106982, 30.212089}, {-88.109123, 
      30.21343}, {-88.112346, 30.216129}, {-88.115589, 30.219742}, {-88.11721,
       30.221549}, {-88.118302, 30.223363}, {-88.118867, 
      30.225185}, {-88.118365, 30.226566}, {-88.117846, 
      30.227031}, {-88.11627899999999, 30.227968999999998`}, {-88.114684, 
      30.227535}, {-88.11361, 30.226636}, {-88.113045, 30.224814}, {-88.11249,
       30.223449}, {-88.110349, 30.222106999999998`}, {-88.109275, 
      30.221207999999997`}, {-88.109248, 30.219835}, {-88.108702, 
      30.218928}, {-88.107627, 30.218028999999998`}, {-88.10602399999999, 
      30.217136999999997`}, {-88.103893, 30.216253}, {-88.102818, 
      30.215353}}, CompressedData["
1:eJxd1Hk0lXkYB/Cb5KLs2zGpuKhbcqNjCbldW/Z9vMZYx9JYOpZjKTNkbVzm
INu4o7QMY1AjlDQoLzNxb8g2J8eowx2lyJXlCo3GfO+/88d73vM57+/5Lc/z
vD+t0DivCDEKhRKIR/Te+tBkFSxBkA/NKvZRLJms4WvrR/thwtZVuHWaycoK
+Ju7m0qQ8ZI+0R/gMN05P0d4iebiycD4uKsN8sWwp3OiXi4sa+87vwTTrRdS
PsD0r+oEwZIEKdfS0+vIZLJi6G1qo/CUPm9XJ/yoR+2wtxRB7tNMo4/Ch7pS
on6HN6PtE4pgE0s63U6aIB87jt+MhEdkXCfnYVOPmeo02GlYqBi2lyDtxWRM
kmHOrRVb+X0EWeamw4mGc23iVpZhhoYkTwyu/NQxXi0Dx9bs6sL+xqad+Vay
BOkRd3bIF9YVv73wGjbI8r+whvOKpdPcS+UI8mavQq0XfDF97o67PPJV/KIq
yYLJKuj7a3oSLprjPj0BUzlbspcUkK9DvxnPmzNZr9M1hkoUCfJJ/5HwN2ZM
ln4Z/yJTiSDNfcsVs+Fqu/efk/D1yoLCVPiKMErlE2xa65lVBueHaASYKxMk
yTOJp2K+o3crRgJhrf0Oalfh7D6Xn4LgKfe+TQOsrzNm8q8tXJlPq42FBZnv
CtThFqWgbG/YrF1q4ynmT/ZN6ZlBvIS+TkgSrJShnDwHd4bEDx2Am+ta6Yuw
UKVW/Xvs32HLsc0d8RZxYfe0Yf695Phm+FXO9aFGnJcyq24khA3vm5vZwEoc
t3cmyFexO/fZFPITE7aYWwl3MLZn0mDT8/7lkzA1mOOiAjce5ZlrIP9Zu7/s
yEa+bWss2NVwc8Na/Sbq0Rr60JyC+um5tameg/cKrp3LgkMG9CamUE9hHU2l
D9akGQtC4SsbjRVSZ5gs7chBnQXUv8X12Gcx8H0ev8wNDi8tudcMG9lljnei
f3wMjjUosVAPma2vJeDA3lvtF+EQrcQID/Tbe2Px/giYxl6LF4NpU1uXouHL
ybMvS9Cvg2nUMwnw4zznIgs4btU/qRUeM6JXUeHlyFl2G7xY+/i4AP2vkHde
MxCueZtV3AP/oRPA1RbNF5SheAPuPhzzpw2M6qQmwqODZTHSsGrXWz0HWJDe
KC0DU4osv2XA3JGWHCc4wrtpWWS1VcnYWth5Vi3IEV4fz3i+DfNbbjzxgp1s
Cq1LrZisgRyhshms80N55zB838cx/BB8cybUTsYa9ZR4nrCN//k2z5sYx/dw
y7aPC7AhczDoAewqJ+00Ct9hV71dg/1O9q82wYWcyTeGiOfvUWiIglNLpDaN
4YNTJ2eOw990jxbth6Oz6/+hwDSvcUYd4gMS7XcGcP9Ms5f8JrBf8R1/XhG8
Us1ZD4WHfpUnwuA3nisZ9vD8A1vGKdhePWFXJIxR9CPwozrqnp9F9UtxP6gK
l56e2ODDCrPGdxf2ECR7+UR2nygfAitJLhy0npnKFcWz2591w94Dzz/SsJ8e
4wtCkU9NSiyx4E6BdWI1XDrrNh8C517b2EmA8yt/SbSD8zbz9C1hvRerJeWY
L6FwOHxHnCD7x/IY9ei3L2b0OtZhKQ+sgH5Vsn1J1cR46bO6yaL76VVneUc4
vHAgNu879H9XcY1ZK+zETFGjw6qM283qOM+PRyaUufh//n9//weaqn0U
      "], CompressedData["
1:eJxF2Hc4V+8bB3Aru8gsq0i+pKSkhE4nIZRR8cHXLGmZSVZGRkZFKCsiKSsz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      "], CompressedData["
1:eJwd1ns41GkUB/BxTSKq7bKlXHKZQrog0b69FOmmaIesoRp3RZJK5NYQEglJ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      "], {{-87.552323, 30.27143}, {-87.545461, 
      30.272409999999997`}, {-87.536495, 30.274326}, {-87.533851, 
      30.27435}, {-87.534426, 30.278005}, {-87.536018, 
      30.278447999999997`}, {-87.539703, 30.27704}, {-87.543939, 
      30.277458}, {-87.548175, 30.277874999999998`}, {-87.55028399999999, 
      30.277396999999997`}, {-87.552382, 30.276004999999998`}, {-87.553416, 
      30.274165}, {-87.553399, 30.272792}, {-87.552323, 
      30.27143}}, {{-87.49024899999999, 30.298544}, {-87.48549899999999, 
      30.299501}, {-87.482871, 30.300897}, {-87.47971299999999, 
      30.302298}, {-87.474958, 30.302798}, {-87.472313, 
      30.302820999999998`}, {-87.468087, 30.303316}, {-87.465447, 
      30.303797}, {-87.462813, 30.304734999999997`}, {-87.461761, 
      30.305201999999998`}, {-87.460168, 30.304758}, {-87.459623, 
      30.30339}, {-87.45907299999999, 30.301565}, {-87.46011999999999, 
      30.300641}, {-87.462749, 30.299246}, {-87.46644599999999, 
      30.298755999999997`}, {-87.46907999999999, 30.297817}, {-87.471719, 
      30.297337}, {-87.47488799999999, 30.296851}, {-87.478585, 
      30.296360999999997`}, {-87.481224, 30.29588}, {-87.483334, 
      30.295403}, {-87.485968, 30.294463999999998`}, {-87.489125, 
      30.293063999999998`}, {-87.49439199999999, 30.291186}, {-87.500198, 
      30.290218}, {-87.504429, 30.29018}, {-87.50811999999999, 
      30.289230999999997`}, {-87.51234, 30.288276999999997`}, {-87.518664, 
      30.286388}, {-87.524987, 30.284499}, {-87.528138, 
      30.282639999999997`}, {-87.531311, 30.28261}, {-87.532386, 
      30.283973}, {-87.531356, 30.28627}, {-87.529258, 
      30.287661999999997`}, {-87.526097, 30.288607}, {-87.52398699999999, 
      30.289084}, {-87.521354, 30.290024}, {-87.518192, 
      30.290968}, {-87.516082, 30.291445}, {-87.512391, 
      30.292393999999998`}, {-87.51080999999999, 
      30.292866}, {-87.50871099999999, 30.294258}, {-87.50873299999999, 
      30.296087999999997`}, {-87.50769799999999, 
      30.297926999999998`}, {-87.50612199999999, 
      30.298856999999998`}, {-87.504012, 30.299333999999998`}, {-87.502425, 
      30.299348}, {-87.499775, 30.298914999999997`}, {-87.49659, 
      30.298029}, {-87.493946, 30.298053}, {-87.49024899999999, 
      30.298544}}, {{-88.097922, 34.896269}, {-88.108066, 
      34.898855999999995`}, {-88.118229, 34.902349}, {-88.127282, 
      34.906310999999995`}, {-88.136375, 34.912089}, {-88.144396, 
      34.920152}, {-88.15239, 34.926852}, {-88.159893, 
      34.936737}, {-88.165174, 34.947562}, {-88.169287, 
      34.956132}, {-88.174512, 34.964231999999996`}, {-88.18025899999999, 
      34.970507999999995`}, {-88.188311, 34.979475}, {-88.199371, 
      34.997479999999996`}, {-88.20285799999999, 35.002879}, {-88.201866, 
      35.008797}, {-88.183899, 35.008601999999996`}}, {{-88.183899, 
      35.008601999999996`}, {-88.07945199999999, 
      35.006873999999996`}, {-87.945871, 35.007686}, {-87.82179599999999, 
      35.006423}}, {{-87.82179599999999, 35.006423}, {-87.775763, 
      35.006024}, {-87.620267, 35.004885}, {-87.321077, 
      35.001909}, {-87.210494, 34.999905999999996`}}, {{-87.210494, 
      34.999905999999996`}, {-87.024142, 34.995889999999996`}, {-86.88439, 
      34.992343999999996`}, {-86.783383, 34.992632}}, {{-86.783383, 
      34.992632}, {-86.71884899999999, 34.992315}, {-86.419196, 
      34.990674999999996`}, {-86.31594299999999, 34.991921}, {-86.310893, 
      34.991913}}, {{-85.58349199999999, 34.862248}, {-85.60559099999999, 
      34.985481}, {-85.82495999999999, 34.988763}, {-86.11786599999999, 
      34.990080999999996`}, {-86.310893, 34.991913}}, {{-85.58349199999999, 
      34.862248}, {-85.572999, 34.803126}, {-85.53227, 
      34.613845}, {-85.513305, 34.524647}}, {{-85.513305, 
      34.524647}, {-85.490175, 34.416318}, {-85.449394, 
      34.219649}, {-85.44680699999999, 34.205537}, {-85.445239, 
      34.198251}, {-85.411493, 34.029762999999996`}, {-85.398563, 
      33.964178}}, {{-85.398563, 33.964178}, {-85.37380999999999, 
      33.837545}, {-85.33635799999999, 33.642084}, {-85.305148, 
      33.482561}}, {{-85.305148, 33.482561}, {-85.299553, 
      33.452477}, {-85.264037, 33.26191}, {-85.23302799999999, 
      33.108197}}, CompressedData["
1:eJwV030w1HkcB3Bljrse5pAsOechcU6sw5Vykw+71lqsh/O79Uwr52GiEe5E
mG6bOtU1te6m3C5z7pQ8h+UuMn4R606ZtOMq6jo6J0UPukKe7r1/fOc7r5nv
e77v+T5YSw+EJa3V0dERYWhnt4UvFebEsL8xBrqx3kTf/9R1aytcuVQ5UgVP
rWszDIbHo2b2cn2IBEO6ljJ4q2PXhj6Yw9s11AAvTqayVjyiTVLn6hE41LCq
ZD/Mk9iELMP9eWmvh+Eks/EIjjfDTkk1Ims+0TnTgf8CYN5KqfdheEWz0TgX
ZgwzXGvg1ocjxXJ4TKO82q/1QtHwWXiL6aHITb5EJD7v8iOsavxMGAyPe37y
tBc+uX9ysRpuKbkWOgt/PNFq1A7PLys49j4MK33tZ6onILKlIKdoWOPf1q6E
5f17+pvhBI87Ljw/ovUJf7BreAyrdtgtH4ADOUjCUU6X1XwhUc4pR+fT8LSL
3XInLH+cZDwAS+csehL9ifI4z9Uz8N2EMdub8PMTfxc58hnW5v6+cDMR0VHl
3Gom7O073JgNv8N9u+42rNbM6koCkN9pYqzny7DtHYPHlmDJNLfDHo4/N+b1
IJDIO9EulAuHr7RePRhEVNvA+3Qb3G08cXseDt9RV70d9njf3qVMTDTjk1Um
gEdPLCfNwQ438pWp8Ma/JBM+wTjfJZYph9VHJANlcLN/4fVG+OWLct0BuPqe
bj0Lu5mdnnQLIdrxVfGTejjPdfWxAlaaykuKtX2TY3+ZgKVCsV0GXLeadZ4b
SlSeV3ktHc6sFkXHwP8Y+X34LSzOFw0Ww5uzDLJVcMbxY72X4JZDH+i9gr/7
9Yc4Bbzt96wCSwHDRqt00mthVd2i2gfeks4Y3YPtlsK8DsCcZzGmU/CbwZRa
OawyL7ihH0bUV1HIaYNtenWK7eC0zocparicZ1YjhUv/vNjUCQsuZy53wLI3
Tx5VwCsv41pdPyfSe2EiDIEVOX1zvfBQxKLnKPq91QhydocTWTfql4zD8sjO
nhk4PPORibZ/qaMsTcYQKS5duLIZ+bMfoTmcuusWLx0O6Q4c7fqCaM/aovkF
2H2kxrZZQlTQaO3h7Mew+7xOXhBG4L+sSXaIhL9OnmlbH4l81b8HZXCPxjHJ
LIrI3MC6QQlb2Qea3oQrth8uqIdb4jZM8KOJ+A/0rVrhu/4FkSPwtGhA2Anz
jxYZuscQGb/r2VsDTxWKvQvhpxa4CfhO5ajRFbjSXaHeC9+XGZzhxuL9+voq
xdr1gojw63CTC18cD5e/F2QUEEf06oyD5Tdwdr5/ogr283DKHdL2n51qcoon
2tn9s41YyLAW5kdyY+FTKZ4Xn8HYxaUI/h9qbRMM
      "], {{-85.001685, 32.510650999999996`}, {-85.000658, 
      32.507448}, {-84.999708, 32.500144999999996`}, {-84.99924999999999, 
      32.495582999999996`}, {-84.99879299999999, 
      32.491020999999996`}, {-84.998361, 32.485092}, {-84.99847199999999, 
      32.479169999999996`}, {-84.998558, 32.474615}, {-84.998644, 
      32.47006}, {-84.99872099999999, 
      32.465959999999995`}, {-84.99774699999999, 32.460023}, {-84.996194, 
      32.455902}, {-84.993556, 32.451766}, {-84.989271, 
      32.448519}, {-84.98552099999999, 32.445735}, {-84.980133, 
      32.443385}, {-84.976357, 32.441967}, {-84.972599, 
      32.439637999999995`}, {-84.969937, 32.436868}, {-84.967826, 
      32.43365}, {-84.966267, 32.429983}, {-84.966337, 32.426339}, {-84.96857,
       32.423179}, {-84.971346, 32.420027}, {-84.975742, 
      32.417352}, {-84.97904299999999, 32.415118}, {-84.980172, 
      32.412855}, {-84.98187, 32.409231999999996`}, {-84.98248199999999, 
      32.405595}, {-84.980398, 32.40101}, {-84.977744, 32.397784}, {-84.97398,
       32.395911}, {-84.972386, 32.394065999999995`}, {-84.972413, 
      32.3927}, {-84.974058, 32.39181}, {-84.977857, 
      32.391861999999996`}, {-84.982208, 32.391464}, {-84.98601599999999, 
      32.391059999999996`}, {-84.98876399999999, 
      32.389272999999996`}, {-84.989893, 32.38701}, {-84.989402, 
      32.384268999999996`}, {-84.988351, 32.382432}, {-84.98617999999999, 
      32.382403}, {-84.982382, 32.382352}, {-84.978583, 
      32.382301}, {-84.975353, 32.380891}, {-84.974302, 
      32.379054}, {-84.97433699999999, 32.377231}, {-84.97651599999999, 
      32.376805}, {-84.97979, 32.375938}, {-84.982512, 
      32.375518}, {-84.98526799999999, 32.373277}, {-84.986931, 
      32.371476}, {-84.98754199999999, 32.367839}, {-84.987603, 
      32.364649}, {-84.988748, 32.361475}, {-84.992055, 
      32.358784}, {-84.995345, 32.357005}, {-84.9981, 
      32.354763}}, {{-84.91946999999999, 32.242481}, {-84.919443, 
      32.243848}, {-84.920508, 32.244775}, {-84.924292, 
      32.245283}, {-84.926468, 32.244858}, {-84.92809299999999, 
      32.24488}, {-84.9297, 32.245813999999996`}, {-84.929664, 
      32.247637}, {-84.92798499999999, 32.250349}, {-84.92524, 
      32.252134}, {-84.92253099999999, 32.252096}, {-84.920373, 
      32.25161}, {-84.91712199999999, 32.251565}, {-84.914414, 
      32.251526999999996`}, {-84.91114499999999, 32.252392}, {-84.908408, 
      32.253721}, {-84.90566299999999, 32.255506}, {-84.90452499999999, 
      32.258224999999996`}, {-84.903386, 32.260943}, {-84.901192, 
      32.26228}, {-84.899557, 32.262712}, {-84.89738899999999, 
      32.262682}, {-84.896315, 32.262211}, {-84.894689, 
      32.262188}, {-84.89357799999999, 32.263539}, {-84.89356, 
      32.264451}, {-84.895682, 32.26676}, {-84.89943799999999, 
      32.268636}, {-84.90427, 32.270984}, {-84.910159, 
      32.274713}, {-84.919264, 32.28031}, {-84.926193, 
      32.286332}, {-84.932563, 32.293258}, {-84.937371, 
      32.296971}, {-84.94218699999999, 32.300227}, {-84.946489, 
      32.30211}, {-84.95133299999999, 32.303999}, {-84.957803, 
      32.305911}, {-84.966408, 32.309674}, {-84.97825, 
      32.314392}, {-84.991186, 32.318667}, {-84.999802, 
      32.321971999999995`}, {-85.005156, 32.325689}, {-85.00835099999999, 
      32.328921}, {-85.009333, 32.334403}, {-85.00979099999999, 
      32.338967}, {-85.008061, 32.344412999999996`}, {-85.00417, 
      32.349375}, {-84.99976199999999, 32.352962}, {-84.9981, 
      32.354763}}, {{-85.0598, 32.062915}, {-85.06520499999999, 
      32.062984}}, {{-85.0598, 32.062915}, {-85.060422, 
      32.058363}, {-85.06219899999999, 32.049723}, {-85.061757, 
      32.044245}, {-85.061847, 32.039231}, {-85.061945, 
      32.03376}, {-85.06200199999999, 32.030569}, {-85.06153499999999, 
      32.026458999999996`}, {-85.060512, 32.023254}, {-85.060013, 
      32.020967999999996`}, {-85.059513, 32.018682}, {-85.060643, 
      32.01596}, {-85.062305, 32.013701}, {-85.06562699999999, 
      32.009184}, {-85.067837, 32.006476}, {-85.070611, 
      32.002407}, {-85.073425, 31.996059}, {-85.073482, 
      31.992866999999997`}, {-85.074111, 31.987859}, {-85.07319299999999, 
      31.978727}, {-85.07109, 31.975507999999998`}, {-85.070591, 
      31.973222}, {-85.071719, 31.970499999999998`}, {-85.074991, 
      31.968716999999998`}, {-85.078287, 31.965567}, {-85.08317799999999, 
      31.963804}, {-85.086457, 31.961565}, {-85.08812499999999, 
      31.958849999999998`}, {-85.088197, 31.954746}, {-85.086658, 
      31.950166999999997`}, {-85.086142, 
      31.948791999999997`}}, CompressedData["
1:eJwV0nlME1YcB/CCgMK0HsOFijIctwjCCCjzeE9EoLix2bWDmQ504Zw4xjVg
ShClYDScQ6ZCiiCQaYmlDOkUpJVToZkyyjEKDOQq0snhgCHr2Jc/Xl4++b78
8vvl93Z/HcUJ0WUwGD44a/c/LvVfXj7Ok/fVcDaMzRNqzXJ/5zysl6W3IxKO
veTmfgEubuFYBs0R+kOz+qEArjKtdWifJbQ/625dNfxdUiWLBbsrZxp74M22
hTGCGUJnffMm38JGv04ud70mdDxRv9TGiyfneFTdC4RVFYl8LryslPhO/UXo
1uakA6mw1mcr6ws440TWwXK4aGk1ulFDaGjISo4U3vauctYBHtRszlfBkieN
7FvThG4TFMSvwm+yPo+zhN9f6LXf682TH2TttBK/IpSbGbjpM9hsKPa0O2zg
/UwUC6t7ez5dnSK07pfvVQK41NBYcgWWT7uEJcPROuH5jrDmhJtZJHzeHh2o
CU09kmvDhuvb+ysS4ZbhM/374da/06zM4NCGy8UHYMcoZu83k4S2Oucd9oBX
7m/4TzpB6Prd5kFrlt4oNr0F6z4wOfTxWi5qSxaNExo4G+EXCAf8W1HFgW01
pepU2GLR8LYJzA5dYErX3udI+doxQn/e+WOLFj7are5mID+tl3nT04cn91gn
iZxAbqJJP3cNvuNePd8Bv5yUrRfDTPuB+Vz4J+65/U9gmxDOMVM4oajU4iG8
Z8fZlLBRQlMySmkxrGbfVL54Sei3TsozAtjgEoP1EZxw2y8pDvaMiJoVjBBa
LTyVHA9bSq0HC4Yx39756Qy4prk9fOxPQr1zfCV34GWvuOePhgg1KtRxfApP
li1ligcJ/ZDBjR6FBxM2ZmsHCD0q/KphAa4uZGnD4QtFEY2LcN7Ui6kkFaH8
MeH913C+cMqqtZ/QlUNeSROwKuKspxOssEhxmoWbCl0Tg/4glJYIj+iyeXJz
jbHIAL7oI0veBb8ns6vk9hFay2QuWsPpu1rLZL2EBuvLNjnDJRt5ztd7sL8C
i2BzOKBt7lh5N2ylqNGivsRZbMGE4+P4mRq49xM78XUlobKu4FYV3Gm2r6yp
i9ARI1tlF5zzeEg79zuh6zymRzpgP36WvzlcLtQvqYcT9gwLJ58T+iamL7kN
PlXkrDD8jdCZ6ArDtXrjU/yTvgr8D9vj9ktwoF3HlrZ2Ql2WQwtN0Z8oO6Oh
7hnm7xxdcoMfcyMV008JffD21T0Kl6W7MUzhYHfD8n2wTRrzUVoboVcP12Rv
hxVq7yY7OLdTh92H+gNbRl3FrYT6bG8RVcLGihuXXOGYkw4fXIWv2FpHXWwh
1CxSogqD4wNGCrKbCZ2+2+3vD3vp+9WmNhH6P1pRL0Y=
      "], {{-87.866754, 30.225869}, {-87.86464, 
      30.225894999999998`}, {-87.857778, 
      30.226437999999998`}, {-87.85197199999999, 30.226967}, {-87.843502, 
      30.226156}, {-87.833439, 30.224905999999997`}, {-87.824984, 
      30.225008}, {-87.816543, 30.226025}, {-87.808103, 
      30.227041}, {-87.805996, 30.227524}}, {{-87.866754, 
      30.225869}, {-87.86643, 30.238228}}, {{-87.77683499999999, 
      30.255779999999998`}, {-87.772634, 30.257659}, {-87.77054799999999, 
      30.259513}, {-87.76899, 30.261362}, {-87.767439, 
      30.263666999999998`}, {-87.76588799999999, 30.265973}, {-87.762772, 
      30.269669}, {-87.76069299999999, 30.271981}, {-87.758613, 
      30.274293}, {-87.75759699999999, 30.27705}, {-87.756039, 
      30.278897999999998`}, {-87.754988, 30.279366999999997`}}, {{-87.866754, 
      30.225869}, {-87.87944399999999, 30.226167999999998`}, {-87.893199, 
      30.226909}, {-87.904304, 30.227224999999997`}, {-87.91435299999999, 
      30.227553999999998`}, {-87.927044, 30.227846999999997`}, {-87.938678, 
      30.228153}, {-87.951881, 30.227521}, {-87.964556, 
      30.226895}, {-87.971954, 30.226796}, {-87.97775, 
      30.225803}, {-87.986717, 30.224767}, {-87.995676, 
      30.223271999999998`}, {-88.006722, 30.220375999999998`}, {-88.0162, 
      30.218415}, {-88.023043, 30.216946999999998`}, {-88.027253, 
      30.215972999999998`}, {-88.030423, 30.215929}, {-88.032562, 
      30.217271999999998`}, {-88.03313299999999, 
      30.219552}, {-88.03316799999999, 30.221382}, {-88.032128, 
      30.222312}, {-88.030577, 30.224164}, {-88.027985, 
      30.226945999999998`}, {-88.026979, 30.229706}, {-88.024883, 
      30.230649999999997`}, {-88.021209, 30.232073999999997`}, {-88.017518, 
      30.232582999999998`}, {-88.01329, 30.232640999999997`}, {-88.005371, 
      30.233207}, {-87.999566, 30.233745}, {-87.99324899999999, 
      30.235204}, {-87.987436, 30.235281999999998`}, {-87.984265, 
      30.235325}, {-87.980037, 30.235381999999998`}, {-87.976337, 
      30.235432}, {-87.972134, 30.236862}, {-87.970557, 
      30.23734}, {-87.96846699999999, 30.238740999999997`}, {-87.966337, 
      30.237854}, {-87.965784, 30.236489}, {-87.965751, 
      30.234658999999997`}, {-87.964686, 30.234215}, {-87.96309199999999, 
      30.233779}}, {{-87.900784, 30.237795}, {-87.90822299999999, 
      30.239988}, {-87.911954, 30.24177}, {-87.91462, 
      30.243108999999997`}, {-87.91726299999999, 
      30.243074999999997`}, {-87.918864, 30.243969}, {-87.919433, 
      30.24625}, {-87.920529, 30.248524}, {-87.921618, 
      30.250339999999998`}, {-87.924301, 30.252592999999997`}, {-87.928041, 
      30.254832999999998`}, {-87.931781, 
      30.257071999999997`}, {-87.93656299999999, 
      30.258381999999997`}, {-87.940263, 30.258333999999998`}, {-87.945013, 
      30.257814}, {-87.948169, 30.256857}, {-87.951324, 
      30.255899999999997`}, {-87.953935, 30.254035}, {-87.95496, 
      30.252191}, {-87.95440699999999, 30.250826}, {-87.95332599999999, 
      30.249467}, {-87.952781, 30.248559}, {-87.95487899999999, 
      30.247615999999997`}, {-87.957002, 30.248046}, {-87.960173, 
      30.248003999999998`}, {-87.9628, 30.247054}, {-87.964361, 
      30.245659999999997`}, {-87.96486499999999, 30.24428}, {-87.963247, 
      30.242472}, {-87.96111599999999, 30.241584999999997`}, {-87.957929, 
      30.240712}, {-87.95579099999999, 30.239366999999998`}, {-87.955766, 
      30.237994999999998`}, {-87.95732799999999, 30.236601}, {-87.960995, 
      30.234721999999998`}, {-87.96309199999999, 30.233779}}, {{-87.86643, 
      30.238228}, {-87.870122, 30.237724999999998`}, {-87.886499, 
      30.237060999999997`}, {-87.900784, 30.237795}}, {{-87.806895, 
      30.25085}, {-87.810074, 30.251269999999998`}, {-87.817482, 
      30.251638999999997`}, {-87.823833, 
      30.252019999999998`}, {-87.82699699999999, 30.251524}, {-87.829089, 
      30.250125999999998`}, {-87.830653, 30.248735}, {-87.833274, 
      30.247329999999998`}, {-87.836438, 30.246834}, {-87.840659, 
      30.246325}, {-87.845401, 30.245351999999997`}, {-87.84907899999999, 
      30.243934}, {-87.851692, 30.242071}, {-87.85325499999999, 
      30.240679}, {-87.85535399999999, 30.239738}, {-87.85957499999999, 
      30.239227999999997`}, {-87.863795, 30.238718}, {-87.86643, 
      30.238228}}, {{-87.77683499999999, 30.255779999999998`}, {-87.781036, 
      30.253901}, {-87.78840799999999, 30.251984}, {-87.79843, 
      30.250493}, {-87.806895, 30.25085}}, {{-87.741191, 
      30.276321}, {-87.754988, 30.279366999999997`}}, {{-87.741191, 
      30.276321}, {-87.74121199999999, 30.277694}, {-87.741782, 
      30.280431999999998`}, {-87.742902, 30.284537999999998`}, {-87.745065, 
      30.287716}, {-87.74613699999999, 
      30.288618999999997`}, {-87.74825899999999, 
      30.289051999999998`}, {-87.750361, 30.288113}, {-87.751398, 
      30.286728999999998`}, {-87.751363, 30.284442}, {-87.75132099999999, 
      30.281696999999998`}, {-87.753416, 30.280299999999997`}, {-87.754988, 
      30.279366999999997`}}, {{-87.725856, 30.276493}, {-87.72423599999999, 
      30.274224}, {-87.724195, 30.271479}, {-87.72469, 
      30.269185}, {-87.72729199999999, 30.266410999999998`}, {-87.731481, 
      30.263619}, {-87.73409699999999, 30.261758999999998`}, {-87.736205, 
      30.261277999999997`}, {-87.738841, 30.260790999999998`}, {-87.740963, 
      30.261224}, {-87.74256299999999, 
      30.262120999999997`}, {-87.74365499999999, 30.264397}, {-87.743168, 
      30.267148}, {-87.742159, 30.270362}, {-87.741143, 
      30.273118999999998`}, {-87.74117, 30.274949}, {-87.741191, 
      30.276321}}, {{-87.754196, 30.296763}, {-87.751565, 
      30.297708}, {-87.748927, 30.298195}, {-87.74575399999999, 
      30.298232}, {-87.74310899999999, 30.298261}, {-87.740465, 
      30.298291}, {-87.738315, 30.296028}, {-87.73880899999999, 
      30.293734999999998`}, {-87.739324, 30.292814}, {-87.739283, 
      30.290069}, {-87.73819, 30.287793999999998`}, {-87.73762699999999, 
      30.285511999999997`}, {-87.736549, 30.284152}, {-87.734392, 
      30.281430999999998`}, {-87.73332099999999, 
      30.280528}, {-87.73013399999999, 30.279647999999998`}, {-87.727999, 
      30.278299999999998`}, {-87.725856, 30.276493}}, {{-87.83882799999999, 
      30.361188}, {-87.836659, 30.358012}, {-87.83449, 
      30.354836}, {-87.83124699999999, 30.350758}, {-87.827469, 
      30.346228}, {-87.823698, 30.342156}, {-87.818832, 
      30.33581}, {-87.81293099999999, 30.330848}, {-87.806523, 
      30.327264}, {-87.80010899999999, 30.323223}, {-87.794753, 
      30.319169}, {-87.789949, 30.31648}, {-87.784086, 
      30.313803999999998`}, {-87.779282, 30.311114999999997`}, {-87.773928, 
      30.307059}, {-87.771777, 30.304796}, {-87.769605, 
      30.301160999999997`}, {-87.764746, 30.294812}, {-87.762574, 
      30.291176}, {-87.76043, 30.289371}, {-87.758837, 
      30.288932}, {-87.757257, 30.289406999999997`}, {-87.757814, 
      30.291231}, {-87.757842, 30.293060999999998`}, {-87.756812, 
      30.294902999999998`}, {-87.754196, 30.296763}}, {{-88.43046799999999, 
      31.11403}, {-88.42455799999999, 30.999917}, {-88.416815, 
      30.852446999999998`}, {-88.41012099999999, 
      30.703083999999997`}, {-88.40510599999999, 
      30.556390999999998`}, {-88.402101, 30.472744}}, {{-88.46275299999999, 
      31.697854999999997`}, {-88.458028, 31.592064999999998`}, {-88.450682, 
      31.443845}, {-88.441188, 31.294252}, {-88.432373, 
      31.149169999999998`}, {-88.43046799999999, 
      31.11403}}, {{-88.46275299999999, 31.697854999999997`}, {-88.088166, 
      31.699225}}, {{-88.420812, 32.308772999999995`}, {-88.42618499999999, 
      32.261732}, {-88.444785, 32.112789}, {-88.463878, 
      31.964706999999997`}, {-88.472004, 31.899797}, {-88.468902, 
      31.817285}, {-88.464897, 31.741619999999998`}, {-88.46275299999999, 
      31.697854999999997`}}, {{-88.33837299999999, 
      32.991631999999996`}, {-88.355831, 32.849737}, {-88.372596, 
      32.704174}, {-88.39087699999999, 32.55627}, {-88.408558, 
      32.408792999999996`}, {-88.420812, 32.308772999999995`}}, {{-88.172168, 
      32.996009}, {-88.29572999999999, 32.992765999999996`}, {-88.301745, 
      32.992671}, {-88.33837299999999, 
      32.991631999999996`}}, {{-88.27341299999999, 
      33.534234999999995`}, {-88.28310599999999, 33.451738}, {-88.301075, 
      33.299476999999996`}, {-88.31908, 33.15173}, {-88.336933, 
      33.000306}, {-88.33837299999999, 32.991631999999996`}}, {{-88.204943, 
      34.0587}, {-88.206317, 34.045496}, {-88.22801299999999, 
      33.898775}, {-88.247367, 33.749781999999996`}, {-88.265536, 
      33.600318}, {-88.27341299999999, 33.534234999999995`}}, {{-88.173435, 
      34.321422999999996`}, {-88.188447, 34.193039}, {-88.204943, 
      34.0587}}, {{-88.107936, 34.812109}, {-88.11124699999999, 
      34.782993999999995`}, {-88.131277, 34.645078}}, {{-88.105069, 
      34.835766}, {-88.107936, 34.812109}}, CompressedData["
1:eJxF13s01dkXAPBrXGJSlKZSKUaZlDeJ6Pvdh6KiKJMYmlteeYaUolIiJUoh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      "], CompressedData["
1:eJxNV3k0lfkbd11JyJbQlJCSyM6lkEnSVEak542YbFe62uNoUWRSUyfTlMnW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      "], CompressedData["
1:eJxF1wk0ldsXAPArY6VSGh7lRUrGjMn4ffs0GKIiZYgiU5kyVB4qEipFKjKE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      "], CompressedData["
1:eJxdV3s41Fkfnxm3ldY9S4SWQgnjmkRDIUm6OL/tYrHuprZUFqUUtS5dSLkb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      "], {{-88.131277, 34.645078}, {-88.133262, 
      34.633238999999996`}, {-88.140549, 34.5818}}, {{-88.140549, 
      34.5818}, {-88.153617, 34.488020999999996`}, {-88.171026, 
      34.338727}, {-88.173435, 34.321422999999996`}}, {{-88.097922, 
      34.896269}, {-88.103122, 34.849872999999995`}}, {{-88.103122, 
      34.849872999999995`}, {-88.105069, 34.835766}}, {{-85.678694, 
      34.340101}, {-85.680853, 34.346478}, {-85.67801299999999, 
      34.351911}, {-85.683554, 34.354222}, {-85.68453799999999, 
      34.366496999999995`}, {-85.694557, 34.366566999999996`}, {-85.695033, 
      34.374294}, {-85.69058, 34.374263}, {-85.690061, 34.370625}, {-85.68283,
       34.37012}, {-85.678972, 34.366458}, {-85.679029, 
      34.361005999999996`}, {-85.676266, 34.359169}, {-85.673502, 
      34.357330999999995`}, {-85.67072, 34.357312}, {-85.671233, 
      34.361405}, {-85.667288, 34.365919999999996`}, {-85.655023, 
      34.36765}, {-85.64943199999999, 34.369881}, {-85.646052, 
      34.373491}, {-85.639949, 34.371629}, {-85.635471, 
      34.373867}, {-85.63479799999999, 34.384313}, {-85.63464499999999, 
      34.397943}, {-85.630211, 34.396091999999996`}, {-85.630697, 
      34.402457}, {-85.626273, 34.399698}, {-85.62664, 
      34.416512}, {-85.618843, 34.416453}, {-85.61862599999999, 
      34.435534}, {-85.627534, 34.436056}, {-85.627933, 
      34.450143}, {-85.606197, 34.450433}, {-85.606696, 
      34.455435}, {-85.606866, 34.489056}, {-85.618573, 
      34.489145}, {-85.619074, 34.494146}, {-85.63691899999999, 
      34.493826}, {-85.636843, 34.50064}, {-85.644092, 
      34.500693}, {-85.641218, 34.508395}, {-85.625605, 
      34.508279}, {-85.61896999999999, 34.503232}, {-85.612832, 
      34.50364}, {-85.612332, 34.498638}, {-85.593375, 
      34.498492999999996`}, {-85.59303, 34.480317}, {-85.57463, 
      34.480627}}, CompressedData["
1:eJwt1Hs41FkYB3BtJoldpW0pKqUxubQ1sboYe47cVUhN0YQxEWlD922LpHKr
2Tak1FqKkWZRmUxGaqah6aqQWrlEm0o3rUWiwX7nefaP3/N7Ps97znnf857z
+80QRPuFfaWlpbURj+b94pk6McWTqyArL/C0VYRuuGZ8V+MrFq2Zt28S6sbw
lu6HZc199d/CPPOELTFwNSN3RUU1oWRhzuLVcEn8EsdYeOmOUXNt4UdzHKoJ
bHF+GVsHbrS2KZ8OL74V/77Pg6v4m/vE/mYVoTJ1Um8z7JJfELgMjnAo6LoL
M8VXxkiVhGaamecq4YuHz+r8CE9doI6qgPtXz7IovEHoK8764FJ4UM9R0Ksg
9LVvovikx//5YV6gt24y/Oaf8SofOaFtPsITUXBW1w6/4OuEDgukoVxYKR87
xfYaoZ7ui04uhzkePsecKwk1+X6rzxr4QILf5a1XCZ0QM5YbCU+3nFllVUFo
04rf836FL4ncVzrKCJVk2LDOwIGiq+9+Kie0W1q/SQLPv3M7oPEKoVtuj6m/
Cc9sEzUwYXmtudtDOM1xSc1vUkL93keYvoUlvHuhC+FC39Z1avh10gRlXhmh
1nMHcjQO5pGhcLjff7CWgf6ueVVc8Q1stPdUuhGsaUv3ZUKLr+4WO8O93oyW
Htjli/+NaFjPuaO3D3bbKQrLhw0sx3jYYf5p1ae1tfA460mrVsEhX+4YT/fi
KiKKhrI/wCo2KoWDuhvMv0Z9s09vPbQL3hwzc7AMcWOzOu1UeHJMZtpLrL8v
snJ7OpzyYP5hXzhYN7+6BB447ZscLyF0IJ6G18NtSQcOzobju+5lfYDTN40L
3VlKqEGI2q4LJmp1f/slQlPNHlTpLuUqkkT7pz++SGhH5cjRiXDqHRP+qwuE
PneSvHuG8axmxdRC+I3uUk4uXDj0xDsD46N7VJ4hsJ9LIrcS60WxyQI7WD0g
5Z9HvrGLPo68wP7Hb/N8vBP1JLQlGl+AM2QDbtvhwhfs0cfh5kmD/Mmwr+rz
vD2w/+pTGQmYb5LlPsyHneo48a5wINu80hH+KNa57wxL9gYmjuD85HtLBeVw
Q/fJ/Zr7nvT0nvQRfFEcFHcOLk6sdsyE/YXMIiFsdSt0ywjqbXQ/V7IXLqrm
WG+E462iWgSwJaM1qB77c2qI1fKDVb0HmdPggZ7NNzQW7nJXRaIfc0jMcRYc
8Hlw7YkSQnU//5CmDT8rtqkLgOdZnZ9Y685V9MmaUoeKUU+H1Xdy+C/5O9tw
WBS6SFcEt9gE2ejDVfpCVgJset9CcbGI0ME9lpwIOG5K/6sFcJLP4mN8eFu2
21qrPwkV6/2cFQKX9tjbO4gJ7UrP01oBs+SurKXnCRXu6TGxgDXH6VCI/O1x
itFwQOS1tohz+D4FnrIvblzFVZaBXlkBoZOOeL3VRlxSGnubB+dMjQlkw3/w
Or204euGHimBsCGbmdYpIrTduqLvFGzSELeJhXj5vbjWN3Ca2bpRh+D65KzY
aeiH/bBLWBV8VNk3ex1sFMvYqII/FvB2av4nbpynNUfgU9rRHnlwxFpBmB0s
D76fWQSbPgyn15BPp6ytKQU29r/V7QxXP9xnEAQv9Ej+lwErnxaHzYcvTz43
Q5xP6ERZu/4w6nltxOycC9c+ineqhwtHiga68wi122DYp+n3UN84vS643MRl
kyvcyH8+qwZO9jLf8An9YdgW8IVwp0ENRwZvW/+L0hCeUczuPAgXhHxOPnmW
0LPH9+wPgP2NrtRpwaYzo7yZmrgOQxRxBveFNkc+ceUqjlbxh8fB09i/RJ2B
pbMlThawV5nPrfVwRkWoqTn8UThDayF8Wcyc+jKX0AC77Gx9OJzfEbYcVjYZ
Ozx34Sp2T2vJLssh9NLEoISVsKuNoDEE8f8ArYMWMg==
      "], {{-85.102772, 31.985937999999997`}, {-85.09741, 
      32.0146}, {-85.069851, 32.014708999999996`}, {-85.067897, 
      32.03338}}, CompressedData["
1:eJwV1Hs01HkUAPCxyiNFsUmTjtduJc5Oqyksutdb2rDZyaMX452YLbQ73u/X
TA1FaL3ilHaik11rS4mhZRXlkZXatG0s2TJqazHE3vnjd77nc+733N/9fu/9
/Qy4vH1BHzEYDA498rV2nb1lnyOnNYx9Q0fRHfBKbURuJzngpf26h2TXhtE3
DWQbaUdqmwegy4hlwQVyvv9aXuA+QB3VCMsiskGM1fxdT8Ck2TmphOy3FBP5
+GvAY/yx2CfkFbfOuos4gBOsd9ny9wnLpjVL9wO2hUkEt8lRg9bOo16AVhGn
VDrIit6jQxo+gHnJfWM95M2VOdeek5mSjvdScrPb5L1+X0D1ctW9mk6c1tzn
k4zsA4AORx//yiZrHU711DsI6H06L8WarNvgpadxCNAio3DFVvLqWnHRMzKT
9fQTJXKRjO+ZfxgwVqay8Jzy18RseJh4BPB6dDdfXg/jzqHmXD/A8AbdCfn5
Nx7/TanfH9BYUbkhmjztemZcxgV8audl6EGOYOzUtwsEzIxatZ1N3p4TK6kJ
Amw0eScxI1cdZLZMBwP2XVFwtSfzkkukf4YAjj34Zfke8u8jNeLeUKp3WGkK
5fd/n+0/HwZ4J0Zo8hm56a1PuXI4YEFlS68RWax+Y33kMUCeIzeVST6XH+s+
Rlao0HNSIXOD2G/5EYDbw431XztwWq+m1GmaRgKechwY7iIv8pnbXMjP2j/t
LCNP1mo/CiDv+EcoFZB3O91vKydX7hQPpJBX7yoI7eIBngjvj8ghHxT3aw99
A7jxjO+WEjJ3j+hS7AlAm0TeQAW5286qxicaUMpw971OHqpkNX+IAbz1HUS2
kNnBmu9TvwWMkwfICVcbuUl8QP3Gd6Fi8vm7VdcEsYCGOspFp8lP9k7vHYgD
3D14UiuezHKL/7k6HlCQNaPrTV57Md2PkwBYf9HZ04bsKWJfryNbV9e5GpKb
yhLGbBMBZ9sfJGmQzduqDN2SABWvKaz5y57TWtekPliQTP2YiopvIId2vQib
SwGMuiHxyCJ7FSZ4LUuj+gx3vOaSVVmSHzTSAZ9Um//hTO51tO+oJhssdevv
ImerYXV0BqBs2tTWiZzG+vLSikzAYvf9K73Im1lmCi3kIbeCdAdyHOt2qCgL
sMR0CszIl9TqZUbZ9P2sqR7XJhc6db/6lyyWLlQtI/sxM0XZOYCXl2rn3thx
Wme3xQ2fzAVcNReiJLf2rQkTFwHg0VA6Ie1f7DMPYwoBF7dMdtuQ87Q2CYNP
AfZs2JzBJ58WaYesFAFuXVg/Uktmftyj6J1H88ppunmfXDxjMZCeD/iTXf7U
OFl9Jv/A2TM0b7KEpb/JglyLssCzgDkOF4Kekpcsu4vWFVD+45FaU+Rx9w2D
L8lGGT9Ovyd3XTYT3iwEnPGW9S6Xz59VyxbbIupnePymeYpLhMbeL4op36s0
UzWKf1iTqbDnPODIUqeqFjmZG9il+z1goK7RsBE57WiaVh95/+A9KVs+3469
xbtLqZ9xToZym7evml0gWzfvO2dAFrSXHOkpA1w4NtpkTB6TjnwVUA74xS7f
0s/JnS7/qeyooPvVGefZke96rPV8Sa6X/2jIjqbcR/6VgP8DmSdw6w==
      "], {{-85.130331, 31.763697999999998`}, {-85.13040099999999, 
      31.759593}, {-85.130456, 31.7564}, {-85.12995599999999, 
      31.754113}, {-85.128918, 31.751818999999998`}, {-85.127365, 
      31.748151}, {-85.12635, 31.744488999999998`}, {-85.124805, 
      31.740364}, {-85.122761, 31.733952}, {-85.123369, 
      31.729853}, {-85.12505399999999, 31.725768}, {-85.126162, 
      31.723955999999998`}, {-85.127285, 31.721232999999998`}, {-85.128447, 
      31.716227999999997`}, {-85.129601, 31.711679999999998`}, {-85.129671, 
      31.707575}, {-85.128665, 31.703456}, {-85.12818899999999, 
      31.6998}, {-85.12558399999999, 31.69475}, {-85.121903, 
      31.689686}, {-85.11558, 31.681850999999998`}, {-85.10712199999999, 
      31.673077}, {-85.09759799999999, 31.663833}, {-85.092837, 
      31.659209999999998`}, {-85.089642, 31.657345}, {-85.087507, 
      31.656405}, {-85.08538, 31.655009999999997`}, {-85.084336, 
      31.653170999999997`}, {-85.08492199999999, 
      31.650440999999997`}, {-85.087121, 31.647731}, {-85.088782, 
      31.645014}, {-85.08989799999999, 31.642747}, {-85.08940799999999, 
      31.640003}, {-85.087289, 31.638150999999997`}, {-85.084625, 
      31.636747999999997`}, {-85.083028, 
      31.635814999999997`}, {-85.08196799999999, 
      31.634888999999998`}, {-85.07826899999999, 
      31.631192}, {-85.07668799999999, 31.629347}, {-85.074562, 
      31.627951}, {-85.072949, 31.62793}, {-85.070269, 
      31.62744}, {-85.06759699999999, 31.626493}}, CompressedData["
1:eJwt1Xk41fkeB3Bju424whS59qcMWUoRlXy/sk0oSWcoxjrKsRzLHbQac5up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      "], {{-85.149019, 31.773504}, {-85.14686499999999, 
      31.773479}, {-85.135109, 31.767861999999997`}, {-85.130331, 
      31.763697999999998`}}, CompressedData["
1:eJwV1HkwnHcYB/C1gopVSrCoiiQk7oxIxLTp+6oQx0wbx9raom61ziASJaLE
EYkjGImqGo1k44yKIxvMbHWFqCvaVCLuNqorVAyWtej3/eOddz7z/H7v73if
5zEIjHEPodNoNHc81Du+k/682JElODX3LDpUSpDiRNc4Adydvi2jAifVa2v/
DZsnGNJfbBPktzmOl1TPsQSf2Rlz+LCYXbDtBas0m93ZhK1D1dbT4S/6q7NO
YX4p6fJ2HB6SlAQ1w4lcCxumE0sQ+K6822WHIL27x5kfwz2xF2lCODW/QDMM
lru+tCyzS5ACb5fSYtja6RePPsQFTdKtNjgrekOhH859Oj79Cv53adjBHuO5
B4oGRHCdfEC0GG5eq1Ki/FOJan3tHkFOmPmZMZxZgt2RgeIIGkk2Pj5tYgP7
PXFm0GVIMlFooOsEL/dbMH1g6UyK6Ev4wlydXg8smp+LSYYf945mW9BJ8n5r
eORD+CUj1q4NzmkLEjXChV1TO+/giHbfbygzRU3d5rIkWcB7o0C5UWUxjwP7
racl9cFa594YcWHZUp+eOXg0r+lBDpwnSji4CH9SNVYphCtSz2sZu7AEE8Ge
2k/hK3qnw87C7KEp7Sjq+9HXHBxg25TR6/tgR0WJ0hm4YTKxio/97NyNGbWG
DxK6/GjYlTU+pwPT2M1Bh+HvCKlUjPX01Y0H53HekZVQ5SnqvkwEl8rhKGHx
5AA82zLj8DVclbbkL4TLzJYJK7hLcnmhAz5fvW0rB1/VmOkYhH8N/KN1A/cd
cs/ZeAH2+SjCUR7xOMvjpgewfl2j/UlDWGecFknC2dWaLkbwD7mezK+o8zqf
3dSCJ0dKKlLhv9xMZhVhvSLOsTKYk34zbT+8j/dpYSecocHjKMF1AyV/TsO7
7UV6uvDvrjdDJPDFhbVOyh3+sYN6rizBj8kqtz+E2b7ZXBfY3nN2eAX7JS0n
+MfhKZbKnWy4ZbeUJsX8Gx4Nmd5wfkPYe71wclgLyxnu4sWNe8CqQ7x8Ftz5
m0PKUdhoOjI+CE7OlBPLwvpjWbkX4Ieies2XVD50JNXawzVbJluUr75WP9KG
fE0Omaql/v+xlvrtXiqfTc0Pr8O2+1XlTlD5vsZNG4U/9wump6IeMoue1VTA
izGKAgLuqn3E8YfZSfQAHuqvvUVHTYx6yOBmqD9HvRZrWtQ1wWqvJ2UTYI1u
rlkALGwus3eHbwu9PzgJhz9wc7KCT6gz/tGB31e+4TYmIcjLjIIdMzjSl3st
FVZXvP+9N8yWfyF/FF4WsYITYF+r/Ftvtwhy9ZD6SgQ8YFCTWQQrM49c4cC6
gZ3zLLiwMs/HBiZVWqOYsFf5HluPql/fzJLKTfQbgxi+BP2k/edXt0Rigjyz
qiA7DBcGe/0XC1dQAVjLX7/iyQZBhmvXiD1hTUvNrL51goxvX7xnDKfzCk3X
1whyJ01BnupnzEeGdYdgRiP/7h76naPdyubGKkH+D8p+W3I=
      "], {{-85.06011099999999, 32.075685}, {-85.063396, 
      32.073448}, {-85.064542, 32.069815}, {-85.065156, 
      32.065719}, {-85.06520499999999, 32.062984}}, {{-85.0598, 
      32.062915}, {-85.059235, 32.064276}, {-85.06027499999999, 
      32.066569}, {-85.060193, 32.071127}, {-85.06011099999999, 
      32.075685}}, {{-85.06011099999999, 32.075685}, {-85.059488, 
      32.080237}, {-85.057268, 32.0834}, {-85.053967, 32.086549}, {-85.052303,
       32.088808}, {-85.052262, 32.091087}, {-85.05380199999999, 
      32.095666}, {-85.05842299999999, 32.109403}, {-85.06300399999999, 
      32.125417999999996`}, {-85.064521, 32.131364999999995`}, {-85.062832, 
      32.13499}, {-85.059012, 32.136765}, {-85.052987, 
      32.140791}, {-85.04914199999999, 32.143933}, {-85.044173, 
      32.149339999999995`}, {-85.036996, 32.156997}, {-85.033125, 
      32.161505}, {-85.03090999999999, 32.164212}, {-85.029253, 
      32.166014}, {-85.025955, 32.168706}, {-85.02264799999999, 
      32.171853999999996`}, {-85.02042399999999, 32.175016}, {-85.0182, 
      32.178177999999996`}, {-85.015993, 32.180428}, {-85.01379299999999, 
      32.182223}, {-85.00943699999999, 32.183533}, {-85.00453999999999, 
      32.184836}, {-84.995818, 32.187911}, {-84.98548, 
      32.190508}, {-84.977858, 32.192685}, {-84.974042, 
      32.194001}, {-84.970767, 32.195324}, {-84.968025, 
      32.197109999999995`}, {-84.967449, 32.198926}, {-84.967422, 
      32.200293}, {-84.96902899999999, 32.201226}, {-84.971728, 
      32.201719}, {-84.974435, 32.201755}, {-84.97713399999999, 
      32.202248}, {-84.979833, 32.20274}, {-84.981422, 
      32.204585}, {-84.982995, 32.207341}, {-84.98185099999999, 
      32.210516999999996`}, {-84.980175, 32.213229}, {-84.977415, 
      32.215927}, {-84.97195599999999, 32.218132}, {-84.964348, 
      32.219397}, {-84.954599, 32.219263999999995`}, {-84.942143, 
      32.219093}, {-84.93345099999999, 32.22034}, {-84.929633, 
      32.221654}, {-84.928523, 32.223006}, {-84.927386, 
      32.225726}, {-84.927323, 32.228916}, {-84.92616799999999, 
      32.232546}, {-84.92504, 32.234809999999996`}, {-84.922828, 
      32.237058}, {-84.920057, 32.24021}, {-84.91946999999999, 
      32.242481}}, {{-85.06520499999999, 32.062984}, {-85.065221, 
      32.062072}, {-85.065803, 32.059799999999996`}, {-85.066908, 
      32.058445999999996`}, {-85.068546, 32.057555}, {-85.070708, 
      32.057582}, {-85.07233, 32.057603}, {-85.074508, 
      32.056718}, {-85.07508899999999, 32.054446}, {-85.07404799999999, 
      32.052153}, {-85.071379, 32.050295}, {-85.069249, 
      32.048443999999996`}, {-85.067669, 32.046144}, {-85.067177, 
      32.043402}, {-85.067242, 32.039755}, {-85.067897, 
      32.03338}}, {{-85.067897, 32.03338}, {-85.06688899999999, 
      32.029263}, {-85.06639799999999, 32.026520999999995`}, {-85.065907, 
      32.023779}, {-85.065947, 32.021499999999996`}, {-85.06544799999999, 
      32.019213}, {-85.067126, 32.016042999999996`}, {-85.06934299999999, 
      32.012879}, {-85.071553, 32.010171}, {-85.074302, 
      32.00747}, {-85.076528, 32.00385}, {-85.078229, 31.999312}, {-85.078818,
       31.996582999999998`}, {-85.07943, 31.992486999999997`}, {-85.080624, 
      31.986117}, {-85.08126, 31.980653}, {-85.081317, 
      31.977462}, {-85.081897, 31.975189}, {-85.083525, 
      31.974753}, {-85.085652, 31.976604}, {-85.08668399999999, 
      31.979353}, {-85.08770799999999, 31.982557999999997`}, {-85.088748, 
      31.984851}, {-85.08923999999999, 
      31.987593999999998`}, {-85.09026399999999, 31.990799}, {-85.09186, 
      31.992186999999998`}, {-85.094584, 31.990852999999998`}, {-85.096276, 
      31.98677}, {-85.095252, 31.983565}, {-85.09367999999999, 
      31.980808999999997`}, {-85.09157599999999, 31.977591}, {-85.091616, 
      31.975310999999998`}, {-85.0938, 
      31.973969999999998`}, {-85.09648299999999, 
      31.974915999999997`}, {-85.098579, 31.978589999999997`}, {-85.097976, 
      31.982231}, {-85.09953999999999, 31.985442}, {-85.102772, 
      31.985937999999997`}}, {{-85.208815, 32.980920999999995`}, {-85.213167, 
      32.982336}, {-85.216382, 32.986469}, {-85.21844399999999, 
      32.994232}, {-85.221127, 32.997448999999996`}, {-85.226567, 
      32.999331}, {-85.23092799999999, 33.00029}, {-85.235843, 
      33.000799}, {-85.24022599999999, 33.000392999999995`}, {-85.247314, 
      33.001836}, {-85.254936, 33.004196}, {-85.257074, 
      33.007405999999996`}, {-85.255376, 33.011029}, {-85.24935099999999, 
      33.011419}, {-85.243895, 33.010448}, {-85.23842499999999, 
      33.010388}, {-85.233509, 33.009878}, {-85.23129899999999, 
      33.011219}, {-85.23233499999999, 33.014873}, {-85.23774, 
      33.01903}, {-85.24149, 33.024079}, {-85.240878, 33.028169}, {-85.238098,
       33.03087}, {-85.23371399999999, 33.031276}, {-85.227797, 
      33.024837}, {-85.223501, 33.019782}, {-85.219731, 
      33.016098}, {-85.214327, 33.011939999999996`}}, {{-85.22488899999999, 
      33.069416}, {-85.23467, 33.074076999999996`}, {-85.23791899999999, 
      33.076388}, {-85.23889, 33.084137}, {-85.237189, 
      33.087759999999996`}, {-85.238226, 
      33.091412999999996`}, {-85.24469599999999, 33.097857}, {-85.247895, 
      33.103353999999996`}, {-85.247311, 33.105623}, {-85.244025, 
      33.105587}, {-85.23432, 33.095922}, {-85.229976, 
      33.093596999999995`}}, {{-85.195769, 32.909748}, {-85.190241, 
      32.880545}, {-85.18768399999999, 32.870042}, {-85.18563499999999, 
      32.861823}, {-85.18352, 32.8577}, {-85.180289, 
      32.854931}, {-85.17484499999999, 32.853957}, {-85.171024, 
      32.853912}, {-85.16881699999999, 32.855253}, {-85.165534, 
      32.855669999999996`}, {-85.162819, 32.854727}, {-85.16066599999999, 
      32.85288}, {-85.15746, 32.848743999999996`}, {-85.15642199999999, 
      32.845545}, {-85.157545, 32.843736}, {-85.159775, 
      32.841031}, {-85.163626, 32.839254}, {-85.166378, 
      32.83792}, {-85.168054, 32.835663}, {-85.170283, 
      32.832957}, {-85.170875, 32.830231999999995`}, {-85.17039, 
      32.826583}, {-85.16879899999999, 32.823831999999996`}, {-85.167746, 
      32.821543}, {-85.167807, 32.817901}, {-85.16895199999999, 
      32.814727}, {-85.169551, 32.811546}, {-85.16851299999999, 
      32.808346}, {-85.166361, 32.8065}, {-85.162611, 32.802357}, {-85.15611, 
      32.799548}, {-85.149065, 32.796732}, {-85.145277, 
      32.794866}, {-85.14260399999999, 32.791646}, {-85.142129, 
      32.787542}, {-85.141053, 32.786618}, {-85.13889499999999, 
      32.785226}, {-85.135646, 32.783820999999996`}, {-85.131321, 
      32.781492}, {-85.128072, 32.780087}, {-85.12536899999999, 
      32.778687999999995`}, {-85.12486299999999, 32.776405}, {-85.125993, 
      32.774142}, {-85.129289, 32.772815}, {-85.133138, 
      32.77104}, {-85.136979, 32.76972}, {-85.14029, 32.767482}, {-85.143048, 
      32.765693}, {-85.144731, 32.762980999999996`}, {-85.14532299999999, 
      32.760255}, {-85.144279, 32.757509999999996`}, {-85.142697, 
      32.754304}, {-85.141108, 32.751552}, {-85.140602, 
      32.749269}, {-85.139566, 32.746069}}, {{-85.206289, 
      32.968145}, {-85.207383, 32.968157999999995`}, {-85.211742, 
      32.969117}, {-85.216093, 32.970532}, {-85.220445, 
      32.971947}, {-85.224819, 32.971996}, {-85.22868299999999, 
      32.969763}, {-85.230389, 32.965683999999996`}, {-85.229354, 
      32.96203}, {-85.226657, 32.959724}, {-85.224493, 
      32.958334}, {-85.219602, 32.956458}, {-85.21471199999999, 
      32.954582}, {-85.211469, 32.952269}, {-85.208773, 
      32.949962}, {-85.208818, 32.947230999999995`}, {-85.209948, 
      32.944967}, {-85.21109299999999, 32.941793}, {-85.21056899999999, 
      32.940422}, {-85.208952, 32.939038}, {-85.20732699999999, 
      32.938108}, {-85.20572399999999, 32.935814}, {-85.20412999999999, 
      32.933064}, {-85.20256499999999, 
      32.928492999999996`}, {-85.20211499999999, 
      32.922568999999996`}, {-85.20275099999999, 32.917113}, {-85.203904, 
      32.913484}, {-85.195769, 32.909748}}, {{-85.206289, 
      32.968145}, {-85.195769, 32.909748}}, {{-85.208815, 
      32.980920999999995`}, {-85.206289, 32.968145}}, {{-85.214327, 
      33.011939999999996`}, {-85.208815, 
      32.980920999999995`}}, {{-85.22488899999999, 
      33.069416}, {-85.22387499999999, 33.064397}, {-85.214327, 
      33.011939999999996`}}, {{-85.23302799999999, 33.108197}, {-85.229976, 
      33.093596999999995`}}, {{-85.229976, 
      33.093596999999995`}, {-85.22488899999999, 33.069416}}, CompressedData["

1:eJwd1Xs0VVkcB3B5yyPTQ1yRR2q86xIK45wag5qL6MSkbp6JCNdSSqiRaxaJ
lUfcvFIhKwrJI48zxSjvpG7yiEZSJo9Gj8G15nv746yzPmvv396/vX97n6Pp
HeLiJyoiIhKAR/h2VR+WTnpJ0Xvd7iZHHiOJb83aevvh4oxdGldgg7PRZXvh
NGXxAwoBJHE7XO4xG84JePglDa6R0tQ4AnNMhs71wOyGjTVCL1oOXjcPJImQ
WCMGE/bn3RX4wud2WUeLw6LRWk6X4dblyqhPfIr20HHf0A3/LagVCO3De8/e
cpwknBMPTEug/w5iq10KHB53TUEfrvfdoD0AP4pSMLCDY/PDxoggkkAWq7Th
16OyabdgPjcxbBnjmZWtFa2DeeRZzzY4paXjmdDqAmN+IXxs0y7tl7DeiSHv
GPjh+s2uEsEkQaefFzsI5+ad8iHhm/ZNq+3hInaN9EW48c0tOwZsw3DMvgrX
tS4N9b6gaFVFzfIcuL4wXfE2nL9jyvUSfGadiloqPKwTduBnOLTci/sXfJrD
Ot+J+Qn/vqIPMGNbVY8PvHLOvsEK4+t4HHaUgdnyzoxAWKKp0OMO1p/xcfcI
Bw4OS+7xhWW7IhgBMDVU27qE/TRXobhhcA35seYknLT90HgenHWD2boBHt9b
MjoLa1qG+FShfvW1yZJC7156lKkOf6+zcP2/LwWN4zxoVAxbE8gv2mp+uAym
3V/T488p2rNDnz8IU/xrvMuwiRLLfwvia8VH813gffxXi/thNas1vE1w66jX
K3M4VJoK/NJP0VI2YSICxBc4jTv0wZniJbf80J4hJ0INwRd8Mq1lkO/gTfmE
m3BqHbPEDN5x9ZLICTh00lB9BP0r7UpUXODy/iqNdHhbR564GWxfeGWfAew6
MaH69Bl8glVvCP/nUO3UBpfbyvbex/wrHGfeCGD17ZtbDsHKYlMWMYgfkPpN
6VeYoXS9vBr5cwab7AT+JBGc2GYrtGqM+XAl/Ofy1NA9OCNnTdQxeG2HYRkX
loxtzjKE713sj9KDGyao3OdHSeITu5o5hvEd5pmJb2HHngcVBbB19cKHUjhA
NbawEjb9XG/rCVcq2Lm9h4tkKxa04a6DK+0X4c4eedaAH0mMpAwa58NiHT8w
U2G5FXSFP3wvIvSuOVx2YfqyBRxxkmmxxxf1ePLW5gbWO/JWq2mND/qXOXY7
w6VzfSxvb5JQKgjePtWH+yx6ZqzbiySuWtS9vgYfjdca7oFT/a+ERMMzS4Xi
AlhLhRNkDavWZOWrIt5sIqJFE5Z/I2a5jPY/nm/0UobblRwePIWLw211he3M
dhPjBDhI7FSBI2xaW2ZoBR8NKJ7gwKiq7ZwnSXTqUIMsmCvIcy+Gv965baoL
N/wU/kLo8xJb/UafUvQ52xiBIuK9c5pl4uHw+W+NLJjb3pzpBocKCwLLZuvH
BcLZDzJTVyFfjdPvnLlwaY3k/T1wiO67pEb4l+6HeSfhSW7RP/NwdUKjMw2b
GlYwGZjfg103Yob9qzCdvS60iVO5birM59f3S8M2Zk9SvsFWn+3jBhG/air5
oBf2//t3EY7u4gxMwukO8sEi8NjM+iod1Oti7uzqnF6KftwpYZQCk9EdOUZw
uMFMqRTqH3l6p1t6N0Xvye7vlcT5nDVaP5cLj/EsF47AoVWRFVt7KJoVH7mJ
Dct8bW+gYBu1FJUS2N1NInAbrNeiPfcJDsy/1CYHj2X5OYnifiTFa3IWMF7a
olqi0BOP243jYJNmnpg4XOq532ULPCzz5cg7xP9oq/9VFM42mLZhCv8P6f+2
jnRRdMLC4Zc8eLFj+skjOH5S0WI17m/BOuXKetj+uNxOTfh/VS8uXA==
      "], {{-87.38348599999999, 34.816179}, {-87.382781, 
      34.803467999999995`}}, CompressedData["
1:eJwt1Hk0lXkYB3DbacqWXJqKkpJcSUiUOvW+4iqjpHrJciXLNSVkaUpZEllv
GtkVIoQk5sRw216pxLWmG041UdbsKaFovnfO/PGe3/mc3/48z/tTdfY+6CYm
IiLigU/Yus1xnHnPKfpiwXeR3MMk8fzr2GwD/G2V9rZR2H8By/E17HB6ZRGT
IomHhhEiXXByknreDXhFdlZhO8xbslTRx5okWlp2VT+DpwIbfTthxS2pEd1w
/fet6WttSKJmpKV0WS1Fz8gdvuwIl764q+IMP7td7BkDH5gL2xMBqz/Xm5OH
Uz1axe7B3hPjmeLw5U/+q4fglX6ZZZvgDz5WG9e8oOiA3nNvLGB+u9u0JWyS
m88WekNUaEkQfLnZ9ecOuOyNe1IanDhj9j4XPnXu17Fa+L5L2T7NIyRRzWUe
+Qj3nX6qqgTXSg2Oy9Xh/vO7Z0cwfsqu5bwL7LY0u0MS/dmZO8VC4ETLK57L
YY4Cf+MdmBNmoecL/0zUtJqCpUx5WYfgK8sLuCH1iG+foYU+bDM4aqTEp2iJ
uu2RevDJuqKFhrDhga6MQHjmt9hZNXhMxNKuEv4vL5jPc2ff7IXdjROeXoVT
w6UCJGyRLyl2NAH/bZomowdnicTEr4PLN1t4FsJHyyJi3+I8jLQquhf28U8a
LYEz5IwG5O1IIszcobYSth+KDa+Ax+K4gj54w7Rn1ASss9ctZhvWMzTMX69l
TxIh2WbcTPhPhjqXA+us/z2hBm7jyZx4DNf17sp9D7+VapA0dSCJiY5mZybu
IzPHcCiGE+WKi1Lg/CC/kK9wlcFh7iR8w4r3ZRMb53W8EOTfQNHvGgbMamBG
YNuXTtgrJ7nP2pEk/ohUEFdrpOjc7sSqGXj27MB9e/j+LwOPrh8liTzzxId5
cJahYqGOE0nMs7Z7TcNV3uX7HeAvntUH2U0UvS/Hcfw4bBw/2q/QTNHMeJNN
N+Hz4emqFLwm2pFVBveyv14IgPtn2lin4UtX6wozhONLRfKl4chOfkUbvDhF
+Yw59i/2MVgp2kLR8RMaSeM438uZcS0SrmBJfOyCI6MXMM/CzTlnNIVW7Fa/
WQ/XaCxc9R5OVqmsZ7RStHVI+DEaLtFqteXAP5RVNjbBOUTWiwR4XjJtQxgs
+o/Yohg4kTO5VRq+dudBTwic28XsMUf8noS3Fp+E849NR6Ui3hxe+94gWKG5
U8wY+fKKmki3gZN/GWT6It8t0h/Et8OXyDRWAurFdHGgtDVcNc/O2gaLPnrz
wAfe6+7U4wan6LOGCuDymRBBPDxKZHwegI1sEuUvwrrsKIHKS4puVUkP8IXP
M3b76sFqUqn0HVi2Q9DDhAn5qRE17D/9zp8vC8dW19zzhqXj29onsV4ho8Wk
Ay63rHVZgP5zHk63Jez///9hRUMv3V2wf7JtuDPcFzef4gE/zNW1M4NLixyD
b8GPhzN3aMF8wZV9n+HuJLXmr1hfZj5Y1x7xEe/naozABT7ewTUwcYKx/huc
1MKWd0c817qubtbGfMkOWdYwrF0TwguFDWwa/UwQf+6SaGM+LHweTsH8TAmD
flhfW3lhHWzczBEIvZg1zCBQL00zzDjxNtRryeiRk/Cra1aTFOxTaG7vAFdo
Rg+HwXNZNYEBsIXwIYUJj+AfeXDZo9A6oZc5+Jn9hI1VxWSzYdZRMl1Yvysi
Z9kdsMsiD5dhuCtUNHzxK4oukbN2WXSMJDbf4js7w5USXVkH4XinorRyOPVJ
GKcdbto8tU5JQNFfsqU+2TuThKBJpzwPtpKXP67kQhLPuhvu9sFbjHcdugv/
JfM21Og1RTdxg/Wvu5JExkSQTyGspDG+f6cbSaweKhTYtFN0TtL5UFuY56q8
thNutJPc8x1+3BqnFNxB0WTomc+D8L9GdkWr
      "], {{-87.382697, 34.796202}, {-87.39103999999999, 
      34.791596999999996`}, {-87.40392299999999, 34.792407}, {-87.411748, 
      34.791438}, {-87.423485, 34.789983}, {-87.425685, 
      34.786787}, {-87.430025, 34.775397999999996`}}, {{-86.681967, 
      34.583189}, {-86.682515, 34.578645}, {-86.688096, 
      34.578637}, {-86.69592899999999, 34.585892}, {-86.707651, 
      34.585872}, {-86.70819499999999, 34.58042}, {-86.717107, 
      34.574044}, {-86.726039, 34.574481}, {-86.726028, 
      34.570847}, {-86.72656099999999, 34.562215}, {-86.717632, 
      34.562232}, {-86.719779, 34.532246}, {-86.733727, 
      34.533128}, {-86.73319699999999, 34.542214}, {-86.74547199999999, 
      34.542643}, {-86.745453, 34.536738}, {-86.762748, 
      34.537154}, {-86.762782, 34.547148}, {-86.794027, 
      34.547528}, {-86.794011, 34.54344}, {-86.806285, 
      34.543408}, {-86.824697, 34.543813}, {-86.82416599999999, 
      34.550174}, {-86.838117, 34.550588999999995`}, {-86.83809099999999, 
      34.544683}, {-86.853714, 34.545091}, {-86.853741, 
      34.550996999999995`}, {-86.86824999999999, 34.551406}, {-86.867711, 
      34.555496}, {-86.883893, 34.555444}, {-86.883926, 
      34.562258}, {-86.909596, 34.562171}, {-86.909641, 
      34.570800999999996`}, {-86.917457, 34.571228}, {-86.930245, 
      34.562551}, {-86.93079, 34.560277}, {-86.93071499999999, 
      34.546648999999995`}, {-86.923997, 34.542586}, {-86.92397199999999, 
      34.538043}, {-86.937361, 34.537993}, {-86.937327, 
      34.532088}, {-86.943461, 34.531611}, {-86.943427, 
      34.525704999999995`}, {-86.95123799999999, 
      34.526129}, {-86.95168199999999, 34.506592999999995`}, {-86.946106, 
      34.506615}, {-86.94656599999999, 34.489804}, {-86.963852, 
      34.490190999999996`}, {-86.967271, 34.502443}, {-86.96577599999999, 
      34.531977999999995`}, {-86.974145, 34.532398}, {-86.97366, 
      34.544212}, {-86.966405, 34.543787}, {-86.965431, 
      34.567413}, {-86.94813099999999, 34.567479999999996`}, {-86.948202, 
      34.579744999999996`}, {-86.941504, 34.579771}, {-86.942021, 
      34.5725}}, {{-86.968513, 34.615550999999996`}, {-86.95786799999999, 
      34.609688}, {-86.950588, 34.606082}, {-86.93883199999999, 
      34.600676}, {-86.925951, 34.593455999999996`}, {-86.914757, 
      34.588045}, {-86.90301099999999, 34.583543999999996`}, {-86.885117, 
      34.577245}}, {{-86.959638, 34.625579}, {-86.955154, 
      34.622870999999996`}, {-86.954579, 34.620148}, {-86.944496, 
      34.614736}, {-86.937775, 34.611128}, {-86.933292, 
      34.608419}, {-86.926577, 34.605717999999996`}, {-86.923214, 
      34.603459}, {-86.923189, 34.598917}, {-86.920378, 
      34.595293}, {-86.917565, 34.591215}, {-86.910296, 
      34.588969}, {-86.913128, 34.596682}, {-86.92379799999999, 
      34.608}, {-86.925508, 34.614353}, {-86.909815, 34.603507}, {-86.907574, 
      34.602152}, {-86.905339, 34.601706}, {-86.900307, 
      34.600359999999995`}, {-86.897503, 34.598099}, {-86.895268, 
      34.597652}, {-86.89359999999999, 34.599019999999996`}, {-86.893619, 
      34.602654}, {-86.89196199999999, 34.606294}, {-86.888649, 
      34.613572999999995`}, {-86.888678, 34.619478}, {-86.88366599999999, 
      34.62222}, {-86.880308, 34.620868}, {-86.88085799999999, 
      34.619049}, {-86.88196599999999, 34.617229}, {-86.88139799999999, 
      34.615413}, {-86.879167, 34.615874999999996`}, {-86.876384, 
      34.617701}, {-86.873031, 34.617256999999995`}, {-86.870234, 
      34.616358}, {-86.86744, 34.615912}, {-86.86575599999999, 
      34.614101}, {-86.866858, 34.610918}, {-86.87020199999999, 
      34.609544}, {-86.872433, 34.609083}, {-86.875777, 
      34.60771}, {-86.875209, 34.605894}, {-86.872974, 
      34.605447}, {-86.870182, 34.605456}, {-86.86627, 
      34.60456}, {-86.86626299999999, 34.603197}, {-86.868488, 
      34.601372999999995`}, {-86.870717, 34.600457999999996`}, {-86.875181, 
      34.599989}, {-86.87907799999999, 
      34.597705999999995`}, {-86.87906699999999, 34.595434}, {-86.877946, 
      34.59453}, {-86.877937, 34.592712999999996`}, {-86.879047, 
      34.591346}, {-86.88183099999999, 34.589974}, {-86.885739, 
      34.589962}, {-86.887962, 34.588136999999996`}, {-86.89018399999999, 
      34.585859}, {-86.89184499999999, 34.583127}, {-86.889038, 
      34.579957}, {-86.885117, 34.577245}}, {{-86.885117, 
      34.577245}, {-86.88286699999999, 34.573617999999996`}}, {{-86.959638, 
      34.625579}, {-86.96185799999999, 34.623298999999996`}}, {{-86.957976, 
      34.627857}, {-86.959638, 34.625579}}, {{-86.942021, 
      34.5725}, {-86.941992, 34.567504}, {-86.929722, 
      34.568912}, {-86.92416899999999, 34.573929}, {-86.920845, 
      34.578483999999996`}, {-86.919178, 34.579853}}, {{-86.919178, 
      34.579853}, {-86.91751099999999, 34.581222}, {-86.91303599999999, 
      34.57942}, {-86.901296, 34.575827}, {-86.892354, 
      34.573586}, {-86.886206, 34.57179}, {-86.88286699999999, 
      34.573617999999996`}}, {{-86.919178, 34.579853}, {-86.91693599999999, 
      34.578044}, {-86.912458, 34.575787999999996`}, {-86.90463299999999, 
      34.573544}, {-86.89512599999999, 
      34.569942999999995`}, {-86.88562999999999, 34.568158}, {-86.866074, 
      34.563224}, {-86.8588, 34.559158}, {-86.85710499999999, 
      34.55462}, {-86.860451, 34.554156}, {-86.864361, 
      34.555051999999996`}, {-86.86883399999999, 
      34.556855}, {-86.87218999999999, 34.558662}, {-86.873875, 
      34.560928}, {-86.881699, 34.563174}, {-86.888967, 
      34.565875}, {-86.894545, 34.565402}, {-86.899563, 
      34.564477}, {-86.90459, 34.565368}, {-86.907411, 34.571264}, {-86.91579,
       34.572597}, {-86.918576, 34.571678}, {-86.921917, 
      34.570302999999996`}, {-86.925806, 34.56711}, {-86.930263, 
      34.565729999999995`}, {-86.93472, 34.564350999999995`}, {-86.936381, 
      34.562073999999996`}, {-86.93524699999999, 
      34.558898}, {-86.93244399999999, 34.556636999999995`}, {-86.931848, 
      34.549825}, {-86.933504, 34.546639}, {-86.9279, 34.542117}, {-86.935137,
       34.539365}, {-86.937921, 34.538446}, {-86.949589, 
      34.530224}, {-86.952919, 34.527485999999996`}, {-86.955687, 
      34.523841}, {-86.956245, 34.523838}, {-86.95791799999999, 
      34.523832}, {-86.963523, 34.528352999999996`}, {-86.962976, 
      34.530172}, {-86.963563, 34.535167}, {-86.96636099999999, 
      34.536518}, {-86.96804499999999, 34.538329}, {-86.967501, 
      34.540602}, {-86.963599, 34.541072}, {-86.958004, 
      34.538368999999996`}, {-86.94796199999999, 
      34.538408}, {-86.93689499999999, 34.554349}, {-86.94192199999999, 
      34.555239}, {-86.94582, 34.553861}, {-86.95923599999999, 
      34.557897}, {-86.962597, 34.560156}, {-86.959257, 
      34.561530999999995`}, {-86.955367, 34.564271999999995`}, {-86.949781, 
      34.563386}, {-86.945346, 34.568399}, {-86.942021, 
      34.5725}}, CompressedData["
1:eJwd1Hk41HkcB3C5ypl7i4mVehxRjCvR+qZDoRI7CtWWBx3IMeOsFF2jbR2j
3WYlomnyWNJKNSL9mnJEjpxNkdgOMxWFh02Ofc/+MTPP65nf8/1+zp9xUKRP
iKyMjEwEPtJfei1Nfkkrg3LN2JGXqEZIoUnl9Dm4YIVm0SycZVZR8h1OFopK
Q9QJMdC8cMqzjUH93pHHYcK0vRpZObC9xFi/D8+/CP4tiQ2/vpBTxoFtX/sl
RcCKudeDneB/qfQ5WZjTzBijwfrekZuacf6aiwUWfFVCOGXyPkFwz+TAj8aw
pcDoC9XCoPimll9PKhNyc3hXeDYsyOjNYSkRIlnzsy8HXt0VwD2zgBBvu4X7
suAZa7eEivmEnHVad5mG8zRnN7ZxFQiJHA1klcMCBc/YebAxq205DfEUvfmS
ypYnRC3tqOVxmHgJz7jAj4RbclyfM6ikf3jWI3KEqDblR6q0M6iBT930xfi/
0KzNdBR2ETVfSIZ330wO53QwqN5TGpmrcH5x56cUv04GdcImsNxCkZBaJ8mQ
AD489enkR/iS0x497S4GpaAjEZsgft7hKqUa+Ehfs+8S5LvGKG95A9xruddS
VYWQ4BKHuTI4+W037xXqU9Zc5/EMtueeHTBBP0LsRhNr4eLK3n1FCwlJjE2f
J4LHwz7emNMghK7/rXoQZp940X5NkxCTrdVyLt2Ih20xvViLkB5dW+ErmNn5
PNoe9k10Fh7qYVAycxctdsDq7jvFw/Bsbup0ODyZrq8d9IJBLUoYXrsbvn4g
Ke1vmBla5WYEV2SefP4OlpY5Cfc5xBrqzsHWm6cqziOeIK+po+YiBuWZwU+i
I159/t3OdfB+dm5NnnRe+j3iwmG3RCN3JvJVkQS+Z8Gm24bjzeCZqp+Y3fDq
wqPd9jAvaq1yD8wYPxeaB684pydqgXsoPyU96Xwv3WYqgg9cNujQRr3CS1dp
vYTV9KdMBfD7D2f5n+AIx0eOWxFPV5z2sQ6YV3ea64l4BQ1r9/TBaWK3kll4
clbxc5f0ecNzj6aR3/0rx99J4/9/H7QJuaO93DgL+abscmBu1iFkV4zur/2o
n0fH1YOG8FB13codcDez/XsdnmeKhnLzUf+Zidg3ufCVDadPaMLJtforY2BD
H9XMg+iflcsqXQN4VJH7TR1+oqhiegj1LlavXHwE81WdvT0jQtrfqna6D1x2
ib8gCvE2PaBKvOF4y7tbNiK/3X77bSl4U4swLw718uLZXa6HR2YTygIwb/QY
vYkKuLgjpeQG5jGw5bqgGDYbXSbOwf55HdHxD4NXlhiMpGN++221CjThdP+J
Zbewf3E2zawy7IMSXdaCBnO1tozTYfXUdL87mP8uV3ZwA/anXkOGdhQOEJQI
Q+HMhxVF22Ef8zg7dbiUp9vvDVdz3lbWYB8f3hO3JsOR7qutEuABiQy7Cj7v
SM+Yxv6qbxWJ5+O+be3TNqVw9lR5hS/c56pXuB7+4b5WigTGt9EG6ftL1UjT
F/Ev+hDpZgwXW9hpNMFnHWQMNODcw1bP3JBvvYr4i9TBLKI1Ab9Z6Dq3Vnq+
sLr+T9SnvJ2nw4L/uB2/KRD10/7ls1kLXEjyG7JR36EVm231EO+9hITWFMxj
7Yw7fz1MyXLpUZi/1lEXgTNMU1E+Jd2H4xzn8KWwXHlPlSv6t/dUzfgEzouO
EnPH4BWnu3YJ4aexvo1h6PcD/at2nXCAuXxMGtwvvP91GH4Z/XiED780fDDw
E85z4/g/eAy3RzX2HoMnmcqjt+Gi6Mjkx3AXGXOKh8dYN82Wo/73UyOeZMMh
BgK5WNg6N4xbAN+q3+BxG35WbprSDPv3SZzEsPR1FIR5ZOdd3KKGfrfzJYYi
WOfpTllzOHxBepMA86s52ChyhuP6ArO42AfHqPmSi3CQYI3MIJzzWfn4LRi3
Nl7TJaRuq5pdPhxqpcCbgY1LbYZOw4N/Lal10iPkP1raLoU=
      "], {{-88.16015999999999, 31.849643999999998`}, {-88.174195, 
      31.850348}, {-88.174166, 31.848979999999997`}}, {{-88.192488, 
      31.797158}, {-88.197346, 31.797541}}, {{-88.197346, 
      31.797541}, {-88.197654, 31.786586999999997`}}, {{-88.197346, 
      31.797541}, {-88.198962, 31.797515999999998`}, {-88.205975, 
      31.797866}, {-88.211901, 31.797776}, {-88.215075, 
      31.79499}, {-88.222549, 31.791681999999998`}, {-88.225213, 
      31.790273}, {-88.221932, 31.788041999999997`}, {-88.208975, 
      31.786872}, {-88.19819199999999, 31.786579}, {-88.197654, 
      31.786586999999997`}}, {{-88.197654, 31.786586999999997`}, {-88.191199, 
      31.787141}, {-88.18253299999999, 31.784989999999997`}, {-88.178744, 
      31.784133999999998`}, {-88.171656, 31.780134}, {-88.167782, 
      31.775174}, {-88.16610899999999, 31.772461}}, {{-88.16610899999999, 
      31.772461}, {-88.161801, 31.772524999999998`}}, {{-88.17318999999999, 
      31.828011}, {-88.173228, 31.829835}, {-88.171678, 
      31.833052}, {-88.171773, 31.837612}, {-88.171281, 
      31.8399}, {-88.17133799999999, 31.842636}, {-88.171944, 
      31.84582}, {-88.171981, 31.847644}, {-88.174166, 
      31.848979999999997`}}, {{-88.174166, 31.848979999999997`}, {-88.177391, 
      31.848475999999998`}, {-88.17997199999999, 
      31.842962999999997`}, {-88.180397, 31.837483}, {-88.181389, 
      31.833363}, {-88.184026, 31.830586}, {-88.190427, 
      31.827296999999998`}, {-88.196826, 
      31.824006999999998`}, {-88.20270599999999, 31.821637}, {-88.204871, 
      31.822060999999998`}}, {{-88.204871, 31.822060999999998`}, {-88.208124, 
      31.822923999999997`}, {-88.211945, 31.825146}, {-88.213571, 
      31.825578}, {-88.215746, 31.826456999999998`}, {-88.21683399999999, 
      31.826895999999998`}, {-88.222233, 31.82727}, {-88.225966, 
      31.825388}, {-88.226985, 31.822635}, {-88.21990199999999, 
      31.819094}, {-88.210692, 31.816954}, {-88.20852699999999, 
      31.816530999999998`}}, {{-88.20852699999999, 
      31.816530999999998`}, {-88.204207, 
      31.816139999999997`}, {-88.19829899999999, 
      31.817141999999997`}, {-88.192881, 31.815856}, {-88.18799299999999, 
      31.814103999999997`}, {-88.18579, 31.811857}, {-88.183568, 
      31.808697}, {-88.181866, 31.804616999999997`}, {-88.183945, 
      31.800936}, {-88.188707, 31.796758999999998`}, {-88.192488, 
      31.797158}}, {{-88.204871, 31.822060999999998`}, {-88.20807599999999, 
      31.820642999999997`}, {-88.20852699999999, 
      31.816530999999998`}}, {{-88.20852699999999, 
      31.816530999999998`}, {-88.208518, 31.816074999999998`}, {-88.192103, 
      31.804463}, {-88.192488, 31.797158}}, {{-88.16015999999999, 
      31.849643999999998`}, {-88.16110599999999, 31.843244}, {-88.168397, 
      31.83082}, {-88.17318999999999, 31.828011}}, {{-88.17318999999999, 
      31.828011}, {-88.176329, 31.823403}, {-88.181074, 
      31.818313999999997`}, {-88.17651599999999, 31.806521}, {-88.164833, 
      31.788904}, {-88.164031, 31.776142}, {-88.161801, 
      31.772524999999998`}}, {{-88.161801, 
      31.772524999999998`}, {-88.15843799999999, 31.766188}, {-88.14036, 
      31.751399}, {-88.13819699999999, 31.750974}, {-88.129656, 
      31.754748}, {-88.128625, 31.757043999999997`}, {-88.118532, 
      31.764032999999998`}}, {{-88.118532, 
      31.764032999999998`}, {-88.10987999999999, 
      31.762332999999998`}, {-88.105006, 31.761034}, {-88.093228, 
      31.737478}, {-88.09223899999999, 31.714679999999998`}, {-88.088166, 
      31.699225}}, {{-88.17318999999999, 31.828011}, {-88.17576199999999, 
      31.822042999999997`}, {-88.176735, 31.81701}, {-88.175052, 
      31.813841999999998`}, {-88.173936, 31.812033999999997`}, {-88.168992, 
      31.807546}, {-88.165022, 31.798025}, {-88.161658, 
      31.791687999999997`}, {-88.159334, 
      31.783510999999997`}, {-88.15648999999999, 
      31.776252999999997`}, {-88.15531899999999, 
      31.771708999999998`}, {-88.149264, 31.765411}, {-88.140592, 
      31.762801}, {-88.133044, 31.762455}, {-88.126638, 
      31.765285}, {-88.122886, 31.766251999999998`}, {-88.119683, 
      31.767667}, {-88.118532, 31.764032999999998`}}, {{-88.16610899999999, 
      31.772461}, {-88.164447, 31.770204999999997`}, {-88.160564, 
      31.764788}, {-88.152318, 31.756698}, {-88.146858, 
      31.753128}, {-88.14137199999999, 31.748189999999997`}, {-88.136535, 
      31.748717}, {-88.13065, 31.750628}, {-88.126398, 
      31.753427}, {-88.123742, 31.75529}, {-88.12114199999999, 
      31.75989}, {-88.12061299999999, 31.760354}, {-88.119545, 
      31.760824999999997`}, {-88.117391, 31.760855999999997`}, {-88.118532, 
      31.764032999999998`}}, {{-85.721621, 31.385589999999997`}, {-85.724289, 
      31.386978}, {-85.726398, 31.390643999999998`}, {-85.72798399999999, 
      31.392937999999997`}, {-85.727954, 31.396133}, {-85.72684699999999, 
      31.399777}, {-85.725203, 31.403416999999997`}, {-85.72409999999999, 
      31.406605}, {-85.72192, 31.410242}, {-85.720294, 31.412056}, {-85.71705,
       31.414772}, {-85.71542, 31.417043}, {-85.71378899999999, 
      31.419314}, {-85.71322599999999, 31.422048999999998`}, {-85.712672, 
      31.423871}, {-85.71157699999999, 31.426144999999998`}, {-85.709414, 
      31.427956}, {-85.706182, 31.429302}, {-85.703518, 
      31.427456999999997`}, {-85.70248199999999, 
      31.423797999999998`}, {-85.70250899999999, 
      31.421059999999997`}, {-85.70254899999999, 
      31.416952}, {-85.70418099999999, 31.414680999999998`}, {-85.705276, 
      31.412406999999998`}, {-85.706379, 31.409219}, {-85.70747899999999, 
      31.406488}, {-85.708569, 31.40467}, {-85.7102, 31.402399}, {-85.711835, 
      31.399672}, {-85.71239299999999, 31.397394}, {-85.71296, 
      31.394202}, {-85.714609, 31.390106}, {-85.71570299999999, 
      31.387831}, {-85.718401, 31.386024}, {-85.721621, 
      31.385589999999997`}}, {{-88.402101, 30.472744}, {-88.399547, 
      30.408289}, {-88.39905, 30.386796}}, {{-88.39905, 
      30.386796}, {-88.395344, 30.386858999999998`}, {-88.393247, 
      30.387811}, {-88.390621, 30.388771}, {-88.389033, 
      30.388797999999998`}, {-88.386894, 30.387919999999998`}, {-88.384194, 
      30.385678}, {-88.38204499999999, 30.384342999999998`}, {-88.379387, 
      30.383930999999997`}, {-88.37781, 30.384414999999997`}, {-88.376772, 
      30.385347999999997`}, {-88.37679299999999, 30.386262}, {-88.378412, 
      30.387607}, {-88.381091, 30.388934}, {-88.38166199999999, 
      30.390753999999998`}, {-88.380084, 30.391239}, {-88.377427, 
      30.390826999999998`}, {-88.37639899999999, 30.392217}, {-88.37643, 
      30.393589}, {-88.37805, 30.394932999999998`}, {-88.378622, 
      30.396753}, {-88.376514, 30.397247}, {-88.374905, 
      30.396359}, {-88.373295, 30.395471999999998`}, {-88.372247, 
      30.395947}}, CompressedData["
1:eJxF2Hc8V98fB3C07JUo2SMrVLTQdSvKVvggMxKyNayUSkaiMiqZUURZkcrK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      "], CompressedData["
1:eJwt13s4lFsbBnCnKLELO0RJKUU7IiFptVIqIqlGJYmEJIddDskUnRBNckyI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      "], {{-86.854794, 30.999589999999998`}, {-86.89587499999999, 
      30.999450999999997`}, {-87.21279899999999, 31.000152}, {-87.524384, 
      30.999540999999997`}, {-87.601225, 31.000176}, {-87.599581, 
      30.996993999999997`}}, {{-86.688324, 30.995428999999998`}, {-86.701662, 
      30.995406}, {-86.772098, 30.999823}, {-86.854794, 
      30.999589999999998`}}, {{-86.54534699999999, 30.994666}, {-86.688324, 
      30.995428999999998`}}, {{-86.186843, 
      30.993775999999997`}, {-86.43491499999999, 
      30.993741999999997`}, {-86.54534699999999, 30.994666}}, CompressedData["

1:eJwV1HlQU2cQAPBI5A5eQaKinOVQuVGoMLAbAiGoiEDD4YBlGC0gKEKMtRQC
yjGC8YAitBUoECswiELVSZkqCZKKqNTEWoJXrSISO9aDwQMV0s0fb9785ntv
v337dj/H9Ny47UYMBiORLsP9NIe3ThMhVGat6V3CjAF0jftxeIx8zCugy3oT
oIn2vkZPHq/vX1K9EXCm8T+NLV+o/MG8QmS1AXB/UoBIQP66xM0zZT1gSvX3
zRVkSdWYsjMK8Fbl3PhhMlvS8VMguc3Y+4NFpFB5fVQ9PCsAtGnl/SMgfzBx
DawiOx62aMghy/9QpL6NBDxn7uNRTA7RiB+Zkl103lMHyXrjA4ylfMDugCub
9pH3vs/+hR8BOBbPkGaQ/eYo+DXhgNKWhsxEclLn3mgBD5Dzym+AT77ZmKYX
hwFS9D5PsviYtjSKC/iiPiaBRW4/ZH3tMgAW5LLmKCl/lUN3fmYIPT91UCMi
f2qzdX8VBJiqSAvMIc8Pt8l6vA6QFSyNKia3mvzpU/g5oPe7odgSsl686640
ELCrtPRSJdlrvLDnXQBgKVtztovcf7DIyJ0cU1sWfpc8a0oZrwWsXXRA+Iac
92lzlmoNYLGSyTSj/NivR6bl/oCthVxLc3JuWr7sqh9gi+CdyFBfu1NFomJf
QAu+i9iIHLqHW3Tdh/5vTHK0luJ1B+Wf9CfPa/BvPU/e/FjkNuoN6FA3vLyG
vKNMcmor+XKLfN8+8s9/Hft10AvQLqfnXgZ5xdWCHW88AbnuL8cyyXcghmlC
3vbE43kW+bjcucHGA7CoWl1nqNcHi1vSiNWA7hJpbzY54Pp2mWgV4FpXVUoc
WfD+74fNKwHF9iW3XcmDr0ZvppNFK8+s+kj9V6UPbg0jc1hnemXkOqfp9Q5k
i4W7zYTkr9hpSbPugJIr5UxHcqLT5plSsnGOqfPbcKr/DYfQbjfAjIaK9svk
2RMctz5XwIaPnYNF5BdDA2FdLoC+ujI1l6yQP7sp+QwwWstO5ZCTfV5HxjoD
Tmsnr73hCZXWSYx4EyfAjW1i29tkUVOP9x0HwKV7wnTN5PZYgV+nPfU7LUvI
F/ordVo7wKChhPp48o4m58lUckH7zgF3cl6sp1PVCsDxdNbpsTCh8t/OTqML
ywF3tnUt7CdHbbPflkxuG5LKj5PDDB9oCzh1T7tfRP7uwQ1dJPk3zWAhknmH
ciY+LgXcZLl1ajHZadkD7vMlgHkJ4dFTXKGyJO2InYID6Pf0jMsTcoev49Ma
G0Cr+/uDxsmqHq9dssWA6S0ja16SGY94lXXW1L/lyZkT5BMdC46q2ICHh498
8dCwfiTkWy+y2e8J6vPkEJcJld0iwHI1t343eYtHxOTxBYC68mAOn1w/8CK4
Yj6dD9nnehaRhbJEZu08wIshZnOmUaj0Z7MmlpF3LVahljyS63rK0ormgcbj
CtltexzPlgXoP8BPVpCnFyrSrSwBn/E4t+Xka32rD+jNAVX2EY295LO6kewC
M5qf0VuyDnLc+XxvH1NAQ9sXk3tnJoeqjGm/i8F+CeSgdby8QSbgXMZgUwi5
1jf0xlYjOk8y1GowxPdNvl/MAGzMeL4hYAO9L9OPbyHLvxk76ZNE/Wy9ZWRG
H4pHA6c9g74UKldOHLrEIf8P8d1fWg==
      "], {{-85.487926, 30.996456}, {-85.49059299999999, 
      30.99648}, {-85.805925, 30.994332}, {-86.11962299999999, 
      30.994023}, {-86.186843, 30.993775999999997`}}, {{-87.382781, 
      34.803467999999995`}, {-87.37495899999999, 
      34.804888999999996`}, {-87.35030499999999, 34.8028}, {-87.333964, 
      34.792926}, {-87.318641, 34.77305}, {-87.305093, 34.76179}, {-87.285974,
       34.752382}, {-87.278707, 34.752885}, {-87.260305, 
      34.75891}}, {{-87.382781, 34.803467999999995`}, {-87.382697, 
      34.796202}}, CompressedData["
1:eJwV02lQU1cUB/AUFTRaaAcFIUKNEgQtMgXE0hnKe2ERBcrWCwOSsARKScoy
ZdRhZEJRKTpCa8CypELZCgxQKJoADttTmkJlqVAN7WjFrQOByGYgEKrt3w93
7vw+3HPPPfccbkJ6WJIRi8Xyx3qzxxuE3hkbhBFYmH//rYSm6O3bdgvg2dlv
VO5wnWHM+QR8POH4zQ0xTWX7BF6ygzXaxIyr8MXEofYVA2F2RFwTO8FFxp3K
PNhiVTEQm0JTDXf0BT7wWOP6wfXPaarWtmbcBi7m+KqtYXqhkMuCdeZjaU7J
NKUY7vy4ZZ0w2r8yy+Wf0dSQ3f7keDiXF9m+lkRTY6m3e13gT+vLzlfBhfvV
T8PXCPPV2Uqv1ESa8oyzdflHT5jT4XckPDiw36fnFFz00VtBF0Q09XAyN9MP
NhN2K54k0JSyPmvQET74bCo5BpYk5LbNrBKGrhT0rcTT1MjPoep02NPX9N2j
sEWALJsHP580a78Vh/yPNUdPrCD+ptNHsuC1Gk+hPzzV0HSXgp1al8q1OsLU
FXSx3OCcIHVjPsy5J5UcgOd/8g8MgRWvS1j/xtLUXe9Ujh/cM8o5kAer3RY+
9IVdVHs228ACQ2mdC6yTzDX8J6SpvYIvoh1h0j+xvggHe9hf3nhJmCu9j14t
wZ72YfJR2LruseNzeNpqo6gQluQkn9XB5tr+sSC4L/e3wn2IT/VdYJvC/K1D
pSFwweF008llwjinFKhD4Ya2aUkJHCVxUFrChVRPayycdSaxxR0eP9N53Qde
Wcke/RKuqiVOmiX8Z55Rx3mYS3a2XYdNb1qlMTD7cMS9ODjKraJiB+rx69dp
qyaLhNlrwhtRoN5dzZGy8QW8N9QvhoX/6ZAafpfD3k9tA96D+SVbzHPg6XQ+
1whG9fPz4ffL1mobcT7AI1bbC0cFTZoLYGXwoMgY8edlo+Ql7vMbzrUVww8M
Gi8JHCY8VN0Nv62ySV9Gfmb0/Zn78KXxzO0CWPXqWL037GxgTxTAlvMxuzWI
H9dUrtyJ8yqrgWtV8HBSbaYUVlufeOELNxvHp+nhIS/Xi2awNPTca/6bfqr+
ky2fJ8zfpa4PdiH/mRrus1B4Q7bPpQVufSdCtA1WkaSpXejfaN0nWx6+IMwR
+19iwuBTzdN1ei1hbgfvofrh/A80Cz/CFdIQS0f0/2P/qlv1sN7oBl8Gp7pH
JFTCrmniqnVYxB/hEdiO7jJiY56i50c2D8wRppvnERcJy7dyKoXw0QyT2avw
E/rG3KNZwpwsaRtehDvO1fMiYL5XeNtJzOuV5WLxDxrCVItMvuuCiwf/WN4E
Ozj4HtLDC00mI94zhFkt809xx7z/D0ihOGM=
      "], {{-87.629138, 34.806348}, {-87.626346, 34.806829}, {-87.617449, 
      34.811001999999995`}, {-87.609177, 34.81971}, {-87.598604, 
      34.824351}, {-87.58582899999999, 34.831736}, {-87.576284, 
      34.830008}, {-87.56237999999999, 
      34.836946999999995`}, {-87.55517499999999, 
      34.842462}, {-87.54456499999999, 34.844828}, {-87.52942, 
      34.843145}, {-87.513667, 34.837832999999996`}, {-87.490619, 
      34.831216999999995`}, {-87.46873, 34.827313}, {-87.451871, 
      34.822455999999995`}, {-87.436089, 34.813953999999995`}, {-87.425958, 
      34.809492999999996`}, {-87.410326, 34.813249}, {-87.38906399999999, 
      34.814319999999995`}, {-87.38460099999999, 
      34.815716}, {-87.38348599999999, 34.816179}}, {{-87.943736, 
      34.834232}, {-87.941912, 34.826533}, {-87.94125, 
      34.821090999999996`}, {-87.940614, 34.817011}, {-87.938324, 
      34.814313999999996`}, {-87.933193, 34.809381}, {-87.92696, 
      34.805369}, {-87.922406, 34.801337}, {-87.92011699999999, 
      34.79864}, {-87.91838, 34.795480999999995`}, {-87.917169, 
      34.7905}, {-87.912099, 34.788744}, {-87.90480699999999, 
      34.787924}, {-87.900289, 34.785706999999995`}, {-87.89688199999999, 
      34.783021999999995`}, {-87.896282, 34.780758}, {-87.893427, 
      34.777612999999995`}, {-87.88779, 
      34.775408999999996`}, {-87.87989999999999, 34.772323}, {-87.876487, 
      34.769183}, {-87.87533499999999, 34.767379999999996`}, {-87.873049, 
      34.764682}, {-87.86791699999999, 34.759291}, {-87.862267, 
      34.756178}, {-87.85716099999999, 34.752148999999996`}, {-87.852047, 
      34.747665999999995`}, {-87.85089699999999, 
      34.745863}, {-87.84356299999999, 34.742312999999996`}, {-87.833433, 
      34.738794999999996`}, {-87.82385599999999, 
      34.734815999999995`}, {-87.817098, 34.732167}, {-87.808672, 
      34.729991}, {-87.79913499999999, 34.72828}, {-87.794669, 
      34.728784}, {-87.789644, 34.729293}, {-87.78517, 
      34.729343}, {-87.777901, 34.729422}, {-87.771772, 
      34.730852}, {-87.76284, 34.731857}, {-87.755055, 
      34.734666}, {-87.751722, 34.736064}, {-87.74615899999999, 
      34.737941}, {-87.741714, 34.739805}, {-87.737821, 
      34.741209}, {-87.731691, 34.742636}, {-87.728916, 
      34.744028}, {-87.723388, 34.748173}, {-87.718469, 
      34.755492}, {-87.715198, 34.760976}, {-87.708018, 
      34.766954999999996`}, {-87.699152, 34.772497}, {-87.691906, 
      34.774387}, {-87.685772, 34.775812}, {-87.67797399999999, 
      34.778162}, {-87.672951, 34.779120999999996`}, {-87.667936, 
      34.780533}, {-87.654574, 34.785208}, {-87.64511499999999, 
      34.788934}, {-87.633956, 34.791314}, {-87.623342, 
      34.792778}}, {{-87.623342, 34.792778}, {-87.62167, 
      34.793248999999996`}, {-87.60941, 34.796999}, {-87.59381499999999, 
      34.802596}, {-87.57596099999999, 34.806849}, {-87.562514, 
      34.806063}, {-87.559212, 34.810179999999995`}, {-87.54978799999999, 
      34.817077999999995`}, {-87.543685, 34.82122}, {-87.53081399999999, 
      34.821788}, {-87.522916, 34.817315}, {-87.507204, 
      34.814727}, {-87.492019, 34.809405999999996`}, {-87.477435, 
      34.807258}, {-87.466731, 34.801897}, {-87.461117, 
      34.80058}, {-87.453835, 34.800186}, {-87.448137, 
      34.792057}, {-87.43966499999999, 34.785767}, {-87.441255, 
      34.778487}, {-87.43893899999999, 34.772147}, {-87.430025, 
      34.775397999999996`}}, {{-87.625074, 34.796395}, {-87.623342, 
      34.792778}}, {{-87.425843, 34.799956}, {-87.434854, 
      34.804426}, {-87.451143, 34.808837}, {-87.486485, 
      34.814448999999996`}, {-87.49100399999999, 
      34.817589999999996`}, {-87.499437, 34.820243}, {-87.508997, 
      34.82334}, {-87.513571, 34.830566999999995`}, {-87.52311999999999, 
      34.832755}, {-87.528714, 34.832252}, {-87.533163, 
      34.829941999999996`}, {-87.546054, 34.830736}, {-87.555511, 
      34.826108999999995`}, {-87.56894899999999, 
      34.825987999999995`}, {-87.586782, 34.819919}, {-87.59111999999999, 
      34.809886999999996`}, {-87.59889199999999, 
      34.805273}, {-87.62284199999999, 34.796870999999996`}, {-87.625074, 
      34.796395}}, {{-87.625074, 34.796395}, {-87.64293699999999, 
      34.793043}, {-87.669089, 34.782793}, {-87.69362699999999, 
      34.777094999999996`}, {-87.708097, 34.771951}, {-87.716375, 
      34.764598}, {-87.73119, 34.746275}, {-87.746799, 34.74293}, {-87.760103,
       34.73552}, {-87.798637, 34.731919}, {-87.805906, 
      34.731837999999996`}, {-87.81770399999999, 
      34.734885999999996`}, {-87.838537, 34.742824999999996`}, {-87.848164, 
      34.749528}, {-87.860709, 34.763009}, {-87.874314, 
      34.772843}, {-87.88845599999999, 34.781306}, {-87.920226, 
      34.804542999999995`}, {-87.92892499999999, 34.820788}, {-87.933173, 
      34.838449}}, {{-87.629138, 34.806348}, {-87.625074, 
      34.796395}}, {{-87.84848699999999, 
      34.511939999999996`}, {-87.85178499999999, 
      34.509176}, {-87.85516299999999, 34.510954}, {-87.85525, 
      34.51595}, {-87.85920999999999, 34.519085}, {-87.865878, 
      34.517644}, {-87.86873, 34.521245}, {-87.87489699999999, 
      34.52299}, {-87.880417, 34.519743999999996`}, {-87.88607499999999, 
      34.524221}, {-87.897795, 34.524535}, {-87.90006699999999, 
      34.526779}, {-87.899033, 34.531335}, {-87.902872, 
      34.527654}, {-87.904594, 34.53036}, {-87.90907299999999, 
      34.531214}, {-87.914683, 34.532964}, {-87.911469, 
      34.540272}, {-87.909937, 34.548013999999995`}, {-87.90005099999999, 
      34.556765}, {-87.89617, 34.558174}, {-87.89343799999999, 
      34.561386999999996`}, {-87.910685, 34.558454}, {-87.91444899999999, 
      34.550685}, {-87.921568, 34.54333}, {-87.918688, 
      34.538367}, {-87.92304999999999, 34.532862}, {-87.930418, 
      34.539131999999995`}, {-87.938785, 34.53903}, {-87.93717099999999, 
      34.542229999999996`}, {-87.94547899999999, 34.538947}, {-87.949451, 
      34.542532}, {-87.957819, 34.542428}, {-87.956248, 
      34.547899}, {-87.964659, 34.550066}, {-87.97004799999999, 
      34.540003}, {-87.964838, 34.530073}, {-87.964238, 
      34.527809}, {-87.954859, 34.533378}, {-87.946382, 
      34.527577}, {-87.93803299999999, 34.528589}, {-87.935693, 
      34.522712}, {-87.927269, 34.519635}, {-87.923232, 
      34.512415}, {-87.922799, 34.519235}, {-87.914434, 
      34.519337}, {-87.907185, 34.519425}, {-87.89921299999999, 
      34.510434}, {-87.899271, 34.513613}, {-87.89544099999999, 
      34.517748}, {-87.886979, 34.512397}, {-87.875301, 
      34.514353}, {-87.868569, 34.51216}, {-87.864634, 
      34.510388999999996`}, {-87.857258, 34.503206}, {-87.847803, 
      34.504678}, {-87.84848699999999, 34.511939999999996`}}, {{-86.72748, 
      32.404599}, {-86.722596, 32.405519999999996`}, {-86.717704, 
      32.403251}, {-86.71660899999999, 32.400064}, {-86.719842, 
      32.3914}, {-86.719247, 32.372264}, {-86.715982, 
      32.369081}, {-86.71324899999999, 32.361795}, {-86.686099, 
      32.353640999999996`}, {-86.68121599999999, 
      32.353649}, {-86.65521799999999, 32.376470999999995`}, {-86.653598, 
      32.381029999999996`}, {-86.655239, 
      32.387406999999996`}, {-86.65417099999999, 32.396521}, {-86.648209, 
      32.401541}, {-86.64224, 32.402916}, {-86.633009, 
      32.402015999999996`}, {-86.62270099999999, 
      32.406583999999995`}, {-86.61944299999999, 32.406587}, {-86.614007, 
      32.401581}, {-86.61291399999999, 32.39657}, {-86.615608, 
      32.382897}, {-86.61668999999999, 32.380162}, {-86.61451, 
      32.374241}, {-86.595501, 32.3615}, {-86.59061799999999, 
      32.362415}, {-86.581949, 32.374725}, {-86.57923699999999, 
      32.376094}, {-86.573809, 32.376098}, {-86.55860799999999, 
      32.369271999999995`}, {-86.547755, 32.369277}, {-86.54232499999999, 
      32.363811}, {-86.53905999999999, 32.345129}, {-86.536889, 
      32.341484}, {-86.532005, 32.338752}, {-86.49783, 
      32.344225}}, {{-86.814638, 32.341052999999995`}, {-86.820583, 
      32.335568}, {-86.818865, 32.312788}, {-86.810711, 
      32.307798}, {-86.798243, 32.308743}, {-86.791215, 
      32.314685}, {-86.784199, 32.324273}}, {{-86.784199, 
      32.324273}, {-86.772866, 32.340706}, {-86.78056, 
      32.368939}, {-86.782192, 32.370301999999995`}, {-86.78118599999999, 
      32.392632}, {-86.774681, 32.395381}, {-86.757291, 
      32.389499}, {-86.746436, 32.389979}, {-86.737222, 
      32.394555}, {-86.72748, 32.404599}}, {{-86.784199, 
      32.324273}, {-86.78746199999999, 32.326543}, {-86.780988, 
      32.336585}, {-86.777209, 32.341606999999996`}, {-86.78160299999999, 
      32.357089}, {-86.78325799999999, 32.364830999999995`}, {-86.787083, 
      32.372112}, {-86.784972, 32.388977}, {-86.783913, 
      32.39627}, {-86.778491, 32.398106}, {-86.74645199999999, 
      32.394991}, {-86.743746, 32.397731}, {-86.745389, 
      32.402283}, {-86.742678, 32.403656}, {-86.73724399999999, 
      32.401845}, {-86.72748, 32.404599}}, {{-86.72748, 
      32.404599}, {-86.726383, 32.400956}, {-86.737211, 
      32.39091}, {-86.752397, 32.386776}, {-86.763803, 
      32.389027999999996`}, {-86.774131, 32.393105}, {-86.778449, 
      32.386258999999995`}, {-86.77789399999999, 32.382615}, {-86.77841, 
      32.374868}, {-86.772387, 32.35939}, {-86.77400999999999, 
      32.358019}, {-86.76852699999999, 32.341172}, {-86.7658, 
      32.336621}, {-86.764156, 32.331613}, {-86.767416, 
      32.333428}, {-86.769594, 32.335701}, {-86.77284399999999, 
      32.334326}, {-86.781481, 32.322457}, {-86.784199, 
      32.324273}}, {{-87.670289, 34.308487}, {-87.669231, 
      34.312132999999996`}, {-87.66596899999999, 34.317164}, {-87.655529, 
      34.325902}, {-87.644531, 34.334645}, {-87.642955, 
      34.341021999999995`}, {-87.648607, 34.346874}, {-87.650731, 
      34.340036999999995`}, {-87.65453199999999, 
      34.333636999999996`}, {-87.66444299999999, 
      34.326722}, {-87.67271199999999, 34.321639999999995`}, {-87.676468, 
      34.312514}, {-87.67808199999999, 34.308862}}, {{-87.670289, 
      34.308487}, {-87.674031, 34.298451}, {-87.682769, 
      34.287911}, {-87.683235, 34.281998}, {-87.680942, 
      34.277477}, {-87.67708499999999, 
      34.279787999999996`}, {-87.67270599999999, 34.284377}, {-87.666068, 
      34.286716}, {-87.66564199999999, 34.295355}, {-87.656317, 
      34.304082}, {-87.646856, 34.303720999999996`}, {-87.644544, 
      34.297836}, {-87.64226, 34.293769}, {-87.640552, 
      34.291059}, {-87.63888299999999, 34.291075}, {-87.638307, 
      34.289718}, {-87.639955, 34.288337999999996`}, {-87.642186, 
      34.288771}, {-87.648906, 34.291886}, {-87.65124399999999, 
      34.299588}, {-87.65726, 34.292712}, {-87.657084, 34.280898}, {-87.66926,
       34.277141}, {-87.678045, 34.269781}, {-87.686967, 
      34.271508}, {-87.692047, 34.276455}, {-87.693208, 
      34.279624}, {-87.68943399999999, 34.287388}, {-87.686195, 
      34.293783999999995`}, {-87.68076599999999, 
      34.302473}, {-87.67808199999999, 34.308862}}, {{-87.67808199999999, 
      34.308862}, {-87.691437, 34.309180999999995`}, {-87.767668, 
      34.310646999999996`}, {-87.786593, 34.311347999999995`}, {-87.856138, 
      34.311921999999996`}, {-87.9001, 34.312764}, {-87.922356, 
      34.312948}, {-87.939606, 34.313190999999996`}, {-88.173435, 
      34.321422999999996`}}, {{-87.634667, 34.307021999999996`}, {-87.670289, 
      34.308487}}, {{-87.670289, 34.308487}, {-87.67808199999999, 
      34.308862}}}]}, 
   {RGBColor[0.575692, 0.11899, 0.08925], PointBox[CompressedData["
1:eJwtVnk41dkbtya7RqSaki0hJD8U0/f7fjPJDYmc24RQQxKypJQS0ULKEjGF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     "]]}, 
   {RGBColor[0.0520638, 0.266529, 0.0545663], PointBox[CompressedData["
1:eJw9V3lYTt/3LYUoiSipkCFTyBRF9+7bYKpocN+UZs0iGmjQLBoVzYbSWymi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     "]]}},
  Frame->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->1663584379]
}, Open  ]],

Cell["Show the layer names and types:", "ExampleText",
 CellID->548210165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/sdtsdlg.tar.gz\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<SDTS\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<LayerNames\>\"", ",", "\"\<LayerTypes\>\""}], "}"}]}], 
      "}"}]}], "]"}], " ", "//", " ", "Transpose"}], " ", "//", " ", 
  "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->575426722],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"PC01\"\>", "\<\"GT-Polygon\"\>"},
    {"\<\"LE01\"\>", "\<\"Complete Chain\"\>"},
    {"\<\"NA01\"\>", "\<\"Area Point\"\>"},
    {"\<\"NO01\"\>", "\<\"Node\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$3369]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->1773057560]
}, Open  ]],

Cell["Import an SDTS digital elevation model:", "ExampleText",
 CellID->1257062758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/sdtsdem.tar.gz\>\"", " ", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->388080005],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvflTz2EXPt5GC2kPpSSVZMlWUnFpQSEhS8oSIoQUJVooW0m0iRJRlqQS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