(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65303,       1775]
NotebookOptionsPosition[     58531,       1557]
NotebookOutlinePosition[     60179,       1599]
CellTagsIndexPosition[     60093,       1594]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"OFF\"" :> Documentation`HelpLookup["paclet:ref/format/OFF"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"VRML\"" :> Documentation`HelpLookup["paclet:ref/format/VRML"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"], 
          "\"ZPR\"" :> Documentation`HelpLookup["paclet:ref/format/ZPR"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"NOFF\\\"\"\>", 7->"\<\"\\\"OBJ\\\"\"\>", 
       8->"\<\"\\\"OFF\\\"\"\>", 9->"\<\"\\\"PLY\\\"\"\>", 
       10->"\<\"\\\"POV\\\"\"\>", 11->"\<\"\\\"RIB\\\"\"\>", 
       12->"\<\"\\\"VRML\\\"\"\>", 13->"\<\"\\\"X3D\\\"\"\>", 
       14->"\<\"\\\"ZPR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Computational Geometry\"\>", 
       3->"\<\"Graphics Importing & Exporting\"\>", 
       4->"\<\"Importing & Exporting\"\>", 
       5->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "STL ",
 StyleBox["(.stl)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/sla", "InlineCode"],
 " \nSTL computer-aided design and manufacturing format. \n3D geometry \
format.\nCommonly used for representing solid models in rapid prototyping \
systems. \nNative format of the 3D Systems stereolithography CAD software.\n\
Developed in 1989 by 3D Systems, Inc.\nSTL is an acronym derived from \
stereolithography.\nASCII or binary format.\nBinary STL files store data \
using little-endian byte ordering. \nStores a solid 3D object as a surface \
formed by a collection of adjacent triangles.\nDoes not store color \
information."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully supports the STL file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", "]"}]], "InlineFormula"],
 "imports an ",
 "STL",
 " file as a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expression to a binary ",
 "STL",
 " file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"], "[", " ", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    RowBox[{
     StyleBox["vertices", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox["primitives", "TI"], ",", 
     StyleBox["opts", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", " ", 
     RowBox[{
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "creates an STL file representing a solid physical model."
}], "FormatNotes",
 CellID->6249],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "STL",
 " file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}]], "InlineFormula"],
 ",",
 Cell[BoxData["\"\<STL\>\""], "InlineFormula"],
 "] or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<STL\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a binary ",
 "STL",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stl\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the STL format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "STL",
     " file represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "STL",
     " file as a ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "the polygon elements in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData[
  RowBox[{"\"\<Graphics3D\>\"", " "}]], "InlineFormula"],
 "element by default for ",
 "STL",
 " files."
}], "FormatNotes",
 CellID->13037],

Cell[TextData[{
 "The ",
 Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
 " element corresponds to the first argument of ",
 Cell[BoxData[
  ButtonBox["GraphicsComplex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->4998],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " element:"
}], "FormatNotes",
 CellID->871823127],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BinaryFormat\>\"", Cell[
    "whether the file is a binary or ASCII STL", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1516492774]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1284028861],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies what background color to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->609898124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->16366],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BinaryFormat\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to write a binary or ASCII file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SurfaceOrientation\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies how triangles should be oriented", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->12033],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<SurfaceOrientation\>\""], "InlineFormula"],
 " are:"
}], "FormatNotes",
 CellID->1473333684],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies no orientation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "}"}], Cell[
    "triangle faces are oriented toward the given point", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "triangles face away from the origin of the coordinate system", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1832777078]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->30231],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZPR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZPR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1919681360]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->161113867],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->343568051],

Cell[TextData[{
 "Import a 3D model from STL and render it as ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->188948766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/spikey.stl\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], Polygon3DBox[CompressedData["
1:eJyll7FKA0EQhheCjYjPEN8iRWDfwdZGBOuUtimD+BABKx/Aeq2tJFVAkIgg
ymGaFNoI3p53x9w5394sBo7ljsmXf/6Z3bkcnc2Oz0fOuWl5jeqr/NydbFah
XMfTgw8f76++d979/YwPZ9vq+f3qIa7Li5f36n4xefQpDsS7m73X8IvemDgQ
TzrnxeU2iOeDeQEfOaRHPA+ZHBlPOqU/ITMvyUcO6RF1NHEgnnQur2/fKp/W
u2dTXsBHDulZTIrO7wxxIN6Sl2l/GfR0OKQH9h1yaJ+Czlj3uMq6V76W/VN/
r+2fUPOD6/ofUhyI1/QkORBPOuM+lXlreXkR/x+OJS/kGPKSOqU/3uk+U14m
DvkDOpFDeYHO2M+VT6Kfa1+LDk/pQxOH/AGdyKG8QKfkmPZFLof8MeRl2l+g
s+znp7ie7s8/5TmC5w/4n+JQP9d6+/Nd59B853P1S/oxyOF66RyqF8xrix4Z
b/EnWDiGunc41M8wr1McLR7ff+q5184LA8f3OCHFoXMe5jVyDPOd8vIWDp3z
xKFznv4XEIf2O+iMdY+rrHvT/6rPif5ROVT3RD8TR+1n0Bn3qcxXy6vjM78f
6hxD3XP1UF5Sp/THO90fS/+kOGr/5OpJ9LOms5l7sp8bn0PP54Yfenyf4iTm
TpYe8hl0So61nxudcr8gh+ZFrh7De12r8wec4ML3
    "]]},
  Boxed->False,
  ImageSize->Medium,
  ViewPoint->{2.425220603383291, -1.8929522499213844`, 1.408913341707985},
  ViewVertical->{0.47689548512518376`, 0.20264331378247621`, 
   1.0600157559955998`}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1725662738]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->1681079896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/spikey.stl\>\"", ",", " ", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269893176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"BinaryFormat\"\>", ",", "\<\"Graphics3D\"\>", 
   ",", "\<\"GraphicsComplex\"\>", ",", "\<\"PolygonData\"\>", 
   ",", "\<\"PolygonObjects\"\>", ",", "\<\"VertexData\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1446984831]
}, Open  ]],

Cell["Test whether this file is a binary or ASCII STL:", "ExampleText",
 CellID->1614952140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{
  "\"\<ExampleData/spikey.stl\>\"", ",", " ", "\"\<BinaryFormat\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->224862385],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[3]=",
 CellID->1369235989]
}, Open  ]],

Cell["Read the vertex coordinates represented in this file:", "ExampleText",
 CellID->1250473434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/spikey.stl\>\"", ",", " ", "\"\<VertexData\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->367042401],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.29494374990463257`"}], ",", "0.907743513584137`", ",", 
     "1.2494018077850342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.9510565400123596`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2628655433654785`", ",", "0.80901700258255`", ",", 
     "0.4253253936767578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6881909370422363`"}], ",", "0.5`", ",", 
     "0.4253253936767578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.9544579982757568`"}], ",", "0.`", ",", 
     "1.2494018077850342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6881909370422363`"}], ",", 
     RowBox[{"-", "0.5`"}], ",", "0.4253253936767578`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.29494374990463257`"}], ",", 
     RowBox[{"-", "0.907743513584137`"}], ",", "1.2494018077850342`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.2628655433654785`", ",", 
     RowBox[{"-", "0.80901700258255`"}], ",", "0.4253253936767578`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.772172749042511`", ",", 
     RowBox[{"-", "0.561016321182251`"}], ",", "1.2494018077850342`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"0.8506507873535156`", ",", "0.`", ",", "0.4253253936767578`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.772172749042511`", ",", "0.561016321182251`", ",", 
     "1.2494018077850342`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29494374990463257`", ",", 
     RowBox[{"-", "0.907743513584137`"}], ",", 
     RowBox[{"-", "1.2494018077850342`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6881909370422363`", ",", 
     RowBox[{"-", "0.5`"}], ",", 
     RowBox[{"-", "0.4253253936767578`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2628655433654785`"}], ",", 
     RowBox[{"-", "0.80901700258255`"}], ",", 
     RowBox[{"-", "0.4253253936767578`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", 
     RowBox[{"-", "0.9510565400123596`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9544579982757568`", ",", "0.`", ",", 
     RowBox[{"-", "1.2494018077850342`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6881909370422363`", ",", "0.5`", ",", 
     RowBox[{"-", "0.4253253936767578`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29494374990463257`", ",", "0.907743513584137`", ",", 
     RowBox[{"-", "1.2494018077850342`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.2628655433654785`"}], ",", "0.80901700258255`", ",", 
     RowBox[{"-", "0.4253253936767578`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.772172749042511`"}], ",", "0.561016321182251`", ",", 
     RowBox[{"-", "1.2494018077850342`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8506507873535156`"}], ",", "0.`", ",", 
     RowBox[{"-", "0.4253253936767578`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.772172749042511`"}], ",", 
     RowBox[{"-", "0.561016321182251`"}], ",", 
     RowBox[{"-", "1.2494018077850342`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4772289991378784`"}], ",", "1.4687598943710327`", ",", 
     "0.29494374990463257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.544345498085022`"}], ",", "0.`", ",", 
     "0.29494374990463257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.4772289991378784`"}], ",", 
     RowBox[{"-", "1.4687598943710327`"}], ",", "0.29494374990463257`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.2494018077850342`", ",", 
     RowBox[{"-", "0.907743513584137`"}], ",", "0.29494374990463257`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.2494018077850342`", ",", "0.907743513584137`", ",", 
     "0.29494374990463257`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4772289991378784`", ",", 
     RowBox[{"-", "1.4687598943710327`"}], ",", 
     RowBox[{"-", "0.29494374990463257`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.544345498085022`", ",", "0.`", ",", 
     RowBox[{"-", "0.29494374990463257`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4772289991378784`", ",", "1.4687598943710327`", ",", 
     RowBox[{"-", "0.29494374990463257`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2494018077850342`"}], ",", "0.907743513584137`", ",", 
     RowBox[{"-", "0.29494374990463257`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2494018077850342`"}], ",", 
     RowBox[{"-", "0.907743513584137`"}], ",", 
     RowBox[{"-", "0.29494374990463257`"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1308599423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1195728668],

Cell["\<\
Construct a 3D model based on the evolution of a cellular automaton:\
\>", "ExampleText",
 CellID->459754450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", " ", "[", 
  RowBox[{
   RowBox[{"Cuboid", "/@", 
    RowBox[{"Position", "[", 
     RowBox[{
      RowBox[{"Last", "[", 
       RowBox[{"CellularAutomaton", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"14", ",", " ", 
           RowBox[{"{", 
            RowBox[{"2", ",", " ", "1"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"1", ",", " ", "1", ",", "1"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"{", 
             RowBox[{"{", "1", "}"}], "}"}], "}"}], ",", "0"}], "}"}], ",", 
         "6"}], "]"}], "]"}], ",", "1"}], "]"}]}], ",", " ", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->446879244],

Cell[BoxData[
 Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
   CuboidBox[{1, 1, 3}], CuboidBox[{1, 1, 4}], CuboidBox[{1, 1, 5}], 
   CuboidBox[{1, 1, 6}], CuboidBox[{1, 1, 7}], CuboidBox[{1, 1, 8}], 
   CuboidBox[{1, 1, 9}], CuboidBox[{1, 1, 10}], CuboidBox[{1, 1, 11}], 
   CuboidBox[{1, 1, 12}], CuboidBox[{1, 1, 13}], CuboidBox[{1, 2, 1}], 
   CuboidBox[{1, 2, 13}], CuboidBox[{1, 3, 1}], CuboidBox[{1, 3, 13}], 
   CuboidBox[{1, 4, 1}], CuboidBox[{1, 4, 13}], CuboidBox[{1, 5, 1}], 
   CuboidBox[{1, 5, 6}], CuboidBox[{1, 5, 7}], CuboidBox[{1, 5, 8}], 
   CuboidBox[{1, 5, 13}], CuboidBox[{1, 6, 1}], CuboidBox[{1, 6, 5}], 
   CuboidBox[{1, 6, 9}], CuboidBox[{1, 6, 13}], CuboidBox[{1, 7, 1}], 
   CuboidBox[{1, 7, 5}], CuboidBox[{1, 7, 9}], CuboidBox[{1, 7, 13}], 
   CuboidBox[{1, 8, 1}], CuboidBox[{1, 8, 5}], CuboidBox[{1, 8, 9}], 
   CuboidBox[{1, 8, 13}], CuboidBox[{1, 9, 1}], CuboidBox[{1, 9, 6}], 
   CuboidBox[{1, 9, 7}], CuboidBox[{1, 9, 8}], CuboidBox[{1, 9, 13}], 
   CuboidBox[{1, 10, 1}], CuboidBox[{1, 10, 13}], CuboidBox[{1, 11, 1}], 
   CuboidBox[{1, 11, 13}], CuboidBox[{1, 12, 1}], CuboidBox[{1, 12, 13}], 
   CuboidBox[{1, 13, 1}], CuboidBox[{1, 13, 2}], CuboidBox[{1, 13, 3}], 
   CuboidBox[{1, 13, 4}], CuboidBox[{1, 13, 5}], CuboidBox[{1, 13, 6}], 
   CuboidBox[{1, 13, 7}], CuboidBox[{1, 13, 8}], CuboidBox[{1, 13, 9}], 
   CuboidBox[{1, 13, 10}], CuboidBox[{1, 13, 11}], CuboidBox[{1, 13, 12}], 
   CuboidBox[{1, 13, 13}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 13}], 
   CuboidBox[{2, 13, 1}], CuboidBox[{2, 13, 13}], CuboidBox[{3, 1, 1}], 
   CuboidBox[{3, 1, 13}], CuboidBox[{3, 13, 1}], CuboidBox[{3, 13, 13}], 
   CuboidBox[{4, 1, 1}], CuboidBox[{4, 1, 13}], CuboidBox[{4, 13, 1}], 
   CuboidBox[{4, 13, 13}], CuboidBox[{5, 1, 1}], CuboidBox[{5, 1, 6}], 
   CuboidBox[{5, 1, 7}], CuboidBox[{5, 1, 8}], CuboidBox[{5, 1, 13}], 
   CuboidBox[{5, 5, 6}], CuboidBox[{5, 5, 7}], CuboidBox[{5, 5, 8}], 
   CuboidBox[{5, 6, 1}], CuboidBox[{5, 6, 5}], CuboidBox[{5, 6, 9}], 
   CuboidBox[{5, 6, 13}], CuboidBox[{5, 7, 1}], CuboidBox[{5, 7, 5}], 
   CuboidBox[{5, 7, 9}], CuboidBox[{5, 7, 13}], CuboidBox[{5, 8, 1}], 
   CuboidBox[{5, 8, 5}], CuboidBox[{5, 8, 9}], CuboidBox[{5, 8, 13}], 
   CuboidBox[{5, 9, 6}], CuboidBox[{5, 9, 7}], CuboidBox[{5, 9, 8}], 
   CuboidBox[{5, 13, 1}], CuboidBox[{5, 13, 6}], CuboidBox[{5, 13, 7}], 
   CuboidBox[{5, 13, 8}], CuboidBox[{5, 13, 13}], CuboidBox[{6, 1, 1}], 
   CuboidBox[{6, 1, 5}], CuboidBox[{6, 1, 9}], CuboidBox[{6, 1, 13}], 
   CuboidBox[{6, 5, 1}], CuboidBox[{6, 5, 5}], CuboidBox[{6, 5, 9}], 
   CuboidBox[{6, 5, 13}], CuboidBox[{6, 9, 1}], CuboidBox[{6, 9, 5}], 
   CuboidBox[{6, 9, 9}], CuboidBox[{6, 9, 13}], CuboidBox[{6, 13, 1}], 
   CuboidBox[{6, 13, 5}], CuboidBox[{6, 13, 9}], CuboidBox[{6, 13, 13}], 
   CuboidBox[{7, 1, 1}], CuboidBox[{7, 1, 5}], CuboidBox[{7, 1, 9}], 
   CuboidBox[{7, 1, 13}], CuboidBox[{7, 5, 1}], CuboidBox[{7, 5, 5}], 
   CuboidBox[{7, 5, 9}], CuboidBox[{7, 5, 13}], CuboidBox[{7, 9, 1}], 
   CuboidBox[{7, 9, 5}], CuboidBox[{7, 9, 9}], CuboidBox[{7, 9, 13}], 
   CuboidBox[{7, 13, 1}], CuboidBox[{7, 13, 5}], CuboidBox[{7, 13, 9}], 
   CuboidBox[{7, 13, 13}], CuboidBox[{8, 1, 1}], CuboidBox[{8, 1, 5}], 
   CuboidBox[{8, 1, 9}], CuboidBox[{8, 1, 13}], CuboidBox[{8, 5, 1}], 
   CuboidBox[{8, 5, 5}], CuboidBox[{8, 5, 9}], CuboidBox[{8, 5, 13}], 
   CuboidBox[{8, 9, 1}], CuboidBox[{8, 9, 5}], CuboidBox[{8, 9, 9}], 
   CuboidBox[{8, 9, 13}], CuboidBox[{8, 13, 1}], CuboidBox[{8, 13, 5}], 
   CuboidBox[{8, 13, 9}], CuboidBox[{8, 13, 13}], CuboidBox[{9, 1, 1}], 
   CuboidBox[{9, 1, 6}], CuboidBox[{9, 1, 7}], CuboidBox[{9, 1, 8}], 
   CuboidBox[{9, 1, 13}], CuboidBox[{9, 5, 6}], CuboidBox[{9, 5, 7}], 
   CuboidBox[{9, 5, 8}], CuboidBox[{9, 6, 1}], CuboidBox[{9, 6, 5}], 
   CuboidBox[{9, 6, 9}], CuboidBox[{9, 6, 13}], CuboidBox[{9, 7, 1}], 
   CuboidBox[{9, 7, 5}], CuboidBox[{9, 7, 9}], CuboidBox[{9, 7, 13}], 
   CuboidBox[{9, 8, 1}], CuboidBox[{9, 8, 5}], CuboidBox[{9, 8, 9}], 
   CuboidBox[{9, 8, 13}], CuboidBox[{9, 9, 6}], CuboidBox[{9, 9, 7}], 
   CuboidBox[{9, 9, 8}], CuboidBox[{9, 13, 1}], CuboidBox[{9, 13, 6}], 
   CuboidBox[{9, 13, 7}], CuboidBox[{9, 13, 8}], CuboidBox[{9, 13, 13}], 
   CuboidBox[{10, 1, 1}], CuboidBox[{10, 1, 13}], CuboidBox[{10, 13, 1}], 
   CuboidBox[{10, 13, 13}], CuboidBox[{11, 1, 1}], CuboidBox[{11, 1, 13}], 
   CuboidBox[{11, 13, 1}], CuboidBox[{11, 13, 13}], CuboidBox[{12, 1, 1}], 
   CuboidBox[{12, 1, 13}], CuboidBox[{12, 13, 1}], CuboidBox[{12, 13, 13}], 
   CuboidBox[{13, 1, 1}], CuboidBox[{13, 1, 2}], CuboidBox[{13, 1, 3}], 
   CuboidBox[{13, 1, 4}], CuboidBox[{13, 1, 5}], CuboidBox[{13, 1, 6}], 
   CuboidBox[{13, 1, 7}], CuboidBox[{13, 1, 8}], CuboidBox[{13, 1, 9}], 
   CuboidBox[{13, 1, 10}], CuboidBox[{13, 1, 11}], CuboidBox[{13, 1, 12}], 
   CuboidBox[{13, 1, 13}], CuboidBox[{13, 2, 1}], CuboidBox[{13, 2, 13}], 
   CuboidBox[{13, 3, 1}], CuboidBox[{13, 3, 13}], CuboidBox[{13, 4, 1}], 
   CuboidBox[{13, 4, 13}], CuboidBox[{13, 5, 1}], CuboidBox[{13, 5, 6}], 
   CuboidBox[{13, 5, 7}], CuboidBox[{13, 5, 8}], CuboidBox[{13, 5, 13}], 
   CuboidBox[{13, 6, 1}], CuboidBox[{13, 6, 5}], CuboidBox[{13, 6, 9}], 
   CuboidBox[{13, 6, 13}], CuboidBox[{13, 7, 1}], CuboidBox[{13, 7, 5}], 
   CuboidBox[{13, 7, 9}], CuboidBox[{13, 7, 13}], CuboidBox[{13, 8, 1}], 
   CuboidBox[{13, 8, 5}], CuboidBox[{13, 8, 9}], CuboidBox[{13, 8, 13}], 
   CuboidBox[{13, 9, 1}], CuboidBox[{13, 9, 6}], CuboidBox[{13, 9, 7}], 
   CuboidBox[{13, 9, 8}], CuboidBox[{13, 9, 13}], CuboidBox[{13, 10, 1}], 
   CuboidBox[{13, 10, 13}], CuboidBox[{13, 11, 1}], CuboidBox[{13, 11, 13}], 
   CuboidBox[{13, 12, 1}], CuboidBox[{13, 12, 13}], CuboidBox[{13, 13, 1}], 
   CuboidBox[{13, 13, 2}], CuboidBox[{13, 13, 3}], CuboidBox[{13, 13, 4}], 
   CuboidBox[{13, 13, 5}], CuboidBox[{13, 13, 6}], CuboidBox[{13, 13, 7}], 
   CuboidBox[{13, 13, 8}], CuboidBox[{13, 13, 9}], CuboidBox[{13, 13, 10}], 
   CuboidBox[{13, 13, 11}], CuboidBox[{13, 13, 12}], CuboidBox[{13, 13, 13}]},
  
  Boxed->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->693315727]
}, Open  ]],

Cell["Export it to STL:", "ExampleText",
 CellID->311155067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<model.stl\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460530624],

Cell[BoxData["\<\"model.stl\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->607133780]
}, Open  ]],

Cell["\<\
Import this file, rendering the model against a dark background:\
\>", "ExampleText",
 CellID->1061444032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<model.stl\>\"", ",", 
   RowBox[{"Background", " ", "\[Rule]", " ", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->755572447],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[None], Polygon3DBox[CompressedData["
1:eJzNnUGO5dhyZBPQpICe1KAGMchBiggUCoXYQ2sNvYQGNO4t9RK1BEGQOJAB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    "]]},
  Background->GrayLevel[0],
  Boxed->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->912704459]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"STL - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 14.7483258}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/sla STL computer-aided design and manufacturing \
format. 3D geometry format. Commonly used for representing solid models in \
rapid prototyping systems. Native format of the 3D Systems stereolithography \
CAD software. Developed in 1989 by 3D Systems, Inc. STL is an acronym derived \
from stereolithography. ASCII or binary format. Binary STL files store data \
using little-endian byte ordering. Stores a solid 3D object as a surface \
formed by a collection of adjacent triangles. Does not store color \
information.", "synonyms" -> {}, "title" -> "STL", "type" -> "Format", "uri" -> 
    "ref/format/STL"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[25529, 866, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 59959, 1587}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4045, 83, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4668, 110, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[4772, 116, 645, 12, 70, "FormatUsage",
 CellID->20778],
Cell[5420, 130, 329, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[5786, 147, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[5853, 150, 416, 16, 70, "FormatNotes",
 CellID->2520],
Cell[6272, 168, 476, 18, 70, "FormatNotes",
 CellID->12927],
Cell[6751, 188, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[6793, 191, 741, 25, 70, "FormatNotes",
 CellID->25134],
Cell[7537, 218, 517, 17, 70, "FormatNotes",
 CellID->6249],
Cell[8057, 237, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[8099, 240, 352, 13, 70, "FormatNotes",
 CellID->22675],
Cell[8454, 255, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[9031, 277, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[9616, 300, 694, 25, 70, "FormatNotes",
 CellID->21001],
Cell[10313, 327, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[10354, 330, 530, 20, 70, "FormatNotes",
 CellID->9310],
Cell[10887, 352, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[11965, 394, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[12629, 418, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[13448, 448, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[13489, 451, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[13853, 467, 342, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[14232, 484, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[14286, 487, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[14481, 497, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[15151, 512, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[15193, 515, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[15264, 518, 1433, 38, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[16700, 558, 424, 17, 70, "FormatNotes",
 CellID->13037],
Cell[17127, 577, 304, 10, 70, "FormatNotes",
 CellID->4998],
Cell[17434, 589, 196, 8, 70, "FormatNotes",
 CellID->871823127],
Cell[17633, 599, 381, 9, 70, "2ColumnTableMod",
 CellID->1516492774]
}, Open  ]],
Cell[CellGroupData[{
Cell[18051, 613, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[18103, 616, 196, 8, 70, "FormatNotes",
 CellID->1284028861],
Cell[18302, 626, 861, 23, 70, "3ColumnTableMod",
 CellID->609898124],
Cell[19166, 651, 178, 7, 70, "FormatNotes",
 CellID->16366],
Cell[19347, 660, 836, 20, 70, "3ColumnTableMod",
 CellID->12033],
Cell[20186, 682, 154, 5, 70, "FormatNotes",
 CellID->1473333684],
Cell[20343, 689, 931, 25, 70, "2ColumnTableMod",
 CellID->1832777078]
}, Closed]],
Cell[CellGroupData[{
Cell[21311, 719, 53, 1, 70, "TutorialsSection",
 CellID->30231],
Cell[21367, 722, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[21535, 727, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[21742, 735, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[21795, 738, 2884, 97, 70, "SeeAlso",
 CellID->1919681360]
}, Open  ]],
Cell[CellGroupData[{
Cell[24716, 840, 58, 1, 70, "MoreAboutSection",
 CellID->161113867],
Cell[24777, 843, 150, 2, 70, "MoreAbout"],
Cell[24930, 847, 135, 2, 70, "MoreAbout"],
Cell[25068, 851, 151, 2, 70, "MoreAbout"],
Cell[25222, 855, 134, 2, 70, "MoreAbout"],
Cell[25359, 859, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25529, 866, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[25645, 872, 60, 1, 70, "ExampleSection",
 CellID->343568051],
Cell[25708, 875, 231, 8, 70, "ExampleText",
 CellID->188948766],
Cell[CellGroupData[{
Cell[25964, 887, 127, 3, 70, "Input",
 CellID->17199],
Cell[26094, 892, 1057, 22, 70, "Output",
 CellID->1725662738]
}, Open  ]],
Cell[27166, 917, 221, 8, 70, "ExampleText",
 CellID->1681079896],
Cell[CellGroupData[{
Cell[27412, 929, 177, 5, 70, "Input",
 CellID->269893176],
Cell[27592, 936, 282, 7, 70, "Output",
 CellID->1446984831]
}, Open  ]],
Cell[27889, 946, 92, 1, 70, "ExampleText",
 CellID->1614952140],
Cell[CellGroupData[{
Cell[28006, 951, 184, 6, 70, "Input",
 CellID->224862385],
Cell[28193, 959, 75, 2, 70, "Output",
 CellID->1369235989]
}, Open  ]],
Cell[28283, 964, 97, 1, 70, "ExampleText",
 CellID->1250473434],
Cell[CellGroupData[{
Cell[28405, 969, 179, 5, 70, "Input",
 CellID->367042401],
Cell[28587, 976, 4794, 128, 70, "Output",
 CellID->1308599423]
}, Open  ]],
Cell[33396, 1107, 126, 3, 70, "ExampleDelimiter",
 CellID->1195728668],
Cell[33525, 1112, 119, 3, 70, "ExampleText",
 CellID->459754450],
Cell[CellGroupData[{
Cell[33669, 1119, 805, 23, 70, "Input",
 CellID->446879244],
Cell[34477, 1144, 6104, 87, 70, "Output",
 CellID->693315727]
}, Open  ]],
Cell[40596, 1234, 60, 1, 70, "ExampleText",
 CellID->311155067],
Cell[CellGroupData[{
Cell[40681, 1239, 141, 4, 70, "Input",
 CellID->460530624],
Cell[40825, 1245, 87, 2, 70, "Output",
 CellID->607133780]
}, Open  ]],
Cell[40927, 1250, 116, 3, 70, "ExampleText",
 CellID->1061444032],
Cell[CellGroupData[{
Cell[41068, 1257, 194, 5, 70, "Input",
 CellID->755572447],
Cell[41265, 1264, 17200, 286, 70, "Output",
 CellID->912704459]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[58504, 1555, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

