(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22802,        804]
NotebookOptionsPosition[     18269,        658]
NotebookOutlinePosition[     19662,        697]
CellTagsIndexPosition[     19577,        692]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "New in 6.0: Import & Export Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/NewIn60ImportAndExportFormats"], 
         "Tabular & Spreadsheet Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/TabularAndSpreadsheetFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Importing & Exporting\"\>", 
      2->"\<\"Listing of All Formats\"\>", 
      3->"\<\"New in 6.0: Import & Export Formats\"\>", 
      4->"\<\"Tabular & Spreadsheet Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SXC ",
 StyleBox["(.sxc)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->16827],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/nd.sun.xml.calc", "InlineCode"],
 "\nOpenOffice 1.0 spreadsheet file.\nStores spreadsheet data and formulas.\n\
SXC is an acronym for Sun XML Calc.\nNative spreadsheet format of \
OpenOffice.org 1.0 and StarOffice 6.0.\nZIP-compressed XML format.\nSupports \
multiple sheets in one file."
}], "FormatUsage",
 CellID->9961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the SXC format."
}], "FormatNotes",
 CellID->491]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->2995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", "]"}]], "InlineFormula"],
 " imports all sheets of an ",
 "SXC",
 " file, returning the result as a list of arrays."
}], "FormatNotes",
 CellID->11942],

Cell["", "WeakDivider",
 CellID->5436],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", "]"}], " "}]], "InlineFormula"],
 "returns the sheets of an SXC file as an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are full arrays containing numerical and textual data, Boolean values, and \
date specifications."
}], "FormatNotes",
 CellID->32391],

Cell["", "WeakDivider",
 CellID->3902],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "SXC",
 " file."
}], "FormatNotes",
 CellID->153],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->292],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->12382],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<SXC\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<SXC\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17421],

Cell["", "WeakDivider",
 CellID->14771],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->11538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "SXC",
 " format."
}], "FormatNotes",
 CellID->1869]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->19912],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->25667],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->26299],

Cell["", "WeakDivider",
 CellID->17035],

Cell["Data representation elements:", "FormatNotes",
 CellID->9894],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of full arrays, representing all sheets", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Formulas\>\"", Cell[
    "all SXC formulas as text", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->146182287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->812283704],

Cell[TextData[{
 "SXC data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell[TextData[{
 "SXC",
 " error cells are imported as ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->819249840],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "[\"",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 ".",
 Cell[BoxData["sxc"], "InlineFormula"],
 "\", ",
 Cell[BoxData[
  RowBox[{"\"\<Formulas\>\"", "]"}]], "InlineFormula"],
 "gives spreadsheet formulas for each cell in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are arrays corresponding to the sheets of an SXC file."
}], "FormatNotes",
 CellID->498669149],

Cell["Importing parts of a data sheet:", "FormatNotes",
 CellID->1203739437],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     RowBox[{
      StyleBox["k", "TI"], Cell["", "TableText"]}]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet, given as a array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     StyleBox["k", "TI"], ",", " ", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     StyleBox["k", "TI"], ",", " ", 
     StyleBox["m", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "cell ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1453356619],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Data\>\"", ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 "returns the first sheet as an array."
}], "FormatNotes",
 CellID->2093805552],

Cell["\<\
The following can be used to select or specify individual sheets by name:\
\>", "FormatNotes",
 CellID->28703],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Sheets\>\"", Cell[
    "list of sheet names", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " of sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", 
     StyleBox["m", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "cell ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " in sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->487595630],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<Sheets\>\"", ",", " ", 
       ButtonBox["All",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/All"]}], "}"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).sxc\>\"", ",", " ", "\"\<Data\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->426627287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " yields spreadsheets as full rectangular arrays. "
}], "FormatNotes",
 CellID->1651196649]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->159661309],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->430996607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "@", 
   RowBox[{"Import", "[", "\"\<ExampleData/mountains.sxc\>\"", "]"}]}], " ", "//",
   " ", "TableForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1225429597],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Rank\"\>", "\<\"Name\"\>", "\<\"Height\"\>", "\<\"First\"\>", \
"\<\"Ascend\"\>"},
    {"1", "\<\"Mount Everest\"\>", "8848", "1953", "\<\"\"\>"},
    {"2", "\<\"K2\"\>", "8611", "1954", "\<\"\"\>"},
    {"3", "\<\"Kangchenjunga\"\>", "8586", "1955", "\<\"\"\>"},
    {"4", "\<\"Lhotse\"\>", "8516", "1956", "\<\"\"\>"},
    {"5", "\<\"Makalu\"\>", "8485", "1955", "\<\"\"\>"},
    {"6", "\<\"Cho Oyu\"\>", "8188", "1954", "\<\"\"\>"},
    {"7", "\<\"Dhaulagiri\"\>", "8167", "1960", "\<\"\"\>"},
    {"8", "\<\"Manaslu\"\>", "8163", "1956", "\<\"\"\>"},
    {"9", "\<\"Nanga Parbat\"\>", "8125", "1953", "\<\"\"\>"},
    {"10", "\<\"Annapurna I\"\>", "8091", "1950", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[1]//TableForm=",
 CellID->2088152101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/mountains.sxc\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<Data\>\"", ",", " ", "1", ",", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1394602233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "\<\"K2\"\>", ",", "8611", ",", "1954", ",", "\<\"\"\>"}],
   "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->146760246]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SXC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 16.3264912}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/nd.sun.xml.calc OpenOffice 1.0 spreadsheet file. \
Stores spreadsheet data and formulas. SXC is an acronym for Sun XML Calc. \
Native spreadsheet format of OpenOffice.org 1.0 and StarOffice 6.0. \
ZIP-compressed XML format. Supports multiple sheets in one file.", 
    "synonyms" -> {}, "title" -> "SXC", "type" -> "Format", "uri" -> 
    "ref/format/SXC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16106, 585, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19443, 685}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1151, 25, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1774, 52, 102, 4, 70, "ObjectNameAlt",
 CellID->16827],
Cell[1879, 58, 377, 8, 70, "FormatUsage",
 CellID->9961],
Cell[2259, 68, 198, 7, 70, "FormatNotes",
 CellID->491]
}, Open  ]],
Cell[CellGroupData[{
Cell[2494, 80, 52, 1, 70, "ImportExportSection",
 CellID->2995],
Cell[2549, 83, 333, 11, 70, "FormatNotes",
 CellID->11942],
Cell[2885, 96, 38, 1, 70, "WeakDivider",
 CellID->5436],
Cell[2926, 99, 822, 27, 70, "FormatNotes",
 CellID->32391],
Cell[3751, 128, 38, 1, 70, "WeakDivider",
 CellID->3902],
Cell[3792, 131, 350, 13, 70, "FormatNotes",
 CellID->153],
Cell[4145, 146, 572, 20, 70, "FormatNotes",
 CellID->292],
Cell[4720, 168, 582, 21, 70, "FormatNotes",
 CellID->12382],
Cell[5305, 191, 703, 25, 70, "FormatNotes",
 CellID->17421],
Cell[6011, 218, 39, 1, 70, "WeakDivider",
 CellID->14771],
Cell[6053, 221, 236, 9, 70, "FormatNotes",
 CellID->11538],
Cell[6292, 232, 215, 9, 70, "FormatNotes",
 CellID->1869]
}, Closed]],
Cell[CellGroupData[{
Cell[6544, 246, 51, 1, 70, "ElementsSection",
 CellID->19912],
Cell[6598, 249, 192, 8, 70, "FormatNotes",
 CellID->25667],
Cell[6793, 259, 668, 13, 70, "2ColumnTableMod",
 CellID->26299],
Cell[7464, 274, 39, 1, 70, "WeakDivider",
 CellID->17035],
Cell[7506, 277, 67, 1, 70, "FormatNotes",
 CellID->9894],
Cell[7576, 280, 496, 11, 70, "2ColumnTableMod",
 CellID->146182287],
Cell[8075, 293, 257, 9, 70, "FormatNotes",
 CellID->812283704],
Cell[8335, 304, 577, 21, 70, "FormatNotes",
 CellID->373727629],
Cell[8915, 327, 218, 9, 70, "FormatNotes",
 CellID->819249840],
Cell[9136, 338, 867, 31, 70, "FormatNotes",
 CellID->498669149],
Cell[10006, 371, 76, 1, 70, "FormatNotes",
 CellID->1203739437],
Cell[10085, 374, 1663, 53, 70, "2ColumnTableMod",
 CellID->1453356619],
Cell[11751, 429, 378, 12, 70, "FormatNotes",
 CellID->2093805552],
Cell[12132, 443, 120, 3, 70, "FormatNotes",
 CellID->28703],
Cell[12255, 448, 1457, 43, 70, "2ColumnTableMod",
 CellID->487595630],
Cell[13715, 493, 720, 26, 70, "FormatNotes",
 CellID->426627287],
Cell[14438, 521, 223, 7, 70, "FormatNotes",
 CellID->1651196649]
}, Open  ]],
Cell[CellGroupData[{
Cell[14698, 533, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[14750, 536, 177, 7, 70, "FormatNotes",
 CellID->31322],
Cell[14930, 545, 460, 13, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[15427, 563, 58, 1, 70, "MoreAboutSection",
 CellID->159661309],
Cell[15488, 566, 134, 2, 70, "MoreAbout"],
Cell[15625, 570, 133, 2, 70, "MoreAbout"],
Cell[15761, 574, 156, 2, 70, "MoreAbout"],
Cell[15920, 578, 149, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16106, 585, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[16222, 591, 60, 1, 70, "ExampleSection",
 CellID->430996607],
Cell[CellGroupData[{
Cell[16307, 596, 208, 6, 70, "Input",
 CellID->1225429597],
Cell[16518, 604, 1233, 28, 70, "Output",
 CellID->2088152101]
}, Open  ]],
Cell[CellGroupData[{
Cell[17788, 637, 241, 7, 70, "Input",
 CellID->1394602233],
Cell[18032, 646, 171, 5, 70, "Output",
 CellID->146760246]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[18242, 656, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

