(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    123127,       2503]
NotebookOptionsPosition[    117952,       2337]
NotebookOutlinePosition[    119476,       2377]
CellTagsIndexPosition[    119389,       2372]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"PNG\\\"\"\>", 
       3->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"New in 6.0: Import & Export Formats\"\>", 
       3->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TGA ",
 StyleBox["(.tga)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "Common MIME types:",
 StyleBox[" application/tga, image/tga, image/tga", "InlineCode"],
 "\nTruevision TARGA format.\nRaster image file format.\nWidely used in \
animation and video applications.\nWas native format of TARGA video cards.\n\
Binary format.\nSupports color mapped and true-color raster images.\nCan \
compress data using a run-length encoding method.\nSupports alpha channels.\n\
Introduced by Truevision in 1984, updated as Version 2.0 in 1989."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support Version 2.0 of the TGA format."
}], "FormatNotes",
 CellID->5055]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "TGA",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as an image to TGA."
}], "FormatNotes",
 CellID->6748],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of RGB color values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "TGA",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because TGA is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from TGA."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<TGA\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<TGA\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "TGA",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tga\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "TGA",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for ",
 "TGA",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->450361849],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", Cell[
    "color encoding used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1499224115]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General option:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17282]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->377367688],

Cell[TextData[{
 "Import a TGA example file and render it as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->514176551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", " ", "\"\<ExampleData/spikey4.tga\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvQdUG2m2qHveSXfO5NA93dPR3c42zgbb2Cbb2OSccwaBhBAgEDlIIBGE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   "], {{0, 0}, {226, 204}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{226, 204},
  PlotRange->{{0, 226}, {0, 204}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->313531749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291097129],

Cell[TextData[{
 "Create a raster image using ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and export it to TGA:"
}], "ExampleText",
 CellID->501699237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<BrightBands\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1038278137],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxlewk0ld/3vqEooTRokkylRAqFlAelUIkoQqVBxoQmCpXSaKqEElJKylBI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   "], {{0, 0}, {30, 20}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->1881039231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<image.tga\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1327976690],

Cell[BoxData["\<\"image.tga\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->506685559]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TGA - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 22.8266576}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Common MIME types: application/tga, image/tga, image/tga Truevision \
TARGA format. Raster image file format. Widely used in animation and video \
applications. Was native format of TARGA video cards. Binary format. Supports \
color mapped and true-color raster images. Can compress data using a \
run-length encoding method. Supports alpha channels. Introduced by Truevision \
in 1984, updated as Version 2.0 in 1989.", "synonyms" -> {}, "title" -> "TGA",
     "type" -> "Format", "uri" -> "ref/format/TGA"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17223, 625, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 119255, 2365}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1740, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2363, 68, 101, 4, 70, "ObjectNameAlt",
 CellID->7514],
Cell[2467, 74, 513, 9, 70, "FormatUsage",
 CellID->10168],
Cell[2983, 85, 338, 12, 70, "FormatNotes",
 CellID->5055]
}, Open  ]],
Cell[CellGroupData[{
Cell[3358, 102, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[3424, 105, 304, 11, 70, "FormatNotes",
 CellID->8922],
Cell[3731, 118, 354, 11, 70, "FormatNotes",
 CellID->6748],
Cell[4088, 131, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[4129, 134, 752, 26, 70, "FormatNotes",
 CellID->10986],
Cell[4884, 162, 493, 18, 70, "FormatNotes",
 CellID->2144],
Cell[5380, 182, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[5503, 187, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[5545, 190, 334, 11, 70, "FormatNotes",
 CellID->26517],
Cell[5882, 203, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[6459, 225, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[7044, 248, 697, 25, 70, "FormatNotes",
 CellID->5874],
Cell[7744, 275, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[7786, 278, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[8313, 300, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[9412, 342, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[10076, 366, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[10895, 396, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[10936, 399, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[11299, 415, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[11688, 434, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[11740, 437, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[11934, 447, 711, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[12648, 463, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[12690, 466, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[12761, 469, 801, 19, 70, "2ColumnTableMod",
 CellID->16955],
Cell[13565, 490, 515, 15, 70, "2ColumnTableMod",
 CellID->23183],
Cell[14083, 507, 404, 16, 70, "FormatNotes",
 CellID->8394],
Cell[14490, 525, 197, 8, 70, "FormatNotes",
 CellID->450361849],
Cell[14690, 535, 634, 13, 70, "2ColumnTableMod",
 CellID->1499224115]
}, Open  ]],
Cell[CellGroupData[{
Cell[15361, 553, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[15413, 556, 54, 1, 70, "FormatNotes",
 CellID->16097],
Cell[15470, 559, 516, 15, 70, "3ColumnTableMod",
 CellID->3065]
}, Closed]],
Cell[CellGroupData[{
Cell[16023, 579, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[16076, 582, 587, 20, 70, "SeeAlso",
 CellID->17282]
}, Open  ]],
Cell[CellGroupData[{
Cell[16700, 607, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[16761, 610, 133, 2, 70, "MoreAbout"],
Cell[16897, 614, 156, 2, 70, "MoreAbout"],
Cell[17056, 618, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17223, 625, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[17339, 631, 60, 1, 70, "ExampleSection",
 CellID->377367688],
Cell[17402, 634, 226, 8, 70, "ExampleText",
 CellID->514176551],
Cell[CellGroupData[{
Cell[17653, 646, 136, 4, 70, "Input",
 CellID->27432],
Cell[17792, 652, 82231, 1352, 70, "Output",
 CellID->313531749]
}, Open  ]],
Cell[100038, 2007, 125, 3, 70, "ExampleDelimiter",
 CellID->291097129],
Cell[100166, 2012, 234, 8, 70, "ExampleText",
 CellID->501699237],
Cell[CellGroupData[{
Cell[100425, 2024, 310, 10, 70, "Input",
 CellID->1038278137],
Cell[100738, 2036, 16879, 281, 70, "Output",
 CellID->1881039231]
}, Open  ]],
Cell[CellGroupData[{
Cell[117654, 2322, 142, 4, 70, "Input",
 CellID->1327976690],
Cell[117799, 2328, 87, 2, 70, "Output",
 CellID->506685559]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[117925, 2335, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

